--TEST--
PHPC-1839: Referenced, out-of-scope, interned string in typeMap (PHP >= 8.1)
--SKIPIF--
<?php require __DIR__ . "/../utils/basic-skipif.inc"; ?>
<?php skip_if_php_version('<', '8.1'); ?>
--FILE--
<?php
require_once __DIR__ . "/../utils/basic.inc";

function createTypemap()
{
    $rootValue = 'array';
    $documentValue = 'array';

    $typemap = ['root' => &$rootValue, 'document' => &$documentValue];

    return $typemap;
}

$typemap = createTypemap();
$bson    = MongoDB\BSON\Document::fromPHP((object) []);

echo "Before:\n";
debug_zval_dump($typemap);

$bson->toPHP($typemap);

echo "After:\n";
debug_zval_dump($typemap);

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
Before:
array(2) refcount(2){
  ["root"]=>
  reference refcount(1) {
    string(5) "array" interned
  }
  ["document"]=>
  reference refcount(1) {
    string(5) "array" interned
  }
}
After:
array(2) refcount(2){
  ["root"]=>
  reference refcount(1) {
    string(5) "array" interned
  }
  ["document"]=>
  reference refcount(1) {
    string(5) "array" interned
  }
}
===DONE===
