<?php
/****************************************************************/
/* ATutor														*/
/****************************************************************/
/* Copyright (c) 2002-2009										*/
/* Inclusive Design Institute                                   */
/* http://atutor.ca												*/
/*                                                              */
/* This program is free software. You can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation.				*/
/****************************************************************/
// $Id$
$_user_location	= 'public';

define('AT_INCLUDE_PATH', '../../../../include/');
require(AT_INCLUDE_PATH.'vitals.inc.php');
require(AT_SOCIAL_INCLUDE.'constants.inc.php');
require(AT_SOCIAL_INCLUDE.'classes/SocialGroups/SocialGroup.class.php');
require(AT_SOCIAL_INCLUDE.'classes/SocialGroups/SocialGroups.class.php');
require(AT_SOCIAL_INCLUDE.'friends.inc.php');

if (isset($_GET['invitation']) || isset($_GET['request'])){
	$id = intval($_GET['id']);
	$sender_id = intval($_GET['sender_id']);
	$status = -1;
	$group_obj = new SocialGroup($id);
	if ($id > 0){
		//handle invitations
		if ($_GET['invitation']=='accept'){

			$sql = "SELECT sender_id from %ssocial_groups_invitations WHERE  member_id = %d AND group_id = %d";
			$sender = queryDB($sql, array(TABLE_PREFIX, $_SESSION[member_id], $id));

			require(AT_INCLUDE_PATH . 'classes/phpmailer/atutormailer.class.php');
			foreach ($sender as $sid){

				$sql_notify = "SELECT first_name, last_name, email FROM %smembers WHERE member_id=%d";
				$row_notify = queryDB($sql_notify, array(TABLE_PREFIX, $sid), TRUE);

				if ($row_notify['email'] != '') {
					$body = _AT('notification_group_invite_accepted', get_display_name($_SESSION['member_id']),$group_obj->getName() , $_base_href.AT_SOCIAL_BASENAME.'index_mystart.php');
					$sender = get_display_name($_SESSION['member_id']);
					$mail = new ATutorMailer;
					$mail->AddAddress($row_notify['email'], $sender);
					$mail->FromName = $_config['site_name'];
					$mail->From     = $_config['contact_email'];
					$mail->Subject  = _AT('group_invitation_accepted');
					$mail->Body     = $body;
		
					if(!$mail->Send()) {
						$msg->addError('SENDING_ERROR');
					}
					unset($mail);
				}
			}

			acceptGroupInvitation($id);
			$status = 1;
		} elseif ($_GET['invitation']=='reject'){
			rejectGroupInvitation($id);
			$status = 2;
		}

		//handle requests (requests to join a group from some member)
		if ($sender_id > 0){
			if ($_GET['request']=='accept'){

			$sql = "SELECT sender_id from %ssocial_groups_requests WHERE  member_id = %d AND group_id = %d";
			$sender = queryDB($sql, array(TABLE_PREFIX, $_SESSION['member_id'], $id));
			
			require(AT_INCLUDE_PATH . 'classes/phpmailer/atutormailer.class.php');
			foreach ($sender as $sid){

				$sql_notify = "SELECT first_name, last_name, email FROM %smembers WHERE member_id=%d";
				$row_notify = queryDB($sql_notify, array(TABLE_PREFIX, $sid), TRUE);
				
				if ($row_notify['email'] != '') {
					$body = _AT('notification_group_request_accepted', $group_obj->getName() , $_base_href.AT_SOCIAL_BASENAME.'index_mystart.php');
					$sender = get_display_name($_SESSION['member_id']);
					$mail = new ATutorMailer;
					$mail->AddAddress($row_notify['email'], $sender);
					$mail->FromName = $_config['site_name'];
					$mail->From     = $_config['contact_email'];
					$mail->Subject  = _AT('group_request_accepted');
					$mail->Body     = $body;
		
					if(!$mail->Send()) {
						$msg->addError('SENDING_ERROR');
					}
					unset($mail);
				}
			}
				acceptGroupRequest($id, $sender_id);
				$status = 3;
			} elseif ($_GET['request']=='reject'){
				rejectGroupRequest($id, $sender_id);
				$status = 4;
			}
		}
	}

	switch($status){
		case 1:
			$msg->addFeedback('ACCEPT_GROUP_INVITATION');
			break;
		case 2:
			$msg->addFeedback('REJECT_GROUP_INVITATION');
			break;
		case 3:
			$msg->addFeedback('ACCEPT_GROUP_REQUEST');
			break;
		case 4:
			$msg->addFeedback('REJECT_GROUP_REQUEST');
			break;
		default:
			break;
	}
	header('Location: '.url_rewrite(AT_SOCIAL_BASENAME.'groups/view.php?id='.$id, AT_PRETTY_URL_HEADER));
	exit;
}

header('Location: '.url_rewrite(AT_SOCIAL_BASENAME.'groups/index.php', AT_PRETTY_URL_HEADER));
exit;
?>