<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php
// ---------------------------
// Select queries
// ---------------------------

class SELECT_SAVEDCART_DATA_BY_EMAIL extends DB_Select
{
    function initQuery($params)
    {
        $tables = Cart :: getTables();
        $pt = $tables['savedcart']['columns'];

        $this -> addSelectField($pt['scid'],"scid");
        $this -> addSelectField($pt['customeremail'],"customeremail");
        $this -> addSelectField($pt['CartContent'], 'CartContent');
        $this -> addSelectField($pt['CartOrders'], 'CartOrders');
        $this -> addSelectField($pt['time'], 'time');
        $this -> WhereValue($pt['customeremail'], DB_EQ, $params['customeremail']);
    }
}

// ---------------------------
// Update queries
// ---------------------------

class UPDATE_SAVEDCART_DATA_EMAIL extends DB_Update
{
    function UPDATE_SAVEDCART_DATA_EMAIL()
    {
		parent :: DB_Update('savedcart');
    }

    function initQuery($params)
    {
        $tables = Cart :: getTables();
        $pt = $tables['savedcart']['columns'];

        $this -> addUpdateValue($pt['CartContent'], $params['CartContent']);
        $this -> addUpdateValue($pt['CartOrders'], $params['CartOrders']);
        $this -> addUpdateValue($pt['time'], $params['time']);
        $this -> WhereValue($pt['customeremail'], DB_EQ,$params['customeremail']);
    }
}

// ---------------------------
// Insert queries
// ---------------------------

class INSERT_SAVEDCART_DATA extends DB_Insert
{
    function INSERT_SAVEDCART_DATA()
    {
		parent :: DB_Insert('savedcart');
    }

    function initQuery($params)
    {
        $tables = Cart :: getTables();
        $pt = $tables['savedcart']['columns'];

        $this -> addInsertValue($params['CartContent'],$pt['CartContent']);

        $this -> addInsertValue($params['CartOrders'],$pt['CartOrders']);

        $this -> addInsertValue($params['customeremail'],$pt['customeremail']);

        $this -> addInsertValue($params['time'],$pt['time']);
    }
}


// ---------------------------
// Delete queries
// ---------------------------

class DELETE_SAVEDCART_DATA extends DB_Delete
{
    function DELETE_SAVEDCART_DATA()
    {
		parent :: DB_Delete('savedcart');
    }

    function initQuery($params)
    {

      $tables = Cart :: getTables();
        $sc = $tables['savedcart']['columns'];

        $this -> WhereField($sc['customeremail'], DB_EQ, "'" . $params['customeremail'] . "'");
    }
}


?>