<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php
/**
 * Action handler on update cache settings.
 *
 * @package Configuration
 * @access  public
 * @author Alexey Florinsky
 */
class UpdateCacheSettings extends AjaxAction
{
//------------------------------------------------
//               PUBLIC DECLARATION
//------------------------------------------------

    /**#@+
     * @access public
     */

    /**
     * Action constructor.
     *
     */
    function UpdateCacheSettings()
    {
    }

    /**
     */
    function onAction()
    {
        global $application;
        $request = $application->getInstance('Request');
		if($request->getValueByKey('restore'))
			$cache = array();
		else
		{
			$cache = array(
				'checkout' => 'RAM',
				'temporary' => 'RAM',
				'persistent' => $request->getValueByKey('persistent'),
				'html' => $request->getValueByKey('html'),
				'hash' => $request->getValueByKey('hash'),
				'database' => $request->getValueByKey('database'),
				'inifiles' => $request->getValueByKey('inifiles'),
				'attr_ids' => $request->getValueByKey('attr_ids'),
				'templatesAZ' => $request->getValueByKey('templatesAZ'),
				'templatesCZ' => $request->getValueByKey('templatesCZ'),
				'modulesAZ' => $request->getValueByKey('modulesAZ'),
				'modulesCZ' => $request->getValueByKey('modulesCZ')
			);
		}

	    $res = modApiFunc('Configuration','writeCacheSettingCode',$cache);

		$request = new Request();
		$request->setView(CURRENT_REQUEST_URL);
		$application->redirect($request);

		if($res===true)
		{
			CCacheFactory::clearAll();
	        modApiFunc('Session','set','ResultMessage','MSG_CACHE_UPDATED');
		}
		else
		{
			modApiFunc('Session','set','ResultCode',$res);
	        modApiFunc('Session','set','ResultMessage','<b class="required">Failed to update cache settings. Please add the below code in avactis-conf/conf.local.php file.</b>');
		}
    }

    /**#@-*/

//------------------------------------------------
//              PRIVATE DECLARATION
//------------------------------------------------

    /**#@+
     * @access private
     */

    /**#@-*/
}

?>