
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `chevereto442`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]albums`
--

CREATE TABLE `[[dbprefix]]albums` (
  `album_id` int unsigned NOT NULL AUTO_INCREMENT,
  `album_name` varchar(100) NOT NULL,
  `album_user_id` int unsigned DEFAULT NULL,
  `album_date` datetime NOT NULL,
  `album_date_gmt` datetime NOT NULL,
  `album_creation_ip` varchar(255) NOT NULL,
  `album_privacy` enum('public','password','private','private_but_link','custom') DEFAULT 'public',
  `album_privacy_extra` text,
  `album_password` text,
  `album_image_count` int unsigned NOT NULL DEFAULT '0',
  `album_description` text,
  `album_likes` int unsigned NOT NULL DEFAULT '0',
  `album_views` int unsigned NOT NULL DEFAULT '0',
  `album_cover_id` int unsigned DEFAULT NULL,
  `album_parent_id` int unsigned DEFAULT NULL,
  `album_cta_enable` tinyint unsigned NOT NULL DEFAULT '0',
  `album_cta` text,
  PRIMARY KEY (`album_id`),
  KEY `album_name` (`album_name`),
  KEY `album_user_id` (`album_user_id`),
  KEY `album_date_gmt` (`album_date_gmt`),
  KEY `album_privacy` (`album_privacy`),
  KEY `album_image_count` (`album_image_count`),
  KEY `album_creation_ip` (`album_creation_ip`),
  KEY `album_likes` (`album_likes`),
  KEY `album_views` (`album_views`),
  KEY `album_parent_id` (`album_parent_id`),
  KEY `album_user_id_parent_id_name` (`album_user_id`,`album_parent_id`,`album_name`),
  FULLTEXT KEY `searchindex` (`album_name`,`album_description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_keys`
--

CREATE TABLE `[[dbprefix]]api_keys` (
  `api_key_id` int unsigned NOT NULL AUTO_INCREMENT,
  `api_key_user_id` int unsigned DEFAULT NULL,
  `api_key_name` varchar(100) DEFAULT NULL,
  `api_key_date_gmt` datetime NOT NULL,
  `api_key_hash` text NOT NULL,
  PRIMARY KEY (`api_key_id`),
  KEY `api_key_user_id` (`api_key_user_id`),
  KEY `api_key_name` (`api_key_name`),
  KEY `api_key_date_gmt` (`api_key_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assets`
--

CREATE TABLE `[[dbprefix]]assets` (
  `asset_id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_key` varchar(255) NOT NULL,
  `asset_checksum` varchar(32) NOT NULL,
  `asset_filename` varchar(255) NOT NULL,
  `asset_file_path` varchar(255) NOT NULL,
  `asset_blob` blob,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `key` (`asset_key`) USING BTREE,
  KEY `filename` (`asset_filename`),
  KEY `file_path` (`asset_file_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` int unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(32) NOT NULL,
  `category_url_key` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `category_description` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `url_key` (`category_url_key`) USING BTREE,
  KEY `category_name` (`category_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]confirmations`
--

CREATE TABLE `[[dbprefix]]confirmations` (
  `confirmation_id` int unsigned NOT NULL AUTO_INCREMENT,
  `confirmation_user_id` int unsigned NOT NULL,
  `confirmation_type` enum('account-activate','account-change-email','account-password-forgot') NOT NULL,
  `confirmation_date` datetime NOT NULL,
  `confirmation_date_gmt` datetime NOT NULL,
  `confirmation_token_hash` varchar(255) NOT NULL,
  `confirmation_status` enum('active','valid','invalid') NOT NULL,
  `confirmation_extra` text,
  PRIMARY KEY (`confirmation_id`),
  KEY `confirmation_user` (`confirmation_user_id`),
  KEY `confirmation_user_type` (`confirmation_user_id`,`confirmation_type`),
  KEY `confirmation_user_type_status_date` (`confirmation_user_id`,`confirmation_type`,`confirmation_status`,`confirmation_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]deletions`
--

CREATE TABLE `[[dbprefix]]deletions` (
  `deleted_id` int unsigned NOT NULL AUTO_INCREMENT,
  `deleted_date_gmt` datetime NOT NULL,
  `deleted_content_id` int unsigned NOT NULL,
  `deleted_content_date_gmt` datetime NOT NULL,
  `deleted_content_user_id` int unsigned DEFAULT NULL,
  `deleted_content_ip` varchar(255) NOT NULL,
  `deleted_content_checksum` varchar(32) DEFAULT NULL,
  `deleted_content_original_filename` varchar(255) DEFAULT NULL,
  `deleted_content_views` int unsigned NOT NULL DEFAULT '0',
  `deleted_content_likes` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`deleted_id`),
  KEY `deleted_content_id` (`deleted_content_id`),
  KEY `deleted_content_user_id` (`deleted_content_user_id`),
  KEY `deleted_content_ip` (`deleted_content_ip`),
  KEY `deleted_content_checksum` (`deleted_content_checksum`),
  KEY `deleted_content_views` (`deleted_content_views`),
  KEY `deleted_content_likes` (`deleted_content_likes`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]follows`
--

CREATE TABLE `[[dbprefix]]follows` (
  `follow_id` int unsigned NOT NULL AUTO_INCREMENT,
  `follow_date` datetime NOT NULL,
  `follow_date_gmt` datetime NOT NULL,
  `follow_user_id` int unsigned NOT NULL,
  `follow_followed_user_id` int unsigned NOT NULL,
  `follow_ip` varchar(255) NOT NULL,
  PRIMARY KEY (`follow_id`),
  KEY `follow_user_id` (`follow_user_id`),
  KEY `follow_followed_user_id` (`follow_followed_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]images`
--

CREATE TABLE `[[dbprefix]]images` (
  `image_id` int unsigned NOT NULL AUTO_INCREMENT,
  `image_name` varchar(255) NOT NULL,
  `image_extension` varchar(255) NOT NULL,
  `image_size` bigint unsigned NOT NULL,
  `image_width` int unsigned NOT NULL,
  `image_height` int unsigned NOT NULL,
  `image_date` datetime NOT NULL,
  `image_date_gmt` datetime NOT NULL,
  `image_title` varchar(100) DEFAULT NULL,
  `image_description` text,
  `image_nsfw` tinyint unsigned NOT NULL DEFAULT '0',
  `image_user_id` int unsigned DEFAULT NULL,
  `image_album_id` int unsigned DEFAULT NULL,
  `image_uploader_ip` varchar(255) NOT NULL,
  `image_storage_mode` enum('datefolder','direct','old','path') NOT NULL DEFAULT 'datefolder',
  `image_path` varchar(4096) DEFAULT NULL,
  `image_storage_id` int unsigned DEFAULT NULL,
  `image_checksum` varchar(32) NOT NULL,
  `image_source_checksum` varchar(32) DEFAULT NULL,
  `image_original_filename` varchar(255) NOT NULL,
  `image_original_exifdata` mediumtext,
  `image_views` int unsigned NOT NULL DEFAULT '0',
  `image_category_id` int unsigned DEFAULT NULL,
  `image_chain` tinyint unsigned NOT NULL,
  `image_thumb_size` int unsigned NOT NULL,
  `image_medium_size` int unsigned NOT NULL DEFAULT '0',
  `image_frame_size` int unsigned NOT NULL DEFAULT '0',
  `image_expiration_date_gmt` datetime DEFAULT NULL,
  `image_likes` int unsigned NOT NULL DEFAULT '0',
  `image_is_animated` tinyint unsigned NOT NULL DEFAULT '0',
  `image_is_approved` tinyint unsigned NOT NULL DEFAULT '1',
  `image_is_360` tinyint unsigned NOT NULL DEFAULT '0',
  `image_duration` int unsigned NOT NULL DEFAULT '0',
  `image_type` tinyint unsigned GENERATED ALWAYS AS ((case when (`image_extension` in (_utf8mb4'pdf',_utf8mb4'doc',_utf8mb4'md')) then 4 when (`image_extension` in (_utf8mb4'mp3',_utf8mb4'm4a',_utf8mb4'wav')) then 3 when (`image_extension` in (_utf8mb4'mp4',_utf8mb4'webm',_utf8mb4'mov')) then 2 when (`image_extension` in (_utf8mb4'avif',_utf8mb4'jpg',_utf8mb4'jpeg',_utf8mb4'gif',_utf8mb4'png',_utf8mb4'webp')) then 1 else 0 end)) STORED,
  `image_delete_hash` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`image_id`),
  KEY `image_name` (`image_name`),
  KEY `image_extension` (`image_extension`),
  KEY `image_size` (`image_size`),
  KEY `image_width` (`image_width`),
  KEY `image_height` (`image_height`),
  KEY `image_date_gmt` (`image_date_gmt`),
  KEY `image_nsfw` (`image_nsfw`),
  KEY `image_user_id` (`image_user_id`),
  KEY `image_album_id` (`image_album_id`),
  KEY `image_uploader_ip` (`image_uploader_ip`),
  KEY `image_storage_mode` (`image_storage_mode`),
  KEY `image_path` (`image_path`(255)),
  KEY `image_storage_id` (`image_storage_id`),
  KEY `image_checksum` (`image_checksum`),
  KEY `image_source_checksum` (`image_source_checksum`),
  KEY `image_views` (`image_views`),
  KEY `image_category_id` (`image_category_id`),
  KEY `image_chain` (`image_chain`),
  KEY `image_expiration_date_gmt` (`image_expiration_date_gmt`),
  KEY `image_likes` (`image_likes`),
  KEY `image_is_animated` (`image_is_animated`),
  KEY `image_is_approved` (`image_is_approved`),
  KEY `image_is_360` (`image_is_360`),
  KEY `image_album_id_image_id` (`image_album_id`,`image_id`),
  KEY `image_duration` (`image_duration`),
  KEY `image_type` (`image_type`),
  KEY `image_uploader_ip_date_gmt_checksum_source_checksum` (`image_uploader_ip`,`image_date_gmt`,`image_checksum`,`image_source_checksum`),
  FULLTEXT KEY `searchindex` (`image_name`,`image_title`,`image_description`,`image_original_filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]importing`
--

CREATE TABLE `[[dbprefix]]importing` (
  `importing_id` int unsigned NOT NULL AUTO_INCREMENT,
  `importing_import_id` int unsigned NOT NULL,
  `importing_path` varchar(4096) NOT NULL,
  `importing_content_type` enum('user','album','image') NOT NULL,
  `importing_content_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`importing_id`),
  UNIQUE KEY `importing_path` (`importing_path`(767))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imports`
--

CREATE TABLE `[[dbprefix]]imports` (
  `import_id` int unsigned NOT NULL AUTO_INCREMENT,
  `import_path` varchar(4096) NOT NULL,
  `import_options` varchar(255) DEFAULT NULL,
  `import_status` enum('queued','working','paused','canceled','completed') NOT NULL,
  `import_users` int unsigned NOT NULL DEFAULT '0',
  `import_images` int unsigned NOT NULL DEFAULT '0',
  `import_albums` int unsigned NOT NULL DEFAULT '0',
  `import_time_created` datetime DEFAULT NULL,
  `import_time_updated` datetime DEFAULT NULL,
  `import_errors` tinyint unsigned NOT NULL DEFAULT '0',
  `import_started` tinyint unsigned NOT NULL DEFAULT '0',
  `import_continuous` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`import_id`),
  KEY `import_path` (`import_path`(767)) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]imports`
--

INSERT INTO `[[dbprefix]]imports` VALUES
(1, '[[softpath]]/importing/no-parse', 'a:1:{s:4:"root";s:5:"plain";}', 'working', 0, 0, 0, '[[regtime]]', '[[regtime]]', 0, 1, 1),
(2, '[[softpath]]/importing/parse-users', 'a:1:{s:4:"root";s:5:"users";}', 'working', 0, 0, 0, '[[regtime]]', '[[regtime]]', 0, 1, 1),
(3, '[[softpath]]/importing/parse-albums', 'a:1:{s:4:"root";s:6:"albums";}', 'working', 0, 0, 0, '[[regtime]]', '[[regtime]]', 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ip_bans`
--

CREATE TABLE `[[dbprefix]]ip_bans` (
  `ip_ban_id` int unsigned NOT NULL AUTO_INCREMENT,
  `ip_ban_date` datetime NOT NULL,
  `ip_ban_date_gmt` datetime NOT NULL,
  `ip_ban_expires` datetime DEFAULT NULL,
  `ip_ban_expires_gmt` datetime DEFAULT NULL,
  `ip_ban_ip` varchar(255) NOT NULL,
  `ip_ban_message` text,
  PRIMARY KEY (`ip_ban_id`),
  UNIQUE KEY `ip_ban_ip` (`ip_ban_ip`) USING BTREE,
  KEY `ip_ban_ip_expires_gmt_id` (`ip_ban_ip`,`ip_ban_expires_gmt`,`ip_ban_id` DESC)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]likes`
--

CREATE TABLE `[[dbprefix]]likes` (
  `like_id` int unsigned NOT NULL AUTO_INCREMENT,
  `like_date` datetime NOT NULL,
  `like_date_gmt` datetime NOT NULL,
  `like_user_id` int unsigned DEFAULT NULL,
  `like_content_type` enum('image','album') DEFAULT NULL,
  `like_content_id` int unsigned NOT NULL,
  `like_content_user_id` int unsigned DEFAULT NULL,
  `like_ip` varchar(255) NOT NULL,
  PRIMARY KEY (`like_id`),
  KEY `like_date_gmt` (`like_date_gmt`),
  KEY `like_user_id` (`like_user_id`),
  KEY `like_content_type` (`like_content_type`),
  KEY `like_content_id` (`like_content_id`),
  KEY `like_content_user_id` (`like_content_user_id`),
  KEY `like_ip` (`like_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locks`
--

CREATE TABLE `[[dbprefix]]locks` (
  `lock_id` int unsigned NOT NULL AUTO_INCREMENT,
  `lock_name` varchar(255) NOT NULL,
  `lock_date_gmt` datetime NOT NULL,
  `lock_expires_gmt` datetime DEFAULT NULL,
  PRIMARY KEY (`lock_id`),
  UNIQUE KEY `lock_name` (`lock_name`) USING BTREE,
  KEY `lock_date_gmt` (`lock_date_gmt`),
  KEY `lock_expires_gmt` (`lock_expires_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logins`
--

CREATE TABLE `[[dbprefix]]logins` (
  `login_id` int unsigned NOT NULL AUTO_INCREMENT,
  `login_user_id` int unsigned NOT NULL,
  `login_type` enum('password','session','cookie','facebook','twitter','google','vk','cookie_facebook','cookie_twitter','cookie_google','cookie_vk') NOT NULL,
  `login_ip` varchar(255) DEFAULT NULL,
  `login_hostname` text,
  `login_date` datetime NOT NULL,
  `login_date_gmt` datetime NOT NULL,
  `login_resource_id` varchar(255) DEFAULT NULL,
  `login_resource_name` text,
  `login_resource_avatar` text,
  `login_resource_url` text,
  `login_secret` text COMMENT 'The secret part',
  `login_token_hash` text COMMENT 'Hashed complement to secret if needed',
  PRIMARY KEY (`login_id`),
  KEY `login_user_id` (`login_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_connections`
--

CREATE TABLE `[[dbprefix]]login_connections` (
  `login_connection_id` int unsigned NOT NULL AUTO_INCREMENT,
  `login_connection_user_id` int unsigned NOT NULL,
  `login_connection_provider_id` int unsigned NOT NULL,
  `login_connection_date_gmt` datetime NOT NULL,
  `login_connection_resource_id` varchar(255) NOT NULL,
  `login_connection_resource_name` text,
  `login_connection_token` text NOT NULL COMMENT 'Ciphertext',
  PRIMARY KEY (`login_connection_id`),
  UNIQUE KEY `login_connection_unique` (`login_connection_user_id`,`login_connection_provider_id`),
  KEY `login_connection_user_id` (`login_connection_user_id`),
  KEY `login_connection_date_gmt` (`login_connection_date_gmt`),
  KEY `login_connection_provider_id` (`login_connection_provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_cookies`
--

CREATE TABLE `[[dbprefix]]login_cookies` (
  `login_cookie_id` int unsigned NOT NULL AUTO_INCREMENT,
  `login_cookie_user_id` int unsigned NOT NULL,
  `login_cookie_connection_id` int unsigned DEFAULT '0',
  `login_cookie_date_gmt` datetime NOT NULL,
  `login_cookie_last_seen_gmt` datetime DEFAULT NULL,
  `login_cookie_ip` varchar(255) DEFAULT NULL,
  `login_cookie_user_agent` text NOT NULL,
  `login_cookie_hash` text NOT NULL,
  PRIMARY KEY (`login_cookie_id`),
  UNIQUE KEY `login_cookie_unique` (`login_cookie_user_id`,`login_cookie_connection_id`,`login_cookie_date_gmt`),
  KEY `login_cookie_user_id_date_gmt` (`login_cookie_user_id`,`login_cookie_date_gmt`),
  KEY `login_cookie_user_id` (`login_cookie_user_id`),
  KEY `login_cookie_ip` (`login_cookie_ip`),
  KEY `login_cookie_connection_id` (`login_cookie_connection_id`),
  KEY `login_cookie_user_id_date_gmt_connection_id` (`login_cookie_user_id`,`login_cookie_date_gmt`,`login_cookie_connection_id`),
  KEY `login_cookie_last_seen_gmt` (`login_cookie_last_seen_gmt` DESC),
  KEY `login_cookie_user_last_seen_gmt` (`login_cookie_user_id`,`login_cookie_last_seen_gmt` DESC)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_passwords`
--

CREATE TABLE `[[dbprefix]]login_passwords` (
  `login_password_id` int unsigned NOT NULL AUTO_INCREMENT,
  `login_password_user_id` int unsigned NOT NULL,
  `login_password_date_gmt` datetime NOT NULL,
  `login_password_hash` text NOT NULL,
  PRIMARY KEY (`login_password_id`),
  UNIQUE KEY `login_password_user_id` (`login_password_user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]login_passwords`
--

INSERT INTO `[[dbprefix]]login_passwords` VALUES
(1, 1, '[[regtime]]', '[[admin_pass]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_providers`
--

CREATE TABLE `[[dbprefix]]login_providers` (
  `login_provider_id` int unsigned NOT NULL AUTO_INCREMENT,
  `login_provider_name` varchar(255) DEFAULT NULL,
  `login_provider_label` varchar(255) DEFAULT NULL,
  `login_provider_key_id` text,
  `login_provider_key_secret` text,
  `login_provider_is_enabled` tinyint unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`login_provider_id`),
  UNIQUE KEY `login_provider_name` (`login_provider_name`),
  KEY `login_provider_is_enabled` (`login_provider_is_enabled`),
  KEY `login_provider_id_is_enabled_name` (`login_provider_id`,`login_provider_is_enabled`,`login_provider_name` DESC)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `[[dbprefix]]login_providers`
--

INSERT INTO `[[dbprefix]]login_providers` VALUES
(1, 'facebook', 'Facebook', NULL, NULL, 0),
(2, 'twitter', 'X', NULL, NULL, 0),
(3, 'google', 'Google', NULL, NULL, 0),
(4, 'vkontakte', 'VK', NULL, NULL, 0),
(5, 'apple', 'Apple', NULL, NULL, 0),
(6, 'amazon', 'Amazon', NULL, NULL, 0),
(7, 'bitbucket', 'BitBucket', NULL, NULL, 0),
(8, 'discord', 'Discord', NULL, NULL, 0),
(9, 'dribbble', 'Dribbble', NULL, NULL, 0),
(10, 'dropbox', 'Dropbox', NULL, NULL, 0),
(11, 'github', 'GitHub', NULL, NULL, 0),
(12, 'gitlab', 'GitLab', NULL, NULL, 0),
(13, 'instagram', 'Instagram', NULL, NULL, 0),
(14, 'linkedin', 'LinkedIn', NULL, NULL, 0),
(15, 'mailru', 'Mailru', NULL, NULL, 0),
(16, 'medium', 'Medium', NULL, NULL, 0),
(17, 'odnoklassniki', 'Odnoklassniki', NULL, NULL, 0),
(18, 'orcid', 'ORCID', NULL, NULL, 0),
(19, 'reddit', 'Reddit', NULL, NULL, 0),
(20, 'spotify', 'Spotify', NULL, NULL, 0),
(21, 'steam', 'Steam', NULL, NULL, 0),
(22, 'strava', 'Strava', NULL, NULL, 0),
(23, 'telegram', 'Telegram', NULL, NULL, 0),
(24, 'tumblr', 'Tumblr', NULL, NULL, 0),
(25, 'twitchtv', 'Twitch', NULL, NULL, 0),
(26, 'wechat', 'WeChat', NULL, NULL, 0),
(27, 'wordpress', 'WordPress', NULL, NULL, 0),
(28, 'yandex', 'Yandex', NULL, NULL, 0),
(29, 'yahoo', 'Yahoo', NULL, NULL, 0),
(30, 'qq', 'QQ', NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `notification_id` int unsigned NOT NULL AUTO_INCREMENT,
  `notification_date_gmt` datetime NOT NULL,
  `notification_user_id` int unsigned NOT NULL,
  `notification_trigger_user_id` int unsigned DEFAULT NULL,
  `notification_type` enum('follow','like') NOT NULL,
  `notification_content_type` enum('user','image','album') NOT NULL,
  `notification_type_id` int unsigned NOT NULL COMMENT 'type_id based on action (type) table',
  `notification_is_read` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`notification_id`),
  KEY `notification_date_gmt` (`notification_date_gmt`),
  KEY `notification_user_id` (`notification_user_id`),
  KEY `notification_trigger_user_id` (`notification_trigger_user_id`),
  KEY `notification_type` (`notification_type`),
  KEY `notification_content_type` (`notification_content_type`),
  KEY `notification_type_id` (`notification_type_id`),
  KEY `notification_is_read` (`notification_is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `page_id` int unsigned NOT NULL AUTO_INCREMENT,
  `page_url_key` varchar(32) DEFAULT NULL,
  `page_type` enum('internal','link') NOT NULL DEFAULT 'internal',
  `page_file_path` varchar(255) DEFAULT NULL,
  `page_link_url` text,
  `page_icon` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `page_description` text,
  `page_keywords` text,
  `page_is_active` tinyint unsigned NOT NULL DEFAULT '1',
  `page_is_link_visible` tinyint unsigned NOT NULL DEFAULT '1',
  `page_attr_target` enum('_self','_blank') DEFAULT '_self',
  `page_attr_rel` varchar(255) DEFAULT NULL,
  `page_sort_display` int unsigned DEFAULT NULL,
  `page_internal` varchar(255) DEFAULT NULL,
  `page_code` text,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_internal` (`page_internal`),
  KEY `page_url_key` (`page_url_key`),
  KEY `page_type` (`page_type`),
  KEY `page_is_active` (`page_is_active`),
  KEY `page_is_link_visible` (`page_is_link_visible`),
  KEY `page_sort_display` (`page_sort_display`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, 'tos', 'internal', NULL, NULL, 'fas fa-landmark', 'Terms of service', NULL, NULL, 1, 1, '_self', NULL, 1, 'tos', NULL),
(2, 'privacy', 'internal', NULL, NULL, 'fas fa-lock', 'Privacy', NULL, NULL, 1, 1, '_self', NULL, 2, 'privacy', NULL),
(3, 'contact', 'internal', NULL, NULL, 'fas fa-at', 'Contact', NULL, NULL, 1, 1, '_self', NULL, 3, 'contact', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queues`
--

CREATE TABLE `[[dbprefix]]queues` (
  `queue_id` int unsigned NOT NULL AUTO_INCREMENT,
  `queue_type` enum('storage-delete') NOT NULL,
  `queue_date_gmt` datetime NOT NULL,
  `queue_args` text NOT NULL,
  `queue_join` int unsigned NOT NULL,
  `queue_attempts` varchar(255) DEFAULT '0',
  `queue_status` enum('pending','failed') NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`queue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]requests`
--

CREATE TABLE `[[dbprefix]]requests` (
  `request_id` int unsigned NOT NULL AUTO_INCREMENT,
  `request_type` enum('upload','signup','account-edit','account-password-forgot','account-password-reset','account-resend-activation','account-email-needed','account-change-email','account-activate','login','content-password','account-two-factor') NOT NULL,
  `request_user_id` int unsigned DEFAULT NULL,
  `request_content_id` int unsigned DEFAULT NULL,
  `request_ip` varchar(255) NOT NULL,
  `request_date` datetime NOT NULL,
  `request_date_gmt` datetime NOT NULL,
  `request_result` enum('success','fail') NOT NULL,
  PRIMARY KEY (`request_id`),
  KEY `request_type` (`request_type`),
  KEY `request_user_id` (`request_user_id`),
  KEY `request_content_id` (`request_content_id`),
  KEY `request_ip` (`request_ip`),
  KEY `request_date_gmt` (`request_date_gmt`),
  KEY `request_result` (`request_result`),
  KEY `request_result_ip_type_date_gmt` (`request_result`,`request_type`,`request_ip`,`request_date_gmt`),
  KEY `request_user_id_result_type_ip` (`request_user_id`,`request_result`,`request_type`,`request_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `setting_id` int unsigned NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `setting_value` text,
  `setting_default` text,
  `setting_typeset` enum('string','bool') DEFAULT 'string',
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `setting_name` (`setting_name`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=248 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 'analytics_code', '', '', 'string'),
(2, 'auto_language', '1', '1', 'bool'),
(3, 'comment_code', '', '', 'string'),
(4, 'default_language', 'en', 'en', 'string'),
(5, 'default_timezone', 'America/Santiago', 'America/Santiago', 'string'),
(6, 'email_from_email', 'from@chevereto.internal', 'from@chevereto.internal', 'string'),
(7, 'email_from_name', 'Chevereto', 'Chevereto', 'string'),
(8, 'email_incoming_email', 'incoming@chevereto.internal', 'incoming@chevereto.internal', 'string'),
(9, 'email_mode', 'mail', 'mail', 'string'),
(10, 'email_smtp_server', '', '', 'string'),
(11, 'email_smtp_server_password', '', '', 'string'),
(12, 'email_smtp_server_port', '', '', 'string'),
(13, 'email_smtp_server_security', '', '', 'string'),
(14, 'email_smtp_server_username', '', '', 'string'),
(15, 'enable_uploads', '1', '1', 'bool'),
(16, 'flood_uploads_day', '1000', '1000', 'string'),
(17, 'flood_uploads_hour', '500', '500', 'string'),
(18, 'flood_uploads_minute', '50', '50', 'string'),
(19, 'flood_uploads_month', '10000', '10000', 'string'),
(20, 'flood_uploads_notify', '0', '0', 'bool'),
(21, 'flood_uploads_protection', '1', '1', 'bool'),
(22, 'flood_uploads_week', '5000', '5000', 'string'),
(23, 'guest_uploads', '1', '1', 'bool'),
(24, 'listing_items_per_page', '24', '24', 'string'),
(25, 'maintenance', '0', '0', 'bool'),
(26, 'captcha', '0', '0', 'bool'),
(27, 'captcha_secret', '', '', 'string'),
(28, 'captcha_sitekey', '', '', 'string'),
(29, 'captcha_threshold', '5', '5', 'string'),
(30, 'theme', 'Peafowl', 'Peafowl', 'string'),
(31, 'upload_filenaming', 'original', 'original', 'string'),
(32, 'upload_image_path', 'images', 'images', 'string'),
(33, 'upload_medium_size', '500', '500', 'string'),
(34, 'upload_storage_mode', 'datefolder', 'datefolder', 'string'),
(35, 'upload_thumb_height', '320', '320', 'string'),
(36, 'upload_thumb_width', '320', '320', 'string'),
(37, 'website_description', 'A free image hosting service powered by Chevereto', 'A free image hosting service powered by Chevereto', 'string'),
(38, 'website_doctitle', 'Chevereto image hosting', 'Chevereto image hosting', 'string'),
(39, 'website_name', 'Chevereto', 'Chevereto', 'string'),
(40, 'website_explore_page', '1', '1', 'bool'),
(41, 'enable_signups', '1', '1', 'bool'),
(42, 'favicon_image', 'default/favicon.png', 'default/favicon.png', 'string'),
(43, 'logo_image', 'default/logo.png', 'default/logo.png', 'string'),
(44, 'logo_vector', 'default/logo.svg', 'default/logo.svg', 'string'),
(45, 'theme_custom_css_code', '', '', 'string'),
(46, 'theme_custom_js_code', '', '', 'string'),
(47, 'website_keywords', 'image sharing, image hosting, chevereto', 'image sharing, image hosting, chevereto', 'string'),
(48, 'watermark_enable', '0', '0', 'bool'),
(49, 'watermark_image', 'default/watermark.png', 'default/watermark.png', 'string'),
(50, 'watermark_position', 'center center', 'center center', 'string'),
(51, 'watermark_margin', '10', '10', 'string'),
(52, 'watermark_opacity', '50', '50', 'string'),
(53, 'banner_home_after_cover', '', '', 'string'),
(54, 'banner_home_after_listing', '', '', 'string'),
(55, 'banner_image_image-viewer_foot', '', '', 'string'),
(56, 'banner_image_image-viewer_top', '', '', 'string'),
(57, 'banner_image_after_image-viewer', '', '', 'string'),
(58, 'banner_image_after_header', '', '', 'string'),
(59, 'banner_image_before_header', '', '', 'string'),
(60, 'banner_image_footer', '', '', 'string'),
(61, 'banner_content_tab-about_column', '', '', 'string'),
(62, 'banner_content_before_comments', '', '', 'string'),
(63, 'banner_explore_after_top', '', '', 'string'),
(64, 'banner_user_after_top', '', '', 'string'),
(65, 'banner_user_before_listing', '', '', 'string'),
(66, 'banner_album_before_header', '', '', 'string'),
(67, 'banner_album_after_header', '', '', 'string'),
(68, 'api_v1_key', '[[api_v1_key]]', '[[api_v1_key]]', 'string'),
(69, 'listing_pagination_mode', 'classic', 'classic', 'string'),
(70, 'banner_listing_before_pagination', '', '', 'string'),
(71, 'banner_listing_after_pagination', '', '', 'string'),
(72, 'show_nsfw_in_listings', '0', '0', 'bool'),
(73, 'show_banners_in_nsfw', '0', '0', 'bool'),
(74, 'website_privacy_mode', 'public', 'public', 'string'),
(75, 'website_content_privacy_mode', 'default', 'default', 'string'),
(76, 'show_nsfw_in_random_mode', '0', '0', 'bool'),
(77, 'cdn', '0', '0', 'bool'),
(78, 'cdn_url', '', '', 'string'),
(79, 'website_search', '1', '1', 'bool'),
(80, 'website_random', '1', '1', 'bool'),
(81, 'theme_logo_height', '', '', 'string'),
(82, 'theme_show_social_share', '1', '1', 'bool'),
(83, 'theme_show_embed_uploader', '1', '1', 'bool'),
(84, 'require_user_email_confirmation', '1', '1', 'bool'),
(85, 'require_user_email_social_signup', '1', '1', 'bool'),
(86, 'theme_download_button', '1', '1', 'bool'),
(87, 'theme_nsfw_upload_checkbox', '1', '1', 'bool'),
(88, 'theme_image_listing_sizing', 'fixed', 'fixed', 'string'),
(89, 'listing_columns_phone', '2', '2', 'string'),
(90, 'listing_columns_phablet', '3', '3', 'string'),
(91, 'listing_columns_tablet', '4', '4', 'string'),
(92, 'listing_columns_laptop', '5', '5', 'string'),
(93, 'listing_columns_desktop', '6', '6', 'string'),
(94, 'homepage_style', 'landing', 'landing', 'string'),
(95, 'homepage_cover_image', 'default/home_cover.jpg', 'default/home_cover.jpg', 'string'),
(96, 'homepage_uids', '', '', 'string'),
(97, 'homepage_endless_mode', '0', '0', 'bool'),
(98, 'user_image_avatar_max_filesize_mb', '1', '1', 'string'),
(99, 'user_image_background_max_filesize_mb', '2', '2', 'string'),
(100, 'theme_image_right_click', '0', '0', 'bool'),
(101, 'theme_show_exif_data', '1', '1', 'bool'),
(102, 'logo_image_homepage', 'default/logo_homepage.png', 'default/logo_homepage.png', 'string'),
(103, 'logo_vector_homepage', 'default/logo_homepage.svg', 'default/logo_homepage.svg', 'string'),
(104, 'homepage_cta_color', 'accent', 'accent', 'string'),
(105, 'homepage_cta_outline', '0', '0', 'bool'),
(106, 'watermark_enable_guest', '1', '1', 'bool'),
(107, 'watermark_enable_user', '1', '1', 'bool'),
(108, 'watermark_enable_admin', '1', '1', 'bool'),
(109, 'homepage_title_html', '', '', 'string'),
(110, 'homepage_paragraph_html', '', '', 'string'),
(111, 'homepage_cta_html', '', '', 'string'),
(112, 'homepage_cta_fn', '', '', 'string'),
(113, 'homepage_cta_fn_extra', '', '', 'string'),
(114, 'language_chooser_enable', '1', '1', 'bool'),
(115, 'languages_disable', '', '', 'string'),
(116, 'website_mode', 'community', 'community', 'string'),
(117, 'website_mode_personal_routing', '', '', 'string'),
(118, 'website_mode_personal_uid', '', '', 'string'),
(119, 'enable_cookie_law', '0', '0', 'bool'),
(120, 'theme_nsfw_blur', '0', '0', 'bool'),
(121, 'watermark_target_min_width', '100', '100', 'string'),
(122, 'watermark_target_min_height', '100', '100', 'string'),
(123, 'watermark_percentage', '4', '4', 'string'),
(124, 'watermark_enable_file_gif', '0', '0', 'bool'),
(125, 'upload_image_exif', '1', '1', 'bool'),
(126, 'upload_image_exif_user_setting', '1', '1', 'bool'),
(127, 'enable_expirable_uploads', '1', '1', 'bool'),
(128, 'banner_home_after_cover_nsfw', '', '', 'string'),
(129, 'banner_home_after_listing_nsfw', '', '', 'string'),
(130, 'banner_image_image-viewer_foot_nsfw', '', '', 'string'),
(131, 'banner_image_image-viewer_top_nsfw', '', '', 'string'),
(132, 'banner_image_after_image-viewer_nsfw', '', '', 'string'),
(133, 'banner_image_after_header_nsfw', '', '', 'string'),
(134, 'banner_image_before_header_nsfw', '', '', 'string'),
(135, 'banner_image_footer_nsfw', '', '', 'string'),
(136, 'banner_content_tab-about_column_nsfw', '', '', 'string'),
(137, 'banner_content_before_comments_nsfw', '', '', 'string'),
(138, 'banner_explore_after_top_nsfw', '', '', 'string'),
(139, 'banner_user_after_top_nsfw', '', '', 'string'),
(140, 'banner_user_before_listing_nsfw', '', '', 'string'),
(141, 'banner_album_before_header_nsfw', '', '', 'string'),
(142, 'banner_album_after_header_nsfw', '', '', 'string'),
(143, 'banner_listing_before_pagination_nsfw', '', '', 'string'),
(144, 'banner_listing_after_pagination_nsfw', '', '', 'string'),
(145, 'upload_medium_fixed_dimension', 'width', 'width', 'string'),
(146, 'enable_followers', '1', '1', 'bool'),
(147, 'enable_likes', '1', '1', 'bool'),
(148, 'enable_consent_screen', '0', '0', 'bool'),
(149, 'user_minimum_age', '', '', 'string'),
(150, 'consent_screen_cover_image', 'default/consent-screen_cover.jpg', 'default/consent-screen_cover.jpg', 'string'),
(151, 'enable_redirect_single_upload', '0', '0', 'bool'),
(152, 'route_image', 'image', 'image', 'string'),
(153, 'route_album', 'album', 'album', 'string'),
(154, 'enable_duplicate_uploads', '0', '0', 'bool'),
(155, 'update_check_display_notification', '1', '1', 'bool'),
(156, 'banner_home_before_title', '', '', 'string'),
(157, 'banner_home_after_cta', '', '', 'string'),
(158, 'banner_home_before_title_nsfw', '', '', 'string'),
(159, 'banner_home_after_cta_nsfw', '', '', 'string'),
(160, 'upload_threads', '2', '2', 'string'),
(161, 'enable_automatic_updates_check', '1', '1', 'bool'),
(162, 'comments_api', 'js', 'js', 'string'),
(163, 'disqus_shortname', '', '', 'string'),
(164, 'disqus_public_key', '', '', 'string'),
(165, 'disqus_secret_key', '', '', 'string'),
(166, 'upload_max_image_width', '0', '0', 'string'),
(167, 'upload_max_image_height', '0', '0', 'string'),
(168, 'auto_delete_guest_uploads', '', '', 'string'),
(169, 'enable_user_content_delete', '1', '1', 'bool'),
(170, 'enable_plugin_route', '1', '1', 'bool'),
(171, 'sdk_pup_url', '', '', 'string'),
(172, 'website_explore_page_guest', '1', '1', 'bool'),
(173, 'explore_albums_min_image_count', '1', '1', 'string'),
(174, 'notify_user_signups', '0', '0', 'bool'),
(175, 'seo_image_urls', '1', '1', 'bool'),
(176, 'seo_album_urls', '1', '1', 'bool'),
(177, 'upload_gui', 'page', 'page', 'string'),
(178, 'captcha_api', 'hcaptcha', 'hcaptcha', 'string'),
(179, 'force_captcha_contact_page', '1', '1', 'bool'),
(180, 'dump_update_query', '0', '0', 'bool'),
(181, 'enable_powered_by', '1', '1', 'bool'),
(182, 'akismet', '0', '0', 'bool'),
(183, 'akismet_api_key', '', '', 'string'),
(184, 'stopforumspam', '0', '0', 'bool'),
(185, 'theme_show_embed_content_for', 'all', 'all', 'string'),
(186, 'moderatecontent', '0', '0', 'bool'),
(187, 'moderatecontent_key', '', '', 'string'),
(188, 'moderatecontent_block_rating', 'a', 'a', 'string'),
(189, 'moderatecontent_flag_nsfw', 'a', 'a', 'string'),
(190, 'moderatecontent_auto_approve', '0', '0', 'bool'),
(191, 'moderate_uploads', '', '', 'string'),
(192, 'image_lock_nsfw_editing', '0', '0', 'bool'),
(193, 'enable_uploads_url', '0', '0', 'bool'),
(194, 'logo_type', 'vector', 'vector', 'string'),
(195, 'route_user', 'user', 'user', 'string'),
(196, 'root_route', 'user', 'user', 'string'),
(197, 'arachnid', '0', '0', 'bool'),
(198, 'image_first_tab', 'about', 'about', 'string'),
(199, 'website_random_guest', '1', '1', 'bool'),
(200, 'website_search_guest', '1', '1', 'bool'),
(201, 'debug_errors', '0', '0', 'bool'),
(202, 'stop_words', 'richard blank\ncosta rica[\\\\\\''s]*? call center\ncall center sales', 'richard blank\ncosta rica[\\\\\\''s]*? call center\ncall center sales', 'string'),
(203, 'semantics_album', '', '', 'string'),
(204, 'semantics_albums', '', '', 'string'),
(205, 'semantics_image', '', '', 'string'),
(206, 'semantics_images', '', '', 'string'),
(207, 'semantics_user', '', '', 'string'),
(208, 'semantics_users', '', '', 'string'),
(209, 'semantics_explore', '', '', 'string'),
(210, 'semantics_discovery', '', '', 'string'),
(211, 'semantics_category', '', '', 'string'),
(212, 'semantics_categories', '', '', 'string'),
(213, 'listing_viewer', '0', '0', 'bool'),
(214, 'twitter_account', '', '', 'string'),
(215, 'theme_font', '0', '0', 'string'),
(216, 'user_profile_view', 'files', 'files', 'string'),
(217, 'upload_enabled_image_formats', 'jpg,png,bmp,gif,webp,mov,mp4,webm', 'avif,jpg,png,bmp,gif,webp,mov,mp4,webm', 'string'),
(218, 'theme_palette', '10', '10', 'string'),
(219, 'asset_storage_api_id', '8', '8', 'string'),
(220, 'asset_storage_url', '/images/_assets/', '/images/_assets/', 'string'),
(221, 'asset_storage_account_id', '', '', 'string'),
(222, 'asset_storage_account_name', '', '', 'string'),
(223, 'asset_storage_bucket', '[[softpath]]/images/_assets/', '', 'string'),
(224, 'asset_storage_key', '', '', 'string'),
(225, 'asset_storage_region', '', '', 'string'),
(226, 'asset_storage_secret', '', '', 'string'),
(227, 'asset_storage_server', '', '', 'string'),
(228, 'asset_storage_service', '', '', 'string'),
(229, 'asset_storage_use_path_style_endpoint', '0', '0', 'bool'),
(230, 'guest_albums', '0', '0', 'bool'),
(231, 'route_video', 'video', 'video', 'string'),
(232, 'route_audio', 'audio', 'audio', 'string'),
(233, 'cache_ttl', '0', '0', 'string'),
(234, 'image_load_max_filesize_mb', '5', '5', 'string'),
(235, 'upload_max_filesize_mb_guest', '10', '10', 'string'),
(236, 'arachnid_api_username', '', '', 'string'),
(237, 'arachnid_api_password', '', '', 'string'),
(238, 'semantics_video', '', '', 'string'),
(239, 'semantics_videos', '', '', 'string'),
(240, 'semantics_tag', '', '', 'string'),
(241, 'semantics_tags', '', '', 'string'),
(242, 'semantics_file', '', '', 'string'),
(243, 'semantics_files', '', '', 'string'),
(244, 'theme_palette_user_select', '1', '1', 'bool'),
(245, 'upload_max_filesize_mb', '100', '100', 'string'),
(246, 'enable_api_user', '1', '1', 'bool'),
(247, 'enable_api_guest', '0', '0', 'bool');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats`
--

CREATE TABLE `[[dbprefix]]stats` (
  `stat_id` int unsigned NOT NULL AUTO_INCREMENT,
  `stat_type` enum('total','date') NOT NULL,
  `stat_date_gmt` date DEFAULT NULL,
  `stat_users` int unsigned NOT NULL DEFAULT '0',
  `stat_images` int unsigned NOT NULL DEFAULT '0',
  `stat_albums` int unsigned NOT NULL DEFAULT '0',
  `stat_tags` int unsigned NOT NULL DEFAULT '0',
  `stat_cron_runs` int unsigned NOT NULL DEFAULT '0',
  `stat_cron_time` int unsigned NOT NULL DEFAULT '0',
  `stat_image_views` bigint unsigned NOT NULL DEFAULT '0',
  `stat_album_views` bigint unsigned NOT NULL DEFAULT '0',
  `stat_image_likes` int unsigned NOT NULL DEFAULT '0',
  `stat_album_likes` int unsigned NOT NULL DEFAULT '0',
  `stat_disk_used` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`stat_id`),
  UNIQUE KEY `stat_date_gmt` (`stat_date_gmt`) USING BTREE,
  KEY `stat_type` (`stat_type`),
  KEY `stat_type_date_gmt` (`stat_type`,`stat_date_gmt` DESC)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb3 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]stats`
--

INSERT INTO `[[dbprefix]]stats` VALUES
(1, 'total', NULL, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(2, 'date', '[[date]]', 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]storages`
--

CREATE TABLE `[[dbprefix]]storages` (
  `storage_id` int unsigned NOT NULL AUTO_INCREMENT,
  `storage_api_id` int unsigned NOT NULL,
  `storage_name` varchar(255) NOT NULL,
  `storage_service` varchar(255) DEFAULT NULL,
  `storage_url` varchar(255) NOT NULL,
  `storage_bucket` varchar(255) DEFAULT NULL,
  `storage_region` varchar(255) DEFAULT NULL,
  `storage_server` varchar(255) DEFAULT NULL,
  `storage_account_id` varchar(255) DEFAULT NULL,
  `storage_account_name` varchar(255) DEFAULT NULL,
  `storage_key` text,
  `storage_secret` text,
  `storage_is_https` tinyint unsigned NOT NULL DEFAULT '0',
  `storage_is_active` tinyint unsigned NOT NULL DEFAULT '0',
  `storage_capacity` bigint unsigned DEFAULT NULL,
  `storage_space_used` bigint unsigned DEFAULT '0',
  `storage_type_chain` tinyint unsigned NOT NULL DEFAULT '1',
  `storage_use_path_style_endpoint` tinyint unsigned NOT NULL DEFAULT '0',
  `storage_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`storage_id`),
  KEY `storage_api_id` (`storage_api_id`),
  KEY `storage_is_active` (`storage_is_active`),
  KEY `storage_deleted_at` (`storage_deleted_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]storage_apis`
--

CREATE TABLE `[[dbprefix]]storage_apis` (
  `storage_api_id` int unsigned NOT NULL AUTO_INCREMENT,
  `storage_api_name` varchar(255) NOT NULL,
  `storage_api_type` varchar(255) NOT NULL,
  PRIMARY KEY (`storage_api_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb3 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]storage_apis`
--

INSERT INTO `[[dbprefix]]storage_apis` VALUES
(1, 'Amazon S3', 's3'),
(2, 'Google Cloud', 'gcloud'),
(3, 'Microsoft Azure', 'azure'),
(4, 'Chevereto Grid', 'chvgrid'),
(5, 'FTP', 'ftp'),
(6, 'SFTP', 'sftp'),
(7, 'OpenStack', 'openstack'),
(8, 'Local', 'local'),
(9, 'S3 compatible', 's3compatible'),
(10, 'Alibaba Cloud OSS', 'oss'),
(11, 'Backblaze B2', 'b2');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `tag_id` int unsigned NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `tag_description` text,
  `tag_user_id` int unsigned NOT NULL,
  `tag_date_gmt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tag_files` int unsigned NOT NULL DEFAULT '0',
  `tag_views` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `tag_name` (`tag_name`) USING BTREE,
  KEY `tag_user_id` (`tag_user_id`),
  KEY `tag_date_gmt` (`tag_date_gmt`),
  KEY `tag_files` (`tag_files`),
  KEY `tag_views` (`tag_views`),
  KEY `tag_user_id_date_gmt` (`tag_user_id`,`tag_date_gmt`),
  KEY `tag_user_id_files` (`tag_user_id`,`tag_files`),
  KEY `tag_user_id_views` (`tag_user_id`,`tag_views`),
  KEY `tag_files_name` (`tag_files` DESC,`tag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags_albums`
--

CREATE TABLE `[[dbprefix]]tags_albums` (
  `tag_album_tag_id` int unsigned NOT NULL,
  `tag_album_album_id` int unsigned NOT NULL,
  `tag_album_user_id` int unsigned NOT NULL,
  `tag_album_count` int unsigned NOT NULL DEFAULT '0',
  `tag_album_last_used_datetime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY `tag_album_UNIQUE` (`tag_album_tag_id`,`tag_album_album_id`,`tag_album_user_id`),
  KEY `tag_album_album_id` (`tag_album_album_id`),
  KEY `tag_album_user_id` (`tag_album_user_id`),
  KEY `tag_album_count` (`tag_album_count`),
  KEY `tag_album_last_used_datetime` (`tag_album_last_used_datetime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags_files`
--

CREATE TABLE `[[dbprefix]]tags_files` (
  `tag_file_tag_id` int unsigned NOT NULL,
  `tag_file_file_id` int unsigned NOT NULL,
  UNIQUE KEY `tag_file_UNIQUE` (`tag_file_tag_id`,`tag_file_file_id`),
  KEY `tag_file_file_id` (`tag_file_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags_users`
--

CREATE TABLE `[[dbprefix]]tags_users` (
  `tag_user_tag_id` int unsigned NOT NULL,
  `tag_user_user_id` int unsigned NOT NULL,
  `tag_user_count` int unsigned NOT NULL DEFAULT '0',
  `tag_user_last_used_datetime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY `tag_user_UNIQUE` (`tag_user_tag_id`,`tag_user_user_id`),
  KEY `tag_user_user_id` (`tag_user_user_id`),
  KEY `tag_user_count` (`tag_user_count`),
  KEY `tag_user_last_used_datetime` (`tag_user_last_used_datetime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]two_factors`
--

CREATE TABLE `[[dbprefix]]two_factors` (
  `two_factor_id` int unsigned NOT NULL AUTO_INCREMENT,
  `two_factor_user_id` int unsigned DEFAULT NULL,
  `two_factor_date_gmt` datetime NOT NULL,
  `two_factor_secret` text NOT NULL,
  PRIMARY KEY (`two_factor_id`),
  KEY `two_factor_user_id` (`two_factor_user_id`),
  KEY `two_factor_date_gmt` (`two_factor_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]uploads`
--

CREATE TABLE `[[dbprefix]]uploads` (
  `upload_id` int unsigned NOT NULL AUTO_INCREMENT,
  `upload_user_id` int unsigned DEFAULT NULL,
  `upload_uploader_ip` varchar(255) NOT NULL,
  `upload_token` varchar(64) NOT NULL,
  `upload_checksum` varchar(32) NOT NULL,
  `upload_params` json NOT NULL,
  `upload_chunks` int unsigned NOT NULL,
  `upload_date_gmt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `upload_completed` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`upload_id`),
  KEY `upload_id_token` (`upload_id`,`upload_token`),
  KEY `upload_id_token_user_id` (`upload_id`,`upload_token`,`upload_user_id`),
  KEY `upload_date_gmt` (`upload_date_gmt`),
  KEY `upload_checksum_uploader_ip_date_gmt` (`upload_checksum`,`upload_uploader_ip`,`upload_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]uploads_chunks`
--

CREATE TABLE `[[dbprefix]]uploads_chunks` (
  `upload_chunk_upload_id` int unsigned NOT NULL,
  `upload_chunk_index` int unsigned NOT NULL,
  `upload_chunk_path` varchar(4096) DEFAULT NULL,
  `upload_chunk_date_gmt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`upload_chunk_upload_id`,`upload_chunk_index`),
  KEY `upload_chunk_date_gmt` (`upload_chunk_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) DEFAULT NULL,
  `user_username` varchar(255) NOT NULL,
  `user_date` datetime NOT NULL,
  `user_date_gmt` datetime NOT NULL,
  `user_email` varchar(255) DEFAULT NULL,
  `user_avatar_filename` varchar(255) DEFAULT NULL,
  `user_facebook_username` varchar(255) DEFAULT NULL,
  `user_twitter_username` varchar(255) DEFAULT NULL,
  `user_website` varchar(255) DEFAULT NULL,
  `user_background_filename` varchar(255) DEFAULT NULL,
  `user_bio` varchar(255) DEFAULT NULL,
  `user_timezone` varchar(255) NOT NULL,
  `user_language` varchar(255) DEFAULT NULL,
  `user_status` enum('valid','awaiting-confirmation','awaiting-email','banned') NOT NULL,
  `user_is_admin` tinyint unsigned NOT NULL DEFAULT '0',
  `user_is_manager` tinyint unsigned NOT NULL DEFAULT '0',
  `user_is_private` tinyint unsigned NOT NULL DEFAULT '0',
  `user_palette_id` int unsigned NOT NULL DEFAULT '0',
  `user_newsletter_subscribe` tinyint unsigned NOT NULL DEFAULT '1',
  `user_show_nsfw_listings` tinyint unsigned NOT NULL DEFAULT '0',
  `user_image_count` int unsigned NOT NULL DEFAULT '0',
  `user_album_count` int unsigned NOT NULL DEFAULT '0',
  `user_image_keep_exif` tinyint unsigned NOT NULL DEFAULT '1',
  `user_file_meta_tag_camera_model` tinyint unsigned NOT NULL DEFAULT '1',
  `user_image_expiration` varchar(255) DEFAULT NULL,
  `user_registration_ip` varchar(255) NOT NULL,
  `user_likes` int unsigned NOT NULL DEFAULT '0' COMMENT 'Likes made to content owned by this user',
  `user_liked` int unsigned NOT NULL DEFAULT '0' COMMENT 'Likes made by this user',
  `user_following` int unsigned NOT NULL DEFAULT '0',
  `user_followers` int unsigned NOT NULL DEFAULT '0',
  `user_content_views` int unsigned NOT NULL DEFAULT '0',
  `user_notifications_unread` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`user_username`) USING BTREE,
  UNIQUE KEY `email` (`user_email`) USING BTREE,
  KEY `user_date_gmt` (`user_date_gmt`),
  KEY `user_status` (`user_status`),
  KEY `user_is_admin` (`user_is_admin`),
  KEY `user_is_manager` (`user_is_manager`),
  KEY `user_is_private` (`user_is_private`),
  KEY `user_palette_id` (`user_palette_id`),
  KEY `user_newsletter_subscribe` (`user_newsletter_subscribe`),
  KEY `user_show_nsfw_listings` (`user_show_nsfw_listings`),
  KEY `user_image_count` (`user_image_count`),
  KEY `user_album_count` (`user_album_count`),
  KEY `user_image_keep_exif` (`user_image_keep_exif`),
  KEY `user_file_meta_tag_camera_model` (`user_file_meta_tag_camera_model`),
  KEY `user_image_expiration` (`user_image_expiration`),
  KEY `user_registration_ip` (`user_registration_ip`),
  KEY `user_likes` (`user_likes`),
  KEY `user_following` (`user_following`),
  KEY `user_followers` (`user_followers`),
  KEY `user_liked` (`user_liked`),
  KEY `user_content_views` (`user_content_views`),
  FULLTEXT KEY `searchindex` (`user_name`,`user_username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, NULL, '[[admin_username]]', '[[regtime]]', '[[regtime]]', '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, NULL, 'America/Santiago', 'en', 'valid', 1, 0, 0, 10, 1, 0, 0, 0, 1, 1, NULL, '[[clientip]]', 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]variables`
--

CREATE TABLE `[[dbprefix]]variables` (
  `variable_id` int unsigned NOT NULL AUTO_INCREMENT,
  `variable_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `variable_datetime_utc` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `variable_value` text,
  `variable_type` enum('string','bool','int','float','array','object') DEFAULT 'string',
  PRIMARY KEY (`variable_id`),
  UNIQUE KEY `variable_name` (`variable_name`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]variables`
--

INSERT INTO `[[dbprefix]]variables` VALUES
(1, 'id_padding', '[[regtime]]', '999', 'int'),
(2, 'crypt_salt', '[[regtime]]', '[[crypt_salt]]', 'string'),
(3, 'chevereto_version_installed', '[[regtime]]', '4.4.2', 'string'),
(4, 'last_used_storage', '[[regtime]]', '0', 'int'),
(5, 'update_check_datetimegmt', '[[regtime]]', '0000-00-00 00:00:00', 'string'),
(6, 'update_check_notified_release', '[[regtime]]', '4.4.2', 'string'),
(7, 'chevereto_news', '[[regtime]]', 'a:0:{}', 'array'),
(8, 'cron_last_ran', '[[regtime]]', '0000-00-00 00:00:00', 'string'),
(9, 'news_check_datetimegmt', '[[regtime]]', '0000-00-00 00:00:00', 'string'),
(10, 'storages_all', '[[regtime]]', '0', 'int'),
(11, 'storages_active', '[[regtime]]', '0', 'int'),
(12, 'login_providers_active', '[[regtime]]', '0', 'int'),
(13, 'hmac_secret_token', '[[regtime]]', '[[hmac_secret_token]]', 'string'),
(14, 'hmac_secret_upload', '[[regtime]]', '[[hmac_secret_upload]]', 'string'),
(15, 'hmac_secret_api_key', '[[regtime]]', '[[hmac_secret_api_key]]', 'string');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]tags_albums`
--
ALTER TABLE `[[dbprefix]]tags_albums`
  ADD CONSTRAINT `[[dbprefix]]tags_albums_ibfk_1` FOREIGN KEY (`tag_album_tag_id`) REFERENCES `[[dbprefix]]tags` (`tag_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tags_albums_ibfk_2` FOREIGN KEY (`tag_album_album_id`) REFERENCES `[[dbprefix]]albums` (`album_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tags_albums_ibfk_3` FOREIGN KEY (`tag_album_user_id`) REFERENCES `[[dbprefix]]users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]tags_files`
--
ALTER TABLE `[[dbprefix]]tags_files`
  ADD CONSTRAINT `[[dbprefix]]tags_files_ibfk_1` FOREIGN KEY (`tag_file_tag_id`) REFERENCES `[[dbprefix]]tags` (`tag_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tags_files_ibfk_2` FOREIGN KEY (`tag_file_file_id`) REFERENCES `[[dbprefix]]images` (`image_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]tags_users`
--
ALTER TABLE `[[dbprefix]]tags_users`
  ADD CONSTRAINT `[[dbprefix]]tags_users_ibfk_1` FOREIGN KEY (`tag_user_tag_id`) REFERENCES `[[dbprefix]]tags` (`tag_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tags_users_ibfk_2` FOREIGN KEY (`tag_user_user_id`) REFERENCES `[[dbprefix]]users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]uploads_chunks`
--
ALTER TABLE `[[dbprefix]]uploads_chunks`
  ADD CONSTRAINT `[[dbprefix]]uploads_chunks_ibfk_1` FOREIGN KEY (`upload_chunk_upload_id`) REFERENCES `[[dbprefix]]uploads` (`upload_id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
