
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `dada11220`
--

-- --------------------------------------------------------

--
-- Table structure for table `dada_archives`
--

CREATE TABLE `dada_archives` (
  `list` varchar(16) COLLATE utf8mb3_bin DEFAULT NULL,
  `archive_id` varchar(32) COLLATE utf8mb3_bin DEFAULT NULL,
  `subject` text COLLATE utf8mb3_bin,
  `message` mediumtext COLLATE utf8mb3_bin,
  `format` text COLLATE utf8mb3_bin,
  `raw_msg` mediumtext COLLATE utf8mb3_bin,
  KEY `dada_archives_list_archive_id_index` (`list`,`archive_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin;

-- --------------------------------------------------------

--
-- Table structure for table `dada_bounce_scores`
--

CREATE TABLE `dada_bounce_scores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` text COLLATE utf8mb4_general_ci,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `score` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_clickthrough_urls`
--

CREATE TABLE `dada_clickthrough_urls` (
  `url_id` int NOT NULL AUTO_INCREMENT,
  `redirect_id` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `msg_id` text COLLATE utf8mb4_general_ci,
  `url` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`url_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_clickthrough_url_log`
--

CREATE TABLE `dada_clickthrough_url_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `remote_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `msg_id` text COLLATE utf8mb4_general_ci,
  `url` text COLLATE utf8mb4_general_ci,
  `email` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_confirmation_tokens`
--

CREATE TABLE `dada_confirmation_tokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `dada_confirmation_tokens_index` (`id`,`timestamp`,`token`(80),`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_consents`
--

CREATE TABLE `dada_consents` (
  `consent_id` int NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consent` mediumtext COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`consent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_consent_activity`
--

CREATE TABLE `dada_consent_activity` (
  `consent_activity_id` int NOT NULL AUTO_INCREMENT,
  `remote_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `email` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `action` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `source` varchar(225) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `source_location` varchar(225) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `list_type` varchar(64) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consent_session_token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `consent_id` int DEFAULT NULL,
  `privacy_policy_id` int DEFAULT NULL,
  PRIMARY KEY (`consent_activity_id`),
  KEY `consent_id` (`consent_id`),
  KEY `privacy_policy_id` (`privacy_policy_id`),
  KEY `dada_consent_activity_index` (`email`,`list`,`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_email_message_previews`
--

CREATE TABLE `dada_email_message_previews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `vars` text COLLATE utf8mb4_general_ci,
  `plaintext` mediumtext COLLATE utf8mb4_general_ci,
  `html` mediumtext COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_mass_mailing_event_log`
--

CREATE TABLE `dada_mass_mailing_event_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `remote_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `msg_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `event` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `details` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dada_mass_mailing_event_log_index` (`list`,`remote_addr`(80),`msg_id`(80),`event`(80),`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_message_drafts`
--

CREATE TABLE `dada_message_drafts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `name` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `screen` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `role` varchar(80) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `draft` mediumtext COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_password_protect_directories`
--

CREATE TABLE `dada_password_protect_directories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` text COLLATE utf8mb4_general_ci,
  `url` text COLLATE utf8mb4_general_ci,
  `path` text COLLATE utf8mb4_general_ci,
  `use_custom_error_page` char(1) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `custom_error_page` text COLLATE utf8mb4_general_ci,
  `default_password` text COLLATE utf8mb4_general_ci,
  `always_use_default_password` char(1) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_privacy_policies`
--

CREATE TABLE `dada_privacy_policies` (
  `privacy_policy_id` int NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `list` varchar(16) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `privacy_policy` mediumtext COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`privacy_policy_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `dada_privacy_policies`
--

INSERT INTO `dada_privacy_policies` VALUES
(1, '[[regtime]]', '[[site_name]]', '[[policy_desc]]');

-- --------------------------------------------------------

--
-- Table structure for table `dada_profiles`
--

CREATE TABLE `dada_profiles` (
  `profile_id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(80) COLLATE utf8mb3_bin NOT NULL,
  `password` tinytext COLLATE utf8mb3_bin,
  `auth_code` varchar(64) COLLATE utf8mb3_bin DEFAULT NULL,
  `update_email_auth_code` varchar(64) COLLATE utf8mb3_bin DEFAULT NULL,
  `update_email` varchar(80) COLLATE utf8mb3_bin DEFAULT NULL,
  `activated` char(1) COLLATE utf8mb3_bin DEFAULT NULL,
  PRIMARY KEY (`profile_id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_profile_fields`
--

CREATE TABLE `dada_profile_fields` (
  `fields_id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(80) COLLATE utf8mb3_bin NOT NULL,
  PRIMARY KEY (`fields_id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_profile_fields_attributes`
--

CREATE TABLE `dada_profile_fields_attributes` (
  `attribute_id` int NOT NULL AUTO_INCREMENT,
  `field` varchar(80) COLLATE utf8mb3_bin DEFAULT NULL,
  `label` varchar(80) COLLATE utf8mb3_bin DEFAULT NULL,
  `fallback_value` text COLLATE utf8mb3_bin,
  `required` char(1) COLLATE utf8mb3_bin NOT NULL DEFAULT '0',
  PRIMARY KEY (`attribute_id`),
  UNIQUE KEY `field` (`field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_profile_settings`
--

CREATE TABLE `dada_profile_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(80) COLLATE utf8mb3_bin DEFAULT NULL,
  `list` varchar(16) COLLATE utf8mb3_bin DEFAULT NULL,
  `setting` varchar(64) COLLATE utf8mb3_bin DEFAULT NULL,
  `value` text COLLATE utf8mb3_bin,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_rate_limit_hits`
--

CREATE TABLE `dada_rate_limit_hits` (
  `user_id` varchar(225) COLLATE utf8mb4_general_ci NOT NULL,
  `action` varchar(225) COLLATE utf8mb4_general_ci NOT NULL,
  `timestamp` int unsigned NOT NULL,
  KEY `dada_rate_limit_hits_all_index` (`user_id`,`action`(80),`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `dada_sessions`
--

CREATE TABLE `dada_sessions` (
  `id` char(32) COLLATE utf8mb4_general_ci NOT NULL,
  `a_session` text COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `dada_settings`
--

CREATE TABLE `dada_settings` (
  `list` varchar(16) COLLATE utf8mb3_bin DEFAULT NULL,
  `setting` varchar(64) COLLATE utf8mb3_bin DEFAULT NULL,
  `value` text COLLATE utf8mb3_bin,
  KEY `dada_settings_list_index` (`list`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin;

--
-- Dumping data for table `dada_settings`
--

INSERT INTO `dada_settings` VALUES
('[[site_name]]', 'list_owner_email', '[[admin_email]]'),
('[[site_name]]', 'privacy_policy', '[[policy_desc]]'),
('[[site_name]]', 'list', '[[site_name]]'),
('[[site_name]]', 'info', '[[mail_desc]]'),
('[[site_name]]', 'list_name', '[[site_desc]]'),
('[[site_name]]', 'password', '[[list_pass]]'),
('[[site_name]]', 'physical_address', '[[physical_desc]]'),
('[[site_name]]', 'admin_menu', 'NAV-Mass Mailing=1;SUBNAV-drafts=1;SUBNAV-send_email=1;SUBNAV-sending_monitor=1;SUBNAV-mass_mailing_options=1;NAV-Mailing List=1;SUBNAV-change_info=1;SUBNAV-change_password=1;SUBNAV-manage_privacy_policy=0;SUBNAV-manage_list_consent=0;SUBNAV-list_options=1;SUBNAV-web_services=1;SUBNAV-delete_list=0;NAV-Membership=1;SUBNAV-view_list=1;SUBNAV-list_activity=1;SUBNAV-add=1;SUBNAV-delete_email=1;SUBNAV-subscription_options=0;NAV-Sending=1;SUBNAV-mail_sending_options=1;SUBNAV-mail_sending_advanced_options=1;SUBNAV-mailing_sending_mass_mailing_options=1;NAV-Archives=1;SUBNAV-view_archive=1;SUBNAV-archive_options=1;SUBNAV-adv_archive_options=1;NAV-Appearance=1;SUBNAV-edit_template=1;SUBNAV-email_themes=1;SUBNAV-edit_type=1;SUBNAV-edit_html_type=1;SUBNAV-html_code=1;SUBNAV-back_link=1;NAV-Profiles=1;SUBNAV-profile_fields=1;NAV-Plugins/Extensions =1;SUBNAV-tracker=1;SUBNAV-bridge=1;SUBNAV-change_root_password=0;SUBNAV-change_list_shortname=0;SUBNAV-log_viewer=1;SUBNAV-screen_cache=0;SUBNAV-global_config=0;SUBNAV-multiple_subscribe=1;SUBNAV-blog_index=1;NAV-<i class="fi-widget"></i> Control Panel Settings=0;SUBNAV-feature_set=0;SUBNAV-scheduled_jobs=1;SUBNAV-setup_info=1;SUBNAV-manage_script=1;'),
('[[site_name]]', 'cipher_key', '[[cipher_key]]'),
('[[site_name]]', 'schedule_last_checked_time', '[[timestamp]]'),
('[[site_name]]', 'scheduled_jobs_last_ran', '[[timestamp]]');

-- --------------------------------------------------------

--
-- Table structure for table `dada_simple_auth_str`
--

CREATE TABLE `dada_simple_auth_str` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `remote_addr` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `auth_str` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UAS` (`auth_str`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dada_subscribers`
--

CREATE TABLE `dada_subscribers` (
  `email_id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(80) COLLATE utf8mb3_bin DEFAULT NULL,
  `list` varchar(16) COLLATE utf8mb3_bin DEFAULT NULL,
  `list_type` varchar(64) COLLATE utf8mb3_bin DEFAULT NULL,
  `list_status` char(1) COLLATE utf8mb3_bin DEFAULT NULL,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`email_id`),
  KEY `_all_index` (`email`,`list`,`list_type`,`list_status`,`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `dada_consent_activity`
--
ALTER TABLE `dada_consent_activity`
  ADD CONSTRAINT `dada_consent_activity_ibfk_1` FOREIGN KEY (`consent_id`) REFERENCES `dada_consents` (`consent_id`),
  ADD CONSTRAINT `dada_consent_activity_ibfk_2` FOREIGN KEY (`privacy_policy_id`) REFERENCES `dada_privacy_policies` (`privacy_policy_id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
