<?php
session_start();
include '../assets/constant/config.php';

try {
  $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo "Connection failed: " . $e->getMessage();
}
?>


<?php include('include/sidebar.php'); ?>
<!-- Top Bar End -->
<?php include('include/header.php'); ?>
<div class="page-content-wrapper ">

  <div class="container-fluid">

    <div class="row">
      <div class="col-sm-12">
        <div class="page-title-box">
          <div class="btn-group float-right">

          </div>
          <h4 class="page-title">Edit Category</h4>
        </div>
      </div>
      <div class="clearfix"></div>
    </div>
    <!-- end page title end breadcrumb -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">



            <div class="tab-content">

              <div class="tab-pane active p-3" id="home" role="tabpanel">
                <form name="myform" action="app/category_crud.php" class="row" method="POST" enctype="multipart/form-data" id="edit_service">

                  <?php
                  $stmt = $conn->prepare("SELECT * FROM `category` WHERE id=? ");
                  $stmt->execute([$_POST['id']]);
                  $record = $stmt->fetchAll();

                  foreach ($record as $key) { ?>

                    <input class="form-control" type="hidden" name="id" value="<?php echo $key['id']; ?>">

               

                    <div class="form-group col-md-6">
                      <label class="control-label">Title</label>
                      <input class="form-control" type="text" name="heading" value="<?php echo $key['heading'] ?>" required="" />
                    </div>

                  <!--      <div class="form-group col-md-6">
                      <label class="control-label">Existing Photo</label><br>
                      <//?php
                                                // Read the image file and encode it to Base64
                                                $imagePath = "../assets/images/" . $key['photo']; // Path to your image file
                                                $imageData = file_get_contents($imagePath);
                                                $base64Image = base64_encode($imageData);
                                                ?>
                      <input type="hidden" value="<//?php echo $key['photo'] ?>" name="old_photo_img">
                      <img class="img-fluid" src="data:image/jpeg;base64,<//?php echo $base64Image; ?>" style="width:100px;height:auto;"><br>
                    </div>

                    <div class="form-group col-md-6">
                      <label class="control-label">Change Photo</label>
                      <input class="form-control" type="file" name="photo">


                    </div> -->

                

                    <div class="form-group col-md-12">

                      <button class="btn btn-primary" type="submit" name="update" onclick="editService()">Update</button>

                    </div>
                  <?php } ?>
                </form>
              </div>

            </div>

          </div>
        </div><!--end card-->
      </div><!--end col-->
    </div><!--end row-->
  </div> <!-- Page content Wrapper -->
</div> <!-- content -->

<?php include('include/footer.php'); ?>

<script type="text/javascript">
  function editService() {
    jQuery.validator.addMethod("alphanumeric", function(value, element) {
      return this.optional(element) || /^(?=.*[a-zA-Z])[a-zA-Z0-9\s!@#$%^&*()_-]+$/.test(value);
    }, "Please enter alphabet characters only");

    jQuery.validator.addMethod("lettersonly", function(value, element) {
      // Check if the value is empty
      if (value.trim() === "") {
        return false;
      }
      return /^[a-zA-Z\s]*$/.test(value);
    }, "Please enter alphabet characters only");
    $('#edit_service').validate({
      rules: {
        heading: {
          required: true
        },
        slug: {
          required: true
        },
        shortcontent: {
          required: true
        },
        content: {
          required: true
        },
        metatitle: {
          required: true
        },
        metadescription: {
          required: true
        },
        keywords: {
          required: true
        },
        robots: {
          required: true
        },
      },
      messages: {
        heading: {
          required: "Please enter a title",
          pattern: "Only alphanumeric characters and spaces are allowed"
        },
        slug: {
          required: "Please enter a slug",
        },
        shortcontent: {
          required: "Please enter a short content",
          pattern: "Only alphanumeric characters and spaces are allowed"
        },
        content: {
          required: "Please enter a content",
          pattern: "Only alphanumeric characters and spaces are allowed"
        },
        metatitle: {
          required: "Please enter a metatitle",
        },
        metadescription: {
          required: "Please enter a metadescription",
        },
        c
      }
    });
  };
</script>