
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `epesi191`
--

-- --------------------------------------------------------

--
-- Table structure for table `apps_shoutbox_messages`
--

CREATE TABLE `apps_shoutbox_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `base_user_login_id` int(11) NOT NULL,
  `to_user_login_id` int(11) DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `posted_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `base_user_login_id` (`base_user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `available_modules`
--

CREATE TABLE `available_modules` (
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `vkey` int(11) NOT NULL,
  `version` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`,`vkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `available_modules`
--

INSERT INTO `available_modules` VALUES
('Applets_Birthdays', 0, '1.0'),
('Applets_Calc', 0, '1.1'),
('Applets_Clock', 0, '1.0'),
('Applets_Google', 0, '1.4'),
('Applets_Host', 0, '1.0'),
('Applets_MonthView', 0, '1.0'),
('Applets_Note', 0, '1.1'),
('Applets_RssFeed', 0, '1.0'),
('Applets_Weather', 0, '0.3'),
('Apps_ActivityReport', 0, '1.0'),
('Apps_Shoutbox', 0, '1.0'),
('Base', 0, '1.0'),
('Base_About', 0, '1.0'),
('Base_Acl', 0, '1.0.0'),
('Base_ActionBar', 0, '1.0'),
('Base_Admin', 0, '1.0.0'),
('Base_Box', 0, '1.0.0'),
('Base_Cron', 0, '1.0'),
('Base_Dashboard', 0, '1.0'),
('Base_EpesiStore', 0, '1.0'),
('Base_Error', 0, '1.0.0'),
('Base_EssClient', 0, '1.0'),
('Base_Help', 0, '1.0.0'),
('Base_HomePage', 0, '1.0'),
('Base_Lang', 0, '1.0.0'),
('Base_Lang_Administrator', 0, '1.0.0'),
('Base_Mail', 0, '1.0.0'),
('Base_Mail_ContactUs', 0, '1.0'),
('Base_MainModuleIndicator', 0, '1.0.0'),
('Base_Menu', 0, '1.0.0'),
('Base_Menu_QuickAccess', 0, '1.0.0'),
('Base_Notify', 0, '2.0'),
('Base_Print', 0, '1.5.0'),
('Base_RegionalSettings', 0, '1.0'),
('Base_Search', 0, '0.9.1'),
('Base_Setup', 0, '1.0.0'),
('Base_StatusBar', 0, '1.0.0'),
('Base_Theme', 0, '1.0.0'),
('Base_Theme_Administrator', 0, '1.0'),
('Base_User', 0, '1.0'),
('Base_User_Administrator', 0, '1.0.0'),
('Base_User_Login', 0, '1.0.0'),
('Base_User_Settings', 0, '1.0'),
('CRM_Calendar', 0, '0.1.0'),
('CRM_Calendar_Event', 0, '1.0'),
('CRM_Common', 0, '0.9'),
('CRM_Contacts', 0, '0.9'),
('CRM_Contacts_AccountManager', 0, '1.0'),
('CRM_Contacts_Activities', 0, '1.0'),
('CRM_Contacts_County', 0, '1.0'),
('CRM_Contacts_NotesAggregate', 0, '1.0'),
('CRM_Contacts_ParentCompany', 0, '1.0'),
('CRM_Contacts_Photo', 0, '1.0'),
('CRM_Fax', 0, '0.5'),
('CRM_Filters', 0, '1.0'),
('CRM_Followup', 0, '1.0'),
('CRM_LoginAudit', 0, '1.0'),
('CRM_Mail', 0, '0.1'),
('CRM_Meeting', 0, '1.0'),
('CRM_PhoneCall', 0, '1.0'),
('CRM_Roundcube', 0, '0.1'),
('CRM_Tasks', 0, '1.0'),
('CRM_WhoIsOnline', 0, '1.0'),
('Data_Countries', 0, '2008'),
('Data_TaxRates', 0, '1.0'),
('FirstRun', 0, '1.0'),
('Libs_CKEditor', 0, '3.5.2'),
('Libs_Codepress', 0, '0.9.6'),
('Libs_Leightbox', 0, '2.03.3'),
('Libs_OpenFlashChart', 0, '1.0'),
('Libs_PHPExcel', 0, '1.7.0'),
('Libs_QuickForm', 0, '3.2.10'),
('Libs_ScriptAculoUs', 0, '1.8.0'),
('Libs_TCPDF', 0, '3.1.001'),
('Tests', 0, '1.0'),
('Tests_Attachment', 0, '0'),
('Tests_Bugtrack', 0, '0.1'),
('Tests_Calendar', 0, '0.1'),
('Tests_Calendar_Event', 0, '0.1'),
('Tests_Callbacks', 0, '1.0.0'),
('Tests_Callbacks_a', 0, '0'),
('Tests_Codepress', 0, '0.1'),
('Tests_Colorpicker', 0, '0.1'),
('Tests_Comment', 0, '0'),
('Tests_GenericBrowser', 0, '0'),
('Tests_Image', 0, '0'),
('Tests_Lang', 0, '0'),
('Tests_Leightbox', 0, '0'),
('Tests_Menu', 0, '0'),
('Tests_OpenFlashChart', 0, '0.1'),
('Tests_QuickForm', 0, '0'),
('Tests_RecordBrowser', 0, '0'),
('Tests_Report', 0, '0.1'),
('Tests_Search', 0, '0'),
('Tests_SharedUniqueHref', 0, '0'),
('Tests_SharedUniqueHref_a', 0, '0'),
('Tests_TabbedBrowser', 0, '0'),
('Tests_Tooltip', 0, '1.0'),
('Tests_Tooltip', 1, '1.5'),
('Tests_Wizard', 0, '0'),
('Tools_SessionKeeper', 0, '0.9'),
('Tools_SetDefaults', 0, '1.0'),
('Tools_WhoIsOnline', 0, '1.0'),
('Utils_Attachment', 0, '1.0'),
('Utils_BBCode', 0, '1.0'),
('Utils_Calendar', 0, '1.0'),
('Utils_Calendar_Event', 0, '1.0.0'),
('Utils_CalendarBusyReport', 0, '0.1'),
('Utils_CalendarBusyReport_Event', 0, '1.0.0'),
('Utils_CatFile', 0, '1.0.0'),
('Utils_ChainedSelect', 0, '1.0'),
('Utils_Comment', 0, '1.0.0'),
('Utils_CommonData', 0, '0'),
('Utils_CurrencyField', 0, '0'),
('Utils_CustomMenu', 0, '1.0.0'),
('Utils_ExportXLS', 0, '1.0'),
('Utils_FileDownload', 0, '1.0'),
('Utils_FileStorage', 0, '0.1'),
('Utils_FileUpload', 0, '1.0'),
('Utils_FrontPage', 0, '1.0.0'),
('Utils_GenericBrowser', 0, '1.0'),
('Utils_Image', 0, '0.8.9'),
('Utils_LeightboxPrompt', 0, '1.0'),
('Utils_Menu', 0, '1.0.0'),
('Utils_Messenger', 0, '0.1'),
('Utils_Path', 0, '1.0'),
('Utils_Planner', 0, '1.0'),
('Utils_PopupCalendar', 0, '0'),
('Utils_QueryBuilder', 0, '1.0.0'),
('Utils_RecordBrowser', 0, '2.0'),
('Utils_RecordBrowser_CustomRecordsets', 0, '1.0'),
('Utils_RecordBrowser_Filters', 0, '0.1'),
('Utils_RecordBrowser_RecordPicker', 0, '0.1'),
('Utils_RecordBrowser_RecordPickerFS', 0, '0.1'),
('Utils_RecordBrowser_Reports', 0, '1.0'),
('Utils_Shortcut', 0, '1.0.0'),
('Utils_TabbedBrowser', 0, '1.0'),
('Utils_Tooltip', 0, '1.0.0'),
('Utils_Tray', 0, '2.0'),
('Utils_Tree', 0, '1.0'),
('Utils_Watchdog', 0, '1.0'),
('Utils_Wizard', 0, '1.0.0');

-- --------------------------------------------------------

--
-- Table structure for table `base_acl_clearance`
--

CREATE TABLE `base_acl_clearance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `callback` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `base_acl_clearance`
--

INSERT INTO `base_acl_clearance` VALUES
(1, 'Base_AclCommon::basic_clearance'),
(2, 'CRM_ContactsCommon::crm_clearance');

-- --------------------------------------------------------

--
-- Table structure for table `base_acl_permission`
--

CREATE TABLE `base_acl_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `base_acl_permission`
--

INSERT INTO `base_acl_permission` VALUES
(1, 'Advanced User Settings'),
(2, 'Dashboard'),
(3, 'Dashboard - manage applets'),
(4, 'Search'),
(5, 'Watchdog - subscribe to categories'),
(6, 'Attachments - view full download history'),
(7, 'Manage Perspective'),
(8, 'Messenger Alerts'),
(9, 'Calendar'),
(10, 'View Activity Report'),
(11, 'Shoutbox'),
(12, 'Shoutbox Admin');

-- --------------------------------------------------------

--
-- Table structure for table `base_acl_rules`
--

CREATE TABLE `base_acl_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `permission_id` (`permission_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `base_acl_rules`
--

INSERT INTO `base_acl_rules` VALUES
(1, 1),
(2, 2),
(3, 3),
(4, 4),
(5, 5),
(6, 6),
(7, 7),
(8, 8),
(9, 9),
(10, 10),
(11, 11),
(12, 12);

-- --------------------------------------------------------

--
-- Table structure for table `base_acl_rules_clearance`
--

CREATE TABLE `base_acl_rules_clearance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `base_acl_rules_clearance`
--

INSERT INTO `base_acl_rules_clearance` VALUES
(1, 1, 'ACCESS:employee'),
(2, 2, 'ACCESS:employee'),
(3, 3, 'ACCESS:employee'),
(4, 4, 'ACCESS:employee'),
(5, 5, 'ACCESS:employee'),
(6, 5, 'ACCESS:manager'),
(7, 6, 'ACCESS:employee'),
(8, 7, 'ACCESS:employee'),
(9, 8, 'ACCESS:employee'),
(10, 9, 'ACCESS:employee'),
(11, 10, 'ACCESS:employee'),
(12, 10, 'ACCESS:manager'),
(13, 11, 'ACCESS:employee'),
(14, 12, 'SUPERADMIN');

-- --------------------------------------------------------

--
-- Table structure for table `base_admin_access`
--

CREATE TABLE `base_admin_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `section` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `allow` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `base_dashboard_applets`
--

CREATE TABLE `base_dashboard_applets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_login_id` int(11) DEFAULT NULL,
  `module_name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `col` smallint(6) DEFAULT '0',
  `pos` smallint(6) DEFAULT '0',
  `color` smallint(6) DEFAULT '0',
  `tab` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_login_id` (`user_login_id`),
  KEY `tab` (`tab`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `base_dashboard_applets`
--

INSERT INTO `base_dashboard_applets` VALUES
(1, 1, 'Applets_Clock', 2, 0, 1, 1),
(2, 1, 'CRM_Tasks', 1, 0, 6, 1),
(3, 1, 'Applets_Note', 2, 0, 10, 1),
(4, 1, 'Utils_Watchdog', 0, 0, 6, 1),
(5, 1, 'CRM_PhoneCall', 1, 0, 8, 1),
(6, 1, 'Apps_Shoutbox', 0, 0, 0, 1),
(7, 1, 'CRM_Calendar', 1, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `base_dashboard_default_applets`
--

CREATE TABLE `base_dashboard_default_applets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `col` smallint(6) DEFAULT '0',
  `pos` smallint(6) DEFAULT '0',
  `color` smallint(6) DEFAULT '0',
  `tab` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tab` (`tab`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `base_dashboard_default_applets`
--

INSERT INTO `base_dashboard_default_applets` VALUES
(1, 'Applets_Clock', 2, 0, 1, 1),
(2, 'CRM_Tasks', 1, 0, 6, 1),
(3, 'CRM_PhoneCall', 1, 1, 8, 1),
(4, 'Applets_Note', 2, 0, 10, 1),
(5, 'CRM_Calendar', 1, 2, 0, 1),
(6, 'Apps_Shoutbox', 0, 1, 0, 1),
(7, 'Utils_Watchdog', 0, 0, 6, 1);

-- --------------------------------------------------------

--
-- Table structure for table `base_dashboard_default_settings`
--

CREATE TABLE `base_dashboard_default_settings` (
  `applet_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`applet_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `base_dashboard_default_settings`
--

INSERT INTO `base_dashboard_default_settings` VALUES
(4, 'bcolor', 'nice-yellow'),
(4, 'text', '<div><strong>Congratulations!</strong><br />You''ve just installed EPESI!</div><div>For more information, help and support please visit <a href="http://epe.si" target="_blank">EPESI website </a></div>'),
(4, 'title', 'Welcome');

-- --------------------------------------------------------

--
-- Table structure for table `base_dashboard_default_tabs`
--

CREATE TABLE `base_dashboard_default_tabs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `pos` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `base_dashboard_default_tabs`
--

INSERT INTO `base_dashboard_default_tabs` VALUES
(1, 'Default', 0);

-- --------------------------------------------------------

--
-- Table structure for table `base_dashboard_settings`
--

CREATE TABLE `base_dashboard_settings` (
  `applet_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`applet_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `base_dashboard_settings`
--

INSERT INTO `base_dashboard_settings` VALUES
(3, 'bcolor', 'nice-yellow'),
(3, 'text', '<div><strong>Congratulations!</strong><br />You''ve just installed EPESI!</div><div>For more information, help and support please visit <a href="http://epe.si" target="_blank">EPESI website </a></div>'),
(3, 'title', 'Welcome');

-- --------------------------------------------------------

--
-- Table structure for table `base_dashboard_tabs`
--

CREATE TABLE `base_dashboard_tabs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_login_id` int(11) DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `pos` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_login_id` (`user_login_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `base_dashboard_tabs`
--

INSERT INTO `base_dashboard_tabs` VALUES
(1, 1, 'Default', 0);

-- --------------------------------------------------------

--
-- Table structure for table `base_home_page`
--

CREATE TABLE `base_home_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `priority` int(11) DEFAULT NULL,
  `home_page` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `base_home_page`
--

INSERT INTO `base_home_page` VALUES
(1, 1, 'Dashboard'),
(2, 2, 'My Contact');

-- --------------------------------------------------------

--
-- Table structure for table `base_home_page_clearance`
--

CREATE TABLE `base_home_page_clearance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `home_page_id` int(11) DEFAULT NULL,
  `clearance` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `home_page_id` (`home_page_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `base_home_page_clearance`
--

INSERT INTO `base_home_page_clearance` VALUES
(1, 1, 'ACCESS:employee');

-- --------------------------------------------------------

--
-- Table structure for table `base_lang_trans_contrib`
--

CREATE TABLE `base_lang_trans_contrib` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `allow` tinyint(4) DEFAULT NULL,
  `first_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `credits` tinyint(4) DEFAULT NULL,
  `credits_website` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `base_login_audit`
--

CREATE TABLE `base_login_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_login_id` int(11) DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `ip_address` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `base_login_audit`
--

INSERT INTO `base_login_audit` VALUES
(1, 1, '[[regtime]]', '[[regtime]]', '[[clientip]]', '[[host_name]]');

-- --------------------------------------------------------

--
-- Table structure for table `base_notify`
--

CREATE TABLE `base_notify` (
  `token` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `cache` text COLLATE utf8_unicode_ci,
  `last_refresh` bigint(20) DEFAULT NULL,
  `single_cache_uid` int(11) DEFAULT NULL,
  `telegram` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`token`),
  KEY `single_cache_uid` (`single_cache_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `base_notify`
--

INSERT INTO `base_notify` VALUES
('[[token]]', 'eJxLtDKwqq4FAAZPAf4=', [[timestamp]], 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `base_user_settings`
--

CREATE TABLE `base_user_settings` (
  `user_login_id` int(11) NOT NULL,
  `module` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `variable` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`user_login_id`,`module`,`variable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `base_user_settings_admin_defaults`
--

CREATE TABLE `base_user_settings_admin_defaults` (
  `module` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `variable` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`module`,`variable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `base_user_settings_admin_defaults`
--

INSERT INTO `base_user_settings_admin_defaults` VALUES
('Base_Menu_QuickAccess', '465e51c2b6eba36161f0115442e7406c_d', 's:1:"1";'),
('Base_Menu_QuickAccess', '465e51c2b6eba36161f0115442e7406c_l', 's:1:"1";'),
('Base_Menu_QuickAccess', '4fe4700ae455ac705d9d5efa1292298b_d', 's:1:"1";'),
('Base_Menu_QuickAccess', '4fe4700ae455ac705d9d5efa1292298b_l', 's:1:"1";'),
('Base_Menu_QuickAccess', '7b3558122283d2a14051c96a7da1fb1b_d', 's:1:"1";'),
('Base_Menu_QuickAccess', '7b3558122283d2a14051c96a7da1fb1b_l', 's:1:"1";'),
('Base_Menu_QuickAccess', 'b34db58caa3e6a8b933deca655640047_d', 's:1:"1";'),
('Base_Menu_QuickAccess', 'b34db58caa3e6a8b933deca655640047_l', 's:1:"1";'),
('Base_RegionalSettings', 'time', 's:11:"%I:%M:%S %p";'),
('Base_RegionalSettings', 'tz', 's:16:"America/New_York";'),
('Utils_RecordBrowser', 'company_auto_fav', 's:1:"1";'),
('Utils_RecordBrowser', 'company_auto_subs', 's:1:"1";'),
('Utils_RecordBrowser', 'contact_auto_fav', 's:1:"1";'),
('Utils_RecordBrowser', 'contact_auto_subs', 's:1:"1";');

-- --------------------------------------------------------

--
-- Table structure for table `company_access`
--

CREATE TABLE `company_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `company_access`
--

INSERT INTO `company_access` VALUES
(3, 'print', 'a:0:{}'),
(4, 'export', 'a:0:{}'),
(5, 'view', 'a:2:{s:12:"(!permission";i:2;s:12:"|:Created_by";s:7:"USER_ID";}'),
(6, 'view', 'a:1:{s:2:"id";s:12:"USER_COMPANY";}'),
(7, 'add', 'a:0:{}'),
(8, 'edit', 'a:2:{s:11:"(permission";i:0;s:12:"|:Created_by";s:7:"USER_ID";}'),
(9, 'edit', 'a:1:{s:2:"id";s:12:"USER_COMPANY";}'),
(10, 'edit', 'a:0:{}'),
(11, 'delete', 'a:1:{s:11:":Created_by";s:7:"USER_ID";}'),
(12, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `company_access_clearance`
--

CREATE TABLE `company_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `company_access_clearance`
--

INSERT INTO `company_access_clearance` VALUES
(3, 'SUPERADMIN'),
(4, 'SUPERADMIN'),
(5, 'ACCESS:employee'),
(6, 'ALL'),
(7, 'ACCESS:employee'),
(8, 'ACCESS:employee'),
(9, 'ALL'),
(9, 'ACCESS:manager'),
(10, 'ACCESS:employee'),
(10, 'ACCESS:manager'),
(11, 'ACCESS:employee'),
(12, 'ACCESS:employee'),
(12, 'ACCESS:manager');

-- --------------------------------------------------------

--
-- Table structure for table `company_access_fields`
--

CREATE TABLE `company_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `company_access_fields`
--

INSERT INTO `company_access_fields` VALUES
(9, 'group'),
(9, 'permission');

-- --------------------------------------------------------

--
-- Table structure for table `company_callback`
--

CREATE TABLE `company_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `company_callback`
--

INSERT INTO `company_callback` VALUES
('Company Name', 'Utils_RecordBrowserCommon::display_linked_field_label', 1),
('Company Name', 'CRM_ContactsCommon::QFfield_cname', 0),
('Phone', 'CRM_ContactsCommon::display_phone', 1),
('Email', 'CRM_ContactsCommon::display_email', 1),
('Email', 'CRM_ContactsCommon::QFfield_unique_email', 0),
('Web address', 'CRM_ContactsCommon::display_webaddress', 1),
('Web address', 'CRM_ContactsCommon::QFfield_webaddress', 0),
('Address 1', 'CRM_ContactsCommon::maplink', 1),
('Address 2', 'CRM_ContactsCommon::maplink', 1),
('City', 'CRM_ContactsCommon::maplink', 1),
('Country', 'Data_CountriesCommon::QFfield_country', 0),
('Zone', 'Data_CountriesCommon::QFfield_zone', 0),
('Tax ID', 'CRM_ContactsCommon::QFfield_tax_id', 0);

-- --------------------------------------------------------

--
-- Table structure for table `company_data_1`
--

CREATE TABLE `company_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_company_name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_short_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_phone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_fax` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_web_address` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_group` text COLLATE utf8_unicode_ci,
  `f_permission` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_address_1` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_address_2` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_city` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_country` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_zone` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_postal_code` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_tax_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_idxed` (`indexed`,`active`),
  KEY `company_act` (`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `company_data_1`
--

INSERT INTO `company_data_1` VALUES
(1, '[[regtime]]', 1, 0, 1, '[[site_name]]', NULL, NULL, NULL, NULL, NULL, '__other__', '0', NULL, NULL, '[[city_add]]', 'US', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `company_edit_history`
--

CREATE TABLE `company_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `company_edit_history_data`
--

CREATE TABLE `company_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `company_favorite`
--

CREATE TABLE `company_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `company_favorite`
--

INSERT INTO `company_favorite` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `company_field`
--

CREATE TABLE `company_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=18 ;

--
-- Dumping data for table `company_field`
--

INSERT INTO `company_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Company Name', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '128', '', '', ''),
(4, 'Short Name', '', 'text', 1, 0, 0, 0, 1, 1, 4, 4, 0, '64', '', '', ''),
(5, 'Phone', '', 'text', 1, 1, 1, 0, 1, 1, 5, 5, 0, '64', '', '', ''),
(6, 'Fax', '', 'text', 1, 0, 0, 0, 1, 1, 6, 6, 0, '64', '', '', ''),
(7, 'Email', '', 'text', 1, 0, 0, 0, 1, 1, 7, 7, 0, '128', '', '', ''),
(8, 'Web address', '', 'text', 1, 0, 0, 0, 1, 1, 8, 8, 0, '64', '', '', ''),
(9, 'Group', '', 'multiselect', 0, 1, 1, 0, 1, 1, 9, 9, 1, '__COMMON__::Companies_Groups', '', '', ''),
(10, 'Permission', '', 'commondata', 1, 0, 0, 1, 1, 1, 10, 10, 0, 'key__CRM/Access', '', '', ''),
(11, 'Address 1', '', 'text', 1, 0, 0, 0, 1, 1, 11, 11, 0, '64', '', '', ''),
(12, 'Address 2', '', 'text', 1, 0, 0, 0, 1, 1, 12, 12, 0, '64', '', '', ''),
(13, 'City', '', 'text', 1, 1, 1, 0, 1, 1, 13, 13, 0, '64', '', '', ''),
(14, 'Country', '', 'commondata', 1, 0, 0, 1, 1, 1, 14, 14, 0, 'value__Countries', '', '', ''),
(15, 'Zone', '', 'commondata', 1, 1, 1, 0, 1, 1, 15, 15, 0, 'value__Countries::Country', '', '', ''),
(16, 'Postal Code', '', 'text', 1, 0, 0, 0, 1, 1, 16, 16, 0, '64', '', '', ''),
(17, 'Tax ID', '', 'text', 1, 0, 0, 0, 1, 1, 17, 17, 0, '64', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `company_recent`
--

CREATE TABLE `company_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `company_recent`
--

INSERT INTO `company_recent` VALUES
(1, 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `contact_access`
--

CREATE TABLE `contact_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=14 ;

--
-- Dumping data for table `contact_access`
--

INSERT INTO `contact_access` VALUES
(3, 'print', 'a:0:{}'),
(4, 'export', 'a:0:{}'),
(5, 'view', 'a:2:{s:12:"(!permission";i:2;s:12:"|:Created_by";s:7:"USER_ID";}'),
(6, 'view', 'a:1:{s:5:"login";s:7:"USER_ID";}'),
(7, 'add', 'a:0:{}'),
(8, 'edit', 'a:2:{s:11:"(permission";i:0;s:12:"|:Created_by";s:7:"USER_ID";}'),
(9, 'edit', 'a:1:{s:5:"login";s:7:"USER_ID";}'),
(10, 'edit', 'a:1:{s:12:"company_name";s:12:"USER_COMPANY";}'),
(11, 'edit', 'a:0:{}'),
(12, 'delete', 'a:1:{s:11:":Created_by";s:7:"USER_ID";}'),
(13, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `contact_access_clearance`
--

CREATE TABLE `contact_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `contact_access_clearance`
--

INSERT INTO `contact_access_clearance` VALUES
(3, 'SUPERADMIN'),
(4, 'SUPERADMIN'),
(5, 'ACCESS:employee'),
(6, 'ALL'),
(7, 'ACCESS:employee'),
(8, 'ACCESS:employee'),
(9, 'ALL'),
(10, 'ALL'),
(10, 'ACCESS:manager'),
(11, 'ACCESS:employee'),
(11, 'ACCESS:manager'),
(12, 'ACCESS:employee'),
(13, 'ACCESS:employee'),
(13, 'ACCESS:manager');

-- --------------------------------------------------------

--
-- Table structure for table `contact_access_fields`
--

CREATE TABLE `contact_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `contact_access_fields`
--

INSERT INTO `contact_access_fields` VALUES
(8, 'access'),
(8, 'login'),
(9, 'company_name'),
(9, 'related_companies'),
(9, 'access'),
(9, 'login'),
(9, 'group'),
(9, 'permission'),
(10, 'login'),
(10, 'company_name'),
(10, 'related_companies');

-- --------------------------------------------------------

--
-- Table structure for table `contact_callback`
--

CREATE TABLE `contact_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `contact_callback`
--

INSERT INTO `contact_callback` VALUES
('Last Name', 'Utils_RecordBrowserCommon::display_linked_field_label', 1),
('First Name', 'Utils_RecordBrowserCommon::display_linked_field_label', 1),
('Company Name', 'CRM_ContactsCommon::display_company', 1),
('Company Name', 'CRM_ContactsCommon::QFfield_company', 0),
('Related Companies', 'CRM_ContactsCommon::display_company', 1),
('Related Companies', 'CRM_ContactsCommon::QFfield_company', 0),
('Work Phone', 'CRM_ContactsCommon::display_phone', 1),
('Mobile Phone', 'CRM_ContactsCommon::display_phone', 1),
('Email', 'CRM_ContactsCommon::display_email', 1),
('Email', 'CRM_ContactsCommon::QFfield_unique_email', 0),
('Web address', 'CRM_ContactsCommon::display_webaddress', 1),
('Web address', 'CRM_ContactsCommon::QFfield_webaddress', 0),
('Address 1', 'CRM_ContactsCommon::maplink', 1),
('Address 2', 'CRM_ContactsCommon::maplink', 1),
('City', 'CRM_ContactsCommon::maplink', 1),
('Country', 'Data_CountriesCommon::QFfield_country', 0),
('Zone', 'Data_CountriesCommon::QFfield_zone', 0),
('Home Phone', 'CRM_ContactsCommon::display_phone', 1),
('Home Address 1', 'CRM_ContactsCommon::home_maplink', 1),
('Home Address 2', 'CRM_ContactsCommon::home_maplink', 1),
('Home City', 'CRM_ContactsCommon::home_maplink', 1),
('Home Country', 'Data_CountriesCommon::QFfield_country', 0),
('Home Zone', 'Data_CountriesCommon::QFfield_zone', 0),
('Login', 'CRM_ContactsCommon::display_login', 1),
('Login', 'CRM_ContactsCommon::QFfield_login', 0),
('Username', 'CRM_ContactsCommon::QFfield_username', 0),
('Set Password', 'CRM_ContactsCommon::QFfield_password', 0),
('Confirm Password', 'CRM_ContactsCommon::QFfield_repassword', 0),
('Admin', 'CRM_ContactsCommon::display_admin', 1),
('Admin', 'CRM_ContactsCommon::QFfield_admin', 0),
('Access', 'CRM_ContactsCommon::QFfield_access', 0);

-- --------------------------------------------------------

--
-- Table structure for table `contact_data_1`
--

CREATE TABLE `contact_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_last_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_first_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_company_name` int(11) DEFAULT NULL,
  `f_related_companies` text COLLATE utf8_unicode_ci,
  `f_group` text COLLATE utf8_unicode_ci,
  `f_title` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_work_phone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_mobile_phone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_fax` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_web_address` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_address_1` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_address_2` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_city` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_country` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_zone` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_postal_code` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_permission` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_phone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_address_1` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_address_2` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_city` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_country` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_zone` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_home_postal_code` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_birth_date` date DEFAULT NULL,
  `f_login` int(11) DEFAULT NULL,
  `f_access` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `contact_idxed` (`indexed`,`active`),
  KEY `contact_act` (`active`),
  KEY `contact_data_1__f_login_idx` (`f_login`,`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `contact_data_1`
--

INSERT INTO `contact_data_1` VALUES
(1, '[[regtime]]', 1, 0, 1, '[[admin_lname]]', '[[admin_fname]]', 1, NULL, '__office__field__', NULL, NULL, NULL, NULL, '[[admin_email]]', NULL, NULL, NULL, '[[city_add]]', 'US', NULL, NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `contact_edit_history`
--

CREATE TABLE `contact_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `contact_id` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contact_edit_history_data`
--

CREATE TABLE `contact_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contact_favorite`
--

CREATE TABLE `contact_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `contact_id` (`contact_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `contact_favorite`
--

INSERT INTO `contact_favorite` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `contact_field`
--

CREATE TABLE `contact_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=37 ;

--
-- Dumping data for table `contact_field`
--

INSERT INTO `contact_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Last Name', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '64', '', '', ''),
(4, 'First Name', '', 'text', 0, 1, 1, 1, 1, 1, 4, 4, 0, '64', '', '', ''),
(5, 'Company Name', '', 'select', 0, 1, 1, 0, 1, 1, 5, 5, 1, 'company::Company Name;::', '', '', ''),
(6, 'Related Companies', '', 'multiselect', 1, 0, 0, 0, 1, 1, 6, 6, 1, 'company::Company Name;::', '', '', ''),
(7, 'Group', '', 'multiselect', 1, 0, 0, 0, 1, 1, 7, 7, 1, '__COMMON__::Contacts_Groups', '', '', ''),
(8, 'Title', '', 'text', 1, 0, 0, 0, 1, 1, 8, 8, 0, '64', '', '', ''),
(9, 'Work Phone', '', 'text', 1, 1, 1, 0, 1, 1, 9, 9, 0, '64', '', '', ''),
(10, 'Mobile Phone', '', 'text', 1, 1, 1, 0, 1, 1, 10, 10, 0, '64', '', '', ''),
(11, 'Fax', '', 'text', 1, 0, 0, 0, 1, 1, 11, 11, 0, '64', '', '', ''),
(12, 'Email', '', 'text', 0, 0, 0, 0, 1, 1, 12, 12, 0, '128', '', '', ''),
(13, 'Web address', '', 'text', 1, 0, 0, 0, 1, 1, 13, 13, 0, '64', '', '', ''),
(14, 'Address 1', '', 'text', 1, 0, 0, 0, 1, 1, 14, 14, 0, '64', '', '', ''),
(15, 'Address 2', '', 'text', 1, 0, 0, 0, 1, 1, 15, 15, 0, '64', '', '', ''),
(16, 'City', '', 'text', 1, 1, 1, 0, 1, 1, 16, 16, 0, '64', '', '', ''),
(17, 'Country', '', 'commondata', 1, 0, 0, 1, 1, 1, 17, 17, 0, 'value__Countries', '', '', ''),
(18, 'Zone', '', 'commondata', 1, 1, 1, 0, 1, 1, 18, 18, 0, 'value__Countries::Country', '', '', ''),
(19, 'Postal Code', '', 'text', 1, 0, 0, 0, 1, 1, 19, 19, 0, '64', '', '', ''),
(20, 'Permission', '', 'commondata', 1, 0, 0, 1, 1, 1, 20, 20, 0, 'key__CRM/Access', '', '', ''),
(21, 'Details', '', 'page_split', 1, 0, 0, 0, 1, 1, 21, 21, 0, '', '', '', ''),
(22, 'Home Phone', '', 'text', 1, 0, 0, 0, 1, 1, 22, 22, 0, '64', '', '', ''),
(23, 'Home Address 1', '', 'text', 1, 0, 0, 0, 1, 1, 23, 23, 0, '64', '', '', ''),
(24, 'Home Address 2', '', 'text', 1, 0, 0, 0, 1, 1, 24, 24, 0, '64', '', '', ''),
(25, 'Home City', '', 'text', 1, 0, 0, 0, 1, 1, 25, 25, 0, '64', '', '', ''),
(26, 'Home Country', '', 'commondata', 1, 0, 0, 0, 1, 1, 26, 26, 0, 'value__Countries', '', '', ''),
(27, 'Home Zone', '', 'commondata', 1, 0, 0, 0, 1, 1, 27, 27, 0, 'value__Countries::Home Country', '', '', ''),
(28, 'Home Postal Code', '', 'text', 1, 0, 0, 0, 1, 1, 28, 28, 0, '64', '', '', ''),
(29, 'Birth Date', '', 'date', 1, 0, 0, 0, 1, 1, 29, 29, 0, '64', '', '', ''),
(30, 'Login Panel', '', 'page_split', 1, 0, 0, 0, 1, 1, 30, 30, 0, '1', '', '', ''),
(31, 'Login', '', 'integer', 0, 0, 0, 0, 1, 1, 31, 31, 0, '64', '', '', ''),
(32, 'Username', '', 'calculated', 0, 0, 0, 0, 1, 1, 32, 32, 0, '', '', '', ''),
(33, 'Set Password', '', 'calculated', 0, 0, 0, 0, 1, 1, 33, 33, 0, '', '', '', ''),
(34, 'Confirm Password', '', 'calculated', 0, 0, 0, 0, 1, 1, 34, 34, 0, '', '', '', ''),
(35, 'Admin', '', 'calculated', 0, 0, 0, 0, 1, 1, 35, 35, 0, '', '', '', ''),
(36, 'Access', '', 'multiselect', 0, 0, 0, 0, 1, 1, 36, 36, 0, '__COMMON__::Contacts/Access', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `contact_recent`
--

CREATE TABLE `contact_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `contact_id` (`contact_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `contact_recent`
--

INSERT INTO `contact_recent` VALUES
(1, 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `crm_calendar_custom_events_handlers`
--

CREATE TABLE `crm_calendar_custom_events_handlers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `handler_callback` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `crm_calendar_custom_events_handlers`
--

INSERT INTO `crm_calendar_custom_events_handlers` VALUES
(1, 'Phonecalls', 'CRM_PhoneCallCommon::crm_calendar_handler'),
(2, 'Tasks', 'CRM_TasksCommon::crm_calendar_handler'),
(3, 'Meetings', 'CRM_MeetingCommon::crm_calendar_handler');

-- --------------------------------------------------------

--
-- Table structure for table `crm_filters_contacts`
--

CREATE TABLE `crm_filters_contacts` (
  `group_id` int(11) NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crm_filters_group`
--

CREATE TABLE `crm_filters_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_login_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`user_login_id`),
  KEY `user_login_id` (`user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_access`
--

CREATE TABLE `crm_meeting_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `crm_meeting_access`
--

INSERT INTO `crm_meeting_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:2:{s:12:"(!permission";i:2;s:10:"|employees";s:4:"USER";}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:3:{s:11:"(permission";i:0;s:10:"|employees";s:4:"USER";s:10:"|customers";s:4:"USER";}'),
(6, 'delete', 'a:1:{s:11:":Created_by";s:7:"USER_ID";}'),
(7, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_access_clearance`
--

CREATE TABLE `crm_meeting_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `crm_meeting_access_clearance`
--

INSERT INTO `crm_meeting_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee'),
(6, 'ACCESS:employee'),
(7, 'ACCESS:employee'),
(7, 'ACCESS:manager');

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_access_fields`
--

CREATE TABLE `crm_meeting_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_callback`
--

CREATE TABLE `crm_meeting_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `crm_meeting_callback`
--

INSERT INTO `crm_meeting_callback` VALUES
('Title', 'CRM_MeetingCommon::display_title', 1),
('Date', 'CRM_MeetingCommon::display_date', 1),
('Duration', 'CRM_MeetingCommon::QFfield_duration', 0),
('Employees', 'CRM_MeetingCommon::display_employees', 1),
('Employees', 'CRM_ContactsCommon::QFfield_contact', 0),
('Customers', 'CRM_ContactsCommon::display_company_contact', 1),
('Status', 'CRM_MeetingCommon::display_status', 1),
('Recurrence type', 'CRM_MeetingCommon::QFfield_recurrence', 0),
('Recurrence end', 'CRM_MeetingCommon::QFfield_recurrence_end', 0),
('Recurrence hash', 'CRM_MeetingCommon::QFfield_recurrence_hash', 0),
('Related', 'CRM_MeetingCommon::QFfield_related', 0);

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_data_1`
--

CREATE TABLE `crm_meeting_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_description` text COLLATE utf8_unicode_ci,
  `f_date` date DEFAULT NULL,
  `f_time` datetime DEFAULT NULL,
  `f_duration` int(11) DEFAULT NULL,
  `f_employees` text COLLATE utf8_unicode_ci,
  `f_customers` text COLLATE utf8_unicode_ci,
  `f_status` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_priority` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_permission` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_recurrence_type` int(11) DEFAULT NULL,
  `f_recurrence_end` date DEFAULT NULL,
  `f_recurrence_hash` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_related` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `crm_meeting_idxed` (`indexed`,`active`),
  KEY `crm_meeting_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_edit_history`
--

CREATE TABLE `crm_meeting_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_meeting_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `crm_meeting_id` (`crm_meeting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_edit_history_data`
--

CREATE TABLE `crm_meeting_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_favorite`
--

CREATE TABLE `crm_meeting_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_meeting_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `crm_meeting_id` (`crm_meeting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_field`
--

CREATE TABLE `crm_meeting_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=17 ;

--
-- Dumping data for table `crm_meeting_field`
--

INSERT INTO `crm_meeting_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Title', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '255', '', '', ''),
(4, 'Description', '', 'long text', 0, 0, 0, 0, 1, 1, 4, 4, 0, '255', '', '', ''),
(5, 'Date', '', 'date', 0, 1, 1, 1, 1, 1, 5, 5, 0, '', '', '', ''),
(6, 'Time', '', 'time', 0, 1, 1, 1, 1, 1, 6, 6, 0, '5', 'time', '', ''),
(7, 'Duration', '', 'integer', 0, 0, 0, 0, 1, 1, 7, 7, 0, '255', 'number', '', ''),
(8, 'Employees', '', 'multiselect', 0, 1, 1, 1, 1, 1, 8, 8, 1, 'contact::Last Name|First Name;CRM_ContactsCommon::contact_format_no_company;CRM_MeetingCommon::employees_crits', '', '', ''),
(9, 'Customers', '', 'multiselect', 0, 1, 1, 0, 1, 1, 9, 9, 0, 'company,contact::;CRM_MeetingCommon::customers_crits;CRM_ContactsCommon::crm_company_contact_select_list_options', '', '', ''),
(10, 'Status', '', 'commondata', 0, 1, 1, 1, 1, 1, 10, 10, 1, 'key__CRM/Status', '', '', ''),
(11, 'Priority', '', 'commondata', 0, 1, 1, 1, 1, 1, 11, 11, 0, 'key__CRM/Priority', '', '', ''),
(12, 'Permission', '', 'commondata', 0, 0, 0, 1, 1, 1, 12, 12, 0, 'key__CRM/Access', '', '', ''),
(13, 'Recurrence type', '', 'integer', 0, 0, 0, 0, 1, 1, 13, 13, 0, '', 'number', '', ''),
(14, 'Recurrence end', '', 'date', 0, 0, 0, 0, 1, 1, 14, 14, 0, '', '', '', ''),
(15, 'Recurrence hash', '', 'text', 0, 0, 0, 0, 1, 1, 15, 15, 0, '16', '', '', ''),
(16, 'Related', '', 'multiselect', 0, 1, 1, 0, 1, 1, 16, 16, 0, '__RECORDSETS__::;CRM_MeetingCommon::related_crits', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_recent`
--

CREATE TABLE `crm_meeting_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_meeting_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `crm_meeting_id` (`crm_meeting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_access`
--

CREATE TABLE `crm_meeting_related_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `crm_meeting_related_access`
--

INSERT INTO `crm_meeting_related_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:0:{}'),
(6, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_access_clearance`
--

CREATE TABLE `crm_meeting_related_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `crm_meeting_related_access_clearance`
--

INSERT INTO `crm_meeting_related_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ADMIN'),
(5, 'SUPERADMIN'),
(6, 'SUPERADMIN');

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_access_fields`
--

CREATE TABLE `crm_meeting_related_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_callback`
--

CREATE TABLE `crm_meeting_related_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `crm_meeting_related_callback`
--

INSERT INTO `crm_meeting_related_callback` VALUES
('Recordset', 'CRM_MeetingCommon::display_recordset', 1),
('Recordset', 'CRM_MeetingCommon::QFfield_recordset', 0);

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_data_1`
--

CREATE TABLE `crm_meeting_related_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_recordset` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_meeting_related_idxed` (`indexed`,`active`),
  KEY `crm_meeting_related_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_edit_history`
--

CREATE TABLE `crm_meeting_related_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_meeting_related_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `crm_meeting_related_id` (`crm_meeting_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_edit_history_data`
--

CREATE TABLE `crm_meeting_related_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_favorite`
--

CREATE TABLE `crm_meeting_related_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_meeting_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `crm_meeting_related_id` (`crm_meeting_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_field`
--

CREATE TABLE `crm_meeting_related_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `crm_meeting_related_field`
--

INSERT INTO `crm_meeting_related_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Recordset', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '64', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `crm_meeting_related_recent`
--

CREATE TABLE `crm_meeting_related_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `crm_meeting_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `crm_meeting_related_id` (`crm_meeting_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `cron`
--

CREATE TABLE `cron` (
  `func` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `last` int(11) NOT NULL,
  `running` tinyint(4) NOT NULL DEFAULT '0',
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`func`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `epesi_store_modules`
--

CREATE TABLE `epesi_store_modules` (
  `module_id` int(11) NOT NULL,
  `version` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module_license_id` int(11) NOT NULL,
  `file` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `history`
--

CREATE TABLE `history` (
  `session_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `client_id` smallint(6) NOT NULL DEFAULT '0',
  `data` longblob,
  PRIMARY KEY (`client_id`,`session_name`,`page_id`),
  KEY `history__session_name__client_id__idx` (`session_name`,`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `history`
--

-- --------------------------------------------------------

--
-- Table structure for table `libs_tcpdf_pdf_index`
--

CREATE TABLE `libs_tcpdf_pdf_index` (
  `created_on` datetime DEFAULT NULL,
  `filename` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `modules`
--

CREATE TABLE `modules` (
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `version` int(11) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  `state` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `modules`
--

INSERT INTO `modules` VALUES
('Applets_Birthdays', 0, 91, 0),
('Applets_Calc', 0, 58, 0),
('Applets_Clock', 0, 73, 0),
('Applets_Google', 0, 59, 0),
('Applets_Host', 0, 60, 0),
('Applets_MonthView', 0, 92, 0),
('Applets_Note', 0, 61, 0),
('Applets_RssFeed', 0, 74, 0),
('Applets_Weather', 0, 75, 0),
('Apps_ActivityReport', 0, 78, 0),
('Apps_Shoutbox', 0, 72, 0),
('Base', 0, 71, 0),
('Base_About', 0, 50, 0),
('Base_Acl', 0, 22, 0),
('Base_ActionBar', 0, 47, 0),
('Base_Admin', 0, 23, 0),
('Base_Box', 0, 48, 0),
('Base_Cron', 0, 70, 0),
('Base_Dashboard', 0, 57, 0),
('Base_EpesiStore', 0, 35, 0),
('Base_Error', 0, 36, 0),
('Base_EssClient', 0, 29, 0),
('Base_Help', 0, 49, 0),
('Base_HomePage', 0, 51, 0),
('Base_Lang', 0, 10, 0),
('Base_Lang_Administrator', 0, 52, 0),
('Base_Mail', 0, 32, 0),
('Base_Mail_ContactUs', 0, 21, 0),
('Base_MainModuleIndicator', 0, 55, 0),
('Base_Menu', 0, 19, 0),
('Base_Menu_QuickAccess', 0, 33, 0),
('Base_Notify', 0, 34, 0),
('Base_Print', 0, 20, 0),
('Base_RegionalSettings', 0, 64, 0),
('Base_Search', 0, 54, 0),
('Base_Setup', 0, 30, 0),
('Base_StatusBar', 0, 13, 0),
('Base_Theme', 0, 14, 0),
('Base_Theme_Administrator', 0, 31, 0),
('Base_User', 0, 24, 0),
('Base_User_Administrator', 0, 53, 0),
('Base_User_Login', 0, 37, 0),
('Base_User_Settings', 0, 38, 0),
('CRM_Calendar', 0, 87, 0),
('CRM_Calendar_Event', 0, 79, 0),
('CRM_Common', 0, 62, 0),
('CRM_Contacts', 0, 77, 0),
('CRM_Contacts_Activities', 0, 80, 0),
('CRM_Filters', 0, 81, 0),
('CRM_Followup', 0, 82, 0),
('CRM_LoginAudit', 0, 83, 0),
('CRM_Mail', 0, 84, 0),
('CRM_Meeting', 0, 88, 0),
('CRM_PhoneCall', 0, 89, 0),
('CRM_Roundcube', 0, 85, 0),
('CRM_Tasks', 0, 90, 0),
('CRM_WhoIsOnline', 0, 86, 0),
('Data_Countries', 0, 63, 0),
('FirstRun', 0, 95, 0),
('Libs_CKEditor', 0, 26, 0),
('Libs_Leightbox', 0, 15, 0),
('Libs_QuickForm', 0, 25, 0),
('Libs_ScriptAculoUs', 0, 0, 0),
('Libs_TCPDF', 0, 11, 0),
('Tools_SessionKeeper', 0, 39, 0),
('Tools_SetDefaults', 0, 94, 0),
('Tools_WhoIsOnline', 0, 40, 0),
('Utils_Attachment', 0, 76, 0),
('Utils_BBCode', 0, 65, 0),
('Utils_Calendar', 0, 66, 0),
('Utils_Calendar_Event', 0, 1, 0),
('Utils_ChainedSelect', 0, 2, 0),
('Utils_CommonData', 0, 56, 0),
('Utils_CurrencyField', 0, 44, 0),
('Utils_FileDownload', 0, 12, 0),
('Utils_FileStorage', 0, 7, 0),
('Utils_FileUpload', 0, 28, 0),
('Utils_FrontPage', 0, 17, 0),
('Utils_GenericBrowser', 0, 45, 0),
('Utils_Image', 0, 8, 0),
('Utils_LeightboxPrompt', 0, 18, 0),
('Utils_Menu', 0, 9, 0),
('Utils_Messenger', 0, 69, 0),
('Utils_PopupCalendar', 0, 43, 0),
('Utils_QueryBuilder', 0, 6, 0),
('Utils_RecordBrowser', 0, 67, 0),
('Utils_RecordBrowser_CustomRecordsets', 0, 68, 0),
('Utils_RecordBrowser_Filters', 0, 27, 0),
('Utils_RecordBrowser_RecordPicker', 0, 3, 0),
('Utils_RecordBrowser_RecordPickerFS', 0, 4, 0),
('Utils_Shortcut', 0, 41, 0),
('Utils_TabbedBrowser', 0, 16, 0),
('Utils_Tooltip', 0, 42, 0),
('Utils_Tree', 0, 5, 0),
('Utils_Watchdog', 0, 46, 0),
('Utils_Wizard', 0, 93, 0);

-- --------------------------------------------------------

--
-- Table structure for table `patches`
--

CREATE TABLE `patches` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `patches`
--

INSERT INTO `patches` VALUES
('0304d4a1e50ed179360ddbb69ebbdb23'),
('048d7ed75e241b20c8cdf8916038e1a1'),
('04d3176bcd7448e1bc34b523be8a5ae2'),
('0545fca51feb461f81489791c5bbbebb'),
('06d33ddc111eece95f0b0f889025277d'),
('08431754532b37041519396228d36f9d'),
('0877643ef6b1269e024be5c95f63627f'),
('08929fdd953c2b1eb41175caa558e379'),
('099da62ca88fb3f8e5a9e32465c951bf'),
('10096952b28aced8c974777bf4a0b110'),
('120e9a5e108fdbf3eded971ceb7501b0'),
('19c08393f347e76fc37123758835f7d7'),
('19faacd79e905f29cffab5db88e37d51'),
('1a3125d14089195d88dc129869cf8ca0'),
('1a824bee1c2f35110fdeffcc0494795b'),
('1b89c32cfe45f71728a55217ca577315'),
('1bd499f0749cdaeedba8e1095e69d673'),
('216f7e398a110f4851541470c9e825d1'),
('22b6c1ecef973612b0f0d13633b96880'),
('22e7dec722290cc4b86b86b5ad31788a'),
('298daf1824c18511c909b90f5949b559'),
('2a77719eb54b69d3618ccc36e816fc47'),
('2d2d98cb42df4862c7951a80755ad211'),
('2d9237b6e04fc17789e54fb88e17c1fc'),
('2e0f3fed51d08695837c2c3f7ee16f39'),
('30bbeab59221fa6c67f5dd2b6f647d94'),
('30fa0b32a89f17062bfb0781d0f66ece'),
('3198c469da321c7ae48062908b5e319e'),
('31d6303b7b450d1e6d036c0311742ad2'),
('361f7980ed8ec5c23c8121207e3c08e2'),
('3653f157c39c24b961610372db39dec7'),
('36a54745debf7303855a3cb085dd6e67'),
('371361ca7652444a79bec1478999e80c'),
('39dd2fd84733f5254e144eb551a79ef3'),
('3b390864871c9c2975766e756df56cf1'),
('3ee2061f789ae457646d56fdac2a0c2b'),
('433969ead32eda35e30e847ed077b154'),
('44137863912e61d2700d5538287783dd'),
('4547f128c9f4281c6f2691681ff6060d'),
('45dafb83f26bfefcc0b6f365cfd58c2b'),
('496173eb28ab8152941e07a0c5203963'),
('499d08b3fc1b20084674924d43d29a07'),
('49f1e90f972ac1dbff2034d0f5ab8f1c'),
('49f471f5b621368127cfc8f0e655c3bd'),
('4aa219299a916108537ddcbf38a49302'),
('4c0be2d81eaa267a742303e8db6fb657'),
('526ce19c09de9a46c8f0ae3e24839d4e'),
('5423a849d24b4fbd19fa7da4af6817ca'),
('55ec86807d507d959e439131867e8e07'),
('566eaca7ad0812aa2a05e03aad6e4747'),
('57d1cef940d3a3239846de4889e06ec5'),
('584fe6ea840dfc2a5add052f16773124'),
('5accb3bc444b4ba23c237343838b23b7'),
('5ee34ea2b34869ffc5a60b62a720e17c'),
('60dc60e5f60de3890ea3fdc362ce8c22'),
('64320e87b42b8800fbd9b70c80f0253b'),
('66b30dc2cb5f879f4b9d3e4b096840b0'),
('6881df1b28b08df026596fd1e0fff4e7'),
('69ca3fbe7880b66ada40fcaa2353d2c4'),
('7134f2c8b02813e613ff0b4cb9e106c2'),
('74ca19617870f3fcbdbf424165e85932'),
('77cdda9222ec1b256226c3dacaa37c63'),
('781af107b958a8f3bf32faca8e6b23bf'),
('79822930d5d93f57190d1e5f7c680588'),
('7988bcc05312596e4f9a327cc4d50d46'),
('7a14f7cc2bc00c55982fa9d91fb878ab'),
('7a8b633117c40790fb71f5c462a86c7b'),
('7ac5964450531372f368d58591e2f61f'),
('7ac673e05359005ad5548c65da65c9eb'),
('8146e14c0162a223b8519fd7a7c186a5'),
('8357fd0ffa2b80bcfe8ecfaa91c04a28'),
('8491c18f617958856bdac89ecdb79f9a'),
('853fd6d13b64e659c6d43d624ff610b7'),
('85d477428523a60fd9cf107a2033cc1a'),
('86f08763275c63af5a816500e968cb19'),
('87c6192736ba11d275cf20e742b6f703'),
('8ae9b4359984f66d9db011869536e06f'),
('8b138377dfc021e7d1913b0ad21724d4'),
('8b5fcea8b4b8c70a28b6d780994f9dcf'),
('8e6809b6527b3703321c188c16ddb6f6'),
('8f239ebf76be87e68b49d3377cd78df5'),
('904a81841012e9d2df98503e37f1431b'),
('90d4ecb30c0aa6b4532819a0dc1a3c2c'),
('90f0f9a8a7a9ce4ed8816acdfe1eda8c'),
('939298549ce0fe317ecd8d3ca271ac4a'),
('93af47e2bea662f5631a77d3713aebf1'),
('95553f8de343696acd2170c0f483a64b'),
('98de8ceb056f02076dfcb25fc35f8c15'),
('9b15b413733ced9b06d63c49790cecca'),
('a1132e72de07dbad150a020f87b2b68e'),
('a3cb545ec9dccfd7035c00c6c3e3db8d'),
('a41ac94cf112b748cfacf9474dccb47f'),
('a4fe7324a7e252ba059e88f5e84cc0c0'),
('a52ff6fe2f6b233b31cde694b109813b'),
('a5d21d0a4e8d100bfad4c7d584b4ebfe'),
('a66487ffdc03a5408ed8554839a65ed0'),
('a68c901b752cad2964518e6e5f88ee7d'),
('a733d692e331ab6f0189c4a5ba4e256f'),
('aede349d80fe3a867398cdf2909cb68a'),
('af467809ee1e033d54ba1dd98f0c8bba'),
('b012a153f1ec2e329ff57e41f68d1983'),
('b0dcdca7dfafc9270bab7ca2949163f2'),
('b59ce5287857aa8b1e2d39c8b45af946'),
('b7cbcfa2dcb28aa2e9a79527f7eaf342'),
('b821835da06c532d78b2bfafb7de6c3a'),
('b83c9f7a4bb6a771cc917911c9f6d32b'),
('b8f4a88a7b97359aee24daab657027bb'),
('b9edb4daabe51b8f8dc39867e608d8e5'),
('bafef3ffa2c76a07b3e886299300c4b1'),
('bb2bc4f2195ad8db59c7a2c9a37ae7fe'),
('bcb872e4bb623cde2eeca7e68b7ac02b'),
('bd63f882937e35edf0549de32b9aabb3'),
('be510aacd00a9b6bfe0abd3b82a1b4ea'),
('bf97f22e456f3c2fd1761c4787aa12eb'),
('c31058bd967e8e5656f42574eef78903'),
('c448b9dcbcef35ea98186b46dd598e6f'),
('c4ddc0110b7636b91983d096f2e9b346'),
('c4eb146b6946e14617e402e3df846406'),
('c64bd32ed58b37727a229ea7c6feb1f1'),
('c74cfa07fc979d43196325c880fa0979'),
('c74daa306e703c7ccaed6d0ae1b1fdaa'),
('c7b7686430a2a36d48f4f4ea35954b7f'),
('cae19188ab664022ecba2ddfe050160b'),
('cd31ac510acb9ca6433da87ffdc0be98'),
('cdee0e4dbc3f541fe364382b0232f4a0'),
('d2ea6a11759ca5e4c8707904049f52ef'),
('d3fbae0c733d48725d849db65ddf4108'),
('d919b6490b40b8f9a33cc7c3d714a092'),
('dbe0205963ba193c95b841008e884b83'),
('ddc4ba009a7fc4e39e0ea7bf183bb256'),
('de283b276c8020be96b117d4f39489d3'),
('de62b49a7d512295a0d90aee5004f3d1'),
('deb65e501493a20da28136a145c3ee69'),
('df2ec87e72dea95ec305675668fce15f'),
('df3d9204cfd982de521e464351ddc0c4'),
('e0264b4a39b3780ca1d50eb131bb17c4'),
('e2eff3959d8ecd3faf45ac77cc7077eb'),
('e35532bd54116493bfa7c9edc061a9fb'),
('e65322d34b6dcf9bd3cfe51fea317bce'),
('e81b5cac30768a49623f856c312a291b'),
('e916f711a09c74a697db2e1f2a453139'),
('e9365ff9bcbe43bd07716e52f60df377'),
('e9ddaca1919fd64a7be88f3fb2f23b1b'),
('ecd715a781ac6faf26c2c3687dd1c987'),
('ee45e986c3871ab492f52f0d931a4f83'),
('f2978f678e46bf47d8c770f0041578d5'),
('f6af4a9744d8829f0d025104ea7da5af'),
('f6ce08cba4fb6eab4c5ace1557ae8717'),
('f78e790e85087da0d33c16a5da959fd2'),
('f8074916e98852484fbbeb81ad3d208a'),
('f84ddd714f25354c6d5554423094e4f5'),
('fa7e271f13c3097269e44c78c59683fc'),
('fbf754e71606e4e5640c58074865d421'),
('fcb8f0db55037fc4ca9dcbc9f6dd32b9'),
('fd4b163e68a74cf4d129878f45137538'),
('fda98bdde50aae0b81f6ca1b91a57f2e'),
('ffba0c538b4e9e7c9e165406fe012ddd');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_access`
--

CREATE TABLE `phonecall_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `phonecall_access`
--

INSERT INTO `phonecall_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:2:{s:12:"(!permission";i:2;s:10:"|employees";s:4:"USER";}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:3:{s:11:"(permission";i:0;s:10:"|employees";s:4:"USER";s:9:"|customer";s:4:"USER";}'),
(6, 'delete', 'a:1:{s:11:":Created_by";s:7:"USER_ID";}'),
(7, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_access_clearance`
--

CREATE TABLE `phonecall_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `phonecall_access_clearance`
--

INSERT INTO `phonecall_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee'),
(6, 'ACCESS:employee'),
(7, 'ACCESS:employee'),
(7, 'ACCESS:manager');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_access_fields`
--

CREATE TABLE `phonecall_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_callback`
--

CREATE TABLE `phonecall_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `phonecall_callback`
--

INSERT INTO `phonecall_callback` VALUES
('Subject', 'CRM_PhoneCallCommon::display_subject', 1),
('Contact Name', 'CRM_PhoneCallCommon::display_contact_name', 1),
('Phone Number', 'CRM_PhoneCallCommon::display_phone_number', 1),
('Customer', 'CRM_ContactsCommon::display_company_contact', 1),
('Employees', 'CRM_ContactsCommon::display_contact', 1),
('Employees', 'CRM_ContactsCommon::QFfield_contact', 0),
('Status', 'CRM_PhoneCallCommon::display_status', 1),
('Phone', 'CRM_PhoneCallCommon::display_phone', 1),
('Phone', 'CRM_PhoneCallCommon::QFfield_phone', 0),
('Related', 'CRM_PhoneCallCommon::QFfield_related', 0);

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_data_1`
--

CREATE TABLE `phonecall_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_subject` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_customer` text COLLATE utf8_unicode_ci,
  `f_other_customer` tinyint(4) DEFAULT NULL,
  `f_other_customer_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_permission` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_employees` text COLLATE utf8_unicode_ci,
  `f_status` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_priority` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_phone` int(11) DEFAULT NULL,
  `f_other_phone` tinyint(4) DEFAULT NULL,
  `f_other_phone_number` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_date_and_time` datetime DEFAULT NULL,
  `f_description` text COLLATE utf8_unicode_ci,
  `f_related` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `phonecall_idxed` (`indexed`,`active`),
  KEY `phonecall_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_edit_history`
--

CREATE TABLE `phonecall_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phonecall_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `phonecall_id` (`phonecall_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_edit_history_data`
--

CREATE TABLE `phonecall_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_favorite`
--

CREATE TABLE `phonecall_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `phonecall_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `phonecall_id` (`phonecall_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_field`
--

CREATE TABLE `phonecall_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `phonecall_field`
--

INSERT INTO `phonecall_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Subject', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '64', '', '', ''),
(4, 'Contact Name', '', 'hidden', 0, 1, 1, 0, 1, 1, 4, 4, 0, '', '', '', ''),
(5, 'Phone Number', '', 'hidden', 0, 1, 1, 0, 1, 1, 5, 5, 0, '', '', '', ''),
(6, 'Customer', '', 'select', 0, 0, 0, 0, 1, 1, 6, 6, 0, 'company,contact::;::;CRM_ContactsCommon::crm_company_contact_select_list_options', '', '', ''),
(7, 'Other Customer', '', 'checkbox', 0, 0, 0, 0, 1, 1, 7, 7, 0, '', '', '', ''),
(8, 'Other Customer Name', '', 'text', 0, 0, 0, 0, 1, 1, 8, 8, 0, '64', '', '', ''),
(9, 'Permission', '', 'commondata', 0, 0, 0, 1, 1, 1, 9, 9, 0, 'key__CRM/Access', '', '', ''),
(10, 'Employees', '', 'multiselect', 0, 1, 1, 1, 1, 1, 10, 10, 1, 'contact::Last Name|First Name;CRM_ContactsCommon::contact_format_no_company;CRM_PhoneCallCommon::employees_crits', '', '', ''),
(11, 'Status', '', 'commondata', 0, 1, 1, 1, 1, 1, 11, 11, 1, 'key__CRM/Status', '', '', ''),
(12, 'Priority', '', 'commondata', 0, 0, 0, 1, 1, 1, 12, 12, 0, 'key__CRM/Priority', '', '', ''),
(13, 'Phone', '', 'integer', 0, 0, 0, 0, 1, 1, 13, 13, 0, '', 'number', '', ''),
(14, 'Other Phone', '', 'checkbox', 0, 0, 0, 0, 1, 1, 14, 14, 0, '', '', '', ''),
(15, 'Other Phone Number', '', 'text', 0, 0, 0, 0, 1, 1, 15, 15, 0, '64', '', '', ''),
(16, 'Date and Time', '', 'timestamp', 0, 1, 1, 1, 1, 1, 16, 16, 0, '', 'timestamp', '', ''),
(17, 'Description', '', 'long text', 0, 0, 0, 0, 1, 1, 17, 17, 0, '255', '', '', ''),
(18, 'Related', '', 'multiselect', 0, 1, 1, 0, 1, 1, 18, 18, 0, '__RECORDSETS__::;CRM_PhoneCallCommon::related_crits', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_recent`
--

CREATE TABLE `phonecall_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `phonecall_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `phonecall_id` (`phonecall_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_access`
--

CREATE TABLE `phonecall_related_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `phonecall_related_access`
--

INSERT INTO `phonecall_related_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:0:{}'),
(6, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_access_clearance`
--

CREATE TABLE `phonecall_related_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `phonecall_related_access_clearance`
--

INSERT INTO `phonecall_related_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ADMIN'),
(5, 'SUPERADMIN'),
(6, 'SUPERADMIN');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_access_fields`
--

CREATE TABLE `phonecall_related_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_callback`
--

CREATE TABLE `phonecall_related_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `phonecall_related_callback`
--

INSERT INTO `phonecall_related_callback` VALUES
('Recordset', 'CRM_PhoneCallCommon::display_recordset', 1),
('Recordset', 'CRM_PhoneCallCommon::QFfield_recordset', 0);

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_data_1`
--

CREATE TABLE `phonecall_related_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_recordset` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `phonecall_related_idxed` (`indexed`,`active`),
  KEY `phonecall_related_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_edit_history`
--

CREATE TABLE `phonecall_related_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phonecall_related_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `phonecall_related_id` (`phonecall_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_edit_history_data`
--

CREATE TABLE `phonecall_related_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_favorite`
--

CREATE TABLE `phonecall_related_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `phonecall_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `phonecall_related_id` (`phonecall_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_field`
--

CREATE TABLE `phonecall_related_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `phonecall_related_field`
--

INSERT INTO `phonecall_related_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Recordset', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '64', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `phonecall_related_recent`
--

CREATE TABLE `phonecall_related_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `phonecall_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `phonecall_related_id` (`phonecall_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_access`
--

CREATE TABLE `rc_accounts_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `rc_accounts_access`
--

INSERT INTO `rc_accounts_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:1:{s:10:"epesi_user";s:7:"USER_ID";}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:0:{}'),
(6, 'delete', 'a:1:{s:10:"epesi_user";s:7:"USER_ID";}');

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_access_clearance`
--

CREATE TABLE `rc_accounts_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_accounts_access_clearance`
--

INSERT INTO `rc_accounts_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee'),
(6, 'ACCESS:employee');

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_access_fields`
--

CREATE TABLE `rc_accounts_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_accounts_access_fields`
--

INSERT INTO `rc_accounts_access_fields` VALUES
(5, 'epesi_user');

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_callback`
--

CREATE TABLE `rc_accounts_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_accounts_callback`
--

INSERT INTO `rc_accounts_callback` VALUES
('EPESI User', 'CRM_MailCommon::display_epesi_user', 1),
('EPESI User', 'CRM_MailCommon::QFfield_epesi_user', 0),
('Account Name', 'CRM_MailCommon::QFfield_account_name', 0),
('Password', 'CRM_MailCommon::display_password', 1),
('Password', 'CRM_MailCommon::QFfield_password', 0),
('Security', 'CRM_MailCommon::QFfield_security', 0),
('SMTP Auth', 'CRM_MailCommon::QFfield_smtp_auth', 0),
('SMTP Login', 'CRM_MailCommon::QFfield_smtp_login', 0),
('SMTP Password', 'CRM_MailCommon::display_password', 1),
('SMTP Password', 'CRM_MailCommon::QFfield_smtp_password', 0),
('SMTP Security', 'CRM_MailCommon::QFfield_smtp_security', 0),
('Default Account', 'CRM_MailCommon::QFfield_default_account', 0);

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_data_1`
--

CREATE TABLE `rc_accounts_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_epesi_user` int(11) DEFAULT NULL,
  `f_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_account_name` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_server` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_login` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_security` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_smtp_server` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_smtp_auth` tinyint(4) DEFAULT NULL,
  `f_smtp_login` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_smtp_password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_smtp_security` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_default_account` tinyint(4) DEFAULT NULL,
  `f_archive_on_sending` tinyint(4) DEFAULT NULL,
  `f_use_epesi_archive_directories` tinyint(4) DEFAULT NULL,
  `f_imap_root` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_imap_delimiter` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rc_accounts_idxed` (`indexed`,`active`),
  KEY `rc_accounts_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_edit_history`
--

CREATE TABLE `rc_accounts_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_accounts_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `rc_accounts_id` (`rc_accounts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_edit_history_data`
--

CREATE TABLE `rc_accounts_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_favorite`
--

CREATE TABLE `rc_accounts_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_accounts_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_accounts_id` (`rc_accounts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_field`
--

CREATE TABLE `rc_accounts_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=21 ;

--
-- Dumping data for table `rc_accounts_field`
--

INSERT INTO `rc_accounts_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'EPESI User', '', 'integer', 0, 1, 1, 1, 1, 1, 3, 3, 0, '', 'number', '', ''),
(4, 'Email', '', 'text', 0, 1, 1, 1, 1, 1, 4, 4, 0, '128', '', '', ''),
(5, 'Account Name', '', 'text', 0, 1, 1, 1, 1, 1, 5, 5, 0, '32', '', '', ''),
(6, 'Server', '', 'text', 0, 1, 1, 1, 1, 1, 6, 6, 0, '255', '', '', ''),
(7, 'Login', '', 'text', 0, 1, 1, 1, 1, 1, 7, 7, 0, '255', '', '', ''),
(8, 'Password', '', 'text', 0, 0, 0, 1, 1, 1, 8, 8, 0, '255', '', '', ''),
(9, 'Security', '', 'commondata', 0, 0, 0, 0, 1, 1, 9, 9, 0, 'value__CRM/Mail/Security', '', '', ''),
(10, 'SMTP Server', '', 'text', 0, 0, 0, 1, 1, 1, 10, 10, 0, '255', '', '', ''),
(11, 'SMTP Auth', '', 'checkbox', 0, 0, 0, 0, 1, 1, 11, 11, 0, '', '', '', ''),
(12, 'SMTP Login', '', 'text', 0, 0, 0, 0, 1, 1, 12, 12, 0, '255', '', '', ''),
(13, 'SMTP Password', '', 'text', 0, 0, 0, 0, 1, 1, 13, 13, 0, '255', '', '', ''),
(14, 'SMTP Security', '', 'commondata', 0, 0, 0, 0, 1, 1, 14, 14, 0, 'value__CRM/Mail/Security', '', '', ''),
(15, 'Default Account', '', 'checkbox', 0, 1, 1, 0, 1, 1, 15, 15, 0, '', '', '', ''),
(16, 'Advanced', '', 'page_split', 1, 0, 0, 0, 1, 1, 16, 16, 0, '', '', '', ''),
(17, 'Archive on sending', '', 'checkbox', 1, 0, 0, 0, 1, 1, 17, 17, 0, '', '', '', ''),
(18, 'Use EPESI Archive directories', '', 'checkbox', 1, 0, 0, 0, 1, 1, 18, 18, 0, '', '', '', ''),
(19, 'IMAP Root', '', 'text', 1, 0, 0, 0, 1, 1, 19, 19, 0, '32', '', '', ''),
(20, 'IMAP Delimiter', '', 'text', 1, 0, 0, 0, 1, 1, 20, 20, 0, '8', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `rc_accounts_recent`
--

CREATE TABLE `rc_accounts_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_accounts_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_accounts_id` (`rc_accounts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_cache`
--

CREATE TABLE `rc_cache` (
  `user_id` int(10) unsigned NOT NULL,
  `cache_key` varchar(128) CHARACTER SET ascii NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `expires` datetime DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  KEY `expires_index` (`expires`),
  KEY `user_cache_index` (`user_id`,`cache_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_cache_index`
--

CREATE TABLE `rc_cache_index` (
  `user_id` int(10) unsigned NOT NULL,
  `mailbox` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `expires` datetime DEFAULT NULL,
  `valid` tinyint(1) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`mailbox`),
  KEY `expires_index` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_cache_messages`
--

CREATE TABLE `rc_cache_messages` (
  `user_id` int(10) unsigned NOT NULL,
  `mailbox` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `expires` datetime DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  `flags` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`mailbox`,`uid`),
  KEY `expires_index` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_cache_shared`
--

CREATE TABLE `rc_cache_shared` (
  `cache_key` varchar(255) CHARACTER SET ascii NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `expires` datetime DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  KEY `expires_index` (`expires`),
  KEY `cache_key_index` (`cache_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_cache_thread`
--

CREATE TABLE `rc_cache_thread` (
  `user_id` int(10) unsigned NOT NULL,
  `mailbox` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `expires` datetime DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`mailbox`),
  KEY `expires_index` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_contactgroupmembers`
--

CREATE TABLE `rc_contactgroupmembers` (
  `contactgroup_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`contactgroup_id`,`contact_id`),
  KEY `contactgroupmembers_contact_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_contactgroups`
--

CREATE TABLE `rc_contactgroups` (
  `contactgroup_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`contactgroup_id`),
  KEY `contactgroups_user_index` (`user_id`,`del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_contacts`
--

CREATE TABLE `rc_contacts` (
  `contact_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` text COLLATE utf8_unicode_ci NOT NULL,
  `firstname` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `surname` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `vcard` longtext COLLATE utf8_unicode_ci,
  `words` text COLLATE utf8_unicode_ci,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`contact_id`),
  KEY `user_contacts_index` (`user_id`,`del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_dictionary`
--

CREATE TABLE `rc_dictionary` (
  `user_id` int(10) unsigned DEFAULT NULL,
  `language` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `uniqueness` (`user_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_identities`
--

CREATE TABLE `rc_identities` (
  `identity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `standard` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `organization` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `reply-to` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bcc` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `signature` longtext COLLATE utf8_unicode_ci,
  `html_signature` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`identity_id`),
  KEY `user_identities_index` (`user_id`,`del`),
  KEY `email_identities_index` (`email`,`del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_access`
--

CREATE TABLE `rc_mails_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `rc_mails_access`
--

INSERT INTO `rc_mails_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'delete', 'a:0:{}'),
(5, 'edit', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_access_clearance`
--

CREATE TABLE `rc_mails_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_mails_access_clearance`
--

INSERT INTO `rc_mails_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_access_fields`
--

CREATE TABLE `rc_mails_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_mails_access_fields`
--

INSERT INTO `rc_mails_access_fields` VALUES
(3, 'headers_data'),
(5, 'subject'),
(5, 'employee'),
(5, 'date'),
(5, 'headers_data'),
(5, 'body'),
(5, 'from'),
(5, 'to'),
(5, 'thread'),
(5, 'message_id'),
(5, 'references');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_attachments`
--

CREATE TABLE `rc_mails_attachments` (
  `mail_id` int(11) NOT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mime_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attachment` tinyint(4) DEFAULT '1',
  KEY `mail_id` (`mail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_attachments_download`
--

CREATE TABLE `rc_mails_attachments_download` (
  `mail_id` int(11) NOT NULL,
  `hash` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `mail_id` (`mail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_callback`
--

CREATE TABLE `rc_mails_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_mails_callback`
--

INSERT INTO `rc_mails_callback` VALUES
('Subject', 'CRM_MailCommon::display_subject', 1),
('Contacts', 'CRM_ContactsCommon::display_company_contact', 1),
('Employee', 'CRM_ContactsCommon::display_contact', 1),
('Employee', 'CRM_ContactsCommon::QFfield_contact', 0),
('Related', 'CRM_MailCommon::QFfield_related', 0),
('Attachments', 'CRM_MailCommon::display_attachments', 1),
('Attachments', 'CRM_MailCommon::QFfield_attachments', 0),
('Body', 'CRM_MailCommon::QFfield_body', 0),
('Thread', 'CRM_MailCommon::display_mail_thread', 1),
('Thread', 'CRM_MailCommon::QFfield_mail_thread', 0),
('Message ID', 'CRM_MailCommon::QFfield_hidden', 0),
('References', 'CRM_MailCommon::QFfield_hidden', 0);

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_data_1`
--

CREATE TABLE `rc_mails_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_subject` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_contacts` text COLLATE utf8_unicode_ci,
  `f_employee` int(11) DEFAULT NULL,
  `f_related` text COLLATE utf8_unicode_ci,
  `f_date` datetime DEFAULT NULL,
  `f_headers_data` text COLLATE utf8_unicode_ci,
  `f_body` text COLLATE utf8_unicode_ci,
  `f_from` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_to` varchar(4096) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_thread` int(11) DEFAULT NULL,
  `f_message_id` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_references` varchar(16384) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rc_mails_idxed` (`indexed`,`active`),
  KEY `rc_mails_act` (`active`),
  KEY `rc_mails_thread_idx` (`f_thread`),
  KEY `rc_mails_msgid_idx` (`f_message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_edit_history`
--

CREATE TABLE `rc_mails_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_mails_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `rc_mails_id` (`rc_mails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_edit_history_data`
--

CREATE TABLE `rc_mails_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_favorite`
--

CREATE TABLE `rc_mails_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_mails_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_mails_id` (`rc_mails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_field`
--

CREATE TABLE `rc_mails_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=16 ;

--
-- Dumping data for table `rc_mails_field`
--

INSERT INTO `rc_mails_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Subject', '', 'text', 0, 1, 1, 0, 1, 1, 3, 3, 0, '256', '', '', ''),
(4, 'Contacts', '', 'multiselect', 0, 1, 1, 0, 1, 1, 4, 4, 0, 'company,contact::;::;CRM_ContactsCommon::crm_company_contact_select_list_options', '', '', ''),
(5, 'Employee', '', 'select', 0, 1, 1, 0, 1, 1, 5, 5, 0, 'contact::Last Name|First Name;::;::', '', '', ''),
(6, 'Related', '', 'multiselect', 0, 1, 1, 0, 1, 1, 6, 6, 0, '__RECORDSETS__::;CRM_MailCommon::related_crits', '', '', ''),
(7, 'Date', '', 'timestamp', 0, 1, 1, 0, 1, 1, 7, 7, 0, '', 'timestamp', '', ''),
(8, 'Attachments', '', 'calculated', 0, 1, 1, 0, 1, 1, 8, 8, 0, '', '', '', ''),
(9, 'Headers Data', '', 'long text', 0, 0, 0, 0, 1, 1, 9, 9, 0, '', '', '', ''),
(10, 'Body', '', 'long text', 0, 0, 0, 0, 1, 1, 10, 10, 0, '', '', '', ''),
(11, 'From', '', 'text', 0, 0, 0, 0, 1, 1, 11, 11, 0, '128', '', '', ''),
(12, 'To', '', 'text', 0, 0, 0, 0, 1, 1, 12, 12, 0, '4096', '', '', ''),
(13, 'Thread', '', 'select', 0, 0, 0, 0, 1, 1, 13, 13, 0, 'rc_mail_threads::Count', '', '', ''),
(14, 'Message ID', '', 'text', 0, 0, 0, 0, 1, 1, 14, 14, 0, '128', '', '', ''),
(15, 'References', '', 'text', 0, 0, 0, 0, 1, 1, 15, 15, 0, '16384', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mails_recent`
--

CREATE TABLE `rc_mails_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_mails_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_mails_id` (`rc_mails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_access`
--

CREATE TABLE `rc_mail_threads_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `rc_mail_threads_access`
--

INSERT INTO `rc_mail_threads_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_access_clearance`
--

CREATE TABLE `rc_mail_threads_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_mail_threads_access_clearance`
--

INSERT INTO `rc_mail_threads_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_access_fields`
--

CREATE TABLE `rc_mail_threads_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_callback`
--

CREATE TABLE `rc_mail_threads_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_mail_threads_callback`
--

INSERT INTO `rc_mail_threads_callback` VALUES
('Subject', 'CRM_MailCommon::display_subject', 1),
('Count', 'CRM_MailCommon::display_thread_count', 1),
('Count', 'CRM_MailCommon::QFfield_thread_count', 0),
('Contacts', 'CRM_ContactsCommon::display_company_contact', 1),
('Attachments', 'CRM_MailCommon::display_thread_attachments', 1),
('Attachments', 'CRM_MailCommon::QFfield_thread_attachments', 0);

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_data_1`
--

CREATE TABLE `rc_mail_threads_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_subject` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_contacts` text COLLATE utf8_unicode_ci,
  `f_first_date` datetime DEFAULT NULL,
  `f_last_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rc_mail_threads_idxed` (`indexed`,`active`),
  KEY `rc_mail_threads_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_edit_history`
--

CREATE TABLE `rc_mail_threads_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_mail_threads_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `rc_mail_threads_id` (`rc_mail_threads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_edit_history_data`
--

CREATE TABLE `rc_mail_threads_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_favorite`
--

CREATE TABLE `rc_mail_threads_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_mail_threads_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_mail_threads_id` (`rc_mail_threads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_field`
--

CREATE TABLE `rc_mail_threads_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `rc_mail_threads_field`
--

INSERT INTO `rc_mail_threads_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Subject', '', 'text', 0, 1, 1, 0, 1, 1, 3, 3, 0, '256', '', '', ''),
(4, 'Count', '', 'calculated', 0, 1, 1, 0, 1, 1, 4, 4, 0, '', '', '', ''),
(5, 'Contacts', '', 'multiselect', 0, 1, 1, 0, 1, 1, 5, 5, 0, 'company,contact::;::;CRM_ContactsCommon::crm_company_contact_select_list_options', '', '', ''),
(6, 'First Date', '', 'timestamp', 0, 1, 1, 0, 1, 1, 6, 6, 0, '', 'timestamp', '', ''),
(7, 'Last Date', '', 'timestamp', 0, 1, 1, 0, 1, 1, 7, 7, 0, '', 'timestamp', '', ''),
(8, 'Attachments', '', 'calculated', 0, 1, 1, 0, 1, 1, 8, 8, 0, '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `rc_mail_threads_recent`
--

CREATE TABLE `rc_mail_threads_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_mail_threads_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_mail_threads_id` (`rc_mail_threads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_access`
--

CREATE TABLE `rc_multiple_emails_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `rc_multiple_emails_access`
--

INSERT INTO `rc_multiple_emails_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:0:{}'),
(6, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_access_clearance`
--

CREATE TABLE `rc_multiple_emails_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_multiple_emails_access_clearance`
--

INSERT INTO `rc_multiple_emails_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee'),
(6, 'ACCESS:employee');

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_access_fields`
--

CREATE TABLE `rc_multiple_emails_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_callback`
--

CREATE TABLE `rc_multiple_emails_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_multiple_emails_callback`
--

INSERT INTO `rc_multiple_emails_callback` VALUES
('Nickname', 'CRM_MailCommon::QFfield_nickname', 0),
('Email', 'CRM_ContactsCommon::display_email', 1),
('Email', 'CRM_ContactsCommon::QFfield_unique_email', 0);

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_data_1`
--

CREATE TABLE `rc_multiple_emails_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_record_type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_record_id` int(11) DEFAULT NULL,
  `f_nickname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rc_multiple_emails_idxed` (`indexed`,`active`),
  KEY `rc_multiple_emails_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_edit_history`
--

CREATE TABLE `rc_multiple_emails_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_multiple_emails_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `rc_multiple_emails_id` (`rc_multiple_emails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_edit_history_data`
--

CREATE TABLE `rc_multiple_emails_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_favorite`
--

CREATE TABLE `rc_multiple_emails_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_multiple_emails_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_multiple_emails_id` (`rc_multiple_emails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_field`
--

CREATE TABLE `rc_multiple_emails_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `rc_multiple_emails_field`
--

INSERT INTO `rc_multiple_emails_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Record Type', '', 'hidden', 0, 0, 0, 0, 1, 1, 3, 3, 1, 'VARCHAR(64)', '', '', ''),
(4, 'Record ID', '', 'hidden', 0, 0, 0, 0, 1, 1, 4, 4, 0, 'INTEGER', '', '', ''),
(5, 'Nickname', '', 'text', 0, 1, 1, 1, 1, 1, 5, 5, 0, '64', '', '', ''),
(6, 'Email', '', 'text', 0, 1, 1, 1, 1, 1, 6, 6, 0, '128', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `rc_multiple_emails_recent`
--

CREATE TABLE `rc_multiple_emails_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_multiple_emails_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_multiple_emails_id` (`rc_multiple_emails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_access`
--

CREATE TABLE `rc_related_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `rc_related_access`
--

INSERT INTO `rc_related_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:0:{}'),
(6, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_access_clearance`
--

CREATE TABLE `rc_related_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_related_access_clearance`
--

INSERT INTO `rc_related_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ADMIN'),
(5, 'SUPERADMIN'),
(6, 'SUPERADMIN');

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_access_fields`
--

CREATE TABLE `rc_related_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_callback`
--

CREATE TABLE `rc_related_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_related_callback`
--

INSERT INTO `rc_related_callback` VALUES
('Recordset', 'CRM_MailCommon::display_recordset', 1),
('Recordset', 'CRM_MailCommon::QFfield_recordset', 0);

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_data_1`
--

CREATE TABLE `rc_related_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_recordset` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rc_related_idxed` (`indexed`,`active`),
  KEY `rc_related_act` (`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `rc_related_data_1`
--

INSERT INTO `rc_related_data_1` VALUES
(1, '[[regtime]]', 1, 0, 1, 'company'),
(2, '[[regtime]]', 1, 0, 1, 'contact');

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_edit_history`
--

CREATE TABLE `rc_related_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_related_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `rc_related_id` (`rc_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_edit_history_data`
--

CREATE TABLE `rc_related_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_favorite`
--

CREATE TABLE `rc_related_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_related_id` (`rc_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_field`
--

CREATE TABLE `rc_related_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `rc_related_field`
--

INSERT INTO `rc_related_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Recordset', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '64', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `rc_related_recent`
--

CREATE TABLE `rc_related_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `rc_related_id` (`rc_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_searches`
--

CREATE TABLE `rc_searches` (
  `search_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` int(3) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`search_id`),
  UNIQUE KEY `uniqueness` (`user_id`,`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rc_session`
--

CREATE TABLE `rc_session` (
  `sess_id` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `vars` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`sess_id`),
  KEY `changed_index` (`changed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rc_system`
--

CREATE TABLE `rc_system` (
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `rc_system`
--

INSERT INTO `rc_system` VALUES
('roundcube-version', '2015030800');

-- --------------------------------------------------------

--
-- Table structure for table `rc_users`
--

CREATE TABLE `rc_users` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `mail_host` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `last_login` datetime DEFAULT NULL,
  `failed_login` datetime DEFAULT NULL,
  `failed_login_counter` int(10) unsigned DEFAULT NULL,
  `language` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `preferences` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`,`mail_host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_access_methods`
--

CREATE TABLE `recordbrowser_access_methods` (
  `tab` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `func` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `priority` int(11) DEFAULT '10',
  PRIMARY KEY (`tab`,`func`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_addon`
--

CREATE TABLE `recordbrowser_addon` (
  `tab` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `func` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pos` int(11) DEFAULT NULL,
  `enabled` tinyint(4) DEFAULT NULL,
  `label` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`tab`,`module`,`func`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `recordbrowser_addon`
--

INSERT INTO `recordbrowser_addon` VALUES
('company', 'CRM_Contacts', 'company_addon', 1, 1, 'Contacts'),
('company', 'CRM_Contacts_Activities', 'company_activities', 5, 1, 'Activities'),
('company', 'CRM_Mail', 'addon', 3, 1, 'E-mails'),
('company', 'CRM_Mail', 'mail_addresses_addon', 4, 1, 'E-mail addresses'),
('company', 'Utils_Attachment', 'body', 2, 1, 'Notes'),
('contact', 'Apps_ActivityReport', 'contact_addon', 2, 1, 'Apps_ActivityReportCommon::contact_addon_label'),
('contact', 'CRM_Contacts_Activities', 'contact_activities', 5, 1, 'Activities'),
('contact', 'CRM_Mail', 'addon', 3, 1, 'E-mails'),
('contact', 'CRM_Mail', 'mail_addresses_addon', 4, 1, 'E-mail addresses'),
('contact', 'Utils_Attachment', 'body', 1, 1, 'Notes'),
('crm_meeting', 'CRM_Mail', 'addon', 3, 1, 'E-mails'),
('crm_meeting', 'CRM_Meeting', 'messanger_addon', 2, 1, 'Alerts'),
('crm_meeting', 'Utils_Attachment', 'body', 1, 1, 'Notes'),
('phonecall', 'CRM_Mail', 'addon', 3, 1, 'E-mails'),
('phonecall', 'CRM_PhoneCall', 'messanger_addon', 2, 1, 'Alerts'),
('phonecall', 'Utils_Attachment', 'body', 1, 1, 'Notes'),
('rc_mail_threads', 'CRM_Mail', 'thread_addon', 1, 1, 'E-mails'),
('rc_mails', 'CRM_Mail', 'attachments_addon', 2, 1, 'Attachments'),
('rc_mails', 'CRM_Mail', 'mail_body_addon', 1, 1, 'Body'),
('rc_mails', 'CRM_Mail', 'mail_headers_addon', 3, 1, 'Headers'),
('task', 'CRM_Mail', 'addon', 3, 1, 'E-mails'),
('task', 'CRM_Tasks', 'messanger_addon', 2, 1, 'Alerts'),
('task', 'Utils_Attachment', 'body', 1, 1, 'Notes');

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_browse_mode_definitions`
--

CREATE TABLE `recordbrowser_browse_mode_definitions` (
  `tab` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `func` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tab`,`module`,`func`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_clipboard_pattern`
--

CREATE TABLE `recordbrowser_clipboard_pattern` (
  `tab` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `pattern` text COLLATE utf8_unicode_ci,
  `enabled` int(11) DEFAULT NULL,
  PRIMARY KEY (`tab`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `recordbrowser_clipboard_pattern`
--

INSERT INTO `recordbrowser_clipboard_pattern` VALUES
('company', '%{{company_name}<BR>}\n%{{address_1}<BR>}\n%{{address_2}<BR>}\n%{%{{city} }%{{zone} }{postal_code}<BR>}\n%{{country}<BR>}\n%{tel. {phone}<BR>}\n%{fax. {fax}<BR>}\n%{{web_address}<BR>}', 1),
('contact', '%{{first_name} {last_name}<BR>}\n%{{title}<BR>}\n%{{company_name}<BR>}\n%{{address_1}<BR>}\n%{{address_2}<BR>}\n%{%{{city} }%{{zone} }{postal_code}<BR>}\n%{{country}<BR>}\n%{tel. {work_phone}<BR>}\n%{{email}<BR>}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_custom_recordsets`
--

CREATE TABLE `recordbrowser_custom_recordsets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` tinyint(4) DEFAULT NULL,
  `tab` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `menu` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_datatype`
--

CREATE TABLE `recordbrowser_datatype` (
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `func` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `recordbrowser_datatype`
--

INSERT INTO `recordbrowser_datatype` VALUES
('crm_company', 'CRM_ContactsCommon', 'crm_company_datatype'),
('crm_company_contact', 'CRM_ContactsCommon', 'crm_company_contact_datatype'),
('crm_contact', 'CRM_ContactsCommon', 'crm_contact_datatype'),
('email', 'CRM_ContactsCommon', 'email_datatype');

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_processing_methods`
--

CREATE TABLE `recordbrowser_processing_methods` (
  `tab` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `func` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tab`,`func`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `recordbrowser_processing_methods`
--

INSERT INTO `recordbrowser_processing_methods` VALUES
('company', 'CRM_ContactsCommon::submit_company'),
('contact', 'CRM_ContactsCommon::submit_contact'),
('crm_meeting', 'CRM_MeetingCommon::submit_meeting'),
('crm_meeting_related', 'CRM_MeetingCommon::processing_related'),
('phonecall', 'CRM_PhoneCallCommon::submit_phonecall'),
('phonecall_related', 'CRM_PhoneCallCommon::processing_related'),
('rc_accounts', 'CRM_MailCommon::submit_account'),
('rc_mails', 'CRM_MailCommon::submit_mail'),
('rc_related', 'CRM_MailCommon::processing_related'),
('task', 'CRM_TasksCommon::submit_task'),
('task_related', 'CRM_TasksCommon::processing_related'),
('utils_attachment', 'Utils_AttachmentCommon::submit_attachment');

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_search_index`
--

CREATE TABLE `recordbrowser_search_index` (
  `tab_id` smallint(6) NOT NULL,
  `record_id` int(11) NOT NULL,
  `field_id` smallint(6) NOT NULL,
  `text` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`tab_id`,`record_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `recordbrowser_table_properties`
--

CREATE TABLE `recordbrowser_table_properties` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `tab` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quickjump` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `tpl` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `favorites` tinyint(4) DEFAULT '0',
  `recent` smallint(6) DEFAULT '0',
  `full_history` tinyint(4) DEFAULT '1',
  `caption` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `description_callback` varchar(128) COLLATE utf8_unicode_ci DEFAULT '',
  `description_fields` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `jump_to_id` tinyint(4) DEFAULT '1',
  `search_include` tinyint(4) DEFAULT '0',
  `search_priority` tinyint(4) DEFAULT '0',
  `printer` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tab` (`tab`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `recordbrowser_table_properties`
--

INSERT INTO `recordbrowser_table_properties` VALUES
(1, 'utils_attachment', '', 'Utils/Attachment/View_entry', 0, 0, 1, 'Note', '', 'Utils_AttachmentCommon::description_callback', '', 0, 1, 0, ''),
(2, 'company', 'Company Name', '', 1, 15, 1, 'Companies', 'CRM/Contacts/companies.png', 'CRM_ContactsCommon::company_format_default', '', 1, 1, 2, ''),
(3, 'contact', 'Last Name', 'CRM/Contacts/Contact', 1, 15, 1, 'Contacts', 'CRM/Contacts/icon.png', 'CRM_ContactsCommon::contact_format_default', '', 1, 1, 2, ''),
(4, 'rc_related', '', '', 0, 0, 1, 'Mail Related Recordsets', '', '', '', 1, 0, 0, ''),
(5, 'rc_accounts', '', '', 0, 0, 1, 'Mail accounts', '', '', '', 1, 0, 0, ''),
(6, 'rc_mail_threads', '', '', 0, 0, 1, 'Mail Thread', '', '', '', 1, 2, -1, ''),
(7, 'rc_mails', '', 'CRM/Mail/mails', 0, 0, 1, 'Mails', '', '', '', 1, 2, -1, ''),
(8, 'rc_multiple_emails', '', '', 1, 0, 1, 'Mail addresses', 'CRM/Mail/icon.png', '', '', 1, 2, 0, ''),
(9, 'phonecall_related', '', '', 0, 0, 1, 'Phonecalls Related Recordsets', '', '', '', 1, 0, 0, ''),
(10, 'phonecall', '', 'CRM/PhoneCall/default', 0, 5, 1, 'Phonecalls', 'CRM/PhoneCall/icon.png', '', '', 1, 2, 0, ''),
(11, 'task_related', '', '', 0, 0, 1, 'Tasks Related Recordsets', '', '', '', 1, 0, 0, ''),
(12, 'task', '', '', 0, 5, 1, 'Tasks', 'CRM/Tasks/icon.png', '', '', 1, 2, 0, ''),
(13, 'crm_meeting_related', '', '', 0, 0, 1, 'Meeting Related Recordsets', '', '', '', 1, 0, 0, ''),
(14, 'crm_meeting', '', 'CRM/Meeting/default', 0, 10, 1, 'Meetings', 'CRM/Meeting/icon.png', '', '', 1, 2, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `session`
--

CREATE TABLE `session` (
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `expires` int(11) NOT NULL DEFAULT '0',
  `data` longblob,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `session`
--

-- --------------------------------------------------------

--
-- Table structure for table `session_client`
--

CREATE TABLE `session_client` (
  `session_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `client_id` smallint(6) NOT NULL DEFAULT '0',
  `data` longblob,
  PRIMARY KEY (`client_id`,`session_name`),
  KEY `session_name` (`session_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `task_access`
--

CREATE TABLE `task_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `task_access`
--

INSERT INTO `task_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:2:{s:12:"(!permission";i:2;s:10:"|employees";s:4:"USER";}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:3:{s:11:"(permission";i:0;s:10:"|employees";s:4:"USER";s:10:"|customers";s:4:"USER";}'),
(6, 'delete', 'a:1:{s:11:":Created_by";s:7:"USER_ID";}'),
(7, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `task_access_clearance`
--

CREATE TABLE `task_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `task_access_clearance`
--

INSERT INTO `task_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee'),
(6, 'ACCESS:employee'),
(7, 'ACCESS:employee'),
(7, 'ACCESS:manager');

-- --------------------------------------------------------

--
-- Table structure for table `task_access_fields`
--

CREATE TABLE `task_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `task_callback`
--

CREATE TABLE `task_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `task_callback`
--

INSERT INTO `task_callback` VALUES
('Title', 'CRM_TasksCommon::display_title', 1),
('Employees', 'CRM_TasksCommon::display_employees', 1),
('Employees', 'CRM_ContactsCommon::QFfield_contact', 0),
('Customers', 'CRM_ContactsCommon::display_company_contact', 1),
('Status', 'CRM_TasksCommon::display_status', 1),
('Deadline', 'CRM_TasksCommon::display_deadline', 1),
('Timeless', 'CRM_TasksCommon::QFfield_timeless', 0),
('Related', 'CRM_TasksCommon::QFfield_related', 0);

-- --------------------------------------------------------

--
-- Table structure for table `task_data_1`
--

CREATE TABLE `task_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_description` text COLLATE utf8_unicode_ci,
  `f_employees` text COLLATE utf8_unicode_ci,
  `f_customers` text COLLATE utf8_unicode_ci,
  `f_status` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_priority` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_permission` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_longterm` tinyint(4) DEFAULT NULL,
  `f_deadline` datetime DEFAULT NULL,
  `f_timeless` tinyint(4) DEFAULT NULL,
  `f_related` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `task_idxed` (`indexed`,`active`),
  KEY `task_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_edit_history`
--

CREATE TABLE `task_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_edit_history_data`
--

CREATE TABLE `task_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `task_favorite`
--

CREATE TABLE `task_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_field`
--

CREATE TABLE `task_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=14 ;

--
-- Dumping data for table `task_field`
--

INSERT INTO `task_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Title', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '255', '', '', ''),
(4, 'Description', '', 'long text', 0, 0, 0, 0, 1, 1, 4, 4, 0, '255', '', '', ''),
(5, 'Employees', '', 'multiselect', 0, 1, 1, 1, 1, 1, 5, 5, 1, 'contact::Last Name|First Name;CRM_ContactsCommon::contact_format_no_company;CRM_TasksCommon::employees_crits', '', '', ''),
(6, 'Customers', '', 'multiselect', 0, 1, 1, 0, 1, 1, 6, 6, 0, 'company,contact::;CRM_TasksCommon::customers_crits;CRM_ContactsCommon::crm_company_contact_select_list_options', '', '', ''),
(7, 'Status', '', 'commondata', 0, 1, 1, 1, 1, 1, 7, 7, 1, 'key__CRM/Status', '', '', ''),
(8, 'Priority', '', 'commondata', 0, 1, 1, 1, 1, 1, 8, 8, 1, 'key__CRM/Priority', '', '', ''),
(9, 'Permission', '', 'commondata', 0, 0, 0, 1, 1, 1, 9, 9, 0, 'key__CRM/Access', '', '', ''),
(10, 'Longterm', '', 'checkbox', 0, 1, 1, 0, 1, 1, 10, 10, 1, '', '', '', ''),
(11, 'Deadline', '', 'timestamp', 0, 1, 1, 0, 1, 1, 11, 11, 0, '', 'timestamp', '', ''),
(12, 'Timeless', '', 'checkbox', 0, 0, 0, 0, 1, 1, 12, 12, 0, '', '', '', ''),
(13, 'Related', '', 'multiselect', 0, 1, 1, 0, 1, 1, 13, 13, 0, '__RECORDSETS__::;CRM_TasksCommon::related_crits', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `task_recent`
--

CREATE TABLE `task_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_related_access`
--

CREATE TABLE `task_related_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `task_related_access`
--

INSERT INTO `task_related_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:0:{}'),
(4, 'add', 'a:0:{}'),
(5, 'edit', 'a:0:{}'),
(6, 'delete', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `task_related_access_clearance`
--

CREATE TABLE `task_related_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `task_related_access_clearance`
--

INSERT INTO `task_related_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ADMIN'),
(5, 'SUPERADMIN'),
(6, 'SUPERADMIN');

-- --------------------------------------------------------

--
-- Table structure for table `task_related_access_fields`
--

CREATE TABLE `task_related_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `task_related_callback`
--

CREATE TABLE `task_related_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `task_related_callback`
--

INSERT INTO `task_related_callback` VALUES
('Recordset', 'CRM_TasksCommon::display_recordset', 1),
('Recordset', 'CRM_TasksCommon::QFfield_recordset', 0);

-- --------------------------------------------------------

--
-- Table structure for table `task_related_data_1`
--

CREATE TABLE `task_related_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_recordset` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_related_idxed` (`indexed`,`active`),
  KEY `task_related_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_related_edit_history`
--

CREATE TABLE `task_related_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_related_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `task_related_id` (`task_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_related_edit_history_data`
--

CREATE TABLE `task_related_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `task_related_favorite`
--

CREATE TABLE `task_related_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `task_related_id` (`task_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_related_field`
--

CREATE TABLE `task_related_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `task_related_field`
--

INSERT INTO `task_related_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Recordset', '', 'text', 0, 1, 1, 1, 1, 1, 3, 3, 0, '64', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `task_related_recent`
--

CREATE TABLE `task_related_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `task_related_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `task_related_id` (`task_related_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tools_whoisonline_users`
--

CREATE TABLE `tools_whoisonline_users` (
  `session_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `user_login_id` int(11) NOT NULL,
  PRIMARY KEY (`session_name`),
  KEY `user_login_id` (`user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `tools_whoisonline_users`
--

-- --------------------------------------------------------

--
-- Table structure for table `user_autologin`
--

CREATE TABLE `user_autologin` (
  `user_login_id` int(11) NOT NULL,
  `autologin_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `last_log` datetime DEFAULT NULL,
  `description` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `user_login_id` (`user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_login`
--

CREATE TABLE `user_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `admin` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_login`
--

INSERT INTO `user_login` VALUES
(1, '[[admin_username]]', 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `user_login_ban`
--

CREATE TABLE `user_login_ban` (
  `failed_on` int(11) DEFAULT NULL,
  `from_addr` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_password`
--

CREATE TABLE `user_password` (
  `user_login_id` int(11) NOT NULL,
  `password` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `mail` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `user_password`
--

INSERT INTO `user_password` VALUES
(1, '[[admin_pass]]', '[[admin_email]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_reset_pass`
--

CREATE TABLE `user_reset_pass` (
  `user_login_id` int(11) NOT NULL,
  `hash_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `created_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `user_login_id` (`user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_access`
--

CREATE TABLE `utils_attachment_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crits` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `utils_attachment_access`
--

INSERT INTO `utils_attachment_access` VALUES
(1, 'print', 'a:0:{}'),
(2, 'export', 'a:0:{}'),
(3, 'view', 'a:2:{s:12:"(!permission";i:2;s:12:"|:Created_by";s:7:"USER_ID";}'),
(4, 'delete', 'a:1:{s:11:":Created_by";s:7:"USER_ID";}'),
(5, 'delete', 'a:0:{}'),
(6, 'add', 'a:0:{}'),
(7, 'edit', 'a:2:{s:11:"(permission";i:0;s:12:"|:Created_by";s:7:"USER_ID";}');

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_access_clearance`
--

CREATE TABLE `utils_attachment_access_clearance` (
  `rule_id` int(11) DEFAULT NULL,
  `clearance` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utils_attachment_access_clearance`
--

INSERT INTO `utils_attachment_access_clearance` VALUES
(1, 'SUPERADMIN'),
(2, 'SUPERADMIN'),
(3, 'ACCESS:employee'),
(4, 'ACCESS:employee'),
(5, 'ACCESS:employee'),
(5, 'ACCESS:manager'),
(6, 'ACCESS:employee'),
(7, 'ACCESS:employee');

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_access_fields`
--

CREATE TABLE `utils_attachment_access_fields` (
  `rule_id` int(11) DEFAULT NULL,
  `block_field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utils_attachment_access_fields`
--

INSERT INTO `utils_attachment_access_fields` VALUES
(6, 'edited_on'),
(7, 'edited_on');

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_callback`
--

CREATE TABLE `utils_attachment_callback` (
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `freezed` tinyint(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utils_attachment_callback`
--

INSERT INTO `utils_attachment_callback` VALUES
('Edited on', 'Utils_AttachmentCommon::display_date', 1),
('Edited on', 'Utils_AttachmentCommon::QFfield_date', 0),
('Note', 'Utils_AttachmentCommon::display_note', 1),
('Note', 'Utils_AttachmentCommon::QFfield_note', 0),
('Files', 'Utils_AttachmentCommon::QFfield_files', 0),
('Crypted', 'Utils_AttachmentCommon::QFfield_crypted', 0);

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_data_1`
--

CREATE TABLE `utils_attachment_data_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `indexed` tinyint(4) DEFAULT '0',
  `active` tinyint(4) DEFAULT '1',
  `f_edited_on` datetime DEFAULT NULL,
  `f_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_note` text COLLATE utf8_unicode_ci,
  `f_files` text COLLATE utf8_unicode_ci,
  `f_permission` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_sticky` tinyint(4) DEFAULT NULL,
  `f_crypted` tinyint(4) DEFAULT NULL,
  `f_attached_to` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `utils_attachment_idxed` (`indexed`,`active`),
  KEY `utils_attachment_act` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_edit_history`
--

CREATE TABLE `utils_attachment_edit_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `utils_attachment_id` int(11) DEFAULT NULL,
  `edited_on` datetime DEFAULT NULL,
  `edited_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `edited_by` (`edited_by`),
  KEY `utils_attachment_id` (`utils_attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_edit_history_data`
--

CREATE TABLE `utils_attachment_edit_history_data` (
  `edit_id` int(11) DEFAULT NULL,
  `field` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  KEY `edit_id` (`edit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_favorite`
--

CREATE TABLE `utils_attachment_favorite` (
  `fav_id` int(11) NOT NULL AUTO_INCREMENT,
  `utils_attachment_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`fav_id`),
  KEY `user_id` (`user_id`),
  KEY `utils_attachment_id` (`utils_attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_field`
--

CREATE TABLE `utils_attachment_field` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `field` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra` tinyint(4) DEFAULT '1',
  `visible` tinyint(4) DEFAULT '1',
  `tooltip` tinyint(4) DEFAULT '1',
  `required` tinyint(4) DEFAULT '1',
  `export` tinyint(4) DEFAULT '1',
  `active` tinyint(4) DEFAULT '1',
  `position` smallint(6) DEFAULT NULL,
  `processing_order` smallint(6) NOT NULL,
  `filter` tinyint(4) DEFAULT '0',
  `param` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `utils_attachment_field`
--

INSERT INTO `utils_attachment_field` VALUES
(1, 'id', NULL, 'foreign index', 0, 0, 1, 1, 1, 1, 1, 1, 0, NULL, NULL, NULL, NULL),
(2, 'General', NULL, 'page_split', 0, 1, 1, 1, 1, 1, 2, 2, 0, NULL, NULL, NULL, NULL),
(3, 'Edited on', '', 'timestamp', 0, 1, 1, 0, 1, 1, 3, 3, 0, '', 'timestamp', '', ''),
(4, 'Title', '', 'text', 0, 0, 0, 0, 1, 1, 4, 4, 0, '255', '', '', ''),
(5, 'Note', '', 'long text', 0, 1, 1, 0, 1, 1, 5, 5, 0, '', '', '', ''),
(6, 'Files', '', 'file', 0, 0, 0, 0, 1, 1, 6, 6, 0, '', '', '', ''),
(7, 'Permission', '', 'commondata', 0, 0, 0, 1, 1, 1, 7, 7, 0, 'key__CRM/Access', '', '', ''),
(8, 'Sticky', '', 'checkbox', 0, 1, 1, 0, 1, 1, 8, 8, 0, '', '', '', ''),
(9, 'Crypted', '', 'checkbox', 0, 0, 0, 0, 1, 1, 9, 9, 0, '', '', '', ''),
(10, 'Attached to', '', 'multiselect', 0, 0, 0, 0, 1, 1, 10, 10, 0, '__RECORDSETS__::;', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `utils_attachment_recent`
--

CREATE TABLE `utils_attachment_recent` (
  `recent_id` int(11) NOT NULL AUTO_INCREMENT,
  `utils_attachment_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `visited_on` datetime DEFAULT NULL,
  PRIMARY KEY (`recent_id`),
  KEY `user_id` (`user_id`),
  KEY `utils_attachment_id` (`utils_attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_bbcode`
--

CREATE TABLE `utils_bbcode` (
  `code` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `func` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utils_bbcode`
--

INSERT INTO `utils_bbcode` VALUES
('b', 'Utils_BBCodeCommon::tag_b'),
('color', 'Utils_BBCodeCommon::tag_color'),
('company', 'CRM_ContactsCommon::company_bbcode'),
('contact', 'CRM_ContactsCommon::contact_bbcode'),
('i', 'Utils_BBCodeCommon::tag_i'),
('img', 'Utils_BBCodeCommon::tag_img'),
('meeting', 'CRM_MeetingCommon::meeting_bbcode'),
('phone', 'CRM_PhoneCallCommon::phone_bbcode'),
('s', 'Utils_BBCodeCommon::tag_s'),
('task', 'CRM_TasksCommon::task_bbcode'),
('u', 'Utils_BBCodeCommon::tag_u'),
('url', 'Utils_BBCodeCommon::tag_url');

-- --------------------------------------------------------

--
-- Table structure for table `utils_commondata_tree`
--

CREATE TABLE `utils_commondata_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '-1',
  `akey` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `readonly` tinyint(4) DEFAULT '0',
  `position` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `parent_id` (`parent_id`,`akey`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=678 ;

--
-- Dumping data for table `utils_commondata_tree`
--

INSERT INTO `utils_commondata_tree` VALUES
(1, -1, 'Calling_Codes', NULL, 1, 1),
(2, 1, 'US', '+1', 0, 1),
(3, 1, 'CA', '+1', 0, 2),
(4, 1, 'BS', '+1242', 0, 3),
(5, 1, 'BB', '+1246', 0, 4),
(6, 1, 'AI', '+1264', 0, 5),
(7, 1, 'AG', '+1268', 0, 6),
(8, 1, 'VG', '+1284', 0, 7),
(9, 1, 'VI', '+1340', 0, 8),
(10, 1, 'KY', '+1345', 0, 9),
(11, 1, 'BM', '+1441', 0, 10),
(12, 1, 'GD', '+1473', 0, 11),
(13, 1, 'TC', '+1649', 0, 12),
(14, 1, 'MS', '+1664', 0, 13),
(15, 1, 'MP', '+1670', 0, 14),
(16, 1, 'GU', '+1671', 0, 15),
(17, 1, 'AS', '+1684', 0, 16),
(18, 1, 'LC', '+1758', 0, 17),
(19, 1, 'DM', '+1767', 0, 18),
(20, 1, 'VC', '+1784', 0, 19),
(21, 1, 'PR', '+1787', 0, 20),
(22, 1, 'DO', '+1809', 0, 21),
(23, 1, 'TT', '+1868', 0, 22),
(24, 1, 'KN', '+1869', 0, 23),
(25, 1, 'JM', '+1876', 0, 24),
(26, 1, 'EG', '+20', 0, 25),
(27, 1, 'MA', '+212', 0, 26),
(28, 1, 'EH', '+212', 0, 27),
(29, 1, 'DZ', '+213', 0, 28),
(30, 1, 'TN', '+216', 0, 29),
(31, 1, 'LY', '+218', 0, 30),
(32, 1, 'GM', '+220', 0, 31),
(33, 1, 'SN', '+221', 0, 32),
(34, 1, 'MR', '+222', 0, 33),
(35, 1, 'ML', '+223', 0, 34),
(36, 1, 'GN', '+224', 0, 35),
(37, 1, 'CI', '+225', 0, 36),
(38, 1, 'BF', '+226', 0, 37),
(39, 1, 'NE', '+227', 0, 38),
(40, 1, 'TG', '+228', 0, 39),
(41, 1, 'BJ', '+229', 0, 40),
(42, 1, 'MU', '+230', 0, 41),
(43, 1, 'LR', '+231', 0, 42),
(44, 1, 'SL', '+232', 0, 43),
(45, 1, 'GH', '+233', 0, 44),
(46, 1, 'NG', '+234', 0, 45),
(47, 1, 'TD', '+235', 0, 46),
(48, 1, 'CF', '+236', 0, 47),
(49, 1, 'CM', '+237', 0, 48),
(50, 1, 'CV', '+238', 0, 49),
(51, 1, 'ST', '+239', 0, 50),
(52, 1, 'GQ', '+240', 0, 51),
(53, 1, 'GA', '+241', 0, 52),
(54, 1, 'CG', '+242', 0, 53),
(55, 1, 'CD', '+243', 0, 54),
(56, 1, 'AO', '+244', 0, 55),
(57, 1, 'GW', '+245', 0, 56),
(58, 1, 'IO', '+246', 0, 57),
(59, 1, 'AC', '+247', 0, 58),
(60, 1, 'SC', '+248', 0, 59),
(61, 1, 'SD', '+249', 0, 60),
(62, 1, 'RW', '+250', 0, 61),
(63, 1, 'ET', '+251', 0, 62),
(64, 1, 'SO', '+252', 0, 63),
(65, 1, 'QS', '+252', 0, 64),
(66, 1, 'DJ', '+253', 0, 65),
(67, 1, 'KE', '+254', 0, 66),
(68, 1, 'TZ', '+255', 0, 67),
(69, 1, 'UG', '+256', 0, 68),
(70, 1, 'BI', '+257', 0, 69),
(71, 1, 'MZ', '+258', 0, 70),
(72, 1, 'ZM', '+260', 0, 71),
(73, 1, 'MG', '+261', 0, 72),
(74, 1, 'RE', '+262', 0, 73),
(75, 1, 'YT', '+262', 0, 74),
(76, 1, 'ZW', '+263', 0, 75),
(77, 1, 'NA', '+264', 0, 76),
(78, 1, 'MW', '+265', 0, 77),
(79, 1, 'LS', '+266', 0, 78),
(80, 1, 'BW', '+267', 0, 79),
(81, 1, 'SZ', '+268', 0, 80),
(82, 1, 'KM', '+269', 0, 81),
(83, 1, 'ZA', '+27', 0, 82),
(84, 1, 'SH', '+290', 0, 83),
(85, 1, 'TA', '+290', 0, 84),
(86, 1, 'ER', '+291', 0, 85),
(87, 1, 'AW', '+297', 0, 86),
(88, 1, 'FO', '+298', 0, 87),
(89, 1, 'GL', '+299', 0, 88),
(90, 1, 'GR', '+30', 0, 89),
(91, 1, 'NL', '+31', 0, 90),
(92, 1, 'BE', '+32', 0, 91),
(93, 1, 'FR', '+33', 0, 92),
(94, 1, 'ES', '+34', 0, 93),
(95, 1, 'GI', '+350', 0, 94),
(96, 1, 'PT', '+351', 0, 95),
(97, 1, 'LU', '+352', 0, 96),
(98, 1, 'IE', '+353', 0, 97),
(99, 1, 'IS', '+354', 0, 98),
(100, 1, 'AL', '+355', 0, 99),
(101, 1, 'MT', '+356', 0, 100),
(102, 1, 'CY', '+357', 0, 101),
(103, 1, 'FI', '+358', 0, 102),
(104, 1, 'AX', '+358', 0, 103),
(105, 1, 'BG', '+359', 0, 104),
(106, 1, 'HU', '+36', 0, 105),
(107, 1, 'LT', '+370', 0, 106),
(108, 1, 'LV', '+371', 0, 107),
(109, 1, 'EE', '+372', 0, 108),
(110, 1, 'MD', '+373', 0, 109),
(111, 1, 'AM', '+374', 0, 110),
(112, 1, 'BY', '+375', 0, 111),
(113, 1, 'AD', '+376', 0, 112),
(114, 1, 'MC', '+377', 0, 113),
(115, 1, 'SM', '+378', 0, 114),
(116, 1, 'UA', '+380', 0, 115),
(117, 1, 'RS', '+381', 0, 116),
(118, 1, 'ME', '+382', 0, 117),
(119, 1, 'HR', '+385', 0, 118),
(120, 1, 'SI', '+386', 0, 119),
(121, 1, 'BA', '+387', 0, 120),
(122, 1, 'EU', '+388', 0, 121),
(123, 1, 'MK', '+389', 0, 122),
(124, 1, 'IT', '+39', 0, 123),
(125, 1, 'VA', '+39', 0, 124),
(126, 1, 'RO', '+40', 0, 125),
(127, 1, 'CH', '+41', 0, 126),
(128, 1, 'CZ', '+420', 0, 127),
(129, 1, 'SK', '+421', 0, 128),
(130, 1, 'LI', '+423', 0, 129),
(131, 1, 'AT', '+43', 0, 130),
(132, 1, 'GB', '+44', 0, 131),
(133, 1, 'GG', '+44', 0, 132),
(134, 1, 'IM', '+44', 0, 133),
(135, 1, 'JE', '+44', 0, 134),
(136, 1, 'DK', '+45', 0, 135),
(137, 1, 'SE', '+46', 0, 136),
(138, 1, 'NO', '+47', 0, 137),
(139, 1, 'SJ', '+47', 0, 138),
(140, 1, 'PL', '+48', 0, 139),
(141, 1, 'DE', '+49', 0, 140),
(142, 1, 'FK', '+500', 0, 141),
(143, 1, 'BZ', '+501', 0, 142),
(144, 1, 'GT', '+502', 0, 143),
(145, 1, 'SV', '+503', 0, 144),
(146, 1, 'HN', '+504', 0, 145),
(147, 1, 'NI', '+505', 0, 146),
(148, 1, 'CR', '+506', 0, 147),
(149, 1, 'PA', '+507', 0, 148),
(150, 1, 'PM', '+508', 0, 149),
(151, 1, 'HT', '+509', 0, 150),
(152, 1, 'PE', '+51', 0, 151),
(153, 1, 'MX', '+52', 0, 152),
(154, 1, 'CU', '+53', 0, 153),
(155, 1, 'AR', '+54', 0, 154),
(156, 1, 'BR', '+55', 0, 155),
(157, 1, 'CL', '+56', 0, 156),
(158, 1, 'CO', '+57', 0, 157),
(159, 1, 'VE', '+58', 0, 158),
(160, 1, 'GP', '+590', 0, 159),
(161, 1, 'BL', '+590', 0, 160),
(162, 1, 'MF', '+590', 0, 161),
(163, 1, 'BO', '+591', 0, 162),
(164, 1, 'GY', '+592', 0, 163),
(165, 1, 'EC', '+593', 0, 164),
(166, 1, 'GF', '+594', 0, 165),
(167, 1, 'PY', '+595', 0, 166),
(168, 1, 'MQ', '+596', 0, 167),
(169, 1, 'SR', '+597', 0, 168),
(170, 1, 'UY', '+598', 0, 169),
(171, 1, 'AN', '+599', 0, 170),
(172, 1, 'MY', '+60', 0, 171),
(173, 1, 'AU', '+61', 0, 172),
(174, 1, 'CX', '+61', 0, 173),
(175, 1, 'CC', '+61', 0, 174),
(176, 1, 'ID', '+62', 0, 175),
(177, 1, 'PH', '+63', 0, 176),
(178, 1, 'NZ', '+64', 0, 177),
(179, 1, 'SG', '+65', 0, 178),
(180, 1, 'TH', '+66', 0, 179),
(181, 1, 'TL', '+670', 0, 180),
(182, 1, 'NF', '+672', 0, 181),
(183, 1, 'AQ', '+672', 0, 182),
(184, 1, 'BN', '+673', 0, 183),
(185, 1, 'NR', '+674', 0, 184),
(186, 1, 'PG', '+675', 0, 185),
(187, 1, 'TO', '+676', 0, 186),
(188, 1, 'SB', '+677', 0, 187),
(189, 1, 'VU', '+678', 0, 188),
(190, 1, 'FJ', '+679', 0, 189),
(191, 1, 'PW', '+680', 0, 190),
(192, 1, 'WF', '+681', 0, 191),
(193, 1, 'CK', '+682', 0, 192),
(194, 1, 'NU', '+683', 0, 193),
(195, 1, 'WS', '+685', 0, 194),
(196, 1, 'KI', '+686', 0, 195),
(197, 1, 'NC', '+687', 0, 196),
(198, 1, 'TV', '+688', 0, 197),
(199, 1, 'PF', '+689', 0, 198),
(200, 1, 'TK', '+690', 0, 199),
(201, 1, 'FM', '+691', 0, 200),
(202, 1, 'MH', '+692', 0, 201),
(203, 1, 'RU', '+7', 0, 202),
(204, 1, 'KZ', '+7', 0, 203),
(205, 1, 'XT', '+800', 0, 204),
(206, 1, 'XS', '+808', 0, 205),
(207, 1, 'JP', '+81', 0, 206),
(208, 1, 'KR', '+82', 0, 207),
(209, 1, 'VN', '+84', 0, 208),
(210, 1, 'KP', '+850', 0, 209),
(211, 1, 'HK', '+852', 0, 210),
(212, 1, 'MO', '+853', 0, 211),
(213, 1, 'KH', '+855', 0, 212),
(214, 1, 'LA', '+856', 0, 213),
(215, 1, 'CN', '+86', 0, 214),
(216, 1, 'XN', '+870', 0, 215),
(217, 1, 'PN', '+872', 0, 216),
(218, 1, 'XP', '+878', 0, 217),
(219, 1, 'BD', '+880', 0, 218),
(220, 1, 'XG', '+881', 0, 219),
(221, 1, 'XV', '+882', 0, 220),
(222, 1, 'XL', '+883', 0, 221),
(223, 1, 'TW', '+886', 0, 222),
(224, 1, 'XD', '+888', 0, 223),
(225, 1, 'TR', '+90', 0, 224),
(226, 1, 'QY', '+90', 0, 225),
(227, 1, 'IN', '+91', 0, 226),
(228, 1, 'PK', '+92', 0, 227),
(229, 1, 'AF', '+93', 0, 228),
(230, 1, 'LK', '+94', 0, 229),
(231, 1, 'MM', '+95', 0, 230),
(232, 1, 'MV', '+960', 0, 231),
(233, 1, 'LB', '+961', 0, 232),
(234, 1, 'JO', '+962', 0, 233),
(235, 1, 'SY', '+963', 0, 234),
(236, 1, 'IQ', '+964', 0, 235),
(237, 1, 'KW', '+965', 0, 236),
(238, 1, 'SA', '+966', 0, 237),
(239, 1, 'YE', '+967', 0, 238),
(240, 1, 'OM', '+968', 0, 239),
(241, 1, 'PS', '+970', 0, 240),
(242, 1, 'AE', '+971', 0, 241),
(243, 1, 'IL', '+972', 0, 242),
(244, 1, 'BH', '+973', 0, 243),
(245, 1, 'QA', '+974', 0, 244),
(246, 1, 'BT', '+975', 0, 245),
(247, 1, 'MN', '+976', 0, 246),
(248, 1, 'NP', '+977', 0, 247),
(249, 1, 'XR', '+979', 0, 248),
(250, 1, 'IR', '+98', 0, 249),
(251, 1, 'XC', '+991', 0, 250),
(252, 1, 'TJ', '+992', 0, 251),
(253, 1, 'TM', '+993', 0, 252),
(254, 1, 'AZ', '+994', 0, 253),
(255, 1, 'GE', '+995', 0, 254),
(256, 1, 'KG', '+996', 0, 255),
(257, 1, 'UZ', '+998', 0, 256),
(258, -1, 'Countries', NULL, 1, 2),
(259, 258, 'AF', 'Afghanistan', 0, 1),
(260, 258, 'AL', 'Albania', 0, 2),
(261, 258, 'DZ', 'Algeria', 0, 3),
(262, 258, 'AS', 'American Samoa', 0, 4),
(263, 258, 'AD', 'Andorra', 0, 5),
(264, 258, 'AO', 'Angola', 0, 6),
(265, 258, 'AI', 'Anguilla', 0, 7),
(266, 258, 'AG', 'Antigua & Barbuda', 0, 8),
(267, 258, 'AR', 'Argentina', 0, 9),
(268, 258, 'AA', 'Armenia', 0, 10),
(269, 258, 'AW', 'Aruba', 0, 11),
(270, 258, 'AU', 'Australia', 0, 12),
(271, 258, 'AT', 'Austria', 0, 13),
(272, 258, 'AZ', 'Azerbaijan', 0, 14),
(273, 258, 'BS', 'Bahamas', 0, 15),
(274, 258, 'BH', 'Bahrain', 0, 16),
(275, 258, 'BD', 'Bangladesh', 0, 17),
(276, 258, 'BB', 'Barbados', 0, 18),
(277, 258, 'BY', 'Belarus', 0, 19),
(278, 258, 'BE', 'Belgium', 0, 20),
(279, 258, 'BZ', 'Belize', 0, 21),
(280, 258, 'BJ', 'Benin', 0, 22),
(281, 258, 'BM', 'Bermuda', 0, 23),
(282, 258, 'BT', 'Bhutan', 0, 24),
(283, 258, 'BO', 'Bolivia', 0, 25),
(284, 258, 'BL', 'Bonaire', 0, 26),
(285, 258, 'BA', 'Bosnia & Herzegovina', 0, 27),
(286, 258, 'BW', 'Botswana', 0, 28),
(287, 258, 'BR', 'Brazil', 0, 29),
(288, 258, 'BC', 'British Indian Ocean Territory', 0, 30),
(289, 258, 'BN', 'Brunei', 0, 31),
(290, 258, 'BG', 'Bulgaria', 0, 32),
(291, 258, 'BF', 'Burkina Faso', 0, 33),
(292, 258, 'BI', 'Burundi', 0, 34),
(293, 258, 'KH', 'Cambodia', 0, 35),
(294, 258, 'CM', 'Cameroon', 0, 36),
(295, 258, 'CA', 'Canada', 0, 37),
(296, 258, 'IC', 'Canary Islands', 0, 38),
(297, 258, 'CV', 'Cape Verde', 0, 39),
(298, 258, 'KY', 'Cayman Islands', 0, 40),
(299, 258, 'CF', 'Central African Republic', 0, 41),
(300, 258, 'TD', 'Chad', 0, 42),
(301, 258, 'CD', 'Channel Islands', 0, 43),
(302, 258, 'CL', 'Chile', 0, 44),
(303, 258, 'CN', 'China', 0, 45),
(304, 258, 'CI', 'Christmas Island', 0, 46),
(305, 258, 'CS', 'Cocos Islands', 0, 47),
(306, 258, 'CO', 'Colombia', 0, 48),
(307, 258, 'CC', 'Comoros', 0, 49),
(308, 258, 'CG', 'Congo', 0, 50),
(309, 258, 'CK', 'Cook Islands', 0, 51),
(310, 258, 'CR', 'Costa Rica', 0, 52),
(311, 258, 'CT', 'Cote D''Ivoire', 0, 53),
(312, 258, 'HR', 'Croatia', 0, 54),
(313, 258, 'CU', 'Cuba', 0, 55),
(314, 258, 'CB', 'Curacao', 0, 56),
(315, 258, 'CY', 'Cyprus', 0, 57),
(316, 258, 'CZ', 'Czech Republic', 0, 58),
(317, 258, 'DK', 'Denmark', 0, 59),
(318, 258, 'DJ', 'Djibouti', 0, 60),
(319, 258, 'DM', 'Dominica', 0, 61),
(320, 258, 'DO', 'Dominican Republic', 0, 62),
(321, 258, 'TM', 'East Timor', 0, 63),
(322, 258, 'EC', 'Ecuador', 0, 64),
(323, 258, 'EG', 'Egypt', 0, 65),
(324, 258, 'SV', 'El Salvador', 0, 66),
(325, 258, 'GQ', 'Equatorial Guinea', 0, 67),
(326, 258, 'ER', 'Eritrea', 0, 68),
(327, 258, 'EE', 'Estonia', 0, 69),
(328, 258, 'ET', 'Ethiopia', 0, 70),
(329, 258, 'FA', 'Falkland Islands', 0, 71),
(330, 258, 'FO', 'Faroe Islands', 0, 72),
(331, 258, 'FJ', 'Fiji', 0, 73),
(332, 258, 'FI', 'Finland', 0, 74),
(333, 258, 'FR', 'France', 0, 75),
(334, 258, 'GF', 'French Guiana', 0, 76),
(335, 258, 'PF', 'French Polynesia', 0, 77),
(336, 258, 'FS', 'French Southern Territories', 0, 78),
(337, 258, 'GA', 'Gabon', 0, 79),
(338, 258, 'GM', 'Gambia', 0, 80),
(339, 258, 'GE', 'Georgia', 0, 81),
(340, 258, 'DE', 'Germany', 0, 82),
(341, 258, 'GH', 'Ghana', 0, 83),
(342, 258, 'GI', 'Gibraltar', 0, 84),
(343, 258, 'GR', 'Greece', 0, 85),
(344, 258, 'GL', 'Greenland', 0, 86),
(345, 258, 'GD', 'Grenada', 0, 87),
(346, 258, 'GP', 'Guadeloupe', 0, 88),
(347, 258, 'GU', 'Guam', 0, 89),
(348, 258, 'GT', 'Guatemala', 0, 90),
(349, 258, 'GN', 'Guinea', 0, 91),
(350, 258, 'GY', 'Guyana', 0, 92),
(351, 258, 'HT', 'Haiti', 0, 93),
(352, 258, 'HW', 'Hawaii', 0, 94),
(353, 258, 'HN', 'Honduras', 0, 95),
(354, 258, 'HK', 'Hong Kong', 0, 96),
(355, 258, 'HU', 'Hungary', 0, 97),
(356, 258, 'IS', 'Iceland', 0, 98),
(357, 258, 'IN', 'India', 0, 99),
(358, 258, 'ID', 'Indonesia', 0, 100),
(359, 258, 'IA', 'Iran', 0, 101),
(360, 258, 'IQ', 'Iraq', 0, 102),
(361, 258, 'IR', 'Ireland', 0, 103),
(362, 258, 'IM', 'Isle of Man', 0, 104),
(363, 258, 'IL', 'Israel', 0, 105),
(364, 258, 'IT', 'Italy', 0, 106),
(365, 258, 'JM', 'Jamaica', 0, 107),
(366, 258, 'JP', 'Japan', 0, 108),
(367, 258, 'JO', 'Jordan', 0, 109),
(368, 258, 'KZ', 'Kazakhstan', 0, 110),
(369, 258, 'KE', 'Kenya', 0, 111),
(370, 258, 'KI', 'Kiribati', 0, 112),
(371, 258, 'NK', 'Korea North', 0, 113),
(372, 258, 'KS', 'Korea South', 0, 114),
(373, 258, 'KW', 'Kuwait', 0, 115),
(374, 258, 'KG', 'Kyrgyzstan', 0, 116),
(375, 258, 'LA', 'Laos', 0, 117),
(376, 258, 'LV', 'Latvia', 0, 118),
(377, 258, 'LB', 'Lebanon', 0, 119),
(378, 258, 'LS', 'Lesotho', 0, 120),
(379, 258, 'LR', 'Liberia', 0, 121),
(380, 258, 'LY', 'Libya', 0, 122),
(381, 258, 'LI', 'Liechtenstein', 0, 123),
(382, 258, 'LT', 'Lithuania', 0, 124),
(383, 258, 'LU', 'Luxembourg', 0, 125),
(384, 258, 'MO', 'Macau', 0, 126),
(385, 258, 'MK', 'Macedonia', 0, 127),
(386, 258, 'MG', 'Madagascar', 0, 128),
(387, 258, 'MY', 'Malaysia', 0, 129),
(388, 258, 'MW', 'Malawi', 0, 130),
(389, 258, 'MV', 'Maldives', 0, 131),
(390, 258, 'ML', 'Mali', 0, 132),
(391, 258, 'MT', 'Malta', 0, 133),
(392, 258, 'MH', 'Marshall Islands', 0, 134),
(393, 258, 'MQ', 'Martinique', 0, 135),
(394, 258, 'MR', 'Mauritania', 0, 136),
(395, 258, 'MU', 'Mauritius', 0, 137),
(396, 258, 'ME', 'Mayotte', 0, 138),
(397, 258, 'MX', 'Mexico', 0, 139),
(398, 258, 'MI', 'Midway Islands', 0, 140),
(399, 258, 'MD', 'Moldova', 0, 141),
(400, 258, 'MC', 'Monaco', 0, 142),
(401, 258, 'MN', 'Mongolia', 0, 143),
(402, 258, 'MS', 'Montserrat', 0, 144),
(403, 258, 'MA', 'Morocco', 0, 145),
(404, 258, 'MZ', 'Mozambique', 0, 146),
(405, 258, 'MM', 'Myanmar', 0, 147),
(406, 258, 'NA', 'Nambia', 0, 148),
(407, 258, 'NU', 'Nauru', 0, 149),
(408, 258, 'NP', 'Nepal', 0, 150),
(409, 258, 'AN', 'Netherland Antilles', 0, 151),
(410, 258, 'NL', 'Netherlands', 0, 152),
(411, 258, 'NV', 'Nevis', 0, 153),
(412, 258, 'NC', 'New Caledonia', 0, 154),
(413, 258, 'NZ', 'New Zealand', 0, 155),
(414, 258, 'NI', 'Nicaragua', 0, 156),
(415, 258, 'NE', 'Niger', 0, 157),
(416, 258, 'NG', 'Nigeria', 0, 158),
(417, 258, 'NW', 'Niue', 0, 159),
(418, 258, 'NF', 'Norfolk Island', 0, 160),
(419, 258, 'NO', 'Norway', 0, 161),
(420, 258, 'OM', 'Oman', 0, 162),
(421, 258, 'PK', 'Pakistan', 0, 163),
(422, 258, 'PW', 'Palau Island', 0, 164),
(423, 258, 'PS', 'Palestine', 0, 165),
(424, 258, 'PA', 'Panama', 0, 166),
(425, 258, 'PG', 'Papua New Guinea', 0, 167),
(426, 258, 'PY', 'Paraguay', 0, 168),
(427, 258, 'PE', 'Peru', 0, 169),
(428, 258, 'PH', 'Philippines', 0, 170),
(429, 258, 'PO', 'Pitcairn Island', 0, 171),
(430, 258, 'PL', 'Poland', 0, 172),
(431, 258, 'PT', 'Portugal', 0, 173),
(432, 258, 'PR', 'Puerto Rico', 0, 174),
(433, 258, 'QA', 'Qatar', 0, 175),
(434, 258, 'RE', 'Reunion', 0, 176),
(435, 258, 'RO', 'Romania', 0, 177),
(436, 258, 'RU', 'Russia', 0, 178),
(437, 258, 'RW', 'Rwanda', 0, 179),
(438, 258, 'NT', 'St Barthelemy', 0, 180),
(439, 258, 'EU', 'St Eustatius', 0, 181),
(440, 258, 'HE', 'St Helena', 0, 182),
(441, 258, 'KN', 'St Kitts-Nevis', 0, 183),
(442, 258, 'LC', 'St Lucia', 0, 184),
(443, 258, 'MB', 'St Maarten', 0, 185),
(444, 258, 'PM', 'St Pierre & Miquelon', 0, 186),
(445, 258, 'VC', 'St Vincent & Grenadines', 0, 187),
(446, 258, 'SP', 'Saipan', 0, 188),
(447, 258, 'SO', 'Samoa', 0, 189),
(448, 258, 'SM', 'San Marino', 0, 190),
(449, 258, 'ST', 'Sao Tome & Principe', 0, 191),
(450, 258, 'SA', 'Saudi Arabia', 0, 192),
(451, 258, 'SN', 'Senegal', 0, 193),
(452, 258, 'SC', 'Seychelles', 0, 194),
(453, 258, 'SS', 'Serbia & Montenegro', 0, 195),
(454, 258, 'SL', 'Sierra Leone', 0, 196),
(455, 258, 'SG', 'Singapore', 0, 197),
(456, 258, 'SK', 'Slovakia', 0, 198),
(457, 258, 'SI', 'Slovenia', 0, 199),
(458, 258, 'SB', 'Solomon Islands', 0, 200),
(459, 258, 'OI', 'Somalia', 0, 201),
(460, 258, 'ZA', 'South Africa', 0, 202),
(461, 258, 'ES', 'Spain', 0, 203),
(462, 258, 'LK', 'Sri Lanka', 0, 204),
(463, 258, 'SD', 'Sudan', 0, 205),
(464, 258, 'SR', 'Suriname', 0, 206),
(465, 258, 'SZ', 'Swaziland', 0, 207),
(466, 258, 'SE', 'Sweden', 0, 208),
(467, 258, 'CH', 'Switzerland', 0, 209),
(468, 258, 'SY', 'Syria', 0, 210),
(469, 258, 'TA', 'Tahiti', 0, 211),
(470, 258, 'TW', 'Taiwan', 0, 212),
(471, 258, 'TJ', 'Tajikistan', 0, 213),
(472, 258, 'TZ', 'Tanzania', 0, 214),
(473, 258, 'TH', 'Thailand', 0, 215),
(474, 258, 'TG', 'Togo', 0, 216),
(475, 258, 'TK', 'Tokelau', 0, 217),
(476, 258, 'TO', 'Tonga', 0, 218),
(477, 258, 'TT', 'Trinidad & Tobago', 0, 219),
(478, 258, 'TN', 'Tunisia', 0, 220),
(479, 258, 'TR', 'Turkey', 0, 221),
(480, 258, 'TU', 'Turkmenistan', 0, 222),
(481, 258, 'TC', 'Turks & Caicos Is', 0, 223),
(482, 258, 'TV', 'Tuvalu', 0, 224),
(483, 258, 'UG', 'Uganda', 0, 225),
(484, 258, 'UA', 'Ukraine', 0, 226),
(485, 258, 'AE', 'United Arab Emirates', 0, 227),
(486, 258, 'GB', 'United Kingdom', 0, 228),
(487, 258, 'US', 'United States of America', 0, 229),
(488, 258, 'UY', 'Uruguay', 0, 230),
(489, 258, 'UZ', 'Uzbekistan', 0, 231),
(490, 258, 'VU', 'Vanuatu', 0, 232),
(491, 258, 'VS', 'Vatican City State', 0, 233),
(492, 258, 'VE', 'Venezuela', 0, 234),
(493, 258, 'VN', 'Vietnam', 0, 235),
(494, 258, 'VB', 'Virgin Islands (Brit)', 0, 236),
(495, 258, 'VA', 'Virgin Islands (USA)', 0, 237),
(496, 258, 'WK', 'Wake Island', 0, 238),
(497, 258, 'WF', 'Wallis & Futana Is', 0, 239),
(498, 258, 'YE', 'Yemen', 0, 240),
(499, 258, 'ZR', 'Zaire', 0, 241),
(500, 258, 'ZM', 'Zambia', 0, 242),
(501, 258, 'ZW', 'Zimbabwe', 0, 243),
(502, 487, 'AL', 'Alabama', 0, 1),
(503, 487, 'AK', 'Alaska', 0, 2),
(504, 487, 'AZ', 'Arizona', 0, 3),
(505, 487, 'AR', 'Arkansas', 0, 4),
(506, 487, 'CA', 'California', 0, 5),
(507, 487, 'CO', 'Colorado', 0, 6),
(508, 487, 'CT', 'Connecticut', 0, 7),
(509, 487, 'DE', 'Delaware', 0, 8),
(510, 487, 'DC', 'District Of Columbia', 0, 9),
(511, 487, 'FL', 'Florida', 0, 10),
(512, 487, 'GA', 'Georgia', 0, 11),
(513, 487, 'HI', 'Hawaii', 0, 12),
(514, 487, 'ID', 'Idaho', 0, 13),
(515, 487, 'IL', 'Illinois', 0, 14),
(516, 487, 'IN', 'Indiana', 0, 15),
(517, 487, 'IA', 'Iowa', 0, 16),
(518, 487, 'KS', 'Kansas', 0, 17),
(519, 487, 'KY', 'Kentucky', 0, 18),
(520, 487, 'LA', 'Louisiana', 0, 19),
(521, 487, 'ME', 'Maine', 0, 20),
(522, 487, 'MD', 'Maryland', 0, 21),
(523, 487, 'MA', 'Massachusetts', 0, 22),
(524, 487, 'MI', 'Michigan', 0, 23),
(525, 487, 'MN', 'Minnesota', 0, 24),
(526, 487, 'MS', 'Mississippi', 0, 25),
(527, 487, 'MO', 'Missouri', 0, 26),
(528, 487, 'MT', 'Montana', 0, 27),
(529, 487, 'NE', 'Nebraska', 0, 28),
(530, 487, 'NV', 'Nevada', 0, 29),
(531, 487, 'NH', 'New Hampshire', 0, 30),
(532, 487, 'NJ', 'New Jersey', 0, 31),
(533, 487, 'NM', 'New Mexico', 0, 32),
(534, 487, 'NY', 'New York', 0, 33),
(535, 487, 'NC', 'North Carolina', 0, 34),
(536, 487, 'ND', 'North Dakota', 0, 35),
(537, 487, 'OH', 'Ohio', 0, 36),
(538, 487, 'OK', 'Oklahoma', 0, 37),
(539, 487, 'OR', 'Oregon', 0, 38),
(540, 487, 'PA', 'Pennsylvania', 0, 39),
(541, 487, 'RI', 'Rhode Island', 0, 40),
(542, 487, 'SC', 'South Carolina', 0, 41),
(543, 487, 'SD', 'South Dakota', 0, 42),
(544, 487, 'TN', 'Tennessee', 0, 43),
(545, 487, 'TX', 'Texas', 0, 44),
(546, 487, 'UT', 'Utah', 0, 45),
(547, 487, 'VT', 'Vermont', 0, 46),
(548, 487, 'VA', 'Virginia', 0, 47),
(549, 487, 'WA', 'Washington', 0, 48),
(550, 487, 'WV', 'West Virginia', 0, 49),
(551, 487, 'WI', 'Wisconsin', 0, 50),
(552, 487, 'WY', 'Wyoming', 0, 51),
(553, 430, 'DS', 'Lower Silesian', 0, 1),
(554, 430, 'KP', 'Kuyavian-Pomeranian', 0, 2),
(555, 430, 'LB', 'Lubusz', 0, 3),
(556, 430, 'LD', 'Łódź', 0, 4),
(557, 430, 'LU', 'Lublin', 0, 5),
(558, 430, 'MA', 'Masovian', 0, 6),
(559, 430, 'MP', 'Lesser Poland', 0, 7),
(560, 430, 'OP', 'Opole', 0, 8),
(561, 430, 'PD', 'Podlaskie', 0, 9),
(562, 430, 'PK', 'Subcarpathian', 0, 10),
(563, 430, 'PM', 'Pomeranian', 0, 11),
(564, 430, 'SL', 'Silesian', 0, 12),
(565, 430, 'SW', 'Świętokrzyskie', 0, 13),
(566, 430, 'WM', 'Warmian-Masurian', 0, 14),
(567, 430, 'WP', 'Greater Poland', 0, 15),
(568, 430, 'ZP', 'West Pomeranian', 0, 16),
(569, 435, 'AB', 'Alba', 0, 1),
(570, 435, 'AG', 'Arges', 0, 2),
(571, 435, 'AR', 'Arad', 0, 3),
(572, 435, 'B', 'Bucuresti', 0, 4),
(573, 435, 'BC', 'Bacau', 0, 5),
(574, 435, 'BH', 'Bihor', 0, 6),
(575, 435, 'BN', 'Bistrita-Nasaud', 0, 7),
(576, 435, 'BR', 'Braila', 0, 8),
(577, 435, 'BT', 'Botosani', 0, 9),
(578, 435, 'BV', 'Brasov', 0, 10),
(579, 435, 'BZ', 'Buzau', 0, 11),
(580, 435, 'CJ', 'Cluj', 0, 12),
(581, 435, 'CL', 'Calarasi', 0, 13),
(582, 435, 'CS', 'Caras-Severin', 0, 14),
(583, 435, 'CT', 'Constanta', 0, 15),
(584, 435, 'CV', 'Covasna', 0, 16),
(585, 435, 'DB', 'Dambovita', 0, 17),
(586, 435, 'DJ', 'Dolj', 0, 18),
(587, 435, 'GJ', 'Gorj', 0, 19),
(588, 435, 'GL', 'Galati', 0, 20),
(589, 435, 'GR', 'Giurgiu', 0, 21),
(590, 435, 'HD', 'Hunedoara', 0, 22),
(591, 435, 'HR', 'Harghita', 0, 23),
(592, 435, 'IF', 'Ilfov', 0, 24),
(593, 435, 'IL', 'Ialomita', 0, 25),
(594, 435, 'IS', 'Iasi', 0, 26),
(595, 435, 'MH', 'Mehedinti', 0, 27),
(596, 435, 'MM', 'Maramures', 0, 28),
(597, 435, 'MS', 'Mures', 0, 29),
(598, 435, 'NT', 'Neamt', 0, 30),
(599, 435, 'OT', 'Olt', 0, 31),
(600, 435, 'PH', 'Prahova', 0, 32),
(601, 435, 'SB', 'Sibiu', 0, 33),
(602, 435, 'SJ', 'Salaj', 0, 34),
(603, 435, 'SM', 'Satu-Mare', 0, 35),
(604, 435, 'SV', 'Suceava', 0, 36),
(605, 435, 'TL', 'Tulcea', 0, 37),
(606, 435, 'TM', 'Timis', 0, 38),
(607, 435, 'TR', 'Teleorman', 0, 39),
(608, 435, 'VL', 'Valcea', 0, 40),
(609, 435, 'VN', 'Vrancea', 0, 41),
(610, 435, 'VS', 'Vaslui', 0, 42),
(611, 295, 'ON', 'Ontario', 0, 1),
(612, 295, 'AB', 'Alberta', 0, 2),
(613, 295, 'BC', 'British Columbia', 0, 3),
(614, 295, 'MB', 'Manitoba', 0, 4),
(615, 295, 'QC', 'Quebec', 0, 5),
(616, 295, 'LB', 'Labrador', 0, 6),
(617, 295, 'NS', 'Nova Scotia', 0, 7),
(618, 295, 'PE', 'Prince Edwards Island', 0, 8),
(619, 295, 'YK', 'Yukon', 0, 9),
(620, 295, 'NT', 'Northwest Territories', 0, 10),
(621, 295, 'NU', 'Nunavut', 0, 11),
(622, 295, 'NB', 'New Brunswick', 0, 12),
(623, 295, 'SK', 'Saskatchewan', 0, 13),
(624, 540, 'philadelphia', 'Philadelphia', 0, 1),
(625, 540, 'montgomery', 'Montgomery', 0, 2),
(626, 540, 'delaware', 'Delaware', 0, 3),
(627, 540, 'lancaster', 'Lancaster', 0, 4),
(628, 540, 'chester', 'Chester', 0, 5),
(629, 540, 'bucks', 'Bucks', 0, 6),
(630, -1, 'System', NULL, 1, 3),
(631, 630, 'csv_export_params', NULL, 0, 1),
(632, 631, 'charset', 'UTF-8', 0, 1),
(633, 631, 'field_separator', ',', 0, 2),
(634, 631, 'decimal_separator', '.', 0, 3),
(635, 631, 'end_line_type', 'UNIX', 0, 4),
(636, 631, 'text_space_indicator', '1', 0, 5),
(637, 631, 'text_space_separator', '&quot;', 0, 6),
(638, -1, 'CRM', NULL, 1, 4),
(639, 638, 'Priority', NULL, 1, 1),
(640, 639, '0', 'Low', 1, 1),
(641, 639, '1', 'Medium', 1, 2),
(642, 639, '2', 'High', 1, 3),
(643, 638, 'Access', NULL, 1, 2),
(644, 643, '0', 'Public', 1, 1),
(645, 643, '1', 'Public, Read-Only', 1, 2),
(646, 643, '2', 'Private', 1, 3),
(647, 638, 'Status', NULL, 1, 3),
(648, 647, '0', 'Open', 1, 1),
(649, 647, '1', 'In Progress', 1, 2),
(650, 647, '2', 'On Hold', 1, 3),
(651, 647, '3', 'Closed', 1, 4),
(652, 647, '4', 'Canceled', 1, 5),
(653, -1, 'Companies_Groups', NULL, 1, 5),
(654, 653, 'customer', 'Customer', 1, 1),
(655, 653, 'vendor', 'Vendor', 1, 2),
(656, 653, 'other', 'Other', 1, 3),
(657, 653, 'manager', 'Manager', 1, 4),
(658, -1, 'Contacts_Groups', NULL, 1, 6),
(659, 658, 'office', 'Office Staff', 1, 1),
(660, 658, 'field', 'Field Staff', 1, 2),
(661, 658, 'custm', 'Customer', 1, 3),
(662, -1, 'Contacts', NULL, 1, 7),
(663, 662, 'Access', NULL, 1, 1),
(664, 663, 'manager', 'Manager', 1, 1),
(665, 663, 'employee', 'Employee', 0, 2),
(666, 638, 'Mail', NULL, 1, 4),
(667, 666, 'Security', NULL, 1, 1),
(668, 667, 'tls', 'TLS', 1, 1),
(669, 667, 'ssl', 'SSL', 1, 2),
(670, -1, 'Base_Notify', NULL, 1, 8),
(672, 670, 'Timeout', NULL, 1, 1),
(673, 672, '-1', 'Disable Notification', 1, 1),
(674, 672, '0', 'Manually', 1, 2),
(675, 672, '10000', '10 seconds', 0, 3),
(676, 672, '30000', '30 seconds', 0, 4),
(677, 672, '60000', '1 minute', 0, 5);

-- --------------------------------------------------------

--
-- Table structure for table `utils_currency`
--

CREATE TABLE `utils_currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `symbol` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimal_sign` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `thousand_sign` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimals` tinyint(4) DEFAULT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `default_currency` tinyint(4) DEFAULT NULL,
  `pos_before` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `utils_currency`
--

INSERT INTO `utils_currency` VALUES
(1, '$', 'USD', '.', ',', 2, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `utils_filedownload_files`
--

CREATE TABLE `utils_filedownload_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8_unicode_ci,
  `curr` bigint(20) DEFAULT '0',
  `size` bigint(20) DEFAULT '0',
  `rate` double DEFAULT '0',
  `time` double DEFAULT '0',
  `view_time` double DEFAULT '0',
  `posted_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_filestorage`
--

CREATE TABLE `utils_filestorage` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filename` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `link` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backref` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_on` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL,
  `deleted` tinyint(4) DEFAULT '0',
  `file_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_filestorage_access`
--

CREATE TABLE `utils_filestorage_access` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `date_accessed` datetime NOT NULL,
  `accessed_by` bigint(20) NOT NULL,
  `type` bigint(20) NOT NULL,
  `ip_address` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `host_name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_filestorage_files`
--

CREATE TABLE `utils_filestorage_files` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hash` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `deleted` tinyint(4) DEFAULT '0',
  `size` bigint(20) DEFAULT NULL,
  `type` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_filestorage_remote`
--

CREATE TABLE `utils_filestorage_remote` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `token` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL,
  `expires_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_messenger_message`
--

CREATE TABLE `utils_messenger_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `callback_method` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `callback_args` text COLLATE utf8_unicode_ci,
  `message` text COLLATE utf8_unicode_ci,
  `created_by` int(11) NOT NULL,
  `created_on` datetime NOT NULL,
  `alert_on` datetime DEFAULT NULL,
  `parent_module` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `page_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `utils_messenger_users`
--

CREATE TABLE `utils_messenger_users` (
  `message_id` int(11) DEFAULT NULL,
  `done` tinyint(4) DEFAULT '0',
  `user_login_id` int(11) DEFAULT NULL,
  `done_on` datetime DEFAULT NULL,
  `follow` tinyint(4) DEFAULT '0',
  KEY `message_id` (`message_id`),
  KEY `user_login_id` (`user_login_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `utils_watchdog_category`
--

CREATE TABLE `utils_watchdog_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `utils_watchdog_category`
--

INSERT INTO `utils_watchdog_category` VALUES
(1, '94549d917270ceab3f011449bdd5fd1b', 'Utils_AttachmentCommon::watchdog_label'),
(2, '93c731f1c3a84ef05cd54d044c379eaa', 'CRM_ContactsCommon::company_watchdog_label'),
(3, '2f8a6bf31f3bd67bd2d9720c58b19c9a', 'CRM_ContactsCommon::contact_watchdog_label'),
(4, '93e992447d79460cdbe8077a3f6c776e', 'CRM_MailCommon::watchdog_label'),
(5, '9f121d1bcc2b246d18ba60b3390f8f4e', 'CRM_PhoneCallCommon::watchdog_label'),
(6, '478f3a4c51824ad23cb50c1c60670c0f', 'CRM_TasksCommon::watchdog_label'),
(7, 'ac7305f48d3761a1209f762996de7ad5', 'CRM_MeetingCommon::watchdog_label');

-- --------------------------------------------------------

--
-- Table structure for table `utils_watchdog_category_subscription`
--

CREATE TABLE `utils_watchdog_category_subscription` (
  `category_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  KEY `user_id` (`user_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `utils_watchdog_event`
--

CREATE TABLE `utils_watchdog_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `internal_id` int(11) DEFAULT NULL,
  `message` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `utils_watchdog_event__internal_id__idx` (`internal_id`),
  KEY `utils_watchdog_event__cat_int__idx` (`category_id`,`internal_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `utils_watchdog_event`
--

INSERT INTO `utils_watchdog_event` VALUES
(1, 2, 1, 'C', '[[regtime]]'),
(2, 3, 1, 'C', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `utils_watchdog_notification_queue`
--

CREATE TABLE `utils_watchdog_notification_queue` (
  `event_id` int(11) NOT NULL,
  PRIMARY KEY (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utils_watchdog_notification_queue`
--

INSERT INTO `utils_watchdog_notification_queue` VALUES
(1),
(2);

-- --------------------------------------------------------

--
-- Table structure for table `utils_watchdog_subscription`
--

CREATE TABLE `utils_watchdog_subscription` (
  `category_id` int(11) DEFAULT NULL,
  `internal_id` int(11) DEFAULT NULL,
  `last_seen_event` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  KEY `utils_watchdog_subscription__cat_int__idx` (`category_id`,`internal_id`),
  KEY `utils_watchdog_subscription__user__idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `utils_watchdog_subscription`
--

INSERT INTO `utils_watchdog_subscription` VALUES
(2, 1, 1, 1),
(3, 1, 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `variables`
--

CREATE TABLE `variables` (
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `variables`
--

INSERT INTO `variables` VALUES
('allow_lang_change', 'b:1;'),
('anonymous_setup', 'b:0;'),
('base_page_title', 's:5:"EPESI";'),
('crm_mail_default_client', 's:13:"CRM_Roundcube";'),
('crm_mail_global_signature', 's:75:"Message sent with EPESI BIM!<br /><a href="http://epe.si">http://epe.si</a>";'),
('default_lang', 's:2:"en";'),
('default_module', 's:8:"Base_Box";'),
('default_theme', 's:7:"default";'),
('error_mail', 's:0:"";'),
('host_ban_by_login', 'i:0;'),
('host_ban_nr_of_tries', 'i:3;'),
('host_ban_time', 'i:300;'),
('login_logo_file', 's:0:"";'),
('logo_file', 's:0:"";'),
('mail_auth', 'b:0;'),
('mail_from_addr', '[[admin_email_ser]]'),
('mail_from_name', '[[admin_username_ser]]'),
('mail_host', 's:19:"smtp.example.com:25";'),
('mail_method', 's:4:"mail";'),
('mail_password', 's:0:"";'),
('mail_security', 's:0:"";'),
('mail_use_replyto', 's:0:"";'),
('mail_user', 's:0:"";'),
('print_document_types', 'a:2:{s:24:"Base_Print_Document_HTML";s:4:"HTML";s:23:"Base_Print_Document_PDF";s:3:"PDF";}'),
('printers_registered', 'a:1:{s:33:"Utils_RecordBrowser_RecordPrinter";s:28:"Generic RecordBrowser Record";}'),
('show_caption_in_title', 's:1:"1";'),
('show_module_indicator', 's:1:"1";'),
('simple_setup', 'i:1;'),
('version', 's:5:"1.9.1";');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `apps_shoutbox_messages`
--
ALTER TABLE `apps_shoutbox_messages`
  ADD CONSTRAINT `apps_shoutbox_messages_ibfk_1` FOREIGN KEY (`base_user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `base_acl_rules`
--
ALTER TABLE `base_acl_rules`
  ADD CONSTRAINT `base_acl_rules_ibfk_1` FOREIGN KEY (`permission_id`) REFERENCES `base_acl_permission` (`id`);

--
-- Constraints for table `base_acl_rules_clearance`
--
ALTER TABLE `base_acl_rules_clearance`
  ADD CONSTRAINT `base_acl_rules_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `base_acl_rules` (`id`);

--
-- Constraints for table `base_dashboard_applets`
--
ALTER TABLE `base_dashboard_applets`
  ADD CONSTRAINT `base_dashboard_applets_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `base_dashboard_applets_ibfk_2` FOREIGN KEY (`tab`) REFERENCES `base_dashboard_tabs` (`id`);

--
-- Constraints for table `base_dashboard_default_applets`
--
ALTER TABLE `base_dashboard_default_applets`
  ADD CONSTRAINT `base_dashboard_default_applets_ibfk_1` FOREIGN KEY (`tab`) REFERENCES `base_dashboard_default_tabs` (`id`);

--
-- Constraints for table `base_dashboard_default_settings`
--
ALTER TABLE `base_dashboard_default_settings`
  ADD CONSTRAINT `base_dashboard_default_settings_ibfk_1` FOREIGN KEY (`applet_id`) REFERENCES `base_dashboard_default_applets` (`id`);

--
-- Constraints for table `base_dashboard_settings`
--
ALTER TABLE `base_dashboard_settings`
  ADD CONSTRAINT `base_dashboard_settings_ibfk_1` FOREIGN KEY (`applet_id`) REFERENCES `base_dashboard_applets` (`id`);

--
-- Constraints for table `base_dashboard_tabs`
--
ALTER TABLE `base_dashboard_tabs`
  ADD CONSTRAINT `base_dashboard_tabs_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `base_home_page_clearance`
--
ALTER TABLE `base_home_page_clearance`
  ADD CONSTRAINT `base_home_page_clearance_ibfk_1` FOREIGN KEY (`home_page_id`) REFERENCES `base_home_page` (`id`);

--
-- Constraints for table `base_notify`
--
ALTER TABLE `base_notify`
  ADD CONSTRAINT `base_notify_ibfk_1` FOREIGN KEY (`single_cache_uid`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `base_user_settings`
--
ALTER TABLE `base_user_settings`
  ADD CONSTRAINT `base_user_settings_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `company_access_clearance`
--
ALTER TABLE `company_access_clearance`
  ADD CONSTRAINT `company_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `company_access` (`id`);

--
-- Constraints for table `company_access_fields`
--
ALTER TABLE `company_access_fields`
  ADD CONSTRAINT `company_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `company_access` (`id`);

--
-- Constraints for table `company_edit_history`
--
ALTER TABLE `company_edit_history`
  ADD CONSTRAINT `company_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `company_edit_history_ibfk_2` FOREIGN KEY (`company_id`) REFERENCES `company_data_1` (`id`);

--
-- Constraints for table `company_edit_history_data`
--
ALTER TABLE `company_edit_history_data`
  ADD CONSTRAINT `company_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `company_edit_history` (`id`);

--
-- Constraints for table `company_favorite`
--
ALTER TABLE `company_favorite`
  ADD CONSTRAINT `company_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `company_favorite_ibfk_2` FOREIGN KEY (`company_id`) REFERENCES `company_data_1` (`id`);

--
-- Constraints for table `company_recent`
--
ALTER TABLE `company_recent`
  ADD CONSTRAINT `company_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `company_recent_ibfk_2` FOREIGN KEY (`company_id`) REFERENCES `company_data_1` (`id`);

--
-- Constraints for table `contact_access_clearance`
--
ALTER TABLE `contact_access_clearance`
  ADD CONSTRAINT `contact_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `contact_access` (`id`);

--
-- Constraints for table `contact_access_fields`
--
ALTER TABLE `contact_access_fields`
  ADD CONSTRAINT `contact_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `contact_access` (`id`);

--
-- Constraints for table `contact_edit_history`
--
ALTER TABLE `contact_edit_history`
  ADD CONSTRAINT `contact_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `contact_edit_history_ibfk_2` FOREIGN KEY (`contact_id`) REFERENCES `contact_data_1` (`id`);

--
-- Constraints for table `contact_edit_history_data`
--
ALTER TABLE `contact_edit_history_data`
  ADD CONSTRAINT `contact_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `contact_edit_history` (`id`);

--
-- Constraints for table `contact_favorite`
--
ALTER TABLE `contact_favorite`
  ADD CONSTRAINT `contact_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `contact_favorite_ibfk_2` FOREIGN KEY (`contact_id`) REFERENCES `contact_data_1` (`id`);

--
-- Constraints for table `contact_recent`
--
ALTER TABLE `contact_recent`
  ADD CONSTRAINT `contact_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `contact_recent_ibfk_2` FOREIGN KEY (`contact_id`) REFERENCES `contact_data_1` (`id`);

--
-- Constraints for table `crm_filters_contacts`
--
ALTER TABLE `crm_filters_contacts`
  ADD CONSTRAINT `crm_filters_contacts_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `crm_filters_group` (`id`);

--
-- Constraints for table `crm_filters_group`
--
ALTER TABLE `crm_filters_group`
  ADD CONSTRAINT `crm_filters_group_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `crm_meeting_access_clearance`
--
ALTER TABLE `crm_meeting_access_clearance`
  ADD CONSTRAINT `crm_meeting_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `crm_meeting_access` (`id`);

--
-- Constraints for table `crm_meeting_access_fields`
--
ALTER TABLE `crm_meeting_access_fields`
  ADD CONSTRAINT `crm_meeting_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `crm_meeting_access` (`id`);

--
-- Constraints for table `crm_meeting_edit_history`
--
ALTER TABLE `crm_meeting_edit_history`
  ADD CONSTRAINT `crm_meeting_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `crm_meeting_edit_history_ibfk_2` FOREIGN KEY (`crm_meeting_id`) REFERENCES `crm_meeting_data_1` (`id`);

--
-- Constraints for table `crm_meeting_edit_history_data`
--
ALTER TABLE `crm_meeting_edit_history_data`
  ADD CONSTRAINT `crm_meeting_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `crm_meeting_edit_history` (`id`);

--
-- Constraints for table `crm_meeting_favorite`
--
ALTER TABLE `crm_meeting_favorite`
  ADD CONSTRAINT `crm_meeting_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `crm_meeting_favorite_ibfk_2` FOREIGN KEY (`crm_meeting_id`) REFERENCES `crm_meeting_data_1` (`id`);

--
-- Constraints for table `crm_meeting_recent`
--
ALTER TABLE `crm_meeting_recent`
  ADD CONSTRAINT `crm_meeting_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `crm_meeting_recent_ibfk_2` FOREIGN KEY (`crm_meeting_id`) REFERENCES `crm_meeting_data_1` (`id`);

--
-- Constraints for table `crm_meeting_related_access_clearance`
--
ALTER TABLE `crm_meeting_related_access_clearance`
  ADD CONSTRAINT `crm_meeting_related_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `crm_meeting_related_access` (`id`);

--
-- Constraints for table `crm_meeting_related_access_fields`
--
ALTER TABLE `crm_meeting_related_access_fields`
  ADD CONSTRAINT `crm_meeting_related_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `crm_meeting_related_access` (`id`);

--
-- Constraints for table `crm_meeting_related_edit_history`
--
ALTER TABLE `crm_meeting_related_edit_history`
  ADD CONSTRAINT `crm_meeting_related_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `crm_meeting_related_edit_history_ibfk_2` FOREIGN KEY (`crm_meeting_related_id`) REFERENCES `crm_meeting_related_data_1` (`id`);

--
-- Constraints for table `crm_meeting_related_edit_history_data`
--
ALTER TABLE `crm_meeting_related_edit_history_data`
  ADD CONSTRAINT `crm_meeting_related_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `crm_meeting_related_edit_history` (`id`);

--
-- Constraints for table `crm_meeting_related_favorite`
--
ALTER TABLE `crm_meeting_related_favorite`
  ADD CONSTRAINT `crm_meeting_related_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `crm_meeting_related_favorite_ibfk_2` FOREIGN KEY (`crm_meeting_related_id`) REFERENCES `crm_meeting_related_data_1` (`id`);

--
-- Constraints for table `crm_meeting_related_recent`
--
ALTER TABLE `crm_meeting_related_recent`
  ADD CONSTRAINT `crm_meeting_related_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `crm_meeting_related_recent_ibfk_2` FOREIGN KEY (`crm_meeting_related_id`) REFERENCES `crm_meeting_related_data_1` (`id`);

--
-- Constraints for table `history`
--
ALTER TABLE `history`
  ADD CONSTRAINT `history_ibfk_1` FOREIGN KEY (`session_name`) REFERENCES `session` (`name`);

--
-- Constraints for table `phonecall_access_clearance`
--
ALTER TABLE `phonecall_access_clearance`
  ADD CONSTRAINT `phonecall_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `phonecall_access` (`id`);

--
-- Constraints for table `phonecall_access_fields`
--
ALTER TABLE `phonecall_access_fields`
  ADD CONSTRAINT `phonecall_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `phonecall_access` (`id`);

--
-- Constraints for table `phonecall_edit_history`
--
ALTER TABLE `phonecall_edit_history`
  ADD CONSTRAINT `phonecall_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `phonecall_edit_history_ibfk_2` FOREIGN KEY (`phonecall_id`) REFERENCES `phonecall_data_1` (`id`);

--
-- Constraints for table `phonecall_edit_history_data`
--
ALTER TABLE `phonecall_edit_history_data`
  ADD CONSTRAINT `phonecall_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `phonecall_edit_history` (`id`);

--
-- Constraints for table `phonecall_favorite`
--
ALTER TABLE `phonecall_favorite`
  ADD CONSTRAINT `phonecall_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `phonecall_favorite_ibfk_2` FOREIGN KEY (`phonecall_id`) REFERENCES `phonecall_data_1` (`id`);

--
-- Constraints for table `phonecall_recent`
--
ALTER TABLE `phonecall_recent`
  ADD CONSTRAINT `phonecall_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `phonecall_recent_ibfk_2` FOREIGN KEY (`phonecall_id`) REFERENCES `phonecall_data_1` (`id`);

--
-- Constraints for table `phonecall_related_access_clearance`
--
ALTER TABLE `phonecall_related_access_clearance`
  ADD CONSTRAINT `phonecall_related_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `phonecall_related_access` (`id`);

--
-- Constraints for table `phonecall_related_access_fields`
--
ALTER TABLE `phonecall_related_access_fields`
  ADD CONSTRAINT `phonecall_related_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `phonecall_related_access` (`id`);

--
-- Constraints for table `phonecall_related_edit_history`
--
ALTER TABLE `phonecall_related_edit_history`
  ADD CONSTRAINT `phonecall_related_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `phonecall_related_edit_history_ibfk_2` FOREIGN KEY (`phonecall_related_id`) REFERENCES `phonecall_related_data_1` (`id`);

--
-- Constraints for table `phonecall_related_edit_history_data`
--
ALTER TABLE `phonecall_related_edit_history_data`
  ADD CONSTRAINT `phonecall_related_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `phonecall_related_edit_history` (`id`);

--
-- Constraints for table `phonecall_related_favorite`
--
ALTER TABLE `phonecall_related_favorite`
  ADD CONSTRAINT `phonecall_related_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `phonecall_related_favorite_ibfk_2` FOREIGN KEY (`phonecall_related_id`) REFERENCES `phonecall_related_data_1` (`id`);

--
-- Constraints for table `phonecall_related_recent`
--
ALTER TABLE `phonecall_related_recent`
  ADD CONSTRAINT `phonecall_related_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `phonecall_related_recent_ibfk_2` FOREIGN KEY (`phonecall_related_id`) REFERENCES `phonecall_related_data_1` (`id`);

--
-- Constraints for table `rc_accounts_access_clearance`
--
ALTER TABLE `rc_accounts_access_clearance`
  ADD CONSTRAINT `rc_accounts_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_accounts_access` (`id`);

--
-- Constraints for table `rc_accounts_access_fields`
--
ALTER TABLE `rc_accounts_access_fields`
  ADD CONSTRAINT `rc_accounts_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_accounts_access` (`id`);

--
-- Constraints for table `rc_accounts_edit_history`
--
ALTER TABLE `rc_accounts_edit_history`
  ADD CONSTRAINT `rc_accounts_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_accounts_edit_history_ibfk_2` FOREIGN KEY (`rc_accounts_id`) REFERENCES `rc_accounts_data_1` (`id`);

--
-- Constraints for table `rc_accounts_edit_history_data`
--
ALTER TABLE `rc_accounts_edit_history_data`
  ADD CONSTRAINT `rc_accounts_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `rc_accounts_edit_history` (`id`);

--
-- Constraints for table `rc_accounts_favorite`
--
ALTER TABLE `rc_accounts_favorite`
  ADD CONSTRAINT `rc_accounts_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_accounts_favorite_ibfk_2` FOREIGN KEY (`rc_accounts_id`) REFERENCES `rc_accounts_data_1` (`id`);

--
-- Constraints for table `rc_accounts_recent`
--
ALTER TABLE `rc_accounts_recent`
  ADD CONSTRAINT `rc_accounts_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_accounts_recent_ibfk_2` FOREIGN KEY (`rc_accounts_id`) REFERENCES `rc_accounts_data_1` (`id`);

--
-- Constraints for table `rc_cache`
--
ALTER TABLE `rc_cache`
  ADD CONSTRAINT `user_id_fk_cache` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_cache_index`
--
ALTER TABLE `rc_cache_index`
  ADD CONSTRAINT `user_id_fk_cache_index` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_cache_messages`
--
ALTER TABLE `rc_cache_messages`
  ADD CONSTRAINT `user_id_fk_cache_messages` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_cache_thread`
--
ALTER TABLE `rc_cache_thread`
  ADD CONSTRAINT `user_id_fk_cache_thread` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_contactgroupmembers`
--
ALTER TABLE `rc_contactgroupmembers`
  ADD CONSTRAINT `contactgroup_id_fk_contactgroups` FOREIGN KEY (`contactgroup_id`) REFERENCES `rc_contactgroups` (`contactgroup_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `contact_id_fk_contacts` FOREIGN KEY (`contact_id`) REFERENCES `rc_contacts` (`contact_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_contactgroups`
--
ALTER TABLE `rc_contactgroups`
  ADD CONSTRAINT `user_id_fk_contactgroups` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_contacts`
--
ALTER TABLE `rc_contacts`
  ADD CONSTRAINT `user_id_fk_contacts` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_dictionary`
--
ALTER TABLE `rc_dictionary`
  ADD CONSTRAINT `user_id_fk_dictionary` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_identities`
--
ALTER TABLE `rc_identities`
  ADD CONSTRAINT `user_id_fk_identities` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rc_mails_access_clearance`
--
ALTER TABLE `rc_mails_access_clearance`
  ADD CONSTRAINT `rc_mails_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_mails_access` (`id`);

--
-- Constraints for table `rc_mails_access_fields`
--
ALTER TABLE `rc_mails_access_fields`
  ADD CONSTRAINT `rc_mails_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_mails_access` (`id`);

--
-- Constraints for table `rc_mails_attachments`
--
ALTER TABLE `rc_mails_attachments`
  ADD CONSTRAINT `rc_mails_attachments_ibfk_1` FOREIGN KEY (`mail_id`) REFERENCES `rc_mails_data_1` (`id`);

--
-- Constraints for table `rc_mails_attachments_download`
--
ALTER TABLE `rc_mails_attachments_download`
  ADD CONSTRAINT `rc_mails_attachments_download_ibfk_1` FOREIGN KEY (`mail_id`) REFERENCES `rc_mails_data_1` (`id`);

--
-- Constraints for table `rc_mails_edit_history`
--
ALTER TABLE `rc_mails_edit_history`
  ADD CONSTRAINT `rc_mails_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_mails_edit_history_ibfk_2` FOREIGN KEY (`rc_mails_id`) REFERENCES `rc_mails_data_1` (`id`);

--
-- Constraints for table `rc_mails_edit_history_data`
--
ALTER TABLE `rc_mails_edit_history_data`
  ADD CONSTRAINT `rc_mails_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `rc_mails_edit_history` (`id`);

--
-- Constraints for table `rc_mails_favorite`
--
ALTER TABLE `rc_mails_favorite`
  ADD CONSTRAINT `rc_mails_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_mails_favorite_ibfk_2` FOREIGN KEY (`rc_mails_id`) REFERENCES `rc_mails_data_1` (`id`);

--
-- Constraints for table `rc_mails_recent`
--
ALTER TABLE `rc_mails_recent`
  ADD CONSTRAINT `rc_mails_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_mails_recent_ibfk_2` FOREIGN KEY (`rc_mails_id`) REFERENCES `rc_mails_data_1` (`id`);

--
-- Constraints for table `rc_mail_threads_access_clearance`
--
ALTER TABLE `rc_mail_threads_access_clearance`
  ADD CONSTRAINT `rc_mail_threads_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_mail_threads_access` (`id`);

--
-- Constraints for table `rc_mail_threads_access_fields`
--
ALTER TABLE `rc_mail_threads_access_fields`
  ADD CONSTRAINT `rc_mail_threads_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_mail_threads_access` (`id`);

--
-- Constraints for table `rc_mail_threads_edit_history`
--
ALTER TABLE `rc_mail_threads_edit_history`
  ADD CONSTRAINT `rc_mail_threads_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_mail_threads_edit_history_ibfk_2` FOREIGN KEY (`rc_mail_threads_id`) REFERENCES `rc_mail_threads_data_1` (`id`);

--
-- Constraints for table `rc_mail_threads_edit_history_data`
--
ALTER TABLE `rc_mail_threads_edit_history_data`
  ADD CONSTRAINT `rc_mail_threads_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `rc_mail_threads_edit_history` (`id`);

--
-- Constraints for table `rc_mail_threads_favorite`
--
ALTER TABLE `rc_mail_threads_favorite`
  ADD CONSTRAINT `rc_mail_threads_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_mail_threads_favorite_ibfk_2` FOREIGN KEY (`rc_mail_threads_id`) REFERENCES `rc_mail_threads_data_1` (`id`);

--
-- Constraints for table `rc_mail_threads_recent`
--
ALTER TABLE `rc_mail_threads_recent`
  ADD CONSTRAINT `rc_mail_threads_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_mail_threads_recent_ibfk_2` FOREIGN KEY (`rc_mail_threads_id`) REFERENCES `rc_mail_threads_data_1` (`id`);

--
-- Constraints for table `rc_multiple_emails_access_clearance`
--
ALTER TABLE `rc_multiple_emails_access_clearance`
  ADD CONSTRAINT `rc_multiple_emails_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_multiple_emails_access` (`id`);

--
-- Constraints for table `rc_multiple_emails_access_fields`
--
ALTER TABLE `rc_multiple_emails_access_fields`
  ADD CONSTRAINT `rc_multiple_emails_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_multiple_emails_access` (`id`);

--
-- Constraints for table `rc_multiple_emails_edit_history`
--
ALTER TABLE `rc_multiple_emails_edit_history`
  ADD CONSTRAINT `rc_multiple_emails_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_multiple_emails_edit_history_ibfk_2` FOREIGN KEY (`rc_multiple_emails_id`) REFERENCES `rc_multiple_emails_data_1` (`id`);

--
-- Constraints for table `rc_multiple_emails_edit_history_data`
--
ALTER TABLE `rc_multiple_emails_edit_history_data`
  ADD CONSTRAINT `rc_multiple_emails_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `rc_multiple_emails_edit_history` (`id`);

--
-- Constraints for table `rc_multiple_emails_favorite`
--
ALTER TABLE `rc_multiple_emails_favorite`
  ADD CONSTRAINT `rc_multiple_emails_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_multiple_emails_favorite_ibfk_2` FOREIGN KEY (`rc_multiple_emails_id`) REFERENCES `rc_multiple_emails_data_1` (`id`);

--
-- Constraints for table `rc_multiple_emails_recent`
--
ALTER TABLE `rc_multiple_emails_recent`
  ADD CONSTRAINT `rc_multiple_emails_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_multiple_emails_recent_ibfk_2` FOREIGN KEY (`rc_multiple_emails_id`) REFERENCES `rc_multiple_emails_data_1` (`id`);

--
-- Constraints for table `rc_related_access_clearance`
--
ALTER TABLE `rc_related_access_clearance`
  ADD CONSTRAINT `rc_related_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_related_access` (`id`);

--
-- Constraints for table `rc_related_access_fields`
--
ALTER TABLE `rc_related_access_fields`
  ADD CONSTRAINT `rc_related_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `rc_related_access` (`id`);

--
-- Constraints for table `rc_related_edit_history`
--
ALTER TABLE `rc_related_edit_history`
  ADD CONSTRAINT `rc_related_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_related_edit_history_ibfk_2` FOREIGN KEY (`rc_related_id`) REFERENCES `rc_related_data_1` (`id`);

--
-- Constraints for table `rc_related_edit_history_data`
--
ALTER TABLE `rc_related_edit_history_data`
  ADD CONSTRAINT `rc_related_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `rc_related_edit_history` (`id`);

--
-- Constraints for table `rc_related_favorite`
--
ALTER TABLE `rc_related_favorite`
  ADD CONSTRAINT `rc_related_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_related_favorite_ibfk_2` FOREIGN KEY (`rc_related_id`) REFERENCES `rc_related_data_1` (`id`);

--
-- Constraints for table `rc_related_recent`
--
ALTER TABLE `rc_related_recent`
  ADD CONSTRAINT `rc_related_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `rc_related_recent_ibfk_2` FOREIGN KEY (`rc_related_id`) REFERENCES `rc_related_data_1` (`id`);

--
-- Constraints for table `rc_searches`
--
ALTER TABLE `rc_searches`
  ADD CONSTRAINT `user_id_fk_searches` FOREIGN KEY (`user_id`) REFERENCES `rc_users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `session_client`
--
ALTER TABLE `session_client`
  ADD CONSTRAINT `session_client_ibfk_1` FOREIGN KEY (`session_name`) REFERENCES `session` (`name`);

--
-- Constraints for table `task_access_clearance`
--
ALTER TABLE `task_access_clearance`
  ADD CONSTRAINT `task_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `task_access` (`id`);

--
-- Constraints for table `task_access_fields`
--
ALTER TABLE `task_access_fields`
  ADD CONSTRAINT `task_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `task_access` (`id`);

--
-- Constraints for table `task_edit_history`
--
ALTER TABLE `task_edit_history`
  ADD CONSTRAINT `task_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `task_edit_history_ibfk_2` FOREIGN KEY (`task_id`) REFERENCES `task_data_1` (`id`);

--
-- Constraints for table `task_edit_history_data`
--
ALTER TABLE `task_edit_history_data`
  ADD CONSTRAINT `task_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `task_edit_history` (`id`);

--
-- Constraints for table `task_favorite`
--
ALTER TABLE `task_favorite`
  ADD CONSTRAINT `task_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `task_favorite_ibfk_2` FOREIGN KEY (`task_id`) REFERENCES `task_data_1` (`id`);

--
-- Constraints for table `task_recent`
--
ALTER TABLE `task_recent`
  ADD CONSTRAINT `task_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `task_recent_ibfk_2` FOREIGN KEY (`task_id`) REFERENCES `task_data_1` (`id`);

--
-- Constraints for table `task_related_access_clearance`
--
ALTER TABLE `task_related_access_clearance`
  ADD CONSTRAINT `task_related_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `task_related_access` (`id`);

--
-- Constraints for table `task_related_access_fields`
--
ALTER TABLE `task_related_access_fields`
  ADD CONSTRAINT `task_related_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `task_related_access` (`id`);

--
-- Constraints for table `task_related_edit_history`
--
ALTER TABLE `task_related_edit_history`
  ADD CONSTRAINT `task_related_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `task_related_edit_history_ibfk_2` FOREIGN KEY (`task_related_id`) REFERENCES `task_related_data_1` (`id`);

--
-- Constraints for table `task_related_edit_history_data`
--
ALTER TABLE `task_related_edit_history_data`
  ADD CONSTRAINT `task_related_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `task_related_edit_history` (`id`);

--
-- Constraints for table `task_related_favorite`
--
ALTER TABLE `task_related_favorite`
  ADD CONSTRAINT `task_related_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `task_related_favorite_ibfk_2` FOREIGN KEY (`task_related_id`) REFERENCES `task_related_data_1` (`id`);

--
-- Constraints for table `task_related_recent`
--
ALTER TABLE `task_related_recent`
  ADD CONSTRAINT `task_related_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `task_related_recent_ibfk_2` FOREIGN KEY (`task_related_id`) REFERENCES `task_related_data_1` (`id`);

--
-- Constraints for table `tools_whoisonline_users`
--
ALTER TABLE `tools_whoisonline_users`
  ADD CONSTRAINT `tools_whoisonline_users_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `user_autologin`
--
ALTER TABLE `user_autologin`
  ADD CONSTRAINT `user_autologin_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `user_password`
--
ALTER TABLE `user_password`
  ADD CONSTRAINT `user_password_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `user_reset_pass`
--
ALTER TABLE `user_reset_pass`
  ADD CONSTRAINT `user_reset_pass_ibfk_1` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `utils_attachment_access_clearance`
--
ALTER TABLE `utils_attachment_access_clearance`
  ADD CONSTRAINT `utils_attachment_access_clearance_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `utils_attachment_access` (`id`);

--
-- Constraints for table `utils_attachment_access_fields`
--
ALTER TABLE `utils_attachment_access_fields`
  ADD CONSTRAINT `utils_attachment_access_fields_ibfk_1` FOREIGN KEY (`rule_id`) REFERENCES `utils_attachment_access` (`id`);

--
-- Constraints for table `utils_attachment_edit_history`
--
ALTER TABLE `utils_attachment_edit_history`
  ADD CONSTRAINT `utils_attachment_edit_history_ibfk_1` FOREIGN KEY (`edited_by`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `utils_attachment_edit_history_ibfk_2` FOREIGN KEY (`utils_attachment_id`) REFERENCES `utils_attachment_data_1` (`id`);

--
-- Constraints for table `utils_attachment_edit_history_data`
--
ALTER TABLE `utils_attachment_edit_history_data`
  ADD CONSTRAINT `utils_attachment_edit_history_data_ibfk_1` FOREIGN KEY (`edit_id`) REFERENCES `utils_attachment_edit_history` (`id`);

--
-- Constraints for table `utils_attachment_favorite`
--
ALTER TABLE `utils_attachment_favorite`
  ADD CONSTRAINT `utils_attachment_favorite_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `utils_attachment_favorite_ibfk_2` FOREIGN KEY (`utils_attachment_id`) REFERENCES `utils_attachment_data_1` (`id`);

--
-- Constraints for table `utils_attachment_recent`
--
ALTER TABLE `utils_attachment_recent`
  ADD CONSTRAINT `utils_attachment_recent_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `utils_attachment_recent_ibfk_2` FOREIGN KEY (`utils_attachment_id`) REFERENCES `utils_attachment_data_1` (`id`);

--
-- Constraints for table `utils_filestorage`
--
ALTER TABLE `utils_filestorage`
  ADD CONSTRAINT `utils_filestorage_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `utils_filestorage_files` (`id`);

--
-- Constraints for table `utils_filestorage_access`
--
ALTER TABLE `utils_filestorage_access`
  ADD CONSTRAINT `utils_filestorage_access_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `utils_filestorage` (`id`);

--
-- Constraints for table `utils_filestorage_remote`
--
ALTER TABLE `utils_filestorage_remote`
  ADD CONSTRAINT `utils_filestorage_remote_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `utils_filestorage` (`id`);

--
-- Constraints for table `utils_messenger_message`
--
ALTER TABLE `utils_messenger_message`
  ADD CONSTRAINT `utils_messenger_message_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `utils_messenger_users`
--
ALTER TABLE `utils_messenger_users`
  ADD CONSTRAINT `utils_messenger_users_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `utils_messenger_message` (`id`),
  ADD CONSTRAINT `utils_messenger_users_ibfk_2` FOREIGN KEY (`user_login_id`) REFERENCES `user_login` (`id`);

--
-- Constraints for table `utils_watchdog_category_subscription`
--
ALTER TABLE `utils_watchdog_category_subscription`
  ADD CONSTRAINT `utils_watchdog_category_subscription_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`),
  ADD CONSTRAINT `utils_watchdog_category_subscription_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `utils_watchdog_category` (`id`);

--
-- Constraints for table `utils_watchdog_event`
--
ALTER TABLE `utils_watchdog_event`
  ADD CONSTRAINT `utils_watchdog_event_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `utils_watchdog_category` (`id`);

--
-- Constraints for table `utils_watchdog_subscription`
--
ALTER TABLE `utils_watchdog_subscription`
  ADD CONSTRAINT `utils_watchdog_subscription_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_login` (`id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
