<?php include("include/header1.php"); ?>


<head>
        <!-- common meta tags -->
        <title>Upcoming Events | Volunteer with OVA</title>
        <meta name="description" content="Stay updated on our upcoming volunteer events and workshops. Join us to make a positive impact.">
        <meta name="keywords" content="volunteer events, workshops, volunteer opportunities, social impact, community engagement">
        <meta name="robots" content="index, follow">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta name="language" content="English">
        <link rel="canonical" href="https://www.ova.ngo/event.php">
        <!-- facebook meta tags -->
        <meta property="og:title" content="Upcoming Events | Volunteer with OVA">
        <meta property="og:description" content="Stay updated on our upcoming volunteer events and workshops. Join us to make a positive impact.">
        <meta property="og:image" content="assets/images/logo.png">
        <meta property="og:url" content="https://www.ova.ngo/event.php">

        <!-- Twiiter meta tags -->
        <meta name="twitter:title" content="Upcoming Events | Volunteer with OVA">
        <meta name="twitter:description" content="Stay updated on our upcoming volunteer events and workshops. Join us to make a positive impact.">
        <meta name="twitter:url" content="https://www.ova.ngo/event.php">
        <meta name="twitter:card" content="summary">
    </head> 

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<?php 
if (isset($_POST['id'])) {
  $rty1=$conn->prepare("SELECT * FROM events WHERE id=? AND delete_status= 0");
$rty1->execute([$_POST['id']]); // code...
}
if (isset($_GET['id'])) {
     $rty1=$conn->prepare("SELECT * FROM events WHERE id=? AND delete_status= 0");
      $rty1->execute([$_GET['id']]); 
}

$roy1=$rty1->fetch();
 $date = $roy1['event_date']; 
    $time=$roy1['time'];
// Convert the date to the desired format
$formattedDate = date('M d, Y', strtotime($date));
$timeformat = date('h:i A', strtotime($time));
 ?>
<section class="page-title bg-background-area" data-bg="../../assets/images/bg2.jpg">
    <div class="overlay"></div>
   <div class="page-title-container">
      <div class="page-title-wrapper">
         <div class="container">
            <div class="row">
               <div class="col col-xs-12">
                  <h2><?php echo $roy1['name1'];?> </h2>
                  <ol class="breadcrumb">
                     <li><a href="../.././">Home</a></li>
                     <li><?php echo $roy1['name1'];?> </li>
                  </ol>
               </div>
            </div>
            <!-- end row -->
         </div>
         <!-- end container -->
      </div>
   </div>
</section>
<!-- start event-single-section -->
<section class="event-single-section section-padding data-bg-image" data-background="../../assets/images/connecting.png">
   <div class="container">
      <div class="row">
         <div class="col col-lg-10 col-lg-offset-1">
            <div class="row">
               <div class="col col-md-9">
                  <div class="event-single-img">
                     <img src="../../panel/assets/images/<?php echo $roy1['photo'];?>" alt="volunteer events">
                  </div>
               </div>
               <div class="col col-md-3">
                  <div class="event-info">
                     <h3>Event info</h3>
                     <ul>
                        <li>
                           <i class="fi flaticon-alarm"></i>
                           <h5>time</h5>
                           <p><?php echo $formattedDate."<br>".$timeformat ?></p>
                        </li>
                        <li>
                           <i class="fi flaticon-down-arrow-3"></i>
                           <h5>Address</h5>
                           <p><?php echo html_entity_decode($roy1['address']) ;?></p>
                        </li>
                        <li>
                           <i class="fi flaticon-like"></i>
                           <h5>Organization</h5>
                           <p><?php echo $row['address'];?></p>
                        </li>
                        <li>
                           <i class="fi flaticon-envelope"></i>
                           <h5>Contact</h5>
                           <p><?php echo $row['email'];?></p>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col col-lg-12">
                  <div class="event-text">
                     <h2><?php echo $roy1['name1'];?></h2>
                     <p class="text-justify">
                        <?php echo html_entity_decode($roy1['description']) ;?>
                     </p>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <!-- end container -->
</section>
<section class="container mb-4">
   <div class="row popup-gallery">
         <?php 
$stm123=$conn->prepare("SELECT * FROM images where event_id = ?");
$stm123->execute([$roy1['id']]);
$ro123=$stm123->fetchAll();
foreach ($ro123 as $ke123) {
 
  
?>
       
         <div class="col-md-4">
            <a href="../../panel/assets/images/<?php echo $ke123['photo'];?>" class="image-overlay" alt="workshops">
               <img src="../../panel/assets/images/<?php echo $ke123['photo'];?>">
               <div class="overlay">
                <i class="fa fa-eye"></i><br>
                
            </div>
            </a>
         </div>
         <?php } ?>
</div>
</section>
<!-- end event-single-section -->
<?php include("include/footer1.php"); ?>
<script>
   $(document).ready(function() {
   $('.popup-gallery').magnificPopup({
      delegate: 'a',
      type: 'image',
      tLoading: 'Loading image #%curr%...',
      mainClass: 'mfp-img-mobile',
      gallery: {
         enabled: true,
         navigateByImgClick: true,
         preload: [0,1] // Will preload 0 - before current, and 1 after the current image
      },
      image: {
         tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
         titleSrc: function(item)
      }
   });
});
</script>