;(function ($, window, document, undefined) {
    var pluginName = "editable",
        defaults = {
            rows: false,
            dropdowns: {},
            edit: function() {},
            save: function() {},
            cancel: function() {}
        };

    var _this = null;

    function editable(element, options) {
        this.element = element;
        this.options = $.extend({}, defaults, options) ;

        this._defaults = defaults;
        this._name = pluginName;

        _this = this;
        this.init();
    }

    editable.prototype = {
        init: function() {
            var instance = this;
            this.editing = false;

            $('body, .dataTable td').bind('click', function(e) {
                instance.cancel();
            });

            var tr = $(this.element);
            tr.find('td').bind('click', function(e) {
                if (!instance.editing) {
                    e.stopPropagation();
                    instance.edit.call(this, instance);
                }
                $(this).find('select, input').bind('click', function(ei) {
                    ei.stopPropagation();
                });
            });
        },

        edit: function(instance) {
            var td = this;

            if (_this.options.rows)
                return;
            _this.options.rows = true;

            var input,
                field = $(this).data('field'),
                type = $(this).data('type'),
                value = $(this).text();
            
            if(!type) return;

            $(this).empty();
    
            if (type == 'select' && field in instance.options.dropdowns) {
                input = $('<select></select>');

                for (var i = 0; i < instance.options.dropdowns[field].fields.length; i++) {
                    $('<option value="' + instance.options.dropdowns[field].fields[i].value + '"></option>')
                         .text(instance.options.dropdowns[field].fields[i].name)
                         .appendTo(input);
                };
                input.val(value).data('old-value', value)
            } else if (type == 'date') {
                input = $('<input type="text" />')
                    .val(value)
                    .data('old-value', value);

                $(input).datepicker({ format: 'dd-mm-yyyy', weekStart: 1 });
                $(input).datepicker("update", moment(value, 'DD-MM-YYYY HH:mm').format('DD-MM-YYYY'));
            } else if (type == 'text') {
                input = $('<input type="text" />')
                    .val(value)
                    .data('old-value', value);
            }
            input.appendTo(this).focus().after('\
                <div style="text-align:center;margin-top: 6px;">\
                    <button type="button" class="button btn btn-xs btn-primary" style="width: 48%;">Save</button>\
                    <button type="button" class="button btn btn-xs btn-default" style="width: 48%;">Cancel</button>\
                </div>\
            ');
            instance.editing = true;

            $(td).find('.btn-primary').click(function(e) {
                e.stopPropagation();
                instance.save();
            });
            $(td).find('.btn-default').click(function(e) {
                e.stopPropagation();
                instance.cancel();
            });
        },
        save: function() {
            var instance = this,
                values = {};

            $('td[data-field]', this.element).each(function() {
                var value = $(':input', this).val();

                values[$(this).data('field')] = value;

                $(this).text(value);
            });

            instance.editing = false;
            this.options.save.bind(this.element)(values);
            _this.options.rows = false;
        },
        cancel: function() {
            var instance = this;

            $('td[data-field]', this.element).each(function() {
                var value = $(':input', this).data('old-value');
                $(this).text(value);
            });

            instance.editing = false;
            _this.options.rows = false;
        },
    };

    $.fn[pluginName] = function(options) {
        this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName,
                new editable(this, options));
            }
        });
        return _this;
    };

})(jQuery, window, document);