

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `gedview430`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blocks`
--

CREATE TABLE `[[dbprefix]]blocks` (
  `b_id` int(11) NOT NULL,
  `b_username` varchar(100) DEFAULT NULL,
  `b_location` varchar(30) DEFAULT NULL,
  `b_order` int(11) DEFAULT NULL,
  `b_name` varchar(255) DEFAULT NULL,
  `b_config` text,
  PRIMARY KEY (`b_id`),
  KEY `[[dbprefix]]blocks_username` (`b_username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dates`
--

CREATE TABLE `[[dbprefix]]dates` (
  `d_day` tinyint(3) unsigned NOT NULL,
  `d_month` char(5) DEFAULT NULL,
  `d_mon` tinyint(3) unsigned NOT NULL,
  `d_year` smallint(6) NOT NULL,
  `d_julianday1` mediumint(8) unsigned NOT NULL,
  `d_julianday2` mediumint(8) unsigned NOT NULL,
  `d_fact` varchar(15) NOT NULL,
  `d_gid` varchar(20) NOT NULL,
  `d_file` smallint(5) unsigned NOT NULL,
  `d_type` enum('@#DGREGORIAN@','@#DJULIAN@','@#DHEBREW@','@#DFRENCH R@','@#DHIJRI@','@#DROMAN@') NOT NULL,
  KEY `[[dbprefix]]date_day` (`d_day`),
  KEY `[[dbprefix]]date_month` (`d_month`),
  KEY `[[dbprefix]]date_mon` (`d_mon`),
  KEY `[[dbprefix]]date_year` (`d_year`),
  KEY `[[dbprefix]]date_julianday1` (`d_julianday1`),
  KEY `[[dbprefix]]date_julianday2` (`d_julianday2`),
  KEY `[[dbprefix]]date_gid` (`d_gid`),
  KEY `[[dbprefix]]date_file` (`d_file`),
  KEY `[[dbprefix]]date_type` (`d_type`),
  KEY `[[dbprefix]]date_fact_gid` (`d_fact`,`d_gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]families`
--

CREATE TABLE `[[dbprefix]]families` (
  `f_id` varchar(20) NOT NULL,
  `f_file` smallint(5) unsigned NOT NULL,
  `f_husb` varchar(20) DEFAULT NULL,
  `f_wife` varchar(20) DEFAULT NULL,
  `f_chil` text,
  `f_gedcom` longtext,
  `f_numchil` int(11) DEFAULT NULL,
  PRIMARY KEY (`f_id`,`f_file`),
  KEY `[[dbprefix]]fam_id` (`f_id`),
  KEY `[[dbprefix]]fam_file` (`f_file`),
  KEY `[[dbprefix]]fam_husb` (`f_husb`),
  KEY `[[dbprefix]]fam_wife` (`f_wife`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorites`
--

CREATE TABLE `[[dbprefix]]favorites` (
  `fv_id` int(11) NOT NULL,
  `fv_username` varchar(30) DEFAULT NULL,
  `fv_gid` varchar(20) NOT NULL,
  `fv_type` varchar(15) DEFAULT NULL,
  `fv_file` varchar(100) DEFAULT NULL,
  `fv_url` varchar(255) DEFAULT NULL,
  `fv_title` varchar(255) DEFAULT NULL,
  `fv_note` text,
  PRIMARY KEY (`fv_id`),
  KEY `[[dbprefix]]favorites_username` (`fv_username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gedcom`
--

CREATE TABLE `[[dbprefix]]gedcom` (
  `gedcom_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gedcom_name` varchar(255) NOT NULL,
  PRIMARY KEY (`gedcom_id`),
  UNIQUE KEY `[[dbprefix]]gedcom_ux1` (`gedcom_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gedcom_setting`
--

CREATE TABLE `[[dbprefix]]gedcom_setting` (
  `gedcom_id` smallint(5) unsigned NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`gedcom_id`,`setting_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hit_counter`
--

CREATE TABLE `[[dbprefix]]hit_counter` (
  `gedcom_id` int(10) unsigned NOT NULL,
  `page_name` varchar(32) NOT NULL,
  `page_parameter` varchar(32) NOT NULL,
  `page_count` int(11) NOT NULL,
  PRIMARY KEY (`gedcom_id`,`page_name`,`page_parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]individuals`
--

CREATE TABLE `[[dbprefix]]individuals` (
  `i_id` varchar(20) NOT NULL,
  `i_file` smallint(5) unsigned NOT NULL,
  `i_rin` varchar(20) NOT NULL,
  `i_isdead` int(11) NOT NULL,
  `i_sex` char(1) NOT NULL,
  `i_gedcom` longtext NOT NULL,
  PRIMARY KEY (`i_id`,`i_file`),
  KEY `[[dbprefix]]indi_id` (`i_id`),
  KEY `[[dbprefix]]indi_file` (`i_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ip_address`
--

CREATE TABLE `[[dbprefix]]ip_address` (
  `ip_address` varchar(40) NOT NULL,
  `category` varchar(32) NOT NULL,
  `comment` varchar(255) NOT NULL,
  PRIMARY KEY (`ip_address`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]link`
--

CREATE TABLE `[[dbprefix]]link` (
  `l_file` smallint(5) unsigned NOT NULL,
  `l_from` varchar(20) NOT NULL,
  `l_type` varchar(15) NOT NULL,
  `l_to` varchar(20) NOT NULL,
  PRIMARY KEY (`l_from`,`l_file`,`l_type`,`l_to`),
  UNIQUE KEY `[[dbprefix]]ux1` (`l_to`,`l_file`,`l_type`,`l_from`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media`
--

CREATE TABLE `[[dbprefix]]media` (
  `m_id` int(11) NOT NULL,
  `m_media` varchar(20) NOT NULL,
  `m_ext` varchar(6) DEFAULT NULL,
  `m_titl` varchar(255) DEFAULT NULL,
  `m_file` varchar(255) DEFAULT NULL,
  `m_gedfile` smallint(5) unsigned NOT NULL,
  `m_gedrec` longtext,
  PRIMARY KEY (`m_id`),
  KEY `[[dbprefix]]m_media` (`m_media`),
  KEY `[[dbprefix]]m_media_file` (`m_media`,`m_gedfile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media_mapping`
--

CREATE TABLE `[[dbprefix]]media_mapping` (
  `mm_id` int(11) NOT NULL,
  `mm_media` varchar(20) NOT NULL,
  `mm_gid` varchar(20) NOT NULL DEFAULT '',
  `mm_order` int(11) NOT NULL DEFAULT '0',
  `mm_gedfile` smallint(5) unsigned NOT NULL,
  `mm_gedrec` longtext,
  PRIMARY KEY (`mm_id`),
  KEY `[[dbprefix]]mm_media_id` (`mm_media`,`mm_gedfile`),
  KEY `[[dbprefix]]mm_media_gid` (`mm_gid`,`mm_gedfile`),
  KEY `[[dbprefix]]mm_media_gedfile` (`mm_gedfile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `m_id` int(11) NOT NULL,
  `m_from` varchar(255) DEFAULT NULL,
  `m_to` varchar(30) DEFAULT NULL,
  `m_subject` varchar(255) DEFAULT NULL,
  `m_body` text,
  `m_created` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`m_id`),
  KEY `[[dbprefix]]messages_to` (`m_to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module`
--

CREATE TABLE `[[dbprefix]]module` (
  `mod_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mod_name` varchar(40) NOT NULL,
  `mod_description` varchar(255) NOT NULL,
  `mod_taborder` tinyint(4) NOT NULL,
  `mod_menuorder` tinyint(4) NOT NULL,
  `mod_sidebarorder` tinyint(4) NOT NULL,
  PRIMARY KEY (`mod_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module_privacy`
--

CREATE TABLE `[[dbprefix]]module_privacy` (
  `mp_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mp_mod_id` int(10) unsigned NOT NULL,
  `mp_file` smallint(5) unsigned NOT NULL,
  `mp_access` tinyint(4) NOT NULL,
  `mp_type` char(1) NOT NULL,
  PRIMARY KEY (`mp_id`),
  KEY `[[dbprefix]]module_privacy_ix1` (`mp_mod_id`,`mp_file`,`mp_access`),
  KEY `[[dbprefix]]module_privacy_ix2` (`mp_mod_id`,`mp_access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mutex`
--

CREATE TABLE `[[dbprefix]]mutex` (
  `mx_id` int(11) NOT NULL,
  `mx_name` varchar(255) DEFAULT NULL,
  `mx_thread` varchar(255) DEFAULT NULL,
  `mx_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`mx_id`),
  KEY `[[dbprefix]]mutex_name` (`mx_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]name`
--

CREATE TABLE `[[dbprefix]]name` (
  `n_file` smallint(5) unsigned NOT NULL,
  `n_id` varchar(20) NOT NULL,
  `n_num` int(11) NOT NULL,
  `n_type` varchar(15) NOT NULL,
  `n_sort` varchar(255) NOT NULL,
  `n_full` varchar(255) NOT NULL,
  `n_list` varchar(255) NOT NULL,
  `n_surname` varchar(255) DEFAULT NULL,
  `n_surn` varchar(255) DEFAULT NULL,
  `n_givn` varchar(255) DEFAULT NULL,
  `n_soundex_givn_std` varchar(255) DEFAULT NULL,
  `n_soundex_surn_std` varchar(255) DEFAULT NULL,
  `n_soundex_givn_dm` varchar(255) DEFAULT NULL,
  `n_soundex_surn_dm` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`n_id`,`n_file`,`n_num`),
  KEY `[[dbprefix]]name_file` (`n_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news`
--

CREATE TABLE `[[dbprefix]]news` (
  `n_id` int(11) NOT NULL,
  `n_username` varchar(100) DEFAULT NULL,
  `n_date` int(11) DEFAULT NULL,
  `n_title` varchar(255) DEFAULT NULL,
  `n_text` text,
  PRIMARY KEY (`n_id`),
  KEY `[[dbprefix]]news_username` (`n_username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]nextid`
--

CREATE TABLE `[[dbprefix]]nextid` (
  `ni_id` varchar(20) NOT NULL,
  `ni_type` varchar(15) NOT NULL,
  `ni_gedfile` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`ni_type`,`ni_gedfile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]other`
--

CREATE TABLE `[[dbprefix]]other` (
  `o_id` varchar(20) NOT NULL,
  `o_file` smallint(5) unsigned NOT NULL,
  `o_type` varchar(15) NOT NULL,
  `o_gedcom` longtext,
  PRIMARY KEY (`o_id`,`o_file`),
  KEY `[[dbprefix]]other_id` (`o_id`),
  KEY `[[dbprefix]]other_file` (`o_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]placelinks`
--

CREATE TABLE `[[dbprefix]]placelinks` (
  `pl_p_id` int(11) NOT NULL,
  `pl_gid` varchar(20) NOT NULL,
  `pl_file` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`pl_p_id`,`pl_gid`,`pl_file`),
  KEY `[[dbprefix]]plindex_place` (`pl_p_id`),
  KEY `[[dbprefix]]plindex_gid` (`pl_gid`),
  KEY `[[dbprefix]]plindex_file` (`pl_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]places`
--

CREATE TABLE `[[dbprefix]]places` (
  `p_id` int(11) NOT NULL,
  `p_place` varchar(150) DEFAULT NULL,
  `p_level` int(11) DEFAULT NULL,
  `p_parent_id` int(11) DEFAULT NULL,
  `p_file` smallint(5) unsigned NOT NULL,
  `p_std_soundex` text,
  `p_dm_soundex` text,
  PRIMARY KEY (`p_id`),
  KEY `[[dbprefix]]place_place` (`p_place`),
  KEY `[[dbprefix]]place_level` (`p_level`),
  KEY `[[dbprefix]]place_parent` (`p_parent_id`),
  KEY `[[dbprefix]]place_file` (`p_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]remotelinks`
--

CREATE TABLE `[[dbprefix]]remotelinks` (
  `r_gid` varchar(20) NOT NULL,
  `r_linkid` varchar(255) DEFAULT NULL,
  `r_file` smallint(5) unsigned NOT NULL,
  KEY `[[dbprefix]]r_gid` (`r_gid`),
  KEY `[[dbprefix]]r_link_id` (`r_linkid`),
  KEY `[[dbprefix]]r_file` (`r_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_setting`
--

CREATE TABLE `[[dbprefix]]site_setting` (
  `site_setting_name` varchar(32) NOT NULL,
  `site_setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`site_setting_name`),
  UNIQUE KEY `[[dbprefix]]site_setting_ux1` (`site_setting_name`,`site_setting_value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]site_setting`
--

INSERT INTO `[[dbprefix]]site_setting` VALUES
('PGV_SCHEMA_VERSION', '14');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sources`
--

CREATE TABLE `[[dbprefix]]sources` (
  `s_id` varchar(20) NOT NULL,
  `s_file` smallint(5) unsigned NOT NULL,
  `s_name` varchar(255) DEFAULT NULL,
  `s_gedcom` longtext,
  `s_dbid` char(1) DEFAULT NULL,
  PRIMARY KEY (`s_id`,`s_file`),
  KEY `[[dbprefix]]sour_id` (`s_id`),
  KEY `[[dbprefix]]sour_name` (`s_name`),
  KEY `[[dbprefix]]sour_file` (`s_file`),
  KEY `[[dbprefix]]sour_dbid` (`s_dbid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) NOT NULL,
  `password` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[dbprefix]]user_ux1` (`user_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, '[[admin_username]]', '[[admin_pass]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_gedcom_setting`
--

CREATE TABLE `[[dbprefix]]user_gedcom_setting` (
  `user_id` int(10) unsigned NOT NULL,
  `gedcom_id` smallint(5) unsigned NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`,`gedcom_id`,`setting_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_setting`
--

CREATE TABLE `[[dbprefix]]user_setting` (
  `user_id` int(10) unsigned NOT NULL,
  `setting_name` varchar(32) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`,`setting_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]user_setting`
--

INSERT INTO `[[dbprefix]]user_setting` VALUES
(1, 'firstname', '[[admin_fname]]'),
(1, 'lastname', '[[admin_lname]]'),
(1, 'canadmin', 'Y'),
(1, 'email', '[[admin_email]]'),
(1, 'verified', 'yes'),
(1, 'verified_by_admin', 'yes'),
(1, 'language', 'english'),
(1, 'reg_timestamp', '[[timestamp]]'),
(1, 'loggedin', 'Y'),
(1, 'sessiontime', '[[timestamp]]'),
(1, 'contactmethod', 'messaging2'),
(1, 'visibleonline', 'Y'),
(1, 'editaccount', 'Y'),
(1, 'sync_gedcom', 'N'),
(1, 'relationship_privacy', 'N'),
(1, 'max_relation_path', '2'),
(1, 'auto_accept', 'N');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
