<?php
session_start();
include '../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit();
}

// Get the booking ID from the URL
$bookingId = isset($_GET['id']) ? $_GET['id'] : null;

if ($bookingId) {
    // Fetch the main booking details
    $stmt = $conn->prepare("SELECT * FROM join_member WHERE id = :id AND delete_status = '0'");
    $stmt->bindParam(':id', $bookingId, PDO::PARAM_INT);
    $stmt->execute();
    $booking = $stmt->fetch(PDO::FETCH_ASSOC);

   

    if (!$booking) {
        echo "No booking found for this ID.";
        exit();
    }
} else {
    echo "Invalid booking ID.";
    exit();
}



$currentDateTime = date("Y-m-d H:i:s");


?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Receipt</title>
    <!--<link rel="stylesheet" href="path/to/your/css/style.css"> <!-- Include your CSS here -->
    <style>
        /* Styling for the receipt */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .receipt-container {
            width: 600px;
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        }
        .receipt-container h2 {
            color: #333;
            text-align: center;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .receipt-container p, .receipt-container h3 {
            color: #555;
            margin: 5px 0;
        }
        .receipt-container table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        .receipt-container table, .receipt-container th, .receipt-container td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .receipt-container th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .receipt-container .total {
            font-weight: bold;
            font-size: 18px;
            margin-top: 10px;
            text-align: right;
        }
        .receipt-container .valid-until {
            text-align: right;
            color: #888;
            font-size: 12px;
        }
        .print-button {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #4CAF50;
            color: white;
            text-align: center;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 20px;
        }
        .print-button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <h2> Receipt</h2>
        <p><strong> ID:</strong> <?php echo htmlspecialchars($booking['id']); ?></p>
        <p><strong> Name:</strong> <?php echo htmlspecialchars($booking['name']); ?></p> 
        <p><strong> Contact:</strong> <?php echo htmlspecialchars($booking['phone']); ?></p>
        <p><strong> Email:</strong> <?php echo htmlspecialchars($booking['email']); ?></p>
        <p><strong> Amount:</strong> <?php echo htmlspecialchars($booking['amount']); ?></p>
        <p><strong>Payment Id:</strong> 
            <?php echo htmlspecialchars($paymentMethods[$booking['payment_id']]);  ?>
        </p>
             <p><strong>Date and Time:</strong> <?php echo $currentDateTime; ?></p>
   
                
      
          
        <p><em>Thank you.... !</em></p>
        <button onclick="window.print()">Print this page</button>
        
    </div>
    
</body>

</html>
