<?php
session_start();
include '../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit();
}

// Get the booking ID from the URL
$bookingId = isset($_GET['id']) ? $_GET['id'] : null;


    // Fetch the main booking details
    $stmt = $conn->prepare("SELECT * FROM join_member WHERE id = :id ");
    $stmt->bindParam(':id', $bookingId, PDO::PARAM_INT);
    $stmt->execute();
    $booking = $stmt->fetch(PDO::FETCH_ASSOC);


$currentDateTime = date("Y-m-d H:i:s");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Receipt</title>
    <style>
        /* Styling for the receipt */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .receipt-container {
            width: 600px;
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        }
        .receipt-container h2 {
            color: #333;
            text-align: center;
            margin-bottom: 20px;
            font-size: 28px;
        }
        .receipt-container p, .receipt-container h3 {
            color: #555;
            margin: 5px 0;
        }
        .receipt-container .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #ddd;
        }
        .receipt-container .info-row strong {
            color: #333;
        }
        .total {
            font-weight: bold;
            font-size: 18px;
            text-align: right;
            margin-top: 20px;
        }
        .valid-until {
            text-align: right;
            color: #888;
            font-size: 12px;
            margin-top: 5px;
        }
        .print-button {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #4CAF50;
            color: white;
            text-align: center;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 20px;
        }
        .print-button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <h2>Receipt</h2>
        <div class="info-row">
            <strong>Receipt ID:</strong>
            <span><?php echo htmlspecialchars($booking['id']); ?></span>
        </div>
        <div class="info-row">
            <strong>Name:</strong>
            <span><?php echo htmlspecialchars($booking['name']); ?></span>
        </div>
        <div class="info-row">
            <strong>Contact:</strong>
            <span><?php echo htmlspecialchars($booking['phone']); ?></span>
        </div>
        <div class="info-row">
            <strong>Email:</strong>
            <span><?php echo htmlspecialchars($booking['email']); ?></span>
        </div>
        <div class="info-row">
            <strong>Amount:</strong>
            <span><?php echo htmlspecialchars($booking['amount']); ?></span>
        </div>
        <div class="info-row">
            <strong>Payment ID:</strong>
            <span><?php echo htmlspecialchars($booking['payment_id']); ?></span>
        </div>
        <div class="info-row">
            <strong>Order ID:</strong>
            <span><?php echo htmlspecialchars($booking['order_id']); ?></span>
        </div>
        <div class="info-row">
            <strong>Date and Time:</strong>
            <span><?php echo $currentDateTime; ?></span>
        </div>
        <div class="total">
            <strong>Total Paid:</strong> <?php echo htmlspecialchars($booking['amount']); ?>
        </div>
        <p class="valid-until"><em>Thank you for your booking!</em></p>
        <button class="print-button" onclick="window.print()">Print this page</button>
    </div>
</body>
</html>
