
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `avactis480`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin`
--

CREATE TABLE `[[dbprefix]]admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_firstname` varchar(50) DEFAULT NULL,
  `admin_lastname` varchar(50) DEFAULT NULL,
  `admin_email_address` varchar(50) DEFAULT NULL,
  `admin_password` varchar(50) DEFAULT NULL,
  `admin_old_password` varchar(50) DEFAULT NULL,
  `admin_created` date DEFAULT '0000-00-00',
  `admin_modified` date DEFAULT '0000-00-00',
  `admin_logdate` date DEFAULT '0000-00-00',
  `admin_lognum` int(11) DEFAULT NULL,
  `admin_remember_email` varchar(5) DEFAULT NULL,
  `admin_options` int(11) DEFAULT NULL,
  `admin_lng` char(2) DEFAULT NULL,
  PRIMARY KEY (`admin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]admin`
--

INSERT INTO `[[dbprefix]]admin` VALUES
(1, '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', '[[admin_pass]]', '[[admin_pass]]', '[[reg_time]]', '0000-00-00', '0000-00-00', 0, 'false', 15, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_ip`
--

CREATE TABLE `[[dbprefix]]admin_ip` (
  `admin_ip_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL,
  `admin_ip_address` varchar(20) DEFAULT NULL,
  `admin_ip_incorrect_login_count` int(11) DEFAULT NULL,
  `admin_ip_last_login_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`admin_ip_id`),
  KEY `IDX_ai` (`admin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_pages`
--

CREATE TABLE `[[dbprefix]]admin_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) NOT NULL,
  `classname` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `heading` varchar(255) NOT NULL,
  `help_identifier` varchar(255) NOT NULL,
  `item_value` varchar(255) NOT NULL,
  `onload_js` varchar(255) DEFAULT NULL,
  `parent` varchar(255) NOT NULL,
  PRIMARY KEY (`identifier`),
  KEY `IDX_id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_permissions`
--

CREATE TABLE `[[dbprefix]]admin_permissions` (
  `admin_id` int(11) DEFAULT NULL,
  `permission` int(11) DEFAULT NULL,
  `access_level` int(11) DEFAULT NULL,
  UNIQUE KEY `IDX_ap` (`admin_id`,`permission`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attributes`
--

CREATE TABLE `[[dbprefix]]attributes` (
  `attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_group_id` int(11) NOT NULL DEFAULT '0',
  `input_type_id` int(11) DEFAULT NULL,
  `unit_type` varchar(10) DEFAULT NULL,
  `attribute_view_tag` varchar(100) DEFAULT NULL,
  `attribute_name` varchar(255) DEFAULT NULL,
  `attribute_descr` longtext,
  `attribute_type` varchar(10) DEFAULT NULL,
  `attribute_allow_html` int(11) DEFAULT NULL,
  `attribute_min_value` varchar(255) DEFAULT NULL,
  `attribute_max_value` varchar(255) DEFAULT NULL,
  `attribute_html_size` varchar(255) DEFAULT NULL,
  `attribute_multilang` varchar(1) DEFAULT NULL,
  `attribute_sort_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`attribute_id`),
  KEY `IDX_pagi` (`attribute_group_id`),
  KEY `IDX_iti` (`input_type_id`),
  KEY `IDX_aso` (`attribute_sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=91 ;

--
-- Dumping data for table `[[dbprefix]]attributes`
--

INSERT INTO `[[dbprefix]]attributes` VALUES
(1, 1, 1, 'currency', 'SalePrice', 'PRD_SALEPRC_NAME', 'PRD_SALEPRC_DESCR', 'standard', 0, '0', '15', '15', 'N', 11),
(2, 1, 1, 'currency', 'ListPrice', 'PRD_LISTPRC_NAME', 'PRD_LISTPRC_DESCR', 'standard', 0, '0', '15', '15', 'N', 12),
(3, 1, 1, 'item', 'QuantityInStock', 'PRD_QUINSTOCK_NAME', 'PRD_QUINSTOCK_DESCR', 'standard', 0, '0', '15', '15', 'N', 13),
(6, 1, 1, 'item', 'LowStockLevel', 'PRD_LOWLEV_NAME', 'PRD_LOWLEV_DESCR', 'standard', 0, '0', '15', '15', 'N', 14),
(4, 1, 1, 'string256', 'SKU', 'PRD_SKU_NAME', 'PRD_SKU_DESCR', 'standard', 0, '0', '256', '30', 'N', 15),
(5, 1, 1, 'item', 'MinQuantity', 'PRD_QUINORDER_NAME', 'PRD_QUINORDER_DESCR', 'standard', 0, '0', '15', '15', 'N', 16),
(7, 1, 7, '', 'Available', 'PRD_AVAIL_NAME', 'PRD_AVAIL_DESCR', 'standard', 0, '0', '10', '5', 'N', 17),
(8, 1, 6, '', 'TaxClass', 'PRD_TAX_CLASS_NAME', 'PRD_TAX_CLASS_DESCR', 'standard', 0, '0', '0', '0', 'N', 18),
(24, 1, 8, '', 'Manufacturer', 'PRD_MANUFACTURER_NAME', 'PRD_MANUFACTURER_DESCR', 'standard', 0, '0', '0', '0', 'N', 19),
(27, 1, 1, 'string256', 'UPC', 'PRD_UPC_NAME', 'PRD_UPC_DESCR', 'standard', 0, '0', '15', '15', 'N', 20),
(28, 1, 1, 'string256', 'EAN', 'PRD_EAN_NAME', 'PRD_EAN_DESCR', 'standard', 0, '0', '15', '15', 'N', 21),
(29, 1, 1, 'string256', 'JAN', 'PRD_JAN_NAME', 'PRD_JAN_DESCR', 'standard', 0, '0', '15', '15', 'N', 22),
(30, 1, 1, 'string256', 'ISBN', 'PRD_ISBN_NAME', 'PRD_ISBN_DESCR', 'standard', 0, '0', '15', '15', 'N', 23),
(31, 1, 1, 'string256', 'MPN', 'PRD_MPN_NAME', 'PRD_MPN_DESCR', 'standard', 0, '0', '256', '15', 'N', 24),
(9, 2, 5, '', 'LargeImage', 'PRD_LRGIMG_NAME', 'PRD_LRGIMG_DESCR', 'standard', 0, '0', '0', '0', 'N', 21),
(10, 2, 5, '', 'SmallImage', 'PRD_SMLIMG_NAME', 'PRD_SMLIMG_DESCR', 'standard', 0, '0', '0', '0', 'N', 22),
(11, 2, 1, 'string256', 'ImageAltText', 'PRD_IMGDESCR_NAME', 'PRD_IMGDESCR_DESCR', 'standard', 0, '0', '256', '70', 'Y', 23),
(12, 3, 2, 'mstring', 'ShortDescription', 'PRD_SHRDESCR_NAME', 'PRD_SHRDESCR_DESCR', 'standard', 1, '0', '0', '0', 'Y', 31),
(13, 3, 2, 'mstring', 'DetailedDescription', 'PRD_DETDESCR_NAME', 'PRD_DETDESCR_DESCR', 'standard', 1, '0', '0', '0', 'Y', 32),
(14, 4, 1, 'currency', 'PerItemShippingCost', 'PRD_SHIPPRC_NAME', 'PRD_SHIPPRC_DESCR', 'standard', 0, '0', '15', '15', 'N', 41),
(20, 4, 1, 'currency', 'PerItemHandlingCost', 'PRD_HANDRC_NAME', 'PRD_HANDRC_DESCR', 'standard', 0, '0', '15', '15', 'N', 42),
(15, 4, 1, 'weight', 'Weight', 'PRD_WEIGHT_NAME', 'PRD_WEIGHT_DESCR', 'standard', 0, '0', '15', '15', 'N', 43),
(21, 4, 3, '', 'FreeShipping', 'PRD_FREESHIP_NAME', 'PRD_FREESHIP_DESCR', 'standard', 0, '0', '0', '0', 'N', 44),
(22, 4, 3, '', 'NeedShipping', 'PRD_NEEDSHIP_NAME', 'PRD_NEEDSHIP_DESCR', 'standard', 0, '0', '0', '0', 'N', 45),
(75, 4, 1, 'length', 'Length', 'PRD_LENGTH_NAME', 'PRD_LENGTH_DESCR', 'standard', 0, '0', '15', '15', 'N', 46),
(76, 4, 1, 'length', 'Width', 'PRD_WIDTH_NAME', 'PRD_WIDTH_DESCR', 'standard', 0, '0', '15', '15', 'N', 47),
(77, 4, 1, 'length', 'Height', 'PRD_HEIGHT_NAME', 'PRD_HEIGHT_DESCR', 'standard', 0, '0', '15', '15', 'N', 48),
(17, 5, 1, 'string256', 'PageTitle', 'PRD_PAGETTL_NAME', 'PRD_PAGETTL_DESCR', 'standard', 0, '0', '256', '75', 'Y', 51),
(18, 5, 2, 'string1024', 'MetaKeywords', 'PRD_METAKWRD_NAME', 'PRD_METAKWRD_DESCR', 'standard', 0, '0', '0', '0', 'Y', 52),
(19, 5, 2, 'string1024', 'MetaDescription', 'PRD_METADESCR_NAME', 'PRD_METADESCR_DESCR', 'standard', 0, '0', '0', '0', 'Y', 53),
(23, 5, 1, 'string256', 'SEOPrefix', 'PRD_SEOURL_NAME', 'PRD_SEOURL_DESCR', 'standard', 0, '0', '256', '75', 'Y', 54),
(60, 6, 11, '', 'Gpc', 'Google Product Category', 'Value which is necessary for exporting products to the Google Merchant Center.For more information see http://www.google.com/support/merchants/', 'custom', 0, '0', '255', '0', '', 81),
(61, 6, 12, '', 'Agegroup', 'Age Group', 'Value which is necessary for exporting products to the Google Merchant Center.For more information see http://www.google.com/support/merchants/', 'custom', 0, '0', '255', '0', '', 82),
(62, 6, 13, '', 'Gender', 'Gender', 'Value which is necessary for exporting products to the Google Merchant Center.For more information see http://www.google.com/support/merchants/', 'custom', 0, '0', '255', '0', '', 83),
(63, 6, 1, '', 'Apparelsize', 'Apparel size', 'Value which is necessary for exporting products to the Google Merchant Center.For more information see http://www.google.com/support/merchants/', 'custom', 0, '0', '255', '0', '', 84),
(64, 6, 1, '', 'Apparelcolor', 'Apparel color', 'Value which is necessary for exporting products to the Google Merchant Center.For more information see http://www.google.com/support/merchants/', 'custom', 0, '0', '255', '0', '', 85),
(25, 7, 9, '', 'CustomerReviews', 'PRD_CUSTOMER_REVIEWS_NAME', 'PRD_CUSTOMER_REVIEWS_DESCR', 'standard', 0, '0', '0', '0', 'N', 121),
(26, 8, 10, '', 'MembershipVisibility', 'PRD_MEMBERSHIP_VISIBILITY_NAME', 'PRD_MEMBERSHIP_VISIBILITY_DESCR', 'standard', 0, '0', '0', '0', 'N', 132),
(32, 6, 1, '', 'Author', 'Author(s)', 'The author of a Book or a group of authors', 'custom', NULL, '2', '255', '70', NULL, 2),
(33, 6, 1, '', 'Language', 'Language', 'The language of a book', 'custom', NULL, '2', '255', '70', NULL, 3),
(34, 6, 1, '', 'Pages', 'Number of Pages', 'Number of Pages', 'custom', NULL, '2', '255', '70', NULL, 4),
(35, 6, 1, '', 'Publicationyear', 'Year of Publication', 'The date when book had been published', 'custom', NULL, '2', '255', '70', NULL, 5),
(36, 6, 1, '', 'Releasedate', 'Release Date', 'The date (year) when the CD/DVD was released', 'custom', NULL, '2', '255', '70', NULL, 1),
(37, 6, 1, '', 'Recordlabel', 'Record Label', 'Record Company label', 'custom', NULL, '2', '255', '70', NULL, 2),
(38, 6, 1, '', 'Numberofdisks', 'Number of Disks', 'Number of disks in the product', 'custom', NULL, '2', '255', '70', NULL, 3),
(78, 6, 1, '', 'gc_from', 'From', 'From GC Attribute', 'custom', 0, '2', '255', '70', 'N', 1),
(79, 6, 1, '', 'gc_to', 'To', 'To GC Attr', 'custom', 0, '2', '255', '70', 'N', 2),
(80, 6, 2, '', 'gc_message', 'Message', 'Message GC Attribute', 'custom', 1, '2', '255', '70', 'N', 3),
(81, 6, 1, '', 'gc_email', 'Email', 'Email GC Attribute', 'custom', 0, '2', '255', '70', 'N', 4),
(82, 6, 1, '', 'gc_fname', 'First Name', 'First Name GC Attribute', 'custom', 0, '2', '255', '70', 'N', 5),
(83, 6, 1, '', 'gc_lname', 'Last Name', 'Last Name GC Atribute', 'custom', 0, '2', '255', '70', 'N', 6),
(84, 6, 1, '', 'gc_country_id', 'Country', 'Country GC Attribute', 'custom', 0, '2', '255', '70', 'N', 7),
(85, 6, 1, '', 'gc_state_id', 'State', 'State GC Attribute', 'custom', 0, '2', '255', '70', 'N', 8),
(86, 6, 1, '', 'gc_city', 'City', 'City GC Attribute', 'custom', 0, '2', '255', '70', 'N', 9),
(87, 6, 1, '', 'gc_zip', 'ZipCode', 'ZipCode GC Attribute', 'custom', 0, '2', '255', '70', 'N', 10),
(88, 6, 1, '', 'gc_address', 'Address', 'Address GC Attribute', 'custom', 0, '2', '255', '70', 'N', 11),
(89, 6, 1, '', 'gc_phone', 'Phone', 'Phone GC Attribute', 'custom', 0, '2', '255', '70', 'N', 12),
(90, 6, 1, '', 'gc_sendtype', 'SendType', 'GC Send Type attribute (email or snail mail)', 'custom', 0, '2', '255', '70', 'N', 13);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attribute_groups`
--

CREATE TABLE `[[dbprefix]]attribute_groups` (
  `attribute_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_group_name` varchar(255) DEFAULT NULL,
  `attribute_group_sort_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`attribute_group_id`),
  KEY `IDX_agso` (`attribute_group_sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]attribute_groups`
--

INSERT INTO `[[dbprefix]]attribute_groups` VALUES
(1, 'PT_ATTRGRP_001', 1),
(2, 'PT_ATTRGRP_002', 2),
(3, 'PT_ATTRGRP_003', 3),
(4, 'PT_ATTRGRP_004', 4),
(5, 'PT_ATTRGRP_005', 5),
(6, 'PT_ATTRGRP_006', 8),
(7, 'PT_ATTRGRP_007', 6),
(8, 'PT_ATTRGRP_008', 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners`
--

CREATE TABLE `[[dbprefix]]banners` (
  `bannerid` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(32) NOT NULL DEFAULT 'T',
  `width` int(11) NOT NULL DEFAULT '0',
  `height` int(11) NOT NULL DEFAULT '0',
  `order_by` int(11) NOT NULL DEFAULT '0',
  `start_date` varchar(255) NOT NULL DEFAULT '0',
  `end_date` varchar(255) NOT NULL DEFAULT '0',
  `effect` varchar(255) NOT NULL DEFAULT '',
  `pages` varchar(32) NOT NULL DEFAULT '',
  `nav` varchar(32) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`bannerid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]banners`
--

INSERT INTO `[[dbprefix]]banners` VALUES
(1, 'T', 6500, 500, 0, '1418857200', '1482101999', 'fade', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners_html`
--

CREATE TABLE `[[dbprefix]]banners_html` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bannerid` int(11) NOT NULL DEFAULT '0',
  `code` longtext NOT NULL,
  `avail` varchar(1) NOT NULL DEFAULT 'Y',
  `order_by` int(11) NOT NULL DEFAULT '0',
  `type` varchar(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `IDX_bh` (`bannerid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners_images`
--

CREATE TABLE `[[dbprefix]]banners_images` (
  `imageid` int(11) NOT NULL AUTO_INCREMENT,
  `bannerid` int(11) NOT NULL DEFAULT '0',
  `image_path` varchar(255) NOT NULL DEFAULT '',
  `image_type` varchar(255) NOT NULL DEFAULT 'image/jpeg',
  `image_x` int(11) NOT NULL DEFAULT '0',
  `image_y` int(11) NOT NULL DEFAULT '0',
  `image_size` int(11) NOT NULL DEFAULT '0',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `date` int(11) NOT NULL DEFAULT '0',
  `alt` varchar(255) NOT NULL DEFAULT '',
  `avail` varchar(1) NOT NULL DEFAULT 'Y',
  `order_by` int(11) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`imageid`),
  KEY `IDX_bi` (`bannerid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]banners_images`
--

INSERT INTO `[[dbprefix]]banners_images` VALUES
(1, 1, 'avactis-images/slide1.jpg', 'image/jpeg', 1500, 494, 126463, 'slide1.jpg', 2014, 'slider1', 'Y', 0, '', 'I'),
(2, 1, 'avactis-images/bg.jpg', 'image/jpeg', 1500, 495, 306747, 'bg.jpg', 2014, 'slider2', 'Y', 0, '', 'I'),
(3, 1, 'avactis-images/bg_2.jpg', 'image/jpeg', 1500, 495, 130058, 'bg_2.jpg', 2014, 'slider3', 'Y', 0, '', 'I');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners_settings`
--

CREATE TABLE `[[dbprefix]]banners_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]banners_settings`
--

INSERT INTO `[[dbprefix]]banners_settings` VALUES
(1, 'TOP_BANNER_DEFAULT_WIDTH', '400'),
(2, 'TOP_BANNER_DEFAULT_HEIGHT', '300'),
(3, 'LEFT_BANNER_DEFAULT_WIDTH', '200'),
(4, 'LEFT_BANNER_DEFAULT_HEIGHT', '200'),
(5, 'BANNER_UNLIMITED_TIME', 'N'),
(6, 'RIGHT_BANNER_DEFAULT_WIDTH', '200'),
(7, 'RIGHT_BANNER_DEFAULT_HEIGHT', '200'),
(8, 'BOTTOM_BANNER_DEFAULT_WIDTH', '400'),
(9, 'BOTTOM_BANNER_DEFAULT_HEIGHT', '300');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blocktags_to_action`
--

CREATE TABLE `[[dbprefix]]blocktags_to_action` (
  `blocktag_to_action_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_blocktag_id` int(11) DEFAULT NULL,
  `notification_action_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`blocktag_to_action_id`),
  KEY `IDX_nb` (`notification_blocktag_id`),
  KEY `IDX_na` (`notification_action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]blocktags_to_action`
--

INSERT INTO `[[dbprefix]]blocktags_to_action` VALUES
(1, 1, 1),
(2, 3, 1),
(3, 1, 2),
(4, 3, 2),
(5, 1, 3),
(6, 3, 3),
(7, 2, 4),
(8, 4, 5),
(9, 5, 16),
(10, 5, 17);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bs_links`
--

CREATE TABLE `[[dbprefix]]bs_links` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `bs_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `UNQ_cid_bs` (`category_id`,`bs_id`),
  KEY `IDX_cid` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=262 ;

--
-- Dumping data for table `[[dbprefix]]bs_links`
--

INSERT INTO `[[dbprefix]]bs_links` VALUES
(252, 12, 36, 2),
(251, 12, 32, 1),
(124, 35, 47, 3),
(154, 9, 5, 6),
(150, 9, 43, 2),
(153, 9, 44, 5),
(149, 9, 42, 1),
(261, 1, 65, 8),
(123, 35, 35, 2),
(92, 24, 97, 3),
(93, 24, 37, 4),
(95, 24, 91, 6),
(91, 24, 108, 2),
(41, 38, 65, 1),
(42, 38, 63, 2),
(43, 38, 71, 3),
(260, 1, 156, 7),
(127, 8, 31, 3),
(125, 8, 28, 1),
(106, 11, 130, 1),
(259, 1, 102, 6),
(257, 1, 138, 4),
(256, 1, 130, 3),
(254, 1, 121, 1),
(145, 21, 18, 1),
(143, 20, 8, 1),
(147, 21, 15, 3),
(148, 21, 31, 4),
(160, 39, 122, 1),
(163, 13, 81, 1),
(162, 39, 23, 3),
(164, 13, 5, 2),
(165, 13, 121, 3),
(167, 14, 23, 2),
(168, 14, 19, 3),
(169, 15, 118, 1),
(170, 15, 9, 2),
(171, 15, 119, 3),
(181, 25, 106, 2),
(183, 26, 104, 1),
(184, 26, 99, 2),
(185, 26, 105, 3),
(186, 27, 97, 1),
(188, 27, 91, 3),
(189, 28, 89, 1),
(192, 40, 49, 1),
(193, 40, 51, 2),
(194, 40, 48, 3),
(200, 41, 58, 3),
(204, 42, 63, 1),
(205, 42, 71, 2),
(210, 43, 70, 1),
(211, 43, 68, 2),
(212, 43, 67, 3),
(222, 10, 158, 1),
(223, 10, 102, 2),
(225, 10, 149, 4),
(226, 10, 136, 5),
(224, 10, 156, 3),
(231, 29, 102, 1),
(235, 30, 135, 1),
(236, 30, 136, 2),
(237, 30, 137, 3),
(240, 16, 152, 3),
(241, 32, 155, 1),
(242, 32, 156, 2),
(243, 32, 158, 3),
(248, 33, 161, 2),
(247, 33, 138, 1),
(250, 33, 169, 4),
(253, 12, 33, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bs_settings`
--

CREATE TABLE `[[dbprefix]]bs_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `UNQ_cid_skey` (`category_id`,`setting_key`),
  KEY `IDX_cid` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=245 ;

--
-- Dumping data for table `[[dbprefix]]bs_settings`
--

INSERT INTO `[[dbprefix]]bs_settings` VALUES
(237, 12, 'ADD_BS_FROM_STAT', 'N'),
(238, 12, 'BS_FROM_STAT_COUNT', '5'),
(239, 12, 'BS_FROM_STAT_PERIOD', '2592000'),
(240, 12, 'SHOW_RECURSIVELY', 'N'),
(117, 9, 'ADD_BS_FROM_STAT', 'N'),
(118, 9, 'BS_FROM_STAT_COUNT', '5'),
(119, 9, 'BS_FROM_STAT_PERIOD', '2592000'),
(120, 9, 'SHOW_RECURSIVELY', 'N'),
(93, 35, 'ADD_BS_FROM_STAT', 'N'),
(94, 35, 'BS_FROM_STAT_COUNT', '5'),
(95, 35, 'BS_FROM_STAT_PERIOD', '2592000'),
(96, 35, 'SHOW_RECURSIVELY', 'N'),
(69, 24, 'ADD_BS_FROM_STAT', 'N'),
(70, 24, 'BS_FROM_STAT_COUNT', '5'),
(71, 24, 'BS_FROM_STAT_PERIOD', '2592000'),
(72, 24, 'SHOW_RECURSIVELY', 'N'),
(37, 38, 'ADD_BS_FROM_STAT', 'N'),
(38, 38, 'BS_FROM_STAT_COUNT', '5'),
(39, 38, 'BS_FROM_STAT_PERIOD', '2592000'),
(40, 38, 'SHOW_RECURSIVELY', 'N'),
(97, 8, 'ADD_BS_FROM_STAT', 'N'),
(98, 8, 'BS_FROM_STAT_COUNT', '5'),
(99, 8, 'BS_FROM_STAT_PERIOD', '2592000'),
(100, 8, 'SHOW_RECURSIVELY', 'N'),
(81, 11, 'ADD_BS_FROM_STAT', 'N'),
(82, 11, 'BS_FROM_STAT_COUNT', '5'),
(83, 11, 'BS_FROM_STAT_PERIOD', '2592000'),
(84, 11, 'SHOW_RECURSIVELY', 'N'),
(241, 1, 'ADD_BS_FROM_STAT', 'N'),
(242, 1, 'BS_FROM_STAT_COUNT', '5'),
(243, 1, 'BS_FROM_STAT_PERIOD', '2592000'),
(244, 1, 'SHOW_RECURSIVELY', 'N'),
(109, 20, 'ADD_BS_FROM_STAT', 'N'),
(110, 20, 'BS_FROM_STAT_COUNT', '5'),
(111, 20, 'BS_FROM_STAT_PERIOD', '2592000'),
(112, 20, 'SHOW_RECURSIVELY', 'N'),
(113, 21, 'ADD_BS_FROM_STAT', 'N'),
(114, 21, 'BS_FROM_STAT_COUNT', '5'),
(115, 21, 'BS_FROM_STAT_PERIOD', '2592000'),
(116, 21, 'SHOW_RECURSIVELY', 'N'),
(125, 39, 'ADD_BS_FROM_STAT', 'N'),
(126, 39, 'BS_FROM_STAT_COUNT', '5'),
(127, 39, 'BS_FROM_STAT_PERIOD', '2592000'),
(128, 39, 'SHOW_RECURSIVELY', 'N'),
(129, 13, 'ADD_BS_FROM_STAT', 'N'),
(130, 13, 'BS_FROM_STAT_COUNT', '5'),
(131, 13, 'BS_FROM_STAT_PERIOD', '2592000'),
(132, 13, 'SHOW_RECURSIVELY', 'N'),
(133, 14, 'ADD_BS_FROM_STAT', 'N'),
(134, 14, 'BS_FROM_STAT_COUNT', '5'),
(135, 14, 'BS_FROM_STAT_PERIOD', '2592000'),
(136, 14, 'SHOW_RECURSIVELY', 'N'),
(137, 15, 'ADD_BS_FROM_STAT', 'N'),
(138, 15, 'BS_FROM_STAT_COUNT', '5'),
(139, 15, 'BS_FROM_STAT_PERIOD', '2592000'),
(140, 15, 'SHOW_RECURSIVELY', 'N'),
(145, 19, 'ADD_BS_FROM_STAT', 'N'),
(146, 19, 'BS_FROM_STAT_COUNT', '5'),
(147, 19, 'BS_FROM_STAT_PERIOD', '2592000'),
(148, 19, 'SHOW_RECURSIVELY', 'N'),
(153, 25, 'ADD_BS_FROM_STAT', 'N'),
(154, 25, 'BS_FROM_STAT_COUNT', '5'),
(155, 25, 'BS_FROM_STAT_PERIOD', '2592000'),
(156, 25, 'SHOW_RECURSIVELY', 'N'),
(157, 26, 'ADD_BS_FROM_STAT', 'N'),
(158, 26, 'BS_FROM_STAT_COUNT', '5'),
(159, 26, 'BS_FROM_STAT_PERIOD', '2592000'),
(160, 26, 'SHOW_RECURSIVELY', 'N'),
(161, 27, 'ADD_BS_FROM_STAT', 'N'),
(162, 27, 'BS_FROM_STAT_COUNT', '5'),
(163, 27, 'BS_FROM_STAT_PERIOD', '2592000'),
(164, 27, 'SHOW_RECURSIVELY', 'N'),
(165, 28, 'ADD_BS_FROM_STAT', 'N'),
(166, 28, 'BS_FROM_STAT_COUNT', '5'),
(167, 28, 'BS_FROM_STAT_PERIOD', '2592000'),
(168, 28, 'SHOW_RECURSIVELY', 'N'),
(169, 40, 'ADD_BS_FROM_STAT', 'N'),
(170, 40, 'BS_FROM_STAT_COUNT', '5'),
(171, 40, 'BS_FROM_STAT_PERIOD', '2592000'),
(172, 40, 'SHOW_RECURSIVELY', 'N'),
(177, 41, 'ADD_BS_FROM_STAT', 'N'),
(178, 41, 'BS_FROM_STAT_COUNT', '5'),
(179, 41, 'BS_FROM_STAT_PERIOD', '2592000'),
(180, 41, 'SHOW_RECURSIVELY', 'N'),
(185, 42, 'ADD_BS_FROM_STAT', 'N'),
(186, 42, 'BS_FROM_STAT_COUNT', '5'),
(187, 42, 'BS_FROM_STAT_PERIOD', '2592000'),
(188, 42, 'SHOW_RECURSIVELY', 'N'),
(193, 43, 'ADD_BS_FROM_STAT', 'N'),
(194, 43, 'BS_FROM_STAT_COUNT', '5'),
(195, 43, 'BS_FROM_STAT_PERIOD', '2592000'),
(196, 43, 'SHOW_RECURSIVELY', 'N'),
(205, 10, 'ADD_BS_FROM_STAT', 'N'),
(206, 10, 'BS_FROM_STAT_COUNT', '5'),
(207, 10, 'BS_FROM_STAT_PERIOD', '2592000'),
(208, 10, 'SHOW_RECURSIVELY', 'N'),
(213, 29, 'ADD_BS_FROM_STAT', 'N'),
(214, 29, 'BS_FROM_STAT_COUNT', '5'),
(215, 29, 'BS_FROM_STAT_PERIOD', '2592000'),
(216, 29, 'SHOW_RECURSIVELY', 'N'),
(217, 30, 'ADD_BS_FROM_STAT', 'N'),
(218, 30, 'BS_FROM_STAT_COUNT', '5'),
(219, 30, 'BS_FROM_STAT_PERIOD', '2592000'),
(220, 30, 'SHOW_RECURSIVELY', 'N'),
(221, 16, 'ADD_BS_FROM_STAT', 'N'),
(222, 16, 'BS_FROM_STAT_COUNT', '5'),
(223, 16, 'BS_FROM_STAT_PERIOD', '2592000'),
(224, 16, 'SHOW_RECURSIVELY', 'N'),
(225, 32, 'ADD_BS_FROM_STAT', 'N'),
(226, 32, 'BS_FROM_STAT_COUNT', '5'),
(227, 32, 'BS_FROM_STAT_PERIOD', '2592000'),
(228, 32, 'SHOW_RECURSIVELY', 'N'),
(233, 33, 'ADD_BS_FROM_STAT', 'N'),
(234, 33, 'BS_FROM_STAT_COUNT', '5'),
(235, 33, 'BS_FROM_STAT_PERIOD', '2592000'),
(236, 33, 'SHOW_RECURSIVELY', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]catalog_temp`
--

CREATE TABLE `[[dbprefix]]catalog_temp` (
  `catalog_temp_id` int(11) NOT NULL AUTO_INCREMENT,
  `catalog_temp_form_id` int(11) DEFAULT NULL,
  `catalog_temp_value` longtext,
  PRIMARY KEY (`catalog_temp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_left` int(11) NOT NULL DEFAULT '0',
  `category_right` int(11) NOT NULL DEFAULT '0',
  `category_level` int(11) NOT NULL DEFAULT '0',
  `category_status` int(11) NOT NULL DEFAULT '1',
  `category_sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`),
  KEY `IDX_lrl` (`category_left`,`category_right`,`category_level`),
  KEY `IDX_left` (`category_left`),
  KEY `IDX_right` (`category_right`),
  KEY `IDX_level` (`category_level`),
  KEY `IDX_lr` (`category_left`,`category_right`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=45 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 1, 26, 0, 1, 0),
(12, 22, 23, 1, 1, 0),
(11, 20, 21, 1, 1, 0),
(8, 4, 9, 1, 1, 0),
(20, 5, 6, 2, 1, 0),
(21, 7, 8, 2, 1, 0),
(24, 10, 17, 1, 1, 0),
(25, 11, 12, 2, 1, 0),
(27, 13, 14, 2, 1, 0),
(28, 15, 16, 2, 1, 0),
(33, 18, 19, 1, 1, 0),
(35, 2, 3, 1, 1, 0),
(44, 24, 25, 1, 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories_descr`
--

CREATE TABLE `[[dbprefix]]categories_descr` (
  `category_id` int(11) NOT NULL DEFAULT '0',
  `category_name` varchar(255) NOT NULL DEFAULT '',
  `category_descr` longtext,
  `category_image_file` varchar(255) DEFAULT NULL,
  `category_image_small_file` varchar(255) DEFAULT NULL,
  `category_image_descr` varchar(255) DEFAULT NULL,
  `category_page_title` varchar(255) DEFAULT NULL,
  `category_meta_keywords` text,
  `category_meta_descr` text,
  `category_show_prod_recurs` int(11) NOT NULL DEFAULT '1',
  `category_seo_url_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]categories_descr`
--

INSERT INTO `[[dbprefix]]categories_descr` VALUES
(1, 'Home', 'Description of Home category', '', '', 'Avactis Shopping Cart', 'Avactis PHP shopping cart software', 'avactis, shopping cart, easy shopping cart, php shopping cart, WYSIWYG templates, webstore, webshop, online shop software, e-shop, e-store, e-commerce, store, php, php5, mysql', 'Avactis PHP shopping cart is a software package that allows you to open an online store on the Internet. Easy integration of an online store into an existing website. No programming skills are required to modify the design of online store components: the templates can be edited in any WYSIWYG HTML editor.', 1, 'Avactis_PHP_shopping_cart_software'),
(11, 'Sport', '', 'sport_and_travel_0.png', 'cat_ico_sport_and_travel.gif', 'Sport and Travel', 'Sport and Travel', 'sport, travel, outdoor clothing, camping, tents, equipment, fishing, accessories, waterproof, hiking, clothes, outdoors, rucksacks', 'Sport and Travel', 1, 'Sport_and_Travel'),
(8, 'Computers', '', 'notebooks_and_desktops.png', 'cat_ico_computers.gif', 'Computers', 'Computers', 'laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals', 'All-in-One, Desktop computers, Notebooks and Netbooks', 1, 'Computers'),
(12, 'Digital Distribution', 'Downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution', 'digital_products.png', 'cat_ico_digital_products.gif', 'Digital Distribution', 'Digital Distribution', 'downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution', 'downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution', 1, 'Digital_Distribution'),
(20, 'Notebooks', '', 'notebooks_0.png', 'cat_notebooks.jpg', 'Notebooks', 'Notebooks', 'Notebooks', 'Notebooks', 1, 'Notebooks'),
(21, 'Desktops', '', 'desktops_0.png', 'cat_desktops.jpg', 'Desktops', 'Desktops', 'Desktops', 'Desktops', 1, 'Desktops'),
(24, 'DVD', '', 'dvd.png', 'cat_ico_dvd_0.gif', 'DVD', 'DVD', 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals', 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals', 0, 'DVD'),
(25, 'Classic Films', '', '', 'cat_classic.jpg', 'Classic Films', 'Classic Films', 'Classic Films', 'Classic Films', 1, 'Classic_Films'),
(27, 'Kids DVDs', '', '', 'cat_kids.jpg', 'Kids DVDs', 'Kids DVDs', 'Kids DVDs', 'Kids DVDs', 1, 'Kids_DVDs'),
(28, 'TV on DVD', '', '', 'cat_tv.jpg', 'TV on DVD', 'TV on DVD', 'TV on DVD', 'TV on DVD', 1, 'TV_on_DVD'),
(33, 'Furniture', '', 'furniture.png', 'cat_ico_furniture.gif', 'Furniture', 'Furniture', 'furniture, sofas, beds, mattresses, tables, chairs, decorations', 'furniture, sofas, beds, mattresses, tables, chairs, decorations', 1, 'Furniture'),
(35, 'Apparel', '', 'apparel_and_tshirts.png', 'cat_ico_apparel.gif', 'Apparel', 'Apparel', 'Apparel, custom T-Shirt, T-Shirts, TShirts, Tee Shirts, T-Shirt, TShirt, shirts', 'Apparel, T-Shirts and custom T-Shirts', 1, 'Apparel'),
(44, 'Hot Deals', '', '', '', '', '', '', '', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_activation_keys`
--

CREATE TABLE `[[dbprefix]]ca_activation_keys` (
  `key_id` int(11) NOT NULL AUTO_INCREMENT,
  `key_value` varchar(32) NOT NULL DEFAULT '',
  `customer_account` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`key_id`),
  UNIQUE KEY `UNQ_account` (`customer_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_attrs_to_groups`
--

CREATE TABLE `[[dbprefix]]ca_attrs_to_groups` (
  `ag_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `attr_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `visible_name` varchar(255) NOT NULL DEFAULT '',
  `is_visible` enum('Y','N') DEFAULT 'Y',
  `is_required` enum('Y','N') DEFAULT 'Y',
  PRIMARY KEY (`ag_id`),
  UNIQUE KEY `UNQ_gid_aid` (`group_id`,`attr_id`),
  KEY `attr_id` (`attr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;

--
-- Dumping data for table `[[dbprefix]]ca_attrs_to_groups`
--

INSERT INTO `[[dbprefix]]ca_attrs_to_groups` VALUES
(1, 1, 11, 1, 'Login', 'N', 'N'),
(2, 1, 3, 2, 'E-mail', 'Y', 'Y'),
(3, 1, 12, 3, 'Password', 'Y', 'Y'),
(4, 1, 13, 4, 'Re-Type Password', 'Y', 'Y'),
(5, 1, 1, 5, 'First Name', 'Y', 'Y'),
(6, 1, 2, 6, 'Last Name', 'Y', 'Y'),
(7, 1, 5, 7, 'Country', 'Y', 'N'),
(8, 1, 6, 8, 'State', 'Y', 'N'),
(9, 1, 7, 9, 'ZIP/Postal Code', 'Y', 'N'),
(10, 1, 8, 10, 'City', 'Y', 'N'),
(11, 1, 9, 11, 'Address Line 1', 'Y', 'N'),
(12, 1, 10, 12, 'Address Line 2', 'Y', 'N'),
(13, 1, 4, 13, 'Contact Phone', 'Y', 'N'),
(14, 2, 1, 1, 'First Name', 'Y', 'Y'),
(15, 2, 2, 2, 'Last Name', 'Y', 'Y'),
(16, 2, 3, 3, 'E-mail', 'Y', 'Y'),
(17, 2, 5, 4, 'Country', 'Y', 'Y'),
(18, 2, 6, 5, 'State', 'Y', 'Y'),
(19, 2, 7, 6, 'ZIP/Postal Code', 'Y', 'Y'),
(20, 2, 8, 7, 'City', 'Y', 'Y'),
(21, 2, 9, 8, 'Address Line 1', 'Y', 'Y'),
(22, 2, 10, 9, 'Address Line 2', 'Y', 'Y'),
(23, 2, 4, 10, 'Contact Phone', 'Y', 'Y'),
(24, 3, 1, 1, 'First Name', 'Y', 'Y'),
(25, 3, 2, 2, 'Last Name', 'Y', 'Y'),
(26, 3, 3, 3, 'E-mail', 'Y', 'Y'),
(27, 3, 5, 4, 'Country', 'Y', 'Y'),
(28, 3, 6, 5, 'State', 'Y', 'Y'),
(29, 3, 7, 6, 'ZIP/Postal Code', 'Y', 'Y'),
(30, 3, 8, 7, 'City', 'Y', 'Y'),
(31, 3, 9, 8, 'Address Line 1', 'Y', 'Y'),
(32, 3, 10, 9, 'Address Line 2', 'Y', 'Y'),
(33, 3, 4, 10, 'Contact Phone', 'Y', 'Y');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_customers`
--

CREATE TABLE `[[dbprefix]]ca_customers` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_account` varchar(255) NOT NULL DEFAULT '',
  `customer_password` varchar(32) NOT NULL DEFAULT '',
  `customer_status` enum('A','N','B','R') DEFAULT 'N',
  `affiliate_id` varchar(255) NOT NULL DEFAULT '',
  `customer_lng` char(2) NOT NULL DEFAULT '',
  `notification_lng` char(2) NOT NULL DEFAULT '',
  `group_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `UNQ_account` (`customer_account`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]ca_customers`
--

INSERT INTO `[[dbprefix]]ca_customers` VALUES
(1, 'steve@avactis-demo.com', 'fe01ce2a7fbac8fafaed7c982a04e229', 'A', '', '', '', 1),
(2, 'm.watson@avactis-demo.com', 'ec5b5e548339efcc656ea19fd5e75e1d', 'A', '', '', '', 1),
(3, 'Lewis@avactis-demo.com', 'b05689279f5e41bd1473316121ea4026', 'R', '', '', '', 1),
(4, 'AlexS@avactis-demo.com', 'e582046fb16fb117cb28a7984b63f009', 'R', '', '', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_customer_groups`
--

CREATE TABLE `[[dbprefix]]ca_customer_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]ca_customer_groups`
--

INSERT INTO `[[dbprefix]]ca_customer_groups` VALUES
(1, 'Default'),
(2, 'Unsigned');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_person_info_attrs`
--

CREATE TABLE `[[dbprefix]]ca_person_info_attrs` (
  `attr_id` int(11) NOT NULL AUTO_INCREMENT,
  `attr_name` varchar(255) NOT NULL DEFAULT '',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`attr_id`),
  UNIQUE KEY `UNQ_an` (`attr_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]ca_person_info_attrs`
--

INSERT INTO `[[dbprefix]]ca_person_info_attrs` VALUES
(1, 'FirstName', 'PIA_FIRSTNAME'),
(2, 'LastName', 'PIA_LASTNAME'),
(3, 'Email', 'PIA_EMAIL'),
(4, 'Phone', 'PIA_PHONE'),
(5, 'Country', 'PIA_COUNTRY'),
(6, 'State', 'PIA_STATE'),
(7, 'ZipCode', 'PIA_ZIPCODE'),
(8, 'City', 'PIA_CITY'),
(9, 'Streetline1', 'PIA_STREET_LINE_1'),
(10, 'Streetline2', 'PIA_STREET_LINE_2'),
(11, 'AccountName', 'PIA_ACCOUNT_NAME'),
(12, 'Password', 'PIA_PASSWD_1'),
(13, 'RePassword', 'PIA_PASSWD_2');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_person_info_data`
--

CREATE TABLE `[[dbprefix]]ca_person_info_data` (
  `data_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `ag_id` int(11) NOT NULL DEFAULT '0',
  `data_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`data_id`),
  UNIQUE KEY `UNQ_cid_agid` (`customer_id`,`ag_id`),
  KEY `ag_id` (`ag_id`),
  KEY `data_value` (`data_value`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=122 ;

--
-- Dumping data for table `[[dbprefix]]ca_person_info_data`
--

INSERT INTO `[[dbprefix]]ca_person_info_data` VALUES
(1, 1, 2, 'steve@avactis-demo.com'),
(2, 1, 16, 'steve@avactis-demo.com'),
(3, 1, 26, 'steve@avactis-demo.com'),
(4, 1, 5, 'Steve'),
(5, 1, 14, 'Steve'),
(6, 1, 24, 'Steve'),
(7, 1, 6, 'Irwin'),
(8, 1, 15, 'Irwin'),
(9, 1, 25, 'Irwin'),
(10, 1, 7, '223'),
(11, 1, 17, '223'),
(12, 1, 27, '223'),
(13, 1, 8, '397'),
(14, 1, 18, '397'),
(15, 1, 28, '397'),
(16, 1, 9, '55455'),
(17, 1, 19, '55455'),
(18, 1, 29, '55455'),
(19, 1, 10, 'Minneapolis'),
(20, 1, 20, 'Minneapolis'),
(21, 1, 30, 'Minneapolis'),
(22, 1, 11, 'P.O.Box 1794'),
(23, 1, 21, 'P.O.Box 1794'),
(24, 1, 31, 'P.O.Box 1794'),
(25, 1, 12, '1178 17th St.'),
(26, 1, 22, '1178 17th St.'),
(27, 1, 32, '1178 17th St.'),
(28, 1, 13, ''),
(29, 1, 23, ''),
(30, 1, 33, ''),
(31, 2, 2, 'm.watson@avactis-demo.com'),
(32, 2, 16, 'm.watson@avactis-demo.com'),
(33, 2, 26, 'm.watson@avactis-demo.com'),
(34, 2, 5, 'Mark'),
(35, 2, 14, 'Mark'),
(36, 2, 24, 'Mark'),
(37, 2, 6, 'Watson'),
(38, 2, 15, 'Watson'),
(39, 2, 25, 'Watson'),
(40, 2, 7, '223'),
(41, 2, 17, '223'),
(42, 2, 27, '223'),
(43, 2, 8, '409'),
(44, 2, 18, '409'),
(45, 2, 28, '409'),
(46, 2, 9, '43081'),
(47, 2, 19, '43081'),
(48, 2, 29, '43081'),
(49, 2, 10, 'Westerville'),
(50, 2, 20, 'Westerville'),
(51, 2, 30, 'Westerville'),
(52, 2, 11, '735 Ceramic Place'),
(53, 2, 21, '735 Ceramic Place'),
(54, 2, 31, '735 Ceramic Place'),
(55, 2, 12, ''),
(56, 2, 22, ''),
(57, 2, 32, ''),
(58, 2, 13, '(763)-555-55-88'),
(59, 2, 23, '(763)-555-55-88'),
(60, 2, 33, '(763)-555-55-88'),
(61, 3, 1, 'Lewis@avactis-demo.com'),
(62, 3, 14, 'John'),
(63, 3, 15, 'Lewis'),
(64, 3, 16, 'Lewis@avactis-demo.com'),
(65, 3, 19, '55455'),
(66, 3, 20, 'Minneapolis'),
(67, 3, 21, 'P.O.Box 1794'),
(68, 3, 22, '1178 17th St.'),
(69, 3, 23, '(763)-555-77-56'),
(70, 3, 17, '223'),
(71, 3, 18, '397'),
(72, 3, 24, 'John'),
(73, 3, 25, 'Lewis'),
(74, 3, 26, 'Lewis@avactis-demo.com'),
(75, 3, 29, '55455'),
(76, 3, 30, 'Minneapolis'),
(77, 3, 31, 'P.O.Box 1794'),
(78, 3, 32, '1178 17th St.'),
(79, 3, 33, '(763)-555-77-56'),
(80, 3, 27, '223'),
(81, 3, 28, '397'),
(82, 3, 2, 'Lewis@avactis-demo.com'),
(83, 3, 5, 'John'),
(84, 3, 6, 'Lewis'),
(85, 3, 7, '223'),
(86, 3, 8, '397'),
(87, 3, 9, '55455'),
(88, 3, 10, 'Minneapolis'),
(89, 3, 11, 'P.O.Box 1794'),
(90, 3, 12, '1178 17th St.'),
(91, 3, 13, '(763)-555-77-56'),
(92, 4, 2, 'AlexS@avactis-demo.com'),
(93, 4, 16, 'AlexS@avactis-demo.com'),
(94, 4, 26, 'AlexS@avactis-demo.com'),
(95, 4, 5, 'Alex'),
(96, 4, 14, 'Alex'),
(97, 4, 24, 'Alex'),
(98, 4, 6, 'Smith'),
(99, 4, 15, 'Smith'),
(100, 4, 25, 'Smith'),
(101, 4, 7, '223'),
(102, 4, 17, '223'),
(103, 4, 27, '223'),
(104, 4, 8, '408'),
(105, 4, 18, '408'),
(106, 4, 28, '408'),
(107, 4, 9, '59201'),
(108, 4, 19, '59201'),
(109, 4, 29, '59201'),
(110, 4, 10, 'Grand Forks'),
(111, 4, 20, 'Grand Forks'),
(112, 4, 30, 'Grand Forks'),
(113, 4, 11, 'P.O.Box 1794'),
(114, 4, 21, 'P.O.Box 1794'),
(115, 4, 31, 'P.O.Box 1794'),
(116, 4, 12, '1178 17th St.'),
(117, 4, 22, '1178 17th St.'),
(118, 4, 32, '1178 17th St.'),
(119, 4, 13, '(701)-555-67-21'),
(120, 4, 23, '(701)-555-67-21'),
(121, 4, 33, '(701)-555-67-21');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_person_info_groups`
--

CREATE TABLE `[[dbprefix]]ca_person_info_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `UNQ_gn` (`group_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]ca_person_info_groups`
--

INSERT INTO `[[dbprefix]]ca_person_info_groups` VALUES
(1, 'Customer', 'PIG_CUSTOMER', 1),
(2, 'Billing', 'PIG_BILLING', 2),
(3, 'Shipping', 'PIG_SHIPPING', 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ca_settings`
--

CREATE TABLE `[[dbprefix]]ca_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]ca_settings`
--

INSERT INTO `[[dbprefix]]ca_settings` VALUES
(1, 'AUTH_SCHEME', '2'),
(2, 'ACCOUNT_ACTIVATION_SCHEME', '1'),
(3, 'CHECKOUT_TYPE', '2'),
(4, 'AUTO_CREATE_ACCOUNT', 'Y'),
(5, 'MERGE_ORDERS_BY_EMAIL', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cconv_man_rates`
--

CREATE TABLE `[[dbprefix]]cconv_man_rates` (
  `rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `_from` varchar(10) NOT NULL DEFAULT '',
  `_to` varchar(10) NOT NULL DEFAULT '',
  `rate` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`rate_id`),
  UNIQUE KEY `unq_ft` (`_from`,`_to`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]cconv_man_rates`
--

INSERT INTO `[[dbprefix]]cconv_man_rates` VALUES
(1, 'USD', 'CAD', '0.9523'),
(2, 'USD', 'GBP', '1.5962'),
(3, 'USD', 'EUR', '1.4419'),
(4, 'USD', 'AUD', '0.8845'),
(5, 'USD', 'JPY', '0.0109'),
(6, 'USD', 'ILS', '0.2632'),
(7, 'USD', 'NOK', '0.1729'),
(8, 'USD', 'SEK', '0.1378'),
(9, 'USD', 'NZD', '0.7061');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cconv_rates_cache`
--

CREATE TABLE `[[dbprefix]]cconv_rates_cache` (
  `crate_id` int(11) NOT NULL AUTO_INCREMENT,
  `crate_from` varchar(10) NOT NULL DEFAULT '',
  `crate_to` varchar(10) NOT NULL DEFAULT '',
  `crate_rate` decimal(12,4) NOT NULL DEFAULT '1.0000',
  `crate_expire` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`crate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cconv_temp_cur_rates`
--

CREATE TABLE `[[dbprefix]]cconv_temp_cur_rates` (
  `code` varchar(5) NOT NULL DEFAULT '',
  `rate` decimal(12,4) NOT NULL DEFAULT '1.0000',
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]cconv_temp_cur_rates`
--

INSERT INTO `[[dbprefix]]cconv_temp_cur_rates` VALUES
('USD', 1.0000);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checkout_pm_sm_accepted_currencies`
--

CREATE TABLE `[[dbprefix]]checkout_pm_sm_accepted_currencies` (
  `checkout_pm_sm_accepted_currencies_module_id` varchar(50) NOT NULL DEFAULT '',
  `checkout_pm_sm_accepted_currencies_currency_code` varchar(5) NOT NULL DEFAULT '',
  `checkout_pm_sm_accepted_currencies_currency_status` enum('ACCEPTED','NOT_ACCEPTED','THE_ONE_ONLY_ACCEPTED') NOT NULL DEFAULT 'ACCEPTED',
  PRIMARY KEY (`checkout_pm_sm_accepted_currencies_module_id`,`checkout_pm_sm_accepted_currencies_currency_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checkout_pm_sm_currency_acceptance_rules`
--

CREATE TABLE `[[dbprefix]]checkout_pm_sm_currency_acceptance_rules` (
  `checkout_pm_sm_currency_acceptance_rules_module_id` varchar(50) NOT NULL DEFAULT '',
  `checkout_pm_sm_currency_acceptance_rules_rule_name` enum('ACTIVE_AND_SELECTED_BY_CUSTOMER','ACTIVE_AND_ACCEPTED_BY_PM_SM_AND_SELECTED_BY_CUSTOMER','THE_ONLY_ACCEPTED','MAIN_STORE_CURRENCY') NOT NULL DEFAULT 'MAIN_STORE_CURRENCY',
  `checkout_pm_sm_currency_acceptance_rules_rule_selected` char(5) NOT NULL DEFAULT 'false',
  PRIMARY KEY (`checkout_pm_sm_currency_acceptance_rules_module_id`,`checkout_pm_sm_currency_acceptance_rules_rule_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]checkout_pm_sm_settings`
--

CREATE TABLE `[[dbprefix]]checkout_pm_sm_settings` (
  `checkout_pm_sm_settings_id` int(11) NOT NULL AUTO_INCREMENT,
  `checkout_pm_sm_settings_module_id` varchar(50) DEFAULT NULL,
  `checkout_pm_sm_settings_module_class_name` varchar(255) NOT NULL DEFAULT '',
  `checkout_pm_sm_settings_module_group` varchar(50) DEFAULT NULL,
  `checkout_pm_sm_settings_status_active_value_id` int(11) NOT NULL DEFAULT '0',
  `checkout_pm_sm_settings_status_selected_value_id` int(11) NOT NULL DEFAULT '0',
  `checkout_pm_sm_settings_sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`checkout_pm_sm_settings_id`),
  KEY `IDX_unique` (`checkout_pm_sm_settings_module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]checkout_pm_sm_settings`
--

INSERT INTO `[[dbprefix]]checkout_pm_sm_settings` VALUES
(1, 'AAE28225-3EEF-58E9-318F-92FCA6766E6B', 'Payment_Module_Cod', 'payment', 1, 1, 1),
(2, 'CB532ED3-E330-690E-C5FB-7147B27CA89C', 'Payment_Module_Direct_Deposit', 'payment', 1, 1, 2),
(3, 'BCE5D24D-666C-43CA-94A0-D6F775903BE2', 'Shipping_Module_DSR', 'shipping', 1, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_menu`
--

CREATE TABLE `[[dbprefix]]cms_menu` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_index` varchar(255) NOT NULL DEFAULT '',
  `menu_name` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`menu_id`),
  UNIQUE KEY `menu_index` (`menu_index`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]cms_menu`
--

INSERT INTO `[[dbprefix]]cms_menu` VALUES
(1, 'top_menu', 'Page Top Menu', ''),
(2, 'main_menu', 'Main Menu', ''),
(3, 'footer_menu', 'Footer Menu', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_menu_items`
--

CREATE TABLE `[[dbprefix]]cms_menu_items` (
  `menu_item_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL DEFAULT '0',
  `item_name` varchar(255) NOT NULL DEFAULT '',
  `item_type` int(11) NOT NULL DEFAULT '0',
  `item_link` text,
  `item_status` int(11) NOT NULL DEFAULT '0',
  `param1` varchar(255) NOT NULL DEFAULT '',
  `param2` varchar(255) NOT NULL DEFAULT '',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`menu_item_id`),
  KEY `menu_id` (`menu_id`),
  KEY `item_status` (`item_status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]cms_menu_items`
--

INSERT INTO `[[dbprefix]]cms_menu_items` VALUES
(1, 1, 'My Account', 1, 'sign-in.php', 1, '', '', 1),
(3, 2, 'HOME', 1, 'index.php', 1, '', '', 1),
(6, 3, 'About Us', 4, '3', 1, '', '', 2),
(7, 2, 'MY CART', 2, 'Cart', 1, '', '', 3),
(8, 2, 'GIFT CERTIFICATE', 1, 'gift-certificate.php', 1, '', '', 4),
(9, 2, 'MY ACCOUNT', 2, 'CustomerAccountHome', 1, '', '', 2),
(14, 1, 'Checkout', 1, 'checkout.php', 1, '', '', 3),
(13, 1, 'My cart', 1, 'cart.php', 1, '', '', 2),
(15, 3, 'Contact Us', 4, '8', 1, '', '', 3),
(16, 3, 'Need Help?', 4, '4', 1, '', '', 4),
(18, 3, 'Customer Service', 4, '6', 1, '', '', 6),
(19, 3, 'Privacy statement', 4, '7', 1, '', '', 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cms_pages`
--

CREATE TABLE `[[dbprefix]]cms_pages` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_index` varchar(255) NOT NULL DEFAULT '',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `descr` text,
  `status` varchar(1) NOT NULL DEFAULT 'A',
  `seo_prefix` varchar(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_descr` varchar(255) DEFAULT NULL,
  `seo_keywords` varchar(255) DEFAULT NULL,
  `availability` varchar(1) NOT NULL DEFAULT 'A',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_index` (`page_index`),
  KEY `parent` (`parent_id`),
  KEY `status` (`status`),
  KEY `availability` (`availability`),
  KEY `name` (`name`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]cms_pages`
--

INSERT INTO `[[dbprefix]]cms_pages` VALUES
(2, 'copyright', 0, 'Page Footer Copyright Text', '    <p>Copyright 2014 Your Company Name. All rights reserved.</p> <p>Powered by <a href="http://www.avactis.com/" target="_blank">Avactis Shopping Cart</a>.</p>', 'H', NULL, '', '', '', 'C', 2),
(3, 'about_us', 0, 'About Us', '      <p><i>To edit this sample page simply login to the control panel of Avactis shopping cart, click the &quot;<b>Content</b></i><i>&quot; link on the top-right menu, select the</i><i> <b>&quot;About Us&quot;</b> page and you can edit this page as needed.</i></p><p>The Avactis team was established in 2001. It has extensive experience in the implementation of e-commerce projects for both large companies and medium- and small-sized businesses all over the world. Over this period we implemented dozens of e-commerce projects. Based on this expertise and input from small and medium companies, we developed the <a href="http://www.avactis.com">Avactis shopping cart software</a>, which allows such companies to start online business rapidly and without heavy investments. One of the major advantages of Avactis is the use of unique technologies that, unlike other shopping cart software, provides for the fast and easy integration of an online store into an existing website, thus minimizing the time-to-market for our customers and partners.<br /><br />The company''s headquarters are located in New-York. Moreover, we collaborate with companies in Tokyo, Japan and Russia, in order to provide the highest level of service to our customers. The Avactis team includes highly skilled software developers, web designers, customer support engineers, sales and marketing professionals, who create and support Avactis e-commerce solutions for our partners and users worldwide.<br /><br />Our organization''s mission is the delivery of high quality e-commerce products and services for small and medium companies, which will allow them to maintain a successful online business. The success of our customers and partners is our success as well.</p>', 'A', NULL, 'About Us', 'About Us', 'About Us', 'C', 3),
(4, 'customer_help', 0, 'Need Help?', '          <p><i>To edit this sample page simply login to the control panel of Avactis shopping cart, click the &quot;<b>Content</b></i><i>&quot; link on the top-right menu, select the</i><i>&nbsp;</i><i><b>&quot;Need Help?&quot;</b> page and you can edit this page as needed.</i></p><ul><li><b><a href="forgot-password.php">Forgot Password</a></b></li></ul><ul><li><b><a href="change-password.php">Change Password</a></b></li></ul><ul><li><b><a href="personal-info.php">Manage personal information</a></b></li></ul><ul><li><b><a href="home.php">View Orders</a></b></li></ul>Feel free to contact us if you need any help.<p>&nbsp;</p><i></i>', 'A', NULL, 'customer_help', 'Need Help', 'Need Help', 'C', 4),
(6, 'customer_service', 0, 'Customer Service', '            <p><i>To edit this sample page simply login to the control panel of Avactis shopping cart, click the &quot;<b>Content</b></i><i>&quot; link on the top-right menu, select the</i><i> </i><i><b>&quot;Customer Service&quot;</b> page and you can edit this page as needed.</i></p><p><b>Shipping &amp; Delivery</b><br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec egestas nulla ut tellus congue ornare. Donec dignissim, quam vitae consectetur sodales, enim lorem rutrum est, a molestie lacus metus in nulla. Ut porta diam sit amet mi pretium accumsan. Cras at consequat tortor. Curabitur et lacus nibh. Curabitur vitae massa mi. Mauris faucibus, sem in faucibus auctor, sem ligula blandit risus, et luctus justo lacus eget est. Maecenas suscipit aliquet erat, vitae ullamcorper odio faucibus a. Aenean nec eros id orci faucibus egestas. In id odio eu diam laoreet ultricies at et risus. Integer volutpat mauris vitae tellus porttitor fringilla. Duis vel urna ac lectus eleifend rhoncus sit amet nec neque. Proin condimentum magna sit amet leo blandit iaculis. Integer varius ante vel erat vestibulum molestie nec eu mi. Quisque malesuada ligula vel lectus porta pharetra. Morbi consequat sapien in tortor consectetur sit amet euismod diam sollicitudin. Integer id velit eget ligula tempor fringilla. Fusce bibendum pretium iaculis. In hac habitasse platea dictumst. Nullam pretium aliquet eros, nec ornare lectus laoreet at.<br /><br /><b>Returns &amp; Replacements</b><br /><br />Nam iaculis porttitor volutpat. Sed dui odio, rhoncus vel rhoncus et, ultricies id nisi. Duis luctus congue felis, non mollis odio volutpat hendrerit. Curabitur vel dui metus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Fusce eu metus a ligula ornare lobortis sed fringilla nunc. Maecenas accumsan mauris sed neque accumsan ac eleifend quam vestibulum. Nunc vulputate egestas quam, a ultricies nunc pulvinar vel. Morbi sit amet lorem nunc, et sodales nulla. Nulla pretium mi ut orci porta lobortis. Etiam luctus tellus ornare mi vestibulum ultrices nec non elit. Sed a diam lectus.<br /><br />Vestibulum ornare, metus nec auctor hendrerit, nunc libero malesuada erat, pharetra gravida odio libero et quam. Nulla fermentum auctor pellentesque. In placerat nisi sit amet nulla ornare dictum. Curabitur faucibus, quam vulputate porttitor tempor, erat diam elementum enim, sit amet consequat lorem eros quis enim. Curabitur dignissim, turpis pellentesque adipiscing fringilla, eros magna condimentum nunc, et mollis arcu libero eget tortor. Sed at nunc erat. Ut felis nisi, mollis a pulvinar vel, dapibus quis tellus. Fusce ultrices, odio vitae dapibus vehicula, metus ligula euismod nibh, vel pharetra massa lorem at arcu. Cras tempor, enim et pharetra ornare, urna nunc varius justo, sit amet cursus turpis sapien non velit. Nulla eleifend facilisis ipsum sed ornare. Integer sit amet diam metus, eget suscipit felis. Pellentesque vel odio turpis, id facilisis risus. Vestibulum ultrices porta eros, eget imperdiet magna malesuada ac. Cras vitae velit elit. Donec vitae elit nulla, vel mollis dui. Nunc interdum molestie enim convallis ullamcorper. Cras euismod odio ut justo semper venenatis pharetra nulla egestas.</p>', 'A', NULL, 'Customer Service', 'Customer Service', 'Customer Service', 'C', 6),
(7, 'privacy_statement', 0, 'Privacy statement', '        <p><i>To edit this sample page simply login to the control panel of Avactis shopping cart, click the &quot;<b>Content</b></i><i>&quot; link on the top-right menu, select the</i><i> </i><i><b>&quot;Privacy statement&quot;</b> page and you can edit this page as needed.</i></p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec egestas nulla ut tellus congue ornare. Donec dignissim, quam vitae consectetur sodales, enim lorem rutrum est, a molestie lacus metus in nulla. Ut porta diam sit amet mi pretium accumsan. Cras at consequat tortor. Curabitur et lacus nibh. Curabitur vitae massa mi. Mauris faucibus, sem in faucibus auctor, sem ligula blandit risus, et luctus justo lacus eget est. Maecenas suscipit aliquet erat, vitae ullamcorper odio faucibus a. Aenean nec eros id orci faucibus egestas. In id odio eu diam laoreet ultricies at et risus. Integer volutpat mauris vitae tellus porttitor fringilla. Duis vel urna ac lectus eleifend rhoncus sit amet nec neque. Proin condimentum magna sit amet leo blandit iaculis. Integer varius ante vel erat vestibulum molestie nec eu mi. Quisque malesuada ligula vel lectus porta pharetra. Morbi consequat sapien in tortor consectetur sit amet euismod diam sollicitudin. Integer id velit eget ligula tempor fringilla. Fusce bibendum pretium iaculis. In hac habitasse platea dictumst. Nullam pretium aliquet eros, nec ornare lectus laoreet at.<br /><br />Nam iaculis porttitor volutpat. Sed dui odio, rhoncus vel rhoncus et, ultricies id nisi. Duis luctus congue felis, non mollis odio volutpat hendrerit. Curabitur vel dui metus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Fusce eu metus a ligula ornare lobortis sed fringilla nunc. Maecenas accumsan mauris sed neque accumsan ac eleifend quam vestibulum. Nunc vulputate egestas quam, a ultricies nunc pulvinar vel. Morbi sit amet lorem nunc, et sodales nulla. Nulla pretium mi ut orci porta lobortis. Etiam luctus tellus ornare mi vestibulum ultrices nec non elit. Sed a diam lectus.</p><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="font-family: Arial,Helvetica,sans; font-size: 11px; text-align: justify"></span></span>', 'A', NULL, 'Privacy statement', 'Privacy statement', 'Privacy statement', 'C', 7),
(8, 'contact_us', 0, 'Contact Us', '                  <p><i>To edit this sample page simply login to the control panel of Avactis shopping cart, click the &quot;<b>Content</b></i><i>&quot; link on the top-right menu, select the</i><i> </i><i><b>&quot;Contact Us&quot;</b> page and you can edit this page as needed.</i></p><p>Do you have a question or comment? Feel free to contact us anytime:<span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="font-family: arial,helvetica; font-size: 12px"><br /></span></span></p><ul><li><b><a href="https://www.avactis.com/support.php">https://www.Avactis.com/support.php</a></b></li></ul>Follow us on Twitter:<br /><ul><li><b><a href="http://www.twitter.com/Avactis">http://www.twitter.com/Avactis</a></b></li></ul>Join us on Facebook:<br /><ul><li><b><a href="http://www.facebook.com/Avactis">http://www.facebook.com/Avactis</a></b></li></ul>', 'A', NULL, 'Contact Us page', 'Contact Us', 'Contact Us', 'C', 8),
(9, 'welcome_text', 0, 'Welcome text', '<p><font size="3"><b><font size="2">Welcome to Avactis Shopping Cart!  </font></b></font></p><p>This is a demonstration store powered by <a href="http://www.avactis.com">Avactis shopping cart software</a>. You can browse products catalog, put products into your cart, rate and review products. </p><p>As an administrator, you can add new products and categories, change the look and feel of the store, edit texts or add new CMS pages using built-in WYSIWYG editor. </p>This is <b><u>not</u> </b>a live store. Please <b><u>do not</u></b> enter real credit card details.<br /><br /><br />', 'A', NULL, '', '', '', 'C', 9),
(10, 'right_banner', 0, 'Build your Mac banner', '          <p><a href="product-info.php?Apple_iMac_Desktop-pid3.html"><img src="avactis-images/u/banner_mac.png" alt="Build your Mac" border="0" height="178" width="200" /></a></p>', 'H', NULL, '', '', '', 'C', 10);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]color_swatch`
--

CREATE TABLE `[[dbprefix]]color_swatch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `main_image` text NOT NULL,
  `checked_image` text,
  `label_text` varchar(255) NOT NULL DEFAULT 'Select Color',
  `number_of_colors` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_name` varchar(50) DEFAULT NULL,
  `country_code` varchar(5) DEFAULT NULL,
  `country_code3` varchar(5) DEFAULT NULL,
  `country_active` char(5) DEFAULT NULL,
  `country_default` char(5) DEFAULT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=238 ;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
(1, 'Afghanistan', 'AF', 'AFG', 'false', 'false'),
(2, 'Albania', 'AL', 'ALB', 'false', 'false'),
(3, 'Algeria', 'DZ', 'DZA', 'false', 'false'),
(4, 'American Samoa', 'AS', 'ASM', 'false', 'false'),
(5, 'Andorra', 'AD', 'AND', 'false', 'false'),
(6, 'Angola', 'AO', 'AGO', 'false', 'false'),
(7, 'Anguilla', 'AI', 'AIA', 'false', 'false'),
(8, 'Antarctica', 'AQ', 'ATA', 'false', 'false'),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 'false', 'false'),
(10, 'Argentina', 'AR', 'ARG', 'false', 'false'),
(11, 'Armenia', 'AM', 'ARM', 'false', 'false'),
(12, 'Aruba', 'AW', 'ABW', 'false', 'false'),
(13, 'Australia', 'AU', 'AUS', 'true', 'false'),
(14, 'Austria', 'AT', 'AUT', 'true', 'false'),
(15, 'Azerbaijan', 'AZ', 'AZE', 'false', 'false'),
(16, 'Bahamas', 'BS', 'BHS', 'false', 'false'),
(17, 'Bahrain', 'BH', 'BHR', 'false', 'false'),
(18, 'Bangladesh', 'BD', 'BGD', 'false', 'false'),
(19, 'Barbados', 'BB', 'BRB', 'false', 'false'),
(20, 'Belarus', 'BY', 'BLR', 'false', 'false'),
(21, 'Belgium', 'BE', 'BEL', 'true', 'false'),
(22, 'Belize', 'BZ', 'BLZ', 'false', 'false'),
(23, 'Benin', 'BJ', 'BEN', 'false', 'false'),
(24, 'Bermuda', 'BM', 'BMU', 'false', 'false'),
(25, 'Bhutan', 'BT', 'BTN', 'false', 'false'),
(26, 'Bolivia', 'BO', 'BOL', 'false', 'false'),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', 'false', 'false'),
(28, 'Botswana', 'BW', 'BWA', 'false', 'false'),
(29, 'Bouvet Island', 'BV', 'BVT', 'false', 'false'),
(30, 'Brazil', 'BR', 'BRA', 'false', 'false'),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 'false', 'false'),
(32, 'British Virgin Islands', 'VG', 'VGB', 'false', 'false'),
(33, 'Brunei Darussalam', 'BN', 'BRN', 'false', 'false'),
(34, 'Bulgaria', 'BG', 'BGR', 'false', 'false'),
(35, 'Burkina Faso', 'BF', 'BFA', 'false', 'false'),
(36, 'Burundi', 'BI', 'BDI', 'false', 'false'),
(37, 'Cambodia', 'KH', 'KHM', 'false', 'false'),
(38, 'Cameroon', 'CM', 'CMR', 'false', 'false'),
(39, 'Canada', 'CA', 'CAN', 'true', 'false'),
(40, 'Cape Verde', 'CV', 'CPV', 'false', 'false'),
(41, 'Cayman Islands', 'KY', 'CYM', 'false', 'false'),
(42, 'Central African Republic', 'CF', 'CAF', 'false', 'false'),
(43, 'Chad', 'TD', 'TCD', 'false', 'false'),
(44, 'Chile', 'CL', 'CHL', 'false', 'false'),
(45, 'China', 'CN', 'CHN', 'false', 'false'),
(46, 'Christmas Island', 'CX', 'CXR', 'false', 'false'),
(47, 'Cocos (Keeling) Islands', 'CC', 'CCK', 'false', 'false'),
(48, 'Colombia', 'CO', 'COL', 'false', 'false'),
(49, 'Comoros', 'KM', 'COM', 'false', 'false'),
(50, 'Congo', 'CG', 'COG', 'false', 'false'),
(51, 'Cook Islands', 'CK', 'COK', 'false', 'false'),
(52, 'Costa Rica', 'CR', 'CRI', 'false', 'false'),
(53, 'Cote D''Ivoire', 'CI', 'CIV', 'false', 'false'),
(54, 'Croatia', 'HR', 'HRV', 'false', 'false'),
(55, 'Cuba', 'CU', 'CUB', 'false', 'false'),
(56, 'Cyprus', 'CY', 'CYP', 'false', 'false'),
(57, 'Czech Republic', 'CZ', 'CZE', 'false', 'false'),
(58, 'Denmark', 'DK', 'DNK', 'false', 'false'),
(59, 'Djibouti', 'DJ', 'DJI', 'false', 'false'),
(60, 'Dominica', 'DM', 'DMA', 'false', 'false'),
(61, 'Dominican Republic', 'DO', 'DOM', 'false', 'false'),
(63, 'Ecuador', 'EC', 'ECU', 'false', 'false'),
(64, 'Egypt', 'EG', 'EGY', 'false', 'false'),
(65, 'El Salvador', 'SV', 'SLV', 'false', 'false'),
(66, 'Equatorial Guinea', 'GQ', 'GNQ', 'false', 'false'),
(67, 'Eritrea', 'ER', 'ERI', 'false', 'false'),
(68, 'Estonia', 'EE', 'EST', 'false', 'false'),
(69, 'Ethiopia', 'ET', 'ETH', 'false', 'false'),
(70, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 'false', 'false'),
(71, 'Faroe Islands', 'FO', 'FRO', 'false', 'false'),
(72, 'Fiji', 'FJ', 'FJI', 'false', 'false'),
(73, 'Finland', 'FI', 'FIN', 'false', 'false'),
(74, 'France', 'FR', 'FRA', 'true', 'false'),
(75, 'France, Metropolitan', 'FX', 'FXX', 'false', 'false'),
(76, 'French Guiana', 'GF', 'GUF', 'false', 'false'),
(77, 'French Polynesia', 'PF', 'PYF', 'false', 'false'),
(78, 'French Southern Territories', 'TF', 'ATF', 'false', 'false'),
(79, 'Gabon', 'GA', 'GAB', 'false', 'false'),
(80, 'Gambia', 'GM', 'GMB', 'false', 'false'),
(81, 'Georgia', 'GE', 'GEO', 'false', 'false'),
(82, 'Germany', 'DE', 'DEU', 'true', 'false'),
(83, 'Ghana', 'GH', 'GHA', 'false', 'false'),
(84, 'Gibraltar', 'GI', 'GIB', 'false', 'false'),
(85, 'Greece', 'GR', 'GRC', 'false', 'false'),
(86, 'Greenland', 'GL', 'GRL', 'false', 'false'),
(87, 'Grenada', 'GD', 'GRD', 'false', 'false'),
(88, 'Guadeloupe', 'GP', 'GLP', 'false', 'false'),
(89, 'Guam', 'GU', 'GUM', 'false', 'false'),
(90, 'Guatemala', 'GT', 'GTM', 'false', 'false'),
(91, 'Guinea', 'GN', 'GIN', 'false', 'false'),
(92, 'Guinea-Bissau', 'GW', 'GNB', 'false', 'false'),
(93, 'Guyana', 'GY', 'GUY', 'false', 'false'),
(94, 'Haiti', 'HT', 'HTI', 'false', 'false'),
(95, 'Heard and McDonald Islands', 'HM', 'HMD', 'false', 'false'),
(96, 'Honduras', 'HN', 'HND', 'false', 'false'),
(97, 'Hong Kong', 'HK', 'HKG', 'false', 'false'),
(98, 'Hungary', 'HU', 'HUN', 'false', 'false'),
(99, 'Iceland', 'IS', 'ISL', 'false', 'false'),
(100, 'India', 'IN', 'IND', 'true', 'false'),
(101, 'Indonesia', 'ID', 'IDN', 'false', 'false'),
(102, 'Iraq', 'IQ', 'IRQ', 'false', 'false'),
(103, 'Ireland', 'IE', 'IRL', 'true', 'false'),
(104, 'Islamic Republic of Iran', 'IR', 'IRN', 'false', 'false'),
(105, 'Israel', 'IL', 'ISR', 'false', 'false'),
(106, 'Italy', 'IT', 'ITA', 'true', 'false'),
(107, 'Jamaica', 'JM', 'JAM', 'false', 'false'),
(108, 'Japan', 'JP', 'JPN', 'false', 'false'),
(109, 'Jordan', 'JO', 'JOR', 'false', 'false'),
(110, 'Kazakhstan', 'KZ', 'KAZ', 'false', 'false'),
(111, 'Kenya', 'KE', 'KEN', 'false', 'false'),
(112, 'Kiribati', 'KI', 'KIR', 'false', 'false'),
(113, 'Korea', 'KP', 'PRK', 'false', 'false'),
(114, 'Korea, Republic of', 'KR', 'KOR', 'false', 'false'),
(115, 'Kuwait', 'KW', 'KWT', 'false', 'false'),
(116, 'Kyrgyzstan', 'KG', 'KGZ', 'false', 'false'),
(117, 'Laos', 'LA', 'LAO', 'false', 'false'),
(118, 'Latvia', 'LV', 'LVA', 'false', 'false'),
(119, 'Lebanon', 'LB', 'LBN', 'false', 'false'),
(120, 'Lesotho', 'LS', 'LSO', 'false', 'false'),
(121, 'Liberia', 'LR', 'LBR', 'false', 'false'),
(122, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 'false', 'false'),
(123, 'Liechtenstein', 'LI', 'LIE', 'false', 'false'),
(124, 'Lithuania', 'LT', 'LTU', 'false', 'false'),
(125, 'Luxembourg', 'LU', 'LUX', 'true', 'false'),
(126, 'Macao', 'MO', 'MAC', 'false', 'false'),
(127, 'Macedonia', 'MK', 'MKD', 'false', 'false'),
(128, 'Madagascar', 'MG', 'MDG', 'false', 'false'),
(129, 'Malawi', 'MW', 'MWI', 'false', 'false'),
(130, 'Malaysia', 'MY', 'MYS', 'false', 'false'),
(131, 'Maldives', 'MV', 'MDV', 'false', 'false'),
(132, 'Mali', 'ML', 'MLI', 'false', 'false'),
(133, 'Malta', 'MT', 'MLT', 'false', 'false'),
(134, 'Marshall Islands', 'MH', 'MHL', 'false', 'false'),
(135, 'Martinique', 'MQ', 'MTQ', 'false', 'false'),
(136, 'Mauritania', 'MR', 'MRT', 'false', 'false'),
(137, 'Mauritius', 'MU', 'MUS', 'false', 'false'),
(138, 'Mayotte', 'YT', 'MYT', 'false', 'false'),
(139, 'Mexico', 'MX', 'MEX', 'true', 'false'),
(140, 'Micronesia', 'FM', 'FSM', 'false', 'false'),
(141, 'Moldova, Republic of', 'MD', 'MDA', 'false', 'false'),
(142, 'Monaco', 'MC', 'MCO', 'false', 'false'),
(143, 'Mongolia', 'MN', 'MNG', 'false', 'false'),
(144, 'Montserrat', 'MS', 'MSR', 'false', 'false'),
(145, 'Morocco', 'MA', 'MAR', 'false', 'false'),
(146, 'Mozambique', 'MZ', 'MOZ', 'false', 'false'),
(147, 'Myanmar', 'MM', 'MMR', 'false', 'false'),
(148, 'Namibia', 'NA', 'NAM', 'false', 'false'),
(149, 'Nauru', 'NR', 'NRU', 'false', 'false'),
(150, 'Nepal', 'NP', 'NPL', 'false', 'false'),
(151, 'Netherlands', 'NL', 'NLD', 'true', 'false'),
(152, 'Netherlands Antilles', 'AN', 'ANT', 'false', 'false'),
(153, 'New Caledonia', 'NC', 'NCL', 'false', 'false'),
(154, 'New Zealand', 'NZ', 'NZL', 'true', 'false'),
(155, 'Nicaragua', 'NI', 'NIC', 'false', 'false'),
(156, 'Niger', 'NE', 'NER', 'false', 'false'),
(157, 'Nigeria', 'NG', 'NGA', 'false', 'false'),
(158, 'Niue', 'NU', 'NIU', 'false', 'false'),
(159, 'Norfolk Island', 'NF', 'NFK', 'false', 'false'),
(160, 'Northern Mariana Islands', 'MP', 'MNP', 'false', 'false'),
(161, 'Norway', 'NO', 'NOR', 'false', 'false'),
(162, 'Oman', 'OM', 'OMN', 'false', 'false'),
(163, 'Pakistan', 'PK', 'PAK', 'false', 'false'),
(164, 'Palau', 'PW', 'PLW', 'false', 'false'),
(165, 'Panama', 'PA', 'PAN', 'false', 'false'),
(166, 'Papua New Guinea', 'PG', 'PNG', 'false', 'false'),
(167, 'Paraguay', 'PY', 'PRY', 'false', 'false'),
(168, 'Peru', 'PE', 'PER', 'false', 'false'),
(169, 'Philippines', 'PH', 'PHL', 'false', 'false'),
(170, 'Pitcairn', 'PN', 'PCN', 'false', 'false'),
(171, 'Poland', 'PL', 'POL', 'false', 'false'),
(172, 'Portugal', 'PT', 'PRT', 'true', 'false'),
(173, 'Puerto Rico', 'PR', 'PRI', 'false', 'false'),
(174, 'Qatar', 'QA', 'QAT', 'false', 'false'),
(175, 'Reunion', 'RE', 'REU', 'false', 'false'),
(176, 'Romania', 'RO', 'ROU', 'false', 'false'),
(177, 'Russian Federation', 'RU', 'RUS', 'false', 'false'),
(178, 'Rwanda', 'RW', 'RWA', 'false', 'false'),
(179, 'Saint Lucia', 'LC', 'LCA', 'false', 'false'),
(180, 'Samoa', 'WS', 'WSM', 'false', 'false'),
(181, 'San Marino', 'SM', 'SMR', 'false', 'false'),
(182, 'Sao Tome and Principe', 'ST', 'STP', 'false', 'false'),
(183, 'Saudi Arabia', 'SA', 'SAU', 'false', 'false'),
(184, 'Senegal', 'SN', 'SEN', 'false', 'false'),
(185, 'Seychelles', 'SC', 'SYC', 'false', 'false'),
(186, 'Sierra Leone', 'SL', 'SLE', 'false', 'false'),
(187, 'Singapore', 'SG', 'SGP', 'false', 'false'),
(188, 'Slovakia', 'SK', 'SVK', 'false', 'false'),
(189, 'Slovenia', 'SI', 'SVN', 'false', 'false'),
(190, 'Solomon Islands', 'SB', 'SLB', 'false', 'false'),
(191, 'Somalia', 'SO', 'SOM', 'false', 'false'),
(192, 'South Africa', 'ZA', 'ZAF', 'false', 'false'),
(193, 'Spain', 'ES', 'ESP', 'true', 'false'),
(194, 'Sri Lanka', 'LK', 'LKA', 'false', 'false'),
(195, 'St. Helena, Ascension and Tristan da Cunha', 'SH', 'SHN', 'false', 'false'),
(196, 'St. Kitts and Nevis', 'KN', 'KNA', 'false', 'false'),
(197, 'St. Pierre and Miquelon', 'PM', 'SPM', 'false', 'false'),
(198, 'St. Vincent and the Grenadines', 'VC', 'VCT', 'false', 'false'),
(199, 'Sudan', 'SD', 'SDN', 'false', 'false'),
(200, 'Suriname', 'SR', 'SUR', 'false', 'false'),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 'false', 'false'),
(202, 'Swaziland', 'SZ', 'SWZ', 'false', 'false'),
(203, 'Sweden', 'SE', 'SWE', 'false', 'false'),
(204, 'Switzerland', 'CH', 'CHE', 'false', 'false'),
(205, 'Syrian Arab Republic', 'SY', 'SYR', 'false', 'false'),
(206, 'Taiwan', 'TW', 'TWN', 'false', 'false'),
(207, 'Tajikistan', 'TJ', 'TJK', 'false', 'false'),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 'false', 'false'),
(209, 'Thailand', 'TH', 'THA', 'false', 'false'),
(210, 'Togo', 'TG', 'TGO', 'false', 'false'),
(211, 'Tokelau', 'TK', 'TKL', 'false', 'false'),
(212, 'Tonga', 'TO', 'TON', 'false', 'false'),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 'false', 'false'),
(214, 'Tunisia', 'TN', 'TUN', 'false', 'false'),
(215, 'Turkey', 'TR', 'TUR', 'false', 'false'),
(216, 'Turkmenistan', 'TM', 'TKM', 'false', 'false'),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 'false', 'false'),
(218, 'Tuvalu', 'TV', 'TUV', 'false', 'false'),
(219, 'Uganda', 'UG', 'UGA', 'false', 'false'),
(220, 'Ukraine', 'UA', 'UKR', 'false', 'false'),
(221, 'United Arab Emirates', 'AE', 'ARE', 'false', 'false'),
(222, 'United Kingdom (Great Britain)', 'GB', 'GBR', 'true', 'false'),
(223, 'United States', 'US', 'USA', 'true', 'true'),
(224, 'United States Virgin Islands', 'VI', 'VIR', 'false', 'false'),
(225, 'Uruguay', 'UY', 'URY', 'false', 'false'),
(226, 'Uzbekistan', 'UZ', 'UZB', 'false', 'false'),
(227, 'Vanuatu', 'VU', 'VUT', 'false', 'false'),
(228, 'Holy See (Vatican City State)', 'VA', 'VAT', 'false', 'false'),
(229, 'Venezuela', 'VE', 'VEN', 'false', 'false'),
(230, 'Viet Nam', 'VN', 'VNM', 'false', 'false'),
(231, 'Wallis And Futuna', 'WF', 'WLF', 'false', 'false'),
(232, 'Western Sahara', 'EH', 'ESH', 'false', 'false'),
(233, 'Yemen', 'YE', 'YEM', 'false', 'false'),
(236, 'Zambia', 'ZM', 'ZMB', 'false', 'false'),
(237, 'Zimbabwe', 'ZW', 'ZWE', 'false', 'false');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]credit_card_attributes_to_types`
--

CREATE TABLE `[[dbprefix]]credit_card_attributes_to_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL DEFAULT '0',
  `attr` int(11) NOT NULL DEFAULT '0',
  `visible` int(11) NOT NULL DEFAULT '0',
  `required` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]credit_card_attributes_to_types`
--

INSERT INTO `[[dbprefix]]credit_card_attributes_to_types` VALUES
(1, 5, 14, 0, 0),
(2, 5, 15, 0, 0),
(3, 5, 16, 0, 0),
(4, 5, 22, 1, 1),
(5, 5, 23, 1, 1),
(6, 5, 24, 1, 1),
(7, 6, 14, 0, 0),
(8, 6, 15, 0, 0),
(9, 6, 16, 0, 0),
(10, 6, 22, 1, 1),
(11, 6, 23, 1, 1),
(12, 6, 24, 1, 1),
(13, 11, 14, 0, 0),
(14, 11, 15, 0, 0),
(15, 11, 16, 0, 0),
(16, 11, 22, 1, 1),
(17, 11, 23, 1, 1),
(18, 11, 24, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]credit_card_settings`
--

CREATE TABLE `[[dbprefix]]credit_card_settings` (
  `credit_card_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `credit_card_type_name` varchar(255) NOT NULL DEFAULT '',
  `credit_card_type_tag` varchar(255) NOT NULL DEFAULT '',
  `credit_card_type_sort_order` int(11) NOT NULL DEFAULT '0',
  `credit_card_type_visible` char(5) NOT NULL DEFAULT 'true',
  PRIMARY KEY (`credit_card_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]credit_card_settings`
--

INSERT INTO `[[dbprefix]]credit_card_settings` VALUES
(1, 'Visa', 'Visa', 1, 'true'),
(2, 'MasterCard', 'MasterCard', 2, 'true'),
(3, 'Discover', 'Discover', 3, 'true'),
(4, 'American Express', 'Amex', 4, 'true'),
(5, 'Maestro', 'Maestro', 5, 'true'),
(6, 'Solo', 'Solo', 6, 'true'),
(7, 'Diners Club', 'DC', 7, 'false'),
(8, 'FirePay', 'FirePay', 8, 'false'),
(9, 'JCB', 'JCB', 9, 'false'),
(10, 'Laser', 'Laser', 10, 'false'),
(11, 'Switch', 'Switch', 11, 'false'),
(12, 'Visa Delta', 'VisaD', 12, 'false'),
(13, 'Visa Electron', 'VisaE', 13, 'false');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crypto_keys`
--

CREATE TABLE `[[dbprefix]]crypto_keys` (
  `session_id` varchar(50) DEFAULT NULL,
  `variable_name` varchar(50) DEFAULT NULL,
  `crypto_key` varchar(50) DEFAULT NULL,
  `lifetime` int(11) DEFAULT NULL,
  UNIQUE KEY `IDX_in` (`session_id`,`variable_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(255) DEFAULT NULL,
  `currency_code` varchar(5) DEFAULT NULL,
  `currency_iso` varchar(5) DEFAULT NULL,
  `currency_sign` varchar(5) DEFAULT NULL,
  `currency_active` char(5) NOT NULL DEFAULT 'false',
  `currency_default` char(5) NOT NULL DEFAULT 'false',
  `currency_visible` char(5) NOT NULL DEFAULT 'true',
  PRIMARY KEY (`currency_id`),
  KEY `IDX_unique` (`currency_iso`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=306 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, 'Afghan Afghani (AFN)', 'AFN', '971', 'AFN', 'false', 'false', 'true'),
(2, 'Albanian Lek (ALL)', 'ALL', '8', 'ALL', 'false', 'false', 'true'),
(3, 'Algerian Dinar (DZD)', 'DZD', '12', 'DZD', 'false', 'false', 'true'),
(4, 'United States Dollar (USD)', 'USD', '840', '$', 'true', 'true', 'true'),
(6, 'European Euro (EUR)', 'EUR', '978', 'EUR', 'false', 'false', 'true'),
(7, 'Angolan Kwanza (AOA)', 'AOA', '973', 'AOA', 'false', 'false', 'true'),
(8, 'East Caribbean Dollar (XCD)', 'XCD', '951', 'XCD', 'false', 'false', 'true'),
(10, 'Argentine Peso (ARS)', 'ARS', '32', 'ARS', 'false', 'false', 'true'),
(11, 'Armenian Dram (AMD)', 'AMD', '51', 'AMD', 'false', 'false', 'true'),
(12, 'Aruban Florin (AWG)', 'AWG', '533', 'AWG', 'false', 'false', 'true'),
(13, 'Australian Dollar (AUD)', 'AUD', '36', 'AUD', 'false', 'false', 'true'),
(16, 'Azerbaijani Manat (AZN)', 'AZN', '944', 'AZN', 'false', 'false', 'true'),
(18, 'Bahamian Dollar (BSD)', 'BSD', '44', 'BSD', 'false', 'false', 'true'),
(19, 'Bahraini Dinar (BHD)', 'BHD', '48', 'BHD', 'false', 'false', 'true'),
(20, 'Barbadian Dollar (BBD)', 'BBD', '52', 'BBD', 'false', 'false', 'true'),
(22, 'Bangladeshi Taka (BDT)', 'BDT', '50', 'BDT', 'false', 'false', 'true'),
(24, 'Belarusian Ruble (BYR)', 'BYR', '974', 'BYR', 'false', 'false', 'true'),
(26, 'Belize Dollar (BZD)', 'BZD', '84', 'BZD', 'false', 'false', 'true'),
(27, 'West African CFA Franc (XOF)', 'XOF', '952', 'XOF', 'false', 'false', 'true'),
(28, 'Bermudian Dollar (BMD)', 'BMD', '60', 'BMD', 'false', 'false', 'true'),
(29, 'India Rupee (INR)', 'INR', '356', 'INR', 'false', 'false', 'true'),
(30, 'Bhutanese Ngultrum (BTN)', 'BTN', '64', 'BTN', 'false', 'false', 'true'),
(31, 'Bolivian Boliviano (BOB)', 'BOB', '68', 'BOB', 'false', 'false', 'true'),
(32, 'Netherlands Antilles Guilder (ANG)', 'ANG', '532', 'ANG', 'false', 'false', 'true'),
(33, 'Bosnia and Herzegovina Marka (BAM)', 'BAM', '977', 'BAM', 'false', 'false', 'true'),
(34, 'Botswana Pula (BWP)', 'BWP', '72', 'BWP', 'false', 'false', 'true'),
(35, 'Brazilian Real (BRL)', 'BRL', '986', 'BRL', 'false', 'false', 'true'),
(36, 'British Pound (GBP)', 'GBP', '826', 'GBP', 'false', 'false', 'true'),
(40, 'Brunei Dollar (BND)', 'BND', '96', 'BND', 'false', 'false', 'true'),
(41, 'Singapore Dollar (SGD)', 'SGD', '702', 'SGD', 'false', 'false', 'true'),
(42, 'Bulgarian Lev (BGN)', 'BGN', '975', 'BGN', 'false', 'false', 'true'),
(44, 'Myanma Kyat (MMK)', 'MMK', '104', 'MMK', 'false', 'false', 'true'),
(45, 'Burundi Franc (BIF)', 'BIF', '108', 'BIF', 'false', 'false', 'true'),
(46, 'Cambodian Riel (KHR)', 'KHR', '116', 'KHR', 'false', 'false', 'true'),
(47, 'CFA Franc BEAC (XAF)', 'XAF', '950', 'XAF', 'false', 'false', 'true'),
(48, 'Canadian Dollar (CAD)', 'CAD', '124', 'CAD', 'false', 'false', 'true'),
(50, 'Cape Verdean Escudo (CVE)', 'CVE', '132', 'CVE', 'false', 'false', 'true'),
(51, 'Cayman Islands Dollar (KYD)', 'KYD', '136', 'KYD', 'false', 'false', 'true'),
(56, 'Chilean Peso (CLP)', 'CLP', '152', 'CLP', 'false', 'false', 'true'),
(57, 'Chinese Renminbi (CNY)', 'CNY', '156', 'CNY', 'false', 'false', 'true'),
(61, 'Colombian Peso (COP)', 'COP', '170', 'COP', 'false', 'false', 'true'),
(64, 'Comorian Franc (KMF)', 'KMF', '174', 'KMF', 'false', 'false', 'true'),
(67, 'Congolese Franc (CDF)', 'CDF', '976', 'CDF', 'false', 'false', 'true'),
(68, 'New Zealand Dollar (NZD)', 'NZD', '554', 'NZD', 'false', 'false', 'true'),
(70, 'Costa Rican Colon (CRC)', 'CRC', '188', 'CRC', 'false', 'false', 'true'),
(72, 'Croatian Kuna (HRK)', 'HRK', '191', 'HRK', 'false', 'false', 'true'),
(73, 'Cuban Peso (CUC)', 'CUC', '931', 'CUC', 'false', 'false', 'true'),
(74, 'Cuban Peso (CUP)', 'CUP', '192', 'CUP', 'false', 'false', 'true'),
(76, 'Cyprus Pound (CYP)', 'CYP', '---', 'CYP', 'false', 'false', 'true'),
(77, 'Czech Koruna (CZK)', 'CZK', '203', 'CZK', 'false', 'false', 'true'),
(78, 'Danish Krone (DKK)', 'DKK', '208', 'DKK', 'false', 'false', 'true'),
(79, 'Djiboutian Franc (DJF)', 'DJF', '262', 'DJF', 'false', 'false', 'true'),
(81, 'Dominican Peso (DOP)', 'DOP', '214', 'DOP', 'false', 'false', 'true'),
(86, 'Egyptian Pound (EGP)', 'EGP', '818', 'EGP', 'false', 'false', 'true'),
(87, 'El Salvador Colon (SVC)', 'SVC', '222', 'SVC', 'false', 'false', 'true'),
(91, 'Eritrean Nakfa (ERN)', 'ERN', '232', 'ERN', 'false', 'false', 'true'),
(92, 'Estonian Kroon (EEK)', 'EEK', '233', 'EEK', 'false', 'false', 'true'),
(93, 'Ethiopian Birr (ETB)', 'ETB', '230', 'ETB', 'false', 'false', 'true'),
(96, 'Falkland Islands Pound (FKP)', 'FKP', '238', 'FKP', 'false', 'false', 'true'),
(98, 'Fijian Dollar (FJD)', 'FJD', '242', 'FJD', 'false', 'false', 'true'),
(102, 'CFP Franc (XPF)', 'XPF', '953', 'XPF', 'false', 'false', 'true'),
(106, 'Gambian Dalasi (GMD)', 'GMD', '270', 'GMD', 'false', 'false', 'true'),
(107, 'Israeli new Sheqel (ILS)', 'ILS', '376', 'ILS', 'false', 'false', 'true'),
(108, 'Georgian Lari (GEL)', 'GEL', '981', 'GEL', 'false', 'false', 'true'),
(110, 'Ghanaian Cedi (GHS)', 'GHS', '936', 'GHS', 'false', 'false', 'true'),
(111, 'Gibraltar Pound (GIP)', 'GIP', '292', 'GIP', 'false', 'false', 'true'),
(112, 'Gold Ounce (XAU)', 'XAU', '959', 'XAU', 'false', 'false', 'true'),
(119, 'Guatemalan Quetzal (GTQ)', 'GTQ', '320', 'GTQ', 'false', 'false', 'true'),
(120, 'Guernsey Islands Pound (GGP)', 'GGP', '---', 'GGP', 'false', 'false', 'true'),
(121, 'Guinean Franc (GNF)', 'GNF', '324', 'GNF', 'false', 'false', 'true'),
(123, 'Guyanese Dollar (GYD)', 'GYD', '328', 'GYD', 'false', 'false', 'true'),
(124, 'Haitian Gourde (HTG)', 'HTG', '332', 'HTG', 'false', 'false', 'true'),
(127, 'Honduran Lempira (HNL)', 'HNL', '340', 'HNL', 'false', 'false', 'true'),
(128, 'Hong Kong Dollar (HKD)', 'HKD', '344', 'HKD', 'false', 'false', 'true'),
(129, 'Hungarian Forint (HUF)', 'HUF', '348', 'HUF', 'false', 'false', 'true'),
(130, 'Icelandic Krona (ISK)', 'ISK', '352', 'ISK', 'false', 'false', 'true'),
(132, 'Indonesian Rupiah (IDR)', 'IDR', '360', 'IDR', 'false', 'false', 'true'),
(133, 'IMF Special Drawing Rights (XDR)', 'XDR', '960', 'XDR', 'false', 'false', 'true'),
(134, 'Iranian Rial (IRR)', 'IRR', '364', 'IRR', 'false', 'false', 'true'),
(135, 'Iraqi Dinar (IQD)', 'IQD', '368', 'IQD', 'false', 'false', 'true'),
(138, 'Isle of Man Pound (IMP)', 'IMP', '---', 'IMP', 'false', 'false', 'true'),
(142, 'Jamaican Dollar (JMD)', 'JMD', '388', 'JMD', 'false', 'false', 'true'),
(143, 'Japanese Yen (JPY)', 'JPY', '392', 'JPY', 'false', 'false', 'true'),
(144, 'Jersey Pound (JEP)', 'JEP', '---', 'JEP', 'false', 'false', 'true'),
(146, 'Jordanian Dinar (JOD)', 'JOD', '400', 'JOD', 'false', 'false', 'true'),
(148, 'Kazakhstani Tenge (KZT)', 'KZT', '398', 'KZT', 'false', 'false', 'true'),
(149, 'Kenyan Shilling (KES)', 'KES', '404', 'KES', 'false', 'false', 'true'),
(151, 'Kuwaiti Dinar (KWD)', 'KWD', '414', 'KWD', 'false', 'false', 'true'),
(152, 'Kyrgyzstani Som (KGS)', 'KGS', '417', 'KGS', 'false', 'false', 'true'),
(153, 'Laotian Kip (LAK)', 'LAK', '418', 'LAK', 'false', 'false', 'true'),
(154, 'Latvian Lats (LVL)', 'LVL', '428', 'LVL', 'false', 'false', 'true'),
(155, 'Lebanese Lira (LBP)', 'LBP', '422', 'LBP', 'false', 'false', 'true'),
(156, 'Lesotho Loti (LSL)', 'LSL', '426', 'LSL', 'false', 'false', 'true'),
(157, 'Liberian Dollar (LRD)', 'LRD', '430', 'LRD', 'false', 'false', 'true'),
(158, 'Libyan Dinar (LYD)', 'LYD', '434', 'LYD', 'false', 'false', 'true'),
(159, 'Switzerland Franc (CHF)', 'CHF', '756', 'CHF', 'false', 'false', 'true'),
(160, 'Lithuanian Litas (LTL)', 'LTL', '440', 'LTL', 'false', 'false', 'true'),
(162, 'Macanese Pataca (MOP)', 'MOP', '446', 'MOP', 'false', 'false', 'true'),
(163, 'Macedonian Denar (MKD)', 'MKD', '807', 'MKD', 'false', 'false', 'true'),
(164, 'Malagasy Ariary (MGA)', 'MGA', '969', 'MGA', 'false', 'false', 'true'),
(166, 'Malawian Kwacha (MWK)', 'MWK', '454', 'MWK', 'false', 'false', 'true'),
(167, 'Malaysian Ringgit (MYR)', 'MYR', '458', 'MYR', 'false', 'false', 'true'),
(168, 'Maldivian Rufiyaa (MVR)', 'MVR', '462', 'MVR', 'false', 'false', 'true'),
(170, 'Maltese Lira (MTL)', 'MTL', '---', 'MTL', 'false', 'false', 'true'),
(174, 'Mauritanian Ouguiya (MRO)', 'MRO', '478', 'MRO', 'false', 'false', 'true'),
(175, 'Mauritian Rupee (MUR)', 'MUR', '480', 'MUR', 'false', 'false', 'true'),
(177, 'Mexican Peso (MXN)', 'MXN', '484', 'MXN', 'false', 'false', 'true'),
(180, 'Moldovan Leu (MDL)', 'MDL', '498', 'MDL', 'false', 'false', 'true'),
(182, 'Mongolian Tugrik (MNT)', 'MNT', '496', 'MNT', 'false', 'false', 'true'),
(185, 'Moroccan Dirham (MAD)', 'MAD', '504', 'MAD', 'false', 'false', 'true'),
(186, 'Mozambican Metical (MZN)', 'MZN', '943', 'MZN', 'false', 'false', 'true'),
(188, 'Namibian Dollar (NAD)', 'NAD', '516', 'NAD', 'false', 'false', 'true'),
(193, 'Nepalese Rupee (NPR)', 'NPR', '524', 'NPR', 'false', 'false', 'true'),
(198, 'Nicaraguan Cordoba (NIO)', 'NIO', '558', 'NIO', 'false', 'false', 'true'),
(200, 'Nigerian Naira (NGN)', 'NGN', '566', 'NGN', 'false', 'false', 'true'),
(203, 'North Korean Won (KPW)', 'KPW', '408', 'KPW', 'false', 'false', 'true'),
(205, 'Norwegian Krone (NOK)', 'NOK', '578', 'NOK', 'false', 'false', 'true'),
(206, 'Omani Rial (OMR)', 'OMR', '512', 'OMR', 'false', 'false', 'true'),
(207, 'Pakistani Rupee (PKR)', 'PKR', '586', 'PKR', 'false', 'false', 'true'),
(209, 'Palladium Ounce (XPD)', 'XPD', '964', 'XPD', 'false', 'false', 'true'),
(210, 'Panamanian Balboa (PAB)', 'PAB', '590', 'PAB', 'false', 'false', 'true'),
(212, 'Papua New Guinean Kina (PGK)', 'PGK', '598', 'PGK', 'false', 'false', 'true'),
(214, 'Vietnamese Dong (VND)', 'VND', '704', 'VND', 'false', 'false', 'true'),
(215, 'Paraguayan Guarani (PYG)', 'PYG', '600', 'PYG', 'false', 'false', 'true'),
(216, 'Peruvian Nuevo Sol (PEN)', 'PEN', '604', 'PEN', 'false', 'false', 'true'),
(217, 'Philippine Peso (PHP)', 'PHP', '608', 'PHP', 'false', 'false', 'true'),
(219, 'Platinum Ounce (XPT)', 'XPT', '962', 'XPT', 'false', 'false', 'true'),
(220, 'Polish Zloty (PLN)', 'PLN', '985', 'PLN', 'false', 'false', 'true'),
(223, 'Qatari Riyal (QAR)', 'QAR', '634', 'QAR', 'false', 'false', 'true'),
(225, 'Romanian Leu (RON)', 'RON', '946', 'RON', 'false', 'false', 'true'),
(226, 'Romanian Leu (ROL)', 'ROL', '---', 'ROL', 'false', 'false', 'true'),
(227, 'Russian Ruble (RUB)', 'RUB', '643', 'RUB', 'false', 'false', 'true'),
(228, 'Rwandan Franc (RWF)', 'RWF', '646', 'RWF', 'false', 'false', 'true'),
(230, 'Saint Helena Pound (SHP)', 'SHP', '654', 'SHP', 'false', 'false', 'true'),
(236, 'Samoan Tala (WST)', 'WST', '882', 'WST', 'false', 'false', 'true'),
(238, 'Sao Tome and Principe Dobra (STD)', 'STD', '678', 'STD', 'false', 'false', 'true'),
(239, 'Saudi Riyal (SAR)', 'SAR', '682', 'SAR', 'false', 'false', 'true'),
(241, 'Senegal Luigino (SPL)', 'SPL', '---', 'SPL', 'false', 'false', 'true'),
(243, 'Serbian Dinar (RSD)', 'RSD', '941', 'RSD', 'false', 'false', 'true'),
(244, 'Seychellois Rupee (SCR)', 'SCR', '690', 'SCR', 'false', 'false', 'true'),
(245, 'Sierra Leonean Leone (SLL)', 'SLL', '694', 'SLL', 'false', 'false', 'true'),
(246, 'Silver Ounce (XAG)', 'XAG', '961', 'XAG', 'false', 'false', 'true'),
(250, 'Slovak Koruna (SKK)', 'SKK', '---', 'SKK', 'false', 'false', 'true'),
(251, 'Slovenain Tolar (SIT)', 'SIT', '---', 'SIT', 'false', 'false', 'true'),
(252, 'Solomon Islands Dollar (SBD)', 'SBD', '90', 'SBD', 'false', 'false', 'true'),
(253, 'Somali Shilling (SOS)', 'SOS', '706', 'SOS', 'false', 'false', 'true'),
(254, 'South African Rand (ZAR)', 'ZAR', '710', 'ZAR', 'false', 'false', 'true'),
(256, 'South Korean Won (KRW)', 'KRW', '410', 'KRW', 'false', 'false', 'true'),
(259, 'Sri Lankan Rupee (LKR)', 'LKR', '144', 'LKR', 'false', 'false', 'true'),
(260, 'Sudan Dinar (SDG)', 'SDG', '938', 'SDG', 'false', 'false', 'true'),
(261, 'Surinamese Dollar (SRD)', 'SRD', '968', 'SRD', 'false', 'false', 'true'),
(263, 'Swazi Lilangeni (SZL)', 'SZL', '748', 'SZL', 'false', 'false', 'true'),
(265, 'Swedish Krona (SEK)', 'SEK', '752', 'SEK', 'false', 'false', 'true'),
(267, 'Syrian Pound (SYP)', 'SYP', '760', 'SYP', 'false', 'false', 'true'),
(268, 'New Taiwan Dollar (TWD)', 'TWD', '901', 'TWD', 'false', 'false', 'true'),
(269, 'Tajikistani Somoni (TJS)', 'TJS', '972', 'TJS', 'false', 'false', 'true'),
(271, 'Tanzanian Shilling (TZS)', 'TZS', '834', 'TZS', 'false', 'false', 'true'),
(272, 'Thai Baht (THB)', 'THB', '764', 'THB', 'false', 'false', 'true'),
(275, 'Tongan Pa''anga (TOP)', 'TOP', '776', 'TOP', 'false', 'false', 'true'),
(277, 'Trinidad and Tobago Dollar (TTD)', 'TTD', '780', 'TTD', 'false', 'false', 'true'),
(278, 'Tunisian Dinar (TND)', 'TND', '788', 'TND', 'false', 'false', 'true'),
(279, 'Turkish new Lira (TRY)', 'TRY', '949', 'TRY', 'false', 'false', 'true'),
(280, 'Turkish Lira (TRL)', 'TRL', '---', 'TRL', 'false', 'false', 'true'),
(281, 'Turkmenistan Manat (TMM)', 'TMM', '934', 'TMM', 'false', 'false', 'true'),
(284, 'Tuvalu Dollar (TVD)', 'TVD', '---', 'TVD', 'false', 'false', 'true'),
(285, 'Ugandan Shilling (UGX)', 'UGX', '800', 'UGX', 'false', 'false', 'true'),
(286, 'Ukrainian Hryvnia (UAH)', 'UAH', '980', 'UAH', 'false', 'false', 'true'),
(287, 'UAE Dirham (AED)', 'AED', '784', 'AED', 'false', 'false', 'true'),
(290, 'Uruguayan Peso (UYU)', 'UYU', '858', 'UYU', 'false', 'false', 'true'),
(291, 'Uzbekistani Som (UZS)', 'UZS', '860', 'UZS', 'false', 'false', 'true'),
(292, 'Vanuatu Vatu (VUV)', 'VUV', '548', 'VUV', 'false', 'false', 'true'),
(294, 'Venezuelan Bolivar Fuerte (VEF)', 'VEF', '937', 'VEF', 'false', 'false', 'true'),
(303, 'Yemeni Rial (YER)', 'YER', '886', 'YER', 'false', 'false', 'true'),
(304, 'Zambian Kwacha (ZMK)', 'ZMK', '894', 'ZMK', 'false', 'false', 'true'),
(305, 'Zimbabwean Dollar (ZWL)', 'ZWL', '932', 'ZWL', 'false', 'false', 'true');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_basket`
--

CREATE TABLE `[[dbprefix]]customer_basket` (
  `customer_busket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `customer_busket_product_quantity` int(11) DEFAULT NULL,
  `customer_busket_date_added` date DEFAULT NULL,
  PRIMARY KEY (`customer_busket_id`),
  KEY `IDX_ci` (`customer_id`),
  KEY `IDX_pi` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_reviews`
--

CREATE TABLE `[[dbprefix]]customer_reviews` (
  `cr_id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `ip_address` varchar(20) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `review` longtext,
  `status` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`cr_id`),
  KEY `datetime` (`datetime`),
  KEY `author` (`author`),
  KEY `ip_address` (`ip_address`),
  KEY `product_id` (`product_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=81 ;

--
-- Dumping data for table `[[dbprefix]]customer_reviews`
--

INSERT INTO `[[dbprefix]]customer_reviews` VALUES
(4, '2009-12-01 07:58:32', 'Dave', '89.250.164.209', 3, 'Awesome! ', 'A'),
(8, '2009-12-08 03:21:01', 'Dave', '79.132.105.4', 35, 'Great idea!', 'A'),
(10, '2009-12-08 03:37:59', 'Jenny', '79.132.105.4', 47, 'Great quality t-shirts, fast delivery', 'A'),
(13, '2009-12-08 04:21:52', 'Kevin', '79.132.105.4', 122, 'A good buy', 'A'),
(14, '2009-12-08 04:28:50', 'Michael', '79.132.105.4', 19, 'Window''s Vista Bible by Alan Simpson is the best. It is like having the author sitting with you personally. ', 'A'),
(15, '2009-12-08 04:34:42', 'Lee', '79.132.105.4', 44, 'Esquire is the only magazine I subscribe to. The pictures are nice, the articles are even better!', 'A'),
(16, '2009-12-08 04:40:00', 'Chris', '79.132.105.4', 42, 'Very nice and beautiful photos took by Guy Oseary, Madonna`s Manager.', 'A'),
(17, '2009-12-08 04:43:59', 'Webmaster', '79.132.105.4', 23, 'Great HTML guide', 'A'),
(21, '2009-12-08 05:19:15', 'Pam', '79.132.105.4', 81, 'Highly recommended. ', 'A'),
(23, '2009-12-08 05:45:53', 'Dave', '79.132.105.4', 106, 'A fantastic series featuring the best songs from Broadway classics.', 'A'),
(24, '2009-12-08 05:49:02', 'west83', '79.132.105.4', 91, 'this film is better than the 2nd', 'A'),
(25, '2009-12-08 06:09:42', 'Steve', '79.132.105.4', 37, 'This was one of the best DVD buys I''ve ever made!', 'A'),
(29, '2009-12-08 06:25:26', 'Lisa', '79.132.105.4', 97, 'great deal for the first 5 H.P. movies!', 'A'),
(32, '2009-12-08 06:32:38', 'Nat', '79.132.105.4', 108, 'Forbidden Planet is an incredible movie and no Sci-Fi fan should be without it. ', 'A'),
(53, '2009-12-08 07:29:58', 'Daniel', '79.132.105.4', 28, '\r\nOverall the product has been a very good buy. I wish it was cheaper but it was worth the money I paid for it.', 'A'),
(54, '2009-12-08 07:31:10', 'Michael', '79.132.105.4', 15, 'The machine itself is very well made and pretty robust', 'A'),
(55, '2009-12-08 07:34:17', 'Mark', '79.132.105.4', 6, 'This Mac Pro is probably 8x faster than the PowerMac at most tasks, and its case design is lovely.', 'A'),
(57, '2009-12-08 07:38:14', 'J. D.', '79.132.105.4', 11, 'I want to say I love this netbook. Pure and simple - A Great Buy! ', 'A'),
(59, '2009-12-08 07:44:49', 'Linda', '79.132.105.4', 57, 'Awesome :) ', 'A'),
(60, '2009-12-08 07:45:31', 'Kate', '79.132.105.4', 53, 'I like it, so beautiful!', 'A'),
(63, '2009-12-08 07:48:41', 'Kate', '79.132.105.4', 48, 'I like it', 'A'),
(64, '2009-12-08 07:49:21', 'Andrew', '79.132.105.4', 118, 'This is the great book!', 'A'),
(66, '2009-12-08 07:58:16', 'Thomas', '79.132.105.4', 102, 'An excellent selection of material and an ideal introduction to opera.\r\nIf you''re an opera lover, this CD is for you. All the great arias.', 'A'),
(67, '2009-12-08 08:09:09', 'Paul', '79.132.105.4', 140, 'You will be sure not disappointed. 5 stars!', 'A'),
(75, '2009-12-11 03:42:56', 'Dave', '79.132.105.4', 130, 'High class gadget.', 'A'),
(76, '2009-12-11 03:46:45', 'Andy', '79.132.105.4', 126, 'I like this sport kayak', 'A'),
(79, '2009-12-11 04:46:03', 'Daniel', '79.132.105.4', 169, 'I like it, 5 stars!', 'A'),
(80, '2009-12-11 05:47:00', 'Kate', '79.132.105.4', 139, 'Easy to clean, 5 stars!', 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_reviews_rates`
--

CREATE TABLE `[[dbprefix]]customer_reviews_rates` (
  `crr_id` int(11) NOT NULL AUTO_INCREMENT,
  `cr_id` int(11) DEFAULT NULL,
  `cr_rl_id` int(11) DEFAULT NULL,
  `rate` int(11) DEFAULT NULL,
  PRIMARY KEY (`crr_id`),
  KEY `cr_id` (`cr_id`),
  KEY `cr_rl_id` (`cr_rl_id`),
  KEY `rate` (`rate`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=83 ;

--
-- Dumping data for table `[[dbprefix]]customer_reviews_rates`
--

INSERT INTO `[[dbprefix]]customer_reviews_rates` VALUES
(4, 4, 1, 5),
(8, 8, 1, 5),
(10, 10, 1, 5),
(13, 13, 1, 5),
(14, 14, 1, 5),
(15, 15, 1, 5),
(16, 16, 1, 5),
(17, 17, 1, 5),
(21, 21, 1, 5),
(23, 23, 1, 5),
(24, 24, 1, 4),
(25, 25, 1, 5),
(29, 29, 1, 5),
(32, 32, 1, 5),
(54, 53, 1, 5),
(55, 54, 1, 4),
(56, 55, 1, 5),
(59, 57, 1, 4),
(61, 59, 1, 5),
(62, 60, 1, 5),
(65, 63, 1, 4),
(66, 64, 1, 5),
(68, 66, 1, 5),
(69, 67, 1, 5),
(77, 75, 1, 4),
(78, 76, 1, 5),
(81, 79, 1, 5),
(82, 80, 1, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_reviews_rate_list`
--

CREATE TABLE `[[dbprefix]]customer_reviews_rate_list` (
  `cr_rl_id` int(11) NOT NULL AUTO_INCREMENT,
  `rate_label` varchar(255) DEFAULT NULL,
  `visible` varchar(1) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`cr_rl_id`),
  KEY `visible` (`visible`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]customer_reviews_rate_list`
--

INSERT INTO `[[dbprefix]]customer_reviews_rate_list` VALUES
(1, 'Overall', 'Y', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]date_time_formats`
--

CREATE TABLE `[[dbprefix]]date_time_formats` (
  `date_time_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` varchar(5) DEFAULT NULL,
  `format` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`date_time_format_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]date_time_formats`
--

INSERT INTO `[[dbprefix]]date_time_formats` VALUES
(1, 'date', 'd-m-Y'),
(2, 'date', 'd/m/Y'),
(3, 'date', 'd.m.Y'),
(4, 'date', 'm-d-Y'),
(5, 'date', 'm/d/Y'),
(6, 'date', 'm.d.Y'),
(7, 'date', 'Y-m-d'),
(8, 'date', 'Y/m/d'),
(9, 'date', 'Y.m.d'),
(10, 'date', 'F d, Y'),
(11, 'date', 'M d, Y'),
(12, 'time', 'H:i:s'),
(13, 'time', 'H:i'),
(14, 'time', 'h:i:s A'),
(15, 'time', 'h:i A'),
(16, 'time', 'h:i:s a'),
(17, 'time', 'h:i a'),
(18, 'date', 'd F, Y');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discounts_global_discount_rates_table`
--

CREATE TABLE `[[dbprefix]]discounts_global_discount_rates_table` (
  `discounts_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `discounts_rate_value_from` float DEFAULT NULL,
  `discounts_rate_value_to` float DEFAULT NULL,
  `discounts_rate_cost_type_id` int(11) NOT NULL DEFAULT '1',
  `discounts_rate_cost` float DEFAULT NULL,
  `discounts_rate_b_active` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`discounts_rate_id`),
  KEY `IDX_rv_from` (`discounts_rate_value_from`),
  KEY `IDX_rv_to` (`discounts_rate_value_to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discounts_settings`
--

CREATE TABLE `[[dbprefix]]discounts_settings` (
  `discounts_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `discounts_setting_key` varchar(50) DEFAULT NULL,
  `discounts_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`discounts_setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_address`
--

CREATE TABLE `[[dbprefix]]email_address` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `lng` char(2) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `UNQ_email` (`email`),
  KEY `IDX_customer` (`customer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]email_address`
--

INSERT INTO `[[dbprefix]]email_address` VALUES
(1, 1, 'steve@avactis-demo.com', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]eventstack`
--

CREATE TABLE `[[dbprefix]]eventstack` (
  `id_event` int(11) NOT NULL AUTO_INCREMENT,
  `id_event_name` int(11) DEFAULT NULL,
  `event_time` int(11) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id_event`),
  KEY `IDX_etime` (`event_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]eventstack_event_names`
--

CREATE TABLE `[[dbprefix]]eventstack_event_names` (
  `id_event_name` int(11) NOT NULL AUTO_INCREMENT,
  `event_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_event_name`),
  KEY `IDX_event_name` (`event_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_manager`
--

CREATE TABLE `[[dbprefix]]events_manager` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `event_name` varchar(255) NOT NULL DEFAULT '',
  `handler_class` varchar(255) NOT NULL DEFAULT '',
  `handler_method` varchar(255) NOT NULL DEFAULT '',
  `handler_include_path` text,
  `handler_order` int(11) DEFAULT '100',
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `UNQ_event_handler` (`event_name`(75),`handler_class`(75),`handler_method`(75)),
  KEY `IDX_handler_order` (`handler_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]events_manager`
--

INSERT INTO `[[dbprefix]]events_manager` VALUES
(1, 'OrdersWereUpdated', 'Checkout', 'OnOrderStatusCreatedOrUpdatedOrDeleted', NULL, 100),
(2, 'OrderCreated', 'Checkout', 'OnOrderStatusCreatedOrUpdatedOrDeleted', NULL, 100),
(3, 'OrdersWillBeDeleted', 'Checkout', 'OnOrderStatusCreatedOrUpdatedOrDeleted', NULL, 100),
(4, 'OrderStatusUpdated', 'Notifications', 'OnOrderStatusUpdated', NULL, 100),
(5, 'CartChanged', 'Checkout', 'OnCartChanged', NULL, 100),
(6, 'OrderCreated', 'Customer_Account', 'OnOrderCreated', NULL, 100),
(7, 'CheckoutPersonInfoFieldUpdated', 'Customer_Account', 'OnCheckoutPersonInfoFieldUpdated', NULL, 100),
(8, 'CheckoutAttributesSortOrderUpdated', 'Customer_Account', 'OnCheckoutAttributesSortOrderUpdated', NULL, 100),
(9, 'ProductsDeleted', 'Customer_Reviews', 'onProductsDeleted', NULL, 100),
(10, 'OrderCreated', 'EventStack', 'onGeneralEvent', NULL, 100),
(11, 'OrderStatusUpdated', 'EventStack', 'onGeneralEvent', NULL, 100),
(12, 'OrdersWillBeDeleted', 'EventStack', 'onGeneralEvent', NULL, 100),
(13, 'CustomerRegistered', 'EventStack', 'onGeneralEvent', NULL, 100),
(14, 'OrdersWereUpdated', 'GiftCertificateApi', 'onOrdersUpdated', NULL, 100),
(15, 'ImageFKRemovedEvent', 'Images', 'OnImageFKRemoved', NULL, 100),
(16, 'RemoveAdmin', 'Notifications', 'OnRemoveAdmin', NULL, 100),
(17, 'CustomerRegistered', 'Notifications', 'OnCustomerRegistered', NULL, 100),
(18, 'CustomerShouldActivateSelf', 'Notifications', 'OnCustomerShouldActivateSelf', NULL, 100),
(19, 'AdminShouldActivateCustomer', 'Notifications', 'OnAdminShouldActivateCustomer', NULL, 100),
(20, 'CustomerActivateSelf', 'Notifications', 'OnCustomerActivateSelf', NULL, 100),
(21, 'AdminActivateCustomer', 'Notifications', 'OnAdminActivateCustomer', NULL, 100),
(22, 'AdminDropCustomerPassword', 'Notifications', 'OnAdminDropCustomerPassword', NULL, 100),
(23, 'CustomerPasswordDroped', 'Notifications', 'OnCustomerPasswordDroped', NULL, 100),
(24, 'AccountWasAutoCreated', 'Notifications', 'OnAccountWasAutoCreated', NULL, 100),
(25, 'InventoryLowLevel', 'Notifications', 'OnInventoryLowLevel', NULL, 100),
(26, 'GiftCertificateCreated', 'Notifications', 'OnGiftCertificateCreated', NULL, 100),
(27, 'GiftCertificatePurchased', 'Notifications', 'OnGiftCertificatePurchased', NULL, 100),
(28, 'RemovePersonInfoTypeEvent', 'Payment_Module_Offline_CC', 'OnRemovePersonInfoType', NULL, 100),
(29, 'RemovePersonInfoTypeEvent', 'Payment_Module_Paypal_CC', 'OnRemovePersonInfoType', NULL, 100),
(30, 'OrdersWereUpdated', 'Product_Files', 'OnOrdersWereUpdated', NULL, 100),
(31, 'OrdersWillBeDeleted', 'Product_Files', 'OnOrdersWillBeDeleted', NULL, 100),
(32, 'ProductInfoDisplayed', 'CProductStatisticCollector', 'onProductInfoDisplayed', NULL, 100),
(33, 'ProductListDisplayed', 'CProductStatisticCollector', 'onProductListDisplayed', NULL, 100),
(34, 'ProductAddedToCart', 'CProductStatisticCollector', 'onProductAddedToCart', NULL, 100),
(35, 'ProductQuantityInCartUpdated', 'CProductStatisticCollector', 'onProductQuantityInCartUpdated', NULL, 100),
(36, 'ProductRemovedFromCart', 'CProductStatisticCollector', 'onProductRemovedFromCart', NULL, 100),
(37, 'ProductsWasSold', 'CProductStatisticCollector', 'onProductsWasSold', NULL, 100),
(38, 'ProductInfoChanged', 'CProductStatisticCollector', 'onProductInfoChanged', NULL, 100),
(39, 'ApplicationStarted', 'CVisitorStatisticCollector', 'onApplicationStarted', NULL, 100),
(40, 'OrderCreated', 'COrdersStatisticCollector', 'onOrderCreated', NULL, 100),
(41, 'OrdersWereUpdated', 'COrdersStatisticCollector', 'onOrdersUpdated', NULL, 100),
(42, 'OrderDataEdited', 'COrdersStatisticCollector', 'onOrderDataEdited', NULL, 100),
(43, 'OrdersWillBeDeleted', 'COrdersStatisticCollector', 'onOrdersDeleted', NULL, 100),
(44, 'CartCreated', 'CCartsStatisticCollector', 'onCartCreated', NULL, 100),
(45, 'ProductsDeleted', 'CProductStatisticCollector', 'onProductsDeleted', NULL, 100),
(46, 'RemovePersonInfoTypeEvent', 'Shipping_Module_DSR', 'OnRemovePersonInfoType', NULL, 100),
(47, 'ProductsWasSold', 'Statistics', 'OnProductsWasSold', NULL, 100),
(48, 'CustomerRegistered', 'Subscriptions', 'onCustomerRegistered', NULL, 100),
(49, 'OrderCreated', 'Subscriptions', 'onOrderCreated', NULL, 100),
(50, 'ApplicationStarted', 'Timeline', 'onApplicationStarted', NULL, 100);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fp_links`
--

CREATE TABLE `[[dbprefix]]fp_links` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `fp_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `UNQ_cid_fp` (`category_id`,`fp_id`),
  KEY `IDX_cid` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=221 ;

--
-- Dumping data for table `[[dbprefix]]fp_links`
--

INSERT INTO `[[dbprefix]]fp_links` VALUES
(7, 8, 18, 1),
(8, 8, 31, 2),
(59, 9, 44, 1),
(60, 9, 118, 2),
(81, 1, 130, 5),
(79, 1, 37, 3),
(78, 1, 108, 2),
(85, 20, 18, 1),
(88, 20, 28, 4),
(99, 39, 44, 4),
(101, 39, 81, 6),
(100, 39, 43, 5),
(102, 39, 5, 7),
(104, 39, 121, 9),
(105, 14, 9, 1),
(107, 14, 4, 3),
(111, 15, 4, 4),
(126, 26, 101, 1),
(125, 19, 43, 3),
(127, 26, 104, 2),
(128, 26, 91, 3),
(129, 26, 97, 4),
(131, 26, 90, 6),
(135, 28, 37, 1),
(138, 28, 89, 4),
(139, 40, 70, 1),
(140, 40, 68, 2),
(141, 40, 67, 3),
(142, 40, 66, 4),
(156, 41, 51, 2),
(157, 41, 50, 3),
(158, 41, 48, 4),
(159, 41, 66, 5),
(155, 41, 52, 1),
(164, 42, 54, 4),
(165, 42, 53, 5),
(166, 42, 57, 6),
(167, 43, 57, 1),
(168, 43, 53, 2),
(169, 43, 54, 3),
(177, 29, 140, 1),
(178, 29, 98, 2),
(183, 30, 150, 1),
(184, 30, 147, 2),
(185, 30, 149, 3),
(187, 16, 153, 2),
(188, 16, 152, 3),
(189, 16, 102, 4),
(191, 16, 98, 6),
(200, 32, 149, 3),
(198, 32, 156, 1),
(202, 32, 150, 5),
(203, 32, 157, 6),
(201, 32, 146, 4),
(199, 32, 158, 2),
(204, 32, 155, 7),
(205, 32, 148, 8),
(218, 12, 32, 5),
(214, 12, 34, 1),
(217, 12, 33, 4),
(219, 12, 19, 6),
(220, 12, 23, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]frg_settings`
--

CREATE TABLE `[[dbprefix]]frg_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]frg_settings`
--

INSERT INTO `[[dbprefix]]frg_settings` VALUES
(1, 'LOCATION', ''),
(2, 'PAYMENT_NOTES', ''),
(3, 'PAYMENT_ACCEPTED', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gc_list`
--

CREATE TABLE `[[dbprefix]]gc_list` (
  `gc_id` int(11) NOT NULL AUTO_INCREMENT,
  `gc_code` varchar(255) DEFAULT NULL,
  `gc_to` varchar(255) DEFAULT NULL,
  `gc_from` varchar(255) DEFAULT NULL,
  `gc_message` varchar(255) DEFAULT NULL,
  `gc_amount` float DEFAULT NULL,
  `gc_remainder` float DEFAULT NULL,
  `gc_sendtype` varchar(1) DEFAULT NULL,
  `gc_date_created` int(11) DEFAULT NULL,
  `gc_status` varchar(1) DEFAULT NULL,
  `gc_fname` varchar(255) DEFAULT NULL,
  `gc_lname` varchar(255) DEFAULT NULL,
  `gc_email` varchar(255) DEFAULT NULL,
  `gc_address` varchar(255) DEFAULT NULL,
  `gc_city` varchar(255) DEFAULT NULL,
  `gc_state_id` int(11) DEFAULT NULL,
  `gc_country_id` int(11) DEFAULT NULL,
  `gc_zip` varchar(255) DEFAULT NULL,
  `gc_phone` varchar(255) DEFAULT NULL,
  `gc_purchased_order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`gc_id`),
  KEY `IDX_code` (`gc_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]images`
--

CREATE TABLE `[[dbprefix]]images` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `image_media` enum('IMAGE_MEDIA_SERVER_PATH','IMAGE_MEDIA_URL','IMAGE_MEDIA_THEME_PATH') NOT NULL,
  `image_path` text,
  `image_url` text,
  `image_mime_type` varchar(255) DEFAULT NULL,
  `image_width` int(11) DEFAULT NULL,
  `image_height` int(11) DEFAULT NULL,
  `image_filesize` int(11) DEFAULT NULL,
  `image_alt_text` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=37 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image_thumbnails`
--

CREATE TABLE `[[dbprefix]]image_thumbnails` (
  `image_id` int(11) NOT NULL DEFAULT '0',
  `thumbnail_image_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]infotags_to_action`
--

CREATE TABLE `[[dbprefix]]infotags_to_action` (
  `infotag_to_action_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_infotag_id` int(11) DEFAULT NULL,
  `notification_action_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`infotag_to_action_id`),
  KEY `IDX_ni` (`notification_infotag_id`),
  KEY `IDX_na` (`notification_action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=576 ;

--
-- Dumping data for table `[[dbprefix]]infotags_to_action`
--

INSERT INTO `[[dbprefix]]infotags_to_action` VALUES
(1, 15, 1),
(2, 16, 1),
(3, 17, 1),
(4, 19, 1),
(5, 21, 1),
(6, 22, 1),
(7, 23, 1),
(8, 24, 1),
(9, 25, 1),
(10, 26, 1),
(11, 27, 1),
(12, 28, 1),
(13, 29, 1),
(14, 30, 1),
(15, 31, 1),
(16, 32, 1),
(17, 33, 1),
(18, 34, 1),
(19, 35, 1),
(20, 36, 1),
(21, 37, 1),
(22, 38, 1),
(23, 39, 1),
(24, 40, 1),
(25, 41, 1),
(26, 42, 1),
(27, 43, 1),
(28, 44, 1),
(29, 45, 1),
(30, 46, 1),
(31, 47, 1),
(32, 48, 1),
(33, 49, 1),
(34, 50, 1),
(35, 51, 1),
(36, 52, 1),
(37, 53, 1),
(38, 54, 1),
(39, 55, 1),
(40, 56, 1),
(41, 57, 1),
(42, 58, 1),
(43, 59, 1),
(44, 60, 1),
(45, 61, 1),
(46, 62, 1),
(47, 63, 1),
(48, 64, 1),
(49, 65, 1),
(50, 66, 1),
(51, 67, 1),
(52, 68, 1),
(53, 69, 1),
(54, 70, 1),
(55, 71, 1),
(56, 72, 1),
(57, 73, 1),
(58, 74, 1),
(59, 75, 1),
(60, 76, 1),
(61, 77, 1),
(62, 78, 1),
(63, 79, 1),
(64, 80, 1),
(65, 81, 1),
(66, 82, 1),
(67, 83, 1),
(68, 15, 2),
(69, 16, 2),
(70, 17, 2),
(71, 18, 2),
(72, 19, 2),
(73, 20, 2),
(74, 21, 2),
(75, 22, 2),
(76, 23, 2),
(77, 24, 2),
(78, 25, 2),
(79, 26, 2),
(80, 27, 2),
(81, 28, 2),
(82, 29, 2),
(83, 30, 2),
(84, 31, 2),
(85, 32, 2),
(86, 33, 2),
(87, 34, 2),
(88, 35, 2),
(89, 36, 2),
(90, 37, 2),
(91, 38, 2),
(92, 39, 2),
(93, 40, 2),
(94, 41, 2),
(95, 42, 2),
(96, 43, 2),
(97, 44, 2),
(98, 45, 2),
(99, 46, 2),
(100, 47, 2),
(101, 48, 2),
(102, 49, 2),
(103, 50, 2),
(104, 51, 2),
(105, 52, 2),
(106, 53, 2),
(107, 54, 2),
(108, 55, 2),
(109, 56, 2),
(110, 57, 2),
(111, 58, 2),
(112, 59, 2),
(113, 60, 2),
(114, 61, 2),
(115, 62, 2),
(116, 63, 2),
(117, 64, 2),
(118, 65, 2),
(119, 66, 2),
(120, 67, 2),
(121, 68, 2),
(122, 69, 2),
(123, 70, 2),
(124, 71, 2),
(125, 72, 2),
(126, 73, 2),
(127, 74, 2),
(128, 75, 2),
(129, 76, 2),
(130, 77, 2),
(131, 78, 2),
(132, 79, 2),
(133, 80, 2),
(134, 81, 2),
(135, 82, 2),
(136, 83, 2),
(137, 15, 3),
(138, 16, 3),
(139, 17, 3),
(140, 18, 3),
(141, 19, 3),
(142, 21, 3),
(143, 22, 3),
(144, 23, 3),
(145, 24, 3),
(146, 25, 3),
(147, 26, 3),
(148, 27, 3),
(149, 28, 3),
(150, 29, 3),
(151, 30, 3),
(152, 31, 3),
(153, 32, 3),
(154, 33, 3),
(155, 34, 3),
(156, 35, 3),
(157, 36, 3),
(158, 37, 3),
(159, 38, 3),
(160, 39, 3),
(161, 40, 3),
(162, 41, 3),
(163, 42, 3),
(164, 43, 3),
(165, 44, 3),
(166, 45, 3),
(167, 46, 3),
(168, 47, 3),
(169, 48, 3),
(170, 49, 3),
(171, 50, 3),
(172, 51, 3),
(173, 52, 3),
(174, 53, 3),
(175, 54, 3),
(176, 55, 3),
(177, 56, 3),
(178, 57, 3),
(179, 58, 3),
(180, 59, 3),
(181, 60, 3),
(182, 61, 3),
(183, 62, 3),
(184, 63, 3),
(185, 64, 3),
(186, 65, 3),
(187, 66, 3),
(188, 67, 3),
(189, 68, 3),
(190, 69, 3),
(191, 70, 3),
(192, 71, 3),
(193, 72, 3),
(194, 73, 3),
(195, 74, 3),
(196, 75, 3),
(197, 76, 3),
(198, 77, 3),
(199, 78, 3),
(200, 79, 3),
(201, 80, 3),
(202, 81, 3),
(203, 82, 3),
(204, 83, 3),
(205, 15, 4),
(206, 16, 4),
(207, 17, 4),
(208, 19, 4),
(209, 21, 4),
(210, 22, 4),
(211, 23, 4),
(212, 24, 4),
(213, 25, 4),
(214, 26, 4),
(215, 27, 4),
(216, 28, 4),
(217, 29, 4),
(218, 30, 4),
(219, 31, 4),
(220, 32, 4),
(221, 33, 4),
(222, 34, 4),
(223, 35, 4),
(224, 36, 4),
(225, 37, 4),
(226, 38, 4),
(227, 39, 4),
(228, 40, 4),
(229, 41, 4),
(230, 42, 4),
(231, 43, 4),
(232, 44, 4),
(233, 45, 4),
(234, 46, 4),
(235, 47, 4),
(236, 48, 4),
(237, 49, 4),
(238, 50, 4),
(239, 51, 4),
(240, 52, 4),
(241, 53, 4),
(242, 54, 4),
(243, 55, 4),
(244, 56, 4),
(245, 57, 4),
(246, 58, 4),
(247, 59, 4),
(248, 60, 4),
(249, 61, 4),
(250, 62, 4),
(251, 63, 4),
(252, 64, 4),
(253, 65, 4),
(254, 66, 4),
(255, 67, 4),
(256, 68, 4),
(257, 69, 4),
(258, 70, 4),
(259, 71, 4),
(260, 72, 4),
(261, 73, 4),
(262, 74, 4),
(263, 75, 4),
(264, 76, 4),
(265, 77, 4),
(266, 78, 4),
(267, 79, 4),
(268, 80, 4),
(269, 81, 4),
(270, 82, 4),
(271, 83, 4),
(272, 15, 5),
(273, 16, 5),
(274, 37, 5),
(275, 38, 5),
(276, 39, 5),
(277, 71, 5),
(278, 72, 5),
(279, 73, 5),
(280, 74, 5),
(281, 75, 5),
(282, 76, 5),
(283, 77, 5),
(284, 78, 5),
(285, 79, 5),
(286, 80, 5),
(287, 81, 5),
(288, 82, 5),
(289, 83, 5),
(290, 37, 6),
(291, 38, 6),
(292, 39, 6),
(293, 40, 6),
(294, 41, 6),
(295, 42, 6),
(296, 43, 6),
(297, 44, 6),
(298, 45, 6),
(299, 46, 6),
(300, 71, 6),
(301, 72, 6),
(302, 73, 6),
(303, 74, 6),
(304, 75, 6),
(305, 76, 6),
(306, 77, 6),
(307, 78, 6),
(308, 79, 6),
(309, 80, 6),
(310, 81, 6),
(311, 82, 6),
(312, 83, 6),
(313, 89, 6),
(314, 37, 7),
(315, 38, 7),
(316, 39, 7),
(317, 40, 7),
(318, 41, 7),
(319, 42, 7),
(320, 43, 7),
(321, 44, 7),
(322, 45, 7),
(323, 46, 7),
(324, 71, 7),
(325, 72, 7),
(326, 73, 7),
(327, 74, 7),
(328, 75, 7),
(329, 76, 7),
(330, 77, 7),
(331, 78, 7),
(332, 79, 7),
(333, 80, 7),
(334, 81, 7),
(335, 82, 7),
(336, 83, 7),
(337, 89, 7),
(338, 90, 7),
(339, 37, 8),
(340, 38, 8),
(341, 39, 8),
(342, 40, 8),
(343, 41, 8),
(344, 42, 8),
(345, 43, 8),
(346, 44, 8),
(347, 45, 8),
(348, 46, 8),
(349, 71, 8),
(350, 72, 8),
(351, 73, 8),
(352, 74, 8),
(353, 75, 8),
(354, 76, 8),
(355, 77, 8),
(356, 78, 8),
(357, 79, 8),
(358, 80, 8),
(359, 81, 8),
(360, 82, 8),
(361, 83, 8),
(362, 89, 8),
(363, 37, 9),
(364, 38, 9),
(365, 39, 9),
(366, 40, 9),
(367, 41, 9),
(368, 42, 9),
(369, 43, 9),
(370, 44, 9),
(371, 45, 9),
(372, 46, 9),
(373, 71, 9),
(374, 72, 9),
(375, 73, 9),
(376, 74, 9),
(377, 75, 9),
(378, 76, 9),
(379, 77, 9),
(380, 78, 9),
(381, 79, 9),
(382, 80, 9),
(383, 81, 9),
(384, 82, 9),
(385, 83, 9),
(386, 89, 9),
(387, 37, 10),
(388, 38, 10),
(389, 39, 10),
(390, 40, 10),
(391, 41, 10),
(392, 42, 10),
(393, 43, 10),
(394, 44, 10),
(395, 45, 10),
(396, 46, 10),
(397, 71, 10),
(398, 72, 10),
(399, 73, 10),
(400, 74, 10),
(401, 75, 10),
(402, 76, 10),
(403, 77, 10),
(404, 78, 10),
(405, 79, 10),
(406, 80, 10),
(407, 81, 10),
(408, 82, 10),
(409, 83, 10),
(410, 89, 10),
(411, 37, 11),
(412, 38, 11),
(413, 39, 11),
(414, 40, 11),
(415, 41, 11),
(416, 42, 11),
(417, 43, 11),
(418, 44, 11),
(419, 45, 11),
(420, 46, 11),
(421, 71, 11),
(422, 72, 11),
(423, 73, 11),
(424, 74, 11),
(425, 75, 11),
(426, 76, 11),
(427, 77, 11),
(428, 78, 11),
(429, 79, 11),
(430, 80, 11),
(431, 81, 11),
(432, 82, 11),
(433, 83, 11),
(434, 89, 11),
(435, 91, 11),
(436, 37, 12),
(437, 38, 12),
(438, 39, 12),
(439, 40, 12),
(440, 41, 12),
(441, 42, 12),
(442, 43, 12),
(443, 44, 12),
(444, 45, 12),
(445, 46, 12),
(446, 71, 12),
(447, 72, 12),
(448, 73, 12),
(449, 74, 12),
(450, 75, 12),
(451, 76, 12),
(452, 77, 12),
(453, 78, 12),
(454, 79, 12),
(455, 80, 12),
(456, 81, 12),
(457, 82, 12),
(458, 83, 12),
(459, 89, 12),
(460, 91, 12),
(461, 37, 13),
(462, 38, 13),
(463, 39, 13),
(464, 40, 13),
(465, 41, 13),
(466, 42, 13),
(467, 43, 13),
(468, 44, 13),
(469, 45, 13),
(470, 46, 13),
(471, 71, 13),
(472, 72, 13),
(473, 73, 13),
(474, 74, 13),
(475, 75, 13),
(476, 76, 13),
(477, 77, 13),
(478, 78, 13),
(479, 79, 13),
(480, 80, 13),
(481, 81, 13),
(482, 82, 13),
(483, 83, 13),
(484, 89, 13),
(485, 91, 13),
(486, 92, 14),
(487, 93, 14),
(488, 94, 14),
(489, 71, 14),
(490, 72, 14),
(491, 73, 14),
(492, 74, 14),
(493, 75, 14),
(494, 76, 14),
(495, 77, 14),
(496, 78, 14),
(497, 79, 14),
(498, 80, 14),
(499, 81, 14),
(500, 82, 14),
(501, 83, 14),
(502, 2, 14),
(503, 1, 15),
(504, 2, 15),
(505, 3, 15),
(506, 4, 15),
(507, 5, 15),
(508, 6, 15),
(509, 7, 15),
(510, 8, 15),
(511, 9, 15),
(512, 10, 15),
(513, 11, 15),
(514, 12, 15),
(515, 13, 15),
(516, 14, 15),
(517, 95, 15),
(518, 96, 15),
(519, 97, 15),
(520, 98, 15),
(521, 99, 15),
(522, 100, 15),
(523, 101, 15),
(524, 71, 15),
(525, 72, 15),
(526, 73, 15),
(527, 74, 15),
(528, 75, 15),
(529, 76, 15),
(530, 77, 15),
(531, 78, 15),
(532, 79, 15),
(533, 80, 15),
(534, 81, 15),
(535, 82, 15),
(536, 83, 15),
(537, 15, 16),
(538, 16, 16),
(539, 40, 16),
(540, 41, 16),
(541, 42, 16),
(542, 74, 16),
(543, 75, 16),
(544, 76, 16),
(545, 77, 16),
(546, 78, 16),
(547, 79, 16),
(548, 80, 16),
(549, 81, 16),
(550, 82, 16),
(551, 83, 16),
(552, 84, 16),
(553, 85, 16),
(554, 86, 16),
(555, 114, 16),
(556, 74, 17),
(557, 75, 17),
(558, 76, 17),
(559, 77, 17),
(560, 78, 17),
(561, 79, 17),
(562, 80, 17),
(563, 81, 17),
(564, 82, 17),
(565, 83, 17),
(566, 84, 17),
(567, 85, 17),
(568, 86, 17),
(569, 114, 17),
(570, 71, 16),
(571, 71, 17),
(572, 72, 16),
(573, 72, 17),
(574, 37, 16),
(575, 38, 16);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]infotags_to_blocktag`
--

CREATE TABLE `[[dbprefix]]infotags_to_blocktag` (
  `infotag_to_blocktag_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_blocktag_id` int(11) DEFAULT NULL,
  `notification_infotag_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`infotag_to_blocktag_id`),
  KEY `IDX_nb` (`notification_blocktag_id`),
  KEY `IDX_ni` (`notification_infotag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=48 ;

--
-- Dumping data for table `[[dbprefix]]infotags_to_blocktag`
--

INSERT INTO `[[dbprefix]]infotags_to_blocktag` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 1, 9),
(10, 1, 10),
(11, 1, 11),
(12, 1, 12),
(13, 1, 13),
(14, 1, 14),
(15, 2, 1),
(16, 2, 2),
(17, 2, 4),
(18, 2, 5),
(19, 2, 6),
(20, 2, 7),
(21, 2, 8),
(22, 2, 9),
(23, 2, 10),
(24, 2, 13),
(25, 2, 14),
(26, 3, 24),
(27, 3, 25),
(28, 3, 26),
(29, 3, 27),
(30, 3, 28),
(31, 4, 84),
(32, 4, 85),
(33, 4, 86),
(34, 4, 87),
(35, 4, 88),
(36, 5, 102),
(37, 5, 103),
(38, 5, 104),
(39, 5, 105),
(40, 5, 106),
(41, 5, 107),
(42, 6, 108),
(43, 6, 109),
(44, 6, 110),
(45, 6, 111),
(46, 6, 112),
(47, 6, 113);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]input_types`
--

CREATE TABLE `[[dbprefix]]input_types` (
  `input_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_type_id` int(11) NOT NULL DEFAULT '0',
  `input_type_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`input_type_id`),
  KEY `IDX_uti` (`unit_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]input_types`
--

INSERT INTO `[[dbprefix]]input_types` VALUES
(1, 0, 'TEXT'),
(2, 0, 'TEXTAREA'),
(3, 0, 'SELECT'),
(4, 0, 'FILE'),
(5, 0, 'IMAGE'),
(6, 0, 'SELECT'),
(7, 0, 'SELECT'),
(8, 0, 'SELECT'),
(9, 0, 'SELECT'),
(10, 0, 'CHECKBOXGROUP'),
(11, 0, 'SELECT'),
(12, 0, 'SELECT'),
(13, 0, 'SELECT');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]input_type_values`
--

CREATE TABLE `[[dbprefix]]input_type_values` (
  `input_type_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `input_type_id` int(11) DEFAULT NULL,
  `input_type_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`input_type_value_id`),
  KEY `IDX_iti` (`input_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]input_type_values`
--

INSERT INTO `[[dbprefix]]input_type_values` VALUES
(1, 3, 'PRDTYPE_VALUE_YES'),
(2, 3, 'PRDTYPE_VALUE_NO'),
(3, 7, 'PRDTYPE_VALUE_STATUS_ONLINE'),
(4, 7, 'PRDTYPE_VALUE_STATUS_OFFLINE'),
(5, 9, 'PRDTYPE_VALUE_REVIEW_RATE'),
(6, 9, 'PRDTYPE_VALUE_REVIEW'),
(7, 9, 'PRDTYPE_VALUE_RATE'),
(8, 9, 'PRDTYPE_VALUE_NOREVIEW'),
(9, 11, 'PRDTYPE_VALUE_NOT_SELECTED'),
(10, 11, 'PRDTYPE_VALUE_ACCESSORIES_CLOTHING'),
(11, 11, 'PRDTYPE_VALUE_ACCESSORIES_SHOES'),
(12, 11, 'PRDTYPE_VALUE_ACCESSORIES'),
(13, 11, 'PRDTYPE_VALUE_MEDIA_BOOKS'),
(14, 11, 'PRDTYPE_VALUE_MEDIA_DVD'),
(15, 11, 'PRDTYPE_VALUE_MEDIA_MUSIC'),
(16, 11, 'PRDTYPE_VALUE_SOFTWARE_VIDEO_GAME'),
(17, 12, 'PRDTYPE_VALUE_NOT_SELECTED'),
(18, 12, 'PRDTYPE_VALUE_ADULT'),
(19, 12, 'PRDTYPE_VALUE_KIDS'),
(20, 13, 'PRDTYPE_VALUE_NOT_SELECTED'),
(21, 13, 'PRDTYPE_VALUE_MALE'),
(22, 13, 'PRDTYPE_VALUE_FEMALE'),
(23, 13, 'PRDTYPE_VALUE_UNISEX');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]layout_https_settings`
--

CREATE TABLE `[[dbprefix]]layout_https_settings` (
  `layout_https_settings_id` int(11) NOT NULL AUTO_INCREMENT,
  `layout_https_settings_layout_full_file_name` varchar(255) NOT NULL DEFAULT '',
  `layout_https_settings_catalog` char(5) NOT NULL DEFAULT 'false',
  `layout_https_settings_cart` char(5) NOT NULL DEFAULT 'false',
  `layout_https_settings_checkout` char(5) NOT NULL DEFAULT 'false',
  `layout_https_settings_download` char(5) NOT NULL DEFAULT 'false',
  `layout_https_settings_customer_data` char(5) NOT NULL DEFAULT 'false',
  `layout_https_settings_customer_login` char(5) NOT NULL DEFAULT 'false',
  `layout_https_settings_whole_cz` char(5) NOT NULL DEFAULT 'false',
  PRIMARY KEY (`layout_https_settings_id`),
  UNIQUE KEY `IDX_unique` (`layout_https_settings_layout_full_file_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localization_settings`
--

CREATE TABLE `[[dbprefix]]localization_settings` (
  `localization_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) DEFAULT NULL,
  `setting_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`localization_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=52 ;

--
-- Dumping data for table `[[dbprefix]]localization_settings`
--

INSERT INTO `[[dbprefix]]localization_settings` VALUES
(1, 'DATE_FORMAT', 'M d, Y'),
(2, 'TIME_FORMAT', 'h:i a'),
(3, 'NUMBER_FORMAT', '2|.|,|'),
(4, 'NEGATIVE_FORMAT', '- %s'),
(9, 'WEIGHT_UNIT', 'lb'),
(10, 'WEIGHT_COEFF', '0.45359'),
(11, 'ITEM_UNIT', 'Item(s)'),
(12, 'CURRENCY_13', '13|AUD'),
(13, 'CURRENCY_FORMAT_13', '2|.|,|'),
(14, 'CURRENCY_POSITIVE_FORMAT_13', '{s}{v}'),
(15, 'CURRENCY_NEGATIVE_FORMAT_13', '-{s}{v}'),
(16, 'CURRENCY_48', '48|CAD'),
(17, 'CURRENCY_FORMAT_48', '2|.|,|'),
(18, 'CURRENCY_POSITIVE_FORMAT_48', '{s}{v}'),
(19, 'CURRENCY_NEGATIVE_FORMAT_48', '-{s}{v}'),
(20, 'CURRENCY_6', '6|EUR'),
(21, 'CURRENCY_FORMAT_6', '2|.|,|'),
(22, 'CURRENCY_POSITIVE_FORMAT_6', '{s}{v}'),
(23, 'CURRENCY_NEGATIVE_FORMAT_6', '-{s}{v}'),
(24, 'CURRENCY_36', '36|GBP'),
(25, 'CURRENCY_FORMAT_36', '2|.|,|'),
(26, 'CURRENCY_POSITIVE_FORMAT_36', '{s}{v}'),
(27, 'CURRENCY_NEGATIVE_FORMAT_36', '-{s}{v}'),
(28, 'CURRENCY_107', '107|ILS'),
(29, 'CURRENCY_FORMAT_107', '2|.|,|'),
(30, 'CURRENCY_POSITIVE_FORMAT_107', '{s}{v}'),
(31, 'CURRENCY_NEGATIVE_FORMAT_107', '-{s}{v}'),
(32, 'CURRENCY_143', '143|JPY'),
(33, 'CURRENCY_FORMAT_143', '2|.|,|'),
(34, 'CURRENCY_POSITIVE_FORMAT_143', '{s}{v}'),
(35, 'CURRENCY_NEGATIVE_FORMAT_143', '-{s}{v}'),
(36, 'CURRENCY_205', '205|NOK'),
(37, 'CURRENCY_FORMAT_205', '2|.|,|'),
(38, 'CURRENCY_POSITIVE_FORMAT_205', '{s}{v}'),
(39, 'CURRENCY_NEGATIVE_FORMAT_205', '-{s}{v}'),
(40, 'CURRENCY_68', '68|NZD'),
(41, 'CURRENCY_FORMAT_68', '2|.|,|'),
(42, 'CURRENCY_POSITIVE_FORMAT_68', '{s}{v}'),
(43, 'CURRENCY_NEGATIVE_FORMAT_68', '-{s}{v}'),
(44, 'CURRENCY_265', '265|SEK'),
(45, 'CURRENCY_FORMAT_265', '2|.|,|'),
(46, 'CURRENCY_POSITIVE_FORMAT_265', '{s}{v}'),
(47, 'CURRENCY_NEGATIVE_FORMAT_265', '-{s}{v}'),
(48, 'CURRENCY_4', '4|$'),
(49, 'CURRENCY_FORMAT_4', '2|.|,|'),
(50, 'CURRENCY_POSITIVE_FORMAT_4', '{s}{v}'),
(51, 'CURRENCY_NEGATIVE_FORMAT_4', '-{s}{v}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_settings`
--

CREATE TABLE `[[dbprefix]]mail_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(255) NOT NULL DEFAULT '',
  `parameter_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]mail_settings`
--

INSERT INTO `[[dbprefix]]mail_settings` VALUES
(1, 'MAIL_TYPE', '1'),
(2, 'MAIL_HOST', 'mail.domain.com'),
(3, 'MAIL_PORT', '25'),
(4, 'MAIL_AUTH', '0'),
(5, 'MAIL_USER', 'user@domain.com'),
(6, 'MAIL_PASS', 'password');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]manufacturers`
--

CREATE TABLE `[[dbprefix]]manufacturers` (
  `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturer_name` varchar(255) NOT NULL DEFAULT '',
  `manufacturer_descr` longtext,
  `manufacturer_image_id` int(11) DEFAULT NULL,
  `manufacturer_site_url` varchar(255) DEFAULT NULL,
  `manufacturer_active` char(5) NOT NULL DEFAULT 'true',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]manufacturers`
--

INSERT INTO `[[dbprefix]]manufacturers` VALUES
(1, 'Apple', '<b>Apple Inc.</b> is an American multinational corporation that designs and manufactures consumer electronics and computer software products. <br /><br />The company''s best-known hardware products include Macintosh computers, the iPod and the iPhone. Apple software includes the Mac OS X operating system, the iTunes media browser, the iLife suite of multimedia and creativity software, the iWork suite of productivity software, Final Cut Studio, a suite of professional audio and film-industry software products, and Logic Studio, a suite of audio tools. <br /><br />The company operates more than 250 retail stores in nine countries and an online store where hardware and software products are sold.', 15, 'http://www.apple.com/', 'true', 2),
(2, 'Asus', '<b>ASUSTeK</b> Computer Incorporated, a Taiwan-based multinational company, produces motherboards, graphics cards, sound cards, optical drives, PDAs, computer monitors, notebook computers, servers, networking products, mobile phones, computer cases, computer components, and computer cooling systems.', 13, 'http://www.asus.com/', 'true', 1),
(3, 'Dell', '<span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="font-family: sans-serif; font-size: 13px; line-height: 19px"><b>Dell Inc.</b> is a multinational technology corporation that develops, manufactures, sells, and supports personal computers and other computer-related products. Based in Round Rock, Texas, Dell employs more than 76,500 people worldwide.<b><br /></b></span></span>', 9, 'http://www.dell.com/', 'true', 4),
(4, 'HP', '<span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="font-family: Arial,Verdana,Helvetica,sans-serif; font-size: 12px"><b>HP </b>is a technology company that operates in more than 170 countries around the world. We explore how technology and services can help people and companies address their problems and challenges, and realize their possibilities, aspirations and dreams. We apply new thinking and ideas to create more simple, valuable and trusted experiences with technology, continuously improving the way our customers live and work.</span></span>', 3, 'http://www.hp.com/', 'true', 5),
(5, 'MSI', 'Founded in August 1986, <b>MSI</b> has continued to uphold a business philosophy that stresses &quot;Award-winning product quality and outstanding customer service.&quot; MSI specializes in the design and manufacture of motherboards, graphics card, add-on cards, servers/workstations, iPC, barebones, communication devices, CE products, Notebooks, car infotainment products, and All-in-One PC.', 1, 'http://www.msi.com/', 'true', 8),
(6, 'Garmin', '<span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="font-family: sans-serif; font-size: 13px; font-weight: bold; line-height: 19px">Garmin Ltd.</span></span>', 17, 'http://www.garmin.com/', 'true', 6),
(7, 'IKEA', '<b>IKEA</b> is a privately-held, international home products retailer that sells flat pack furniture, accessories, and bathroom and kitchen items in their retail stores around the world. The company, which pioneered flat-pack design furniture at affordable prices, is now the world''s largest furniture retailer.', 29, 'http://www.ikea.com/', 'true', 7),
(8, 'Avactis', '', 33, 'http://www.avactis.com/', 'true', 0),
(9, 'Brunton', '<span style="color: #333333; line-height: 14px; -webkit-border-horizontal-spacing: 2px; -webkit-border-vertical-spacing: 2px" class="Apple-style-span"><span style="font-size: small" class="Apple-style-span"><font face="arial, helvetica, sans-serif" class="Apple-style-span"><b>Brunton</b></font></span></span>', 35, 'http://www.brunton.com/', 'true', 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]marketplace_ext_data`
--

CREATE TABLE `[[dbprefix]]marketplace_ext_data` (
  `extension_id` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(255) NOT NULL DEFAULT '',
  `extension_name` varchar(255) NOT NULL DEFAULT '',
  `extension_desc` varchar(255) NOT NULL DEFAULT '',
  `extension_detail_link` varchar(255) NOT NULL DEFAULT '',
  `extension_price` decimal(12,2) NOT NULL DEFAULT '0.00',
  `extension_image` varchar(255) NOT NULL DEFAULT '',
  `extension_category` varchar(255) NOT NULL DEFAULT '',
  `extension_type` char(2) NOT NULL DEFAULT 'P',
  `latestversion` varchar(255) NOT NULL DEFAULT '',
  `latestcompatibleversion` varchar(255) NOT NULL DEFAULT '',
  `extension_filename` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`extension_id`),
  KEY `IDX_ext_id` (`extension_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_admin`
--

CREATE TABLE `[[dbprefix]]menu_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(255) NOT NULL,
  `menu_description` varchar(255) NOT NULL,
  `icon_image` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL DEFAULT '0',
  `has_subcategory` char(5) NOT NULL,
  `visibility` char(5) NOT NULL,
  `menu_url` varchar(255) NOT NULL,
  `group_name` varchar(255) NOT NULL,
  `new_window` char(5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_menu_name` (`menu_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module`
--

CREATE TABLE `[[dbprefix]]module` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(50) NOT NULL DEFAULT '',
  `module_groups` varchar(255) NOT NULL DEFAULT '',
  `module_description` varchar(255) NOT NULL DEFAULT '',
  `module_version` varchar(20) NOT NULL DEFAULT '',
  `module_author` varchar(255) NOT NULL DEFAULT '',
  `module_contact` varchar(255) NOT NULL DEFAULT '',
  `module_system` varchar(1) NOT NULL DEFAULT '0',
  `module_date` date NOT NULL DEFAULT '0000-00-00',
  `module_active` varchar(1) NOT NULL DEFAULT '0',
  `module_updated` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=77 ;

--
-- Dumping data for table `[[dbprefix]]module`
--

INSERT INTO `[[dbprefix]]module` VALUES
(1, 'Modules_Manager', 'Main', 'Modules_Manager module description', '0.1.%BUILD%', 'Alexey Kolesnikov', '', '1', '0000-00-00', '1', '1'),
(2, 'Resources', 'Main', 'Resources module', '0.1.%BUILD%', 'Ravil Garafutdinov', '', '', '0000-00-00', '1', '1'),
(3, 'MultiLang', 'Main', 'MultiLang module', '0.1.%BUILD%', 'Sergey Kulitsky', '', '', '0000-00-00', '1', '1'),
(4, 'Configuration', 'Main', 'Configuration module', '0.1.%BUILD%', 'Alexey Florinsky', '', '', '0000-00-00', '1', '1'),
(5, 'EventsManager', 'Main', 'EventsManager module description', '0.1.%BUILD%', 'Alexey Florinsky', '', '1', '0000-00-00', '1', '1'),
(6, 'Bestsellers_API', 'Main', 'Bestsellers module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(7, 'Cart', 'Main', '', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(8, 'Catalog', 'Main', 'Catalog module description', '0.1.%BUILD%', 'Alexey Kolesnikov', '', '', '0000-00-00', '1', '1'),
(9, 'Charts', 'Main', 'Charts module', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(10, 'Checkout', 'Main', 'Checkout module description', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(11, 'CMS', 'Main', 'CMS module', '0.1.%BUILD%', 'Sergey Kulitsky', '', '', '0000-00-00', '1', '1'),
(12, 'ColorSwatch', 'Main', '', '1.0.%BUILD%', 'Avactis Team', '', '', '0000-00-00', '1', '1'),
(13, 'Crypto', 'Main', 'Crypto module', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(14, 'Currency_Converter', 'Main', 'Currency Converter', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(15, 'Customer_Account', 'Main', 'Customer Account module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(16, 'Customer_Reviews', 'Main', 'Customer Reviews module', '0.1.%BUILD%', 'Sergey E. Kulitsky', '', '', '0000-00-00', '1', '1'),
(17, 'Data_Converter', 'Main', 'Data Converter module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(18, 'Discounts', '', 'Discounts', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(19, 'Error', 'Main', 'Error module description', '0.1.%BUILD%', 'Alexey Kolesnikov', '', '1', '0000-00-00', '1', '1'),
(20, 'Error_Document', 'Main', 'Error document module description', '0.1.%BUILD%', 'HBWSL', '', '1', '0000-00-00', '1', '1'),
(21, 'EventStack', 'Main', 'EventStack module description', '0.1.%BUILD%', 'Alexey Florinsky', '', '1', '0000-00-00', '1', '1'),
(22, 'Extension_Manager', 'Main', 'Module for managing Extensions and Core upgrade', '0.1.%BUILD%', 'Gaurav Joshi', '', '', '0000-00-00', '1', '1'),
(23, 'Featured_Products', 'Main', 'Featured Products module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(24, 'Froogle', 'Main', 'Export products to Froogle', '0.1.%BUILD%', 'Egor Makarov', '', '', '0000-00-00', '1', '1'),
(25, 'GiftCertificateApi', 'Main', 'GiftCertificate module description', '0.1.%BUILD%', 'Alexey Florinsky', '', '1', '0000-00-00', '1', '1'),
(26, 'Hint', 'Main', 'Hint module description', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(27, 'HTTPS', 'Main', 'HTTPS module', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(28, 'Images', 'Main', 'Images module', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(29, 'Layout_CMS', 'Main', 'Layout CMS module', '0.1.%BUILD%', 'Alexey Astafyev', '', '', '0000-00-00', '1', '1'),
(30, 'License', 'Main', 'License module', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(31, 'Localization', 'Main', 'Localization module', '0.1.%BUILD%', 'Alexey Florinsky', '', '', '0000-00-00', '1', '1'),
(32, 'Location', 'Main', 'Location module', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(33, 'Look_Feel', 'Main', 'Look & Feel module', '0.1.%BUILD%', 'Sergey Kulitsky', '', '', '0000-00-00', '1', '1'),
(34, 'Manufacturers', 'Main', 'Manufacturers module', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(35, 'MenuManager', 'Main', 'To manage menus in Admin', '0.1.%BUILD%', 'Avactis Team', '', '', '0000-00-00', '1', '1'),
(36, 'Mod_Rewrite', 'Main', 'Mod Rewrite module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(37, 'News', 'Main', 'News module', '0.1.%BUILD%', 'Timur Nasibullin', '', '', '0000-00-00', '1', '1'),
(38, 'Newsletter', 'Main', 'module description', '0.1.%BUILD%', 'Egor Makarov', '', '', '0000-00-00', '1', '1'),
(39, 'Notifications', 'Main', 'Notifications module', '0.1.%BUILD%', 'Alexey Florinsky', '', '', '0000-00-00', '1', '1'),
(40, 'OrdersExportCSV', 'Main', 'Orders Export to CSV feature', '0.1.%BUILD%', 'Alexey Florinsky', '', '', '0000-00-00', '1', '1'),
(41, 'Paginator', 'Main', 'Paginator module description', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(42, 'Payment_Module_All_Inactive', 'PaymentModule', 'AllInactive payment module. See payment documentation', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(43, 'Payment_Module_Cod', 'PaymentModule,Offline', '"Cash on delivery" method payment module. See payment documentation', '0.1.%BUILD%', 'Egor Makarov', '', '', '0000-00-00', '1', '1'),
(44, 'Payment_Module_Gc', 'PaymentModule', '"Gift Certificate" substitution payment method payment module.', '1.0.%BUILD%', 'Ravil Garafutdinov', '', '', '0000-00-00', '1', '1'),
(45, 'Payment_Module_Offline_CC', 'PaymentModule,Offline', 'OfflineCC payment module. See payment documentation', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(46, 'Payment_Module_Paypal_CC', 'PaymentModule,OnlineCC', 'PaypalCC payment module. See payment documentation', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(47, 'Product_Files', 'Main', 'Product Files module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(48, 'Product_Images', 'Main', 'Product Images module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(49, 'Product_Options', 'Main', 'Product Options module', '0.5.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(50, 'PromoCodes', '', 'PromoCodes', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(51, 'Quantity_Discounts', '', 'Quantity discounts', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(52, 'Quick_Books', 'Main', 'Quick Books integration module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(53, 'Related_Products', 'Main', 'Related Products module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(54, 'Reports', 'Main', 'Reports module', '0.1.%BUILD%', 'Alexey Florinsky', '', '1', '0000-00-00', '1', '1'),
(55, 'RESTManager', 'Main', 'REST Api module', '0.1.%BUILD%', 'Alexey Florinsky', '', '1', '0000-00-00', '1', '1'),
(56, 'SecureStore', 'Main', '', '0.1.%BUILD%', 'Pragati', '', '', '0000-00-00', '1', '1'),
(58, 'Shell', 'Main', 'Shell module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(59, 'Shipping_Cost_Calculator', 'Main', 'Shipping Cost Calculator', '0.2.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(60, 'Shipping_Module_All_Inactive', 'ShippingModule', 'All Inactive shipping module. See shipping documentation', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(61, 'Shipping_Module_DSR', 'ShippingModule,Offline', 'Custom Shipping Rates shipping module. See shipping documentation', '0.1.%BUILD%', 'Ravil Garafutdinov, Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(62, 'Shipping_Module_Free_Shipping', 'ShippingModule,Offline', 'Free Shipping emulation shipping module.', '0.1.%BUILD%', 'Ravil Garafutdinov', '', '', '0000-00-00', '1', '1'),
(63, 'Shipping_Tester', 'Main', 'Shipping Tester', '0.2.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(64, 'Statistics', 'Main', 'Statistics module', '0.1.%BUILD%', 'Egor V. Derevyankin', '', '', '0000-00-00', '1', '1'),
(65, 'Subscriptions', 'Main', 'Customers'' subscriptions to newsletters', '0.0.%BUILD%', 'Sergey Galanin', '', '', '0000-00-00', '1', '1'),
(66, 'TaxExempts', '', 'TaxExempts', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(67, 'TaxRateByZip', 'Main', 'Tax Rate by Zip module', '0.1.%BUILD%', 'Garafutdinov Ravil', '', '', '0000-00-00', '1', '1'),
(68, 'Taxes', 'Main', 'Taxes module', '0.1.%BUILD%', 'Alexander Girin', '', '', '0000-00-00', '1', '1'),
(69, 'Timeline', 'Main', 'Timeline module', '0.1.%BUILD%', 'Alexey Florinsky', '', '1', '0000-00-00', '1', '1'),
(70, 'Tools', 'Main', 'Tools module', '0.1.%BUILD%', 'Alexey Florinsky', '', '', '0000-00-00', '1', '1'),
(71, 'TransactionTracking', '', 'TransactionTracking module description', '0.1.%BUILD%', 'Vadim Lyalikov', '', '', '0000-00-00', '1', '1'),
(72, 'Users', 'Main', 'Users module description', '0.1.%BUILD%', 'Alexey Florinsky, Alexander Girin', '', '1', '0000-00-00', '1', '1'),
(73, 'WishList', 'Main', 'WishList module', '0.1.%BUILD%', 'Sergey Kulitsky', '', '', '0000-00-00', '1', '1'),
(74, 'Wizard', 'Main', 'Wizard module', '0.1.%BUILD%', 'HBWSL', '', '', '0000-00-00', '1', '1'),
(75, 'AnalyticsApi', 'Main', 'Track store using google analytics', '0.1.47900', 'HBWSL', '', 'E', '0000-00-00', '1', '1'),
(76, 'banner', '', 'Banner System for Avactis shopcart', '0.1.%BUILD%', 'Ninad', '', 'E', '0000-00-00', '1', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]module_class`
--

CREATE TABLE `[[dbprefix]]module_class` (
  `module_id` int(11) NOT NULL,
  `module_class_name` varchar(255) NOT NULL DEFAULT '',
  `module_class_file` varchar(255) NOT NULL DEFAULT '',
  `module_class_type` varchar(20) NOT NULL DEFAULT '',
  `module_class_active` varchar(1) NOT NULL DEFAULT '0',
  KEY `MM_module_class_module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]module_class`
--

INSERT INTO `[[dbprefix]]module_class` VALUES
(1, 'ActionIsNotSetAction', '/avactis-system/modules/modules_manager/actions/action_is_not_set.php', 'action', '1'),
(1, 'combine_php', '/avactis-system/modules/modules_manager/actions/combine_php.php', 'action', '1'),
(1, 'reinstall_module', '/avactis-system/modules/modules_manager/actions/reinstall_module.php', 'action', '1'),
(1, 'reload_resources', '/avactis-system/modules/modules_manager/actions/reload_resources.php', 'action', '1'),
(1, 'ReinstallModuleAction', '/avactis-system/modules/modules_manager/actions/reinstall.php', 'action', '1'),
(2, 'Resources', '/avactis-system/modules/resources/resources_api.php', 'api', '1'),
(3, 'ML_ExportLabels', '/avactis-system/modules/multilang/views/ml_export_labels_az.php', 'view_az', '1'),
(3, 'SelectPageLanguage', '/avactis-system/modules/multilang/views/ml_select_page_language_az.php', 'view_az', '1'),
(3, 'LabelData', '/avactis-system/modules/multilang/views/ml_label_data_az.php', 'view_az', '1'),
(3, 'LabelEditor', '/avactis-system/modules/multilang/views/ml_label_editor_az.php', 'view_az', '1'),
(3, 'LanguageSettings', '/avactis-system/modules/multilang/views/ml_language_settings_az.php', 'view_az', '1'),
(3, 'GetLangPageURL', '/avactis-system/modules/multilang/views/ml_get_lang_page_url_cz.php', 'view_cz', '1'),
(3, 'SelectLanguage', '/avactis-system/modules/multilang/views/ml_select_language_az.php', 'view_az', '1'),
(3, 'SelectLanguage', '/avactis-system/modules/multilang/views/ml_select_language_cz.php', 'view_cz', '1'),
(3, 'ChangeLanguage', '/avactis-system/modules/multilang/actions/change_language.php', 'action', '1'),
(3, 'do_change_def_lng', '/avactis-system/modules/multilang/actions/do_change_def_lng_az.php', 'action', '1'),
(3, 'do_import_labels', '/avactis-system/modules/multilang/actions/do_import_labels_az.php', 'action', '1'),
(3, 'do_export_labels', '/avactis-system/modules/multilang/actions/do_export_labels_az.php', 'action', '1'),
(3, 'ChangePageLanguage', '/avactis-system/modules/multilang/actions/change_page_language_az.php', 'action', '1'),
(3, 'ML_UpdateLabelData', '/avactis-system/modules/multilang/actions/update_label_data_az.php', 'action', '1'),
(3, 'ML_UpdateLabels', '/avactis-system/modules/multilang/actions/update_labels_az.php', 'action', '1'),
(4, 'SettingGroupList', '/avactis-system/modules/configuration/views/settings_groups_az.php', 'view_az', '1'),
(4, 'CreditCardAttributes', '/avactis-system/modules/configuration/views/credit_card_attributes_az.php', 'view_az', '1'),
(4, 'SortCreditCardTypes', '/avactis-system/modules/configuration/views/sort_credit_card_types_az.php', 'view_az', '1'),
(4, 'CreditCardSettings', '/avactis-system/modules/configuration/views/credit_card_settings_az.php', 'view_az', '1'),
(4, 'CacheSettings', '/avactis-system/modules/configuration/views/cache_settings_az.php', 'view_az', '1'),
(4, 'StoreOwner', '/avactis-system/modules/configuration/views/store_owner_az.php', 'view_az', '1'),
(4, 'GeneralSettings', '/avactis-system/modules/configuration/views/general_settings_az.php', 'view_az', '1'),
(4, 'SetSupportMode', '/avactis-system/modules/configuration/actions/set-support-mode-action.php', 'action', '1'),
(4, 'UpdateMailSettings', '/avactis-system/modules/configuration/actions/update-mail-settings-action.php', 'action', '1'),
(4, 'ClearCache', '/avactis-system/modules/configuration/actions/clear-cache-action.php', 'action', '1'),
(4, 'UpdateCreditCardAttributes', '/avactis-system/modules/configuration/actions/update-credit-card-attributes-action.php', 'action', '1'),
(4, 'UpdateApplicationSettings', '/avactis-system/modules/configuration/actions/update-application-settings-action.php', 'action', '1'),
(4, 'UpdateCreditCardSettings', '/avactis-system/modules/configuration/actions/update-credit-card-settings-action.php', 'action', '1'),
(4, 'ClearInstanceAjax', '/avactis-system/modules/configuration/actions/clear-instance-ajax-action.php', 'action', '1'),
(4, 'UpdateCacheSettings', '/avactis-system/modules/configuration/actions/update-cache-settings-action.php', 'action', '1'),
(5, 'EventsManager', '/avactis-system/modules/eventsmanager/events_manager_api.php', 'api', '1'),
(6, 'BS_LinksList', '/avactis-system/modules/bestsellers_api/views/bs_links_list_az.php', 'view_az', '1'),
(6, 'Bestsellers', '/avactis-system/modules/bestsellers_api/views/bestsellers_cz.php', 'view_cz', '1'),
(6, 'Bestsellers_API', '/avactis-system/modules/bestsellers_api/bestsellers_api.php', 'api', '1'),
(6, 'save_bs_links_and_settings', '/avactis-system/modules/bestsellers_api/actions/save_bs_links_and_settings.php', 'action', '1'),
(7, 'CartThumbnail', '/avactis-system/modules/cart/views/cart_thumbnail.php', 'view_cz', '1'),
(7, 'ShoppingCart', '/avactis-system/modules/cart/views/cart_content.php', 'view_cz', '1'),
(7, 'UpdateCartContent', '/avactis-system/modules/cart/actions/updatequantityincart_action.php', 'action', '1'),
(7, 'ClearCart', '/avactis-system/modules/cart/actions/clearcart_action.php', 'action', '1'),
(7, 'RemoveProductFromCart', '/avactis-system/modules/cart/actions/removefromcart_action.php', 'action', '1'),
(7, 'AddToCart', '/avactis-system/modules/cart/actions/addtocart_action.php', 'action', '1'),
(7, 'Cart', '/avactis-system/modules/cart/cart_api.php', 'api', '1'),
(8, 'ProductSearchForm', '/avactis-system/modules/catalog/views/product_search_form_az.php', 'view_az', '1'),
(8, 'ProductGroupEdit', '/avactis-system/modules/catalog/views/product_group_edit_az.php', 'view_az', '1'),
(8, 'CategoryReview', '/avactis-system/modules/catalog/views/category_review_az.php', 'view_az', '1'),
(8, 'MngProductCats', '/avactis-system/modules/catalog/views/mng_product_cats_az.php', 'view_az', '1'),
(8, 'CategoryBookmarks', '/avactis-system/modules/catalog/views/category_bookmarks.php', 'view_az', '1'),
(8, 'ImportProductsView', '/avactis-system/modules/catalog/views/import_products_view_az.php', 'view_az', '1'),
(8, 'ExportProductsView', '/avactis-system/modules/catalog/views/export_products_view_az.php', 'view_az', '1'),
(8, 'ProductBookmarks', '/avactis-system/modules/catalog/views/product_bookmarks.php', 'view_az', '1'),
(8, 'SearchResult', '/avactis-system/modules/catalog/views/search_result_az.php', 'view_az', '1'),
(8, 'SearchFormShort', '/avactis-system/modules/catalog/views/search_form_short_az.php', 'view_az', '1'),
(8, 'SearchForm', '/avactis-system/modules/catalog/views/search_form_az.php', 'view_az', '1'),
(8, 'AttributeHelp', '/avactis-system/modules/catalog/views/attribute-help-az.php', 'view_az', '1'),
(8, 'EditCustomAttribute', '/avactis-system/modules/catalog/views/edit_custom_attribute_az.php', 'view_az', '1'),
(8, 'Breadcrumb', '/avactis-system/modules/catalog/views/breadcrumb-az.php', 'view_az', '1'),
(8, 'AddCustomAttribute', '/avactis-system/modules/catalog/views/add_custom_attribute_az.php', 'view_az', '1'),
(8, 'DeleteProductType', '/avactis-system/modules/catalog/views/delete_product_type_az.php', 'view_az', '1'),
(8, 'EditProductType', '/avactis-system/modules/catalog/views/edit_product_type_az.php', 'view_az', '1'),
(8, 'AddProductType', '/avactis-system/modules/catalog/views/add_product_type_az.php', 'view_az', '1'),
(8, 'ManageProductTypes', '/avactis-system/modules/catalog/views/manage_product_types_az.php', 'view_az', '1'),
(8, 'EditCategory', '/avactis-system/modules/catalog/views/edit_category_az.php', 'view_az', '1'),
(8, 'SortProducts', '/avactis-system/modules/catalog/views/sort_products_az.php', 'view_az', '1'),
(8, 'SortCategories', '/avactis-system/modules/catalog/views/sort_categories_az.php', 'view_az', '1'),
(8, 'ViewCategory', '/avactis-system/modules/catalog/views/view_category_az.php', 'view_az', '1'),
(8, 'DeleteProducts', '/avactis-system/modules/catalog/views/delete_products_az.php', 'view_az', '1'),
(8, 'DeleteCategory', '/avactis-system/modules/catalog/views/delete_category_az.php', 'view_az', '1'),
(8, 'CopyProducts', '/avactis-system/modules/catalog/views/copy_products_az.php', 'view_az', '1'),
(8, 'MoveProducts', '/avactis-system/modules/catalog/views/move_products_az.php', 'view_az', '1'),
(8, 'MoveCategory', '/avactis-system/modules/catalog/views/move_category_az.php', 'view_az', '1'),
(8, 'AddCategory', '/avactis-system/modules/catalog/views/add_category_az.php', 'view_az', '1'),
(8, 'EditProductInfo', '/avactis-system/modules/catalog/views/edit_product_info_az.php', 'view_az', '1'),
(8, 'AddProductInfo', '/avactis-system/modules/catalog/views/add_product_info_az.php', 'view_az', '1'),
(8, 'ProductInfo', '/avactis-system/modules/catalog/views/product_info_az.php', 'view_az', '1'),
(8, 'ProductList', '/avactis-system/modules/catalog/views/prodslist_az.php', 'view_az', '1'),
(8, 'ProductTypeFilter', '/avactis-system/modules/catalog/views/product_type_filter_cz.php', 'view_cz', '1'),
(8, 'NavigationBar', '/avactis-system/modules/catalog/views/navigation-bar-az.php', 'view_az', '1'),
(8, 'CustomerReviewsProductInfo', '/avactis-system/modules/catalog/views/cr_product_info_cz.php', 'view_cz', '1'),
(8, 'SearchResult', '/avactis-system/modules/catalog/views/search_result_cz.php', 'view_cz', '1'),
(8, 'ProductSet', '/avactis-system/modules/catalog/views/product_set_view.php', 'view_cz', '1'),
(8, 'SearchForm', '/avactis-system/modules/catalog/views/search_form_cz.php', 'view_cz', '1'),
(8, 'ProductListSorter', '/avactis-system/modules/catalog/views/product_list_sorter_cz.php', 'view_cz', '1'),
(8, 'ProductInfo', '/avactis-system/modules/catalog/views/product_info_cz.php', 'view_cz', '1'),
(8, 'Subcategories', '/avactis-system/modules/catalog/views/subcategories_cz.php', 'view_cz', '1'),
(8, 'Breadcrumb', '/avactis-system/modules/catalog/views/cat_breadcrumb_cz.php', 'view_cz', '1'),
(8, 'CategorySheet', '/avactis-system/modules/catalog/views/category_sheet_cz.php', 'view_cz', '1'),
(8, 'NavigationBarCustom', '/avactis-system/modules/catalog/views/navigation-bar-custom-cz.php', 'view_cz', '1'),
(8, 'ProductList', '/avactis-system/modules/catalog/views/prodslist_cz.php', 'view_cz', '1'),
(8, 'NavigationBar', '/avactis-system/modules/catalog/views/navigation-bar-cz.php', 'view_cz', '1'),
(8, 'SearchProducts', '/avactis-system/modules/catalog/actions/search_products_action.php', 'action', '1'),
(8, 'SetEditableProducts', '/avactis-system/modules/catalog/actions/set_editable_products_action.php', 'action', '1'),
(8, 'SetEditableCategory', '/avactis-system/modules/catalog/actions/set_editable_category_action.php', 'action', '1'),
(8, 'SetCurrentProductType', '/avactis-system/modules/catalog/actions/set_current_product_type_action.php', 'action', '1'),
(8, 'SetCurrentProduct', '/avactis-system/modules/catalog/actions/setcurrprod_action.php', 'action', '1'),
(8, 'SetMoveToCat', '/avactis-system/modules/catalog/actions/set_moveto_cat_action.php', 'action', '1'),
(8, 'SetProductListSortField', '/avactis-system/modules/catalog/actions/set_product_list_sort_field.php', 'action', '1'),
(8, 'SetCurrMnf', '/avactis-system/modules/catalog/actions/setcurrmnf_action.php', 'action', '1'),
(8, 'SetProductTypeFilter', '/avactis-system/modules/catalog/actions/set_product_type_filter_action.php', 'action', '1'),
(8, 'SetCurrCat', '/avactis-system/modules/catalog/actions/setcurrcat_action.php', 'action', '1'),
(8, 'SetSearchProductFormFilter', '/avactis-system/modules/catalog/actions/set_search_product_form_filter.php', 'action', '1'),
(8, 'SetProductGroup', '/avactis-system/modules/catalog/actions/set_product_group.php', 'action', '1'),
(8, 'save_ctg_tree', '/avactis-system/modules/catalog/actions/save_ctg_tree.php', 'action', '1'),
(8, 'UpdateProductGroup', '/avactis-system/modules/catalog/actions/update_product_group.php', 'action', '1'),
(8, 'get_ctg_review', '/avactis-system/modules/catalog/actions/get_ctg_review.php', 'action', '1'),
(8, 'do_products_import', '/avactis-system/modules/catalog/actions/do_products_import.php', 'action', '1'),
(8, 'do_products_export', '/avactis-system/modules/catalog/actions/do_products_export.php', 'action', '1'),
(8, 'update_product_cats', '/avactis-system/modules/catalog/actions/update_product_cats.php', 'action', '1'),
(8, 'ajax_get_plist', '/avactis-system/modules/catalog/actions/ajax_get_plist.php', 'action', '1'),
(8, 'UpdateCustomAttribute', '/avactis-system/modules/catalog/actions/update_custom_attribute_action.php', 'action', '1'),
(8, 'AddCustomAttributeAction', '/avactis-system/modules/catalog/actions/add_custom_attribute_action.php', 'action', '1'),
(8, 'UpdateProductTypeAction', '/avactis-system/modules/catalog/actions/update_product_type_action.php', 'action', '1'),
(8, 'AddProductTypeAction', '/avactis-system/modules/catalog/actions/add_product_type_action.php', 'action', '1'),
(8, 'ConfirmDeleteProductTypes', '/avactis-system/modules/catalog/actions/confirm_delete_product_types_action.php', 'action', '1'),
(8, 'ConfirmDeleteProducts', '/avactis-system/modules/catalog/actions/confirm_delete_products_action.php', 'action', '1'),
(8, 'ConfirmDeleteCategory', '/avactis-system/modules/catalog/actions/confirm_delete_category_action.php', 'action', '1'),
(8, 'AddProductInfoAction', '/avactis-system/modules/catalog/actions/add_product_info_action.php', 'action', '1'),
(8, 'UpdateProductInfo', '/avactis-system/modules/catalog/actions/update_product_info_action.php', 'action', '1'),
(8, 'UpdateCategoryInfo', '/avactis-system/modules/catalog/actions/update_category_info_action.php', 'action', '1'),
(8, 'SaveSortedProducts', '/avactis-system/modules/catalog/actions/save_sorted_products_action.php', 'action', '1'),
(8, 'SaveSortedCategories', '/avactis-system/modules/catalog/actions/save_sorted_categories_action.php', 'action', '1'),
(8, 'CopyToProducts', '/avactis-system/modules/catalog/actions/copy_products_action.php', 'action', '1'),
(8, 'MoveToProducts', '/avactis-system/modules/catalog/actions/move_products_action.php', 'action', '1'),
(8, 'MoveToCategory', '/avactis-system/modules/catalog/actions/move_category_action.php', 'action', '1'),
(8, 'AddCategoryInfo', '/avactis-system/modules/catalog/actions/add_category_info_action.php', 'action', '1'),
(8, 'Catalog', '/avactis-system/modules/catalog/catalog_api.php', 'api', '1'),
(9, 'Charts', '/avactis-system/modules/charts/charts_api.php', 'api', '1'),
(10, 'OrderPackingSlip', '/avactis-system/modules/checkout/views/checkout-order-packing-slip-az.php', 'view_az', '1'),
(10, 'CheckoutInfoSortGroup', '/avactis-system/modules/checkout/views/checkout-info-sort-group-az.php', 'view_az', '1'),
(10, 'OrderInvoice', '/avactis-system/modules/checkout/views/checkout-order-invoice-az.php', 'view_az', '1'),
(10, 'CheckoutInfoAttributeEdit', '/avactis-system/modules/checkout/views/checkout-info-attribute-edit-az.php', 'view_az', '1'),
(10, 'CheckoutInfoList', '/avactis-system/modules/checkout/views/checkout-info-list-az.php', 'view_az', '1'),
(10, 'CheckoutShippingModuleSettings', '/avactis-system/modules/checkout/views/checkout-shipping-module-settings-az.php', 'view_az', '1'),
(10, 'CheckoutShippingModuleFreeVersion', '/avactis-system/modules/checkout/views/checkout-shipping-module-free-version-az.php', 'view_az', '1'),
(10, 'CheckoutShippingModulesList', '/avactis-system/modules/checkout/views/checkout-shipping-modules-list-az.php', 'view_az', '1'),
(10, 'CheckoutPaymentModuleSettings', '/avactis-system/modules/checkout/views/checkout-payment-module-settings-az.php', 'view_az', '1'),
(10, 'CheckoutPaymentModuleFreeVersion', '/avactis-system/modules/checkout/views/checkout-payment-module-free-version-az.php', 'view_az', '1'),
(10, 'CheckoutPaymentModulesList', '/avactis-system/modules/checkout/views/checkout-payment-modules-list-az.php', 'view_az', '1'),
(10, 'CustomerInfo', '/avactis-system/modules/checkout/views/checkout-customer-info-az.php', 'view_az', '1'),
(10, 'ManageCustomers', '/avactis-system/modules/checkout/views/checkout-manage-customers-az.php', 'view_az', '1'),
(10, 'OrderInfo', '/avactis-system/modules/checkout/views/checkout-order-info-az.php', 'view_az', '1'),
(10, 'DeleteOrders', '/avactis-system/modules/checkout/views/checkout-delete-orders-az.php', 'view_az', '1'),
(10, 'ManageOrders', '/avactis-system/modules/checkout/views/checkout-manage-orders-az.php', 'view_az', '1'),
(10, 'OneStepCheckout', '/avactis-system/modules/checkout/views/one-step-checkout-cz.php', 'view_cz', '1'),
(10, 'LastPlacedOrder', '/avactis-system/modules/checkout/views/last-placed-order-cz.php', 'view_cz', '1'),
(10, 'CheckoutShippingMethodsSelect', '/avactis-system/modules/checkout/views/checkout-shipping-methods-select.php', 'view_cz', '1'),
(10, 'CheckoutShippingMethodsOutput', '/avactis-system/modules/checkout/views/checkout-shipping-methods-output.php', 'view_cz', '1'),
(10, 'CheckoutNavigationBar', '/avactis-system/modules/checkout/views/checkout-navigation-bar-cz.php', 'view_cz', '1'),
(10, 'CheckoutStepLink', '/avactis-system/modules/checkout/views/checkout-step-link-cz.php', 'view_cz', '1'),
(10, 'CheckoutOrder', '/avactis-system/modules/checkout/views/checkout-order-cz.php', 'view_cz', '1'),
(10, 'CheckoutBankAccountInfoOutput', '/avactis-system/modules/checkout/views/checkout-bank-account-info-output-cz.php', 'view_cz', '1'),
(10, 'CheckoutBankAccountInfoInput', '/avactis-system/modules/checkout/views/checkout-bank-account-info-input-cz.php', 'view_cz', '1'),
(10, 'CheckoutCreditCardInfoOutput', '/avactis-system/modules/checkout/views/checkout-credit-card-info-output-cz.php', 'view_cz', '1'),
(10, 'CheckoutCreditCardInfoInput', '/avactis-system/modules/checkout/views/checkout-credit-card-info-input-cz.php', 'view_cz', '1'),
(10, 'CheckoutBillingInfoOutput', '/avactis-system/modules/checkout/views/checkout-billing-info-output-cz.php', 'view_cz', '1'),
(10, 'CheckoutBillingInfoInput', '/avactis-system/modules/checkout/views/checkout-billing-info-input-cz.php', 'view_cz', '1'),
(10, 'CheckoutShippingInfoOutput', '/avactis-system/modules/checkout/views/checkout-shipping-info-output-cz.php', 'view_cz', '1'),
(10, 'CheckoutShippingInfoInput', '/avactis-system/modules/checkout/views/checkout-shipping-info-input-cz.php', 'view_cz', '1'),
(10, 'CheckoutCustomerInfoOutput', '/avactis-system/modules/checkout/views/checkout-customer-info-output-cz.php', 'view_cz', '1'),
(10, 'CheckoutCustomerInfoInput', '/avactis-system/modules/checkout/views/checkout-customer-info-input-cz.php', 'view_cz', '1'),
(10, 'JSSetCurrStep', '/avactis-system/modules/checkout/actions/js-set-curr-step-action.php', 'action', '1'),
(10, 'CheckoutView', '/avactis-system/modules/checkout/views/checkout-view-cz.php', 'view_cz', '1'),
(10, 'SetCurrentCustomer', '/avactis-system/modules/checkout/actions/set-current-customer-action.php', 'action', '1'),
(10, 'UpdatePaymentStatus', '/avactis-system/modules/checkout/actions/update-payment-status-action.php', 'action', '1'),
(10, 'SetCurrentOrder', '/avactis-system/modules/checkout/actions/set-current-order-action.php', 'action', '1'),
(10, 'ConfirmOrder', '/avactis-system/modules/checkout/actions/confirm-order-action.php', 'action', '1'),
(10, 'RemoveCustomField_action', '/avactis-system/modules/checkout/actions/remove-custom-field-action.php', 'action', '1'),
(10, 'SetCurrStep', '/avactis-system/modules/checkout/actions/set-curr-step-action.php', 'action', '1'),
(10, 'EditCustomField_action', '/avactis-system/modules/checkout/actions/edit-custom-field-action.php', 'action', '1'),
(10, 'AddCustomField_action', '/avactis-system/modules/checkout/actions/add-custom-field-action.php', 'action', '1'),
(10, 'FlipPersonInfoTypeStatus', '/avactis-system/modules/checkout/actions/flip_person_info_type_status-action.php', 'action', '1'),
(10, 'RemovePersonInfoOrderData', '/avactis-system/modules/checkout/actions/remove-person-info-order-data-action.php', 'action', '1'),
(10, 'SaveSortedAttributes', '/avactis-system/modules/checkout/actions/save-sorted-attributes-checkout-info.php', 'action', '1'),
(10, 'UpdateCheckoutInfo', '/avactis-system/modules/checkout/actions/update-checkout-info.php', 'action', '1'),
(10, 'SetCurrentShippingModuleSettingsViewName', '/avactis-system/modules/checkout/actions/set-curr-shipping-module-settings-view-name.php', 'action', '1'),
(10, 'SaveSelectedShippingModulesList', '/avactis-system/modules/checkout/actions/save-selected-shipping-modules-list-action.php', 'action', '1'),
(10, 'SetCurrentPaymentModuleSettingsViewName', '/avactis-system/modules/checkout/actions/set-curr-payment-module-settings-view-name.php', 'action', '1'),
(10, 'SaveSelectedPaymentModulesList', '/avactis-system/modules/checkout/actions/save-selected-payment-modules-list-action.php', 'action', '1'),
(10, 'DeleteOrdersAction', '/avactis-system/modules/checkout/actions/delete-orders-action.php', 'action', '1'),
(10, 'SetOrdersForDeleteAction', '/avactis-system/modules/checkout/actions/set-orders-for-delete-action.php', 'action', '1'),
(10, 'UpdateOrderAction', '/avactis-system/modules/checkout/actions/update-order-action.php', 'action', '1'),
(10, 'CustomersSearchByField', '/avactis-system/modules/checkout/actions/search-by-field-action.php', 'action', '1'),
(10, 'CustomersSearchByLetter', '/avactis-system/modules/checkout/actions/search-by-letter-action.php', 'action', '1'),
(10, 'OrdersSearchById', '/avactis-system/modules/checkout/actions/search-by-id-action.php', 'action', '1'),
(10, 'OrdersSearchByDate', '/avactis-system/modules/checkout/actions/search-by-date-action.php', 'action', '1'),
(10, 'OrdersSearchByStatus', '/avactis-system/modules/checkout/actions/search-by-status-action.php', 'action', '1'),
(10, 'Checkout', '/avactis-system/modules/checkout/checkout_api.php', 'api', '1'),
(11, 'CMS_Nav_Menu', '/avactis-system/modules/cms/views/cms_nav_menu_az.php', 'view_az', '1'),
(11, 'CMS_Menu_Data', '/avactis-system/modules/cms/views/cms_menu_data_az.php', 'view_az', '1'),
(11, 'CMS_Menu', '/avactis-system/modules/cms/views/cms_menu_az.php', 'view_az', '1'),
(11, 'CMS_Page_Data', '/avactis-system/modules/cms/views/cms_page_data_az.php', 'view_az', '1'),
(11, 'CMS_Pages', '/avactis-system/modules/cms/views/cms_pages_az.php', 'view_az', '1'),
(11, 'CMSMenu', '/avactis-system/modules/cms/views/cms_menu_cz.php', 'view_cz', '1'),
(11, 'PageView', '/avactis-system/modules/cms/views/pageview_cz.php', 'view_cz', '1'),
(11, 'CMSPage', '/avactis-system/modules/cms/views/cms_page_cz.php', 'view_cz', '1'),
(11, 'CMSPageTree', '/avactis-system/modules/cms/views/cms_page_tree_cz.php', 'view_cz', '1'),
(11, 'update_nav_menu_data', '/avactis-system/modules/cms/actions/update_nav_menu_data.php', 'action', '1'),
(11, 'SearchNavMenu', '/avactis-system/modules/cms/actions/search_nav_menu.php', 'action', '1'),
(11, 'update_menu', '/avactis-system/modules/cms/actions/update_menu.php', 'action', '1'),
(11, 'update_nav_menu_location', '/avactis-system/modules/cms/actions/update_nav_menu_location.php', 'action', '1'),
(11, 'update_menu_data', '/avactis-system/modules/cms/actions/update_menu_data.php', 'action', '1'),
(11, 'update_pages', '/avactis-system/modules/cms/actions/update_pages.php', 'action', '1'),
(11, 'update_page_data', '/avactis-system/modules/cms/actions/update_page_data.php', 'action', '1'),
(11, 'CMS', '/avactis-system/modules/cms/cms_api.php', 'api', '1'),
(12, 'PI_ColorSwatch', '/avactis-system/modules/color_swatch/views/product_color_swatch_az.php', 'view_az', '1'),
(12, 'ColorSwatchImages', '/avactis-system/modules/color_swatch/views/product_color_swatch_cz.php', 'view_cz', '1'),
(12, 'update_number_label_action', '/avactis-system/modules/color_swatch/actions/update_number_label_action.php', 'action', '1'),
(12, 'update_values_of_color_swatch_action', '/avactis-system/modules/color_swatch/actions/update_values_of_color_swatch_action.php', 'action', '1'),
(12, 'del_values_of_color_swatch_action', '/avactis-system/modules/color_swatch/actions/del_values_of_color_swatch_action.php', 'action', '1'),
(12, 'add_color_swatch_image_action', '/avactis-system/modules/color_swatch/actions/add_color_swatch_image_action.php', 'action', '1'),
(12, 'ColorSwatch', '/avactis-system/modules/color_swatch/color_swatch_api.php', 'api', '1'),
(4, 'SettingParamList', '/avactis-system/modules/configuration/views/settings_params_az.php', 'view_az', '1'),
(4, 'UpdateStoreOwnerProfile', '/avactis-system/modules/configuration/actions/update-store-owner-profile-action.php', 'action', '1'),
(4, 'UpdateGeneralSettings', '/avactis-system/modules/configuration/actions/update-general-settings-action.php', 'action', '1'),
(4, 'Configuration', '/avactis-system/modules/configuration/configuration_api.php', 'api', '1'),
(13, 'Crypto', '/avactis-system/modules/crypto/crypto_api.php', 'api', '1'),
(13, 'DecryptRsaBlowfishJavascript', '/avactis-system/modules/crypto/actions/decrypt-rsa-blowfish-javascript-action.php', 'action', '1'),
(13, 'resend_data_as_text_file', '/avactis-system/modules/crypto/actions/resend_data_as_text_file-action.php', 'action', '1'),
(14, 'CurrencyRateEditor', '/avactis-system/modules/currency_converter/views/currency_rate_editor.php', 'view_az', '1'),
(14, 'del_ccrates', '/avactis-system/modules/currency_converter/actions/del_ccrates.php', 'action', '1'),
(14, 'add_ccrate', '/avactis-system/modules/currency_converter/actions/add_ccrate.php', 'action', '1'),
(14, 'Currency_Converter', '/avactis-system/modules/currency_converter/currency_converter_api.php', 'api', '1'),
(15, 'CustomerAccountInfo', '/avactis-system/modules/customer_account/views/customer_account_info_az.php', 'view_az', '1'),
(15, 'CustomersList', '/avactis-system/modules/customer_account/views/customers_list_az.php', 'view_az', '1'),
(15, 'CustomerHomePage', '/avactis-system/modules/customer_account/views/customer_home_page.php', 'view_cz', '1'),
(15, 'RegisterFormEditor', '/avactis-system/modules/customer_account/views/register_form_editor_az.php', 'view_az', '1'),
(15, 'OrderList', '/avactis-system/modules/customer_account/views/customer_order_list_cz.php', 'view_cz', '1'),
(15, 'OrderSearchByIdForm', '/avactis-system/modules/customer_account/views/customer_order_search_by_id_form_cz.php', 'view_cz', '1'),
(15, 'OrderSearchForm', '/avactis-system/modules/customer_account/views/customer_order_search_form_cz.php', 'view_cz', '1'),
(15, 'CustomerForgotPasswordForm', '/avactis-system/modules/customer_account/views/customer_forgot_password_form_cz.php', 'view_cz', '1'),
(15, 'CustomerChangePasswordForm', '/avactis-system/modules/customer_account/views/customer_change_password_form_cz.php', 'view_cz', '1'),
(15, 'OrderDownloadLinks', '/avactis-system/modules/customer_account/views/customer_order_download_links_cz.php', 'view_cz', '1'),
(15, 'CustomerNewPasswordForm', '/avactis-system/modules/customer_account/views/customer_new_password_form_cz.php', 'view_cz', '1'),
(15, 'OrderInvoice', '/avactis-system/modules/customer_account/views/customer_order_invoice_cz.php', 'view_cz', '1'),
(15, 'OrderInfo', '/avactis-system/modules/customer_account/views/customer_order_info_cz.php', 'view_cz', '1'),
(15, 'OrderHistory', '/avactis-system/modules/customer_account/views/customer_orders_history_cz.php', 'view_cz', '1'),
(15, 'CustomerPersonalInfo', '/avactis-system/modules/customer_account/views/customer_personal_info_cz.php', 'view_cz', '1'),
(15, 'CustomerRegistrationForm', '/avactis-system/modules/customer_account/views/reg_form_cz.php', 'view_cz', '1'),
(15, 'MessageBox', '/avactis-system/modules/customer_account/views/reg_msg_cz.php', 'view_cz', '1'),
(15, 'CustomerSignInBox', '/avactis-system/modules/customer_account/views/auth_box_cz.php', 'view_cz', '1'),
(15, 'drop_account_password', '/avactis-system/modules/customer_account/actions/drop_account_password.php', 'action', '1'),
(15, 'change_account_password', '/avactis-system/modules/customer_account/actions/change_account_password.php', 'action', '1'),
(15, 'save_account_password', '/avactis-system/modules/customer_account/actions/save_account_password.php', 'action', '1'),
(15, 'save_personal_info', '/avactis-system/modules/customer_account/actions/save_personal_info.php', 'action', '1'),
(15, 'customer_sign_out', '/avactis-system/modules/customer_account/actions/customer_sign_out.php', 'action', '1'),
(15, 'customer_sign_in', '/avactis-system/modules/customer_account/actions/customer_sign_in.php', 'action', '1'),
(15, 'register_customer', '/avactis-system/modules/customer_account/actions/register_customer.php', 'action', '1'),
(15, 'activate_account', '/avactis-system/modules/customer_account/actions/activate_account.php', 'action', '1'),
(15, 'delete_customer_groups', '/avactis-system/modules/customer_account/actions/delete_customer_groups.php', 'action', '1'),
(15, 'add_customer_group', '/avactis-system/modules/customer_account/actions/add_customer_group.php', 'action', '1'),
(15, 'update_group_sort_order', '/avactis-system/modules/customer_account/actions/update_group_sort_order.php', 'action', '1'),
(15, 'update_customers_accounts', '/avactis-system/modules/customer_account/actions/update_customers_accounts.php', 'action', '1'),
(15, 'drop_accounts_passwords', '/avactis-system/modules/customer_account/actions/drop_accounts_passwords.php', 'action', '1'),
(15, 'update_reg_form', '/avactis-system/modules/customer_account/actions/update_reg_form.php', 'action', '1'),
(15, 'activate_customers_accounts', '/avactis-system/modules/customer_account/actions/activate_customers_accounts.php', 'action', '1'),
(15, 'delete_customers_accounts', '/avactis-system/modules/customer_account/actions/delete_customers_accounts.php', 'action', '1'),
(15, 'do_customers_export', '/avactis-system/modules/customer_account/actions/do_customers_export.php', 'action', '1'),
(15, 'Customer_Account', '/avactis-system/modules/customer_account/customer_account_api.php', 'api', '1'),
(16, 'CR_Select_Product', '/avactis-system/modules/customer_reviews/views/cr_select_product_az.php', 'view_az', '1'),
(16, 'CR_Review_Data', '/avactis-system/modules/customer_reviews/views/cr_review_data_az.php', 'view_az', '1'),
(16, 'ManageCustomerReviews', '/avactis-system/modules/customer_reviews/views/cr_manage_customer_reviews_az.php', 'view_az', '1'),
(16, 'CR_Rates_Settings', '/avactis-system/modules/customer_reviews/views/cr_rates_settings_az.php', 'view_az', '1'),
(16, 'ProductAddReviewForm', '/avactis-system/modules/customer_reviews/views/cr_product_add_review_form_cz.php', 'view_cz', '1'),
(16, 'ProductAddReviewLink', '/avactis-system/modules/customer_reviews/views/cr_product_add_review_link_cz.php', 'view_cz', '1'),
(16, 'ProductReviewList', '/avactis-system/modules/customer_reviews/views/cr_product_review_list_cz.php', 'view_cz', '1'),
(16, 'ProductDetailedRating', '/avactis-system/modules/customer_reviews/views/cr_product_detailed_rating_cz.php', 'view_cz', '1'),
(16, 'update_review_data', '/avactis-system/modules/customer_reviews/actions/update_review_data.php', 'action', '1'),
(16, 'ProductRating', '/avactis-system/modules/customer_reviews/views/cr_product_rating_cz.php', 'view_cz', '1'),
(16, 'update_customer_reviews', '/avactis-system/modules/customer_reviews/actions/update_customer_reviews.php', 'action', '1'),
(16, 'update_cr_rates_settings', '/avactis-system/modules/customer_reviews/actions/update_cr_rates_settings.php', 'action', '1'),
(16, 'Customer_Reviews', '/avactis-system/modules/customer_reviews/customer_reviews_api.php', 'api', '1'),
(17, 'Data_Converter', '/avactis-system/modules/data_converter/data_converter_api.php', 'api', '1'),
(18, 'Discounts', '/avactis-system/modules/discounts/discounts_api.php', 'api', '1'),
(18, 'update_global_discounts', '/avactis-system/modules/discounts/actions/update_global_discounts_action.php', 'action', '1'),
(18, 'discounts_manage_global_discounts_az', '/avactis-system/modules/discounts/views/discounts_manage_global_discounts_az.php', 'view_az', '1'),
(19, 'SetupWarnings', '/avactis-system/modules/error/views/setup_warnings.php', 'view_az', '1'),
(19, 'C_Error', '/avactis-system/modules/error/views/c_error.php', 'view_cz', '1'),
(19, 'Error', '/avactis-system/modules/error/error.php', 'api', '1'),
(19, 'A_Error', '/avactis-system/modules/error/views/a_error.php', 'view_cz', '1'),
(20, 'Error_Document_Setting', '/avactis-system/modules/error_document/views/error-document-setting-az.php', 'view_az', '1'),
(20, 'Error_Document', '/avactis-system/modules/error_document/error_document_api.php', 'api', '1'),
(20, 'UpdateErrDocStatus', '/avactis-system/modules/error_document/actions/update_err_doc_status_action.php', 'action', '1'),
(21, 'EventStack', '/avactis-system/modules/eventstack/event_stack_api.php', 'api', '1'),
(22, 'ExtensionDetails', '/avactis-system/modules/extension_manager/views/extension_details_az.php', 'view_az', '1'),
(22, 'ExtensionManager_Manage', '/avactis-system/modules/extension_manager/views/extension_manage_az.php', 'view_az', '1'),
(22, 'NotifyCoreUpgrade', '/avactis-system/modules/extension_manager/views/notify_core_upgrade.php', 'view_az', '1'),
(22, 'ExtensionManager_ListView', '/avactis-system/modules/extension_manager/views/extension_list_az.php', 'view_az', '1'),
(22, 'GetCoreUpgradeFile', '/avactis-system/modules/extension_manager/actions/get_core_upgrade_file.php', 'action', '1'),
(22, 'GetMarketPlaceExtension', '/avactis-system/modules/extension_manager/actions/get_marketplace_extension.php', 'action', '1'),
(22, 'ActivateDeactivateExtension', '/avactis-system/modules/extension_manager/actions/active_deactive_extension.php', 'action', '1'),
(22, 'UninstallExtensionAction', '/avactis-system/modules/extension_manager/actions/uninstall_extension.php', 'action', '1'),
(22, 'Extension_Manager', '/avactis-system/modules/extension_manager/extension_manager_api.php', 'api', '1'),
(23, 'FeaturedProducts', '/avactis-system/modules/featured_products/views/featured_products_cz.php', 'view_cz', '1'),
(23, 'FP_LinksList', '/avactis-system/modules/featured_products/views/fp_links_list_az.php', 'view_az', '1'),
(23, 'Featured_Products', '/avactis-system/modules/featured_products/featured_products_api.php', 'api', '1'),
(23, 'save_fp_links', '/avactis-system/modules/featured_products/actions/save_fp_links.php', 'action', '1'),
(24, 'Froogle_Export', '/avactis-system/modules/froogle/views/froogle_export_az.php', 'view_az', '1'),
(24, 'Froogle', '/avactis-system/modules/froogle/froogle_api.php', 'api', '1'),
(24, 'do_froogle_export', '/avactis-system/modules/froogle/actions/do_froogle_export.php', 'action', '1'),
(25, 'GiftCertificateAddView', '/avactis-system/modules/gift_certificate/views/gc_add_az.php', 'view_az', '1'),
(25, 'GiftCertificateEditView', '/avactis-system/modules/gift_certificate/views/gc_edit_az.php', 'view_az', '1'),
(25, 'CreateGiftCertificateForm', '/avactis-system/modules/gift_certificate/views/gc_create_cz.php', 'view_cz', '1'),
(25, 'GiftCertificateListView', '/avactis-system/modules/gift_certificate/views/gc_list_az.php', 'view_az', '1'),
(25, 'GiftCertificateForm', '/avactis-system/modules/gift_certificate/views/gc_add_cz.php', 'view_cz', '1'),
(25, 'RemoveGiftCertificateAction', '/avactis-system/modules/gift_certificate/actions/RemoveGiftCertificateAction.php', 'action', '1'),
(25, 'AddGCToCart', '/avactis-system/modules/gift_certificate/actions/AddGCToCart.php', 'action', '1'),
(25, 'GiftCertificateDellAction', '/avactis-system/modules/gift_certificate/actions/GiftCertificateDellAction.php', 'action', '1'),
(25, 'AddGiftCertificateAction', '/avactis-system/modules/gift_certificate/actions/AddGiftCertificateAction.php', 'action', '1'),
(25, 'GiftCertificateAddAction', '/avactis-system/modules/gift_certificate/actions/GiftCertificateAddAction.php', 'action', '1'),
(25, 'GiftCertificateUpdateAction', '/avactis-system/modules/gift_certificate/actions/GiftCertificateUpdateAction.php', 'action', '1'),
(25, 'GiftCertificateApi', '/avactis-system/modules/gift_certificate/gift_certificate_api.php', 'api', '1'),
(26, 'ShowHint', '/avactis-system/modules/hint/views/show_hint.php', 'view_az', '1'),
(26, 'SetHintContent', '/avactis-system/modules/hint/actions/set_hint_content.php', 'action', '1'),
(26, 'Hint', '/avactis-system/modules/hint/hint_api.php', 'api', '1'),
(27, 'HTTPSSettings', '/avactis-system/modules/https/views/https_settings_az.php', 'view_az', '1'),
(27, 'HTTPS', '/avactis-system/modules/https/https_api.php', 'api', '1'),
(27, 'UpdateHTTPSSettings', '/avactis-system/modules/https/actions/update_https_settings_action.php', 'action', '1'),
(28, 'image_output_az', '/avactis-system/modules/images/views/image_output_az.php', 'view_az', '1'),
(28, 'image_input_az', '/avactis-system/modules/images/views/image_input_az.php', 'view_az', '1'),
(28, 'image_output_cz', '/avactis-system/modules/images/views/image_output_cz.php', 'view_cz', '1'),
(28, 'images_update_alt_text', '/avactis-system/modules/images/actions/images_update_alt_text_action.php', 'action', '1'),
(28, 'images_upload_url', '/avactis-system/modules/images/actions/images_upload_url_action.php', 'action', '1'),
(28, 'images_upload_server_file', '/avactis-system/modules/images/actions/images_upload_server_file_action.php', 'action', '1'),
(28, 'images_upload_local_file', '/avactis-system/modules/images/actions/images_upload_local_file_action.php', 'action', '1'),
(28, 'images_delete_image', '/avactis-system/modules/images/actions/images_delete_image_action.php', 'action', '1'),
(28, 'Images', '/avactis-system/modules/images/images_api.php', 'api', '1'),
(29, 'LayoutCMS', '/avactis-system/modules/layout_cms/views/layout_cms_az.php', 'view_az', '1'),
(29, 'get_available_blocks', '/avactis-system/modules/layout_cms/actions/get_available_blocks_az.php', 'action', '1'),
(29, 'save_layout_tmpl', '/avactis-system/modules/layout_cms/actions/save_layout_tmpl_az.php', 'action', '1'),
(29, 'get_layout_tmpl', '/avactis-system/modules/layout_cms/actions/get_layout_tmpl_az.php', 'action', '1'),
(29, 'add_new_page', '/avactis-system/modules/layout_cms/actions/add_new_page_az.php', 'action', '1'),
(29, 'delete_page', '/avactis-system/modules/layout_cms/actions/delete_page_az.php', 'action', '1'),
(29, 'Layout_CMS', '/avactis-system/modules/layout_cms/layout_cms_api.php', 'api', '1'),
(30, 'LicenseMention', '/avactis-system/modules/license/views/license_mention_az.php', 'view_az', '1'),
(30, 'LicenseInfo', '/avactis-system/modules/license/views/license_info_az.php', 'view_az', '1'),
(30, 'RegisterStore', '/avactis-system/modules/license/actions/register_store_action.php', 'action', '1'),
(30, 'UpdateStoreRegistration', '/avactis-system/modules/license/actions/update_store_registration_action.php', 'action', '1'),
(30, 'UpdateLicenseKey', '/avactis-system/modules/license/actions/update_license_key_action.php', 'action', '1'),
(30, 'License', '/avactis-system/modules/license/license_api.php', 'api', '1'),
(31, 'WeightSettings', '/avactis-system/modules/localization/views/weight_settings_az.php', 'view_az', '1'),
(31, 'NumberSettings', '/avactis-system/modules/localization/views/number_settings_az.php', 'view_az', '1'),
(31, 'DateTimeSettings', '/avactis-system/modules/localization/views/date_settings_az.php', 'view_az', '1'),
(31, 'AcceptedCurrencies', '/avactis-system/modules/localization/views/accepted_currencies_az.php', 'view_az', '1'),
(31, 'CurrencySettings', '/avactis-system/modules/localization/views/currency_settings_az.php', 'view_az', '1'),
(31, 'CurrencySelector', '/avactis-system/modules/localization/views/currency_selector_cz.php', 'view_cz', '1'),
(31, 'UpdateWeightUnit', '/avactis-system/modules/localization/actions/update_weight_unit_action.php', 'action', '1'),
(31, 'SetDisplayCurrency', '/avactis-system/modules/localization/actions/set_display_currency_action.php', 'action', '1'),
(31, 'UpdateAcceptedCurrencies', '/avactis-system/modules/localization/actions/update_accepted_currencies_action.php', 'action', '1'),
(31, 'UpdateCurrencyFormat', '/avactis-system/modules/localization/actions/update_currency_format_action.php', 'action', '1'),
(31, 'UpdateNumberFormat', '/avactis-system/modules/localization/actions/update_number_format_action.php', 'action', '1'),
(31, 'UpdateDateTimeFormat', '/avactis-system/modules/localization/actions/update_date_time_format_action.php', 'action', '1'),
(31, 'Localization', '/avactis-system/modules/localization/localization_api.php', 'api', '1'),
(32, 'StatesSettings', '/avactis-system/modules/location/views/states_settings_az.php', 'view_az', '1'),
(32, 'CountriesSettings', '/avactis-system/modules/location/views/countries_settings_az.php', 'view_az', '1'),
(32, 'UpdateStates', '/avactis-system/modules/location/actions/update_states_action.php', 'action', '1'),
(32, 'Location', '/avactis-system/modules/location/location_api.php', 'api', '1'),
(32, 'UpdateCountries', '/avactis-system/modules/location/actions/update_countries_action.php', 'action', '1'),
(33, 'SkinList', '/avactis-system/modules/look_feel/views/skin_list_az.php', 'view_az', '1'),
(33, 'CustomSkinList', '/avactis-system/modules/look_feel/views/custom_skin_list_cz.php', 'view_cz', '1'),
(33, 'Update_Skin_Settings', '/avactis-system/modules/look_feel/actions/update_skin_settings_az.php', 'action', '1'),
(33, 'Edit_Skin', '/avactis-system/modules/look_feel/actions/edit_skin_az.php', 'action', '1'),
(33, 'Change_Skin', '/avactis-system/modules/look_feel/actions/change_skin_az.php', 'action', '1'),
(33, 'Look_Feel', '/avactis-system/modules/look_feel/look_feel_api.php', 'api', '1'),
(34, 'SortManufacturers', '/avactis-system/modules/manufacturers/views/sort_manufacturers_az.php', 'view_az', '1'),
(34, 'EditManufacturer', '/avactis-system/modules/manufacturers/views/edit_manufacturer_az.php', 'view_az', '1'),
(34, 'AddManufacturer', '/avactis-system/modules/manufacturers/views/add_manufacturer_az.php', 'view_az', '1'),
(34, 'ManufacturerInfo', '/avactis-system/modules/manufacturers/views/manufacturer_info_cz.php', 'view_cz', '1'),
(34, 'ManufacturersList', '/avactis-system/modules/manufacturers/views/manufacturers_list_az.php', 'view_az', '1'),
(34, 'ManufacturersFilter', '/avactis-system/modules/manufacturers/views/manufacturers_filter_cz.php', 'view_cz', '1'),
(34, 'update_manufacturers_sort_order', '/avactis-system/modules/manufacturers/actions/update_manufacturers_sort_order.php', 'action', '1'),
(34, 'set_editable_manufacturer', '/avactis-system/modules/manufacturers/actions/set_editable_manufacturer_action.php', 'action', '1'),
(34, 'SaveSortedManufacturers', '/avactis-system/modules/manufacturers/actions/save_sorted_manufacturers_action.php', 'action', '1'),
(34, 'del_manufacturers', '/avactis-system/modules/manufacturers/actions/del_manufacturers.php', 'action', '1'),
(34, 'update_manufacturer', '/avactis-system/modules/manufacturers/actions/update_manufacturer.php', 'action', '1'),
(34, 'add_manufacturer', '/avactis-system/modules/manufacturers/actions/add_manufacturer.php', 'action', '1'),
(34, 'Manufacturers', '/avactis-system/modules/manufacturers/manufacturers_api.php', 'api', '1'),
(35, 'MenuManager', '/avactis-system/modules/menu_manager/menu_api.php', 'api', '1'),
(35, 'AdminMenuManager', '/avactis-system/modules/menu_manager/views/admin_menu_az.php', 'view_az', '1'),
(36, 'MR_Settings', '/avactis-system/modules/mod_rewrite/views/mr_settings_az.php', 'view_az', '1'),
(36, 'update_mr_settings_and_layouts', '/avactis-system/modules/mod_rewrite/actions/update_mr_settings_and_layouts.php', 'action', '1'),
(36, 'update_mr_for_layout', '/avactis-system/modules/mod_rewrite/actions/update_mr_for_layout.php', 'action', '1'),
(36, 'gen_save_htaccess', '/avactis-system/modules/mod_rewrite/actions/gen_save_htaccess.php', 'action', '1'),
(36, 'ajax_gen_htaccess', '/avactis-system/modules/mod_rewrite/actions/ajax_gen_htaccess.php', 'action', '1'),
(36, 'update_mr_settings', '/avactis-system/modules/mod_rewrite/actions/update_mr_settings.php', 'action', '1'),
(36, 'Mod_Rewrite', '/avactis-system/modules/mod_rewrite/mod_rewrite_api.php', 'api', '1'),
(1, 'Modules_Manager', '/avactis-system/modules/modules_manager/mm_api.php', 'api', '1'),
(3, 'ML_ImportLabels', '/avactis-system/modules/multilang/views/ml_import_labels_az.php', 'view_az', '1'),
(3, 'UpdateLanguages', '/avactis-system/modules/multilang/actions/update_languages_az.php', 'action', '1'),
(3, 'MultiLang', '/avactis-system/modules/multilang/multilang_api.php', 'api', '1'),
(37, 'AvactisHomeNews', '/avactis-system/modules/news/views/avactis_home_news_az.php', 'view_az', '1'),
(37, 'NewsSettings', '/avactis-system/modules/news/views/news_settings_az.php', 'view_az', '1'),
(37, 'UpdateNewsSettings', '/avactis-system/modules/news/actions/update_news_settings_action.php', 'action', '1'),
(37, 'News', '/avactis-system/modules/news/news_api.php', 'api', '1'),
(38, 'Newsletter_Send', '/avactis-system/modules/newsletter/views/newsletter_send_az.php', 'view_az', '1'),
(38, 'Newsletter_List', '/avactis-system/modules/newsletter/views/newsletter_list_az.php', 'view_az', '1'),
(38, 'Newsletter_Compose', '/avactis-system/modules/newsletter/views/newsletter_compose_az.php', 'view_az', '1'),
(38, 'do_newsletter_send', '/avactis-system/modules/newsletter/actions/do_newsletter_send.php', 'action', '1'),
(38, 'do_newsletter_delete', '/avactis-system/modules/newsletter/actions/do_newsletter_delete.php', 'action', '1'),
(38, 'do_newsletter_save', '/avactis-system/modules/newsletter/actions/do_newsletter_save.php', 'action', '1'),
(38, 'Newsletter', '/avactis-system/modules/newsletter/newsletter_api.php', 'api', '1'),
(39, 'NotificationsList', '/avactis-system/modules/notifications/views/notifications_az.php', 'view_az', '1'),
(39, 'MailInfo', '/avactis-system/modules/notifications/views/mail_info_az.php', 'view_az', '1'),
(39, 'SetCurrentNotification', '/avactis-system/modules/notifications/actions/set_current_notification_action.php', 'action', '1'),
(39, 'IncludeTemplate', '/avactis-system/modules/notifications/actions/include_template_action.php', 'action', '1'),
(39, 'SaveNotification', '/avactis-system/modules/notifications/actions/save_notification_action.php', 'action', '1'),
(39, 'AddNotification', '/avactis-system/modules/notifications/actions/add_notification_action.php', 'action', '1'),
(39, 'DeleteNotification', '/avactis-system/modules/notifications/actions/delete_notification_action.php', 'action', '1'),
(39, 'Notifications', '/avactis-system/modules/notifications/notifications_api.php', 'api', '1'),
(40, 'OrdersExportCSVView', '/avactis-system/modules/ordersexportcsv/views/orders_export_csv_az.php', 'view_az', '1'),
(40, 'DoOrdersExportCSVAction', '/avactis-system/modules/ordersexportcsv/actions/do_orders_export_csv.php', 'action', '1'),
(40, 'OrdersExportCSV', '/avactis-system/modules/ordersexportcsv/orders_export_csv_api.php', 'api', '1'),
(41, 'PaginatorRows', '/avactis-system/modules/paginator/views/paginator_rows_per_page_az.php', 'view_az', '1'),
(41, 'PaginatorLine', '/avactis-system/modules/paginator/views/paginator_line_az.php', 'view_az', '1'),
(41, 'PaginatorDropdown', '/avactis-system/modules/paginator/views/paginator_rows_per_page.php', 'view_cz', '1'),
(41, 'PaginatorLine', '/avactis-system/modules/paginator/views/paginator_line.php', 'view_cz', '1'),
(41, 'Paginator_SetPage', '/avactis-system/modules/paginator/actions/paginator_setpage.php', 'action', '1'),
(41, 'Paginator_SetRowsPerPage', '/avactis-system/modules/paginator/actions/paginator_setrowsperpage.php', 'action', '1'),
(41, 'Paginator', '/avactis-system/modules/paginator/paginator_api.php', 'api', '1'),
(42, 'CheckoutPaymentModuleAllInactiveOutput', '/avactis-system/modules/payment_module_all_inactive/views/all_inactive_output_cz.php', 'view_cz', '1'),
(42, 'CheckoutPaymentModuleAllInactiveInput', '/avactis-system/modules/payment_module_all_inactive/views/all_inactive_input_cz.php', 'view_cz', '1'),
(42, 'Payment_Module_All_Inactive', '/avactis-system/modules/payment_module_all_inactive/payment_module_all_inactive_api.php', 'api', '1'),
(43, 'CheckoutPaymentModuleCodInputAZ', '/avactis-system/modules/payment_module_cod/views/cod_input_az.php', 'view_az', '1'),
(43, 'CheckoutPaymentModuleCodOutput', '/avactis-system/modules/payment_module_cod/views/cod_output_cz.php', 'view_cz', '1'),
(43, 'CheckoutPaymentModuleCodInput', '/avactis-system/modules/payment_module_cod/views/cod_input_cz.php', 'view_cz', '1'),
(43, 'Payment_Module_Cod', '/avactis-system/modules/payment_module_cod/payment_module_cod_api.php', 'api', '1'),
(43, 'update_cod', '/avactis-system/modules/payment_module_cod/actions/update_cod.php', 'action', '1'),
(44, 'CheckoutPaymentModuleGCOutput', '/avactis-system/modules/payment_module_gc/views/gc_output_cz.php', 'view_cz', '1'),
(44, 'CheckoutPaymentModuleGCInput', '/avactis-system/modules/payment_module_gc/views/gc_input_cz.php', 'view_cz', '1'),
(44, 'Payment_Module_Gc', '/avactis-system/modules/payment_module_gc/payment_module_gc_api.php', 'api', '1'),
(45, 'offline_cc_input_az', '/avactis-system/modules/payment_module_offline_cc/views/offline_cc_input_az.php', 'view_az', '1'),
(45, 'CheckoutPaymentModuleOfflineCCOutput', '/avactis-system/modules/payment_module_offline_cc/views/offline_cc_output_cz.php', 'view_cz', '1'),
(45, 'save_rsa_public_key', '/avactis-system/modules/payment_module_offline_cc/actions/save_rsa_public_key.php', 'action', '1'),
(45, 'CheckoutPaymentModuleOfflineCCInput', '/avactis-system/modules/payment_module_offline_cc/views/offline_cc_input_cz.php', 'view_cz', '1'),
(45, 'generate_rsa_key_pair_in_php', '/avactis-system/modules/payment_module_offline_cc/actions/generate_rsa_key_pair_in_php_action.php', 'action', '1'),
(45, 'replace_rsa_key_pair_step5_replace_old_encrypted_data_with_new_reencrypted_tmp_data', '/avactis-system/modules/payment_module_offline_cc/actions/replace_rsa_key_pair_step5_replace_old_encrypted_data_with_new_reencrypted_tmp_data_action.php', 'action', '1'),
(45, 'replace_rsa_key_pair_step2_reencrypt_tmp_data', '/avactis-system/modules/payment_module_offline_cc/actions/replace_rsa_key_pair_step2_reencrypt_tmp_data_action.php', 'action', '1'),
(45, 'update_offline_cc', '/avactis-system/modules/payment_module_offline_cc/actions/update_offline_cc.php', 'action', '1'),
(45, 'replace_rsa_key_pair_step1_prepare_server_tmp_data', '/avactis-system/modules/payment_module_offline_cc/actions/replace_rsa_key_pair_step1_prepare_server_tmp_data_action.php', 'action', '1'),
(45, 'Payment_Module_Offline_CC', '/avactis-system/modules/payment_module_offline_cc/payment_module_offline_cc_api.php', 'api', '1'),
(46, 'paypal_cc_input_az', '/avactis-system/modules/payment_module_paypal_cc/views/paypal_cc_input_az.php', 'view_az', '1'),
(46, 'CheckoutPaymentModulePaypalCCOutput', '/avactis-system/modules/payment_module_paypal_cc/views/paypal_cc_output_cz.php', 'view_cz', '1'),
(46, 'update_paypal', '/avactis-system/modules/payment_module_paypal_cc/actions/update_paypal.php', 'action', '1');
INSERT INTO `[[dbprefix]]module_class` VALUES
(46, 'CheckoutPaymentModulePaypalCCInput', '/avactis-system/modules/payment_module_paypal_cc/views/paypal_cc_input_cz.php', 'view_cz', '1'),
(46, 'Payment_Module_Paypal_CC', '/avactis-system/modules/payment_module_paypal_cc/payment_module_paypal_cc_api.php', 'api', '1'),
(47, 'PF_FilesList', '/avactis-system/modules/product_files/views/files_list_az.php', 'view_az', '1'),
(47, 'PF_OrderHotlinks', '/avactis-system/modules/product_files/views/order_hotlinks_az.php', 'view_az', '1'),
(47, 'PF_Settings', '/avactis-system/modules/product_files/views/settings_az.php', 'view_az', '1'),
(47, 'direct_download_file', '/avactis-system/modules/product_files/actions/direct_download_file.php', 'action', '1'),
(47, 'DownloadProductFilePrompt', '/avactis-system/modules/product_files/views/download_product_file_prompt_cz.php', 'view_cz', '1'),
(47, 'download_product_file', '/avactis-system/modules/product_files/actions/download_product_file.php', 'action', '1'),
(47, 'update_files_of_product', '/avactis-system/modules/product_files/actions/update_files_of_product.php', 'action', '1'),
(47, 'update_hl_edate', '/avactis-system/modules/product_files/actions/update_hl_edate.php', 'action', '1'),
(47, 'zero_hotlink_tries', '/avactis-system/modules/product_files/actions/zero_hotlink_tries.php', 'action', '1'),
(47, 'del_files_from_product', '/avactis-system/modules/product_files/actions/del_files_from_product.php', 'action', '1'),
(47, 'change_hotlink_status', '/avactis-system/modules/product_files/actions/change_hotlink_status.php', 'action', '1'),
(47, 'add_file_to_product', '/avactis-system/modules/product_files/actions/add_file_to_product.php', 'action', '1'),
(47, 'update_pf_settings', '/avactis-system/modules/product_files/actions/update_pf_settings.php', 'action', '1'),
(47, 'Product_Files', '/avactis-system/modules/product_files/product_files_api.php', 'api', '1'),
(48, 'PI_Settings', '/avactis-system/modules/product_images/views/settings_az.php', 'view_az', '1'),
(48, 'ProductDetailedImages', '/avactis-system/modules/product_images/views/images_block_cz.php', 'view_cz', '1'),
(48, 'PI_ImagesList', '/avactis-system/modules/product_images/views/images_list_az.php', 'view_az', '1'),
(48, 'update_imgs_sort_order', '/avactis-system/modules/product_images/actions/update_imgs_sort_order.php', 'action', '1'),
(48, 'update_pi_settings', '/avactis-system/modules/product_images/actions/update_pi_settings.php', 'action', '1'),
(48, 'update_images_of_product', '/avactis-system/modules/product_images/actions/update_images_of_product.php', 'action', '1'),
(48, 'add_image_to_product', '/avactis-system/modules/product_images/actions/add_image_to_product.php', 'action', '1'),
(48, 'del_images_from_product', '/avactis-system/modules/product_images/actions/del_images_from_product.php', 'action', '1'),
(48, 'upload_image_for_preview', '/avactis-system/modules/product_images/actions/upload_image_for_preview.php', 'action', '1'),
(48, 'Product_Images', '/avactis-system/modules/product_images/product_images_api.php', 'api', '1'),
(49, 'PO_InvEditor', '/avactis-system/modules/product_options/views/po_inv_editor_az.php', 'view_az', '1'),
(49, 'PO_CRulesList', '/avactis-system/modules/product_options/views/po_crules_list_az.php', 'view_az', '1'),
(49, 'PO_CRulesEditor', '/avactis-system/modules/product_options/views/po_crules_editor_az.php', 'view_az', '1'),
(49, 'PO_InvPage', '/avactis-system/modules/product_options/views/po_inv_page_az.php', 'view_az', '1'),
(49, 'PO_EditOption', '/avactis-system/modules/product_options/views/po_edit_option_az.php', 'view_az', '1'),
(49, 'PO_AddOption', '/avactis-system/modules/product_options/views/po_add_option_az.php', 'view_az', '1'),
(49, 'PO_OptionsList', '/avactis-system/modules/product_options/views/po_options_list_az.php', 'view_az', '1'),
(49, 'ProductOptionsWarnings', '/avactis-system/modules/product_options/views/options-warnings-cz.php', 'view_cz', '1'),
(49, 'OptionsCombination', '/avactis-system/modules/product_options/views/options-combination-cz.php', 'view_cz', '1'),
(49, 'OptionsChoice', '/avactis-system/modules/product_options/views/options-choice-cz.php', 'view_cz', '1'),
(49, 'update_options_sort', '/avactis-system/modules/product_options/actions/update_options_sort.php', 'action', '1'),
(49, 'update_values_sort', '/avactis-system/modules/product_options/actions/update_values_sort.php', 'action', '1'),
(49, 'get_uploaded_file', '/avactis-system/modules/product_options/actions/get_uploaded_file.php', 'action', '1'),
(49, 'get_crules_list', '/avactis-system/modules/product_options/actions/get_crules_list.php', 'action', '1'),
(49, 'del_crules_from_entity', '/avactis-system/modules/product_options/actions/del_crules_from_entity.php', 'action', '1'),
(49, 'add_crule_to_entity', '/avactis-system/modules/product_options/actions/add_crule_to_entity.php', 'action', '1'),
(49, 'clear_inventory', '/avactis-system/modules/product_options/actions/clear_inventory.php', 'action', '1'),
(49, 'get_inventory_page', '/avactis-system/modules/product_options/actions/get_inventory_page.php', 'action', '1'),
(49, 'rebuild_inventory', '/avactis-system/modules/product_options/actions/rebuild_inventory.php', 'action', '1'),
(49, 'update_inventory', '/avactis-system/modules/product_options/actions/update_inventory.php', 'action', '1'),
(49, 'del_inv_records_from_entity', '/avactis-system/modules/product_options/actions/del_inv_records_from_entity.php', 'action', '1'),
(49, 'add_inv_record_to_entity', '/avactis-system/modules/product_options/actions/add_inv_record_to_entity.php', 'action', '1'),
(49, 'update_options_settings', '/avactis-system/modules/product_options/actions/update_options_settings.php', 'action', '1'),
(49, 'update_values_of_option', '/avactis-system/modules/product_options/actions/update_values_of_option.php', 'action', '1'),
(49, 'del_values_from_option', '/avactis-system/modules/product_options/actions/del_values_from_option.php', 'action', '1'),
(49, 'add_value_to_option', '/avactis-system/modules/product_options/actions/add_value_to_option.php', 'action', '1'),
(49, 'update_option_of_entity', '/avactis-system/modules/product_options/actions/update_option_of_entity.php', 'action', '1'),
(49, 'del_option_from_entity', '/avactis-system/modules/product_options/actions/del_option_from_entity.php', 'action', '1'),
(49, 'add_option_to_entity', '/avactis-system/modules/product_options/actions/add_option_to_entity.php', 'action', '1'),
(49, 'Product_Options', '/avactis-system/modules/product_options/product_options_api.php', 'api', '1'),
(50, 'EditPromoCode', '/avactis-system/modules/promocodes/views/edit_promo_code_az.php', 'view_az', '1'),
(50, 'EditPromoCodeArea', '/avactis-system/modules/promocodes/views/edit_promo_code_area_az.php', 'view_az', '1'),
(50, 'AddPromoCode', '/avactis-system/modules/promocodes/views/add_promo_code_az.php', 'view_az', '1'),
(50, 'PromoCodesNavigationBar', '/avactis-system/modules/promocodes/views/promo_codes_manage_promo_codes_az.php', 'view_az', '1'),
(50, 'PromoCodeForm', '/avactis-system/modules/promocodes/views/promo_code_form_cz.php', 'view_cz', '1'),
(50, 'AddPromoCode', '/avactis-system/modules/promocodes/actions/add_promo_code_action.php', 'action', '1'),
(50, 'RemovePromoCode', '/avactis-system/modules/promocodes/actions/remove_promo_code_action.php', 'action', '1'),
(50, 'DelPromoCodeInfo', '/avactis-system/modules/promocodes/actions/del_promo_code_info_action.php', 'action', '1'),
(50, 'UpdatePromoCodeInfo', '/avactis-system/modules/promocodes/actions/update_promo_code_info_action.php', 'action', '1'),
(50, 'UpdatePromoCodeArea', '/avactis-system/modules/promocodes/actions/update_promo_code_area_action.php', 'action', '1'),
(50, 'SetEditablePromoCode', '/avactis-system/modules/promocodes/actions/set_editable_promo_code_action.php', 'action', '1'),
(50, 'AddPromoCodeInfo', '/avactis-system/modules/promocodes/actions/add_promo_code_info_action.php', 'action', '1'),
(50, 'PromoCodes', '/avactis-system/modules/promocodes/promo_codes_api.php', 'api', '1'),
(51, 'manage_quantity_discounts_az', '/avactis-system/modules/quantity_discounts/views/manage_quantity_discounts_az.php', 'view_az', '1'),
(51, 'Quantity_Discounts', '/avactis-system/modules/quantity_discounts/quantity_discounts_api.php', 'api', '1'),
(51, 'update_quantity_discounts', '/avactis-system/modules/quantity_discounts/actions/update_quantity_discounts_action.php', 'action', '1'),
(52, 'QB_Export', '/avactis-system/modules/quick_books/views/qb_export_az.php', 'view_az', '1'),
(52, 'do_orders_export', '/avactis-system/modules/quick_books/actions/do_orders_export.php', 'action', '1'),
(52, 'QB_Settings', '/avactis-system/modules/quick_books/views/qb_settings_az.php', 'view_az', '1'),
(52, 'update_qb_settings', '/avactis-system/modules/quick_books/actions/update_qb_settings.php', 'action', '1'),
(52, 'Quick_Books', '/avactis-system/modules/quick_books/quick_books_api.php', 'api', '1'),
(53, 'RelatedProducts', '/avactis-system/modules/related_products/views/related_products_cz.php', 'view_cz', '1'),
(53, 'RP_LinksList', '/avactis-system/modules/related_products/views/rp_links_list_az.php', 'view_az', '1'),
(53, 'Related_Products', '/avactis-system/modules/related_products/related_products_api.php', 'api', '1'),
(53, 'save_rp_links', '/avactis-system/modules/related_products/actions/save_rp_links.php', 'action', '1'),
(54, 'StatisticsAverageVisitorsPerDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsMaxUniqueVisitors', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsMaxVisitorsOnline', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsOnlineYesterday', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsOnline', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsOnlineRaw', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsOrdersNumberToday', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsSalesTotalToday', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsThisYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsLastYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsLastMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsLastWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsThisMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsThisWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsLastDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsTotal', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitorsThisDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsLastYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsLastMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsThisYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsThisMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsThisWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsLastWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsLastDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsTotal', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsVisitsThisDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsLastYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsThisYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsThisMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsLastMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsLastWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsThisWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsLastDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsTotal', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'StatisticsPageViewsThisDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_az', '1'),
(54, 'DatetimePeriodSelector', '/avactis-system/modules/reports/views/datetime_period_selector.php', 'view_az', '1'),
(54, 'ReportGroups', '/avactis-system/modules/reports/views/report_groups.php', 'view_az', '1'),
(54, 'ReportGroupPage', '/avactis-system/modules/reports/views/report_group_page.php', 'view_az', '1'),
(54, 'ReportSalesPerVisitsRatesByDay', '/avactis-system/modules/reports/views/reports_orders_per_visitors_by_period.php', 'view_az', '1'),
(54, 'ReportOrdersPerVisitsRatesByDay', '/avactis-system/modules/reports/views/reports_orders_per_visitors_by_period.php', 'view_az', '1'),
(54, 'ReportSalesPerVisitorsRatesByDay', '/avactis-system/modules/reports/views/reports_orders_per_visitors_by_period.php', 'view_az', '1'),
(54, 'ReportOrdersPerVisitorsRatesByDay', '/avactis-system/modules/reports/views/reports_orders_per_visitors_by_period.php', 'view_az', '1'),
(54, 'ChartTaxByYear', '/avactis-system/modules/reports/views/charts_tax_by_period.php', 'view_az', '1'),
(54, 'ReportAbandonmentRatesByDay', '/avactis-system/modules/reports/views/reports_abandonment_rates_by_period.php', 'view_az', '1'),
(54, 'ChartTaxByMonth', '/avactis-system/modules/reports/views/charts_tax_by_period.php', 'view_az', '1'),
(54, 'ChartTaxByDay', '/avactis-system/modules/reports/views/charts_tax_by_period.php', 'view_az', '1'),
(54, 'ChartOrdersByDayLast10Months', '/avactis-system/modules/reports/views/charts_orders_by_period.php', 'view_az', '1'),
(54, 'ChartOrdersByDayLast10Days', '/avactis-system/modules/reports/views/charts_orders_by_period.php', 'view_az', '1'),
(54, 'ChartOrdersByYear', '/avactis-system/modules/reports/views/charts_orders_by_period.php', 'view_az', '1'),
(54, 'ChartOrdersByMonth', '/avactis-system/modules/reports/views/charts_orders_by_period.php', 'view_az', '1'),
(54, 'ChartOrdersByDay', '/avactis-system/modules/reports/views/charts_orders_by_period.php', 'view_az', '1'),
(54, 'ChartPageViewsByDay', '/avactis-system/modules/reports/views/charts_visitor_statistics.php', 'view_az', '1'),
(54, 'ChartSeancesByDay', '/avactis-system/modules/reports/views/charts_visitor_statistics.php', 'view_az', '1'),
(54, 'ChartRepeatVisitorsByDay', '/avactis-system/modules/reports/views/charts_visitor_statistics.php', 'view_az', '1'),
(54, 'ChartVisitorsByDay', '/avactis-system/modules/reports/views/charts_visitor_statistics.php', 'view_az', '1'),
(54, 'ChartFirstTimeVisitorsByDay', '/avactis-system/modules/reports/views/charts_visitor_statistics.php', 'view_az', '1'),
(54, 'ReportTopTenCustomerStatistics', '/avactis-system/modules/reports/views/reports_top_10_customers.php', 'view_az', '1'),
(54, 'ReportSeanceClickPath', '/avactis-system/modules/reports/views/reports_seance_click_path.php', 'view_az', '1'),
(54, 'ReportRecentVisitorStatisticsShort', '/avactis-system/modules/reports/views/reports_recent_visitors.php', 'view_az', '1'),
(54, 'ReportRecentCrawlersStatistics', '/avactis-system/modules/reports/views/reports_recent_visitors.php', 'view_az', '1'),
(54, 'ReportVisitsStatisticsByDay', '/avactis-system/modules/reports/views/reports_visitor_statistics.php', 'view_az', '1'),
(54, 'ReportRecentVisitorStatistics', '/avactis-system/modules/reports/views/reports_recent_visitors.php', 'view_az', '1'),
(54, 'ReportVisitorStatisticsByDay', '/avactis-system/modules/reports/views/reports_visitor_statistics.php', 'view_az', '1'),
(54, 'ReportTopViewedPages', '/avactis-system/modules/reports/views/reports_top_pages.php', 'view_az', '1'),
(54, 'ReportTopVisitorFullReferers', '/avactis-system/modules/reports/views/reports_top_referers.php', 'view_az', '1'),
(54, 'ReportTopVisitorReferers', '/avactis-system/modules/reports/views/reports_top_referers.php', 'view_az', '1'),
(54, 'ReportVisitorOS', '/avactis-system/modules/reports/views/reports_visitor_os.php', 'view_az', '1'),
(54, 'ReportVisitorBrowsers', '/avactis-system/modules/reports/views/reports_visitor_browsers.php', 'view_az', '1'),
(54, 'ChartProductViewsByYear', '/avactis-system/modules/reports/views/charts_product_views_by_period.php', 'view_az', '1'),
(54, 'ChartProductViewsByMonth', '/avactis-system/modules/reports/views/charts_product_views_by_period.php', 'view_az', '1'),
(54, 'ChartProductViewsByDay', '/avactis-system/modules/reports/views/charts_product_views_by_period.php', 'view_az', '1'),
(54, 'ReportProductAddedCartVsSalesByDay', '/avactis-system/modules/reports/views/reports_product_cart_vs_sales_by_period.php', 'view_az', '1'),
(54, 'ReportProductSalesVsViewsByDay', '/avactis-system/modules/reports/views/reports_product_views_vs_sales_by_period.php', 'view_az', '1'),
(54, 'ChartProductSalesByYear', '/avactis-system/modules/reports/views/charts_product_sales_by_period.php', 'view_az', '1'),
(54, 'ChartProductSalesByMonth', '/avactis-system/modules/reports/views/charts_product_sales_by_period.php', 'view_az', '1'),
(54, 'ChartProductSalesByDay', '/avactis-system/modules/reports/views/charts_product_sales_by_period.php', 'view_az', '1'),
(54, 'ReportProductSummaryStatisticsByYears', '/avactis-system/modules/reports/views/reports_summary_product_stat.php', 'view_az', '1'),
(54, 'ReportProductSummaryStatisticsByMonths', '/avactis-system/modules/reports/views/reports_summary_product_stat.php', 'view_az', '1'),
(54, 'ReportAllSellersByItemsLast30Days', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportProductSummaryStatisticsByDays', '/avactis-system/modules/reports/views/reports_summary_product_stat.php', 'view_az', '1'),
(54, 'ReportAllDeletedFromCartQuantity', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportAllAddedToCartQuantity', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportAllDeletedFromCartTimes', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportAllAddedToCartTimes', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportAllByViews', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportAllSellersByItems', '/avactis-system/modules/reports/views/reports_products.php', 'view_az', '1'),
(54, 'ReportTop10SellersByItemsLast30Days', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'ReportTop10DeletedFromCartQuantity', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'ReportTop10DeletedFromCartTimes', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'ReportTop10AddedToCartQuantity', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'ReportTop10AddedToCartTimes', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'ReportTop10ByViews', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'ReportTop10SellersByItems', '/avactis-system/modules/reports/views/reports_top_10.php', 'view_az', '1'),
(54, 'StatisticsAverageVisitorsPerDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsMaxUniqueVisitors', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsMaxVisitorsOnline', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsOnlineYesterday', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsOnline', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsOnlineRaw', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsOrdersNumberToday', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsSalesTotalToday', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsLastYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsLastMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsThisYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsThisMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsLastWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsThisWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsLastDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsThisDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitorsTotal', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsLastYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsThisYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsLastMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsThisMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsLastWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsThisWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsLastDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsThisDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsVisitsTotal', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsLastYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsThisYear', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsLastMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsThisMonth', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsLastWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsThisWeek', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsLastDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsThisDay', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'StatisticsPageViewsTotal', '/avactis-system/modules/reports/views/one_tag_reports.php', 'view_cz', '1'),
(54, 'getReportContent', '/avactis-system/modules/reports/actions/getReportContent.php', 'action', '1'),
(54, 'ClearStat', '/avactis-system/modules/reports/actions/clear_stat.php', 'action', '1'),
(54, 'Reports', '/avactis-system/modules/reports/reports_api.php', 'api', '1'),
(55, 'RESTManager', '/avactis-system/modules/rest/rest_api.php', 'api', '1'),
(55, 'REST_Request_Action', '/avactis-system/modules/rest/actions/rest_request_action.php', 'action', '1'),
(56, 'FindUpdatedFile', '/avactis-system/modules/securestore/views/find-updated-files-az.php', 'view_az', '1'),
(56, 'SendResultMailAction', '/avactis-system/modules/securestore/actions/sendresultmail.php', 'action', '1'),
(56, 'SecureStore', '/avactis-system/modules/securestore/secure_store_api.php', 'api', '1'),
(56, 'FindUpdatedFileAction', '/avactis-system/modules/securestore/actions/findupdatedfile.php', 'action', '1'),
(58, 'FileSelector', '/avactis-system/modules/shell/views/file_selector.php', 'view_az', '1'),
(58, 'ServerFileSelector', '/avactis-system/modules/shell/views/server_file_selector.php', 'view_az', '1'),
(58, 'FSBrowser', '/avactis-system/modules/shell/views/fs_browser.php', 'view_az', '1'),
(58, 'shell_del_uploaded', '/avactis-system/modules/shell/actions/shell_del_uploaded.php', 'action', '1'),
(58, 'shell_upload_file', '/avactis-system/modules/shell/actions/shell_upload_file.php', 'action', '1'),
(58, 'get_folder_content', '/avactis-system/modules/shell/actions/get_folder_content.php', 'action', '1'),
(58, 'Shell', '/avactis-system/modules/shell/shell_api.php', 'api', '1'),
(59, 'FreeShippingRulesList', '/avactis-system/modules/shipping_cost_calculator/views/fs-rules-list-az.php', 'view_az', '1'),
(59, 'EditFsRule', '/avactis-system/modules/shipping_cost_calculator/views/edit-fs-rule-az.php', 'view_az', '1'),
(59, 'EditFsRuleArea', '/avactis-system/modules/shipping_cost_calculator/views/edit-fs-rule-area-az.php', 'view_az', '1'),
(59, 'ShippingCostCalculatorSettings', '/avactis-system/modules/shipping_cost_calculator/views/shipping-cost-calculator-settings.php', 'view_az', '1'),
(59, 'AddFsRule', '/avactis-system/modules/shipping_cost_calculator/views/add-fs-rule-az.php', 'view_az', '1'),
(59, 'ShippingCostCalculatorSection', '/avactis-system/modules/shipping_cost_calculator/views/shipping-cost-calculator-section.php', 'view_az', '1'),
(59, 'ShippingCalculator', '/avactis-system/modules/shipping_cost_calculator/views/shipping_calculator_cz.php', 'view_cz', '1'),
(59, 'CalculateShippingCZ', '/avactis-system/modules/shipping_cost_calculator/actions/calculate_shipping_cz.php', 'action', '1'),
(59, 'UpdateFsRuleArea', '/avactis-system/modules/shipping_cost_calculator/actions/update_fs_rule_area.php', 'action', '1'),
(59, 'UpdateFsRuleInfo', '/avactis-system/modules/shipping_cost_calculator/actions/update_fs_rule.php', 'action', '1'),
(59, 'DeleteFsRule', '/avactis-system/modules/shipping_cost_calculator/actions/delete_fs_rule.php', 'action', '1'),
(59, 'AddFsRuleInfo', '/avactis-system/modules/shipping_cost_calculator/actions/add_fs_rule_info.php', 'action', '1'),
(59, 'update_scc_settings', '/avactis-system/modules/shipping_cost_calculator/actions/update_scc_settings.php', 'action', '1'),
(59, 'Shipping_Cost_Calculator', '/avactis-system/modules/shipping_cost_calculator/shipping_cost_calculator_api.php', 'api', '1'),
(60, 'Shipping_Module_All_Inactive', '/avactis-system/modules/shipping_module_all_inactive/shipping_module_all_inactive_api.php', 'api', '1'),
(61, 'Shipping_Module_DSR', '/avactis-system/modules/shipping_module_dsr/shipping_module_dsr_api.php', 'api', '1'),
(61, 'update_dsr_settings', '/avactis-system/modules/shipping_module_dsr/actions/update_dsr_settings_action.php', 'action', '1'),
(61, 'dsr_input_az', '/avactis-system/modules/shipping_module_dsr/views/dsr_input_az.php', 'view_az', '1'),
(62, 'Shipping_Module_Free_Shipping', '/avactis-system/modules/shipping_module_free_shipping/shipping_module_free_shipping_api.php', 'api', '1'),
(63, 'ShippingTesterWindow', '/avactis-system/modules/shipping_tester/views/shipping-tester-window.php', 'view_az', '1'),
(63, 'Shipping_Tester', '/avactis-system/modules/shipping_tester/shipping_tester_api.php', 'api', '1'),
(63, 'test_ship', '/avactis-system/modules/shipping_tester/actions/test_ship.php', 'action', '1'),
(64, 'Statistics', '/avactis-system/modules/statistics/statistics_api.php', 'api', '1'),
(65, 'Subscriptions_Topic_Name', '/avactis-system/modules/subscriptions/views/topic_name.php', 'view_az', '1'),
(65, 'Subscriptions_Export', '/avactis-system/modules/subscriptions/views/export_az.php', 'view_az', '1'),
(65, 'Subscriptions_Unsubscribe', '/avactis-system/modules/subscriptions/views/unsubscribe_az.php', 'view_az', '1'),
(65, 'Subscriptions_Subscribe', '/avactis-system/modules/subscriptions/views/subscribe_az.php', 'view_az', '1'),
(65, 'Subscriptions_DeleteTopics', '/avactis-system/modules/subscriptions/views/delete_topics_az.php', 'view_az', '1'),
(65, 'Subscriptions_SortTopics', '/avactis-system/modules/subscriptions/views/sort_topics_az.php', 'view_az', '1'),
(65, 'Subscriptions_EditTopic', '/avactis-system/modules/subscriptions/views/edit_topic_az.php', 'view_az', '1'),
(65, 'Subscriptions_Manage', '/avactis-system/modules/subscriptions/views/manage_az.php', 'view_az', '1'),
(65, 'SubscribeOnCheckoutOutput', '/avactis-system/modules/subscriptions/views/subscribe_on_checkout_output_cz.php', 'view_cz', '1'),
(65, 'SubscribeOnCheckout', '/avactis-system/modules/subscriptions/views/subscribe_on_checkout_cz.php', 'view_cz', '1'),
(65, 'UnsubscribeByLink', '/avactis-system/modules/subscriptions/views/unsubscribe_by_link_cz.php', 'view_cz', '1'),
(65, 'SubscribeFormProfile', '/avactis-system/modules/subscriptions/views/subscribe_form_profile_cz.php', 'view_cz', '1'),
(65, 'update_subscr_signature', '/avactis-system/modules/subscriptions/actions/update_subscr_signature.php', 'action', '1'),
(65, 'SubscribeBox', '/avactis-system/modules/subscriptions/views/subscribe_box_cz.php', 'view_cz', '1'),
(65, 'update_customer_subscriptions', '/avactis-system/modules/subscriptions/actions/update_customer_subscriptions.php', 'action', '1'),
(65, 'emails_export', '/avactis-system/modules/subscriptions/actions/export.php', 'action', '1'),
(65, 'unsubscribe_confirm', '/avactis-system/modules/subscriptions/actions/unsubscribe_confirm.php', 'action', '1'),
(65, 'subscribe', '/avactis-system/modules/subscriptions/actions/subscribe.php', 'action', '1'),
(65, 'subscribe_confirm', '/avactis-system/modules/subscriptions/actions/subscribe_confirm.php', 'action', '1'),
(65, 'update_topic', '/avactis-system/modules/subscriptions/actions/update_topic.php', 'action', '1'),
(65, 'create_topic', '/avactis-system/modules/subscriptions/actions/create_topic.php', 'action', '1'),
(65, 'delete_emails', '/avactis-system/modules/subscriptions/actions/delete_emails.php', 'action', '1'),
(65, 'delete_topics', '/avactis-system/modules/subscriptions/actions/delete_topics.php', 'action', '1'),
(65, 'update_topics_order', '/avactis-system/modules/subscriptions/actions/update_topics_order.php', 'action', '1'),
(65, 'Subscriptions', '/avactis-system/modules/subscriptions/subscriptions_api.php', 'api', '1'),
(66, 'TaxExempts', '/avactis-system/modules/tax_exempts/tax_exempts_api.php', 'api', '1'),
(66, 'FullTaxExemptForm', '/avactis-system/modules/tax_exempts/views/full_tax_exempt_form_cz.php', 'view_cz', '1'),
(67, 'TaxRatesImportView', '/avactis-system/modules/tax_rate_by_zip/views/taxrates_import_az.php', 'view_az', '1'),
(67, 'TaxRateByZip_AddNewSet', '/avactis-system/modules/tax_rate_by_zip/views/tax-rate-by-zip-add-new-set.php', 'view_az', '1'),
(67, 'TaxRatesRedirectToImportAction', '/avactis-system/modules/tax_rate_by_zip/actions/redirect_to_import_action.php', 'action', '1'),
(67, 'TaxRateByZip_Sets', '/avactis-system/modules/tax_rate_by_zip/views/tax-rate-by-zip-sets-az.php', 'view_az', '1'),
(67, 'DoTaxRatesImportFromCSV', '/avactis-system/modules/tax_rate_by_zip/actions/do_taxrates_import_from_csv.php', 'action', '1'),
(67, 'TaxRatesByZipItemsAction', '/avactis-system/modules/tax_rate_by_zip/actions/taxratesbyzipitems_action.php', 'action', '1'),
(67, 'TaxRateByZip', '/avactis-system/modules/tax_rate_by_zip/tax_rate_by_zip_api.php', 'api', '1'),
(68, 'TaxCalculator', '/avactis-system/modules/taxes/views/tax-calculator-az.php', 'view_az', '1'),
(68, 'ShippingModulesListForTaxes', '/avactis-system/modules/taxes/views/sm-list-az.php', 'view_az', '1'),
(68, 'EditTaxRate', '/avactis-system/modules/taxes/views/tax-settings-edit-rate-az.php', 'view_az', '1'),
(68, 'AddTaxRate', '/avactis-system/modules/taxes/views/tax-settings-add-rate-az.php', 'view_az', '1'),
(68, 'EditTaxClass', '/avactis-system/modules/taxes/views/tax-settings-edit-class-az.php', 'view_az', '1'),
(68, 'AddTaxClass', '/avactis-system/modules/taxes/views/tax-settings-add-class-az.php', 'view_az', '1'),
(68, 'EditTaxDisplayOption', '/avactis-system/modules/taxes/views/tax-settings-edit-display-az.php', 'view_az', '1'),
(68, 'AddTaxDisplayOption', '/avactis-system/modules/taxes/views/tax-settings-add-display-az.php', 'view_az', '1'),
(68, 'EditTaxName', '/avactis-system/modules/taxes/views/tax-settings-edit-name-az.php', 'view_az', '1'),
(68, 'AddTaxName', '/avactis-system/modules/taxes/views/tax-settings-add-name-az.php', 'view_az', '1'),
(68, 'TaxSettings', '/avactis-system/modules/taxes/views/tax-settings-az.php', 'view_az', '1'),
(68, 'SetShippingTaxes', '/avactis-system/modules/taxes/actions/setshippingtaxes_action.php', 'action', '1'),
(68, 'ProductTaxClassSettings', '/avactis-system/modules/taxes/views/prod-tax-class-settings-az.php', 'view_az', '1'),
(68, 'TaxCalculateAction', '/avactis-system/modules/taxes/actions/taxcalculator_action.php', 'action', '1'),
(68, 'AddFromCatalog', '/avactis-system/modules/taxes/actions/addprodtaxclassfromcatalog_action.php', 'action', '1'),
(68, 'DeleteTaxRateAction', '/avactis-system/modules/taxes/actions/deletetaxrate_action.php', 'action', '1'),
(68, 'UpdateTaxRateAction', '/avactis-system/modules/taxes/actions/updatetaxrate_action.php', 'action', '1'),
(68, 'AddTaxRateAction', '/avactis-system/modules/taxes/actions/addtaxrate_action.php', 'action', '1'),
(68, 'DeleteTaxDisplayOptionAction', '/avactis-system/modules/taxes/actions/deletetaxdisplayoption_action.php', 'action', '1'),
(68, 'UpdateTaxDisplayAction', '/avactis-system/modules/taxes/actions/updatetaxdisplayoption_action.php', 'action', '1'),
(68, 'SetTaxClassId', '/avactis-system/modules/taxes/actions/settaxclassid_action.php', 'action', '1'),
(68, 'AddTaxDisplayOptionAction', '/avactis-system/modules/taxes/actions/addtaxdisplayoption_action.php', 'action', '1'),
(68, 'DeleteTaxNameAction', '/avactis-system/modules/taxes/actions/deletetaxname_action.php', 'action', '1'),
(68, 'SetEditableTaxId', '/avactis-system/modules/taxes/actions/seteditabletaxid_action.php', 'action', '1'),
(68, 'UpdateTaxNameAction', '/avactis-system/modules/taxes/actions/updatetaxname_action.php', 'action', '1'),
(68, 'AddTaxNameAction', '/avactis-system/modules/taxes/actions/addtaxname_action.php', 'action', '1'),
(68, 'DeleteProdTaxClass', '/avactis-system/modules/taxes/actions/deleteprodtaxclass_action.php', 'action', '1'),
(68, 'UpdateProdTaxClass', '/avactis-system/modules/taxes/actions/updateprodtaxclass_action.php', 'action', '1'),
(68, 'AddProdTaxClass', '/avactis-system/modules/taxes/actions/addprodtaxclass_action.php', 'action', '1'),
(68, 'Taxes', '/avactis-system/modules/taxes/taxes_api.php', 'api', '1'),
(69, 'TimelineView', '/avactis-system/modules/timeline/views/timeline.php', 'view_az', '1'),
(69, 'TimelineItemView', '/avactis-system/modules/timeline/views/timeline_item.php', 'view_az', '1'),
(69, 'SetTimelineFilter', '/avactis-system/modules/timeline/actions/SetTimelineFilter.php', 'action', '1'),
(69, 'Timeline', '/avactis-system/modules/timeline/timeline_api.php', 'api', '1'),
(70, 'ServerInfo', '/avactis-system/modules/tools/views/server_info_az.php', 'view_az', '1'),
(70, 'CZLayoutsList', '/avactis-system/modules/tools/views/cz_layouts_list_az.php', 'view_az', '1'),
(70, 'Support', '/avactis-system/modules/tools/views/support_az.php', 'view_az', '1'),
(70, 'RestoreProgress', '/avactis-system/modules/tools/views/restore_progress_az.php', 'view_az', '1'),
(70, 'BackupProgress', '/avactis-system/modules/tools/views/backup_progress_az.php', 'view_az', '1'),
(70, 'BackupDeleteProgress', '/avactis-system/modules/tools/views/backup_delete_progress_az.php', 'view_az', '1'),
(70, 'BackupDelete', '/avactis-system/modules/tools/views/backup_delete_az.php', 'view_az', '1'),
(70, 'BackupRestore', '/avactis-system/modules/tools/views/backup_restore_az.php', 'view_az', '1'),
(70, 'BackupCreate', '/avactis-system/modules/tools/views/backup_create_az.php', 'view_az', '1'),
(70, 'BackupInfo', '/avactis-system/modules/tools/views/backup_info_az.php', 'view_az', '1'),
(70, 'Backup', '/avactis-system/modules/tools/views/backup_az.php', 'view_az', '1'),
(70, 'AutoBackupCreate', '/avactis-system/modules/tools/views/auto_backup_create_az.php', 'view_az', '1'),
(70, 'CreateAutoBackup', '/avactis-system/modules/tools/actions/auto_backup_action.php', 'action', '1'),
(70, 'UpdateBackupInfo', '/avactis-system/modules/tools/actions/update_backup_info_action.php', 'action', '1'),
(70, 'SetCurrentBackupFile', '/avactis-system/modules/tools/actions/set_current_backup_file_action.php', 'action', '1'),
(70, 'SetRestoreFile', '/avactis-system/modules/tools/actions/set_restore_file_action.php', 'action', '1'),
(70, 'BackupDeleteAction', '/avactis-system/modules/tools/actions/backup_delete_action.php', 'action', '1'),
(70, 'BackupCancel', '/avactis-system/modules/tools/actions/backup_cancel_action.php', 'action', '1'),
(70, 'RestoreImagesProgressAction', '/avactis-system/modules/tools/actions/restore_images_progress_action.php', 'action', '1'),
(70, 'RestoreProgressAction', '/avactis-system/modules/tools/actions/restore_progress_action.php', 'action', '1'),
(70, 'BackupImagesProgressAction', '/avactis-system/modules/tools/actions/backup_images_progress_action.php', 'action', '1'),
(70, 'BackupProgressAction', '/avactis-system/modules/tools/actions/backup_progress_action.php', 'action', '1'),
(70, 'DBStat', '/avactis-system/modules/tools/actions/db_stat_action.php', 'action', '1'),
(70, 'Tools', '/avactis-system/modules/tools/tools_api.php', 'api', '1'),
(71, 'TransactionTrackingSettings', '/avactis-system/modules/transaction_tracking/views/transaction-tracking-settings-az.php', 'view_az', '1'),
(71, 'TransactionTrackingHtmlCode', '/avactis-system/modules/transaction_tracking/views/transaction-tracking-html-code-cz.php', 'view_cz', '1'),
(71, 'VisitorTrackingCode', '/avactis-system/modules/transaction_tracking/views/visitor-tracking-code-cz.php', 'view_cz', '1'),
(71, 'UpdateTransactionTrackingSettings', '/avactis-system/modules/transaction_tracking/actions/update-transaction-tracking-settings-action.php', 'action', '1'),
(71, 'TransactionTracking', '/avactis-system/modules/transaction_tracking/transaction_tracking_api.php', 'api', '1'),
(72, 'AdminMemberEdit', '/avactis-system/modules/users/views/admin_member_edit_az.php', 'view_az', '1'),
(72, 'AdminMemberAdd', '/avactis-system/modules/users/views/admin_member_add_az.php', 'view_az', '1'),
(72, 'AdminMemberInfo', '/avactis-system/modules/users/views/admin_member_info_az.php', 'view_az', '1'),
(72, 'AdminMembers', '/avactis-system/modules/users/views/admin_members_az.php', 'view_az', '1'),
(72, 'AdminPasswordRecovery', '/avactis-system/modules/users/views/password_recovery_az.php', 'view_az', '1'),
(72, 'AdminPasswordUpdate', '/avactis-system/modules/users/views/password_update_az.php', 'view_az', '1'),
(72, 'AdminSignIn', '/avactis-system/modules/users/views/signin_az.php', 'view_az', '1'),
(72, 'SignIn', '/avactis-system/modules/users/actions/signin_action.php', 'action', '1'),
(72, 'SetSelectedUser', '/avactis-system/modules/users/actions/set_selected_user_action.php', 'action', '1'),
(72, 'SignOut', '/avactis-system/modules/users/actions/signout_action.php', 'action', '1'),
(72, 'PasswordRecovery', '/avactis-system/modules/users/actions/password_recovery_action.php', 'action', '1'),
(72, 'PasswordUpdate', '/avactis-system/modules/users/actions/password_update_action.php', 'action', '1'),
(72, 'PasswordChange', '/avactis-system/modules/users/actions/password_change_action.php', 'action', '1'),
(72, 'SetDeleteAdminMembers', '/avactis-system/modules/users/actions/set_delete_admin_member_action.php', 'action', '1'),
(72, 'ConfirmDeleteAdmins', '/avactis-system/modules/users/actions/confirm_delete_admins_action.php', 'action', '1'),
(72, 'EditAdmin', '/avactis-system/modules/users/actions/edit_admin_action.php', 'action', '1'),
(72, 'Users', '/avactis-system/modules/users/users_api.php', 'api', '1'),
(72, 'AddAdmin', '/avactis-system/modules/users/actions/add_admin_action.php', 'action', '1'),
(73, 'WishlistContent', '/avactis-system/modules/wishlist/views/wl_wishlist_content_cz.php', 'view_cz', '1'),
(73, 'SendWishlistContent', '/avactis-system/modules/wishlist/views/wl_send_wishlist_content_cz.php', 'view_cz', '1'),
(73, 'AddToWishlistButton', '/avactis-system/modules/wishlist/views/wl_add_to_wishlist_button_cz.php', 'view_cz', '1'),
(73, 'WishList', '/avactis-system/modules/wishlist/wishlist_api.php', 'api', '1'),
(74, 'Wizard', '/avactis-system/modules/wizard/wizard_api.php', 'api', '1'),
(74, 'SetupGuide', '/avactis-system/modules/wizard/views/setup_guide_az.php', 'view_az', '1'),
(75, 'AnalyticsApi', '/avactis-extensions/analytics/analytics_api.php', 'api', '1'),
(75, 'UpdateAnalytics', '/avactis-extensions/analytics/actions/update_analytics_action.php', 'action', '1'),
(75, 'AnalyticsFieldAz', '/avactis-extensions/analytics/views/admin/analytics_field_az.php', 'view_az', '1'),
(76, 'BannerContentManagement', '/avactis-extensions/banner/views/admin/banner_manage_content_az.php', 'view_az', '1'),
(76, 'BannerManagement', '/avactis-extensions/banner/views/admin/banner_manage_az.php', 'view_az', '1'),
(76, 'BannerLocation', '/avactis-extensions/banner/views/admin/banner_location_az.php', 'view_az', '1'),
(76, 'add_banner_content_info', '/avactis-extensions/banner/actions/add_banner_content_info_action.php', 'action', '1'),
(76, 'Banners', '/avactis-extensions/banner/views/frontend/banners_cz.php', 'view_cz', '1'),
(76, 'banner', '/avactis-extensions/banner/banner_api.php', 'api', '1'),
(76, 'add_banner_info', '/avactis-extensions/banner/actions/add_banner_info_action.php', 'action', '1'),
(8, 'ProductSearchFormShort', '/avactis-system/modules/catalog/views/product_search_form_short_az.php', 'view_az', '1'),
(10, 'ManageCustomFields', '/avactis-system/modules/checkout/views/checkout-manage-custom-fields.php', 'view_az', '1'),
(4, 'MailParamList', '/avactis-system/modules/configuration/views/mail_params_az.php', 'view_az', '1'),
(15, 'CustomerGroups', '/avactis-system/modules/customer_account/views/customer_groups_az.php', 'view_az', '1'),
(15, 'ExportCustomers', '/avactis-system/modules/customer_account/views/export_customers_az.php', 'view_az', '1'),
(3, 'ChangeDefaultLanguage', '/avactis-system/modules/multilang/views/ml_change_default_language_az.php', 'view_az', '1'),
(49, 'PO_CheckCRules', '/avactis-system/modules/product_options/views/po_check_crules_az.php', 'view_az', '1'),
(54, 'ReportsResetData', '/avactis-system/modules/reports/views/reports_reset_data.php', 'view_az', '1'),
(65, 'Subscriptions_Signature', '/avactis-system/modules/subscriptions/views/signature_az.php', 'view_az', '1'),
(72, 'AdminMemberDelete', '/avactis-system/modules/users/views/admin_member_delete_az.php', 'view_az', '1'),
(72, 'AdminMemberPasswordReset', '/avactis-system/modules/users/views/admin_member_passwd_reset_az.php', 'view_az', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mr_integrity`
--

CREATE TABLE `[[dbprefix]]mr_integrity` (
  `record_id` int(11) NOT NULL AUTO_INCREMENT,
  `layout_path` varchar(255) NOT NULL DEFAULT '',
  `layout_md5` varchar(50) NOT NULL DEFAULT '',
  `htaccess_path` varchar(255) NOT NULL DEFAULT '',
  `htaccess_md5` varchar(50) NOT NULL DEFAULT '',
  `sefu_md5` varchar(50) NOT NULL DEFAULT '',
  `sets_md5` varchar(50) NOT NULL DEFAULT '',
  `mr_active` enum('N','Y') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`record_id`),
  UNIQUE KEY `lp` (`layout_path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mr_schemes`
--

CREATE TABLE `[[dbprefix]]mr_schemes` (
  `scheme_id` int(11) NOT NULL AUTO_INCREMENT,
  `scheme_name` varchar(255) NOT NULL DEFAULT '',
  `cat_rule_tpl` varchar(255) NOT NULL DEFAULT '',
  `prod_rule_tpl` varchar(255) NOT NULL DEFAULT '',
  `cms_rule_tpl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`scheme_id`),
  UNIQUE KEY `sn` (`scheme_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]mr_schemes`
--

INSERT INTO `[[dbprefix]]mr_schemes` VALUES
(1, 's1', '^%query_cat_prefix%-(%category_id%)-(%page_number%)%parent_cid%-%seo_cat_prefix%\\.html', '^%query_prod_prefix%-(%product_id%)%parent_cid%-%seo_prod_prefix%\\.html', '^%query_cms_prefix%-(%page_id%)-%seo_cms_prefix%\\.html'),
(2, 's2', '^%seo_cat_prefix%-%query_cat_prefix%-(%category_id%)-(%page_number%)%parent_cid%\\.html', '^%seo_prod_prefix%-%query_prod_prefix%-(%product_id%)%parent_cid%\\.html', '^%seo_cms_prefix%-%query_cms_prefix%-(%page_id%)\\.html'),
(3, 's3', '^%query_cat_prefix%-(%category_id%)-(%page_number%)%parent_cid%/%seo_cat_prefix%\\.html', '^%query_prod_prefix%-(%product_id%)%parent_cid%/%seo_prod_prefix%\\.html', '^%query_cms_prefix%-(%page_id%)/%seo_cms_prefix%\\.html'),
(4, 's4', '^%seo_cat_prefix%/%query_cat_prefix%-(%category_id%)-(%page_number%)%parent_cid%\\.html', '^%seo_prod_prefix%/%query_prod_prefix%-(%product_id%)%parent_cid%\\.html', '^%seo_cms_prefix%/%query_cms_prefix%-(%page_id%)\\.html'),
(5, 's5', '^%query_cat_prefix%/(%category_id%)-(%page_number%)%parent_cid%/%seo_cat_prefix%\\.html', '^%query_prod_prefix%/(%product_id%)%parent_cid%/%seo_prod_prefix%\\.html', '^%query_cms_prefix%/(%page_id%)/%seo_cms_prefix%\\.html'),
(6, 's6', '^%seo_cat_prefix%/%query_cat_prefix%/(%category_id%)-(%page_number%)%parent_cid%\\.html', '^%seo_prod_prefix%/%query_prod_prefix%/(%product_id%)%parent_cid%\\.html', '^%seo_cms_prefix%/%query_cms_prefix%/(%page_id%)\\.html');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mr_settings`
--

CREATE TABLE `[[dbprefix]]mr_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]mr_settings`
--

INSERT INTO `[[dbprefix]]mr_settings` VALUES
(1, 'CATS_PREFIX', 'cid'),
(2, 'PRODS_PREFIX', 'pid'),
(3, 'CMS_PREFIX', 'cms'),
(4, 'REWRITE_SCHEME', '1'),
(5, 'ADD_FSL_STRING', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]multilang_active_languages`
--

CREATE TABLE `[[dbprefix]]multilang_active_languages` (
  `lng_number` int(11) NOT NULL AUTO_INCREMENT,
  `lng` char(2) DEFAULT NULL,
  `lng_name` varchar(255) DEFAULT NULL,
  `lng_name_mb` varchar(255) DEFAULT NULL,
  `codepage` varchar(255) DEFAULT NULL,
  `is_active` varchar(1) DEFAULT NULL,
  `is_default` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`lng_number`),
  KEY `lng` (`lng`),
  KEY `lng_name` (`lng_name`),
  KEY `is_active` (`is_active`),
  KEY `is_default` (`is_default`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]multilang_active_languages`
--

INSERT INTO `[[dbprefix]]multilang_active_languages` VALUES
(1, 'EN', 'English', NULL, '', 'Y', 'Y');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]multilang_data`
--

CREATE TABLE `[[dbprefix]]multilang_data` (
  `ml_id` int(11) NOT NULL AUTO_INCREMENT,
  `label` int(11) DEFAULT NULL,
  `label_key` int(11) DEFAULT NULL,
  `lng` int(11) DEFAULT NULL,
  `value` longtext,
  PRIMARY KEY (`ml_id`),
  UNIQUE KEY `label_lng` (`label`,`label_key`,`lng`),
  KEY `label` (`label`),
  KEY `label_key` (`label_key`),
  KEY `lng` (`lng`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]multilang_languages`
--

CREATE TABLE `[[dbprefix]]multilang_languages` (
  `lng` char(2) NOT NULL DEFAULT '',
  `lng_name` varchar(255) DEFAULT NULL,
  `codepage` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`lng`),
  KEY `lng_name` (`lng_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]multilang_languages`
--

INSERT INTO `[[dbprefix]]multilang_languages` VALUES
('AA', 'Afar', ''),
('AB', 'Abkhazian', ''),
('AE', 'Avestan', ''),
('AF', 'Afrikaans', ''),
('AM', 'Amharic', ''),
('AN', 'Aragonese', ''),
('AR', 'Arabic', ''),
('AS', 'Assamese', ''),
('AY', 'Aymara', ''),
('AZ', 'Azerbaijani', ''),
('BA', 'Bashkir', ''),
('BE', 'Belarusian', ''),
('BG', 'Bulgarian', ''),
('BH', 'Bihari', ''),
('BI', 'Bislama', ''),
('BN', 'Bengali', ''),
('BO', 'Tibetan', ''),
('BR', 'Breton', ''),
('BS', 'Bosnian', ''),
('CA', 'Catalan', ''),
('CE', 'Chechen', ''),
('CH', 'Chamorro', ''),
('CO', 'Corsican', ''),
('CS', 'Czech', ''),
('CU', 'Church Slavic/Slavonic/Old Bulgarian', ''),
('CV', 'Chuvash', ''),
('CY', 'Welsh', ''),
('DA', 'Danish', ''),
('DE', 'German', ''),
('DV', 'Divehi/Dhivehi/Maldivian', ''),
('DZ', 'Dzongkha', ''),
('EL', 'Greek, Modern (1453-)', ''),
('EN', 'English', ''),
('EO', 'Esperanto', ''),
('ES', 'Spanish/Castilian', ''),
('ET', 'Estonian', ''),
('EU', 'Basque', ''),
('FA', 'Persian', ''),
('FI', 'Finnish', ''),
('FJ', 'Fijian', ''),
('FO', 'Faroese', ''),
('FR', 'French', ''),
('FY', 'Western Frisian', ''),
('GA', 'Irish', ''),
('GD', 'Gaelic/Scottish Gaelic', ''),
('GL', 'Galician', ''),
('GN', 'Guarani', ''),
('GU', 'Gujarati', ''),
('GV', 'Manx', ''),
('HA', 'Hausa', ''),
('HE', 'Hebrew', ''),
('HI', 'Hindi', ''),
('HO', 'Hiri Motu', ''),
('HR', 'Croatian', ''),
('HT', 'Haitian/Haitian Creole', ''),
('HU', 'Hungarian', ''),
('HY', 'Armenian', ''),
('HZ', 'Herero', ''),
('IA', 'Interlingua (International Auxiliary Language Association)', ''),
('ID', 'Indonesian', ''),
('IE', 'Interlingue', ''),
('II', 'Sichuan Yi', ''),
('IK', 'Inupiaq', ''),
('IO', 'Ido', ''),
('IS', 'Icelandic', ''),
('IT', 'Italian', ''),
('IU', 'Inuktitut', ''),
('JA', 'Japanese', ''),
('JV', 'Javanese', ''),
('KA', 'Georgian', ''),
('KI', 'Kikuyu/Gikuyu', ''),
('KJ', 'Kuanyama/Kwanyama', ''),
('KK', 'Kazakh', ''),
('KL', 'Kalaallisut', ''),
('KM', 'Khmer', ''),
('KN', 'Kannada', ''),
('KO', 'Korean', ''),
('KS', 'Kashmiri', ''),
('KU', 'Kurdish', ''),
('KV', 'Komi', ''),
('KW', 'Cornish', ''),
('KY', 'Kirghiz', ''),
('LA', 'Latin', ''),
('LB', 'Luxembourgish/Letzeburgesch', ''),
('LI', 'Limburgan/Limburger/Limburgish', ''),
('LN', 'Lingala', ''),
('LO', 'Lao', ''),
('LT', 'Lithuanian', ''),
('LV', 'Latvian', ''),
('MG', 'Malagasy', ''),
('MH', 'Marshallese', ''),
('MI', 'Maori', ''),
('MK', 'Macedonian', ''),
('ML', 'Malayalam', ''),
('MN', 'Mongolian', ''),
('MO', 'Moldavian', ''),
('MR', 'Marathi', ''),
('MS', 'Malay', ''),
('MT', 'Maltese', ''),
('MY', 'Burmese', ''),
('NA', 'Nauru', ''),
('NB', 'Norwegian Bokmal', ''),
('ND', 'Ndebele, North', ''),
('NE', 'Nepali', ''),
('NG', 'Ndonga', ''),
('NL', 'Dutch', ''),
('NN', 'Norwegian Nynorsk', ''),
('NO', 'Norwegian', ''),
('NR', 'Ndebele, South', ''),
('NV', 'Navaho, Navajo', ''),
('NY', 'Nyanja/Chichewa/Chewa', ''),
('OC', 'Occitan (post 1500)/Provencal', ''),
('OM', 'Oromo', ''),
('OR', 'Oriya', ''),
('OS', 'Ossetian/Ossetic', ''),
('PA', 'Panjabi', ''),
('PI', 'Pali', ''),
('PL', 'Polish', ''),
('PS', 'Pushto', ''),
('PT', 'Portuguese', ''),
('QU', 'Quechua', ''),
('RM', 'Raeto-Romance', ''),
('RN', 'Rundi', ''),
('RO', 'Romanian', ''),
('RU', 'Russian', ''),
('RW', 'Kinyarwanda', ''),
('SA', 'Sanskrit', ''),
('SC', 'Sardinian', ''),
('SD', 'Sindhi', ''),
('SE', 'Northern Sami', ''),
('SG', 'Sango', ''),
('SI', 'Sinhala/Sinhalese', ''),
('SK', 'Slovak', ''),
('SL', 'Slovenian', ''),
('SM', 'Samoan', ''),
('SN', 'Shona', ''),
('SO', 'Somali', ''),
('SQ', 'Albanian', ''),
('SR', 'Serbian', ''),
('SS', 'Swati', ''),
('ST', 'Sotho, Southern', ''),
('SU', 'Sundanese', ''),
('SV', 'Swedish', ''),
('SW', 'Swahili', ''),
('TA', 'Tamil', ''),
('TE', 'Telugu', ''),
('TG', 'Tajik', ''),
('TH', 'Thai', ''),
('TI', 'Tigrinya', ''),
('TK', 'Turkmen', ''),
('TL', 'Tagalog', ''),
('TN', 'Tswana', ''),
('TO', 'Tonga (Tonga Islands)', ''),
('TR', 'Turkish', ''),
('TS', 'Tsonga', ''),
('TT', 'Tatar', ''),
('TW', 'Twi', ''),
('TY', 'Tahitian', ''),
('UG', 'Uighur', ''),
('UK', 'Ukrainian', ''),
('UR', 'Urdu', ''),
('UZ', 'Uzbek', ''),
('VI', 'Vietnamese', ''),
('VO', 'Volapuk', ''),
('WA', 'Walloon', ''),
('WO', 'Wolof', ''),
('XH', 'Xhosa', ''),
('YI', 'Yiddish', ''),
('YO', 'Yoruba', ''),
('ZA', 'Zhuang/Chuang', ''),
('ZH', 'Chinese', ''),
('ZU', 'Zulu', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]negative_currency_formats`
--

CREATE TABLE `[[dbprefix]]negative_currency_formats` (
  `negative_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `format` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`negative_format_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]negative_currency_formats`
--

INSERT INTO `[[dbprefix]]negative_currency_formats` VALUES
(1, '({s}{v})'),
(2, '({s} {v})'),
(3, '({v}{s})'),
(4, '({v} {s})'),
(5, '{s}-{v}'),
(6, '{s} -{v}'),
(7, '-{s}{v}'),
(8, '- {s}{v}'),
(9, '-{s} {v}'),
(10, '- {s} {v}'),
(11, '-{v}{s}'),
(12, '- {v}{s}'),
(13, '-{v} {s}'),
(14, '- {v} {s}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]negative_formats`
--

CREATE TABLE `[[dbprefix]]negative_formats` (
  `negative_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `format` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`negative_format_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]negative_formats`
--

INSERT INTO `[[dbprefix]]negative_formats` VALUES
(1, '(%s)'),
(2, '-%s'),
(3, '- %s'),
(4, '%s-'),
(5, '%s -');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news`
--

CREATE TABLE `[[dbprefix]]news` (
  `news_id` int(11) NOT NULL AUTO_INCREMENT,
  `news_title` varchar(255) DEFAULT NULL,
  `news_link` varchar(255) DEFAULT NULL,
  `news_content` longtext,
  `news_category` varchar(50) DEFAULT NULL,
  `news_date` int(11) DEFAULT NULL,
  `news_type` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`news_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_letters`
--

CREATE TABLE `[[dbprefix]]newsletter_letters` (
  `letter_id` int(11) NOT NULL AUTO_INCREMENT,
  `letter_subject` varchar(255) NOT NULL DEFAULT '',
  `letter_from_name` varchar(255) NOT NULL DEFAULT '',
  `letter_from_email` varchar(100) NOT NULL DEFAULT '',
  `letter_html` longtext,
  `letter_text` longtext,
  `letter_sent_date` datetime DEFAULT NULL,
  `letter_creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`letter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_settings`
--

CREATE TABLE `[[dbprefix]]newsletter_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_temp`
--

CREATE TABLE `[[dbprefix]]newsletter_temp` (
  `recipient_id` int(11) NOT NULL AUTO_INCREMENT,
  `recipient_num` int(11) NOT NULL DEFAULT '0',
  `recipient_value` varchar(255) NOT NULL DEFAULT '',
  `key_unsubscribe` varchar(32) NOT NULL DEFAULT '',
  `lng` char(2) DEFAULT NULL,
  PRIMARY KEY (`recipient_id`),
  KEY `IDX_num` (`recipient_num`,`recipient_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_topics`
--

CREATE TABLE `[[dbprefix]]newsletter_topics` (
  `letter_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  UNIQUE KEY `UNQ_topic` (`letter_id`,`topic_id`),
  KEY `IDX_topic` (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_unsubscribe`
--

CREATE TABLE `[[dbprefix]]newsletter_unsubscribe` (
  `key_unsubscribe` varchar(32) NOT NULL,
  `delivery_num` int(11) NOT NULL,
  `letter_id` int(11) NOT NULL,
  `email_id` int(11) NOT NULL,
  `topics_ids` varchar(255) NOT NULL,
  PRIMARY KEY (`key_unsubscribe`),
  KEY `IDX_num` (`delivery_num`,`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]news_settings`
--

CREATE TABLE `[[dbprefix]]news_settings` (
  `news_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) DEFAULT NULL,
  `stting_type` varchar(10) DEFAULT NULL,
  `setting_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`news_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]news_settings`
--

INSERT INTO `[[dbprefix]]news_settings` VALUES
(1, 'news_display_count', 'integer', '1'),
(2, 'news_max_count', 'integer', '10'),
(3, 'news_last_build_date', 'integer', '1480330074'),
(4, 'news_ttl', 'integer', '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `notification_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_action_id` int(11) DEFAULT NULL,
  `notification_name` varchar(255) DEFAULT NULL,
  `notification_subject` varchar(255) DEFAULT NULL,
  `notification_body` longtext,
  `notification_from_email_custom_address` varchar(50) DEFAULT '',
  `notification_from_email_admin_id` int(11) DEFAULT NULL,
  `notification_from_email_code` varchar(50) DEFAULT NULL,
  `notification_active` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `IDX_na` (`notification_action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]notifications`
--

INSERT INTO `[[dbprefix]]notifications` VALUES
(1, 1, 'New Order', '{StoreOwnerName}. Your order #{OrderID}', 'Dear {CustomerFirstname} {CustomerLastname},\n\nThank you for making your order.  Your order''s details are provided below.\n\n-----------------------------------------------------\nPurchasing Information:\n-----------------------------------------------------\nE-mail Address: {CustomerEmail}\n\nBilling Address:\n----------------\n{BillingFirstname} {BillingLastname}\n{BillingStreetline1}\n{BillingStreetline2}\n{BillingCity}, {BillingState}, {BillingPostcode}\n{BillingCountry}\n{BillingPhone}\n\nComment:\n{BillingCommentLine}\n\n\nShipping Address:\n-----------------\n{ShippingFirstname} {ShippingLastname}\n{ShippingStreetline1}\n{ShippingStreetline2}\n{ShippingCity}, {ShippingState}, {ShippingPostcode}\n{ShippingCountry}\n{ShippingPhone}\n\nComment:\n{ShippingCommentLine}\n\n-----------------------------------------------------\nOrder Summary:\n-----------------------------------------------------\nOrder #: {OrderID}\nPayment Method: {OrderPaymentMethod}\nAdditional payment information :\n {OrderPaymentMethodText}\nShipping Method: {OrderShippingMethod}\n\nItems:\n----------\n{OrderContentBlock}\nSubtotal of Items: {OrderSubtotal}\n{OrderDiscountsBlock}\nShipping & Handling: {OrderTotalShippingAndHandlingCost}\n{OrderTax}\n\nTax Exemption: {OrderTaxExptMark}\nAmount: {OrderTaxExptAmount}\nCustomer Input: {OrderTaxExptInput}\n--------------\nTotal for this Order: {OrderTotal}\n\nThanks again for shopping with us.\n\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(2, 2, 'Order Shipped', '{StoreOwnerName}. Your order shipped #{OrderID}', 'Greetings from {StoreOwnerName},\n\nPlease be informed that we have shipped your items, and that this completes your order.\n\nThe following items have been shipped to you by {StoreOwnerName}:\n\n-----------------------------------------------------\nOrder Summary:\n-----------------------------------------------------\nOrder #: {OrderID}\nPayment Method: {OrderPaymentMethod}\nShipping Method: {OrderShippingMethod}\nTracking Number: {TrackingNumber}\n\nItems:\n----------\n{OrderContentBlock}\nSubtotal of Items: {OrderSubtotal}\n{OrderDiscountsBlock}\nShipping & Handling: {OrderTotalShippingAndHandlingCost}\n{OrderTax}\n--------------\nTotal for this Order: {OrderTotal}\n\nThis shipment was sent to:\n--------------------------\n{ShippingFirstname} {ShippingLastname}\n{ShippingStreetline1}\n{ShippingStreetline2}\n{ShippingCity}, {ShippingState}, {ShippingPostcode}\n{ShippingCountry}\n{ShippingPhone}\n\nComment:\n{ShippingCommentLine}\n\nPlease note: This e-mail was sent from a notification-only address that cannot accept incoming e-mail. Please do not reply to this message.\n\nThank you for shopping with us.\n\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(3, 2, 'Order Status Changed', '{StoreOwnerName}. Your order (#{OrderID}) status has been changed to {OrderStatus}', 'Greetings from {StoreOwnerName},\n\nWe thought you''d like to know that the status of your order has been changed from {OrderOldStatus} to {OrderStatus}.\n\n-----------------------------------------------------\nPurchasing Information:\n-----------------------------------------------------\nE-mail Address: {CustomerEmail}\n\nBilling Address:\n----------------\n{BillingFirstname} {BillingLastname}\n{BillingStreetline1}\n{BillingStreetline2}\n{BillingCity}, {BillingState}, {BillingPostcode}\n{BillingCountry}\n{BillingPhone}\n\nShipping Address:\n-----------------\n{ShippingFirstname} {ShippingLastname}\n{ShippingStreetline1}\n{ShippingStreetline2}\n{ShippingCity}, {ShippingState}, {ShippingPostcode}\n{ShippingCountry}\n{ShippingPhone}\n\nComment:\n{ShippingCommentLine}\n\n-----------------------------------------------------\nOrder Summary:\n-----------------------------------------------------\nOrder #: {OrderID}\nPayment Method: {OrderPaymentMethod}\nShipping Method: {OrderShippingMethod}\n\nItems:\n----------\n{OrderContentBlock}\nSubtotal of Items: {OrderSubtotal}\n{OrderDiscountsBlock}\nShipping & Handling: {OrderTotalShippingAndHandlingCost}\n{OrderTax}\n--------------\nTotal for this Order: {OrderTotal}\n\nThanks again for shopping with us.\n\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(4, 3, 'Payment Received', '{StoreOwnerName}. Important Notice: We have received your payment for order #{OrderID}', 'Greetings from {StoreOwnerName},\n\nWe thought you''d like to know that we have received your payment for order (#{OrderID}).\n-----------------------------------------------------\nPurchasing Information:\n-----------------------------------------------------\nE-mail Address: {CustomerEmail}\n\nBilling Address:\n----------------\n{BillingFirstname} {BillingLastname}\n{BillingStreetline1}\n{BillingStreetline2}\n{BillingCity}, {BillingState}, {BillingPostcode}\n{BillingCountry}\n{BillingPhone}\n\nComment:\n{BillingCommentLine}\n\n\nShipping Address:\n-----------------\n{ShippingFirstname} {ShippingLastname}\n{ShippingStreetline1}\n{ShippingStreetline2}\n{ShippingCity}, {ShippingState}, {ShippingPostcode}\n{ShippingCountry}\n{ShippingPhone}\n\nComment:\n{ShippingCommentLine}\n\n-----------------------------------------------------\nOrder Summary:\n-----------------------------------------------------\nOrder #: {OrderID}\nPayment Method: {OrderPaymentMethod}\n\nItems:\n----------\n{OrderContentBlock}\nSubtotal of Items: {OrderSubtotal}\n{OrderDiscountsBlock}\nShipping & Handling: {OrderTotalShippingAndHandlingCost}\n{OrderTax}\n--------------\nTotal for this Order: {OrderTotal}\n\nThanks again for shopping with us.\n\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(5, 4, 'Low Stock Levels', '{StoreOwnerName}. Low Stock Levels.', 'Low stock levels have been registered for the following products.\n----------------------------------------------\n{LowLevelProductsBlock}\n----------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(6, 5, 'Digital Products/E-Goods', '{StoreOwnerName}. Digital Products Ordered.', 'Dear {CustomerFirstname} {CustomerLastname},\n\nWe have received your payment for order (#{OrderID}).\n-----------------------------------------------------\n\nTo download the ordered packages, please use the following link(s):\n\n{OrderDownloadLinksBlock}\n\n----------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(7, 6, 'A new account has been registered', '{StoreOwnerWebsite}. Your account has been registered.', 'Dear {CustomerFirstname},\n\nYou have successfully registered with {StoreOwnerWebsite}.\n\nAccount Name: {AccountName}\nFirst Name: {CustomerFirstname}\nLast Name: {CustomerLastname}\n\nThank you for visiting our store!\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(8, 7, 'The customer must activate their account', '{StoreOwnerName}. Important Notice: You must activate your account.', 'Dear {CustomerFirstname},\n\nYou must activate the account {AccountName} to be able to use it.\n\nTo do so, please click the following link:\n{AccountActivationLink}\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(9, 8, 'An administrator must activate a customer account', '{StoreOwnerName}. Important Notice: An account needs to be activated.', 'Dear Administrator,\n\nA customer has registered with your website.\n\nTheir account needs to be activated.\n\nAccount Name: {AccountName}\nFirst Name: {CustomerFirstname}\nLast Name: {CustomerLastname}\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(10, 9, 'Customer has activated their account', '{StoreOwnerName}. You have successfully activated your account {AccountName}.', 'Dear {CustomerFirstname},\n\nYou have successfully activated your account {AccountName} on our website {StoreOwnerWebsite}\n\nThank you for visiting our store!\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(11, 10, 'Administrator activated a customer''s account', 'An administrator has activated your account.', 'Dear {CustomerFirstname},\n\nYour account {AccountName} has been activated at our  website {StoreOwnerWebsite}\n\nThank you for visiting our store!\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(12, 11, 'An administrator has reset the customer account''s password', '{StoreOwnerName}. Important Notice: An administrator has reset your password.', 'Dear {CustomerFirstname},\n\nThe password for your account {AccountName} has been reset.\n\nClick the link below to set your new password.\n{AccountNewPasswordLink}\n\nIf clicking doesn''t seem to work, you can copy and paste the link into your browser''s address window, or retype it there.\n\nThank you for visiting our store!\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(13, 12, 'Customer has reset their account''s password', '{StoreOwnerName}. Important Notice: Your account''s password has been reset.', 'Dear {CustomerFirstname},\n\nThe password for your account {AccountName} has been reset.\n\nClick the link below to set your new password.\n{AccountNewPasswordLink}\n\nIf clicking doesn''t seem to work, you can copy and paste the link into your browser''s address window, or retype it there.\n\nThank you for visiting our store!\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(14, 13, 'Account created automatically', 'Account created automatically', 'Greetings,\n\nWe received an order linked with your e-mail. If you made this order, please follow the instructions below. If you did not make this order at our online store, you can safely ignore this e-mail.\n\nFor each new customer our store creates a customer account. With this customer account you can continue to make orders online without providing billing and shipping information a second time. Also, you can review the status of all your online orders.\n\nClick the link below to activate your customer account {AccountName} and set your password.\n\n{AccountNewPasswordLink}\n\nIf clicking doesn''t seem to work, you can copy and paste the link into your browser''s address window, or retype it there.\n\nThank you for visiting our store!\n\n-------------------------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}\n-------------------------------------------------------------', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(15, 14, 'Product Options Inventory: Low Stock Level', '{StoreOwnerName}. Product Options Inventory: Low Stock Level.', 'Low stock levels have been registered for the following product.\n----------------------------------------------\nProduct: {ProductName}\nCombination SKU: {CombinationSKU}\nCombination: {CombinationDescription}\nCombination Quantity In Stock: {CombinationQuantityInStock}\n----------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(16, 15, 'Customer Review Posted', '{StoreOwnerName}. New customer review posted.', 'A new customer review has been posted\n----------------------------------------------\nDate: {CustomerReviewDate} {CustomerReviewTime}\nIP: {CustomerReviewIP}\n\nProductID : {ProductID}\nProduct: {ProductName}\nSKU: {ProductSKU}\n\nAverage Rating: {CustomerReviewOverallRating}\nReview:\n{CustomerReviewText}\n\n----------------------------------------------\n{StoreOwnerName}\n{StoreOwnerWebsite}', '', NULL, 'EMAIL_STORE_OWNER', 'checked'),
(17, 16, 'Gift Certificate Purchased', 'Gift Certificates', '{StoreOwnerName}. Gift Certificates Created\r\nDear {GiftCertificateRecipient},\r\n\r\nYou have a gift certificate.\r\n-----------------------------------------------------\r\n\r\n{OrderedGiftCertificateBlock}\r\n\r\n----------------------------------------------\r\n{StoreOwnerName}\r\n{StoreOwnerWebsite}', 'owner@avactis-demo.com', 0, 'EMAIL_STORE_OWNER', 'checked'),
(18, 17, 'Gift Certificates', '{StoreOwnerName}. Gift Certificate Created', 'Dear {GiftCertificateRecipient},\r\n\r\nGift Certificate was issued\r\n-----------------------------------------------------\r\n\r\n{OrderedGiftCertificateBlock}\r\n\r\n----------------------------------------------\r\n{StoreOwnerName}\r\n{StoreOwnerWebsite}', 'owner@avactis-demo.com', 0, 'EMAIL_STORE_OWNER', 'checked');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_actions`
--

CREATE TABLE `[[dbprefix]]notification_actions` (
  `notification_action_id` int(11) NOT NULL AUTO_INCREMENT,
  `action_code` varchar(255) DEFAULT NULL,
  `action_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`notification_action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

--
-- Dumping data for table `[[dbprefix]]notification_actions`
--

INSERT INTO `[[dbprefix]]notification_actions` VALUES
(1, 'NewOrder', 'New Order Placed'),
(2, 'OrderStatusChanged', 'Order Status Changed'),
(3, 'PaymentStatusChanged', 'Payment Status Changed'),
(4, 'ProductLowLevelInStock', 'Low Level in Stock'),
(5, 'DigitalProductsOrdered', 'Digital Products/E-Goods Ordered'),
(6, 'CustomerAccountRegistered', 'New customer registration'),
(7, 'CustomerShouldActivateSelf', 'Customer must activate their account'),
(8, 'AdminShouldActivateCustomer', 'Administrator must activate customer account'),
(9, 'CustomerActivateSelf', 'Customer has activated their account'),
(10, 'AdminActivateCustomer', 'Administrator has activated customer account'),
(11, 'AdminDropCustomerPassword', 'Administrator has reset customer account''s password'),
(12, 'CustomerDropPassword', 'Customer has reset their account''s password'),
(13, 'CustomerAccountWasAutoCreated', 'Account created automatically'),
(14, 'InventoryLowLevelInStock', 'Product Options Inventory: Low Stock Level'),
(15, 'CustomerReviewPosted', 'A new customer review has been posted'),
(16, 'GiftCertificateOrdered', 'Gift Certificate Purchased'),
(17, 'GiftCertificateCreated', 'Gift Certificate Created');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_action_options`
--

CREATE TABLE `[[dbprefix]]notification_action_options` (
  `notification_action_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_action_id` int(11) DEFAULT NULL,
  `option_name` varchar(255) DEFAULT NULL,
  `option_input_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`notification_action_option_id`),
  KEY `IDX_na` (`notification_action_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]notification_action_options`
--

INSERT INTO `[[dbprefix]]notification_action_options` VALUES
(1, 2, 'NTFCTN_ACTION_OPTION_001', 'checkbox'),
(2, 3, 'NTFCTN_ACTION_OPTION_002', 'checkbox');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_action_option_values`
--

CREATE TABLE `[[dbprefix]]notification_action_option_values` (
  `notification_action_option_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_action_option_id` int(11) DEFAULT NULL,
  `option_value_name` varchar(255) DEFAULT NULL,
  `option_key` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`notification_action_option_value_id`),
  KEY `IDX_nao` (`notification_action_option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]notification_action_option_values`
--

INSERT INTO `[[dbprefix]]notification_action_option_values` VALUES
(1, 1, 'ORDER_STATUS_001', '1'),
(2, 1, 'ORDER_STATUS_002', '2'),
(3, 1, 'ORDER_STATUS_003', '3'),
(4, 1, 'ORDER_STATUS_004', '4'),
(5, 1, 'ORDER_STATUS_005', '5'),
(6, 1, 'ORDER_STATUS_006', '6'),
(7, 1, 'ORDER_STATUS_007', '7'),
(8, 2, 'ORDER_PAYMENT_STATUS_001', '1'),
(9, 2, 'ORDER_PAYMENT_STATUS_002', '2'),
(10, 2, 'ORDER_PAYMENT_STATUS_003', '3');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_blocktags`
--

CREATE TABLE `[[dbprefix]]notification_blocktags` (
  `notification_blocktag_id` int(11) NOT NULL AUTO_INCREMENT,
  `blocktag_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`notification_blocktag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]notification_blocktags`
--

INSERT INTO `[[dbprefix]]notification_blocktags` VALUES
(1, '{OrderContentBlock}'),
(2, '{LowLevelProductsBlock}'),
(3, '{OrderDiscountsBlock}'),
(4, '{OrderDownloadLinksBlock}'),
(5, '{OrderedGiftCertificateBlock}'),
(6, '{AppliedGiftCertificateBlock}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_blocktag_bodies`
--

CREATE TABLE `[[dbprefix]]notification_blocktag_bodies` (
  `notification_blocktag_body_id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_blocktag_id` int(11) DEFAULT NULL,
  `notification_id` int(11) DEFAULT NULL,
  `blocktag_body` longtext,
  PRIMARY KEY (`notification_blocktag_body_id`),
  KEY `IDX_nb` (`notification_blocktag_id`),
  KEY `IDX_n` (`notification_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]notification_blocktag_bodies`
--

INSERT INTO `[[dbprefix]]notification_blocktag_bodies` VALUES
(1, 1, 1, '{ProductSKU} {ProductName}\nPrice: {ProductSalePrice}\nQty: {ProductQuantity}\nAmount: {ProductAmount}\nOptions:\n{ProductOptions}\n'),
(2, 3, 1, 'Global Discount: {OrderGlobalDiscount}\nPromo Code Discount: {OrderPromoCodeDiscount}\nQuantity Discount: {OrderQuantityDiscount}\nDiscounted Subtotal: {OrderDiscountedSubtotal}\nPrepaid By Gift Certificate: {OrderTotalPrepaidByGC}\nOrder Total to Pay: {OrderTotalToPay}\n'),
(3, 1, 2, '{ProductSKU} {ProductName}\nPrice: {ProductSalePrice}\nQty: {ProductQuantity}\nAmount: {ProductAmount}\nOptions:\n{ProductOptions}\n'),
(4, 3, 2, 'Global Discount: {OrderGlobalDiscount}\nPromo Code Discount: {OrderPromoCodeDiscount}\nQuantity Discount: {OrderQuantityDiscount}\nDiscounted Subtotal: {OrderDiscountedSubtotal}\nPrepaid By Gift Certificate: {OrderTotalPrepaidByGC}\nOrder Total to Pay: {OrderTotalToPay}\n'),
(5, 1, 3, '{ProductSKU} {ProductName}\nPrice: {ProductSalePrice}\nQty: {ProductQuantity}\nAmount: {ProductAmount}\nOptions:\n{ProductOptions}\n'),
(6, 3, 3, 'Global Discount: {OrderGlobalDiscount}\nPromo Code Discount: {OrderPromoCodeDiscount}\nQuantity Discount: {OrderQuantityDiscount}\nDiscounted Subtotal: {OrderDiscountedSubtotal}\nPrepaid By Gift Certificate: {OrderTotalPrepaidByGC}\nOrder Total to Pay: {OrderTotalToPay}\n'),
(7, 1, 4, '{ProductSKU} {ProductName}\nPrice: {ProductSalePrice}\nQty: {ProductQuantity}\nAmount: {ProductAmount}\nOptions:\n{ProductOptions}\n'),
(8, 3, 4, 'Global Discount: {OrderGlobalDiscount}\nPromo Code Discount: {OrderPromoCodeDiscount}\nQuantity Discount: {OrderQuantityDiscount}\nDiscounted Subtotal: {OrderDiscountedSubtotal}\nPrepaid By Gift Certificate: {OrderTotalPrepaidByGC}\nOrder Total to Pay: {OrderTotalToPay}\n'),
(9, 2, 5, '{ProductSKU} {ProductName}\nPrice: {ProductSalePrice}\nQuantity In Stock: {ProductQuantityInStock}\n'),
(10, 4, 6, 'File: {DownloadFilename}\nDescription: {DownloadFileDescription}\nLink: {DownloadLink}\n\nThis link will be valid until {DownloadLinkExpiryDate}. You may use this link for up to {DownloadLinkAttempts} downloads. After that the link will be disabled.\n--------------\n'),
(11, 6, 1, 'Gift Certificate: {AppliedGiftCertificateCode}\nType: {AppliedGiftCertificateType}\nFrom: {AppliedGiftCertificateFrom}\nTo: {AppliedGiftCertificateTo}\nMessage: {AppliedGiftCertificateMessage}\nAmount: {AppliedGiftCertificateAmount}\n\n--------------'),
(12, 6, 2, 'Gift Certificate: {AppliedGiftCertificateCode}\nType: {AppliedGiftCertificateType}\nFrom: {AppliedGiftCertificateFrom}\nTo: {AppliedGiftCertificateTo}\nMessage: {AppliedGiftCertificateMessage}\nAmount: {AppliedGiftCertificateAmount}\n\n--------------'),
(13, 6, 3, 'Gift Certificate: {AppliedGiftCertificateCode}\nType: {AppliedGiftCertificateType}\nFrom: {AppliedGiftCertificateFrom}\nTo: {AppliedGiftCertificateTo}\nMessage: {AppliedGiftCertificateMessage}\nAmount: {AppliedGiftCertificateAmount}\n\n--------------'),
(14, 6, 4, 'Gift Certificate: {AppliedGiftCertificateCode}\nType: {AppliedGiftCertificateType}\nFrom: {AppliedGiftCertificateFrom}\nTo: {AppliedGiftCertificateTo}\nMessage: {AppliedGiftCertificateMessage}\nAmount: {AppliedGiftCertificateAmount}\n\n--------------'),
(15, 5, 7, 'Gift Certificate: {PurchasedGiftCertificateCode}\nFrom: {PurchasedGiftCertificateFrom}\nTo: {PurchasedGiftCertificateTo}\nMessage: {PurchasedGiftCertificateMessage}\nAmount: {PurchasedGiftCertificateAmount}\n\nYou can apply this gift certificate on shopping cart page\n--------------\n'),
(16, 5, 8, 'Gift Certificate: {PurchasedGiftCertificateCode}\nFrom: {PurchasedGiftCertificateFrom}\nTo: {PurchasedGiftCertificateTo}\nMessage: {PurchasedGiftCertificateMessage}\nAmount: {PurchasedGiftCertificateAmount}\n\nYou can apply this gift certificate on shopping cart page\n--------------\n'),
(17, 5, 17, 'Gift Certificate: {PurchasedGiftCertificateCode}\r\nFrom: {PurchasedGiftCertificateFrom}\r\nTo: {PurchasedGiftCertificateTo}\r\nMessage: {PurchasedGiftCertificateMessage}\r\nAmount: {PurchasedGiftCertificateAmount}\r\n\r\n'),
(18, 5, 18, 'Gift Certificate: {PurchasedGiftCertificateCode}\nFrom: {PurchasedGiftCertificateFrom}\nTo: {PurchasedGiftCertificateTo}\nMessage: {PurchasedGiftCertificateMessage}\nAmount: {PurchasedGiftCertificateAmount}\n\nYou can apply this gift certificate on shopping cart page\n--------------\n');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_infotags`
--

CREATE TABLE `[[dbprefix]]notification_infotags` (
  `notification_infotag_id` int(11) NOT NULL AUTO_INCREMENT,
  `infotag_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`notification_infotag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=115 ;

--
-- Dumping data for table `[[dbprefix]]notification_infotags`
--

INSERT INTO `[[dbprefix]]notification_infotags` VALUES
(1, '{ProductID}'),
(2, '{ProductName}'),
(3, '{ProductQuantity}'),
(4, '{ProductSalePrice}'),
(5, '{ProductListPrice}'),
(6, '{ProductSKU}'),
(7, '{ProductPerItemShippingCost}'),
(8, '{ProductPerItemHandlingCost}'),
(9, '{ProductWeight}'),
(10, '{ProductFreeShipping}'),
(11, '{ProductAmount}'),
(12, '{ProductOptions}'),
(13, '{ProductQuantityInStock}'),
(14, '{ProductManufacturer}'),
(15, '{OrderID}'),
(16, '{OrderDate}'),
(17, '{OrderStatus}'),
(18, '{OrderOldStatus}'),
(19, '{OrderPaymentStatus}'),
(20, '{OrderOldPaymentStatus}'),
(21, '{OrderPaymentMethod}'),
(22, '{OrderPaymentMethodText}'),
(23, '{OrderShippingMethod}'),
(24, '{OrderSubtotal}'),
(25, '{OrderGlobalDiscount}'),
(26, '{OrderPromoCode}'),
(27, '{OrderPromoCodeDiscount}'),
(28, '{OrderQuantityDiscount}'),
(29, '{OrderDiscountedSubtotal}'),
(30, '{OrderTotalShippingAndHandlingCost}'),
(31, '{OrderTax}'),
(32, '{OrderTaxExptMark}'),
(33, '{OrderTaxExptAmount}'),
(34, '{OrderTaxExptInput}'),
(35, '{OrderTotal}'),
(36, '{TrackingNumber}'),
(37, '{CustomerFirstname}'),
(38, '{CustomerLastname}'),
(39, '{CustomerEmail}'),
(40, '{CustomerStreetline1}'),
(41, '{CustomerStreetline2}'),
(42, '{CustomerCity}'),
(43, '{CustomerState}'),
(44, '{CustomerPostcode}'),
(45, '{CustomerCountry}'),
(46, '{CustomerPhone}'),
(47, '{BillingFirstname}'),
(48, '{BillingLastname}'),
(49, '{BillingEmail}'),
(50, '{BillingStreetline1}'),
(51, '{BillingStreetline2}'),
(52, '{BillingCity}'),
(53, '{BillingState}'),
(54, '{BillingPostcode}'),
(55, '{BillingCountry}'),
(56, '{BillingPhone}'),
(57, '{BillingCommentLine}'),
(58, '{BillingCommentArea}'),
(59, '{ShippingFirstname}'),
(60, '{ShippingLastname}'),
(61, '{ShippingEmail}'),
(62, '{ShippingStreetline1}'),
(63, '{ShippingStreetline2}'),
(64, '{ShippingCity}'),
(65, '{ShippingState}'),
(66, '{ShippingPostcode}'),
(67, '{ShippingCountry}'),
(68, '{ShippingPhone}'),
(69, '{ShippingCommentLine}'),
(70, '{ShippingCommentArea}'),
(71, '{StoreOwnerName}'),
(72, '{StoreOwnerWebsite}'),
(73, '{StoreOwnerPhones}'),
(74, '{StoreOwnerFax}'),
(75, '{StoreOwnerStreetLine1}'),
(76, '{StoreOwnerStreetLine2}'),
(77, '{StoreOwnerCity}'),
(78, '{StoreOwnerState}'),
(79, '{StoreOwnerPostcode}'),
(80, '{StoreOwnerCountry}'),
(81, '{StoreOwnerEmail}'),
(82, '{StoreOwnerSiteAdministratorEmail}'),
(83, '{StoreOwnerOrdersDepartmentEmail}'),
(84, '{DownloadLink}'),
(85, '{DownloadLinkExpiryDate}'),
(86, '{DownloadLinkAttempts}'),
(87, '{DownloadFilename}'),
(88, '{DownloadFileDescription}'),
(89, '{AccountName}'),
(90, '{AccountActivationLink}'),
(91, '{AccountNewPasswordLink}'),
(92, '{CombinationSKU}'),
(93, '{CombinationQuantityInStock}'),
(94, '{CombinationDescription}'),
(95, '{CustomerReviewAuthor}'),
(96, '{CustomerReviewDate}'),
(97, '{CustomerReviewTime}'),
(98, '{CustomerReviewIP}'),
(99, '{CustomerReviewText}'),
(100, '{CustomerReviewStatus}'),
(101, '{CustomerReviewOverallRating}'),
(102, '{PurchasedGiftCertificateCode}'),
(103, '{PurchasedGiftCertificateMessage}'),
(104, '{PurchasedGiftCertificateAmount}'),
(105, '{PurchasedGiftCertificateFrom}'),
(106, '{PurchasedGiftCertificateTo}'),
(107, '{PurchasedGiftCertificateType}'),
(108, '{AppliedGiftCertificateCode}'),
(109, '{AppliedGiftCertificateMessage}'),
(110, '{AppliedGiftCertificateAmount}'),
(111, '{AppliedGiftCertificateFrom}'),
(112, '{AppliedGiftCertificateTo}'),
(113, '{AppliedGiftCertificateType}'),
(114, '{GiftCertificateRecipient}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_send_to`
--

CREATE TABLE `[[dbprefix]]notification_send_to` (
  `notification_id` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `email_code` varchar(50) DEFAULT NULL,
  KEY `IDX_n` (`notification_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]notification_send_to`
--

INSERT INTO `[[dbprefix]]notification_send_to` VALUES
(1, '', 'EMAIL_CUSTOMER'),
(1, '', 'EMAIL_STORE_OWNER'),
(2, '', 'EMAIL_CUSTOMER'),
(2, '', 'EMAIL_STORE_OWNER'),
(3, '', 'EMAIL_CUSTOMER'),
(3, '', 'EMAIL_STORE_OWNER'),
(4, '', 'EMAIL_CUSTOMER'),
(4, '', 'EMAIL_STORE_OWNER'),
(5, '', 'EMAIL_STORE_OWNER'),
(6, '', 'EMAIL_CUSTOMER'),
(6, '', 'EMAIL_STORE_OWNER'),
(7, '', 'EMAIL_CUSTOMER'),
(7, '', 'EMAIL_STORE_OWNER'),
(8, '', 'EMAIL_CUSTOMER'),
(9, '', 'EMAIL_STORE_OWNER'),
(10, '', 'EMAIL_CUSTOMER'),
(10, '', 'EMAIL_STORE_OWNER'),
(11, '', 'EMAIL_CUSTOMER'),
(11, '', 'EMAIL_STORE_OWNER'),
(12, '', 'EMAIL_CUSTOMER'),
(12, '', 'EMAIL_STORE_OWNER'),
(13, '', 'EMAIL_CUSTOMER'),
(14, '', 'EMAIL_CUSTOMER'),
(14, '', 'EMAIL_STORE_OWNER'),
(15, '', 'EMAIL_STORE_OWNER'),
(16, '', 'EMAIL_STORE_OWNER'),
(17, '', 'EMAIL_CUSTOMER'),
(18, '', 'EMAIL_CUSTOMER');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]options`
--

CREATE TABLE `[[dbprefix]]options` (
  `option_id` int(11) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(256) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(16) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]options`
--

INSERT INTO `[[dbprefix]]options` VALUES
(1, 'analyticscode', '', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]option_values_to_notification`
--

CREATE TABLE `[[dbprefix]]option_values_to_notification` (
  `notification_action_option_value_id` int(11) DEFAULT NULL,
  `notification_id` int(11) DEFAULT NULL,
  `value` varchar(20) DEFAULT NULL,
  KEY `IDX_naov` (`notification_action_option_value_id`),
  KEY `IDX_n` (`notification_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]option_values_to_notification`
--

INSERT INTO `[[dbprefix]]option_values_to_notification` VALUES
(1, 2, 'false'),
(2, 2, 'false'),
(3, 2, 'false'),
(4, 2, 'true'),
(5, 2, 'false'),
(6, 2, 'false'),
(7, 2, 'false'),
(1, 3, 'false'),
(2, 3, 'true'),
(3, 3, 'true'),
(4, 3, 'false'),
(5, 3, 'true'),
(6, 3, 'true'),
(7, 3, 'true'),
(8, 4, 'false'),
(9, 4, 'true'),
(10, 4, 'false');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `order_payment_status_id` int(11) NOT NULL DEFAULT '0',
  `order_payment_method` varchar(255) DEFAULT NULL,
  `order_payment_module_id` varchar(255) NOT NULL DEFAULT '',
  `order_payment_method_detail` varchar(255) DEFAULT NULL,
  `order_payment_processor_order_id` varchar(255) DEFAULT NULL,
  `order_shipping_method` varchar(255) DEFAULT NULL,
  `order_track_id` text,
  `order_person_id` int(11) DEFAULT NULL,
  `affiliate_id` varchar(255) NOT NULL DEFAULT '',
  `was_manually_edited` int(11) DEFAULT '0',
  `display_included_tax` int(11) DEFAULT '0',
  `is_order_new_type` int(11) DEFAULT '1',
  PRIMARY KEY (`order_id`),
  KEY `IDX_date` (`order_date`),
  KEY `status_id` (`order_status_id`),
  KEY `person_id` (`order_person_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_full_tax_exempts`
--

CREATE TABLE `[[dbprefix]]order_full_tax_exempts` (
  `order_id` int(11) NOT NULL DEFAULT '0',
  `exempt_status` char(5) NOT NULL DEFAULT '0',
  `exempt_reason_customer_input` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_gc`
--

CREATE TABLE `[[dbprefix]]order_gc` (
  `gc_ord_id` int(11) NOT NULL AUTO_INCREMENT,
  `gc_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `gc_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`gc_ord_id`),
  KEY `IDX_gc_id` (`gc_id`),
  KEY `IDX_order_id` (`order_id`),
  KEY `IDX_gc_code` (`gc_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_notes`
--

CREATE TABLE `[[dbprefix]]order_notes` (
  `order_id` int(11) NOT NULL DEFAULT '0',
  `order_note_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_microtime` varchar(50) DEFAULT '0',
  `order_note_content` longtext NOT NULL,
  `order_note_type` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_payment_status`
--

CREATE TABLE `[[dbprefix]]order_payment_status` (
  `order_payment_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_payment_status_name` varchar(50) NOT NULL DEFAULT '',
  `order_payment_status_description` varchar(255) DEFAULT NULL,
  `order_payment_status_sort` int(11) DEFAULT NULL,
  `order_payment_status_type` varchar(20) NOT NULL DEFAULT 'custom',
  `order_payment_status_active` char(5) DEFAULT NULL,
  PRIMARY KEY (`order_payment_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]order_payment_status`
--

INSERT INTO `[[dbprefix]]order_payment_status` VALUES
(1, 'ORDER_PAYMENT_STATUS_001', 'ORDER_PAYMENT_STATUS_DESCR_001', 1, 'custom', NULL),
(2, 'ORDER_PAYMENT_STATUS_002', 'ORDER_PAYMENT_STATUS_DESCR_002', 2, 'custom', NULL),
(3, 'ORDER_PAYMENT_STATUS_003', 'ORDER_PAYMENT_STATUS_DESCR_003', 3, 'custom', NULL),
(4, 'ORDER_PAYMENT_STATUS_004', 'ORDER_PAYMENT_STATUS_DESCR_004', 4, 'custom', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_person_data`
--

CREATE TABLE `[[dbprefix]]order_person_data` (
  `order_person_data_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `person_info_variant_id` int(11) NOT NULL DEFAULT '0',
  `person_attribute_id` int(11) NOT NULL DEFAULT '0',
  `order_person_data_name` varchar(255) NOT NULL DEFAULT '',
  `order_person_data_value` varchar(255) DEFAULT NULL,
  `order_person_data_description` varchar(255) DEFAULT NULL,
  `order_person_data_b_encrypted` int(11) NOT NULL DEFAULT '0',
  `order_person_data_encrypted_secret_key` text,
  `order_person_data_rsa_public_key_asc_format` text,
  PRIMARY KEY (`order_person_data_id`),
  KEY `IDX_unique` (`order_id`,`person_info_variant_id`,`person_attribute_id`,`order_person_data_b_encrypted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_prices`
--

CREATE TABLE `[[dbprefix]]order_prices` (
  `order_id` int(11) NOT NULL,
  `currency_code` varchar(5) DEFAULT NULL,
  `currency_type` enum('CURRENCY_TYPE_MAIN_STORE_CURRENCY','CURRENCY_TYPE_CUSTOMER_SELECTED','CURRENCY_TYPE_PAYMENT_GATEWAY') NOT NULL,
  `order_total_to_pay` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `order_total_paid_by_gc` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `order_total` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `order_subtotal` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `minimum_shipping_cost` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `free_shipping_for_orders_over` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `free_handling_for_orders_over` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `per_item_shipping_cost_sum` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `per_order_shipping_fee` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `shipping_method_cost` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `total_shipping_charge` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `per_item_handling_cost_sum` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `per_order_handling_fee` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `total_handling_charge` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `total_shipping_and_handling_cost` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `order_tax_total` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `subtotal_global_discount` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `subtotal_promo_code_discount` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `quantity_discount` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `discounted_subtotal` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `order_not_included_tax_total` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `per_order_payment_module_shipping_fee` decimal(20,5) NOT NULL DEFAULT '0.00000',
  UNIQUE KEY `IDX_unique` (`order_id`,`currency_code`),
  KEY `currency_code` (`currency_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_product`
--

CREATE TABLE `[[dbprefix]]order_product` (
  `order_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `order_product_qty` int(11) NOT NULL DEFAULT '1',
  `order_product_name` varchar(255) NOT NULL DEFAULT '',
  `order_product_type` varchar(255) NOT NULL DEFAULT '',
  `order_product_store_id` int(11) DEFAULT NULL,
  `order_product_inventory_id` varchar(255) DEFAULT '',
  PRIMARY KEY (`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_product_custom_attributes`
--

CREATE TABLE `[[dbprefix]]order_product_custom_attributes` (
  `order_product_custom_attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_product_id` int(11) NOT NULL DEFAULT '0',
  `order_product_custom_attribute_tag` varchar(255) NOT NULL DEFAULT '',
  `order_product_custom_attribute_name` varchar(255) NOT NULL DEFAULT '',
  `order_product_custom_attribute_value` longtext,
  PRIMARY KEY (`order_product_custom_attribute_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_product_options`
--

CREATE TABLE `[[dbprefix]]order_product_options` (
  `product_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_product_id` int(11) NOT NULL DEFAULT '0',
  `option_name` varchar(255) NOT NULL DEFAULT '',
  `option_value` longtext,
  `is_file` enum('N','Y') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`product_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_product_to_attributes`
--

CREATE TABLE `[[dbprefix]]order_product_to_attributes` (
  `attribute_id` int(11) NOT NULL DEFAULT '0',
  `currency_code` varchar(5) DEFAULT NULL,
  `currency_type` enum('CURRENCY_TYPE_MAIN_STORE_CURRENCY','CURRENCY_TYPE_CUSTOMER_SELECTED','CURRENCY_TYPE_PAYMENT_GATEWAY') NOT NULL,
  `order_product_id` int(11) NOT NULL DEFAULT '0',
  `order_product_attribute_value` longtext,
  KEY `IDX_attribute_id` (`attribute_id`),
  KEY `IDX_currency_code` (`currency_code`),
  KEY `IDX_order_product_id` (`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_promo_codes`
--

CREATE TABLE `[[dbprefix]]order_promo_codes` (
  `order_id` int(11) NOT NULL DEFAULT '0',
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `coupon_promo_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_status`
--

CREATE TABLE `[[dbprefix]]order_status` (
  `order_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_status_name` varchar(50) NOT NULL DEFAULT '',
  `order_status_description` varchar(255) DEFAULT NULL,
  `order_status_sort` int(11) DEFAULT NULL,
  `order_status_type` varchar(20) NOT NULL DEFAULT 'custom',
  `order_status_active` char(5) DEFAULT NULL,
  PRIMARY KEY (`order_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]order_status`
--

INSERT INTO `[[dbprefix]]order_status` VALUES
(1, 'ORDER_STATUS_001', 'ORDER_STATUS_DESCR_001', 1, 'custom', NULL),
(2, 'ORDER_STATUS_002', 'ORDER_STATUS_DESCR_002', 2, 'custom', NULL),
(3, 'ORDER_STATUS_003', 'ORDER_STATUS_DESCR_003', 3, 'custom', NULL),
(4, 'ORDER_STATUS_004', 'ORDER_STATUS_DESCR_004', 4, 'custom', NULL),
(5, 'ORDER_STATUS_005', 'ORDER_STATUS_DESCR_005', 5, 'custom', NULL),
(6, 'ORDER_STATUS_006', 'ORDER_STATUS_DESCR_006', 6, 'custom', NULL),
(7, 'ORDER_STATUS_007', 'ORDER_STATUS_DESCR_007', 7, 'custom', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_taxes`
--

CREATE TABLE `[[dbprefix]]order_taxes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `currency_code` varchar(5) DEFAULT NULL,
  `currency_type` enum('CURRENCY_TYPE_MAIN_STORE_CURRENCY','CURRENCY_TYPE_CUSTOMER_SELECTED','CURRENCY_TYPE_PAYMENT_GATEWAY') NOT NULL,
  `order_tax_type` varchar(50) NOT NULL DEFAULT '',
  `order_tax_value` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `is_included` int(11) DEFAULT '2',
  PRIMARY KEY (`id`),
  KEY `IDX_type` (`order_tax_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_tax_display_options`
--

CREATE TABLE `[[dbprefix]]order_tax_display_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `currency_code` varchar(5) DEFAULT NULL,
  `currency_type` enum('CURRENCY_TYPE_MAIN_STORE_CURRENCY','CURRENCY_TYPE_CUSTOMER_SELECTED','CURRENCY_TYPE_PAYMENT_GATEWAY') NOT NULL,
  `visible_name` varchar(50) NOT NULL DEFAULT '',
  `order_tax_value` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `formula` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `IDX_type` (`visible_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]patterns`
--

CREATE TABLE `[[dbprefix]]patterns` (
  `pattern_id` int(11) NOT NULL AUTO_INCREMENT,
  `pattern_name` varchar(50) DEFAULT NULL,
  `pattern_descr` varchar(255) DEFAULT NULL,
  `pattern_value` varchar(255) DEFAULT NULL,
  `pattern_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`pattern_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]patterns`
--

INSERT INTO `[[dbprefix]]patterns` VALUES
(1, 'Integer', 'All integer numbers.', '/^\\d*$/', 'integer'),
(2, 'Float', 'A numbers with floating point.', '/^\\d*\\.\\d*$/', 'float'),
(3, 'String', 'Simple string without restrictions.', '/^.*$/', 'string'),
(4, 'Multiline string', 'String with multiline support.', '/^.*$/m', 'mstring'),
(5, 'Currency', 'Currency values.', '/^\\d*\\.\\d{2}$/', 'currency'),
(6, 'String1024', 'length(x) < 1024.', '/^(.{0,1024})$/', 'string1024'),
(7, 'String128', 'length(x) < 128.', '/^(.{0,128})$/', 'string128'),
(8, 'String256', 'length(x) < 256.', '/^(.{0,256})$/', 'string256'),
(9, 'String512', 'length(x) < 512.', '/^(.{0,512})$/', 'string512'),
(10, 'Weight', 'Weight values.', '/^\\d*\\.?\\d*$/', 'weight'),
(11, 'Items', 'Items values.', '/^-?\\d*$/', 'item');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]persons`
--

CREATE TABLE `[[dbprefix]]persons` (
  `person_id` int(11) NOT NULL AUTO_INCREMENT,
  `person_login` varchar(255) NOT NULL DEFAULT '',
  `person_password` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`person_id`),
  KEY `IDX_login` (`person_login`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]persons_data`
--

CREATE TABLE `[[dbprefix]]persons_data` (
  `person_info_variant_id` int(11) NOT NULL DEFAULT '0',
  `person_attribute_id` int(11) NOT NULL DEFAULT '0',
  `person_id` int(11) NOT NULL DEFAULT '0',
  `person_attribute_value` longtext NOT NULL,
  PRIMARY KEY (`person_info_variant_id`,`person_attribute_id`,`person_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]person_attributes`
--

CREATE TABLE `[[dbprefix]]person_attributes` (
  `person_attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `person_attribute_view_tag` varchar(255) NOT NULL DEFAULT '',
  `pattern_id` int(11) DEFAULT NULL,
  `input_type_id` int(11) DEFAULT NULL,
  `input_validation_func_name` varchar(255) NOT NULL DEFAULT '',
  `attribute_min_value` varchar(255) DEFAULT NULL,
  `attribute_max_value` varchar(255) DEFAULT NULL,
  `attribute_html_size` varchar(255) DEFAULT NULL,
  `is_custom` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`person_attribute_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]person_attributes`
--

INSERT INTO `[[dbprefix]]person_attributes` VALUES
(1, 'Firstname', 3, 1, 'is_valid_first_name', '0', '128', '20', 0),
(2, 'Lastname', 3, 1, 'is_valid_last_name', '0', '128', '20', 0),
(3, 'Email', 3, 1, 'is_valid_email', '0', '128', '30', 0),
(4, 'Streetline1', 3, 1, 'is_valid_street_line_1', '0', '128', '30', 0),
(5, 'Streetline2', 3, 1, 'is_valid_street_line_2', '0', '128', '30', 0),
(6, 'City', 3, 1, 'is_valid_city', '0', '128', '20', 0),
(7, 'State', 3, 1, 'is_valid_state', '0', '128', '20', 0),
(8, 'Postcode', 3, 1, 'is_valid_postcode', '0', '128', '12', 0),
(9, 'Country', 3, 3, 'is_valid_country', NULL, NULL, NULL, 0),
(10, 'Phone', 3, 1, 'is_valid_phone', '0', '128', '20', 0),
(11, 'CommentArea', 6, 2, 'is_valid_string1024_null', NULL, NULL, NULL, 0),
(12, 'CreditCardType', 8, 3, 'is_valid_credit_card_type', '0', '128', '20', 0),
(13, 'CreditCardNumber', 1, 1, 'is_valid_credit_card_number', '0', '128', '20', 0),
(14, 'CreditCardVerificationNumber', 1, 1, 'is_valid_credit_card_verification_number', '0', '128', '20', 0),
(15, 'ExpirationMonth', 1, 3, 'is_valid_month', NULL, NULL, NULL, 0),
(16, 'ExpirationYear', 1, 3, 'is_valid_year', NULL, NULL, NULL, 0),
(22, 'ValidFromMonth', 1, 3, 'is_valid_month_valid_from', NULL, NULL, NULL, 0),
(23, 'ValidFromYear', 1, 3, 'is_valid_year_valid_from', NULL, NULL, NULL, 0),
(24, 'CreditCardIssueNumber', 3, 1, 'is_valid_credit_card_issue_number', NULL, NULL, NULL, 0),
(17, 'BankAccountName', 3, 1, 'is_valid_bank_account_name', '0', '128', '20', 0),
(18, 'BankRoutingNumber', 3, 1, 'is_valid_bank_routing_number', '0', '128', '20', 0),
(19, 'BankAccountNumber', 3, 1, 'is_valid_bank_account_number', '0', '128', '20', 0),
(20, 'BankStateBranch', 3, 1, 'is_valid_bank_state_branch', '0', '128', '20', 0),
(21, 'BankInternationalBankAccountNumber', 3, 1, 'is_valid_bank_international_bank_account_number', '0', '128', '20', 0),
(25, 'CommentLine', 3, 1, 'is_valid_text_line', '0', '128', '30', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]person_info_types`
--

CREATE TABLE `[[dbprefix]]person_info_types` (
  `person_info_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `person_info_type_tag` varchar(50) NOT NULL DEFAULT '',
  `person_info_type_name` varchar(255) NOT NULL DEFAULT '',
  `person_info_type_description` varchar(255) DEFAULT NULL,
  `person_info_type_visible_name` varchar(255) NOT NULL DEFAULT '',
  `person_info_type_active` char(5) NOT NULL DEFAULT 'true',
  PRIMARY KEY (`person_info_type_id`),
  UNIQUE KEY `IDX_tag` (`person_info_type_tag`),
  KEY `IDX_name` (`person_info_type_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]person_info_types`
--

INSERT INTO `[[dbprefix]]person_info_types` VALUES
(2, 'billingInfo', 'Billing Information', 'Billing Information', 'Billing Information', 'true'),
(3, 'shippingInfo', 'Shipping Information', 'Shipping Information', 'Shipping Information', 'true'),
(4, 'creditCardInfo', 'Credit Card Information', 'Credit Card Information', 'Credit Card Information', 'true'),
(5, 'bankAccountInfo', 'Bank Account Information', 'Bank Account Information', 'Bank Account Information', 'true'),
(6, 'paymentModule', 'Payment Module', 'Payment Module', 'Payment Method', 'true'),
(7, 'shippingModuleAndMethod', 'Shipping Module and Method', 'Shipping Module and Method', 'Shipping Method', 'true');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]person_info_variants`
--

CREATE TABLE `[[dbprefix]]person_info_variants` (
  `person_info_variant_id` int(11) NOT NULL AUTO_INCREMENT,
  `person_info_type_id` int(11) NOT NULL DEFAULT '0',
  `person_info_variant_tag` varchar(50) NOT NULL DEFAULT '',
  `person_info_variant_name` varchar(255) NOT NULL DEFAULT '',
  `person_info_variant_description` varchar(255) DEFAULT NULL,
  `person_info_variant_visible_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`person_info_variant_id`),
  UNIQUE KEY `IDX_tag_type_id` (`person_info_type_id`,`person_info_variant_tag`),
  KEY `IDX_name` (`person_info_variant_name`),
  KEY `IDX_type_id` (`person_info_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]person_info_variants`
--

INSERT INTO `[[dbprefix]]person_info_variants` VALUES
(2, 2, 'default', '[default] Billing Information', '[default] Billing Information', 'Billing Information'),
(3, 3, 'default', '[default] Shipping Information', '[default] Shipping Information', 'Shipping Information'),
(4, 4, 'default', '[default] Credit Card Information', '[default] Credit Card Information', '[default] Credit Card Information'),
(5, 5, 'default', '[default] Bank Account Information', '[default] Bank Account Information', '[default] Bank Account Information');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]person_info_variants_to_attributes`
--

CREATE TABLE `[[dbprefix]]person_info_variants_to_attributes` (
  `person_info_id` int(11) NOT NULL AUTO_INCREMENT,
  `person_info_variant_id` int(11) NOT NULL DEFAULT '0',
  `person_attribute_id` int(11) NOT NULL DEFAULT '0',
  `person_attribute_visible_name` varchar(255) NOT NULL DEFAULT '',
  `person_attribute_description` varchar(255) DEFAULT NULL,
  `person_attribute_unremovable` char(5) DEFAULT NULL,
  `person_attribute_visible` char(5) DEFAULT NULL,
  `person_attribute_required` char(5) DEFAULT NULL,
  `person_attribute_sort_order` int(11) DEFAULT NULL,
  `field_type` enum('CUSTOM_FIELD_TYPE_TEXT','CUSTOM_FIELD_TYPE_CHECKBOX','CUSTOM_FIELD_TYPE_SELECT','CUSTOM_FIELD_TYPE_STANDARD','CUSTOM_FIELD_TYPE_TEXTAREA') NOT NULL DEFAULT 'CUSTOM_FIELD_TYPE_STANDARD',
  `field_params` longtext NOT NULL,
  PRIMARY KEY (`person_info_id`),
  UNIQUE KEY `IDS` (`person_info_variant_id`,`person_attribute_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=38 ;

--
-- Dumping data for table `[[dbprefix]]person_info_variants_to_attributes`
--

INSERT INTO `[[dbprefix]]person_info_variants_to_attributes` VALUES
(1, 2, 1, 'First Name', 'Billing First Name', '0', '1', '1', 1, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(2, 2, 2, 'Last Name', 'Billing Last Name', '0', '1', '1', 2, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(3, 2, 3, 'E-mail', 'Billing E-mail Address', '0', '1', '1', 3, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(4, 2, 9, 'Country', 'Country', '1', '1', '1', 4, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(5, 2, 8, 'ZIP Code', 'ZIP Code', '1', '1', '1', 5, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(6, 2, 7, 'State', 'State', '0', '1', '1', 6, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(7, 2, 6, 'City', 'City', '0', '1', '1', 7, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(8, 2, 4, 'Address Line 1', 'Address Line 1', '0', '1', '0', 8, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(9, 2, 5, 'Address Line 2', 'Address Line 2', '0', '1', '0', 9, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(10, 2, 10, 'Contact Phone', 'Contact Phone', '0', '1', '1', 10, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(11, 2, 25, 'Comment', 'Comment Text Line', '0', '0', '0', 11, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(12, 2, 11, 'Comment', 'Comment Text Area', '0', '0', '0', 12, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(13, 3, 1, 'First Name', 'First Name', '0', '1', '1', 1, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(14, 3, 2, 'Last Name', 'Last Name', '0', '1', '1', 2, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(15, 3, 3, 'E-mail', 'E-mail Address', '0', '1', '0', 3, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(16, 3, 9, 'Country', 'Country', '1', '1', '1', 4, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(17, 3, 8, 'ZIP Code', 'ZIP Code', '1', '1', '1', 5, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(18, 3, 7, 'State', 'State', '0', '1', '1', 6, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(19, 3, 6, 'City', 'City', '0', '1', '0', 7, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(20, 3, 4, 'Address Line 1', 'Address Line 1', '0', '1', '0', 8, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(21, 3, 5, 'Address Line 2', 'Address Line 2', '0', '1', '0', 9, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(22, 3, 10, 'Contact Phone', 'Contact Phone', '0', '1', '0', 10, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(23, 3, 25, 'Comment', 'Comment Text Line', '0', '0', '0', 11, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(24, 3, 11, 'Comment', 'Comment Text Area', '0', '0', '0', 12, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(25, 4, 12, 'Card Type', 'Credit Card Type', '1', '1', '0', 1, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(26, 4, 13, 'Card Number', 'Credit Card Number', '1', '1', '0', 2, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(27, 4, 14, 'Verification Code', 'A 3 or 4 digit value printed on the card or signature strip', '1', '1', '0', 3, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(28, 4, 15, 'Expiration Month', 'Credit Card Expiration Month', '1', '1', '0', 4, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(29, 4, 16, 'Expiration Year', 'Credit Card Expiration Year', '1', '1', '0', 5, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(30, 4, 22, '''valid from'' Month', 'Credit Card ''valid from'' Month', '1', '1', '0', 6, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(31, 4, 23, '''valid from'' Year', 'Credit Card ''valid from'' Year', '1', '1', '0', 7, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(32, 4, 24, 'Issue Number', 'Credit Card Issue Number', '1', '1', '0', 8, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(33, 5, 17, 'Account Name', 'Bank Account Name', '0', '1', '1', 1, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(34, 5, 18, 'Routing Number', 'Routing transit number (RTN) or ABA number (USA)', '0', '1', '0', 2, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(35, 5, 19, 'Account Number', 'Bank Account Number', '0', '1', '0', 3, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(36, 5, 20, 'BSB', 'Bank-State-Branch (BSB) (Australia)', '0', '1', '0', 4, 'CUSTOM_FIELD_TYPE_STANDARD', ''),
(37, 5, 21, 'IBAN', 'International Bank Account Number (IBAN) (European Union)', '0', '1', '0', 5, 'CUSTOM_FIELD_TYPE_STANDARD', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]person_to_info_variants`
--

CREATE TABLE `[[dbprefix]]person_to_info_variants` (
  `person_id` int(11) NOT NULL DEFAULT '0',
  `person_info_variant_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`person_id`,`person_info_variant_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pf_files`
--

CREATE TABLE `[[dbprefix]]pf_files` (
  `file_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `file_path` text,
  `file_name` varchar(255) DEFAULT NULL,
  `file_descr` varchar(255) DEFAULT NULL,
  `file_size` int(11) NOT NULL DEFAULT '0',
  `is_uploaded` enum('Y','N') DEFAULT 'Y',
  PRIMARY KEY (`file_id`),
  KEY `IDX_pid` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pf_hotlinks`
--

CREATE TABLE `[[dbprefix]]pf_hotlinks` (
  `hotlink_id` int(11) NOT NULL AUTO_INCREMENT,
  `hotlink_key` varchar(255) NOT NULL DEFAULT '',
  `hotlink_value` text NOT NULL,
  `order_product_id` int(11) NOT NULL DEFAULT '0',
  `file_id` int(11) NOT NULL DEFAULT '0',
  `expire_date` int(11) NOT NULL DEFAULT '0',
  `max_try` int(11) NOT NULL DEFAULT '0',
  `was_try` int(11) NOT NULL DEFAULT '0',
  `status` enum('L','U') DEFAULT 'L',
  PRIMARY KEY (`hotlink_id`),
  KEY `IDX_opid` (`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pf_settings`
--

CREATE TABLE `[[dbprefix]]pf_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]pf_settings`
--

INSERT INTO `[[dbprefix]]pf_settings` VALUES
(1, 'HL_TL', '72'),
(2, 'HL_MAX_TRY', '3');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pi_images`
--

CREATE TABLE `[[dbprefix]]pi_images` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `image_path` text,
  `image_mime_type` varchar(255) DEFAULT NULL,
  `image_sizes` text NOT NULL,
  `thumb_path` text,
  `thumb_sizes` text,
  `alt_text` varchar(255) NOT NULL DEFAULT '',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_id`),
  KEY `IDX_pid` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pi_settings`
--

CREATE TABLE `[[dbprefix]]pi_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]pi_settings`
--

INSERT INTO `[[dbprefix]]pi_settings` VALUES
(1, 'RESIZE_DETAILED_LARGE_IMAGE', 'N'),
(2, 'DETAILED_LARGE_IMAGE_SIZE', '640'),
(3, 'THUMB_SIDE', '70'),
(4, 'THUMBS_PER_LINE', '3'),
(5, 'AUTO_GEN_MAIN_SMALL_IMAGE', 'Y'),
(6, 'MAIN_IMAGE_SIDE', '100'),
(7, 'RESIZE_LARGE_IMAGE', 'N'),
(8, 'LARGE_IMAGE_SIZE', '640'),
(9, 'AUTO_GEN_CAT_SMALL_IMAGE', 'Y'),
(10, 'CAT_IMAGE_SIDE', '120');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pm_all_inactive_settings`
--

CREATE TABLE `[[dbprefix]]pm_all_inactive_settings` (
  `pm_all_inactive_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_all_inactive_setting_key` varchar(50) DEFAULT NULL,
  `pm_all_inactive_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pm_all_inactive_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]pm_all_inactive_settings`
--

INSERT INTO `[[dbprefix]]pm_all_inactive_settings` VALUES
(1, 'MODULE_NAME', 's:28:"No available payment methods";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pm_cod_settings`
--

CREATE TABLE `[[dbprefix]]pm_cod_settings` (
  `pm_cod_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_cod_setting_key` varchar(50) DEFAULT NULL,
  `pm_cod_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pm_cod_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]pm_cod_settings`
--

INSERT INTO `[[dbprefix]]pm_cod_settings` VALUES
(1, 'MODULE_NAME', 's:14:"CashOnDelivery";'),
(2, 'PER_ORDER_SHIPPING_FEE', 's:4:"0.00";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pm_gc_settings`
--

CREATE TABLE `[[dbprefix]]pm_gc_settings` (
  `pm_gc_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_gc_setting_key` varchar(50) DEFAULT NULL,
  `pm_gc_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pm_gc_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]pm_gc_settings`
--

INSERT INTO `[[dbprefix]]pm_gc_settings` VALUES
(1, 'MODULE_NAME', 's:16:"Gift Certificate";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pm_offline_cc_settings`
--

CREATE TABLE `[[dbprefix]]pm_offline_cc_settings` (
  `pm_offline_cc_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_offline_cc_setting_key` varchar(50) DEFAULT NULL,
  `pm_offline_cc_setting_value` text,
  PRIMARY KEY (`pm_offline_cc_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]pm_offline_cc_settings`
--

INSERT INTO `[[dbprefix]]pm_offline_cc_settings` VALUES
(1, 'MODULE_NAME', 's:37:"Manual/Offline Credit Card Processing";'),
(2, 'RSA_PUBLIC_KEY_ASC_FORMAT', 's:0:"";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pm_paypal_settings`
--

CREATE TABLE `[[dbprefix]]pm_paypal_settings` (
  `pm_paypal_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_paypal_setting_key` varchar(50) DEFAULT NULL,
  `pm_paypal_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pm_paypal_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]pm_paypal_settings`
--

INSERT INTO `[[dbprefix]]pm_paypal_settings` VALUES
(1, 'MODULE_NAME', 's:32:"PayPal Website Payments Standard";'),
(3, 'MODULE_EMAIL', 's:20:"you@yourbusiness.com";'),
(4, 'MODULE_MODE', 's:1:"1";'),
(5, 'MODULE_CART', 's:1:"1";'),
(6, 'MODULE_BILLING_INFO', 's:1:"1";'),
(7, 'MODULE_ADDRESS_OVERRIDE', 's:1:"1";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]positive_currency_formats`
--

CREATE TABLE `[[dbprefix]]positive_currency_formats` (
  `negative_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `format` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`negative_format_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]positive_currency_formats`
--

INSERT INTO `[[dbprefix]]positive_currency_formats` VALUES
(1, '{s}{v}'),
(2, '{s} {v}'),
(3, '{v}{s}'),
(4, '{v} {s}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]po_crules`
--

CREATE TABLE `[[dbprefix]]po_crules` (
  `crule_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_entity` enum('product','ptype') DEFAULT NULL,
  `entity_id` int(11) NOT NULL DEFAULT '0',
  `tpl_index` int(11) NOT NULL DEFAULT '0',
  `sside` text NOT NULL,
  `lside` text NOT NULL,
  `rside` text NOT NULL,
  `crule_formula` longtext NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`crule_id`),
  KEY `IDX_ent_eid` (`parent_entity`,`entity_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]po_inventory`
--

CREATE TABLE `[[dbprefix]]po_inventory` (
  `it_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_entity` enum('product','ptype') DEFAULT NULL,
  `entity_id` int(11) NOT NULL DEFAULT '0',
  `combination` longtext NOT NULL,
  `formula` longtext NOT NULL,
  `sku` varchar(255) NOT NULL DEFAULT '',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`it_id`),
  KEY `IDX_ent_eid` (`parent_entity`,`entity_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]po_options`
--

CREATE TABLE `[[dbprefix]]po_options` (
  `option_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_entity` enum('product','ptype') DEFAULT NULL,
  `entity_id` int(11) NOT NULL DEFAULT '0',
  `option_name` varchar(255) NOT NULL DEFAULT '',
  `display_name` varchar(255) NOT NULL DEFAULT '',
  `display_descr` text,
  `option_type` enum('SS','MS','CI','UF') DEFAULT NULL,
  `show_type` enum('DD','RG','MS','CBG','CBSI','CBTA','SI','TA','DFI') DEFAULT NULL,
  `discard_avail` enum('Y','N') DEFAULT 'N',
  `discard_value` varchar(255) NOT NULL DEFAULT '',
  `checkbox_text` varchar(255) NOT NULL DEFAULT '',
  `use_for_it` enum('Y','N') DEFAULT 'N',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`option_id`),
  KEY `IDX_ent_eid` (`parent_entity`,`entity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=179 ;

--
-- Dumping data for table `[[dbprefix]]po_options`
--

INSERT INTO `[[dbprefix]]po_options` VALUES
(1, 'product', 3, 'Processor', 'Processor', 'Get amazing performance from the quad-core Intel Core i5 or i7 &quot;Nehalem&quot; processor, which features four processor cores on a single chip. Choose the speed and processor you want.', 'SS', 'RG', 'N', '', '', 'N', 1),
(2, 'ptype', 2, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(3, 'product', 3, 'Memory', 'Memory', 'More memory (RAM) increases performance and enables your computer to perform faster and better. Choose additional 1066MHz DDR3 memory for your iMac.', 'SS', 'DD', 'N', '', '', 'N', 2),
(4, 'product', 3, 'Hard Drive', 'Hard Drive', 'A larger hard drive gives you more space for data and applications. Choose the right capacity for you.', 'SS', 'RG', 'N', '', '', 'N', 3),
(5, 'product', 3, 'Apple Mouse', 'Apple Mouse', 'You can connect your own USB mouse or add a new mouse. Choose the wireless Magic Mouse &mdash; the world&rsquo;s first Multi-Touch mouse &mdash; or select the wired Apple Mouse.', 'MS', 'MS', 'N', '', '', 'N', 4),
(6, 'product', 4, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(7, 'product', 3, 'Apple Remote', 'Apple Remote', 'Control your Mac from afar with the sleek aluminium Apple Remote. Play, pause, adjust volume, move forward and back, and access menus while playing music and video.', 'MS', 'CBG', 'N', '', '', 'N', 5),
(8, 'product', 3, 'Comments', 'Comments', '', 'CI', 'TA', 'N', '', '', 'N', 6),
(9, 'product', 5, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(11, 'product', 9, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(16, 'product', 19, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(17, 'product', 23, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(18, 'product', 35, 'Size', 'Size', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(19, 'product', 35, 'Upload your design', 'Upload your design', '', 'UF', 'DFI', 'Y', '', '', 'N', 0),
(20, 'product', 35, 'Comments', 'Comments', '', 'CI', 'TA', 'N', '', '', 'N', 2),
(21, 'ptype', 5, 'Size', 'Size', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(22, 'product', 36, 'Size', 'Size', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(29, 'product', 42, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(31, 'product', 43, 'subscription', 'Subscription period', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(33, 'product', 44, 'subscription', 'Subscription period', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(37, 'product', 47, 'Size', 'Size', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(38, 'ptype', 7, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(39, 'ptype', 7, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(40, 'ptype', 7, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(41, 'ptype', 7, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(42, 'product', 48, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(43, 'product', 48, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(44, 'product', 48, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(45, 'product', 48, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(46, 'product', 49, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(47, 'product', 49, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(48, 'product', 49, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(49, 'product', 49, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(50, 'product', 50, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(51, 'product', 50, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(52, 'product', 50, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(53, 'product', 50, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(54, 'product', 51, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(55, 'product', 51, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(56, 'product', 51, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(57, 'product', 51, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(58, 'product', 52, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(59, 'product', 52, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(60, 'product', 52, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(61, 'product', 52, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(62, 'product', 53, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(63, 'product', 53, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(64, 'product', 53, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(65, 'product', 53, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(66, 'product', 54, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(67, 'product', 54, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(68, 'product', 54, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(69, 'product', 54, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(78, 'product', 57, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(79, 'product', 57, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(80, 'product', 57, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(81, 'product', 57, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(82, 'product', 58, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(83, 'product', 58, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(84, 'product', 58, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(85, 'product', 58, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(86, 'product', 59, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(87, 'product', 59, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(88, 'product', 59, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(89, 'product', 59, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(102, 'product', 63, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(103, 'product', 63, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(104, 'product', 63, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(105, 'product', 63, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(110, 'product', 65, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(111, 'product', 65, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(112, 'product', 65, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(113, 'product', 65, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(114, 'product', 66, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(115, 'product', 66, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(116, 'product', 66, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(117, 'product', 66, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(118, 'product', 67, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(119, 'product', 67, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(120, 'product', 67, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(121, 'product', 67, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(122, 'product', 68, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(123, 'product', 68, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(124, 'product', 68, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(125, 'product', 68, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(130, 'product', 70, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(131, 'product', 70, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(132, 'product', 70, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(133, 'product', 70, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(134, 'product', 71, 'Extra (Mylar Balloons)', 'Mylar Balloon', '', 'SS', 'DD', 'Y', 'No Ballons', '', 'N', 1),
(135, 'product', 71, 'Extra (Box of Chocolates)', 'Box of Chocolates', '', 'SS', 'DD', 'N', '', '', 'N', 2),
(136, 'product', 71, 'DeliveryDate', 'Delivery Date', '', 'CI', 'SI', 'N', '', '', 'N', 3),
(137, 'product', 71, 'SpecialInstructions', 'Special Instructions / Gift Message', '', 'CI', 'TA', 'N', '', '', 'N', 4),
(154, 'product', 121, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(147, 'product', 81, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(148, 'product', 82, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(151, 'product', 118, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(152, 'product', 119, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(155, 'product', 122, 'giftwrapping', 'Gift Wrapping', '', 'SS', 'DD', 'N', '', '', 'N', 1),
(164, 'product', 18, 'Processor', 'Processor', 'A faster processor increases the efficiency and performance of your applications and operations.', 'SS', 'DD', 'N', '', '', 'N', 1),
(165, 'product', 18, 'Memory', 'Memory', 'More memory (RAM) increases overall performance and enables your computer to run more applications at the same time.', 'SS', 'DD', 'N', '', '', 'N', 2),
(166, 'product', 18, 'Hard Drive', 'Hard Drive', 'How much storage do you need?', 'SS', 'DD', 'N', '', '', 'N', 3),
(167, 'product', 18, 'Comments', 'Comments', '', 'CI', 'SI', 'N', '', '', 'N', 4),
(173, 'product', 6, 'Processor', 'Processor', 'Two Quad-Core Intel Xeon &quot;Nehalem&quot; processors give you a total of eight processor cores for the ultimate in power and performance. Choose the speed you want.', 'SS', 'RG', 'N', '', '', 'N', 1),
(174, 'product', 6, 'Memory', 'Memory', 'The 8-core Mac Pro supports up to 32GB of 1066MHz DDR3 ECC SDRAM memory in eight slots. Choose more memory for improved overall system performance.', 'SS', 'DD', 'N', '', '', 'N', 2),
(175, 'product', 6, 'RAID', 'RAID Card', 'Enhance data protection and storage performance by configuring your system with the Mac Pro RAID Card and multiple hard drives.', 'SS', 'DD', 'N', '', '', 'N', 3),
(176, 'product', 6, 'Drive', 'Optical Drive', 'Your Mac Pro comes standard with one 18x double-layer SuperDrive that burns and plays both CDs and DVDs. Add a second SuperDrive to streamline disc burning.', 'SS', 'DD', 'N', '', '', 'N', 4),
(177, 'product', 6, 'Mouse', 'Apple Mouse', 'You can connect your own USB mouse or add a new mouse. Choose the wireless Magic Mouse &mdash; the world&rsquo;s first Multi-Touch mouse &mdash; or select the wired Apple Mouse.', 'SS', 'DD', 'N', '', '', 'N', 5),
(178, 'product', 6, 'Display', 'Apple Displays', 'Connect your Mac Pro to a 24-inch Apple LED Cinema Display, which features a built-in iSight camera, microphone, and speakers, or a 30-inch Apple Cinema HD Display for the ultimate widescreen canvas.', 'SS', 'DD', 'N', '', '', 'N', 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]po_options_values`
--

CREATE TABLE `[[dbprefix]]po_options_values` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT,
  `option_id` int(11) NOT NULL DEFAULT '0',
  `value_name` varchar(255) NOT NULL DEFAULT '',
  `is_default` enum('Y','N') DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `price_modifier` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `weight_modifier` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `shipping_cost_modifier` decimal(20,5) NOT NULL DEFAULT '0.00000',
  `handling_cost_modifier` decimal(20,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`value_id`),
  KEY `IDX_oid` (`option_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=423 ;

--
-- Dumping data for table `[[dbprefix]]po_options_values`
--

INSERT INTO `[[dbprefix]]po_options_values` VALUES
(1, 1, '2.66GHz Quad-Core Intel Core i5', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(2, 1, '2.8GHz Quad-Core Intel Core i7', 'N', 2, 200.00000, 0.00000, 0.00000, 0.00000),
(3, 2, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(4, 2, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(5, 3, '4GB SDRAM - 2x2GB', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(6, 3, '8GB SDRAM - 4x2GB', 'N', 2, 200.00000, 0.00000, 0.00000, 0.00000),
(7, 3, '8GB SDRAM - 2x4GB', 'N', 3, 600.00000, 0.00000, 0.00000, 0.00000),
(8, 3, '16GB SDRAM - 4x4GB', 'N', 4, 1400.00000, 0.00000, 0.00000, 0.00000),
(9, 4, '1TB Serial ATA Drive', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(10, 4, '2TB Serial ATA Drive', 'N', 2, 250.00000, 0.00000, 0.00000, 0.00000),
(11, 5, 'Apple Mouse', 'N', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(12, 6, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(13, 6, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(14, 5, 'Apple Magic Mouse', 'Y', 2, 20.00000, 0.00000, 0.00000, 0.00000),
(16, 7, 'Apple Remote', 'Y', 2, 19.00000, 0.00000, 0.00000, 0.00000),
(17, 8, 'Comments', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(18, 9, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(19, 9, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(22, 11, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(23, 11, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(32, 16, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(33, 16, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(34, 17, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(35, 17, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(36, 18, 'S', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(37, 18, 'M', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(38, 18, 'L', 'N', 3, 0.00000, 0.00000, 0.00000, 0.00000),
(39, 18, 'XL', 'N', 4, 0.00000, 0.00000, 0.00000, 0.00000),
(40, 18, '2XL', 'N', 5, 0.00000, 0.00000, 0.00000, 0.00000),
(41, 18, '3XL', 'N', 6, 0.00000, 0.00000, 0.00000, 0.00000),
(42, 18, '4XL', 'N', 7, 0.00000, 0.00000, 0.00000, 0.00000),
(43, 19, 'no file', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(44, 20, 'replace it for your own', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(45, 21, 'S', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(46, 21, 'M', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(47, 21, 'L', 'N', 3, 0.00000, 0.00000, 0.00000, 0.00000),
(48, 21, 'XL', 'N', 4, 0.00000, 0.00000, 0.00000, 0.00000),
(49, 21, '2XL', 'N', 5, 0.00000, 0.00000, 0.00000, 0.00000),
(50, 21, '3XL', 'N', 6, 0.00000, 0.00000, 0.00000, 0.00000),
(51, 21, '4XL', 'N', 7, 0.00000, 0.00000, 0.00000, 0.00000),
(52, 22, 'S', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(53, 22, 'M', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(54, 22, 'L', 'N', 3, 0.00000, 0.00000, 0.00000, 0.00000),
(55, 22, 'XL', 'N', 4, 0.00000, 0.00000, 0.00000, 0.00000),
(56, 22, '2XL', 'N', 5, 0.00000, 0.00000, 0.00000, 0.00000),
(57, 22, '3XL', 'N', 6, 0.00000, 0.00000, 0.00000, 0.00000),
(58, 22, '4XL', 'N', 7, 0.00000, 0.00000, 0.00000, 0.00000),
(72, 29, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(73, 29, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(77, 31, '8-month subscription', 'N', 2, -10.00000, 0.00000, 0.00000, 0.00000),
(76, 31, '1-year subscription', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(81, 33, '2-year subscription (24 issues)', 'N', 2, 12.00000, 0.00000, 0.00000, 0.00000),
(80, 33, '1-year subscription (12 issues)', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(92, 37, 'S', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(93, 37, 'M', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(94, 37, 'L', 'N', 3, 0.00000, 0.00000, 0.00000, 0.00000),
(95, 37, 'XL', 'N', 4, 0.00000, 0.00000, 0.00000, 0.00000),
(96, 37, '2XL', 'N', 5, 0.00000, 0.00000, 0.00000, 0.00000),
(97, 37, '3XL', 'N', 6, 0.00000, 0.00000, 0.00000, 0.00000),
(98, 37, '4XL', 'N', 7, 0.00000, 0.00000, 0.00000, 0.00000),
(99, 38, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(100, 38, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(101, 38, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(102, 39, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(103, 39, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(104, 39, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(105, 40, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(106, 41, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(107, 42, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(108, 42, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(109, 42, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(110, 43, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(111, 43, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(112, 43, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(113, 44, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(114, 45, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(115, 46, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(116, 46, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(117, 46, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(118, 47, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(119, 47, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(120, 47, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(121, 48, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(122, 49, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(123, 50, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(124, 50, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(125, 50, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(126, 51, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(127, 51, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(128, 51, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(129, 52, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(130, 53, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(131, 54, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(132, 54, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(133, 54, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(134, 55, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(135, 55, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(136, 55, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(137, 56, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(138, 57, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(139, 58, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(140, 58, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(141, 58, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(142, 59, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(143, 59, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(144, 59, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(145, 60, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(146, 61, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(147, 62, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(148, 62, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(149, 62, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(150, 63, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(151, 63, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(152, 63, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(153, 64, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(154, 65, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(155, 66, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(156, 66, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(157, 66, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(158, 67, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(159, 67, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(160, 67, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(161, 68, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(162, 69, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(179, 78, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(180, 78, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(181, 78, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(182, 79, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(183, 79, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(184, 79, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(185, 80, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(186, 81, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(187, 82, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(188, 82, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(189, 82, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(190, 83, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(191, 83, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(192, 83, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(193, 84, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(194, 85, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(195, 86, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(196, 86, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(197, 86, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(198, 87, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(199, 87, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(200, 87, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(201, 88, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(202, 89, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(227, 102, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(228, 102, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(229, 102, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(230, 103, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(231, 103, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(232, 103, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(233, 104, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(234, 105, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(243, 110, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(244, 110, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(245, 110, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(246, 111, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(247, 111, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(248, 111, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(249, 112, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(250, 113, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(251, 114, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(252, 114, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(253, 114, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(254, 115, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(255, 115, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(256, 115, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(257, 116, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(258, 117, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(259, 118, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(260, 118, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(261, 118, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(262, 119, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(263, 119, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(264, 119, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(265, 120, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(266, 121, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(267, 122, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(268, 122, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(269, 122, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(270, 123, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(271, 123, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(272, 123, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(273, 124, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(274, 125, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(283, 130, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(284, 130, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(285, 130, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(286, 131, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(287, 131, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(288, 131, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(289, 132, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(290, 133, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(291, 134, '1 Mylar Balloon', 'Y', 1, 4.99000, 0.00000, 0.00000, 0.00000),
(292, 134, '2 Mylar Balloon', 'N', 2, 9.99000, 0.00000, 0.00000, 0.00000),
(293, 134, '3 Mylar Balloon', 'N', 3, 14.99000, 0.00000, 0.00000, 0.00000),
(294, 135, 'Small box', 'Y', 1, 9.99000, 0.00000, 0.00000, 0.00000),
(295, 135, 'Medium box', 'N', 2, 19.99000, 0.00000, 0.00000, 0.00000),
(296, 135, 'Large box', 'N', 3, 29.90000, 0.00000, 0.00000, 0.00000),
(297, 136, 'mm/dd/yy', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(298, 137, '---', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(362, 154, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(361, 154, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(347, 147, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(348, 147, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(349, 148, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(350, 148, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(355, 151, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(356, 151, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(357, 152, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(358, 152, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(363, 155, 'Yes, add gift wrapping', 'Y', 1, 10.00000, 0.00000, 0.00000, 0.00000),
(364, 155, 'No, thank you', 'N', 2, 0.00000, 0.00000, 0.00000, 0.00000),
(384, 164, 'Intel Core 2 Quad Q8200 [+ $150]', 'N', 3, 150.00000, 0.00000, 0.00000, 0.00000),
(383, 164, 'Intel Core 2 Duo E7500 [+ $100]', 'N', 2, 110.00000, 0.00000, 0.00000, 0.00000),
(382, 164, 'Intel Celeron 450', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(385, 164, 'Intel Core 2 Duo E8400 [+ $170]', 'N', 4, 170.00000, 0.00000, 0.00000, 0.00000),
(386, 165, '2GB DDR2 SDRAM', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(387, 165, '3GB DDR2 SDRAM [+ $39]', 'N', 2, 39.00000, 0.00000, 0.00000, 0.00000),
(388, 165, '4GB DDR2 SDRAM [+ $69]', 'N', 3, 69.00000, 0.00000, 0.00000, 0.00000),
(390, 166, '320GB', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(391, 166, '500GB [+ $30]', 'N', 2, 30.00000, 0.00000, 0.00000, 0.00000),
(392, 166, '640GB [+ $70]', 'N', 3, 70.00000, 0.00000, 0.00000, 0.00000),
(393, 166, '750GB [+ $100]', 'N', 4, 100.00000, 0.00000, 0.00000, 0.00000),
(394, 167, 'replace it for your own', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(406, 173, 'Two 2.26GHz Intel Xeon', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(407, 173, 'Two 2.66GHz Intel Xeon [+ $1,400.00]', 'N', 2, 1400.00000, 0.00000, 0.00000, 0.00000),
(408, 173, 'Two 2.93GHz Intel Xeon [+ $2,600.00]', 'N', 3, 2600.00000, 0.00000, 0.00000, 0.00000),
(409, 174, '6GB (6x1GB)', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(410, 174, '8GB (4x2GB) [+ $100.00]', 'N', 2, 100.00000, 0.00000, 0.00000, 0.00000),
(411, 174, '12GB (6x2GB) [+ $300.00]', 'N', 3, 300.00000, 0.00000, 0.00000, 0.00000),
(412, 174, '16GB (8x2GB) [+ $500.00]', 'N', 4, 500.00000, 0.00000, 0.00000, 0.00000),
(413, 174, '32GB (8x4GB) [+ $3,700.00]', 'N', 5, 3700.00000, 0.00000, 0.00000, 0.00000),
(414, 175, 'None', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(415, 175, 'Mac Pro RAID Card [+ $700.00]', 'N', 2, 700.00000, 0.00000, 0.00000, 0.00000),
(416, 176, 'One 18x SuperDrive', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(417, 176, 'Two 18x SuperDrives [+ $100.00]', 'N', 2, 100.00000, 0.00000, 0.00000, 0.00000),
(418, 177, 'Apple Mouse', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(419, 177, 'Apple Magic Mouse', 'N', 2, 20.00000, 0.00000, 0.00000, 0.00000),
(420, 178, 'None', 'Y', 1, 0.00000, 0.00000, 0.00000, 0.00000),
(421, 178, 'Apple LED Cinema Display (24") [+ $899.00]', 'N', 2, 899.00000, 0.00000, 0.00000, 0.00000),
(422, 178, 'Apple Cinema HD Display (30") [+ $1,799.00]', 'N', 3, 1799.00000, 0.00000, 0.00000, 0.00000);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]po_settings`
--

CREATE TABLE `[[dbprefix]]po_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_entity` enum('product','ptype') DEFAULT NULL,
  `entity_id` int(11) NOT NULL DEFAULT '0',
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` longtext NOT NULL,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `IDX_ent_eid_key` (`parent_entity`,`entity_id`,`setting_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1754 ;

--
-- Dumping data for table `[[dbprefix]]po_settings`
--

INSERT INTO `[[dbprefix]]po_settings` VALUES
(29, 'product', 3, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(28, 'product', 3, 'WRN_CI_CR', 'Product option combination does not exist.'),
(27, 'product', 3, 'WRN_ONS', ''),
(25, 'product', 3, 'LL_NTF', '0'),
(26, 'product', 3, 'INV_PER_PAGE', '10'),
(23, 'product', 3, 'AANIC', 'Y'),
(24, 'product', 3, 'AANIS', 'N'),
(21, 'product', 3, 'AAWD', 'Y'),
(22, 'product', 3, 'CR_FORMULA', '(true);'),
(11, 'product', 2, 'AAWD', 'Y'),
(12, 'product', 2, 'CR_FORMULA', '(true);'),
(13, 'product', 2, 'AANIC', 'Y'),
(14, 'product', 2, 'AANIS', 'N'),
(15, 'product', 2, 'LL_NTF', '0'),
(16, 'product', 2, 'INV_PER_PAGE', '10'),
(17, 'product', 2, 'WRN_ONS', ''),
(18, 'product', 2, 'WRN_CI_CR', 'Product option combination does not exist.'),
(19, 'product', 2, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(20, 'product', 2, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(30, 'product', 3, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(31, 'product', 4, 'AAWD', 'Y'),
(41, 'product', 4, 'CR_FORMULA', '(true);'),
(33, 'product', 4, 'AANIC', 'Y'),
(34, 'product', 4, 'AANIS', 'N'),
(35, 'product', 4, 'LL_NTF', '0'),
(36, 'product', 4, 'INV_PER_PAGE', '10'),
(37, 'product', 4, 'WRN_ONS', ''),
(38, 'product', 4, 'WRN_CI_CR', 'Product option combination does not exist.'),
(39, 'product', 4, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(40, 'product', 4, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(42, 'product', 5, 'AAWD', 'Y'),
(52, 'product', 5, 'CR_FORMULA', '(true);'),
(44, 'product', 5, 'AANIC', 'Y'),
(45, 'product', 5, 'AANIS', 'N'),
(46, 'product', 5, 'LL_NTF', '0'),
(47, 'product', 5, 'INV_PER_PAGE', '10'),
(48, 'product', 5, 'WRN_ONS', ''),
(49, 'product', 5, 'WRN_CI_CR', 'Product option combination does not exist.'),
(50, 'product', 5, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(51, 'product', 5, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(53, 'product', 6, 'AAWD', 'Y'),
(54, 'product', 6, 'CR_FORMULA', '(true);'),
(55, 'product', 6, 'AANIC', 'Y'),
(56, 'product', 6, 'AANIS', 'N'),
(57, 'product', 6, 'LL_NTF', '0'),
(58, 'product', 6, 'INV_PER_PAGE', '10'),
(59, 'product', 6, 'WRN_ONS', ''),
(60, 'product', 6, 'WRN_CI_CR', 'Product option combination does not exist.'),
(61, 'product', 6, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(62, 'product', 6, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(74, 'product', 8, 'AAWD', 'Y'),
(75, 'product', 8, 'CR_FORMULA', '(true);'),
(76, 'product', 8, 'AANIC', 'Y'),
(77, 'product', 8, 'AANIS', 'N'),
(78, 'product', 8, 'LL_NTF', '0'),
(79, 'product', 8, 'INV_PER_PAGE', '10'),
(80, 'product', 8, 'WRN_ONS', ''),
(81, 'product', 8, 'WRN_CI_CR', 'Product option combination does not exist.'),
(82, 'product', 8, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(83, 'product', 8, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(84, 'product', 9, 'AAWD', 'Y'),
(94, 'product', 9, 'CR_FORMULA', '(true);'),
(86, 'product', 9, 'AANIC', 'Y'),
(87, 'product', 9, 'AANIS', 'N'),
(88, 'product', 9, 'LL_NTF', '0'),
(89, 'product', 9, 'INV_PER_PAGE', '10'),
(90, 'product', 9, 'WRN_ONS', ''),
(91, 'product', 9, 'WRN_CI_CR', 'Product option combination does not exist.'),
(92, 'product', 9, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(93, 'product', 9, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(106, 'product', 11, 'AAWD', 'Y'),
(107, 'product', 11, 'CR_FORMULA', '(true);'),
(108, 'product', 11, 'AANIC', 'Y'),
(109, 'product', 11, 'AANIS', 'N'),
(110, 'product', 11, 'LL_NTF', '0'),
(111, 'product', 11, 'INV_PER_PAGE', '10'),
(112, 'product', 11, 'WRN_ONS', ''),
(113, 'product', 11, 'WRN_CI_CR', 'Product option combination does not exist.'),
(114, 'product', 11, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(115, 'product', 11, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(148, 'product', 15, 'AAWD', 'Y'),
(149, 'product', 15, 'CR_FORMULA', '(true);'),
(150, 'product', 15, 'AANIC', 'Y'),
(151, 'product', 15, 'AANIS', 'N'),
(152, 'product', 15, 'LL_NTF', '0'),
(153, 'product', 15, 'INV_PER_PAGE', '10'),
(154, 'product', 15, 'WRN_ONS', ''),
(155, 'product', 15, 'WRN_CI_CR', 'Product option combination does not exist.'),
(156, 'product', 15, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(157, 'product', 15, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(179, 'product', 18, 'AAWD', 'Y'),
(180, 'product', 18, 'CR_FORMULA', '(true);'),
(181, 'product', 18, 'AANIC', 'Y'),
(182, 'product', 18, 'AANIS', 'N'),
(183, 'product', 18, 'LL_NTF', '0'),
(184, 'product', 18, 'INV_PER_PAGE', '10'),
(185, 'product', 18, 'WRN_ONS', ''),
(186, 'product', 18, 'WRN_CI_CR', 'Product option combination does not exist.'),
(187, 'product', 18, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(188, 'product', 18, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(189, 'product', 19, 'AAWD', 'Y'),
(199, 'product', 19, 'CR_FORMULA', '(true);'),
(191, 'product', 19, 'AANIC', 'Y'),
(192, 'product', 19, 'AANIS', 'N'),
(193, 'product', 19, 'LL_NTF', '0'),
(194, 'product', 19, 'INV_PER_PAGE', '10'),
(195, 'product', 19, 'WRN_ONS', ''),
(196, 'product', 19, 'WRN_CI_CR', 'Product option combination does not exist.'),
(197, 'product', 19, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(198, 'product', 19, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(230, 'product', 23, 'AAWD', 'Y'),
(240, 'product', 23, 'CR_FORMULA', '(true);'),
(232, 'product', 23, 'AANIC', 'Y'),
(233, 'product', 23, 'AANIS', 'N'),
(234, 'product', 23, 'LL_NTF', '0'),
(235, 'product', 23, 'INV_PER_PAGE', '10'),
(236, 'product', 23, 'WRN_ONS', ''),
(237, 'product', 23, 'WRN_CI_CR', 'Product option combination does not exist.'),
(238, 'product', 23, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(239, 'product', 23, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(281, 'product', 28, 'AAWD', 'Y'),
(282, 'product', 28, 'CR_FORMULA', '(true);'),
(283, 'product', 28, 'AANIC', 'Y'),
(284, 'product', 28, 'AANIS', 'N'),
(285, 'product', 28, 'LL_NTF', '0'),
(286, 'product', 28, 'INV_PER_PAGE', '10'),
(287, 'product', 28, 'WRN_ONS', ''),
(288, 'product', 28, 'WRN_CI_CR', 'Product option combination does not exist.'),
(289, 'product', 28, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(290, 'product', 28, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(311, 'product', 31, 'AAWD', 'Y'),
(312, 'product', 31, 'CR_FORMULA', '(true);'),
(313, 'product', 31, 'AANIC', 'Y'),
(314, 'product', 31, 'AANIS', 'N'),
(315, 'product', 31, 'LL_NTF', '0'),
(316, 'product', 31, 'INV_PER_PAGE', '10'),
(317, 'product', 31, 'WRN_ONS', ''),
(318, 'product', 31, 'WRN_CI_CR', 'Product option combination does not exist.'),
(319, 'product', 31, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(320, 'product', 31, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(321, 'product', 32, 'AAWD', 'Y'),
(322, 'product', 32, 'CR_FORMULA', '(true);'),
(323, 'product', 32, 'AANIC', 'Y'),
(324, 'product', 32, 'AANIS', 'N'),
(325, 'product', 32, 'LL_NTF', '0'),
(326, 'product', 32, 'INV_PER_PAGE', '10'),
(327, 'product', 32, 'WRN_ONS', ''),
(328, 'product', 32, 'WRN_CI_CR', 'Product option combination does not exist.'),
(329, 'product', 32, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(330, 'product', 32, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(331, 'product', 33, 'AAWD', 'Y'),
(332, 'product', 33, 'CR_FORMULA', '(true);'),
(333, 'product', 33, 'AANIC', 'Y'),
(334, 'product', 33, 'AANIS', 'N'),
(335, 'product', 33, 'LL_NTF', '0'),
(336, 'product', 33, 'INV_PER_PAGE', '10'),
(337, 'product', 33, 'WRN_ONS', ''),
(338, 'product', 33, 'WRN_CI_CR', 'Product option combination does not exist.'),
(339, 'product', 33, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(340, 'product', 33, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(341, 'product', 34, 'AAWD', 'Y'),
(342, 'product', 34, 'CR_FORMULA', '(true);'),
(343, 'product', 34, 'AANIC', 'Y'),
(344, 'product', 34, 'AANIS', 'N'),
(345, 'product', 34, 'LL_NTF', '0'),
(346, 'product', 34, 'INV_PER_PAGE', '10'),
(347, 'product', 34, 'WRN_ONS', ''),
(348, 'product', 34, 'WRN_CI_CR', 'Product option combination does not exist.'),
(349, 'product', 34, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(350, 'product', 34, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(351, 'product', 35, 'AAWD', 'Y'),
(352, 'product', 35, 'CR_FORMULA', '(true);'),
(353, 'product', 35, 'AANIC', 'Y'),
(354, 'product', 35, 'AANIS', 'N'),
(355, 'product', 35, 'LL_NTF', '0'),
(356, 'product', 35, 'INV_PER_PAGE', '10'),
(357, 'product', 35, 'WRN_ONS', ''),
(358, 'product', 35, 'WRN_CI_CR', 'Product option combination does not exist.'),
(359, 'product', 35, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(360, 'product', 35, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(361, 'product', 36, 'AAWD', 'Y'),
(371, 'product', 36, 'CR_FORMULA', '(true);'),
(363, 'product', 36, 'AANIC', 'Y'),
(364, 'product', 36, 'AANIS', 'N'),
(365, 'product', 36, 'LL_NTF', '0'),
(366, 'product', 36, 'INV_PER_PAGE', '10'),
(367, 'product', 36, 'WRN_ONS', ''),
(368, 'product', 36, 'WRN_CI_CR', 'Product option combination does not exist.'),
(369, 'product', 36, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(370, 'product', 36, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(372, 'product', 37, 'AAWD', 'Y'),
(373, 'product', 37, 'CR_FORMULA', '(true);'),
(374, 'product', 37, 'AANIC', 'Y'),
(375, 'product', 37, 'AANIS', 'N'),
(376, 'product', 37, 'LL_NTF', '0'),
(377, 'product', 37, 'INV_PER_PAGE', '10'),
(378, 'product', 37, 'WRN_ONS', ''),
(379, 'product', 37, 'WRN_CI_CR', 'Product option combination does not exist.'),
(380, 'product', 37, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(381, 'product', 37, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(426, 'product', 42, 'AAWD', 'Y'),
(436, 'product', 42, 'CR_FORMULA', '(true);'),
(428, 'product', 42, 'AANIC', 'Y'),
(429, 'product', 42, 'AANIS', 'N'),
(430, 'product', 42, 'LL_NTF', '0'),
(431, 'product', 42, 'INV_PER_PAGE', '10'),
(432, 'product', 42, 'WRN_ONS', ''),
(433, 'product', 42, 'WRN_CI_CR', 'Product option combination does not exist.'),
(434, 'product', 42, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(435, 'product', 42, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(437, 'product', 43, 'AAWD', 'Y'),
(447, 'product', 43, 'CR_FORMULA', '(true);'),
(439, 'product', 43, 'AANIC', 'Y'),
(440, 'product', 43, 'AANIS', 'N'),
(441, 'product', 43, 'LL_NTF', '0'),
(442, 'product', 43, 'INV_PER_PAGE', '10'),
(443, 'product', 43, 'WRN_ONS', ''),
(444, 'product', 43, 'WRN_CI_CR', 'Product option combination does not exist.'),
(445, 'product', 43, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(446, 'product', 43, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(448, 'product', 44, 'AAWD', 'Y'),
(458, 'product', 44, 'CR_FORMULA', '(true);'),
(450, 'product', 44, 'AANIC', 'Y'),
(451, 'product', 44, 'AANIS', 'N'),
(452, 'product', 44, 'LL_NTF', '0'),
(453, 'product', 44, 'INV_PER_PAGE', '10'),
(454, 'product', 44, 'WRN_ONS', ''),
(455, 'product', 44, 'WRN_CI_CR', 'Product option combination does not exist.'),
(456, 'product', 44, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(457, 'product', 44, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(481, 'product', 47, 'AAWD', 'Y'),
(491, 'product', 47, 'CR_FORMULA', '(true);'),
(483, 'product', 47, 'AANIC', 'Y'),
(484, 'product', 47, 'AANIS', 'N'),
(485, 'product', 47, 'LL_NTF', '0'),
(486, 'product', 47, 'INV_PER_PAGE', '10'),
(487, 'product', 47, 'WRN_ONS', ''),
(488, 'product', 47, 'WRN_CI_CR', 'Product option combination does not exist.'),
(489, 'product', 47, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(490, 'product', 47, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(492, 'product', 48, 'AAWD', 'Y'),
(502, 'product', 48, 'CR_FORMULA', '(true);'),
(494, 'product', 48, 'AANIC', 'Y'),
(495, 'product', 48, 'AANIS', 'N'),
(496, 'product', 48, 'LL_NTF', '0'),
(497, 'product', 48, 'INV_PER_PAGE', '10'),
(498, 'product', 48, 'WRN_ONS', ''),
(499, 'product', 48, 'WRN_CI_CR', 'Product option combination does not exist.'),
(500, 'product', 48, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(501, 'product', 48, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(503, 'product', 49, 'AAWD', 'Y'),
(513, 'product', 49, 'CR_FORMULA', '(true);'),
(505, 'product', 49, 'AANIC', 'Y'),
(506, 'product', 49, 'AANIS', 'N'),
(507, 'product', 49, 'LL_NTF', '0'),
(508, 'product', 49, 'INV_PER_PAGE', '10'),
(509, 'product', 49, 'WRN_ONS', ''),
(510, 'product', 49, 'WRN_CI_CR', 'Product option combination does not exist.'),
(511, 'product', 49, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(512, 'product', 49, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(514, 'product', 50, 'AAWD', 'Y'),
(524, 'product', 50, 'CR_FORMULA', '(true);'),
(516, 'product', 50, 'AANIC', 'Y'),
(517, 'product', 50, 'AANIS', 'N'),
(518, 'product', 50, 'LL_NTF', '0'),
(519, 'product', 50, 'INV_PER_PAGE', '10'),
(520, 'product', 50, 'WRN_ONS', ''),
(521, 'product', 50, 'WRN_CI_CR', 'Product option combination does not exist.'),
(522, 'product', 50, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(523, 'product', 50, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(525, 'product', 51, 'AAWD', 'Y'),
(535, 'product', 51, 'CR_FORMULA', '(true);'),
(527, 'product', 51, 'AANIC', 'Y'),
(528, 'product', 51, 'AANIS', 'N'),
(529, 'product', 51, 'LL_NTF', '0'),
(530, 'product', 51, 'INV_PER_PAGE', '10'),
(531, 'product', 51, 'WRN_ONS', ''),
(532, 'product', 51, 'WRN_CI_CR', 'Product option combination does not exist.'),
(533, 'product', 51, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(534, 'product', 51, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(536, 'product', 52, 'AAWD', 'Y'),
(546, 'product', 52, 'CR_FORMULA', '(true);'),
(538, 'product', 52, 'AANIC', 'Y'),
(539, 'product', 52, 'AANIS', 'N'),
(540, 'product', 52, 'LL_NTF', '0'),
(541, 'product', 52, 'INV_PER_PAGE', '10'),
(542, 'product', 52, 'WRN_ONS', ''),
(543, 'product', 52, 'WRN_CI_CR', 'Product option combination does not exist.'),
(544, 'product', 52, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(545, 'product', 52, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(547, 'product', 53, 'AAWD', 'Y'),
(557, 'product', 53, 'CR_FORMULA', '(true);'),
(549, 'product', 53, 'AANIC', 'Y'),
(550, 'product', 53, 'AANIS', 'N'),
(551, 'product', 53, 'LL_NTF', '0'),
(552, 'product', 53, 'INV_PER_PAGE', '10'),
(553, 'product', 53, 'WRN_ONS', ''),
(554, 'product', 53, 'WRN_CI_CR', 'Product option combination does not exist.'),
(555, 'product', 53, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(556, 'product', 53, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(558, 'product', 54, 'AAWD', 'Y'),
(568, 'product', 54, 'CR_FORMULA', '(true);'),
(560, 'product', 54, 'AANIC', 'Y'),
(561, 'product', 54, 'AANIS', 'N'),
(562, 'product', 54, 'LL_NTF', '0'),
(563, 'product', 54, 'INV_PER_PAGE', '10'),
(564, 'product', 54, 'WRN_ONS', ''),
(565, 'product', 54, 'WRN_CI_CR', 'Product option combination does not exist.'),
(566, 'product', 54, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(567, 'product', 54, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(591, 'product', 57, 'AAWD', 'Y'),
(601, 'product', 57, 'CR_FORMULA', '(true);'),
(593, 'product', 57, 'AANIC', 'Y'),
(594, 'product', 57, 'AANIS', 'N'),
(595, 'product', 57, 'LL_NTF', '0'),
(596, 'product', 57, 'INV_PER_PAGE', '10'),
(597, 'product', 57, 'WRN_ONS', ''),
(598, 'product', 57, 'WRN_CI_CR', 'Product option combination does not exist.'),
(599, 'product', 57, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(600, 'product', 57, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(602, 'product', 58, 'AAWD', 'Y'),
(612, 'product', 58, 'CR_FORMULA', '(true);'),
(604, 'product', 58, 'AANIC', 'Y'),
(605, 'product', 58, 'AANIS', 'N'),
(606, 'product', 58, 'LL_NTF', '0'),
(607, 'product', 58, 'INV_PER_PAGE', '10'),
(608, 'product', 58, 'WRN_ONS', ''),
(609, 'product', 58, 'WRN_CI_CR', 'Product option combination does not exist.'),
(610, 'product', 58, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(611, 'product', 58, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(613, 'product', 59, 'AAWD', 'Y'),
(623, 'product', 59, 'CR_FORMULA', '(true);'),
(615, 'product', 59, 'AANIC', 'Y'),
(616, 'product', 59, 'AANIS', 'N'),
(617, 'product', 59, 'LL_NTF', '0'),
(618, 'product', 59, 'INV_PER_PAGE', '10'),
(619, 'product', 59, 'WRN_ONS', ''),
(620, 'product', 59, 'WRN_CI_CR', 'Product option combination does not exist.'),
(621, 'product', 59, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(622, 'product', 59, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(657, 'product', 63, 'AAWD', 'Y'),
(667, 'product', 63, 'CR_FORMULA', '(true);'),
(659, 'product', 63, 'AANIC', 'Y'),
(660, 'product', 63, 'AANIS', 'N'),
(661, 'product', 63, 'LL_NTF', '0'),
(662, 'product', 63, 'INV_PER_PAGE', '10'),
(663, 'product', 63, 'WRN_ONS', ''),
(664, 'product', 63, 'WRN_CI_CR', 'Product option combination does not exist.'),
(665, 'product', 63, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(666, 'product', 63, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(679, 'product', 65, 'AAWD', 'Y'),
(689, 'product', 65, 'CR_FORMULA', '(true);'),
(681, 'product', 65, 'AANIC', 'Y'),
(682, 'product', 65, 'AANIS', 'N'),
(683, 'product', 65, 'LL_NTF', '0'),
(684, 'product', 65, 'INV_PER_PAGE', '10'),
(685, 'product', 65, 'WRN_ONS', ''),
(686, 'product', 65, 'WRN_CI_CR', 'Product option combination does not exist.'),
(687, 'product', 65, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(688, 'product', 65, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(690, 'product', 66, 'AAWD', 'Y'),
(700, 'product', 66, 'CR_FORMULA', '(true);'),
(692, 'product', 66, 'AANIC', 'Y'),
(693, 'product', 66, 'AANIS', 'N'),
(694, 'product', 66, 'LL_NTF', '0'),
(695, 'product', 66, 'INV_PER_PAGE', '10'),
(696, 'product', 66, 'WRN_ONS', ''),
(697, 'product', 66, 'WRN_CI_CR', 'Product option combination does not exist.'),
(698, 'product', 66, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(699, 'product', 66, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(701, 'product', 67, 'AAWD', 'Y'),
(711, 'product', 67, 'CR_FORMULA', '(true);'),
(703, 'product', 67, 'AANIC', 'Y'),
(704, 'product', 67, 'AANIS', 'N'),
(705, 'product', 67, 'LL_NTF', '0'),
(706, 'product', 67, 'INV_PER_PAGE', '10'),
(707, 'product', 67, 'WRN_ONS', ''),
(708, 'product', 67, 'WRN_CI_CR', 'Product option combination does not exist.'),
(709, 'product', 67, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(710, 'product', 67, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(712, 'product', 68, 'AAWD', 'Y'),
(722, 'product', 68, 'CR_FORMULA', '(true);'),
(714, 'product', 68, 'AANIC', 'Y'),
(715, 'product', 68, 'AANIS', 'N'),
(716, 'product', 68, 'LL_NTF', '0'),
(717, 'product', 68, 'INV_PER_PAGE', '10'),
(718, 'product', 68, 'WRN_ONS', ''),
(719, 'product', 68, 'WRN_CI_CR', 'Product option combination does not exist.'),
(720, 'product', 68, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(721, 'product', 68, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(734, 'product', 70, 'AAWD', 'Y'),
(744, 'product', 70, 'CR_FORMULA', '(true);'),
(736, 'product', 70, 'AANIC', 'Y'),
(737, 'product', 70, 'AANIS', 'N'),
(738, 'product', 70, 'LL_NTF', '0'),
(739, 'product', 70, 'INV_PER_PAGE', '10'),
(740, 'product', 70, 'WRN_ONS', ''),
(741, 'product', 70, 'WRN_CI_CR', 'Product option combination does not exist.'),
(742, 'product', 70, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(743, 'product', 70, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(745, 'product', 71, 'AAWD', 'Y'),
(755, 'product', 71, 'CR_FORMULA', '(true);'),
(747, 'product', 71, 'AANIC', 'Y'),
(748, 'product', 71, 'AANIS', 'N'),
(749, 'product', 71, 'LL_NTF', '0'),
(750, 'product', 71, 'INV_PER_PAGE', '10'),
(751, 'product', 71, 'WRN_ONS', ''),
(752, 'product', 71, 'WRN_CI_CR', 'Product option combination does not exist.'),
(753, 'product', 71, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(754, 'product', 71, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1269, 'product', 121, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1270, 'product', 121, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1268, 'product', 121, 'WRN_ONS', ''),
(1262, 'product', 121, 'AAWD', 'Y'),
(1272, 'product', 121, 'CR_FORMULA', '(true);'),
(1264, 'product', 121, 'AANIC', 'Y'),
(1265, 'product', 121, 'AANIS', 'N'),
(1266, 'product', 121, 'LL_NTF', '0'),
(1267, 'product', 121, 'INV_PER_PAGE', '10'),
(855, 'product', 81, 'AAWD', 'Y'),
(865, 'product', 81, 'CR_FORMULA', '(true);'),
(857, 'product', 81, 'AANIC', 'Y'),
(858, 'product', 81, 'AANIS', 'N'),
(859, 'product', 81, 'LL_NTF', '0'),
(860, 'product', 81, 'INV_PER_PAGE', '10'),
(861, 'product', 81, 'WRN_ONS', ''),
(862, 'product', 81, 'WRN_CI_CR', 'Product option combination does not exist.'),
(863, 'product', 81, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(864, 'product', 81, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(866, 'product', 82, 'AAWD', 'Y'),
(876, 'product', 82, 'CR_FORMULA', '(true);'),
(868, 'product', 82, 'AANIC', 'Y'),
(869, 'product', 82, 'AANIS', 'N'),
(870, 'product', 82, 'LL_NTF', '0'),
(871, 'product', 82, 'INV_PER_PAGE', '10'),
(872, 'product', 82, 'WRN_ONS', ''),
(873, 'product', 82, 'WRN_CI_CR', 'Product option combination does not exist.'),
(874, 'product', 82, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(875, 'product', 82, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(939, 'product', 89, 'AAWD', 'Y'),
(940, 'product', 89, 'CR_FORMULA', '(true);'),
(941, 'product', 89, 'AANIC', 'Y'),
(942, 'product', 89, 'AANIS', 'N'),
(943, 'product', 89, 'LL_NTF', '0'),
(944, 'product', 89, 'INV_PER_PAGE', '10'),
(945, 'product', 89, 'WRN_ONS', ''),
(946, 'product', 89, 'WRN_CI_CR', 'Product option combination does not exist.'),
(947, 'product', 89, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(948, 'product', 89, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(949, 'product', 90, 'AAWD', 'Y'),
(950, 'product', 90, 'CR_FORMULA', '(true);'),
(951, 'product', 90, 'AANIC', 'Y'),
(952, 'product', 90, 'AANIS', 'N'),
(953, 'product', 90, 'LL_NTF', '0'),
(954, 'product', 90, 'INV_PER_PAGE', '10'),
(955, 'product', 90, 'WRN_ONS', ''),
(956, 'product', 90, 'WRN_CI_CR', 'Product option combination does not exist.'),
(957, 'product', 90, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(958, 'product', 90, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(959, 'product', 91, 'AAWD', 'Y'),
(960, 'product', 91, 'CR_FORMULA', '(true);'),
(961, 'product', 91, 'AANIC', 'Y'),
(962, 'product', 91, 'AANIS', 'N'),
(963, 'product', 91, 'LL_NTF', '0'),
(964, 'product', 91, 'INV_PER_PAGE', '10'),
(965, 'product', 91, 'WRN_ONS', ''),
(966, 'product', 91, 'WRN_CI_CR', 'Product option combination does not exist.'),
(967, 'product', 91, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(968, 'product', 91, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1019, 'product', 97, 'AAWD', 'Y'),
(1020, 'product', 97, 'CR_FORMULA', '(true);'),
(1021, 'product', 97, 'AANIC', 'Y'),
(1022, 'product', 97, 'AANIS', 'N'),
(1023, 'product', 97, 'LL_NTF', '0'),
(1024, 'product', 97, 'INV_PER_PAGE', '10'),
(1025, 'product', 97, 'WRN_ONS', ''),
(1026, 'product', 97, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1027, 'product', 97, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1028, 'product', 97, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1029, 'product', 98, 'AAWD', 'Y'),
(1030, 'product', 98, 'CR_FORMULA', '(true);'),
(1031, 'product', 98, 'AANIC', 'Y'),
(1032, 'product', 98, 'AANIS', 'N'),
(1033, 'product', 98, 'LL_NTF', '0'),
(1034, 'product', 98, 'INV_PER_PAGE', '10'),
(1035, 'product', 98, 'WRN_ONS', ''),
(1036, 'product', 98, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1037, 'product', 98, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1038, 'product', 98, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1039, 'product', 99, 'AAWD', 'Y'),
(1040, 'product', 99, 'CR_FORMULA', '(true);'),
(1041, 'product', 99, 'AANIC', 'Y'),
(1042, 'product', 99, 'AANIS', 'N'),
(1043, 'product', 99, 'LL_NTF', '0'),
(1044, 'product', 99, 'INV_PER_PAGE', '10'),
(1045, 'product', 99, 'WRN_ONS', ''),
(1046, 'product', 99, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1047, 'product', 99, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1048, 'product', 99, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1049, 'product', 100, 'AAWD', 'Y'),
(1050, 'product', 100, 'CR_FORMULA', '(true);'),
(1051, 'product', 100, 'AANIC', 'Y'),
(1052, 'product', 100, 'AANIS', 'N'),
(1053, 'product', 100, 'LL_NTF', '0'),
(1054, 'product', 100, 'INV_PER_PAGE', '10'),
(1055, 'product', 100, 'WRN_ONS', ''),
(1056, 'product', 100, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1057, 'product', 100, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1058, 'product', 100, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1059, 'product', 101, 'AAWD', 'Y'),
(1060, 'product', 101, 'CR_FORMULA', '(true);'),
(1061, 'product', 101, 'AANIC', 'Y'),
(1062, 'product', 101, 'AANIS', 'N'),
(1063, 'product', 101, 'LL_NTF', '0'),
(1064, 'product', 101, 'INV_PER_PAGE', '10'),
(1065, 'product', 101, 'WRN_ONS', ''),
(1066, 'product', 101, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1067, 'product', 101, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1068, 'product', 101, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1069, 'product', 102, 'AAWD', 'Y'),
(1070, 'product', 102, 'CR_FORMULA', '(true);'),
(1071, 'product', 102, 'AANIC', 'Y'),
(1072, 'product', 102, 'AANIS', 'N'),
(1073, 'product', 102, 'LL_NTF', '0'),
(1074, 'product', 102, 'INV_PER_PAGE', '10'),
(1075, 'product', 102, 'WRN_ONS', ''),
(1076, 'product', 102, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1077, 'product', 102, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1078, 'product', 102, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1079, 'product', 103, 'AAWD', 'Y'),
(1080, 'product', 103, 'CR_FORMULA', '(true);'),
(1081, 'product', 103, 'AANIC', 'Y'),
(1082, 'product', 103, 'AANIS', 'N'),
(1083, 'product', 103, 'LL_NTF', '0'),
(1084, 'product', 103, 'INV_PER_PAGE', '10'),
(1085, 'product', 103, 'WRN_ONS', ''),
(1086, 'product', 103, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1087, 'product', 103, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1088, 'product', 103, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1089, 'product', 104, 'AAWD', 'Y'),
(1090, 'product', 104, 'CR_FORMULA', '(true);'),
(1091, 'product', 104, 'AANIC', 'Y'),
(1092, 'product', 104, 'AANIS', 'N'),
(1093, 'product', 104, 'LL_NTF', '0'),
(1094, 'product', 104, 'INV_PER_PAGE', '10'),
(1095, 'product', 104, 'WRN_ONS', ''),
(1096, 'product', 104, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1097, 'product', 104, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1098, 'product', 104, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1099, 'product', 105, 'AAWD', 'Y'),
(1100, 'product', 105, 'CR_FORMULA', '(true);'),
(1101, 'product', 105, 'AANIC', 'Y'),
(1102, 'product', 105, 'AANIS', 'N'),
(1103, 'product', 105, 'LL_NTF', '0'),
(1104, 'product', 105, 'INV_PER_PAGE', '10'),
(1105, 'product', 105, 'WRN_ONS', ''),
(1106, 'product', 105, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1107, 'product', 105, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1108, 'product', 105, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1109, 'product', 106, 'AAWD', 'Y'),
(1110, 'product', 106, 'CR_FORMULA', '(true);'),
(1111, 'product', 106, 'AANIC', 'Y'),
(1112, 'product', 106, 'AANIS', 'N'),
(1113, 'product', 106, 'LL_NTF', '0'),
(1114, 'product', 106, 'INV_PER_PAGE', '10'),
(1115, 'product', 106, 'WRN_ONS', ''),
(1116, 'product', 106, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1117, 'product', 106, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1118, 'product', 106, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1129, 'product', 108, 'AAWD', 'Y'),
(1130, 'product', 108, 'CR_FORMULA', '(true);'),
(1131, 'product', 108, 'AANIC', 'Y'),
(1132, 'product', 108, 'AANIS', 'N'),
(1133, 'product', 108, 'LL_NTF', '0'),
(1134, 'product', 108, 'INV_PER_PAGE', '10'),
(1135, 'product', 108, 'WRN_ONS', ''),
(1136, 'product', 108, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1137, 'product', 108, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1138, 'product', 108, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1209, 'product', 116, 'AAWD', 'Y'),
(1210, 'product', 116, 'CR_FORMULA', '(true);'),
(1211, 'product', 116, 'AANIC', 'Y'),
(1212, 'product', 116, 'AANIS', 'N'),
(1213, 'product', 116, 'LL_NTF', '0'),
(1214, 'product', 116, 'INV_PER_PAGE', '10'),
(1215, 'product', 116, 'WRN_ONS', ''),
(1216, 'product', 116, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1217, 'product', 116, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1218, 'product', 116, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1229, 'product', 118, 'AAWD', 'Y'),
(1239, 'product', 118, 'CR_FORMULA', '(true);'),
(1231, 'product', 118, 'AANIC', 'Y'),
(1232, 'product', 118, 'AANIS', 'N'),
(1233, 'product', 118, 'LL_NTF', '0'),
(1234, 'product', 118, 'INV_PER_PAGE', '10'),
(1235, 'product', 118, 'WRN_ONS', ''),
(1236, 'product', 118, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1237, 'product', 118, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1238, 'product', 118, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1240, 'product', 119, 'AAWD', 'Y'),
(1250, 'product', 119, 'CR_FORMULA', '(true);'),
(1242, 'product', 119, 'AANIC', 'Y'),
(1243, 'product', 119, 'AANIS', 'N'),
(1244, 'product', 119, 'LL_NTF', '0'),
(1245, 'product', 119, 'INV_PER_PAGE', '10'),
(1246, 'product', 119, 'WRN_ONS', ''),
(1247, 'product', 119, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1248, 'product', 119, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1249, 'product', 119, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1271, 'product', 121, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1273, 'product', 122, 'AAWD', 'Y'),
(1283, 'product', 122, 'CR_FORMULA', '(true);'),
(1275, 'product', 122, 'AANIC', 'Y'),
(1276, 'product', 122, 'AANIS', 'N'),
(1277, 'product', 122, 'LL_NTF', '0'),
(1278, 'product', 122, 'INV_PER_PAGE', '10'),
(1279, 'product', 122, 'WRN_ONS', ''),
(1280, 'product', 122, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1281, 'product', 122, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1282, 'product', 122, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1304, 'product', 125, 'AAWD', 'Y'),
(1305, 'product', 125, 'CR_FORMULA', '(true);'),
(1306, 'product', 125, 'AANIC', 'Y'),
(1307, 'product', 125, 'AANIS', 'N'),
(1308, 'product', 125, 'LL_NTF', '0'),
(1309, 'product', 125, 'INV_PER_PAGE', '10'),
(1310, 'product', 125, 'WRN_ONS', ''),
(1311, 'product', 125, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1312, 'product', 125, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1313, 'product', 125, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1314, 'product', 126, 'AAWD', 'Y'),
(1315, 'product', 126, 'CR_FORMULA', '(true);'),
(1316, 'product', 126, 'AANIC', 'Y'),
(1317, 'product', 126, 'AANIS', 'N'),
(1318, 'product', 126, 'LL_NTF', '0'),
(1319, 'product', 126, 'INV_PER_PAGE', '10'),
(1320, 'product', 126, 'WRN_ONS', ''),
(1321, 'product', 126, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1322, 'product', 126, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1323, 'product', 126, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1354, 'product', 130, 'AAWD', 'Y'),
(1355, 'product', 130, 'CR_FORMULA', '(true);'),
(1356, 'product', 130, 'AANIC', 'Y'),
(1357, 'product', 130, 'AANIS', 'N'),
(1358, 'product', 130, 'LL_NTF', '0'),
(1359, 'product', 130, 'INV_PER_PAGE', '10'),
(1360, 'product', 130, 'WRN_ONS', ''),
(1361, 'product', 130, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1362, 'product', 130, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1363, 'product', 130, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1384, 'product', 133, 'AAWD', 'Y'),
(1385, 'product', 133, 'CR_FORMULA', '(true);'),
(1386, 'product', 133, 'AANIC', 'Y'),
(1387, 'product', 133, 'AANIS', 'N'),
(1388, 'product', 133, 'LL_NTF', '0'),
(1389, 'product', 133, 'INV_PER_PAGE', '10'),
(1390, 'product', 133, 'WRN_ONS', ''),
(1391, 'product', 133, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1392, 'product', 133, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1393, 'product', 133, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1404, 'product', 135, 'AAWD', 'Y'),
(1405, 'product', 135, 'CR_FORMULA', '(true);'),
(1406, 'product', 135, 'AANIC', 'Y'),
(1407, 'product', 135, 'AANIS', 'N'),
(1408, 'product', 135, 'LL_NTF', '0'),
(1409, 'product', 135, 'INV_PER_PAGE', '10'),
(1410, 'product', 135, 'WRN_ONS', ''),
(1411, 'product', 135, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1412, 'product', 135, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1413, 'product', 135, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1414, 'product', 136, 'AAWD', 'Y'),
(1415, 'product', 136, 'CR_FORMULA', '(true);'),
(1416, 'product', 136, 'AANIC', 'Y'),
(1417, 'product', 136, 'AANIS', 'N'),
(1418, 'product', 136, 'LL_NTF', '0'),
(1419, 'product', 136, 'INV_PER_PAGE', '10'),
(1420, 'product', 136, 'WRN_ONS', ''),
(1421, 'product', 136, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1422, 'product', 136, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1423, 'product', 136, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1424, 'product', 137, 'AAWD', 'Y'),
(1425, 'product', 137, 'CR_FORMULA', '(true);'),
(1426, 'product', 137, 'AANIC', 'Y'),
(1427, 'product', 137, 'AANIS', 'N'),
(1428, 'product', 137, 'LL_NTF', '0'),
(1429, 'product', 137, 'INV_PER_PAGE', '10'),
(1430, 'product', 137, 'WRN_ONS', ''),
(1431, 'product', 137, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1432, 'product', 137, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1433, 'product', 137, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1434, 'product', 138, 'AAWD', 'Y'),
(1435, 'product', 138, 'CR_FORMULA', '(true);'),
(1436, 'product', 138, 'AANIC', 'Y'),
(1437, 'product', 138, 'AANIS', 'N'),
(1438, 'product', 138, 'LL_NTF', '0'),
(1439, 'product', 138, 'INV_PER_PAGE', '10'),
(1440, 'product', 138, 'WRN_ONS', ''),
(1441, 'product', 138, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1442, 'product', 138, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1443, 'product', 138, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1444, 'product', 139, 'AAWD', 'Y'),
(1445, 'product', 139, 'CR_FORMULA', '(true);'),
(1446, 'product', 139, 'AANIC', 'Y'),
(1447, 'product', 139, 'AANIS', 'N'),
(1448, 'product', 139, 'LL_NTF', '0'),
(1449, 'product', 139, 'INV_PER_PAGE', '10'),
(1450, 'product', 139, 'WRN_ONS', ''),
(1451, 'product', 139, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1452, 'product', 139, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1453, 'product', 139, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1454, 'product', 140, 'AAWD', 'Y'),
(1455, 'product', 140, 'CR_FORMULA', '(true);'),
(1456, 'product', 140, 'AANIC', 'Y'),
(1457, 'product', 140, 'AANIS', 'N'),
(1458, 'product', 140, 'LL_NTF', '0'),
(1459, 'product', 140, 'INV_PER_PAGE', '10'),
(1460, 'product', 140, 'WRN_ONS', ''),
(1461, 'product', 140, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1462, 'product', 140, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1463, 'product', 140, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1514, 'product', 146, 'AAWD', 'Y'),
(1515, 'product', 146, 'CR_FORMULA', '(true);'),
(1516, 'product', 146, 'AANIC', 'Y'),
(1517, 'product', 146, 'AANIS', 'N'),
(1518, 'product', 146, 'LL_NTF', '0'),
(1519, 'product', 146, 'INV_PER_PAGE', '10'),
(1520, 'product', 146, 'WRN_ONS', ''),
(1521, 'product', 146, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1522, 'product', 146, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1523, 'product', 146, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1524, 'product', 147, 'AAWD', 'Y'),
(1525, 'product', 147, 'CR_FORMULA', '(true);'),
(1526, 'product', 147, 'AANIC', 'Y'),
(1527, 'product', 147, 'AANIS', 'N'),
(1528, 'product', 147, 'LL_NTF', '0'),
(1529, 'product', 147, 'INV_PER_PAGE', '10'),
(1530, 'product', 147, 'WRN_ONS', ''),
(1531, 'product', 147, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1532, 'product', 147, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1533, 'product', 147, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1534, 'product', 148, 'AAWD', 'Y'),
(1535, 'product', 148, 'CR_FORMULA', '(true);'),
(1536, 'product', 148, 'AANIC', 'Y'),
(1537, 'product', 148, 'AANIS', 'N'),
(1538, 'product', 148, 'LL_NTF', '0'),
(1539, 'product', 148, 'INV_PER_PAGE', '10'),
(1540, 'product', 148, 'WRN_ONS', ''),
(1541, 'product', 148, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1542, 'product', 148, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1543, 'product', 148, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1544, 'product', 149, 'AAWD', 'Y'),
(1545, 'product', 149, 'CR_FORMULA', '(true);'),
(1546, 'product', 149, 'AANIC', 'Y'),
(1547, 'product', 149, 'AANIS', 'N'),
(1548, 'product', 149, 'LL_NTF', '0'),
(1549, 'product', 149, 'INV_PER_PAGE', '10'),
(1550, 'product', 149, 'WRN_ONS', ''),
(1551, 'product', 149, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1552, 'product', 149, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1553, 'product', 149, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1554, 'product', 150, 'AAWD', 'Y'),
(1555, 'product', 150, 'CR_FORMULA', '(true);'),
(1556, 'product', 150, 'AANIC', 'Y'),
(1557, 'product', 150, 'AANIS', 'N'),
(1558, 'product', 150, 'LL_NTF', '0'),
(1559, 'product', 150, 'INV_PER_PAGE', '10'),
(1560, 'product', 150, 'WRN_ONS', ''),
(1561, 'product', 150, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1562, 'product', 150, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1563, 'product', 150, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1574, 'product', 152, 'AAWD', 'Y'),
(1575, 'product', 152, 'CR_FORMULA', '(true);'),
(1576, 'product', 152, 'AANIC', 'Y'),
(1577, 'product', 152, 'AANIS', 'N'),
(1578, 'product', 152, 'LL_NTF', '0'),
(1579, 'product', 152, 'INV_PER_PAGE', '10'),
(1580, 'product', 152, 'WRN_ONS', ''),
(1581, 'product', 152, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1582, 'product', 152, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1583, 'product', 152, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1584, 'product', 153, 'AAWD', 'Y'),
(1585, 'product', 153, 'CR_FORMULA', '(true);'),
(1586, 'product', 153, 'AANIC', 'Y'),
(1587, 'product', 153, 'AANIS', 'N'),
(1588, 'product', 153, 'LL_NTF', '0'),
(1589, 'product', 153, 'INV_PER_PAGE', '10'),
(1590, 'product', 153, 'WRN_ONS', ''),
(1591, 'product', 153, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1592, 'product', 153, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1593, 'product', 153, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1604, 'product', 155, 'AAWD', 'Y'),
(1605, 'product', 155, 'CR_FORMULA', '(true);'),
(1606, 'product', 155, 'AANIC', 'Y'),
(1607, 'product', 155, 'AANIS', 'N'),
(1608, 'product', 155, 'LL_NTF', '0'),
(1609, 'product', 155, 'INV_PER_PAGE', '10'),
(1610, 'product', 155, 'WRN_ONS', ''),
(1611, 'product', 155, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1612, 'product', 155, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1613, 'product', 155, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1614, 'product', 156, 'AAWD', 'Y'),
(1615, 'product', 156, 'CR_FORMULA', '(true);'),
(1616, 'product', 156, 'AANIC', 'Y'),
(1617, 'product', 156, 'AANIS', 'N'),
(1618, 'product', 156, 'LL_NTF', '0'),
(1619, 'product', 156, 'INV_PER_PAGE', '10'),
(1620, 'product', 156, 'WRN_ONS', ''),
(1621, 'product', 156, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1622, 'product', 156, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1623, 'product', 156, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1624, 'product', 157, 'AAWD', 'Y'),
(1625, 'product', 157, 'CR_FORMULA', '(true);'),
(1626, 'product', 157, 'AANIC', 'Y'),
(1627, 'product', 157, 'AANIS', 'N'),
(1628, 'product', 157, 'LL_NTF', '0'),
(1629, 'product', 157, 'INV_PER_PAGE', '10'),
(1630, 'product', 157, 'WRN_ONS', ''),
(1631, 'product', 157, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1632, 'product', 157, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1633, 'product', 157, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1634, 'product', 158, 'AAWD', 'Y'),
(1635, 'product', 158, 'CR_FORMULA', '(true);'),
(1636, 'product', 158, 'AANIC', 'Y'),
(1637, 'product', 158, 'AANIS', 'N'),
(1638, 'product', 158, 'LL_NTF', '0'),
(1639, 'product', 158, 'INV_PER_PAGE', '10'),
(1640, 'product', 158, 'WRN_ONS', ''),
(1641, 'product', 158, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1642, 'product', 158, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1643, 'product', 158, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1664, 'product', 161, 'AAWD', 'Y'),
(1665, 'product', 161, 'CR_FORMULA', '(true);'),
(1666, 'product', 161, 'AANIC', 'Y'),
(1667, 'product', 161, 'AANIS', 'N'),
(1668, 'product', 161, 'LL_NTF', '0'),
(1669, 'product', 161, 'INV_PER_PAGE', '10'),
(1670, 'product', 161, 'WRN_ONS', ''),
(1671, 'product', 161, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1672, 'product', 161, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1673, 'product', 161, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.'),
(1744, 'product', 169, 'AAWD', 'Y'),
(1745, 'product', 169, 'CR_FORMULA', '(true);'),
(1746, 'product', 169, 'AANIC', 'Y'),
(1747, 'product', 169, 'AANIS', 'N'),
(1748, 'product', 169, 'LL_NTF', '0'),
(1749, 'product', 169, 'INV_PER_PAGE', '10'),
(1750, 'product', 169, 'WRN_ONS', ''),
(1751, 'product', 169, 'WRN_CI_CR', 'Product option combination does not exist.'),
(1752, 'product', 169, 'WRN_CI_INV', 'Product option combination doesn''t exist or is out of stock.'),
(1753, 'product', 169, 'WRN_CI_EXT', 'The type of file you uploaded is not allowed.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products`
--

CREATE TABLE `[[dbprefix]]products` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_type_id` int(11) NOT NULL DEFAULT '0',
  `product_name` varchar(255) DEFAULT NULL,
  `product_date_added` date DEFAULT '0000-00-00',
  `product_date_updated` date DEFAULT '0000-00-00',
  `product_date_available` date DEFAULT '0000-00-00',
  PRIMARY KEY (`product_id`),
  KEY `IDX_pti` (`product_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=170 ;

--
-- Dumping data for table `[[dbprefix]]products`
--

INSERT INTO `[[dbprefix]]products` VALUES
(3, 3, 'Apple iMac Desktop', '2009-11-25', '2009-12-15', '0000-00-00'),
(5, 2, 'The Lost Symbol', '2009-11-25', '2009-12-11', '0000-00-00'),
(6, 3, 'Apple Mac Pro Desktop', '2009-11-25', '2009-12-08', '0000-00-00'),
(8, 3, 'Apple MacBook Air', '2009-11-25', '2009-12-08', '0000-00-00'),
(11, 3, 'Apple MacBook Laptop', '2009-11-25', '2009-12-08', '0000-00-00'),
(15, 3, 'Asus Eee Top PC', '2009-11-25', '2009-12-08', '0000-00-00'),
(18, 3, 'Dell Inspiron Slim Desktop', '2009-11-25', '2009-12-08', '0000-00-00'),
(28, 3, 'Asus Eee PC Touch', '2009-11-26', '2009-12-08', '0000-00-00'),
(31, 3, 'HP TouchSmart', '2009-11-26', '2009-12-08', '0000-00-00'),
(32, 4, 'Avactis Shopping Cart PDF Manual', '2009-11-26', '2009-12-11', '0000-00-00'),
(33, 4, 'Avactis Shopping Cart Web Manual', '2009-11-26', '2009-12-11', '0000-00-00'),
(34, 4, 'Avactis Shopping Cart Free Edition', '2009-11-26', '2009-12-11', '0000-00-00'),
(35, 5, 'Custom T-Shirt (Upload your own design!)', '2009-11-26', '2009-12-01', '0000-00-00'),
(36, 5, 'Avactis T-Shirt', '2009-11-26', '2009-12-08', '0000-00-00'),
(37, 6, 'House, M.D.', '2009-11-26', '2009-12-08', '0000-00-00'),
(47, 5, 'Pure cotton T-Shirt', '2009-11-26', '2009-12-08', '0000-00-00'),
(89, 6, 'Lost', '2009-11-27', '2009-11-27', '0000-00-00'),
(90, 6, 'Up', '2009-11-27', '2009-11-27', '0000-00-00'),
(91, 6, 'Ice Age 3 - Dawn of the Dinosaurs', '2009-11-27', '2009-12-08', '0000-00-00'),
(97, 6, 'Harry Potter Collection Years 1-5', '2009-11-27', '2009-11-27', '0000-00-00'),
(106, 6, 'Classic Musicals from the Dream Factory, Vol. 3', '2009-11-27', '2009-12-08', '0000-00-00'),
(108, 6, 'Forbidden Planet', '2009-11-27', '2009-11-27', '0000-00-00'),
(116, 6, 'James Bond Ultimate Collection, Volume 1', '2009-11-27', '2009-12-11', '0000-00-00'),
(125, 9, 'Winter Camping Tent', '2009-11-30', '2009-11-30', '0000-00-00'),
(126, 9, 'Sea Eagle Sport Kayak', '2009-11-30', '2009-12-11', '0000-00-00'),
(130, 9, 'Garmin Nuvi GPS Receiver', '2009-11-30', '2009-12-11', '0000-00-00'),
(133, 9, 'Brunton Eclipse Compass', '2009-11-30', '2009-12-11', '0000-00-00'),
(138, 10, 'ARILD Chair', '2009-12-01', '2009-12-11', '0000-00-00'),
(139, 10, 'EKTORP TULLSTA Chair', '2009-12-01', '2009-12-11', '0000-00-00'),
(140, 8, 'Tchaikovsky: Ballet Music (Box Set)', '2009-12-02', '2009-12-11', '0000-00-00'),
(161, 10, 'KARLSTAD modular sofa', '2009-12-03', '2009-12-11', '0000-00-00'),
(169, 10, 'EKTORP Neckroll', '2009-12-03', '2009-12-11', '0000-00-00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_search`
--

CREATE TABLE `[[dbprefix]]products_search` (
  `products_search_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_search_pattern` text,
  `products_search_time` datetime DEFAULT NULL,
  `products_search_words` text,
  PRIMARY KEY (`products_search_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_search_result`
--

CREATE TABLE `[[dbprefix]]products_search_result` (
  `products_search_id` int(11) NOT NULL DEFAULT '0',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `relevance` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_search_id`,`product_id`),
  KEY `IDX_relevance` (`relevance`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]products_to_categories`
--

CREATE TABLE `[[dbprefix]]products_to_categories` (
  `record_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`record_id`),
  UNIQUE KEY `IDX_pc` (`product_id`,`category_id`),
  KEY `IDX_cp` (`category_id`,`product_id`),
  KEY `IDX_sort_order` (`sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=228 ;

--
-- Dumping data for table `[[dbprefix]]products_to_categories`
--

INSERT INTO `[[dbprefix]]products_to_categories` VALUES
(4, 3, 8, 1),
(37, 31, 21, 1),
(38, 18, 21, 0),
(44, 28, 20, 4),
(48, 15, 21, 4),
(49, 6, 21, 10),
(51, 8, 20, 2),
(55, 11, 20, 5),
(56, 32, 12, 2),
(57, 33, 12, 1),
(58, 34, 12, 0),
(62, 35, 35, 0),
(64, 36, 35, 1),
(66, 37, 28, 0),
(227, 90, 44, 227),
(78, 47, 35, 2),
(120, 89, 28, 5),
(121, 90, 27, 4),
(122, 91, 27, 0),
(128, 97, 27, 1),
(139, 106, 25, 0),
(141, 108, 25, 2),
(149, 116, 25, 11),
(159, 125, 11, 7),
(160, 126, 11, 5),
(164, 130, 11, 3),
(167, 133, 11, 1),
(172, 138, 33, 172),
(173, 139, 33, 173),
(197, 161, 33, 197),
(205, 169, 33, 205),
(223, 35, 44, 223),
(218, 31, 44, 218),
(216, 6, 44, 216),
(225, 106, 44, 225),
(226, 169, 44, 226);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]product_attributes`
--

CREATE TABLE `[[dbprefix]]product_attributes` (
  `product_attr_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0',
  `attribute_id` int(11) NOT NULL DEFAULT '0',
  `product_attr_value` longtext,
  PRIMARY KEY (`product_attr_id`),
  UNIQUE KEY `IDX_pid_aid` (`product_id`,`attribute_id`),
  KEY `IDX_pi` (`product_id`),
  KEY `IDX_ai` (`attribute_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4587 ;

--
-- Dumping data for table `[[dbprefix]]product_attributes`
--

INSERT INTO `[[dbprefix]]product_attributes` VALUES
(61, 3, 11, 'Apple iMac Desktop'),
(63, 3, 13, 'It was a great idea then, and it&rsquo;s a great idea now. The all-in-one design of the first flat-panel iMac cleaned up the desktop. It put everything you need &mdash; display, processor, graphics card, hard drive, optical drive, memory, and more &mdash; inside one simple enclosure. New technology inside and out makes the new iMac a worthy addition to the all-in-one dynasty.<br /><br /><b>In the box</b><br /><ul><li>iMac</li><li>Apple Wireless Keyboard</li><li>Magic Mouse</li><li>Power cord</li><li>Install/restore DVDs</li><li>Cleaning cloth</li><li>Printed and electronic documentation</li></ul><b>Included software</b><br /><ul><li>Mac OS X Snow Leopard </li><li>iLife</li></ul>'),
(62, 3, 12, 'It was a great idea then, and it&rsquo;s a great idea now. The all-in-one design of the first flat-panel iMac cleaned up the desktop. It put everything you need &mdash; display, processor, graphics card, hard drive, optical drive, memory, and more &mdash; inside one simple enclosure. New technology inside and out makes the new iMac a worthy addition to the all-in-one dynasty.'),
(51, 3, 1, '1999.00'),
(52, 3, 2, '2220.00'),
(53, 3, 3, '57'),
(54, 3, 4, 'Comp-18'),
(55, 3, 5, ''),
(56, 3, 6, '19'),
(57, 3, 7, '3'),
(58, 3, 8, '2'),
(59, 3, 9, 'avactis-images/large_image_3.jpg'),
(60, 3, 10, 'avactis-images/thumbnail_3.jpg'),
(107, 5, 1, '29.99'),
(108, 5, 2, ''),
(109, 5, 3, '20'),
(110, 5, 6, '3'),
(111, 5, 5, ''),
(112, 5, 4, 'BOOK-27'),
(113, 5, 7, '3'),
(114, 5, 8, '1'),
(115, 5, 24, '-1'),
(116, 5, 9, 'avactis-images/book_danbrown1.jpg'),
(117, 5, 10, 'avactis-images/thumb_book_danbrown1.jpg'),
(118, 5, 11, 'The Lost Symbol'),
(119, 5, 12, 'Jealous thriller writers will despair, doubters and nay-sayers will be proved wrong, and readers will rejoice: Dan Brown has done it again.'),
(120, 5, 13, '<p>Starred Review. After scores of Da Vinci Code knockoffs, spinoffs, copies and caricatures, Brown has had the stroke of brilliance to set his breakneck new thriller not in some far-off exotic locale, but right here in our own backyard. Everyone off the bus, and welcome to a Washington, D.C., they never told you about on your school trip when you were a kid, a place steeped in Masonic history that, once revealed, points to a dark, ancient conspiracy that threatens not only America but the world itself. </p><p>Returning hero Robert Langdon comes to Washington to give a lecture at the behest of his old mentor, Peter Solomon. When he arrives at the U.S. Capitol for his lecture, he finds, instead of an audience, Peter''s severed hand mounted on a wooden base, fingers pointing skyward to the Rotunda ceiling fresco of George Washington dressed in white robes, ascending to heaven. Langdon teases out a plethora of clues from the tattooed hand that point toward a secret portal through which an intrepid seeker will find the wisdom known as the Ancient Mysteries, or the lost wisdom of the ages. A villain known as Mal''akh, a steroid-swollen, fantastically tattooed, muscle-bodied madman, wants to locate the wisdom so he can rule the world. Mal''akh has captured Peter and promises to kill him if Langdon doesn''t agree to help find the portal. Joining Langdon in his search is Peter''s younger sister, Kathleen, who has been conducting experiments in a secret museum. This is just the kickoff for a deadly chase that careens back and forth, across, above and below the nation''s capital, darting from revelation to revelation, pausing only to explain some piece of wondrous, historical esoterica. </p><p>Jealous thriller writers will despair, doubters and nay-sayers will be proved wrong, and readers will rejoice: Dan Brown has done it again.</p>'),
(121, 5, 14, '0.00'),
(122, 5, 20, '0.00'),
(123, 5, 15, '1.70'),
(124, 5, 21, '2'),
(125, 5, 22, '1'),
(126, 5, 17, 'The Lost Symbol'),
(127, 5, 18, 'The Lost Symbol, Books, Fiction Books, Education Books, Fiction / Science / Education / Entertainment, Dan Brown, The Lost Symbol, Da Vinci Code'),
(128, 5, 19, 'The Lost Symbol: Jealous thriller writers will despair, doubters and nay-sayers will be proved wrong, and readers will rejoice: Dan Brown has done it again.'),
(129, 5, 23, 'The_Lost_Symbol'),
(130, 5, 25, '5'),
(131, 5, 30, '385504225'),
(132, 5, 32, 'Dan Brown'),
(133, 5, 33, 'English'),
(134, 5, 34, '528'),
(135, 5, 35, '2009'),
(136, 6, 1, '3299.00'),
(137, 6, 2, ''),
(138, 6, 3, '59'),
(139, 6, 4, 'Comp-6'),
(140, 6, 5, ''),
(141, 6, 6, '19'),
(142, 6, 7, '3'),
(143, 6, 8, '2'),
(144, 6, 9, 'avactis-images/large_image.jpg'),
(145, 6, 10, 'avactis-images/thumbnail.jpg'),
(146, 6, 11, 'Apple Mac Pro Desktop'),
(147, 6, 12, 'The redesigned interior of the new Mac Pro feels like the well-organized workstation it is. No rat&rsquo;s nest of components here. You don&rsquo;t need to turn the system on its side or struggle to reach into awkward spaces to make changes. Just remove the side panel for instant, easy access to everything. Slide out the processor tray to add memory. Slide out hard drive bays to add storage. Slide a simple bar to change up to four expansion cards at once. And with plenty of I/O ports both front and back, you&rsquo;ll have room for all your external devices.'),
(148, 6, 13, 'The redesigned interior of the new Mac Pro feels like the well-organized workstation it is. <i>No rat&rsquo;s nest of components here.</i> You don&rsquo;t need to turn the system on its side or struggle to reach into awkward spaces to make changes. Just remove the side panel for instant, easy access to everything. Slide out the processor tray to add memory. Slide out hard drive bays to add storage. Slide a simple bar to change up to four expansion cards at once. And with plenty of I/O ports both front and back, you&rsquo;ll have room for all your external devices.<br /><br />Highly recyclable and even more energy efficient, the new Mac Pro is designed with the environment in mind.<br /><br />In the box:<br /><ul><li>Mac Pro</li><li>Power cord</li><li>Apple Keyboard with Numeric Keypad</li><li>Apple Mouse</li><li>USB keyboard extension cable</li><li>Install/restore DVDs</li><li>Printed and electronic documentation</li></ul><p>Included software:</p><ul><li>Mac OS X Snow Leopard</li><li>iLife</li></ul><p>&nbsp;</p>'),
(149, 6, 14, ''),
(150, 6, 15, ''),
(151, 6, 17, 'Apple Mac Pro Desktop'),
(152, 6, 18, 'laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(153, 6, 19, 'The redesigned interior of the new Mac Pro feels like the well-organized workstation it is. No rat''s nest of components here. You don''t need to turn the system on its side or struggle to reach into awkward spaces to make changes. Just remove the side panel for instant, easy access to everything. Slide out the processor tray to add memory. Slide out hard drive bays to add storage. Slide a simple bar to change up to four expansion cards at once. And with plenty of I/O ports both front and back, you''ll have room for all your external devices.'),
(154, 6, 20, ''),
(155, 6, 21, '2'),
(156, 6, 22, '1'),
(157, 6, 23, 'Apple_Mac_Pro_Desktop'),
(158, 6, 24, '1'),
(159, 6, 25, '5'),
(189, 8, 1, '1799.00'),
(190, 8, 2, ''),
(191, 8, 3, '59'),
(192, 8, 4, 'Comp-5'),
(193, 8, 5, ''),
(194, 8, 6, '19'),
(195, 8, 7, '3'),
(196, 8, 8, '2'),
(197, 8, 9, 'avactis-images/large_image_1.jpg'),
(198, 8, 10, 'avactis-images/thumbnail_1.jpg'),
(199, 8, 11, 'Apple MacBook Air'),
(200, 8, 12, 'MacBook Air is carved from a solid sheet of aluminum. This revolutionary unibody design replaces many parts with just one and results in a clean, seamless appearance. The anodized aluminum surface and stunning contours confirm MacBook Air as a feat of beautiful engineering.<br /><br />The thinness of MacBook Air is stirring. But even more impressive, there&rsquo;s a full-size, fully capable notebook encased in the 0.16 to 0.76 inch of sleek, sturdy anodized aluminum. And at just 3.0 pounds, MacBook Air is more than portable. It&rsquo;s with you everywhere you go.'),
(201, 8, 13, '<p><font color="#ff6600" size="2"><b><u>MacBook Air is carved from a solid sheet of aluminum.</u></b></font> </p><p>This revolutionary unibody design replaces many parts with just one and results in a clean, seamless appearance. The anodized aluminum surface and stunning contours confirm MacBook Air as a feat of beautiful engineering.<br /><br /><font color="#ff6600" size="2"><b><u>The thinness of MacBook Air is stirring.</u></b></font> </p><p>But even more impressive, there&rsquo;s a full-size, fully capable notebook encased in the 0.16 to 0.76 inch of sleek, sturdy anodized aluminum. And at just 3.0 pounds, MacBook Air is more than portable. It&rsquo;s with you everywhere you go.<br /><br /><font color="#ff6600"><b><font size="2"><u>The moment you open MacBook Air, you&rsquo;re greeted by instant full screen brightness.</u></font></b></font> </p><p>Its slim design doesn&rsquo;t compromise on size: The glossy 13.3-inch, widescreen LED-backlit MacBook Air display offers the same viewable size as the screen on the new 13-inch MacBook Pro. The 1280-by-800 resolution gives you vibrant images and rich colors, making it perfect for watching your own in-flight movies. And LED technology makes the display more power efficient, which translates into longer battery life.<br /><br />The keyboard is full size, and its backlit keys make it easy to work in the dim lighting of airplanes and conference halls. A built-in ambient light sensor automatically adjusts keyboard illumination and display brightness for optimal visibility. And with the spacious trackpad and support for Multi-Touch technology, you can get a lot done with a simple gesture or two.</p>'),
(202, 8, 14, ''),
(203, 8, 15, ''),
(204, 8, 17, 'Apple MacBook Air'),
(205, 8, 18, 'Apple MacBook Air, laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(206, 8, 19, 'MacBook Air is carved from a solid sheet of aluminum. This revolutionary unibody design replaces many parts with just one and results in a clean, seamless appearance. The anodized aluminum surface and stunning contours confirm MacBook Air as a feat of beautiful engineering.'),
(207, 8, 20, ''),
(208, 8, 21, '2'),
(209, 8, 22, '1'),
(210, 8, 23, 'Apple_MacBook_Air'),
(211, 8, 24, '1'),
(212, 8, 25, '5'),
(271, 11, 1, '999.00'),
(272, 11, 2, ''),
(273, 11, 3, '59'),
(274, 11, 4, 'Comp-1'),
(275, 11, 5, ''),
(276, 11, 6, '19'),
(277, 11, 7, '3'),
(278, 11, 8, '2'),
(279, 11, 9, 'avactis-images/large_image_4.jpg'),
(280, 11, 10, 'avactis-images/thumbnail_0.jpg'),
(281, 11, 11, 'Apple MacBook Laptop'),
(282, 11, 12, '<p>Durable unibody enclosure.<br /><br />A mere 1.08 inches thin and even lighter at 4.7 pounds, the sleek new MacBook cuts a slim profile on any desk (or in any backpack or briefcase). It features a new seamless, more durable unibody enclosure with rounded contours that make it easy to pick up and slide into and out of your bag. </p><p>And it&rsquo;s made of rugged polycarbonate that withstands the rough and tumble of everyday life &mdash; at school, at work, or while traveling. Even the bottom of the new MacBook feels different. Covering its entire surface is a nonslip material that keeps your MacBook right where you put it, whether on a desk, table, or airplane tray.</p>'),
(283, 11, 13, '<p>Durable unibody enclosure.<br /><br />A mere 1.08 inches thin and even lighter at 4.7 pounds, the sleek new MacBook cuts a slim profile on any desk (or in any backpack or briefcase). It features a new seamless, more durable unibody enclosure with rounded contours that make it easy to pick up and slide into and out of your bag. </p><p>And it&rsquo;s made of rugged polycarbonate that withstands the rough and tumble of everyday life &mdash; at school, at work, or while traveling. Even the bottom of the new MacBook feels different. Covering its entire surface is a nonslip material that keeps your MacBook right where you put it, whether on a desk, table, or airplane tray.</p><p>MacBook delivers the power of the Intel Core 2 Duo and a slew of innovative features, including a built-in iSight camera for video chatting on the go, iLife ''06, Front Row, and a glossy 13-inch widescreen display.</p><p>Good design leaves nothing to chance. Great design anticipates it. No surprise, then, that MacBook features little touches - like a klutz-proof power adapter and a nifty magnetic latch - that make your computing experience as streamlined as MacBook itself.</p><p><b>No power cord, no Ethernet cable, no headphone jack, no wires. No problem. With a long battery life and built-in AirPort and Bluetooth, you can get online virtually anywhere. It''s not magic. It''s MacBook.</b></p>'),
(284, 11, 14, ''),
(285, 11, 15, ''),
(286, 11, 17, 'Apple MacBook Laptop'),
(287, 11, 18, 'Apple MacBook Laptop, laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(288, 11, 19, 'Durable unibody enclosure. A mere 1.08 inches thin and even lighter at 4.7 pounds, the sleek new MacBook cuts a slim profile on any desk (or in any backpack or briefcase). It features a new seamless, more durable unibody enclosure with rounded contours that make it easy to pick up and slide into and out of your bag. And it''s made of rugged polycarbonate that withstands the rough and tumble of everyday life at school, at work, or while traveling. Even the bottom of the new MacBook feels different. Covering its entire surface is a nonslip material that keeps your MacBook right where you put it, whether on a desk, table, or airplane tray.'),
(289, 11, 20, ''),
(290, 11, 21, '2'),
(291, 11, 22, '1'),
(292, 11, 23, 'Apple_MacBook_Laptop'),
(293, 11, 24, '1'),
(294, 11, 25, '5'),
(377, 15, 1, '1999.00'),
(378, 15, 2, ''),
(379, 15, 3, '59'),
(380, 15, 4, 'Comp-7'),
(381, 15, 5, ''),
(382, 15, 6, '19'),
(383, 15, 7, '3'),
(384, 15, 8, '2'),
(385, 15, 9, 'avactis-images/large_image_0.jpg'),
(386, 15, 10, 'avactis-images/thumbnail_5.jpg'),
(387, 15, 11, 'Asus Eee Top PC'),
(388, 15, 12, '<p>The EeeTop PC minimalist design and slim form factor ensures a small desktop footprint. Its light and compact design makes it the ideal all-in-one, plug-and-play PC. That billing is further reinforced by its fast and easy start-up. So plug in the power cable and boot up, because the days of cluttered desktops and messy wiring are over.</p>'),
(389, 15, 13, '<p>The EeeTop PC minimalist design and slim form factor ensures a small desktop footprint. Its light and compact design makes it the ideal all-in-one, plug-and-play PC. That billing is further reinforced by its fast and easy start-up. So plug in the power cable and boot up, because the days of cluttered desktops and messy wiring are over.<br /><br />Everyday Computing and Multimedia Entertainment with a Sense of Style:</p> <ul><li>Blu-ray, Full HD 1080p, and HDMI compatibility provide the ultimate video experience</li><li>SRS Premium Sound &amp; Hi-Fi speakers for the ultimate audio experience</li><li>Exclusive touch-optimized software introduces a new level of interactive communication</li><li>Frameless display for an elegant and stylish design</li></ul> '),
(390, 15, 14, ''),
(391, 15, 15, ''),
(392, 15, 17, 'Asus Eee Top PC'),
(393, 15, 18, 'Asus Eee Top PC, laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(394, 15, 19, 'The EeeTop PC minimalist design and slim form factor ensures a small desktop footprint. Its light and compact design makes it the ideal all-in-one, plug-and-play PC. That billing is further reinforced by its fast and easy start-up. So plug in the power cable and boot up, because the days of cluttered desktops and messy wiring are over.'),
(395, 15, 20, ''),
(396, 15, 21, '2'),
(397, 15, 22, '1'),
(398, 15, 23, 'Asus_Eee_Top_PC'),
(399, 15, 24, '2'),
(400, 15, 25, '5'),
(454, 18, 1, '449.00'),
(455, 18, 2, '500.00'),
(456, 18, 3, '58'),
(457, 18, 4, 'Comp-19'),
(458, 18, 5, ''),
(459, 18, 6, '19'),
(460, 18, 7, '3'),
(461, 18, 8, '2'),
(462, 18, 9, 'avactis-images/large_image_9.jpg'),
(463, 18, 10, 'avactis-images/thumbnail_7.jpg'),
(464, 18, 11, 'Dell Inspiron Slim Desktop'),
(465, 18, 12, 'Fully expandable, fully customizable desktop designed for essential tasks and available with advanced technology options. <br /> <br /> Everything you want and nothing you don&rsquo;t. The InspironTM Slim desktop gives you the power to personalize everything down to the chassis color.'),
(466, 18, 13, 'Fully expandable, fully customizable desktop designed for essential tasks and available with advanced technology options. <br /><br />Everything you want and nothing you don&rsquo;t. The InspironTM Slim desktop gives you the power to personalize everything down to the chassis color.<br /><ul><li><font color="#000000"><b>Complement your style with a choice of 8 vibrant colors</b></font></li><li><font color="#000000"><b>Choose your power with up to an Intel&reg;&nbsp; Core&trade;2 Quad processor</b></font></li><li><font color="#000000"><b>Position its slim design vertically or horizontally in a media center</b></font></li></ul>'),
(467, 18, 14, ''),
(468, 18, 15, ''),
(469, 18, 17, 'Dell Inspiron Slim Desktop'),
(470, 18, 18, 'Dell Inspiron Slim Desktop, laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(471, 18, 19, 'Fully expandable, fully customizable desktop designed for essential tasks and available with advanced technology options. Everything you want and nothing you don''t. The InspironTM Slim desktop gives you the power to personalize everything down to the chassis color.'),
(472, 18, 20, ''),
(473, 18, 21, '2'),
(474, 18, 22, '1'),
(475, 18, 23, 'Dell_Inspiron_Slim_Desktop'),
(476, 18, 24, '3'),
(477, 18, 25, '5'),
(704, 28, 1, '499.99'),
(705, 28, 2, ''),
(706, 28, 3, '59'),
(707, 28, 4, 'Comp-9'),
(708, 28, 5, ''),
(709, 28, 6, '19'),
(710, 28, 7, '3'),
(711, 28, 8, '2'),
(712, 28, 9, 'avactis-images/Image9_TouchpadStylus.jpg'),
(713, 28, 10, 'avactis-images/Image9_TouchpadStylus111.jpg'),
(714, 28, 11, 'Asus Eee PC Touch'),
(715, 28, 12, 'Revolutionizing the world renowned Eee PC series, the Eee PC delivers ultimate portability and simplicity with an easy-to-use touchscreen that enables user to effortlessly navigate applications and the Web at a press of a finger.&nbsp; As big as a paperback novel, the lightweight Eee PC is the world&rsquo;s smallest and slimmest touch PC. Plus, it boasts long-lasting battery life with the energy-efficient Intel Atom processor, exclusive ASUS Super Hybrid Engine, and LED-backlit display, so you&rsquo;ll be able to easily bring the thin and light Eee PC whenever and wherever you go'),
(716, 28, 13, '<p><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="font-family: verdana,arial,helvetica,sans-serif; font-size: small"><p><font size="4"><b><font color="#ff6600">Key Features</font></b></font></p><ul style="margin: 1.12em 0px 1.12em 20px; padding: 0px; list-style-type: disc"><li style="margin: 0px 0px 0px 20px">8.9-inch touchscreen-enhanced Eee PC</li><li style="margin: 0px 0px 0px 20px">Panel rotates 180-degrees into tablet mode for ultra mobility</li><li style="margin: 0px 0px 0px 20px">Energy-efficient Intel Atom Z520 processor</li><li style="margin: 0px 0px 0px 20px">Long-lasting battery life with 5 hours of interrupted use</li><li style="margin: 0px 0px 0px 20px">Exclusive touch-optimized software suite</li><li style="margin: 0px 0px 0px 20px">52GB Hybrid Storage (16GB SSD + 16GB SD Card + 20GB Eee online Storage)</li><li style="margin: 0px 0px 0px 20px">Complete wirless connectivity with Bluetooth v2.1 and Wi-Fi 802.1 b/g/n&nbsp;</li><li style="margin: 0px 0px 0px 20px">Complimentary stylus for ultimate precision</li></ul></span></span>Revolutionizing the world renowned Eee PC series, the Eee PC delivers ultimate portability and simplicity with an easy-to-use touchscreen that enables user to effortlessly navigate applications and the Web at a press of a finger.As big as a paperback novel, the lightweight Eee PC is the world&rsquo;s smallest and slimmest touch PC. Plus, it boasts long-lasting battery life with the energy-efficient Intel Atom processor, exclusive ASUS Super Hybrid Engine, and LED-backlit display, so you&rsquo;ll be able to easily bring the thin and light Eee PC whenever and wherever you go.'),
(717, 28, 14, ''),
(718, 28, 15, ''),
(719, 28, 17, 'Asus Eee PC Touch'),
(720, 28, 18, 'Asus Eee PC Touch, laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(721, 28, 19, 'Revolutionizing the world renowned Eee PC series, the Eee PC delivers ultimate portability and simplicity with an easy-to-use touchscreen that enables user to effortlessly navigate applications and the Web at a press of a finger.  As big as a paperback novel, the lightweight Eee PC is the world''s smallest and slimmest touch PC. Plus, it boasts long-lasting battery life with the energy-efficient Intel Atom processor, exclusive ASUS Super Hybrid Engine, and LED-backlit display, so you''ll be able to easily bring the thin and light Eee PC whenever and wherever you go.'),
(722, 28, 20, ''),
(723, 28, 21, '2'),
(724, 28, 22, '1'),
(725, 28, 23, 'Asus_Eee_PC_Touch'),
(726, 28, 24, '2'),
(727, 28, 25, '5'),
(776, 31, 1, '799.99'),
(777, 31, 2, ''),
(778, 31, 3, '59'),
(779, 31, 4, 'Comp-10'),
(780, 31, 5, ''),
(781, 31, 6, '19'),
(782, 31, 7, '3'),
(783, 31, 8, '2'),
(784, 31, 9, 'avactis-images/detailed-1_14.jpg'),
(785, 31, 10, 'avactis-images/thumbnail_15.jpg'),
(786, 31, 11, 'HP TouchSmart'),
(787, 31, 12, 'From an elegant design to advanced features to a suite of built-for-touch applications, the HP TouchSmart redefines what you can do with a touch. This powerful, compact, wireless all-in-one with 20&quot; (diagonal) high-definition widescreen is ready to take up residence in your kitchen or family room.'),
(788, 31, 13, '<p>From an elegant design to advanced features to a suite of built-for-touch applications, the HP TouchSmart redefines what you can do with a touch. This powerful, compact, wireless all-in-one with 20&quot; (diagonal) high-definition widescreen is ready to take up residence in your kitchen or family room. <br /><br /><b>Amazing apps made easy</b></p><p>Experience your music, photos and video in a whole new way with our built-in TouchSmart apps. The touchable calendar and e-mail programs will help you stay organized, and video chat will let you keep in touch with everyone. You can also:<br /></p><ul><li>Instantly launch your favorite apps from HP TouchSmart Home</li><li>Experience the best of the Web &mdash; Hulu, Netflix, Twitter, Rhapsody, and more&mdash;in touch-enabled style</li><li>Import recipes from the Web; enter your own, and easily manage with HP Recipe Box</li><li>&quot;Write&quot; search criteria with your finger using the new search interface</li><li>Use touch to edit photos, and to choose songs and create playlists</li><li>Create and share collages with a simple touch using HP TouchSmart Canvas</li><li>Use your voice to zoom, rotate, and invert photos</li><li>Create professional-looking videos, slide shows, and movies</li><li>Watch movies on DVD; burn and edit home videos</li><li>Bookmark favorite movie scenes</li><li>Watch, pause, rewind, and record live TV with the optional dual-format NTSC and over-air ATSC high-definition TV tuner</li></ul>'),
(789, 31, 14, ''),
(790, 31, 15, ''),
(791, 31, 17, 'HP TouchSmart'),
(792, 31, 18, 'HP TouchSmart, laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(793, 31, 19, 'From an elegant design to advanced features to a suite of built-for-touch applications, the HP TouchSmart redefines what you can do with a touch. This powerful, compact, wireless all-in-one with 20" (diagonal) high-definition widescreen is ready to take up residence in your kitchen or family room.'),
(794, 31, 20, ''),
(795, 31, 21, '2'),
(796, 31, 22, '1'),
(797, 31, 23, 'HP_TouchSmart'),
(798, 31, 24, '-1'),
(799, 31, 25, '5'),
(800, 32, 1, '0.00'),
(801, 32, 2, ''),
(802, 32, 3, ''),
(803, 32, 4, 'Downloadable-1'),
(804, 32, 5, ''),
(805, 32, 6, ''),
(806, 32, 7, '3'),
(807, 32, 8, '1'),
(808, 32, 9, ''),
(809, 32, 10, 'avactis-images/pdf_1.jpg'),
(810, 32, 11, 'Avactis Shopping Cart PDF Manual'),
(811, 32, 12, '<p>Note that this is the <b>DEMO </b>store, you cannot purchase any products here. </p>  <b>Please download Avactis Shopping Cart PDF manual at: <a href="http://www.avactis.com/manuals.php">http://www.avactis.com/manuals.php</a></b><font face="arial,helvetica,sans-serif" size="2"><a href="http://www.avactis.com/manuals.php"><u><b></b></u></a></font>'),
(812, 32, 13, '<p>Note that this is the <b>DEMO </b>store, you cannot purchase any products here. </p><p>  <b>Please download Avactis Shopping Cart PDF manual at: <a href="http://www.avactis.com/manuals.php">http://www.avactis.com/manuals.php</a></b><br />&nbsp;</p><hr /><br />The Digital Products/E-Goods mechanism lets you sell electronic products such as software, images, music recordings, videos, and so on.<br /><br />To create a Digital Product, you create a product and then assign a number of files to it. When the customer orders the product, he or she is granted access to download these files.<br /><br />The buyer receives a confirmation by e-mail containing the links to file downloads. This confirmation is sent only after the order payment status is changed to Fully Paid.'),
(813, 32, 14, ''),
(814, 32, 15, ''),
(815, 32, 17, 'Avactis Shopping Cart PDF Manual - Downloadable products'),
(816, 32, 18, 'Avactis Shopping Cart PDF Manual, downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution'),
(817, 32, 19, 'The Digital Products/E-Goods mechanism lets you sell electronic products such as software, images, music recordings, videos, and so on. To create a Digital Product, you create a product and then assign a number of files to it. When the customer orders the product, he or she is granted access to download these files. The buyer receives a confirmation by e-mail containing the links to file downloads.'),
(818, 32, 20, ''),
(819, 32, 21, '2'),
(820, 32, 22, '1'),
(821, 32, 23, 'Avactis_Shopping_Cart_PDF_Manual_-_Downloadable_products'),
(822, 32, 24, '8'),
(823, 32, 25, '5'),
(848, 34, 1, '0.00'),
(824, 33, 1, '0.00'),
(825, 33, 2, ''),
(826, 33, 3, ''),
(827, 33, 4, 'Downloadable-2'),
(828, 33, 5, ''),
(829, 33, 6, ''),
(830, 33, 7, '3'),
(831, 33, 8, '1'),
(832, 33, 9, ''),
(833, 33, 10, 'avactis-images/download1.jpg'),
(849, 34, 2, ''),
(834, 33, 11, 'Avactis Shopping Cart Web Manual'),
(835, 33, 12, '<p>Note that this is the <b>DEMO </b>store, you cannot purchase any products here. </p>  <b>Please download Avactis Shopping Cart manual at: <a href="http://www.avactis.com/manuals.php">http://www.avactis.com/manuals.php</a></b>'),
(836, 33, 13, '<p>Note that this is the <b>DEMO </b>store, you cannot purchase any products here. </p><p>  <b>Please download Avactis Shopping Cart manual at: <a href="http://www.avactis.com/manuals.php">http://www.avactis.com/manuals.php</a></b><br />&nbsp;</p><hr /><br />The Digital Products/E-Goods mechanism lets you sell electronic products such as software, images, music recordings, videos, and so on.<br /><br />To create a Digital Product, you create a product and then assign a number of files to it. When the customer orders the product, he or she is granted access to download these files.<br /><br />The buyer receives a confirmation by e-mail containing the links to file downloads. This confirmation is sent only after the order payment status is changed to Fully Paid.'),
(837, 33, 14, ''),
(838, 33, 15, ''),
(839, 33, 17, 'Avactis Shopping Cart Web Manual - Downloadable products'),
(840, 33, 18, 'Avactis Shopping Cart Web Manual, downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution'),
(841, 33, 19, 'The Digital Products/E-Goods mechanism lets you sell electronic products such as software, images, music recordings, videos, and so on. To create a Digital Product, you create a product and then assign a number of files to it. When the customer orders the product, he or she is granted access to download these files. The buyer receives a confirmation by e-mail containing the links to file downloads. This confirmation is sent only after the order payment status is changed to Fully Paid.'),
(842, 33, 20, ''),
(843, 33, 21, '2'),
(844, 33, 22, '1'),
(845, 33, 23, 'Avactis_Shopping_Cart_Web_Manual_-_Downloadable_products'),
(846, 33, 24, '8'),
(847, 33, 25, '5'),
(850, 34, 3, ''),
(851, 34, 4, 'Downloadable-3'),
(852, 34, 5, ''),
(853, 34, 6, ''),
(854, 34, 7, '3'),
(855, 34, 8, '1'),
(856, 34, 9, ''),
(857, 34, 10, 'avactis-images/download1_0.jpg'),
(858, 34, 11, 'Avactis Shopping Cart Free Edition'),
(859, 34, 12, '<p>Note that this is the <b>DEMO </b>store, you cannot purchase any products here. </p>  <b>Please download Avactis Shopping Cart Free Edition at: <a href="http://www.avactis.com/free_shopping_cart.php">http://www.avactis.com/free_shopping_cart.php</a></b><font face="arial,helvetica,sans-serif" size="2"><a href="http://www.avactis.com/free_shopping_cart.php"><u><b></b></u></a></font>'),
(860, 34, 13, '<p>Note that this is the <b>DEMO </b>store, you cannot purchase any products here. </p>  <b>Please download Avactis Shopping Cart Free Edition at: <a href="http://www.avactis.com/free_shopping_cart.php">http://www.avactis.com/free_shopping_cart.php</a></b><br /><a href="https://www.avactis.com/free_shopping_cart.php"><br /></a><hr /><br />Although some functionality of Avactis Free edition is limited, you can use it to create a production Ecommerce store.<br /><br />To comapre the various Avactis editions (including Free, Owned and White Label editions), visit the <a href="http://www.avactis.com/compare_avactis_editions.php">Avactis Editions</a> page.<a href="https://www.avactis.com/free_shopping_cart.php"><br /></a>'),
(861, 34, 14, ''),
(862, 34, 15, ''),
(863, 34, 17, 'Avactis Shopping Cart Free Edition - Downloadable products'),
(864, 34, 18, 'Avactis Shopping Cart Free Edition, downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution'),
(865, 34, 19, 'Avactis Shopping Cart Free Edition. Although some functionality of Avactis Free edition is limited, you can use it to create a production Ecommerce store.'),
(866, 34, 20, ''),
(867, 34, 21, '2'),
(868, 34, 22, '1'),
(869, 34, 23, 'Avactis_Shopping_Cart_Free_Edition_-_Downloadable_products'),
(870, 34, 24, '8'),
(871, 34, 25, '5'),
(872, 35, 1, '25.99'),
(873, 35, 2, '29.00'),
(874, 35, 3, ''),
(875, 35, 4, 'T-Shirt-1'),
(876, 35, 5, ''),
(877, 35, 6, ''),
(878, 35, 7, '3'),
(879, 35, 8, '1'),
(880, 35, 9, 'avactis-images/1111_0.jpg'),
(881, 35, 10, 'avactis-images/11111.jpg'),
(882, 35, 11, 'Custom T-Shirt - Upload your own design'),
(883, 35, 12, '<font size="4" face="arial,helvetica,sans-serif"><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="color: #333333; font-family: Arial,Helvetica,sans-serif; font-size: 12px; text-align: left"><font size="4">Design your tee in minutes! Simply upload your photos and/or artwork, personalize with text, and order. </font></span></span></font>'),
(884, 35, 13, '<p><font size="4" face="arial,helvetica,sans-serif"><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="color: #333333; font-family: Arial,Helvetica,sans-serif; font-size: 12px; text-align: left"><font size="4">Design your tee in minutes! Simply upload your photos and/or artwork, personalize with text, and order. </font><b><br /></b></span></span></font></p><ul><li><font size="2" face="arial,helvetica,sans-serif"><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="color: #333333; font-family: Arial,Helvetica,sans-serif; font-size: 12px; text-align: left"></span></span>High quality, full color printing &mdash; great for photo tees. <br /></font></li><li><font size="2" face="arial,helvetica,sans-serif">Fast shipping on all personalized T-shirts. 100% satisfaction guarantee.</font><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="color: #333333; font-family: Arial,Helvetica,sans-serif; font-size: 12px; text-align: left"></span></span></li></ul><span class="Apple-style-span" style="border-collapse: separate; color: #000000; font-family: ''Times New Roman''; font-size: medium; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px"><span class="Apple-style-span" style="color: #333333; font-family: Arial,Helvetica,sans-serif; font-size: 12px; text-align: left"></span></span>'),
(885, 35, 14, ''),
(886, 35, 15, ''),
(887, 35, 17, 'Custom T-Shirt - Upload your own design'),
(888, 35, 18, 'Custom T-Shirt, Upload your own design, T-Shirts, TShirts, Tee Shirts, T-Shirt, TShirt, shirts'),
(889, 35, 19, 'Design your tee in minutes! Simply upload your photos and/or artwork, personalize with text, and order. High quality, full color printing Ã¢â‚¬â€ great for photo tees. Fast shipping on all personalized T-shirts. 100% satisfaction guarantee.'),
(890, 35, 20, ''),
(891, 35, 21, '2'),
(892, 35, 22, '1'),
(893, 35, 23, 'Custom_T-Shirt_-_Upload_your_own_design'),
(894, 35, 24, '-1'),
(895, 35, 25, '5'),
(896, 36, 1, '15.99'),
(897, 36, 2, '17.80'),
(898, 36, 3, '24'),
(899, 36, 4, 'T-Shirt-2'),
(900, 36, 5, ''),
(901, 36, 6, ''),
(902, 36, 7, '3'),
(903, 36, 8, '1'),
(904, 36, 9, 'avactis-images/avtb.jpg'),
(905, 36, 10, 'avactis-images/avts.jpg'),
(906, 36, 11, 'Avactis T-Shirt'),
(907, 36, 12, '<font size="2"><b><font face="arial,helvetica,sans-serif">Avactis T-Shirt<br /></font></b></font><ul><li><font size="2"><b><font face="arial,helvetica,sans-serif">Fitted</font></b></font></li><li><font size="2"><b><font face="arial,helvetica,sans-serif">Short length sleeves </font></b></font></li><li><font size="2"><b><font face="arial,helvetica,sans-serif">93% Cotton, 7% Elastane</font></b></font></li></ul>'),
(908, 36, 13, '<p><font size="3"><b><font face="arial,helvetica,sans-serif">Avactis T-Shirt<br /></font></b></font></p><ul><li><font size="3"><b><font face="arial,helvetica,sans-serif">Fitted</font></b></font></li><li><font size="3"><b><font face="arial,helvetica,sans-serif">Short length sleeves </font></b></font></li><li><font size="3"><b><font face="arial,helvetica,sans-serif">93% Cotton, 7% Elastane<br /><br /></font></b></font></li></ul><p><font size="3">Styling features include twin needle stitching for neatness and strength on the collar, sleeve and hem. </font></p><p><font size="3">The neck is taped neck for comfort. The fabric is made from soft single jersey.This product is made from tubular fabric so there are no side seams on these T-shirts.</font></p>'),
(920, 37, 1, '23.99'),
(921, 37, 2, '26.70'),
(922, 37, 3, '119'),
(923, 37, 4, 'DVD-1'),
(924, 37, 5, ''),
(925, 37, 6, '35'),
(926, 37, 7, '3'),
(927, 37, 8, '1'),
(928, 37, 9, 'avactis-images/hous-2.jpg'),
(929, 37, 10, 'avactis-images/hous-1.jpg'),
(930, 37, 11, 'House M.D. - Season 4 - DVD'),
(931, 37, 12, '<p><font size="2" face="arial,helvetica,sans-serif">Prepare for even more baffling, complex, and shocking medical mysteries than ever before as every Season 4 episode of <i>House, M.D.</i> arrives on DVD! </font></p><p><font size="2" face="arial,helvetica,sans-serif">Reunite with the perplexing and prickly Dr. Gregory House (Hugh Laurie) as he tackles impossible cases while putting a new staff of potential team members -- including Dr. Lawrence Kutner (Kal Penn), Dr. Chris Taub (Peter Jacobson), and Dr. Hadley (Olivia Wilde), more commonly known as &quot;Thirteen&quot; thanks to a nickname bestowed by House -- through the medical wringer with House''s trademark sarcasm and irreverent bedside manner. </font></p><p><font size="2" face="arial,helvetica,sans-serif">All 16 episodes of Season 4 (2007-8) are offered on four discs.</font></p>'),
(932, 37, 13, '<p><font size="4" face="arial,helvetica,sans-serif">Prepare for even more baffling, complex, and shocking medical mysteries than ever before as every Season 4 episode of <i>House, M.D.</i> arrives on DVD! <br /><br /></font></p><p><font size="3" face="arial,helvetica,sans-serif">Reunite with the perplexing and prickly Dr. Gregory House (Hugh Laurie) as he tackles impossible cases while putting a new staff of potential team members -- including Dr. Lawrence Kutner (Kal Penn), Dr. Chris Taub (Peter Jacobson), and Dr. Hadley (Olivia Wilde), more commonly known as &quot;Thirteen&quot; thanks to a nickname bestowed by House -- through the medical wringer with House''s trademark sarcasm and irreverent bedside manner.<br /><br /> </font></p><p><font size="3"><b><font face="arial,helvetica,sans-serif">All 16 episodes of Season 4 (2007-8) are offered on four discs.</font></b></font></p>'),
(909, 36, 14, ''),
(910, 36, 15, ''),
(911, 36, 17, 'Avactis T-Shirt'),
(912, 36, 18, 'Avactis T-Shirt, custom T-Shirt, T-Shirts, TShirts, Tee Shirts, T-Shirt, TShirt, shirts'),
(913, 36, 19, 'Avactis T-Shirt, fitted, short length sleeves, 93% Cotton, 7% Elastane'),
(914, 36, 20, ''),
(915, 36, 21, '2'),
(916, 36, 22, '1'),
(917, 36, 23, 'Avactis_T-Shirt'),
(918, 36, 24, '-1'),
(919, 36, 25, '5'),
(933, 37, 14, ''),
(934, 37, 15, ''),
(935, 37, 17, 'House M.D. - Season 4 - DVD'),
(936, 37, 18, 'House M.D. - Season 4 - DVD, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(937, 37, 19, 'Prepare for even more baffling, complex, and shocking medical mysteries than ever before as every Season 4 episode of House, M.D. arrives on DVD!\r\n\r\nReunite with the perplexing and prickly Dr. Gregory House (Hugh Laurie) as he tackles impossible cases while putting a new staff of potential team members -- including Dr. Lawrence Kutner (Kal Penn), Dr. Chris Taub (Peter Jacobson), and Dr. Hadley (Olivia Wilde), more commonly known as "Thirteen" thanks to a nickname bestowed by House -- through the medical wringer with House''s trademark sarcasm and irreverent bedside manner.\r\n\r\nAll 16 episodes of Season 4 (2007-8) are offered on four discs.'),
(938, 37, 20, ''),
(939, 37, 21, '2'),
(940, 37, 22, '1'),
(941, 37, 23, 'House_M_D_-_Season_4_-_DVD'),
(942, 37, 24, '-1'),
(943, 37, 25, '5'),
(1200, 47, 1, '13.99'),
(1201, 47, 2, '15.60'),
(1202, 47, 3, ''),
(1203, 47, 4, 'T-Shirt-4'),
(1204, 47, 5, ''),
(1205, 47, 6, ''),
(1206, 47, 7, '3'),
(1207, 47, 8, '1'),
(1208, 47, 9, 'avactis-images/t1b.jpg'),
(1209, 47, 10, 'avactis-images/thumb_t1b.jpg'),
(1210, 47, 11, 'Pure cotton T-Shirt'),
(1211, 47, 12, '<font size="2" face="arial,helvetica,sans-serif">This t-shirt is the classic T!<br /></font><ul><li><font size="2" face="arial,helvetica,sans-serif">Relaxed fit </font></li><li><font size="2" face="arial,helvetica,sans-serif">Short length sleeves </font></li><li><font size="2" face="arial,helvetica,sans-serif">100% Green Cotton&nbsp; </font></li></ul>'),
(1212, 47, 13, '<font size="3" face="arial,helvetica,sans-serif"><b>This T-shirt is the classic T!<br /></b><br /> </font> <ul><li><font size="3" face="arial,helvetica,sans-serif">Relaxed fit </font></li><li><font size="3" face="arial,helvetica,sans-serif">Short length sleeves </font></li><li><font size="3" face="arial,helvetica,sans-serif">100% Green Cotton&nbsp; </font></li></ul><br /><br /><p><font size="3">Styling features include twin needle stitching for neatness and strength on the collar, sleeve and hem. </font></p><p><font size="3">The neck is taped neck for comfort. The fabric is made from soft single jersey.This product is made from tubular fabric so there are no side seams on these T-shirts.</font></p>'),
(1213, 47, 14, ''),
(1214, 47, 15, ''),
(1215, 47, 17, 'Pure cotton T-Shirt'),
(1216, 47, 18, 'Pure cotton T-Shirt, T-Shirts, TShirts, Tee Shirts, T-Shirt, TShirt, shirts'),
(1217, 47, 19, 'This t-shirt is the classic T, Relaxed fit, Short length sleeves,  100% Green Cotton'),
(1218, 47, 20, ''),
(1219, 47, 21, '2'),
(1220, 47, 22, '1'),
(1221, 47, 23, 'Pure_cotton_T-Shirt'),
(1222, 47, 24, '-1'),
(1223, 47, 25, '5'),
(1614, 63, 1, '54.95'),
(1615, 63, 2, ''),
(1616, 63, 3, '22'),
(1617, 63, 4, 'SKU-0051'),
(1618, 63, 5, ''),
(1619, 63, 6, '3'),
(1620, 63, 7, '3'),
(1621, 63, 8, '2'),
(1639, 63, 9, 'avactis-images/pimage_51_001_0.jpg'),
(1638, 63, 10, 'avactis-images/pimage_51_0.gif'),
(1624, 63, 11, ''),
(1625, 63, 12, '<p>Add your warmest congratulations with a delightful bouquet filling a 24% full lead crystal block with happy blossoms. It&rsquo;s stork-ready, with same-day delivery.</p>'),
(1626, 63, 13, '<p>Add your warmest congratulations with a delightful bouquet filling a 24% full lead crystal block with happy blossoms. It&rsquo;s stork-ready, with same-day delivery.</p><ul><li><b>Roses</b>, <b>snapdragons </b>and <b>tulips </b>arrive in a crystal baby block. </li><li>Available in pink or blue. </li><li>Indicate preference in the special instructions field at checkout. </li><li>Approximately 10&quot; W x 13&quot; H </li><li>This item is hand-arranged and delivered by a Teleflora florist.</li></ul>'),
(1627, 63, 14, '14.97'),
(1628, 63, 15, '1.01'),
(1629, 63, 17, 'Teleflora''s Crystal Baby Block'),
(1630, 63, 18, 'Flowers, Flores, Flower Arrangements, Florists, Online Florist, Florals, Flower Delivery, Gift Baskets, Bouquets '),
(1631, 63, 19, 'Teleflora''s Crystal Baby Block.'),
(1632, 63, 20, '1.01'),
(1633, 63, 21, '2'),
(1634, 63, 22, '1'),
(1635, 63, 23, 'Teleflora_Crystal_Baby_Block'),
(1636, 63, 24, '-1'),
(1637, 63, 25, '5'),
(1666, 65, 1, '44.95'),
(1667, 65, 2, ''),
(1668, 65, 3, '28'),
(1669, 65, 4, 'SKU-0044'),
(1670, 65, 5, ''),
(1671, 65, 6, '4'),
(1672, 65, 7, '3'),
(1673, 65, 8, '2'),
(1691, 65, 9, 'avactis-images/pimage_44_002_0.jpg'),
(1690, 65, 10, 'avactis-images/pimage_44_001_0.jpg'),
(1676, 65, 11, ''),
(1677, 65, 12, '<p>Welcome the little duckling to the flock with our cute-as-a-button ceramic duck filled with yellow and white blooms. After the flowers fade, the duck can store tiny supplies. <br />Boy or girl versions available. Indicate preference in the special instructions.</p>'),
(1678, 65, 13, '<p>Welcome the little duckling to the flock with our cute-as-a-button ceramic duck filled with yellow and white blooms. After the flowers fade, the duck can store tiny supplies. <br /><br />Boy or girl versions available. Indicate preference in the special instructions.</p><ul><li>Spray <b>Roses</b>, <b>Chrysanthemums</b>, <b>Mini Carnations</b>, <b>Gypsophilia</b>, and <b>Oregonia</b> arrive in a ceramic duck. </li><li><b>Ducky </b>measures <b>8 1/4&quot; H x 7 &quot; W x 8 1/2&quot; L</b>. </li><li><b>Arrangement </b>approximately <b>10&quot; H x 10&quot; W</b>. </li><li>This item is hand-arranged and delivered by a Teleflora florist. </li></ul>'),
(1679, 65, 14, '1.11'),
(1680, 65, 15, '1.01'),
(1681, 65, 17, 'Teleflora''s Just Ducky Bouquet'),
(1682, 65, 18, 'Flowers, Flores, Flower Arrangements, Florists, Online Florist, Florals, Flower Delivery, Gift Baskets, Bouquets '),
(1683, 65, 19, 'Teleflora''s Just Ducky Bouquet'),
(1684, 65, 20, '1.05'),
(1685, 65, 21, '2'),
(1686, 65, 22, '1'),
(1687, 65, 23, 'Teleflora_Just_Ducky_Bouquet'),
(1688, 65, 24, '-1'),
(1689, 65, 25, '5'),
(1822, 71, 1, '34.95'),
(1823, 71, 2, ''),
(1824, 71, 3, '20'),
(1825, 71, 4, 'SKU-0056'),
(1826, 71, 5, ''),
(1827, 71, 6, '3'),
(1828, 71, 7, '3'),
(1829, 71, 8, '2'),
(1847, 71, 9, 'avactis-images/pimage_56_002_0.jpg'),
(1846, 71, 10, 'avactis-images/pimage_56_001_0.jpg'),
(1832, 71, 11, ''),
(1833, 71, 12, '<p>The contemporary silvery heart vase is a real stunner, something she&#39;ll treasure for years. And the red gerberas? Sweet, simple &mdash; just the right expression of affection for someone who might just be The One.</p>'),
(1834, 71, 13, '<p>The contemporary silvery heart vase is a real stunner, something she&#39;ll treasure for years. And the red gerberas? Sweet, simple &mdash; just the right expression of affection for someone who might just be The One.</p><ul><li>A ceramic heart vase with a silver finish, featuring three radiantly red gerberas, accented with lily grass and Ming fern. </li><li>Approximately 13&quot; (W) x 17&quot; (H) </li><li>This item is hand-arranged and delivered by a Teleflora florist</li></ul>'),
(1835, 71, 14, '1.12'),
(1836, 71, 15, '1.01'),
(1837, 71, 17, 'Teleflora''s Young at Heart Bouquet'),
(1838, 71, 18, 'Flowers, Flores, Flower Arrangements, Florists, Online Florist, Florals, Flower Delivery, Gift Baskets, Bouquets '),
(1839, 71, 19, 'Teleflora''s Young at Heart Bouquet.'),
(1840, 71, 20, '1.02'),
(1841, 71, 21, '2'),
(1842, 71, 22, '1'),
(1843, 71, 23, 'Teleflora_Young_at_Heart_Bouquet'),
(1844, 71, 24, '-1'),
(1845, 71, 25, '5'),
(2291, 89, 1, '23.99'),
(2292, 89, 2, ''),
(2293, 89, 3, '119'),
(2294, 89, 4, 'DVD-6'),
(2295, 89, 5, ''),
(2296, 89, 6, '35'),
(2297, 89, 7, '3'),
(2298, 89, 8, '1'),
(2299, 89, 9, 'avactis-images/hous-2_2.jpg'),
(2300, 89, 10, 'avactis-images/thumb_hous-2_2.jpg'),
(2301, 89, 11, 'Lost - Season 5'),
(2302, 89, 12, '&quot;When am I?&quot; John Locke''s chronological confusion sums up <i>Season 5</i>, which hopscotches dizzyingly between the 1970s and 2008 as it charts the Oceanic Six''s return to the island and reveals important island secrets. On the island, Locke (Terry O''Quinn) is the new leader of the Others. But in L.A., he''s dead, and his death plays a key role in getting Jack (Matthew Fox), Kate (Evangeline Lilly), Hurley (Jorge Garcia) and Sun (Yunjin Kim) to return via Ajira Airways. Sayid (Naveen Andrews) refuses to join his fellow former castaways, but winds up being escorted onto the Guam-bound flight by a bounty hunter named Ilana (Zuleikha Robinson). Ben (Michael Emerson) must return, too, to face judgment for allowing his daughter Alex to die. Their flight -- with Frank Lapidus (Jeff Fahey) at the controls -- is a bumpy one, but the final destination is indeed the island. Ben, Sun, Ilana and Frank remain fixed in time upon their return to the island, but Jack, Kate, Hurley and Sayid are flashed back in time to 1977, where they are reunited with Sawyer (Josh Holloway) and Juliet (Elizabeth Mitchell). After surviving a series of time-travel flashes, Sawyer and Juliet landed in the 1970s and forged a close relationship with each other and the Dharma Initiative, which also welcomes Miles Straume (Ken Leung). Meanwhile, Miles'' colleague Daniel Faraday (Jeremy Davies) embarks on a time-traveling mission that introduces him to a nuclear bomb named Jughead and a young woman named Ellie. Both play prominent roles as the season progresses.'),
(2303, 89, 13, '&quot;When am I?&quot; John Locke''s chronological confusion sums up <i>Season 5</i>, which hopscotches dizzyingly between the 1970s and 2008 as it charts the Oceanic Six''s return to the island and reveals important island secrets. On the island, Locke (Terry O''Quinn) is the new leader of the Others. But in L.A., he''s dead, and his death plays a key role in getting Jack (Matthew Fox), Kate (Evangeline Lilly), Hurley (Jorge Garcia) and Sun (Yunjin Kim) to return via Ajira Airways. Sayid (Naveen Andrews) refuses to join his fellow former castaways, but winds up being escorted onto the Guam-bound flight by a bounty hunter named Ilana (Zuleikha Robinson). Ben (Michael Emerson) must return, too, to face judgment for allowing his daughter Alex to die. Their flight -- with Frank Lapidus (Jeff Fahey) at the controls -- is a bumpy one, but the final destination is indeed the island. Ben, Sun, Ilana and Frank remain fixed in time upon their return to the island, but Jack, Kate, Hurley and Sayid are flashed back in time to 1977, where they are reunited with Sawyer (Josh Holloway) and Juliet (Elizabeth Mitchell). After surviving a series of time-travel flashes, Sawyer and Juliet landed in the 1970s and forged a close relationship with each other and the Dharma Initiative, which also welcomes Miles Straume (Ken Leung). Meanwhile, Miles'' colleague Daniel Faraday (Jeremy Davies) embarks on a time-traveling mission that introduces him to a nuclear bomb named Jughead and a young woman named Ellie. Both play prominent roles as the season progresses.'),
(2304, 89, 14, ''),
(2305, 89, 15, ''),
(2306, 89, 17, 'Lost - Season 5'),
(2307, 89, 18, 'Lost - Season 5, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2308, 89, 19, '"When am I?" John Locke''s chronological confusion sums up Season 5, which hopscotches dizzyingly between the 1970s and 2008 as it charts the Oceanic Six''s return to the island and reveals important island secrets.'),
(2309, 89, 20, ''),
(2310, 89, 21, '2'),
(2311, 89, 22, '1'),
(2312, 89, 23, 'Lost_-_Season_5'),
(2313, 89, 24, '-1'),
(2314, 89, 25, '5'),
(2315, 90, 1, '23.99'),
(2316, 90, 2, '');
INSERT INTO `[[dbprefix]]product_attributes` VALUES
(2317, 90, 3, '119'),
(2318, 90, 4, 'Kids-DVD-1'),
(2319, 90, 5, ''),
(2320, 90, 6, '35'),
(2321, 90, 7, '3'),
(2322, 90, 8, '1'),
(2323, 90, 9, 'hous-2_3.jpg'),
(2324, 90, 10, 'thumb_hous-2_3.jpg'),
(2325, 90, 11, 'Up'),
(2326, 90, 12, 'A feisty septuagenarian teams with a fearless wilderness ranger to do battle with a vicious band of beasts and villains in this computer-animated adventure scripted by Pixar veteran Bob Peterson and co-directed by Peterson and Monsters, Inc. director Peter Docter. Carl Fredricksen is a 78-year-old balloon salesman. His entire life, Carl has longed to wander the wilds of South America. Then, one day, the irascible senior citizen shocks his neighbors by tying thousands of balloons to his home and finally taking flight. But Carl isn''t alone on his once-in-a-lifetime journey, because stowed away on his front porch is an excitable eight-year-old wilderness explorer named Russell. Later, as the house touches down on the world''s second largest continent, Carl and his unlikely traveling companion step outside to discover that not only is their new front lawn considerably larger, but that the predators therein are much more ferocious than anything they ever faced back home.'),
(2327, 90, 13, 'A feisty septuagenarian teams with a fearless wilderness ranger to do battle with a vicious band of beasts and villains in this computer-animated adventure scripted by Pixar veteran Bob Peterson and co-directed by Peterson and Monsters, Inc. director Peter Docter. Carl Fredricksen is a 78-year-old balloon salesman. His entire life, Carl has longed to wander the wilds of South America. Then, one day, the irascible senior citizen shocks his neighbors by tying thousands of balloons to his home and finally taking flight. But Carl isn''t alone on his once-in-a-lifetime journey, because stowed away on his front porch is an excitable eight-year-old wilderness explorer named Russell. Later, as the house touches down on the world''s second largest continent, Carl and his unlikely traveling companion step outside to discover that not only is their new front lawn considerably larger, but that the predators therein are much more ferocious than anything they ever faced back home.'),
(2328, 90, 14, ''),
(2329, 90, 15, ''),
(2330, 90, 17, 'Up'),
(2331, 90, 18, 'Up, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2332, 90, 19, 'A feisty septuagenarian teams with a fearless wilderness ranger to do battle with a vicious band of beasts and villains in this computer-animated adventure scripted by Pixar veteran Bob Peterson and co-directed by Peterson and Monsters, Inc. director Peter Docter. Carl Fredricksen is a 78-year-old balloon salesman. His entire life, Carl has longed to wander the wilds of South America. Then, one day, the irascible senior citizen shocks his neighbors by tying thousands of balloons to his home and finally taking flight. But Carl isn''t alone on his once-in-a-lifetime journey, because stowed away on his front porch is an excitable eight-year-old wilderness explorer named Russell. Later, as the house touches down on the world''s second largest continent, Carl and his unlikely traveling companion step outside to discover that not only is their new front lawn considerably larger, but that the predators therein are much more ferocious than anything they ever faced back home.'),
(2333, 90, 20, ''),
(2334, 90, 21, '2'),
(2335, 90, 22, '1'),
(2336, 90, 23, 'Up'),
(2337, 90, 24, '-1'),
(2338, 90, 25, '5'),
(2339, 91, 1, '23.99'),
(2340, 91, 2, '26.70'),
(2341, 91, 3, '119'),
(2342, 91, 4, 'Kids-DVD-2'),
(2343, 91, 5, ''),
(2344, 91, 6, '35'),
(2345, 91, 7, '3'),
(2346, 91, 8, '1'),
(2347, 91, 9, 'avactis-images/hous-1_2.jpg'),
(2348, 91, 10, 'avactis-images/thumb_hous-1_2.jpg'),
(2349, 91, 11, 'Ice Age 3 - Dawn of the Dinosaurs & Scrat Pack'),
(2350, 91, 12, '<p><font size="2" face="arial,helvetica,sans-serif">After the events of &quot;Ice Age: The Meltdown&quot;, life begins to change for Manny and his friends: Scrat is still on the hunt to hold onto his beloved acorn, while finding a possible romance in a female sabre-toothed squirrel named Scratte. Manny and Ellie, having since become an item, are expecting a baby, which leaves Manny anxious to ensure that everything is perfect for when his baby arrives. </font></p><p><font size="2" face="arial,helvetica,sans-serif">Diego is fed up with being treated like a house-cat and ponders the notion that he is becoming too laid-back. Sid begins to wish for a family of his own, and so steals some dinosaur eggs which leads to Sid ending up in a strange underground world where his herd must rescue him, while dodging dinosaurs and facing danger left and right, and meeting up with a one-eyed weasel known as Buck who hunts dinosaurs intently.</font></p>'),
(2351, 91, 13, '<p><font size="3" face="arial,helvetica,sans-serif">After the events of &quot;Ice Age: The Meltdown&quot;, life begins to change for Manny and his friends: Scrat is still on the hunt to hold onto his beloved acorn, while finding a possible romance in a female sabre-toothed squirrel named Scratte. Manny and Ellie, having since become an item, are expecting a baby, which leaves Manny anxious to ensure that everything is perfect for when his baby arrives. </font></p><p><font size="3" face="arial,helvetica,sans-serif">Diego is fed up with being treated like a house-cat and ponders the notion that he is becoming too laid-back. Sid begins to wish for a family of his own, and so steals some dinosaur eggs which leads to Sid ending up in a strange underground world where his herd must rescue him, while dodging dinosaurs and facing danger left and right, and meeting up with a one-eyed weasel known as Buck who hunts dinosaurs intently.</font></p>'),
(2352, 91, 14, ''),
(2353, 91, 15, ''),
(2354, 91, 17, 'Ice Age 3 - Dawn of the Dinosaurs'),
(2355, 91, 18, 'Ice Age 3 - Dawn of the Dinosaurs & Scrat Pack, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2356, 91, 19, 'The fun continues as Diego, Manny, and Sid all return for another round of prehistoric fun in this installment of the popular computer-animated children''s series. '),
(2357, 91, 20, ''),
(2358, 91, 21, '2'),
(2359, 91, 22, '1'),
(2360, 91, 23, 'Ice_Age_3_-_Dawn_of_the_Dinosaurs___Scrat_Pack'),
(2361, 91, 24, '-1'),
(2362, 91, 25, '5'),
(2483, 97, 1, '33.45'),
(2484, 97, 2, ''),
(2485, 97, 3, '119'),
(2486, 97, 4, 'Kids-DVD-8'),
(2487, 97, 5, ''),
(2488, 97, 6, '35'),
(2489, 97, 7, '3'),
(2490, 97, 8, '1'),
(2491, 97, 9, 'avactis-images/hous-2_7.jpg'),
(2492, 97, 10, 'avactis-images/thumb_hous-2_7.jpg'),
(2493, 97, 11, 'Harry Potter Collection Years 1-5'),
(2494, 97, 12, 'For all but the most nitpicking Potter-philes out there, Harry Potter and the Sorcerer''s Stone is nothing less than the perfect visual incarnation of J.K. Rowling''s world of swooping owls and flying broomsticks. However, it''s never precisely more than that, either; the very act of giving image and voice to these rich literary precepts places them in a realm inevitably less magical than the imagination. Still, it''s hard to picture a more essentially faithful adaptation of Rowling''s tone and story, which weighs in at a hefty two and a half hours despite streamlining some of the more vestigial elements of a quick 300-page read. Steve Kloves'' adaptation of the wildly popular bestseller lingers less on some of the episodic Hogwarts'' adventures, only briefly touching on such red herring plot points as the wise centaur and Hagrid''s dragon. The eye-popping visuals have numerous other opportunities to shine, chief among them the grippingly rendered Quidditch match, in which players on broomsticks zoom and jockey like the speeder bikes of Endor in Return of the Jedi. It''s no surprise that Harry Potter should occasionally invoke a Star Wars movie, since its hero is an orphaned boy who yearns for a destiny beyond what his aunt and uncle can provide, and who possesses unparalleled mystical powers that the dark side seeks to corrupt. The landscape Chris Columbus and cinematographer John Seale have created with its levitating banquet hall decorations, animated games of wizard chess, ominous trolls, and three-headed dogs is of equal vividness and complexity as that galaxy far, far away, and it should make just as much if not more money. Besides the film''s many technical achievements, the actors really deliver, well beyond the who''s who of British thespians who comprise the Hogwarts'' teachers. Daniel Radcliffe has the look and reluctant heroism of Harry down perfectly, if a little too languidly; he''s bested by Emma Watson''s deliciously petulant and precocious Hermione, as well as the masterful line deliveries and comic timing of Rupert Grint as Ron.'),
(2495, 97, 13, 'For all but the most nitpicking Potter-philes out there, Harry Potter and the Sorcerer''s Stone is nothing less than the perfect visual incarnation of J.K. Rowling''s world of swooping owls and flying broomsticks. However, it''s never precisely more than that, either; the very act of giving image and voice to these rich literary precepts places them in a realm inevitably less magical than the imagination. Still, it''s hard to picture a more essentially faithful adaptation of Rowling''s tone and story, which weighs in at a hefty two and a half hours despite streamlining some of the more vestigial elements of a quick 300-page read. Steve Kloves'' adaptation of the wildly popular bestseller lingers less on some of the episodic Hogwarts'' adventures, only briefly touching on such red herring plot points as the wise centaur and Hagrid''s dragon. The eye-popping visuals have numerous other opportunities to shine, chief among them the grippingly rendered Quidditch match, in which players on broomsticks zoom and jockey like the speeder bikes of Endor in Return of the Jedi. It''s no surprise that Harry Potter should occasionally invoke a Star Wars movie, since its hero is an orphaned boy who yearns for a destiny beyond what his aunt and uncle can provide, and who possesses unparalleled mystical powers that the dark side seeks to corrupt. The landscape Chris Columbus and cinematographer John Seale have created with its levitating banquet hall decorations, animated games of wizard chess, ominous trolls, and three-headed dogs is of equal vividness and complexity as that galaxy far, far away, and it should make just as much if not more money. Besides the film''s many technical achievements, the actors really deliver, well beyond the who''s who of British thespians who comprise the Hogwarts'' teachers. Daniel Radcliffe has the look and reluctant heroism of Harry down perfectly, if a little too languidly; he''s bested by Emma Watson''s deliciously petulant and precocious Hermione, as well as the masterful line deliveries and comic timing of Rupert Grint as Ron.'),
(2496, 97, 14, ''),
(2497, 97, 15, ''),
(2498, 97, 17, 'Harry Potter Collection Years 1-5'),
(2499, 97, 18, 'Harry Potter Collection Years 1-5, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2500, 97, 19, 'For all but the most nitpicking Potter-philes out there, Harry Potter and the Sorcerer''s Stone is nothing less than the perfect visual incarnation of J.K. Rowling''s world of swooping owls and flying broomsticks.'),
(2501, 97, 20, ''),
(2502, 97, 21, '2'),
(2503, 97, 22, '1'),
(2504, 97, 23, 'Harry_Potter_Collection_Years_1-5'),
(2505, 97, 24, '-1'),
(2506, 97, 25, '5'),
(2534, 99, 1, '23.99'),
(2535, 99, 2, ''),
(2536, 99, 3, '119'),
(2537, 99, 4, 'HF1'),
(2538, 99, 5, ''),
(2539, 99, 6, '35'),
(2540, 99, 7, '3'),
(2541, 99, 8, '1'),
(2542, 99, 9, 'avactis-images/hous-1_5.jpg'),
(2543, 99, 10, 'avactis-images/thumb_hous-1_5.jpg'),
(2544, 99, 11, 'Four Christmases a.k.a. Four Holidays'),
(2545, 99, 12, 'A crafty couple run the Christmas Day gauntlet by racing to visit their divorced parents'' four separate households in this Vince Vaughn/Reese Witherspoon comedy that proves the holidays are no time for relaxing. Brad (Vaughn) and Kate (Witherspoon) have made something of an art form out of avoiding their families during the holidays, but this year their foolproof plan is about go bust -- big time. Stuck at the city airport after all departing flights are canceled, the couple is embarrassed to see their ruse exposed to the world by an overzealous television reporter. Now, Brad and Kate are left with precious little choice other than to swallow their pride and suffer the rounds. Along the way, they perform in a church nativity play at the behest of Kate''s mother''s (Mary Steenburgen) pushy pastor Phil (Dwight Yoakam), contend with Brad''s gruff father, Howard (Robert Duvall), and bullying brothers, Dallas (Jon Favreau) and Denver (Tim McGraw) -- a pair of trained UFC fighters -- and pay a visit to Brad''s spacy, New Age mother, Paula (Sissy Spacek), who recently made waves in the family circle by marrying her son''s childhood friend.'),
(2546, 99, 13, 'A crafty couple run the Christmas Day gauntlet by racing to visit their divorced parents'' four separate households in this Vince Vaughn/Reese Witherspoon comedy that proves the holidays are no time for relaxing. Brad (Vaughn) and Kate (Witherspoon) have made something of an art form out of avoiding their families during the holidays, but this year their foolproof plan is about go bust -- big time. Stuck at the city airport after all departing flights are canceled, the couple is embarrassed to see their ruse exposed to the world by an overzealous television reporter. Now, Brad and Kate are left with precious little choice other than to swallow their pride and suffer the rounds. Along the way, they perform in a church nativity play at the behest of Kate''s mother''s (Mary Steenburgen) pushy pastor Phil (Dwight Yoakam), contend with Brad''s gruff father, Howard (Robert Duvall), and bullying brothers, Dallas (Jon Favreau) and Denver (Tim McGraw) -- a pair of trained UFC fighters -- and pay a visit to Brad''s spacy, New Age mother, Paula (Sissy Spacek), who recently made waves in the family circle by marrying her son''s childhood friend.'),
(2547, 99, 14, ''),
(2548, 99, 15, ''),
(2549, 99, 17, 'Four Christmases a.k.a. Four Holidays'),
(2550, 99, 18, 'Four Christmases a.k.a. Four Holidays, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2551, 99, 19, 'A crafty couple run the Christmas Day gauntlet by racing to visit their divorced parents'' four separate households in this Vince Vaughn/Reese Witherspoon comedy that proves the holidays are no time for relaxing. Brad (Vaughn) and Kate (Witherspoon) have made something of an art form out of avoiding their families during the holidays, but this year their foolproof plan is about go bust -- big time.'),
(2552, 99, 20, ''),
(2553, 99, 21, '2'),
(2554, 99, 22, '1'),
(2555, 99, 23, 'Four_Christmases_a_k_a__Four_Holidays'),
(2556, 99, 24, '-1'),
(2557, 99, 25, '5'),
(2558, 100, 1, '23.99'),
(2559, 100, 2, ''),
(2560, 100, 3, '119'),
(2561, 100, 4, 'HF2'),
(2562, 100, 5, ''),
(2563, 100, 6, '35'),
(2564, 100, 7, '3'),
(2565, 100, 8, '1'),
(2566, 100, 9, 'avactis-images/hous-2_8.jpg'),
(2567, 100, 10, 'avactis-images/thumb_hous-2_8.jpg'),
(2568, 100, 11, 'Peanuts Deluxe Collection - Barnes & Noble Exclusive '),
(2569, 100, 12, 'The Big Six Peanuts television specials in one specially priced box set that''s packed with bonuses -- now, that''s special, Charlie Brown! A Barnes &amp; Noble exclusive, The Peanuts Deluxe Collection brings together It''s the Great Pumpkin, Charlie Brown; A Charlie Brown Thanksgiving; A Charlie Brown Christmas; Be My Valentine, Charlie Brown; It&rsquo;s the Easter Beagle, Charlie Brown; and You''re Not Elected, Charlie Brown. Not only does this set provide the best way to experience the magic of the Peanuts crew, it''s the only way to get each of the six animated gems in one collection. Culled from 2008 remastered editions, each of the six discs here include a bonus Peanuts special and a featurette. The featured bonus episodes are: It''s Magic, Charlie Brown; It''s Christmas Time Again, Charlie Brown; It''s Your First Kiss, Charlie Brown; It''s Arbor Day, Charlie Brown; He''s a Bully, Charlie Brown; and You''re in Love, Charlie Brown.<br /><i></i>'),
(2570, 100, 13, 'The Big Six Peanuts television specials in one specially priced box set that''s packed with bonuses -- now, that''s special, Charlie Brown! A Barnes &amp; Noble exclusive, The Peanuts Deluxe Collection brings together It''s the Great Pumpkin, Charlie Brown; A Charlie Brown Thanksgiving; A Charlie Brown Christmas; Be My Valentine, Charlie Brown; It&rsquo;s the Easter Beagle, Charlie Brown; and You''re Not Elected, Charlie Brown. Not only does this set provide the best way to experience the magic of the Peanuts crew, it''s the only way to get each of the six animated gems in one collection. Culled from 2008 remastered editions, each of the six discs here include a bonus Peanuts special and a featurette. The featured bonus episodes are: It''s Magic, Charlie Brown; It''s Christmas Time Again, Charlie Brown; It''s Your First Kiss, Charlie Brown; It''s Arbor Day, Charlie Brown; He''s a Bully, Charlie Brown; and You''re in Love, Charlie Brown.<br /><i></i>'),
(2571, 100, 14, ''),
(2572, 100, 15, ''),
(2573, 100, 17, 'Peanuts Deluxe Collection - Barnes & Noble Exclusive '),
(2574, 100, 18, 'Peanuts Deluxe Collection - Barnes & Noble Exclusive , DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2575, 100, 19, 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2576, 100, 20, ''),
(2577, 100, 21, '2'),
(2578, 100, 22, '1'),
(2579, 100, 23, 'Peanuts_Deluxe_Collection_-_Barnes___Noble_Exclusive_'),
(2580, 100, 24, '-1'),
(2581, 100, 25, '5'),
(2582, 101, 1, '23.99'),
(2583, 101, 2, ''),
(2584, 101, 3, '119'),
(2585, 101, 4, 'HF3'),
(2586, 101, 5, ''),
(2587, 101, 6, '35'),
(2588, 101, 7, '3'),
(2589, 101, 8, '1'),
(2590, 101, 9, 'hous-2_9.jpg'),
(2591, 101, 10, 'thumb_hous-2_9.jpg'),
(2592, 101, 11, 'National Lampoon''s Christmas Vacation'),
(2593, 101, 12, 'Chevy Chase, star of National Lampoon''s Vacation and its sequel, is back as the paterfamilias of the Griswold family (including Beverly D''Angelo as his missus) to skewer the Yuletide season. Chevy mugs, trips, falls, mashes his fingers and stubs his toes as he prepares to invite numerous dysfunctional relatives to his household to celebrate Christmas. Amidst the more outrageous sight gags (including the electrocution of a cat as the Christmas tree is lit) the film betrays a sentimental streak, with old wounds healing and long-estranged relatives reuniting in the Griswold living room. National Lampoon''s Christmas Vacation was still capable of attracting an audience five years after its release: It was one of the top-rated seasonal TV specials of 1994, outrating even the first network telecast of It''s a Wonderful Life.'),
(2594, 101, 13, 'Chevy Chase, star of National Lampoon''s Vacation and its sequel, is back as the paterfamilias of the Griswold family (including Beverly D''Angelo as his missus) to skewer the Yuletide season. Chevy mugs, trips, falls, mashes his fingers and stubs his toes as he prepares to invite numerous dysfunctional relatives to his household to celebrate Christmas. Amidst the more outrageous sight gags (including the electrocution of a cat as the Christmas tree is lit) the film betrays a sentimental streak, with old wounds healing and long-estranged relatives reuniting in the Griswold living room. National Lampoon''s Christmas Vacation was still capable of attracting an audience five years after its release: It was one of the top-rated seasonal TV specials of 1994, outrating even the first network telecast of It''s a Wonderful Life.'),
(2595, 101, 14, ''),
(2596, 101, 15, ''),
(2597, 101, 17, 'National Lampoon''s Christmas Vacation'),
(2598, 101, 18, 'National Lampoon''s Christmas Vacation, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2599, 101, 19, 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2600, 101, 20, ''),
(2601, 101, 21, '2'),
(2602, 101, 22, '1'),
(2603, 101, 23, 'National_Lampoon_s_Christmas_Vacation'),
(2604, 101, 24, '-1'),
(2605, 101, 25, '5'),
(2633, 103, 1, '23.99'),
(2634, 103, 2, ''),
(2635, 103, 3, '119'),
(2636, 103, 4, 'HF4'),
(2637, 103, 5, ''),
(2638, 103, 6, '35'),
(2639, 103, 7, '3'),
(2640, 103, 8, '1'),
(2641, 103, 9, 'hous-1_6.jpg'),
(2642, 103, 10, 'thumb_hous-1_6.jpg'),
(2643, 103, 11, 'Christmas in Connecticut a.k.a. Indiscretion'),
(2644, 103, 12, 'War hero Dennis Morgan becomes the object of a publicity stunt staged by magazine publisher Sidney Greenstreet. The corpulent print mogul announces that Morgan has won a Christmas dinner, to be prepared by the magazine''s housekeeping expert Barbara Stanwyck in her own Connecticut home. The catch: Not only does Stanwyck not have a home in Connecticut, but she''s never been in a kitchen in her life! She also doesn''t have a husband (as her articles claim), so Stanwyck''s erstwhile beau Reginald Gardiner is pressed into service as the hubby. As for the cooking, that will be handled by master chef S. Z. &quot;Cuddles&quot; Sakall. This solves everything, right? No way, Jose. Long dismissed as a lesser film farce, Christmas in Connecticut has its own irresistible charm, and has in recent years become a perennial Christmas-eve TV attraction. Pay absolutely no attention to the 1992 TV remake, starring Dyan Cannon and directed by Arnold Schwarzenegger.'),
(2645, 103, 13, 'War hero Dennis Morgan becomes the object of a publicity stunt staged by magazine publisher Sidney Greenstreet. The corpulent print mogul announces that Morgan has won a Christmas dinner, to be prepared by the magazine''s housekeeping expert Barbara Stanwyck in her own Connecticut home. The catch: Not only does Stanwyck not have a home in Connecticut, but she''s never been in a kitchen in her life! She also doesn''t have a husband (as her articles claim), so Stanwyck''s erstwhile beau Reginald Gardiner is pressed into service as the hubby. As for the cooking, that will be handled by master chef S. Z. &quot;Cuddles&quot; Sakall. This solves everything, right? No way, Jose. Long dismissed as a lesser film farce, Christmas in Connecticut has its own irresistible charm, and has in recent years become a perennial Christmas-eve TV attraction. Pay absolutely no attention to the 1992 TV remake, starring Dyan Cannon and directed by Arnold Schwarzenegger.'),
(2646, 103, 14, ''),
(2647, 103, 15, ''),
(2648, 103, 17, 'Christmas in Connecticut a.k.a. Indiscretion'),
(2649, 103, 18, 'Christmas in Connecticut\r\na.k.a. Indiscretion, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2650, 103, 19, 'War hero Dennis Morgan becomes the object of a publicity stunt staged by magazine publisher Sidney Greenstreet. The corpulent print mogul announces that Morgan has won a Christmas dinner, to be prepared by the magazine''s housekeeping expert Barbara Stanwyck in her own Connecticut home. The catch: Not only does Stanwyck not have a home in Connecticut, but she''s never been in a kitchen in her life! She also doesn''t have a husband (as her articles claim), so Stanwyck''s erstwhile beau Reginald Gardiner is pressed into service as the hubby. As for the cooking, that will be handled by master chef S. Z. "Cuddles" Sakall. This solves everything, right? No way, Jose. Long dismissed as a lesser film farce, Christmas in Connecticut has its own irresistible charm, and has in recent years become a perennial Christmas-eve TV attraction. Pay absolutely no attention to the 1992 TV remake, starring Dyan Cannon and directed by Arnold Schwarzenegger.'),
(2651, 103, 20, ''),
(2652, 103, 21, '2'),
(2653, 103, 22, '1'),
(2654, 103, 23, 'Christmas_in_Connecticut_a_k_a__Indiscretion'),
(2655, 103, 24, '-1'),
(2656, 103, 25, '5'),
(2657, 104, 1, '23.99'),
(2658, 104, 2, ''),
(2659, 104, 3, '119'),
(2660, 104, 4, 'DVD'),
(2661, 104, 5, '5'),
(2662, 104, 6, '35'),
(2663, 104, 7, '3'),
(2664, 104, 8, '1'),
(2665, 104, 9, 'avactis-images/hous-2_10.jpg'),
(2666, 104, 10, 'avactis-images/thumb_hous-2_10.jpg'),
(2667, 104, 11, 'Shrek the Halls'),
(2668, 104, 12, 'Picking up where <i>Shrek the Third</i> left off, this animated, original, half-hour special finds Shrek (Mike Meyers) doing his best to get into the Christmas spirit. Having promised Fiona (Cameron Diaz) and the kids that this will be the best Christmas ever, the loveable ogre realizes that in order to succeed, he''ll have to take a crash course in the holiday. His noble efforts are soon complicated, however, when Christmas arrives and old friends Donkey (Eddie Murphy), Puss in Boots (Antonio Banderas), Gingy (Conrad Vernon) and the rest of the gang decide to drop in for a surprise visit.'),
(2669, 104, 13, '<font size="3" face="arial,helvetica,sans-serif">Picking up where <i>Shrek the Third</i> left off, this animated, original, half-hour special finds Shrek (Mike Meyers) doing his best to get into the Christmas spirit. Having promised Fiona (Cameron Diaz) and the kids that this will be the best Christmas ever, the loveable ogre realizes that in order to succeed, he''ll have to take a crash course in the holiday. His noble efforts are soon complicated, however, when Christmas arrives and old friends Donkey (Eddie Murphy), Puss in Boots (Antonio Banderas), Gingy (Conrad Vernon) and the rest of the gang decide to drop in for a surprise visit.</font>'),
(2670, 104, 14, ''),
(2671, 104, 15, ''),
(2672, 104, 17, 'Shrek the Halls'),
(2673, 104, 18, 'Shrek the Halls, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2674, 104, 19, 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2675, 104, 20, ''),
(2676, 104, 21, '2'),
(2677, 104, 22, '1'),
(2678, 104, 23, 'Shrek_the_Halls'),
(2679, 104, 24, '-1'),
(2680, 104, 25, '5'),
(2681, 105, 1, '23.99'),
(2682, 105, 2, ''),
(2683, 105, 3, '119'),
(2684, 105, 4, 'HF6'),
(2685, 105, 5, ''),
(2686, 105, 6, '35'),
(2687, 105, 7, '3'),
(2688, 105, 8, '1'),
(2689, 105, 9, 'hous-1_7.jpg'),
(2690, 105, 10, 'thumb_hous-1_7.jpg'),
(2691, 105, 11, 'A Charlie Brown Christmas'),
(2692, 105, 12, 'The first prime-time Peanuts special introduced Charles M. Schulz''s timeless gang to the world of television and was awarded both an Emmy and a Peabody award. Originally broadcast December 9, 1965, on CBS -- years before Seasonal Affective Disorder entered our lexicon -- the story is driven by Charlie Brown, sort of a tyro Scrooge made even more miserable by the increasingly crass commercialism of holiday cheer. Charlie agrees to direct the school Christmas pageant and in the process tries to discover the true meaning of the holiday. Although its animation is dated and its evangelism is unsubtle, A Charlie Brown Christmas -- like all the Peanuts holiday specials -- is so good-hearted that it''s very easy to overlook its flaws. Linus wrapping his blanket around the tiny, stunted tree remains among the most endearing images ever produced for network television. For grown-ups, this is how Charlie Brown and Snoopy and Sally will always be remembered, stumbling and dancing around the school stage in a childish torrent of goodwill. For kids, the simple charm of the white beagle with black ears and his friends will likely beguile them from here to next Tuesday. The new DVD is unedited and includes footage that was shorn after the initial broadcast, as well as the more recent special, It''s Christmastime Again, Charlie Brown.'),
(2693, 105, 13, 'The first prime-time Peanuts special introduced Charles M. Schulz''s timeless gang to the world of television and was awarded both an Emmy and a Peabody award. Originally broadcast December 9, 1965, on CBS -- years before Seasonal Affective Disorder entered our lexicon -- the story is driven by Charlie Brown, sort of a tyro Scrooge made even more miserable by the increasingly crass commercialism of holiday cheer. Charlie agrees to direct the school Christmas pageant and in the process tries to discover the true meaning of the holiday. Although its animation is dated and its evangelism is unsubtle, A Charlie Brown Christmas -- like all the Peanuts holiday specials -- is so good-hearted that it''s very easy to overlook its flaws. Linus wrapping his blanket around the tiny, stunted tree remains among the most endearing images ever produced for network television. For grown-ups, this is how Charlie Brown and Snoopy and Sally will always be remembered, stumbling and dancing around the school stage in a childish torrent of goodwill. For kids, the simple charm of the white beagle with black ears and his friends will likely beguile them from here to next Tuesday. The new DVD is unedited and includes footage that was shorn after the initial broadcast, as well as the more recent special, It''s Christmastime Again, Charlie Brown.'),
(2694, 105, 14, ''),
(2695, 105, 15, ''),
(2696, 105, 17, 'A Charlie Brown Christmas'),
(2697, 105, 18, 'A Charlie Brown Christmas, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2698, 105, 19, 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2699, 105, 20, ''),
(2700, 105, 21, '2'),
(2701, 105, 22, '1'),
(2702, 105, 23, 'A_Charlie_Brown_Christmas'),
(2703, 105, 24, '-1'),
(2704, 105, 25, '5'),
(2705, 106, 1, '23.99'),
(2706, 106, 2, '26.70'),
(2707, 106, 3, '119'),
(2708, 106, 4, 'CF_DVD_1'),
(2709, 106, 5, ''),
(2710, 106, 6, '35'),
(2711, 106, 7, '3'),
(2712, 106, 8, '1'),
(2713, 106, 9, 'avactis-images/hous-2_11.jpg'),
(2714, 106, 10, 'avactis-images/thumb_hous-2_11.jpg'),
(2715, 106, 11, 'Classic Musicals from the Dream Factory, Vol. 3'),
(2716, 106, 12, '<p><font size="3" face="arial,helvetica,sans-serif">A never-completed stage musical was the source for the MGM superproduction Born to Dance. The plot is another three-sailors-on-leave affair, with Ted (James Stewart), Mush (Buddy Ebsen) and Gunny (Sid Silvers, who also co-wrote the script) romancing the eminently romanceable Nora (Eleanor Powell), Peppy (Frances Langford) and Jenny (Una Merkel). </font></p>'),
(2717, 106, 13, '<p><font size="3" face="arial,helvetica,sans-serif">A never-completed stage musical was the source for the MGM superproduction Born to Dance. The plot is another three-sailors-on-leave affair, with Ted (James Stewart), Mush (Buddy Ebsen) and Gunny (Sid Silvers, who also co-wrote the script) romancing the eminently romanceable Nora (Eleanor Powell), Peppy (Frances Langford) and Jenny (Una Merkel). </font></p><p><font size="3" face="arial,helvetica,sans-serif">Nora aspires to become a dancing star, but her career nearly ends before it begins when she inadvertently comes between Broadway luminary Lucy James (Virginia Bruce) and her producer-lover McKay (Alan Dinehart). </font></p><p><font size="3" face="arial,helvetica,sans-serif">If anyone watching back in 1936 really cared about the plot, they probably weren''t music lovers. The lovely Cole Porter score (his first written directly for the screen) includes &quot;I''ve Got You Under My Skin,&quot; sung by Virginia Bruce to James Stewart, and &quot;Easy to Love,&quot; warbled by Stewart to Eleanor Powell. </font></p><p><font size="3" face="arial,helvetica,sans-serif">Highlights include Reginald Gardiner''s impersonation of a symphony-conducting traffic cop (a routine he''d previously performed on stage) and Eleanor Powell''s climactic tap routine on board an art-deco battleship. </font></p>'),
(2718, 106, 14, ''),
(2719, 106, 15, ''),
(2720, 106, 17, 'Classic Musicals from the Dream Factory, Vol. 3'),
(2721, 106, 18, 'Classic Musicals from the Dream Factory, Vol. 3, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2722, 106, 19, 'A never-completed stage musical was the source for the MGM superproduction Born to Dance. The plot is another three-sailors-on-leave affair, with Ted (James Stewart), Mush (Buddy Ebsen) and Gunny (Sid Silvers, who also co-wrote the script) romancing the eminently romanceable Nora (Eleanor Powell), Peppy (Frances Langford) and Jenny (Una Merkel). '),
(2723, 106, 20, ''),
(2724, 106, 21, '2'),
(2725, 106, 22, '1'),
(2726, 106, 23, 'Classic_Musicals_from_the_Dream_Factory__Vol__3'),
(2727, 106, 24, '-1'),
(2728, 106, 25, '5'),
(2753, 108, 1, '48.59'),
(2754, 108, 2, ''),
(2755, 108, 3, '119'),
(2756, 108, 4, 'CF_DVD_3'),
(2757, 108, 5, ''),
(2758, 108, 6, '35'),
(2759, 108, 7, '3'),
(2760, 108, 8, '1'),
(2761, 108, 9, 'avactis-images/hous-1_9.jpg'),
(2762, 108, 10, 'avactis-images/thumb_hous-1_9.jpg'),
(2763, 108, 11, 'Forbidden Planet'),
(2764, 108, 12, 'You remember this one: Intrepid astronauts led by Commander John J. Adams (Leslie Nielsen) visit the far-off planet known as Altair-4, where the seemingly idyllic lifestyle enjoyed by reclusive scientist Dr. Edward Morbius (Walter Pidgeon) and his futuristic glam-girl daughter, Altaira Morbius (Anne Francis), is suddenly threatened by the inexplicable rampages of an invisible monster. Few science-fiction films from the ''50s remain as popular as this space-opera adaptation of Shakespeare''s The Tempest, although we''re not sure we agree with the assertion made in one of this deluxe edition&rsquo;s new documentaries, claiming that Forbidden Planet was the genre''s most important pre-Star Wars movie. That appraisal comes from one of the many influential filmmakers who sing Planet''s praises in &quot;Exploring the Far Reaches of Forbidden Planet.&quot; They include directors Joe Dante, John Landis, and John Carpenter, who are joined by special-effects wizards John Dykstra and Dennis Muren, several film historians, and surviving cast members Leslie Nielsen, Anne Francis, Earl Holliman, and Warren Stevens. Warner excels in the production of special features, and the studio has pulled out all the stops once again, coming up with material that was either believed lost or was just plain forgotten, including test footage from special-effects sequences and lighting comparisons of the various sets. Other featurettes include &quot;Watch the Skies,&quot; a Turner Classic Movies documentary on sci-fi films of the ''50s, and &quot;Robby the Robot: Engineering a Sci-Fi Icon.&quot; Robby stars as well in two 1958 extras: &quot;The Invisible Boy,&quot; a feature; and &quot;Robot Client,&quot; an episode from the Thin Man TV series.'),
(2765, 108, 13, 'You remember this one: Intrepid astronauts led by Commander John J. Adams (Leslie Nielsen) visit the far-off planet known as Altair-4, where the seemingly idyllic lifestyle enjoyed by reclusive scientist Dr. Edward Morbius (Walter Pidgeon) and his futuristic glam-girl daughter, Altaira Morbius (Anne Francis), is suddenly threatened by the inexplicable rampages of an invisible monster. Few science-fiction films from the ''50s remain as popular as this space-opera adaptation of Shakespeare''s The Tempest, although we''re not sure we agree with the assertion made in one of this deluxe edition&rsquo;s new documentaries, claiming that Forbidden Planet was the genre''s most important pre-Star Wars movie. That appraisal comes from one of the many influential filmmakers who sing Planet''s praises in &quot;Exploring the Far Reaches of Forbidden Planet.&quot; They include directors Joe Dante, John Landis, and John Carpenter, who are joined by special-effects wizards John Dykstra and Dennis Muren, several film historians, and surviving cast members Leslie Nielsen, Anne Francis, Earl Holliman, and Warren Stevens. Warner excels in the production of special features, and the studio has pulled out all the stops once again, coming up with material that was either believed lost or was just plain forgotten, including test footage from special-effects sequences and lighting comparisons of the various sets. Other featurettes include &quot;Watch the Skies,&quot; a Turner Classic Movies documentary on sci-fi films of the ''50s, and &quot;Robby the Robot: Engineering a Sci-Fi Icon.&quot; Robby stars as well in two 1958 extras: &quot;The Invisible Boy,&quot; a feature; and &quot;Robot Client,&quot; an episode from the Thin Man TV series.'),
(2766, 108, 14, ''),
(2767, 108, 15, ''),
(2768, 108, 17, 'Forbidden Planet'),
(2769, 108, 18, 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2770, 108, 19, 'You remember this one: Intrepid astronauts led by Commander John J. Adams (Leslie Nielsen) visit the far-off planet known as Altair-4, where the seemingly idyllic lifestyle enjoyed by reclusive scientist Dr. Edward Morbius (Walter Pidgeon) and his futuristic glam-girl daughter, Altaira Morbius (Anne Francis), is suddenly threatened by the inexplicable rampages of an invisible monster. Few science-fiction films from the ''50s remain as popular as this space-opera adaptation of Shakespeare''s The Tempest, although we''re not sure we agree with the assertion made in one of this deluxe edition''s new documentaries, claiming that Forbidden Planet was the genre''s most important pre-Star Wars movie.'),
(2771, 108, 20, ''),
(2772, 108, 21, '2'),
(2773, 108, 22, '1'),
(2774, 108, 23, 'Forbidden_Planet'),
(2775, 108, 24, '-1'),
(2776, 108, 25, '5'),
(2945, 116, 1, '23.99'),
(2946, 116, 2, ''),
(2947, 116, 3, '119'),
(2948, 116, 4, 'CF_DVD_11'),
(2949, 116, 5, ''),
(2950, 116, 6, '35'),
(2951, 116, 7, '3'),
(2952, 116, 8, '1'),
(2953, 116, 9, 'avactis-images/image1_2.jpg'),
(2954, 116, 10, 'avactis-images/thumb_image1_2.jpg'),
(2955, 116, 11, 'James Bond Ultimate Collection, Volume 1'),
(2956, 116, 12, 'With the 2006 release of&nbsp; Casino Royale, MGM-UA has gone through an extensive remastering and repackaging of the previously on-hiatus 007 library, fleshing the older films out to two-disc sets with all-new and extensive bonus features. This time around, the Bonds are being made available in four box sets containing five films each, with the classic entries spread among the quartet. Goldfinger (1964), arguably the finest of Sean Connery&rsquo;s 007 adventures, is the headliner in this Ultimate Edition Volume 1; Honor Blackman&rsquo;s Pussy Galore remains the most alluring of the Bond Girls, and Gert Frobe&rsquo;s Auric Goldfinger may be the most fascinatingly nefarious of James Bond&rsquo;s super-foes. His &ldquo;No, Mister Bond; I expect you to die,&rdquo; remains among cinema&rsquo;s all-time greatest kiss-offs. Connery&rsquo;s penultimate vehicle, Diamonds Are Forever (1971), while campy, has sparkling Las Vegas location shooting, a luscious leading lady in Jill St. John, and another top-notch bad guy in SPECTRE&rsquo;s Ernst Stavro Blofeld (Charles Gray, equally well remembered for his work as &ldquo;The Criminologist&rdquo; in The Rocky Horror Picture Show). Also included are The Man with the Golden Gun (1974), Roger Moore&rsquo;s second outing as 007 and a great showcase for one of the screen&rsquo;s most urbane villains, Christopher Lee; The Living Daylights (1987), with Timothy Dalton debuting as a more somber Bond; and The World Is Not Enough (1999), a fast-paced romp starring Pierce Brosnan and memorably featuring Denise Richards as a rocket scientist. (Yes, that&rsquo;s right, a rocket scientist.) With flashy new packaging worthy of film&rsquo;s greatest super-agent, and loads of DVD extras, this adds up to a terrific box set.'),
(2957, 116, 13, 'With the 2006 release of&nbsp; Casino Royale, MGM-UA has gone through an extensive remastering and repackaging of the previously on-hiatus 007 library, fleshing the older films out to two-disc sets with all-new and extensive bonus features. This time around, the Bonds are being made available in four box sets containing five films each, with the classic entries spread among the quartet. Goldfinger (1964), arguably the finest of Sean Connery&rsquo;s 007 adventures, is the headliner in this Ultimate Edition Volume 1; Honor Blackman&rsquo;s Pussy Galore remains the most alluring of the Bond Girls, and Gert Frobe&rsquo;s Auric Goldfinger may be the most fascinatingly nefarious of James Bond&rsquo;s super-foes. His &ldquo;No, Mister Bond; I expect you to die,&rdquo; remains among cinema&rsquo;s all-time greatest kiss-offs. Connery&rsquo;s penultimate vehicle, Diamonds Are Forever (1971), while campy, has sparkling Las Vegas location shooting, a luscious leading lady in Jill St. John, and another top-notch bad guy in SPECTRE&rsquo;s Ernst Stavro Blofeld (Charles Gray, equally well remembered for his work as &ldquo;The Criminologist&rdquo; in The Rocky Horror Picture Show). Also included are The Man with the Golden Gun (1974), Roger Moore&rsquo;s second outing as 007 and a great showcase for one of the screen&rsquo;s most urbane villains, Christopher Lee; The Living Daylights (1987), with Timothy Dalton debuting as a more somber Bond; and The World Is Not Enough (1999), a fast-paced romp starring Pierce Brosnan and memorably featuring Denise Richards as a rocket scientist. (Yes, that&rsquo;s right, a rocket scientist.) With flashy new packaging worthy of film&rsquo;s greatest super-agent, and loads of DVD extras, this adds up to a terrific box set.'),
(2958, 116, 14, ''),
(2959, 116, 15, ''),
(2960, 116, 17, 'James Bond Ultimate Collection, Volume 1'),
(2961, 116, 18, 'James Bond Ultimate Collection, Volume 1, DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2962, 116, 19, 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(2963, 116, 20, ''),
(2964, 116, 21, '2'),
(2965, 116, 22, '1'),
(2966, 116, 23, 'James_Bond_Ultimate_Collection_Volume_1'),
(2967, 116, 24, '-1'),
(2968, 116, 25, '5'),
(3186, 125, 1, '237.00'),
(3187, 125, 2, ''),
(3188, 125, 3, ''),
(3189, 125, 4, 'ST3'),
(3190, 125, 5, ''),
(3191, 125, 6, ''),
(3192, 125, 7, '3'),
(3193, 125, 8, '1'),
(3194, 125, 9, 'image1_11.jpg'),
(3195, 125, 10, 'thumb_image1_11.jpg'),
(3196, 125, 11, 'Winter Camping Tent'),
(3197, 125, 12, '<ul><li>Ultra stable, compact and lightweight</li><li>3 Season tent</li><li>Sleeps 3</li><li>4.1 sq ft of vestibule</li><li>Center height: 41&quot;</li><li>83&quot; x 67&quot;</li><li>Pack weight: 8 lbs 10 oz</li><li>Trail weight: 7 lbs 11 oz</li><li>Tent floor: Nylon taffeta</li><li>Tent rainfly: Polyester Ripstop</li><li>Tent canopy: Polyester (breathable)</li><li>Aluminum 7001-T6 poles</li><li>Two-way compression carry bag</li></ul>'),
(3198, 125, 13, '<ul><li>Ultra stable, compact and lightweight</li><li>3 Season tent</li><li>Sleeps 3</li><li>4.1 sq ft of vestibule</li><li>Center height: 41&quot;</li><li>83&quot; x 67&quot;</li><li>Pack weight: 8 lbs 10 oz</li><li>Trail weight: 7 lbs 11 oz</li><li>Tent floor: Nylon taffeta</li><li>Tent rainfly: Polyester Ripstop</li><li>Tent canopy: Polyester (breathable)</li><li>Aluminum 7001-T6 poles</li><li>Two-way compression carry bag</li></ul>'),
(3199, 125, 14, ''),
(3200, 125, 15, ''),
(3201, 125, 17, 'Winter Camping Tent'),
(3202, 125, 18, 'Winter Camping Tent, sport, travel, outdoor clothing, camping, tents, equipment, fishing, accessories, waterproof, hiking, clothes, outdoors, rucksacks'),
(3203, 125, 19, 'Winter Camping Tent'),
(3204, 125, 20, ''),
(3205, 125, 21, '2'),
(3206, 125, 22, '1'),
(3207, 125, 23, 'Winter_Camping_Tent'),
(3208, 125, 24, '-1'),
(3209, 125, 25, '5'),
(3210, 126, 1, '523.00'),
(3211, 126, 2, ''),
(3212, 126, 3, ''),
(3213, 126, 4, 'ST4'),
(3214, 126, 5, ''),
(3215, 126, 6, ''),
(3216, 126, 7, '3'),
(3217, 126, 8, '1'),
(3218, 126, 9, 'avactis-images/image1_12.jpg'),
(3219, 126, 10, 'avactis-images/thumb_image1_12.jpg'),
(3220, 126, 11, 'Sea Eagle Sport Kayak'),
(3221, 126, 12, 'Imagine yourself blasting down a white water river &mdash; spray flying everywhere and your heart beating like a drum. Or imagine yourself on a mirror-smooth lake at dawn, slicing the silence with smooth paddle strokes.<br /> <br /> Can one boat do all this? Yes, when it''s a Sea Eagle Sport Kayak.'),
(3222, 126, 13, 'Imagine yourself blasting down a white water river &mdash; spray flying everywhere and your heart beating like a drum. Or imagine yourself on a mirror-smooth lake at dawn, slicing the silence with smooth paddle strokes.<br /> <br /> Can one boat do all this? Yes, when it''s a Sea Eagle Sport Kayak.'),
(3223, 126, 14, ''),
(3224, 126, 15, ''),
(3225, 126, 17, 'Sea Eagle Sport Kayak'),
(3226, 126, 18, 'Sea Eagle Sport Kayak, sport, travel, outdoor clothing, camping, tents, equipment, fishing, accessories, waterproof, hiking, clothes, outdoors, rucksacks'),
(3227, 126, 19, 'Sea Eagle Sport Kayak'),
(3228, 126, 20, ''),
(3229, 126, 21, '2'),
(3230, 126, 22, '1'),
(3231, 126, 23, 'Sea_Eagle_Sport_Kayak'),
(3232, 126, 24, '-1'),
(3233, 126, 25, '5'),
(3306, 130, 1, '229.95'),
(3307, 130, 2, ''),
(3308, 130, 3, ''),
(3309, 130, 4, 'ST8'),
(3310, 130, 5, ''),
(3311, 130, 6, ''),
(3312, 130, 7, '3'),
(3313, 130, 8, '1'),
(3314, 130, 9, 'avactis-images/image1_16.jpg'),
(3315, 130, 10, 'avactis-images/thumb_image1_16.jpg'),
(3316, 130, 11, 'Garmin - nuvi 205W GPS Receiver'),
(3317, 130, 12, 'Portable, affordable and wide, nuvi 205W is your personal travel assistant for life on the go. This navigator leads the way with turn-by-turn directions and optional MSN&reg; Direct services to get you there on time and keep you informed. It''s packed with millions of destinations and maps for the contiguous U.S., Canada or regional sections of Europe. Like the rest of the sleek nuvi 2x5-series, the 205W is priced right and ultra-easy to use.'),
(3318, 130, 13, 'Portable, affordable and wide, nuvi 205W is your personal travel assistant for life on the go. This navigator leads the way with turn-by-turn directions and optional MSN&reg; Direct services to get you there on time and keep you informed. It''s packed with millions of destinations and maps for the contiguous U.S., Canada or regional sections of Europe. Like the rest of the sleek nuvi 2x5-series, the 205W is priced right and ultra-easy to use.'),
(3319, 130, 14, ''),
(3320, 130, 15, ''),
(3321, 130, 17, 'Garmin - nuvi 205W GPS Receiver'),
(3322, 130, 18, 'Garmin - nuvi 205W GPS Receiver, sport, travel, outdoor clothing, camping, tents, equipment, fishing, accessories, waterproof, hiking, clothes, outdoors, rucksacks'),
(3323, 130, 19, 'Portable, affordable and wide, nuvi 205W is your personal travel assistant for life on the go. This navigator leads the way with turn-by-turn directions and optional MSNÃ‚Â® Direct services to get you there on time and keep you informed. It''s packed with millions of destinations and maps for the contiguous U.S., Canada or regional sections of Europe. Like the rest of the sleek nuvi 2x5-series, the 205W is priced right and ultra-easy to use.'),
(3324, 130, 20, ''),
(3325, 130, 21, '2'),
(3326, 130, 22, '1'),
(3327, 130, 23, 'Garmin_-_nuvi_205W_GPS_Receiver'),
(3328, 130, 24, '6'),
(3329, 130, 25, '5'),
(3378, 133, 1, '49.95'),
(3379, 133, 2, ''),
(3380, 133, 3, ''),
(3381, 133, 4, 'ST11'),
(3382, 133, 5, ''),
(3383, 133, 6, ''),
(3384, 133, 7, '3'),
(3385, 133, 8, '1'),
(3386, 133, 9, 'avactis-images/image1_19.jpg'),
(3387, 133, 10, 'avactis-images/thumb_image1_19.jpg'),
(3388, 133, 11, 'Brunton 8099 Eclipse Compass'),
(3389, 133, 12, '<b>Brunton 8099 Eclipse Compass</b><br /><br />The Brunton 8099 Eclipse Compass is an all-in-one professional compass that serves as both a baseplate and a mirrored sighting map compass. Designed for easy-navigation, the 8099 features three clinometer systems and our patented circle-over-circle alignment system. Includes field reference cards for mapping and emergency skills.'),
(3390, 133, 13, '<b>Brunton 8099 Eclipse Compass</b><br /> <br /> The Brunton 8099 Eclipse Compass is an all-in-one professional compass that serves as both a baseplate and a mirrored sighting map compass. Designed for easy-navigation, the 8099 features three clinometer systems and our patented circle-over-circle alignment system. Includes field reference cards for mapping and emergency skills.<br /> <ul><li>4.1&quot;x2.5&quot;x1&quot;</li><li>3.6 oz.</li><li>Magnified read out</li><li>1&deg; graduations</li><li>Field reference cards</li><li>3 inclinometer systems</li><li>Declination adjustable</li><li>USGS map scale 1:24k, ft., UTM. mile</li><li>&quot;Circle over circle&quot; alignment system</li><li>Map magnifier</li><li>Lanyard</li></ul> '),
(3391, 133, 14, ''),
(3392, 133, 15, ''),
(3393, 133, 17, 'Brunton 8099 Eclipse Compass'),
(3394, 133, 18, 'Brunton 8099 Eclipse Compass, sport, travel, outdoor clothing, camping, tents, equipment, fishing, accessories, waterproof, hiking, clothes, outdoors, rucksacks'),
(3395, 133, 19, 'Brunton 8099 Eclipse Compass'),
(3396, 133, 20, ''),
(3397, 133, 21, '2'),
(3398, 133, 22, '1'),
(3399, 133, 23, 'Brunton_8099_Eclipse_Compass'),
(3400, 133, 24, '9'),
(3401, 133, 25, '5'),
(3426, 135, 1, '11.99'),
(3427, 135, 2, ''),
(3428, 135, 3, '15'),
(3429, 135, 4, 'MUSIC-C-1'),
(3430, 135, 5, ''),
(3431, 135, 6, ''),
(3432, 135, 7, '3'),
(3433, 135, 8, '1'),
(3434, 135, 9, 'avactis-images/44407238.JPG'),
(3435, 135, 10, 'avactis-images/thumb_44407238.JPG'),
(3436, 135, 11, 'Play On - Carrie Underwood'),
(3437, 135, 12, 'Daisy in her hair aside, Carrie Underwood looks flat-out glamorous on the cover of Play On, which is a pretty fair indication of what awaits listeners on her third album. Carrie is still a country artist and sometimes will sing supported by fiddles and steel guitar, but this is crossover pop pure and simple, whether it''s the thundering rhythms on the Shania-styled strut &quot;Cowboy Casanova&quot; or the preponderance of power ballads. Many of these ballads are infused with social consciousness -- Carrie decries hunger on &quot;Change&quot; and homelessness on &quot;Temporary Home&quot; -- reminiscent of Idol Gives Back, and they''re not the only AmIdol connection here, as Kara DioGuardi co-wrote the sassy &quot;Undo It&quot; and &quot;Mama''s Song&quot; with Underwood herself. Carrie takes a much stronger presence as a writer here, co-authoring seven of the 13 songs. Play On particularly shines on the breezy &quot;Quitter&quot; and &quot;This Time,&quot; songs built on solid melodies and delivered without flash, relying on craft and Carrie''s considerable small-town charm.');
INSERT INTO `[[dbprefix]]product_attributes` VALUES
(3438, 135, 13, '<p>Daisy in her hair aside, Carrie Underwood looks flat-out glamorous on the cover of Play On, which is a pretty fair indication of what awaits listeners on her third album. Carrie is still a country artist and sometimes will sing supported by fiddles and steel guitar, but this is crossover pop pure and simple, whether it''s the thundering rhythms on the Shania-styled strut &quot;Cowboy Casanova&quot; or the preponderance of power ballads. </p><p>Many of these ballads are infused with social consciousness -- Carrie decries hunger on &quot;Change&quot; and homelessness on &quot;Temporary Home&quot; -- reminiscent of Idol Gives Back, and they''re not the only AmIdol connection here, as Kara DioGuardi co-wrote the sassy &quot;Undo It&quot; and &quot;Mama''s Song&quot; with Underwood herself. </p><p>Carrie takes a much stronger presence as a writer here, co-authoring seven of the 13 songs. Play On particularly shines on the breezy &quot;Quitter&quot; and &quot;This Time,&quot; songs built on solid melodies and delivered without flash, relying on craft and Carrie''s considerable small-town charm.</p>'),
(3439, 135, 14, ''),
(3440, 135, 15, '0.20'),
(3441, 135, 17, 'Play On - Carrie Underwood'),
(3442, 135, 18, 'Play On - Carrie Underwood, music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy'),
(3443, 135, 19, 'Daisy in her hair aside, Carrie Underwood looks flat-out glamorous on the cover of Play On, which is a pretty fair indication of what awaits listeners on her third album. Carrie is still a country artist and sometimes will sing supported by fiddles and steel guitar, but this is crossover pop pure and simple, whether it''s the thundering rhythms on the Shania-styled strut "Cowboy Casanova" or the preponderance of power ballads. Many of these ballads are infused with social consciousness -- Carrie decries hunger on "Change" and homelessness on "Temporary Home" -- reminiscent of Idol Gives Back, and they''re not the only AmIdol connection here, as Kara DioGuardi co-wrote the sassy "Undo It" and "Mama''s Song" with Underwood herself. Carrie takes a much stronger presence as a writer here, co-authoring seven of the 13 songs. Play On particularly shines on the breezy "Quitter" and "This Time," songs built on solid melodies and delivered without flash, relying on craft and Carrie''s considerable small-town charm.'),
(3444, 135, 20, ''),
(3445, 135, 21, '2'),
(3446, 135, 22, '1'),
(3447, 135, 23, 'Play_On_-_Carrie_Underwood'),
(3448, 135, 24, ''),
(3449, 135, 25, '5'),
(3450, 135, 31, '2009'),
(3451, 135, 32, ''),
(3452, 135, 33, '1'),
(3453, 136, 1, '9.99'),
(3454, 136, 2, ''),
(3455, 136, 3, '5'),
(3456, 136, 4, 'MUSIC-C-2'),
(3457, 136, 5, ''),
(3458, 136, 6, ''),
(3459, 136, 7, '3'),
(3460, 136, 8, '1'),
(3461, 136, 9, 'avactis-images/126977313.jpg'),
(3462, 136, 10, 'avactis-images/thumb_126977313.jpg'),
(3463, 136, 11, 'Lady Antebellum'),
(3464, 136, 12, 'A powerhouse trio comprising Hillary Scott, Charley Kelley, and Dave Haywood, Lady Antebellum is charging out of the box with what''s not only the strongest country debut of early 2008 but a record that could become a mainstream classic.'),
(3465, 136, 13, '<p>A powerhouse trio comprising Hillary Scott, Charley Kelley, and Dave Haywood, Lady Antebellum is charging out of the box with what''s not only the strongest country debut of early 2008 but a record that could become a mainstream classic. Terrific original songs, expressive singing, and striking country-rock arrangements mark the group''s turf right from the git-go, in the album-opening hit single, &quot;Love Don''t Live Here.&quot; &quot;Looking for a Good Time&quot; follows, a driving, pull-no-punches expression of lust for a one-night stand, featuring ferocious guitar riffing and dramatic give-and-take vocal trade-offs between Scott and Kelley. </p><p>No nihilists or hedonists this trio, though: about the time you catch your breath, the Antebellums settle into &quot;All We''d Ever Need,&quot; a regret-filled power ballad detailing the narrator''s all-consuming guilt over losing a good thing; it''s a dynamic tour de force that makes all the right moves. &quot;Long Gone&quot; follows, echoing with Byrds and Springsteen flourishes in the rich organ support and cascading guitar lines as Scott and Kelley blend in captivating harmony, documenting the transformation of a once-gullible gal who''s heard all the lines, all the promises, and is &quot;gone like the wind under Superman''s cape.&quot; </p><p>It''s as heartless a kiss-off song as country music has produced in the past couple of decades, and despite its bitter, backbiting reflections, it''s delightfully rockin'' when it kicks into high gear. For Lady Antebellum, it looks like things will only get better from here.</p>'),
(3466, 136, 14, ''),
(3467, 136, 15, '0.20'),
(3468, 136, 17, 'Lady Antebellum'),
(3469, 136, 18, 'Lady Antebellum, music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy'),
(3470, 136, 19, 'Lady Antebellum, Avactis Music store, various music disks'),
(3471, 136, 20, ''),
(3472, 136, 21, '2'),
(3473, 136, 22, '1'),
(3474, 136, 23, 'Lady_Antebellum'),
(3475, 136, 24, ''),
(3476, 136, 25, '5'),
(3477, 136, 31, '2008'),
(3478, 136, 32, 'CAPITOL'),
(3479, 136, 33, '1'),
(3480, 137, 1, '8.54'),
(3481, 137, 2, ''),
(3482, 137, 3, '5'),
(3483, 137, 4, 'MUSIC-C-3'),
(3484, 137, 5, ''),
(3485, 137, 6, ''),
(3486, 137, 7, '3'),
(3487, 137, 8, '1'),
(3488, 137, 9, 'avactis-images/211403591_0.jpg'),
(3489, 137, 10, 'avactis-images/thumb_211403591_0.jpg'),
(3490, 137, 11, 'Wanted! The Outlaws - Waylon Jennings'),
(3491, 137, 12, '<span style="font-family: ''Times New Roman''; font-size: medium" class="Apple-style-span"><div style="font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; background-color: #ffffff">The term &quot;outlaw&quot; had been bandied about after Waylon Jennings'' 1972 hit &quot;Ladies Love Outlaws,&quot; but it didn''t permanently gel until the release of the album Wanted! The Outlaws in 1976. The songs in this packaged product weren''t new -- the album contained previously released material by Jennings, Willie Nelson, Tompall Glaser, and Jennings'' wife Jessi Colter (who had hit the charts a year earlier with &quot;I''m Not Lisa&quot;). But it marked the industry''s recognition of the changing times, and as the center point of a campaign to publicize Nashville''s new &quot;progressive&quot; breed, it worked like a charm. It quickly became the first country album to sell more than a million copies, and it boosted the careers of all involved.&nbsp;</div></span>'),
(3492, 137, 13, '<font face="arial,helvetica,sans-serif" size="3"><span style="font-family: ''Times New Roman''; font-size: medium" class="Apple-style-span"><div style="font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; background-color: #ffffff"><font face="arial,helvetica,sans-serif" size="3"><span style="font-family: ''Times New Roman''; font-size: medium" class="Apple-style-span"><font face="arial,helvetica,sans-serif">The term &quot;outlaw&quot; had been bandied about after Waylon Jennings'' 1972 hit &quot;Ladies Love Outlaws,&quot; but it didn''t permanently gel until the release of the album Wanted! The Outlaws in 1976. </font></span></font></div><div style="font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; background-color: #ffffff">&nbsp;</div><div style="font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; background-color: #ffffff"><font face="arial,helvetica,sans-serif" size="3"><span style="font-family: ''Times New Roman''; font-size: medium" class="Apple-style-span"><font face="arial,helvetica,sans-serif">The songs in this packaged product weren''t new -- the album contained previously released material by Jennings, Willie Nelson, Tompall Glaser, and Jennings'' wife Jessi Colter (who had hit the charts a year earlier with &quot;I''m Not Lisa&quot;). </font></span></font></div><div style="font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; background-color: #ffffff">&nbsp;</div><div style="font-family: Verdana,Arial,Helvetica,sans-serif; font-size: 11px; background-color: #ffffff"><font face="arial,helvetica,sans-serif" size="3"><span style="font-family: ''Times New Roman''; font-size: medium" class="Apple-style-span"><font face="arial,helvetica,sans-serif">But it marked the industry''s recognition of the changing times, and as the center point of a campaign to publicize Nashville''s new &quot;progressive&quot; breed, it worked like a charm. It quickly became the first country album to sell more than a million copies, and it boosted the careers of all involved. </font><br /></span></font></div></span></font>'),
(3493, 137, 14, ''),
(3494, 137, 15, '0.20'),
(3495, 137, 17, 'Wanted! The Outlaws - Waylon Jennings'),
(3496, 137, 18, 'Wanted! The Outlaws - Waylon Jennings , music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy'),
(3497, 137, 19, 'The term "outlaw" had been bandied about after Waylon Jennings'' 1972 hit "Ladies Love Outlaws," but it didn''t permanently gel until the release of the album Wanted! The Outlaws in 1976. The songs in this packaged product weren''t new -- the album contained previously released material by Jennings, Willie Nelson, Tompall Glaser, and Jennings'' wife Jessi Colter (who had hit the charts a year earlier with "I''m Not Lisa"). But it marked the industry''s recognition of the changing times, and as the center point of a campaign to publicize Nashville''s new "progressive" breed, it worked like a charm. It quickly became the first country album to sell more than a million copies, and it boosted the careers of all involved. '),
(3498, 137, 20, ''),
(3499, 137, 21, '2'),
(3500, 137, 22, '1'),
(3501, 137, 23, 'Wanted_The_Outlaws_-_Waylon_Jennings'),
(3502, 137, 24, ''),
(3503, 137, 25, '5'),
(3504, 137, 31, '1976'),
(3505, 137, 32, 'RCA'),
(3506, 137, 33, '1'),
(3507, 138, 1, '599.00'),
(3508, 138, 2, ''),
(3509, 138, 3, '15'),
(3510, 138, 4, 'FR1-1'),
(3511, 138, 5, ''),
(3512, 138, 6, ''),
(3513, 138, 7, '3'),
(3514, 138, 8, '1'),
(3515, 138, 9, 'avactis-images/62950_PE170189_S4.jpg'),
(3516, 138, 10, 'avactis-images/thumb_62950_PE170189_S4.jpg'),
(3517, 138, 11, 'ARILD Chair'),
(3518, 138, 12, '<p><b>Key features</b><br /> </p><ul><li>Seat surfaces and armrests in heavy, hardwearing, easy care grain leather; practical for families with children.</li><li>The back cushion is kept in place by a zipper.</li><li>Seat cushion filled with polyurethane foam, polyester fibers and waterfowl feathers provides great seating comfort.</li></ul>'),
(3519, 138, 13, '<p><b>Key features</b></p><ul><li>Seat surfaces and armrests in heavy, hardwearing, easy care grain leather; practical for families with children.</li><li>The back cushion is kept in place by a zipper.</li><li>Seat cushion filled with polyurethane foam, polyester fibers and waterfowl feathers provides great seating comfort.</li></ul>'),
(3520, 138, 14, ''),
(3521, 138, 15, ''),
(3522, 138, 17, 'ARILD Chair'),
(3523, 138, 18, 'ARILD Chair, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(3524, 138, 19, 'ARILD Chair, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(3525, 138, 20, ''),
(3526, 138, 21, '2'),
(3527, 138, 22, '1'),
(3528, 138, 23, 'ARILD_Chair'),
(3529, 138, 24, '7'),
(3530, 138, 25, '5'),
(3531, 139, 1, '149.00'),
(3532, 139, 2, ''),
(3533, 139, 3, '23'),
(3534, 139, 4, 'FR1-2'),
(3535, 139, 5, ''),
(3536, 139, 6, ''),
(3537, 139, 7, '3'),
(3538, 139, 8, '1'),
(3539, 139, 9, 'avactis-images/239032_PE131239_S4.jpg'),
(3540, 139, 10, 'avactis-images/thumb_239032_PE131239_S4.jpg'),
(3541, 139, 11, 'EKTORP TULLSTA Chair'),
(3542, 139, 12, '<p><b>Key features</b><br /> </p><ul><li>Easy to keep clean with a removable,machine washable cover.</li><li>The pillow provides comfortable lumbar support.</li><li>A range of coordinated covers makes it easy for you to give your furniture a new look.</li><li>Slim lines, easy to place.</li></ul>'),
(3543, 139, 13, '<p><b>Key features</b></p><ul><li>Easy to keep clean with a removable,machine washable cover.</li><li>The pillow provides comfortable lumbar support.</li><li>A range of coordinated covers makes it easy for you to give your furniture a new look.</li><li>Slim lines, easy to place.</li></ul><p>&nbsp;</p>'),
(3544, 139, 14, ''),
(3545, 139, 15, ''),
(3546, 139, 17, 'EKTORP TULLSTA Chair'),
(3547, 139, 18, 'EKTORP TULLSTA Chair, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(3548, 139, 19, 'EKTORP TULLSTA Chair, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(3549, 139, 20, ''),
(3550, 139, 21, '2'),
(3551, 139, 22, '1'),
(3552, 139, 23, 'EKTORP_TULLSTA_Chair'),
(3553, 139, 24, '-1'),
(3554, 139, 25, '5'),
(3555, 140, 1, '39.99'),
(3556, 140, 2, ''),
(3557, 140, 3, '5'),
(3558, 140, 4, 'MUSIC-7'),
(3559, 140, 5, ''),
(3560, 140, 6, ''),
(3561, 140, 7, '3'),
(3562, 140, 8, '1'),
(3563, 140, 9, 'avactis-images/mus_tchaikovsky.jpg'),
(3564, 140, 10, 'avactis-images/thumb_mus_tchaikovsky.jpg'),
(3565, 140, 11, 'Tchaikovsky: Ballet Music'),
(3566, 140, 12, 'Seven CDs containing Tchaikovsky''s complete ballet music for ''Sleeping Beauty'',  ''Swan Lake'', ''The Nutcracker'', plus Glazunov''s orchestration of Chopin piano  music fashioned into a ballet called ''Les Sylphides''. '),
(3567, 140, 13, '<p><font size="3" face="arial,helvetica,sans-serif">Seven CDs containing Tchaikovsky''s complete ballet music for ''<i>Sleeping Beauty</i>'',  ''<i>Swan Lake</i>'', ''<i>The Nutcracker</i>'', plus Glazunov''s orchestration of Chopin piano  music fashioned into a ballet called ''<i>Les Sylphides</i>''.</font></p><ul><li><font size="3" face="arial,helvetica,sans-serif"><b>Composer:</b> Tchailkovsky</font></li><li><font size="3" face="arial,helvetica,sans-serif"><b>Number of Discs:</b> 7</font></li><li><font size="3" face="arial,helvetica,sans-serif"><b>Format:</b> Box set</font></li></ul>'),
(3568, 140, 14, ''),
(3569, 140, 15, '0.20'),
(3570, 140, 17, 'Tchaikovsky: Ballet Music'),
(3571, 140, 18, 'music, classical, opera, rock, electonic, alternative, hard & heavy, Tchaikovsky, Ballet Music, Tchaikovsky Ballet'),
(3572, 140, 19, 'Seven CDs containing Tchaikovsky''s complete ballet music for ''Sleeping Beauty'', ''Swan Lake'', ''The Nutcracker'', plus Glazunov''s orchestration of Chopin piano music fashioned into a ballet called ''Les Sylphides'' '),
(3573, 140, 20, ''),
(3574, 140, 21, '2'),
(3575, 140, 22, '1'),
(3576, 140, 23, 'Tchaikovsky_Ballet_Music'),
(3577, 140, 24, ''),
(3578, 140, 25, '5'),
(3579, 140, 36, '2009'),
(3580, 140, 37, 'Naxos'),
(3581, 140, 38, '7'),
(3717, 146, 1, '12.99'),
(3718, 146, 2, '18.98'),
(3719, 146, 3, '20'),
(3720, 146, 4, 'MUSIC-14'),
(3721, 146, 5, ''),
(3722, 146, 6, ''),
(3723, 146, 7, '3'),
(3724, 146, 8, '1'),
(3725, 146, 9, 'avactis-images/mus_mckennitt1.jpg'),
(3726, 146, 10, 'avactis-images/thumb_mus_mckennitt1.jpg'),
(3727, 146, 11, 'A Midwinter Night''s Dream - Loreena McKennitt'),
(3728, 146, 12, '2008 release. On her first full-length holiday album, Loreena celebrates the  season with a CD that blends the five songs from A Winter Garden (1995) with  eight new recordings inspired by seasonal favorites. 13 tracks including ''The  Holly &amp; The Ivy'', ''Good King Wenceslas'', ''Seeds Of Love'', ''Coventry Carol''  and more. '),
(3729, 146, 13, '<p>2008 release. On her first full-length holiday album, Loreena celebrates the  season with a CD that blends the five songs from A Winter Garden (1995) with  eight new recordings inspired by seasonal favorites. 13 tracks including ''The  Holly &amp; The Ivy'', ''Good King Wenceslas'', ''Seeds Of Love'', ''Coventry Carol''  and more.</p><p><b>Tracks</b></p><table border="0" cellpadding="3" cellspacing="1"> <tbody><tr class="listRowEven"> <td>1. Holly &amp; The Ivy </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_001?ie=UTF8&track=001&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>2. Flambeau, Jeannette, Isabelle </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen"></td>''); } //-->   </tr> <tr class="listRowEven"> <td>3. Seven Rejoices of Mary </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_003?ie=UTF8&track=003&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>4. No&euml;l Nouvelet! </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_004?ie=UTF8&track=004&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>5. Good King Wenceslas </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_005?ie=UTF8&track=005&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>6. Coventry Carol [Live] </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_006?ie=UTF8&track=006&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>7. God Rest Ye Merry, Gentlemen [Abdelli Version] </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_007?ie=UTF8&track=007&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>8. Snow </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_008?ie=UTF8&track=008&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>9. Breton Carol </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_009?ie=UTF8&track=009&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>10. Seeds of Love </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_010?ie=UTF8&track=010&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>11. Gloucestershire Wassail </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_011?ie=UTF8&track=011&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>12. Emmanuel </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_012?ie=UTF8&track=012&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>13. In the Bleak Midwinter </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B001G9LVGG/ref=pd_krex_dp_001_013?ie=UTF8&track=013&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr></tbody></table>'),
(3730, 146, 14, ''),
(3731, 146, 15, '0.20'),
(3732, 146, 17, 'A Midwinter Night''s Dream - Loreena McKennitt'),
(3733, 146, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy, Loreena McKennitt, folk music, A Midwinter Night''s Dream'),
(3734, 146, 19, 'Loreena celebrates the season with a CD that blends the five songs from A Winter Garden (1995) with eight new recordings inspired by seasonal favorites.'),
(3735, 146, 20, ''),
(3736, 146, 21, '2'),
(3737, 146, 22, '1'),
(3738, 146, 23, 'A_Midwinter_Nights_Dream_-_Loreena_McKennitt'),
(3739, 146, 24, ''),
(3740, 146, 25, '5'),
(3741, 146, 31, '2008'),
(3742, 146, 32, 'Quinlan Road'),
(3743, 146, 33, '1'),
(3744, 147, 1, '12.99'),
(3745, 147, 2, '18.98'),
(3746, 147, 3, '5'),
(3747, 147, 4, 'MUSIC-15'),
(3748, 147, 5, ''),
(3749, 147, 6, ''),
(3750, 147, 7, '3'),
(3751, 147, 8, '1'),
(3752, 147, 9, 'avactis-images/mus_mckennitt2.jpg'),
(3753, 147, 10, 'avactis-images/thumb_mus_mckennitt2.jpg'),
(3754, 147, 11, 'An Ancient Muse - Loreena McKennitt'),
(3755, 147, 12, 'An Ancient Muse is &quot;eclectic celtic&quot; - singer/composer Loreena McKennitt''s  highly-anticipated first new studio recording in nine years. Taking up where her  previous work left off, McKennitt fuses the melodic sensibility of Celtic  Balladry with musical traditions from Greece, Turkey, Spain, and beyond. Once  heard, never forgotten, Loreena MacKennitt leads the listener on a timeless  journey from the Scottish borders to the caravanserais of the Silk Road to the  wine-dark seas of Homer''s Odyssey. McKennitt''s worldwide multi-platinum sales  culminated in her most recent album, 1997''s The Book of Secrets, which reached  #17 on the Billboard Top 200 Chart.'),
(3756, 147, 13, '<p>An Ancient Muse is &quot;eclectic celtic&quot; - singer/composer Loreena McKennitt''s  highly-anticipated first new studio recording in nine years. Taking up where her  previous work left off, McKennitt fuses the melodic sensibility of Celtic  Balladry with musical traditions from Greece, Turkey, Spain, and beyond. </p><p>Once  heard, never forgotten, Loreena MacKennitt leads the listener on a timeless  journey from the Scottish borders to the caravanserais of the Silk Road to the  wine-dark seas of Homer''s Odyssey. McKennitt''s worldwide multi-platinum sales  culminated in her most recent album, 1997''s The Book of Secrets, which reached  #17 on the Billboard Top 200 Chart.</p><p><b>Tracks</b> </p><ol><li>&quot;Incantation </li><li>&quot;The Gates of Istanbul&quot;</li><li>&quot;Caravanserai&quot;</li><li>&quot;The English Ladye and the Knight&quot;</li><li>&quot;Kecharitomene&quot;</li><li>&quot;Penelope''s Song&quot;</li><li>&quot;Sacred Shabbat&quot;</li><li>&quot;Beneath a Phrygian Sky&quot;</li><li>&quot;Never-ending Road (Amhr&aacute;n Duit)&quot;</li></ol>'),
(3757, 147, 14, ''),
(3758, 147, 15, '0.20'),
(3759, 147, 17, 'An Ancient Muse - Loreena McKennitt'),
(3760, 147, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy, loreena mckenitt, an ancient muse, loreena mckenitt 2006, celtic music'),
(3761, 147, 19, 'An Ancient Muse is "eclectic celtic" - singer/composer Loreena McKennitt''s highly-anticipated first new studio recording in nine years.'),
(3762, 147, 20, ''),
(3763, 147, 21, '2'),
(3764, 147, 22, '1'),
(3765, 147, 23, 'An_Ancient_Muse_-_Loreena_McKennitt'),
(3766, 147, 24, ''),
(3767, 147, 25, '5'),
(3768, 147, 31, '2006'),
(3769, 147, 32, 'Verve'),
(3770, 147, 33, '1'),
(3771, 148, 1, '13.98'),
(3772, 148, 2, ''),
(3773, 148, 3, '5'),
(3774, 148, 4, 'MUSIC-16'),
(3775, 148, 5, ''),
(3776, 148, 6, ''),
(3777, 148, 7, '3'),
(3778, 148, 8, '1'),
(3779, 148, 9, 'avactis-images/mus_cmills.jpg'),
(3780, 148, 10, 'avactis-images/thumb_mus_cmills.jpg'),
(3781, 148, 11, 'Living in the Aftermath'),
(3782, 148, 12, 'The latest collection from one of America''s most wandering-est of wandering  troubadours. After almost a decade of rave reviews &amp; countless shows in  stadiums &amp; shoeboxes (the past 2 yrs alone have seen him touring alongside  Ben Folds, Bishop Allen, Lucero &amp; many more). Harvesting music &amp; lyrics  from headlines, horror movies, four-color ash-can adventures, and the black  &amp; white reflections of late night re-reruns, Mills returns with a raw &amp;  ready collection of true rock n'' roll numbers, each one peppered with knowing  asides &amp; unencumbered poignancy. '),
(3783, 148, 13, '<p>The latest collection from one of America''s most wandering-est of wandering  troubadours. After almost a decade of rave reviews &amp; countless shows in  stadiums &amp; shoeboxes (the past 2 yrs alone have seen him touring alongside  Ben Folds, Bishop Allen, Lucero &amp; many more). Harvesting music &amp; lyrics  from headlines, horror movies, four-color ash-can adventures, and the black  &amp; white reflections of late night re-reruns, Mills returns with a raw &amp;  ready collection of true rock n'' roll numbers, each one peppered with knowing  asides &amp; unencumbered poignancy. </p><p><b>&nbsp;Tracks:</b> </p><table border="0" cellpadding="3" cellspacing="1"> <tbody><tr class="listRowEven"> <td>1. Calling All Comrades </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_001?ie=UTF8&track=001&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>2. Living in the Aftermath </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_002?ie=UTF8&track=002&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>3. Nightmare at 20, 000 Feet </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_003?ie=UTF8&track=003&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>4. Such a Beautiful Thing </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_004?ie=UTF8&track=004&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>5. Blackbirds </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_005?ie=UTF8&track=005&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>6. Atom Smashers </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_006?ie=UTF8&track=006&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>7. I Guess This Is Why (They Invented Goodbye) </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_007?ie=UTF8&track=007&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>8. All''s Well That Ends </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_008?ie=UTF8&track=008&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>9. Can''t Believe </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0014DC0L4/ref=pd_krex_dp_001_009?ie=UTF8&track=009&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr></tbody></table>'),
(3784, 148, 14, ''),
(3785, 148, 15, '0.20'),
(3786, 148, 17, 'Living in the Aftermath'),
(3787, 148, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy, country music, alt-folk, chris mills, Living in the Aftermath'),
(3788, 148, 19, 'The latest collection from one of America''s most wandering-est of wandering troubadours.'),
(3789, 148, 20, ''),
(3790, 148, 21, '2'),
(3791, 148, 22, '1'),
(3792, 148, 23, 'Living_in_the_Aftermath_-_Chris_Mills'),
(3793, 148, 24, ''),
(3794, 148, 25, '5'),
(3795, 148, 31, '2008'),
(3796, 148, 32, 'Ernest Jenning'),
(3797, 148, 33, '1'),
(3798, 149, 1, '10.99'),
(3799, 149, 2, ''),
(3800, 149, 3, '5'),
(3801, 149, 4, 'MUSIC-17'),
(3802, 149, 5, ''),
(3803, 149, 6, ''),
(3804, 149, 7, '3'),
(3805, 149, 8, '1'),
(3806, 149, 9, 'avactis-images/mus_chuckwagongang.jpg'),
(3807, 149, 10, 'avactis-images/thumb_mus_chuckwagongang.jpg'),
(3808, 149, 11, 'I''ll Fly Away - Chuck Wagon Gang'),
(3809, 149, 12, '<p><b>Tracks</b> <br /> </p> <table border="0" cellpadding="3" cellspacing="1">  <tbody><tr class="listRowEven"> <td>1. I''ll Fly Away </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_001?ie=UTF8&track=001&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>2. Echoes From the Burning Bush </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_002?ie=UTF8&track=002&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>3. Heaven Will Surely Be Worth It All </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_003?ie=UTF8&track=003&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>4. God Put a Rainbow In the Cloud </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_004?ie=UTF8&track=004&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>5. This World Is Not My Home </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_005?ie=UTF8&track=005&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>6. He''s Everything To Me </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_006?ie=UTF8&track=006&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>7. Where the Soul Never Dies </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_007?ie=UTF8&track=007&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>8. I''ve Found a Hiding Place </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_008?ie=UTF8&track=008&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>9. I''ll Be No Stranger There </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_009?ie=UTF8&track=009&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>10. He Said If I Be Lifted Up </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_010?ie=UTF8&track=010&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr></tbody> </table> '),
(3810, 149, 13, '<p><b>Tracks</b> </p><b></b><table border="0" cellpadding="3" cellspacing="1"> <tbody><tr class="listRowEven"> <td>1. I''ll Fly Away </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_001?ie=UTF8&track=001&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>2. Echoes From the Burning Bush </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_002?ie=UTF8&track=002&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>3. Heaven Will Surely Be Worth It All </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_003?ie=UTF8&track=003&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>4. God Put a Rainbow In the Cloud </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_004?ie=UTF8&track=004&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>5. This World Is Not My Home </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_005?ie=UTF8&track=005&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>6. He''s Everything To Me </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_006?ie=UTF8&track=006&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>7. Where the Soul Never Dies </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_007?ie=UTF8&track=007&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>8. I''ve Found a Hiding Place </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_008?ie=UTF8&track=008&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowEven"> <td>9. I''ll Be No Stranger There </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_009?ie=UTF8&track=009&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr> <tr class="listRowOdd"> <td>10. He Said If I Be Lifted Up </td>  <!-- if (browserHasRadio()){             document.write(''<td class="listen">'');var link = krexLink(''/gp/recsradio/radio/B0002584OM/ref=pd_krex_dp_001_010?ie=UTF8&track=010&disc=001''); document.write(link + ''Listen</a><img src="http://g-ecx.images-amazon.com/images/G/01/x-locale/detail/music/notes_clear._V47082447_.gif" width="14" alt="" align="bottom" class="icon" height="14" border="0" /></td>'');} //-->   </tr></tbody></table>'),
(3811, 149, 14, ''),
(3812, 149, 15, '0.20'),
(3813, 149, 17, 'I''ll Fly Away - Chuck Wagon Gang'),
(3814, 149, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy, country, chunk wagon gang, I''ll Fly Away'),
(3815, 149, 19, 'I''ll Fly Away - Chuck Wagon Gang'),
(3816, 149, 20, ''),
(3817, 149, 21, '2'),
(3818, 149, 22, '1'),
(3819, 149, 23, 'Chuck_Wagon_Gang'),
(3820, 149, 24, ''),
(3821, 149, 25, '5'),
(3822, 149, 31, '2004'),
(3823, 149, 32, 'Music Mill'),
(3824, 149, 33, '1'),
(3825, 150, 1, '17.98'),
(3826, 150, 2, ''),
(3827, 150, 3, '25'),
(3828, 150, 4, 'MUSIC-18'),
(3829, 150, 5, ''),
(3830, 150, 6, ''),
(3831, 150, 7, '3'),
(3832, 150, 8, '1'),
(3833, 150, 9, 'avactis-images/mus_folk1.jpg'),
(3834, 150, 10, 'avactis-images/thumb_mus_folk1.jpg'),
(3835, 150, 11, 'Tunes From the Attic'),
(3836, 150, 12, '<p><b>Tracks</b></p>  <table width="100%" bgcolor="#ffffff" border="0" cellpadding="4" cellspacing="1"><tbody><tr class="rowEven">  <td class="titleCol">&nbsp; 1. Joyne  Hands</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 2. You  Lasses and Lads</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 3. Jenny,  My Blithest Maid</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 4. Johnny  Cock thy Beaver</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 5. Paven;  Galliard</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 6. The  Mermaid''s Song</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 7. The  Old Maid of the Mill Dust</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 8. The  Northern Lasse''s Lamentation</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 9. Well  Hall</td>   </tr> <tr class="rowOdd">  <td class="titleCol">10. The  Jewes Dawnce</td>   </tr> <tr class="rowEven">  <td class="titleCol">11. Come  Love, Let''s Walk</td>   </tr> <tr class="rowOdd">  <td class="titleCol">12. Green  Garter</td>   </tr> <tr class="rowEven">  <td class="titleCol">13. The  Irish Ho-Hoane</td>   </tr> <tr class="rowOdd">  <td class="titleCol">14. The  Irishe Dumpe</td>   </tr> <tr class="rowEven">  <td class="titleCol">15. Oh!  How Happy''s He</td>   </tr> <tr class="rowOdd">  <td class="titleCol">16. Callino</td>   </tr> <tr class="rowEven">  <td class="titleCol">17. Joy  to the Person of My Love</td>   </tr></tbody></table>'),
(3837, 150, 13, '<p><b>Tracks</b></p>  <table width="100%" bgcolor="#ffffff" border="0" cellpadding="4" cellspacing="1"><tbody><tr class="rowEven">  <td class="titleCol">&nbsp; 1. Joyne  Hands</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 2. You  Lasses and Lads</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 3. Jenny,  My Blithest Maid</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 4. Johnny  Cock thy Beaver</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 5. Paven;  Galliard</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 6. The  Mermaid''s Song</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 7. The  Old Maid of the Mill Dust</td>   </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 8. The  Northern Lasse''s Lamentation</td>   </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 9. Well  Hall</td>   </tr> <tr class="rowOdd">  <td class="titleCol">10. The  Jewes Dawnce</td>   </tr> <tr class="rowEven">  <td class="titleCol">11. Come  Love, Let''s Walk</td>   </tr> <tr class="rowOdd">  <td class="titleCol">12. Green  Garter</td>   </tr> <tr class="rowEven">  <td class="titleCol">13. The  Irish Ho-Hoane</td>   </tr> <tr class="rowOdd">  <td class="titleCol">14. The  Irishe Dumpe</td>   </tr> <tr class="rowEven">  <td class="titleCol">15. Oh!  How Happy''s He</td>   </tr> <tr class="rowOdd">  <td class="titleCol">16. Callino</td>   </tr> <tr class="rowEven">  <td class="titleCol">17. Joy  to the Person of My Love</td>   </tr></tbody></table>'),
(3838, 150, 14, ''),
(3839, 150, 15, '0.20'),
(3840, 150, 17, 'Tunes From the Attic'),
(3841, 150, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy, folk music, Tunes From the Attic, Chris Norman, Larry Kipkis, Mark Cudek'),
(3842, 150, 19, 'Tunes From the Attic'),
(3843, 150, 20, ''),
(3844, 150, 21, '2'),
(3845, 150, 22, '1'),
(3846, 150, 23, 'Tunes_From_the_Attic'),
(3847, 150, 24, ''),
(3848, 150, 25, '5'),
(3849, 150, 31, '1997'),
(3850, 150, 32, 'Dorian Recordings'),
(3851, 150, 33, '1'),
(3960, 155, 1, '11.99'),
(3961, 155, 2, '13.96'),
(3962, 155, 3, '20'),
(3963, 155, 4, 'MUSIC-23'),
(3964, 155, 5, ''),
(3965, 155, 6, ''),
(3966, 155, 7, '3'),
(3967, 155, 8, '1'),
(3968, 155, 9, 'avactis-images/disk1.jpg'),
(3969, 155, 10, 'avactis-images/thumb_disk1.jpg'),
(3970, 155, 11, 'Where The Wild Things Are - Original Songs By Karen O And The Kids'),
(3971, 155, 12, 'Inside Karen O is a Wild Thing - as singer for the Grammy-nominated Yeah Yeah  Yeahs, her wild thing is in your face, vulnerable, obnoxious, tender,  exciting... a self-proclaimed &quot;spazoid.&quot; To Oscar-nominated Where the Wild  Things Are director Spike Jonze, however, Karen O and her music possess  something of a child-like innocence, a guileless charm that put her exactly on  the right emotional wavelength to sonically capture the film, be it a tender  moment or a wild rumpus.  '),
(3972, 155, 13, '<p><font size="3">Inside Karen O is a Wild Thing - as singer for the Grammy-nominated Yeah Yeah  Yeahs, her wild thing is in your face, vulnerable, obnoxious, tender,  exciting... a self-proclaimed &quot;spazoid.&quot; To Oscar-nominated Where the Wild  Things Are director Spike Jonze, however, Karen O and her music possess  something of a child-like innocence, a guileless charm that put her exactly on  the right emotional wavelength to sonically capture the film, be it a tender  moment or a wild rumpus.  </font></p><p><font size="3">To compose the music, O enlisted friends and fellow musicians she believed  had a musical intuition that would bolster her intent to marry sound to vision.  Dubbed Karen O and the Kids, these include Tristan Bechet (Services), Tom Biller  (co-producer with Karen O and member of Afternoons), Bradford Cox (Deerhunter),  Brian Chase (Yeah Yeah Yeahs), Dean Fertita (Queens of the Stone Age, The Dead  Weather, The Raconteurs), Aaron Hemphill (Liars), Greg Kurstin (The Bird and the  Bee), Jack Lawrence (The Dead Weather, The Raconteurs, The Greenhornes), Oscar  Michel (Gris Gris), Imaad Wasif (New Folk Implosion, Alaska), Nick Zinner, (Yeah  Yeah Yeahs) and an untrained children''s choir.</font></p>'),
(3973, 155, 14, ''),
(3974, 155, 15, '0.20'),
(3975, 155, 17, 'Where The Wild Things Are - Original Songs By Karen O And The Kids'),
(3976, 155, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy'),
(3977, 155, 19, 'Avactis Music store, various music disks'),
(3978, 155, 20, ''),
(3979, 155, 21, '2'),
(3980, 155, 22, '1'),
(3981, 155, 23, 'Where_The_Wild_Things_Are'),
(3982, 155, 24, ''),
(3983, 155, 25, '5'),
(3984, 155, 31, '2009'),
(3985, 155, 32, 'Interscope Records'),
(3986, 155, 33, '1'),
(3987, 156, 1, '13.99'),
(3988, 156, 2, '15.98'),
(3989, 156, 3, '20'),
(3990, 156, 4, 'MUSIC-24'),
(3991, 156, 5, ''),
(3992, 156, 6, ''),
(3993, 156, 7, '3'),
(3994, 156, 8, '1'),
(3995, 156, 9, 'avactis-images/mus_welcometomali.jpg'),
(3996, 156, 10, 'avactis-images/thumb_mus_welcometomali.jpg'),
(3997, 156, 11, 'Welcome To Mali - Amadou & Mariam'),
(3998, 156, 12, '<p>2009 U.S. pressing of this album, the follow up to the celebrated release Dimanche &hellip; Bamako, which sold more than half a million copies worldwide and won the couple numerous accolades upon it''s release in 2005. </p><p>Welcome To Mali features a track ''Sabali'', produced by Damon Albarn, plus special guest appearances by K''naan, Keziah Jones, ''M'', Toumani Diabate, Tiken Jah Fakoli and Juan Rozoff. </p><p>The album expands their horizons and yet remains true to their core sound, putting the spotlight firmly back on their unique mix of sweet melodies and funky rhythms, driven by Amadou''s bluesy guitar and the duo''s compelling voices.</p>');
INSERT INTO `[[dbprefix]]product_attributes` VALUES
(3999, 156, 13, '<p><font size="3">2009 U.S. pressing of this album, the follow up to the celebrated release  Dimanche &hellip; Bamako, which sold more than half a million copies worldwide and won  the couple numerous accolades upon it''s release in 2005. </font></p><p><font size="3">Welcome To Mali  features a track ''Sabali'', produced by Damon Albarn, plus special guest  appearances by K''naan, Keziah Jones, ''M'', Toumani Diabate, Tiken Jah Fakoli and  Juan Rozoff. </font></p><p><font size="3">The album expands their horizons and yet remains true to their core  sound, putting the spotlight firmly back on their unique mix of sweet melodies  and funky rhythms, driven by Amadou''s bluesy guitar and the duo''s compelling  voices.</font></p>'),
(4000, 156, 14, ''),
(4001, 156, 15, '0.20'),
(4002, 156, 17, 'Welcome To Mali - Amadou & Mariam'),
(4003, 156, 18, 'music, classical, opera, vinyl LPs, rock, electronic, alternative, hard & heavy, world music, welcome to mail, ethnic music, Amadou & Mariam'),
(4004, 156, 19, '2009 U.S. pressing of this album, the follow up to the celebrated release Dimanche'),
(4005, 156, 20, ''),
(4006, 156, 21, '2'),
(4007, 156, 22, '1'),
(4008, 156, 23, 'Welcome_To_Mali_-_Amadou___Mariam'),
(4009, 156, 24, ''),
(4010, 156, 25, '5'),
(4011, 156, 31, '2008'),
(4012, 156, 32, 'Nonesuch'),
(4013, 156, 33, '1'),
(4014, 157, 1, '13.99'),
(4015, 157, 2, '17.88'),
(4016, 157, 3, '5'),
(4017, 157, 4, 'MUSIC-25'),
(4018, 157, 5, ''),
(4019, 157, 6, ''),
(4020, 157, 7, '3'),
(4021, 157, 8, '1'),
(4022, 157, 9, 'avactis-images/mus_jarosz.jpg'),
(4023, 157, 10, 'avactis-images/thumb_mus_jarosz.jpg'),
(4024, 157, 11, 'Song Up in Her Head - Sarah Jarosz'),
(4025, 157, 12, 'Seventeen-year-old Texas native Sarah Jarosz emerged on the scene about five  years ago as someone to watch. Jamming onstage with bluegrass icons David  Grisman and Ricky Skaggs, she played her mandolin with a sure touch and real  joy. It looked and sounded comfortable in her then twelve-year-old hands. She  started writing songs on the guitar and took up the banjo. While her  instrumental talents are formidable, let''s make one thing clear: Sarah is a  singer. Her voice is velvety smooth, agile, and powerful, occasionally  reminiscent of such disparate artists as Natalie Maines and Patty Griffin. '),
(4026, 157, 13, '<p>Seventeen-year-old Texas native Sarah Jarosz emerged on the scene about five  years ago as someone to watch. Jamming onstage with bluegrass icons David  Grisman and Ricky Skaggs, she played her mandolin with a sure touch and real  joy. It looked and sounded comfortable in her then twelve-year-old hands. She  started writing songs on the guitar and took up the banjo. While her  instrumental talents are formidable, let''s make one thing clear: Sarah is a  singer. Her voice is velvety smooth, agile, and powerful, occasionally  reminiscent of such disparate artists as Natalie Maines and Patty Griffin. </p><p><b>Tracks </b></p><table bgcolor="#ffffff" border="0" cellpadding="4" cellspacing="1" width="100%"><tbody><tr class="rowEven">  <td class="titleCol">&nbsp; 1. Song Up In  Her Head</td> <td class="runtimeCol">2:43</td>  </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 2. Edge Of A  Dream</td> <td class="runtimeCol">3:42</td>  </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 3. Tell Me  True</td> <td class="runtimeCol">4:08</td>  </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 4. Mansinneedof</td> <td class="runtimeCol">2:51</td>  </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 5. I Can''t  Love You Now</td> <td class="runtimeCol">2:34</td>  </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 6. Broussard''s  Lament</td> <td class="runtimeCol">3:36</td>  </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 7. Fischer  Store Road</td> <td class="runtimeCol">2:17</td>  </tr> <tr class="rowOdd">  <td class="titleCol">&nbsp; 8. Left  Home</td> <td class="runtimeCol">3:24</td>  </tr> <tr class="rowEven">  <td class="titleCol">&nbsp; 9. Shankill  Butchers</td> <td class="runtimeCol">4:22</td>  </tr> <tr class="rowOdd">  <td class="titleCol">10. Can''t  Hide</td> <td class="runtimeCol">3:11</td>  </tr> <tr class="rowEven">  <td class="titleCol">11. Long  Journey</td> <td class="runtimeCol">5:17</td>  </tr> <tr class="rowOdd">  <td class="titleCol">12. Come On Up  To The House</td> <td class="runtimeCol">4:27</td>  </tr> <tr class="rowEven">  <td class="titleCol">13. Little  Song</td> <td class="runtimeCol">2:48</td>  </tr></tbody></table>'),
(4041, 158, 1, '12.99'),
(4042, 158, 2, '18.98'),
(4043, 158, 3, '25'),
(4044, 158, 4, 'MUSIC-26'),
(4045, 158, 5, ''),
(4046, 158, 6, ''),
(4047, 158, 7, '3'),
(4048, 158, 8, '1'),
(4049, 158, 9, 'avactis-images/mus_worldsongs.jpg'),
(4050, 158, 10, 'avactis-images/thumb_mus_worldsongs.jpg'),
(4051, 158, 11, 'Songs Around The World - Playing for Change'),
(4052, 158, 12, '&quot;The act of playing music with people of different cultures, religions,  economics and politics is a powerful statement. It shows that we can find ways  of working together and sharing our experiences with one another in a positive  way. Music has the power to break down the walls between cultures, to raise the  level of human understanding.&quot; ~ Mark Johnson, founder, Playing for Change '),
(4053, 158, 13, '<p><font size="3">Bill Moyers called it a remarkable example of &quot;the simple yet transformative  power of music... to touch something in each of us.&quot; Variety acknowledged it as  &quot;a great showcase for just what incredible, thoroughly accessible popular music  is being made worldwide. Utilizing innovative mobile audio/video techniques,  Playing for Change (PFC) records musicians outdoors in cities and townships  worldwide. </font></p><p><font size="3">They''ve travelled from post-Katrina New Orleans to post-apartheid  South Africa, from the remote beauty of the Himalayas to the religious diversity  of Jerusalem. Their talents are captured in myriad environments: under the sun  and beneath the streetlights... in public parks, plazas and promenades... in  doorways, on cobblestone streets, amid hilly pueblos. </font></p><p><font size="3">Their performances are  subsequently combined in allowing them to collaborate - albeit separated by  hundreds, or even thousands, of miles.</font></p>'),
(4027, 157, 14, ''),
(4028, 157, 15, '0.20'),
(4029, 157, 17, 'Song Up in Her Head - Sarah Jarosz'),
(4030, 157, 18, 'music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy, Sarah Jarosz, Song Up in her head, indie rock, indie music, Country Folk'),
(4031, 157, 19, 'Seventeen-year-old Texas native Sarah Jarosz emerged on the scene about five years ago as someone to watch'),
(4032, 157, 20, ''),
(4033, 157, 21, '2'),
(4034, 157, 22, '1'),
(4035, 157, 23, 'Song_Up_in_Her_Head_-_Sarah_Jarosz'),
(4036, 157, 24, ''),
(4037, 157, 25, '5'),
(4038, 157, 31, '2009'),
(4039, 157, 32, 'Sarah Jarosz '),
(4040, 157, 33, '1'),
(4054, 158, 14, ''),
(4055, 158, 15, '0.20'),
(4056, 158, 17, 'Songs Around The World - Playing for Change'),
(4057, 158, 18, 'Songs Around The World - Playing for Change, music, classical, opera, vinyl LPs, rock, electonic, alternative, hard & heavy'),
(4058, 158, 19, 'Avactis Music store, various music disks'),
(4059, 158, 20, ''),
(4060, 158, 21, '2'),
(4061, 158, 22, '1'),
(4062, 158, 23, 'Songs_Around_The_World_-_Playing_for_Change'),
(4063, 158, 24, ''),
(4064, 158, 25, '5'),
(4065, 158, 31, '2009'),
(4066, 158, 32, 'HEAR MUSIC'),
(4067, 158, 33, '2'),
(4122, 161, 1, '828.00'),
(4123, 161, 2, ''),
(4124, 161, 3, '5'),
(4125, 161, 4, 'FR-2-1'),
(4126, 161, 5, ''),
(4127, 161, 6, '1'),
(4128, 161, 7, '3'),
(4129, 161, 8, '1'),
(4130, 161, 9, 'avactis-images/furn_karlstad.JPG'),
(4131, 161, 10, 'avactis-images/thumb_furn_karlstad.JPG'),
(4132, 161, 11, 'KARLSTAD modular sofa'),
(4133, 161, 12, '<p><b>Key features</b><br /> </p><ul><li>A range of coordinated covers makes it easy for you to give your furniture a new look.</li><li>Easy to keep clean with removable, dry clean only cover.</li><li>Tiltable backrest for flexible seating comfort; choose between sitting position and two different resting positions.</li><li>Can be used alone or combined with other parts of the sofa series.</li></ul>'),
(4134, 161, 13, '<p><b>Key features</b></p><ul><li>A range of coordinated covers makes it easy for you to give your furniture a new look.</li><li>Easy to keep clean with removable, dry clean only cover.</li><li>Tiltable backrest for flexible seating comfort; choose between sitting position and two different resting positions.</li><li>Can be used alone or combined with other parts of the sofa series.</li></ul>'),
(4135, 161, 14, ''),
(4136, 161, 15, ''),
(4137, 161, 17, 'KARLSTAD modular sofa'),
(4138, 161, 18, 'KARLSTAD modular sofa, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(4139, 161, 19, 'KARLSTAD modular sofa, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(4140, 161, 20, ''),
(4141, 161, 21, '2'),
(4142, 161, 22, '1'),
(4143, 161, 23, 'KARLSTAD_modular_sofa'),
(4144, 161, 24, '-1'),
(4145, 161, 25, '5'),
(4314, 169, 1, '9.99'),
(4315, 169, 2, ''),
(4316, 169, 3, '50'),
(4317, 169, 4, 'FR3-5'),
(4318, 169, 5, ''),
(4319, 169, 6, '5'),
(4320, 169, 7, '3'),
(4321, 169, 8, '1'),
(4322, 169, 9, 'avactis-images/furn_ektopneckroll.jpg'),
(4323, 169, 10, 'avactis-images/thumb_furn_ektopneckroll.jpg'),
(4324, 169, 11, 'EKTORP Neckroll'),
(4325, 169, 12, '<b>Key features<br /> <br /> </b> <ul><li>Filling with waterfowl feathers gives soft, pliable support for your neck.</li><li>Easy to keep clean with a removable, machine washable cover.</li></ul> '),
(4326, 169, 13, '<b>Key features<br /><br /></b><ul><li>Filling with waterfowl feathers gives soft, pliable support for your neck.</li><li>Easy to keep clean with a removable, machine washable cover.</li></ul>'),
(4327, 169, 14, ''),
(4328, 169, 15, ''),
(4329, 169, 17, 'EKTORP Neckroll'),
(4330, 169, 18, 'EKTORP Neckroll, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(4331, 169, 19, 'EKTORP Neckroll, furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(4332, 169, 20, ''),
(4333, 169, 21, '2'),
(4334, 169, 22, '1'),
(4335, 169, 23, 'EKTORP_Neckroll'),
(4336, 169, 24, '-1'),
(4337, 169, 25, '5'),
(4514, 150, 16, ''),
(4513, 149, 16, ''),
(4512, 148, 16, ''),
(4511, 147, 16, ''),
(4510, 146, 16, ''),
(4509, 140, 16, ''),
(4508, 139, 16, ''),
(4507, 138, 16, ''),
(4506, 137, 16, ''),
(4505, 136, 16, ''),
(4504, 135, 16, ''),
(4503, 133, 16, ''),
(4502, 130, 16, ''),
(4501, 126, 16, ''),
(4500, 125, 16, ''),
(4495, 116, 16, ''),
(4494, 108, 16, ''),
(4493, 106, 16, ''),
(4492, 105, 16, ''),
(4491, 104, 16, ''),
(4490, 103, 16, ''),
(4488, 101, 16, ''),
(4487, 100, 16, ''),
(4486, 99, 16, ''),
(4484, 97, 16, ''),
(4483, 91, 16, ''),
(4482, 90, 16, ''),
(4481, 89, 16, ''),
(4478, 71, 16, ''),
(4473, 65, 16, ''),
(4472, 63, 16, ''),
(4461, 47, 16, ''),
(4457, 37, 16, ''),
(4456, 36, 16, ''),
(4455, 35, 16, ''),
(4454, 34, 16, ''),
(4453, 33, 16, ''),
(4452, 32, 16, ''),
(4451, 31, 16, ''),
(4450, 28, 16, ''),
(4447, 18, 16, ''),
(4446, 15, 16, ''),
(4445, 11, 16, ''),
(4443, 8, 16, ''),
(4442, 6, 16, ''),
(4441, 5, 16, ''),
(4439, 3, 25, '5'),
(4438, 3, 24, ''),
(4437, 3, 23, ''),
(4436, 3, 22, ''),
(4435, 3, 21, ''),
(4434, 3, 20, ''),
(4433, 3, 19, ''),
(4432, 3, 18, ''),
(4431, 3, 17, ''),
(4430, 3, 16, ''),
(4429, 3, 15, ''),
(4428, 3, 14, ''),
(4517, 155, 16, ''),
(4518, 156, 16, ''),
(4519, 157, 16, ''),
(4520, 158, 16, ''),
(4521, 161, 16, ''),
(4522, 169, 16, ''),
(4524, 3, 26, '-1'),
(4526, 5, 26, '-1'),
(4527, 6, 26, '-1'),
(4528, 8, 26, '-1'),
(4530, 11, 26, '-1'),
(4531, 15, 26, '-1'),
(4532, 18, 26, '-1'),
(4535, 28, 26, '-1'),
(4536, 31, 26, '-1'),
(4537, 32, 26, '-1'),
(4538, 33, 26, '-1'),
(4539, 34, 26, '-1'),
(4540, 35, 26, '-1'),
(4541, 36, 26, '-1'),
(4542, 37, 26, '-1'),
(4546, 47, 26, '-1'),
(4563, 89, 26, '-1'),
(4564, 90, 26, '-1'),
(4565, 91, 26, '-1'),
(4566, 97, 26, '-1'),
(4569, 106, 26, '-1'),
(4570, 108, 26, '-1'),
(4571, 116, 26, '-1'),
(4576, 125, 26, '-1'),
(4577, 126, 26, '-1'),
(4578, 130, 26, '-1'),
(4579, 133, 26, '-1'),
(4580, 138, 26, '-1'),
(4581, 139, 26, '-1'),
(4582, 140, 26, '-1'),
(4585, 161, 26, '-1'),
(4586, 169, 26, '-1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]product_images`
--

CREATE TABLE `[[dbprefix]]product_images` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_attr_id` int(11) NOT NULL DEFAULT '0',
  `image_name` varchar(255) NOT NULL DEFAULT '',
  `image_width` int(11) NOT NULL DEFAULT '0',
  `image_height` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_id`),
  KEY `IDX_pi` (`product_attr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=363 ;

--
-- Dumping data for table `[[dbprefix]]product_images`
--

INSERT INTO `[[dbprefix]]product_images` VALUES
(22, 60, 'thumbnail_3.jpg', 120, 120),
(21, 59, 'large_image_3.jpg', 720, 540),
(9, 116, 'book_danbrown1.jpg', 350, 500),
(10, 117, 'thumb_book_danbrown1.jpg', 70, 100),
(23, 144, 'large_image.jpg', 720, 540),
(24, 145, 'thumbnail.jpg', 120, 120),
(15, 197, 'large_image_1.jpg', 720, 540),
(16, 198, 'thumbnail_1.jpg', 120, 120),
(29, 279, 'large_image_4.jpg', 720, 540),
(26, 280, 'thumbnail_0.jpg', 120, 120),
(35, 385, 'large_image_0.jpg', 720, 540),
(36, 386, 'thumbnail_5.jpg', 120, 120),
(42, 462, 'large_image_9.jpg', 523, 350),
(43, 463, 'thumbnail_7.jpg', 120, 120),
(62, 712, 'Image9_TouchpadStylus.jpg', 320, 240),
(63, 713, 'Image9_TouchpadStylus111.jpg', 120, 120),
(68, 784, 'detailed-1_14.jpg', 720, 540),
(69, 785, 'thumbnail_15.jpg', 120, 120),
(76, 809, 'pdf_1.jpg', 64, 64),
(77, 833, 'download1.jpg', 59, 57),
(78, 857, 'download1_0.jpg', 59, 57),
(79, 880, '1111_0.jpg', 380, 368),
(81, 881, '11111.jpg', 120, 120),
(82, 904, 'avtb.jpg', 380, 368),
(83, 905, 'avts.jpg', 120, 120),
(84, 928, 'hous-2.jpg', 433, 595),
(85, 929, 'hous-1.jpg', 120, 120),
(108, 1208, 't1b.jpg', 450, 450),
(109, 1209, 'thumb_t1b.jpg', 100, 100),
(140, 1638, 'pimage_51_0.gif', 140, 138),
(141, 1639, 'pimage_51_001_0.jpg', 372, 430),
(144, 1690, 'pimage_44_001_0.jpg', 140, 140),
(145, 1691, 'pimage_44_002_0.jpg', 420, 430),
(156, 1846, 'pimage_56_001_0.jpg', 140, 137),
(157, 1847, 'pimage_56_002_0.jpg', 384, 430),
(196, 2299, 'hous-2_2.jpg', 470, 595),
(197, 2300, 'thumb_hous-2_2.jpg', 79, 100),
(198, 2323, 'hous-2_3.jpg', 421, 584),
(199, 2324, 'thumb_hous-2_3.jpg', 72, 100),
(200, 2347, 'hous-1_2.jpg', 434, 595),
(201, 2348, 'thumb_hous-1_2.jpg', 73, 100),
(212, 2491, 'hous-2_7.jpg', 476, 595),
(213, 2492, 'thumb_hous-2_7.jpg', 80, 100),
(216, 2542, 'hous-1_5.jpg', 398, 595),
(217, 2543, 'thumb_hous-1_5.jpg', 67, 100),
(218, 2566, 'hous-2_8.jpg', 408, 595),
(219, 2567, 'thumb_hous-2_8.jpg', 69, 100),
(220, 2590, 'hous-2_9.jpg', 469, 595),
(221, 2591, 'thumb_hous-2_9.jpg', 79, 100),
(224, 2641, 'hous-1_6.jpg', 402, 595),
(225, 2642, 'thumb_hous-1_6.jpg', 68, 100),
(226, 2665, 'hous-2_10.jpg', 367, 595),
(227, 2666, 'thumb_hous-2_10.jpg', 62, 100),
(228, 2689, 'hous-1_7.jpg', 436, 595),
(229, 2690, 'thumb_hous-1_7.jpg', 73, 100),
(230, 2713, 'hous-2_11.jpg', 397, 595),
(231, 2714, 'thumb_hous-2_11.jpg', 67, 100),
(234, 2761, 'hous-1_9.jpg', 469, 695),
(235, 2762, 'thumb_hous-1_9.jpg', 67, 100),
(250, 2953, 'image1_2.jpg', 519, 695),
(251, 2954, 'thumb_image1_2.jpg', 75, 100),
(268, 3194, 'image1_11.jpg', 300, 152),
(269, 3195, 'thumb_image1_11.jpg', 100, 51),
(270, 3218, 'image1_12.jpg', 400, 152),
(271, 3219, 'thumb_image1_12.jpg', 100, 38),
(278, 3314, 'image1_16.jpg', 576, 576),
(279, 3315, 'thumb_image1_16.jpg', 100, 100),
(284, 3386, 'image1_19.jpg', 400, 400),
(285, 3387, 'thumb_image1_19.jpg', 100, 100),
(288, 3434, '44407238.JPG', 600, 597),
(289, 3435, 'thumb_44407238.JPG', 100, 100),
(290, 3461, '126977313.jpg', 600, 600),
(291, 3462, 'thumb_126977313.jpg', 100, 100),
(294, 3489, 'thumb_211403591_0.jpg', 96, 100),
(293, 3488, '211403591_0.jpg', 578, 600),
(295, 3515, '62950_PE170189_S4.jpg', 500, 500),
(296, 3516, 'thumb_62950_PE170189_S4.jpg', 100, 100),
(297, 3539, '239032_PE131239_S4.jpg', 500, 500),
(298, 3540, 'thumb_239032_PE131239_S4.jpg', 100, 100),
(299, 3563, 'mus_tchaikovsky.jpg', 400, 400),
(300, 3564, 'thumb_mus_tchaikovsky.jpg', 100, 100),
(311, 3725, 'mus_mckennitt1.jpg', 500, 452),
(312, 3726, 'thumb_mus_mckennitt1.jpg', 100, 90),
(313, 3752, 'mus_mckennitt2.jpg', 500, 500),
(314, 3753, 'thumb_mus_mckennitt2.jpg', 100, 100),
(315, 3779, 'mus_cmills.jpg', 500, 500),
(316, 3780, 'thumb_mus_cmills.jpg', 100, 100),
(317, 3806, 'mus_chuckwagongang.jpg', 500, 500),
(318, 3807, 'thumb_mus_chuckwagongang.jpg', 100, 100),
(319, 3833, 'mus_folk1.jpg', 474, 468),
(320, 3834, 'thumb_mus_folk1.jpg', 100, 99),
(361, 3968, 'disk1.jpg', 452, 452),
(362, 3969, 'thumb_disk1.jpg', 100, 100),
(331, 3995, 'mus_welcometomali.jpg', 1689, 1535),
(332, 3996, 'thumb_mus_welcometomali.jpg', 100, 91),
(333, 4022, 'mus_jarosz.jpg', 602, 600),
(334, 4023, 'thumb_mus_jarosz.jpg', 100, 100),
(335, 4049, 'mus_worldsongs.jpg', 400, 400),
(336, 4050, 'thumb_mus_worldsongs.jpg', 100, 100),
(341, 4130, 'furn_karlstad.JPG', 500, 500),
(342, 4131, 'thumb_furn_karlstad.JPG', 100, 100),
(359, 4322, 'furn_ektopneckroll.jpg', 500, 500),
(360, 4323, 'thumb_furn_ektopneckroll.jpg', 100, 100);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]product_tax_classes`
--

CREATE TABLE `[[dbprefix]]product_tax_classes` (
  `product_tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_tax_class_name` varchar(255) DEFAULT NULL,
  `product_tax_class_descr` longtext,
  `product_tax_class_type` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`product_tax_class_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]product_tax_classes`
--

INSERT INTO `[[dbprefix]]product_tax_classes` VALUES
(1, 'Nontaxable', 'Nontaxable Products', 'standard'),
(2, 'Taxable', 'Taxable Products', 'custom');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]product_types`
--

CREATE TABLE `[[dbprefix]]product_types` (
  `product_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_type_name` varchar(255) DEFAULT NULL,
  `product_type_descr` longtext,
  PRIMARY KEY (`product_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]product_types`
--

INSERT INTO `[[dbprefix]]product_types` VALUES
(1, 'General Products', 'This type is common for the majority of products'),
(2, 'Books', 'Fiction, Science, Education, Entertainment'),
(3, 'Computers', 'All-in-One, Desktop computers, Notebooks and Netbooks'),
(4, 'Downloadable products', 'Electronic products distribution'),
(5, 'Apparel, T-Shirts', 'Apparel, T-Shirts and custom T-Shirts'),
(6, 'DVD', 'DVDs, Movies, Videos, Films, Box Sets'),
(7, 'Flowers', 'This product type is for flowers.'),
(8, 'Music', 'Music CD'),
(9, 'Spots & Travel', 'Spots & Travel products'),
(10, 'Furniture', 'Furniture, sofas, tables, chairs, decorations'),
(-1, '1', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]product_type_attributes`
--

CREATE TABLE `[[dbprefix]]product_type_attributes` (
  `product_type_attr_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_type_id` int(11) NOT NULL DEFAULT '0',
  `attribute_id` int(11) DEFAULT NULL,
  `product_type_attr_visibility` char(5) DEFAULT NULL,
  `product_type_attr_required` char(5) DEFAULT NULL,
  `product_type_attr_default_value` longtext,
  PRIMARY KEY (`product_type_attr_id`),
  UNIQUE KEY `IDX_ptid_aid` (`product_type_id`,`attribute_id`),
  KEY `IDX_pti` (`product_type_id`),
  KEY `IDX_ai` (`attribute_id`),
  KEY `IDX_aid_vis` (`attribute_id`,`product_type_attr_visibility`),
  KEY `IDX_ptid_aid_vis` (`product_type_id`,`attribute_id`,`product_type_attr_visibility`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=386 ;

--
-- Dumping data for table `[[dbprefix]]product_type_attributes`
--

INSERT INTO `[[dbprefix]]product_type_attributes` VALUES
(1, 1, 1, '1', '1', ''),
(2, 1, 2, '1', '', ''),
(3, 1, 3, '1', '', ''),
(4, 1, 6, '1', '', ''),
(5, 1, 5, '1', '', ''),
(6, 1, 4, '1', '', ''),
(7, 1, 7, '1', '', '3'),
(8, 1, 8, '1', '', '2'),
(9, 1, 24, '1', '', ''),
(10, 1, 9, '1', '', ''),
(11, 1, 10, '1', '', ''),
(12, 1, 11, '1', '', ''),
(13, 1, 12, '1', '', ''),
(14, 1, 13, '1', '', ''),
(15, 1, 14, '1', '', ''),
(16, 1, 20, '1', '', ''),
(17, 1, 15, '1', '', ''),
(18, 1, 21, '1', '', '2'),
(19, 1, 22, '1', '', '1'),
(20, 1, 17, '1', '', ''),
(21, 1, 18, '1', '', ''),
(22, 1, 19, '1', '', ''),
(23, 1, 23, '1', '', ''),
(24, 1, 25, '1', '', ''),
(25, 1, 26, '1', '', ''),
(26, 1, 27, '1', '', ''),
(27, 1, 28, '1', '', ''),
(28, 1, 29, '1', '', ''),
(29, 1, 30, '1', '', ''),
(30, 1, 31, '1', '', ''),
(31, 1, 60, '1', '', ''),
(32, 1, 61, '1', '', ''),
(33, 1, 62, '1', '', ''),
(34, 1, 63, '1', '', ''),
(35, 1, 64, '1', '', ''),
(36, 2, 1, '1', '1', '100.00'),
(37, 2, 2, '1', '', ''),
(38, 2, 3, '1', '', '10'),
(39, 2, 6, '1', '', ''),
(40, 2, 5, '', '', ''),
(41, 2, 4, '1', '', 'BK'),
(42, 2, 7, '1', '', '3'),
(43, 2, 8, '1', '', '2'),
(44, 2, 24, '1', '', '-1'),
(45, 2, 9, '1', '', ''),
(46, 2, 10, '1', '', ''),
(47, 2, 11, '1', '', ''),
(48, 2, 12, '1', '', ''),
(49, 2, 13, '1', '', ''),
(50, 2, 14, '1', '', '0.00'),
(51, 2, 20, '1', '', '0.00'),
(52, 2, 15, '1', '', '2.00'),
(53, 2, 21, '1', '', '2'),
(54, 2, 22, '1', '', '1'),
(55, 2, 17, '1', '', ''),
(56, 2, 18, '1', '', 'Books, Fiction Books, Education Books, Fiction / Science / Education / Entertainment'),
(57, 2, 19, '1', '', 'Avactis Book Store'),
(58, 2, 23, '1', '', ''),
(59, 2, 25, '1', '', '5'),
(60, 2, 35, '1', '', '2009'),
(61, 2, 37, '1', '', ''),
(62, 3, 1, '1', '1', ''),
(63, 3, 2, '1', '', ''),
(64, 3, 3, '1', '', '59'),
(65, 3, 4, '1', '', 'Comp'),
(66, 3, 5, '1', '', ''),
(67, 3, 6, '1', '', '19'),
(68, 3, 7, '1', '', '3'),
(69, 3, 8, '1', '', '2'),
(70, 3, 9, '1', '', ''),
(71, 3, 10, '1', '', ''),
(72, 3, 11, '1', '', ''),
(73, 3, 12, '1', '', ''),
(74, 3, 13, '1', '', ''),
(75, 3, 14, '1', '', ''),
(76, 3, 15, '1', '', ''),
(77, 3, 17, '1', '', ''),
(78, 3, 18, '1', '', 'laptop, laptops, computer, computers, notebook, notebooks, desktops, desktop, electronics, sales, deals'),
(79, 3, 19, '1', '', 'All-in-One, Desktop computers, Notebooks and Netbooks'),
(80, 3, 20, '1', '', ''),
(81, 3, 21, '1', '', '1'),
(82, 3, 22, '1', '', '1'),
(83, 3, 23, '1', '', ''),
(84, 3, 24, '1', '', '-1'),
(85, 3, 25, '1', '', '5'),
(86, 2, 33, '1', '', 'English'),
(87, 2, 34, '1', '', '200'),
(88, 4, 1, '1', '1', '0.00'),
(89, 4, 2, '1', '', ''),
(90, 4, 3, '1', '', ''),
(91, 4, 4, '1', '', 'Downloadable'),
(92, 4, 5, '1', '', ''),
(93, 4, 6, '1', '', ''),
(94, 4, 7, '1', '', '3'),
(95, 4, 8, '1', '', '2'),
(96, 4, 9, '1', '', ''),
(97, 4, 10, '1', '', ''),
(98, 4, 11, '1', '', ''),
(99, 4, 12, '1', '', ''),
(100, 4, 13, '1', '', ''),
(101, 4, 14, '1', '', ''),
(102, 4, 15, '1', '', ''),
(103, 4, 17, '1', '', 'Downloadable products'),
(104, 4, 18, '1', '', 'downloadable products shopping cart, digital distribution, digital delivery, electronic software distribution, electronic products distribution'),
(105, 4, 19, '1', '', ''),
(106, 4, 20, '1', '', ''),
(107, 4, 21, '1', '', '1'),
(108, 4, 22, '1', '', '1'),
(109, 4, 23, '1', '', 'Downloadable products'),
(110, 4, 24, '1', '', '-1'),
(111, 4, 25, '1', '', '5'),
(112, 5, 1, '1', '1', '15.99'),
(113, 5, 2, '1', '', ''),
(114, 5, 3, '1', '', ''),
(115, 5, 4, '1', '', 'T-Shirt'),
(116, 5, 5, '1', '', ''),
(117, 5, 6, '1', '', ''),
(118, 5, 7, '1', '', '3'),
(119, 5, 8, '1', '', '2'),
(120, 5, 9, '1', '', ''),
(121, 5, 10, '1', '', ''),
(122, 5, 11, '1', '', ''),
(123, 5, 12, '1', '', ''),
(124, 5, 13, '1', '', ''),
(125, 5, 14, '1', '', ''),
(126, 5, 15, '1', '', ''),
(127, 5, 17, '1', '', 'T-Shirt'),
(128, 5, 18, '1', '', 'Apparel, custom T-Shirt, T-Shirts, TShirts, Tee Shirts, T-Shirt, TShirt, shirts'),
(129, 5, 19, '1', '', 'Apparel, T-Shirts and custom T-Shirts'),
(130, 5, 20, '1', '', ''),
(131, 5, 21, '1', '', '1'),
(132, 5, 22, '1', '', '1'),
(133, 5, 23, '1', '', 'T-Shirt'),
(134, 5, 24, '1', '', '-1'),
(135, 5, 25, '1', '', '5'),
(136, 6, 1, '1', '1', '23.99'),
(137, 6, 2, '1', '', ''),
(138, 6, 3, '1', '', '119'),
(139, 6, 4, '1', '', 'DVD'),
(140, 6, 5, '1', '', ''),
(141, 6, 6, '1', '', '35'),
(142, 6, 7, '1', '', '3'),
(143, 6, 8, '1', '', '2'),
(144, 6, 9, '1', '', ''),
(145, 6, 10, '1', '', ''),
(146, 6, 11, '1', '', ''),
(147, 6, 12, '1', '', ''),
(148, 6, 13, '1', '', ''),
(149, 6, 14, '1', '', ''),
(150, 6, 15, '1', '', ''),
(151, 6, 17, '1', '', 'DVD'),
(152, 6, 18, '1', '', 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(153, 6, 19, '1', '', 'DVD, DVDs, Movies, Videos, Films, Box Sets, Boxed Sets, Bargain DVD, DVD deals'),
(154, 6, 20, '1', '', ''),
(155, 6, 21, '1', '', '1'),
(156, 6, 22, '1', '', '1'),
(157, 6, 23, '1', '', 'DVD'),
(158, 6, 24, '1', '', '-1'),
(159, 6, 25, '1', '', '5'),
(160, 7, 1, '1', '1', '0.00'),
(161, 7, 2, '1', '', '0.00'),
(162, 7, 3, '1', '', '10'),
(163, 7, 6, '1', '', '5'),
(164, 7, 5, '', '', ''),
(165, 7, 4, '1', '', 'FLO-00000001'),
(166, 7, 7, '1', '', '3'),
(167, 7, 8, '1', '', '2'),
(168, 7, 24, '1', '', '-1'),
(169, 7, 9, '1', '', ''),
(170, 7, 10, '1', '', ''),
(171, 7, 11, '1', '', ''),
(172, 7, 12, '1', '', ''),
(173, 7, 13, '1', '', ''),
(174, 7, 14, '1', '', '0.00'),
(175, 7, 20, '1', '', '0.00'),
(176, 7, 15, '1', '', '1.00'),
(177, 7, 21, '1', '', '2'),
(178, 7, 22, '1', '', '1'),
(179, 7, 17, '1', '', ''),
(180, 7, 18, '1', '', 'Flowers, Flores, Flower Arrangements, Florists, Online Florist, Florals, Flower Delivery, Gift Baskets, Bouquets '),
(181, 7, 19, '1', '', ''),
(182, 7, 23, '1', '', ''),
(183, 7, 25, '1', '', '5'),
(184, 8, 1, '1', '1', '5.00'),
(185, 8, 2, '1', '', ''),
(186, 8, 3, '1', '', '5'),
(187, 8, 6, '1', '', ''),
(188, 8, 5, '', '', ''),
(189, 8, 4, '1', '', 'MUSIC-'),
(190, 8, 7, '1', '', '3'),
(191, 8, 8, '1', '', '2'),
(192, 8, 24, '', '', '-1'),
(193, 8, 9, '1', '', ''),
(194, 8, 10, '1', '', ''),
(195, 8, 11, '1', '', ''),
(196, 8, 12, '1', '', ''),
(197, 8, 13, '1', '', ''),
(198, 8, 14, '1', '', ''),
(199, 8, 20, '1', '', ''),
(200, 8, 15, '1', '', '0.20'),
(201, 8, 21, '1', '', '2'),
(202, 8, 22, '1', '', '1'),
(203, 8, 17, '1', '', ''),
(204, 8, 18, '1', '', 'music, classical, opera, rock, electonic, alternative, hard & heavy'),
(205, 8, 19, '1', '', 'Avactis Music store, various music disks'),
(206, 8, 23, '1', '', ''),
(207, 8, 25, '1', '', '5'),
(208, 8, 36, '1', '', ''),
(209, 8, 37, '1', '', ''),
(210, 8, 38, '1', '', '1'),
(211, 9, 1, '1', '1', '34.00'),
(212, 9, 2, '1', '', ''),
(213, 9, 3, '1', '', ''),
(214, 9, 6, '1', '', ''),
(215, 9, 5, '1', '', ''),
(216, 9, 4, '1', '', ''),
(217, 9, 7, '1', '', '3'),
(218, 9, 8, '1', '', '2'),
(219, 9, 24, '1', '', '-1'),
(220, 9, 9, '1', '', ''),
(221, 9, 10, '1', '', ''),
(222, 9, 11, '1', '', ''),
(223, 9, 12, '1', '', ''),
(224, 9, 13, '1', '', ''),
(225, 9, 14, '1', '', ''),
(226, 9, 20, '1', '', ''),
(227, 9, 15, '1', '', ''),
(228, 9, 21, '1', '', '1'),
(229, 9, 22, '1', '', '1'),
(230, 9, 17, '1', '', ''),
(231, 9, 18, '1', '', 'sport, travel, outdoor clothing, camping, tents, equipment, fishing, accessories, waterproof, hiking, clothes, outdoors, rucksacks'),
(232, 9, 19, '1', '', ''),
(233, 9, 23, '1', '', ''),
(234, 9, 25, '1', '', '5'),
(235, 10, 1, '1', '1', ''),
(236, 10, 2, '1', '', ''),
(237, 10, 3, '1', '', '25'),
(238, 10, 4, '1', '', 'FR1'),
(239, 10, 5, '1', '', ''),
(240, 10, 6, '1', '', ''),
(241, 10, 7, '1', '', '3'),
(242, 10, 8, '1', '', '2'),
(243, 10, 9, '1', '', ''),
(244, 10, 10, '1', '', ''),
(245, 10, 11, '1', '', ''),
(246, 10, 12, '1', '', ''),
(247, 10, 13, '1', '', ''),
(248, 10, 14, '1', '', ''),
(249, 10, 15, '1', '', ''),
(250, 10, 17, '1', '', ''),
(251, 10, 18, '1', '', 'furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(252, 10, 19, '1', '', 'furniture, sofas, beds, mattresses, tables, chairs, decorations'),
(253, 10, 20, '1', '', ''),
(254, 10, 21, '1', '', '1'),
(255, 10, 22, '1', '', '1'),
(256, 10, 23, '1', '', ''),
(257, 10, 24, '1', '', '-1'),
(258, 10, 25, '1', '', '5'),
(259, 2, 26, '1', '', ''),
(260, 3, 26, '1', '', ''),
(261, 4, 26, '1', '', ''),
(262, 5, 26, '1', '', ''),
(263, 6, 26, '1', '', ''),
(264, 7, 26, '1', '', ''),
(265, 8, 26, '1', '', ''),
(266, 9, 26, '1', '', ''),
(267, 10, 26, '1', '', ''),
(268, 2, 27, '1', '', ''),
(269, 3, 27, '1', '', ''),
(270, 4, 27, '1', '', ''),
(271, 5, 27, '1', '', ''),
(272, 6, 27, '1', '', ''),
(273, 7, 27, '1', '', ''),
(274, 8, 27, '1', '', ''),
(275, 9, 27, '1', '', ''),
(276, 10, 27, '1', '', ''),
(277, 2, 28, '1', '', ''),
(278, 3, 28, '1', '', ''),
(279, 4, 28, '1', '', ''),
(280, 5, 28, '1', '', ''),
(281, 6, 28, '1', '', ''),
(282, 7, 28, '1', '', ''),
(283, 8, 28, '1', '', ''),
(284, 9, 28, '1', '', ''),
(285, 10, 28, '1', '', ''),
(286, 2, 29, '1', '', ''),
(287, 3, 29, '1', '', ''),
(288, 4, 29, '1', '', ''),
(289, 5, 29, '1', '', ''),
(290, 6, 29, '1', '', ''),
(291, 7, 29, '1', '', ''),
(292, 8, 29, '1', '', ''),
(293, 9, 29, '1', '', ''),
(294, 10, 29, '1', '', ''),
(295, 2, 30, '1', '', ''),
(296, 3, 30, '1', '', ''),
(297, 4, 30, '1', '', ''),
(298, 5, 30, '1', '', ''),
(299, 6, 30, '1', '', ''),
(300, 7, 30, '1', '', ''),
(301, 8, 30, '1', '', ''),
(302, 9, 30, '1', '', ''),
(303, 10, 30, '1', '', ''),
(304, 2, 31, '1', '', ''),
(305, 3, 31, '1', '', ''),
(306, 4, 31, '1', '', ''),
(307, 5, 31, '1', '', ''),
(308, 6, 31, '1', '', ''),
(309, 7, 31, '1', '', ''),
(310, 8, 31, '1', '', ''),
(311, 9, 31, '1', '', ''),
(312, 10, 31, '1', '', ''),
(313, 1, 75, '1', '', ''),
(314, 1, 76, '1', '', ''),
(315, 1, 77, '1', '', ''),
(316, 2, 75, '1', '', ''),
(317, 2, 76, '1', '', ''),
(318, 2, 77, '1', '', ''),
(319, 3, 75, '1', '', ''),
(320, 3, 76, '1', '', ''),
(321, 3, 77, '1', '', ''),
(322, 4, 75, '1', '', ''),
(323, 4, 76, '1', '', ''),
(324, 4, 77, '1', '', ''),
(325, 5, 75, '1', '', ''),
(326, 5, 76, '1', '', ''),
(327, 5, 77, '1', '', ''),
(328, 6, 75, '1', '', ''),
(329, 6, 76, '1', '', ''),
(330, 6, 77, '1', '', ''),
(331, 7, 75, '1', '', ''),
(332, 7, 76, '1', '', ''),
(333, 7, 77, '1', '', ''),
(334, 8, 75, '1', '', ''),
(335, 8, 76, '1', '', ''),
(336, 8, 77, '1', '', ''),
(337, 9, 75, '1', '', ''),
(338, 9, 76, '1', '', ''),
(339, 9, 77, '1', '', ''),
(340, 10, 75, '1', '', ''),
(341, 10, 76, '1', '', ''),
(342, 10, 77, '1', '', ''),
(343, -1, 1, '1', '1', '0.00'),
(344, -1, 2, '1', '', ''),
(345, -1, 3, '', '', ''),
(346, -1, 4, '', '', ''),
(347, -1, 5, '', '', ''),
(348, -1, 6, '', '', ''),
(349, -1, 7, '1', '', '3'),
(350, -1, 8, '1', '', '1'),
(351, -1, 9, '1', '', ''),
(352, -1, 10, '1', '', ''),
(353, -1, 11, '1', '', ''),
(354, -1, 12, '1', '', ''),
(355, -1, 13, '1', '', ''),
(356, -1, 14, '1', '', ''),
(357, -1, 15, '1', '', ''),
(358, -1, 17, '1', '', ''),
(359, -1, 18, '1', '', ''),
(360, -1, 19, '1', '', ''),
(361, -1, 20, '1', '', ''),
(362, -1, 21, '1', '', '2'),
(363, -1, 22, '1', '', '1'),
(364, -1, 23, '1', '', ''),
(365, -1, 24, '1', '', '-1'),
(366, -1, 25, '1', '', '5'),
(367, -1, 26, '1', '', ''),
(368, -1, 27, '1', '', ''),
(369, -1, 28, '1', '', ''),
(370, -1, 29, '1', '', ''),
(371, -1, 30, '1', '', ''),
(372, -1, 31, '1', '', ''),
(373, -1, 78, '1', '', ''),
(374, -1, 79, '1', '', ''),
(375, -1, 80, '1', '', ''),
(376, -1, 81, '1', '', ''),
(377, -1, 82, '1', '', ''),
(378, -1, 83, '1', '', ''),
(379, -1, 84, '1', '', ''),
(380, -1, 85, '1', '', ''),
(381, -1, 86, '1', '', ''),
(382, -1, 87, '1', '', ''),
(383, -1, 88, '1', '', ''),
(384, -1, 89, '1', '', ''),
(385, -1, 90, '1', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]promo_codes_coupons_table`
--

CREATE TABLE `[[dbprefix]]promo_codes_coupons_table` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_min_subtotal` float DEFAULT NULL,
  `coupon_promo_code` varchar(255) DEFAULT NULL,
  `coupon_campaign_name` varchar(255) DEFAULT NULL,
  `coupon_b_ignore_other_discounts` int(11) NOT NULL DEFAULT '1',
  `coupon_status` int(11) NOT NULL DEFAULT '1',
  `coupon_discount_cost` float DEFAULT NULL,
  `coupon_discount_cost_type_id` int(11) NOT NULL DEFAULT '1',
  `coupon_start_date` date DEFAULT NULL,
  `coupon_end_date` date DEFAULT NULL,
  `coupon_times_to_use` int(11) NOT NULL DEFAULT '0',
  `coupon_times_used` int(11) NOT NULL DEFAULT '0',
  `coupon_products_affected` longtext,
  `coupon_categories_affected` longtext,
  `free_shipping` int(11) NOT NULL DEFAULT '0',
  `free_handling` int(11) NOT NULL DEFAULT '0',
  `strict_cart` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupon_id`),
  UNIQUE KEY `IDX_promo_code_key` (`coupon_promo_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]promo_codes_settings`
--

CREATE TABLE `[[dbprefix]]promo_codes_settings` (
  `promo_codes_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `promo_codes_setting_key` varchar(50) DEFAULT NULL,
  `promo_codes_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`promo_codes_setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qb_settings`
--

CREATE TABLE `[[dbprefix]]qb_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL DEFAULT '',
  `setting_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]qb_settings`
--

INSERT INTO `[[dbprefix]]qb_settings` VALUES
(1, 'TRNS_CLASS', ''),
(2, 'ACC_TAX', ''),
(3, 'ACC_PRODUCT', ''),
(4, 'ACC_SHIPPING', ''),
(5, 'ACC_INVENTORY', ''),
(6, 'ACC_GLOBAL_DISCOUNT', ''),
(7, 'ACC_PROMOCODE_DISCOUNT', ''),
(8, 'ACC_QUANTITY_DISCOUNT', ''),
(9, 'OP_AS_INV', 'Y'),
(10, 'MIN_QIS', '0'),
(11, 'ACC_COGS', ''),
(12, 'QB_ORDERS_PREFIX', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quantity_discounts_rates_table`
--

CREATE TABLE `[[dbprefix]]quantity_discounts_rates_table` (
  `discounts_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `discounts_rate_product_id` int(11) NOT NULL DEFAULT '0',
  `discounts_rate_value_from` float DEFAULT NULL,
  `discounts_rate_cost_type_id` int(11) NOT NULL DEFAULT '1',
  `discounts_rate_cost` float DEFAULT NULL,
  `discounts_rate_b_active` int(11) NOT NULL DEFAULT '1',
  `discounts_rate_customer_group_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`discounts_rate_id`),
  KEY `IDX_rv_from` (`discounts_rate_value_from`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quantity_discounts_settings`
--

CREATE TABLE `[[dbprefix]]quantity_discounts_settings` (
  `discounts_setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `discounts_setting_key` varchar(50) DEFAULT NULL,
  `discounts_setting_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`discounts_setting_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_carts_stat`
--

CREATE TABLE `[[dbprefix]]reports_carts_stat` (
  `datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `carts_created_qty` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_crawlers_info`
--

CREATE TABLE `[[dbprefix]]reports_crawlers_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_string` text NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(5) NOT NULL DEFAULT 'R',
  PRIMARY KEY (`id`),
  KEY `IDX_agent` (`agent_string`(200))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1454 ;

--
-- Dumping data for table `[[dbprefix]]reports_crawlers_info`
--

INSERT INTO `[[dbprefix]]reports_crawlers_info` VALUES
(1, '&lt;a href=''http://www.unchaos.com/''> UnChaos &lt;/a> From Chaos To Order Hybrid Web Search Engine.(vadim_gonchar@unchaos.com)', 'UnCHAOS search robot', 'R'),
(2, '&lt;a href=''http://www.unchaos.com/''> UnChaos Bot Hybrid Web Search Engine. &lt;/a> (vadim_gonchar@unchaos.com)', 'UnCHAOS search robot', 'R'),
(3, '&lt;b> UnChaosBot From Chaos To Order UnChaos Hybrid Web Search Engine at www.unchaos.com &lt;/b> (info@unchaos.com)', 'UnCHAOS search robot', 'R'),
(4, '&lt;http://www.sygol.com/> http://www.sygol.com', 'Sygol Search (Italy) robot', 'R'),
(5, '*/Nutch-0.9-dev', 'Unknown Yahoo robot', 'R'),
(6, '+SitiDi.net/SitiDiBot/1.0 (+Have Good Day)', 'SitiDi.net search (Germany) robot', 'R'),
(7, '-DIE-KRAEHE- META-SEARCH-ENGINE/1.1 http://www.die-kraehe.de', 'Die Kraehe Meta-Search-Engine (Germany) link checking', 'R'),
(8, '192.comAgent', '192.com - UK web directory', 'R'),
(9, '4anything.com LinkChecker v2.0', '4Anything robot', 'R'),
(10, '8484 Boston Project v 1.0', 'Unknown guestbook spamming or harvesting tool from diff. IPs', 'S'),
(11, ':robot/1.0 (linux) ( admin e-mail: undefined http://www.neofonie.de/loesungen/search/robot.html )', 'neofonie search robot Germany', 'R'),
(12, 'A-Online Search', 'A-Online.at robot - now Jet2Web Search', 'R'),
(13, 'A1 Sitemap Generator/1.0 (+http://www.micro-sys.dk/products/sitemap-generator/) miggibot/2006.01.24', 'MiggiBot website crawler engine - A1 Sitemap Generator', 'R'),
(14, 'aardvark-crawler', 'Aardvark web crawler for Sun''s Blog recommendations', 'R'),
(15, 'AbachoBOT', 'Abacho / Crawler.de robot', 'R'),
(16, 'AbachoBOT (Mozilla compatible)', 'Abacho / Crawler.de robot', 'R'),
(17, 'ABCdatos BotLink/5.xx.xxx#BBL', 'ABCdatos - Castilian program &amp; tutorial directory', 'R'),
(18, 'Aberja Checkomat', 'Aberja Hybridsuchmaschine (Germany) link checking', 'R'),
(19, 'abot/0.1 (abot; http://www.abot.com; abot@abot.com)', 'Nameprotect copyright search robot (24.177.134.x)', 'R'),
(20, 'About/0.1libwww-perl/5.47', 'About robot', 'R'),
(21, 'Accelatech RSSCrawler/0.4', 'Accela Technology RSS feed crawler', 'R'),
(22, 'accoona', 'Accoona Search robot', 'R'),
(23, 'Accoona-AI-Agent/1.1.1 (crawler at accoona dot com)', 'Accoona Search robot', 'R'),
(24, 'Accoona-AI-Agent/1.1.2 (aicrawler at accoonabot dot com)', 'Accoona Search robot', 'R'),
(25, 'Ack (http://www.ackerm.com/)', 'Ackerm search robot', 'R'),
(26, 'AcoiRobot', 'Acoi picture finder robot', 'R'),
(27, 'Acoon Robot v1.50.001', 'Acoon.de search (Germany) robot', 'R'),
(28, 'Acoon Robot v1.52 (http://www.acoon.de)', 'Acoon.de search (Germany) robot', 'R'),
(29, 'Acoon-Robot 4.0.x.[xx] (http://www.acoon.de)', 'Acoon.de search (Germany) robot', 'R'),
(30, 'Acoon-Robot v3.xx (http://www.acoon.de and http://www.acoon.com)', 'Acoon.de search (Germany) robot', 'R'),
(31, 'Acorn/Nutch-0.9 (Non-Profit Search Engine; acorn.isara.org; acorn at isara dot org)', 'Acorn Search Project', 'R'),
(32, 'AESOP_com_SpiderMan', 'Aesop robot', 'R'),
(33, 'agadine/1.x.x (+http://www.agada.de)', 'Agada search (Germany) robot', 'R'),
(34, 'Agent-SharewarePlazaFileCheckBot/2.0+(+http://www.SharewarePlaza.com)', 'SharewarePlaza link checking', 'R'),
(35, 'AgentName/0.1 libwww-perl/5.48', 'Linkomatic submission verifier', 'R'),
(36, 'AIBOT/2.1 By +(www.21seek.com A Real artificial intelligence search engine China)', '21seek.com (China) robot (218.17.90.xxx)', 'R'),
(37, 'aipbot/1.0 (aipbot; http://www.aipbot.com; aipbot@aipbot.com)', 'Nameprotect copyright search robot (24.177.134.x)', 'R'),
(38, 'aipbot/2-beta (aipbot dev; http://aipbot.com; aipbot@aipbot.com)', 'Nameprotect copyright search robot (24.177.134.x)', 'R'),
(39, 'Aladin/3.324', 'Aladin robot', 'R'),
(40, 'Aleksika Spider/1.0 (+http://www.aleksika.com/)', 'Aleksika Danmark - Search engine optimization spider', 'R'),
(41, 'AlkalineBOT/1.3', 'Vestris robot', 'R'),
(42, 'AlkalineBOT/1.4 (1.4.0326.0 RTM)', 'Vestris robot', 'R'),
(43, 'Allesklar/0.1 libwww-perl/5.46', 'Allesklar.de robot', 'R'),
(44, 'Allrati/1.1 (+)', 'Unknown robot from Allrati.com', 'R'),
(45, 'AltaVista Intranet V2.0 AVS EVAL search@freeit.com', 'Altavista robot', 'R'),
(46, 'AltaVista Intranet V2.0 Compaq Altavista Eval sveand@altavista.net', 'Altavista robot', 'R'),
(47, 'AltaVista Intranet V2.0 evreka.com crawler@evreka.com', 'Altavista robot', 'R'),
(48, 'AltaVista V2.0B crawler@evreka.com', 'Altavista robot', 'R'),
(49, 'AmfibiBOT', 'Amfibi Search robot', 'R'),
(50, 'Amfibibot/0.06 (Amfibi Web Search; http://www.amfibi.com; agent@amfibi.com)', 'Amfibi Search robot', 'R'),
(51, 'Amfibibot/0.07 (Amfibi Robot; http://www.amfibi.com; agent@amfibi.com)', 'Amfibi Search robot', 'R'),
(52, 'amibot', 'amibot - Amidalla search engine robot (62.241.33.xx)', 'R'),
(53, 'AnnoMille spider 0.1 alpha - http://www.annomille.it', 'Annomille Italian historical oriented robot', 'R'),
(54, 'AnswerBus (http://www.answerbus.com/)', 'AnswerBus natural language search using COLLATE technology', 'R'),
(55, 'antibot-V1.1.5/i586-linux-2.2', 'Antibot (discontinued) robot', 'R'),
(56, 'AnzwersCrawl/2.0 (anzwerscrawl@anzwers.com.au;Engine)', 'Anzwers (Yahoo) Australia robot', 'R'),
(57, 'Apexoo Spider 1.x', 'Apexoo Search spider', 'R'),
(58, 'Aport', 'Aport robot', 'R'),
(59, 'appie 1.1 (www.walhello.com)', 'Walhello Internet Search robot', 'R'),
(60, 'ArabyBot (compatible; Mozilla/5.0; GoogleBot; FAST Crawler 6.4; http://www.araby.com;)', 'Araby search - Arabia', 'R'),
(61, 'ArachBot', 'Covac Arachnid Web Crawler', 'R'),
(62, 'Arachnoidea (arachnoidea@euroseek.com)', 'Euroseek spider', 'R'),
(63, 'ArchitextSpider', 'Excite spider', 'R'),
(64, 'archive.org_bot', 'Heritrix - The Internet Archive''s open-source crawler (207.241.225.2xx)', 'R'),
(65, 'Arikus_Spider', 'Arikus inContext search engine software', 'R'),
(66, 'Arquivo-web-crawler  (compatible; heritrix/1.12.1 +http://arquivo-web.fccn.pt)', 'Tomba project: the Portuguese web archive', 'R'),
(67, 'ASAHA Search Engine Turkey V.001 (http://www.asaha.com/)', 'Asaha search robot (Turkey)', 'R'),
(68, 'Asahina-Antenna/1.x', 'ASAHINA Antenna information detecting agent', 'R'),
(69, 'Asahina-Antenna/1.x (libhina.pl/x.x ; libtime.pl/x.x)', 'ASAHINA Antenna information detecting agent', 'R'),
(70, 'ask.24x.info', 'Ask 24x Info robot', 'R'),
(71, 'AskAboutOil/0.06-rcp (Nutch; http://www.nutch.org/docs/en/bot.html; nutch-agent@askaboutoil.com)', 'Ask About Oil - Petroleum related search (24.227.212.xxx) using Nutch', 'R'),
(72, 'asked/Nutch-0.8 (web crawler; http://asked.jp; epicurus at gmail dot com)', 'askEd! / Inferret search (Japan) robot using Nutch', 'R'),
(73, 'ASPSeek/1.2.5', 'ASPSeek search engine software -Yahoo-Inc. / Telecom Canada robot ', 'R'),
(74, 'ASPseek/1.2.9d', 'Swsoft.net robot using Aspseek', 'R'),
(75, 'ASPSeek/1.2.x', 'ASPSeek search engine software', 'R'),
(76, 'ASPSeek/1.2.xa', 'ASPSeek search engine software', 'R'),
(77, 'ASPseek/1.2.xx', 'ASPSeek search engine software', 'R'),
(78, 'ASPSeek/1.2.xxpre', 'ASPSeek search engine software', 'R'),
(79, 'ASSORT/0.10', 'Associative Sort robot', 'R'),
(80, 'asterias/2.0', 'Singingfish media spider (64.12.186.2xx) via AOL search', 'R'),
(81, 'AtlocalBot/1.1 +(http://www.atlocal.com/local-web-site-owner.html)', 'Atlocal local business search robot', 'R'),
(82, 'Atomic_Email_Hunter/4.0', 'Atomic Email Hunter email extracing and harvesting', 'S'),
(83, 'Atomz/1.0', 'Atomz robot', 'R'),
(84, 'atSpider/1.0', 'atSpider (ceased) email harvester / spambot', 'S'),
(85, 'Attentio/Nutch-0.9-dev (Attentio''s beta blog crawler; www.attentio.com; info@attentio.com)', 'Attentio social media monitoring and analysing ', 'R'),
(86, 'augurfind', 'Augurnet Swiss (was www.augurnet.ch) search robot', 'R'),
(87, 'augurnfind V-1.x', 'Augurnet Swiss (was www.augurnet.ch) search robot', 'R'),
(88, 'autoemailspider', 'Auto Email Pro Email harvester', 'S'),
(89, 'autowebdir 1.1 (www.autowebdir.com)', 'Autowebdir - The Automatically Generated Web Directory', 'R'),
(90, 'AV Fetch 1.0', 'Altavista robot ??', 'R'),
(91, 'AVSearch-1.0(peter.turney@nrc.ca)', 'National Research Council Canada robot', 'R'),
(92, 'AVSearch-3.0(AltaVista/AVC)', 'Altavista robot', 'R'),
(93, 'axadine/ (Axadine Crawler; http://www.axada.de/; )', 'Axada search Germany robot', 'R'),
(94, 'AxmoRobot - Crawling your site for better indexing on www.axmo.com search engine.', 'Axmo search robot', 'R'),
(95, 'BabalooSpider/1.3 (BabalooSpider; http://www.babaloo.si; spider@babaloo.si)', 'Babaloo search robot (Slovenia)', 'R'),
(96, 'BaboomBot/1.x.x (+http://www.baboom.us)', 'BaBoom Web Portal (ODP) robot (66.98.254.xx)', 'R'),
(97, 'BaiduImagespider+(+http://www.baidu.jp/search/s308.html)', 'Baidu search (Japan) image crawler', 'R'),
(98, 'BaiDuSpider', 'Baidu spidering engine - used by diff. IPs', 'R'),
(99, 'Baiduspider+(+http://help.baidu.jp/system/05.html)', 'Baidu spidering engine - used by diff. IPs', 'R'),
(100, 'Baiduspider+(+http://www.baidu.com/search/spider.htm)', 'Baidu spidering engine - used by diff. IPs', 'R'),
(101, 'Baiduspider+(+http://www.baidu.com/search/spider_jp.html)', 'Baidu search (Japan) crawler', 'R'),
(102, 'Balihoo/Nutch-1.0-dev (Crawler for Balihoo.com search engine - obeys robots.txt and robots meta tags ; http://balihoo.com/index.aspx; robot at balihoo dot com)', 'Balihoo - Vertical search engine crawler (beta)', 'R'),
(103, 'BarraHomeCrawler (albertof@barrahome.org)', 'Barrahome crawler', 'R'),
(104, 'bdcindexer_2.6.2 (research@bdc)', 'Business.com robot', 'R'),
(105, 'BDFetch', 'Brandimensions Brand Protection robot', 'R'),
(106, 'BDNcentral Crawler v2.3 [en] (http://www.bdncentral.com/robot.html) (X11; I; Linux 2.0.44 i686)', 'Bdncentral Sitesearch robot', 'R'),
(107, 'beautybot/1.0 (+http://www.uchoose.de/crawler/beautybot/)', 'Beauty robot for Cosmoty - German beauty and wellness search', 'R'),
(108, 'BebopBot/2.5.1 ( crawler http://www.apassion4jazz.net/bebopbot.html )', 'A Passion for Jazz music related search robot', 'R'),
(109, 'BigCliqueBOT/1.03-dev (bigclicbot; http://www.bigclique.com; bot@bigclique.com)', 'BigClique Search robot', 'R'),
(110, 'BIGLOTRON (Beta 2;GNU/Linux)', 'Biglotron search (France) robot', 'R'),
(111, 'Bigsearch.ca/Nutch-x.x-dev (Bigsearch.ca Internet Spider; http://www.bigsearch.ca/; info@enhancededge.com)', 'Bigsearch.ca search robot', 'R'),
(112, 'BilgiBetaBot/0.8-dev (bilgi.com (Beta) ; http://lucene.apache.org/nutch/bot.html; nutch-agent@lucene.apache.org)', 'Bilgi.com (Beta) search robot - Turkey', 'R'),
(113, 'BilgiBot/1.0(beta) (http://www.bilgi.com/; bilgi at bilgi dot com)', 'Bilgi.com (Beta) search robot - Turkey', 'R'),
(114, 'Bitacle bot/1.1', 'Bitacle Blog Search Archive robot', 'R'),
(115, 'Bitacle Robot (V:1.0;) (http://www.bitacle.com)', 'Bitacle Blog Search Archive robot', 'R'),
(116, 'BlackWidow', 'FS Consulting (was www.fsconsult.net) Black Widow web crawler', 'R'),
(117, 'Blaiz-Bee/1.0 (+http://www.blaiz.net)', 'Blaiz Enterprises RawGrunt search', 'R'),
(118, 'Blaiz-Bee/2.00.8222 (BE Internet Search Engine http://www.rawgrunt.com)', 'Blaiz Enterprises RawGrunt search', 'R'),
(119, 'Blaiz-Bee/2.00.xxxx (+http://www.blaiz.net)', 'Blaiz Enterprises RawGrunt search', 'R'),
(120, 'BlitzBOT@tricus.net', 'Blitzsuche Germany robot', 'R'),
(121, 'BlitzBOT@tricus.net (Mozilla compatible)', 'Blitzsuche Germany robot', 'R'),
(122, 'BlogBot/1.x', 'blogdex robot from MIT.edu', 'R'),
(123, 'Bloglines Title Fetch/1.0 (http://www.bloglines.com)', 'Bloglines article search', 'R'),
(124, 'Bloglines-Images/0.1 (http://www.bloglines.com)', 'Bloglines graphics crawler', 'R'),
(125, 'Bloglines/3.1 (http://www.bloglines.com)', 'Bloglines news crawler', 'R'),
(126, 'Blogpulse (info@blogpulse.com)', 'Intelliseek''s BlogPulse blog search', 'R'),
(127, 'BlogPulseLive (support@blogpulse.com)', 'Intelliseek''s BlogPulse blog search', 'R'),
(128, 'BlogSearch/1.x +http://www.icerocket.com/', 'IceRocket Web search robot', 'R'),
(129, 'blogsearchbot-pumpkin-3', 'Art of Computing blog search project', 'R'),
(130, 'BlogsNowBot&#44; V 2.01 (+http://www.blogsnow.com/)', 'BlogsNow realtime link tracker robot', 'R'),
(131, 'BlogVibeBot-v1.1 (spider@blogvibe.nl)', 'BlogVipe news and Blog crawler (Netherlands)', 'R'),
(132, 'blogWatcher_Spider/0.1 (http://www.lr.pi.titech.ac.jp/blogWatcher/)', 'blogWatcher robot from Okumura Group Tokyo (131.112.182.xxx)', 'R'),
(133, 'BlogzIce/1.0 (+http://icerocket.com; rhodes@icerocket.com)', 'IceRocket Web search robot', 'R'),
(134, 'BlogzIce/1.0 +http://www.icerocket.com/', 'IceRocket Web search robot', 'R'),
(135, 'BloobyBot', 'Blooby search (beta) robot', 'R'),
(136, 'Bloodhound/Nutch-0.9 (Testing Crawler for Research - obeys robots.txt and robots meta tags ; http://balihoo.com/index.aspx; robot at balihoo dot com)', 'Balihoo - Search Engine for Advertising Media', 'R'),
(137, 'boitho.com-dc/0.xx (http://www.boitho.com/dcbot.html)', 'Boitho search (Norway) robot via 80.202.212.xx / 80.80.111.xx', 'R'),
(138, 'boitho.com-robot/1.x', 'Boitho search (Norway) robot via 80.202.212.xx / 80.80.111.xx', 'R'),
(139, 'boitho.com-robot/1.x (http://www.boitho.com/bot.html)', 'Boitho search (Norway) robot via 80.202.212.xx / 80.80.111.xx', 'R'),
(140, 'BPImageWalker/2.0 (www.bdbrandprotect.com)', 'BD-Brandprotect copyright infringement crawler', 'R'),
(141, 'BravoBrian SpiderEngine MarcoPolo', 'Robot for BravoBrian bSTOP', 'R'),
(142, 'BruinBot (+http://webarchive.cs.ucla.edu/bruinbot.html) ', 'Webarchive Project Bruinbot crawler', 'R'),
(143, 'BSDSeek/1.0', 'Inktomi (Hotbot-Lycos NBCi) robot', 'R'),
(144, 'BTbot/0.x (+http://www.btbot.com/btbot.html)', 'BitTorrent Search Engine btbot robot', 'R'),
(145, 'BuildCMS crawler (http://www.buildcms.com/crawler)', 'BuildCMS crawler - market monitoring project of BuildCMS', 'R'),
(146, 'BullsEye', 'BullsEye/Intelliseek robot', 'R'),
(147, 'bumblebee@relevare.com', 'Relevare Portal software robot', 'R'),
(148, 'BurstFindCrawler/1.1 (crawler.burstfind.com; http://crawler.burstfind.com; crawler@burstfind.com)', 'BurstFind search crawler (64.34.172.xx)', 'R'),
(149, 'Buscaplus Robi/1.0 (http://www.buscaplus.com/robi/)', 'Buscaplus (Spain) robot', 'R'),
(150, 'bwh3_user_agent', 'Basic Web Hacking 3 fake user-agent from Hellbound Hackers challenges', 'S'),
(151, 'Cabot/Nutch-0.9 (Amfibi''s web-crawling robot; http://www.amfibi.com/cabot/; agent@amfibi.com)', 'Amfibi Search robot', 'R'),
(152, 'Cabot/Nutch-1.0-dev (Amfibi''s web-crawling robot; http://www.amfibi.com/cabot/; agent@amfibi.com)', 'Amfibi Search robot', 'R'),
(153, 'carleson/1.0', 'Cosmix project crawler (204.14.48.x / 38.113.234.xxx)', 'R'),
(154, 'Carnegie_Mellon_University_Research_WebBOT-->PLEASE READ-->http://www.andrew.cmu.edu/~brgordon/webbot/index.html http://www.andrew.cmu.edu/~brgordon/webbot/index.html', 'Carnegie Mellon University WebBOT', 'R'),
(155, 'Carnegie_Mellon_University_WebCrawler http://www.andrew.cmu.edu/~brgordon/webbot/index.html', 'Carnegie Mellon University WebBOT', 'R'),
(156, 'Catall Spider', 'Catall.de search &amp; web directory (Germany)', 'R'),
(157, 'CazoodleBot/CazoodleBot-0.1 (CazoodleBot Crawler; http://www.cazoodle.com/cazoodlebot; cazoodlebot@cazoodle.com)', 'UIUCs Cazoodle search based on MetaQuerier', 'R'),
(158, 'CCBot/1.0 (+http://www.commoncrawl.org/bot.html)', 'CommonCrawl Foundation search crawler', 'R'),
(159, 'ccubee/x.x', 'Empyreum Ccubee (Czech) search engine solution', 'R'),
(160, 'Ceramic Tile Installation Guide (http://www.floorstransformed.com)', 'Floortransformed.com robot (link ckecking ??)', 'R'),
(161, 'cfetch/1.0', 'Cosmix project crawler (204.14.48.x / 38.113.234.xxx)', 'R'),
(162, 'China Local Browse 2.6', 'Unknown spam bot from telekom.com.my (218.111.83.xxx)', 'S'),
(163, 'ChristCRAWLER 2.0', 'Christcentral.com Christcrawler (was www.christcrawler.com)', 'R'),
(164, 'CipinetBot (http://www.cipinet.com/bot.html)', 'CipinetBot -Cipinet Search Engine Web Crawler', 'R'),
(165, 'ClariaBot/1.0', 'Claria (ex Gator) SearchScout robot (64.152.73.xx)', 'R'),
(166, 'Claymont.com', 'Claymont Search robot', 'R'),
(167, 'CloakDetect/0.9 (+http://fulltext.seznam.cz/)', 'Seznam Search (Czech Republic) robot', 'R'),
(168, 'Clushbot/2.x (+http://www.clush.com/bot.html)', 'Clush clustered search robot', 'R'),
(169, 'Clushbot/3.x-BinaryFury (+http://www.clush.com/bot.html)', 'Clush clustered search robot', 'R'),
(170, 'Clushbot/3.xx-Ajax (+http://www.clush.com/bot.html)', 'Clush clustered search robot', 'R'),
(171, 'Clushbot/3.xx-Hector (+http://www.clush.com/bot.html)', 'Clush clustered search robot', 'R'),
(172, 'Clushbot/3.xx-Peleus (+http://www.clush.com/bot.html)', 'Clush clustered search robot', 'R'),
(173, 'Cogentbot/1.X (+http://www.cogentsoftwaresolutions.com/bot.html)', 'Cogent Search Bot from Cogent Software Solutions for unknown purposes', 'R'),
(174, 'combine/0.0', 'Combine harvesting &amp; indexing robot', 'R'),
(175, 'Combine/2.0 http://combine.it.lth.se/', 'Combine harvesting &amp; indexing robot', 'R'),
(176, 'Combine/3 http://combine.it.lth.se/', 'Combine harvesting &amp; indexing robot', 'R'),
(177, 'Combine/x.0', 'Combine harvesting &amp; indexing robot', 'R'),
(178, 'cometrics-bot&#44; http://www.cometrics.de', 'cometrics Web Content Mining solution - Germany', 'R'),
(179, 'Computer_and_Automation_Research_Institute_Crawler crawler@ilab.sztaki.hu', 'Hungarian Academy of Sciences data mining search', 'R'),
(180, 'Comrite/0.7.1 (Nutch; http://lucene.apache.org/nutch/bot.html; nutch-agent@lucene.apache.org)', 'ComRite Chinese Search Engine for Oversea Web Sites (69.248.26.xx)', 'R'),
(181, 'ContactBot/0.2', 'Probably E-Mail harvesting robot - same as LMQueueBot', 'S'),
(182, 'ContentSmartz', 'ContentSmartz e-mail harvesting tools', 'S'),
(183, 'Convera Internet Spider V6.x', 'Converas RetrievalWare Internet Spider (63.241.61.x)', 'R'),
(184, 'ConveraCrawler/0.2', 'Converas RetrievalWare Internet Spider (63.241.61.x)', 'R'),
(185, 'ConveraCrawler/0.9d (+http://www.authoritativeweb.com/crawl)', 'Converas RetrievalWare Internet Spider (63.241.61.x)', 'R'),
(186, 'ConveraMultiMediaCrawler/0.1 (+http://www.authoritativeweb.com/crawl)', 'Converas RetrievalWare Internet Spider (63.241.61.x)', 'R'),
(187, 'CoolBot', 'Suchmaschine21 (Germany) robot', 'R'),
(188, 'cosmos/0.8_(robot@xyleme.com)', 'Xyleme SA France robot', 'R'),
(189, 'cosmos/0.9_(robot@xyleme.com)', 'Xyleme SA France robot', 'R'),
(190, 'CougarSearch/0.x (+http://www.cougarsearch.com/faq.shtml)', 'Cougarsearch.com robot', 'R'),
(191, 'Covac TexAs Arachbot', 'Covac Arachnid Web Crawler', 'R'),
(192, 'Cowbot-0.1 (NHN Corp. / +82-2-3011-1954 / nhnbot@naver.com)', 'Naver Japan / Korea robot', 'R'),
(193, 'Cowbot-0.1.x (NHN Corp. / +82-2-3011-1954 / nhnbot@naver.com)', 'Naver Japan / Korea robot', 'R'),
(194, 'CrawlConvera0.1 (CrawlConvera@yahoo.com)', 'Converas RetrievalWare Internet Spider', 'R'),
(195, 'Crawler (cometsearch@cometsystems.com)', 'Cometsystems Comet Search robot via Findwhat (now Miva)', 'R'),
(196, 'Crawler admin@crawler.de', 'Crawler.de / Abacho robot', 'R'),
(197, 'Crawler V 0.2.x admin@crawler.de', 'Crawler.de / Abacho robot', 'R'),
(198, 'crawler@alexa.com', 'Alexa crawler', 'R'),
(199, 'CrawlerBoy Pinpoint.com', 'Pinpoint WAP search robot', 'R'),
(200, 'Crawllybot/0.1 (Crawllybot; +http://www.crawlly.com; crawler@crawlly.com)', 'Crawlly Beta search - Germany (72.232.194.2xx)', 'R'),
(201, 'CreativeCommons/0.06-dev (Nutch; http://www.nutch.org/docs/en/bot.html; nutch-agent@lists.sourceforge.net)', 'Creatice Commons using Nutch open source robot', 'R'),
(202, 'CrocCrawler vx.3 [en] (http://www.croccrawler.com) (X11; I; Linux 2.0.44 i686)', 'Croccrawler robot', 'R'),
(203, 'csci_b659/0.13', 'Web mining project from CSCI 659 (computer science course) at Indiana Univerity', 'R'),
(204, 'Cuasarbot/0.9b http://www.cuasar.com/spider_beta/ ', 'Cuasar (Spain) music / ringtone search spider', 'R'),
(205, 'CurryGuide SiteScan 1.1', 'CurryGuide UK link check robot', 'R'),
(206, 'Custom Spider www.bisnisseek.com /1.0', 'Bisnisseek (was www.bisnisseek.com) robot', 'R'),
(207, 'CyberPatrol SiteCat Webbot (http://www.cyberpatrol.com/cyberpatrolcrawler.asp)', 'CyberPatrol LLC robot for web filtering software', 'R'),
(208, 'CydralSpider/1.x (Cydral Web Image Search; http://www.cydral.com)', 'Cydral image &amp; site search spider', 'R'),
(209, 'CydralSpider/3.0 (Cydral Image Search; http://www.cydral.com)', 'Cydral image &amp; site search spider', 'R'),
(210, 'DataCha0s/2.0', 'Unknown bot from Kornet Korea (218.149.129.xxx) scans for Perl Awstats', 'S'),
(211, 'DataCha0s/2.0', 'Unknown UA looking for Awstats Perl components', 'S'),
(212, 'DataFountains/DMOZ Downloader', 'INFOMINE/iVia Scholary Internet Resource Collections robot', 'R'),
(213, 'DataFountains/Dmoz Downloader (http://ivia.ucr.edu/useragents.shtml)', 'INFOMINE/iVia Scholary Internet Resource Collections robot', 'R'),
(214, 'DataFountains/DMOZ Feature Vector Corpus Creator (http://ivia.ucr.edu/useragents.shtml)', 'INFOMINE/iVia Scholary Internet Resource Collections robot', 'R'),
(215, 'DataparkSearch/4.47 (+http://dataparksearch.org/bot)', 'DataparkSearch open source search engine', 'R'),
(216, 'DataparkSearch/4.xx (http://www.dataparksearch.org/)', 'DataparkSearch open source search engine', 'R'),
(217, 'DataSpear/1.0 (Spider; http://www.dataspear.com/spider.html; spider@dataspear.com)', 'DataSpear Directory robot (24.109.29.xx)', 'R'),
(218, 'DataSpearSpiderBot/0.2 (DataSpear Spider Bot; http://dssb.dataspear.com/bot.html; dssb@dataspear.com)', 'DataSpear Directory robot (24.109.29.xx)', 'R'),
(219, 'DatenBot( http://www.sicher-durchs-netz.de/bot.html)', 'Sicher-durchs-Netz German security related search (62.75.220.xxx)', 'R'),
(220, 'DaviesBot/1.7 (www.wholeweb.net)', 'Wholeweb robot', 'R'),
(221, 'daypopbot/0.x', 'Daypop blog - weblog - online mag search spider', 'R'),
(222, 'dbDig(http://www.prairielandconsulting.com)', 'dbDig search engine', 'R'),
(223, 'DBrowse 1.4b', 'Some site scanning tool via diff. IPs i.e.: - wanweb.net (208.6.163.xxx) - cox.net (68.4.xxx.xxx)', 'S'),
(224, 'DBrowse 1.4d', 'Some site scanning tool via diff. IPs i.e.: - pacbell.net (67.112.xxx.xxx)', 'S'),
(225, 'dCSbot/1.1', 'unknown divine/Openmarket.com robot', 'R'),
(226, 'de.searchengine.comBot 1.2 (http://de.searchengine.com/spider)', 'Searchengine.com (Germany) submission checking / robot (84.73.57.xx)', 'R'),
(227, 'deepak-USC/ISI', 'deepak-USC/ISI robot from USC/Information Science Institute', 'R'),
(228, 'DeepIndex', 'Deepindex robot', 'R'),
(229, 'DeepIndex ( http://www.zetbot.com )', 'Zetbot search Belgium (213.41.128.xx) using Deepindex robot', 'R'),
(230, 'DeepIndex (www.en.deepindex.com)', 'Deepindex robot', 'R'),
(231, 'DeepIndexer.ca', 'Deepindex robot (via Paragon.net Canada)', 'R'),
(232, 'Demo Bot DOT 16b', 'Some site scanning tool from 217.34.59.xxx (btopenworld.com)', 'S'),
(233, 'Demo Bot Z 16b', 'Some site scanning tool from 68.154.96.xx (bellsouth.net)', 'S'),
(234, 'Denmex websearch (http://search.denmex.com)', 'Denmex Websearch robot/link checking', 'R'),
(235, 'dev-spider2.searchpsider.com/1.3b', 'Searchspider.com robot (72.245.225.xxx)', 'R'),
(236, 'DiaGem/1.1 (http://www.skyrocket.gr.jp/diagem.html)', 'DiaGem Japan web crawler', 'R'),
(237, 'Diamond/x.0', 'Claria (ex Gator) SearchScout robot (64.152.73.xx)', 'R'),
(238, 'DiamondBot', 'Claria (ex Gator) SearchScout robot (64.152.73.xx)', 'R'),
(239, 'Digger/1.0 JDK/1.3.0rc3', 'Diggit! robot', 'R'),
(240, 'DigOut4U', 'OpenPortal4U robot', 'R'),
(241, 'DIIbot/1.2', 'Findsame.com (site is offline) / Digital-Integrity robot', 'R'),
(242, 'disco/Nutch-0.9 (experimental crawler; www.discoveryengine.com; disco-crawl@discoveryengine.com)', 'Unkown robot from Discovery Engine Corp.', 'R'),
(243, 'disco/Nutch-1.0-dev (experimental crawler; www.discoveryengine.com; disco-crawl@discoveryengine.com)', 'Unkown robot from Discovery Engine Corp.', 'R'),
(244, 'DittoSpyder', 'Ditto picture search robot', 'R'),
(245, 'dloader(NaverRobot)/1.0', 'Naver Japan / Korea robot', 'R'),
(246, 'DoCoMo/1.0/Nxxxi/c10', 'NTT DoCoMo (Japan) robot', 'R'),
(247, 'DoCoMo/1.0/Nxxxi/c10/TB', 'NTT DoCoMo (Japan) robot', 'R'),
(248, 'DoCoMo/2.0 P900iV(c100;TB;W24H11) ', 'NTT DoCoMo (Japan) robot', 'R'),
(249, 'DoCoMo/2.0 SH902i (compatible; Y!J-SRD/1.0; http://help.yahoo.co.jp/help/jp/search/indexing/indexing-27.html)', 'Yahoo Search Japan robot (203.216.197.xxx)', 'R'),
(250, 'DoCoMo/2.0/SO502i (compatible; Y!J-SRD/1.0; http://help.yahoo.co.jp/help/jp/search/indexing/indexing-27.html)', 'Yahoo Search Japan robot (203.216.197.xxx)', 'R'),
(251, 'dodgebot/experimental', 'unknown robot from AGMLAB Information Technologies (Information retrieval system ?)', 'R'),
(252, 'Download-Tipp Linkcheck (http://download-tipp.de/)', 'Download-Tipp Germany link checking', 'R'),
(253, 'Drecombot/1.0 (http://career.drecom.jp/bot.html)', 'Drecom Japan (210.233.67.xxx) - Blog search ??', 'R'),
(254, 'DSurf15a 01', 'Some site scanning tool via diff. IPs i.e.: - cox.net (68.5.xxx.xxx) - pacbell.net (64.16x.xxx.xxx)', 'S'),
(255, 'DSurf15a 71', 'Some site scanning tool via diff. IPs i.e.: - cox.net (68.4.xxx.xxx)', 'S'),
(256, 'DSurf15a 81', 'Some site scanning tool via diff. IPs i.e.: - verizon.net (4.47.xxx.xxx)', 'S'),
(257, 'DSurf15a VA', 'Some site scanning tool via diff. IPs i.e.: - eastlink.ca (24.222.xxx.xxx) - cogeco.net (216.221.8x.xxx)', 'S'),
(258, 'dtSearchSpider', 'dt Search Spider software', 'R'),
(259, 'DuckDuckBot/1.0; (+http://duckduckgo.com/duckduckbot.html)', 'Duck Duck Go search crawler', 'R'),
(260, 'Dumbot(version 0.1 beta - dumbfind.com)', 'DumbFind.com robot', 'R'),
(261, 'Dumbot(version 0.1 beta - http://www.dumbfind.com/dumbot.html)', 'DumbFind.com robot', 'R'),
(262, 'Dumbot(version 0.1 beta)', 'DumbFind.com robot', 'R'),
(263, 'e-sense 1.0 ea(www.vigiltech.com/esensedisclaim.html)', 'Vigiltech e-Sense user research robot (website is offline)', 'R'),
(264, 'e-SocietyRobot(http://www.yama.info.waseda.ac.jp/~yamana/es/)', 'e-Society Project (Japan) crawler (133.9.238.xx)', 'R'),
(265, 'eApolloBot/2.0 (compatible; heritrix/2.0.0-SNAPSHOT-20071024.170148 +http://www.eapollo-opto.com)', 'Global Opto''s eApollo Flash based search engine - Taiwan', 'R'),
(266, 'EARTHCOM.info/1.x [www.earthcom.info]', 'Earthcom (Czech Republic) search robot (194.108.39.xx)', 'R'),
(267, 'EARTHCOM.info/1.xbeta [www.earthcom.info]', 'Earthcom (Czech Republic) search robot (194.108.39.xx)', 'R'),
(268, 'EasyDL/3.xx', 'Keywen Encyclopedia Bot', 'R'),
(269, 'EasyDL/3.xx http://keywen.com/Encyclopedia/Bot', 'Keywen Encyclopedia Bot', 'R'),
(270, 'EBrowse 1.4b', 'Some site scanning tool via diff. IPs i.e.: - swbell.net (65.66.xxx.xxx)', 'S'),
(271, 'EchO!/2.0', 'Echo.fr robot', 'R'),
(272, 'Educate Search VxB', 'Some site scanning tool via diff. IPs i.e.: - cox.net (68.4.xxx.xxx)', 'S'),
(273, 'egothor/3.0a (+http://www.xdefine.org/robot.html)', 'Xdefine text search engine robot - based on Egothor open source crawler', 'R'),
(274, 'EgotoBot/4.8 (+http://www.egoto.com/about.htm)', 'Egoto Search robot', 'R'),
(275, 'ejupiter.com', 'eJupiter searcg robot (206.191.49.xx)', 'R'),
(276, 'elfbot/1.0 (+http://www.uchoose.de/crawler/elfbot/)', 'Elftales crawler for uChoose theme based search (Germany)', 'R'),
(277, 'ELI/20070402:2.0 (DAUM RSS Robot&#44; Daum Communications Corp.; +http://ws.daum.net/aboutkr.html)', 'DAUMOA - RSS search robot of Daum', 'R'),
(278, 'EmailSiphon', 'Sonic E-mail collector', 'S'),
(279, 'EmailSpider', 'EmailSpider E-mail harvesting  software', 'S'),
(280, 'EmailWolf 1.00', 'Trellian EMailWolf E-mail collector', 'S'),
(281, 'EMPAS_ROBOT', 'Empas search Korea robot (220.95.22x.xxx)', 'R'),
(282, 'EnaBot/1.x (http://www.enaball.com/crawler.html)', 'Enabot - Enaball semantic search project crawler', 'R'),
(283, 'Enfish Tracker', 'Enfish Personal search tool', 'R'),
(284, 'Enterprise_Search/1.0', 'Enterprise Search engine software (64.202.165.xxx)', 'R'),
(285, 'Enterprise_Search/1.0.xxx', 'Enterprise Search engine software (64.202.165.xxx)', 'R'),
(286, 'Enterprise_Search/1.00.xxx;MSSQL (http://www.innerprise.net/es-spider.asp)', 'Enterprise Search engine software (64.202.165.xxx)', 'R'),
(287, 'envolk/1.7 (+http://www.envolk.com/envolkspiderinfo.php)', 'Envolk Web Search robot', 'R'),
(288, 'envolk[ITS]spider/1.6(+http://www.envolk.com/envolkspider.html)', 'Envolk Web Search robot', 'R'),
(289, 'EroCrawler', 'EroCrawler adult search robot', 'R'),
(290, 'ES.NET_Crawler/2.0 (http://search.innerprise.net/)', 'Enterprise Search engine software (64.202.165.xxx)', 'R'),
(291, 'eseek-larbin_2.6.2 (crawler@exactseek.com)', 'ExactSEEK (Jayde Online) robot', 'R'),
(292, 'ESISmartSpider', 'ESI Smart-Spider toolkit', 'R'),
(293, 'eStyleSearch 4 (compatible; MSIE 6.0; Windows NT 5.0)', 'e-Style ISP search (Russia) robot (217.174.103.xxx)', 'R'),
(294, 'ESurf15a 15', 'Some site scanning tool via diff. IPs', 'S'),
(295, 'EuripBot/0.x (+http://www.eurip.com) GetFile', 'Eurip.com - European Internet Portal robot', 'R'),
(296, 'EuripBot/0.x (+http://www.eurip.com) GetRobots', 'Eurip.com - European Internet Portal robot', 'R'),
(297, 'EuripBot/0.x (+http://www.eurip.com) PreCheck', 'Eurip.com - European Internet Portal robot', 'R'),
(298, 'Eurobot/1.0 (http://www.ayell.eu)', 'Ayell Euronet business directory robot', 'R'),
(299, 'EvaalSE - bot@evaal.com', 'Evaal Search Engine robot', 'R'),
(300, 'eventax/1.3 (eventax; http://www.eventax.de/; info@eventax.de)', 'Eventax event search (Germany)', 'R'),
(301, 'Everest-Vulcan Inc./0.1 (R&amp;D project; host=e-1-24; http://everest.vulcan.com/crawlerhelp)', 'Vulcan Inc. Everest crawler (in development)', 'R'),
(302, 'Everest-Vulcan Inc./0.1 (R&amp;D project; http://everest.vulcan.com/crawlerhelp)', 'Vulcan Inc. Everest crawler (in development)', 'R'),
(303, 'Exabot-Images/1.0', 'Exalead Websearch image crawler (193.47.80.xx)', 'R'),
(304, 'Exabot-Test/1.0', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(305, 'Exabot/2.0', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(306, 'Exabot/3.0', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(307, 'ExactSeek Crawler/0.1', 'ExactSEEK (Jayde Online) robot', 'R'),
(308, 'exactseek-crawler-2.63 (crawler@exactseek.com)', 'ExactSEEK (Jayde Online) robot', 'R'),
(309, 'exactseek-pagereaper-2.63 (crawler@exactseek.com)', 'ExactSEEK (Jayde Online) robot', 'R'),
(310, 'exactseek.com', 'ExactSEEK (Jayde Online) robot (69.9.181.1xx)', 'R'),
(311, 'Exalead NG/MimeLive Client (convert/http/0.120)', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(312, 'Excalibur Internet Spider V6.5.4', 'Excalibur (now Convera) spider software', 'R'),
(313, 'Execrawl/1.0 (Execrawl; http://www.execrawl.com/; bot@execrawl.com)', 'Execrawl software search using nutch', 'R'),
(314, 'exooba crawler/exooba crawler (crawler for exooba.com; http://www.exooba.com/; info at exooba dot com)', 'exooba crawler for exooba search pre-alpha development', 'R'),
(315, 'exooba/exooba crawler (exooba; exooba)', 'exooba crawler for exooba search pre-alpha development', 'R'),
(316, 'ExperimentalHenrytheMiragoRobot', 'Mirago UK Robot', 'R'),
(317, 'ExtractorPro', 'Extractor Pro e-mail collector', 'S'),
(318, 'EyeCatcher (Download-tipp.de)/1.0', 'Download-Tipp Germany robot', 'R'),
(319, 'Factbot 1.09 (see http://www.factbites.com/webmasters.php)', 'Factbites search robot', 'R'),
(320, 'factbot : http://www.factbites.com/robots', 'Factbites search robot', 'R'),
(321, 'Fast Crawler Gold Edition', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(322, 'FAST Enterprise Crawler 6 (Experimental)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(323, 'FAST Enterprise Crawler 6 / Scirus scirus-crawler@fast.no; http://www.scirus.com/srsapp/contactus/', 'Fast Enterprise Crawler (66.151.181.xx) for Scirus scienctific information search', 'R'),
(324, 'FAST Enterprise Crawler 6 used by Cobra Development (admin@fastsearch.com)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(325, 'FAST Enterprise Crawler 6 used by Comperio AS (sts@comperio.no)', 'Comperio Web Miner based on Fast ESP', 'R'),
(326, 'FAST Enterprise Crawler 6 used by FAST (FAST)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(327, 'FAST Enterprise Crawler 6 used by Pages Jaunes (pvincent@pagesjaunes.fr)', 'Pages Jaunes business search (France) robot using Fast Enterprise Crawler', 'R'),
(328, 'FAST Enterprise Crawler 6 used by Sensis.com.au Web Crawler (search_comments\\at\\sensis\\dot\\com\\dot\\au)', 'Fast/Alltheweb crawler for Sensis.com.au Australian search (66.151.181.xx)', 'R'),
(329, 'FAST Enterprise Crawler 6 used by Singapore Press Holdings (crawler@sphsearch.sg)', 'SPH Search - Singapore related search using Fast crawler', 'R'),
(330, 'FAST Enterprise Crawler/6 (www.fastsearch.com)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(331, 'FAST Enterprise Crawler/6.4 (helpdesk at fast.no)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(332, 'FAST FirstPage retriever (compatible; MSIE 5.5; Mozilla/4.0)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(333, 'FAST MetaWeb Crawler (helpdesk at fastsearch dot com)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(334, 'Fast PartnerSite Crawler', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(335, 'FAST-WebCrawler/2.2.10 (Multimedia Search) (crawler@fast.no; http://www.fast.no/faq/faqfastwebsearch/faqfastwebcrawler.html)', 'Fast/Alltheweb multimedia crawler', 'R'),
(336, 'FAST-WebCrawler/2.2.6 (crawler@fast.no; http://www.fast.no/faq/faqfastwebsearch/faqfastwebcrawler.html)', 'Fast/Alltheweb crawler', 'R'),
(337, 'FAST-WebCrawler/2.2.7 (crawler@fast.no; http://www.fast.no/faq/faqfastwebsearch/faqfastwebcrawler.html)http://www.fast.no', 'Fast/Alltheweb crawler', 'R'),
(338, 'FAST-WebCrawler/2.2.8 (crawler@fast.no; http://www.fast.no/faq/faqfastwebsearch/faqfastwebcrawler.html)http://www.fast.no', 'Fast/Alltheweb crawler', 'R'),
(339, 'FAST-WebCrawler/3.2 test', 'Fast/Alltheweb crawler', 'R'),
(340, 'FAST-WebCrawler/3.3 (crawler@fast.no; http://fast.no/support.php?c=faqs/crawler)', 'Fast/Alltheweb crawler', 'R'),
(341, 'FAST-WebCrawler/3.4/Nirvana (crawler@fast.no; http://fast.no/support.php?c=faqs/crawler)', 'Fast/Alltheweb crawler', 'R'),
(342, 'FAST-WebCrawler/3.4/PartnerSite (crawler@fast.no; http://fast.no/support.php?c=faqs/crawler)', 'Fast/Alltheweb crawler', 'R'),
(343, 'FAST-WebCrawler/3.5 (atw-crawler at fast dot no; http://fast.no/support.php?c=faqs/crawler)', 'Fast/Alltheweb crawler', 'R'),
(344, 'FAST-WebCrawler/3.6 (atw-crawler at fast dot no; http://fast.no/support/crawler.asp)', 'Fast/Alltheweb crawler', 'R'),
(345, 'FAST-WebCrawler/3.6/FirstPage (crawler@fast.no; http://fast.no/support.php?c=faqs/crawler)', 'Fast/Alltheweb crawler', 'R'),
(346, 'FAST-WebCrawler/3.7 (atw-crawler at fast dot no; http://fast.no/support/crawler.asp)', 'Fast/Alltheweb crawler', 'R'),
(347, 'FAST-WebCrawler/3.7/FirstPage (atw-crawler at fast dot no;http://fast.no/support/crawler.asp)', 'Fast/Alltheweb crawler', 'R'),
(348, 'FAST-WebCrawler/3.8 (atw-crawler at fast dot no; http://fast.no/support/crawler.asp)', 'Fast/Alltheweb crawler', 'R'),
(349, 'FAST-WebCrawler/3.8/Fresh (atw-crawler at fast dot no; http://fast.no/support/crawler.asp)', 'Fast/Alltheweb crawler', 'R'),
(350, 'FAST-WebCrawler/3.x Multimedia', 'Fast/Alltheweb multimedia crawler', 'R'),
(351, 'FAST-WebCrawler/3.x Multimedia (mm dash crawler at fast dot no)', 'Fast/Alltheweb multimedia crawler', 'R'),
(352, 'fastbot crawler beta 2.0 (+http://www.fastbot.de)', 'Fastbot search Germany crawler (80.252.104.1xx)', 'R'),
(353, 'FastBug http://www.ay-up.com', 'Ay-Up geo sync search robot', 'R'),
(354, 'FastCrawler 3.0.1 (crawler@1klik.dk)', 'Fast/Alltheweb crawler (66.151.181.xx)', 'R'),
(355, 'FastSearch Web Crawler for Verizon SuperPages (kevin.watters@fastsearch.com)', 'Fast/Alltheweb crawler used by SuperPages.com', 'R'),
(356, 'Favcollector/2.0 (info@favcollector.com http://www.favcollector.com/)', 'Favcollector Favicon collecting robot', 'R'),
(357, 'favo.eu crawler/0.6 (http://www.favo.eu)', 'favo.eu (Germany) search robot', 'R'),
(358, 'Faxobot/1.0', 'FaXo Search robot (69.152.89.xx)', 'R'),
(359, 'Feed Seeker Bot (RSS Feed Seeker http://www.MyNewFavoriteThing.com/fsb.php)', 'RSS Feed Seeker bot (68.225.95.2xx)', 'R'),
(360, 'Feed24.com', 'Feed24 news feed and blog search', 'R'),
(361, 'FeedChecker/0.01', 'Unknown robot from the University of Tokyo (157.82.157.xx)', 'R'),
(362, 'Feedfetcher-Google; (+http://www.google.com/feedfetcher.html)', 'Google Feedfetcher - RSS and Atom feed crawler', 'R'),
(363, 'FeedHub FeedDiscovery/1.0 (http://www.feedhub.com)', 'FeedHub news feed personalization engine powered by mSpoke', 'R'),
(364, 'FeedHub MetaDataFetcher/1.0 (http://www.feedhub.com)', 'FeedHub news feed personalization engine powered by mSpoke', 'R'),
(365, 'Feedjit Favicon Crawler 1.0', 'Feedjit news feed service favicon crawler', 'R'),
(366, 'Feedster Crawler/3.0; Feedster&#44; Inc.', 'Feedster RSS feed search', 'R'),
(367, 'Felix - Mixcat Crawler (+http://mixcat.com)', 'MixCat robot', 'R'),
(368, 'FFC Trap Door Spider', 'Frequent Finders spider via Sitefusion.com', 'R'),
(369, 'Filtrbox/1.0', 'filtrbox media content (news) monitoring', 'R'),
(370, 'Findexa Crawler (http://www.findexa.no/gulesider/article26548.ece)', 'Yelo.no business search (Norway) via Findexa', 'R'),
(371, 'findlinks/x.xxx (+http://wortschatz.uni-leipzig.de/findlinks/) ', 'NextLinks - German vocabulary and hyperlink search', 'R'),
(372, 'FineBot', 'Finesearch robot', 'R'),
(373, 'Firefly/1.0', 'Fireball.de robot', 'R'),
(374, 'Firefly/1.0 (compatible; Mozilla 4.0; MSIE 5.5)', 'Fireball.de robot', 'R'),
(375, 'Firefox (kastaneta03@hotmail.com)', 'Unknown robot from Czech Technical University Prague (147.32.141.xx)', 'R'),
(376, 'Firefox_1.0.6 (kasparek@naparek.cz)', 'Unknown robot from Czech Technical University Prague (147.32.141.xx)', 'R'),
(377, 'FirstGov.gov Search - POC:firstgov.webmasters@gsa.gov', 'AT&amp;T/Fast Search robot for FirstGov (U.S.Government) portal', 'R'),
(378, 'firstsbot', 'Firstsfind Germany robot / link checking', 'R'),
(379, 'Flapbot/0.7.2 (Flaptor Crawler; http://www.flaptor.com; crawler at flaptor period com)', 'Flaptor information retrieval solutions robot', 'R'),
(380, 'Flexum spider', 'Flexum.ru search service', 'R'),
(381, 'Flexum/2.0', 'Flexum.ru search service', 'R'),
(382, 'FlickBot 2.0 RPT-HTTPClient/0.3-3', 'DivX.com Movie Find robot', 'R'),
(383, 'flunky', 'Metacarta / Cogent robot', 'R'),
(384, 'FnooleBot/2.5.2 (+http://www.fnoole.com/addurl.html)', 'Fnoole news crawler', 'R'),
(385, 'FocusedSampler/1.0', 'IBM''s Almaden Research robot', 'R'),
(386, 'Folkd.com Spider/0.1 beta 1 (www.folkd.com)', 'folkd.com social search robot', 'R'),
(387, 'Fooky.com/ScorpionBot/ScoutOut; http://www.fooky.com/scorpionbots', 'Fooky search Scorpionbots robot (65.12.170.xxx)', 'R'),
(388, 'Francis/1.0 (francis@neomo.de http://www.neomo.de/)', 'Neomo Search (Germany) robot (85.10.197.1xx)', 'R'),
(389, 'Franklin Locator 1.8', 'Some spam bot', 'S'),
(390, 'FreeFind.com-SiteSearchEngine/1.0 (http://freefind.com; spiderinfo@freefind.com)', 'FreeFind.com robot', 'R'),
(391, 'FreshNotes crawler&lt; report problems to crawler-at-freshnotes-dot-com', 'FreshNotes - music related artist search (72.3.225.xx)', 'R'),
(392, 'FSurf15a 01', 'Some site scanning tool via diff. IPs', 'S'),
(393, 'FTB-Bot http://www.findthebest.co.uk/', 'Find the Best search robot', 'R'),
(394, 'Full Web Bot 0416B', 'Some site scanning tool from diff. IPs i.e.: - 66.28.240.xx (cogentco.com) - 68.5.174.xx (cox.net)', 'S'),
(395, 'Full Web Bot 0516B', 'Some site scanning tool i.e. from - 68.154.96.xx (bellsouth.net)', 'S'),
(396, 'Full Web Bot 2816B', 'Some site scanning tool from 66.255.6.xxx (uslec.com)', 'S'),
(397, 'FuseBulb.Com', 'FuseBulb search', 'R'),
(398, 'FyberSpider (+http://www.fybersearch.com/fyberspider.php)', 'FyberSearch FyberSpider robot', 'R'),
(399, 'GAIS Robot/1.0B2', 'Seed Search robot', 'R'),
(400, 'Gaisbot/3.0 (indexer@gais.cs.ccu.edu.tw; http://gais.cs.ccu.edu.tw/robot.php)', 'Gaislab Taiwan robot', 'R'),
(401, 'Gaisbot/3.0+(robot06@gais.cs.ccu.edu.tw;+http://gais.cs.ccu.edu.tw/robot.php)', 'Gaislab Taiwan robot', 'R'),
(402, 'GalaxyBot/1.0 (http://www.galaxy.com/galaxybot.html)', 'Galaxy robot (63.121.41.xxx)', 'R'),
(403, 'Gallent Search Spider v1.4 Robot 2 (http://robot.GallentSearch.com)', 'Gallent Search directory (UK)', 'R'),
(404, 'gamekitbot/1.0 (+http://www.uchoose.de/crawler/gamekitbot/)', 'Gamekit game search engine - Germany', 'R'),
(405, 'GammaSpider/1.0', 'GammaWare GammaSpider', 'R'),
(406, 'gazz/x.x (gazz@nttrd.com)', 'nttrd.com / Infobee.ne.jp robot', 'R'),
(407, 'generic_crawler/01.0217/', 'Unknown robot from Carnegie Mellon University (128.2.211.xxx)', 'R'),
(408, 'genieBot (http://64.5.245.11/faq/faq.html)', 'GenieKnows.com search', 'R'),
(409, 'geniebot wgao@genieknows.com', 'GenieKnows.com search', 'R'),
(410, 'GeonaBot 1.x; http://www.geona.com/', 'Geona Search robot / link checking', 'R'),
(411, 'gigabaz/3.1x (baz@gigabaz.com; http://gigabaz.com/gigabaz/)', 'GigaBaz Brainbot (Germany) robot', 'R'),
(412, 'Gigabot/2.0 (gigablast.com)', 'Gigablast robot (64.62.168.xx)', 'R'),
(413, 'Gigabot/2.0/gigablast.com/spider.html', 'Gigablast robot', 'R'),
(414, 'Gigabot/2.0; http://www.gigablast.com/spider.html', 'Gigablast robot', 'R'),
(415, 'Gigabot/2.0att', 'Gigablast robot', 'R'),
(416, 'Gigabot/3.0 (http://www.gigablast.com/spider.html)', 'Gigablast robot', 'R'),
(417, 'Gigabot/x.0', 'Gigablast robot (64.62.168.xx)', 'R'),
(418, 'GigabotSiteSearch/2.0 (sitesearch.gigablast.com)', 'Gigablast robot (64.62.168.xx)', 'R'),
(419, 'GNODSPIDER (www.gnod.net)', 'www.gnod.net spider', 'R'),
(420, 'Goblin/0.9 (http://www.goguides.org/)', 'GoGuides.Org (195.226.137.xx) robot', 'R'),
(421, 'Goblin/0.9.x (http://www.goguides.org/goblin-info.html)', 'GoGuides.Org (195.226.137.xx) robot', 'R'),
(422, 'GoForIt.com', 'GoForIt Search robot', 'R'),
(423, 'GOFORITBOT ( http://www.goforit.com/about/ )', 'GoForIt Search robot', 'R'),
(424, 'gonzo1[P] +http://www.suchen.de/popups/faq.jsp', 'suchen.de German local search robot', 'R'),
(425, 'gonzo2[P] +http://www.suchen.de/faq.html', 'suchen.de German local search robot', 'R'),
(426, 'Goofer/0.2', 'Some private robot (Wanadoo.fr client)', 'R'),
(427, 'Googlebot-Image/1.0', 'Google image crawler (66.249.72.xxx)', 'R'),
(428, 'Googlebot-Image/1.0 ( http://www.googlebot.com/bot.html)', 'Google image crawler (66.249.72.xxx)', 'R'),
(429, 'Googlebot/2.1 ( http://www.google.com/bot.html)', 'Google robot 66.249.64.XXX', 'R'),
(430, 'Googlebot/2.1 ( http://www.googlebot.com/bot.html)', 'Google robot 66.249.64.XXX', 'R'),
(431, 'Googlebot/Test ( http://www.googlebot.com/bot.html)', 'Google robot 66.249.64.XXX', 'R'),
(432, 'GrapeFX/0.3 libwww/5.4.0', 'Grapeshot web search system API', 'R'),
(433, 'great-plains-web-spider/flatlandbot (Flatland Industries Web Spider; http://www.flatlandindustries.com/flatlandbot.php; jason@flatlandindustries.com)', 'Flatland Industries vertical search solution', 'R'),
(434, 'GrigorBot 0.8 (http://www.grigor.biz/bot.html)', 'Grigor Search bot', 'R'),
(435, 'Gromit/1.0', 'Australasian Legal Information Institute (AustLII) robot', 'R'),
(436, 'grub crawler(http://www.grub.org)', 'Grub open source crawler', 'R'),
(437, 'grub-client', 'Grub open source crawler', 'R'),
(438, 'gsa-crawler (Enterprise; GID-01422; jplastiras@google.com)', 'Google Search Appliance robot (216.239.xx.xx)', 'R'),
(439, 'gsa-crawler (Enterprise; GID-01742;gsatesting@rediffmail.com)', 'Google Search Appliance robot (216.239.xx.xx)', 'R'),
(440, 'gsa-crawler (Enterprise; GIX-02057; dm@enhesa.com)', 'Google Enterprise Search Appliance used by Enhesa (212.35.100.1xx)', 'R'),
(441, 'gsa-crawler (Enterprise; GIX-03519; cknuetter@stubhub.com)', 'Google Enterprise Search Appliance used by IBM (129.41.20.1xx)', 'R'),
(442, 'gsa-crawler (Enterprise; GIX-0xxxx; enterprise-training@google.com)', 'Google Search Appliance robot (216.239.xx.xx)', 'R'),
(443, 'Guestbook Auto Submitter', 'Guestbook spamming tool', 'S'),
(444, 'Gulliver/1.3', 'Northernlight robot', 'R'),
(445, 'Gulper Web Bot 0.2.4 (www.ecsl.cs.sunysb.edu/~maxim/cgi-bin/Link/GulperBot)', 'Yuntis Collaborative Web Resource Categorization and Ranking Project robot', 'R'),
(446, 'Gungho/0.08004 (http://code.google.com/p/gungho-crawler/wiki/Index)', 'Gungho - Extensible web crawler written in Perl by Google Code', 'R'),
(447, 'GurujiBot/1.0 (+http://www.guruji.com/WebmasterFAQ.html)', 'guruji : the Indian search engine robot', 'R'),
(448, 'GurujiImageBot/1.0 (+http://www.guruji.com/en/WebmasterFAQ.html)', 'guruji : the Indian search engine picture crawler', 'R'),
(449, 'HappyFunBot/1.1', 'Happy Fun Search robot', 'R'),
(450, 'Harvest-NG/1.0.2', 'Harvest-NG web crawler used by search.yahoo.com', 'R'),
(451, 'Hatena Antenna/0.4 (http://a.hatena.ne.jp/help#robot)', 'Hatena::Antenna Japan robot', 'R'),
(452, 'Hatena Pagetitle Agent/1.0', 'Hatena Japan robot', 'R'),
(453, 'Hatena RSS/0.3 (http://r.hatena.ne.jp)', 'Hatena Japan RSS feed robot', 'R'),
(454, 'hbtronix.spider.2 -- http://hbtronix.de/spider.php', 'hbtronix.spider - Domain name spider (Germany)', 'R'),
(455, 'HeinrichderMiragoRobot', 'Mirago Germany robot', 'R'),
(456, 'HeinrichderMiragoRobot (http://www.miragorobot.com/scripts/deinfo.asp)', 'Mirago Germany robot', 'R'),
(457, 'Helix/1.x ( http://www.sitesearch.ca/helix/)', 'Helix - The SiteSearch (Canada) web crawler', 'R'),
(458, 'HenriLeRobotMirago (http://www.miragorobot.com/scripts/frinfo.asp)', 'Mirago France robot', 'R'),
(459, 'HenrytheMiragoRobot', 'Mirago search (UK) robot', 'R'),
(460, 'HenryTheMiragoRobot (http://www.miragorobot.com/scripts/mrinfo.asp)', 'Mirago search (UK) robot', 'R'),
(461, 'Hi! I''m CsCrawler my homepage: http://www.kde.cs.uni-kassel.de/lehre/ss2005/googlespam/crawler.html RPT-HTTPClient/0.3-3', 'University of Kassel Germany CsCrawler using the HTTPClient library', 'R'),
(462, 'Hippias/0.9 Beta', 'Hippias robot', 'R'),
(463, 'HitList', 'Pilot Hitlist web analytics solution', 'R'),
(464, 'Hitwise Spider v1.0 http://www.hitwise.com', 'Hitwise spider', 'R'),
(465, 'holmes/3.11 (http://morfeo.centrum.cz/bot)', 'Morfeo / Centrum Search (Czech Republic) robot from 65.102.46.xxx', 'R'),
(466, 'holmes/3.9 (onet.pl)', 'Onet.pl (Poland) search robot', 'R'),
(467, 'holmes/3.xx (OnetSzukaj/5.0; +http://szukaj.onet.pl)', 'Onet.pl (Poland) search robot', 'R'),
(468, 'holmes/x.x', 'Morfeo / Centrum Search (Czech Republic) robot from 65.102.46.xxx', 'R'),
(469, 'HolmesBot (http://holmes.ge)', 'Holes search robot (Georgia)', 'R'),
(470, 'HomePageSearch(hpsearch.uni-trier.de)', 'HomePageSearch robot', 'R'),
(471, 'Homerbot: www.homerweb.com', 'Homerweb search robot', 'R'),
(472, 'Honda-Search/0.7.2 (Nutch; http://lucene.apache.org/nutch/bot.html; search@honda-search.com)', 'Honda-Search.com - Honda cars related search robot', 'R'),
(473, 'HooWWWer/2.1.3 (debugging run) (+http://cosco.hiit.fi/search/hoowwwer/ | mailto:crawler-info&lt;at>hiit.fi)', 'HooWWer - Next Generation Information Retrieval robot ', 'R'),
(474, 'HooWWWer/2.1.x ( http://cosco.hiit.fi/search/hoowwwer/ | mailto:crawler-info&lt;at>hiit.fi)', 'HooWWer - Next Generation Information Retrieval robot (128.214.112.xx)', 'R'),
(475, 'HPL/Nutch-0.9 -', 'Unknown robot from HP Labs', 'R'),
(476, 'htdig/3.1.6 (http://computerorgs.com)', 'COMPUTERorgs.com robot (205.134.190.xxx) using htdig', 'R'),
(477, 'htdig/3.1.6 (unconfigured@htdig.searchengine.maintainer)', 'htdig used by the Academie de Toulouse', 'R'),
(478, 'htdig/3.1.x (root@localhost)', 'htdig search tool', 'R'),
(479, 'http://Ask.24x.Info/ (http://narres.it/)', 'Ask 24x Info (Germany) DMOZ related robot', 'R'),
(480, 'http://hilfe.acont.de/bot.html ACONTBOT', 'ACONTBOT - Acont search Germany robot', 'R'),
(481, 'http://www.almaden.ibm.com/cs/crawler', 'IBM''s Almaden Research robot', 'R'),
(482, 'http://www.almaden.ibm.com/cs/crawler [rc1.wf.ibm.com]', 'IBM''s Almaden Research robot', 'R'),
(483, 'http://www.almaden.ibm.com/cs/crawler [wf216]', 'IBM''s Almaden Research robot', 'R'),
(484, 'http://www.istarthere.com_spider@istarthere.com', 'Istarthere.com search robot', 'R'),
(485, 'http://www.monogol.de', 'Monogol - German open source search engine project (195.226.167.1xx)', 'R'),
(486, 'http://www.trendtech.dk/spider.asp)', 'TrendTech Search Engine (Denmark) robot', 'R'),
(487, 'i1searchbot/2.0 (i1search web crawler; http://www.i1search.com; crawler@i1search.com)', 'i1search robot', 'R'),
(488, 'IAArchiver-1.0', 'Alexa / The Internet Archive (209.237.238.1xx)', 'R'),
(489, 'iaskspider2 (iask@staff.sina.com.cn)', 'Iask search / Sina portal robot (China)', 'R'),
(490, 'ia_archiver', 'Alexa / The Internet Archive (209.237.238.1xx)', 'R'),
(491, 'ia_archiver-web.archive.org', 'Alexa / The Internet Archive (209.237.238.1xx)', 'R'),
(492, 'ia_archiver/1.6', 'Alexa / The Internet Archive (209.237.238.1xx)', 'R'),
(493, 'ICC-Crawler(Mozilla-compatible; http://kc.nict.go.jp/icc/crawl.html; icc-crawl(at)ml(dot)nict(dot)go(dot)jp)', 'Knowledge Clustered Group ICC-Crawler (University of Tokyo - Japan)', 'R'),
(494, 'ICC-Crawler(Mozilla-compatible;http://kc.nict.go.jp/icc/crawl.html;icc-crawl-contact(at)ml(dot)nict(dot)go(dot)jp)', 'Knowledge Clustered Group ICC-Crawler (University of Tokyo - Japan)', 'R'),
(495, 'iCCrawler (http://www.iccenter.net)', 'ICJobs - Intelligence Competence Center (Germany) robot', 'R'),
(496, 'ICCrawler - ICjobs (http://www.icjobs.de/bot.htm)', 'ICJobs - Intelligence Competence Center (Germany) robot', 'R'),
(497, 'ichiro/x.0 (http://help.goo.ne.jp/door/crawler.html)', 'Goo Japan / Inktomi robot (210.173.179.xx)', 'R'),
(498, 'ichiro/x.0 (ichiro@nttr.co.jp)', 'Goo Japan / Inktomi robot (210.173.179.xx)', 'R'),
(499, 'IconSurf/2.0 favicon finder (see http://iconsurf.com/robot.html)', 'Iconsurf.com - Visual Surf Engine / favicon finder', 'R'),
(500, 'IconSurf/2.0 favicon monitor (see http://iconsurf.com/robot.html)', 'Iconsurf.com - Visual Surf Engine / favicon finder', 'R'),
(501, 'ICRA_label_spider/x.0', 'ICRA (Internet Content Rating Association) label spider', 'R'),
(502, 'icsbot-0.1', 'ICS Robot Search Engine (International Christian school of Seoul)', 'R'),
(503, 'ideare - SignSite/1.x', 'Janas (Ideare.com / Tiscali.it) robot', 'R'),
(504, 'iFeed.jp/2.0 (www.psychedelix.com/agents/agents.rss; 0 subscribers)', 'iFeed.jp - online rss aggregator (in development)', 'R'),
(505, 'igdeSpyder (compatible; igde.ru; +http://igde.ru/doc/tech.html)', 'Igde search (Russia) robot', 'R'),
(506, 'IIITBOT/1.1 (Indian Language Web Search Engine; http://webkhoj.iiit.net; pvvpr at iiit dot ac dot in)', 'Webkhoj - Indian language search engine', 'R');
INSERT INTO `[[dbprefix]]reports_crawlers_info` VALUES
(507, 'ilial/Nutch-0.9 (Ilial&#44; Inc. is a Los Angeles based Internet startup company. For more information please visit http://www.ilial.com/crawler; http://www.ilial.com/crawler; crawl@ilial.com)', 'Ilial Knowledge Search robot', 'R'),
(508, 'ilial/Nutch-0.9-dev', 'Unknown robot from UCLA using Nutch', 'R'),
(509, 'IlseBot/1.x', 'Ilse Netherlands robot (62.69.178.xx)', 'R'),
(510, 'IlTrovatore-Setaccio ( http://www.iltrovatore.it)', 'Il Trovatore - Italian search engine robot', 'R'),
(511, 'Iltrovatore-Setaccio/0.3-dev (Indexing; http://www.iltrovatore.it/bot.html; info@iltrovatore.it)', 'Il Trovatore - Italian search engine robot', 'R'),
(512, 'IlTrovatore-Setaccio/1.2 ( http://www.iltrovatore.it/aiuto/faq.html)', 'Il Trovatore - Italian search engine robot', 'R'),
(513, 'Iltrovatore-Setaccio/1.2 (It-bot; http://www.iltrovatore.it/bot.html; info@iltrovatore.it)', 'Il Trovatore - Italian search engine robot', 'R'),
(514, 'iltrovatore-setaccio/1.2-dev (spidering; http://www.iltrovatore.it/aiuto/.....)', 'Il Trovatore - Italian search engine robot', 'R'),
(515, 'IlTrovatore/1.2 (IlTrovatore; http://www.iltrovatore.it/bot.html; bot@iltrovatore.it)', 'Il Trovatore - Italian search engine robot', 'R'),
(516, 'ImageWalker/2.0 (www.bdbrandprotect.com)', 'BD-Brandprotect copyright infringement crawler', 'R'),
(517, 'IncyWincy data gatherer(webmaster@loopimprovements.com', 'IncyWincy search engine using DMOZ Open Directory database', 'R'),
(518, 'IncyWincy page crawler(webmaster@loopimprovements.com', 'IncyWincy search engine using DMOZ Open Directory database', 'R'),
(519, 'IncyWincy(http://www.look.com)', 'Look.com robot using IncyWincy search engine', 'R'),
(520, 'IncyWincy(http://www.loopimprovements.com/robot.html)', 'IncyWincy search engine using DMOZ Open Directory database', 'R'),
(521, 'IncyWincy/2.1(loopimprovements.com/robot.html)', 'IncyWincy search engine using DMOZ Open Directory database', 'R'),
(522, 'IndexTheWeb.com Crawler7', 'Index the Web (69.57.134.xx) crawler', 'R'),
(523, 'Industry Program 1.0.x', 'Spam bot from diff. IPs', 'S'),
(524, 'Inet library', 'Inet Library Resource Center robot', 'R'),
(525, 'info@pubblisito.com- (http://www.pubblisito.com) il Sud dei Motori di Ricerca', 'Pubblisito.com search - Italia', 'R'),
(526, 'InfoFly/1.0 (http://www.versions-project.org/)', 'Versions-project.org Ingelin spider', 'R'),
(527, 'INFOMINE/8.0 Adders', 'INFOMINE Scholary Internet Resource Collection crawler', 'R'),
(528, 'INFOMINE/8.0 RemoteServices', 'INFOMINE Scholary Internet Resource Collection crawler', 'R'),
(529, 'INFOMINE/8.0 VLCrawler (http://infomine.ucr.edu/useragents)', 'INFOMINE Scholary Internet Resource Collection crawler', 'R'),
(530, 'InfoNaviRobot(F107)', '164.71.1.1xx jp.co.fujitsu.t2 Robot', 'R'),
(531, 'InfoSeek Sidewinder/0.9', 'Infoseek robot', 'R'),
(532, 'InfoSeek Sidewinder/1.0A', 'Infoseek robot', 'R'),
(533, 'InfoSeek Sidewinder/1.1A', 'Infoseek robot', 'R'),
(534, 'Infoseek SideWinder/1.45 (Compatible; MSIE 10.0; UNIX)', 'Infoseek robot', 'R'),
(535, 'Infoseek SideWinder/2.0B (Linux 2.4 i686)', 'Infoseek Japan robot', 'R'),
(536, 'INGRID/3.0 MT (webcrawler@NOSPAMexperimental.net; http://webmaster.ilse.nl/jsp/webmaster.jsp)', 'Ilse Netherlands robot (62.69.178.xx)', 'R'),
(537, 'Inktomi Search', 'Inktomi (Hotbot-Lycos NBCi etc.) robot', 'R'),
(538, 'InnerpriseBot/1.0 (http://www.innerprise.com/)', 'Enterprise Search engine software (64.202.165.xxx) ', 'R'),
(539, 'Insitor.com search and find world wide!', 'Insitor Search robot (80.67.20.1xx)', 'R'),
(540, 'Insitornaut', 'Insitor Search robot (80.67.20.1xx)', 'R'),
(541, 'Internet Ninja x.0', 'Dream Train (Japan) Internet search robot', 'R'),
(542, 'InternetArchive/0.8-dev(Nutch;http://lucene.apache.org/nutch/bot.html;nutch-agent@lucene.apache', 'Heritrix - The Internet Archive''s open-source crawler based on Nutch (207.241.225.2xx)', 'R'),
(543, 'InternetSeer.com', 'Internetseer Web site monitoring / Claymont robot', 'R'),
(544, 'IOI/2.0 (ISC Open Index crawler; http://index.isc.org/; bot@index.isc.org)', 'Internet Open Index crawler using Nutch', 'R'),
(545, 'IPiumBot laurion(dot)com', 'Laurions Ipium robot', 'R'),
(546, 'IpselonBot/0.xx-beta (Ipselon; http://www.ipselon.com; ipselonbot@ipselon.com)', 'Ipselon Web Search robot', 'R'),
(547, 'IRLbot/1.0 ( http://irl.cs.tamu.edu/crawler)', 'IRL-crawler - Texas A&amp;M University research project crawler', 'R'),
(548, 'IRLbot/3.0 (compatible; MSIE 6.0; http://irl.cs.tamu.edu/crawler/)', 'IRL-crawler - Texas A&amp;M University research project crawler', 'R'),
(549, 'ISC Systems iRc Search 2.1', 'Unknown spambot / harvester from diff. IPs', 'S'),
(550, 'IUPUI Research Bot v 1.9a', 'Some spam bot from 66.139.78.xx(x)', 'S'),
(551, 'IWAgent/ 1.0 - www.brandprotect.com', 'BD BrandProtect - brand&#44; company or trademarks online monitoring', 'R'),
(552, 'Jabot/6.x (http://odin.ingrid.org/)', 'ODIN Directory Japan robot (163.138.95.xx)', 'R'),
(553, 'Jabot/7.x.x (http://odin.ingrid.org/)', 'ODIN Directory Japan robot (163.138.95.xx)', 'R'),
(554, 'Jack', 'German Domanova (offline since Feb.02) robot', 'R'),
(555, 'Jambot/0.1.x (Jambot; http://www.jambot.com/blog; crawler@jambot.com)', 'JamBot search robot (70.146.82.xx)', 'R'),
(556, 'Jambot/0.2.1 (Jambot; http://www.jambot.com/blog/static.php?page=webmaster-robot; crawler@jambot.com)', 'JamBot search robot', 'R'),
(557, 'Jayde Crawler. http://www.jayde.com', 'Jayde B2B Search robot (66.28.139.xx)', 'R'),
(558, 'Jetbot/1.0', 'JetEye Search robot (64.62.142.xxx / 64.71.144.xxx)', 'R'),
(559, 'JobSpider_BA/1.1', 'Finacialbot.com - German (213.61.218.xx) job search JobRoboter', 'R'),
(560, 'Jyxobot/x', 'Jyxo search (Czech Republic) robot (212.71.128.xx)', 'R'),
(561, 'k2spider', 'Verity K2 Spider ( Network search software)', 'R'),
(562, 'KAIST AITrc Crawler', 'Unknown robot from AITrc (Advanced Information Technology Research Center) - Korea', 'R'),
(563, 'KakleBot - www.kakle.com/0.1 (KakleBot - www.kakle.com; http:// www.kakle.com/bot.html; support@kakle.com)', 'Kakle ranked metasearch robot', 'R'),
(564, 'kalooga/kalooga-4.0-dev-datahouse (Kalooga; http://www.kalooga.com; info@kalooga.com)', 'Kalooga image crawler', 'R'),
(565, 'kalooga/KaloogaBot (Kalooga; http://www.kalooga.com/info.html?page=crawler; crawler@kalooga.com)', 'Kalooga image crawler', 'R'),
(566, 'Kenjin Spider', 'Kenjin Spider search agent', 'R'),
(567, 'Kevin http://dznet.com/kevin/', 'Dznet.com Kevin crawler (link checking ?) via 68.39.148.xx (nj.comcast.net)', 'R'),
(568, 'Kevin http://websitealert.net/kevin/', 'Website AlertsKevin crawler (website monitoring) via 68.39.148.xx (nj.comcast.net)', 'R'),
(569, 'KE_1.0/2.0 libwww/5.2.8', 'Voila.fr robot', 'R'),
(570, 'KFSW-Bot (Version: 1.01 powered by KFSW www.kfsw.de)', 'Some Perl search script from KFSW (Germany)', 'R'),
(571, 'kinja-imagebot (http://www.kinja.com/)', 'kinja weblog search robot', 'R'),
(572, 'kinjabot (http://www.kinja.com)', 'kinja weblog search robot', 'R'),
(573, 'KIT-Fireball/2.0', 'Fireball search (Germany) robot', 'R'),
(574, 'KIT-Fireball/2.0 (compatible; Mozilla 4.0; MSIE 5.5)', 'Fireball search (Germany) robot', 'R'),
(575, 'KnowItAll(knowitall@cs.washington.edu)', 'University of Washington KnowItAll - web information extraction', 'R'),
(576, 'Knowledge.com/0.x', 'The knowledge.com (ODP) directory robot', 'R'),
(577, 'Krugle/Krugle&#44;Nutch/0.8+ (Krugle web crawler; http://www.krugle.com/crawler/info.html; webcrawler@krugle.com)', 'Krugle source code search engine for developers (64.71.164.1xx) ', 'R'),
(578, 'KSbot/1.0 (KnowledgeStorm crawler; http://www.knowledgestorm.com/resources/content/crawler/index.html; crawleradmin@knowledgestorm.com)', 'KnowledgeStorm technology industry crawler for Findtech.com', 'R'),
(579, 'kuloko-bot/0.x', 'Kuloko contextual search robot', 'R'),
(580, 'kulokobot www.kuloko.com kuloko@backweave.com', 'Kuloko contextual search robot', 'R'),
(581, 'kulturarw3/0.1', 'National Library of Sweden Heritage Project robot', 'R'),
(582, 'LapozzBot/1.4 ( http://robot.lapozz.com)', 'Lapozz search (Hungary) robot (82.131.195.xx)', 'R'),
(583, 'LapozzBot/1.5 (+http://robot.lapozz.hu)', 'Lapozz search (Hungary) robot (82.131.195.xx)', 'R'),
(584, 'larbin (samualt9@bigfoot.com)', 'Larbin indexer used as Metacarta.com (66.28.xx.xxx) robot', 'R'),
(585, 'LARBIN-EXPERIMENTAL (efp@gmx.net)', 'Unknown robot from 66.230.140.xx (argon.oxeo.com)', 'S'),
(586, 'larbin_2.1.1 larbin2.1.1@somewhere.com', 'Larbin indexer used by Mitsubishi Electric Research Labs', 'R'),
(587, 'larbin_2.2.0 (crawl@compete.com)', 'Larbin indexer used as Compete.com crawler', 'R'),
(588, 'larbin_2.2.1_de_Viennot (Laurent.Viennot@inria.fr)', 'Larbin indexer used as Inria robot', 'R'),
(589, 'larbin_2.2.2 (sugayama@lab7.kuis.kyoto-u.ac.jp)', 'Larbin indexer used as Kyoto University robot', 'R'),
(590, 'larbin_2.2.2_guillaume (guillaume@liafa.jussieu.fr)', 'Larbin indexer used as Inria robot', 'R'),
(591, 'larbin_2.6.0 (larbin2.6.0@unspecified.mail)', 'Larbin indexer used by an unknown dsl.net client', 'R'),
(592, 'larbin_2.6.1 (larbin2.6.1@unspecified.mail)', 'Larbin indexer used by diff. IPs / services', 'R'),
(593, 'larbin_2.6.2 (hamasaki@grad.nii.ac.jp)', 'Larbin indexer used by National Institut of Informatics (NII/Japan)', 'R'),
(594, 'larbin_2.6.2 (larbin2.6.2@unspecified.mail)', 'Larbin indexer used by diff. IPs', 'R'),
(595, 'larbin_2.6.2 (listonATccDOTgatechDOTedu)', 'Larbin indexer used as robot by Georgia Institute of Technology http://www.gatech.edu/', 'R'),
(596, 'larbin_2.6.2 (pimenas@systems.tuc.gr)', 'Larbin indexer used by Technical University of Crete', 'R'),
(597, 'larbin_2.6.2 (tom@lemurconsulting.com)', 'Larbin indexer used as Lemur Consulting robot', 'R'),
(598, 'larbin_2.6.2 (vitalbox1@hotmail.com)', 'Larbin indexer used as robot via cloud9.net (168.100.192.xxx)', 'R'),
(599, 'larbin_2.6.3 (ltaa_web_crawler@groupes.epfl.ch)', 'Unknown robot from EPFL Lausanne Switzerland (128.178.155.1xx)', 'R'),
(600, 'larbin_2.6.3 (wgao@genieknows.com)', 'Larbin indexer used by GenieKnows.com search', 'R'),
(601, 'larbin_2.6.3_for_(http://cosco.hiit.fi/search/) tsilande@hiit.fi', 'Larbin indexer used by Next Generation Information Retrieval (NGIR)', 'R'),
(602, 'larbin_2.6_basileocaml (basile.starynkevitch@cea.fr)', 'Larbin indexer used by CEA / DCom Rechercher', 'R'),
(603, 'larbin_devel (http://pauillac.inria.fr/~ailleret/prog/larbin/)', 'Larbin indexer used as Inria robot', 'R'),
(604, 'lawinfo-crawler/Nutch-0.9-dev (Crawler for lawinfo.com pages; http://www.lawinfo.com; webmaster@lawinfo.com)', 'LawInfo - Lawyer and attorney directory', 'R'),
(605, 'LECodeChecker/3.0 libgetdoc/1.0', 'Linkexchange crawler', 'R'),
(606, 'LEIA/2.90', 'Gseek.com (site is offline) robot', 'R'),
(607, 'LEIA/3.01pr (LEIAcrawler; [SNIP])', 'Gseek.com (site is offline) robot', 'R'),
(608, 'LetsCrawl.com/1.0 +http://letscrawl.com/', 'Maybe logfile spamming for Lets crawl! search (Germany)', 'S'),
(609, 'LexiBot/1.00', 'Lexibot (exMataHari) search software', 'R'),
(610, 'Libby_1.1/libwww-perl/5.47', 'About.com robot', 'R'),
(611, 'LibertyW (+http://www.lw01.com)', 'LibertyW search for mobile (France)', 'R'),
(612, 'libWeb/clsHTTP -- hiongun@kt.co.kr', 'Korea Telecom Search robot', 'R'),
(613, 'libwww-perl/5.41', 'CMP United Media robot', 'R'),
(614, 'libwww-perl/5.45', 'SplatSearch robot (207.44.142.xx)', 'R'),
(615, 'libwww-perl/5.48', 'Alexa robot', 'R'),
(616, 'libwww-perl/5.52 FP/2.1', 'Fast Search robot', 'R'),
(617, 'libwww-perl/5.52 FP/4.0', 'Fast Search robot', 'R'),
(618, 'libwww-perl/5.65', 'Amidalla search engine robot (62.241.33.xx)', 'R'),
(619, 'libwww-perl/5.800', 'SplatSearch robot (72.36.210.xx)', 'R'),
(620, 'libwww/5.3.2', 'Mediater Rechercher robot', 'R'),
(621, 'LijitSpider/Nutch-0.9 (Reports crawler; http://www.lijit.com/; info(a)lijit(d)com)', 'Lijit blog search spider', 'R'),
(622, 'Lincoln State Web Browser', 'Some spam bot', 'S'),
(623, 'linkbot', 'Rpsoft 2000 Site-Crawler', 'R'),
(624, 'linknzbot', 'Linknz - The Kiwi Search Engine (New Zealand)', 'R'),
(625, 'Links 2.0 (http://gossamer-threads.com/scripts/links/)', 'Links SQL directory management program', 'R'),
(626, 'Links SQL (http://gossamer-threads.com/scripts/links-sql/)', 'Links SQL directory management program', 'R'),
(627, 'LinkScan/11.0beta2 UnixShareware robot from Elsop.com (used by Indiafocus/Indiainfo)', 'Shareware robot from Elsop.com (used by Indiafocus/Indiainfo and others)', 'R'),
(628, 'LinkScan/9.0g Unix', 'Shareware robot from Elsop.com (used by Indiafocus/Indiainfo and others)', 'R'),
(629, 'LinkScan/x.x Unix', 'Shareware robot from Elsop.com', 'R'),
(630, 'LiveTrans/Nutch-0.9 (maintainer: cobain at iis dot sinica dot edu dot tw; http://wkd.iis.sinica.edu.tw/LiveTrans/)', 'WKD Lab: LiveTrans - Online query and terminology translation service', 'R'),
(631, 'Llaut/1.0 (http://mnm.uib.es/~gallir/llaut/bot.html)', 'llaut robot - Universitat de les Illes Balears (Spain)', 'R'),
(632, 'LMQueueBot/0.2', 'E-Mail harvesting robot - same as ContactBot', 'S'),
(633, 'lmspider (lmspider@scansoft.com)', 'lmspider from Scansoft (192.133.61.xx) - Web text collector', 'R'),
(634, 'LNSpiderguy', 'Lexis-Nexis robot', 'R'),
(635, 'LocalBot/1.0 ( http://www.localbot.co.uk/)', 'LocalBot company information collector', 'R'),
(636, 'LocalcomBot/1.2.x ( http://www.local.com/bot.htm)', 'Local.com local search robot (216.52.252.xxx)', 'R'),
(637, 'Lockstep Spider/1.0', 'Lockstep (website content protection tool) user agent', 'R'),
(638, 'Look.com', 'GlobalQueue spider (64.40.105.xxx)', 'R'),
(639, 'Lovel as 1.0 ( +http://www.everatom.com)', 'Everatom.com song lyrics search', 'R'),
(640, 'LTI/LemurProject Nutch Spider/Nutch-1.0-dev (lti crawler for CMU; http://www.lti.cs.cmu.edu; changkuk at cmu dot edu)', 'LTI - The Lemur Toolkit for Language Modeling and Information Retrieval via Yahoo', 'R'),
(641, 'LTI/LemurProject Nutch Spider/Nutch-1.0-dev (Research spider using Nutch; http://www.lemurproject.org; mhoy@cs.cmu.edu)', 'LTI - The Lemur Toolkit for Language Modeling and Information Retrieval via Yahoo', 'R'),
(642, 'lwp-trivial/1.32', 'Ultimate Search / Smartdesk (no website) robot', 'R'),
(643, 'lwp-trivial/1.34', 'Search4free robot', 'R'),
(644, 'lwp-trivial/1.34', 'Search4free robot', 'R'),
(645, 'LWP::Simple/5.22', 'Perl LWP:Collective module', 'R'),
(646, 'LWP::Simple/5.36', 'Perl LWP:Collective module', 'R'),
(647, 'LWP::Simple/5.48', 'Perl LWP:Collective module - Linkomatic robot', 'R'),
(648, 'LWP::Simple/5.50', 'Perl LWP:Collective module - secure-netz.de link checking (in conjunction w. libwww-perl/5.50)', 'R'),
(649, 'LWP::Simple/5.51', 'Perl LWP:Collective module - Inktomi (62.253.64.x) robot', 'R'),
(650, 'LWP::Simple/5.53', 'Perl LWP:Collective module - Only.com ', 'R'),
(651, 'LWP::Simple/5.63', 'Perl LWP:Collective module', 'R'),
(652, 'LWP::Simple/5.803', 'ThePlanet/jaja-jak-globusy.com Google Adsense refferer spam bot from 70.85.116.* / 70.84.128.xxx / 70.85.193.xxx', 'S'),
(653, 'Lycos_Spider_(modspider)', 'Lycos spider', 'R'),
(654, 'Lycos_Spider_(T-Rex)', 'Lycos spider', 'R'),
(655, 'Lynx/2.8.4rel.1 libwww-FM/2.14 SSL-MM/1.4.1 OpenSSL/0.9.6c (human-guided@lerly.net)', 'Lynx 2.x text mode browser used as robot via cogentco.com', 'R'),
(656, 'Mac Finder 1.0.xx', 'Some spam bot', 'S'),
(657, 'Mackster( http://www.ukwizz.com )', 'UKWizz search robot', 'R'),
(658, 'Mahiti.Com/Mahiti Crawler-1.0 (Mahiti.Com; http://mahiti.com ; mahiti.com)', 'Mahiti.com India search crawler', 'R'),
(659, 'Mail.Ru/1.0', 'Mail.ru search', 'R'),
(660, 'mailto:webcraft@bea.com', 'Unknown Bea robot', 'R'),
(661, 'mammoth/1.0 ( http://www.sli-systems.com/)', 'SLI Systems mammoth robot', 'R'),
(662, 'MantraAgent', 'Looksmart robot', 'R'),
(663, 'MapoftheInternet.com ( http://MapoftheInternet.com)', 'Map of the Internet visual search engine index robot', 'R'),
(664, 'Mariner/5.1b [de] (Win95; I ;Kolibri gncwebbot)', 'Kolibri.de robot', 'R'),
(665, 'Marketwave Hit List', 'Pilot Hitlist web site analysis', 'R'),
(666, 'Martini', 'Looksmart directory page analysis', 'R'),
(667, 'MARTINI', 'Looksmart directory page analysis', 'R'),
(668, 'Marvin v0.3', 'Marvin Medhunt robot', 'R'),
(669, 'MaSagool/1.0 (MaSagool; http://sagool.jp/; info@sagool.jp)', 'Sagool search Japan robot', 'R'),
(670, 'MasterSeek', 'Masterseek (Scandinavia) Beta business search ?', 'R'),
(671, 'Mata Hari/2.00 ', 'Lexibot (exMataHari) search software', 'R'),
(672, 'Matrix S.p.A. - FAST Enterprise Crawler 6 (Unknown admin e-mail address)', 'Virgilio Italy robot (212.48.11.xxx) using Fast Enterprise Search', 'R'),
(673, 'maxomobot/dev-20051201 (maxomo; http://67.102.134.34:4047/MAXOMO/MAXOMObot.html; maxomobot@maxomo.com)', 'Maxomo multimedia search robot', 'R'),
(674, 'MDbot/1.0 (+http://www.megadownload.net/bot.html)', 'MegaDownload files search robot', 'R'),
(675, 'MediaCrawler-1.0 (Experimental)', 'Media Find crawler', 'R'),
(676, 'Mediapartners-Google/2.1 ( http://www.googlebot.com/bot.html)', 'Google AdSense robot', 'R'),
(677, 'MediaSearch/0.1', 'WWW.fi Media Search', 'R'),
(678, 'MegaSheep v1.0 (www.searchuk.com internet sheep)', 'Search UK robot', 'R'),
(679, 'Megite2.0 (http://www.megite.com)', 'Megite web2.0 RSS and news service software', 'R'),
(680, 'Mercator-1.x', 'Mercator crawler software (used by Altavista)', 'R'),
(681, 'Mercator-2.0', 'Mercator crawler software (used by Altavista)', 'R'),
(682, 'Mercator-Scrub-1.1', 'Mercator crawler software (used by Altavista)', 'R'),
(683, 'Metaeuro Web Crawler/0.2 (MetaEuro Web Search Clustering Engine; http://www.metaeuro.com; crawler at metaeuro dot com)', 'MetaEuro.com Clustering Web Search Engine crawler', 'R'),
(684, 'MetaGer-LinkChecker', 'MetaGer search robot (Germany)', 'R'),
(685, 'MetagerBot/0.8-dev (MetagerBot; http://metager.de;  )', 'MetaGer search robot (Germany)', 'R'),
(686, 'MetaGer_PreChecker0.1', 'MetaGer search robot (Germany)', 'R'),
(687, 'Metaspinner/0.01 (Metaspinner; http://www.meta-spinner.de/; support@meta-spinner.de/)', 'Metaspinner search robot - Germany', 'R'),
(688, 'metatagsdir/0.7 (+http://metatagsdir.com/directory/)', 'Metatagsdir.com directory index spider', 'R'),
(689, 'MFC Foundation Class Library 4.0', 'Microsoft Foundation Class Library - i.e. used for e-mail harvesting from 68.154.96.xx (bellsouth.net)', 'S'),
(690, 'MicroBaz', 'GigaBaz Brainbot (Germany) robot (213.139.152.xx)', 'R'),
(691, 'Microsoft Small Business Indexer', 'MS Small Business Server content indexer', 'R'),
(692, 'Microsoft URL Control - 6.00.8xxx', 'user agent looks for form-mail components (spam-bot)', 'S'),
(693, 'MicrosoftPrototypeCrawler (How''s my crawling? mailto:newbiecrawler@hotmail.com)', 'Unknown robot from Microsoft.com (131.107.163.xx)', 'R'),
(694, 'Missauga Locate 1.0.0', 'Some spam bot', 'S'),
(695, 'Missigua Locator 1.9', 'Some spam bot', 'S'),
(696, 'Missouri College Browse', 'Some spam bot', 'S'),
(697, 'Misterbot-Nutch/0.7.1 (Misterbot-Nutch; http://www.misterbot.fr; admin@misterbot.fr)', 'Misterbot search France robot', 'R'),
(698, 'Miva (AlgoFeedback@miva.com)', 'Miva / ex Findwhat.com search robot (66.150.55.2xx)', 'R'),
(699, 'Mizzu Labs 2.2', 'Some spam bot from Jasmine Internet - Bangkok (203.147.0.xx)', 'S'),
(700, 'MJ12bot/vx.x.x (http://majestic12.co.uk/bot.php?+)', 'Majestic-12 DSearch MJ12bot (Experimental distributed crawler)', 'R'),
(701, 'MJ12bot/vx.x.x (http://www.majestic12.co.uk/projects/dsearch/mj12bot.php)', 'Majestic-12 DSearch MJ12bot (Experimental distributed crawler)', 'R'),
(702, 'MJBot (SEO assessment)', 'MJB SEO Club MJBot', 'R'),
(703, 'MLBot (www.metadatalabs.com)', 'MLBot - metadata labs web crawler for building a media index (beta)', 'R'),
(704, 'MnogoSearch/3.2.xx', 'mnoGoSearch (ex UdmSearch) software robot', 'R'),
(705, 'Mo College 1.9', 'Unknown bad bot - maybe guestbook spamming or email harvesting', 'S'),
(706, 'moget/x.x (moget@goo.ne.jp)', 'Goo Japan / Inktomi robot (210.173.179.xx)', 'R'),
(707, 'mogimogi/1.0', 'Goo Japan / Inktomi robot (210.173.179.xx)', 'R'),
(708, 'MojeekBot/0.x (archi; http://www.mojeek.com/bot.html)', 'Mojeek Search Preview robot (217.155.205.xx)', 'R'),
(709, 'Morris - Mixcat Crawler ( http://mixcat.com)', 'MixCat robot s. also Felix', 'R'),
(710, 'Mouse-House/7.4 (spider_monkey spider info at www.mobrien.com/sm.shtml)', 'MPRM Group Ltd. Spider Monkey robot', 'R'),
(711, 'mozDex/0.xx-dev (mozDex; http://www.mozdex.com/en/bot.html; spider@mozdex.com)', 'Mozdex Open search engine spider (65.98.100.2xx)', 'R'),
(712, 'Mozilla (Mozilla@somewhere.com)', 'http://www.somewhere.com robot', 'R'),
(713, 'Mozilla 4.0(compatible; BotSeer/1.0; +http://botseer.ist.psu.edu)', 'BotSeer search engine for robots.txt', 'R'),
(714, 'Mozilla/2.0 (compatible; Ask Jeeves)', 'Ask Jeeves /Teoma robot', 'R'),
(715, 'Mozilla/2.0 (compatible; Ask Jeeves/Teoma)', 'Ask Jeeves /Teoma robot', 'R'),
(716, 'Mozilla/2.0 (compatible; Ask Jeeves/Teoma; http://about.ask.com/en/docs/about/webmasters.shtml) ', 'Ask Jeeves /Teoma robot', 'R'),
(717, 'Mozilla/2.0 (compatible; Ask Jeeves/Teoma; http://sp.ask.com/docs/about/tech_crawling.html)', 'Ask Jeeves /Teoma robot', 'R'),
(718, 'Mozilla/2.0 (compatible; EZResult -- Internet Search Engine)', 'Direct Hit Robot', 'R'),
(719, 'Mozilla/2.0 (compatible; NEWT ActiveX; Win32)', 'Borland Delphi .OCX component used by WebCollector email harverster', 'S'),
(720, 'Mozilla/2.0 (compatible; T-H-U-N-D-E-R-S-T-O-N-E)', 'Thunderstone''s Webinator Web indexing program', 'R'),
(721, 'Mozilla/3.0 (compatible; Fluffy the spider; http://www.searchhippo.com/; info@searchhippo.com)', 'Searchhippo robot', 'R'),
(722, 'Mozilla/3.0 (compatible; Indy Library)', 'Internet Direct Library for Borland (often used as e-mail address collector and mass mailing tool)', 'S'),
(723, 'Mozilla/3.0 (compatible; MuscatFerret/1.5.4; claude@euroferret.com)', 'Euroferret robot', 'R'),
(724, 'Mozilla/3.0 (compatible; MuscatFerret/1.5; olly@muscat.co.uk)', 'Euroferret robot', 'R'),
(725, 'Mozilla/3.0 (compatible; MuscatFerret/1.6.x; claude@euroferret.com)', 'Euroferret robot', 'R'),
(726, 'Mozilla/3.0 (compatible; scan4mail (advanced version) http://www.peterspages.net/?scan4mail)', 'Scan4Mail online mail extraction service', 'S'),
(727, 'Mozilla/3.0 (compatible; ScollSpider; http://www.webwobot.com)', 'WebWobot UK search engine robot (82.43.129.2xx)', 'R'),
(728, 'Mozilla/3.0 (compatible; Webinator-DEV01.home.iprospect.com/2.56)', 'Iprospect search engine positioning using Thunderstone''s Webinator', 'R'),
(729, 'Mozilla/3.0 (compatible; Webinator-indexer.cyberalert.com/2.56)', 'CyberAlert''s Media Monitor using Thunderstone''s Webinator', 'R'),
(730, 'Mozilla/3.0 (INGRID/3.0 MT; webcrawler@NOSPAMexperimental.net; http://aanmelden.ilse.nl/?aanmeld_mode=webhints)', 'Ilse Netherlands robot (62.69.178.xx)', 'R'),
(731, 'Mozilla/3.0 (Slurp.so/Goo; slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'http://www.goo.ne.jp /Inktomi robot', 'R'),
(732, 'Mozilla/3.0 (Slurp/cat; slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos-NBCi) robot - 72.30.61.xx(x)', 'R'),
(733, 'Mozilla/3.0 (Slurp/si; slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos-NBCi) robot - 72.30.61.xx(x)', 'R'),
(734, 'Mozilla/3.0 (Vagabondo/1.1 MT; webcrawler@NOSPAMwise-guys.nl; http://webagent.wise-guys.nl/)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(735, 'Mozilla/3.0 (Vagabondo/1.x MT; webagent@wise-guys.nl; http://webagent.wise-guys.nl/)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(736, 'Mozilla/3.0 (Vagabondo/2.0 MT; webcrawler@NOSPAMexperimental.net; http://aanmelden.ilse.nl/?aanmeld_mode=webhints)', 'Ilse Netherlands robot', 'R'),
(737, 'Mozilla/3.0 (Vagabondo/2.0 MT; webcrawler@NOSPAMwise-guys.nl; http://webagent.wise-guys.nl/)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(738, 'Mozilla/3.01 (Compatible; Links2Go Similarity Engine)', 'Links2Go robot', 'R'),
(739, 'Mozilla/4.0', 'Yahoo Mindset: Intent-driven Search (66.228.182.1xx)', 'R'),
(740, 'Mozilla/4.0 (agadine3.0) www.agada.de', 'Agada search (Germany) robot', 'R'),
(741, 'Mozilla/4.0 (compatible: AstraSpider V.2.1 : astrafind.com)', 'Astrafind! adult search robot (66.98.252.xx)', 'R'),
(742, 'Mozilla/4.0 (compatible;  Vagabondo/2.2; webcrawler at wise-guys dot nl; http://webagent.wise-guys.nl/)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(743, 'Mozilla/4.0 (compatible;  Vagabondo/4.0Beta; webcrawler at wise-guys dot nl; http://webagent.wise-guys.nl/)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(744, 'Mozilla/4.0 (compatible; Advanced Email Extractor v2.xx)', 'Advanced Email Extractor e-mail collector (spam bot)', 'S'),
(745, 'Mozilla/4.0 (compatible; B_L_I_T_Z_B_O_T)', 'Blitzsuche Germany robot', 'R'),
(746, 'Mozilla/4.0 (compatible; ChristCrawler.com ChristCrawler@ChristCENTRAL.com)', 'Christcentral.com Christcrawler (was www.christcrawler.com)', 'R'),
(747, 'Mozilla/4.0 (compatible; crawlx&#44; crawler@trd.overture.com)', 'Yahoo Search Marketing crawler (68.142.211.1xx)', 'R'),
(748, 'Mozilla/4.0 (compatible; DAUMOA-video; +http://ws.daum.net/aboutkr.html)', 'DAUMOA - Daum search Korea robot (211.115.109.xxx)', 'R'),
(749, 'Mozilla/4.0 (compatible; FastCrawler3 support-fastcrawler3@fast.no)', 'Fast/Alltheweb crawler', 'R'),
(750, 'Mozilla/4.0 (compatible; FDSE robot)', 'Fluid Dynamics Search Engine (FDSE) robot used by Abadoor.de', 'R'),
(751, 'Mozilla/4.0 (compatible; GPU p2p crawler http://gpu.sourceforge.net/search_engine.php)', 'GPU Distributed Search Engine crawler', 'R'),
(752, 'Mozilla/4.0 (compatible; grub-client-0.2.x; Crawl your stuff with http://grub.org)', 'Grub open source crawler', 'R'),
(753, 'Mozilla/4.0 (compatible; grub-client-0.3.x; Crawl your own stuff with http://grub.org)', 'Grub open source crawler', 'R'),
(754, 'Mozilla/4.0 (compatible; grub-client-2.x)', 'Grub open source crawler used by Looksmart ( 64.241.242.xx)', 'R'),
(755, 'Mozilla/4.0 (compatible; Iplexx Spider/1.0 http://www.iplexx.at)', 'Iplexx Austria (webhosting company) logfile spamming bot', 'S'),
(756, 'Mozilla/4.0 (compatible; MSIE 4.01; Vonna.com b o t)', 'Vonna search robot', 'R'),
(757, 'Mozilla/4.0 (compatible; MSIE 4.01; Windows CE; PPC; 240x320; SPV M700; OpVer 19.123.2.733) OrangeBot-Mobile 2008.0 (mobilesearch.support@orange-ftgroup.com)', 'Orange France robot for mobiles', 'R'),
(758, 'Mozilla/4.0 (compatible; MSIE 4.0; Windows NT; Site Server 3.0 Robot) Indonesia Interactive', 'Indonesia Interactive Web-portal robot on MS Site Server', 'R'),
(759, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0) (samualt9@bigfoot.com)', 'Metacarta.com (66.28.xx.xxx) robot', 'R'),
(760, 'Mozilla/4.0 (compatible; MSIE 5.0; NetNose-Crawler 2.0; A New Search Experience: http://www.netnose.com)', 'www.netnose.com crawler', 'R'),
(761, 'Mozilla/4.0 (compatible; MSIE 5.0; Windows 95) TrueRobot; 1.5', 'Echo.com robot', 'R'),
(762, 'Mozilla/4.0 (compatible; MSIE 5.0; Windows 95) VoilaBot BETA 1.2 (http://www.voila.com/)', 'Voila.fr robot', 'R'),
(763, 'Mozilla/4.0 (compatible; MSIE 5.0; Windows 95) VoilaBot; 1.6', 'Voila.fr robot', 'R'),
(764, 'Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt; DTS Agent', 'Beijing Express Email Address Extractor via DHCP Data Transport Services (DTS)', 'S'),
(765, 'Mozilla/4.0 (compatible; MSIE 5.0; www.galaxy.com; www.psychedelix.com)', 'Galaxy robot (63.121.41.xxx) ', 'R'),
(766, 'Mozilla/4.0 (compatible; MSIE 5.0; www.galaxy.com; www.psychedelix.com/; http://www.galaxy.com/info/crawler.html)', 'Galaxy robot (63.121.41.xxx)', 'R'),
(767, 'Mozilla/4.0 (compatible; MSIE 5.0; YANDEX)', 'Yandex Search Russia link checking (213.180.206.2xx)', 'R'),
(768, 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 4.0; obot)', 'Cobion Germany Brand Protection Services robot', 'R'),
(769, 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 4.0; QXW03018)', 'Cobion Germany Brand Protection Services robot', 'R'),
(770, 'Mozilla/4.0 (compatible; MSIE 6.0 compatible; Asterias Crawler v4; +http://www.singingfish.com/help/spider.html; webmaster@singingfish.com); SpiderThread  Revision: 3.10', 'Singingfish media spider (64.12.186.2xx) via AOL search', 'R'),
(771, 'Mozilla/4.0 (compatible; MSIE 6.0; MSIE 5.5; Windows NT 5.1) Skampy/0.9.x [en]', 'Skaffe.com directory link checker', 'R'),
(772, 'Mozilla/4.0 (compatible; MSIE 6.0; TargetSeek/1.0; +http://www.targetgroups.net/TargetSeek.html)', 'TargetSeek Crawler concerning electronics industry product announcements', 'R'),
(773, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; ODP entries t_st; http://tuezilla.de/t_st-odp-entries-agent.html)', 'T&#252;zilla (Germany) - ODP link checking using Robozilla', 'R'),
(774, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; ODP links test; http://tuezilla.de/test-odp-links-agent.html)', 'T&#252;zilla (Germany) - ODP link checking using Robozilla', 'R'),
(775, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; ZoomSpider.net bot; .NET CLR 1.1.4322)', 'ZoomSpider.Net indexing robot for several directorys', 'R'),
(776, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; heritrix/1.3.0 http://www.cs.washington.edu/research/networking/websys/)', 'Heritrix Internet Archive''s open-source web project used by Analysis Projects at UW', 'R'),
(777, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; QihooBot 1.0  qihoobot@qihoo.net)', 'Qihoo search (China) robot', 'R'),
(778, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT; MS Search 4.0 Robot)', 'MSN Search robot (207.46.89.xx)', 'R'),
(779, 'Mozilla/4.0 (compatible; MSIE enviable; DAUMOA 2.0; DAUM Web Robot; Daum Communications Corp.&#44; Korea; +http://ws.daum.net/aboutkr.html)', 'DAUMOA - Daum search Korea robot (211.115.109.xxx)', 'R'),
(780, 'Mozilla/4.0 (compatible; MSIE is not me; DAUMOA/1.0.1; DAUM Web Robot; Daum Communications Corp.&#44; Korea)', 'DAUMOA - Daum search Korea robot (211.115.109.xxx)', 'R'),
(781, 'Mozilla/4.0 (compatible; NaverBot/1.0; http://help.naver.com/delete_main.asp)', 'Naver Search Korea Naverbot', 'R'),
(782, 'Mozilla/4.0 (compatible; SpeedySpider; www.entireweb.com)', 'Entireweb Search Speedyspider (62.13.25.xxx)', 'R'),
(783, 'Mozilla/4.0 (compatible; www.galaxy.com)', 'Galaxy robot', 'R'),
(784, 'Mozilla/4.0 (compatible; Y!J; for robot study; keyoshid)', 'Yahoo Search Japan robot (203.141.52.)', 'R'),
(785, 'Mozilla/4.0 (compatible; Yahoo Japan; for robot study; kasugiya)', 'Yahoo Japan robot (202.93.76.xx)', 'R'),
(786, 'Mozilla/4.0 (JemmaTheTourist;http://www.activtourist.com)', 'Activtourist Jemma spider', 'R'),
(787, 'Mozilla/4.0 (MobilePhone SCP-5500/US/1.0) NetFront/3.0 MMP/2.0 (compatible; Googlebot/2.1; http://www.google.com/bot.html)', 'Google robot from 66.249.66.xxx ', 'R'),
(788, 'Mozilla/4.0 (MobilePhone SCP-5500/US/1.0) NetFront/3.0 MMP/2.0 FAKE (compatible; Googlebot/2.1; http://www.google.com/bot.html)', 'Google robot from 66.249.66.xxx ', 'R'),
(789, 'Mozilla/4.0 (Mozilla; http://www.mozilla.org/docs/en/bot.html; master@mozilla.com)', 'Unknown robot from Mozilla.org', 'R'),
(790, 'Mozilla/4.0 (Sleek Spider/1.2)', 'ASI - Any Search Info robot', 'R'),
(791, 'Mozilla/4.0 compatible FurlBot/Furl Search 2.0 (FurlBot; http://www.furl.net; wn.furlbot@looksmart.net)', 'Furl (Looksmart) online bookmark tool robot', 'R'),
(792, 'Mozilla/4.0 compatible ZyBorg/1.0 (wn.zyborg@looksmart.net; http://www.WISEnutbot.com)', 'Wisenut robot', 'R'),
(793, 'Mozilla/4.0 compatible ZyBorg/1.0 (ZyBorg@WISEnutbot.com; http://www.WISEnutbot.com)', 'Wisenut robot', 'R'),
(794, 'Mozilla/4.0 compatible ZyBorg/1.0 Dead Link Checker (wn.zyborg@looksmart.net; http://www.WISEnutbot.com)', 'Wisenut robot', 'R'),
(795, 'Mozilla/4.0 compatible ZyBorg/1.0 for Homepage (ZyBorg@WISEnutbot.com; http://www.WISEnutbot.com)', 'Wisenut robot', 'R'),
(796, 'Mozilla/4.0 efp@gmx.net', 'Unknown robot from 66.230.140.xx (argon.oxeo.com) maybe an e-mail collector', 'S'),
(797, 'Mozilla/4.0 [en] (Ask Jeeves Corporate Spider)', 'Ask / Ask Jeeves robot', 'R'),
(798, 'Mozilla/4.0(compatible; Zealbot 1.0)', 'LookSmart spider', 'R'),
(799, 'Mozilla/4.04 (compatible; Dulance bot; +http://www.dulance.com/bot.jsp)', 'Dulance Bot - Dulance automated price comparison engine', 'R'),
(800, 'Mozilla/4.0_(compatible;_MSIE_5.0;_Windows_95)_TrueRobot/1.4 libwww/5.2.8', 'Echo.com robot', 'R'),
(801, 'Mozilla/4.0_(compatible;_MSIE_5.0;_Windows_95)_VoilaBot/1.6 libwww/5.3.2', 'Voila.fr robot', 'R'),
(802, 'Mozilla/4.6 [en] (http://www.cnet.com/)', 'Cnet robot for Search.com (216.239.114.xx)', 'R'),
(803, 'Mozilla/4.7', 'Nameprotect (12.148.196.128 - 12.148.196.255) snoopbot', 'R'),
(804, 'Mozilla/4.7 (compatible; http://eidetica.com/spider)', 'Eidetica earch and text mining spider', 'R'),
(805, 'Mozilla/4.7 (compatible; Intelliseek; http://www.intelliseek.com)', 'Intelliseek (64.158.138.xx) robot', 'R'),
(806, 'Mozilla/4.7 (compatible; Whizbang)', 'WhizBang! Labs information extraction robot', 'R'),
(807, 'Mozilla/4.7 (compatible; WhizBang; http://www.whizbang.com/crawler)', 'WhizBang! Labs information extraction robot', 'R'),
(808, 'Mozilla/4.7 [en](BecomeBot@exava.com)', 'BecomeBot - Becomecom shopping search (64.124.85.xx(x))', 'R'),
(809, 'Mozilla/4.7 [en](Exabot@exava.com)', 'Exabot - exava shopping search (64.124.85.xx(x))', 'R'),
(810, 'Mozilla/4.72 [en] (BACS http://www.ba.be)', 'http://www.ba.be robot', 'R'),
(811, 'Mozilla/5.0', 'GigaMedia / NTT DoCoMo robot', 'R'),
(812, 'Mozilla/5.0 (+http://www.eurekster.com/mammoth) Mammoth/0.1', 'Eurekster Swicki community search using SLI-Systems site search engine Mammoth', 'R'),
(813, 'Mozilla/5.0 (+http://www.sli-systems.com/) Mammoth/0.1', 'SLI Systems mammoth robot', 'R'),
(814, 'Mozilla/5.0 (Clustered-Search-Bot/1.0; support@clush.com; http://www.clush.com/)', 'Clush search robot', 'R'),
(815, 'Mozilla/5.0 (compatible; +http://www.evri.com/evrinid)', 'Evri search robot', 'R'),
(816, 'Mozilla/5.0 (compatible; Abonti/0.8 - http://www.abonti.com)', 'Abonti WebSearch beta robot', 'R'),
(817, 'Mozilla/5.0 (compatible; AnsearchBot/1.x; +http://www.ansearch.com.au/)', 'Ansearch Australian search robot', 'R'),
(818, 'Mozilla/5.0 (compatible; archive.org_bot/1.10.0 +http://www.loc.gov/minerva/crawl.html)', 'The Library of Congress Minerva crawler', 'R'),
(819, 'Mozilla/5.0 (compatible; archive.org_bot/1.13.1x http://crawler.archive.org)', 'Heritrix - The Internet Archive''s open-source crawler (207.241.225.2xx)', 'R'),
(820, 'Mozilla/5.0 (compatible; archive.org_bot/1.5.0-200506132127 http://crawler.archive.org) Hurricane Katrina', 'Heritrix - The Internet Archive''s open-source crawler', 'R'),
(821, 'Mozilla/5.0 (compatible; Ask Jeeves/Teoma;  http://about.ask.com/en/docs/about/webmasters.shtml)', 'Ask Jeeves /Teoma robot', 'R'),
(822, 'Mozilla/5.0 (compatible; BecomeBot/1.23; http://www.become.com/webmasters.html)', 'BecomeBot - Become.com shopping search (64.124.85.xx(x))', 'R'),
(823, 'Mozilla/5.0 (compatible; BecomeBot/1.xx; MSIE 6.0 compatible; http://www.become.com/webmasters.html)', 'BecomeBot - Become.com shopping search (64.124.85.xx(x))', 'R'),
(824, 'Mozilla/5.0 (compatible; BecomeBot/2.0beta; http://www.become.com/webmasters.html)', 'BecomeBot - Become.com shopping search (64.124.85.xx(x))', 'R'),
(825, 'Mozilla/5.0 (compatible; BecomeBot/2.x; MSIE 6.0 compatible; http://www.become.com/site_owners.html)', 'BecomeBot - Become.com shopping search (64.124.85.xx(x))', 'R'),
(826, 'Mozilla/5.0 (compatible; BecomeJPBot/2.3; MSIE 6.0 compatible; +http://www.become.co.jp/site_owners.html)', 'BecomeBot - Become.com shopping search (64.124.85.xx(x))', 'R'),
(827, 'Mozilla/5.0 (compatible; BlogRefsBot/0.1; http://www.blogrefs.com/about/bloggers)', 'BlogRefsBot.com blog robot', 'R'),
(828, 'Mozilla/5.0 (compatible; Bot; +http://pressemitteilung.ws/spamfilter', 'Pressemitteilungen Webservice RSS / news crawler (Germany)', 'R'),
(829, 'Mozilla/5.0 (compatible; BuzzRankingBot/1.0; +http://www.buzzrankingbot.com/)', 'BuzzRanking internet content analysis', 'R'),
(830, 'Mozilla/5.0 (compatible; Charlotte/1.0b; charlotte@betaspider.com)', 'Charlotte indexing spider for Searchme / Wikiseek', 'R'),
(831, 'Mozilla/5.0 (compatible; Charlotte/1.0b; http://www.searchme.com/support/)', 'Charlotte indexing spider for Searchme / Wikiseek', 'R'),
(832, 'Mozilla/5.0 (compatible; Crawling jpeg; http://www.yama.info.waseda.ac.jp)', 'Unknown graphics crawler or downloading agent from Yamana Laboratory - Waseda Univerity Japan (133.9.238.xx)', 'R'),
(833, 'Mozilla/5.0 (compatible; de/1.13.2 +http://www.de.com)', 'De.com German travel related search via Amazon Web Services', 'R'),
(834, 'Mozilla/5.0 (compatible; Diffbot/0.1; +http://www.diffbot.com)', 'Diffbot beta - RSS and news feed crawler', 'R'),
(835, 'Mozilla/5.0 (compatible; DNS-Digger-Explorer/1.0; +http://www.dnsdigger.com)', 'DNS-Digger - DNS server neighbourhood search', 'R'),
(836, 'Mozilla/5.0 (compatible; DNS-Digger/1.0; +http://www.dnsdigger.com)', 'DNS-Digger - DNS server neighbourhood search', 'R'),
(837, 'Mozilla/5.0 (compatible; EARTHCOM.info/2.01; http://www.earthcom.info)', 'Earthcom (Czech Republic) search robot (194.108.39.xx)', 'R'),
(838, 'Mozilla/5.0 (compatible; EARTHCOM/2.2; +http://enter4u.eu)', 'enter4u / Earthcom.info search (Czech Republic)', 'R'),
(839, 'Mozilla/5.0 (compatible; Exabot Test/3.0; +http://www.exabot.com/go/robot)', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(840, 'Mozilla/5.0 (compatible; FatBot 2.0; http://www.thefind.com/main/CrawlerFAQs.fhtml)', 'TheFind.com - Shopping search robot', 'R'),
(841, 'Mozilla/5.0 (compatible; Galbot/1.0; +http://www.galbot.com/bot.html)', 'Galbot tagging robot (beta) - Denmark', 'R'),
(842, 'mozilla/5.0 (compatible; genevabot http://www.healthdash.com)', 'Geneva Single-Site Search Engine used by Healthdash health search', 'R'),
(843, 'Mozilla/5.0 (compatible; Googlebot/2.1; http://www.google.com/bot.html)', 'Google robot', 'R'),
(844, 'mozilla/5.0 (compatible; heritrix/1.0.4 http://innovationblog.com)', 'Unknown robot using Heritrix', 'R'),
(845, 'Mozilla/5.0 (compatible; heritrix/1.10.2 +http://i.stanford.edu/)', 'The Stanford University InfoLab robot using Heritrix', 'R'),
(846, 'Mozilla/5.0 (compatible; heritrix/1.12.1 +http://newstin.com/)', 'Newstin news feed search using Heritrix', 'R'),
(847, 'Mozilla/5.0 (compatible; heritrix/1.12.1 +http://www.page-store.com)', 'Page-store.com vertical search via Amazon Web Services', 'R'),
(848, 'Mozilla/5.0 (compatible; heritrix/1.12.1 +http://www.page-store.com) [email:paul@page-store.com]', 'Page-store.com vertical search via Amazon Web Services', 'R'),
(849, 'mozilla/5.0 (compatible; heritrix/1.3.0 http://archive.crawler.org)', 'Heritrix Internet Archive''s open-source web project ', 'R'),
(850, 'Mozilla/5.0 (compatible; heritrix/1.4.0 +http://www.chepi.net)', 'Chepi Beta search Spain (194.116.240.1xx) using Heritrix', 'R'),
(851, 'Mozilla/5.0 (compatible; heritrix/1.4t http://www.truveo.com/)', 'Truveo data mining robot using Heritrix', 'R'),
(852, 'Mozilla/5.0 (compatible; heritrix/1.5.0 http://www.l3s.de/~kohlschuetter/projects/crawling/)', 'L3S WebCrawling Project (Germany) using Heritrix', 'R'),
(853, 'Mozilla/5.0 (compatible; heritrix/1.5.0-200506231921 http://pandora.nla.gov.au/crawl.html)', 'Pandora Internet Archive crawler (Australia) using Heritrix', 'R'),
(854, 'Mozilla/5.0 (compatible; heritrix/1.6.0 http://www.worio.com/)', 'WORIO (beta) search for computer scientists and programmers using Heritrix open-source crawler', 'R'),
(855, 'Mozilla/5.0 (compatible; heritrix/1.7.0 +http://www.greaterera.com/)', 'greatarea.com website collection project using Heritrix', 'R'),
(856, 'Mozilla/5.0 (compatible; heritrix/1.x.x +http://www.accelobot.com)', 'Accelobot - Accelovation Market Discovery software robot', 'R'),
(857, 'Mozilla/5.0 (compatible; heritrix/2.0.0-RC1 +http://www.aol.com)', 'Unknown AOL robot using Heritrix', 'R'),
(858, 'Mozilla/5.0 (compatible; Hermit Search. Com; +http://www.hermitsearch.com)', 'Hermits Search.com - Products and service search robot', 'R'),
(859, 'Mozilla/5.0 (compatible; HyperixScoop/1.3; +http://www.hyperix.com)', 'Hyperix vertical search crawler', 'R'),
(860, 'Mozilla/5.0 (compatible; IDBot/1.0; +http://www.id-search.org/bot.html)', 'ID-Search.org - Russian search project', 'R'),
(861, 'Mozilla/5.0 (compatible; InterseekWeb/3.x)', 'Najdi.si (Slovenia) search using Interseek/Web Interseek/API Search Engine', 'R'),
(862, 'Mozilla/5.0 (compatible; Konqueror/3.5; Linux) KHTML/3.5.5 (like Gecko) (Exabot-Thumbnails)', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(863, 'Mozilla/5.0 (compatible; LemSpider 0.1)', 'Lemur Consulting LemIR spider', 'R'),
(864, 'Mozilla/5.0 (compatible; MojeekBot/2.0; http://www.mojeek.com/bot.html)', 'Mojeek Search Preview robot (217.155.205.xx)', 'R'),
(865, 'Mozilla/5.0 (compatible; MSIE 6.0; Podtech Network; crawler_admin@podtech.net)', 'PodTech entertainment and video network crawler', 'R'),
(866, 'Mozilla/5.0 (compatible; OnetSzukaj/5.0; http://szukaj.onet.pl)', 'onet.pl Szukaj (Search) robot (213.180.128.1xx)', 'R'),
(867, 'Mozilla/5.0 (compatible; PalmeraBot; http://www.links24h.com/help/palmera) Version 0.001', 'PalmeraBot - Links24h.com search engine robot', 'R'),
(868, 'Mozilla/5.0 (compatible; pogodak.ba/3.x)', 'Pogodak search (Slovenia) robot via Interseek', 'R'),
(869, 'Mozilla/5.0 (compatible; Pogodak.hr/3.1)', 'Pogodak search (Slovenia) robot via Interseek', 'R'),
(870, 'Mozilla/5.0 (compatible; PWeBot/3.1; http://www.programacionweb.net/robot.php)', 'ProgramacionWeb.net PWeBot crawler (Argentina)', 'R'),
(871, 'Mozilla/5.0 (compatible; Quantcastbot/1.0; www.quantcast.com)', 'Quantcast - Open Internet Ratings Service', 'R'),
(872, 'Mozilla/5.0 (compatible; ScoutJet; +http://www.scoutjet.com/)', 'ScoutJet (Blekko) search web crawler', 'R'),
(873, 'Mozilla/5.0 (compatible; Scrubby/2.2;  http://www.scrubtheweb.com/)', 'Scrub the web robot (66.93.156.xx)', 'R'),
(874, 'Mozilla/5.0 (compatible; ShunixBot/1.x.x +http://www.shunix.com/robot.htm)', 'Shunixbot (France) beta / test semantic web indexing robot', 'R'),
(875, 'Mozilla/5.0 (compatible; ShunixBot/1.x; http://www.shunix.com/bot.htm)', 'Shunixbot (France) beta / test semantic web indexing robot', 'R'),
(876, 'Mozilla/5.0 (compatible; SkreemRBot +http://skreemr.com)', 'Skreemr - Audio search engine', 'R'),
(877, 'Mozilla/5.0 (compatible; SummizeBot +http://www.summize.com)', 'Summize - Opinion and review search robot', 'R'),
(878, 'Mozilla/5.0 (compatible; Synoobot/0.9; http://www.synoo.com/search/bot.html)', 'Synoo web directory robot', 'R'),
(879, 'Mozilla/5.0 (compatible; Theophrastus/x.x; http://users.cs.cf.ac.uk/N.A.Smith/theophrastus.php)', 'Theophrastus Internet Spider for a basic search engine project', 'R'),
(880, 'Mozilla/5.0 (compatible; TridentSpider/3.1)', 'Interseek - Java search engine technology used for Pogodak search', 'R'),
(881, 'Mozilla/5.0 (compatible; Vagabondo/2.1; webcrawler at wise-guys dot nl; http://webagent.wise-guys.nl/)', 'WiseGuys robot', 'R'),
(882, 'Mozilla/5.0 (compatible; Webduniabot/1.0; +http://search.webdunia.com/bot.aspx)', 'Webdunia search (India) robot', 'R'),
(883, 'Mozilla/5.0 (compatible; worio bot heritrix/1.10.0 +http://worio.com)', 'WORIO (beta) search for computer scientists and programmers using Heritrix open-source crawler', 'R'),
(884, 'Mozilla/5.0 (compatible; WoW Lemmings Kathune/2.0;http://www.wowlemmings.com/kathune.html)', 'Kathune spider for World of Warcraft guild data. Used to power WoW Lemmings', 'R'),
(885, 'Mozilla/5.0 (compatible; Yahoo! DE Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 'Yahoo / Inktomi search robot', 'R'),
(886, 'Mozilla/5.0 (compatible; Yahoo! Slurp China; http://misc.yahoo.com.cn/help.html)', 'Inktomi robot (202.160.180.xxx) for Yahoo China', 'R'),
(887, 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 'Inktomi robot for Yahoo (via 66.196.xx.xxx)', 'R'),
(888, 'Mozilla/5.0 (compatible; Yoono; http://www.yoono.com/)', 'Yoono - community based search (193.110.140.xxx / 194.0.179.[x]xx)', 'R'),
(889, 'Mozilla/5.0 (compatible; YoudaoBot/1.0; http://www.youdao.com/help/webmaster/spider/; )', 'Youdao search (China) robot', 'R'),
(890, 'Mozilla/5.0 (compatible; Zenbot/1.3; +http://zen.co.za/webmasters/)', 'Zenbot robot for the Southern African Zen search service', 'R'),
(891, 'Mozilla/5.0 (compatible; zermelo +http://www.powerset.com) [email:paul@page-store.com&#44;crawl@powerset.com]', 'Powerset Natural Language Search crawler (under development) using Heritrix via Amazon Web Services', 'R'),
(892, 'Mozilla/5.0 (compatible;archive.org_bot/1.7.1; collectionId=316; Archive-It; +http://www.archive-it.org)', 'Heritrix - The Internet Archive''s open-source crawler (207.241.225.2xx)', 'R'),
(893, 'Mozilla/5.0 (compatible;archive.org_bot/heritrix-1.9.0-200608171144 +http://pandora.nla.gov.au/crawl.html)', 'Wayback Machine Internet Archive crawler', 'R'),
(894, 'Mozilla/5.0 (compatible;MAINSEEK_BOT)', 'Mainseek search (Poland) robot', 'R'),
(895, 'Mozilla/5.0 (Slurp/cat; slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos - NBCi etc.) robot', 'R'),
(896, 'Mozilla/5.0 (Slurp/si; slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos - NBCi etc.) robot', 'R'),
(897, 'Mozilla/5.0 (Twiceler-0.9 http://www.cuill.com/twiceler/robot.html)', 'Twiceler experimental web crawler', 'R'),
(898, 'Mozilla/5.0 (Version: xxxx Type:xx)', 'Some spambot from Romania (82.208.139.1xx &amp; 86.123.65.xx) - Maybe email harvesting', 'S'),
(899, 'Mozilla/5.0 (wgao@genieknows.com)', 'GenieKnows.com search robot (64.5.245.xx / 64.5.220.xxx)', 'R'),
(900, 'Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.7.7) NimbleCrawler 1.11 obeys UserAgent NimbleCrawler For problems contact: crawler_at_dataalchemy.com', 'Healthline health related search robot (72.5.115.xx)', 'R'),
(901, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1) VoilaBot BETA 1.2 (support.voilabot@orange-ftgroup.com)', 'Voila.fr robot', 'R'),
(902, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1) VoilaBot BETA 1.2 (support.voilabot@orange-ftgroup.com)', 'Voila.fr robot', 'R'),
(903, 'Mozilla/5.0 (Windows;) NimbleCrawler 1.12 obeys UserAgent NimbleCrawler For problems contact: crawler@health', 'Healthline health related search robot (72.5.115.xx)', 'R'),
(904, 'Mozilla/5.0 (Windows;) NimbleCrawler 1.12 obeys UserAgent NimbleCrawler For problems contact: crawler@healthline.com', 'Healthline health related search robot (72.5.115.xx)', 'R'),
(905, 'Mozilla/5.0 URL-Spider', 'URL Spider - used by usww.net', 'R'),
(906, 'Mozilla/5.0 usww.com-Spider-for-w8.net', 'W8net spider', 'R'),
(907, 'Mozilla/5.0 wgao@genieknows.com', 'GenieKnows.com search robot (64.5.245.xx / 64.5.220.xxx)', 'R'),
(908, 'Mozilla/5.0 [en] (compatible; Gulper Web Bot 0.2.4 www.ecsl.cs.sunysb.edu/~maxim/cgi-bin/Link/GulperBot)', 'Yuntis : Collaborative Web Resource Categorization and Ranking Project robot', 'R'),
(909, 'MQbot metaquerier.cs.uiuc.edu/crawler', 'MetaExplorer project''s MetaQuerier robot', 'R'),
(910, 'MQBOT/Nutch-0.9-dev (MQBOT Nutch Crawler; http://falcon.cs.uiuc.edu; mqbot@cs.uiuc.edu)', 'MetaExplorer project''s MetaQuerier robot', 'R'),
(911, 'msnbot-media/1.0 (+http://search.msn.com/msnbot.htm)', 'MSN media search robot', 'R'),
(912, 'msnbot-Products/1.0 (+http://search.msn.com/msnbot.htm)', 'Windows Live product search (Beta) robot', 'R'),
(913, 'MSNBOT/0.xx (http://search.msn.com/msnbot.htm)', 'MSN Search robot - 131.107.xxx.xxx 204.95.96.xxx - 204.95.111.xxx 207.46.xxx.xxx', 'R'),
(914, 'msnbot/x.xx ( http://search.msn.com/msnbot.htm)', 'MSN Search robot - 131.107.xxx.xxx 204.95.96.xxx - 204.95.111.xxx 207.46.xxx.xxx', 'R'),
(915, 'MSNBOT_Mobile MSMOBOT Mozilla/2.0 (compatible; MSIE 4.02; Windows CE; Default)', 'Microsoft search for mobiles', 'R'),
(916, 'MSNPTC/1.0', 'MSN Search robot - 131.107.xxx.xxx 204.95.96.xxx - 204.95.111.xxx 207.46.xxx.xxx', 'R'),
(917, 'MSRBOT (http://research.microsoft.com/research/sv/msrbot)', 'Microsoft MSRBot', 'R'),
(918, 'multicrawler ( http://sw.deri.org/2006/04/multicrawler/robots.html)', 'MultiCrawler for DERI Galway''s Semantic Web Search Engine cluster', 'R'),
(919, 'MultiText/0.1', 'Virginia Tech Digital Library Research Laboratory robot', 'R'),
(920, 'MusicWalker2.0 ( http://www.somusical.com)', 'SoMusical! musical directory link checking', 'R'),
(921, 'MVAClient', 'Unknown bad bot from diff. Taiwanese IPs', 'S'),
(922, 'Mylinea.com Crawler 2.0', 'Mylinea France web catalogue crawler', 'R'),
(923, 'Naamah 1.0.1/Blogbot (http://blogbot.de/)', 'Blogbot (Germany) robot', 'R'),
(924, 'Naamah 1.0a/Blogbot (http://blogbot.de/)', 'Blogbot (Germany) robot', 'R'),
(925, 'NABOT/5.0', 'Naver Japan / Korea robot ', 'R'),
(926, 'nabot_1.0', 'Naver Japan / Korea robot ', 'R'),
(927, 'NameOfAgent (CMS Spider)', 'Badbot searching for Wordpress wp-login.php', 'S'),
(928, 'NASA Search 1.0', 'Unknown spambot / harvester from diff. IPs', 'S'),
(929, 'NationalDirectory-WebSpider/1.3', 'Nationaldirectory spider', 'R'),
(930, 'NationalDirectoryAddURL/1.0', 'Nationaldirectory spider', 'R'),
(931, 'NaverBot-1.0 (NHN Corp. / +82-2-3011-1954 / nhnbot@naver.com)', 'Naver Japan / Korea robot', 'R'),
(932, 'NaverBot_dloader/1.5', 'Naver Japan / Korea robot', 'R'),
(933, 'NavissoBot', 'Navisso closed beta robot (69.41.162.1xx)', 'R'),
(934, 'NavissoBot/1.7  (+http://navisso.com/)', 'Navisso closed beta robot (69.41.162.1xx)', 'R'),
(935, 'NCSA Beta 1 (http://vias.ncsa.uiuc.edu/viasarchivinginformation.html)', 'Vias Information Archival robot', 'R'),
(936, 'Nebullabot/2.2 (http://bot.nebulla.info)', 'Nebulla.info distributed crawler (Germany)', 'R'),
(937, 'NEC Research Agent -- compuman at research.nj.nec.com', 'NEC Researchindex robot - now CiteSeer.IST scientific document index', 'R'),
(938, 'Net-Seekr Bot/Net-Seekr Bot V1 (http://www.net-seekr.com)', 'Net Seekr search robot', 'R'),
(939, 'NetinfoBot/1.0 (http://netinfo.bg/netinfobot.html)', 'Netinfo.bg search (Bulgaria) robot', 'R'),
(940, 'NetLookout/2.24', 'Netlookout internet notifier', 'R'),
(941, 'Netluchs/0.8-dev ( ; http://www.netluchs.de/; ___don''t___spam_me_@netluchs.de)', 'Netluchs (Germany) search (193.164.8.xx)', 'R'),
(942, 'NetNoseCrawler/v1.0', 'unknown InCom (216.0.107.xx) robot', 'R'),
(943, 'Netprospector JavaCrawler', 'Netprospector metasearch software', 'R'),
(944, 'NetResearchServer(http://www.look.com)', 'Look.com robot (209.87.232.x)', 'R'),
(945, 'NetResearchServer/x.x(loopimprovements.com/robot.html)', 'IncyWincy search engine using DMOZ database', 'R');
INSERT INTO `[[dbprefix]]reports_crawlers_info` VALUES
(946, 'NetSeer/Nutch-0.9 (NetSeer Crawler; http://www.netseer.com; crawler@netseer.com)', 'NetSeer search (beta) crawler via Amazon Web Services - see also Teemer', 'R'),
(947, 'NetSprint -- 2.0', 'Wirtualna Polska / Netsprint search (Poland) robot', 'R'),
(948, 'NetWhatCrawler/0.06-dev (NetWhatCrawler from NetWhat.com; http://www.netwhat.com; support@netwhat.com)', 'NetWhat Search crawler (69.9.167.1xx)', 'R'),
(949, 'NetZippy', 'Netzippy robot', 'R'),
(950, 'NextGenSearchBot 1 (for information visit http://www.eliyon.com/NextGenSearchBot)', 'Eliyon Crawler for Business People Search', 'R'),
(951, 'NextopiaBOT (+http://www.nextopia.com) distributed crawler client beta v0.x', 'Nextopia crawler', 'R'),
(952, 'NG-Search/0.90 (NG-SearchBot; http://www.ng-search.com;  )', 'find your keywords - semantic search (Germany) robot', 'R'),
(953, 'NG/1.0', 'Exalead (France) search robot (193.47.80.xx)', 'R'),
(954, 'NG/4.0.1229', 'Exalead Websearch image crawler (193.47.80.xx)', 'R'),
(955, 'NITLE Blog Spider/0.01', 'Experimental LSI (?) robot from 140.233.69.xx (Middlebury.edu)', 'R'),
(956, 'Noago Spider', 'Noago spider', 'R'),
(957, 'Nokia-WAPToolkit/1.2 googlebot(at)googlebot.com', 'Google WAP robot', 'R'),
(958, 'Nokia6610/1.0 (3.09) Profile/MIDP-1.0 Configuration/CLDC-1.0 (compatible;YahooSeeker/M1A1-R2D2; http://help.yahoo.com/help/us/ysearch/crawling/crawling-01.html)', 'YahooSeeker/M1A1-R2D2 - Yahoo mobile web crawling robot', 'R'),
(959, 'NokodoBot/1.x (+http://nokodo.com/bot.htm)', 'Nokodo public beta search robot (67.18.222.xx)', 'R'),
(960, 'Norbert the Spider(Burf.com)', 'Burf.com UK Search Engine robot', 'R'),
(961, 'noxtrumbot/1.0 (crawler@noxtrum.com)', 'noXtrum search robot (Spain)', 'R'),
(962, 'noyona_0_1', 'Noyona job search (preview)', 'R'),
(963, 'NP/0.1 (NP; http://www.nameprotect.com; npbot@nameprotect.com)', 'Nameprotect copyright search robot (24.177.134.x)', 'R'),
(964, 'NPBot (http://www.nameprotect.com/botinfo.html)', 'Nameprotect copyright search robot (24.177.134.x)', 'R'),
(965, 'NPBot-1/2.0', 'Nameprotect copyright search robot (24.177.134.x)', 'R'),
(966, 'Nsauditor/1.x', 'Nsauditor Network Security Auditor', 'S'),
(967, 'nsyght.com/Nutch-1.0-dev (nsyght.com; Nsyght.com)', 'Nsyght social search application', 'R'),
(968, 'nsyght.com/Nutch-x.x (nsyght.com; search.nsyght.com)', 'Nsyght social search application', 'R'),
(969, 'nttdirectory_robot/0.9 (super-robot@super.navi.ocn.ne.jp)', 'NTT Directory robot', 'R'),
(970, 'nuSearch Spider &lt;a href=''http://www.nusearch.com''>www.nusearch.com&lt;/a> (compatible; MSIE 4.01)', 'nuSearch spider (84.9.136.xxx)', 'R'),
(971, 'NuSearch Spider (compatible; MSIE 6.0)', 'nuSearch spider (84.9.136.xxx)', 'R'),
(972, 'NuSearch Spider www.nusearch.com', 'nuSearch spider (84.9.136.xxx)', 'R'),
(973, 'Nutch', 'Nutch open source robot', 'R'),
(974, 'Nutch crawler/Nutch-0.9 (picapage.com; admin@picapage.com)', 'Picapage search for handheld devices using Nutch', 'R'),
(975, 'Nutch/Nutch-0.9 (Eurobot; http://www.ayell.eu )', 'Ayell Euronet business directory robot using Nutch', 'R'),
(976, 'NutchCVS/0.0x-dev (Nutch; http://www.nutch.org/docs/bot.html; nutch-agent@lists.sourceforge.net)', 'Nutch open source robot', 'R'),
(977, 'NutchCVS/0.7.1 (Nutch running at UW; http://www.nutch.org/docs/en/bot.html; sycrawl@cs.washington.edu)', 'Robot from University of Washington Computer Science &amp; Engineering (128.208.6.2xx)', 'R'),
(978, 'NutchEC2Test/Nutch-0.9-dev (Testing Nutch on Amazon EC2.; http://lucene.apache.org/nutch/bot.html; ec2test at lucene.com)', 'Amazon Elastic Compute Cloud (Amazon EC2) robot', 'R'),
(979, 'NutchOrg/0.0x-dev (Nutch; http://www.nutch.org/docs/bot.html; nutch-agent@lists.sourceforge.net)', 'Nutch open source robot', 'R'),
(980, 'nutchsearch/Nutch-0.9 (Nutch Search 1.0; herceg_novi at yahoo dot com)', 'Unknown robot using Nutch (maybe private crawling) via Cox network (70.187.130.25x)', 'R'),
(981, 'NutchVinegarCrawl/Nutch-0.8.1 (Vinegar; http://www.cs.washington.edu; eytanadar at gmail dot com)', 'Unknown crawler from University of Washington - Computer science', 'R'),
(982, 'obidos-bot (just looking for books.)', 'Weblog bookwatch robot', 'R'),
(983, 'ObjectsSearch/0.01-dev (ObjectsSearch;http://www.ObjectsSearch.com/bot.html; support@thesoftwareobjects.com)', 'Objects Search robot', 'R'),
(984, 'ObjectsSearch/0.0x (ObjectsSearch; http://www.ObjectsSearch.com/bot.html; support@thesoftwareobjects.com)', 'Objects Search robot', 'R'),
(985, 'oBot ((compatible;Win32))', 'Cobion Germany Brand Protection Services robot', 'R'),
(986, 'Ocelli/1.x (http://www.globalspec.com/Ocelli)', 'GlobalSpec Engineering Search robot (66.194.55.xxx)', 'R'),
(987, 'Octora Beta - www.octora.com', 'Octora blog or RSS information crawler - beta (66.228.114.xx)', 'R'),
(988, 'Octora Beta Bot - www.octora.com', 'Octora RSS feed search', 'R'),
(989, 'OmniExplorer_Bot/1.0x (+http://www.omni-explorer.com) Internet CategorizerOmniExplorer http://www.omni-explorer.com/ car &amp; shopping search (64.62.175.xxx)', 'OmniExplorer car &amp; shopping search (64.62.175.xxx)', 'R'),
(990, 'OmniExplorer_Bot/1.0x (+http://www.omni-explorer.com) Job Crawler', 'OmniExplorer car &amp; shopping search (64.62.175.xxx)', 'R'),
(991, 'OmniExplorer_Bot/1.1x (+http://www.omni-explorer.com) Torrent Crawler', 'OmniExplorer car &amp; shopping search (64.62.175.xxx)', 'R'),
(992, 'OmniExplorer_Bot/x.xx (+http://www.omni-explorer.com) WorldIndexer', 'OmniExplorer car &amp; shopping search (64.62.175.xxx)', 'R'),
(993, 'Onet.pl SA- http://szukaj.onet.pl', 'onet.pl Szukaj (Search) robot (213.180.128.1xx)', 'R'),
(994, 'OntoSpider/1.0 libwww-perl/5.65', 'OntoSpider - Dutch robot for a research project. (195.11.244.xx)', 'R'),
(995, 'OpenAcoon v4.0.x (www.openacoon.de)', 'OpenAcoon open source search engine (used by Acoon search)', 'R'),
(996, 'Openbot/3.0+(robot-response@openfind.com.tw;+http://www.openfind.com.tw/robot.html)', 'Openfind.com.tw robot', 'R'),
(997, 'Openfind data gatherer- Openbot/3.0+(robot-response@openfind.com.tw;+http://www.openfind.com.tw/robot.html)', 'Openfind.com.tw robot', 'R'),
(998, 'Openfind Robot/1.1A2', 'Openfind.com.tw robot', 'R'),
(999, 'OpenISearch/1.x (www.openisearch.com)', 'open i search robot  - search engine in development', 'R'),
(1000, 'OpenTaggerBot (http://www.opentagger.com/opentaggerbot.htm)', 'Opentagger social bookmarking system', 'R'),
(1001, 'OpenTextSiteCrawler/2.9.2', 'OpenText crawler', 'R'),
(1002, 'OpenWebSpider/0.x.x (http://www.openwebspider.org)', 'OpenWebSpider - Open Source web search engine', 'R'),
(1003, 'OpenWebSpider/x', 'OpenWebSpider - Open Source web search engine', 'R'),
(1004, 'OpidooBOT (larbin2.6.3@unspecified.mail)', 'Opidoo Search Belgium robot (62.4.83.xxx)', 'R'),
(1005, 'Oracle Ultra Search', 'Oracle Search', 'R'),
(1006, 'OrangeSpider', 'Orangeslicer semantic search (Beta) Germany (193.201.52.1xx)', 'R'),
(1007, 'Orbiter/T-2.0 (+http://www.dailyorbit.com/bot.htm)', 'Orbiter - DailyOrbit search spider', 'R'),
(1008, 'Overture-WebCrawler/3.8/Fresh (atw-crawler at fast dot no; http://fast.no/support/crawler.asp)', 'Overture/Fast/Alltheweb crawler (66.77.73.xxx)', 'R'),
(1009, 'ozelot/2.7.3 (Search engine indexer; www.flying-cat.de/ozelot; ozelot@flying-cat.de)', 'Ozelot - Flying Cat''s search engine robot (Germany)', 'R'),
(1010, 'PADLibrary Spider', 'PADLibrary.com - PAD file software robot for FindFiles.com', 'R'),
(1011, 'PageBitesHyperBot/600 (http://www.pagebites.com/)', 'Pagebites job search crawler', 'R'),
(1012, 'Pagebull http://www.pagebull.com/', 'Pagebull visual search engine', 'R'),
(1013, 'page_verifier (http://www.securecomputing.com/goto/pv)', 'Secure Computing SmartFilter Tools - malware crawler', 'R'),
(1014, 'parallelContextFocusCrawler1.1parallelContextFocusCrawler1.1', 'CFC crawler used by Italian academic and research network (GARR)', 'R'),
(1015, 'ParaSite/1.0b (http://www.ianett.com/parasite/)', 'http://www.ianett.com robot', 'R'),
(1016, 'Patwebbot (http://www.herz-power.de/technik.html)', 'Patsearch (Germany) robot', 'R'),
(1017, 'PBrowse 1.4b', 'Some site scanning tool via diff. IPs- i.e.: - cox.net (68.4.xxx.xxx)', 'S'),
(1018, 'pd02_1.0.0 pd02_1.0.0@dzimi@post.sk', 'Post.sk / Eurotel.sk robot', 'R'),
(1019, 'PEERbot www.peerbot.com', 'Peerbot - favicon search robot', 'R'),
(1020, 'PEval 1.4b', 'Some site scanning tool via diff. IPs', 'S'),
(1021, 'PicoSearch/1.0', 'Pico Search robot', 'R'),
(1022, 'Piffany_Web_Scraper_v0.x', 'Piffany targeted search web spider', 'R'),
(1023, 'Piffany_Web_Spider_v0.x', 'Piffany targeted search web spider', 'R'),
(1024, 'pipeLiner/0.3a (PipeLine Spider;http://www.pipeline-search.com/webmaster.html; webmaster''at''pipeline-search.com)', 'pipeline search (DMOZ based) search robot (24.106.39. xxx)', 'R'),
(1025, 'pipeLiner/0.xx (PipeLine Spider; http://www.pipeline-search.com/webmaster.html)', 'pipeline search (DMOZ based) search robot (24.106.39. xxx)', 'R'),
(1026, 'Pita', 'Pita crawler', 'R'),
(1027, 'PJspider/3.0 (pjspider@portaljuice.com; http://www.portaljuice.com)', 'Portaljuice spider', 'R'),
(1028, 'PlagiarBot/1.0', 'unknown ucsd.edu robot', 'R'),
(1029, 'PluckFeedCrawler/2.0 (compatible; Mozilla 4.0; MSIE 5.5; http://www.pluck.com; 1 subscribers)', 'Pluck RSS feed crawler', 'R'),
(1030, 'Pluggd/Nutch-0.9 (automated crawler http://www.pluggd.com;support at pluggd dot com)', 'Pluggd Podcast search engine', 'R'),
(1031, 'Poirot', 'ThePlanet/jaja-jak-globusy.com Google Adsense refferer spam bot from 70.85.116.* / 70.84.128.xxx / 70.85.193.xxx', 'S'),
(1032, 'polybot 1.0 (http://cis.poly.edu/polybot/)', 'Polybot webcrawler', 'R'),
(1033, 'Pompos/1.x http://dir.com/pompos.html', 'Dir.com / Iliad French recherche robot', 'R'),
(1034, 'Pompos/1.x pompos@iliad.fr', 'Iliad / Free French recherche robot', 'R'),
(1035, 'Popdexter/1.0', 'Popdex - web site popularity crawler', 'R'),
(1036, 'Port Huron Labs', 'Unknown spam bot / harvester (63.223.10.***)', 'S'),
(1037, 'PortalBSpider/2.0 (spider@portalb.com)', 'PortalB (now Alacra search) spider', 'R'),
(1038, 'potbot 1.0', 'Potbot : A simple IRC bot written in Perl', 'R'),
(1039, 'PRCrawler/Nutch-0.9 (data mining development project; crawler@projectrialto.com)', 'Project Rialto - data mining development project', 'R'),
(1040, 'PrivacyFinder Cache Bot v1.0', 'CUPS robot for AT&amp;T Privacy Bird Privacy Preferences (P3P) enhancements', 'R'),
(1041, 'PrivacyFinder/1.1', 'CUPS robot for AT&amp;T Privacy Bird Privacy Preferences (P3P) enhancements', 'R'),
(1042, 'Production Bot 0116B', 'Some site scanning tool from diff. IPs- i.e.: - 67.99.33.x (lightningcon.broadwing.net)', 'S'),
(1043, 'Production Bot 2016B', 'Some site scanning tool from diff. IPs- i.e.: - 216.232.64.xx (telus.net)', 'S'),
(1044, 'Production Bot DOT 3016B', 'Some site scanning tool from diff. IPs- i.e.: - 141.154.181.xxx (east.verizon.net)', 'S'),
(1045, 'Program Shareware 1.0.2', 'Some spam bot', 'S'),
(1046, 'Project XP5 [2.03.07-111203]', 'XP5 robot', 'R'),
(1047, 'PROve AnswerBot 4.0', 'Answerchase PROve Answerbot', 'R'),
(1048, 'ProWebGuide Link Checker (http://www.prowebguide.com)', 'ProWebguide robot', 'R'),
(1049, 'psbot/0.1 (+http://www.picsearch.com/bot.html)', 'Picsearch robot (62.119.21.13x)', 'R'),
(1050, 'PSurf15a 11', 'Some site scanning tool via diff. IPs- i.e.: QWest Net', 'S'),
(1051, 'PSurf15a 51', 'Some site scanning tool via diff. IPs- i.e.: Optonline net (24.191.xxx.xxx)', 'S'),
(1052, 'PSurf15a VA', 'Some site scanning tool via diff. IPs- i.e.: - choiceone.net (216.153.xxx.xxx) - attbi.com (12.250.xxx.xxx) - optonline.net (24.191.xxx.xxx)', 'S'),
(1053, 'psycheclone', 'Unknown website grabbing / ripping for unknown purposes from 208.66.195.x - Digitalinfinity.org Russia', 'S'),
(1054, 'PubCrawl (pubcrawl.stanford.edu)', 'Some robot from Stanford University (171.64.75.xxx = PubCrawl.Stanford.EDU)', 'R'),
(1055, 'pulseBot (pulse Web Miner)', 'WebarooBot - Webaroo web site search / theme based downloading tool (64.124.122.2xx)', 'R'),
(1056, 'PWeBot/1.2 Inspector (http://www.programacionweb.net/robot.php)', 'ProgramacionWeb.net PWeBot link checking (Argentina)', 'R'),
(1057, 'PycURL', 'Fast Search robot (using PycURL Python component- s. below)', 'R'),
(1058, 'Python-urllib/1.1x', 'Python URL fetcher - robot used by Naver Japan/Korea', 'R'),
(1059, 'Python-urllib/2.0a1', 'Python URL fetcher - robot used by Google', 'R'),
(1060, 'Qango.com Web Directory (http://www.qango.com/)', 'Qango.com Web Directory robot', 'R'),
(1061, 'QEAVis Agent/Nutch-0.9 (Quantitative Evaluation of Academic Websites Visibility; http://nlp.uned.es/qeavis', 'QEAVis: Quantitative Evaluation of Academic Websites Visibility using Nutch', 'R'),
(1062, 'QPCreep Test Rig ( We are not indexing- just testing )', 'Quepasa!com (Latin American search) robot', 'R'),
(1063, 'QuepasaCreep ( crawler@quepasacorp.com )', 'Quepasa!com (Latin American search) robot', 'R'),
(1064, 'QuepasaCreep v0.9.1x', 'Quepasa!com (Latin American search) robot', 'R'),
(1065, 'QueryN Metasearch', 'QueryN Metasearch robot', 'R'),
(1066, 'QweeryBot/3.01 ( http://qweerybot.qweery.nl)', 'Qweerybot for the Qweery search engine (in development) - Netherland', 'R'),
(1067, 'Qweery_robot.txt_CheckBot/3.01 (http://qweerybot.qweery.com)', 'Qweerybot for the Qweery search engine (in development) - Netherland', 'R'),
(1068, 'R6_CommentReader_(www.radian6.com/crawler)', 'Radian6 RSS feed comment crawler', 'R'),
(1069, 'R6_FeedFetcher_(www.radian6.com/crawler)', 'Radian6 Rss feed crawler', 'R'),
(1070, 'rabaz (rabaz at gigabaz dot com)', 'gigaBaz - the brainbot (Germany) robot', 'R'),
(1071, 'RaBot/1.0 Agent-admin/phortse@hanmail.net', 'DAUMOA - Daum search Korea robot (211.115.109.xxx)', 'R'),
(1072, 'ramBot xtreme x.x', 'Intersearch.de (was www.intersearch.de) robot (Germany)', 'R'),
(1073, 'RAMPyBot - www.giveRAMP.com/0.1 (RAMPyBot - www.giveRAMP.com; http://www.giveramp.com/bot.html; support@giveRAMP.com)', 'giveRAMP Search Engine robot (64.69.43.1xx)', 'R'),
(1074, 'RAMPyBot/0.8-dev (Nutch; http://lucene.apache.org/nutch/bot.html; nutch-agent@lucene.apache.org)', 'giveRAMP Search Engine robot (64.69.43.1xx)', 'R'),
(1075, 'Rankivabot/3.2 (www.rankiva.com; 3.2; vzmxikn)', 'Rankiva website popularity robot', 'R'),
(1076, 'Rational SiteCheck (Windows NT)', 'Innova/IBM Rational SiteCheck - Rational robot', 'R'),
(1077, 'Reaper [2.03.10-031204] (http://www.sitesearch.ca/reaper/)', 'Reaper robot for SiteSearch', 'R'),
(1078, 'Reaper/2.0x (+http://www.sitesearch.ca/reaper)', 'Reaper robot for SiteSearch', 'R'),
(1079, 'RedCarpet/1.2 (http://www.redcarpet-inc.com/robots.html)', 'RedCarpet crawler for Pronto price comparison search(66.179.107.1xx)', 'R'),
(1080, 'RedCell/0.1 (InfoSec Search Bot (Coming Soon); http://www.telegenetic.net/bot.html; lhall@telegenetic.net)', 'Der Bot for telegenetic.net''s security related search (65.220.67.2xx)', 'R'),
(1081, 'RedCell/0.1 (RedCell; telegenetic.net/bot.html; lhall_at_telegenetic.net)', 'Der Bot for telegenetic.net''s security related search (65.220.67.2xx)', 'R'),
(1082, 'RedKernel WWW-Spider 2/0 (+http://www-spider.redkernel-softwares.com/)', 'RedKernel Softwares robot', 'R'),
(1083, 'rico/0.1', 'Applied Semantics Auto-Categorizer for QWestDex Direct', 'R'),
(1084, 'RixBot (http://babelserver.org/rix)', 'RixBot Rebol Indexer for the RIX - Rebol related search (195.204.121.xx)', 'R'),
(1085, 'RoboCrawl (http://www.canadiancontent.net)', 'Canadian Content search crawler', 'R'),
(1086, 'RoboCrawl (www.canadiancontent.net)', 'Canadian Content Search (207.44.220.xx) robot', 'R'),
(1087, 'RoboPal (http://www.findpal.com/)', 'FindPal Australia metasearch robot (61.68.139.xx)', 'R'),
(1088, 'Robot/www.pj-search.com', 'PopJapanSearch robot', 'R'),
(1089, 'Robot: NutchCrawler- Owner: wdavies@acm.org', 'Experimental robot using Wget via attbi.net', 'R'),
(1090, 'Robot@SuperSnooper.Com', 'Supersnooper robot', 'R'),
(1091, 'Robozilla/1.0', 'Netscape Directory / DMOZ Open Directory link crawler', 'R'),
(1092, 'Rotondo/3.1 libwww/5.3.1', 'Qualigo.de robot', 'R'),
(1093, 'RRC (crawler_admin@bigfoot.com)', 'Metacarta.com (66.28.xx.xxx) robot', 'R'),
(1094, 'RSSMicro.com RSS/Atom Feed Robot', 'RSS Micro Search - RSS feed search engine', 'R'),
(1095, 'RSurf15a 41', 'Some site scanning tool via diff. IPs- i.e.: - dslx.net (208.35.1x.xxx) - Home.com', 'S'),
(1096, 'RSurf15a 51', 'Some site scanning tool via diff. IPs- i.e.: - dslx.net (208.35.1x.xxx) - Home.com', 'S'),
(1097, 'RSurf15a 81', 'Some site scanning tool via diff. IPs- i.e.: - dslx.net (208.35.1x.xxx) - Home.com', 'S'),
(1098, 'RufusBot (Rufus Web Miner; http://64.124.122.252/feedback.html)', 'WebarooBot - Webaroo web site search / theme based downloading tool (64.124.122.2xx)', 'R'),
(1099, 'RufusBot (Rufus Web Miner; http://www.webaroo.com/rooSiteOwners.html)', 'WebarooBot - Webaroo web site search / theme based downloading tool (64.124.122.2xx)', 'R'),
(1100, 'sait/Nutch-0.9 (SAIT Research; http://www.samsung.com)', 'sait robot - unknown robot from Samsung International Korea', 'R'),
(1101, 'SandCrawler - Compatibility Testing', 'Sandcrawler robot from Microsoft (131.107.0.xx)', 'R'),
(1102, 'SapphireWebCrawler/1.0 (Sapphire Web Crawler using Nutch; http://boston.lti.cs.cmu.edu/crawler/; mhoy@cs.cmu.edu)', 'Sapphire Web Crawler from Carnegie Mellon University''s Language Technologies Institute', 'R'),
(1103, 'SapphireWebCrawler/Nutch-1.0-dev (Sapphire Web Crawler using Nutch; http://boston.lti.cs.cmu.edu/crawler/; mhoy@cs.cmu.edu)', 'Sapphire Web Crawler from Carnegie Mellon University''s Language Technologies Institute', 'R'),
(1104, 'savvybot/0.2', 'WebSavvy Directory robot', 'R'),
(1105, 'SBIder/0.7 (SBIder; http://www.sitesell.com/sbider.html; http://support.sitesell.com/contact-support.html)', 'SiteSell SBIder Nutch based crawler', 'R'),
(1106, 'SBIder/0.8-dev (SBIder; http://www.sitesell.com/sbider.html; http://support.sitesell.com/contact-support.html)', 'SiteSell SBIder Nutch based crawler', 'R'),
(1107, 'ScanWeb', 'ScanWeb - regular expression based web page searching tool', 'R'),
(1108, 'ScholarUniverse/0.8 (Nutch;+http://scholaruniverse.com/bot.jsp; fetch-agent@scholaruniverse.com)', 'ScholarUniverse - Scholarly experts search robot', 'R'),
(1109, 'schwarzmann.biz-Spider_for_paddel.org+(http://www.innerprise.net/usp-spider.asp)', 'URL Spider Pro (USP) used by German Schwarzmann GmbH', 'R'),
(1110, 'ScollSpider/2.0 (+http://www.webwobot.com/ScollSpider.php)', 'WebWobot UK search engine robot (82.43.129.2xx)', 'R'),
(1111, 'Scooter-3.0.EU', 'Altavista robot', 'R'),
(1112, 'Scooter-3.0.FS', 'Altavista robot', 'R'),
(1113, 'Scooter-3.0.HD', 'Altavista robot', 'R'),
(1114, 'Scooter-3.0.VNS', 'Altavista robot', 'R'),
(1115, 'Scooter-3.0QI', 'Altavista robot', 'R'),
(1116, 'Scooter-3.2', 'Altavista robot', 'R'),
(1117, 'Scooter-3.2.BT', 'Altavista robot', 'R'),
(1118, 'Scooter-3.2.DIL', 'Altavista robot', 'R'),
(1119, 'Scooter-3.2.EX', 'Altavista robot', 'R'),
(1120, 'Scooter-3.2.JT', 'Altavista robot', 'R'),
(1121, 'Scooter-3.2.NIV', 'Altavista robot', 'R'),
(1122, 'Scooter-3.2.SF0', 'Altavista robot', 'R'),
(1123, 'Scooter-3.2.snippet', 'Altavista robot', 'R'),
(1124, 'Scooter-3.3dev', 'Altavista robot', 'R'),
(1125, 'Scooter-ARS-1.1', 'Altavista robot', 'R'),
(1126, 'Scooter-ARS-1.1-ih', 'Altavista robot', 'R'),
(1127, 'scooter-venus-3.0.vns', 'Altavista robot', 'R'),
(1128, 'Scooter-W3-1.0', 'Altavista robot', 'R'),
(1129, 'Scooter-W3.1.2', 'Altavista robot', 'R'),
(1130, 'Scooter/1.0', 'Altavista robot', 'R'),
(1131, 'Scooter/1.0 scooter@pa.dec.com', 'Altavista robot', 'R'),
(1132, 'Scooter/1.1 (custom)', 'Altavista robot', 'R'),
(1133, 'Scooter/2.0 G.R.A.B. V1.1.0', 'Altavista robot', 'R'),
(1134, 'Scooter/2.0 G.R.A.B. X2.0', 'Altavista robot', 'R'),
(1135, 'Scooter/3.3', 'Altavista robot', 'R'),
(1136, 'Scooter/3.3.QA.pczukor', 'Altavista robot', 'R'),
(1137, 'Scooter/3.3.vscooter', 'Altavista robot', 'R'),
(1138, 'Scooter/3.3_SF', 'Altavista robot', 'R'),
(1139, 'Scooter2_Mercator_x-x.0', 'Altavista using Mercator robot', 'R'),
(1140, 'Scooter_bh0-3.0.3', 'Altavista robot', 'R'),
(1141, 'Scooter_trk3-3.0.3', 'Altavista robot', 'R'),
(1142, 'ScoutAbout', 'Some nec.com robot using Research Republic ScoutAbout Research Tool', 'R'),
(1143, 'ScoutAnt/0.1; +http://www.ant.com/what_is_ant.com/', 'Ant.com search robot', 'R'),
(1144, 'scoutmaster', 'ScoutMaster information retrieval software', 'R'),
(1145, 'Scrubby/2.x (http://www.scrubtheweb.com/)', 'Scrub the web robot (66.93.156.xx)', 'R'),
(1146, 'Scrubby/3.0 (+http://www.scrubtheweb.com/help/technology.html)', 'Scrub the web robot (66.93.156.xx)', 'R'),
(1147, 'Search+', 'URL Search+ search software', 'R'),
(1148, 'Search-Engine-Studio', 'Xtreem Search Engine Studio - SE software', 'R'),
(1149, 'search.ch V1.4', 'Search.ch robot', 'R'),
(1150, 'search.ch V1.4.2 (spiderman@search.ch; http://www.search.ch)', 'Search.ch robot', 'R'),
(1151, 'Search/1.0 (http://www.innerprise.net/es-spider.asp)', 'Enterprise Search web indexing / site searching tool', 'R'),
(1152, 'searchbot admin@google.com', 'Unknown robot  / website grabber from Chinatelecom (219.142.78.xxx)', 'S'),
(1153, 'SearchByUsa/2 (SearchByUsa; http://www.SearchByUsa.com/bot.html; info@SearchByUsa.com)', 'SearchByUSA robot (69.150.7.xxx)', 'R'),
(1154, 'SearchdayBot', 'Searchday (Germany) search robot', 'R'),
(1155, 'SearchExpress Spider0.99', 'Searchexpress spider', 'R'),
(1156, 'SearchGuild/DMOZ/Experiment (searchguild@gmail.com)', 'Searchguild forum &amp; directory robot (81.3.75.xxx)', 'R'),
(1157, 'SearchGuild_DMOZ_Experiment (chris@searchguild.com)', 'Searchguild forum &amp; directory robot (81.3.75.xxx)', 'R'),
(1158, 'Searchit-Now Robot/2.2 (+http://www.searchit-now.co.uk)', 'Searchit robot (69.93.107.xx)', 'R'),
(1159, 'Searchmee! Spider v0.98a', 'Searchmee!  Search Engine (prototype) robot by findanisp.com', 'R'),
(1160, 'SearchSight/2.0 (http://SearchSight.com/)', 'SearchSight search robot', 'R'),
(1161, 'SearchSpider.com/1.1', 'SearchSpider robot', 'R'),
(1162, 'Searchspider/1.2 (SearchSpider; http://www.searchspider.com; webmaster@searchspider.com)', 'SearchSpider robot', 'R'),
(1163, 'SearchTone2.0 - IDEARE', 'Janas (Ideare.com / Tiscali.it) robot', 'R'),
(1164, 'Seekbot/1.0 (http://www.seekbot.net/bot.html) HTTPFetcher/0.3', 'seekport. beta search (Germany) robot', 'R'),
(1165, 'Seekbot/1.0 (http://www.seekbot.net/bot.html) RobotsTxtFetcher/1.0 (XDF)', 'seekport. beta search (Germany) robot', 'R'),
(1166, 'Seekbot/1.0 (http://www.seekbot.net/bot.html) RobotsTxtFetcher/1.2', 'seekport. beta search (Germany) robot', 'R'),
(1167, 'Seeker.lookseek.com', 'Lookseek search robot / link checking', 'R'),
(1168, 'Semager/1.1 (http://www.semager.de/blog/semager-bots/)', 'Semager.de (was NG-Search) semantic search - Germany', 'R'),
(1169, 'Semager/1.x (http://www.semager.de)', 'Semager.de (was NG-Search) semantic search - Germany', 'R'),
(1170, 'Sensis Web Crawler (search_comments\\at\\sensis\\dot\\com\\dot\\au)', 'Sensis Australia search robot', 'R'),
(1171, 'Sensis.com.au Web Crawler (search_comments\\at\\sensis\\dot\\com\\dot\\au)', 'Sensis Australia search robot', 'R'),
(1172, 'SeznamBot/1.0', 'Seznam Search (Czech Republic) robot', 'R'),
(1173, 'SeznamBot/1.0 (+http://fulltext.seznam.cz/)', 'Seznam Search (Czech Republic) robot', 'R'),
(1174, 'SeznamBot/2.0-test (+http://fulltext.sblog.cz/)', 'Seznam Search (Czech Republic) robot', 'R'),
(1175, 'ShablastBot 1.0', 'Unknown robot from Shablast.com - Website has no content - Ignores robots.txt', 'S'),
(1176, 'Shim Crawler', 'Chikayama-Taura Lab Shim-Crawler used for The Kototoi Project (Japan) - (133.11.36.xx)', 'R'),
(1177, 'Shim-Crawler(Mozilla-compatible; http://www.logos.ic.i.u-tokyo.ac.jp/crawler/; crawl@logos.ic.i.u-tokyo.ac.jp)', 'Chikayama-Taura Lab Shim-Crawler used for The Kototoi Project (Japan) - (133.11.36.xx)', 'R'),
(1178, 'ShopWiki/1.0 ( +http://www.shopwiki.com/)', 'ShopWiki shopping search based on LittleWiki search', 'R'),
(1179, 'ShopWiki/1.0 ( +http://www.shopwiki.com/wiki/Help:Bot)', 'ShopWiki shopping search based on LittleWiki search', 'R'),
(1180, 'Shoula.com Crawler 2.0', 'Shoula Search Engine crawler', 'R'),
(1181, 'SietsCrawler/1.1 (+http://www.siets.biz)', 'Siets Crawler - Web based site crawling application', 'R'),
(1182, 'Sigram/Nutch-1.0-dev (Test agent for Nutch development; http://www.sigram.com/bot.html; bot at sigram dot com)', 'Sigram''s Nutch robot - crawler testing', 'R'),
(1183, 'Siigle Orumcex v.001 Turkey (http://www.siigle.com)', 'Siigle search (Turkey) robot', 'R'),
(1184, 'silk/1.0', 'Slider Search directory robot (194.213.194.2xx)', 'R'),
(1185, 'silk/1.0 (+http://www.slider.com/silk.htm)/3.7', 'Slider Search directory robot (194.213.194.2xx)', 'R'),
(1186, 'Sirketcebot/v.01 (http://www.sirketce.com/bot.html)', 'Sirket&#231;e search - Turkey', 'R'),
(1187, 'SiteSpider +(http://www.SiteSpider.com/)', 'Site Spider robot (66.249.17.xx)', 'R'),
(1188, 'SiteTruth.com site rating system', 'SiteTruth - Automatic site legitimacy rating system', 'R'),
(1189, 'SiteXpert', 'Xtreeme SiteXpert sitemap &amp; search engine builder', 'R'),
(1190, 'Skampy/0.9.x (http://www.skaffe.com/skampy-info.html)', 'Skaffe.com directory link checker', 'R'),
(1191, 'Skimpy/0.x (http://www.skaffe.com/skampy-info.html)', 'Skaffe.com directory link checker', 'R'),
(1192, 'Skywalker/0.1 (Skywalker; anonymous; anonymous)', 'Visvo distributed website crawler based on Nutch', 'R'),
(1193, 'Slarp/0.1', 'Only.com robot', 'R'),
(1194, 'Slider_Search_v1-de', 'Slider Search directory robot (194.213.194.2xx)', 'R'),
(1195, 'Slurp/2.0 (slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos-NBCi) robot', 'R'),
(1196, 'Slurp/2.0-KiteWeekly (slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos-NBCi) robot', 'R'),
(1197, 'Slurp/si (slurp@inktomi.com; http://www.inktomi.com/slurp.html)', 'Inktomi (Hotbot-Lycos-NBCi) robot', 'R'),
(1198, 'Slurpy Verifier/1.0', 'Inktomi (Hotbot-Lycos-NBCi) robot - 72.30.61.xx(x)', 'R'),
(1199, 'SlySearch (slysearch@slysearch.com)', 'Slysearch robot (now Turnitin robot)', 'R'),
(1200, 'SlySearch/1.0 http://www.plagiarism.org/crawler/robotinfo.html', 'Slysearch robot (now Turnitin robot)', 'R'),
(1201, 'SlySearch/1.x http://www.slysearch.com', 'Slysearch robot (now Turnitin robot)', 'R'),
(1202, 'smartwit.com', 'Loop Improvements NRS Enterprise search (69.44.155.xx[x])', 'R'),
(1203, 'SmiffyDCMetaSpider/1.0', 'SmiffyDCMetaSpider - Robot to check the retro-adding of Dublin Core metadata', 'R'),
(1204, 'snap.com beta crawler v0', 'Unknown bot from bb2.net (66.234.139.xxx) also as Snapbot/1.0', 'S'),
(1205, 'Snapbot/1.0', 'Unknown bot from bb2.net (66.234.139.xxx) - also as snap.com', 'S'),
(1206, 'Snapbot/1.0 (Snap Shots&#44; +http://www.snap.com)', 'Unknown bot from Psinet / Cogentco - not from Snap.com', 'S'),
(1207, 'SnykeBot/0.6 (http://www.snyke.com)', 'Snyke.com France robot', 'R'),
(1208, 'SocSciBot ()', 'Link crawler for the social sciences', 'R'),
(1209, 'SoftHypermarketFileCheckBot/1.0+(+http://www.softhypermaket.com)', 'Soft Hypermarket link checking', 'R'),
(1210, 'sogou develop spider', 'Unknown UA from Chinanet (220.181.26.1xx) faking Sogou search robot', 'S'),
(1211, 'Sogou Orion spider/3.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', 'Unknown UA from Chinanet (220.181.18.xx) faking Sogou search robot', 'S'),
(1212, 'sogou spider', 'Unknown UA from Chinanet (220.181.26.1xx) faking Sogou search robot', 'S'),
(1213, 'Sogou web spider/3.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', 'Unknown UA from Chinanet (220.181.26.1xx) faking Sogou search robot', 'S'),
(1214, 'sohu agent', 'Unknown UA from Chinanet (220.181.26.1xx) faking Sogou search robot', 'S'),
(1215, 'sohu-search', 'Sohu (Search Fox) search robot China (61.135.131.xxx)', 'R'),
(1216, 'Sosospider+(+http://help.soso.com/webspider.htm)', 'SOSO search (China) spider', 'R'),
(1217, 'speedfind ramBot xtreme 8.1', 'Speedfind.de robot', 'R'),
(1218, 'Speedy Spider (Beta/x.x; speedy@entireweb.com)', 'Entireweb search robot', 'R'),
(1219, 'Speedy Spider (Entireweb; Beta/1.0; http://www.entireweb.com/about/search_tech/speedyspider/)', 'Entireweb search spider', 'R'),
(1220, 'Speedy_Spider (http://www.entireweb.com)', 'Entireweb search robot', 'R'),
(1221, 'Sphere Scout&#38;v4.0 - scout at sphere dot com', 'Sphere blog and news search robot', 'R'),
(1222, 'Sphider', 'Sphider - a lightweight search engine in PHP', 'R'),
(1223, 'Spida/0.1', 'Only.com robot', 'R'),
(1224, 'Spider-Sleek/2.0 (+http://search-info.com/linktous.html)', 'Search-Info ODP/DMOZ spider', 'R'),
(1225, 'spider.batsch.com', 'Batsch robot', 'R'),
(1226, 'spider.yellopet.com - www.yellopet.com', 'Yellopet spider', 'R'),
(1227, 'Spider/maxbot.com admin@maxbot.com', 'Maxbot .gov .mil .edu indexing robot', 'R'),
(1228, 'SpiderKU/0.x', 'Unknown robot from CPE at Kasetsart University (158.108.35.xxx)', 'R'),
(1229, 'SpiderMan', 'Yahoo Search user agent or spider (202.165.102.xxx)', 'R'),
(1230, 'SpiderMonkey/7.0x (SpiderMonkey.ca info at http://spidermonkey.ca/sm.shtml)', 'SpiderMonkey Canada robot', 'R'),
(1231, 'Spinne/2.0', 'Spider.de robot', 'R'),
(1232, 'Spinne/2.0 med', 'Medkatalog (medical catalogue) Austria robot', 'R'),
(1233, 'Spinne/2.0 med_AH', 'Medkatalog (medical catalogue) Austria robot', 'R'),
(1234, 'Spock Crawler (http://www.spock.com/crawler)', 'Spock - people search application - via Amazon web services', 'R'),
(1235, 'sportsuchmaschine.de-Robot (Version: 1.02- powered by www.sportsuchmaschine.de)', 'Sportsuchmaschine (German sports related search) link checking / robot', 'R'),
(1236, 'sproose/0.1-alpha (sproose crawler; http://www.sproose.com/bot.html; crawler@sproose.com)', 'Sproose personalized search (38.100.225.xx)', 'R'),
(1237, 'Sqworm/2.9.81-BETA (beta_release; 20011102-760; i686-pc-linux-gnu)', 'AOL Search / Pacific Internet Exchange robot', 'R'),
(1238, 'Sqworm/2.9.85-BETA (beta_release; 20011115-775; i686-pc-linux-gnu)', 'diff. IPs / services i.e.: - Inria.fr robot - Websense (Internet filtering) robot', 'R'),
(1239, 'SSurf15a 11 ', 'Some site scanning tool via diff. IPs i.e.: - choiceone.net (216.153.xxx.xxx) - epix.net (216.108.198.xx)', 'S'),
(1240, 'StackRambler/x.x ', 'Rambler search (Russia) robot (81.19.6x.xx)', 'R'),
(1241, 'stat statcrawler@gmail.com', 'Experimental search engine spider from 66.92.186.xxx', 'R'),
(1242, 'Steeler/1.x (http://www.tkl.iis.u-tokyo.ac.jp/~crawler/)', 'Steeler crawler', 'R'),
(1243, 'Steeler/3.3 (http://www.tkl.iis.u-tokyo.ac.jp/~crawler/)', 'Steeler - University of Tokyo web crawler', 'R'),
(1244, 'Strategic Board Bot (+http://www.strategicboard.com)', 'Strategic Board blog &amp; news search robot', 'R'),
(1245, 'Strategic Board Bot (+http://www.strategicboard.com)', 'Strategic Board blogs and news aggregator robot', 'R'),
(1246, 'Submission Spider at surfsafely.com', 'Surfsafely submission verifier', 'R'),
(1247, 'suchbaer.de', 'Suchbaer.de (Germany) search robot', 'R'),
(1248, 'suchbaer.de (CrawlerAgent v0.103)', 'Suchbaer.de (Germany) search robot', 'R'),
(1249, 'suchbot', 'Suchbot Germany robot', 'R'),
(1250, 'Suchknecht.at-Robot', 'Suchknecht Austria robot', 'R'),
(1251, 'suchpadbot/1.0 (+http://www.suchpad.de)', 'suchpad search Germany robot (213.239.194.xx)', 'R'),
(1252, 'SurferF3 1/0', 'Wanadoo Rechereche robot', 'R'),
(1253, 'suzuran', 'Yokogao Search Engine robot (Kanazawa University)', 'R'),
(1254, 'Swooglebot/2.0. (+http://swoogle.umbc.edu/swooglebot.htm)', 'Swooglebot Swoogle''s semantic web crawler', 'R'),
(1255, 'SWSBot-Images/1.2 http://www.smartwaresoft.com/swsbot12.html', 'SWSBot - SmartWareSoft (85.186.255.xx) software search engine created for Playfuls.com', 'R'),
(1256, 'SygolBot http://www.sygol.net', 'Sygol Search (Italy) robot', 'R'),
(1257, 'SynoBot', 'Synomia (France) robot', 'R'),
(1258, 'Syntryx ANT Scout Chassis Pheromone; Mozilla/4.0 compatible crawler', 'Syntryx Solution Suite - domain / keyword crawler (216.7.179.xx)', 'R'),
(1259, 'Szukacz/1.x', 'Szukacz.pl (Polish search) robot', 'R'),
(1260, 'Szukacz/1.x (robot; www.szukacz.pl/jakdzialarobot.html; szukacz@proszynski.pl)', 'Szukacz.pl (Polish search) robot', 'R'),
(1261, 'tags2dir.com/0.8 (+http://tags2dir.com/directory/)', 'tags2dir.com directory index', 'R'),
(1262, 'Tagword (http://tagword.com/dmoz_survey.php)', 'TAGword DMOZ survey - ODP link checking robot', 'R'),
(1263, 'Talkro Web-Shot/1.0 (E-mail: webshot@daumsoft.com- Home: http://222.122.15.190/webshot)', 'Daumsoft Talkro IR robot', 'R'),
(1264, 'TCDBOT/Nutch-0.8 (PhD student research;http://www.tcd.ie; mcgettrs at t c d dot IE)', 'Trinity College Dublin (Ireland) TCDBOT', 'R'),
(1265, 'TECOMAC-Crawler/0.x', 'Tecomac Gmbh (Germany) crawler software - now Arexera Information Technologies', 'R'),
(1266, 'Tecomi Bot (http://www.tecomi.com/bot.htm)', 'Tecomi (Germany) beta / test robot (84.201.65.xxx)', 'R'),
(1267, 'Teemer (NetSeer&#44; Inc. is a Los Angeles based Internet startup company.; http://www.netseer.com/crawler.html; crawler@netseer.com)', 'Teemer crawler for NetSeer search (beta) via Amazon Web Services - see also NetSeer/Nutch', 'R'),
(1268, 'Teoma MP', 'Teoma crawler (65.214.36.xx[x])', 'R'),
(1269, 'teomaagent crawler-admin@teoma.com', 'Teoma crawler (65.214.36.xx[x])', 'R'),
(1270, 'teomaagent1 [crawler-admin@teoma.com]', 'Teoma crawler (65.214.36.xx[x])', 'R'),
(1271, 'teoma_agent1', 'Teoma crawler (65.214.36.xx[x])', 'R'),
(1272, 'Teradex Mapper; mapper@teradex.com; http://www.teradex.com', 'Teradex Directory robot', 'R'),
(1273, 'terraminds-bot/1.0 (support@terraminds.de)', 'Terraminds blog search (Germany)', 'R'),
(1274, 'TerrawizBot/1.0 (+http://www.terrawiz.com/bot.html)', 'Terrawiz Indian Search Engine robot', 'R'),
(1275, 'Test spider', 'Noceans Information Portfolio Manager (66.35.69.x)', 'R'),
(1276, 'TestCrawler/Nutch-0.9 (Testing Crawler for Research ; http://balihoo.com/index.aspx; tgautier at balihoo dot com)', 'Balihoo - Search Engine for Advertising Media', 'R'),
(1277, 'TheRarestParser/0.2a (http://therarestwords.com/)', 'The Rarest Words - Linguistic experiment crawler via Amazon Web Services', 'R'),
(1278, 'TheSuBot/0.1 (www.thesubot.de)', 'TheSuBot robot (Germany) for an unknown theme based search engine', 'R'),
(1279, 'thumbshots-de-Bot (Version: 1.02- powered by www.thumbshots.de)', 'ThumbShots.de (Germany) robot', 'R'),
(1280, 'timboBot/0.9 http://www.breakingblogs.com/timbo_bot.html', 'Breaking Blogs timbo bot blog robot', 'R'),
(1281, 'TinEye/1.1 (http://tineye.com/crawler.html)', 'TinEye crawler for an open image search project', 'R'),
(1282, 'tivraSpider/1.0 (crawler@tivra.com)', 'Tivra spider from AT&amp;T Labs Research', 'R'),
(1283, 'TJG/Spider', 'Tjgroup spider', 'R'),
(1284, 'Tkensaku/x.x(http://www.tkensaku.com/q.html)', 'Tkensaku Search (Japan) robot from 210.239.46.xxx (www.tken.com)', 'R'),
(1285, 'Topodia/1.2-dev (Topodia - Crawler for HTTP content indexing; http://www.topodia.com/; support@topodia.com)', 'Topodia search engine and personal information assistant (in development)', 'R'),
(1286, 'Toutatis x-xx.x (hoppa.com)', 'Hoppa robot (81.4.78.xxx)', 'R'),
(1287, 'Toutatis x.x (hoppa.com)', 'Hoppa robot (81.4.78.xxx)', 'R'),
(1288, 'Toutatis x.x-x', 'Hoppa robot (81.4.78.xxx)', 'R'),
(1289, 'traazibot/testengine (+http://www.traazi.de)', 'Traazi! search (Germany) robot', 'R'),
(1290, 'Trampelpfad-Spider', 'Trampelpfad Webkatalog spider', 'R'),
(1291, 'Trampelpfad-Spider-v0.1', 'Trampelpfad Webkatalog spider', 'R'),
(1292, 'TSurf15a 11', 'some bad user agent', 'S'),
(1293, 'Tumblr/1.0 RSS syndication (+http://www.tumblr.com/) (support@tumblr.com)', 'Tumblr Tumblelogs RSS and news syndication crawler', 'R'),
(1294, 'TurnitinBot/x.x (http://www.turnitin.com/robot/crawlerinfo.html)', 'Turnitin (ex SlySearch) robot for helping educational institutions prevent plagiarism', 'R'),
(1295, 'Turnpike Emporium LinkChecker/0.1', 'TurnPike Emporium Directory (207.67.198.x) link checking', 'R'),
(1296, 'TutorGig/1.5 (+http://www.tutorgig.com/crawler)', 'TutorGig tutorial search robot', 'R'),
(1297, 'Tutorial Crawler 1.4 (http://www.tutorgig.com/crawler)', 'TutorGig tutorial search robot', 'R'),
(1298, 'Twiceler www.cuill.com/robots.html', 'Twiceler experimental web crawler', 'R'),
(1299, 'Twiceler-0.9 http://www.cuill.com/twiceler/robot.html', 'Twiceler experimental web crawler', 'R'),
(1300, 'Tycoon Agent/Nutch-1.0-dev', 'Tycoon - Hewlett-Packards distributed cluster solution robot', 'R'),
(1301, 'TygoBot', 'Tygo Search robot', 'R'),
(1302, 'TygoProwler', 'Tygo Search robot', 'R'),
(1303, 'UIowaCrawler/1.0', 'University of Iowa Crawler- possibly MySpiders', 'R'),
(1304, 'UKWizz/Nutch-0.8.1 (UKWizz Nutch crawler; http://www.ukwizz.com/)', 'UKWizz search robot', 'R'),
(1305, 'Ultraseek', 'Infoseek robot', 'R'),
(1306, 'Under the Rainbow 2.2', 'Unknown mail harvester/spambot from 80.58.13.xxx (proxycache.rima-tde.net)', 'S'),
(1307, 'UofTDB_experiment (leehyun@cs.toronto.edu)', 'Unknown robot from University of Toronto (128.100.5.1xx)', 'R'),
(1308, 'updated/0.1-alpha (updated crawler; http://www.updated.com; crawler@updated.com)', 'Updated! search robot', 'R'),
(1309, 'updated/0.1beta (updated.com; http://www.updated.com; crawler@updated.om)', 'Updated! search robot', 'R'),
(1310, 'Uptimebot', 'UptimeBot.com online link popularity check', 'R'),
(1311, 'UptimeBot(www.uptimebot.com)', 'UptimeBot.com online link popularity check', 'R'),
(1312, 'URL Spider Pro/x.xx (innerprise.net)', 'Innerprise URL Spider Pro (now ES.NET) web indexing / site searching tool', 'R'),
(1313, 'urlfan-bot/1.0; +http://www.urlfan.com/site/bot/350.html', '://URLFAN news crawler', 'R'),
(1314, 'URL_Spider_Pro/x.x', 'Innerprise URL Spider Pro (now ES.NET) web indexing / site searching tool', 'R'),
(1315, 'URL_Spider_Pro/x.x+(http://www.innerprise.net/usp-spider.asp)', 'Innerprise URL Spider Pro (now ES.NET) web indexing / site searching tool', 'R'),
(1316, 'User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)', 'Malformed UA header from some guestbook/forum spammer', 'S'),
(1317, 'User-Agent: Mozilla/4.0 (SKIZZLE! Distributed Internet Spider v1.0 - www.SKIZZLE.com)', 'Skizzle search robot', 'R'),
(1318, 'USyd-NLP-Spider (http://www.it.usyd.edu.au/~vinci/bot.html)', 'University of Sydney NLP Spider for research in Natural Language Processing ', 'R'),
(1319, 'VadixBot', 'Unknown bad behaving bot via Road Runner - see link', 'S'),
(1320, 'Vagabondo-WAP/2.0 (webcrawler at wise-guys dot nl; http://webagent.wise-guys.nl/)/1.0 Profile', 'WiseGuys WAP pages robot', 'R'),
(1321, 'Vagabondo/1.x MT (webagent@wise-guys.nl)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(1322, 'Vagabondo/2.0 MT', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(1323, 'Vagabondo/2.0 MT (webagent at wise-guys dot nl)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(1324, 'Vagabondo/2.0 MT (webagent@NOSPAMwise-guys.nl)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(1325, 'Vagabondo/3.0 (webagent at wise-guys dot nl)', 'WiseGuys robot Netherland - 82.94.216.2', 'R'),
(1326, 'Vakes/0.01 (Vakes; http://www.vakes.com/; search@vakes.com)', 'Open Directory link checking from Vakes', 'R'),
(1327, 'versus 0.2 (+http://versus.integis.ch)', 'Versus Project robot - Comparing methods for near-uniform URL sampling', 'R'),
(1328, 'versus crawler eda.baykan@epfl.ch', 'Unknown robot from EPFL University Switzerland (128.178.155.xxx)', 'R'),
(1329, 'VeryGoodSearch.com.DaddyLongLegs', 'VeryGoodSearch.com link submission checking', 'R'),
(1330, 'verzamelgids.nl - Networking4all Bot/x.x', 'Verzamelgids NL link checking robot', 'R'),
(1331, 'Verzamelgids/2.2 (http://www.verzamelgids.nl)', 'Verzamelgids NL link checking robot', 'R'),
(1332, 'Vespa Crawler', 'Unknown robot from Yahoo Norway', 'R'),
(1333, 'VisBot/2.0 (Visvo.com Crawler; http://www.visvo.com/bot.html; bot@visvo.com)', 'Visbot crawler for a search software under development', 'R'),
(1334, 'Vision Research Lab image spider at vision.ece.ucsb.edu', 'Vision research lab''s Cortina - content based image retrieval (128.111.60.xx)', 'R'),
(1335, 'VMBot/0.x.x (VMBot; http://www.VerticalMatch.com/; vmbot@tradedot.com)', 'VM - Vertical Search Engine (China)', 'R'),
(1336, 'Vortex/2.2 (+http://marty.anstey.ca/robots/vortex/)', 'Vortex Web Indexing Robot for a study on  internet link distribution', 'R'),
(1337, 'voyager-hc/1.0', 'Kosmix health&#44; auto and travel search crawler (204.14.48.x / 38.113.234.xxx)', 'R'),
(1338, 'voyager/1.0', 'Kosmix health&#44; auto and travel search crawler (204.14.48.x / 38.113.234.xxx)', 'R'),
(1339, 'voyager/2.0 (http://www.kosmix.com/html/crawler.html)', 'Kosmix health&#44; auto and travel search crawler (204.14.48.x / 38.113.234.xxx)', 'R'),
(1340, 'VSE/1.0 (testcrawler@hotmail.com)', 'Vivisimo search crawler (206.210.89.xxx)', 'R'),
(1341, 'VSE/1.0 (testcrawler@vivisimo.com)', 'Vivisimo search crawler (206.210.89.xxx)', 'R'),
(1342, 'vspider', 'Verity vspider indexing software', 'R'),
(1343, 'vspider/3.x', 'Verity vspider indexing software', 'R'),
(1344, 'VWBOT/Nutch-0.9-dev (VWBOT Nutch Crawler; http://vwbot.cs.uiuc.edu;+vwbot@cs.uiuc.edu', 'VWBot - MetaQuerier Crawler for the MetaQuerier project at the University of Illinois', 'R'),
(1345, 'W3SiteSearch Crawler_v1.1 http://www.w3sitesearch.de', 'W3 Site Search (Germany) search engine solution', 'R'),
(1346, 'wadaino.jp-crawler 0.2 (http://wadaino.jp/)', 'Wadain (Japan) Blog / RSS search crawler', 'R'),
(1347, 'Wavefire/0.8-dev (Wavefire; http://www.wavefire.com; info@wavefire.com)', 'Wavefire local search community engine (64.141.15.1xx)', 'R'),
(1348, 'Waypath development crawler - info at waypath dot com', 'Waypath blog discovery engine robot', 'R'),
(1349, 'Waypath Scout v2.x - info at waypath dot com', 'Waypath blog discovery engine robot', 'R'),
(1350, 'Web Snooper', 'RankMeter ranking software', 'R'),
(1351, 'web2express.org/Nutch-0.9-dev (leveled playing field; http://web2express.org/; info at web2express.org)', 'Web2Express / Web2x - Open data searching tool', 'R'),
(1352, 'WebAlta Crawler/1.2.1 (http://www.webalta.ru/bot.html)', 'WebAlta search Russia crawler (85.21.201.xx)', 'R'),
(1353, 'WebarooBot (Webaroo Bot; http://64.124.122.252/feedback.html)', 'WebarooBot / RufusBot from webaroo offline search service', 'R'),
(1354, 'WebarooBot (Webaroo Bot; http://www.webaroo.com/rooSiteOwners.html)', 'WebarooBot / RufusBot from webaroo offline search service', 'R'),
(1355, 'webbandit/4.xx.0', 'Web Bandit personal search software', 'R'),
(1356, 'Webclipping.com', 'WebClipping.com - online news monitoring service', 'R'),
(1357, 'WebCompass 2.0', 'Quarterdecks WebCompass search tool', 'R'),
(1358, 'WebCorp/1.0', 'WebCorp linguistic search engine (UK)', 'R'),
(1359, 'webcrawl.net', 'Webcrawl Search robot (64.40.105.xxx)', 'R'),
(1360, 'WebFindBot(http://www.web-find.com)', 'Webfind search robot', 'R'),
(1361, 'Webglimpse 2.xx.x (http://webglimpse.net)', 'Webglimpse search engine software', 'R'),
(1362, 'Weblog Attitude Diffusion 1.0', 'Los Alamos National Laboratoy weblog research project', 'R'),
(1363, 'webmeasurement-bot&#44; http://rvs.informatik.uni-leipzig.de', 'Unknown robot from Leipzig University (Germany) faculty for computer science', 'R'),
(1364, 'WebRankSpider/1.37 (+http://ulm191.server4you.de/crawler/)', 'WebRankSpider experimental web crawler', 'R'),
(1365, 'WebSearch.COM.AU/3.0.1 (The Australian Search Engine; http://WebSearch.COM.AU; Search@WebSearch.COM.AU)', 'Websearch Australia robot', 'R'),
(1366, 'WebSearchBench WebCrawler v0.1(Experimental)', 'Dortmund University WebSearchBench - Open source search software', 'R'),
(1367, 'WebSearchBench WebCrawler V1.0 (Beta)- Prof. Dr.-Ing. Christoph Lindemann- Universit&#228;t Dortmund- cl@cs.uni-dortmund.de- http://websearchbench.cs.uni-dortmund.de/', 'Dortmund University WebSearchBench - Open source search software', 'R'),
(1368, 'WebsiteWorth v1.0', 'Sootle web directory Website Worth ranking tool', 'R'),
(1369, 'Webspinne/1.0 webmaster@webspinne.de', 'Webspinne.de robot', 'R'),
(1370, 'Websquash.com (Add url robot)', 'Websquash.com Search Engine robot / link checking', 'R'),
(1371, 'WebStat/1.0 (Unix; beta; 20040314)', 'WebStat - Java statistical computing environment for the web', 'R'),
(1372, 'Webster v0.3 ( http://webster.healeys.net/ )', 'Webster - Rev. Healeys web crawler', 'R'),
(1373, 'WebVac (webmaster@pita.stanford.edu)', 'The Stanford WebBase Project crawler', 'R'),
(1374, 'Webverzeichnis.de - Telefon: 01908 / 26005', 'Webverzeichnis.de (Germany) directory robot', 'R'),
(1375, 'WebVulnCrawl.unknown/1.0 libwww-perl/5.803', 'Web Vulnerability Crawler', 'S'),
(1376, 'Wells Search II', 'Unknown spam bot / harvester (62.163.**.** / 62.194.**.*)', 'S'),
(1377, 'WEP Search 00', 'Some spam bot- see link', 'S'),
(1378, 'WFARC', 'IBM''s Almaden Research robot (Clever search project)', 'R'),
(1379, 'whatUseek_winona/3.0', 'WhatUSeek / Chubba robot', 'R'),
(1380, 'WhizBang! Lab', 'WhizBang! Labs (closed since May 2002) information extraction robot', 'R'),
(1381, 'Willow Internet Crawler by Twotrees V2.1', 'Twotrees crawler', 'R'),
(1382, 'WinHTTP Example/1.0', 'Example code for a WinHTTP C++ library crawler', 'R'),
(1383, 'WinkBot/0.06 (Wink.com search engine web crawler; http://www.wink.com/Wink:WinkBot; winkbot@wink.com)', 'Wink beta search robot (64.13.136.x)', 'R'),
(1384, 'WIRE/0.11 (Linux; i686; Bot&#44;Robot&#44;Spider&#44;Crawler&#44;aromano@cli.di.unipi.it)', 'WIRE crawler used by the University of Pisa - Italy', 'R'),
(1385, 'WIRE/0.x (Linux; i686; Bot&#44;Robot&#44;Spider&#44;Crawler)', 'WIRE - Web information retrieval environment crawler', 'R'),
(1386, 'WISEbot/1.0 (WISEbot@koreawisenut.com; http://wisebot.koreawisenut.com)', 'Korea Wisenut robot', 'R'),
(1387, 'worio heritrix bot (+http://worio.com/)', 'WORIO (beta) search for computer scientists and programmers using Heritrix open-source crawler', 'R'),
(1388, 'woriobot ( http://www.worio.com/)', 'WORIO (beta) search for computer scientists and programmers via Amazon Web Services', 'R'),
(1389, 'WorldLight', 'Entireweb Search robot (62.13.25.xxx)', 'R'),
(1390, 'Wotbox/alpha0.6 (bot@wotbox.com; http://www.wotbox.com)', 'Wotbox spider', 'R'),
(1391, 'Wotbox/alpha0.x.x (bot@wotbox.com; http://www.wotbox.com) Java/1.4.1_02', 'Wotbox spider', 'R'),
(1392, 'WSB WebCrawler V1.0 (Beta)- cl@cs.uni-dortmund.de', 'WebSearchBench crawler from Dortmund University- Germany', 'R'),
(1393, 'WSB&#44; http://websearchbench.cs.uni-dortmund.de', 'WebSearchBench crawler from Dortmund University- Germany', 'R'),
(1394, 'wume_crawler/1.1 (http://wume.cse.lehigh.edu/~xiq204/crawler/)', 'WUME Lab''s web crawler (128.180.121.xxx)', 'R'),
(1395, 'Wwlib/Linux', 'WWLib - Wolverhampton Univerity Web Library for classifying web documents', 'R'),
(1396, 'www.arianna.it', 'Arianna robot', 'R'),
(1397, 'WWWeasel Robot v1.00 (http://wwweasel.de)', 'World Wide Weasel Germany robot', 'R'),
(1398, 'wwwster/1.x (Beta- mailto:gue@cis.uni-muenchen.de)', 'Unknown robot from CIS at Munich University', 'R'),
(1399, 'X-Crawler ', 'Arexera (Germany) crawler software', 'R'),
(1400, 'xirq/0.1-beta (xirq; http://www.xirq.com; xirq@xirq.com)', 'XIRQ search (beta) robot (70.86.206.1xx)', 'R'),
(1401, 'xyro_(xcrawler@cosmos.inria.fr)', 'Inria Crawler', 'R'),
(1402, 'Y!J-BSC/1.0 (http://help.yahoo.co.jp/help/jp/search/indexing/indexing-15.html)', 'Yahoo Search Japan robot (211.14.8.2xx)', 'R'),
(1403, 'Y!J-SRD/1.0', 'Yahoo Search Japan robot (203.216.197.xxx)', 'R'),
(1404, 'Y!J/1.0 (http://help.yahoo.co.jp/help/jp/search/indexing/indexing-15.html)', 'Yahoo Search Japan robot (211.14.8.2xx)', 'R'),
(1405, 'yacy (www.yacy.net; v20040602; i386 Linux 2.4.26-gentoo-r13; java 1.4.2_06; MET/en)', 'Yacy distributed P2P web search engine robot', 'R'),
(1406, 'yacybot (x86 Windows XP 5.1; java 1.5.0_06; Europe/de) yacy.net', 'Yacy distributed P2P web search engine robot', 'R'),
(1407, 'Yahoo Pipes 1.0', '(Yahoo) Pipes interactive data aggregator robot', 'R'),
(1408, 'Yahoo! Mindset', 'Yahoo Mindset: Intent-driven Search (66.228.182.1xx)', 'R'),
(1409, 'Yahoo-Blogs/v3.9 (compatible; Mozilla 4.0; MSIE 5.5; http://help.yahoo.com/help/us/ysearch/crawling/crawling-02.html )', 'Yahoo blog indexing robot (209.191.83.1xx)', 'R'),
(1410, 'Yahoo-MMAudVid/1.0 (mms dash mmaudvidcrawler dash support at yahoo dash inc dot com)', 'Yahoo multimedia crawler (206.190.43.xx)', 'R'),
(1411, 'Yahoo-MMAudVid/2.0(mms dash mm aud vid crawler dash support at yahoo dash inc.com ;Mozilla 4.0 compatible; MSIE 7.0;Windows NT 5.0; .NET CLR 2.0)', 'Yahoo multimedia crawler', 'R'),
(1412, 'Yahoo-MMCrawler/3.x (mm dash crawler at trd dot overture dot com)', 'Yahoo multimedia crawler via Fastsearch.net (66.77.73.xx)', 'R'),
(1413, 'Yahoo-Test/4.0', 'Yahoo Search robot', 'R'),
(1414, 'Yahoo-VerticalCrawler-FormerWebCrawler/3.9 crawler at trd dot overture dot com; http://www.alltheweb.com/help/webmaster/crawler', 'Yahoo crawler via Overture (66.77.73.3x)', 'R'),
(1415, 'YahooFeedSeeker/2.0 (compatible; Mozilla 4.0; MSIE 5.5; http://publisher.yahoo.com/rssguide)', 'Yahoo Publisher Network RSS crawler', 'R'),
(1416, 'YahooSeeker-Testing/v3.9 (compatible; Mozilla 4.0; MSIE 5.5; http://search.yahoo.com/)', 'Yahoo Product Search crawler ( 68.142.195..x)', 'R'),
(1417, 'YahooSeeker/1.0 (compatible; Mozilla 4.0; MSIE 5.5; http://help.yahoo.com/help/us/shop/merchant/)', 'Yahoo Product Search crawler ( 66.196.93.x)', 'R'),
(1418, 'YahooSeeker/1.0 (compatible; Mozilla 4.0; MSIE 5.5; http://search.yahoo.com/yahooseeker.html)', 'Yahoo Product Search crawler ( 66.196.93.x)', 'R'),
(1419, 'YahooSeeker/1.1 (compatible; Mozilla 4.0; MSIE 5.5; http://help.yahoo.com/help/us/shop/merchant/)', 'Yahoo Product Search crawler ( 66.196.93.x)', 'R'),
(1420, 'YahooSeeker/bsv3.9 (compatible; Mozilla 4.0; MSIE 5.5; http://help.yahoo.com/help/us/ysearch/crawling/crawling-02.html )', 'Yahoo Product Search crawler ( 68.142.195..x)', 'R'),
(1421, 'YahooSeeker/CafeKelsa-dev (compatible; Konqueror/3.2; FreeBSD ;cafekelsa-dev-webmaster@yahoo-inc.com )', 'Yahoo robot', 'R'),
(1422, 'Yandex/1.01.001 (compatible; Win16; I)', 'Yandex Search Russia link checking (213.180.206.2xx)', 'R'),
(1423, 'Yanga WorldSearch Bot v1.1/beta (http://www.yanga.co.uk/)', 'Yanga search robot by Gigabase (Russian Federation)', 'R'),
(1424, 'yarienavoir.net/0.2', 'Yarienavoir search (Belgium) robot', 'R'),
(1425, 'Yeti', '1noon.com search Korea robot (222.231.21.xxx)', 'R'),
(1426, 'Yeti/0.01 (nhn/1noon&#44; yetibot@naver.com&#44; check robots.txt daily and follows it)', '1noon.com search Korea robot (222.231.21.xxx)', 'R'),
(1427, 'Yeti/1.0 (NHN Corp.; http://help.naver.com/robots/)', 'Naver search (Korea) robot', 'R');
INSERT INTO `[[dbprefix]]reports_crawlers_info` VALUES
(1428, 'yggdrasil/Nutch-0.9 (yggdrasil biorelated search engine; www dot biotec dot tu minus dresden do de slash schroeder; heiko dot dietze at biotec dot tu minus dresden dot de)', 'yggdrasil spider for GoPubMed biorelated search engine', 'R'),
(1429, 'YodaoBot/1.0 (http://www.yodao.com/help/webmaster/spider/; )', 'Yodao search (China)', 'R'),
(1430, 'yoofind/yoofind-0.1-dev (yoono webcrawler; http://www.yoono.com ; MyEmail)', 'Yoono - community based search (193.110.140.xxx / 194.0.179.[x]xx)', 'R'),
(1431, 'yoogliFetchAgent/0.1', 'Yoogli search (under development) agent', 'R'),
(1432, 'yoono/1.0 web-crawler/1.0', 'Yoono - community based search (193.110.140.xxx / 194.0.179.[x]xx)', 'R'),
(1433, 'YottaCars_Bot/4.12 (+http://www.yottacars.com) Car Search Engine ', 'YottaCars bot - YottaCar car search engine ( 64.62.175.xxx)', 'R'),
(1434, 'YottaShopping_Bot/4.12 (+http://www.yottashopping.com) Shopping Search Engine', 'YottaShopping bot - YottaShopping search engine ( 64.62.175.xxx) ', 'R'),
(1435, 'Zao-Crawler', 'Zao crawler for Kototoi Project', 'R'),
(1436, 'Zao-Crawler 0.2b', 'Zao crawler for Kototoi Project', 'R'),
(1437, 'Zao/0.1 (http://www.kototoi.org/zao/)', 'Zao crawler for Kototoi Project', 'R'),
(1438, 'ZBot/1.00 (icaulfield@zeus.com)', 'Zeus Internet Marketing Robot based on Webster Pro component', 'R'),
(1439, 'Zearchit', 'Zearchit German search / directory', 'R'),
(1440, 'ZeBot_lseek.net (bot@ze.bz)', 'Ze.bz Moteur de Recherche robot', 'R'),
(1441, 'ZeBot_www.ze.bz (ze.bz@hotmail.com)', 'Ze.bz Moteur de Recherche robot', 'R'),
(1442, 'zedzo.digest/0.1 (http://www.zedzo.com/)', 'ZedZo Search (beta) robot', 'R'),
(1443, 'zermelo Mozilla/5.0 compatible; heritrix/1.12.1 (+http://www.powerset.com) [email:crawl@powerset.com&#44;email:paul@page-store.com]', 'Powerset Natural Language Search crawler (under development) using Heritrix via Amazon Web Services', 'R'),
(1444, 'zerxbot/Version 0.6 libwww-perl/5.79', 'Zerx search robot ?', 'R'),
(1445, 'Zeus ThemeSite Viewer Webster Pro V2.9 Win32', 'Zeus Internet Marketing Robot (based on Webster Pro)', 'R'),
(1446, 'Zeus xxxxx Webster Pro V2.9 Win32', 'Zeus Internet Marketing Robot (based on Webster Pro)', 'R'),
(1447, 'Zeusbot/0.07 (Ulysseek''s web-crawling robot; http://www.zeusbot.com; agent@zeusbot.com)', 'Zeusbot robot for building the Ulsysseek.com index', 'R'),
(1448, 'ZipppBot/0.xx (ZipppBot; http://www.zippp.net; webmaster@zippp.net)', 'Zipp.net web search robot', 'R'),
(1449, 'ZIPPPCVS/0.xx (ZipppBot/.xx;http://www.zippp.net; webmaster@zippp.net)', 'Zipp.net web search robot', 'R'),
(1450, 'Zippy v2.0 - Zippyfinder.com', 'Zippyfinder robot', 'R'),
(1451, 'ZoomSpider - wrensoft.com', 'Zoom Search Engine software spider', 'R'),
(1452, 'zspider/0.9-dev http://feedback.redkolibri.com/', 'zspider robot for a new search engine', 'R'),
(1453, 'ZyBorg/1.0 (ZyBorg@WISEnut.com; http://www.WISEnut.com)', 'Wisenut robot', 'R');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_crawlers_visits`
--

CREATE TABLE `[[dbprefix]]reports_crawlers_visits` (
  `visitor_id` int(11) NOT NULL AUTO_INCREMENT,
  `visit_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `agent_string` text NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(5) NOT NULL DEFAULT 'R',
  `ip` varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `host` varchar(255) NOT NULL DEFAULT '',
  `referrer` varchar(255) NOT NULL DEFAULT '',
  `entry_page` varchar(255) NOT NULL DEFAULT '',
  `scanned_pages` longtext NOT NULL,
  PRIMARY KEY (`visitor_id`),
  KEY `IDX_visit_time` (`visit_time`),
  KEY `IDX_name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_orders_products_stat`
--

CREATE TABLE `[[dbprefix]]reports_orders_products_stat` (
  `order_id` int(11) NOT NULL DEFAULT '0',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `amount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_orders_stat`
--

CREATE TABLE `[[dbprefix]]reports_orders_stat` (
  `order_stat_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `order_payment_status_id` int(11) NOT NULL DEFAULT '0',
  `order_deleted` int(11) NOT NULL DEFAULT '0',
  `order_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_total` float NOT NULL DEFAULT '0',
  `order_tax_total` float NOT NULL DEFAULT '0',
  `order_currency` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_stat_id`),
  KEY `IDX_datetime` (`order_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_page_urls`
--

CREATE TABLE `[[dbprefix]]reports_page_urls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_url` text,
  PRIMARY KEY (`id`),
  KEY `IDX_page` (`page_url`(256))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_product_info`
--

CREATE TABLE `[[dbprefix]]reports_product_info` (
  `product_id` int(11) NOT NULL DEFAULT '0',
  `product_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_product_stat`
--

CREATE TABLE `[[dbprefix]]reports_product_stat` (
  `datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `sale_items` int(11) NOT NULL DEFAULT '0',
  `added_to_cart_times` int(11) NOT NULL DEFAULT '0',
  `deleted_from_cart_times` int(11) NOT NULL DEFAULT '0',
  `added_to_cart_qty` int(11) NOT NULL DEFAULT '0',
  `deleted_from_cart_qty` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`datetime`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_visitor_info`
--

CREATE TABLE `[[dbprefix]]reports_visitor_info` (
  `visitor_id` int(11) NOT NULL AUTO_INCREMENT,
  `visitor_session_id` varchar(200) NOT NULL DEFAULT '',
  `visitor_os` varchar(100) DEFAULT NULL,
  `visitor_browser` varchar(100) DEFAULT NULL,
  `visitor_agent` text,
  `visitor_type` varchar(5) DEFAULT NULL,
  `visitor_register_time` datetime DEFAULT NULL,
  PRIMARY KEY (`visitor_id`,`visitor_session_id`),
  KEY `IDX_register_time` (`visitor_register_time`),
  KEY `IDX_visitor_id` (`visitor_id`),
  KEY `IDX_visitor_type` (`visitor_type`),
  KEY `IDX_visitor_session_id` (`visitor_session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_visitor_seances`
--

CREATE TABLE `[[dbprefix]]reports_visitor_seances` (
  `visitor_id` int(11) DEFAULT NULL,
  `seance_id` int(11) DEFAULT NULL,
  `prev_seance_id` int(11) DEFAULT NULL,
  `visit_number` int(11) DEFAULT NULL,
  `creation_time` datetime DEFAULT NULL,
  `entry_page` varchar(255) DEFAULT NULL,
  `referer_host` varchar(200) DEFAULT NULL,
  `referer` varchar(255) DEFAULT NULL,
  `remote_ip` varchar(50) DEFAULT NULL,
  `remote_host` varchar(255) DEFAULT NULL,
  UNIQUE KEY `UNQ_seance_id` (`seance_id`),
  KEY `IDX_visitor_id` (`visitor_id`),
  KEY `creation_time` (`creation_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports_visitor_seance_info`
--

CREATE TABLE `[[dbprefix]]reports_visitor_seance_info` (
  `idd` int(11) NOT NULL AUTO_INCREMENT,
  `seance_id` int(11) DEFAULT NULL,
  `page_url` int(11) DEFAULT NULL,
  `visit_time` datetime DEFAULT NULL,
  `visitors_online` int(11) DEFAULT NULL,
  PRIMARY KEY (`idd`),
  KEY `IDX_sid` (`seance_id`),
  KEY `IDX_visit_time` (`visit_time`),
  KEY `IDX_page_url` (`page_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report_periods`
--

CREATE TABLE `[[dbprefix]]report_periods` (
  `report_class_name` varchar(255) NOT NULL DEFAULT '',
  `report_period_label` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`report_class_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]report_periods`
--

INSERT INTO `[[dbprefix]]report_periods` VALUES
('chartordersbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartordersbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('chartordersbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('reportabandonmentratesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportabandonmentratesbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('reportabandonmentratesbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('reportorderspervisitorsratesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportorderspervisitorsratesbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('reportorderspervisitorsratesbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('chartproductsalesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartproductsalesbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('chartproductsalesbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('chartproductviewsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartproductviewsbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('chartproductviewsbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('reportproductsalesvsviewsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportproductsalesvsviewsbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('reportproductsalesvsviewsbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('reportproductaddedcartvssalesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportproductaddedcartvssalesbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('reportproductaddedcartvssalesbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('reporttop10sellersbyitems', 'DATETIME_PERIOD_DAY_LAST_30'),
('reporttop10byviews', 'DATETIME_PERIOD_DAY_LAST_30'),
('reporttop10addedtocartquantity', 'DATETIME_PERIOD_DAY_LAST_30'),
('reporttop10deletedfromcartquantity', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportproductsummarystatisticsbydays', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportproductsummarystatisticsbymonths', 'DATETIME_PERIOD_MONTH_LAST_12'),
('reportproductsummarystatisticsbyyears', 'DATETIME_PERIOD_YEAR_LAST_6'),
('chartpageviewsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartseancesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartvisitorsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartfirsttimevisitorsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('chartrepeatvisitorsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reporttopvisitorreferers', 'DATETIME_PERIOD_DAY_LAST_30'),
('reporttopvisitorfullreferers', 'DATETIME_PERIOD_DAY_LAST_30'),
('reporttopviewedpages', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportvisitorstatisticsbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportvisitorstatisticsbymonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('reportvisitorstatisticsbyyear', 'DATETIME_PERIOD_YEAR_LAST_6'),
('reportorderspervisitsratesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportsalespervisitorsratesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('reportsalespervisitsratesbyday', 'DATETIME_PERIOD_DAY_LAST_30'),
('ChartTaxByDay', 'DATETIME_PERIOD_DAY_LAST_30'),
('ChartTaxByMonth', 'DATETIME_PERIOD_MONTH_LAST_12'),
('ChartTaxByYear', 'DATETIME_PERIOD_YEAR_LAST_6');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource_labels`
--

CREATE TABLE `[[dbprefix]]resource_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `res_prefix` varchar(32) DEFAULT NULL,
  `res_label` varchar(255) DEFAULT NULL,
  `res_text` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_uprefix_key` (`res_prefix`,`res_label`),
  KEY `IDX_prefix_key` (`res_prefix`),
  KEY `IDX_label_key` (`res_label`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8516 ;

--
-- Dumping data for table `[[dbprefix]]resource_labels`
--

INSERT INTO `[[dbprefix]]resource_labels` VALUES
(1, 'SYS', 'CORE_001', 'File not found.'),
(2, 'SYS', 'CORE_002', 'Section [<b>{0}</b>] not found.'),
(3, 'SYS', 'CORE_003', 'Directive <b>Default</b> not found.'),
(4, 'SYS', 'CORE_004', 'File <b>''{0}''</b> not found.'),
(5, 'SYS', 'CORE_005', 'File <b>''{0}''</b> not found.'),
(6, 'SYS', 'CORE_006', 'Section name coincides with PHP function or reserved word, or has the same name as predefined or system-defined tags/views. Please rename the section.'),
(7, 'SYS', 'CORE_007', 'Only directives in the form of categories {1+,2} can be used. Your directive <b>''{0}''</b> is invalid.'),
(8, 'SYS', 'CORE_008', 'Only directives in the form of categories {1+,2} or products {1+,2} can be used. Your directive <b>''{0}''</b> is invalid.'),
(9, 'SYS', 'CORE_009', 'Only directive ''default'' can be used. Your directive <b>''{0}''</b> is meaningless.'),
(10, 'SYS', 'CORE_010', 'Mandatory section [layouts] is missing.'),
(11, 'SYS', 'CORE_011', 'Mandatory directive ''default'' is missing.'),
(12, 'SYS', 'CORE_012', 'Declaration of section <b>''{0}''</b> is missing.'),
(13, 'SYS', 'CORE_013', 'Declared directive does not match the form of categories {1+,2} or products {1+,2}. Your directive <b>''{0}''</b> is invalid.'),
(14, 'SYS', 'CORE_015', 'Mandatory directive <b>''TemplateDirectory''</b> is missing.'),
(15, 'SYS', 'CORE_0151', 'Missing mandatory directive for description of file of template ''{0}''.'),
(16, 'SYS', 'CORE_0152', 'Missing required directive for description of option of template ''{0}''.'),
(17, 'SYS', 'CORE_0154', 'Invalid declaration of directive {0}. Declaration format: TemplateFile-&lt;name&gt;-ProductType{1,2,3,4}, where the list in braces specifies one or more product type identifiers.'),
(18, 'SYS', 'CORE_0154_3INI', 'Invalid declaration of directive {0}. Declaration format: TemplateFile-ProductType{1,2,3,4}, where the list in braces specifies one or more product type identifiers.'),
(19, 'SYS', 'CORE_0155', 'Missing declaration of directive {0}.'),
(20, 'SYS', 'CORE_016', 'Directory <b>''{0}''</b> does not exist.'),
(21, 'SYS', 'CORE_017', 'File <b>''{0}''</b> does not exist.'),
(22, 'SYS', 'CORE_052', '{0}::{1}, sizeof(\\$result) != 1" ; This message will be displayed if, for example, the Home category does not exist'),
(23, 'SYS', 'CORE_053', '{0}::{1}, \\$retval = ''''" ; This message will be displayed if ''Breadcrumb'' is empt'),
(24, 'SYS', 'CORE_154', 'The next order ID must be more than max ID of gift certificate <b>({0})</b>.'),
(25, 'SYS', 'CORE_155', 'The next order ID must be more than max ID of last order <b>({0})</b>.'),
(26, 'SYS', 'CORE_020', 'Mismatch with regular expression of the [&lt;Section Name&gt;] type when declaring the section.'),
(27, 'SYS', 'CORE_021', 'Mismatch between the directive and regular expression of the &lt;directive&gt; [{1[, 2+, 3]}] = &lt;value&gt; type.'),
(28, 'SYS', 'CORE_ML_001', 'PHP requires mb_string extension to properly work with the page charset provided'),
(29, 'SYS', 'CORE_ML_002', 'The page charset provided is not configured'),
(30, 'SYS', 'CORE_ML_003', 'Unknown error with the page charset provided.'),
(31, 'SYS', 'CORE_ML_004', 'PHP mb_string extension is misconfigured to encode HTTP input data which may cause some errors. Please set either mbstring.http_input setting to ''pass'' or set mbstring.internal_encoding setting to ''Off'''),
(32, 'SYS', 'CORE_ML_005', 'Input data is improperly encoded.'),
(33, 'SYS', 'CORE_ML_006', 'Missing language resource for module [{0}], table [{1}], field [{2}]'),
(34, 'SYS', 'TMPL_001', 'Missing template description for [this] StoreTag = ''{0}''.'),
(35, 'SYS', 'PGNTRRW_001', 'Directive <b>''{0}''</b> is missing.'),
(36, 'SYS', 'PGNTRRW_005', 'Unknown directive.'),
(37, 'SYS', 'PRDLST_006', 'To perform this action, please first select a product or products.'),
(38, 'SYS', 'PRDLST_007', 'No products to be sorted.'),
(39, 'SYS', 'PRDLST_008', 'No products to be sorted; there is only one product in this category.'),
(40, 'SYS', 'PRDLST_009', 'You can select only a single product to edit.'),
(41, 'SYS', 'PRDLST_010', 'To perform this action, please select a product first.'),
(42, 'SYS', 'NB_006', 'To perform this action, please first select a category.'),
(43, 'SYS', 'NB_007', 'No categories to be sorted.'),
(44, 'SYS', 'NB_008', 'No categories to be sorted; there is only one subcategory in this category.'),
(45, 'SYS', 'NB_009', 'There are no categories for performing this action.'),
(46, 'SYS', 'PRDADD_001', 'Please enter an integer.<br>&nbsp;E.g. 12, 34, 78, 56.'),
(47, 'SYS', 'PRDADD_002', 'Please enter a numerical value.<br>&nbsp;E.g. 23.325, 34, 99.2'),
(48, 'SYS', 'PRDADD_003', 'Please enter a numerical value.<br>&nbsp;E.g. 12.35, 34, 99.00'),
(49, 'SYS', 'PRDADD_004', 'Please enter product name. Total number of characters must not exceed 256. Excess characters will be ignored.'),
(50, 'SYS', 'PRDADD_005', 'Sorry, it is not allowed to use images of this type for {0}'),
(51, 'SYS', 'PRDADD_006', 'File download error for {0}. Please repeat the operation.'),
(52, 'SYS', 'PRDADD_007', 'Total number of characters must not exceed 1024. Excess characters will be ignored.'),
(53, 'SYS', 'PRDADD_008', 'Total number of characters should not exceed 128. Excess characters will be ignored.'),
(54, 'SYS', 'PRDADD_009', 'Total number of characters should not exceed 256. Excess characters will be ignored.'),
(55, 'SYS', 'PRDADD_010', 'Total number of characters should not exceed 512. Excess characters will be ignored.'),
(56, 'SYS', 'PRDADD_011', 'Sorry, the file specified for {0} does not exist.'),
(57, 'SYS', 'ADDPRDTYPE_001', 'Attribute ''Product Type Name'' should have length longer than 1 and less than 128 characters.'),
(58, 'SYS', 'ADDPRDTYPE_002', 'Attribute ''Product Type Description'' should have length longer than 1 and less than 512 characters.'),
(59, 'SYS', 'ERR_AZ_CAT_ADDCAT_001', 'Category name should have length greater than 0 and less than 257 characters.'),
(60, 'SYS', 'ERR_AZ_CAT_ADDCAT_002', '''Page Title'' should have length greater than 3 and less than 128 characters.'),
(61, 'SYS', 'ERR_AZ_CAT_ADDCAT_003', 'Attribute Meta Keywords should not exceed 1024 characters'),
(62, 'SYS', 'ERR_AZ_CAT_ADDCAT_004', 'Attribute Meta Description should not exceed 1024 characters'),
(63, 'SYS', 'ERR_AZ_CAT_ADDCAT_005', 'Category Name should have length greater than 0 and less than 128 characters.'),
(64, 'SYS', 'ERR_AZ_CAT_ADDCAT_006', 'Attribute Image Description should not exceed 256 characters'),
(65, 'SYS', 'ERR_AZ_CAT_ADDCAT_007', 'Attribute Page Title should not exceed 256 characters'),
(66, 'SYS', 'ADDCUSTOM_001', 'Attribute Tag not defined.'),
(67, 'SYS', 'ADDCUSTOM_002', 'Attribute Tag must be entered without any blank spaces. Allowable characters and digits are 0, 1, 2...9, A-Z, a-z, _. For example, if you create an attribute describing the size of a flower bouquet, you can name it FlowerDimensions (no black spaces).'),
(68, 'SYS', 'ADDCUSTOM_003', 'Attribute Name not defined.'),
(69, 'SYS', 'ADDCUSTOM_004', 'Attribute Description not defined.'),
(70, 'SYS', 'ADDCUSTOM_005', 'Attribute ''{0}'' already defined for this product type.'),
(71, 'SYS', 'DELCUSTOM_006', 'Are you sure you want to delete custom attribute?'),
(72, 'SYS', 'CATADD_001', 'Total number of characters should not exceed 1024. Excess characters will be ignored.'),
(73, 'SYS', 'CATADD_002', 'Total number of characters should not exceed 128. Excess characters will be ignored.'),
(74, 'SYS', 'CATADD_003', 'Total number of characters should not exceed 256. Excess characters will be ignored.'),
(75, 'SYS', 'CATADD_004', 'Total number of characters should not exceed 512. Excess characters will be ignored.'),
(76, 'SYS', 'error.required', 'Attribute {0} is a mandatory field'),
(77, 'SYS', 'error.wrongPattern', 'Attribute {0} does not match template {1}'),
(78, 'SYS', 'error.wrongPatternString1024', 'Attribute {0} should not exceed 1024 characters'),
(79, 'SYS', 'error.wrongPatternString128', 'Attribute {0} should not exceed 128 characters'),
(80, 'SYS', 'error.wrongPatternString256', 'Attribute {0} should not exceed 256 characters'),
(81, 'SYS', 'error.wrongPatternString512', 'Attribute {0} should not exceed 512 characters'),
(82, 'SYS', 'PRD_PRDTYPE_NAME', 'Product Type'),
(83, 'SYS', 'PRD_PRDTYPE_DESCR', 'Mandatory input field. This field defines the product type. Prior to entering any data for a new product, you must select the existing product type it belongs to. There are default and user-defined product types. To create a new product type, please refer to the user manual.'),
(84, 'SYS', 'PRD_ID_NAME', 'Product ID'),
(85, 'SYS', 'PRD_ID_DESCR', 'Product ID is a unique digital product identifier. This identifier is assigned to a product by the system as a numeric value (e.g. 7693). This assigned number uniquely identifies the product among multiple other products.'),
(86, 'SYS', 'PRD_NAME_NAME', 'Product Name'),
(87, 'SYS', 'PRD_NAME_DESCR', 'Mandatory input field. Defines the product name.'),
(88, 'SYS', 'PRD_SALEPRC_NAME', 'Sale Price (per item)'),
(89, 'SYS', 'PRD_SALEPRC_DESCR', 'The product sale price. The product is sold to customers at this price.'),
(90, 'SYS', 'PRD_LISTPRC_NAME', 'List Price (per item)'),
(91, 'SYS', 'PRD_LISTPRC_DESCR', 'The product list price. The list price is not used for sales and purchases.'),
(92, 'SYS', 'PRD_QUINSTOCK_NAME', 'Quantity in Stock'),
(93, 'SYS', 'PRD_QUINSTOCK_DESCR', 'Goods remaining in the warehouse.'),
(94, 'SYS', 'PRD_SKU_NAME', 'SKU'),
(95, 'SYS', 'PRD_SKU_DESCR', 'Stock Keeping Unit. Shows the product identifier according to the inventory numbering.'),
(96, 'SYS', 'PRD_QUINORDER_NAME', 'Minimum Quantity in Order'),
(97, 'SYS', 'PRD_QUINORDER_DESCR', 'Shows the minimum quantity of goods that may be ordered.'),
(98, 'SYS', 'PRD_LOWLEV_NAME', 'Low level in Stock'),
(99, 'SYS', 'PRD_LOWLEV_DESCR', 'Shows the minimum level of a product in the warehouse, at which the stock is considered to be low.'),
(100, 'SYS', 'PRD_AVAIL_NAME', 'Product Status'),
(101, 'SYS', 'PRD_AVAIL_DESCR', 'Shows whether the product is available in stock.'),
(102, 'SYS', 'PRD_TAXABLE_NAME', 'Taxable'),
(103, 'SYS', 'PRD_TAXABLE_DESCR', 'Shows whether the product is subject to tax.'),
(104, 'SYS', 'PRD_LRGIMG_NAME', 'Large Image'),
(105, 'SYS', 'PRD_LRGIMG_DESCR', 'Complete path to the product image.'),
(106, 'SYS', 'PRD_SMLIMG_NAME', 'Small Image'),
(107, 'SYS', 'PRD_SMLIMG_DESCR', 'Complete path to the product thumbnail image.'),
(108, 'SYS', 'PRD_IMGDESCR_NAME', 'Image Description'),
(109, 'SYS', 'PRD_IMGDESCR_DESCR', 'Description of the image. Regular text only.'),
(110, 'SYS', 'PRD_SHRDESCR_NAME', 'Short Description'),
(111, 'SYS', 'PRD_SHRDESCR_DESCR', 'Short description of the product. You may enter HTML text.'),
(112, 'SYS', 'PRD_DETDESCR_NAME', 'Detailed Description'),
(113, 'SYS', 'PRD_DETDESCR_DESCR', 'Detailed description of the product. You may enter HTML text.'),
(114, 'SYS', 'PRD_SHIPPRC_NAME', 'Per Item Shipping Cost'),
(115, 'SYS', 'PRD_SHIPPRC_DESCR', 'Shows the costs associated with shipping the product to the customer (per item shipping cost). This cost is <b>always</b> added to the amount calculated by the shipping modules Flat Shipping Rates, UPS, FedEx, UPS etc.<br>&nbsp;<br>The Per Item Shipping Cost represents the cost of shipping one item of a product and does NOT include its handling cost. To enter the handling cost for a product, use the Per Item Handling Cost.<br>&nbsp;<br><b>Example:</b><br>A customer ordered 5 products, each of which has a Per Item Shipping Cost = $2 and is shipped by FedEx. <br>&nbsp;<br>Meanwhile, the shipping cost calculated by the FedEx online module equals $17. <br>&nbsp;<br>Thus, the total shipping cost equals $27 ($2 * 5 items + $17).'),
(116, 'SYS', 'PRD_HANDRC_NAME', 'Per Item Handling Cost'),
(117, 'SYS', 'PRD_HANDRC_DESCR', '<b>Attribute Name:</b> Per Item Handling Cost<br><br><b>Description:</b> Represents the cost of handling one item of a product. This cost is always added to the Per Order Handling Fee.<br><br><b>Example:</b> A customer ordered 10 products, each of which has a Per Item Handling Cost = $3.<br><br>The Per Order Handling Fee for the order equals $9. Thus, the Total Order Handling Charge equals $39 ($3 * 10 items + $9).'),
(118, 'SYS', 'PRD_WEIGHT_NAME', 'Weight (per item)'),
(119, 'SYS', 'PRD_WEIGHT_DESCR', 'The weight of the product.'),
(120, 'SYS', 'PRD_LENGTH_NAME', 'Length'),
(121, 'SYS', 'PRD_LENGTH_DESCR', 'The length of the product in inches'),
(122, 'SYS', 'PRD_WIDTH_NAME', 'Width'),
(123, 'SYS', 'PRD_WIDTH_DESCR', 'The width of the product in inches'),
(124, 'SYS', 'PRD_HEIGHT_NAME', 'Height'),
(125, 'SYS', 'PRD_HEIGHT_DESCR', 'The height of the product in inches'),
(126, 'SYS', 'PRD_FREIGHTCLASS_NAME', ''),
(127, 'SYS', 'PRD_FREIGHTCLASS_DESCR', ''),
(128, 'SYS', 'PRD_STACKABLE_NAME', ''),
(129, 'SYS', 'PRD_STACKABLE_DESCR', ''),
(130, 'SYS', 'PRD_PACKAGETYPE_NAME', ''),
(131, 'SYS', 'PRD_PACKAGETYPE_DESCR', ''),
(132, 'SYS', 'PRD_FREESHIP_NAME', 'Free Shipping'),
(133, 'SYS', 'PRD_FREESHIP_DESCR', 'Shows whether the product can be delivered to the customer free of charge.'),
(134, 'SYS', 'PRD_PAGETTL_NAME', 'Page Title'),
(135, 'SYS', 'PRD_PAGETTL_DESCR', 'You can enter the page title for a given product here. This title will be displayed in the top part of the browser, in the title bar. This title is also used by search engines for page indexation purposes.'),
(136, 'SYS', 'PRD_METAKWRD_NAME', 'META Keywords'),
(137, 'SYS', 'PRD_METAKWRD_DESCR', 'Key words for this product. This information is used by search engines for page indexation purposes.'),
(138, 'SYS', 'PRD_METADESCR_NAME', 'META Description'),
(139, 'SYS', 'PRD_METADESCR_DESCR', 'The description of the product to be used by search engines. This information is used by search engines for page indexation purposes.'),
(140, 'SYS', 'PRD_NEEDSHIP_NAME', 'Need Shipping'),
(141, 'SYS', 'PRD_NEEDSHIP_DESCR', 'Indicates whether the product should be shipped via the default shipping method'),
(142, 'SYS', 'PRD_SEOURL_NAME', 'SEO URL prefix'),
(143, 'SYS', 'PRD_SEOURL_DESCR', 'This string will be added to the beginning of the URL which leads to the product info page. The following characters are accepted: ''a-z'', ''A-Z'', ''0-9'', ''-'', and ''_''. All other symbols will be automatically replaced with an underscore ''_''.'),
(144, 'SYS', 'PRD_CUSTOMER_REVIEWS_NAME', 'Customer Reviews'),
(145, 'SYS', 'PRD_CUSTOMER_REVIEWS_DESCR', 'Customer ability to write reviews of this product or rate it'),
(146, 'SYS', 'PT_ATTRGRP_001', 'Key Product Details'),
(147, 'SYS', 'PT_ATTRGRP_002', 'Main Product Image'),
(148, 'SYS', 'PT_ATTRGRP_003', 'Product Descriptions'),
(149, 'SYS', 'PT_ATTRGRP_004', 'Shipping Information'),
(150, 'SYS', 'PT_ATTRGRP_005', 'Search Engine Information'),
(151, 'SYS', 'PT_ATTRGRP_006', 'Custom Attributes'),
(152, 'SYS', 'PT_ATTRGRP_007', 'Customer Reviews Information'),
(153, 'SYS', 'PT_ATTRGRP_008', 'Membership Visibility'),
(154, 'SYS', 'PRDTYPE_VALUE_YES', 'YES'),
(155, 'SYS', 'PRDTYPE_VALUE_NO', 'NO'),
(156, 'SYS', 'PRDTYPE_VALUE_LBS', 'lbs'),
(157, 'SYS', 'PRDTYPE_VALUE_KG', 'kg'),
(158, 'SYS', 'PRDTYPE_VALUE_GRAM', 'gram'),
(159, 'SYS', 'PRDTYPE_VALUE_ITEM', 'Item(s)'),
(160, 'SYS', 'PRDTYPE_VALUE_REVIEW_RATE', 'Review & Rating'),
(161, 'SYS', 'PRDTYPE_VALUE_REVIEW', 'Review only'),
(162, 'SYS', 'PRDTYPE_VALUE_RATE', 'Rating only'),
(163, 'SYS', 'PRDTYPE_VALUE_NOREVIEW', 'None'),
(164, 'SYS', 'PRDTYPE_VALUE_NOT_SELECTED', 'Not defined'),
(165, 'SYS', 'PRDTYPE_VALUE_ACCESSORIES_CLOTHING', 'Apparel & Accessories > Clothing'),
(166, 'SYS', 'PRDTYPE_VALUE_ACCESSORIES_SHOES', 'Apparel & Accessories > Shoes'),
(167, 'SYS', 'PRDTYPE_VALUE_ACCESSORIES', 'Apparel & Accessories'),
(168, 'SYS', 'PRDTYPE_VALUE_MEDIA_BOOKS', 'Media > Books'),
(169, 'SYS', 'PRDTYPE_VALUE_MEDIA_DVD', 'Media > DVDs & Videos'),
(170, 'SYS', 'PRDTYPE_VALUE_MEDIA_MUSIC', 'Media > Music'),
(171, 'SYS', 'PRDTYPE_VALUE_SOFTWARE_VIDEO_GAME', 'Software > Video Game Software'),
(172, 'SYS', 'PRDTYPE_VALUE_ADULT', 'adult'),
(173, 'SYS', 'PRDTYPE_VALUE_KIDS', 'kids'),
(174, 'SYS', 'PRDTYPE_VALUE_MALE', 'male'),
(175, 'SYS', 'PRDTYPE_VALUE_FEMALE', 'female'),
(176, 'SYS', 'PRDTYPE_VALUE_UNISEX', 'unisex'),
(177, 'SYS', 'CTGR_HOME_NAME', 'Home'),
(178, 'SYS', 'CTGR_HOME_DESCR', 'Description of category Home'),
(179, 'SYS', 'PRDTYPE_GENERAL_NAME', 'General Products'),
(180, 'SYS', 'PRDTYPE_GENERAL_DESCR', 'This type is common for the majority of products'),
(181, 'SYS', 'PT_TYPEID_NAME', 'Product Type ID'),
(182, 'SYS', 'PT_TYPEID_DESCR', 'Product type identifier. This is a numerical value.'),
(183, 'SYS', 'PT_TYPENAME_NAME', 'Product Type'),
(184, 'SYS', 'PT_TYPENAME_DESCR', 'Name of the product type. This is used when adding a new product.'),
(185, 'SYS', 'PT_TYPEDESCR_NAME', 'Product Type Description'),
(186, 'SYS', 'PT_TYPEDESCR_DESCR', 'Short description of the product type.'),
(187, 'SYS', 'CAT_ID_NAME', 'Category ID'),
(188, 'SYS', 'CAT_ID_DESCR', 'Category ID (same as subcategory ID) is a unique digital identifier of a product category. This identifier is assigned to a category by the system as a numeric value (e.g. 45). This assigned number uniquely identifies the category among multiple other categories. '),
(189, 'SYS', 'CAT_NAME_NAME', 'Category Name'),
(190, 'SYS', 'CAT_NAME_DESCR', 'Defines the category name. For instance, if your store sells books on e-commerce, you may use ''E-Commerce'' as one of the category names.'),
(191, 'SYS', 'CAT_DESCR_NAME', 'Description'),
(192, 'SYS', 'CAT_DESCR_DESCR', 'You can enter the description for a given category here.'),
(193, 'SYS', 'CAT_LRGIMG_NAME', 'Large Image'),
(194, 'SYS', 'CAT_LRGIMG_DESCR', 'Allows to upload a corresponding image for the category.'),
(195, 'SYS', 'CAT_SMLIMG_NAME', 'Small Image'),
(196, 'SYS', 'CAT_SMLIMG_DESCR', 'Allows to upload a corresponding thumbnail image for the category.'),
(197, 'SYS', 'CAT_SMLIMG_HINT', 'If you do not upload a small image (thumbnail), it will be created automatically<br />based on the full image.<br />'),
(198, 'SYS', 'CAT_IMGDESCR_NAME', 'Image Description'),
(199, 'SYS', 'CAT_IMGDESCR_DESCR', 'You can enter the description of an image for a given category here.'),
(200, 'SYS', 'CAT_PAGETTL_NAME', 'Page Title'),
(201, 'SYS', 'CAT_PAGETTL_DESCR', 'You can enter the page title for a given category here. This title will be displayed in the top part of the browser, in the title bar. This title is also used by search engines for page indexation purposes.'),
(202, 'SYS', 'CAT_METAKWRD_NAME', 'Meta Keywords'),
(203, 'SYS', 'CAT_METAKWRD_DESCR', 'The keywords for this category. This information is used by search engines for page indexation purposes.'),
(204, 'SYS', 'CAT_METADESCR_NAME', 'Meta Description'),
(205, 'SYS', 'CAT_METADESCR_DESCR', 'The description of the category to be used by search engines. This information is used by search engines for page indexation purposes.'),
(206, 'SYS', 'CUSTSL_TAG_NAME', 'Attribute Tag'),
(207, 'SYS', 'CUSTSL_TAG_DESCR', 'The store tag name. The tag name distinguishes a given attribute from other attributes created by the user or attributes available in the system by default. The tag name must be entered without any blank spaces. Allowable characters and digits are 0, 1, 2...9, A-Z, a-z, -, _. For example, if you create an attribute describing the size of a flower bouquet, you can name it FlowerDimensions (no black spaces). <br><br>Attention: You cannot change or edit Attribute Tags after creation.<br><br>Note: Functional word Product will be automatically appended to the tag name. For instance, if you have created custom attribute FlowerDimensions, you need to use the <?php ProductFlowerDimensions() ?> tag in the templates. Please refer to the documentation for additional details about the Avactis tags.'),
(208, 'SYS', 'CUSTSL_NAME_NAME', 'Attribute Name'),
(209, 'SYS', 'CUSTSL_NAME_DESCR', 'Defines the attribute name. For example, you may use Flower Dimensions to describe an attribute representing the dimensions of a flower bouquet. An attribute name can contain any characters, as well as blank spaces.'),
(210, 'SYS', 'CUSTSL_DESCR_NAME', 'Attribute Description'),
(211, 'SYS', 'CUSTSL_DESCR_DESCR', 'Defines the attribute description. For instance, you may write ''''This attribute describes the physical dimensions of a flower bouquet. Example: 16''''H x 12''''W.'''' '),
(212, 'SYS', 'CUSTSL_VALUES_NAME', 'Attribute Values'),
(213, 'SYS', 'CUSTSL_VALUES_DESCR', 'Defines the attribute values.'),
(214, 'SYS', 'CUSTBT_TAG_NAME', 'Attribute Tag'),
(215, 'SYS', 'CUSTBT_TAG_DESCR', 'The store tag name. The tag name distinguishes a given attribute from other attributes created by the user or attributes available in the system by default. The tag name must be entered without any blank spaces. Allowable characters and digits are 0, 1, 2...9, A-Z, a-z, -, _. For instance, if you create an attribute describing the features of a TV set, you can name it TVSetFeatures (no blank spaces).<br><br>Attention: You cannot change or edit Attribute Tags after creation.<br><br>Note: Functional word Product at the beginning will be automatically appended to the tag name. For instance, if you have created custom attribute TVSetFeatures, you need to use the <?php ProductTVSetFeatures() ?> tag in the templates. Please refer to the documentation for additional details about the Avactis tags.'),
(216, 'SYS', 'CUSTBT_NAME_NAME', 'Attribute Name'),
(217, 'SYS', 'CUSTBT_NAME_DESCR', 'Defines the attribute name. For instance, you may write ''TV Set Features'' to describe the features of a TV set. An attribute name can contain any characters, as well as blank spaces.'),
(218, 'SYS', 'CUSTBT_DESCR_NAME', 'Attribute Description'),
(219, 'SYS', 'CUSTBT_DESCR_DESCR', 'Defines the attribute description. For instance, you may write ''''This attribute allows you to define TV set features.'''' '),
(220, 'SYS', 'CUSTBT_DEFVAL_NAME', 'Default Value'),
(221, 'SYS', 'CUSTBT_DEFVAL_DESCR', 'Defines the default value of the attribute. This value may be represented both as regular text or HTML text.'),
(222, 'SYS', 'CUSTBT_VALUES_NAME', 'Attribute Values'),
(223, 'SYS', 'CUSTBT_VALUES_DESCR', 'Defines the attribute values.'),
(224, 'SYS', 'PRTYPE_VALUE_NOT_SELECTED', 'Not defined'),
(225, 'SYS', 'PRTYPE_CUST_ATTR_SELECT', 'Select'),
(226, 'SYS', 'PRDTYPE_CUST_ATTR_PAGE_HEADER', 'Product Type:'),
(227, 'SYS', 'PRDTYPE_CUST_ATTR_PAGE_NAME_SL', 'Attribute Format: Single Line Text and Numbers'),
(228, 'SYS', 'PRDTYPE_CUST_ATTR_PAGE_NAME_BT', 'Attribute Format: Large Text'),
(229, 'SYS', 'PRDTYPE_CUST_ATTR_PAGE_NAME_SEL', 'Attribute Format: Select options'),
(230, 'SYS', 'CTLG_TAB_PAGE_TITLE', 'Catalog'),
(231, 'SYS', 'CTLG_TAB_PAGE_NAME', 'Catalog'),
(232, 'SYS', 'CTLG_TAB_001', 'Catalog Management'),
(233, 'SYS', 'CTLG_TAB_002', 'Manage Products'),
(234, 'SYS', 'CTLG_TAB_003', 'Add, edit and delete products.'),
(235, 'SYS', 'CTLG_TAB_004', 'Manage Categories'),
(236, 'SYS', 'CTLG_TAB_005', 'Add, edit and delete categories.'),
(237, 'SYS', 'CTLG_TAB_006', 'Manage Product Types'),
(238, 'SYS', 'CTLG_TAB_007', 'Manage the types of products to be added to the catalog.'),
(239, 'SYS', 'CTLG_TAB_SEARCH', 'Catalog Search'),
(240, 'SYS', 'CTLG_TAB_SEARCH_RESULT', 'Catalog Search Result'),
(241, 'SYS', 'CTLG_MANUFACTURERS_PAGE_TITLE', 'Manufacturers'),
(242, 'SYS', 'MNG_CTGR_PAGE_NAME', 'Manage Categories'),
(243, 'SYS', 'MNG_CTGR_CURR_CTGR', 'Current Category:'),
(244, 'SYS', 'MNG_CTGR_CURR_PRD', 'Current Product:'),
(245, 'SYS', 'MNG_CTGR_COL_HDR_001', 'Subcategories'),
(246, 'SYS', 'MNG_CTGR_COL_HDR_002', 'Subcategory ID'),
(247, 'SYS', 'MNG_CTGR_COL_HDR_003', 'Products'),
(248, 'SYS', 'MNG_CTGR_COL_HDR_004', 'Included Categories'),
(249, 'SYS', 'MNG_CTGR_EMPTY', 'No Subcategories'),
(250, 'SYS', 'MNG_CTGR_EMPTY_NA', 'NA'),
(251, 'SYS', 'MNG_MNFS_PAGE_NAME', 'Manage manufacturers'),
(252, 'SYS', 'MNG_PRTYPE_PAGE_NAME', 'Manage Product Types'),
(253, 'SYS', 'MNG_PRTYPE_PAGE_HEADER', 'Available Product Types'),
(254, 'SYS', 'MNG_PRTYPE_PAGE_DESCR', 'This section is used to edit and add the forms for entering data for specific product types.'),
(255, 'SYS', 'MNG_PRTYPE_CURR_PRTYPE', 'Current Product Type:'),
(256, 'SYS', 'PRTYPE_ADD_PAGE_TITLE', 'Add Product Type'),
(257, 'SYS', 'PRTYPE_ADD_PAGE_NAME', 'New Product Type'),
(258, 'SYS', 'PRTYPE_ADD_PAGE_DESCR', 'This section shows attributes that define the parameters of the selected product type. You can add/delete product attributes as required. You can also hide unwanted attributes using the ''<strong>Visibility</strong>'' option.'),
(259, 'SYS', 'PRTYPE_ADD_COL_HDR_001', 'Visibility'),
(260, 'SYS', 'PRTYPE_ADD_COL_HDR_002', 'Attributes'),
(261, 'SYS', 'PRTYPE_ADD_COL_HDR_003', 'Default Values'),
(262, 'SYS', 'PRTYPE_ADD_NEW_CUST_ATTR', 'New Custom Attribute'),
(263, 'SYS', 'PRTYPE_CUST_ATTR_BGTXT', 'Large Text'),
(264, 'SYS', 'PRTYPE_CUST_ATTR_SNGLLN', 'Text and Numbers (Single Line)'),
(265, 'SYS', 'PRTYPE_CUST_ATTR_FRM_LABEL', 'Attribute Format'),
(266, 'SYS', 'PRTYPE_ATTR_NO_DEF_VALUE', 'No Default Value'),
(267, 'SYS', 'PRTYPE_EDIT_PAGE_TITLE', 'Edit Product Type'),
(268, 'SYS', 'PRTYPE_EDIT_PAGE_NAME', 'Edit Product Type'),
(269, 'SYS', 'PRTYPE_DEL_PAGE_TITLE', 'Delete Product Type(s)'),
(270, 'SYS', 'PRTYPE_DEL_PAGE_NAME', 'Manage Product Types'),
(271, 'SYS', 'PRTYPE_DEL_HEADER_001', 'Product types to be deleted'),
(272, 'SYS', 'PRTYPE_DEL_COMMON_WARNING', 'Select product types to be deleted.<br> WARNING!!! You will not be able to restore product types after deletion.'),
(273, 'SYS', 'PRTYPE_DEL_WARNING', 'Deletion impossible, because there are {0} product(s) of this product type in the catalog. To continue, please first delete product(s) of this type.'),
(274, 'SYS', 'PRTYPE_DEL_GENPR_WARNING', '. This product type is system-defined and cannot be deleted.'),
(275, 'SYS', 'PRTYPE_DEL_CONFIRM', 'Are you sure you want to delete selected product types?'),
(276, 'SYS', 'PRTYPE_DEL_ALERT', 'Select product types to be deleted.'),
(277, 'SYS', 'ADD_CTGR_PAGE_NAME', 'New Category Details'),
(278, 'SYS', 'ADD_CTGR_GRP_001', 'Category  Image'),
(279, 'SYS', 'ADD_CTGR_GRP_002', 'Search Engine Information'),
(280, 'SYS', 'EDIT_CTGR_PAGE_NAME', 'Category Details'),
(281, 'SYS', 'MOVE_CTGR_EMPTY_CTGR', 'There are no subcategories in the current category.'),
(282, 'SYS', 'MOVE_CTGR_HEADER', 'Selected Category:'),
(283, 'SYS', 'MOVE_CTGR_NEW_LOCATION', 'Target Location:'),
(284, 'SYS', 'MOVE_CTGR_CRNT_LOCATION', 'Current Location:'),
(285, 'SYS', 'MOVE_CTGR_FOR_NEW_LOCATION', 'Category for New Location:'),
(286, 'SYS', 'MOVE_CTGR_SUBCTGR_LABEL', 'Select Subcategory'),
(287, 'SYS', 'DEL_CTGR_001', 'products.'),
(288, 'SYS', 'DEL_CTGR_HEADER', 'Subcategories and products to be deleted'),
(289, 'SYS', 'DEL_CTGR_WARNING', 'WARNING!!! You have selected category ''{0}'' for deletion. All subcategories and products in category ''{0}'' will be deleted. You will not be able to restore them after deletion.'),
(290, 'SYS', 'INFO_CTGR_PAGE_NAME', 'Category Details'),
(291, 'SYS', 'INFO_CTGR_NO_IMG', 'No Image'),
(292, 'SYS', 'SORT_CTGR_001', 'Sort'),
(293, 'SYS', 'SORT_CTGR_OBJ_CAP_PLRL', 'Subcategories'),
(294, 'SYS', 'SORT_CTGR_OBJ_CAP_SNGL', 'Subcategory'),
(295, 'SYS', 'SORT_CTGR_OBJ_PLRL', 'subcategories'),
(296, 'SYS', 'SORT_CTGR_OBJ_SNGL', 'subcategory'),
(297, 'SYS', 'SORT_CTGR_002', 'Below is a list of {0} in the category &quot;{1}&quot;. To change the sequence of {0}, select a {2} and adjust its position in the list by clicking the up and down arrow buttons.'),
(298, 'SYS', 'SORT_CTGR_003', 'Sequence of {0} in the category <span class=''required''>&quot;{1}&quot;</span>'),
(299, 'SYS', 'SORT_CTGR_004', 'Move up'),
(300, 'SYS', 'SORT_CTGR_005', 'Move one line up'),
(301, 'SYS', 'SORT_CTGR_006', 'Move one line down'),
(302, 'SYS', 'SORT_CTGR_007', 'Move down'),
(303, 'SYS', 'MNG_PRD_PAGE_NAME', 'Manage Products'),
(304, 'SYS', 'MNG_PRD_CURR_CTGR', 'Current Category:'),
(305, 'SYS', 'MNG_PRD_HEADER_001', 'Product(s) {0} - {1} of {2} in this category.'),
(306, 'SYS', 'MNG_PRD_HEADER_002', '{0} product(s) in {1} included subcategory of this category.'),
(307, 'SYS', 'MNG_PRD_HEADER_003', '{0} product(s) in {1} included subcategories of this category.'),
(308, 'SYS', 'MNG_PRD_HEADER_004', 'Go To Subcategory'),
(309, 'SYS', 'MNG_PRD_SUBCTGR_OPT_001', '{0} - {1} product(s), {2} subcategory'),
(310, 'SYS', 'MNG_PRD_SUBCTGR_OPT_002', '{0} - {1} product(s), {2} subcategories'),
(311, 'SYS', 'MNG_PRD_COL_HDR_001', 'N'),
(312, 'SYS', 'MNG_PRD_COL_HDR_002', 'Image'),
(313, 'SYS', 'MNG_PRD_COL_HDR_003', 'ID'),
(314, 'SYS', 'MNG_PRD_COL_HDR_SKU', 'SKU'),
(315, 'SYS', 'MNG_PRD_COL_HDR_004', 'Name'),
(316, 'SYS', 'MNG_PRD_COL_HDR_005', 'Price'),
(317, 'SYS', 'MNG_PRD_COL_HDR_006', 'Quantity'),
(318, 'SYS', 'MNG_PRD_COL_HDR_007', 'Updated'),
(319, 'SYS', 'MNG_PRD_COL_HDR_008', 'Info/Status'),
(320, 'SYS', 'MNG_PRD_FOOTER', 'Current Category:'),
(321, 'SYS', 'MNG_PRD_EMPTY', 'No Products'),
(322, 'SYS', 'MNG_PRD_EMPTY_NA', 'NA'),
(323, 'SYS', 'MNG_PRD_PRD_LABEL', 'prod.'),
(324, 'SYS', 'ADD_PRD_PAGE_NAME', 'Add New Product'),
(325, 'SYS', 'ADD_PRD_PRDTYPE_SELECT', '--- SELECT PRODUCT TYPE ---'),
(326, 'SYS', 'ADD_PRD_PRDTYPE_WRNG', 'Please select Product Type first.'),
(327, 'SYS', 'INFO_PRD_PAGE_NAME', 'Product Details'),
(328, 'SYS', 'EDIT_PRD_PAGE_NAME', 'Product Details'),
(329, 'SYS', 'MOVE_PRD_HEADER', 'Selected: {0} product(s)'),
(330, 'SYS', 'COPY_PRD_HEADER', 'Selected: {0} product(s)'),
(331, 'SYS', 'DEL_PRD_HEADER', 'Products to be deleted'),
(332, 'SYS', 'DEL_PRD_WARNING', 'WARNING!!! You selected products in category ''{0}'' for deletion. You will not be able to restore them after deletion.'),
(333, 'SYS', 'SORT_PRD_OBJ_CAP_PLRL', 'Products'),
(334, 'SYS', 'SORT_PRD_OBJ_CAP_SNGL', 'Product'),
(335, 'SYS', 'SORT_PRD_OBJ_PLRL', 'products'),
(336, 'SYS', 'SORT_PRD_OBJ_SNGL', 'product'),
(337, 'SYS', 'ADMIN_MENU_PAGE_TITLE', 'Avactis Shopping Cart'),
(338, 'SYS', 'ADMIN_MENU_PAGE_NAME', 'Admin'),
(339, 'SYS', 'ADMIN_MENU_HEADER_001', 'Administration'),
(340, 'SYS', 'ADMIN_MENU_HEADER_002', 'Tools'),
(341, 'SYS', 'ADMIN_MENU_HEADER_003', 'Advanced Settings & Configuration'),
(342, 'SYS', 'ADMIN_MENU_MEMBERS', 'Admin Members'),
(343, 'SYS', 'ADMIN_MENU_MEMBERS_DESCR', 'Add, edit, delete or change admin members'' rights.'),
(344, 'SYS', 'ADMIN_MENU_BACKUP', 'Backup/Restore'),
(345, 'SYS', 'ADMIN_MENU_BACKUP_DESCR', 'Create a backup copy of the database including product catalog, images, orders and all the settings. Restore database from backup.'),
(346, 'SYS', 'ADMIN_MENU_SERVERINFO', 'Application/Server Info'),
(347, 'SYS', 'ADMIN_MENU_SERVERINFO_DESCR', 'Information about the server and the current version of the software.'),
(348, 'SYS', 'ADMIN_MENU_LICENSEINFO', 'License'),
(349, 'SYS', 'ADMIN_MENU_LICENSEINFO_DESCR', 'Information about the software license.'),
(350, 'SYS', 'ADMIN_MENU_HTTPSSETTINGS', 'HTTPS Settings'),
(351, 'SYS', 'ADMIN_MENU_HTTPSSETTINGS_DESCR', 'The configuration of SSL Admin Area and the settings for enabling fully functional SSL in Storefront.'),
(352, 'SYS', 'ADMIN_MENU_MAILSETTINGS', 'Mail Settings'),
(353, 'SYS', 'ADMIN_MENU_MAILSETTINGS_DESCR', 'The configuration of mail sending functions.'),
(354, 'SYS', 'ADMIN_MENU_TIMELINE', 'View System Logs'),
(355, 'SYS', 'ADMIN_MENU_TIMELINE_DESCR', 'The system log module allows you to review application events for debugging the storefront.'),
(356, 'SYS', 'ADMIN_MENU_SITEMAP', 'Genrate Sitemap'),
(357, 'SYS', 'ADMIN_MENU_SITEMAP_DESCR', 'This creates sitemap for your website which will be helpful for search engines to crawl your website.'),
(358, 'SYS', 'ADMIN_MENU_CHAT_CONFIGURE', 'Chat Configure'),
(359, 'SYS', 'ADMIN_MENU_CHAT_CONFIGURE_DESCR', 'This will configure Chat System.'),
(360, 'SYS', 'SIGN_IN_PAGE_TITLE', 'Avactis Shopping Cart'),
(361, 'SYS', 'SIGN_IN_PAGE_NAME', 'Sign In'),
(362, 'SYS', 'SIGN_IN_001', 'Please enter your Email Address and Password to access your account.'),
(363, 'SYS', 'SIGN_IN_002', 'Email Address:'),
(364, 'SYS', 'SIGN_IN_003', 'Password:'),
(365, 'SYS', 'SIGN_IN_004', 'Remember My Email Address'),
(366, 'SYS', 'SIGN_IN_005', 'Sign In'),
(367, 'SYS', 'SIGN_IN_006', 'I forgot My Password'),
(368, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_001', 'Sign In Error:&nbsp;You need to have JavaScript enabled in order to access Avactis administrator area.'),
(369, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_002', '1. Your browser may not support JavaScript.'),
(370, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_003', 'If your browser does not support JavaScript, you must upgrade to a newer version. We recommend using <a href=''http://www.microsoft.com/windows/ie/''> Internet Explorer 5</a> or higher or <a href=''http://www.netscape.com/download/''> Netscape 6</a> or higher.'),
(371, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_004', '2. JavaScript may be disabled.'),
(372, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_005', 'If JavaScript is disabled in your browser, you must enable it in order to continue.'),
(373, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_006', 'To enable JavaScript, follow the instructions below for your browser.'),
(374, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_007', '<B>Internet Explorer 5 or higher:</B><br>1. Click Tools, then click Internet Options.<br>2. Click the Security tab.<br>3. Click the Custom Level button.<br>4. Scroll to the Scripting section.<br>5. Check Enable under Active scripting, Allow paste operations via script, and Scripting of Java applets.<br>6. Click the OK button.'),
(375, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_008', '<B>Netscape 6.x or higher:</B><br>1. Click Edit, then click Preferences<br>2. Click on Advanced.<br>3. Check Enable JavaScript for Navigator.<br>4. Click the OK button.'),
(376, 'SYS', 'SIGN_IN_JS_DISABLED_ERR_009', 'Please consult your browser''s help section for further information concerning JavaScript settings.'),
(377, 'SYS', 'SIGN_IN_BLOCKED_PAGE_TITLE', 'Avactis Shopping Cart'),
(378, 'SYS', 'SIGN_IN_BLOCKED_001', 'Due to multiple attempts to access the system using invalid login and password, access to the system was temporarily blocked. Please try again later.'),
(379, 'SYS', 'SIGN_IN_TIMEOUT_001', '5 minutes'),
(380, 'SYS', 'SIGN_IN_TIMEOUT_002', '10 minutes'),
(381, 'SYS', 'SIGN_IN_TIMEOUT_003', '15 minutes'),
(382, 'SYS', 'SIGN_IN_TIMEOUT_004', '30 minutes'),
(383, 'SYS', 'SIGN_IN_TIMEOUT_005', '60 minutes'),
(384, 'SYS', 'SIGN_IN_TIMEOUT_006', '2 hours'),
(385, 'SYS', 'SIGN_IN_TIMEOUT_007', '5 hours'),
(386, 'SYS', 'SIGN_IN_TIMEOUT_008', '10 hours'),
(387, 'SYS', 'SIGN_IN_TIMEOUT_009', '24 hours'),
(388, 'SYS', 'SIGN_IN_DELTA_TIME_001', '10 minutes'),
(389, 'SYS', 'SIGN_IN_DELTA_TIME_002', '20 minutes'),
(390, 'SYS', 'SIGN_IN_DELTA_TIME_003', '30 minutes'),
(391, 'SYS', 'SIGN_IN_DELTA_TIME_004', '60 minutes'),
(392, 'SYS', 'SIGN_IN_DELTA_TIME_005', '2 hours'),
(393, 'SYS', 'SIGN_IN_DELTA_TIME_006', '3 hours'),
(394, 'SYS', 'SIGNIN_001', 'Sign In Error: Unknown email address or password. Both an email address and a password must be given. Make sure your CapsLock key is off, and try again.'),
(395, 'SYS', 'PSWUPD_000', 'The E-mail address is not valid. (PSWUPD_000)'),
(396, 'SYS', 'PSWUPD_001', 'The Current password you entered  doesn''t match the existing password. (PSWUPD_001)'),
(397, 'SYS', 'PSWUPD_002', 'The New passwords you entered don''t match. (PSWUPD_002)'),
(398, 'SYS', 'PSWUPD_003', 'All Fields must be filled - E-mail, Current Password, New Password and Verify New Password. (PSWUPD_003)'),
(399, 'SYS', 'PSWUPD_004', 'Password Policy Failure - Your new password must be between 8 and 32 characters in length. (PSWUPD_004)'),
(400, 'SYS', 'PSWUPD_005', 'Password Policy Failure - Your new password must contain at least one character from any two of the following groups: (1) Lowercase characters, (2)Uppercase characters,  (3) Numbers, (4) Punctuation marks. (PSWUPD_005)'),
(401, 'SYS', 'PSWUPD_006', 'Password Policy Failure - Your new password must be different from current password. (PSWUPD_006)'),
(402, 'SYS', 'PSWUPD_007', 'Password Policy Failure - Your new password must be different from e-mail. (PSWUPD_007)'),
(403, 'SYS', 'PSWREC_001', 'ERROR: This e-mail address is not registered in the system. Please check whether you entered your e-mail address correctly and try again.'),
(404, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_PAGE_TITLE', 'Avactis Shopping Cart'),
(405, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_001', 'Password Recovery'),
(406, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_002', 'To recover your password, please enter your e-mail address here.<BR> After you click &quot;Submit&quot;, a new password will be sent to your e-mail address.'),
(407, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_003', 'Email Address:'),
(408, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_004', 'Submit'),
(409, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_005', 'A new password has been sent to the e-mail address you specified, i.e. to {0}.<BR> Pursuant to our security policy, you need to change this password after you have logged into the system.'),
(410, 'SYS', 'SIGN_IN_PASSWD_RECOVERY_006', 'Continue'),
(411, 'SYS', 'SIGN_IN_PASSWD_UPDATE_PAGE_TITLE', 'Avactis Shopping Cart'),
(412, 'SYS', 'SIGN_IN_PASSWD_UPDATE_001', 'Password Update'),
(413, 'SYS', 'SIGN_IN_PASSWD_UPDATE_002', 'You are logging into the system for the first time, or your password was changed by the administrator, or a new password was sent to you upon your request.<BR> For security reasons, you must change the password.<BR> Please keep your password in a secure place.'),
(414, 'SYS', 'SIGN_IN_PASSWD_UPDATE_003', 'Your new password must conform to the following password policy:'),
(415, 'SYS', 'SIGN_IN_PASSWD_UPDATE_004', '<UL><LI>it should be different from the current password<LI>it should be different from your e-mail address<LI>its length should be from 8 (minimum) to 32 (maximum) characters<LI>it should contain characters of at least two types listed below:<UL><LI>Lowercase characters<LI>Uppercase characters<LI>Numbers<LI>Punctuation characters</UL></UL>'),
(416, 'SYS', 'SIGN_IN_PASSWD_UPDATE_005', 'Email Address:*'),
(417, 'SYS', 'SIGN_IN_PASSWD_UPDATE_006', 'Current Password:*'),
(418, 'SYS', 'SIGN_IN_PASSWD_UPDATE_007', 'New Password:*'),
(419, 'SYS', 'SIGN_IN_PASSWD_UPDATE_008', 'Verify New Password:*'),
(420, 'SYS', 'PGNTR_PG', 'Page'),
(421, 'SYS', 'PGNTR_RPPG', 'Number of {0} displayed:'),
(422, 'SYS', 'PGNTR_PREV', 'PREV'),
(423, 'SYS', 'PGNTR_NEXT', 'NEXT'),
(424, 'SYS', 'PGNTR_PRD_ITEMS', 'products'),
(425, 'SYS', 'PGNTR_CTGR_ITEMS', 'categories'),
(426, 'SYS', 'PGNTR_ORD_ITEMS', 'orders'),
(427, 'SYS', 'PGNTR_CUST_ITEMS', 'customers'),
(428, 'SYS', 'PGNTR_REC_ITEMS', 'records'),
(429, 'SYS', 'PGNTR_CR_ITEMS', 'customer reviews'),
(430, 'SYS', 'PGNTR_EMLS_ITEMS', 'emails'),
(431, 'SYS', 'PGNTR_ML_LABEL_ITEMS', 'labels'),
(432, 'SYS', 'PGNTR_CMS_MENU_ITEMS', 'menu'),
(433, 'SYS', 'PGNTR_CMS_PAGE_ITEMS', 'articles'),
(434, 'SYS', 'PGNTR_GC_ITEMS', 'gift certificates'),
(435, 'SYS', 'HELP_ATTR_PAGE_NAME', 'Attribute:'),
(436, 'SYS', 'HELP_CUST_ATTR_PAGE_NAME', 'Field:'),
(437, 'SYS', 'HELP_ATTR_PAGE_HEADER', 'Attribute Name:'),
(438, 'SYS', 'HELP_CUST_ATTR_PAGE_HEADER', 'Field Name:'),
(439, 'SYS', 'HELP_ATTR_FIELD_DESCR', 'Description:'),
(440, 'SYS', 'HELP_ATTR_TAG', 'Attribute Tag:'),
(441, 'SYS', 'ORDERS_HEADER_001', 'Orders'),
(442, 'SYS', 'ORDERS_SEARCH_QUICK_ORDER_NAVIGATION', 'Quick Order Navigation'),
(443, 'SYS', 'ORDERS_SEARCH_ORDERS', 'Search Orders'),
(444, 'SYS', 'ORDERS_SEARCH_NEW_ORDERS', 'New Orders'),
(445, 'SYS', 'ORDERS_SEARCH_IN_PROGRESS', 'In progress'),
(446, 'SYS', 'ORDERS_SEARCH_READY_TO_SHIP', 'Ready to Ship'),
(447, 'SYS', 'ORDERS_SEARCH_FILTER', 'Filter'),
(448, 'SYS', 'ORDERS_SEARCH_ALL', 'All'),
(449, 'SYS', 'ORDERS_SEARCH_FROM', 'From'),
(450, 'SYS', 'ORDERS_SEARCH_TO', 'To'),
(451, 'SYS', 'ORDERS_SEARCH_TYPE', 'Orders'),
(452, 'SYS', 'ORDERS_SEARCH_PAYMENT_TYPE', 'Payments'),
(453, 'SYS', 'ORDERS_SEARCH_ORDER_ID', 'Order ID'),
(454, 'SYS', 'ORDERS_SEARCH_OK', 'Search'),
(455, 'SYS', 'ORDERS_SEARCH_STATUSES', 'Order statuses'),
(456, 'SYS', 'ORDERS_PAYMENT_SEARCH_STATUSES', 'Payment statuses'),
(457, 'SYS', 'ORDERS_RESULTS_NEW_ORDERS', 'New Orders'),
(458, 'SYS', 'ORDERS_RESULTS_DATE', 'Date'),
(459, 'SYS', 'ORDERS_RESULTS_MORE_THEN_ROWS_PER_PAGE_FOUND', '{0} - {1} of {2} order(s) found.'),
(460, 'SYS', 'ORDERS_RESULTS_LESS_THEN_ROWS_PER_PAGE_FOUND', '{0} order(s) found.'),
(461, 'SYS', 'ORDERS_RESULTS_AMOUNT', 'Amount'),
(462, 'SYS', 'ORDERS_RESULTS_TAX_TOTAL', 'Tax'),
(463, 'SYS', 'ORDERS_RESULTS_TAX_FULL_EXEMPTION_TOTAL', 'Tax Exemption Total'),
(464, 'SYS', 'ORDERS_RESULTS_TAX_TOTAL_MINUS_TAX_FULL_EXEMPTION_TOTAL', 'Tax Total'),
(465, 'SYS', 'ORDERS_RESULTS_ORDER_ID', 'Order ID'),
(466, 'SYS', 'ORDERS_RESULTS_CUSTOMER', 'Login/E-mail'),
(467, 'SYS', 'ORDERS_RESULTS_CUSTOMER_NAME', 'Customer Name'),
(468, 'SYS', 'ORDERS_RESULTS_ORDER_DATE', 'Order Date'),
(469, 'SYS', 'ORDERS_RESULTS_TAX', 'Tax'),
(470, 'SYS', 'ORDERS_RESULTS_ORDER_STATUS', 'Order Status'),
(471, 'SYS', 'ORDERS_RESULTS_PAYMENT_STATUS', 'Payment Status'),
(472, 'SYS', 'ORDERS_RESULTS_UPDATE', 'Update'),
(473, 'SYS', 'ORDERS_RESULTS_DELETE', 'Delete'),
(474, 'SYS', 'ORDERS_INFO', 'Order Info'),
(475, 'SYS', 'ORDERS_INVOICE', 'INVOICE'),
(476, 'SYS', 'ORDERS_PACKING_SLIP', 'PACKING SLIP'),
(477, 'SYS', 'ORDERS_INFO_ORDER_NUMBER', 'Order Number'),
(478, 'SYS', 'INVOICE_FOR_ORDERS_INFO_ORDER_NUMBER', 'INVOICE for order number'),
(479, 'SYS', 'INVOICE_PRINT', 'Print this page'),
(480, 'SYS', 'PACKING_SLIP_FOR_ORDERS_INFO_ORDER_NUMBER', 'Packing Slip for order number'),
(481, 'SYS', 'ORDERS_INFO_KEY_DETAILS', 'Key Order Details'),
(482, 'SYS', 'ORDERS_INFO_ORDER_CURRENCY', 'Display Order Prices In'),
(483, 'SYS', 'ORDERS_INFO_ORDER_CURRENCY_DESCR', 'The currency the customer selected during order placement OR the currency used for processing the payment at the payment gateway was different from the main online store currency. The order has been saved in both currencies (if all three currencies are different, then in all three currencies) taking into account the exchange rate valid at the moment of order creation. The currency that was the main online store currency at the time of order creation is denoted as (main). The currency the customer selected is denoted as (cs). The currency used as the payment gateway is denoted as (gw).'),
(484, 'SYS', 'ORDERS_INFO_ORDER_ID', 'Order ID'),
(485, 'SYS', 'ORDERS_INFO_INVOICE', 'Invoice'),
(486, 'SYS', 'ORDERS_INFO_PACKING_SLIP', 'Packing Slip'),
(487, 'SYS', 'ORDERS_INFO_ORDER_ID_DESCR', 'Represents the unique ID of an order in the <B>Avactis Shopping Cart</B> system. Each order has an order ID and can be positively identified by its order ID.'),
(488, 'SYS', 'ORDERS_INFO_PAYMENT_PROCESSOR_ORDER_ID', 'Payment Processor Order ID'),
(489, 'SYS', 'ORDERS_INFO_PAYMENT_PROCESSOR_ORDER_ID_DESCR', 'Represents the order ID of an order made through an online payment system. This ID is generated by the online payment system; it can be missing if the payment was made in cash or otherwise without using an online payment system. This ID can also be missing in the event of a glitch that occurred when the payment was processed by an online payment system.'),
(490, 'SYS', 'ORDERS_INFO_ORDER_DATE', 'Order Date'),
(491, 'SYS', 'ORDERS_INFO_ORDER_AMOUNT', 'Order Amount'),
(492, 'SYS', 'ORDERS_INFO_ORDER_STATUS', 'Order Status'),
(493, 'SYS', 'ORDERS_INFO_ORDER_STATUS_DESCR', 'Represents the status of the order.<BR><BR>The order statuses used in Avactis Shopping Cart are listed below. After the customer places an order, the order is assigned a <B>New Order</B> status. The status of an order can be changed manually by the system administrator when processing the order.<BR><BR>When changing order status, there is an option to automatically notify the customer about the order status change. This is done by selecting the appropriate settings in Store Settings >> Email notification options. Such email notifications let you inform your customers about the progress of their orders and help raise their level of commitment and loyalty to your online store.<BR><BR><B>New Order</B> - order has been placed but has not been accepted for processing.<BR><B>In Progress</B> - order has been accepted for processing.<BR><B>Ready to Ship</B> - order has been processed and is ready to be shipped.<BR><B>Shipped</B> - order has been shipped.<BR><B>Cancelled</B> - order has been cancelled.<BR><B>Declined</B> - order has been declined by the online store manager.<BR><B>Completed</B> - order has been completed in full.'),
(494, 'SYS', 'ORDERS_INFO_ORDER_PAYMENT_STATUS', 'Payment Status'),
(495, 'SYS', 'ORDERS_INFO_ORDER_PAYMENT_STATUS_DESCR', 'Represents the status of payment.<BR><BR>The possible payment statuses are listed below. The status of a payment can be changed manually by the system administrator. Also, payment status can be automatically set to Fully Paid by the system if the payment has been successfully completed through an online payment processing system.<BR><BR><B>Waiting</B> - payment is pending or has not been made.<BR><B>Fully Paid</B> - payment has been made in full.<BR><B>Declined</B> - payment has been declined (for example, because a credit card fraud is suspected).'),
(496, 'SYS', 'ORDERS_INFO_PRODUCTS', 'Product(s) Ordered'),
(497, 'SYS', 'ORDERS_INFO_PRODUCTS_SUBTOTAL', 'Subtotal:'),
(498, 'SYS', 'ORDERS_INFO_PRODUCTS_SUBTOTAL_GLOBAL_DISCOUNT', 'Global discount:'),
(499, 'SYS', 'ORDERS_INFO_PRODUCTS_SUBTOTAL_PROMO_CODE_DISCOUNT', 'Promo Code discount'),
(500, 'SYS', 'ORDERS_INFO_PRODUCTS_QUANTITY_DISCOUNT', 'Quantity discount:'),
(501, 'SYS', 'ORDERS_INFO_PRODUCTS_DISCOUNTED_SUBTOTAL', 'Discounted Subtotal:'),
(502, 'SYS', 'ORDERS_INFO_PRODUCTS_SHIPPING', 'Shipping and Handling'),
(503, 'SYS', 'ORDERS_INFO_PRODUCTS_TAX', 'Tax'),
(504, 'SYS', 'ORDERS_INFO_PRODUCTS_TOTAL', 'Total:'),
(505, 'SYS', 'ORDERS_INFO_COMMENTS', 'Comments'),
(506, 'SYS', 'ORDERS_INFO_ADD_COMMENT', 'Add Comment (invisible to Customer)'),
(507, 'SYS', 'ORDERS_INFO_ADD_COMMENT_DESCR', 'This field lets you enter additional comments about the order. For example, you may include the history of a conversation with the customer which provides more details or terms regarding the order.'),
(508, 'SYS', 'ORDERS_INFO_HISTORY', 'Order Logs'),
(509, 'SYS', 'ORDERS_INFO_ORDER_PAYMENT_METHOD', 'Payment Method'),
(510, 'SYS', 'ORDERS_INFO_ORDER_PAYMENT_METHOD_DESCR', 'Represents the method of payment used to pay for the order. If the payment method is subsequently changed, this field can be edited manually.'),
(511, 'SYS', 'ORDERS_INFO_ORDER_PAYMENT_DETAILS', 'Displays any additional details about the order which are received from the online payment system or are recorded at the time of order placement. For example, this can include the customer''s IP address, a response from the online payment system, etc.'),
(512, 'SYS', 'ORDERS_INFO_ORDER_SHIPPING_METHOD', 'Shipping Method'),
(513, 'SYS', 'ORDERS_INFO_ORDER_SHIPPING_METHOD_DESCR', 'Represents the method used for shipping products to the customer.'),
(514, 'SYS', 'ORDERS_INFO_ORDER_TRACKING_NUMBER', 'Tracking Number'),
(515, 'SYS', 'ORDERS_INFO_ORDER_TRACKING_NUMBER_DESCR', 'Represents the tracking number for the shipped order. The tracking number can be used to track the progress of order shipment.'),
(516, 'SYS', 'ORDERS_INFO_AFFILIATE_ID', 'Affiliate ID'),
(517, 'SYS', 'ORDERS_INFO_AFFILIATE_ID_DESCR', 'Affiliate ID associated with the order.'),
(518, 'SYS', 'LBL_ORDERS_INFO_AFFILIATE_ID', 'Affiliate ID:'),
(519, 'SYS', 'ORDERS_HISTORY_STATUS_UPDATED', 'Order Status changed from ''{0}'' to ''{1}''.'),
(520, 'SYS', 'ORDERS_HISTORY_PAYMENT_STATUS_UPDATED', 'Order Payment Status changed from ''{0}'' to ''{1}''.'),
(521, 'SYS', 'ORDERS_HISTORY_TRACKING_NUMBER_UPDATED', 'Tracking Number changed from ''{0}'' to ''{1}''.'),
(522, 'SYS', 'ORDERS_HISTORY_PAYMENT_PROCESSOR_ORDER_ID_UPDATED', 'Payment Processor Order ID changed from ''{0}'' to ''{1}''.'),
(523, 'SYS', 'ORDERS_HISTORY_PAYMENT_METHOD_UPDATED', 'Payment Method changed from ''{0}'' to ''{1}''.'),
(524, 'SYS', 'ORDERS_HISTORY_SHIPPING_METHOD_UPDATED', 'Shipping Method changed from ''{0}'' to ''{1}''.'),
(525, 'SYS', 'ORDERS_HISTORY_CUSTOMER_INFO_UPDATED', 'Customer Information has been updated.'),
(526, 'SYS', 'ORDERS_HISTORY_BILLING_INFO_UPDATED', 'Billing Information has been updated.'),
(527, 'SYS', 'ORDERS_HISTORY_SHIPPING_INFO_UPDATED', 'Shipping Information has been updated.'),
(528, 'SYS', 'ORDERS_HISTORY_BANK_ACCOUNT_INFO_UPDATED', 'Bank Account Information has been updated.'),
(529, 'SYS', 'ORDERS_HISTORY_CREDIT_CARD_INFO_UPDATED', 'Credit Card Information has been updated.'),
(530, 'SYS', 'ORDERS_HISTORY_PRODUCT_OPTION_UPDATED', 'Product Option Name has changed from ''{0}'' to ''{1}''.'),
(531, 'SYS', 'ORDERS_HISTORY_PRODUCT_NAME_UPDATED', 'Product Name has changed from ''{0}'' to ''{1}''.'),
(532, 'SYS', 'ORDERS_HISTORY_TAX_EXEMPTION_UPDATED', 'Tax exemption checkmark has changed from ''{0}'' to ''{1}''.'),
(533, 'SYS', 'ORDERS_HISTORY_PRODUCT_QUANTITY_UPDATED', 'Product Quantity has changed from ''{0}'' to ''{1}''.'),
(534, 'SYS', 'ORDERS_HISTORY_GLOBAL_DISCOUNT_UPDATED', 'Global Discount has changed from ''{0}'' to ''{1}''.'),
(535, 'SYS', 'ORDERS_HISTORY_PROMOCODE_DISCOUNT_UPDATED', 'Promo Code Discount has changed from ''{0}'' to ''{1}''.'),
(536, 'SYS', 'ORDERS_HISTORY_QUANTITY_DISCOUNT_UPDATED', 'Quantity Discount has changed from ''{0}'' to ''{1}''.'),
(537, 'SYS', 'ORDERS_HISTORY_SHIPPING_HANDLING_UPDATED', 'Shipping and Handling has changed from ''{0}'' to ''{1}''.'),
(538, 'SYS', 'ORDERS_HISTORY_PRODUCT_SALEPRICE_UPDATED', 'Product Sale Price has changed from ''{0}'' to ''{1}''.'),
(539, 'SYS', 'ORDERS_HISTORY_TAX_UPDATED', 'Tax ''{0}'' has changed from ''{1}'' to ''{2}''.'),
(540, 'SYS', 'ORDERS_HISTORY_TDO_UPDATED', 'Tax display option ''{0}'' has changed from ''{1}'' to ''{2}''.'),
(541, 'SYS', 'ORDERS_HISTORY_PRICES_UPDATED', 'Order Prices have changed in ''{0}''.'),
(542, 'SYS', 'ORDERS_HISTORY_PRICES_INTACT', 'No values have changed.'),
(543, 'SYS', 'ORDERS_HISTORY_TOTAL_UPDATED', 'Due to changes in product totals, their prices or other monetary values, the order has been recalculated in ''{0}''.'),
(544, 'SYS', 'ORDER_STATUS_001', 'New Order'),
(545, 'SYS', 'ORDER_STATUS_DESCR_001', ''),
(546, 'SYS', 'ORDER_STATUS_002', 'In Progress'),
(547, 'SYS', 'ORDER_STATUS_DESCR_002', ''),
(548, 'SYS', 'ORDER_STATUS_003', 'Ready To Ship'),
(549, 'SYS', 'ORDER_STATUS_DESCR_003', ''),
(550, 'SYS', 'ORDER_STATUS_004', 'Shipped'),
(551, 'SYS', 'ORDER_STATUS_DESCR_004', ''),
(552, 'SYS', 'ORDER_STATUS_005', 'Cancelled'),
(553, 'SYS', 'ORDER_STATUS_DESCR_005', ''),
(554, 'SYS', 'ORDER_STATUS_006', 'Declined'),
(555, 'SYS', 'ORDER_STATUS_DESCR_006', ''),
(556, 'SYS', 'ORDER_STATUS_007', 'Completed');
INSERT INTO `[[dbprefix]]resource_labels` VALUES
(557, 'SYS', 'ORDER_STATUS_DESCR_007', ''),
(558, 'SYS', 'ORDER_PAYMENT_STATUS_001', 'Waiting'),
(559, 'SYS', 'ORDER_PAYMENT_STATUS_DESCR_001', ''),
(560, 'SYS', 'ORDER_PAYMENT_STATUS_002', 'Fully Paid'),
(561, 'SYS', 'ORDER_PAYMENT_STATUS_DESCR_002', ''),
(562, 'SYS', 'ORDER_PAYMENT_STATUS_003', 'Declined'),
(563, 'SYS', 'ORDER_PAYMENT_STATUS_DESCR_003', ''),
(564, 'SYS', 'ORDER_PAYMENT_STATUS_004', 'Suspicious'),
(565, 'SYS', 'ORDER_PAYMENT_STATUS_DESCR_004', ''),
(566, 'SYS', 'FULL_TAX_EXEMPT_MSG', 'Tax Exemption Adjustment:'),
(567, 'SYS', 'FULL_TAX_EXEMPT_YES_MSG', 'Yes'),
(568, 'SYS', 'FULL_TAX_EXEMPT_NO_MSG', 'No'),
(569, 'SYS', 'INCLUDED_TAX_EDIT_MSG', 'Taxes marked with an asterisk (*) are included in the product price and do not directly affect the subtotal.'),
(570, 'SYS', 'ORDER_PRICES_ARE_NOT_EDITABLE', 'Sorry, this order''s structure is out of date, and its prices and quantities cannot be edited.'),
(571, 'SYS', 'ORDER_DEL_PAGE_TITLE', 'Delete Orders'),
(572, 'SYS', 'ORDER_DEL_PAGE_HEADER', 'Delete Orders'),
(573, 'SYS', 'ORDER_DEL_PAGE_SUBTITLE', 'Orders to be deleted'),
(574, 'SYS', 'ORDER_DEL_WARNING', 'WARNING!!! You will not be able to restore selected orders after deletion.'),
(575, 'SYS', 'ORDER_DEL_WRN_001', 'Select the orders you want to delete.'),
(576, 'SYS', 'CUSTOMERS_HEADER_001', 'Customers'),
(577, 'SYS', 'CUSTOMERS_SEARCH_QUICK_NAVIGATION', 'Quick Customer Navigation (by Last Name)'),
(578, 'SYS', 'CUSTOMERS_SEARCH_CUSTOMERS', 'Search Customers'),
(579, 'SYS', 'CUSTOMERS_SEARCH_ALL', 'All'),
(580, 'SYS', 'CUSTOMERS_SEARCH_BY', 'Search by'),
(581, 'SYS', 'CUSTOMERS_SEARCH_BY_NAME', 'Customer Name'),
(582, 'SYS', 'CUSTOMERS_SEARCH_BY_EMAIL', 'E-mail'),
(583, 'SYS', 'CUSTOMERS_SEARCH_OK', 'Search'),
(584, 'SYS', 'CUSTOMERS_RESULTS_MORE_THEN_ROWS_PER_PAGE_FOUND', '{0} - {1} of {2} customers found.'),
(585, 'SYS', 'CUSTOMERS_RESULTS_LESS_THEN_ROWS_PER_PAGE_FOUND', '{0} customers found.'),
(586, 'SYS', 'CUSTOMERS_RESULTS_NAME', 'Customer Name'),
(587, 'SYS', 'CUSTOMERS_RESULTS_EMAIL', 'E-mail Address'),
(588, 'SYS', 'CUSTOMERS_RESULTS_ORDERS', 'Total Orders'),
(589, 'SYS', 'CUSTOMERS_RESULTS_AMOUNT', 'Total Amount'),
(590, 'SYS', 'CUSTOMERS_INFO', 'Customer Info'),
(591, 'SYS', 'CUSTOMERS_INFO_GROUP1', 'Customer Information for Last Order'),
(592, 'SYS', 'CUSTOMERS_INFO_GROUP2', 'Billing Information for Last Order'),
(593, 'SYS', 'CUSTOMERS_INFO_GROUP3', 'Shipping Information for Last Order'),
(594, 'SYS', 'CUSTOMERS_INFO_GROUP4', 'Credit Card Information for Last Order'),
(595, 'SYS', 'CUSTOMERS_INFO_ORDERS', 'Orders'),
(596, 'SYS', 'CUSTOMERS_INFO_SUBSCRIPTIONS', 'Subscriptions'),
(597, 'SYS', 'CUSTOMERS_INFO_ORDER_ID', 'Order ID'),
(598, 'SYS', 'CUSTOMERS_INFO_ORDER_NAME', 'Customer Name'),
(599, 'SYS', 'CUSTOMERS_INFO_ORDER_DATE', 'Order Date'),
(600, 'SYS', 'CUSTOMERS_INFO_ORDER_AMOUNT', 'Amount'),
(601, 'SYS', 'CUSTOMERS_INFO_ORDER_STATUS', 'Order Status'),
(602, 'SYS', 'CUSTOMERS_INFO_ORDER_PAYMENT_STATUS', 'Payment Status'),
(603, 'SYS', 'CUSTOMER_REVIEWS_HEADER_001', 'Customer Reviews'),
(604, 'SYS', 'BTN_SELECT', 'Select'),
(605, 'SYS', 'LABEL_EDITOR_HEADER_001', 'Label Editor'),
(606, 'SYS', 'CMS_HEADER_001', 'Articles'),
(607, 'SYS', 'CMS_HEADER_002', 'Links &amp; Menu'),
(608, 'SYS', 'MENU_NAV_CMS_MENUS', 'Menu Manager'),
(609, 'SYS', 'PRD_GRP_EDIT_PAGE_NAME', 'Bulk Product Updater'),
(610, 'SYS', 'PRD_GRP_EDIT_BACK_PAGE', 'Back to Manage Products page'),
(611, 'SYS', 'PRD_GRP_EDIT_BTN_BACK', 'Back to Manage Products page'),
(612, 'SYS', 'UPDATE_PAGE_NAME', 'System Management'),
(613, 'SYS', 'STRSET_HEADER_001', 'Modules'),
(614, 'SYS', 'STRSET_HEADER_002', 'Location/Taxes/Localization'),
(615, 'SYS', 'STRSET_HEADER_003', 'Store Configuration'),
(616, 'SYS', 'STRSET_PAYM_METH', 'Payment Methods'),
(617, 'SYS', 'STRSET_PAYM_METH_DESCR', 'Select payment gateways and activate payment methods.'),
(618, 'SYS', 'PAYM_METH_SAVED_MSG', 'The list of payment modules has been successfully updated.'),
(619, 'SYS', 'SHIP_METH_SAVED_MSG', 'The list of shipping modules has been successfully updated.'),
(620, 'SYS', 'STRSET_HEADER_007', 'Currency Settings'),
(621, 'SYS', 'PAYM_METH_PAGE_NAME', 'Payment Methods'),
(622, 'SYS', 'PAYM_METH_HEADER_001', 'Selected Payment Methods'),
(623, 'SYS', 'PAYM_METH_HEADER_002', 'Manage Payment Methods'),
(624, 'SYS', 'PAYM_METH_DESCR_001', 'Below you can see the selected payment methods. The order of payment methods is identical to what the customers will see when making an order. To change the priorities, please go to Manage Payment Methods.'),
(625, 'SYS', 'PAYM_METH_DESCR_002', 'The <b>Available Payment Methods</b> box displays the list of payment methods and payment gateways. To activate desired payment methods and/or payment gateways, select them in this list and move them to the <b>Selected Payment Methods</b> box using the right arrow. Use the up and down arrows to define the order in which the payment methods will be displayed to the customers when they make an order. If you don''t find the desired payment method in this list, please contact our support staff.'),
(626, 'SYS', 'PAYM_METH_DESCR_003', 'To start receiving payments, you need to enter the required parameters and activate payment method.'),
(627, 'SYS', 'PAYM_METH_HEADER_003', 'Available Payment Methods'),
(628, 'SYS', 'PAYM_METH_HEADER_004', 'Selected Payment Methods'),
(629, 'SYS', 'PAYM_METH_HEADER_005', 'Offline Payment Methods'),
(630, 'SYS', 'PAYM_METH_HEADER_006', 'Online Credit Card'),
(631, 'SYS', 'PAYM_METH_HEADER_007', 'Online eCheck'),
(632, 'SYS', 'PAYM_METH_HEADER_008', 'Online Payment System'),
(633, 'SYS', 'PAGE_HELP_LABEL', 'Page Help'),
(634, 'SYS', 'VIDEO_TUTORIAL_LABEL', 'Video Tutorial'),
(635, 'SYS', 'SHOW_HIDE_LABEL', 'Show/Hide'),
(636, 'SYS', 'DECRYPT_LABEL', 'Decrypt'),
(637, 'SYS', 'REQUIRED_FIELD_LABEL', '* = Required Field'),
(638, 'SYS', 'LARGE_IMAGE_LINK', 'Large Image'),
(639, 'SYS', 'FULLSIZE_IMAGE_LINK', 'Click to see fullsize image'),
(640, 'SYS', 'DELETE_IMAGE_LINK', 'Delete'),
(641, 'SYS', 'COPYRIGHT_TEXT', '&copy; 2004-%s Avactis. All Rights Reserved.'),
(642, 'SYS', 'CMN_PAGE_TITLE', 'Avactis Shopping Cart'),
(643, 'SYS', 'PRD_ADD_PAGE_TITLE', 'Add Product'),
(644, 'SYS', 'PRD_MOVE_PAGE_TITLE', 'Move Products'),
(645, 'SYS', 'PRD_DEL_PAGE_TITLE', 'Delete Products'),
(646, 'SYS', 'PRD_SORT_PAGE_TITLE', 'Sort Products'),
(647, 'SYS', 'PRD_VIEW_PAGE_TITLE', 'Product Info'),
(648, 'SYS', 'PRD_EDIT_PAGE_TITLE', 'Edit Product'),
(649, 'SYS', 'PRD_COPY_PAGE_TITLE', 'Copy Products'),
(650, 'SYS', 'CTGR_ADD_PAGE_TITLE', 'Add Category'),
(651, 'SYS', 'CTGR_MOVE_PAGE_TITLE', 'Move Category'),
(652, 'SYS', 'CTGR_EDIT_PAGE_TITLE', 'Edit Category'),
(653, 'SYS', 'CTGR_DEL_PAGE_TITLE', 'Delete Category'),
(654, 'SYS', 'CTGR_VIEW_PAGE_TITLE', 'Category Info'),
(655, 'SYS', 'CTGR_SORT_PAGE_TITLE', 'Sort Categories'),
(656, 'SYS', 'PRDTYPE_ADD_CUST_ATTR_PAGE_TITLE', 'Add Custom Attribute'),
(657, 'SYS', 'PRDTYPE_EDIT_CUST_ATTR_PAGE_TITLE', 'Edit Custom Attribute'),
(658, 'SYS', 'HOME_PAGE_TITLE', 'Home'),
(659, 'SYS', 'CUSTOMERS_PAGE_TITLE', 'Customers'),
(660, 'SYS', 'CUSTOMERS_REVIEWS_PAGE_TITLE', 'Customer Reviews'),
(661, 'SYS', 'ORDERS_PAGE_TITLE', 'Orders'),
(662, 'SYS', 'MARKETING_PAGE_TITLE', 'Marketing'),
(663, 'SYS', 'REPORTS_PAGE_TITLE', 'Reports'),
(664, 'SYS', 'LOOKNFEEL_PAGE_TITLE', 'Look & Feel'),
(665, 'SYS', 'LAYOUT_CMS_PAGE_TITLE', 'Page Manager'),
(666, 'SYS', 'ADMIN_PAGE_TITLE', 'Admin'),
(667, 'SYS', 'ADMIN_MEMBERS_PAGE_TITLE', 'Admin Members'),
(668, 'SYS', 'ADMIN_MEMBER_INFO_PAGE_TITLE', 'Admin Member Info'),
(669, 'SYS', 'TIMELINE_PAGE_TITLE', 'View System Logs'),
(670, 'SYS', 'BACKUP_PAGE_TITLE', 'Data Backup & Restore'),
(671, 'SYS', 'APP_INFO_PAGE_TITLE', 'Application/Server Info'),
(672, 'SYS', 'STORE_SETTINGS_PAGE_TITLE', 'Store Settings'),
(673, 'SYS', 'PM_PAGE_TITLE', 'Payment Methods'),
(674, 'SYS', 'SM_PAGE_TITLE', 'Shipping Settings/Methods'),
(675, 'SYS', 'NOTIFICATIONS_PAGE_TITLE', 'E-mail Notifications'),
(676, 'SYS', 'CHECKOUT_FORM_EDITOR_PAGE_TITLE', 'Checkout Form Editor'),
(677, 'SYS', 'CUSTOMER_ACC_SETTINGS_PAGE_TITLE', 'Customer Account Settings'),
(678, 'SYS', 'TAXES_PAGE_TITLE', 'Taxes'),
(679, 'SYS', 'TAX_ZIP_SETS_PAGE_TITLE', 'ZIP Based Tax Rates'),
(680, 'SYS', 'LABEL_EDITOR_PAGE_TITLE', 'Label Editor'),
(681, 'SYS', 'CMS_PAGE_TITLE', 'Content'),
(682, 'SYS', 'BTN_BROWSE', 'Browse'),
(683, 'SYS', 'BTN_SWITCH_TO_PROD', 'Switch to Products'),
(684, 'SYS', 'BTN_SWITCH_TO_PROD_TITLE', 'Switch to list of products in the current category'),
(685, 'SYS', 'BTN_SWITCH_TO_CTG', 'Switch to Categories'),
(686, 'SYS', 'BTN_SWITCH_TO_CTG_TITLE', 'Switch to list of subcategories in the current category'),
(687, 'SYS', 'BTN_DELETE_PRDTYPE', 'Delete'),
(688, 'SYS', 'BTN_DELETE_PRDTYPE_TITLE', 'Delete product type(s)'),
(689, 'SYS', 'BTN_CANCEL_DELETE_PRDTYPE', 'Cancel'),
(690, 'SYS', 'BTN_CANCEL_DELETE_PRDTYPE_TITLE', 'Cancel deletion of product types'),
(691, 'SYS', 'BTN_ADDCAT', 'Add Category'),
(692, 'SYS', 'BTN_ADDPRD', 'Add Product'),
(693, 'SYS', 'BTN_ADDPRD_TITLE', 'Add product into the current category'),
(694, 'SYS', 'BTN_MOVE_PRD', 'Move'),
(695, 'SYS', 'BTN_MOVE_PRD_TITLE', 'Move selected products to another category'),
(696, 'SYS', 'BTN_DELETE_PRD', 'Delete'),
(697, 'SYS', 'BTN_DELETE_PRD_TITLE', 'Delete selected products'),
(698, 'SYS', 'BTN_SORT_PRD', 'Sort'),
(699, 'SYS', 'BTN_SORT_PRD_TITLE', 'Sort product in this category'),
(700, 'SYS', 'BTN_SAVE_NEW_PRD', 'Save'),
(701, 'SYS', 'BTN_SAVE_NEW_PRD_TITLE', 'Save new product'),
(702, 'SYS', 'BTN_SAVEANDADDANOTHER_NEW_PRD', 'Save and Add another'),
(703, 'SYS', 'BTN_SAVEANDADDANOTHER_NEW_PRD_TITLE', 'Save new product and add another product'),
(704, 'SYS', 'BTN_CANCEL_NEW_PRD', 'Cancel'),
(705, 'SYS', 'BTN_CANCEL_NEW_PRD_TITLE', 'Cancel addition of new product'),
(706, 'SYS', 'BTN_EDIT_INFO_PRD', 'Edit'),
(707, 'SYS', 'BTN_EDIT_INFO_PRD_TITLE', 'Edit information about the product'),
(708, 'SYS', 'BTN_CANCEL_INFO_PRD', 'Cancel'),
(709, 'SYS', 'BTN_CANCEL_INFO_PRD_TITLE', 'Close window with information about the product'),
(710, 'SYS', 'BTN_CLOSE_INFO_PRD', 'Close'),
(711, 'SYS', 'BTN_CLOSE_INFO_PRD_TITLE', 'Close window with information about the product'),
(712, 'SYS', 'BTN_SAVE_EDIT_PRD', 'Save'),
(713, 'SYS', 'BTN_SAVE_EDIT_PRD_TITLE', 'Save changes in information about the product'),
(714, 'SYS', 'BTN_CANCEL_EDIT_PRD', 'Cancel'),
(715, 'SYS', 'BTN_CANCEL_EDIT_PRD_TITLE', 'Cancel changes in information about the product'),
(716, 'SYS', 'BTN_ADD_PRDTYPE', 'Add New Type'),
(717, 'SYS', 'BTN_ADD_PRDTYPE_TITLE', 'Add new product type'),
(718, 'SYS', 'BTN_UPDATE_ORDER_INFO', 'Update'),
(719, 'SYS', 'BTN_EDIT_ORDER_INFO', 'Edit'),
(720, 'SYS', 'BTN_CANCEL_ORDER_INFO', 'Cancel'),
(721, 'SYS', 'BTN_CANCEL_CUSTOMER_INFO', 'Close'),
(722, 'SYS', 'BTN_CLEAR', 'Clear'),
(723, 'SYS', 'BTN_CLEAR_CACHE', 'Clear Cache'),
(724, 'SYS', 'MSG_CACHE_CLEARED', 'The cache cleared'),
(725, 'SYS', 'BTN_UNDO', 'Undo'),
(726, 'SYS', 'BTN_COPY_PRD', 'Copy'),
(727, 'SYS', 'BTN_COPY_PRD_TITLE', 'Copy selected products to another category'),
(728, 'SYS', 'BTN_EDIT_PRD', 'Edit'),
(729, 'SYS', 'BTN_EDIT_PRD_TITLE', 'Edit information about the product'),
(730, 'SYS', 'BTN_EDIT_HOME_CATEGORY', 'Edit Home Category'),
(731, 'SYS', 'BTN_ENABLE_EDITOR', 'Enable Editor'),
(732, 'SYS', 'BTN_OK', 'OK'),
(733, 'SYS', 'BTN_SAVE', 'Save'),
(734, 'SYS', 'BTN_CANCEL', 'Cancel'),
(735, 'SYS', 'BTN_UPDATE', 'Update'),
(736, 'SYS', 'BTN_EDIT', 'Edit'),
(737, 'SYS', 'BTN_PREVIEW', 'Preview'),
(738, 'SYS', 'BTN_DELETE', 'Delete'),
(739, 'SYS', 'BTN_CLOSE', 'Close'),
(740, 'SYS', 'BTN_ADD', 'Add'),
(741, 'SYS', 'BTN_ADD_FIELD', 'Add field'),
(742, 'SYS', 'BTN_COPY', 'Copy'),
(743, 'SYS', 'BTN_TEST', 'Test'),
(744, 'SYS', 'BTN_SORT', 'Sort'),
(745, 'SYS', 'BTN_SETTINGS', 'Settings'),
(746, 'SYS', 'BTN_NEW', 'New'),
(747, 'SYS', 'BTN_CHECK', 'Check'),
(748, 'SYS', 'BTN_REGISTER_STORE', 'Register Store'),
(749, 'SYS', 'BTN_UPDATE_LICENSE_KEY', 'Update Key'),
(750, 'SYS', 'BTN_UPDATE_REGISTRATION', 'Update Store Registration'),
(751, 'SYS', 'BTN_SUBMIT', 'Submit'),
(752, 'SYS', 'BTN_CLOSE_WINDOW', 'Close Window'),
(753, 'SYS', 'BTN_DELETE_SELECTED', 'Delete selected'),
(754, 'SYS', 'BTN_MESSAGE', 'Message'),
(755, 'SYS', 'BTN_REFRESH', 'Refresh'),
(756, 'SYS', 'BTN_RETURN', 'Return'),
(757, 'SYS', 'BTN_GO', 'Go'),
(758, 'SYS', 'BTN_RESET', 'Reset'),
(759, 'SYS', 'MENU_HOME', 'Home'),
(760, 'SYS', 'MENU_DASHBOARD', 'Dashboard'),
(761, 'SYS', 'MENU_CATALOG', 'Products'),
(762, 'SYS', 'MENU_PRODUCTS', 'Manage Products'),
(763, 'SYS', 'MENU_CATEGORIES', 'Manage Categories'),
(764, 'SYS', 'MENU_PRODUCT_TYPES', 'Product Types'),
(765, 'SYS', 'MENU_MANUFACTURERS', 'Manufacturers'),
(766, 'SYS', 'MENU_ORDERS', 'Orders'),
(767, 'SYS', 'MENU_USERS', 'Customers'),
(768, 'SYS', 'MENU_ADMIN_MEMBERS', 'Admin Members'),
(769, 'SYS', 'MENU_CUSTOMERS', 'Customers'),
(770, 'SYS', 'MENU_CUSTOMER_REVIEWS', 'Customer Reviews'),
(771, 'SYS', 'MENU_MARKETING', 'Marketing'),
(772, 'SYS', 'MENU_GLOBAL_DISCOUNTS', 'Global Discounts'),
(773, 'SYS', 'MENU_PROMO_CODES', 'Promo Codes'),
(774, 'SYS', 'MENU_GIFT_CERTIFICATES', 'Gift Certificates'),
(775, 'SYS', 'MENU_NEWSLETTERS', 'Newsletters'),
(776, 'SYS', 'MENU_SUBSCRIPTIONS', 'Subscriptions'),
(777, 'SYS', 'MENU_TRANSACTION_TRACKING', 'Transaction Tracking'),
(778, 'SYS', 'MENU_REPORTS', 'Reports'),
(779, 'SYS', 'MENU_RESET_REPORTS', 'Reset Reports'),
(780, 'SYS', 'MENU_STOREFRONT_DESIGN', 'Design'),
(781, 'SYS', 'MENU_THEME_MANAGER', 'Store Design'),
(782, 'SYS', 'MENU_PAGE_MANAGER', 'Page Manager'),
(783, 'SYS', 'MENU_CMS_PAGES', 'CMS Pages'),
(784, 'SYS', 'MENU_CMS_MENUS', 'Links &amp; Menus'),
(785, 'SYS', 'MENU_CMS', 'Content'),
(786, 'SYS', 'MENU_SETTINGS', 'Settings'),
(787, 'SYS', 'MENU_STORE_SETTINGS', 'Store Settings'),
(788, 'SYS', 'MENU_MAIL_SETTINGS', 'Mail Settings'),
(789, 'SYS', 'MENU_HTTPS_SETTINGS', 'HTTPS Settings'),
(790, 'SYS', 'MENU_TOOLS', 'Tools'),
(791, 'SYS', 'MENU_SYSTEM_LOGS', 'System Logs'),
(792, 'SYS', 'MENU_BACKUP_RESTORE', 'Backup/Restore'),
(793, 'SYS', 'MENU_CLEAR_CACHE_LOGS', 'Clear Cache &amp; Logs'),
(794, 'SYS', 'MENU_LICENSE_INFO', 'License Info'),
(795, 'SYS', 'MENU_APPLICATION_SERVER_INFO', 'Application/Server Info'),
(796, 'SYS', 'MENU_SECURE_STORE', 'Secure store'),
(797, 'SYS', 'MENU_EXTENSIONS', 'Extensions'),
(798, 'SYS', 'MENU_MANAGE_EXTENSIONS', 'Manage Extensions'),
(799, 'SYS', 'MENU_CONFIGURE_EXTENSIONS', 'Configure Extensions'),
(800, 'SYS', 'MENU_UPDATE', 'Update'),
(801, 'SYS', 'MENU_ADMIN', 'Admin'),
(802, 'SYS', 'MENU_HELP', 'Help'),
(803, 'SYS', 'MENU_LABEL_EDITOR', 'Label Editor'),
(804, 'SYS', 'MENU_COMMUNITY_FORUMS', 'Community Forums'),
(805, 'SYS', 'MENU_SUPPORT', 'Support'),
(806, 'SYS', 'MENU_SIGN_OUT', 'Sign Out'),
(807, 'SYS', 'MENU_TERMS_OF_USE', 'Terms of Use'),
(808, 'SYS', 'MENU_LICENSE_AGREEMENT', 'License Agreement'),
(809, 'SYS', 'MENU_PRIVACY_POLICY', 'Privacy Policy'),
(810, 'SYS', 'LFTBX_HEADER_001', 'Store Status - '),
(811, 'SYS', 'LFTBX_HEADER_CLSD', 'CLOSED'),
(812, 'SYS', 'LFTBX_HEADER_ONLN', 'ONLINE'),
(813, 'SYS', 'LFTBX_HEADER_STORE_STATUS_HINT', 'Click to change store status'),
(814, 'SYS', 'LFTBX_PRD_QUAN', 'Unique Products:'),
(815, 'SYS', 'LFTBX_PRD_LINKS_QUAN', 'All Products:'),
(816, 'SYS', 'LFTBX_CTGR_QUAN', 'Categories:'),
(817, 'SYS', 'LFTBX_NWORD_QUAN', 'New Orders:'),
(818, 'SYS', 'LFTBX_INPRGRS_QUAN', 'In progress:'),
(819, 'SYS', 'LFTBX_RDTOSHP_QUAN', 'Ready to Ship:'),
(820, 'SYS', 'LFTBX_HEADER_002', 'Quick Links'),
(821, 'SYS', 'LFTBX_HEADER_FEEDBACK', 'Send Feedback'),
(822, 'SYS', 'LFTBX_FEEDBACK_MSG', 'If you have suggestions or found a bug or misprint, please e-mail us at <A HREF=''mailto:feedback@avactis.com''>feedback@avactis.com</A>'),
(823, 'SYS', 'SHIP_METH_PAGE_NAME', 'Shipping Settings/Methods'),
(824, 'SYS', 'SHIP_METH_HEADER_001', 'Selected Shipping Methods'),
(825, 'SYS', 'SHIP_METH_HEADER_002', 'Manage Shipping Methods'),
(826, 'SYS', 'SHIP_METH_DESCR_001', 'Below you can see the selected shipping methods. The order of shipping methods is identical to what the customers will see when placing orders. To rearrange the shipping methods, please go to Manage Shipping Methods.'),
(827, 'SYS', 'SHIP_METH_DESCR_002', 'The <b>Available Shipping Methods</b> box displays the list of shipping methods. To activate the desired shipping methods, select them in the list and move them to the <b>Selected Shipping Methods</b> box by clicking the right arrow button. Click the up and down arrows to define the order in which the shipping methods will be displayed to the customer when they are placing an order. If you don''t find the desired shipping method in the list, please contact our support staff.'),
(828, 'SYS', 'SHIP_METH_DESCR_003', 'To start working with a shipping method, please enter the required parameters and activate the shipping method.'),
(829, 'SYS', 'SHIP_METH_HEADER_003', 'Available Shipping Methods'),
(830, 'SYS', 'SHIP_METH_HEADER_004', 'Selected Shipping Methods'),
(831, 'SYS', 'PAYM_MODULE_SETTINGS_PAGE_TITLE', 'Edit payment module settings'),
(832, 'SYS', 'SHIP_MODULE_SETTINGS_PAGE_TITLE', 'Edit shipping module settings'),
(833, 'SYS', 'SHIPPING_GENERAL_SETTINGS_PAGE_TITLE', 'Edit General Shipping Settings'),
(834, 'SYS', 'SHIPPING_FS_RULES_LIST_PAGE_TITLE', 'Edit Free Shipping Rules'),
(835, 'SYS', 'SHIP_TESTER_PAGE_TITLE', 'Test shipping configuration'),
(836, 'SYS', 'STRSET_SHIP_METH', 'Shipping Settings/Methods'),
(837, 'SYS', 'STRSET_SHIP_METH_DESCR', 'Configure shipping settings. Select and activate shipping methods.'),
(838, 'SYS', 'STRSET_GENERAL', 'General Settings'),
(839, 'SYS', 'STRSET_GENERAL_DESCR', 'General online store settings.'),
(840, 'SYS', 'STRSET_STORE_OWNER', 'Store Owner''s Profile'),
(841, 'SYS', 'STRSET_STORE_OWNER_DESCR', 'Edit the store owner''s profile.'),
(842, 'SYS', 'STRSET_CURRENCY_FORMAT', 'Currency Format'),
(843, 'SYS', 'STRSET_CURRENCY_FORMAT_DESCR', 'Edit currency display settings.'),
(844, 'SYS', 'STRSET_DATE_FORMAT', 'Date/Time Format'),
(845, 'SYS', 'STRSET_DATE_FORMAT_DESCR', 'Edit date and time display settings.'),
(846, 'SYS', 'STRSET_COUNTRIES', 'Countries'),
(847, 'SYS', 'STRSET_COUNTRIES_DESCR', 'Edit the list of countries.'),
(848, 'SYS', 'STRSET_LANGUAGES', 'Languages'),
(849, 'SYS', 'STRSET_LANGUAGES_DESCR', 'Edit the list of available languages.'),
(850, 'SYS', 'STRSET_LABEL_EDITOR_DESCR', 'Edit/Translate labels in different languages'),
(851, 'SYS', 'STRSET_ACCEPTED_CURRENCIES', 'Accepted Currencies'),
(852, 'SYS', 'STRSET_STRSET_ACCEPTED_CURRENCIES_DESCR', 'Edit the list of accepted currencies.'),
(853, 'SYS', 'STRSET_STATES', 'States'),
(854, 'SYS', 'STRSET_STATES_DESCR', 'Edit the list of states.'),
(855, 'SYS', 'STRSET_TAXES', 'Taxes'),
(856, 'SYS', 'STRSET_TAXES_DESCR', 'Define taxes, tax classes and tax formulas.'),
(857, 'SYS', 'STRSET_TAX_ZIP_SETS', 'ZIP Code Based Tax Rates'),
(858, 'SYS', 'STRSET_TAX_ZIP_SETS_DESCR', 'Add and update ZIP based tax rates.'),
(859, 'SYS', 'STRSET_NUM_FORMAT', 'Number Format'),
(860, 'SYS', 'STRSET_NUM_FORMAT_DESCR', 'Number format settings.'),
(861, 'SYS', 'STRSET_WEIGHT_UNIT', 'Weight Unit'),
(862, 'SYS', 'STRSET_WEIGHT_UNIT_DESCR', 'Weight unit settings.'),
(863, 'SYS', 'MAIL_PAGE_TITLE', 'Mail Settings'),
(864, 'SYS', 'MAIL_SET_PAGE_TITLE', 'Mail Settings'),
(865, 'SYS', 'MAIL_SET_PAGE_SUBTITLE', 'Mail Settings'),
(866, 'SYS', 'MSG_MAIL_SETTINGS_UPDATED', 'Mail settings have been successfully updated.'),
(867, 'SYS', 'MSG_MAIL_SENT', 'The message has been successfully sent.'),
(868, 'SYS', 'MAIL_NOT_SENT', 'Unable to send the message: invalid mail settings.'),
(869, 'SYS', 'MAIL_SETTINGS_MAIL_CONFIGURATION_LABEL', 'Mail Configuration'),
(870, 'SYS', 'MAIL_SETTINGS_MAIL_CONFIGURATION_TYPE1_DESCR', '<b>Use your hosting server settings.</b><br />The settings work in most cases.'),
(871, 'SYS', 'MAIL_SETTINGS_MAIL_CONFIGURATION_TYPE2_DESCR', '<b>Use custom settings.</b><br />Use this if your hosting server mail settings are wrong or you can use other settings. Specify the necessary parameters below.'),
(872, 'SYS', 'MAIL_SETTINGS_SERVER_DEFAULTS', 'Server defaults'),
(873, 'SYS', 'MAIL_SETTINGS_SPECIFIC_SETTINGS', 'Specific settings'),
(874, 'SYS', 'MAIL_SETTINGS_SMTP_SETTINGS_LABEL', 'SMTP Settings'),
(875, 'SYS', 'MAIL_SETTINGS_TEST_MAIL_LABEL', 'Test Mail'),
(876, 'SYS', 'MAIL_SETTINGS_TEST_MAIL_DESCR', '<b>Send a test message.</b><br />The message will be sent from the current store administrator address with a Subject of ''Avactis Test Mail Subject'' and the current settings in the message body.'),
(877, 'SYS', 'MAIL_SETTINGS_HOST_LABEL', 'SMTP host:'),
(878, 'SYS', 'MAIL_SETTINGS_PORT_LABEL', 'SMTP port:'),
(879, 'SYS', 'MAIL_SETTINGS_AUTH_LABEL', 'SMTP authorization'),
(880, 'SYS', 'MAIL_SETTINGS_USER_LABEL', 'Username:'),
(881, 'SYS', 'MAIL_SETTINGS_PASS_LABEL', 'Password:'),
(882, 'SYS', 'MAIL_SETTINGS_WARNING_HOST', 'Please enter host name or IP address'),
(883, 'SYS', 'MAIL_SETTINGS_WARNING_PORT', 'Please enter port number'),
(884, 'SYS', 'MAIL_SETTINGS_WARNING_USER', 'Please enter user name (login)'),
(885, 'SYS', 'MAIL_SETTINGS_WARNING_PASS', 'Please enter password'),
(886, 'SYS', 'MAIL_SET_ALERT_HOST', 'Please enter host name or IP address'),
(887, 'SYS', 'MAIL_SET_ALERT_PORT', 'Please enter port number'),
(888, 'SYS', 'MAIL_SET_ALERT_USER', 'Please enter user name (login)'),
(889, 'SYS', 'MAIL_SET_ALERT_PASS', 'Please enter password'),
(890, 'SYS', 'MAIL_SETTINGS_AVACTIS_TEST_MAIL_BODY', 'Avactis Test Mail'),
(891, 'SYS', 'MAIL_SETTINGS_AVACTIS_TEST_MAIL_SUBJECT', 'Avactis Test Mail Subject'),
(892, 'SYS', 'MAIL_SETTINGS_INVALID_EMAIL', 'Sorry, an invalid e-mail was specified.'),
(893, 'SYS', 'SUPPORT_PAGE_NAME', 'Support'),
(894, 'SYS', 'GENERAL_MONTH_01', 'January'),
(895, 'SYS', 'GENERAL_MONTH_02', 'February'),
(896, 'SYS', 'GENERAL_MONTH_03', 'March'),
(897, 'SYS', 'GENERAL_MONTH_04', 'April'),
(898, 'SYS', 'GENERAL_MONTH_05', 'May'),
(899, 'SYS', 'GENERAL_MONTH_06', 'June'),
(900, 'SYS', 'GENERAL_MONTH_07', 'July'),
(901, 'SYS', 'GENERAL_MONTH_08', 'August'),
(902, 'SYS', 'GENERAL_MONTH_09', 'September'),
(903, 'SYS', 'GENERAL_MONTH_10', 'October'),
(904, 'SYS', 'GENERAL_MONTH_11', 'November'),
(905, 'SYS', 'GENERAL_MONTH_12', 'December'),
(906, 'SYS', 'COUNTRY_CODE_001', 'AF/AFG'),
(907, 'SYS', 'COUNTRY_001', 'Afghanistan'),
(908, 'SYS', 'COUNTRY_CODE_238', 'AX/ALA'),
(909, 'SYS', 'COUNTRY_238', 'Aland Islands'),
(910, 'SYS', 'COUNTRY_CODE_002', 'AL/ALB'),
(911, 'SYS', 'COUNTRY_002', 'Albania'),
(912, 'SYS', 'COUNTRY_CODE_003', 'DZ/DZA'),
(913, 'SYS', 'COUNTRY_003', 'Algeria'),
(914, 'SYS', 'COUNTRY_CODE_004', 'AS/ASM'),
(915, 'SYS', 'COUNTRY_004', 'American Samoa'),
(916, 'SYS', 'COUNTRY_CODE_005', 'AD/AND'),
(917, 'SYS', 'COUNTRY_005', 'Andorra'),
(918, 'SYS', 'COUNTRY_CODE_006', 'AO/AGO'),
(919, 'SYS', 'COUNTRY_006', 'Angola'),
(920, 'SYS', 'COUNTRY_CODE_007', 'AI/AIA'),
(921, 'SYS', 'COUNTRY_007', 'Anguilla'),
(922, 'SYS', 'COUNTRY_CODE_008', 'AQ/ATA'),
(923, 'SYS', 'COUNTRY_008', 'Antarctica'),
(924, 'SYS', 'COUNTRY_CODE_009', 'AG/ATG'),
(925, 'SYS', 'COUNTRY_009', 'Antigua and Barbuda'),
(926, 'SYS', 'COUNTRY_CODE_010', 'AR/ARG'),
(927, 'SYS', 'COUNTRY_010', 'Argentina'),
(928, 'SYS', 'COUNTRY_CODE_011', 'AM/ARM'),
(929, 'SYS', 'COUNTRY_011', 'Armenia'),
(930, 'SYS', 'COUNTRY_CODE_012', 'AW/ABW'),
(931, 'SYS', 'COUNTRY_012', 'Aruba'),
(932, 'SYS', 'COUNTRY_CODE_013', 'AU/AUS'),
(933, 'SYS', 'COUNTRY_013', 'Australia'),
(934, 'SYS', 'COUNTRY_CODE_014', 'AT/AUT'),
(935, 'SYS', 'COUNTRY_014', 'Austria'),
(936, 'SYS', 'COUNTRY_CODE_015', 'AZ/AZE'),
(937, 'SYS', 'COUNTRY_015', 'Azerbaijan'),
(938, 'SYS', 'COUNTRY_CODE_016', 'BS/BHS'),
(939, 'SYS', 'COUNTRY_016', 'Bahamas'),
(940, 'SYS', 'COUNTRY_CODE_017', 'BH/BHR'),
(941, 'SYS', 'COUNTRY_017', 'Bahrain'),
(942, 'SYS', 'COUNTRY_CODE_018', 'BD/BGD'),
(943, 'SYS', 'COUNTRY_018', 'Bangladesh'),
(944, 'SYS', 'COUNTRY_CODE_019', 'BB/BRB'),
(945, 'SYS', 'COUNTRY_019', 'Barbados'),
(946, 'SYS', 'COUNTRY_CODE_020', 'BY/BLR'),
(947, 'SYS', 'COUNTRY_020', 'Belarus'),
(948, 'SYS', 'COUNTRY_CODE_021', 'BE/BEL'),
(949, 'SYS', 'COUNTRY_021', 'Belgium'),
(950, 'SYS', 'COUNTRY_CODE_022', 'BZ/BLZ'),
(951, 'SYS', 'COUNTRY_022', 'Belize'),
(952, 'SYS', 'COUNTRY_CODE_023', 'BJ/BEN'),
(953, 'SYS', 'COUNTRY_023', 'Benin'),
(954, 'SYS', 'COUNTRY_CODE_024', 'BM/BMU'),
(955, 'SYS', 'COUNTRY_024', 'Bermuda'),
(956, 'SYS', 'COUNTRY_CODE_025', 'BT/BTN'),
(957, 'SYS', 'COUNTRY_025', 'Bhutan'),
(958, 'SYS', 'COUNTRY_CODE_026', 'BO/BOL'),
(959, 'SYS', 'COUNTRY_026', 'Bolivia'),
(960, 'SYS', 'COUNTRY_CODE_027', 'BA/BIH'),
(961, 'SYS', 'COUNTRY_027', 'Bosnia and Herzegowina'),
(962, 'SYS', 'COUNTRY_CODE_028', 'BW/BWA'),
(963, 'SYS', 'COUNTRY_028', 'Botswana'),
(964, 'SYS', 'COUNTRY_CODE_029', 'BV/BVT'),
(965, 'SYS', 'COUNTRY_029', 'Bouvet Island'),
(966, 'SYS', 'COUNTRY_CODE_030', 'BR/BRA'),
(967, 'SYS', 'COUNTRY_030', 'Brazil'),
(968, 'SYS', 'COUNTRY_CODE_031', 'IO/IOT'),
(969, 'SYS', 'COUNTRY_031', 'British Indian Ocean Territory'),
(970, 'SYS', 'COUNTRY_CODE_032', 'VG/VGB'),
(971, 'SYS', 'COUNTRY_032', 'British Virgin Islands'),
(972, 'SYS', 'COUNTRY_CODE_033', 'BN/BRN'),
(973, 'SYS', 'COUNTRY_033', 'Brunei Darussalam'),
(974, 'SYS', 'COUNTRY_CODE_034', 'BG/BGR'),
(975, 'SYS', 'COUNTRY_034', 'Bulgaria'),
(976, 'SYS', 'COUNTRY_CODE_035', 'BF/BFA'),
(977, 'SYS', 'COUNTRY_035', 'Burkina Faso'),
(978, 'SYS', 'COUNTRY_CODE_036', 'BI/BDI'),
(979, 'SYS', 'COUNTRY_036', 'Burundi'),
(980, 'SYS', 'COUNTRY_CODE_037', 'KH/KHM'),
(981, 'SYS', 'COUNTRY_037', 'Cambodia'),
(982, 'SYS', 'COUNTRY_CODE_038', 'CM/CMR'),
(983, 'SYS', 'COUNTRY_038', 'Cameroon'),
(984, 'SYS', 'COUNTRY_CODE_039', 'CA/CAN'),
(985, 'SYS', 'COUNTRY_039', 'Canada'),
(986, 'SYS', 'COUNTRY_CODE_040', 'CV/CPV'),
(987, 'SYS', 'COUNTRY_040', 'Cape Verde'),
(988, 'SYS', 'COUNTRY_CODE_041', 'KY/CYM'),
(989, 'SYS', 'COUNTRY_041', 'Cayman Islands'),
(990, 'SYS', 'COUNTRY_CODE_042', 'CF/CAF'),
(991, 'SYS', 'COUNTRY_042', 'Central African Republic'),
(992, 'SYS', 'COUNTRY_CODE_043', 'TD/TCD'),
(993, 'SYS', 'COUNTRY_043', 'Chad'),
(994, 'SYS', 'COUNTRY_CODE_044', 'CL/CHL'),
(995, 'SYS', 'COUNTRY_044', 'Chile'),
(996, 'SYS', 'COUNTRY_CODE_045', 'CN/CHN'),
(997, 'SYS', 'COUNTRY_045', 'China'),
(998, 'SYS', 'COUNTRY_CODE_046', 'CX/CXR'),
(999, 'SYS', 'COUNTRY_046', 'Christmas Island'),
(1000, 'SYS', 'COUNTRY_CODE_047', 'CC/CCK'),
(1001, 'SYS', 'COUNTRY_047', 'Cocos (Keeling) Islands'),
(1002, 'SYS', 'COUNTRY_CODE_048', 'CO/COL'),
(1003, 'SYS', 'COUNTRY_048', 'Colombia'),
(1004, 'SYS', 'COUNTRY_CODE_049', 'KM/COM'),
(1005, 'SYS', 'COUNTRY_049', 'Comoros'),
(1006, 'SYS', 'COUNTRY_CODE_050', 'CG/COG'),
(1007, 'SYS', 'COUNTRY_050', 'Congo'),
(1008, 'SYS', 'COUNTRY_CODE_239', 'CD/COD'),
(1009, 'SYS', 'COUNTRY_239', 'Congo, the Democratic Republic of the'),
(1010, 'SYS', 'COUNTRY_CODE_051', 'CK/COK'),
(1011, 'SYS', 'COUNTRY_051', 'Cook Islands'),
(1012, 'SYS', 'COUNTRY_CODE_052', 'CR/CRI'),
(1013, 'SYS', 'COUNTRY_052', 'Costa Rica'),
(1014, 'SYS', 'COUNTRY_CODE_053', 'CI/CIV'),
(1015, 'SYS', 'COUNTRY_053', 'Cote D''Ivoire'),
(1016, 'SYS', 'COUNTRY_CODE_054', 'HR/HRV'),
(1017, 'SYS', 'COUNTRY_054', 'Croatia'),
(1018, 'SYS', 'COUNTRY_CODE_055', 'CU/CUB'),
(1019, 'SYS', 'COUNTRY_055', 'Cuba'),
(1020, 'SYS', 'COUNTRY_CODE_056', 'CY/CYP'),
(1021, 'SYS', 'COUNTRY_056', 'Cyprus'),
(1022, 'SYS', 'COUNTRY_CODE_057', 'CZ/CZE'),
(1023, 'SYS', 'COUNTRY_057', 'Czech Republic'),
(1024, 'SYS', 'COUNTRY_CODE_058', 'DK/DNK'),
(1025, 'SYS', 'COUNTRY_058', 'Denmark'),
(1026, 'SYS', 'COUNTRY_CODE_059', 'DJ/DJI'),
(1027, 'SYS', 'COUNTRY_059', 'Djibouti'),
(1028, 'SYS', 'COUNTRY_CODE_060', 'DM/DMA'),
(1029, 'SYS', 'COUNTRY_060', 'Dominica'),
(1030, 'SYS', 'COUNTRY_CODE_061', 'DO/DOM'),
(1031, 'SYS', 'COUNTRY_061', 'Dominican Republic'),
(1032, 'SYS', 'COUNTRY_CODE_063', 'EC/ECU'),
(1033, 'SYS', 'COUNTRY_063', 'Ecuador'),
(1034, 'SYS', 'COUNTRY_CODE_064', 'EG/EGY'),
(1035, 'SYS', 'COUNTRY_064', 'Egypt'),
(1036, 'SYS', 'COUNTRY_CODE_065', 'SV/SLV'),
(1037, 'SYS', 'COUNTRY_065', 'El Salvador'),
(1038, 'SYS', 'COUNTRY_CODE_066', 'GQ/GNQ'),
(1039, 'SYS', 'COUNTRY_066', 'Equatorial Guinea'),
(1040, 'SYS', 'COUNTRY_CODE_067', 'ER/ERI'),
(1041, 'SYS', 'COUNTRY_067', 'Eritrea'),
(1042, 'SYS', 'COUNTRY_CODE_068', 'EE/EST'),
(1043, 'SYS', 'COUNTRY_068', 'Estonia'),
(1044, 'SYS', 'COUNTRY_CODE_069', 'ET/ETH'),
(1045, 'SYS', 'COUNTRY_069', 'Ethiopia'),
(1046, 'SYS', 'COUNTRY_CODE_070', 'FK/FLK'),
(1047, 'SYS', 'COUNTRY_070', 'Falkland Islands (Malvinas)'),
(1048, 'SYS', 'COUNTRY_CODE_071', 'FO/FRO'),
(1049, 'SYS', 'COUNTRY_071', 'Faroe Islands'),
(1050, 'SYS', 'COUNTRY_CODE_072', 'FJ/FJI'),
(1051, 'SYS', 'COUNTRY_072', 'Fiji'),
(1052, 'SYS', 'COUNTRY_CODE_073', 'FI/FIN'),
(1053, 'SYS', 'COUNTRY_073', 'Finland'),
(1054, 'SYS', 'COUNTRY_CODE_074', 'FR/FRA'),
(1055, 'SYS', 'COUNTRY_074', 'France'),
(1056, 'SYS', 'COUNTRY_CODE_075', 'FX/FXX'),
(1057, 'SYS', 'COUNTRY_075', 'France, Metropolitan'),
(1058, 'SYS', 'COUNTRY_CODE_076', 'GF/GUF'),
(1059, 'SYS', 'COUNTRY_076', 'French Guiana'),
(1060, 'SYS', 'COUNTRY_CODE_077', 'PF/PYF'),
(1061, 'SYS', 'COUNTRY_077', 'French Polynesia'),
(1062, 'SYS', 'COUNTRY_CODE_078', 'TF/ATF'),
(1063, 'SYS', 'COUNTRY_078', 'French Southern Territories'),
(1064, 'SYS', 'COUNTRY_CODE_079', 'GA/GAB'),
(1065, 'SYS', 'COUNTRY_079', 'Gabon'),
(1066, 'SYS', 'COUNTRY_CODE_080', 'GM/GMB'),
(1067, 'SYS', 'COUNTRY_080', 'Gambia'),
(1068, 'SYS', 'COUNTRY_CODE_081', 'GE/GEO'),
(1069, 'SYS', 'COUNTRY_081', 'Georgia'),
(1070, 'SYS', 'COUNTRY_CODE_082', 'DE/DEU'),
(1071, 'SYS', 'COUNTRY_082', 'Germany'),
(1072, 'SYS', 'COUNTRY_CODE_083', 'GH/GHA'),
(1073, 'SYS', 'COUNTRY_083', 'Ghana'),
(1074, 'SYS', 'COUNTRY_CODE_084', 'GI/GIB'),
(1075, 'SYS', 'COUNTRY_084', 'Gibraltar'),
(1076, 'SYS', 'COUNTRY_CODE_085', 'GR/GRC'),
(1077, 'SYS', 'COUNTRY_085', 'Greece'),
(1078, 'SYS', 'COUNTRY_CODE_086', 'GL/GRL'),
(1079, 'SYS', 'COUNTRY_086', 'Greenland'),
(1080, 'SYS', 'COUNTRY_CODE_087', 'GD/GRD'),
(1081, 'SYS', 'COUNTRY_087', 'Grenada'),
(1082, 'SYS', 'COUNTRY_CODE_088', 'GP/GLP'),
(1083, 'SYS', 'COUNTRY_088', 'Guadeloupe'),
(1084, 'SYS', 'COUNTRY_CODE_089', 'GU/GUM'),
(1085, 'SYS', 'COUNTRY_089', 'Guam'),
(1086, 'SYS', 'COUNTRY_CODE_090', 'GT/GTM'),
(1087, 'SYS', 'COUNTRY_090', 'Guatemala'),
(1088, 'SYS', 'COUNTRY_CODE_240', 'GG/GGY'),
(1089, 'SYS', 'COUNTRY_240', 'Guernsey'),
(1090, 'SYS', 'COUNTRY_CODE_091', 'GN/GIN'),
(1091, 'SYS', 'COUNTRY_091', 'Guinea'),
(1092, 'SYS', 'COUNTRY_CODE_092', 'GW/GNB'),
(1093, 'SYS', 'COUNTRY_092', 'Guinea-Bissau'),
(1094, 'SYS', 'COUNTRY_CODE_093', 'GY/GUY'),
(1095, 'SYS', 'COUNTRY_093', 'Guyana'),
(1096, 'SYS', 'COUNTRY_CODE_094', 'HT/HTI'),
(1097, 'SYS', 'COUNTRY_094', 'Haiti'),
(1098, 'SYS', 'COUNTRY_CODE_095', 'HM/HMD'),
(1099, 'SYS', 'COUNTRY_095', 'Heard and McDonald Islands'),
(1100, 'SYS', 'COUNTRY_CODE_096', 'HN/HND'),
(1101, 'SYS', 'COUNTRY_096', 'Honduras'),
(1102, 'SYS', 'COUNTRY_CODE_097', 'HK/HKG'),
(1103, 'SYS', 'COUNTRY_097', 'Hong Kong'),
(1104, 'SYS', 'COUNTRY_CODE_098', 'HU/HUN'),
(1105, 'SYS', 'COUNTRY_098', 'Hungary'),
(1106, 'SYS', 'COUNTRY_CODE_099', 'IS/ISL'),
(1107, 'SYS', 'COUNTRY_099', 'Iceland'),
(1108, 'SYS', 'COUNTRY_CODE_100', 'IN/IND'),
(1109, 'SYS', 'COUNTRY_100', 'India'),
(1110, 'SYS', 'COUNTRY_CODE_101', 'ID/IDN'),
(1111, 'SYS', 'COUNTRY_101', 'Indonesia'),
(1112, 'SYS', 'COUNTRY_CODE_102', 'IQ/IRQ'),
(1113, 'SYS', 'COUNTRY_102', 'Iraq'),
(1114, 'SYS', 'COUNTRY_CODE_103', 'IE/IRL'),
(1115, 'SYS', 'COUNTRY_103', 'Ireland'),
(1116, 'SYS', 'COUNTRY_CODE_104', 'IR/IRN'),
(1117, 'SYS', 'COUNTRY_104', 'Islamic Republic of Iran'),
(1118, 'SYS', 'COUNTRY_CODE_241', 'IM/IMN'),
(1119, 'SYS', 'COUNTRY_241', 'Isle of Man'),
(1120, 'SYS', 'COUNTRY_CODE_105', 'IL/ISR'),
(1121, 'SYS', 'COUNTRY_105', 'Israel'),
(1122, 'SYS', 'COUNTRY_CODE_106', 'IT/ITA'),
(1123, 'SYS', 'COUNTRY_106', 'Italy'),
(1124, 'SYS', 'COUNTRY_CODE_107', 'JM/JAM'),
(1125, 'SYS', 'COUNTRY_107', 'Jamaica'),
(1126, 'SYS', 'COUNTRY_CODE_108', 'JP/JPN'),
(1127, 'SYS', 'COUNTRY_108', 'Japan'),
(1128, 'SYS', 'COUNTRY_CODE_242', 'JE/JEY'),
(1129, 'SYS', 'COUNTRY_242', 'Jersey'),
(1130, 'SYS', 'COUNTRY_CODE_109', 'JO/JOR'),
(1131, 'SYS', 'COUNTRY_109', 'Jordan'),
(1132, 'SYS', 'COUNTRY_CODE_110', 'KZ/KAZ'),
(1133, 'SYS', 'COUNTRY_110', 'Kazakhstan'),
(1134, 'SYS', 'COUNTRY_CODE_111', 'KE/KEN'),
(1135, 'SYS', 'COUNTRY_111', 'Kenya'),
(1136, 'SYS', 'COUNTRY_CODE_112', 'KI/KIR'),
(1137, 'SYS', 'COUNTRY_112', 'Kiribati'),
(1138, 'SYS', 'COUNTRY_CODE_113', 'KP/PRK'),
(1139, 'SYS', 'COUNTRY_113', 'Korea'),
(1140, 'SYS', 'COUNTRY_CODE_114', 'KR/KOR'),
(1141, 'SYS', 'COUNTRY_114', 'Korea, Republic of'),
(1142, 'SYS', 'COUNTRY_CODE_115', 'KW/KWT'),
(1143, 'SYS', 'COUNTRY_115', 'Kuwait'),
(1144, 'SYS', 'COUNTRY_CODE_116', 'KG/KGZ'),
(1145, 'SYS', 'COUNTRY_116', 'Kyrgyzstan'),
(1146, 'SYS', 'COUNTRY_CODE_117', 'LA/LAO'),
(1147, 'SYS', 'COUNTRY_117', 'Laos'),
(1148, 'SYS', 'COUNTRY_CODE_118', 'LV/LVA'),
(1149, 'SYS', 'COUNTRY_118', 'Latvia'),
(1150, 'SYS', 'COUNTRY_CODE_119', 'LB/LBN'),
(1151, 'SYS', 'COUNTRY_119', 'Lebanon'),
(1152, 'SYS', 'COUNTRY_CODE_120', 'LS/LSO'),
(1153, 'SYS', 'COUNTRY_120', 'Lesotho'),
(1154, 'SYS', 'COUNTRY_CODE_121', 'LR/LBR'),
(1155, 'SYS', 'COUNTRY_121', 'Liberia'),
(1156, 'SYS', 'COUNTRY_CODE_122', 'LY/LBY'),
(1157, 'SYS', 'COUNTRY_122', 'Libyan Arab Jamahiriya'),
(1158, 'SYS', 'COUNTRY_CODE_123', 'LI/LIE'),
(1159, 'SYS', 'COUNTRY_123', 'Liechtenstein'),
(1160, 'SYS', 'COUNTRY_CODE_124', 'LT/LTU'),
(1161, 'SYS', 'COUNTRY_124', 'Lithuania'),
(1162, 'SYS', 'COUNTRY_CODE_125', 'LU/LUX'),
(1163, 'SYS', 'COUNTRY_125', 'Luxembourg'),
(1164, 'SYS', 'COUNTRY_CODE_126', 'MO/MAC'),
(1165, 'SYS', 'COUNTRY_126', 'Macao'),
(1166, 'SYS', 'COUNTRY_CODE_127', 'MK/MKD'),
(1167, 'SYS', 'COUNTRY_127', 'Macedonia'),
(1168, 'SYS', 'COUNTRY_CODE_128', 'MG/MDG'),
(1169, 'SYS', 'COUNTRY_128', 'Madagascar'),
(1170, 'SYS', 'COUNTRY_CODE_129', 'MW/MWI'),
(1171, 'SYS', 'COUNTRY_129', 'Malawi'),
(1172, 'SYS', 'COUNTRY_CODE_130', 'MY/MYS'),
(1173, 'SYS', 'COUNTRY_130', 'Malaysia'),
(1174, 'SYS', 'COUNTRY_CODE_131', 'MV/MDV'),
(1175, 'SYS', 'COUNTRY_131', 'Maldives'),
(1176, 'SYS', 'COUNTRY_CODE_132', 'ML/MLI'),
(1177, 'SYS', 'COUNTRY_132', 'Mali'),
(1178, 'SYS', 'COUNTRY_CODE_133', 'MT/MLT'),
(1179, 'SYS', 'COUNTRY_133', 'Malta'),
(1180, 'SYS', 'COUNTRY_CODE_134', 'MH/MHL'),
(1181, 'SYS', 'COUNTRY_134', 'Marshall Islands'),
(1182, 'SYS', 'COUNTRY_CODE_135', 'MQ/MTQ'),
(1183, 'SYS', 'COUNTRY_135', 'Martinique'),
(1184, 'SYS', 'COUNTRY_CODE_136', 'MR/MRT'),
(1185, 'SYS', 'COUNTRY_136', 'Mauritania'),
(1186, 'SYS', 'COUNTRY_CODE_137', 'MU/MUS'),
(1187, 'SYS', 'COUNTRY_137', 'Mauritius'),
(1188, 'SYS', 'COUNTRY_CODE_138', 'YT/MYT'),
(1189, 'SYS', 'COUNTRY_138', 'Mayotte'),
(1190, 'SYS', 'COUNTRY_CODE_139', 'MX/MEX'),
(1191, 'SYS', 'COUNTRY_139', 'Mexico'),
(1192, 'SYS', 'COUNTRY_CODE_140', 'FM/FSM'),
(1193, 'SYS', 'COUNTRY_140', 'Micronesia'),
(1194, 'SYS', 'COUNTRY_CODE_141', 'MD/MDA'),
(1195, 'SYS', 'COUNTRY_141', 'Moldova, Republic of'),
(1196, 'SYS', 'COUNTRY_CODE_142', 'MC/MCO'),
(1197, 'SYS', 'COUNTRY_142', 'Monaco'),
(1198, 'SYS', 'COUNTRY_CODE_143', 'MN/MNG'),
(1199, 'SYS', 'COUNTRY_143', 'Mongolia'),
(1200, 'SYS', 'COUNTRY_CODE_243', 'ME/MNE'),
(1201, 'SYS', 'COUNTRY_243', 'Montenegro'),
(1202, 'SYS', 'COUNTRY_CODE_144', 'MS/MSR'),
(1203, 'SYS', 'COUNTRY_144', 'Montserrat'),
(1204, 'SYS', 'COUNTRY_CODE_145', 'MA/MAR'),
(1205, 'SYS', 'COUNTRY_145', 'Morocco'),
(1206, 'SYS', 'COUNTRY_CODE_146', 'MZ/MOZ'),
(1207, 'SYS', 'COUNTRY_146', 'Mozambique'),
(1208, 'SYS', 'COUNTRY_CODE_147', 'MM/MMR'),
(1209, 'SYS', 'COUNTRY_147', 'Myanmar'),
(1210, 'SYS', 'COUNTRY_CODE_148', 'NA/NAM'),
(1211, 'SYS', 'COUNTRY_148', 'Namibia'),
(1212, 'SYS', 'COUNTRY_CODE_149', 'NR/NRU'),
(1213, 'SYS', 'COUNTRY_149', 'Nauru'),
(1214, 'SYS', 'COUNTRY_CODE_150', 'NP/NPL'),
(1215, 'SYS', 'COUNTRY_150', 'Nepal'),
(1216, 'SYS', 'COUNTRY_CODE_151', 'NL/NLD'),
(1217, 'SYS', 'COUNTRY_151', 'Netherlands'),
(1218, 'SYS', 'COUNTRY_CODE_152', 'AN/ANT'),
(1219, 'SYS', 'COUNTRY_152', 'Netherlands Antilles'),
(1220, 'SYS', 'COUNTRY_CODE_153', 'NC/NCL'),
(1221, 'SYS', 'COUNTRY_153', 'New Caledonia'),
(1222, 'SYS', 'COUNTRY_CODE_154', 'NZ/NZL'),
(1223, 'SYS', 'COUNTRY_154', 'New Zealand'),
(1224, 'SYS', 'COUNTRY_CODE_155', 'NI/NIC'),
(1225, 'SYS', 'COUNTRY_155', 'Nicaragua'),
(1226, 'SYS', 'COUNTRY_CODE_156', 'NE/NER'),
(1227, 'SYS', 'COUNTRY_156', 'Niger'),
(1228, 'SYS', 'COUNTRY_CODE_157', 'NG/NGA'),
(1229, 'SYS', 'COUNTRY_157', 'Nigeria'),
(1230, 'SYS', 'COUNTRY_CODE_158', 'NU/NIU'),
(1231, 'SYS', 'COUNTRY_158', 'Niue'),
(1232, 'SYS', 'COUNTRY_CODE_159', 'NF/NFK'),
(1233, 'SYS', 'COUNTRY_159', 'Norfolk Island'),
(1234, 'SYS', 'COUNTRY_CODE_160', 'MP/MNP'),
(1235, 'SYS', 'COUNTRY_160', 'Northern Mariana Islands'),
(1236, 'SYS', 'COUNTRY_CODE_161', 'NO/NOR'),
(1237, 'SYS', 'COUNTRY_161', 'Norway'),
(1238, 'SYS', 'COUNTRY_CODE_162', 'OM/OMN'),
(1239, 'SYS', 'COUNTRY_162', 'Oman'),
(1240, 'SYS', 'COUNTRY_CODE_163', 'PK/PAK'),
(1241, 'SYS', 'COUNTRY_163', 'Pakistan'),
(1242, 'SYS', 'COUNTRY_CODE_164', 'PW/PLW'),
(1243, 'SYS', 'COUNTRY_164', 'Palau'),
(1244, 'SYS', 'COUNTRY_CODE_244', 'PS/PSE'),
(1245, 'SYS', 'COUNTRY_244', 'Palestinian Territory'),
(1246, 'SYS', 'COUNTRY_CODE_165', 'PA/PAN'),
(1247, 'SYS', 'COUNTRY_165', 'Panama'),
(1248, 'SYS', 'COUNTRY_CODE_166', 'PG/PNG'),
(1249, 'SYS', 'COUNTRY_166', 'Papua New Guinea'),
(1250, 'SYS', 'COUNTRY_CODE_167', 'PY/PRY'),
(1251, 'SYS', 'COUNTRY_167', 'Paraguay'),
(1252, 'SYS', 'COUNTRY_CODE_168', 'PE/PER'),
(1253, 'SYS', 'COUNTRY_168', 'Peru'),
(1254, 'SYS', 'COUNTRY_CODE_169', 'PH/PHL'),
(1255, 'SYS', 'COUNTRY_169', 'Philippines'),
(1256, 'SYS', 'COUNTRY_CODE_170', 'PN/PCN'),
(1257, 'SYS', 'COUNTRY_170', 'Pitcairn'),
(1258, 'SYS', 'COUNTRY_CODE_171', 'PL/POL'),
(1259, 'SYS', 'COUNTRY_171', 'Poland'),
(1260, 'SYS', 'COUNTRY_CODE_172', 'PT/PRT'),
(1261, 'SYS', 'COUNTRY_172', 'Portugal'),
(1262, 'SYS', 'COUNTRY_CODE_173', 'PR/PRI'),
(1263, 'SYS', 'COUNTRY_173', 'Puerto Rico'),
(1264, 'SYS', 'COUNTRY_CODE_174', 'QA/QAT'),
(1265, 'SYS', 'COUNTRY_174', 'Qatar'),
(1266, 'SYS', 'COUNTRY_CODE_175', 'RE/REU'),
(1267, 'SYS', 'COUNTRY_175', 'Reunion'),
(1268, 'SYS', 'COUNTRY_CODE_176', 'RO/ROU'),
(1269, 'SYS', 'COUNTRY_176', 'Romania'),
(1270, 'SYS', 'COUNTRY_CODE_177', 'RU/RUS'),
(1271, 'SYS', 'COUNTRY_177', 'Russian Federation'),
(1272, 'SYS', 'COUNTRY_CODE_178', 'RW/RWA'),
(1273, 'SYS', 'COUNTRY_178', 'Rwanda'),
(1274, 'SYS', 'COUNTRY_CODE_245', 'BL/BLM'),
(1275, 'SYS', 'COUNTRY_245', 'Saint Barthelemy'),
(1276, 'SYS', 'COUNTRY_CODE_179', 'LC/LCA'),
(1277, 'SYS', 'COUNTRY_179', 'Saint Lucia'),
(1278, 'SYS', 'COUNTRY_CODE_180', 'WS/WSM'),
(1279, 'SYS', 'COUNTRY_180', 'Samoa'),
(1280, 'SYS', 'COUNTRY_CODE_181', 'SM/SMR'),
(1281, 'SYS', 'COUNTRY_181', 'San Marino'),
(1282, 'SYS', 'COUNTRY_CODE_182', 'ST/STP'),
(1283, 'SYS', 'COUNTRY_182', 'Sao Tome and Principe'),
(1284, 'SYS', 'COUNTRY_CODE_183', 'SA/SAU'),
(1285, 'SYS', 'COUNTRY_183', 'Saudi Arabia'),
(1286, 'SYS', 'COUNTRY_CODE_184', 'SN/SEN'),
(1287, 'SYS', 'COUNTRY_184', 'Senegal'),
(1288, 'SYS', 'COUNTRY_CODE_246', 'RS/SRB'),
(1289, 'SYS', 'COUNTRY_246', 'Serbia'),
(1290, 'SYS', 'COUNTRY_CODE_185', 'SC/SYC'),
(1291, 'SYS', 'COUNTRY_185', 'Seychelles'),
(1292, 'SYS', 'COUNTRY_CODE_186', 'SL/SLE'),
(1293, 'SYS', 'COUNTRY_186', 'Sierra Leone'),
(1294, 'SYS', 'COUNTRY_CODE_187', 'SG/SGP'),
(1295, 'SYS', 'COUNTRY_187', 'Singapore'),
(1296, 'SYS', 'COUNTRY_CODE_188', 'SK/SVK'),
(1297, 'SYS', 'COUNTRY_188', 'Slovakia'),
(1298, 'SYS', 'COUNTRY_CODE_189', 'SI/SVN'),
(1299, 'SYS', 'COUNTRY_189', 'Slovenia'),
(1300, 'SYS', 'COUNTRY_CODE_190', 'SB/SLB'),
(1301, 'SYS', 'COUNTRY_190', 'Solomon Islands'),
(1302, 'SYS', 'COUNTRY_CODE_191', 'SO/SOM'),
(1303, 'SYS', 'COUNTRY_191', 'Somalia'),
(1304, 'SYS', 'COUNTRY_CODE_192', 'ZA/ZAF'),
(1305, 'SYS', 'COUNTRY_192', 'South Africa'),
(1306, 'SYS', 'COUNTRY_CODE_247', 'GS/SGS'),
(1307, 'SYS', 'COUNTRY_247', 'South Georgia and the South Sandwich Islands'),
(1308, 'SYS', 'COUNTRY_CODE_193', 'ES/ESP'),
(1309, 'SYS', 'COUNTRY_193', 'Spain'),
(1310, 'SYS', 'COUNTRY_CODE_194', 'LK/LKA'),
(1311, 'SYS', 'COUNTRY_194', 'Sri Lanka'),
(1312, 'SYS', 'COUNTRY_CODE_195', 'SH/SHN'),
(1313, 'SYS', 'COUNTRY_195', 'St. Helena, Ascension and Tristan da Cunha'),
(1314, 'SYS', 'COUNTRY_CODE_196', 'KN/KNA'),
(1315, 'SYS', 'COUNTRY_196', 'St. Kitts and Nevis'),
(1316, 'SYS', 'COUNTRY_CODE_197', 'PM/SPM'),
(1317, 'SYS', 'COUNTRY_197', 'St. Pierre and Miquelon'),
(1318, 'SYS', 'COUNTRY_CODE_198', 'VC/VCT'),
(1319, 'SYS', 'COUNTRY_198', 'St. Vincent and the Grenadines'),
(1320, 'SYS', 'COUNTRY_CODE_199', 'SD/SDN'),
(1321, 'SYS', 'COUNTRY_199', 'Sudan'),
(1322, 'SYS', 'COUNTRY_CODE_200', 'SR/SUR'),
(1323, 'SYS', 'COUNTRY_200', 'Suriname'),
(1324, 'SYS', 'COUNTRY_CODE_201', 'SJ/SJM'),
(1325, 'SYS', 'COUNTRY_201', 'Svalbard and Jan Mayen Islands'),
(1326, 'SYS', 'COUNTRY_CODE_202', 'SZ/SWZ'),
(1327, 'SYS', 'COUNTRY_202', 'Swaziland'),
(1328, 'SYS', 'COUNTRY_CODE_203', 'SE/SWE'),
(1329, 'SYS', 'COUNTRY_203', 'Sweden'),
(1330, 'SYS', 'COUNTRY_CODE_204', 'CH/CHE'),
(1331, 'SYS', 'COUNTRY_204', 'Switzerland'),
(1332, 'SYS', 'COUNTRY_CODE_205', 'SY/SYR'),
(1333, 'SYS', 'COUNTRY_205', 'Syrian Arab Republic'),
(1334, 'SYS', 'COUNTRY_CODE_206', 'TW/TWN'),
(1335, 'SYS', 'COUNTRY_206', 'Taiwan'),
(1336, 'SYS', 'COUNTRY_CODE_207', 'TJ/TJK'),
(1337, 'SYS', 'COUNTRY_207', 'Tajikistan'),
(1338, 'SYS', 'COUNTRY_CODE_208', 'TZ/TZA'),
(1339, 'SYS', 'COUNTRY_208', 'Tanzania, United Republic of'),
(1340, 'SYS', 'COUNTRY_CODE_209', 'TH/THA'),
(1341, 'SYS', 'COUNTRY_209', 'Thailand'),
(1342, 'SYS', 'COUNTRY_CODE_248', 'TL/TLS'),
(1343, 'SYS', 'COUNTRY_248', 'Timor-Leste'),
(1344, 'SYS', 'COUNTRY_CODE_210', 'TG/TGO'),
(1345, 'SYS', 'COUNTRY_210', 'Togo'),
(1346, 'SYS', 'COUNTRY_CODE_211', 'TK/TKL'),
(1347, 'SYS', 'COUNTRY_211', 'Tokelau'),
(1348, 'SYS', 'COUNTRY_CODE_212', 'TO/TON'),
(1349, 'SYS', 'COUNTRY_212', 'Tonga'),
(1350, 'SYS', 'COUNTRY_CODE_213', 'TT/TTO'),
(1351, 'SYS', 'COUNTRY_213', 'Trinidad and Tobago'),
(1352, 'SYS', 'COUNTRY_CODE_214', 'TN/TUN'),
(1353, 'SYS', 'COUNTRY_214', 'Tunisia'),
(1354, 'SYS', 'COUNTRY_CODE_215', 'TR/TUR'),
(1355, 'SYS', 'COUNTRY_215', 'Turkey'),
(1356, 'SYS', 'COUNTRY_CODE_216', 'TM/TKM'),
(1357, 'SYS', 'COUNTRY_216', 'Turkmenistan'),
(1358, 'SYS', 'COUNTRY_CODE_217', 'TC/TCA'),
(1359, 'SYS', 'COUNTRY_217', 'Turks and Caicos Islands'),
(1360, 'SYS', 'COUNTRY_CODE_218', 'TV/TUV'),
(1361, 'SYS', 'COUNTRY_218', 'Tuvalu'),
(1362, 'SYS', 'COUNTRY_CODE_219', 'UG/UGA'),
(1363, 'SYS', 'COUNTRY_219', 'Uganda'),
(1364, 'SYS', 'COUNTRY_CODE_220', 'UA/UKR'),
(1365, 'SYS', 'COUNTRY_220', 'Ukraine'),
(1366, 'SYS', 'COUNTRY_CODE_221', 'AE/ARE'),
(1367, 'SYS', 'COUNTRY_221', 'United Arab Emirates'),
(1368, 'SYS', 'COUNTRY_CODE_222', 'GB/GBR'),
(1369, 'SYS', 'COUNTRY_222', 'United Kingdom (Great Britain)'),
(1370, 'SYS', 'COUNTRY_CODE_223', 'US/USA'),
(1371, 'SYS', 'COUNTRY_223', 'United States'),
(1372, 'SYS', 'COUNTRY_CODE_249', 'UM/UMI'),
(1373, 'SYS', 'COUNTRY_249', 'United States Minor Outlying Islands'),
(1374, 'SYS', 'COUNTRY_CODE_224', 'VI/VIR'),
(1375, 'SYS', 'COUNTRY_224', 'United States Virgin Islands'),
(1376, 'SYS', 'COUNTRY_CODE_225', 'UY/URY'),
(1377, 'SYS', 'COUNTRY_225', 'Uruguay'),
(1378, 'SYS', 'COUNTRY_CODE_226', 'UZ/UZB'),
(1379, 'SYS', 'COUNTRY_226', 'Uzbekistan'),
(1380, 'SYS', 'COUNTRY_CODE_227', 'VU/VUT'),
(1381, 'SYS', 'COUNTRY_227', 'Vanuatu'),
(1382, 'SYS', 'COUNTRY_CODE_228', 'VA/VAT'),
(1383, 'SYS', 'COUNTRY_228', 'Holy See (Vatican City State)'),
(1384, 'SYS', 'COUNTRY_CODE_229', 'VE/VEN'),
(1385, 'SYS', 'COUNTRY_229', 'Venezuela'),
(1386, 'SYS', 'COUNTRY_CODE_230', 'VN/VNM'),
(1387, 'SYS', 'COUNTRY_230', 'Viet Nam'),
(1388, 'SYS', 'COUNTRY_CODE_231', 'WF/WLF'),
(1389, 'SYS', 'COUNTRY_231', 'Wallis And Futuna'),
(1390, 'SYS', 'COUNTRY_CODE_232', 'EH/ESH'),
(1391, 'SYS', 'COUNTRY_232', 'Western Sahara'),
(1392, 'SYS', 'COUNTRY_CODE_233', 'YE/YEM'),
(1393, 'SYS', 'COUNTRY_233', 'Yemen'),
(1394, 'SYS', 'COUNTRY_CODE_236', 'ZM/ZMB'),
(1395, 'SYS', 'COUNTRY_236', 'Zambia'),
(1396, 'SYS', 'COUNTRY_CODE_237', 'ZW/ZWE'),
(1397, 'SYS', 'COUNTRY_237', 'Zimbabwe'),
(1398, 'SYS', 'STATE_CODE_001', 'CT'),
(1399, 'SYS', 'STATE_001', 'Australian Capital Territory'),
(1400, 'SYS', 'STATE_CODE_002', 'NS'),
(1401, 'SYS', 'STATE_002', 'New South Wales'),
(1402, 'SYS', 'STATE_CODE_003', 'NT'),
(1403, 'SYS', 'STATE_003', 'Northern Territory'),
(1404, 'SYS', 'STATE_CODE_004', 'QL'),
(1405, 'SYS', 'STATE_004', 'Queensland'),
(1406, 'SYS', 'STATE_CODE_005', 'SA'),
(1407, 'SYS', 'STATE_005', 'South Australia'),
(1408, 'SYS', 'STATE_CODE_006', 'TS'),
(1409, 'SYS', 'STATE_006', 'Tasmania'),
(1410, 'SYS', 'STATE_CODE_007', 'VI'),
(1411, 'SYS', 'STATE_007', 'Victoria'),
(1412, 'SYS', 'STATE_CODE_008', 'WA'),
(1413, 'SYS', 'STATE_008', 'Western Australia'),
(1414, 'SYS', 'STATE_CODE_009', 'BUR'),
(1415, 'SYS', 'STATE_009', 'Burgenland'),
(1416, 'SYS', 'STATE_CODE_010', 'KAR'),
(1417, 'SYS', 'STATE_010', 'Karnten'),
(1418, 'SYS', 'STATE_CODE_011', 'NIE'),
(1419, 'SYS', 'STATE_011', 'Niederosterreich'),
(1420, 'SYS', 'STATE_CODE_012', 'OBO'),
(1421, 'SYS', 'STATE_012', 'Oberosterreich'),
(1422, 'SYS', 'STATE_CODE_013', 'SAL'),
(1423, 'SYS', 'STATE_013', 'Salzburgerland'),
(1424, 'SYS', 'STATE_CODE_014', 'STE'),
(1425, 'SYS', 'STATE_014', 'Steiermark'),
(1426, 'SYS', 'STATE_CODE_015', 'TIR'),
(1427, 'SYS', 'STATE_015', 'Tirol'),
(1428, 'SYS', 'STATE_CODE_016', 'VOR'),
(1429, 'SYS', 'STATE_016', 'Vorarlberg'),
(1430, 'SYS', 'STATE_CODE_017', 'WIE'),
(1431, 'SYS', 'STATE_017', 'Wien'),
(1432, 'SYS', 'STATE_CODE_018', 'ANT'),
(1433, 'SYS', 'STATE_018', 'Antwerpen'),
(1434, 'SYS', 'STATE_CODE_019', 'WBR'),
(1435, 'SYS', 'STATE_019', 'Brabant Wallon'),
(1436, 'SYS', 'STATE_CODE_020', 'BRU'),
(1437, 'SYS', 'STATE_020', 'Brussel - Bruxelles'),
(1438, 'SYS', 'STATE_CODE_021', 'HAI'),
(1439, 'SYS', 'STATE_021', 'Hainaut'),
(1440, 'SYS', 'STATE_CODE_022', 'LIE'),
(1441, 'SYS', 'STATE_022', 'Lie`ge'),
(1442, 'SYS', 'STATE_CODE_023', 'LIM'),
(1443, 'SYS', 'STATE_023', 'Limburg'),
(1444, 'SYS', 'STATE_CODE_024', 'Lux'),
(1445, 'SYS', 'STATE_024', 'Luxembourg'),
(1446, 'SYS', 'STATE_CODE_025', 'NAM'),
(1447, 'SYS', 'STATE_025', 'Namur'),
(1448, 'SYS', 'STATE_CODE_026', 'OVL'),
(1449, 'SYS', 'STATE_026', 'Oost-Vlaanderen'),
(1450, 'SYS', 'STATE_CODE_027', 'VBR'),
(1451, 'SYS', 'STATE_027', 'Vlaams-Brabant'),
(1452, 'SYS', 'STATE_CODE_028', 'WVL'),
(1453, 'SYS', 'STATE_028', 'West-Vlaanderen'),
(1454, 'SYS', 'STATE_CODE_029', 'AB'),
(1455, 'SYS', 'STATE_029', 'Alberta'),
(1456, 'SYS', 'STATE_CODE_030', 'BC'),
(1457, 'SYS', 'STATE_030', 'British Columbia'),
(1458, 'SYS', 'STATE_CODE_031', 'MB'),
(1459, 'SYS', 'STATE_031', 'Manitoba'),
(1460, 'SYS', 'STATE_CODE_032', 'NB'),
(1461, 'SYS', 'STATE_032', 'New Brunswick'),
(1462, 'SYS', 'STATE_CODE_033', 'NL'),
(1463, 'SYS', 'STATE_033', 'Newfoundland and Labrador'),
(1464, 'SYS', 'STATE_CODE_034', 'NT'),
(1465, 'SYS', 'STATE_034', 'Northwest Territories'),
(1466, 'SYS', 'STATE_CODE_035', 'NS'),
(1467, 'SYS', 'STATE_035', 'Nova Scotia'),
(1468, 'SYS', 'STATE_CODE_036', 'NU'),
(1469, 'SYS', 'STATE_036', 'Nunavut'),
(1470, 'SYS', 'STATE_CODE_037', 'ON'),
(1471, 'SYS', 'STATE_037', 'Ontario'),
(1472, 'SYS', 'STATE_CODE_038', 'PE'),
(1473, 'SYS', 'STATE_038', 'Prince Edward Island'),
(1474, 'SYS', 'STATE_CODE_039', 'QC'),
(1475, 'SYS', 'STATE_039', 'Quebec'),
(1476, 'SYS', 'STATE_CODE_040', 'SK'),
(1477, 'SYS', 'STATE_040', 'Saskatchewan'),
(1478, 'SYS', 'STATE_CODE_041', '1'),
(1479, 'SYS', 'STATE_041', 'Ain'),
(1480, 'SYS', 'STATE_CODE_042', '2'),
(1481, 'SYS', 'STATE_042', 'Aisne'),
(1482, 'SYS', 'STATE_CODE_043', '3'),
(1483, 'SYS', 'STATE_043', 'Allier'),
(1484, 'SYS', 'STATE_CODE_044', '4'),
(1485, 'SYS', 'STATE_044', 'Alpes-de-Haute-Provence'),
(1486, 'SYS', 'STATE_CODE_045', '6'),
(1487, 'SYS', 'STATE_045', 'Alpes-Maritimes'),
(1488, 'SYS', 'STATE_CODE_046', '7'),
(1489, 'SYS', 'STATE_046', 'Arde`che'),
(1490, 'SYS', 'STATE_CODE_047', '8'),
(1491, 'SYS', 'STATE_047', 'Ardennes'),
(1492, 'SYS', 'STATE_CODE_048', '9'),
(1493, 'SYS', 'STATE_048', 'Arie`ge'),
(1494, 'SYS', 'STATE_CODE_049', '10'),
(1495, 'SYS', 'STATE_049', 'Aube'),
(1496, 'SYS', 'STATE_CODE_050', '11'),
(1497, 'SYS', 'STATE_050', 'Aude'),
(1498, 'SYS', 'STATE_CODE_051', '12'),
(1499, 'SYS', 'STATE_051', 'Aveyron'),
(1500, 'SYS', 'STATE_CODE_052', '67'),
(1501, 'SYS', 'STATE_052', 'Bas-Rhin'),
(1502, 'SYS', 'STATE_CODE_053', '13'),
(1503, 'SYS', 'STATE_053', 'Bouches-du-Rho^ne'),
(1504, 'SYS', 'STATE_CODE_054', '14'),
(1505, 'SYS', 'STATE_054', 'Calvados'),
(1506, 'SYS', 'STATE_CODE_055', '15'),
(1507, 'SYS', 'STATE_055', 'Cantal'),
(1508, 'SYS', 'STATE_CODE_056', '16'),
(1509, 'SYS', 'STATE_056', 'Charente'),
(1510, 'SYS', 'STATE_CODE_057', '17'),
(1511, 'SYS', 'STATE_057', 'Charente-Maritime'),
(1512, 'SYS', 'STATE_CODE_058', '18'),
(1513, 'SYS', 'STATE_058', 'Cher'),
(1514, 'SYS', 'STATE_CODE_059', '19'),
(1515, 'SYS', 'STATE_059', 'Corre`ze'),
(1516, 'SYS', 'STATE_CODE_060', '2A'),
(1517, 'SYS', 'STATE_060', 'Corsu-du-Sud'),
(1518, 'SYS', 'STATE_CODE_061', '21'),
(1519, 'SYS', 'STATE_061', 'Co^te-d''Or'),
(1520, 'SYS', 'STATE_CODE_062', '22'),
(1521, 'SYS', 'STATE_062', 'Co^tes-d''Armor'),
(1522, 'SYS', 'STATE_CODE_063', '23'),
(1523, 'SYS', 'STATE_063', 'Creuse'),
(1524, 'SYS', 'STATE_CODE_064', '79'),
(1525, 'SYS', 'STATE_064', 'Deux-Sevres'),
(1526, 'SYS', 'STATE_CODE_065', '24'),
(1527, 'SYS', 'STATE_065', 'Dordogne'),
(1528, 'SYS', 'STATE_CODE_066', '25'),
(1529, 'SYS', 'STATE_066', 'Doubs'),
(1530, 'SYS', 'STATE_CODE_067', '26'),
(1531, 'SYS', 'STATE_067', 'Dro^me'),
(1532, 'SYS', 'STATE_CODE_068', '91'),
(1533, 'SYS', 'STATE_068', 'Essonne'),
(1534, 'SYS', 'STATE_CODE_069', '27'),
(1535, 'SYS', 'STATE_069', 'Eure'),
(1536, 'SYS', 'STATE_CODE_070', '28'),
(1537, 'SYS', 'STATE_070', 'Eure-et-Loir'),
(1538, 'SYS', 'STATE_CODE_071', '29'),
(1539, 'SYS', 'STATE_071', 'Finiste`re'),
(1540, 'SYS', 'STATE_CODE_072', '30'),
(1541, 'SYS', 'STATE_072', 'Gard'),
(1542, 'SYS', 'STATE_CODE_073', '32'),
(1543, 'SYS', 'STATE_073', 'Gers'),
(1544, 'SYS', 'STATE_CODE_074', '33'),
(1545, 'SYS', 'STATE_074', 'Gironde'),
(1546, 'SYS', 'STATE_CODE_075', '68'),
(1547, 'SYS', 'STATE_075', 'Haut-Rhin'),
(1548, 'SYS', 'STATE_CODE_076', '2B'),
(1549, 'SYS', 'STATE_076', 'Haute-Corse'),
(1550, 'SYS', 'STATE_CODE_077', '31'),
(1551, 'SYS', 'STATE_077', 'Haute-Garonne'),
(1552, 'SYS', 'STATE_CODE_078', '43'),
(1553, 'SYS', 'STATE_078', 'Haute-Loire'),
(1554, 'SYS', 'STATE_CODE_079', '52'),
(1555, 'SYS', 'STATE_079', 'Haute-Marne'),
(1556, 'SYS', 'STATE_CODE_080', '70'),
(1557, 'SYS', 'STATE_080', 'Haute-Sao^ne'),
(1558, 'SYS', 'STATE_CODE_081', '74'),
(1559, 'SYS', 'STATE_081', 'Haute-Savoie'),
(1560, 'SYS', 'STATE_CODE_082', '87'),
(1561, 'SYS', 'STATE_082', 'Haute-Vienne'),
(1562, 'SYS', 'STATE_CODE_083', '5'),
(1563, 'SYS', 'STATE_083', 'Hautes-Alpes'),
(1564, 'SYS', 'STATE_CODE_084', '65'),
(1565, 'SYS', 'STATE_084', 'Hautes-Pyre''ne''es'),
(1566, 'SYS', 'STATE_CODE_085', '92'),
(1567, 'SYS', 'STATE_085', 'Hauts-de-Seine'),
(1568, 'SYS', 'STATE_CODE_086', '34'),
(1569, 'SYS', 'STATE_086', 'He''rault'),
(1570, 'SYS', 'STATE_CODE_087', '35'),
(1571, 'SYS', 'STATE_087', 'Ille-et-Vilaine'),
(1572, 'SYS', 'STATE_CODE_088', '36'),
(1573, 'SYS', 'STATE_088', 'Indre'),
(1574, 'SYS', 'STATE_CODE_089', '37'),
(1575, 'SYS', 'STATE_089', 'Indre-et-Loire'),
(1576, 'SYS', 'STATE_CODE_090', '38'),
(1577, 'SYS', 'STATE_090', 'Ise`re'),
(1578, 'SYS', 'STATE_CODE_091', '39'),
(1579, 'SYS', 'STATE_091', 'Jura'),
(1580, 'SYS', 'STATE_CODE_092', '40'),
(1581, 'SYS', 'STATE_092', 'Landes'),
(1582, 'SYS', 'STATE_CODE_093', '41'),
(1583, 'SYS', 'STATE_093', 'Loir-et-Cher'),
(1584, 'SYS', 'STATE_CODE_094', '42');
INSERT INTO `[[dbprefix]]resource_labels` VALUES
(1585, 'SYS', 'STATE_094', 'Loire'),
(1586, 'SYS', 'STATE_CODE_095', '44'),
(1587, 'SYS', 'STATE_095', 'Loire-Atlantique'),
(1588, 'SYS', 'STATE_CODE_096', '45'),
(1589, 'SYS', 'STATE_096', 'Loiret'),
(1590, 'SYS', 'STATE_CODE_097', '46'),
(1591, 'SYS', 'STATE_097', 'Lot'),
(1592, 'SYS', 'STATE_CODE_098', '47'),
(1593, 'SYS', 'STATE_098', 'Lot-et-Garonne'),
(1594, 'SYS', 'STATE_CODE_099', '48'),
(1595, 'SYS', 'STATE_099', 'Loze`re'),
(1596, 'SYS', 'STATE_CODE_100', '49'),
(1597, 'SYS', 'STATE_100', 'Maine-et-Loire'),
(1598, 'SYS', 'STATE_CODE_101', '50'),
(1599, 'SYS', 'STATE_101', 'Manche'),
(1600, 'SYS', 'STATE_CODE_102', '51'),
(1601, 'SYS', 'STATE_102', 'Marne'),
(1602, 'SYS', 'STATE_CODE_103', '53'),
(1603, 'SYS', 'STATE_103', 'Mayenne'),
(1604, 'SYS', 'STATE_CODE_104', '54'),
(1605, 'SYS', 'STATE_104', 'Meurthe-et-Moselle'),
(1606, 'SYS', 'STATE_CODE_105', '56'),
(1607, 'SYS', 'STATE_105', 'Morbihan'),
(1608, 'SYS', 'STATE_CODE_106', '57'),
(1609, 'SYS', 'STATE_106', 'Moselle'),
(1610, 'SYS', 'STATE_CODE_107', '58'),
(1611, 'SYS', 'STATE_107', 'Nie`vre'),
(1612, 'SYS', 'STATE_CODE_108', '59'),
(1613, 'SYS', 'STATE_108', 'Nord'),
(1614, 'SYS', 'STATE_CODE_109', '60'),
(1615, 'SYS', 'STATE_109', 'Oise'),
(1616, 'SYS', 'STATE_CODE_110', '61'),
(1617, 'SYS', 'STATE_110', 'Orne'),
(1618, 'SYS', 'STATE_CODE_111', '75'),
(1619, 'SYS', 'STATE_111', 'Paris'),
(1620, 'SYS', 'STATE_CODE_112', '62'),
(1621, 'SYS', 'STATE_112', 'Pas-de-Calais'),
(1622, 'SYS', 'STATE_CODE_113', '63'),
(1623, 'SYS', 'STATE_113', 'Puy-de-Do^me'),
(1624, 'SYS', 'STATE_CODE_114', '64'),
(1625, 'SYS', 'STATE_114', 'Pyre''ne''ees-Atlantiques'),
(1626, 'SYS', 'STATE_CODE_115', '66'),
(1627, 'SYS', 'STATE_115', 'Pyre''ne''es-Orientales'),
(1628, 'SYS', 'STATE_CODE_116', '69'),
(1629, 'SYS', 'STATE_116', 'Rho^ne'),
(1630, 'SYS', 'STATE_CODE_117', '71'),
(1631, 'SYS', 'STATE_117', 'Sao^ne-et-Loire'),
(1632, 'SYS', 'STATE_CODE_118', '72'),
(1633, 'SYS', 'STATE_118', 'Sarthe'),
(1634, 'SYS', 'STATE_CODE_119', '73'),
(1635, 'SYS', 'STATE_119', 'Savoie'),
(1636, 'SYS', 'STATE_CODE_120', '77'),
(1637, 'SYS', 'STATE_120', 'Seine-et-Marne'),
(1638, 'SYS', 'STATE_CODE_121', '76'),
(1639, 'SYS', 'STATE_121', 'Seine-Maritime'),
(1640, 'SYS', 'STATE_CODE_122', '93'),
(1641, 'SYS', 'STATE_122', 'Seine-Saint-Denis'),
(1642, 'SYS', 'STATE_CODE_123', '80'),
(1643, 'SYS', 'STATE_123', 'Somme'),
(1644, 'SYS', 'STATE_CODE_124', '81'),
(1645, 'SYS', 'STATE_124', 'Tarn'),
(1646, 'SYS', 'STATE_CODE_125', '82'),
(1647, 'SYS', 'STATE_125', 'Tarn-et-Garonne'),
(1648, 'SYS', 'STATE_CODE_126', '90'),
(1649, 'SYS', 'STATE_126', 'Territoire-de-Belfort'),
(1650, 'SYS', 'STATE_CODE_127', '95'),
(1651, 'SYS', 'STATE_127', 'Val-d''Oise'),
(1652, 'SYS', 'STATE_CODE_128', '94'),
(1653, 'SYS', 'STATE_128', 'Val-de-Marne'),
(1654, 'SYS', 'STATE_CODE_129', '83'),
(1655, 'SYS', 'STATE_129', 'Var'),
(1656, 'SYS', 'STATE_CODE_130', '84'),
(1657, 'SYS', 'STATE_130', 'Vaucluse'),
(1658, 'SYS', 'STATE_CODE_131', '85'),
(1659, 'SYS', 'STATE_131', 'Vende''e'),
(1660, 'SYS', 'STATE_CODE_132', '86'),
(1661, 'SYS', 'STATE_132', 'Vienne'),
(1662, 'SYS', 'STATE_CODE_133', '88'),
(1663, 'SYS', 'STATE_133', 'Vosges'),
(1664, 'SYS', 'STATE_CODE_134', '89'),
(1665, 'SYS', 'STATE_134', 'Yonne'),
(1666, 'SYS', 'STATE_CODE_135', '78'),
(1667, 'SYS', 'STATE_135', 'Yvelines'),
(1668, 'SYS', 'STATE_CODE_136', 'BAD'),
(1669, 'SYS', 'STATE_136', 'Baden-Wurttemberg'),
(1670, 'SYS', 'STATE_CODE_137', 'BAY'),
(1671, 'SYS', 'STATE_137', 'Bayern'),
(1672, 'SYS', 'STATE_CODE_138', 'BER'),
(1673, 'SYS', 'STATE_138', 'Berlin'),
(1674, 'SYS', 'STATE_CODE_139', 'BRA'),
(1675, 'SYS', 'STATE_139', 'Brandenburg'),
(1676, 'SYS', 'STATE_CODE_140', 'BRE'),
(1677, 'SYS', 'STATE_140', 'Bremen'),
(1678, 'SYS', 'STATE_CODE_141', 'HAM'),
(1679, 'SYS', 'STATE_141', 'Hamburg'),
(1680, 'SYS', 'STATE_CODE_142', 'HES'),
(1681, 'SYS', 'STATE_142', 'Hessen'),
(1682, 'SYS', 'STATE_CODE_143', 'MEC'),
(1683, 'SYS', 'STATE_143', 'Mecklenburg-Vorpommern'),
(1684, 'SYS', 'STATE_CODE_144', 'NIE'),
(1685, 'SYS', 'STATE_144', 'Niedersachsen'),
(1686, 'SYS', 'STATE_CODE_145', 'NOR'),
(1687, 'SYS', 'STATE_145', 'Nordrhein-Westfalen'),
(1688, 'SYS', 'STATE_CODE_146', 'RHE'),
(1689, 'SYS', 'STATE_146', 'Rheinland-Pfalz'),
(1690, 'SYS', 'STATE_CODE_147', 'SAR'),
(1691, 'SYS', 'STATE_147', 'Saarland'),
(1692, 'SYS', 'STATE_CODE_148', 'SAC'),
(1693, 'SYS', 'STATE_148', 'Sachsen'),
(1694, 'SYS', 'STATE_CODE_149', 'SAA'),
(1695, 'SYS', 'STATE_149', 'Sachsen-Anhalt'),
(1696, 'SYS', 'STATE_CODE_150', 'SCH'),
(1697, 'SYS', 'STATE_150', 'Schleswig-Holstein'),
(1698, 'SYS', 'STATE_CODE_151', 'THU'),
(1699, 'SYS', 'STATE_151', 'Thuringen'),
(1700, 'SYS', 'STATE_CODE_152', 'ABR'),
(1701, 'SYS', 'STATE_152', 'Abruzzo'),
(1702, 'SYS', 'STATE_CODE_153', 'BAS'),
(1703, 'SYS', 'STATE_153', 'Basilicata'),
(1704, 'SYS', 'STATE_CODE_154', 'CAL'),
(1705, 'SYS', 'STATE_154', 'Calabria'),
(1706, 'SYS', 'STATE_CODE_155', 'CAM'),
(1707, 'SYS', 'STATE_155', 'Campania'),
(1708, 'SYS', 'STATE_CODE_156', 'EMI'),
(1709, 'SYS', 'STATE_156', 'Emilia-Romagna'),
(1710, 'SYS', 'STATE_CODE_157', 'FRI'),
(1711, 'SYS', 'STATE_157', 'Friuli-Venezia Giulia'),
(1712, 'SYS', 'STATE_CODE_158', 'LAZ'),
(1713, 'SYS', 'STATE_158', 'Lazio'),
(1714, 'SYS', 'STATE_CODE_159', 'LIG'),
(1715, 'SYS', 'STATE_159', 'Liguria'),
(1716, 'SYS', 'STATE_CODE_160', 'LOM'),
(1717, 'SYS', 'STATE_160', 'Lombardia'),
(1718, 'SYS', 'STATE_CODE_161', 'MAR'),
(1719, 'SYS', 'STATE_161', 'Marche'),
(1720, 'SYS', 'STATE_CODE_162', 'MOL'),
(1721, 'SYS', 'STATE_162', 'Molise'),
(1722, 'SYS', 'STATE_CODE_163', 'PIE'),
(1723, 'SYS', 'STATE_163', 'Piemonte'),
(1724, 'SYS', 'STATE_CODE_164', 'PUG'),
(1725, 'SYS', 'STATE_164', 'Puglia'),
(1726, 'SYS', 'STATE_CODE_165', 'SAR'),
(1727, 'SYS', 'STATE_165', 'Sardegna'),
(1728, 'SYS', 'STATE_CODE_166', 'SIC'),
(1729, 'SYS', 'STATE_166', 'Sicilia'),
(1730, 'SYS', 'STATE_CODE_167', 'TOS'),
(1731, 'SYS', 'STATE_167', 'Toscana'),
(1732, 'SYS', 'STATE_CODE_168', 'TRE'),
(1733, 'SYS', 'STATE_168', 'Trentino-Alto Adige'),
(1734, 'SYS', 'STATE_CODE_169', 'UMB'),
(1735, 'SYS', 'STATE_169', 'Umbria'),
(1736, 'SYS', 'STATE_CODE_170', 'VAL'),
(1737, 'SYS', 'STATE_170', 'Valle D''Aosta'),
(1738, 'SYS', 'STATE_CODE_171', 'VNT'),
(1739, 'SYS', 'STATE_171', 'Veneto'),
(1740, 'SYS', 'STATE_CODE_172', 'DIE'),
(1741, 'SYS', 'STATE_172', 'Diekirch'),
(1742, 'SYS', 'STATE_CODE_173', 'GRE'),
(1743, 'SYS', 'STATE_173', 'Grevenmacher'),
(1744, 'SYS', 'STATE_CODE_174', 'LUX'),
(1745, 'SYS', 'STATE_174', 'Luxembourg'),
(1746, 'SYS', 'STATE_CODE_175', 'DRE'),
(1747, 'SYS', 'STATE_175', 'Drenthe'),
(1748, 'SYS', 'STATE_CODE_176', 'FLE'),
(1749, 'SYS', 'STATE_176', 'Flevoland'),
(1750, 'SYS', 'STATE_CODE_177', 'FRI'),
(1751, 'SYS', 'STATE_177', 'Friesland'),
(1752, 'SYS', 'STATE_CODE_178', 'GEL'),
(1753, 'SYS', 'STATE_178', 'Gelderland'),
(1754, 'SYS', 'STATE_CODE_179', 'GRO'),
(1755, 'SYS', 'STATE_179', 'Groningen'),
(1756, 'SYS', 'STATE_CODE_180', 'LIM'),
(1757, 'SYS', 'STATE_180', 'Limburg'),
(1758, 'SYS', 'STATE_CODE_181', 'NBR'),
(1759, 'SYS', 'STATE_181', 'Noord-Brabant'),
(1760, 'SYS', 'STATE_CODE_182', 'NHO'),
(1761, 'SYS', 'STATE_182', 'Noord-Holland'),
(1762, 'SYS', 'STATE_CODE_183', 'OVE'),
(1763, 'SYS', 'STATE_183', 'Overijssel'),
(1764, 'SYS', 'STATE_CODE_184', 'UTR'),
(1765, 'SYS', 'STATE_184', 'Utrecht'),
(1766, 'SYS', 'STATE_CODE_185', 'ZEE'),
(1767, 'SYS', 'STATE_185', 'Zeeland'),
(1768, 'SYS', 'STATE_CODE_186', 'ZHO'),
(1769, 'SYS', 'STATE_186', 'Zuid-Holland'),
(1770, 'SYS', 'STATE_CODE_187', 'LC'),
(1771, 'SYS', 'STATE_187', 'A Corun~a'),
(1772, 'SYS', 'STATE_CODE_188', 'AL'),
(1773, 'SYS', 'STATE_188', 'Alava'),
(1774, 'SYS', 'STATE_CODE_189', 'AB'),
(1775, 'SYS', 'STATE_189', 'Albacete'),
(1776, 'SYS', 'STATE_CODE_190', 'AA'),
(1777, 'SYS', 'STATE_190', 'Alicante'),
(1778, 'SYS', 'STATE_CODE_191', 'AM'),
(1779, 'SYS', 'STATE_191', 'Almeria'),
(1780, 'SYS', 'STATE_CODE_192', 'AS'),
(1781, 'SYS', 'STATE_192', 'Asturias'),
(1782, 'SYS', 'STATE_CODE_193', 'AV'),
(1783, 'SYS', 'STATE_193', 'Avila'),
(1784, 'SYS', 'STATE_CODE_194', 'BA'),
(1785, 'SYS', 'STATE_194', 'Badajoz'),
(1786, 'SYS', 'STATE_CODE_195', 'BC'),
(1787, 'SYS', 'STATE_195', 'Barcelona'),
(1788, 'SYS', 'STATE_CODE_196', 'VI'),
(1789, 'SYS', 'STATE_196', 'Bizkaia'),
(1790, 'SYS', 'STATE_CODE_197', 'BU'),
(1791, 'SYS', 'STATE_197', 'Burgos'),
(1792, 'SYS', 'STATE_CODE_198', 'CC'),
(1793, 'SYS', 'STATE_198', 'Caceres'),
(1794, 'SYS', 'STATE_CODE_199', 'CD'),
(1795, 'SYS', 'STATE_199', 'Cadiz'),
(1796, 'SYS', 'STATE_CODE_200', 'CT'),
(1797, 'SYS', 'STATE_200', 'Cantabria'),
(1798, 'SYS', 'STATE_CODE_201', 'CS'),
(1799, 'SYS', 'STATE_201', 'Castellon'),
(1800, 'SYS', 'STATE_CODE_202', 'CE'),
(1801, 'SYS', 'STATE_202', 'Ceuta'),
(1802, 'SYS', 'STATE_CODE_203', 'CR'),
(1803, 'SYS', 'STATE_203', 'Ciudad Real'),
(1804, 'SYS', 'STATE_CODE_204', 'CO'),
(1805, 'SYS', 'STATE_204', 'Cordoba'),
(1806, 'SYS', 'STATE_CODE_205', 'CU'),
(1807, 'SYS', 'STATE_205', 'Cuenca'),
(1808, 'SYS', 'STATE_CODE_206', 'GI'),
(1809, 'SYS', 'STATE_206', 'Gerona'),
(1810, 'SYS', 'STATE_CODE_207', 'GP'),
(1811, 'SYS', 'STATE_207', 'Gipuzkoa'),
(1812, 'SYS', 'STATE_CODE_208', 'GR'),
(1813, 'SYS', 'STATE_208', 'Granada'),
(1814, 'SYS', 'STATE_CODE_209', 'GU'),
(1815, 'SYS', 'STATE_209', 'Guadalajara'),
(1816, 'SYS', 'STATE_CODE_210', 'HU'),
(1817, 'SYS', 'STATE_210', 'Huelva'),
(1818, 'SYS', 'STATE_CODE_211', 'HS'),
(1819, 'SYS', 'STATE_211', 'Huesca'),
(1820, 'SYS', 'STATE_CODE_212', 'IB'),
(1821, 'SYS', 'STATE_212', 'Illes Balears'),
(1822, 'SYS', 'STATE_CODE_213', 'JA'),
(1823, 'SYS', 'STATE_213', 'Jaen'),
(1824, 'SYS', 'STATE_CODE_214', 'LR'),
(1825, 'SYS', 'STATE_214', 'La Rioja'),
(1826, 'SYS', 'STATE_CODE_215', 'LP'),
(1827, 'SYS', 'STATE_215', 'Las Palmas'),
(1828, 'SYS', 'STATE_CODE_216', 'LE'),
(1829, 'SYS', 'STATE_216', 'Leon'),
(1830, 'SYS', 'STATE_CODE_217', 'LD'),
(1831, 'SYS', 'STATE_217', 'Lerida'),
(1832, 'SYS', 'STATE_CODE_218', 'LU'),
(1833, 'SYS', 'STATE_218', 'Lugo'),
(1834, 'SYS', 'STATE_CODE_219', 'MD'),
(1835, 'SYS', 'STATE_219', 'Madrid'),
(1836, 'SYS', 'STATE_CODE_220', 'MA'),
(1837, 'SYS', 'STATE_220', 'Malaga'),
(1838, 'SYS', 'STATE_CODE_221', 'ME'),
(1839, 'SYS', 'STATE_221', 'Melilla'),
(1840, 'SYS', 'STATE_CODE_222', 'MU'),
(1841, 'SYS', 'STATE_222', 'Murcia'),
(1842, 'SYS', 'STATE_CODE_223', 'NA'),
(1843, 'SYS', 'STATE_223', 'Navarra'),
(1844, 'SYS', 'STATE_CODE_224', 'OR'),
(1845, 'SYS', 'STATE_224', 'Ourense'),
(1846, 'SYS', 'STATE_CODE_225', 'PA'),
(1847, 'SYS', 'STATE_225', 'Palencia'),
(1848, 'SYS', 'STATE_CODE_226', 'PO'),
(1849, 'SYS', 'STATE_226', 'Pontevedra'),
(1850, 'SYS', 'STATE_CODE_227', 'SA'),
(1851, 'SYS', 'STATE_227', 'Salamanca'),
(1852, 'SYS', 'STATE_CODE_228', 'SG'),
(1853, 'SYS', 'STATE_228', 'Segovia'),
(1854, 'SYS', 'STATE_CODE_229', 'SE'),
(1855, 'SYS', 'STATE_229', 'Sevilla'),
(1856, 'SYS', 'STATE_CODE_230', 'SO'),
(1857, 'SYS', 'STATE_230', 'Soria'),
(1858, 'SYS', 'STATE_CODE_231', 'TA'),
(1859, 'SYS', 'STATE_231', 'Tarragona'),
(1860, 'SYS', 'STATE_CODE_232', 'TF'),
(1861, 'SYS', 'STATE_232', 'Tenerife'),
(1862, 'SYS', 'STATE_CODE_233', 'TE'),
(1863, 'SYS', 'STATE_233', 'Teruel'),
(1864, 'SYS', 'STATE_CODE_234', 'TO'),
(1865, 'SYS', 'STATE_234', 'Toledo'),
(1866, 'SYS', 'STATE_CODE_235', 'VC'),
(1867, 'SYS', 'STATE_235', 'Valencia'),
(1868, 'SYS', 'STATE_CODE_236', 'VD'),
(1869, 'SYS', 'STATE_236', 'Valladolid'),
(1870, 'SYS', 'STATE_CODE_237', 'ZM'),
(1871, 'SYS', 'STATE_237', 'Zamora'),
(1872, 'SYS', 'STATE_CODE_238', 'ZA'),
(1873, 'SYS', 'STATE_238', 'Zaragoza'),
(1874, 'SYS', 'STATE_CODE_239', 'ABd'),
(1875, 'SYS', 'STATE_239', 'Aberdeenshire'),
(1876, 'SYS', 'STATE_CODE_240', 'AGY'),
(1877, 'SYS', 'STATE_240', 'Anglesey'),
(1878, 'SYS', 'STATE_CODE_241', 'AG'),
(1879, 'SYS', 'STATE_241', 'Angus'),
(1880, 'SYS', 'STATE_CODE_242', 'ARg'),
(1881, 'SYS', 'STATE_242', 'Argyll'),
(1882, 'SYS', 'STATE_CODE_243', 'AV'),
(1883, 'SYS', 'STATE_243', 'Avon'),
(1884, 'SYS', 'STATE_CODE_244', 'AY'),
(1885, 'SYS', 'STATE_244', 'Ayrshire'),
(1886, 'SYS', 'STATE_CODE_245', 'BF'),
(1887, 'SYS', 'STATE_245', 'Banffshire'),
(1888, 'SYS', 'STATE_CODE_246', 'BE'),
(1889, 'SYS', 'STATE_246', 'Bedfordshire'),
(1890, 'SYS', 'STATE_CODE_247', 'BK'),
(1891, 'SYS', 'STATE_247', 'Berkshire'),
(1892, 'SYS', 'STATE_CODE_248', 'BEW'),
(1893, 'SYS', 'STATE_248', 'Berwickshire'),
(1894, 'SYS', 'STATE_CODE_249', 'BKM'),
(1895, 'SYS', 'STATE_249', 'Buckinghamshire'),
(1896, 'SYS', 'STATE_CODE_250', 'BU'),
(1897, 'SYS', 'STATE_250', 'Buckinhamshire'),
(1898, 'SYS', 'STATE_CODE_251', 'CN'),
(1899, 'SYS', 'STATE_251', 'Caithness'),
(1900, 'SYS', 'STATE_CODE_252', 'CB'),
(1901, 'SYS', 'STATE_252', 'Cambridgeshire'),
(1902, 'SYS', 'STATE_CODE_253', 'CGN'),
(1903, 'SYS', 'STATE_253', 'Cardiganshire'),
(1904, 'SYS', 'STATE_CODE_254', 'CMN'),
(1905, 'SYS', 'STATE_254', 'Carmarthenshire'),
(1906, 'SYS', 'STATE_CODE_255', 'CH'),
(1907, 'SYS', 'STATE_255', 'Cheshire'),
(1908, 'SYS', 'STATE_CODE_256', 'CL'),
(1909, 'SYS', 'STATE_256', 'Clackmannanshire'),
(1910, 'SYS', 'STATE_CODE_257', 'CV'),
(1911, 'SYS', 'STATE_257', 'Cleveland'),
(1912, 'SYS', 'STATE_CODE_258', 'CW'),
(1913, 'SYS', 'STATE_258', 'Clwyd'),
(1914, 'SYS', 'STATE_CODE_259', 'COr'),
(1915, 'SYS', 'STATE_259', 'Cornwall'),
(1916, 'SYS', 'STATE_CODE_260', 'CAn'),
(1917, 'SYS', 'STATE_260', 'County Antrim'),
(1918, 'SYS', 'STATE_CODE_261', 'CAr'),
(1919, 'SYS', 'STATE_261', 'County Armagh'),
(1920, 'SYS', 'STATE_CODE_262', 'CDo'),
(1921, 'SYS', 'STATE_262', 'County Down'),
(1922, 'SYS', 'STATE_CODE_263', 'CDu'),
(1923, 'SYS', 'STATE_263', 'County Durham'),
(1924, 'SYS', 'STATE_CODE_264', 'CFm'),
(1925, 'SYS', 'STATE_264', 'County Fermanagh'),
(1926, 'SYS', 'STATE_CODE_265', 'CLd'),
(1927, 'SYS', 'STATE_265', 'County Londonderry'),
(1928, 'SYS', 'STATE_CODE_266', 'CTy'),
(1929, 'SYS', 'STATE_266', 'County Tyrone'),
(1930, 'SYS', 'STATE_CODE_267', 'CUL'),
(1931, 'SYS', 'STATE_267', 'Cumberland'),
(1932, 'SYS', 'STATE_CODE_268', 'CU'),
(1933, 'SYS', 'STATE_268', 'Cumbria'),
(1934, 'SYS', 'STATE_CODE_269', 'DEN'),
(1935, 'SYS', 'STATE_269', 'Denbighshire'),
(1936, 'SYS', 'STATE_CODE_270', 'DB'),
(1937, 'SYS', 'STATE_270', 'Derbyshire'),
(1938, 'SYS', 'STATE_CODE_271', 'DV'),
(1939, 'SYS', 'STATE_271', 'Devon'),
(1940, 'SYS', 'STATE_CODE_272', 'DO'),
(1941, 'SYS', 'STATE_272', 'Dorset'),
(1942, 'SYS', 'STATE_CODE_273', 'DF'),
(1943, 'SYS', 'STATE_273', 'Dumfriesshire'),
(1944, 'SYS', 'STATE_CODE_274', 'DU'),
(1945, 'SYS', 'STATE_274', 'Dunbartonshire'),
(1946, 'SYS', 'STATE_CODE_275', 'DY'),
(1947, 'SYS', 'STATE_275', 'Dyfed'),
(1948, 'SYS', 'STATE_CODE_276', 'EL'),
(1949, 'SYS', 'STATE_276', 'East Lothian'),
(1950, 'SYS', 'STATE_CODE_277', 'ES'),
(1951, 'SYS', 'STATE_277', 'East Sussex'),
(1952, 'SYS', 'STATE_CODE_278', 'EX'),
(1953, 'SYS', 'STATE_278', 'Essex'),
(1954, 'SYS', 'STATE_CODE_279', 'FI'),
(1955, 'SYS', 'STATE_279', 'Fife'),
(1956, 'SYS', 'STATE_CODE_280', 'FLN'),
(1957, 'SYS', 'STATE_280', 'Flintshire'),
(1958, 'SYS', 'STATE_CODE_281', 'GLA'),
(1959, 'SYS', 'STATE_281', 'Glamorgan'),
(1960, 'SYS', 'STATE_CODE_282', 'GL'),
(1961, 'SYS', 'STATE_282', 'Gloucestershire'),
(1962, 'SYS', 'STATE_CODE_283', 'GW'),
(1963, 'SYS', 'STATE_283', 'Gwent'),
(1964, 'SYS', 'STATE_CODE_284', 'GY'),
(1965, 'SYS', 'STATE_284', 'Gwynedd'),
(1966, 'SYS', 'STATE_CODE_285', 'HA'),
(1967, 'SYS', 'STATE_285', 'Hampshire'),
(1968, 'SYS', 'STATE_CODE_286', 'HE'),
(1969, 'SYS', 'STATE_286', 'Herefordshire'),
(1970, 'SYS', 'STATE_CODE_287', 'HF'),
(1971, 'SYS', 'STATE_287', 'Hertfordshire'),
(1972, 'SYS', 'STATE_CODE_288', 'HUN'),
(1973, 'SYS', 'STATE_288', 'Huntingdonshire'),
(1974, 'SYS', 'STATE_CODE_289', 'IS'),
(1975, 'SYS', 'STATE_289', 'Inverness-shire'),
(1976, 'SYS', 'STATE_CODE_290', 'IsAr'),
(1977, 'SYS', 'STATE_290', 'Isle of Arran'),
(1978, 'SYS', 'STATE_CODE_291', 'IsBa'),
(1979, 'SYS', 'STATE_291', 'Isle of Barra'),
(1980, 'SYS', 'STATE_CODE_292', 'IsBe'),
(1981, 'SYS', 'STATE_292', 'Isle of Benbecula'),
(1982, 'SYS', 'STATE_CODE_293', 'IsBu'),
(1983, 'SYS', 'STATE_293', 'Isle of Bute'),
(1984, 'SYS', 'STATE_CODE_294', 'IsCa'),
(1985, 'SYS', 'STATE_294', 'Isle of Canna'),
(1986, 'SYS', 'STATE_CODE_295', 'IsCo'),
(1987, 'SYS', 'STATE_295', 'Isle of Coll'),
(1988, 'SYS', 'STATE_CODE_296', 'IsCl'),
(1989, 'SYS', 'STATE_296', 'Isle of Colonsay'),
(1990, 'SYS', 'STATE_CODE_297', 'IsCu'),
(1991, 'SYS', 'STATE_297', 'Isle of Cumbrae'),
(1992, 'SYS', 'STATE_CODE_298', 'IsEg'),
(1993, 'SYS', 'STATE_298', 'Isle of Eigg'),
(1994, 'SYS', 'STATE_CODE_299', 'IsGi'),
(1995, 'SYS', 'STATE_299', 'Isle of Gigha'),
(1996, 'SYS', 'STATE_CODE_300', 'IsHa'),
(1997, 'SYS', 'STATE_300', 'Isle of Harris'),
(1998, 'SYS', 'STATE_CODE_301', 'IsIo'),
(1999, 'SYS', 'STATE_301', 'Isle of Iona'),
(2000, 'SYS', 'STATE_CODE_302', 'IsJu'),
(2001, 'SYS', 'STATE_302', 'Isle of Jura'),
(2002, 'SYS', 'STATE_CODE_303', 'IsLw'),
(2003, 'SYS', 'STATE_303', 'Isle of Lewis'),
(2004, 'SYS', 'STATE_CODE_304', 'IsMu'),
(2005, 'SYS', 'STATE_304', 'Isle of Mull'),
(2006, 'SYS', 'STATE_CODE_305', 'IsNu'),
(2007, 'SYS', 'STATE_305', 'Isle of North Uist'),
(2008, 'SYS', 'STATE_CODE_306', 'IsRu'),
(2009, 'SYS', 'STATE_306', 'Isle of Rhum'),
(2010, 'SYS', 'STATE_CODE_307', 'IsSc'),
(2011, 'SYS', 'STATE_307', 'Isle of Scalpay'),
(2012, 'SYS', 'STATE_CODE_308', 'IsSh'),
(2013, 'SYS', 'STATE_308', 'Isle of Shetland'),
(2014, 'SYS', 'STATE_CODE_309', 'IsSk'),
(2015, 'SYS', 'STATE_309', 'Isle of Skye'),
(2016, 'SYS', 'STATE_CODE_310', 'IsSu'),
(2017, 'SYS', 'STATE_310', 'Isle of South Uist'),
(2018, 'SYS', 'STATE_CODE_311', 'IsTi'),
(2019, 'SYS', 'STATE_311', 'Isle of Tiree'),
(2020, 'SYS', 'STATE_CODE_312', 'IsWi'),
(2021, 'SYS', 'STATE_312', 'Isle of Wight'),
(2022, 'SYS', 'STATE_CODE_313', 'IsScl'),
(2023, 'SYS', 'STATE_313', 'Isles of Scilly'),
(2024, 'SYS', 'STATE_CODE_314', 'KEN'),
(2025, 'SYS', 'STATE_314', 'Kent'),
(2026, 'SYS', 'STATE_CODE_315', 'KCD'),
(2027, 'SYS', 'STATE_315', 'Kincardineshire'),
(2028, 'SYS', 'STATE_CODE_316', 'KRS'),
(2029, 'SYS', 'STATE_316', 'Kinross-shire'),
(2030, 'SYS', 'STATE_CODE_317', 'KKD'),
(2031, 'SYS', 'STATE_317', 'Kirkcudbrightshire'),
(2032, 'SYS', 'STATE_CODE_318', 'LKS'),
(2033, 'SYS', 'STATE_318', 'Lanarkshire'),
(2034, 'SYS', 'STATE_CODE_319', 'LAN'),
(2035, 'SYS', 'STATE_319', 'Lancashire'),
(2036, 'SYS', 'STATE_CODE_320', 'LEI'),
(2037, 'SYS', 'STATE_320', 'Leicestershire'),
(2038, 'SYS', 'STATE_CODE_321', 'LIN'),
(2039, 'SYS', 'STATE_321', 'Lincolnshire'),
(2040, 'SYS', 'STATE_CODE_322', 'LO'),
(2041, 'SYS', 'STATE_322', 'London'),
(2042, 'SYS', 'STATE_CODE_323', 'MER'),
(2043, 'SYS', 'STATE_323', 'Merseyside'),
(2044, 'SYS', 'STATE_CODE_324', 'MG'),
(2045, 'SYS', 'STATE_324', 'Mid Glamorgan'),
(2046, 'SYS', 'STATE_CODE_325', 'MX'),
(2047, 'SYS', 'STATE_325', 'Middlesex'),
(2048, 'SYS', 'STATE_CODE_326', 'Mdl'),
(2049, 'SYS', 'STATE_326', 'Midlothian'),
(2050, 'SYS', 'STATE_CODE_327', 'MON'),
(2051, 'SYS', 'STATE_327', 'Monmouthshire'),
(2052, 'SYS', 'STATE_CODE_328', 'MGY'),
(2053, 'SYS', 'STATE_328', 'Montgomeryshire'),
(2054, 'SYS', 'STATE_CODE_329', 'MOR'),
(2055, 'SYS', 'STATE_329', 'Morayshire'),
(2056, 'SYS', 'STATE_CODE_330', 'NA'),
(2057, 'SYS', 'STATE_330', 'Nairnshire'),
(2058, 'SYS', 'STATE_CODE_331', 'NO'),
(2059, 'SYS', 'STATE_331', 'Norfolk'),
(2060, 'SYS', 'STATE_CODE_332', 'NHB'),
(2061, 'SYS', 'STATE_332', 'North Humberside'),
(2062, 'SYS', 'STATE_CODE_333', 'NYK'),
(2063, 'SYS', 'STATE_333', 'North Yorkshire'),
(2064, 'SYS', 'STATE_CODE_334', 'NTH'),
(2065, 'SYS', 'STATE_334', 'Northamptonshire'),
(2066, 'SYS', 'STATE_CODE_335', 'NU'),
(2067, 'SYS', 'STATE_335', 'Northumberland'),
(2068, 'SYS', 'STATE_CODE_336', 'NTT'),
(2069, 'SYS', 'STATE_336', 'Nottinghamshire'),
(2070, 'SYS', 'STATE_CODE_337', 'OKI'),
(2071, 'SYS', 'STATE_337', 'Orkney'),
(2072, 'SYS', 'STATE_CODE_338', 'OX'),
(2073, 'SYS', 'STATE_338', 'Oxfordshire'),
(2074, 'SYS', 'STATE_CODE_339', 'PEE'),
(2075, 'SYS', 'STATE_339', 'Peebles-shire'),
(2076, 'SYS', 'STATE_CODE_340', 'PEM'),
(2077, 'SYS', 'STATE_340', 'Pembrokeshire'),
(2078, 'SYS', 'STATE_CODE_341', 'PER'),
(2079, 'SYS', 'STATE_341', 'Perth'),
(2080, 'SYS', 'STATE_CODE_342', 'PO'),
(2081, 'SYS', 'STATE_342', 'Powys'),
(2082, 'SYS', 'STATE_CODE_343', 'RAD'),
(2083, 'SYS', 'STATE_343', 'Radnorshire'),
(2084, 'SYS', 'STATE_CODE_344', 'Rn'),
(2085, 'SYS', 'STATE_344', 'Renfrewshire'),
(2086, 'SYS', 'STATE_CODE_345', 'ROC'),
(2087, 'SYS', 'STATE_345', 'Ross and Cromarty'),
(2088, 'SYS', 'STATE_CODE_346', 'ROX'),
(2089, 'SYS', 'STATE_346', 'Roxburghshire'),
(2090, 'SYS', 'STATE_CODE_347', 'RUT'),
(2091, 'SYS', 'STATE_347', 'Rutland'),
(2092, 'SYS', 'STATE_CODE_348', 'SEL'),
(2093, 'SYS', 'STATE_348', 'Selkirkshire'),
(2094, 'SYS', 'STATE_CODE_349', 'SHI'),
(2095, 'SYS', 'STATE_349', 'Shetland'),
(2096, 'SYS', 'STATE_CODE_350', 'SR'),
(2097, 'SYS', 'STATE_350', 'Shropshire'),
(2098, 'SYS', 'STATE_CODE_351', 'SO'),
(2099, 'SYS', 'STATE_351', 'Somerset'),
(2100, 'SYS', 'STATE_CODE_352', 'SG'),
(2101, 'SYS', 'STATE_352', 'South Glamorgan'),
(2102, 'SYS', 'STATE_CODE_353', 'SH'),
(2103, 'SYS', 'STATE_353', 'South Humberside'),
(2104, 'SYS', 'STATE_CODE_354', 'SYK'),
(2105, 'SYS', 'STATE_354', 'South Yorkshire'),
(2106, 'SYS', 'STATE_CODE_355', 'ST'),
(2107, 'SYS', 'STATE_355', 'Staffordshire'),
(2108, 'SYS', 'STATE_CODE_356', 'STI'),
(2109, 'SYS', 'STATE_356', 'Stirlingshire'),
(2110, 'SYS', 'STATE_CODE_357', 'SF'),
(2111, 'SYS', 'STATE_357', 'Suffolk'),
(2112, 'SYS', 'STATE_CODE_358', 'SY'),
(2113, 'SYS', 'STATE_358', 'Surrey'),
(2114, 'SYS', 'STATE_CODE_359', 'SU'),
(2115, 'SYS', 'STATE_359', 'Sussex'),
(2116, 'SYS', 'STATE_CODE_360', 'SUT'),
(2117, 'SYS', 'STATE_360', 'Sutherland'),
(2118, 'SYS', 'STATE_CODE_361', 'TW'),
(2119, 'SYS', 'STATE_361', 'Tyne and Wear'),
(2120, 'SYS', 'STATE_CODE_362', 'WAR'),
(2121, 'SYS', 'STATE_362', 'Warwickshire'),
(2122, 'SYS', 'STATE_CODE_363', 'WG'),
(2123, 'SYS', 'STATE_363', 'West Glamorgan'),
(2124, 'SYS', 'STATE_CODE_364', 'WLN'),
(2125, 'SYS', 'STATE_364', 'West Lothian'),
(2126, 'SYS', 'STATE_CODE_365', 'WM'),
(2127, 'SYS', 'STATE_365', 'West Midlands'),
(2128, 'SYS', 'STATE_CODE_366', 'WS'),
(2129, 'SYS', 'STATE_366', 'West Sussex'),
(2130, 'SYS', 'STATE_CODE_367', 'WYK'),
(2131, 'SYS', 'STATE_367', 'West Yorkshire'),
(2132, 'SYS', 'STATE_CODE_368', 'WES'),
(2133, 'SYS', 'STATE_368', 'Westmorland'),
(2134, 'SYS', 'STATE_CODE_369', 'WIG'),
(2135, 'SYS', 'STATE_369', 'Wigtownshire'),
(2136, 'SYS', 'STATE_CODE_370', 'WIt'),
(2137, 'SYS', 'STATE_370', 'Wiltshire'),
(2138, 'SYS', 'STATE_CODE_371', 'WO'),
(2139, 'SYS', 'STATE_371', 'Worcestershire'),
(2140, 'SYS', 'STATE_CODE_372', 'YKS'),
(2141, 'SYS', 'STATE_372', 'Yorkshire'),
(2142, 'SYS', 'STATE_CODE_373', 'AL'),
(2143, 'SYS', 'STATE_373', 'Alabama'),
(2144, 'SYS', 'STATE_CODE_374', 'AK'),
(2145, 'SYS', 'STATE_374', 'Alaska'),
(2146, 'SYS', 'STATE_CODE_375', 'AZ'),
(2147, 'SYS', 'STATE_375', 'Arizona'),
(2148, 'SYS', 'STATE_CODE_376', 'AR'),
(2149, 'SYS', 'STATE_376', 'Arkansas'),
(2150, 'SYS', 'STATE_CODE_377', 'CA'),
(2151, 'SYS', 'STATE_377', 'California'),
(2152, 'SYS', 'STATE_CODE_378', 'CO'),
(2153, 'SYS', 'STATE_378', 'Colorado'),
(2154, 'SYS', 'STATE_CODE_379', 'CT'),
(2155, 'SYS', 'STATE_379', 'Connecticut'),
(2156, 'SYS', 'STATE_CODE_380', 'DE'),
(2157, 'SYS', 'STATE_380', 'Delaware'),
(2158, 'SYS', 'STATE_CODE_381', 'DC'),
(2159, 'SYS', 'STATE_381', 'District of Columbia'),
(2160, 'SYS', 'STATE_CODE_382', 'FL'),
(2161, 'SYS', 'STATE_382', 'Florida'),
(2162, 'SYS', 'STATE_CODE_383', 'GA'),
(2163, 'SYS', 'STATE_383', 'Georgia'),
(2164, 'SYS', 'STATE_CODE_384', 'GU'),
(2165, 'SYS', 'STATE_384', 'Guam'),
(2166, 'SYS', 'STATE_CODE_385', 'HI'),
(2167, 'SYS', 'STATE_385', 'Hawaii'),
(2168, 'SYS', 'STATE_CODE_386', 'ID'),
(2169, 'SYS', 'STATE_386', 'Idaho'),
(2170, 'SYS', 'STATE_CODE_387', 'IL'),
(2171, 'SYS', 'STATE_387', 'Illinois'),
(2172, 'SYS', 'STATE_CODE_388', 'IN'),
(2173, 'SYS', 'STATE_388', 'Indiana'),
(2174, 'SYS', 'STATE_CODE_389', 'IA'),
(2175, 'SYS', 'STATE_389', 'Iowa'),
(2176, 'SYS', 'STATE_CODE_390', 'KS'),
(2177, 'SYS', 'STATE_390', 'Kansas'),
(2178, 'SYS', 'STATE_CODE_391', 'KY'),
(2179, 'SYS', 'STATE_391', 'Kentucky'),
(2180, 'SYS', 'STATE_CODE_392', 'LA'),
(2181, 'SYS', 'STATE_392', 'Louisiana'),
(2182, 'SYS', 'STATE_CODE_393', 'ME'),
(2183, 'SYS', 'STATE_393', 'Maine'),
(2184, 'SYS', 'STATE_CODE_394', 'MD'),
(2185, 'SYS', 'STATE_394', 'Maryland'),
(2186, 'SYS', 'STATE_CODE_395', 'MA'),
(2187, 'SYS', 'STATE_395', 'Massachusetts'),
(2188, 'SYS', 'STATE_CODE_396', 'MI'),
(2189, 'SYS', 'STATE_396', 'Michigan'),
(2190, 'SYS', 'STATE_CODE_397', 'MN'),
(2191, 'SYS', 'STATE_397', 'Minnesota'),
(2192, 'SYS', 'STATE_CODE_398', 'MS'),
(2193, 'SYS', 'STATE_398', 'Mississippi'),
(2194, 'SYS', 'STATE_CODE_399', 'MO'),
(2195, 'SYS', 'STATE_399', 'Missouri'),
(2196, 'SYS', 'STATE_CODE_400', 'MT'),
(2197, 'SYS', 'STATE_400', 'Montana'),
(2198, 'SYS', 'STATE_CODE_401', 'NE'),
(2199, 'SYS', 'STATE_401', 'Nebraska'),
(2200, 'SYS', 'STATE_CODE_402', 'NV'),
(2201, 'SYS', 'STATE_402', 'Nevada'),
(2202, 'SYS', 'STATE_CODE_403', 'NH'),
(2203, 'SYS', 'STATE_403', 'New Hampshire'),
(2204, 'SYS', 'STATE_CODE_404', 'NJ'),
(2205, 'SYS', 'STATE_404', 'New Jersey'),
(2206, 'SYS', 'STATE_CODE_405', 'NM'),
(2207, 'SYS', 'STATE_405', 'New Mexico'),
(2208, 'SYS', 'STATE_CODE_406', 'NY'),
(2209, 'SYS', 'STATE_406', 'New York'),
(2210, 'SYS', 'STATE_CODE_407', 'NC'),
(2211, 'SYS', 'STATE_407', 'North Carolina'),
(2212, 'SYS', 'STATE_CODE_408', 'ND'),
(2213, 'SYS', 'STATE_408', 'North Dakota'),
(2214, 'SYS', 'STATE_CODE_409', 'OH'),
(2215, 'SYS', 'STATE_409', 'Ohio'),
(2216, 'SYS', 'STATE_CODE_410', 'OK'),
(2217, 'SYS', 'STATE_410', 'Oklahoma'),
(2218, 'SYS', 'STATE_CODE_411', 'OR'),
(2219, 'SYS', 'STATE_411', 'Oregon'),
(2220, 'SYS', 'STATE_CODE_412', 'PA'),
(2221, 'SYS', 'STATE_412', 'Pennsylvania'),
(2222, 'SYS', 'STATE_CODE_413', 'PR'),
(2223, 'SYS', 'STATE_413', 'Puerto Rico'),
(2224, 'SYS', 'STATE_CODE_414', 'RI'),
(2225, 'SYS', 'STATE_414', 'Rhode Island'),
(2226, 'SYS', 'STATE_CODE_415', 'SC'),
(2227, 'SYS', 'STATE_415', 'South Carolina'),
(2228, 'SYS', 'STATE_CODE_416', 'SD'),
(2229, 'SYS', 'STATE_416', 'South Dakota'),
(2230, 'SYS', 'STATE_CODE_417', 'TN'),
(2231, 'SYS', 'STATE_417', 'Tennessee'),
(2232, 'SYS', 'STATE_CODE_418', 'TX'),
(2233, 'SYS', 'STATE_418', 'Texas'),
(2234, 'SYS', 'STATE_CODE_419', 'UT'),
(2235, 'SYS', 'STATE_419', 'Utah'),
(2236, 'SYS', 'STATE_CODE_420', 'VT'),
(2237, 'SYS', 'STATE_420', 'Vermont'),
(2238, 'SYS', 'STATE_CODE_421', 'VI'),
(2239, 'SYS', 'STATE_421', 'Virgin Islands'),
(2240, 'SYS', 'STATE_CODE_422', 'VA'),
(2241, 'SYS', 'STATE_422', 'Virginia'),
(2242, 'SYS', 'STATE_CODE_423', 'WA'),
(2243, 'SYS', 'STATE_423', 'Washington'),
(2244, 'SYS', 'STATE_CODE_424', 'WV'),
(2245, 'SYS', 'STATE_424', 'West Virginia'),
(2246, 'SYS', 'STATE_CODE_425', 'WI'),
(2247, 'SYS', 'STATE_425', 'Wisconsin'),
(2248, 'SYS', 'STATE_CODE_426', 'WY'),
(2249, 'SYS', 'STATE_426', 'Wyoming'),
(2250, 'SYS', 'STATE_CODE_427', 'CW'),
(2251, 'SYS', 'STATE_427', 'Carlow'),
(2252, 'SYS', 'STATE_CODE_428', 'CN'),
(2253, 'SYS', 'STATE_428', 'Cavan'),
(2254, 'SYS', 'STATE_CODE_429', 'CE'),
(2255, 'SYS', 'STATE_429', 'Clare'),
(2256, 'SYS', 'STATE_CODE_430', 'C'),
(2257, 'SYS', 'STATE_430', 'Cork'),
(2258, 'SYS', 'STATE_CODE_431', 'DL'),
(2259, 'SYS', 'STATE_431', 'Donegal'),
(2260, 'SYS', 'STATE_CODE_432', 'D'),
(2261, 'SYS', 'STATE_432', 'Dublin'),
(2262, 'SYS', 'STATE_CODE_433', 'G'),
(2263, 'SYS', 'STATE_433', 'Galway'),
(2264, 'SYS', 'STATE_CODE_434', 'KY'),
(2265, 'SYS', 'STATE_434', 'Kerry'),
(2266, 'SYS', 'STATE_CODE_435', 'KE'),
(2267, 'SYS', 'STATE_435', 'Kildare'),
(2268, 'SYS', 'STATE_CODE_436', 'KK'),
(2269, 'SYS', 'STATE_436', 'Kilkenny'),
(2270, 'SYS', 'STATE_CODE_437', 'LS'),
(2271, 'SYS', 'STATE_437', 'Laois'),
(2272, 'SYS', 'STATE_CODE_438', 'LM'),
(2273, 'SYS', 'STATE_438', 'Leitrim'),
(2274, 'SYS', 'STATE_CODE_439', 'LK'),
(2275, 'SYS', 'STATE_439', 'Limerick'),
(2276, 'SYS', 'STATE_CODE_440', 'LD'),
(2277, 'SYS', 'STATE_440', 'Longford'),
(2278, 'SYS', 'STATE_CODE_441', 'LH'),
(2279, 'SYS', 'STATE_441', 'Louth'),
(2280, 'SYS', 'STATE_CODE_442', 'MO'),
(2281, 'SYS', 'STATE_442', 'Mayo'),
(2282, 'SYS', 'STATE_CODE_443', 'MH'),
(2283, 'SYS', 'STATE_443', 'Meath'),
(2284, 'SYS', 'STATE_CODE_444', 'MN'),
(2285, 'SYS', 'STATE_444', 'Monaghan'),
(2286, 'SYS', 'STATE_CODE_445', 'OY'),
(2287, 'SYS', 'STATE_445', 'Offaly'),
(2288, 'SYS', 'STATE_CODE_446', 'RN'),
(2289, 'SYS', 'STATE_446', 'Roscommon'),
(2290, 'SYS', 'STATE_CODE_447', 'SO'),
(2291, 'SYS', 'STATE_447', 'Sligo'),
(2292, 'SYS', 'STATE_CODE_448', 'T'),
(2293, 'SYS', 'STATE_448', 'Tipperary'),
(2294, 'SYS', 'STATE_CODE_449', 'WD'),
(2295, 'SYS', 'STATE_449', 'Waterford'),
(2296, 'SYS', 'STATE_CODE_450', 'WH'),
(2297, 'SYS', 'STATE_450', 'Westmeath'),
(2298, 'SYS', 'STATE_CODE_451', 'WX'),
(2299, 'SYS', 'STATE_451', 'Wexford'),
(2300, 'SYS', 'STATE_CODE_452', 'WW'),
(2301, 'SYS', 'STATE_452', 'Wicklow'),
(2302, 'SYS', 'STATE_CODE_453', '1'),
(2303, 'SYS', 'STATE_453', 'Aveiro'),
(2304, 'SYS', 'STATE_CODE_454', '2'),
(2305, 'SYS', 'STATE_454', 'Beja'),
(2306, 'SYS', 'STATE_CODE_455', '3'),
(2307, 'SYS', 'STATE_455', 'Braga'),
(2308, 'SYS', 'STATE_CODE_456', '4'),
(2309, 'SYS', 'STATE_456', 'Braganc,a'),
(2310, 'SYS', 'STATE_CODE_457', '5'),
(2311, 'SYS', 'STATE_457', 'Castelo Branco'),
(2312, 'SYS', 'STATE_CODE_458', '6'),
(2313, 'SYS', 'STATE_458', 'Coimbra'),
(2314, 'SYS', 'STATE_CODE_459', '7'),
(2315, 'SYS', 'STATE_459', 'E''vora'),
(2316, 'SYS', 'STATE_CODE_460', '8'),
(2317, 'SYS', 'STATE_460', 'Faro'),
(2318, 'SYS', 'STATE_CODE_461', '9'),
(2319, 'SYS', 'STATE_461', 'Guarda'),
(2320, 'SYS', 'STATE_CODE_462', '10'),
(2321, 'SYS', 'STATE_462', 'Leiria'),
(2322, 'SYS', 'STATE_CODE_463', '11'),
(2323, 'SYS', 'STATE_463', 'Lisboa'),
(2324, 'SYS', 'STATE_CODE_464', '12'),
(2325, 'SYS', 'STATE_464', 'Portalegre'),
(2326, 'SYS', 'STATE_CODE_465', '13'),
(2327, 'SYS', 'STATE_465', 'Porto'),
(2328, 'SYS', 'STATE_CODE_466', '14'),
(2329, 'SYS', 'STATE_466', 'Santare''m'),
(2330, 'SYS', 'STATE_CODE_467', '15'),
(2331, 'SYS', 'STATE_467', 'Setu''bal'),
(2332, 'SYS', 'STATE_CODE_468', '16'),
(2333, 'SYS', 'STATE_468', 'Viana do Castelo'),
(2334, 'SYS', 'STATE_CODE_469', '17'),
(2335, 'SYS', 'STATE_469', 'Vila Real'),
(2336, 'SYS', 'STATE_CODE_470', '18'),
(2337, 'SYS', 'STATE_470', 'Viseu'),
(2338, 'SYS', 'STATE_CODE_471', '31'),
(2339, 'SYS', 'STATE_471', 'Ilha da Madeira'),
(2340, 'SYS', 'STATE_CODE_472', '32'),
(2341, 'SYS', 'STATE_472', 'Ilha de Porto Santo'),
(2342, 'SYS', 'STATE_CODE_473', '41'),
(2343, 'SYS', 'STATE_473', 'Ilha de Santa Maria'),
(2344, 'SYS', 'STATE_CODE_474', '42'),
(2345, 'SYS', 'STATE_474', 'Ilha de Sa~o Miguel'),
(2346, 'SYS', 'STATE_CODE_475', '43'),
(2347, 'SYS', 'STATE_475', 'Ilha Terceira'),
(2348, 'SYS', 'STATE_CODE_476', '44'),
(2349, 'SYS', 'STATE_476', 'Ilha da Graciosa'),
(2350, 'SYS', 'STATE_CODE_477', '45'),
(2351, 'SYS', 'STATE_477', 'Ilha de Sa~o Jorge'),
(2352, 'SYS', 'STATE_CODE_478', '46'),
(2353, 'SYS', 'STATE_478', 'Ilha do Pico'),
(2354, 'SYS', 'STATE_CODE_479', '47'),
(2355, 'SYS', 'STATE_479', 'Ilha do Faial'),
(2356, 'SYS', 'STATE_CODE_480', '48'),
(2357, 'SYS', 'STATE_480', 'Ilha das Flores'),
(2358, 'SYS', 'STATE_CODE_481', '49'),
(2359, 'SYS', 'STATE_481', 'Ilha do Corvo'),
(2360, 'SYS', 'STATE_CODE_482', 'NTL'),
(2361, 'SYS', 'STATE_482', 'Northland'),
(2362, 'SYS', 'STATE_CODE_483', 'AUK'),
(2363, 'SYS', 'STATE_483', 'Auckland'),
(2364, 'SYS', 'STATE_CODE_484', 'WKO'),
(2365, 'SYS', 'STATE_484', 'Waikato'),
(2366, 'SYS', 'STATE_CODE_485', 'BOP'),
(2367, 'SYS', 'STATE_485', 'Bay of Plenty'),
(2368, 'SYS', 'STATE_CODE_486', 'GIS'),
(2369, 'SYS', 'STATE_486', 'East Cape'),
(2370, 'SYS', 'STATE_CODE_487', 'HKB'),
(2371, 'SYS', 'STATE_487', 'Hawke''s Bay'),
(2372, 'SYS', 'STATE_CODE_488', 'TKI'),
(2373, 'SYS', 'STATE_488', 'Taranaki'),
(2374, 'SYS', 'STATE_CODE_489', 'MWT'),
(2375, 'SYS', 'STATE_489', 'Manawatu-Wanganui'),
(2376, 'SYS', 'STATE_CODE_490', 'WGN'),
(2377, 'SYS', 'STATE_490', 'Wellington'),
(2378, 'SYS', 'STATE_CODE_491', 'TAS'),
(2379, 'SYS', 'STATE_491', 'Tasman'),
(2380, 'SYS', 'STATE_CODE_492', 'NSN'),
(2381, 'SYS', 'STATE_492', 'Nelson'),
(2382, 'SYS', 'STATE_CODE_493', 'MBH'),
(2383, 'SYS', 'STATE_493', 'Marlborough'),
(2384, 'SYS', 'STATE_CODE_494', 'WTC'),
(2385, 'SYS', 'STATE_494', 'West Coast'),
(2386, 'SYS', 'STATE_CODE_495', 'CAN'),
(2387, 'SYS', 'STATE_495', 'Canterbury'),
(2388, 'SYS', 'STATE_CODE_496', 'OTA'),
(2389, 'SYS', 'STATE_496', 'Otago'),
(2390, 'SYS', 'STATE_CODE_497', 'STL'),
(2391, 'SYS', 'STATE_497', 'Southland'),
(2392, 'SYS', 'STATE_CODE_498', 'Ags'),
(2393, 'SYS', 'STATE_498', 'Aguascalientes'),
(2394, 'SYS', 'STATE_CODE_499', 'BC'),
(2395, 'SYS', 'STATE_499', 'Baja California'),
(2396, 'SYS', 'STATE_CODE_500', 'BCS'),
(2397, 'SYS', 'STATE_500', 'Baja California Sur'),
(2398, 'SYS', 'STATE_CODE_501', 'Camp'),
(2399, 'SYS', 'STATE_501', 'Campeche'),
(2400, 'SYS', 'STATE_CODE_502', 'Chis'),
(2401, 'SYS', 'STATE_502', 'Chiapas'),
(2402, 'SYS', 'STATE_CODE_503', 'Chih'),
(2403, 'SYS', 'STATE_503', 'Chihuahua'),
(2404, 'SYS', 'STATE_CODE_504', 'Coah'),
(2405, 'SYS', 'STATE_504', 'Coahuila'),
(2406, 'SYS', 'STATE_CODE_505', 'Col'),
(2407, 'SYS', 'STATE_505', 'Colima'),
(2408, 'SYS', 'STATE_CODE_506', 'DF'),
(2409, 'SYS', 'STATE_506', 'Distrito Federal'),
(2410, 'SYS', 'STATE_CODE_507', 'Dgo'),
(2411, 'SYS', 'STATE_507', 'Durango'),
(2412, 'SYS', 'STATE_CODE_508', 'Gto'),
(2413, 'SYS', 'STATE_508', 'Guanajuato'),
(2414, 'SYS', 'STATE_CODE_509', 'Gro'),
(2415, 'SYS', 'STATE_509', 'Guerrero'),
(2416, 'SYS', 'STATE_CODE_510', 'Hgo'),
(2417, 'SYS', 'STATE_510', 'Hidalgo'),
(2418, 'SYS', 'STATE_CODE_511', 'Jal'),
(2419, 'SYS', 'STATE_511', 'Jalisco'),
(2420, 'SYS', 'STATE_CODE_512', 'Edomex'),
(2421, 'SYS', 'STATE_512', 'Mexico (Estado de Mexico)'),
(2422, 'SYS', 'STATE_CODE_513', 'Mich'),
(2423, 'SYS', 'STATE_513', 'Michoacan'),
(2424, 'SYS', 'STATE_CODE_514', 'Mor'),
(2425, 'SYS', 'STATE_514', 'Morelos'),
(2426, 'SYS', 'STATE_CODE_515', 'Nay'),
(2427, 'SYS', 'STATE_515', 'Nayarit'),
(2428, 'SYS', 'STATE_CODE_516', 'NL'),
(2429, 'SYS', 'STATE_516', 'Nuevo Leon'),
(2430, 'SYS', 'STATE_CODE_517', 'Oax'),
(2431, 'SYS', 'STATE_517', 'Oaxaca'),
(2432, 'SYS', 'STATE_CODE_518', 'Pue'),
(2433, 'SYS', 'STATE_518', 'Puebla'),
(2434, 'SYS', 'STATE_CODE_519', 'Qro'),
(2435, 'SYS', 'STATE_519', 'Queretaro'),
(2436, 'SYS', 'STATE_CODE_520', 'Q Roo'),
(2437, 'SYS', 'STATE_520', 'Quintana Roo'),
(2438, 'SYS', 'STATE_CODE_521', 'SLP'),
(2439, 'SYS', 'STATE_521', 'San Luis Potosi'),
(2440, 'SYS', 'STATE_CODE_522', 'Sin'),
(2441, 'SYS', 'STATE_522', 'Sinaloa'),
(2442, 'SYS', 'STATE_CODE_523', 'Son'),
(2443, 'SYS', 'STATE_523', 'Sonora'),
(2444, 'SYS', 'STATE_CODE_524', 'Tab'),
(2445, 'SYS', 'STATE_524', 'Tabasco'),
(2446, 'SYS', 'STATE_CODE_525', 'Tamps'),
(2447, 'SYS', 'STATE_525', 'Tamaulipas'),
(2448, 'SYS', 'STATE_CODE_526', 'Tlax'),
(2449, 'SYS', 'STATE_526', 'Tlaxcala'),
(2450, 'SYS', 'STATE_CODE_527', 'Ver'),
(2451, 'SYS', 'STATE_527', 'Veracruz'),
(2452, 'SYS', 'STATE_CODE_528', 'Yuc'),
(2453, 'SYS', 'STATE_528', 'Yucatan'),
(2454, 'SYS', 'STATE_CODE_529', 'Zac'),
(2455, 'SYS', 'STATE_529', 'Zacatecas'),
(2456, 'SYS', 'STATE_CODE_530', 'CF'),
(2457, 'SYS', 'STATE_530', 'Capital Federal (CABA)'),
(2458, 'SYS', 'STATE_CODE_531', 'BA'),
(2459, 'SYS', 'STATE_531', 'Buenos Aires'),
(2460, 'SYS', 'STATE_CODE_532', 'CA'),
(2461, 'SYS', 'STATE_532', 'Catamarca'),
(2462, 'SYS', 'STATE_CODE_533', 'CO'),
(2463, 'SYS', 'STATE_533', 'C rdoba'),
(2464, 'SYS', 'STATE_CODE_534', 'CH'),
(2465, 'SYS', 'STATE_534', 'Chaco'),
(2466, 'SYS', 'STATE_CODE_535', 'CT'),
(2467, 'SYS', 'STATE_535', 'Chubut'),
(2468, 'SYS', 'STATE_CODE_536', 'CR'),
(2469, 'SYS', 'STATE_536', 'Corrientes'),
(2470, 'SYS', 'STATE_CODE_537', 'ER'),
(2471, 'SYS', 'STATE_537', 'Entre R os'),
(2472, 'SYS', 'STATE_CODE_538', 'FM'),
(2473, 'SYS', 'STATE_538', 'Formosa'),
(2474, 'SYS', 'STATE_CODE_539', 'JY'),
(2475, 'SYS', 'STATE_539', 'Jujuy'),
(2476, 'SYS', 'STATE_CODE_540', 'LP'),
(2477, 'SYS', 'STATE_540', 'La Pampa'),
(2478, 'SYS', 'STATE_CODE_541', 'LR'),
(2479, 'SYS', 'STATE_541', 'La Rioja'),
(2480, 'SYS', 'STATE_CODE_542', 'MZ'),
(2481, 'SYS', 'STATE_542', 'Mendoza'),
(2482, 'SYS', 'STATE_CODE_543', 'MS'),
(2483, 'SYS', 'STATE_543', 'Misiones'),
(2484, 'SYS', 'STATE_CODE_544', 'NQ'),
(2485, 'SYS', 'STATE_544', 'Neuqu n'),
(2486, 'SYS', 'STATE_CODE_545', 'RN'),
(2487, 'SYS', 'STATE_545', 'Rio Negro'),
(2488, 'SYS', 'STATE_CODE_546', 'ST'),
(2489, 'SYS', 'STATE_546', 'Salta'),
(2490, 'SYS', 'STATE_CODE_547', 'SJ'),
(2491, 'SYS', 'STATE_547', 'San Juan'),
(2492, 'SYS', 'STATE_CODE_548', 'SL'),
(2493, 'SYS', 'STATE_548', 'San Luis'),
(2494, 'SYS', 'STATE_CODE_549', 'SZ'),
(2495, 'SYS', 'STATE_549', 'Santa Cruz'),
(2496, 'SYS', 'STATE_CODE_550', 'SF'),
(2497, 'SYS', 'STATE_550', 'Santa Fe'),
(2498, 'SYS', 'STATE_CODE_551', 'SE'),
(2499, 'SYS', 'STATE_551', 'Santiago del Estero'),
(2500, 'SYS', 'STATE_CODE_552', 'TF'),
(2501, 'SYS', 'STATE_552', 'Tierra del Fuego, Ant rtida e Is.Atl.Sur'),
(2502, 'SYS', 'STATE_CODE_553', 'TU'),
(2503, 'SYS', 'STATE_553', 'Tucum n'),
(2504, 'SYS', 'STATE_CODE_554', 'ART'),
(2505, 'SYS', 'STATE_554', 'Artigas'),
(2506, 'SYS', 'STATE_CODE_555', 'CAN'),
(2507, 'SYS', 'STATE_555', 'Canelones'),
(2508, 'SYS', 'STATE_CODE_556', 'CER'),
(2509, 'SYS', 'STATE_556', 'Cerro Largo'),
(2510, 'SYS', 'STATE_CODE_557', 'COL'),
(2511, 'SYS', 'STATE_557', 'Colonia'),
(2512, 'SYS', 'STATE_CODE_558', 'DUR'),
(2513, 'SYS', 'STATE_558', 'Durazno'),
(2514, 'SYS', 'STATE_CODE_559', 'FLS'),
(2515, 'SYS', 'STATE_559', 'Flores'),
(2516, 'SYS', 'STATE_CODE_560', 'FDA'),
(2517, 'SYS', 'STATE_560', 'Florida'),
(2518, 'SYS', 'STATE_CODE_561', 'LAV'),
(2519, 'SYS', 'STATE_561', 'Lavalleja'),
(2520, 'SYS', 'STATE_CODE_562', 'MAL'),
(2521, 'SYS', 'STATE_562', 'Maldonado'),
(2522, 'SYS', 'STATE_CODE_563', 'MVD'),
(2523, 'SYS', 'STATE_563', 'Montevideo'),
(2524, 'SYS', 'STATE_CODE_564', 'PAY'),
(2525, 'SYS', 'STATE_564', 'Paysand '),
(2526, 'SYS', 'STATE_CODE_565', 'RNE'),
(2527, 'SYS', 'STATE_565', 'Rio Negro'),
(2528, 'SYS', 'STATE_CODE_566', 'RIV'),
(2529, 'SYS', 'STATE_566', 'Rivera'),
(2530, 'SYS', 'STATE_CODE_567', 'RCH'),
(2531, 'SYS', 'STATE_567', 'Rocha'),
(2532, 'SYS', 'STATE_CODE_568', 'SAL'),
(2533, 'SYS', 'STATE_568', 'Salto'),
(2534, 'SYS', 'STATE_CODE_569', 'SJS'),
(2535, 'SYS', 'STATE_569', 'San Jos '),
(2536, 'SYS', 'STATE_CODE_570', 'SOR'),
(2537, 'SYS', 'STATE_570', 'Soriano'),
(2538, 'SYS', 'STATE_CODE_571', 'TAC'),
(2539, 'SYS', 'STATE_571', 'Tacuaremb '),
(2540, 'SYS', 'STATE_CODE_572', 'TRE'),
(2541, 'SYS', 'STATE_572', 'Treinta y Tres'),
(2542, 'SYS', 'STATE_CODE_573', 'AC'),
(2543, 'SYS', 'STATE_573', 'Acre'),
(2544, 'SYS', 'STATE_CODE_574', 'AL'),
(2545, 'SYS', 'STATE_574', 'Alagoas'),
(2546, 'SYS', 'STATE_CODE_575', 'AP'),
(2547, 'SYS', 'STATE_575', 'Amap '),
(2548, 'SYS', 'STATE_CODE_576', 'AM'),
(2549, 'SYS', 'STATE_576', 'Amazonas'),
(2550, 'SYS', 'STATE_CODE_577', 'BA'),
(2551, 'SYS', 'STATE_577', 'Bah a'),
(2552, 'SYS', 'STATE_CODE_578', 'CE'),
(2553, 'SYS', 'STATE_578', 'Cear '),
(2554, 'SYS', 'STATE_CODE_579', 'DF'),
(2555, 'SYS', 'STATE_579', 'Distrito Federal'),
(2556, 'SYS', 'STATE_CODE_580', 'ES'),
(2557, 'SYS', 'STATE_580', 'Esp rito Santo'),
(2558, 'SYS', 'STATE_CODE_581', 'GO'),
(2559, 'SYS', 'STATE_581', 'Goi s'),
(2560, 'SYS', 'STATE_CODE_582', 'MA'),
(2561, 'SYS', 'STATE_582', 'Maranhao'),
(2562, 'SYS', 'STATE_CODE_583', 'MT'),
(2563, 'SYS', 'STATE_583', 'Mato Grosso'),
(2564, 'SYS', 'STATE_CODE_584', 'MS'),
(2565, 'SYS', 'STATE_584', 'Mato Grosso do Sul'),
(2566, 'SYS', 'STATE_CODE_585', 'MG'),
(2567, 'SYS', 'STATE_585', 'Minas Gerais'),
(2568, 'SYS', 'STATE_CODE_586', 'PA'),
(2569, 'SYS', 'STATE_586', 'Par '),
(2570, 'SYS', 'STATE_CODE_587', 'PB'),
(2571, 'SYS', 'STATE_587', 'Para ba'),
(2572, 'SYS', 'STATE_CODE_588', 'PR'),
(2573, 'SYS', 'STATE_588', 'Paran '),
(2574, 'SYS', 'STATE_CODE_589', 'PE'),
(2575, 'SYS', 'STATE_589', 'Pernambuco'),
(2576, 'SYS', 'STATE_CODE_590', 'PI'),
(2577, 'SYS', 'STATE_590', 'Piau '),
(2578, 'SYS', 'STATE_CODE_591', 'RJ'),
(2579, 'SYS', 'STATE_591', 'Rio de Janeiro'),
(2580, 'SYS', 'STATE_CODE_592', 'RN'),
(2581, 'SYS', 'STATE_592', 'Rio Grande do Norte'),
(2582, 'SYS', 'STATE_CODE_593', 'RS'),
(2583, 'SYS', 'STATE_593', 'Rio Grande do Sul'),
(2584, 'SYS', 'STATE_CODE_594', 'RO'),
(2585, 'SYS', 'STATE_594', 'Rond nia'),
(2586, 'SYS', 'STATE_CODE_595', 'RR'),
(2587, 'SYS', 'STATE_595', 'Roraima'),
(2588, 'SYS', 'STATE_CODE_596', 'SC'),
(2589, 'SYS', 'STATE_596', 'Santa Catarina'),
(2590, 'SYS', 'STATE_CODE_597', 'SP'),
(2591, 'SYS', 'STATE_597', 'S o Paulo'),
(2592, 'SYS', 'STATE_CODE_598', 'SE'),
(2593, 'SYS', 'STATE_598', 'Sergipe'),
(2594, 'SYS', 'STATE_CODE_599', 'To'),
(2595, 'SYS', 'STATE_599', 'Tocantins'),
(2596, 'SYS', 'STATE_CODE_600', 'RM'),
(2597, 'SYS', 'STATE_600', 'Regi n Metropolitana'),
(2598, 'SYS', 'STATE_CODE_601', 'I'),
(2599, 'SYS', 'STATE_601', 'Tarapac '),
(2600, 'SYS', 'STATE_CODE_602', 'II'),
(2601, 'SYS', 'STATE_602', 'Antofagasta'),
(2602, 'SYS', 'STATE_CODE_603', 'III'),
(2603, 'SYS', 'STATE_603', 'Atacama'),
(2604, 'SYS', 'STATE_CODE_604', 'IV'),
(2605, 'SYS', 'STATE_604', 'Coquimbo'),
(2606, 'SYS', 'STATE_CODE_605', 'V'),
(2607, 'SYS', 'STATE_605', 'Valpara so'),
(2608, 'SYS', 'STATE_CODE_606', 'VI'),
(2609, 'SYS', 'STATE_606', 'Lib. Gral. O`Higgins'),
(2610, 'SYS', 'STATE_CODE_607', 'VII'),
(2611, 'SYS', 'STATE_607', 'Maule'),
(2612, 'SYS', 'STATE_CODE_608', 'VIII'),
(2613, 'SYS', 'STATE_608', 'Biob o'),
(2614, 'SYS', 'STATE_CODE_609', 'IX'),
(2615, 'SYS', 'STATE_609', 'La Araucan a'),
(2616, 'SYS', 'STATE_CODE_610', 'X'),
(2617, 'SYS', 'STATE_610', 'Los Lagos'),
(2618, 'SYS', 'STATE_CODE_611', 'XI'),
(2619, 'SYS', 'STATE_611', 'Ais n'),
(2620, 'SYS', 'STATE_CODE_612', 'XII'),
(2621, 'SYS', 'STATE_612', 'Magallanes'),
(2622, 'SYS', 'STATE_CODE_613', 'XIV'),
(2623, 'SYS', 'STATE_613', 'Los R os'),
(2624, 'SYS', 'STATE_CODE_614', 'XV'),
(2625, 'SYS', 'STATE_614', 'Arica y Parinacota'),
(2626, 'SYS', 'STATE_CODE_615', 'YT'),
(2627, 'SYS', 'STATE_615', 'Yukon'),
(2628, 'SYS', 'STATE_616', 'Andaman and Nicobar Islands'),
(2629, 'SYS', 'STATE_CODE_616', 'AN'),
(2630, 'SYS', 'STATE_617', 'Andhra Pradesh'),
(2631, 'SYS', 'STATE_CODE_617', 'AP'),
(2632, 'SYS', 'STATE_618', 'Arunachal Pradesh'),
(2633, 'SYS', 'STATE_CODE_618', 'AR'),
(2634, 'SYS', 'STATE_619', 'Assam'),
(2635, 'SYS', 'STATE_CODE_619', 'AS'),
(2636, 'SYS', 'STATE_620', 'Bihar'),
(2637, 'SYS', 'STATE_CODE_620', 'BR'),
(2638, 'SYS', 'STATE_621', 'Chandigarh'),
(2639, 'SYS', 'STATE_CODE_621', 'CH'),
(2640, 'SYS', 'STATE_622', 'Chhattisgarh'),
(2641, 'SYS', 'STATE_CODE_622', 'CT'),
(2642, 'SYS', 'STATE_623', 'Dadra and Nagar Haveli'),
(2643, 'SYS', 'STATE_CODE_623', 'DN'),
(2644, 'SYS', 'STATE_624', 'Daman and Diu'),
(2645, 'SYS', 'STATE_CODE_624', 'DD'),
(2646, 'SYS', 'STATE_625', 'Delhi'),
(2647, 'SYS', 'STATE_CODE_625', 'DL'),
(2648, 'SYS', 'STATE_626', 'Goa'),
(2649, 'SYS', 'STATE_CODE_626', 'GA'),
(2650, 'SYS', 'STATE_627', 'Gujarat'),
(2651, 'SYS', 'STATE_CODE_627', 'GJ'),
(2652, 'SYS', 'STATE_628', 'Haryana'),
(2653, 'SYS', 'STATE_CODE_628', 'HR'),
(2654, 'SYS', 'STATE_629', 'Himachal Pradesh'),
(2655, 'SYS', 'STATE_CODE_629', 'HP'),
(2656, 'SYS', 'STATE_630', 'Jammu and Kashmir'),
(2657, 'SYS', 'STATE_CODE_630', 'JK'),
(2658, 'SYS', 'STATE_631', 'Jharkhand'),
(2659, 'SYS', 'STATE_CODE_631', 'JH'),
(2660, 'SYS', 'STATE_632', 'Karnataka'),
(2661, 'SYS', 'STATE_CODE_632', 'KA'),
(2662, 'SYS', 'STATE_633', 'Kerala'),
(2663, 'SYS', 'STATE_CODE_633', 'KL'),
(2664, 'SYS', 'STATE_634', 'Lakshadweep'),
(2665, 'SYS', 'STATE_CODE_634', 'LD'),
(2666, 'SYS', 'STATE_635', 'Madhya Pradesh'),
(2667, 'SYS', 'STATE_CODE_635', 'MP'),
(2668, 'SYS', 'STATE_636', 'Maharashtra'),
(2669, 'SYS', 'STATE_CODE_636', 'MH'),
(2670, 'SYS', 'STATE_637', 'Manipur'),
(2671, 'SYS', 'STATE_CODE_637', 'MN'),
(2672, 'SYS', 'STATE_638', 'Meghalaya'),
(2673, 'SYS', 'STATE_CODE_638', 'ML'),
(2674, 'SYS', 'STATE_639', 'Mizoram'),
(2675, 'SYS', 'STATE_CODE_639', 'MZ'),
(2676, 'SYS', 'STATE_640', 'Nagaland'),
(2677, 'SYS', 'STATE_CODE_640', 'NL'),
(2678, 'SYS', 'STATE_641', 'Orissa'),
(2679, 'SYS', 'STATE_CODE_641', 'OR'),
(2680, 'SYS', 'STATE_642', 'Pondicherry'),
(2681, 'SYS', 'STATE_CODE_642', 'PY'),
(2682, 'SYS', 'STATE_643', 'Punjab'),
(2683, 'SYS', 'STATE_CODE_643', 'PB'),
(2684, 'SYS', 'STATE_644', 'Rajasthan'),
(2685, 'SYS', 'STATE_CODE_644', 'RJ'),
(2686, 'SYS', 'STATE_645', 'Sikkim'),
(2687, 'SYS', 'STATE_CODE_645', 'SK'),
(2688, 'SYS', 'STATE_646', 'Tamil Nadu'),
(2689, 'SYS', 'STATE_CODE_646', 'TN'),
(2690, 'SYS', 'STATE_647', 'Telangana'),
(2691, 'SYS', 'STATE_CODE_647', 'TG'),
(2692, 'SYS', 'STATE_648', 'Tripura'),
(2693, 'SYS', 'STATE_CODE_648', 'TR'),
(2694, 'SYS', 'STATE_649', 'Uttar Pradesh'),
(2695, 'SYS', 'STATE_CODE_649', 'UP'),
(2696, 'SYS', 'STATE_650', 'Uttaranchal'),
(2697, 'SYS', 'STATE_CODE_650', 'UT'),
(2698, 'SYS', 'STATE_651', 'West Bengal'),
(2699, 'SYS', 'STATE_CODE_651', 'WB'),
(2700, 'SYS', 'STATE_ALL_OTHER', 'All Other'),
(2701, 'SYS', 'MNG_CNTR_PAGE_TITLE', 'Countries Management'),
(2702, 'SYS', 'MNG_CNTR_PAGE_NAME', 'Store Configuration'),
(2703, 'SYS', 'MNG_CNTR_PAGE_HEADER', 'Countries Management'),
(2704, 'SYS', 'MNG_CNTR_TABLE_HEADER_001', 'Code'),
(2705, 'SYS', 'MNG_CNTR_TABLE_HEADER_002', 'Country'),
(2706, 'SYS', 'MNG_CNTR_TABLE_HEADER_003', 'Active'),
(2707, 'SYS', 'MNG_CNTR_TABLE_HEADER_004', 'Default'),
(2708, 'SYS', 'MNG_CNTR_OBJECT_NAME', 'countries'),
(2709, 'SYS', 'MNG_CNTR_NO_SELECTED_ERROR', 'Please check at least one country.'),
(2710, 'SYS', 'MNG_CNTR_RESULT_MESSAGE', 'Country display have been successfully saved.'),
(2711, 'SYS', 'MNG_CNTR_RESULT_ERROR_MESSAGE', 'Error to save country changes.'),
(2712, 'SYS', 'MNG_CURR_PAGE_HEADER', 'Currencies Management'),
(2713, 'SYS', 'MNG_CURR_TABLE_HEADER_001', 'Code'),
(2714, 'SYS', 'MNG_CURR_TABLE_HEADER_002', 'Currency name, visible to customer'),
(2715, 'SYS', 'MNG_CURR_TABLE_HEADER_003', 'Active'),
(2716, 'SYS', 'MNG_CURR_TABLE_HEADER_004', 'Main store currency'),
(2717, 'SYS', 'MNG_STATE_PAGE_TITLE', 'States Management'),
(2718, 'SYS', 'MNG_STATE_PAGE_NAME', 'Store Configuration'),
(2719, 'SYS', 'MNG_STATE_PAGE_HEADER', 'States Management'),
(2720, 'SYS', 'MNG_STATE_CNTR_LABEL', 'Country:'),
(2721, 'SYS', 'MNG_STATE_TABLE_HEADER_001', 'Code'),
(2722, 'SYS', 'MNG_STATE_TABLE_HEADER_002', 'State'),
(2723, 'SYS', 'MNG_STATE_TABLE_HEADER_003', 'Active'),
(2724, 'SYS', 'MNG_STATE_TABLE_HEADER_004', 'Default'),
(2725, 'SYS', 'MNG_STATE_OBJECT_NAME', 'states'),
(2726, 'SYS', 'MNG_STATE_WRN_001', 'No countries with states defined for them were found in system'),
(2727, 'SYS', 'MNG_STATE_WRN_002', 'States are not defined for selected country'),
(2728, 'SYS', 'MNG_STATE_WRN_003', 'The page has been changed:\\n    - Press \\''OK\\'' to save the changes and go to another country\\''s states list;\\n    - Press \\''Cancel\\'' to leave the page and discard the changes'),
(2729, 'SYS', 'MNG_STATE_RESULT_MESSAGE', 'States display have been successfully saved.'),
(2730, 'SYS', 'MNG_STATE_RESULT_ERROR_MESSAGE', 'Error to save states changes.'),
(2731, 'SYS', 'ADMIN_AS_INFO_PAGE_TITLE', 'Application/Server Info'),
(2732, 'SYS', 'ADMIN_AS_INFO_HEADER_001', 'Application Info'),
(2733, 'SYS', 'ADMIN_AS_INFO_HEADER_002', 'Server Info'),
(2734, 'SYS', 'ADMIN_AS_INFO_SUBTITLE_001', 'Summary'),
(2735, 'SYS', 'ADMIN_AS_INFO_SUBTITLE_002', 'Registration Info'),
(2736, 'SYS', 'ADMIN_AS_INFO_SUBTITLE_003', 'Modules Info'),
(2737, 'SYS', 'ADMIN_AS_INFO_SUBTITLE_004', 'Summary'),
(2738, 'SYS', 'ADMIN_AS_INFO_SUBTITLE_005', 'PHP Info'),
(2739, 'SYS', 'ADMIN_AS_INFO_FIELD_001', 'Product Version'),
(2740, 'SYS', 'ADMIN_AS_INFO_FIELD_002', 'Product Verson Type'),
(2741, 'SYS', 'ADMIN_AS_INFO_FIELD_003', 'Product Release Date'),
(2742, 'SYS', 'ADMIN_AS_INFO_FIELD_004', 'License Number'),
(2743, 'SYS', 'ADMIN_AS_INFO_FIELD_005', 'Licensed Domain'),
(2744, 'SYS', 'ADMIN_AS_INFO_FIELD_006', 'License Start Date'),
(2745, 'SYS', 'ADMIN_AS_INFO_FIELD_007', 'License Validity Period'),
(2746, 'SYS', 'ADMIN_AS_INFO_FIELD_008', 'Allowed Number of Products'),
(2747, 'SYS', 'ADMIN_AS_INFO_FIELD_009', 'License Type'),
(2748, 'SYS', 'ADMIN_AS_INFO_FIELD_010', 'Core Version'),
(2749, 'SYS', 'ADMIN_AS_INFO_FIELD_011', 'PHP Version'),
(2750, 'SYS', 'ADMIN_AS_INFO_FIELD_012', 'MySQL Version'),
(2751, 'SYS', 'ADMIN_AS_INFO_FIELD_013', 'Server OS'),
(2752, 'SYS', 'ADMIN_AS_INFO_FIELD_014', 'Web Server'),
(2753, 'SYS', 'ADMIN_AS_INFO_VERSION_LABEL', 'Version'),
(2754, 'SYS', 'ADMIN_AS_INFO_PHP_INFO_LINK', 'Click Here for more information'),
(2755, 'SYS', 'ADMIN_AS_INFO_HEADER_003', '<BR><BR><BR><HR><BR><P>Validating changes and integrity of files'),
(2756, 'SYS', 'ADMIN_MEMBERS_PAGE_NAME', 'Admin Members'),
(2757, 'SYS', 'ADMIN_MEMBERS_HEADER', 'Admin Members'),
(2758, 'SYS', 'ADMIN_MEMBERS_TABLE_HEADER_001', 'Name'),
(2759, 'SYS', 'ADMIN_MEMBERS_TABLE_HEADER_002', 'E-mail'),
(2760, 'SYS', 'ADMIN_MEMBERS_TABLE_HEADER_003', 'Number of sign-ins'),
(2761, 'SYS', 'ADMIN_MEMBERS_TABLE_HEADER_004', 'Last Logged In'),
(2762, 'SYS', 'ADMIN_MEMBERS_TABLE_HEADER_005', 'Created'),
(2763, 'SYS', 'ADMIN_MEMBERS_TABLE_HEADER_006', 'Modified'),
(2764, 'SYS', 'ADMIN_MEMBERS_LABEL_001', 'Never logged in'),
(2765, 'SYS', 'ADMIN_MEMBERS_LABEL_002', 'Never modified'),
(2766, 'SYS', 'ADMIN_MEMBERS_LABEL_003', '* - Current Admin'),
(2767, 'SYS', 'ADMIN_BACKUP_PAGE_NAME', 'Data Backup &amp; Restore'),
(2768, 'SYS', 'ADMIN_BACKUP_HEADER', 'Backup'),
(2769, 'SYS', 'ADMIN_SERVER_PAGE_NAME', 'Application/Server Info'),
(2770, 'SYS', 'ADMIN_INFO_PAGE_TITLE', 'Admin Info'),
(2771, 'SYS', 'ADMIN_INFO_PAGE_SUBTITLE', 'Admin Member:'),
(2772, 'SYS', 'ADMIN_INFO_HEADER_001', 'Additional Information'),
(2773, 'SYS', 'ADMIN_INFO_HEADER_002', 'Permissions'),
(2774, 'SYS', 'ADMIN_INFO_FIELD_001', 'First Name'),
(2775, 'SYS', 'ADMIN_INFO_FIELD_002', 'Last Name'),
(2776, 'SYS', 'ADMIN_INFO_FIELD_003', 'E-mail'),
(2777, 'SYS', 'ADMIN_INFO_FIELD_004', 'Number of sign-ins'),
(2778, 'SYS', 'ADMIN_INFO_FIELD_005', 'Last Logged In'),
(2779, 'SYS', 'ADMIN_INFO_FIELD_006', 'Created'),
(2780, 'SYS', 'ADMIN_INFO_FIELD_007', 'Modified'),
(2781, 'SYS', 'ADMIN_INFO_FIELD_008', 'Authorized to'),
(2782, 'SYS', 'ADMIN_INFO_FIELD_009', 'Not authorized to'),
(2783, 'SYS', 'ADMIN_INFO_WARNING_001', 'Are you sure that you want to change the password of admin member'),
(2784, 'SYS', 'ADMIN_PSWD_CHANGE_PAGE_TITLE', ' Change password'),
(2785, 'SYS', 'ADMIN_PSWD_CHANGE_PAGE_SUBTITLE', 'Change password for:'),
(2786, 'SYS', 'ADMIN_PSWD_CHANGE_FIELD_001', 'New Password'),
(2787, 'SYS', 'ADMIN_PSWD_CHANGE_FIELD_002', 'Re-Enter New Password'),
(2788, 'SYS', 'ADMIN_PSWD_CHANGE_FIELD_003', 'Send New Password by Email'),
(2789, 'SYS', 'PSWUPD_008', 'All Fields must be filled in - both New Password and Verify New Password.'),
(2790, 'SYS', 'PSWUPD_009', 'All Fields must be filled in - each of First Name, Last Name, E-mail, Password, and Verify Password.'),
(2791, 'SYS', 'PSWUPD_010', 'An admin member with this email address already exists in the database. Please provide a unique e-mail address.'),
(2792, 'SYS', 'PSWUPD_011', 'All Fields must be filled in - each of First Name, Last Name, and E-mail.'),
(2793, 'SYS', 'ADMIN_ADD_MEMBER_PAGE_TITLE', 'Add Admin Member'),
(2794, 'SYS', 'ADMIN_ADD_MEMBER_PAGE_SUBTITLE', 'Admin Info'),
(2795, 'SYS', 'ADMIN_ADD_MEMBER_FIELD_004', 'Password'),
(2796, 'SYS', 'ADMIN_ADD_MEMBER_FIELD_005', 'Re-Enter Password'),
(2797, 'SYS', 'ADMIN_ADD_MEMBER_FIELD_006', 'Available Options'),
(2798, 'SYS', 'ADMIN_EDIT_MEMBER_PAGE_TITLE', 'Edit Admin Member'),
(2799, 'SYS', 'ADMIN_DELETE_MEMBER_PAGE_TITLE', 'Delete Admin Member'),
(2800, 'SYS', 'ADMIN_DELETE_MEMBER_PAGE_SUBTITLE', 'Admin Members to be deleted'),
(2801, 'SYS', 'ADMIN_DELETE_MEMBER_WARNING_001', 'WARNING! The following admin members will be deleted. Please be careful: admin member accounts cannot be restored after they are deleted.'),
(2802, 'SYS', 'ADMIN_DELETE_MEMBER_WARNING_002', 'To perform this action please first select one or more admin members.');
INSERT INTO `[[dbprefix]]resource_labels` VALUES
(2803, 'SYS', 'ADMIN_OPTION_NAME_001', 'Add admin members or edit admin members'' information'),
(2804, 'SYS', 'ADMIN_OPTION_NAME_002', 'Add, Delete, Modify e-mail notifications'),
(2805, 'SYS', 'ADMIN_OPTION_NAME_004', 'Create Backup, Restore'),
(2806, 'SYS', 'ADMIN_OPTION_NAME_008', 'Receive notifications of order status changes'),
(2807, 'SYS', 'BTN_UPDATE_COUNTRIES', 'Update'),
(2808, 'SYS', 'BTN_UPDATE_STATES', 'Update'),
(2809, 'SYS', 'BTN_CHANGE_PASSWORD', 'Change Password'),
(2810, 'SYS', 'GNRL_SET_PAGE_TITLE', 'Store Configuration'),
(2811, 'SYS', 'GNRL_SET_PAGE_SUBTITLE', 'General Settings'),
(2812, 'SYS', 'MSG_GNRL_SET_UPDATED', 'General Settings have been updated.'),
(2813, 'SYS', 'GNRL_SET_HEADER_001', 'Close/Open the Online Store'),
(2814, 'SYS', 'GNRL_SET_HEADER_002', 'Low Stock Level Settings'),
(2815, 'SYS', 'GNRL_SET_HEADER_003', 'Store Time Settings'),
(2816, 'SYS', 'GNRL_SET_HEADER_004', 'Settings for Blocking Sign In to Admin Area'),
(2817, 'SYS', 'GNRL_SET_HEADER_005', 'Shopping Cart'),
(2818, 'SYS', 'GNRL_SET_HEADER_006', 'Paginators in Admin Area'),
(2819, 'SYS', 'GNRL_SET_HEADER_007', 'Paginators in Storefront'),
(2820, 'SYS', 'GNRL_SET_FIELD_001', 'Store status'),
(2821, 'SYS', 'GNRL_SET_FIELD_001_DESCR', 'To close the store, set the status to <B>CLOSED</B>. Store users will not be able to view the catalog of products or place orders. A webpage specially created for this purpose will be displayed to visitors. For details on creating such a page, please refer to Storefront Area documentation.<BR>To open the store to shoppers, set the store status to <B>ONLINE</B>.'),
(2822, 'SYS', 'GNRL_SET_FIELD_002', 'Key for signing in to a temporarily closed store'),
(2823, 'SYS', 'GNRL_SET_FIELD_002_DESCR', 'The keyword for accessing a CLOSED store. The URL for viewing a CLOSED store is displayed below the keyword.'),
(2824, 'SYS', 'GNRL_SET_FIELD_003', 'Displaying products not in stock'),
(2825, 'SYS', 'GNRL_SET_FIELD_003_DESCR', '<B>Enabled</B>: products not in stock ARE displayed when customers browse the catalog.<br><B>Disabled</B>: products not in stock are NOT displayed when customers browse the catalog.'),
(2826, 'SYS', 'GNRL_SET_FIELD_032', 'Return product to stock when order is deleted'),
(2827, 'SYS', 'GNRL_SET_FIELD_032_DESCR', 'If this is set to ''Yes'' and an order is deleted, then it''s products are returned to stock.'),
(2828, 'SYS', 'GNRL_SET_FIELD_033', 'Return product to stock when order status changes to Canceled or Declined'),
(2829, 'SYS', 'GNRL_SET_FIELD_033_DESCR', 'When an order is created, the stock is reduced by the number of items ordered. These settings are designed to help you manage your stock. If this setting is set to ''Yes'' and the order status changes to Canceled or Declined, then it''s products are returned to stock.'),
(2830, 'SYS', 'GNRL_SET_FIELD_004', 'Ordering of products not in stock'),
(2831, 'SYS', 'GNRL_SET_FIELD_004_DESCR', '<B>Enabled</B>: products not in stock CAN be ordered.<BR><B>Disabled</B>: products not in stock CAN NOT be ordered.'),
(2832, 'SYS', 'GNRL_SET_FIELD_005', 'Store Time'),
(2833, 'SYS', 'GNRL_SET_FIELD_005_DESCR', 'Current store time and store date.'),
(2834, 'SYS', 'GNRL_SET_FIELD_006', 'Adjust store time'),
(2835, 'SYS', 'GNRL_SET_FIELD_006_DESCR', 'This setting lets you change the current store time. Use positive numbers to increase the time and negative numbers to decrease it.'),
(2836, 'SYS', 'GNRL_SET_FIELD_007', 'Number of unsuccessful attempts to sign in to Admin Area after which the Sign In page is blocked'),
(2837, 'SYS', 'GNRL_SET_FIELD_007_DESCR', 'This setting determines the number of unsuccessful attempts to sign in to Admin Area after which the Sign In page becomes blocked. This allows you to protect your store from unauthorized access. The block applies to only one user that has a particular IP address and does not apply to any other users.'),
(2838, 'SYS', 'GNRL_SET_FIELD_008', 'Amount of time the sign in page stays blocked'),
(2839, 'SYS', 'GNRL_SET_FIELD_008_DESCR', 'The amount of time the Sign In page stays blocked for the user who has exceeded the limit of attempts to sign in. The block applies to only one user that has a particular IP address and does not apply to any other users.'),
(2840, 'SYS', 'GNRL_SET_FIELD_009', 'Show customer the shopping cart contents after the product has been added'),
(2841, 'SYS', 'GNRL_SET_FIELD_009_DESCR', '<B>Enabled</B>: the contents of the shopping cart are displayed after a product is added. Any time a product is added, the customer sees what is currently in the cart.<BR><B>Disabled</B>: the contents of the shopping cart are NOT displayed after a product is added. Adding products to cart is done without the cart''s contents being displayed every time, although the customer may view the cart whenever they want.'),
(2842, 'SYS', 'GNRL_SET_FIELD_010', 'Default products per page'),
(2843, 'SYS', 'GNRL_SET_FIELD_010_DESCR', 'Select how many products are displayed per page by default.'),
(2844, 'SYS', 'GNRL_SET_FIELD_011', 'List of available products per page values'),
(2845, 'SYS', 'GNRL_SET_FIELD_011_DESCR', 'By using this option you can modify the list of available products per page values.'),
(2846, 'SYS', 'GNRL_SET_FIELD_023', 'Number of page links shown'),
(2847, 'SYS', 'GNRL_SET_FIELD_023_DESCR', 'Number of page links after which the Next link is shown.'),
(2848, 'SYS', 'GNRL_SET_ENABLED_LABEL', 'Enabled'),
(2849, 'SYS', 'GNRL_SET_DISABLED_LABEL', 'Disabled'),
(2850, 'SYS', 'GNRL_SET_SHOW_ABSENT_SHOW_BUY_LABEL', 'Show and allow to buy.'),
(2851, 'SYS', 'GNRL_SET_SHOW_ABSENT_SHOW_NOT_BUY_LABEL', 'Show but don''t allow to buy.'),
(2852, 'SYS', 'GNRL_SET_SHOW_ABSENT_NOT_SHOW_NOT_BUY_LABEL', 'Don''t show, don''t allow to buy.'),
(2853, 'SYS', 'GNRL_SET_LABEL_001', 'Hours'),
(2854, 'SYS', 'GNRL_SET_LABEL_002', 'attempts'),
(2855, 'SYS', 'GNRL_SET_ALERT_001', 'The list of available \\''items per page\\'' values must contain at least one entry.'),
(2856, 'SYS', 'GNRL_SET_FIELD_034', 'Enable wishlist'),
(2857, 'SYS', 'GNRL_SET_FIELD_034_DESCR', 'Enable wishlist'),
(2858, 'SYS', 'CRNCY_FORMAT_PAGE_TITLE', 'Store Configuration'),
(2859, 'SYS', 'CRNCY_FORMAT_PAGE_SUBTITLE', 'Currency Format'),
(2860, 'SYS', 'CRNCY_FORMAT_FIELD_001', 'Type of Currency'),
(2861, 'SYS', 'CRNCY_FORMAT_FIELD_002', 'Currency denotation'),
(2862, 'SYS', 'CRNCY_FORMAT_FIELD_003', 'Decimal separator'),
(2863, 'SYS', 'CRNCY_FORMAT_FIELD_004', 'Thousands separator'),
(2864, 'SYS', 'CRNCY_FORMAT_FIELD_005', 'Number of figures after the decimal sign'),
(2865, 'SYS', 'CRNCY_FORMAT_FIELD_006', 'Format for positive amounts'),
(2866, 'SYS', 'CRNCY_FORMAT_FIELD_007', 'Format for negative amounts'),
(2867, 'SYS', 'CRNCY_FORMAT_FIELD_008', 'Examples'),
(2868, 'SYS', 'MSG_CRNCY_FORMAT_UPDATED', 'Currency output format has been updated.'),
(2869, 'SYS', 'DATE_TIME_PAGE_TITLE', 'Store Configuration'),
(2870, 'SYS', 'DATE_TIME_PAGE_SUBTITLE', 'Date/Time Format'),
(2871, 'SYS', 'DATE_TIME_FIELD_001', 'Date format'),
(2872, 'SYS', 'DATE_TIME_FIELD_002', 'Time format'),
(2873, 'SYS', 'MSG_DATE_TIME_UPDATED', 'Date and time output formats have been updated.'),
(2874, 'SYS', 'NUM_FORMAT_PAGE_TITLE', 'Store Configuration'),
(2875, 'SYS', 'NUM_FORMAT_PAGE_SUBTITLE', 'Number Format'),
(2876, 'SYS', 'NUM_FORMAT_FIELD_001', 'Decimal separator'),
(2877, 'SYS', 'NUM_FORMAT_FIELD_002', 'Thousands separator'),
(2878, 'SYS', 'NUM_FORMAT_FIELD_003', 'Number of figures after the decimal sign'),
(2879, 'SYS', 'NUM_FORMAT_FIELD_004', 'Format for negative numbers'),
(2880, 'SYS', 'NUM_FORMAT_FIELD_005', 'Examples'),
(2881, 'SYS', 'NUM_FORMAT_SEP_101', '.'),
(2882, 'SYS', 'NUM_FORMAT_SEP_VAL_101', '.'),
(2883, 'SYS', 'NUM_FORMAT_SEP_102', ','),
(2884, 'SYS', 'NUM_FORMAT_SEP_VAL_102', ','),
(2885, 'SYS', 'NUM_FORMAT_SEP_103', '-'),
(2886, 'SYS', 'NUM_FORMAT_SEP_VAL_103', '-'),
(2887, 'SYS', 'NUM_FORMAT_SEP_104', '='),
(2888, 'SYS', 'NUM_FORMAT_SEP_VAL_104', '='),
(2889, 'SYS', 'NUM_FORMAT_SEP_105', '/'),
(2890, 'SYS', 'NUM_FORMAT_SEP_VAL_105', '/'),
(2891, 'SYS', 'NUM_FORMAT_SEP_106', ';'),
(2892, 'SYS', 'NUM_FORMAT_SEP_VAL_106', ';'),
(2893, 'SYS', 'NUM_FORMAT_SEP_107', ':'),
(2894, 'SYS', 'NUM_FORMAT_SEP_VAL_107', ':'),
(2895, 'SYS', 'NUM_FORMAT_SEP_108', ''''),
(2896, 'SYS', 'NUM_FORMAT_SEP_VAL_108', ''''),
(2897, 'SYS', 'NUM_FORMAT_SEP_201', '&lt;none&gt;'),
(2898, 'SYS', 'NUM_FORMAT_SEP_VAL_201', ''),
(2899, 'SYS', 'NUM_FORMAT_SEP_202', 'space'),
(2900, 'SYS', 'NUM_FORMAT_SEP_VAL_202', ' '),
(2901, 'SYS', 'NUM_FORMAT_SEP_203', '.'),
(2902, 'SYS', 'NUM_FORMAT_SEP_VAL_203', '.'),
(2903, 'SYS', 'NUM_FORMAT_SEP_204', ','),
(2904, 'SYS', 'NUM_FORMAT_SEP_VAL_204', ','),
(2905, 'SYS', 'NUM_FORMAT_SEP_205', ''''),
(2906, 'SYS', 'NUM_FORMAT_SEP_VAL_205', ''''),
(2907, 'SYS', 'ITEM_UNIT', 'Item(s)'),
(2908, 'SYS', 'MSG_NUM_FORMAT_UPDATED', 'Number format has been updated.'),
(2909, 'SYS', 'CURRENCY_CODE_001', 'AFN'),
(2910, 'SYS', 'CURRENCY_ISO_001', '971'),
(2911, 'SYS', 'CURRENCY_NAME_001', 'Afghan Afghani (AFN)'),
(2912, 'SYS', 'CURRENCY_CODE_002', 'ALL'),
(2913, 'SYS', 'CURRENCY_ISO_002', '8'),
(2914, 'SYS', 'CURRENCY_NAME_002', 'Albanian Lek (ALL)'),
(2915, 'SYS', 'CURRENCY_CODE_003', 'DZD'),
(2916, 'SYS', 'CURRENCY_ISO_003', '12'),
(2917, 'SYS', 'CURRENCY_NAME_003', 'Algerian Dinar (DZD)'),
(2918, 'SYS', 'CURRENCY_CODE_004', 'USD'),
(2919, 'SYS', 'CURRENCY_ISO_004', '840'),
(2920, 'SYS', 'CURRENCY_NAME_004', 'United States Dollar (USD)'),
(2921, 'SYS', 'CURRENCY_CODE_006', 'EUR'),
(2922, 'SYS', 'CURRENCY_ISO_006', '978'),
(2923, 'SYS', 'CURRENCY_NAME_006', 'European Euro (EUR)'),
(2924, 'SYS', 'CURRENCY_CODE_007', 'AOA'),
(2925, 'SYS', 'CURRENCY_ISO_007', '973'),
(2926, 'SYS', 'CURRENCY_NAME_007', 'Angolan Kwanza (AOA)'),
(2927, 'SYS', 'CURRENCY_CODE_008', 'XCD'),
(2928, 'SYS', 'CURRENCY_ISO_008', '951'),
(2929, 'SYS', 'CURRENCY_NAME_008', 'East Caribbean Dollar (XCD)'),
(2930, 'SYS', 'CURRENCY_CODE_010', 'ARS'),
(2931, 'SYS', 'CURRENCY_ISO_010', '32'),
(2932, 'SYS', 'CURRENCY_NAME_010', 'Argentine Peso (ARS)'),
(2933, 'SYS', 'CURRENCY_CODE_011', 'AMD'),
(2934, 'SYS', 'CURRENCY_ISO_011', '51'),
(2935, 'SYS', 'CURRENCY_NAME_011', 'Armenian Dram (AMD)'),
(2936, 'SYS', 'CURRENCY_CODE_012', 'AWG'),
(2937, 'SYS', 'CURRENCY_ISO_012', '533'),
(2938, 'SYS', 'CURRENCY_NAME_012', 'Aruban Florin (AWG)'),
(2939, 'SYS', 'CURRENCY_CODE_013', 'AUD'),
(2940, 'SYS', 'CURRENCY_ISO_013', '36'),
(2941, 'SYS', 'CURRENCY_NAME_013', 'Australian Dollar (AUD)'),
(2942, 'SYS', 'CURRENCY_CODE_016', 'AZN'),
(2943, 'SYS', 'CURRENCY_ISO_016', '944'),
(2944, 'SYS', 'CURRENCY_NAME_016', 'Azerbaijani Manat (AZN)'),
(2945, 'SYS', 'CURRENCY_CODE_018', 'BSD'),
(2946, 'SYS', 'CURRENCY_ISO_018', '44'),
(2947, 'SYS', 'CURRENCY_NAME_018', 'Bahamian Dollar (BSD)'),
(2948, 'SYS', 'CURRENCY_CODE_019', 'BHD'),
(2949, 'SYS', 'CURRENCY_ISO_019', '48'),
(2950, 'SYS', 'CURRENCY_NAME_019', 'Bahraini Dinar (BHD)'),
(2951, 'SYS', 'CURRENCY_CODE_020', 'BBD'),
(2952, 'SYS', 'CURRENCY_ISO_020', '52'),
(2953, 'SYS', 'CURRENCY_NAME_020', 'Barbadian Dollar (BBD)'),
(2954, 'SYS', 'CURRENCY_CODE_022', 'BDT'),
(2955, 'SYS', 'CURRENCY_ISO_022', '50'),
(2956, 'SYS', 'CURRENCY_NAME_022', 'Bangladeshi Taka (BDT)'),
(2957, 'SYS', 'CURRENCY_CODE_024', 'BYR'),
(2958, 'SYS', 'CURRENCY_ISO_024', '974'),
(2959, 'SYS', 'CURRENCY_NAME_024', 'Belarusian Ruble (BYR)'),
(2960, 'SYS', 'CURRENCY_CODE_026', 'BZD'),
(2961, 'SYS', 'CURRENCY_ISO_026', '84'),
(2962, 'SYS', 'CURRENCY_NAME_026', 'Belize Dollar (BZD)'),
(2963, 'SYS', 'CURRENCY_CODE_027', 'XOF'),
(2964, 'SYS', 'CURRENCY_ISO_027', '952'),
(2965, 'SYS', 'CURRENCY_NAME_027', 'West African CFA Franc (XOF)'),
(2966, 'SYS', 'CURRENCY_CODE_028', 'BMD'),
(2967, 'SYS', 'CURRENCY_ISO_028', '60'),
(2968, 'SYS', 'CURRENCY_NAME_028', 'Bermudian Dollar (BMD)'),
(2969, 'SYS', 'CURRENCY_CODE_029', 'INR'),
(2970, 'SYS', 'CURRENCY_ISO_029', '356'),
(2971, 'SYS', 'CURRENCY_NAME_029', 'India Rupee (INR)'),
(2972, 'SYS', 'CURRENCY_CODE_030', 'BTN'),
(2973, 'SYS', 'CURRENCY_ISO_030', '64'),
(2974, 'SYS', 'CURRENCY_NAME_030', 'Bhutanese Ngultrum (BTN)'),
(2975, 'SYS', 'CURRENCY_CODE_031', 'BOB'),
(2976, 'SYS', 'CURRENCY_ISO_031', '68'),
(2977, 'SYS', 'CURRENCY_NAME_031', 'Bolivian Boliviano (BOB)'),
(2978, 'SYS', 'CURRENCY_CODE_032', 'ANG'),
(2979, 'SYS', 'CURRENCY_ISO_032', '532'),
(2980, 'SYS', 'CURRENCY_NAME_032', 'Netherlands Antilles Guilder (ANG)'),
(2981, 'SYS', 'CURRENCY_CODE_033', 'BAM'),
(2982, 'SYS', 'CURRENCY_ISO_033', '977'),
(2983, 'SYS', 'CURRENCY_NAME_033', 'Bosnia and Herzegovina Marka (BAM)'),
(2984, 'SYS', 'CURRENCY_CODE_034', 'BWP'),
(2985, 'SYS', 'CURRENCY_ISO_034', '72'),
(2986, 'SYS', 'CURRENCY_NAME_034', 'Botswana Pula (BWP)'),
(2987, 'SYS', 'CURRENCY_CODE_035', 'BRL'),
(2988, 'SYS', 'CURRENCY_ISO_035', '986'),
(2989, 'SYS', 'CURRENCY_NAME_035', 'Brazilian Real (BRL)'),
(2990, 'SYS', 'CURRENCY_CODE_036', 'GBP'),
(2991, 'SYS', 'CURRENCY_ISO_036', '826'),
(2992, 'SYS', 'CURRENCY_NAME_036', 'British Pound (GBP)'),
(2993, 'SYS', 'CURRENCY_CODE_040', 'BND'),
(2994, 'SYS', 'CURRENCY_ISO_040', '96'),
(2995, 'SYS', 'CURRENCY_NAME_040', 'Brunei Dollar (BND)'),
(2996, 'SYS', 'CURRENCY_CODE_041', 'SGD'),
(2997, 'SYS', 'CURRENCY_ISO_041', '702'),
(2998, 'SYS', 'CURRENCY_NAME_041', 'Singapore Dollar (SGD)'),
(2999, 'SYS', 'CURRENCY_CODE_042', 'BGN'),
(3000, 'SYS', 'CURRENCY_ISO_042', '975'),
(3001, 'SYS', 'CURRENCY_NAME_042', 'Bulgarian Lev (BGN)'),
(3002, 'SYS', 'CURRENCY_CODE_044', 'MMK'),
(3003, 'SYS', 'CURRENCY_ISO_044', '104'),
(3004, 'SYS', 'CURRENCY_NAME_044', 'Myanma Kyat (MMK)'),
(3005, 'SYS', 'CURRENCY_CODE_045', 'BIF'),
(3006, 'SYS', 'CURRENCY_ISO_045', '108'),
(3007, 'SYS', 'CURRENCY_NAME_045', 'Burundi Franc (BIF)'),
(3008, 'SYS', 'CURRENCY_CODE_046', 'KHR'),
(3009, 'SYS', 'CURRENCY_ISO_046', '116'),
(3010, 'SYS', 'CURRENCY_NAME_046', 'Cambodian Riel (KHR)'),
(3011, 'SYS', 'CURRENCY_CODE_047', 'XAF'),
(3012, 'SYS', 'CURRENCY_ISO_047', '950'),
(3013, 'SYS', 'CURRENCY_NAME_047', 'CFA Franc BEAC (XAF)'),
(3014, 'SYS', 'CURRENCY_CODE_048', 'CAD'),
(3015, 'SYS', 'CURRENCY_ISO_048', '124'),
(3016, 'SYS', 'CURRENCY_NAME_048', 'Canadian Dollar (CAD)'),
(3017, 'SYS', 'CURRENCY_CODE_050', 'CVE'),
(3018, 'SYS', 'CURRENCY_ISO_050', '132'),
(3019, 'SYS', 'CURRENCY_NAME_050', 'Cape Verdean Escudo (CVE)'),
(3020, 'SYS', 'CURRENCY_CODE_051', 'KYD'),
(3021, 'SYS', 'CURRENCY_ISO_051', '136'),
(3022, 'SYS', 'CURRENCY_NAME_051', 'Cayman Islands Dollar (KYD)'),
(3023, 'SYS', 'CURRENCY_CODE_056', 'CLP'),
(3024, 'SYS', 'CURRENCY_ISO_056', '152'),
(3025, 'SYS', 'CURRENCY_NAME_056', 'Chilean Peso (CLP)'),
(3026, 'SYS', 'CURRENCY_CODE_057', 'CNY'),
(3027, 'SYS', 'CURRENCY_ISO_057', '156'),
(3028, 'SYS', 'CURRENCY_NAME_057', 'Chinese Renminbi (CNY)'),
(3029, 'SYS', 'CURRENCY_CODE_061', 'COP'),
(3030, 'SYS', 'CURRENCY_ISO_061', '170'),
(3031, 'SYS', 'CURRENCY_NAME_061', 'Colombian Peso (COP)'),
(3032, 'SYS', 'CURRENCY_CODE_064', 'KMF'),
(3033, 'SYS', 'CURRENCY_ISO_064', '174'),
(3034, 'SYS', 'CURRENCY_NAME_064', 'Comorian Franc (KMF)'),
(3035, 'SYS', 'CURRENCY_CODE_067', 'CDF'),
(3036, 'SYS', 'CURRENCY_ISO_067', '976'),
(3037, 'SYS', 'CURRENCY_NAME_067', 'Congolese Franc (CDF)'),
(3038, 'SYS', 'CURRENCY_CODE_068', 'NZD'),
(3039, 'SYS', 'CURRENCY_ISO_068', '554'),
(3040, 'SYS', 'CURRENCY_NAME_068', 'New Zealand Dollar (NZD)'),
(3041, 'SYS', 'CURRENCY_CODE_070', 'CRC'),
(3042, 'SYS', 'CURRENCY_ISO_070', '188'),
(3043, 'SYS', 'CURRENCY_NAME_070', 'Costa Rican Colon (CRC)'),
(3044, 'SYS', 'CURRENCY_CODE_072', 'HRK'),
(3045, 'SYS', 'CURRENCY_ISO_072', '191'),
(3046, 'SYS', 'CURRENCY_NAME_072', 'Croatian Kuna (HRK)'),
(3047, 'SYS', 'CURRENCY_CODE_073', 'CUC'),
(3048, 'SYS', 'CURRENCY_ISO_073', '931'),
(3049, 'SYS', 'CURRENCY_NAME_073', 'Cuban Peso (CUC)'),
(3050, 'SYS', 'CURRENCY_CODE_074', 'CUP'),
(3051, 'SYS', 'CURRENCY_ISO_074', '192'),
(3052, 'SYS', 'CURRENCY_NAME_074', 'Cuban Peso (CUP)'),
(3053, 'SYS', 'CURRENCY_CODE_076', 'CYP'),
(3054, 'SYS', 'CURRENCY_ISO_076', '---'),
(3055, 'SYS', 'CURRENCY_NAME_076', 'Cyprus Pound (CYP)'),
(3056, 'SYS', 'CURRENCY_CODE_077', 'CZK'),
(3057, 'SYS', 'CURRENCY_ISO_077', '203'),
(3058, 'SYS', 'CURRENCY_NAME_077', 'Czech Koruna (CZK)'),
(3059, 'SYS', 'CURRENCY_CODE_078', 'DKK'),
(3060, 'SYS', 'CURRENCY_ISO_078', '208'),
(3061, 'SYS', 'CURRENCY_NAME_078', 'Danish Krone (DKK)'),
(3062, 'SYS', 'CURRENCY_CODE_079', 'DJF'),
(3063, 'SYS', 'CURRENCY_ISO_079', '262'),
(3064, 'SYS', 'CURRENCY_NAME_079', 'Djiboutian Franc (DJF)'),
(3065, 'SYS', 'CURRENCY_CODE_081', 'DOP'),
(3066, 'SYS', 'CURRENCY_ISO_081', '214'),
(3067, 'SYS', 'CURRENCY_NAME_081', 'Dominican Peso (DOP)'),
(3068, 'SYS', 'CURRENCY_CODE_086', 'EGP'),
(3069, 'SYS', 'CURRENCY_ISO_086', '818'),
(3070, 'SYS', 'CURRENCY_NAME_086', 'Egyptian Pound (EGP)'),
(3071, 'SYS', 'CURRENCY_CODE_087', 'SVC'),
(3072, 'SYS', 'CURRENCY_ISO_087', '222'),
(3073, 'SYS', 'CURRENCY_NAME_087', 'El Salvador Colon (SVC)'),
(3074, 'SYS', 'CURRENCY_CODE_091', 'ERN'),
(3075, 'SYS', 'CURRENCY_ISO_091', '232'),
(3076, 'SYS', 'CURRENCY_NAME_091', 'Eritrean Nakfa (ERN)'),
(3077, 'SYS', 'CURRENCY_CODE_092', 'EEK'),
(3078, 'SYS', 'CURRENCY_ISO_092', '233'),
(3079, 'SYS', 'CURRENCY_NAME_092', 'Estonian Kroon (EEK)'),
(3080, 'SYS', 'CURRENCY_CODE_093', 'ETB'),
(3081, 'SYS', 'CURRENCY_ISO_093', '230'),
(3082, 'SYS', 'CURRENCY_NAME_093', 'Ethiopian Birr (ETB)'),
(3083, 'SYS', 'CURRENCY_CODE_096', 'FKP'),
(3084, 'SYS', 'CURRENCY_ISO_096', '238'),
(3085, 'SYS', 'CURRENCY_NAME_096', 'Falkland Islands Pound (FKP)'),
(3086, 'SYS', 'CURRENCY_CODE_098', 'FJD'),
(3087, 'SYS', 'CURRENCY_ISO_098', '242'),
(3088, 'SYS', 'CURRENCY_NAME_098', 'Fijian Dollar (FJD)'),
(3089, 'SYS', 'CURRENCY_CODE_102', 'XPF'),
(3090, 'SYS', 'CURRENCY_ISO_102', '953'),
(3091, 'SYS', 'CURRENCY_NAME_102', 'CFP Franc (XPF)'),
(3092, 'SYS', 'CURRENCY_CODE_106', 'GMD'),
(3093, 'SYS', 'CURRENCY_ISO_106', '270'),
(3094, 'SYS', 'CURRENCY_NAME_106', 'Gambian Dalasi (GMD)'),
(3095, 'SYS', 'CURRENCY_CODE_107', 'ILS'),
(3096, 'SYS', 'CURRENCY_ISO_107', '376'),
(3097, 'SYS', 'CURRENCY_NAME_107', 'Israeli new Sheqel (ILS)'),
(3098, 'SYS', 'CURRENCY_CODE_108', 'GEL'),
(3099, 'SYS', 'CURRENCY_ISO_108', '981'),
(3100, 'SYS', 'CURRENCY_NAME_108', 'Georgian Lari (GEL)'),
(3101, 'SYS', 'CURRENCY_CODE_110', 'GHS'),
(3102, 'SYS', 'CURRENCY_ISO_110', '936'),
(3103, 'SYS', 'CURRENCY_NAME_110', 'Ghanaian Cedi (GHS)'),
(3104, 'SYS', 'CURRENCY_CODE_111', 'GIP'),
(3105, 'SYS', 'CURRENCY_ISO_111', '292'),
(3106, 'SYS', 'CURRENCY_NAME_111', 'Gibraltar Pound (GIP)'),
(3107, 'SYS', 'CURRENCY_CODE_112', 'XAU'),
(3108, 'SYS', 'CURRENCY_ISO_112', '959'),
(3109, 'SYS', 'CURRENCY_NAME_112', 'Gold Ounce (XAU)'),
(3110, 'SYS', 'CURRENCY_CODE_119', 'GTQ'),
(3111, 'SYS', 'CURRENCY_ISO_119', '320'),
(3112, 'SYS', 'CURRENCY_NAME_119', 'Guatemalan Quetzal (GTQ)'),
(3113, 'SYS', 'CURRENCY_CODE_120', 'GGP'),
(3114, 'SYS', 'CURRENCY_ISO_120', '---'),
(3115, 'SYS', 'CURRENCY_NAME_120', 'Guernsey Islands Pound (GGP)'),
(3116, 'SYS', 'CURRENCY_CODE_121', 'GNF'),
(3117, 'SYS', 'CURRENCY_ISO_121', '324'),
(3118, 'SYS', 'CURRENCY_NAME_121', 'Guinean Franc (GNF)'),
(3119, 'SYS', 'CURRENCY_CODE_123', 'GYD'),
(3120, 'SYS', 'CURRENCY_ISO_123', '328'),
(3121, 'SYS', 'CURRENCY_NAME_123', 'Guyanese Dollar (GYD)'),
(3122, 'SYS', 'CURRENCY_CODE_124', 'HTG'),
(3123, 'SYS', 'CURRENCY_ISO_124', '332'),
(3124, 'SYS', 'CURRENCY_NAME_124', 'Haitian Gourde (HTG)'),
(3125, 'SYS', 'CURRENCY_CODE_127', 'HNL'),
(3126, 'SYS', 'CURRENCY_ISO_127', '340'),
(3127, 'SYS', 'CURRENCY_NAME_127', 'Honduran Lempira (HNL)'),
(3128, 'SYS', 'CURRENCY_CODE_128', 'HKD'),
(3129, 'SYS', 'CURRENCY_ISO_128', '344'),
(3130, 'SYS', 'CURRENCY_NAME_128', 'Hong Kong Dollar (HKD)'),
(3131, 'SYS', 'CURRENCY_CODE_129', 'HUF'),
(3132, 'SYS', 'CURRENCY_ISO_129', '348'),
(3133, 'SYS', 'CURRENCY_NAME_129', 'Hungarian Forint (HUF)'),
(3134, 'SYS', 'CURRENCY_CODE_130', 'ISK'),
(3135, 'SYS', 'CURRENCY_ISO_130', '352'),
(3136, 'SYS', 'CURRENCY_NAME_130', 'Icelandic Krona (ISK)'),
(3137, 'SYS', 'CURRENCY_CODE_132', 'IDR'),
(3138, 'SYS', 'CURRENCY_ISO_132', '360'),
(3139, 'SYS', 'CURRENCY_NAME_132', 'Indonesian Rupiah (IDR)'),
(3140, 'SYS', 'CURRENCY_CODE_133', 'XDR'),
(3141, 'SYS', 'CURRENCY_ISO_133', '960'),
(3142, 'SYS', 'CURRENCY_NAME_133', 'IMF Special Drawing Rights (XDR)'),
(3143, 'SYS', 'CURRENCY_CODE_134', 'IRR'),
(3144, 'SYS', 'CURRENCY_ISO_134', '364'),
(3145, 'SYS', 'CURRENCY_NAME_134', 'Iranian Rial (IRR)'),
(3146, 'SYS', 'CURRENCY_CODE_135', 'IQD'),
(3147, 'SYS', 'CURRENCY_ISO_135', '368'),
(3148, 'SYS', 'CURRENCY_NAME_135', 'Iraqi Dinar (IQD)'),
(3149, 'SYS', 'CURRENCY_CODE_138', 'IMP'),
(3150, 'SYS', 'CURRENCY_ISO_138', '---'),
(3151, 'SYS', 'CURRENCY_NAME_138', 'Isle of Man Pound (IMP)'),
(3152, 'SYS', 'CURRENCY_CODE_142', 'JMD'),
(3153, 'SYS', 'CURRENCY_ISO_142', '388'),
(3154, 'SYS', 'CURRENCY_NAME_142', 'Jamaican Dollar (JMD)'),
(3155, 'SYS', 'CURRENCY_CODE_143', 'JPY'),
(3156, 'SYS', 'CURRENCY_ISO_143', '392'),
(3157, 'SYS', 'CURRENCY_NAME_143', 'Japanese Yen (JPY)'),
(3158, 'SYS', 'CURRENCY_CODE_144', 'JEP'),
(3159, 'SYS', 'CURRENCY_ISO_144', '---'),
(3160, 'SYS', 'CURRENCY_NAME_144', 'Jersey Pound (JEP)'),
(3161, 'SYS', 'CURRENCY_CODE_146', 'JOD'),
(3162, 'SYS', 'CURRENCY_ISO_146', '400'),
(3163, 'SYS', 'CURRENCY_NAME_146', 'Jordanian Dinar (JOD)'),
(3164, 'SYS', 'CURRENCY_CODE_148', 'KZT'),
(3165, 'SYS', 'CURRENCY_ISO_148', '398'),
(3166, 'SYS', 'CURRENCY_NAME_148', 'Kazakhstani Tenge (KZT)'),
(3167, 'SYS', 'CURRENCY_CODE_149', 'KES'),
(3168, 'SYS', 'CURRENCY_ISO_149', '404'),
(3169, 'SYS', 'CURRENCY_NAME_149', 'Kenyan Shilling (KES)'),
(3170, 'SYS', 'CURRENCY_CODE_151', 'KWD'),
(3171, 'SYS', 'CURRENCY_ISO_151', '414'),
(3172, 'SYS', 'CURRENCY_NAME_151', 'Kuwaiti Dinar (KWD)'),
(3173, 'SYS', 'CURRENCY_CODE_152', 'KGS'),
(3174, 'SYS', 'CURRENCY_ISO_152', '417'),
(3175, 'SYS', 'CURRENCY_NAME_152', 'Kyrgyzstani Som (KGS)'),
(3176, 'SYS', 'CURRENCY_CODE_153', 'LAK'),
(3177, 'SYS', 'CURRENCY_ISO_153', '418'),
(3178, 'SYS', 'CURRENCY_NAME_153', 'Laotian Kip (LAK)'),
(3179, 'SYS', 'CURRENCY_CODE_154', 'LVL'),
(3180, 'SYS', 'CURRENCY_ISO_154', '428'),
(3181, 'SYS', 'CURRENCY_NAME_154', 'Latvian Lats (LVL)'),
(3182, 'SYS', 'CURRENCY_CODE_155', 'LBP'),
(3183, 'SYS', 'CURRENCY_ISO_155', '422'),
(3184, 'SYS', 'CURRENCY_NAME_155', 'Lebanese Lira (LBP)'),
(3185, 'SYS', 'CURRENCY_CODE_156', 'LSL'),
(3186, 'SYS', 'CURRENCY_ISO_156', '426'),
(3187, 'SYS', 'CURRENCY_NAME_156', 'Lesotho Loti (LSL)'),
(3188, 'SYS', 'CURRENCY_CODE_157', 'LRD'),
(3189, 'SYS', 'CURRENCY_ISO_157', '430'),
(3190, 'SYS', 'CURRENCY_NAME_157', 'Liberian Dollar (LRD)'),
(3191, 'SYS', 'CURRENCY_CODE_158', 'LYD'),
(3192, 'SYS', 'CURRENCY_ISO_158', '434'),
(3193, 'SYS', 'CURRENCY_NAME_158', 'Libyan Dinar (LYD)'),
(3194, 'SYS', 'CURRENCY_CODE_159', 'CHF'),
(3195, 'SYS', 'CURRENCY_ISO_159', '756'),
(3196, 'SYS', 'CURRENCY_NAME_159', 'Switzerland Franc (CHF)'),
(3197, 'SYS', 'CURRENCY_CODE_160', 'LTL'),
(3198, 'SYS', 'CURRENCY_ISO_160', '440'),
(3199, 'SYS', 'CURRENCY_NAME_160', 'Lithuanian Litas (LTL)'),
(3200, 'SYS', 'CURRENCY_CODE_162', 'MOP'),
(3201, 'SYS', 'CURRENCY_ISO_162', '446'),
(3202, 'SYS', 'CURRENCY_NAME_162', 'Macanese Pataca (MOP)'),
(3203, 'SYS', 'CURRENCY_CODE_163', 'MKD'),
(3204, 'SYS', 'CURRENCY_ISO_163', '807'),
(3205, 'SYS', 'CURRENCY_NAME_163', 'Macedonian Denar (MKD)'),
(3206, 'SYS', 'CURRENCY_CODE_164', 'MGA'),
(3207, 'SYS', 'CURRENCY_ISO_164', '969'),
(3208, 'SYS', 'CURRENCY_NAME_164', 'Malagasy Ariary (MGA)'),
(3209, 'SYS', 'CURRENCY_CODE_166', 'MWK'),
(3210, 'SYS', 'CURRENCY_ISO_166', '454'),
(3211, 'SYS', 'CURRENCY_NAME_166', 'Malawian Kwacha (MWK)'),
(3212, 'SYS', 'CURRENCY_CODE_167', 'MYR'),
(3213, 'SYS', 'CURRENCY_ISO_167', '458'),
(3214, 'SYS', 'CURRENCY_NAME_167', 'Malaysian Ringgit (MYR)'),
(3215, 'SYS', 'CURRENCY_CODE_168', 'MVR'),
(3216, 'SYS', 'CURRENCY_ISO_168', '462'),
(3217, 'SYS', 'CURRENCY_NAME_168', 'Maldivian Rufiyaa (MVR)'),
(3218, 'SYS', 'CURRENCY_CODE_170', 'MTL'),
(3219, 'SYS', 'CURRENCY_ISO_170', '---'),
(3220, 'SYS', 'CURRENCY_NAME_170', 'Maltese Lira (MTL)'),
(3221, 'SYS', 'CURRENCY_CODE_174', 'MRO'),
(3222, 'SYS', 'CURRENCY_ISO_174', '478'),
(3223, 'SYS', 'CURRENCY_NAME_174', 'Mauritanian Ouguiya (MRO)'),
(3224, 'SYS', 'CURRENCY_CODE_175', 'MUR'),
(3225, 'SYS', 'CURRENCY_ISO_175', '480'),
(3226, 'SYS', 'CURRENCY_NAME_175', 'Mauritian Rupee (MUR)'),
(3227, 'SYS', 'CURRENCY_CODE_177', 'MXN'),
(3228, 'SYS', 'CURRENCY_ISO_177', '484'),
(3229, 'SYS', 'CURRENCY_NAME_177', 'Mexican Peso (MXN)'),
(3230, 'SYS', 'CURRENCY_CODE_180', 'MDL'),
(3231, 'SYS', 'CURRENCY_ISO_180', '498'),
(3232, 'SYS', 'CURRENCY_NAME_180', 'Moldovan Leu (MDL)'),
(3233, 'SYS', 'CURRENCY_CODE_182', 'MNT'),
(3234, 'SYS', 'CURRENCY_ISO_182', '496'),
(3235, 'SYS', 'CURRENCY_NAME_182', 'Mongolian Tugrik (MNT)'),
(3236, 'SYS', 'CURRENCY_CODE_185', 'MAD'),
(3237, 'SYS', 'CURRENCY_ISO_185', '504'),
(3238, 'SYS', 'CURRENCY_NAME_185', 'Moroccan Dirham (MAD)'),
(3239, 'SYS', 'CURRENCY_CODE_186', 'MZN'),
(3240, 'SYS', 'CURRENCY_ISO_186', '943'),
(3241, 'SYS', 'CURRENCY_NAME_186', 'Mozambican Metical (MZN)'),
(3242, 'SYS', 'CURRENCY_CODE_188', 'NAD'),
(3243, 'SYS', 'CURRENCY_ISO_188', '516'),
(3244, 'SYS', 'CURRENCY_NAME_188', 'Namibian Dollar (NAD)'),
(3245, 'SYS', 'CURRENCY_CODE_193', 'NPR'),
(3246, 'SYS', 'CURRENCY_ISO_193', '524'),
(3247, 'SYS', 'CURRENCY_NAME_193', 'Nepalese Rupee (NPR)'),
(3248, 'SYS', 'CURRENCY_CODE_198', 'NIO'),
(3249, 'SYS', 'CURRENCY_ISO_198', '558'),
(3250, 'SYS', 'CURRENCY_NAME_198', 'Nicaraguan Cordoba (NIO)'),
(3251, 'SYS', 'CURRENCY_CODE_200', 'NGN'),
(3252, 'SYS', 'CURRENCY_ISO_200', '566'),
(3253, 'SYS', 'CURRENCY_NAME_200', 'Nigerian Naira (NGN)'),
(3254, 'SYS', 'CURRENCY_CODE_203', 'KPW'),
(3255, 'SYS', 'CURRENCY_ISO_203', '408'),
(3256, 'SYS', 'CURRENCY_NAME_203', 'North Korean Won (KPW)'),
(3257, 'SYS', 'CURRENCY_CODE_205', 'NOK'),
(3258, 'SYS', 'CURRENCY_ISO_205', '578'),
(3259, 'SYS', 'CURRENCY_NAME_205', 'Norwegian Krone (NOK)'),
(3260, 'SYS', 'CURRENCY_CODE_206', 'OMR'),
(3261, 'SYS', 'CURRENCY_ISO_206', '512'),
(3262, 'SYS', 'CURRENCY_NAME_206', 'Omani Rial (OMR)'),
(3263, 'SYS', 'CURRENCY_CODE_207', 'PKR'),
(3264, 'SYS', 'CURRENCY_ISO_207', '586'),
(3265, 'SYS', 'CURRENCY_NAME_207', 'Pakistani Rupee (PKR)'),
(3266, 'SYS', 'CURRENCY_CODE_209', 'XPD'),
(3267, 'SYS', 'CURRENCY_ISO_209', '964'),
(3268, 'SYS', 'CURRENCY_NAME_209', 'Palladium Ounce (XPD)'),
(3269, 'SYS', 'CURRENCY_CODE_210', 'PAB'),
(3270, 'SYS', 'CURRENCY_ISO_210', '590'),
(3271, 'SYS', 'CURRENCY_NAME_210', 'Panamanian Balboa (PAB)'),
(3272, 'SYS', 'CURRENCY_CODE_212', 'PGK'),
(3273, 'SYS', 'CURRENCY_ISO_212', '598'),
(3274, 'SYS', 'CURRENCY_NAME_212', 'Papua New Guinean Kina (PGK)'),
(3275, 'SYS', 'CURRENCY_CODE_214', 'VND'),
(3276, 'SYS', 'CURRENCY_ISO_214', '704'),
(3277, 'SYS', 'CURRENCY_NAME_214', 'Vietnamese Dong (VND)'),
(3278, 'SYS', 'CURRENCY_CODE_215', 'PYG'),
(3279, 'SYS', 'CURRENCY_ISO_215', '600'),
(3280, 'SYS', 'CURRENCY_NAME_215', 'Paraguayan Guarani (PYG)'),
(3281, 'SYS', 'CURRENCY_CODE_216', 'PEN'),
(3282, 'SYS', 'CURRENCY_ISO_216', '604'),
(3283, 'SYS', 'CURRENCY_NAME_216', 'Peruvian Nuevo Sol (PEN)'),
(3284, 'SYS', 'CURRENCY_CODE_217', 'PHP'),
(3285, 'SYS', 'CURRENCY_ISO_217', '608'),
(3286, 'SYS', 'CURRENCY_NAME_217', 'Philippine Peso (PHP)'),
(3287, 'SYS', 'CURRENCY_CODE_219', 'XPT'),
(3288, 'SYS', 'CURRENCY_ISO_219', '962'),
(3289, 'SYS', 'CURRENCY_NAME_219', 'Platinum Ounce (XPT)'),
(3290, 'SYS', 'CURRENCY_CODE_220', 'PLN'),
(3291, 'SYS', 'CURRENCY_ISO_220', '985'),
(3292, 'SYS', 'CURRENCY_NAME_220', 'Polish Zloty (PLN)'),
(3293, 'SYS', 'CURRENCY_CODE_223', 'QAR'),
(3294, 'SYS', 'CURRENCY_ISO_223', '634'),
(3295, 'SYS', 'CURRENCY_NAME_223', 'Qatari Riyal (QAR)'),
(3296, 'SYS', 'CURRENCY_CODE_225', 'RON'),
(3297, 'SYS', 'CURRENCY_ISO_225', '946'),
(3298, 'SYS', 'CURRENCY_NAME_225', 'Romanian Leu (RON)'),
(3299, 'SYS', 'CURRENCY_CODE_226', 'ROL'),
(3300, 'SYS', 'CURRENCY_ISO_226', '---'),
(3301, 'SYS', 'CURRENCY_NAME_226', 'Romanian Leu (ROL)'),
(3302, 'SYS', 'CURRENCY_CODE_227', 'RUB'),
(3303, 'SYS', 'CURRENCY_ISO_227', '643'),
(3304, 'SYS', 'CURRENCY_NAME_227', 'Russian Ruble (RUB)'),
(3305, 'SYS', 'CURRENCY_CODE_228', 'RWF'),
(3306, 'SYS', 'CURRENCY_ISO_228', '646'),
(3307, 'SYS', 'CURRENCY_NAME_228', 'Rwandan Franc (RWF)'),
(3308, 'SYS', 'CURRENCY_CODE_230', 'SHP'),
(3309, 'SYS', 'CURRENCY_ISO_230', '654'),
(3310, 'SYS', 'CURRENCY_NAME_230', 'Saint Helena Pound (SHP)'),
(3311, 'SYS', 'CURRENCY_CODE_236', 'WST'),
(3312, 'SYS', 'CURRENCY_ISO_236', '882'),
(3313, 'SYS', 'CURRENCY_NAME_236', 'Samoan Tala (WST)'),
(3314, 'SYS', 'CURRENCY_CODE_238', 'STD'),
(3315, 'SYS', 'CURRENCY_ISO_238', '678'),
(3316, 'SYS', 'CURRENCY_NAME_238', 'Sao Tome and Principe Dobra (STD)'),
(3317, 'SYS', 'CURRENCY_CODE_239', 'SAR'),
(3318, 'SYS', 'CURRENCY_ISO_239', '682'),
(3319, 'SYS', 'CURRENCY_NAME_239', 'Saudi Riyal (SAR)'),
(3320, 'SYS', 'CURRENCY_CODE_241', 'SPL'),
(3321, 'SYS', 'CURRENCY_ISO_241', '---'),
(3322, 'SYS', 'CURRENCY_NAME_241', 'Senegal Luigino (SPL)'),
(3323, 'SYS', 'CURRENCY_CODE_243', 'RSD'),
(3324, 'SYS', 'CURRENCY_ISO_243', '941'),
(3325, 'SYS', 'CURRENCY_NAME_243', 'Serbian Dinar (RSD)'),
(3326, 'SYS', 'CURRENCY_CODE_244', 'SCR'),
(3327, 'SYS', 'CURRENCY_ISO_244', '690'),
(3328, 'SYS', 'CURRENCY_NAME_244', 'Seychellois Rupee (SCR)'),
(3329, 'SYS', 'CURRENCY_CODE_245', 'SLL'),
(3330, 'SYS', 'CURRENCY_ISO_245', '694'),
(3331, 'SYS', 'CURRENCY_NAME_245', 'Sierra Leonean Leone (SLL)'),
(3332, 'SYS', 'CURRENCY_CODE_246', 'XAG'),
(3333, 'SYS', 'CURRENCY_ISO_246', '961'),
(3334, 'SYS', 'CURRENCY_NAME_246', 'Silver Ounce (XAG)'),
(3335, 'SYS', 'CURRENCY_CODE_250', 'SKK'),
(3336, 'SYS', 'CURRENCY_ISO_250', '---'),
(3337, 'SYS', 'CURRENCY_NAME_250', 'Slovak Koruna (SKK)'),
(3338, 'SYS', 'CURRENCY_CODE_251', 'SIT'),
(3339, 'SYS', 'CURRENCY_ISO_251', '---'),
(3340, 'SYS', 'CURRENCY_NAME_251', 'Slovenain Tolar (SIT)'),
(3341, 'SYS', 'CURRENCY_CODE_252', 'SBD'),
(3342, 'SYS', 'CURRENCY_ISO_252', '90'),
(3343, 'SYS', 'CURRENCY_NAME_252', 'Solomon Islands Dollar (SBD)'),
(3344, 'SYS', 'CURRENCY_CODE_253', 'SOS'),
(3345, 'SYS', 'CURRENCY_ISO_253', '706'),
(3346, 'SYS', 'CURRENCY_NAME_253', 'Somali Shilling (SOS)'),
(3347, 'SYS', 'CURRENCY_CODE_254', 'ZAR'),
(3348, 'SYS', 'CURRENCY_ISO_254', '710'),
(3349, 'SYS', 'CURRENCY_NAME_254', 'South African Rand (ZAR)'),
(3350, 'SYS', 'CURRENCY_CODE_256', 'KRW'),
(3351, 'SYS', 'CURRENCY_ISO_256', '410'),
(3352, 'SYS', 'CURRENCY_NAME_256', 'South Korean Won (KRW)'),
(3353, 'SYS', 'CURRENCY_CODE_259', 'LKR'),
(3354, 'SYS', 'CURRENCY_ISO_259', '144'),
(3355, 'SYS', 'CURRENCY_NAME_259', 'Sri Lankan Rupee (LKR)'),
(3356, 'SYS', 'CURRENCY_CODE_260', 'SDG'),
(3357, 'SYS', 'CURRENCY_ISO_260', '938'),
(3358, 'SYS', 'CURRENCY_NAME_260', 'Sudan Dinar (SDG)'),
(3359, 'SYS', 'CURRENCY_CODE_261', 'SRD'),
(3360, 'SYS', 'CURRENCY_ISO_261', '968'),
(3361, 'SYS', 'CURRENCY_NAME_261', 'Surinamese Dollar (SRD)'),
(3362, 'SYS', 'CURRENCY_CODE_263', 'SZL'),
(3363, 'SYS', 'CURRENCY_ISO_263', '748'),
(3364, 'SYS', 'CURRENCY_NAME_263', 'Swazi Lilangeni (SZL)'),
(3365, 'SYS', 'CURRENCY_CODE_265', 'SEK'),
(3366, 'SYS', 'CURRENCY_ISO_265', '752'),
(3367, 'SYS', 'CURRENCY_NAME_265', 'Swedish Krona (SEK)'),
(3368, 'SYS', 'CURRENCY_CODE_267', 'SYP'),
(3369, 'SYS', 'CURRENCY_ISO_267', '760'),
(3370, 'SYS', 'CURRENCY_NAME_267', 'Syrian Pound (SYP)'),
(3371, 'SYS', 'CURRENCY_CODE_268', 'TWD'),
(3372, 'SYS', 'CURRENCY_ISO_268', '901'),
(3373, 'SYS', 'CURRENCY_NAME_268', 'New Taiwan Dollar (TWD)'),
(3374, 'SYS', 'CURRENCY_CODE_269', 'TJS'),
(3375, 'SYS', 'CURRENCY_ISO_269', '972'),
(3376, 'SYS', 'CURRENCY_NAME_269', 'Tajikistani Somoni (TJS)'),
(3377, 'SYS', 'CURRENCY_CODE_271', 'TZS'),
(3378, 'SYS', 'CURRENCY_ISO_271', '834'),
(3379, 'SYS', 'CURRENCY_NAME_271', 'Tanzanian Shilling (TZS)'),
(3380, 'SYS', 'CURRENCY_CODE_272', 'THB'),
(3381, 'SYS', 'CURRENCY_ISO_272', '764'),
(3382, 'SYS', 'CURRENCY_NAME_272', 'Thai Baht (THB)'),
(3383, 'SYS', 'CURRENCY_CODE_275', 'TOP'),
(3384, 'SYS', 'CURRENCY_ISO_275', '776'),
(3385, 'SYS', 'CURRENCY_NAME_275', 'Tongan Pa''anga (TOP)'),
(3386, 'SYS', 'CURRENCY_CODE_277', 'TTD'),
(3387, 'SYS', 'CURRENCY_ISO_277', '780'),
(3388, 'SYS', 'CURRENCY_NAME_277', 'Trinidad and Tobago Dollar (TTD)'),
(3389, 'SYS', 'CURRENCY_CODE_278', 'TND'),
(3390, 'SYS', 'CURRENCY_ISO_278', '788'),
(3391, 'SYS', 'CURRENCY_NAME_278', 'Tunisian Dinar (TND)'),
(3392, 'SYS', 'CURRENCY_CODE_279', 'TRY'),
(3393, 'SYS', 'CURRENCY_ISO_279', '949'),
(3394, 'SYS', 'CURRENCY_NAME_279', 'Turkish new Lira (TRY)'),
(3395, 'SYS', 'CURRENCY_CODE_280', 'TRL'),
(3396, 'SYS', 'CURRENCY_ISO_280', '---'),
(3397, 'SYS', 'CURRENCY_NAME_280', 'Turkish Lira (TRL)'),
(3398, 'SYS', 'CURRENCY_CODE_281', 'TMM'),
(3399, 'SYS', 'CURRENCY_ISO_281', '934'),
(3400, 'SYS', 'CURRENCY_NAME_281', 'Turkmenistan Manat (TMM)'),
(3401, 'SYS', 'CURRENCY_CODE_284', 'TVD'),
(3402, 'SYS', 'CURRENCY_ISO_284', '---'),
(3403, 'SYS', 'CURRENCY_NAME_284', 'Tuvalu Dollar (TVD)'),
(3404, 'SYS', 'CURRENCY_CODE_285', 'UGX'),
(3405, 'SYS', 'CURRENCY_ISO_285', '800'),
(3406, 'SYS', 'CURRENCY_NAME_285', 'Ugandan Shilling (UGX)'),
(3407, 'SYS', 'CURRENCY_CODE_286', 'UAH'),
(3408, 'SYS', 'CURRENCY_ISO_286', '980'),
(3409, 'SYS', 'CURRENCY_NAME_286', 'Ukrainian Hryvnia (UAH)'),
(3410, 'SYS', 'CURRENCY_CODE_287', 'AED'),
(3411, 'SYS', 'CURRENCY_ISO_287', '784'),
(3412, 'SYS', 'CURRENCY_NAME_287', 'UAE Dirham (AED)'),
(3413, 'SYS', 'CURRENCY_CODE_290', 'UYU'),
(3414, 'SYS', 'CURRENCY_ISO_290', '858'),
(3415, 'SYS', 'CURRENCY_NAME_290', 'Uruguayan Peso (UYU)'),
(3416, 'SYS', 'CURRENCY_CODE_291', 'UZS'),
(3417, 'SYS', 'CURRENCY_ISO_291', '860'),
(3418, 'SYS', 'CURRENCY_NAME_291', 'Uzbekistani Som (UZS)'),
(3419, 'SYS', 'CURRENCY_CODE_292', 'VUV'),
(3420, 'SYS', 'CURRENCY_ISO_292', '548'),
(3421, 'SYS', 'CURRENCY_NAME_292', 'Vanuatu Vatu (VUV)'),
(3422, 'SYS', 'CURRENCY_CODE_294', 'VEF'),
(3423, 'SYS', 'CURRENCY_ISO_294', '937'),
(3424, 'SYS', 'CURRENCY_NAME_294', 'Venezuelan Bolivar Fuerte (VEF)'),
(3425, 'SYS', 'CURRENCY_CODE_303', 'YER'),
(3426, 'SYS', 'CURRENCY_ISO_303', '886'),
(3427, 'SYS', 'CURRENCY_NAME_303', 'Yemeni Rial (YER)'),
(3428, 'SYS', 'CURRENCY_CODE_304', 'ZMK'),
(3429, 'SYS', 'CURRENCY_ISO_304', '894'),
(3430, 'SYS', 'CURRENCY_NAME_304', 'Zambian Kwacha (ZMK)'),
(3431, 'SYS', 'CURRENCY_CODE_305', 'ZWL'),
(3432, 'SYS', 'CURRENCY_ISO_305', '932'),
(3433, 'SYS', 'CURRENCY_NAME_305', 'Zimbabwean Dollar (ZWL)'),
(3434, 'SYS', 'MDMNGR_001', 'Missing main file for module (API).'),
(3435, 'SYS', 'MDMNGR_002', 'Missing Action-file for module.'),
(3436, 'SYS', 'MDMNGR_003', 'Missing View-file(CZ) for module.'),
(3437, 'SYS', 'MDMNGR_004', 'Missing View-file(AZ) for module.'),
(3438, 'SYS', 'MDMNGR_005', 'Error in module structure. Method ''install'' not declared.'),
(3439, 'SYS', 'MDMNGR_006', 'Error in module structure. Method ''uninstall'' not declared.'),
(3440, 'SYS', 'CURRENCY_FIELD', 'Please enter a numerical value. E.g. {0}, {1}, {2}.'),
(3441, 'SYS', 'ITEM_FIELD', 'Please enter an integer value. E.g. 12, 34, 78, 56.'),
(3442, 'SYS', 'WEIGHT_FIELD', 'Please enter a numerical value. E.g. {0}, {1}, {2}.'),
(3443, 'SYS', 'WEIGHT_PAGE_TITLE', 'Store Configuration'),
(3444, 'SYS', 'WEIGHT_PAGE_SUBTITLE', 'Weight Unit'),
(3445, 'SYS', 'WEIGHT_FIELD_001', 'Weight unit notation'),
(3446, 'SYS', 'WEIGHT_FIELD_002', 'Ratio for converting to kilograms'),
(3447, 'SYS', 'WEIGHT_UNIT', 'lb'),
(3448, 'SYS', 'MSG_WEIGHT_UPDATED', 'Weight output format has been updated.'),
(3449, 'SYS', 'OWNER_PROFILE_PAGE_TITLE', 'Store Configuration'),
(3450, 'SYS', 'OWNER_PROFILE_PAGE_SUBTITLE', 'Store Owner''s Profile'),
(3451, 'SYS', 'MSG_OWNER_PROFILE_UPDATED', 'Store Owner''s Profile updated.'),
(3452, 'SYS', 'OWNER_PROFILE_FIELD_000', 'Common Store Page Title'),
(3453, 'SYS', 'OWNER_PROFILE_FIELD_000_DESCR', 'This is the common title for your online store pages.'),
(3454, 'SYS', 'OWNER_PROFILE_FIELD_001', 'Name'),
(3455, 'SYS', 'OWNER_PROFILE_FIELD_001_DESCR', 'This is the name of your online store, for example, &quot;Avactis Online Store&quot;.<BR>This name appears in the From field of all e-mails sent to your customers.'),
(3456, 'SYS', 'OWNER_PROFILE_FIELD_002', 'Website'),
(3457, 'SYS', 'OWNER_PROFILE_FIELD_002_DESCR', 'The URL of your online store.<BR>For example, <a href=''http://www.avactis.com''>http://www.avactis.com</a>'),
(3458, 'SYS', 'OWNER_PROFILE_FIELD_003', 'Phones'),
(3459, 'SYS', 'OWNER_PROFILE_FIELD_004', 'Fax'),
(3460, 'SYS', 'OWNER_PROFILE_FIELD_005', 'Address Line 1'),
(3461, 'SYS', 'OWNER_PROFILE_FIELD_006', 'Address Line 2'),
(3462, 'SYS', 'OWNER_PROFILE_FIELD_007', 'City'),
(3463, 'SYS', 'OWNER_PROFILE_FIELD_008', 'State'),
(3464, 'SYS', 'OWNER_PROFILE_FIELD_009', 'ZIP Code'),
(3465, 'SYS', 'OWNER_PROFILE_FIELD_010', 'Country'),
(3466, 'SYS', 'OWNER_PROFILE_FIELD_011', 'Store e-mail address'),
(3467, 'SYS', 'OWNER_PROFILE_FIELD_011_DESCR', 'The e-mail address of your store. This address also appears in the From field of all e-mails sent to your customers as well as to the administrator and the order-processing department.'),
(3468, 'SYS', 'OWNER_PROFILE_FIELD_012', 'Site administrator e-mail address'),
(3469, 'SYS', 'OWNER_PROFILE_FIELD_012_DESCR', 'The site administrator''s e-mail address. This address receives all automated messages from the online store. Automated messages include information about attempts at unauthorized access, low stock levels of products, new orders placed, etc.'),
(3470, 'SYS', 'OWNER_PROFILE_FIELD_013', 'Orders department e-mail address'),
(3471, 'SYS', 'OWNER_PROFILE_FIELD_013_DESCR', 'The e-mail address of the order-processing department. This address receives all automated messages from the online store that concern low stock levels of products, new orders placed, changes in order status, etc.'),
(3472, 'SYS', 'OWNER_PROFILE_FIELD_014', 'The ''From'' text for store e-mails'),
(3473, 'SYS', 'OWNER_PROFILE_FIELD_014_DESCR', 'This text appears in the From field of all e-mails sent to your customers as well as to the administrator and the order-processing department.'),
(3474, 'SYS', 'OWNER_PROFILE_FIELD_015', 'The ''From'' text for site administrator e-mails'),
(3475, 'SYS', 'OWNER_PROFILE_FIELD_015_DESCR', 'This text appears in the From field of all e-mails sent on behalf of the site administrator.'),
(3476, 'SYS', 'OWNER_PROFILE_FIELD_016', 'The ''From'' text for order processing department e-mails'),
(3477, 'SYS', 'OWNER_PROFILE_FIELD_016_DESCR', 'This text appears in the From field of all e-mails sent on behalf of the of the order-processing department.'),
(3478, 'SYS', 'OWNER_PROFILE_FIELD_017', 'From'),
(3479, 'SYS', 'OWNER_PROFILE_FIELD_018', 'E-mail Address'),
(3480, 'SYS', 'OWNER_PROFILE_WRN_001', 'Store e-mail address is not valid.'),
(3481, 'SYS', 'OWNER_PROFILE_WRN_002', 'Site administrator\\''s e-mail address is not valid.'),
(3482, 'SYS', 'OWNER_PROFILE_WRN_003', 'Orders department e-mail address is not valid.'),
(3483, 'SYS', 'AZ_STORE_SETTINGS_GENERAL_SETTINGS_PAGE_TITLE', 'General Settings'),
(3484, 'SYS', 'AZ_STORE_SETTINGS_STORE_OWNER_PROFILE_PAGE_TITLE', 'Store Owner''s Profile'),
(3485, 'SYS', 'GNRL_SET_ONLINE_LABEL', 'Online'),
(3486, 'SYS', 'GNRL_SET_CLOSED_LABEL', 'Closed'),
(3487, 'SYS', 'GNRL_SET_YES_LABEL', 'Yes'),
(3488, 'SYS', 'GNRL_SET_NO_LABEL', 'No'),
(3489, 'SYS', 'CORE_022_3INI', 'Directive is inconsistent with description format for product types {1[,2,3]} or {default}.'),
(3490, 'SYS', 'PRD_TAX_CLS_PAGE_NAME', 'Store Configuration'),
(3491, 'SYS', 'PRD_TAX_CLS_PAGE_SUBTITLE', 'Product Tax Classes'),
(3492, 'SYS', 'PRD_TAX_CLS_HEADER_001', 'Name'),
(3493, 'SYS', 'PRD_TAX_CLS_HEADER_002', 'Description'),
(3494, 'SYS', 'PRD_TAX_CLS_NA_DESCR', 'Product Tax Classes are undefined'),
(3495, 'SYS', 'PRD_TAX_CLS_TITLE_ADD', 'Add Product Tax Class'),
(3496, 'SYS', 'PRD_TAX_CLS_TITLE_EDIT', 'Edit Product Tax Class'),
(3497, 'SYS', 'PRD_TAX_CLS_FIELD_001', 'Product Tax Class Name'),
(3498, 'SYS', 'PRD_TAX_CLS_FIELD_002', 'Product Tax Class Description'),
(3499, 'SYS', 'PRD_TAX_CLS_WRN_001', 'Please select Product Tax Class first.'),
(3500, 'SYS', 'PRD_TAX_CLS_WRN_002', 'The \\''Product Tax Class Name\\'' is a required field.'),
(3501, 'SYS', 'PRD_TAX_CLS_WRN_003', 'Are you sure that you want to delete this Product Tax Class?'),
(3502, 'SYS', 'PRD_TAX_CLS_NAME_001', 'Nontaxable'),
(3503, 'SYS', 'PRD_TAX_CLS_DESCR_001', 'Nontaxable Products'),
(3504, 'SYS', 'PRD_TAX_CLS_NAME_002', 'Taxable'),
(3505, 'SYS', 'PRD_TAX_CLS_DESCR_002', 'Taxable Products'),
(3506, 'SYS', 'PRD_TAX_CLS_ADD_LINK', 'Add Product Tax Class'),
(3507, 'SYS', 'TAXES_PAGE_NAME', 'Taxes'),
(3508, 'SYS', 'TAX_CALCULATOR', 'Tax Calculator'),
(3509, 'SYS', 'TAXES_PAGE_WRN_001', 'Tax Name to be deleted is not selected or does not exist.'),
(3510, 'SYS', 'TAXES_PAGE_WRN_002', 'Are you sure that you want to delete the tax \\''{TaxName}\\''?\\n Deletion of this tax will cause it to be deleted from the table Tax Display Options and the table Tax Rates.'),
(3511, 'SYS', 'TAXES_PAGE_WRN_003', 'Tax Display Option to be deleted is not selected or does not exist.'),
(3512, 'SYS', 'TAXES_PAGE_WRN_004', 'Are you sure that you want to delete this Tax Display Option?'),
(3513, 'SYS', 'TAXES_PAGE_WRN_005', 'Tax Rate to be deleted is not selected or does not exist.'),
(3514, 'SYS', 'TAXES_PAGE_WRN_006', 'Are you sure that you want to delete this Tax Rate?'),
(3515, 'SYS', 'TAXES_PAGE_WRN_007', 'This tax cannot be deleted since that would result in a cyclic dependency in tax calculations.'),
(3516, 'SYS', 'TAXES_PAGE_WRN_008', 'Please select Tax Class first.'),
(3517, 'SYS', 'TAXES_PAGE_WRN_009', 'Are you sure that you want to delete \\''{TaxClass}\\'' Tax Class?\\nDeletion of this tax class will result in the deletion of tax rates in addition,\\nattributes of products belonging to tax class \\''Product Tax Class\\'' will be changed to \\''Non-Taxable\\''.'),
(3518, 'SYS', 'TAXES_PAGE_WRN_010', 'This Tax Class cannot be deleted.'),
(3519, 'SYS', 'TAXES_PAGE_WRN_011', 'Cannot add a Tax Rate since no taxes are defined in the system.'),
(3520, 'SYS', 'TAXES_PAGE_WRN_012', 'Tax Rate to be edited is not selected or does not exist.'),
(3521, 'SYS', 'TAXES_PAGE_WRN_013', 'Tax Display Option to be edited is not selected or does not exist.'),
(3522, 'SYS', 'TAXES_PAGE_WRN_014', 'Tax Name to be edited is not selected or does not exist.'),
(3523, 'SYS', 'TAXES_PAGE_WRN_015', 'To define Tax Display Options, first you should define the Tax Names.'),
(3524, 'SYS', 'TAXES_DISPLAY_PRICES_W_INCLUDED_TAXES_PARAM_NAME', 'Display product prices including taxes'),
(3525, 'SYS', 'TAXES_DISPLAY_PRICES_W_INCLUDED_TAXES_PARAM_DESCRIPTION', 'Display product prices including taxes in Product List, Product Info, Shopping Cart, and Checkout pages of storefront.<br /><br />NOTE: This option only affects taxes included in the product prices.'),
(3526, 'SYS', 'MANAGE_TAXES_TITLE', 'Manage Taxes'),
(3527, 'SYS', 'MANAGE_TAXES_MESSAGE', 'This page allows you to define tax settings. Use the Tax Names section to create names for taxes that will be used in your online store. Use the Tax Display Options section to determine how these taxes will display to your customers. Then, create Product Tax Classes, which will be used when you enter products into the catalog. Finally, in the Tax Rates section, define tax formulas for each Product Tax Class. For more details, see Page Help at any time.'),
(3528, 'SYS', 'TAX_NAMES_TITLE', 'Tax Names'),
(3529, 'SYS', 'TAX_NAMES_HEADER_001', 'Name'),
(3530, 'SYS', 'TAX_NAMES_HEADER_002', 'Address To Use'),
(3531, 'SYS', 'TAX_NAMES_HEADER_003', 'Included Into Product Price'),
(3532, 'SYS', 'TAX_NAMES_ITEMS_NA', 'Tax Names are not defined'),
(3533, 'SYS', 'TAX_ADDRESS_NAME_001', 'Shipping Address'),
(3534, 'SYS', 'TAX_ADDRESS_NAME_002', 'Billing Address'),
(3535, 'SYS', 'TAX_ADDRESS_NAME_003', 'Store Owner Address'),
(3536, 'SYS', 'ADD_TAX_NAME_PAGE_TITLE', 'Add Tax Name'),
(3537, 'SYS', 'ADD_TAX_NAME_PAGE_NAME', 'Taxes'),
(3538, 'SYS', 'ADD_TAX_NAME_PAGE_SUBTITLE', 'Add Tax Name'),
(3539, 'SYS', 'ADD_TAX_NAME_FIELD_001', 'Tax Name'),
(3540, 'SYS', 'ADD_TAX_NAME_FIELD_001_DESCR', 'The name of the tax for which the rule is being defined. Examples of tax names:<br>Sales Tax<BR>GST<BR>PST<BR>HST<BR>VAT'),
(3541, 'SYS', 'ADD_TAX_NAME_FIELD_003', 'Included Into Product Price'),
(3542, 'SYS', 'ADD_TAX_NAME_FIELD_003_DESCR', 'Click here if the prices you enter for products in this tax category include the tax.'),
(3543, 'SYS', 'ADD_TAX_NAME_FIELD_002', 'Address To Use'),
(3544, 'SYS', 'ADD_TAX_NAME_FIELD_002_DESCR', 'The type of address for which the tax is defined.<BR><BR>For example, if the tax applies to Shipping Address, then only the recipient''s address will be taken into account for tax calculation purposes - regardless of the payer''s address (Billing Address). Shipping Address is entered by the customer at the time of purchase.<BR><BR>If the tax applies to Billing Address, then the tax is calculated only with regard to the payer''s address, regardless of the shipping location. Using the Billing or Shipping Addresses for tax calculation depends on the tax jurisdiction where your business is registered. For example, in most of the United States, if an article is shipped outside the state, no tax is charged. If the article is shipped within the state, a tax is charged even if the payer is located in another state. Thus, the example shows how a tax can be applied to Shipping Address.'),
(3545, 'SYS', 'ADD_TAX_NAME_WRN_001', '\\''Tax Name\\'' is a required field.'),
(3546, 'SYS', 'EDIT_TAX_NAME_PAGE_TITLE', 'Edit Tax Name'),
(3547, 'SYS', 'EDIT_TAX_NAME_PAGE_SUBTITLE', 'Edit Tax Name'),
(3548, 'SYS', 'TAX_DISPLAY_TITLE', 'Tax Display Options'),
(3549, 'SYS', 'TAX_DISPLAY_HEADER_001', 'Tax &amp; Display Rule'),
(3550, 'SYS', 'TAX_DISPLAY_HEADER_002', 'Displayed Text'),
(3551, 'SYS', 'TAX_DISPLAY_ITEMS_NA', 'Tax Display Options are not defined'),
(3552, 'SYS', 'TAX_DISPLAY_OPTION_001', '(always display)'),
(3553, 'SYS', 'TAX_DISPLAY_OPTION_002', '(display if applicable)'),
(3554, 'SYS', 'TAX_DISPLAY_OPTION_003', '(never display)'),
(3555, 'SYS', 'ADD_TAX_DISPLAY_OPTION_PAGE_TITLE', 'Add Tax Display Options'),
(3556, 'SYS', 'ADD_TAX_DISPLAY_OPTION_PAGE_NAME', 'Taxes'),
(3557, 'SYS', 'ADD_TAX_DISPLAY_OPTION_PAGE_SUBTITLE', 'Add Tax Display Options'),
(3558, 'SYS', 'ADD_TAX_DISPLAY_OPTION_FIELD_001', 'Tax &amp; Display Rule'),
(3559, 'SYS', 'ADD_TAX_DISPLAY_OPTION_FIELD_001_DESCR', 'Displays the tax name and the rules for displaying the tax to store visitors during checkout.<BR><BR>Use the Select Tax drop-down menu to select the tax for editing its display rule. Use the Select Option menu to select the condition for displaying this tax to store visitors during checkout.<BR><BR>Options:<BR>always display - the tax will always be displayed even if its amount equals zero and/or if it is not applicable.<BR><BR>display if applicable - the tax will be displayed only if it is applicable to the order<BR><BR>never display - the tax will not be displayed in any situation<BR><BR>After selecting the tax and its display rule, click Add. The tax and the display rule will be shown in the Tax & Display Rule line. If you want to delete the tax and its display rule, click Clear.<BR><BR>Note: These options matter only for displaying the tax. If a tax is defined for the current tax jurisdiction and the &quot;never display&quot; option is selected, then the tax will still be calculated and included in the total tax amount - even though it will not be visible to the customer.'),
(3560, 'SYS', 'ADD_TAX_DISPLAY_OPTION_FIELD_002', 'Displayed Text (visible to customer)'),
(3561, 'SYS', 'ADD_TAX_DISPLAY_OPTION_FIELD_002_DESCR', 'This box is used for recording the text that will be shown to store visitors during checkout. Examples:<BR>- Sales Tax<BR>- Tax<BR>- VAT<BR>- GST<BR>- PST<BR>- HST'),
(3562, 'SYS', 'ADD_TAX_DISPLAY_OPTION_FIELD_003', 'Select Tax:'),
(3563, 'SYS', 'ADD_TAX_DISPLAY_OPTION_FIELD_004', 'Select Option:'),
(3564, 'SYS', 'ADD_TAX_DISPLAY_OPTION_WRN_001', '\\''Tax &amp; Display Rule\\'' and \\Displayed Text\\'' are required fields.'),
(3565, 'SYS', 'EDIT_TAX_DISPLAY_OPTION_PAGE_TITLE', 'Edit Tax Display Options'),
(3566, 'SYS', 'EDIT_TAX_DISPLAY_OPTION_PAGE_SUBTITLE', 'Edit Tax Display Options'),
(3567, 'SYS', 'TAX_CLASSES_TITLE', 'Product Tax Classes'),
(3568, 'SYS', 'TAX_CLASS_HEADER_001', 'Product Tax Class'),
(3569, 'SYS', 'TAX_CLASS_HEADER_002', 'Description'),
(3570, 'SYS', 'ADD_TAX_CLASS_PAGE_TITLE', 'Add Prouct Tax Class'),
(3571, 'SYS', 'ADD_TAX_CLASS_PAGE_NAME', 'Taxes'),
(3572, 'SYS', 'ADD_TAX_CLASS_PAGE_SUBTITLE', 'Add Product Tax Class'),
(3573, 'SYS', 'ADD_TAX_CLASS_FIELD_001', 'Product Tax Class Name'),
(3574, 'SYS', 'ADD_TAX_CLASS_FIELD_001_DESCR', 'The name of the Tax Class for a product which links it with a particular category of taxes.<BR>Examples:<BR>1% Sales Tax<BR>7% Sales Tax<BR>Nontaxable<BR>Taxable<BR>15% VAT<BR>'),
(3575, 'SYS', 'ADD_TAX_CLASS_FIELD_002', 'Product Tax Class Description'),
(3576, 'SYS', 'ADD_TAX_CLASS_FIELD_002_DESCR', 'A short description for a Tax Class.<BR>Examples:<BR>Taxable Products - 1% Sales Tax<BR>Taxable Products - 7% Sales Tax<BR>Nontaxable Products<BR>Taxable Products<BR>'),
(3577, 'SYS', 'ADD_TAX_CLASS_WRN_001', 'The field \\''Product Tax Class Name\\'' must be filled in.'),
(3578, 'SYS', 'EDIT_TAX_CLASS_PAGE_TITLE', 'Edit Product Tax Class'),
(3579, 'SYS', 'EDIT_TAX_CLASS_PAGE_SUBTITLE', 'Edit Product Tax Class'),
(3580, 'SYS', 'TAX_SHIPPING_TITLE', 'Tax Rules on Shipping Costs'),
(3581, 'SYS', 'TAX_SHIPPING_DESCRIPTION', 'DON''T apply taxes to shipping charges if shipping cost is calculated by this method:'),
(3582, 'SYS', 'EDIT_TAX_SHIPPING_TITLE', 'Tax Rules on Shipping Costs'),
(3583, 'SYS', 'EDIT_TAX_SHIPPING_SUBTITLE', 'List of Shipping Methods'),
(3584, 'SYS', 'EDIT_TAX_SHIPPING_HEADER_001', 'Select Shipping Method(s) to which taxes do not apply'),
(3585, 'SYS', 'EDIT_TAX_SHIPPING_ITEM_NA', 'No Shipping Methods are defined in the system'),
(3586, 'SYS', 'TAX_RATE_TITLE', 'Tax Rates'),
(3587, 'SYS', 'TAX_RATE_SUBTITLE', 'Tax Rates. Product Tax Class - {0}'),
(3588, 'SYS', 'TAX_RATE_HEADER_001', 'Address'),
(3589, 'SYS', 'TAX_RATE_HEADER_002', 'Tax Formula'),
(3590, 'SYS', 'TAX_RATE_ITEMS_NA', 'Tax Rates are not defined'),
(3591, 'SYS', 'TAX_RATE_ITEMS_NONTAXABLE', 'All other addresses are not subject to taxation'),
(3592, 'SYS', 'TAX_RATE_NA_LABEL', '<B>NA</B>'),
(3593, 'SYS', 'TAX_RATE_NOT_APPLICABLE_LABEL', 'Not Applicable'),
(3594, 'SYS', 'TAX_COST_NAME_001', 'Sale Price'),
(3595, 'SYS', 'TAX_COST_NAME_002', 'Shipping Cost'),
(3596, 'SYS', 'TAX_COST_NAME_003', 'Discount'),
(3597, 'SYS', 'ADD_TAX_RATE_PAGE_TITLE', 'Add Tax Rate'),
(3598, 'SYS', 'ADD_TAX_RATE_PAGE_NAME', 'Taxes'),
(3599, 'SYS', 'ADD_TAX_RATE_PAGE_SUBTITLE', 'Add Tax Rate'),
(3600, 'SYS', 'ADD_TAX_RATE_FIELD_001', 'Shipping/Billing Address'),
(3601, 'SYS', 'ADD_TAX_RATE_FIELD_001_DESCR', 'The address for which the calculation rule is being defined. If the address entered during checkout matches this entry, then the tax appearing in Tax Formula will be calculated.<BR><BR>Note: For the tax for a particular product to be calculated, the Product Tax Class for the product being ordered also must match the value entered in Product Tax Class.'),
(3602, 'SYS', 'ADD_TAX_RATE_FIELD_002', 'Product Tax Class');
INSERT INTO `[[dbprefix]]resource_labels` VALUES
(3603, 'SYS', 'ADD_TAX_RATE_FIELD_002_DESCR', 'The Tax Class for which the tax appearing in Tax Formula is being calculated. If the product being checked out has this tax class, then the tax appearing in Tax Formula will be calculated.<BR><BR>Note: For the tax for a particular product to be calculated, the address entered during checkout also must match the value entered in Shipping/Billing Address.'),
(3604, 'SYS', 'ADD_TAX_RATE_FIELD_003', 'Tax Name'),
(3605, 'SYS', 'ADD_TAX_RATE_FIELD_003_NA', 'Not Applicable'),
(3606, 'SYS', 'ADD_TAX_RATE_FIELD_003_DESCR', 'The Tax Name for which the tax appearing in Tax Formula is being calculated.'),
(3607, 'SYS', 'ADD_TAX_RATE_FIELD_004', 'Rate (%)'),
(3608, 'SYS', 'Select_Zip_Code_Based_Rates', 'ZIP Code Based Rates'),
(3609, 'SYS', 'ADD_TAX_RATE_FIELD_004_DESCR', 'The tax rate, as a percentage, which is applied to the currently selected Product and Tax Class.<br><br>If a tax in the selected state/region depends on the ZIP code, select the &quot;ZIP Code Based Rates&quot; option. <br><br><b>Note:</b> ZIP Code Tax Rates affect the tax only for the state/region and country selected in the Shipping/Billing Address.<br><br>In the drop-down list, select the file which stores the tax rates depending on the ZIP code for the selected state/region and country. The tax rates file must first be uploaded on the Store Settings &gt;&gt; ZIP Code Based Tax Rates page.'),
(3610, 'SYS', 'ADD_TAX_RATE_TAX_ZIP_SET', 'ZIP Code Based Rates'),
(3611, 'SYS', 'ADD_TAX_RATE_TAX_ZIP_SET_DESCR', 'ZIP Code Tax Rates affect the tax only for the state/region and country selected in the Shipping/Billing Address. In the drop-down list, select the file which stores the tax rates depending on the ZIP code for the selected state/region and country. The tax rates file must first be uploaded on the Store Settings >> ZIP Code Based Tax Rates page.'),
(3612, 'SYS', 'ADD_TAX_RATE_FIELD_005', 'Tax Formula'),
(3613, 'SYS', 'ADD_TAX_RATE_FIELD_005_DESCR', 'Use this field to define the formula for tax calculation. The tax formula may include such variables as Shipping Cost, Sale Price (use the Select Price drop-down menu), other taxes (use the Select Tax drop-down menu), and numeric values (use the Add Number box). For mathematical operations, use the symbols &quot;(&quot;, &quot;+&quot;, &quot;)&quot;, &quot;+&quot;, &quot;-&quot;, &quot;x&quot;,  and &quot; / &quot;. Click Add to add the selected parameter to the tax formula. Click Undo to remove the added parameter. The Clear buttons deletes the entire formula and clears the box.'),
(3614, 'SYS', 'ADD_TAX_RATE_FIELD_006', 'Select Price:'),
(3615, 'SYS', 'ADD_TAX_RATE_FIELD_007', 'Select Tax:'),
(3616, 'SYS', 'ADD_TAX_RATE_FIELD_008', 'Add Number:'),
(3617, 'SYS', 'ADD_TAX_RATE_WRN_001', 'Select a country.'),
(3618, 'SYS', 'ADD_TAX_RATE_WRN_002', 'Select a state.'),
(3619, 'SYS', 'ADD_TAX_RATE_WRN_003', 'Tax rate is not defined.'),
(3620, 'SYS', 'ADD_TAX_RATE_WRN_004', 'Tax calculation formula is not defined.'),
(3621, 'SYS', 'ADD_TAX_RATE_WRN_005', 'Division by zero.'),
(3622, 'SYS', 'ADD_TAX_RATE_WRN_006', 'Tax calculation formula is incomplete.'),
(3623, 'SYS', 'ADD_TAX_RATE_WRN_007', 'Select Product Tax Class.'),
(3624, 'SYS', 'ADD_TAX_RATE_WRN_008', 'Select Tax Name.'),
(3625, 'SYS', 'ADD_TAX_RATE_ERR_001', 'The following two formulas are inconsistent with each other:'),
(3626, 'SYS', 'ADD_TAX_RATE_ERR_002', 'The following formulas form a cyclic dependency. No evaluation is possible. Please double check the relevant formula definitions.'),
(3627, 'SYS', 'SELECT_PRODUCT_TAX_CLASS_LABEL', 'SELECT TAX CLASS'),
(3628, 'SYS', 'SELECT_TAX_NAME_LABEL', 'SELECT TAX NAME'),
(3629, 'SYS', 'EDIT_TAX_RATE_PAGE_TITLE', 'Edit Tax Rate'),
(3630, 'SYS', 'EDIT_TAX_RATE_PAGE_SUBTITLE', 'Edit Tax Rate'),
(3631, 'SYS', 'TAX_CALCULATOR_PAGE_TITLE', 'Tax Calculator'),
(3632, 'SYS', 'TAX_CALCULATOR_PAGE_NAME', 'Taxes'),
(3633, 'SYS', 'TAX_CALCULATOR_PAGE_SUBTITLE', 'Tax Calculator'),
(3634, 'SYS', 'TAX_CALCULATOR_FIELD_001', 'Shopping Cart Contents'),
(3635, 'SYS', 'TAX_CALCULATOR_FIELD_002', 'Order-Level Shipping Cost'),
(3636, 'SYS', 'TAX_CALCULATOR_FIELD_003', 'Shipping Method'),
(3637, 'SYS', 'TAX_CALCULATOR_FIELD_004', 'Shipping Address'),
(3638, 'SYS', 'TAX_CALCULATOR_FIELD_005', 'Billing Address'),
(3639, 'SYS', 'TAX_CALCULATOR_FIELD_006', 'Customer Address'),
(3640, 'SYS', 'TAX_CALCULATOR_FIELD_007', 'Displayed Tax Text<br>(visible to customers)'),
(3641, 'SYS', 'TAX_CALCULATOR_FIELD_008', 'Tax Calculation Results'),
(3642, 'SYS', 'TAX_CALCULATOR_FIELD_009', 'Tax Calculation Trace Info'),
(3643, 'SYS', 'NO_SHIPPING_METHOD_LABEL', 'No Shipping Method'),
(3644, 'SYS', 'TAX_CALCULATOR_CART_TABLE_HEADER_001', 'Products'),
(3645, 'SYS', 'TAX_CALCULATOR_CART_TABLE_HEADER_002', 'Sale Price, '),
(3646, 'SYS', 'TAX_CALCULATOR_CART_TABLE_HEADER_003', 'Qty'),
(3647, 'SYS', 'TAX_CALCULATOR_CART_TABLE_HEADER_004', 'Per Item Shipping Cost, '),
(3648, 'SYS', 'TAX_CALCULATOR_CART_TABLE_HEADER_005', 'Tax Class'),
(3649, 'SYS', 'TAX_CALCULATOR_WRN_001', 'All fields of Shopping Cart Contents must be filled in.'),
(3650, 'SYS', 'TAX_CALCULATOR_WRN_002', 'Enter Order-Level Shipping Cost'),
(3651, 'SYS', 'TAX_CALCULATOR_WRN_003', 'Select Shipping Country.'),
(3652, 'SYS', 'TAX_CALCULATOR_WRN_004', 'Select Shipping State.'),
(3653, 'SYS', 'TAX_CALCULATOR_WRN_005', 'Select Billing Country.'),
(3654, 'SYS', 'TAX_CALCULATOR_WRN_006', 'Select Billing State.'),
(3655, 'SYS', 'TAX_CALCULATOR_WRN_007', 'Select Shipping Method.'),
(3656, 'SYS', 'TAX_CALCULATOR_VIRTUAL_PRODUCT_NAME', 'Product'),
(3657, 'SYS', 'TAX_CALCULATOR_STEP_001', 'Step 1. Preparation Data for Tax Calculation'),
(3658, 'SYS', 'TAX_CALCULATOR_STEP_001_WRN', 'No Shipping Method Selected. Order-Level Shipping Cost Ignored.'),
(3659, 'SYS', 'TAX_CALCULATOR_STEP_002', 'Step 2. Tax Calculation'),
(3660, 'SYS', 'TAX_CALCULATOR_STEP_002_WRN', 'Tax to shipping costs not applied.'),
(3661, 'SYS', 'TAX_CALCULATOR_TOTAL_LABEL', 'TOTAL:'),
(3662, 'SYS', 'TAX_CALCULATOR_TAX_TOTAL_LABEL', 'Total Tax: '),
(3663, 'SYS', 'TAX_CALCULATOR_TABLE1_TITLE', 'Table 1. Total Sale Price'),
(3664, 'SYS', 'TAX_CALCULATOR_TABLE1_HEADER_001', 'Products'),
(3665, 'SYS', 'TAX_CALCULATOR_TABLE1_HEADER_002', 'Sale Price, '),
(3666, 'SYS', 'TAX_CALCULATOR_TABLE1_HEADER_003', 'Qty'),
(3667, 'SYS', 'TAX_CALCULATOR_TABLE1_HEADER_004', 'Total Sale Price, '),
(3668, 'SYS', 'TAX_CALCULATOR_TABLE2_TITLE', 'Table 2. Total Per Item Shipping Cost'),
(3669, 'SYS', 'TAX_CALCULATOR_TABLE2_HEADER_001', 'Products'),
(3670, 'SYS', 'TAX_CALCULATOR_TABLE2_HEADER_002', 'Per Item Shipping Cost, '),
(3671, 'SYS', 'TAX_CALCULATOR_TABLE2_HEADER_003', 'Qty'),
(3672, 'SYS', 'TAX_CALCULATOR_TABLE2_HEADER_004', 'Total Per Item Shipping Cost, '),
(3673, 'SYS', 'TAX_CALCULATOR_TABLE3_TITLE', 'Table 3. Product Price Share'),
(3674, 'SYS', 'TAX_CALCULATOR_TABLE3_HEADER_001', 'Products'),
(3675, 'SYS', 'TAX_CALCULATOR_TABLE3_HEADER_002', 'Total Sale Price, '),
(3676, 'SYS', 'TAX_CALCULATOR_TABLE3_HEADER_003', 'Product Price Share'),
(3677, 'SYS', 'TAX_CALCULATOR_TABLE4_TITLE', 'Table 4. Order-Level Shipping Cost by Product Price Share'),
(3678, 'SYS', 'TAX_CALCULATOR_TABLE4_HEADER_001', 'Products'),
(3679, 'SYS', 'TAX_CALCULATOR_TABLE4_HEADER_002', 'Product Price Share'),
(3680, 'SYS', 'TAX_CALCULATOR_TABLE4_HEADER_003', 'Order Level Shipping Cost, '),
(3681, 'SYS', 'TAX_CALCULATOR_TABLE5_TITLE', 'Table 5. Shipping Cost'),
(3682, 'SYS', 'TAX_CALCULATOR_TABLE5_HEADER_001', 'Products'),
(3683, 'SYS', 'TAX_CALCULATOR_TABLE5_HEADER_002', 'Total Per Item Shipping Cost, '),
(3684, 'SYS', 'TAX_CALCULATOR_TABLE5_HEADER_003', 'Order Level Shipping Cost, '),
(3685, 'SYS', 'TAX_CALCULATOR_TABLE5_HEADER_004', 'Shipping Cost, '),
(3686, 'SYS', 'TAX_CALCULATOR_TABLE6_TITLE', 'Table 6. Data for Calculation Taxes'),
(3687, 'SYS', 'TAX_CALCULATOR_TABLE6_HEADER_001', 'Products'),
(3688, 'SYS', 'TAX_CALCULATOR_TABLE6_HEADER_002', 'Tax Class'),
(3689, 'SYS', 'TAX_CALCULATOR_TABLE6_HEADER_003', 'Sale Price, '),
(3690, 'SYS', 'TAX_CALCULATOR_TABLE6_HEADER_004', 'Shipping Cost, '),
(3691, 'SYS', 'TAX_CALCULATOR_TABLE_PRODUCT_HEADER_001', 'Tax Formula'),
(3692, 'SYS', 'TAX_CALCULATOR_TABLE_PRODUCT_HEADER_002', 'Address Used'),
(3693, 'SYS', 'TAX_CALCULATOR_TABLE_PRODUCT_HEADER_003', 'Tax, '),
(3694, 'SYS', 'BTN_CALCULATE', 'Calculate'),
(3695, 'SYS', 'TAX_CALCULATOR_WRN_009', '<span class=''required''>The Tax {0} is not applicable. The tax depends on itself or there is a conflicting dependency.</span>'),
(3696, 'SYS', 'TAX_CALCULATOR_WRN_010', '<span class=''required''>The Tax {0} is not applicable. Data redundancy in module settings.</span>'),
(3697, 'SYS', 'TAX_CALCULATOR_WRN_011', '<b>The Tax {0} is applicable for ''{4}''.<br><u>{0} = {1} * {2} = {3}</u></b>'),
(3698, 'SYS', 'TAX_CALCULATOR_WRN_012', '<b>The Tax {0} for product ''{2}'' has already been calculated. {0} = {1}</b><br>'),
(3699, 'SYS', 'TAX_CALCULATOR_WRN_013', '<span class=''required''>No formulas are defined, therefore the Tax {0} is not applicable for ''{1}''</span>'),
(3700, 'SYS', 'TAX_CALCULATOR_STAGE_001', 'Stage 1:'),
(3701, 'SYS', 'TAX_CALCULATOR_STAGE_002', 'Stage 2:'),
(3702, 'SYS', 'TAX_CALCULATOR_STAGE_003', 'Stage 3:'),
(3703, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE1_HEADER_001', 'Product'),
(3704, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE1_HEADER_002', 'Tax Class'),
(3705, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE2_HEADER_001', 'Address Type'),
(3706, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE2_HEADER_002', 'Address'),
(3707, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_001', 'Name'),
(3708, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_002', 'Tax Class'),
(3709, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_003', 'Qty'),
(3710, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_004', 'Sale Price'),
(3711, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_005', 'Shipping Cost'),
(3712, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_006', 'Total Sale Price'),
(3713, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_TABLE3_HEADER_007', 'Total Shipping Price'),
(3714, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_001', 'The set of Tax Classes in the shopping cart:'),
(3715, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_001_1', 'The set of Tax Classes:'),
(3716, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_002', 'The set of addresses gathered from Checkout:'),
(3717, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_002_1', 'The set of addresses:'),
(3718, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_003', 'The list of applicable taxes and tax rates corresponding to the set of Tax Classes and Addresses:'),
(3719, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_004', 'Applicable Taxes'),
(3720, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_005', 'Non-applicable Taxes'),
(3721, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_006', 'Tax calculation:'),
(3722, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_007', 'Calculations for tax {0}; below is the list of all applicable formulas which can be used to calculate the tax:'),
(3723, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_008', 'List entries which do not correspond to {0} have been removed. The remaining formulas will be used for calculating tax {1} for each product in the shopping cart according to its Tax Class.'),
(3724, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_009', 'From the list of formulas for tax {0} let us choose a tax formula for Tax Class = '),
(3725, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_010', 'The list of applicable and non-applicable taxes, and the addresses to which they apply:'),
(3726, 'SYS', 'TAX_CALCULATOR_TRACE_INFO_011', 'Calculations for tax {0} for product {1}'),
(3727, 'SYS', 'TAX_CALCULATOR_COLUMN_001', 'Address'),
(3728, 'SYS', 'TAX_CALCULATOR_COLUMN_002', 'Tax Class'),
(3729, 'SYS', 'TAX_CALCULATOR_COLUMN_003', 'Tax Formula'),
(3730, 'SYS', 'PRD_TAX_CLASS_NAME', 'Product Tax Class'),
(3731, 'SYS', 'PRD_TAX_CLASS_DESCR', 'This field lets you select the Product Tax Class. Depending on the applicable tax assessment laws, a tax may or may not be charged at the time of sale of a product. By default, all products belong to the Nontaxable tax class. The Product Tax Class is defined in Store Settings > Taxes.'),
(3732, 'SYS', 'PRD_MANUFACTURER_NAME', 'Product Manufacturer'),
(3733, 'SYS', 'PRD_MANUFACTURER_DESCR', 'This field lets you specify the product manufacturer. Customers will be able to use it to sort products in the storefront, search by it and view products for a selected manufacturer.'),
(3734, 'SYS', 'PRD_MEMBERSHIP_VISIBILITY_NAME', 'Membership Visibility'),
(3735, 'SYS', 'PRD_MEMBERSHIP_VISIBILITY_DESCR', 'Only customers from selected group(s) will be able to see this product in the storefront catalog.'),
(3736, 'SYS', 'PRD_UPC_NAME', 'UPC'),
(3737, 'SYS', 'PRD_UPC_DESCR', 'Universal Product Code. A unique numerical identifier for commercial products that''s usually associated with a barcode printed on retail merchandise.'),
(3738, 'SYS', 'PRD_EAN_NAME', 'EAN'),
(3739, 'SYS', 'PRD_EAN_DESCR', 'European Article Number. A unique numerical identifier for commercial products that''s usually associated with a barcode printed on retail merchandise.'),
(3740, 'SYS', 'PRD_JAN_NAME', 'JAN'),
(3741, 'SYS', 'PRD_JAN_DESCR', 'Japanese Article Number. A unique numerical identifier for commercial products that''s usually associated with a barcode printed on retail merchandise.'),
(3742, 'SYS', 'PRD_ISBN_NAME', 'ISBN'),
(3743, 'SYS', 'PRD_ISBN_DESCR', 'International Standard Book Number. A unique numerical identifier for commercial books published since 1970 that can be found on the back of the book along with the barcode.'),
(3744, 'SYS', 'PRD_MPN_NAME', 'MPN'),
(3745, 'SYS', 'PRD_MPN_DESCR', 'Manufacturer Part Number. The number which uniquely identifies the product to it''s manufacturer.'),
(3746, 'SYS', 'SELECT_COUNTRY_LABEL', 'SELECT COUNTRY'),
(3747, 'SYS', 'SELECT_STATE_LABEL', 'SELECT STATE'),
(3748, 'SYS', 'SELECT_SHIPPING_METHOD_LABEL', 'SELECT SHIPPING METHOD'),
(3749, 'SYS', 'ALL_OTHER_STATES_LABEL', 'All Other'),
(3750, 'SYS', 'STATE_ALL_LABEL', 'All States'),
(3751, 'SYS', 'COUNTRY_ALL_LABEL', 'All Countries'),
(3752, 'SYS', 'STATE_UNDEFINED_LABEL', 'All States'),
(3753, 'SYS', 'PRODUCT_TAX_CLASS_ANY_LABEL', 'Any'),
(3754, 'SYS', 'ADMIN_FIRST_NAME', 'Admin'),
(3755, 'SYS', 'ADMIN_LAST_NAME', 'Name'),
(3756, 'SYS', 'ORDERS_RESULTS_ORDER_ID_LINK_TITLE', 'Order Info'),
(3757, 'SYS', 'ORDERS_RESULTS_ORDER_CUSTOMER_NAME_LINK_TITLE', 'Customer Info'),
(3758, 'SYS', 'CHECKOUT_PERSON_INFO_CUSTOMER_INFORMATION_NAME', 'Customer Information'),
(3759, 'SYS', 'CHECKOUT_PERSON_INFO_CUSTOMER_INFORMATION_DESCRIPTION', 'Customer Information'),
(3760, 'SYS', 'CHECKOUT_PERSON_INFO_CUSTOMER_INFORMATION_VISIBLE_NAME', 'Customer Information'),
(3761, 'SYS', 'CHECKOUT_PERSON_INFO_BILLING_INFORMATION_NAME', 'Billing Information'),
(3762, 'SYS', 'CHECKOUT_PERSON_INFO_BILLING_INFORMATION_DESCRIPTION', 'Billing Information'),
(3763, 'SYS', 'CHECKOUT_PERSON_INFO_BILLING_INFORMATION_VISIBLE_NAME', 'Billing Information'),
(3764, 'SYS', 'CHECKOUT_PERSON_INFO_SHIPPING_INFORMATION_NAME', 'Shipping Information'),
(3765, 'SYS', 'CHECKOUT_PERSON_INFO_SHIPPING_INFORMATION_DESCRIPTION', 'Shipping Information'),
(3766, 'SYS', 'CHECKOUT_PERSON_INFO_SHIPPING_INFORMATION_VISIBLE_NAME', 'Shipping Information'),
(3767, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_CUSTOMER_INFORMATION_NAME', '[default] Customer Information'),
(3768, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_CUSTOMER_INFORMATION_DESCRIPTION', '[default] Customer Information'),
(3769, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_CUSTOMER_INFORMATION_VISIBLE_NAME', 'Customer Information'),
(3770, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_BILLING_INFORMATION_NAME', '[default] Billing Information'),
(3771, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_BILLING_INFORMATION_DESCRIPTION', '[default] Billing Information'),
(3772, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_BILLING_INFORMATION_VISIBLE_NAME', 'Billing Information'),
(3773, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_SHIPPING_INFORMATION_NAME', '[default] Shipping Information'),
(3774, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_SHIPPING_INFORMATION_DESCRIPTION', '[default] Shipping Information'),
(3775, 'SYS', 'CHECKOUT_PERSON_INFO_VARIANT_DEFAULT_SHIPPING_INFORMATION_VISIBLE_NAME', 'Shipping Information'),
(3776, 'SYS', 'CHECKOUT_CUSTOMER_INFO_FIRSTNAME_NAME', 'First Name'),
(3777, 'SYS', 'CHECKOUT_CUSTOMER_INFO_FIRSTNAME_DESCRIPTION', 'Customer First Name'),
(3778, 'SYS', 'CHECKOUT_CUSTOMER_INFO_LASTNAME_NAME', 'Last Name'),
(3779, 'SYS', 'CHECKOUT_CUSTOMER_INFO_LASTNAME_DESCRIPTION', 'Customer Last Name'),
(3780, 'SYS', 'CHECKOUT_CUSTOMER_INFO_EMAIL_NAME', 'E-mail'),
(3781, 'SYS', 'CHECKOUT_CUSTOMER_INFO_EMAIL_DESCRIPTION', 'Customer E-mail Address'),
(3782, 'SYS', 'CHECKOUT_CUSTOMER_INFO_COUNTRY_NAME', 'Country'),
(3783, 'SYS', 'CHECKOUT_CUSTOMER_INFO_COUNTRY_DESCRIPTION', 'Country'),
(3784, 'SYS', 'CHECKOUT_CUSTOMER_INFO_POSTCODE_NAME', 'ZIP Code'),
(3785, 'SYS', 'CHECKOUT_CUSTOMER_INFO_POSTCODE_DESCRIPTION', 'ZIP Code'),
(3786, 'SYS', 'CHECKOUT_CUSTOMER_INFO_STATE_NAME', 'State'),
(3787, 'SYS', 'CHECKOUT_CUSTOMER_INFO_STATE_DESCRIPTION', 'State'),
(3788, 'SYS', 'CHECKOUT_CUSTOMER_INFO_CITY_NAME', 'City'),
(3789, 'SYS', 'CHECKOUT_CUSTOMER_INFO_CITY_DESCRIPTION', 'City'),
(3790, 'SYS', 'CHECKOUT_CUSTOMER_INFO_STREETLINE1_NAME', 'Address Line 1'),
(3791, 'SYS', 'CHECKOUT_CUSTOMER_INFO_STREETLINE1_DESCRIPTION', 'Address Line 1'),
(3792, 'SYS', 'CHECKOUT_CUSTOMER_INFO_STREETLINE2_NAME', 'Address Line 2'),
(3793, 'SYS', 'CHECKOUT_CUSTOMER_INFO_STREETLINE2_DESCRIPTION', 'Address Line 2'),
(3794, 'SYS', 'CHECKOUT_CUSTOMER_INFO_PHONE_NAME', 'Contact Phone'),
(3795, 'SYS', 'CHECKOUT_CUSTOMER_INFO_PHONE_DESCRIPTION', 'Contact Phone'),
(3796, 'SYS', 'CHECKOUT_BILLING_INFO_FIRSTNAME_NAME', 'First Name'),
(3797, 'SYS', 'CHECKOUT_BILLING_INFO_FIRSTNAME_DESCRIPTION', 'Billing First Name'),
(3798, 'SYS', 'CHECKOUT_BILLING_INFO_LASTNAME_NAME', 'Last Name'),
(3799, 'SYS', 'CHECKOUT_BILLING_INFO_LASTNAME_DESCRIPTION', 'Billing Last Name'),
(3800, 'SYS', 'CHECKOUT_BILLING_INFO_EMAIL_NAME', 'E-mail'),
(3801, 'SYS', 'CHECKOUT_BILLING_INFO_EMAIL_DESCRIPTION', 'Billing E-mail Address'),
(3802, 'SYS', 'CHECKOUT_BILLING_INFO_COUNTRY_NAME', 'Country'),
(3803, 'SYS', 'CHECKOUT_BILLING_INFO_COUNTRY_DESCRIPTION', 'Country'),
(3804, 'SYS', 'CHECKOUT_BILLING_INFO_POSTCODE_NAME', 'ZIP Code'),
(3805, 'SYS', 'CHECKOUT_BILLING_INFO_POSTCODE_DESCRIPTION', 'ZIP Code'),
(3806, 'SYS', 'CHECKOUT_BILLING_INFO_STATE_NAME', 'State'),
(3807, 'SYS', 'CHECKOUT_BILLING_INFO_STATE_DESCRIPTION', 'State'),
(3808, 'SYS', 'CHECKOUT_BILLING_INFO_CITY_NAME', 'City'),
(3809, 'SYS', 'CHECKOUT_BILLING_INFO_CITY_DESCRIPTION', 'City'),
(3810, 'SYS', 'CHECKOUT_BILLING_INFO_STREETLINE1_NAME', 'Address Line 1'),
(3811, 'SYS', 'CHECKOUT_BILLING_INFO_STREETLINE1_DESCRIPTION', 'Address Line 1'),
(3812, 'SYS', 'CHECKOUT_BILLING_INFO_STREETLINE2_NAME', 'Address Line 2'),
(3813, 'SYS', 'CHECKOUT_BILLING_INFO_STREETLINE2_DESCRIPTION', 'Address Line 2'),
(3814, 'SYS', 'CHECKOUT_BILLING_INFO_PHONE_NAME', 'Contact Phone'),
(3815, 'SYS', 'CHECKOUT_BILLING_INFO_PHONE_DESCRIPTION', 'Contact Phone'),
(3816, 'SYS', 'CHECKOUT_BILLING_INFO_COMMENT_LINE_NAME', 'Comment'),
(3817, 'SYS', 'CHECKOUT_BILLING_INFO_COMMENT_LINE_DESCRIPTION', 'Comment Text Line'),
(3818, 'SYS', 'CHECKOUT_BILLING_INFO_COMMENT_AREA_NAME', 'Comment'),
(3819, 'SYS', 'CHECKOUT_BILLING_INFO_COMMENT_AREA_DESCRIPTION', 'Comment Text Area'),
(3820, 'SYS', 'CHECKOUT_SHIPPING_INFO_FIRSTNAME_NAME', 'First Name'),
(3821, 'SYS', 'CHECKOUT_SHIPPING_INFO_FIRSTNAME_DESCRIPTION', 'First Name'),
(3822, 'SYS', 'CHECKOUT_SHIPPING_INFO_LASTNAME_NAME', 'Last Name'),
(3823, 'SYS', 'CHECKOUT_SHIPPING_INFO_LASTNAME_DESCRIPTION', 'Last Name'),
(3824, 'SYS', 'CHECKOUT_SHIPPING_INFO_EMAIL_NAME', 'E-mail'),
(3825, 'SYS', 'CHECKOUT_SHIPPING_INFO_EMAIL_DESCRIPTION', 'E-mail Address'),
(3826, 'SYS', 'CHECKOUT_SHIPPING_INFO_COUNTRY_NAME', 'Country'),
(3827, 'SYS', 'CHECKOUT_SHIPPING_INFO_COUNTRY_DESCRIPTION', 'Country'),
(3828, 'SYS', 'CHECKOUT_SHIPPING_INFO_POSTCODE_NAME', 'ZIP Code'),
(3829, 'SYS', 'CHECKOUT_SHIPPING_INFO_POSTCODE_DESCRIPTION', 'ZIP Code'),
(3830, 'SYS', 'CHECKOUT_SHIPPING_INFO_STATE_NAME', 'State'),
(3831, 'SYS', 'CHECKOUT_SHIPPING_INFO_STATE_DESCRIPTION', 'State'),
(3832, 'SYS', 'CHECKOUT_SHIPPING_INFO_CITY_NAME', 'City'),
(3833, 'SYS', 'CHECKOUT_SHIPPING_INFO_CITY_DESCRIPTION', 'City'),
(3834, 'SYS', 'CHECKOUT_SHIPPING_INFO_STREETLINE1_NAME', 'Address Line 1'),
(3835, 'SYS', 'CHECKOUT_SHIPPING_INFO_STREETLINE1_DESCRIPTION', 'Address Line 1'),
(3836, 'SYS', 'CHECKOUT_SHIPPING_INFO_STREETLINE2_NAME', 'Address Line 2'),
(3837, 'SYS', 'CHECKOUT_SHIPPING_INFO_STREETLINE2_DESCRIPTION', 'Address Line 2'),
(3838, 'SYS', 'CHECKOUT_SHIPPING_INFO_PHONE_NAME', 'Contact Phone'),
(3839, 'SYS', 'CHECKOUT_SHIPPING_INFO_PHONE_DESCRIPTION', 'Contact Phone'),
(3840, 'SYS', 'CHECKOUT_SHIPPING_INFO_COMMENT_LINE_NAME', 'Comment'),
(3841, 'SYS', 'CHECKOUT_SHIPPING_INFO_COMMENT_LINE_DESCRIPTION', 'Comment Text Line'),
(3842, 'SYS', 'CHECKOUT_SHIPPING_INFO_COMMENT_AREA_NAME', 'Comment'),
(3843, 'SYS', 'CHECKOUT_SHIPPING_INFO_COMMENT_AREA_DESCRIPTION', 'Comment Text Area'),
(3844, 'SYS', 'CHECKOUT_SHIPPING_GROUP_OFFLINE_SHORT_NAME', 'Offline'),
(3845, 'SYS', 'CHECKOUT_PAYMENT_GROUP_OFFLINE_SHORT_NAME', 'Offline'),
(3846, 'SYS', 'CHECKOUT_PAYMENT_GROUP_ONLINE_CC_SHORT_NAME', 'Online CC'),
(3847, 'SYS', 'CHECKOUT_PAYMENT_GROUP_ONLINE_ECHECK_SHORT_NAME', 'eCheck'),
(3848, 'SYS', 'CHECKOUT_PAYMENT_GROUP_ONLINE_PAYMENT_SYSTEM_SHORT_NAME', 'Online PS'),
(3849, 'SYS', 'CHECKOUT_PAYMENT_001', 'Payment module ''{0}'' (id=''{1}'') returned unknown code resultEvent equal to ''{2}''.'),
(3850, 'SYS', 'CHECKOUT_005', 'Invalid amount_type when querying amount of order ''{0}''. Please forward this message to the webmaster. CHECKOUT_005.'),
(3851, 'SYS', 'CHECKOUT_006', 'Invalid weight_type when querying weight of order ''{0}''. Please forward this message to the webmaster. CHECKOUT_006.'),
(3852, 'SYS', 'CHECKOUT_007', 'Invalid (html form control) person_type in attribute ''{0}''. Please forward this message to the webmaster. CHECKOUT_007.'),
(3853, 'SYS', 'CHECKOUT_008', 'Invalid (html form control) select_person in attribute ''{0}''. Please forward this message to the webmaster. CHECKOUT_008.'),
(3854, 'SYS', 'CHECKOUT_009', 'Invalid tag in attribute ''{0}''. Please forward this message to the webmaster. CHECKOUT_009.'),
(3855, 'SYS', 'CHECKOUT_010', 'Invalid (?) tag ''{0}''. Please forward this message to the webmaster. CHECKOUT_010.'),
(3856, 'SYS', 'CHECKOUT_011', 'Variable PrerequisitesValidationResults is not defined in the session. Please forward this message to the webmaster. CHECKOUT_011.'),
(3857, 'SYS', 'PRICE_N_A', 'N/A'),
(3858, 'SYS', 'SETUP_WARNING_IMAGE_FOLDER_IS_NOT_WRITABLE', 'Unable to write to images folder ''{0}''.'),
(3859, 'SYS', 'SETUP_WARNING_CACHE_FOLDER_IS_NOT_WRITABLE', 'Unable to write to cache folder ''{0}''.'),
(3860, 'SYS', 'SETUP_WARNING_INSTALLER_FILES_ARE_NOT_REMOVED', 'Avactis Shopping Cart installation files (install.dat and install.php) have been found in folder &lt;store&gt;. For system security purposes, these files must be deleted.'),
(3861, 'SYS', 'SETUP_WARNING_DOWNLOADS_FOLDER_IS_NOT_WRITABLE', 'Unable to write to downloads folder ''{0}''.'),
(3862, 'SYS', 'SETUP_WARNING_UPLOADS_FOLDER_IS_NOT_WRITABLE', 'Unable to write to uploads folder ''{0}''.'),
(3863, 'SYS', 'HINT_PAGE_TITLE', 'Field Hint'),
(3864, 'SYS', 'HINT_FIELD_001', 'Field Name:'),
(3865, 'SYS', 'HINT_FIELD_002', 'Field Description:'),
(3866, 'SYS', 'NEWS_001', 'No news available'),
(3867, 'SYS', 'NEWS_002', 'Last build date:'),
(3868, 'SYS', 'NEWS_003', 'Date:'),
(3869, 'SYS', 'NEWS_004', 'Category:'),
(3870, 'SYS', 'NEWS_005', 'Read more...'),
(3871, 'SYS', 'NEWS_SET_PAGE_TITLE', 'News Module Configuration'),
(3872, 'SYS', 'NEWS_SET_PAGE_SUBTITLE', 'News Store Settings'),
(3873, 'SYS', 'NEWS_SETTINGS', 'News settings'),
(3874, 'SYS', 'NEWS_SET_FIELD_001', 'The number of news bits displayed'),
(3875, 'SYS', 'CORE_030', 'Failed to find system configuration file config.php or insufficient rights to read the file.'),
(3876, 'SYS', 'CORE_031', 'Failed to find configuration file layout.ini or insufficient rights to read the file.'),
(3877, 'SYS', 'CORE_032', 'Failed to find the required directive SiteURL in the configuration file for section [Site]. This directive must contain the URL of the client side of the online store.'),
(3878, 'SYS', 'CORE_033', 'Failed to find the required directive SitePATH in the configuration file for section [Site]. This directive must contain the absolute path to the client side of the online store (the path in the file system).'),
(3879, 'SYS', 'CORE_034', 'Failed to find the required section [Site] in the configuration file.'),
(3880, 'SYS', 'CORE_035', 'The specified template folder <b>{0}</b> not found in <b>{1}</b>'),
(3881, 'SYS', 'CORE_037', 'Failed to find the required section [Template] in the configuration file.'),
(3882, 'SYS', 'CORE_038', 'The path specified in directive SitePath does not exist.'),
(3883, 'SYS', 'CORE_040', 'Unable to write to cache folder ''{0}''.'),
(3884, 'SYS', 'CORE_041', 'DB_MySQL::DB_Connect() - unable to connect to DB ''{0}''.'),
(3885, 'SYS', 'CORE_042', 'DB_MySQL::DB_Connect() - unable to connect to MySQL server.'),
(3886, 'SYS', 'CORE_043', 'Table ''{0}'' already exists.'),
(3887, 'SYS', 'CORE_044', 'modApiFunc: Method ''{1}'' not found in class ''{0}''  - unable to execute it.'),
(3888, 'SYS', 'CORE_045', 'modApiFunc: Class ''{0}'' not loaded into the system - unable to create object.'),
(3889, 'SYS', 'CORE_046', 'Failed to find delimiter &lt;!-- BEGIN TPL (DO NOT REMOVE!) --&gt; . Path ''{0}'''),
(3890, 'SYS', 'CORE_047', 'Failed to find delimiter &lt;!-- END TPL (DO NOT REMOVE!) --&gt; . Path ''{0}'''),
(3891, 'SYS', 'CORE_048', 'The first opening delimiter &lt;!-- BEGIN TPL (DO NOT REMOVE!) --&gt; is located later than the first closing delimiter &lt;!-- END TPL (DO NOT REMOVE!) --&gt;. Path ''{0}''. Opening delimiter &lt;!-- BEGIN TPL (DO NOT REMOVE!) --&gt; must be located earlier than &lt;!-- END TPL (DO NOT REMOVE!) --&gt;.'),
(3892, 'SYS', 'CORE_049', '{0}::{1} current zone has unexpected value.'),
(3893, 'SYS', 'CORE_050', '{0}::{1} session[SessionPost] is already set.'),
(3894, 'SYS', 'CORE_051', '{0}::{1} unexpected FormSubmitValue ''{2}'''),
(3895, 'SYS', 'CORE_054', '{0} : {1} incorrect Shipping/Payment module Id. There is no ''APIClassName'' member in module info.'),
(3896, 'SYS', 'CORE_055', '{0} : {1} : function isCheckoutConfirmationStep should not be used.'),
(3897, 'SYS', 'CORE_059', 'A forced ''{0}'' redirect attempted with the mismatching URL ''{1}''.'),
(3898, 'SYS', 'CORE_060', 'Attempted to pop the tag parameter stack with tag ''{0}'', which does not match the top tag ''{1}''.'),
(3899, 'SYS', 'BCP_PAGE_SUBTITLE', 'Archive list'),
(3900, 'SYS', 'BCP_HEADER_001', 'Backup file'),
(3901, 'SYS', 'BCP_HEADER_002', 'Created date'),
(3902, 'SYS', 'BCP_HEADER_003', 'Backup file size'),
(3903, 'SYS', 'BCP_NO_BACKUP_FILES', 'Backup files not found'),
(3904, 'SYS', 'BCP_ALERT_001', 'To perform this action, please first select a backup file.'),
(3905, 'SYS', 'BCP_ALERT_002', 'Are you sure that you want to delete the selected file?'),
(3906, 'SYS', 'BCP_WIN_OS_UNSUPPORTED', '<br><br><br>&nbsp;Backup and Restore tools available on Linux/Unix operating systems only.<br><br><br><br>'),
(3907, 'SYS', 'BCP_CREATE_PAGE_TITLE', 'Backup Creation'),
(3908, 'SYS', 'BCP_CREATE_PAGE_NAME', 'Backup'),
(3909, 'SYS', 'BCP_CREATE_PAGE_SUBTITLE', 'Backup Creation'),
(3910, 'SYS', 'BCP_CREATE_MESSAGE_001', 'Database backup will begin after you click the Start button.'),
(3911, 'SYS', 'BCP_CREATE_MESSAGE_002', 'Database backup in progress:'),
(3912, 'SYS', 'BCP_CREATE_MESSAGE_003', 'Backup completed successfully.'),
(3913, 'SYS', 'BCP_CREATE_MESSAGE_004', 'Images backup in progress:'),
(3914, 'SYS', 'BCP_INFO_PAGE_TITLE', 'Backup Info'),
(3915, 'SYS', 'BCP_INFO_PAGE_NAME', 'Backup Name:'),
(3916, 'SYS', 'BCP_INFO_PAGE_SUBTITLE', 'Backup Info'),
(3917, 'SYS', 'BCP_INFO_SAVED', 'Backup information has been successfully updated'),
(3918, 'SYS', 'BCP_INFO_FIELD_001', 'SQL Dump File Name'),
(3919, 'SYS', 'BCP_INFO_FIELD_002', 'SQL Dump File Size'),
(3920, 'SYS', 'BCP_INFO_FIELD_003', 'Images Folder'),
(3921, 'SYS', 'BCP_INFO_FIELD_004', 'Images Folder Size'),
(3922, 'SYS', 'BCP_INFO_FIELD_005', 'Backup Creation Date'),
(3923, 'SYS', 'BCP_INFO_FIELD_006', 'Start Time'),
(3924, 'SYS', 'BCP_INFO_FIELD_007', 'Finish Time'),
(3925, 'SYS', 'BCP_INFO_FIELD_008', 'History/Comments'),
(3926, 'SYS', 'BCP_INFO_FIELD_009', 'Add Comment'),
(3927, 'SYS', 'BCP_INFO_HEADER_001', 'Additional Information'),
(3928, 'SYS', 'BCP_INFO_LOG_MSG_001', '<b>{0} {1}</b><br>Backup completed successfully.<br>Backup performed by <b>{2} {3} ({4})</b>.<br><hr style=''border: 0px; height: 1px; color: #b2c2df; background-color: #b2c2df;''><br>'),
(3929, 'SYS', 'BCP_INFO_LOG_MSG_002', '<b>{0} {1}</b><br><b>{2} {3} ({4})</b> - added the comment:<br><br>'),
(3930, 'SYS', 'BCP_INFO_LOG_MSG_003', '<b>{0} {1}</b><br><b>{2} {3} ({4})</b> - edited the comment:<br><br>'),
(3931, 'SYS', 'BCP_INFO_LOG_MSG_004', '<b>{0} {1}</b><br>Backup completed successfully.<br>This backup was performed automatically before restoring by <b>{2} {3} ({4})</b>.<br><hr style=''border: 0px; height: 1px; color: #b2c2df; background-color: #b2c2df;''><br>'),
(3932, 'SYS', 'BCP_INFO_LOG_MSG_005', '<b>{0} {1}</b><br>This backup was used for restoring; restore completed successfully.<br>Restore performed by <b>{2} {3} ({4})</b>.<br><hr style=''border: 0px; height: 1px; color: #b2c2df; background-color: #b2c2df;''><br>'),
(3933, 'SYS', 'BCP_RESTORE_PAGE_TITLE', 'Backup Restoring'),
(3934, 'SYS', 'BCP_RESTORE_PAGE_NAME', 'Admin'),
(3935, 'SYS', 'BCP_RESTORE_PAGE_SUBTITLE', 'Backup Restoring'),
(3936, 'SYS', 'BCP_RESTORE_MESSAGE_001', 'Database restore will begin after you click the Start button. After restore begins, wait until the process has finished - any interruptions may cause unpredictable effects.'),
(3937, 'SYS', 'BCP_RESTORE_MESSAGE_002', 'Database restore in progress:'),
(3938, 'SYS', 'BCP_RESTORE_MESSAGE_003', 'Restore completed successfully.'),
(3939, 'SYS', 'BCP_RESTORE_MESSAGE_004', 'Images restore in progress:'),
(3940, 'SYS', 'BCP_RESTORE_ERR_001', 'The file selected for restoring is empty or does not exist.'),
(3941, 'SYS', 'BCP_RESTORE_ERR_002', 'The file selected for restoring is invalid.'),
(3942, 'SYS', 'BCP_RESTORE_STEP_001', 'Step 1 of 2. Database and Images backup.'),
(3943, 'SYS', 'BCP_RESTORE_STEP_002', 'Step 2 of 2. Database and Images restoring.'),
(3944, 'SYS', 'BCP_RESTORE_AUTO_BACKUP_MESSAGE', 'Create backup before restoring (Recommended).'),
(3945, 'SYS', 'BTN_CREATE', 'Create'),
(3946, 'SYS', 'BTN_DOWNLOAD', 'Download'),
(3947, 'SYS', 'BTN_UPLOAD', 'Upload'),
(3948, 'SYS', 'BTN_RESTORE', 'Restore'),
(3949, 'SYS', 'BTN_START', 'Start'),
(3950, 'SYS', 'STRSET_HEADER_005', 'E-Mail Templates &amp; Notifications'),
(3951, 'SYS', 'STRSET_EMAIL_NOTIFICATIONS', 'E-mail Notifications'),
(3952, 'SYS', 'STRSET_EMAIL_NOTIFICATIONS_DESCR', 'Change e-mail notification settings and edit e-mail templates for e-mails automatically generated by system events.'),
(3953, 'SYS', 'SETUP_WARNING_BACKUP_FOLDER_IS_NOT_WRITABLE', 'Unable to write to backup folder ''{0}''.'),
(3954, 'SYS', 'BCP_DELETE_PAGE_TITLE', 'Backup Deletion'),
(3955, 'SYS', 'BCP_DELETE_PAGE_NAME', 'Admin'),
(3956, 'SYS', 'BCP_DELETE_PAGE_SUBTITLE', 'Backup Deletion'),
(3957, 'SYS', 'BCP_DELETE_MESSAGE_001', 'Are you sure that you want to delete the selected backup?'),
(3958, 'SYS', 'BCP_DELETE_MESSAGE_002', 'Backup deletion in progress:'),
(3959, 'SYS', 'BCP_DELETE_MESSAGE_003', 'Backup deleted successfully.'),
(3960, 'SYS', 'ADMIN_OPTION_DESCR_002', ''),
(3961, 'SYS', 'ADMIN_OPTION_DESCR_004', ''),
(3962, 'SYS', 'BCP_NO_PERMISSION', 'You don''t have permission to perform Backup/Restore.'),
(3963, 'SYS', 'NTFCTN_ITEMS_NO_PERMISSION', 'You don''t have permission to manage E-mail Notifications'),
(3964, 'SYS', 'STRSET_CACHE', 'Clear Cache'),
(3965, 'SYS', 'STRSET_CACHE_DESCR', 'Clear system cache.'),
(3966, 'SYS', 'CACHE_SETTINGS_WINDOW_TITLE', 'Clear Cache'),
(3967, 'SYS', 'CACHE_SETTINGS_PAGE_TITLE', 'Clear Cache'),
(3968, 'SYS', 'CACHE_SETTINGS_PAGE_SUBTITLE', 'Cache Settings'),
(3969, 'SYS', 'CACHE_SETTINGS_LEVEL', 'Cache Level'),
(3970, 'SYS', 'CACHE_SETTINGS_LEVEL_DESCR', 'The performance of Avactis Shopping Cart is optimized through catalog caching. Optimizing system performance is particularly necessary - and produces the greatest effect - when the size of the product catalog reaches high proportions (5,000 - 10,000 products or more). Caching is controlled by the Cache Level setting. The trade-off between system performance and cache size is set by one of these values: DISABLED, MINIMUM, MEDIUM, or MAXIMUM. The greater the Cache Level value, the more disk space the cache will consume.<br><br><li><b>DISABLED</b> - caching is switched off altogether.<li><b>MINIMUM</b> - this causes a small increase in Store Front performance; cache size is minimal, usually only a few kilobytes.<li><b>MEDIUM</b> - this ensures good performance for medium to large catalogs; cache size is on the order of several megabytes. This setting is recommended for most users.<li><b>MAXIMUM</b> - performance is maximized, but cache size can be as high as tens of megabytes for very large catalogs. This setting is recommended for catalogs with 5,000 - 10,000 or more products.<br><br><span  style=''color: red; font-weight: bold''>Please note!</span>  At the MAXIMUM setting, caching includes the generated HTML code of block tags. This maximizes the performance of your Store Front. However, any modifications made to templates will not take effect, since Avactis Shopping Cart will be using the previously generated HTML code of block tags.<br><br>If you are tuning the design of store blocks and making changes to them, you should use the MEDIUM Cache Level setting. After you are finished editing the templates, you can switch to the MAXIMUM level to ensure maximum performance of your Store Front. For the updated templates to take effect, click the Clear cache link.'),
(3971, 'SYS', 'CACHE_SETTINGS_SIZE', 'Current Cache Size'),
(3972, 'SYS', 'CACHE_SETTINGS_CLEAR', 'Clear cache'),
(3973, 'SYS', 'CACHE_SETTINGS_LEVEL_DISABLED', 'Disabled'),
(3974, 'SYS', 'CACHE_SETTINGS_LEVEL_MINIMUM', 'Minimum'),
(3975, 'SYS', 'CACHE_SETTINGS_LEVEL_MEDIUM', 'Medium'),
(3976, 'SYS', 'CACHE_SETTINGS_LEVEL_MAXIMUM', 'Maximum'),
(3977, 'SYS', 'CACHE_SETTINGS_SIZE_B', 'Bytes'),
(3978, 'SYS', 'CACHE_SETTINGS_SIZE_KB', 'KBytes'),
(3979, 'SYS', 'CACHE_SETTINGS_SIZE_MB', 'MBytes'),
(3980, 'SYS', 'CACHE_SETTINGS_SIZE_GB', 'GBytes'),
(3981, 'SYS', 'MSG_CACHE_UPDATED', 'Cache settings have been successfully updated.'),
(3982, 'SYS', 'LICENSE_PAGE_TITLE', 'Avactis Shopping Cart: License Info'),
(3983, 'SYS', 'LICENSE_WINDOW_TITLE', 'License'),
(3984, 'SYS', 'LICENSE_PAGE_SUBTITLE', 'License Information'),
(3985, 'SYS', 'LICENSE_FIELD_001', 'License Key:'),
(3986, 'SYS', 'LICENSE_FIELD_001_DESCR', 'A license key is issued to you after you purchase Avactis Shopping Cart. It is illegal to use Avactis Shopping Cart commercially without a license key.'),
(3987, 'SYS', 'LICENSE_FIELD_002', 'License Status:'),
(3988, 'SYS', 'LICENSE_FIELD_002_DESCR', 'Shows the status of your license.'),
(3989, 'SYS', 'LICENSE_FIELD_003', 'License Date Created:'),
(3990, 'SYS', 'LICENSE_FIELD_003_DESCR', 'This is the date the license was created.'),
(3991, 'SYS', 'LICENSE_FIELD_004', 'License URL (domain):'),
(3992, 'SYS', 'LICENSE_FIELD_004_DESCR', 'Shows the URL (domain) to which the license is issued (license number is displayed in the License Key box). This URL (domain) must match your current URL (domain).'),
(3993, 'SYS', 'LICENSE_FIELD_005', 'Your Current URL:'),
(3994, 'SYS', 'LICENSE_FIELD_005_DESCR', 'Displays the URL (domain) on which this copy of Avactis Shopping Cart is installed.'),
(3995, 'SYS', 'LICENSE_FIELD_006', 'Version Type:'),
(3996, 'SYS', 'LICENSE_FIELD_006_DESCR', 'Defines the version type of the license.'),
(3997, 'SYS', 'LICENSE_FIELD_007', 'Updates Expire:'),
(3998, 'SYS', 'LICENSE_FIELD_007_DESCR', 'Displays the updates expiration date. After this date, Avactis Shopping Cart will continue to operate as usual, but further updates will require a renewed update license.'),
(3999, 'SYS', 'LICENSE_FIELD_008', 'Support Expires:'),
(4000, 'SYS', 'LICENSE_FIELD_008_DESCR', ' Displays the support expiration date. After this date, Avactis Shopping Cart will continue to operate as usual, but you will need to renew your support license to receive technical support.'),
(4001, 'SYS', 'LICENSE_FIELD_009', 'New License Key:'),
(4002, 'SYS', 'LICENSE_FIELD_009_DESCR', 'If you have received a new license for the current domain, enter it here.'),
(4003, 'SYS', 'LICENSE_FIELD_010', 'Your Current Version Type:'),
(4004, 'SYS', 'LICENSE_FIELD_010_DESCR', 'Shows the current version type.'),
(4005, 'SYS', 'MSG_LICENSE_UPDATED', 'License information has been updated.'),
(4006, 'SYS', 'MSG_LICENSE_UPDATE_FAILED', 'Sorry, cannot update'),
(4007, 'SYS', 'LICENSE_WARNING_001', 'Unable to connect to the license server, please try again later.'),
(4008, 'SYS', 'LICENSE_WARNING_002', 'You are using a free trial version of Avactis Shopping Cart. The trial version had limited functionality and does not allow installing updates.'),
(4009, 'SYS', 'LICENSE_WARNING_003', 'To get a commercial version license, please go to: <A H