<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php

/**
 * Catalog module.
 * Catalog Navigator.
 *
 * @package Catalog
 * @access  public
 * @author  Vadim Lyalikov, Alexey Kolesnikov
 */
class NavigationBar
{
//------------------------------------------------
//               PUBLIC DECLARATION
//------------------------------------------------

    /**#@+
     * @access public
     */

    /**
     * Gets a template format for the given view.
     */
    function getTemplateFormat()
    {
    	$format = array(
    	    'layout-file'        => 'navigation-bar-config.ini'
    	   ,'files' => array(
    	        'Container'               => TEMPLATE_FILE_SIMPLE
    	       ,'Empty'                   => TEMPLATE_FILE_SIMPLE
    	       ,'CategoryDefault'         => TEMPLATE_FILE_SIMPLE
    	       ,'CategoryDefaultSelected' => TEMPLATE_FILE_SIMPLE
    	       ,'CategoryLevel1'          => TEMPLATE_FILE_SIMPLE
    	       ,'CategoryLevel1Selected'  => TEMPLATE_FILE_SIMPLE
    	       ,'CategoryLevel2'          => TEMPLATE_FILE_SIMPLE
    	       ,'CategoryLevel2Selected'  => TEMPLATE_FILE_SIMPLE
    	       ,'SubcategoriesContainer'  => TEMPLATE_FILE_SIMPLE
    	    )
    	   ,'options' => array(
    	        'DefaultIndent'  => TEMPLATE_OPTION_REQUIRED
    	       ,'Level1Indent'   => TEMPLATE_OPTION_REQUIRED
    	       ,'Level2Indent'   => TEMPLATE_OPTION_REQUIRED
    	    )
    	);
    	return $format;
    }

    /**
     * The view constructor.
     *
     * @ finish the functions on this page
     */
    function NavigationBar()
    {
        global $application;

        #check if fatal errors exist in the block tag
        $this->NoView = false;
        if ($application->issetBlockTagFatalErrors("NavigationBar"))
        {
            $this->NoView = true;
        }

        $this->pCatalog = &$application->getInstance('Catalog');
    }

    /**
     * Returns the Catalog Navigator Tree view.
     *
     * It builds the HTML code from bottom to top - from $cid to root category
     * recursively.
     * Traced variables:
     *     1) current category id
     *     2) tree HTML code, already generated on previous steps
     *
     * outputCatalogNavigatorTree($cid)
     *
     * 1) if $cid is a tree leaf
     *     HTML = list of all direct descendants
     * 2) if $cid is a tree root
     *     output HTML
     * 3) else if neither 1) nor 2) holds then
     *     HTML = list of all direct descendants with
     *            last $cid marked and
     *            last HTML attached to it.
     *    e.g.
     *
     *    HTML =
     *
     *    catx1
     *    catx2
     *    CATX3
     *        HTML
     *    catx4
     *
     *
     * @ finish the functions on this page
     */
    function outputCatalogNavigatorTree($cid)
    {
        global $application;

        //$_descendants - HTML code, already generated by the moment.
        $_descendants = "";
        $_previous_descendants = "";

        $_cid = $cid;
        $_previous_cid = 2147483648;

        for(;$_previous_cid > 1;)
        {
            $_descendants = "";

            # define the category level with the $_cid id
            $categoryInfo = &$application->getInstance('CCategoryInfo', $_cid);
            $cat_level = 1 + $categoryInfo->getCategoryTagValue('level');

            # define if the template for the given category exists
            $template_readable = $this->mTmplFiller->isTemplateReadable("CategoryLevel" . $cat_level);
            $template_marked_readable = $this->mTmplFiller->isTemplateReadable("CategoryLevel" . $cat_level . "Selected");
            $template = "CategoryDefault";
            $template_marked = "CategoryDefaultSelected";
            if ($template_readable)
            {
            	$template = "CategoryLevel" . $cat_level;
            }
            if ($template_marked_readable)
            {
            	$template_marked = "CategoryLevel" . $cat_level . "Selected";
            }

            # read out the indent options
            $level_indent = $application->getBlockOption($this->template, "Level" .$cat_level. "Indent");
            if ($level_indent === null)
            {
            	$level_indent = $application->getBlockOption($this->template, "DefaultIndent");
            }

            # get the nested categories
            $children = $this->pCatalog->getDirectSubcategoriesListFull($_cid, true);

            foreach ($children as $child)
            {
                $this->_Current_Category = &$child;
                $child_id = $child->getCategoryTagValue("ID");

                if($child_id == $_previous_cid)
                {
                    # fill out the tamplate for the specified categories.
                    $_descendants .=
                    $this->mTmplFiller->fill($template_marked);

                    $this->_Subcategories = array(
                                                "Local_LevelIndent" => $level_indent
                                               ,"Local_Subcategories" => $_previous_descendants
                                               );
                    $application->registerAttributes($this->_Subcategories);
                    $_descendants .= $this->mTmplFiller->fill('SubcategoriesContainer');
                }
                else
                {
                    # fill out the template for the current categories.
                    $_descendants .= $this->mTmplFiller->fill($template);
                }
            }
            $this->_Current_Category = null;

            $_previous_descendants = $_descendants;
            $_previous_cid = $_cid;
            $_cid = $categoryInfo->getCategoryTagValue('ParentID');

        }
        return $_descendants;
    }

/*    function getViewCacheKey()
    {
        return modApiFunc('CProductListFilter','getCurrentCategoryId');
    }//*/

    /**
     * Returns the generated ProductList view.
     *
     * @return string
     */
    function output()
    {
        global $application;

        #define whether to output the view or not
        if ($this->NoView)
        {
            $application->outputTagErrors(true, "NavigationBar", "Errors");
            return;
        }
        else
        {
            $application->outputTagErrors(true, "NavigationBar", "Warnings");
        }

        $this->cat_id = func_num_args() > 0 ? @func_get_arg(0) : false;
        if ($this->cat_id === false)
        {
            $this->cat_id = modApiFunc('CProductListFilter','getCurrentCategoryId');
        }

        $this->mTmplFiller = new TemplateFiller();
        $this->template = $application->getBlockTemplate('NavigationBar');
        $this->mTmplFiller->setTemplate($this->template);

        if ($this->cat_id == 1)
        {
            $this->categoryInfo = &$application->getInstance('CCategoryInfo', $this->cat_id);
            if (! $this->categoryInfo->getCategoryTagValue("hasonlinesubcategories"))
            {
                $retval = $this->mTmplFiller->fill("Empty");
            }
            else
            {
                $retval = $this->mTmplFiller->fill("Container");
            }
        }
        else
        {
            $retval = $this->mTmplFiller->fill("Container");
        }
        return $retval;
    }

    /**
     * Processes tags in the templates for the given view.
     *
     * @return string tag value, if tag has been processed. NULL, otherwise.
     */
    function getTag($tag)
    {
        $value = null;
    	switch ($tag)
    	{
    	    case 'Local_Items':
                $value = $this->outputCatalogNavigatorTree($this->cat_id);
    	        break;

    	    case 'Local_LevelIndent':
                $value = isset($this->_Subcategories["Local_LevelIndent"])? $this->_Subcategories["Local_LevelIndent"]:"";
    	        break;

    	    case 'Local_Subcategories':
                $value = isset($this->_Subcategories["Local_Subcategories"])? $this->_Subcategories["Local_Subcategories"]:"";
    	        break;

    		default:
    		    list($entity, $tag) = getTagName($tag);
        	    if ($entity == 'category' && is_object($this->_Current_Category))
        	    {
                    $value = $this->_Current_Category->getCategoryTagValue($tag);
        	    }
    			break;
    	}
    	return $value;
    }

    /**#@-*/

//------------------------------------------------
//              PRIVATE DECLARATION
//------------------------------------------------

    /**#@+
     * @access private
     */

    /**
     * Pointer to the module object.
     */
    var $pCatalog;

    /**
     * Pointer to the template filler object.
     * It needs to track sequences of identical templates, like lists.
     */
    var $mTmplFiller;

    var $cat_id;

    /**
     * Current category info, selected during the category tree traverse.
     *
     * @var array
     */
    var $_Current_Category;

    var $_Subcategories;

    /**
     * The template selected for the view.
     *
     * @var array
     */
    var $template;

    /**#@-*/
}
?>