<?php
/***********************************************************************
| Avactis (TM) Shopping Cart software developed by HBWSL.
| http://www.avactis.com
| -----------------------------------------------------------------------
| All source codes & content (c) Copyright 2004-2015, HBWSL.
| unless specifically noted otherwise.
| =============================================
| This source code is released under the Avactis License Agreement.
| The latest version of this license can be found here:
| http://www.avactis.com/license.php
|
| By using this software, you acknowledge having read this license agreement
| and agree to be bound thereby.
|
 ***********************************************************************/
?><?php include('../admin.php'); ?>
<HTML>
<HEAD>
<TITLE>Avactis Storefront Editor</TITLE>
<?php
    if (! modApiFunc('Users', 'checkCurrentUserPermission', PERMISSION_DESIGN)) {
        echo '<div class="no_access">Sorry, You have no access to this content.</div>';
        die;
    }
	$skin = modApiFunc('Look_Feel', 'getCurrentSkin');

	asc_enqueue_script('jquery');
	asc_enqueue_script('admin-avactis-jquery-post-extend');
	do_action( 'admin_print_scripts' );
	include 'part_htmlheader.php';
?>
<script type="text/javascript" src="js/jquery-1.10.2.min.js"></script>
<script type="text/javascript" src="js/avactis-jquery_post_extend.js"></script>
<script type="text/javascript" src="js/jquery-migrate-1.1.1.min.js"></script>
<style>
	#storefront { float:right;width:80%;border:0px;height:100%; }
	#sidebar-form { float:left;width:20%;height:100%; }
	#btn-save { margin: 5px;}
</style>
</HEAD>
<BODY class="page-content">
	<form id="sidebar-form">
		<div style="margin-bottom:10px;">
		<a href="look_feel.php" class="btn btn-default btn-small"> <i class="fa fa-times"></i> </a>
		<a id="btn-save" href="javascript:;" onclick="saveSettings();" class="btn btn-default btn-sm blue pull-right disabled"> Saved </a>
		</div>
		<div class="portlet box green">
							<div class="portlet-title">
								<div class="caption">
									Theme Editor
								</div>
							</div>
							<div class="portlet-body">
								<div class="panel-group accordion" id="accordion3">
									<!--Logo editor Block Start-->
									<div class="panel panel-default">
										<div class="panel-heading">
											<h4 class="panel-title">
											<a class="accordion-toggle accordion-toggle-styled collapsed" data-toggle="collapse" data-parent="#accordion3" href="#collapse_3_1">
											Logo Editor </a>
											</h4>
										</div>
										<div id="collapse_3_1" class="panel-collapse collapse">
											<div class="panel-body">
												<input type="hidden" name="ViewState[Logo]" value="" id="ViewState_Logo">
												<p>
													Current Skin: <?php echo $skin; ?>
												</p>
												<p>Logo Preview<br>
										<div class="preview-logo"><img id="cat-Logo" style="display:none;" src="" alt="Select logo image" width="100px;" height="100px;"></div><br>
					<a title="File on server:" class="btn blue" onclick="openURLinNewWindow('tinymce/plugins/image/image.php?catalog=yes&amp;for=Logo','Image Manager')" href="javascript:;"><i class="fa fa-check"></i> Select</a>
												</p>
											</div>
										</div>
									</div>
									<!--Logo editor Block end-->
									<!--Title & Tagline editor Block Start-->
									<div class="panel panel-default">
										<div class="panel-heading">
											<h4 class="panel-title">
											<a class="accordion-toggle accordion-toggle-styled collapsed" data-toggle="collapse" data-parent="#accordion3" href="#collapse_3_2">
											Title & Tagline Editor </a>
											</h4>
										</div>
										<div id="collapse_3_2" class="panel-collapse collapse">
											<div class="panel-body" style="height:200px; overflow-y:auto;">
												<p>&nbsp;
												</p>
											</div>
										</div>
									</div>
									<!--Title & Tagline editor Block end-->
									<!--Background Color & Text Block Start-->
									<div class="panel panel-default">
										<div class="panel-heading">
											<h4 class="panel-title">
											<a class="accordion-toggle accordion-toggle-styled collapsed" data-toggle="collapse" data-parent="#accordion3" href="#collapse_3_3">
											Background Color & Text</a>
											</h4>
										</div>
										<div id="collapse_3_3" class="panel-collapse collapse">
											<div class="panel-body" style="height:200px; overflow-y:auto;">
												<p>&nbsp;
												</p>
											</div>
										</div>
									</div>
									<!--Background Color & Text Block end-->
									<!--Custom CSS Block Start-->
									<div class="panel panel-default">
										<div class="panel-heading">
											<h4 class="panel-title">
											<a class="accordion-toggle accordion-toggle-styled collapsed" data-toggle="collapse" data-parent="#accordion3" href="#collapse_3_4">
											Custom CSS </a>
											</h4>
										</div>
										<div id="collapse_3_4" class="panel-collapse collapse">
											<div class="panel-body" style="height:200px; overflow-y:auto;">
												<p>&nbsp;
												</p>
											</div>
										</div>
									</div>
									<!--Custom CSS Block end-->
									<!--Social Media Block Start-->
									<div class="panel panel-default">
										<div class="panel-heading">
											<h4 class="panel-title">
											<a class="accordion-toggle accordion-toggle-styled collapsed" data-toggle="collapse" data-parent="#accordion3" href="#collapse_3_5">
											Social Media </a>
											</h4>
										</div>
										<div id="collapse_3_5" class="panel-collapse collapse">
											<div class="panel-body" style="height:200px; overflow-y:auto;">
												<p>&nbsp;
												</p>
											</div>
										</div>
									</div>
									<!--Social Media Block end-->
								</div>
							</div>
						</div>
	</form>

	<iframe onload="updateiFrame();" id="storefront" name="css_editor_storefront" src="<?php echo urlStorefrontBase() ?>"></iframe>

<?php include 'part_footer_scripts.php'; ?>

<script>
var customSettings = {};

function saveSettings() {
	var theme_settings = {};
	theme_settings['<?php echo $skin?>-theme-settings'] = customSettings;
	var json_data = JSON.stringify(theme_settings);
    jQuery.post(
        'jquery_ajax_handler.php', // backend
        {
        	'asc_action': 'Update_Skin_Settings',
        	'json_data': json_data
        },
        // Function is called when an answer arrives.
        function(result, output) {
			console.log(result.msg);
			disableSaveButton();
        },
	    'json'
    );
}

function enableSaveButton() {
	jQuery('#lbl-save').html('Save');
	jQuery('#btn-save').removeClass("disabled");
}

function disableSaveButton() {
	jQuery('#lbl-save').html('Saved');
	jQuery('#btn-save').addClass('disabled');
}

function CallBackOnImageSelect() {
	jQuery("#cat-Logo").css("display","block");
	customSettings['site-logo'] = jQuery('#ViewState_Logo').val();
	updateiFrame();
	enableSaveButton();
}

function updateiFrame() {
	var ifrmCS = customSettings;
	for(key in ifrmCS) {
		value = ifrmCS[key];
		switch(key) {
			case 'site-logo':
				var attr = jQuery('#storefront').contents().find('img.site-logo').attr('src');
				if (typeof attr !== typeof undefined && attr !== false) {
					jQuery('#storefront').contents().find('img.site-logo').attr("src",value);
				}
				else {
					jQuery('#storefront').contents().find('.site-logo').css("background-image","url("+value+")");
				}
				break;
			case 'title':
				break;
			case 'custom-css':
				break;
		}
	}
}
</script>
</BODY>
</HTML>