var FormWizard = function () {


    return {
        //main function to initiate the module
        init: function () {
            if (!jQuery().bootstrapWizard) {
                return;
            }

            function format(state) {
                if (!state.id) return state.text; // optgroup
                return "<img class='flag' src='../../assets/global/img/flags/" + state.id.toLowerCase() + ".png'/>&nbsp;&nbsp;" + state.text;
            }

            jQuery("#country_list").select2({
                placeholder: "Select",
                allowClear: true,
                formatResult: format,
                formatSelection: format,
                escapeMarkup: function (m) {
                    return m;
                }
            });

            var form = jQuery('#submit_form');
            var error = jQuery('.alert-danger', form);
            var success = jQuery('.alert-success', form);

            form.validate({
                doNotHideMessage: true, //this option enables to show the error/success messages on tab switch.
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                rules: {
                    //account
                    username: {
                        minlength: 5,
                        required: true
                    },
                    password: {
                        minlength: 5,
                        required: true
                    },
                    rpassword: {
                        minlength: 5,
                        required: true,
                        equalTo: "#submit_form_password"
                    },
                    //profile
                    fullname: {
                        required: true
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required: true
                    },
                    gender: {
                        required: true
                    },
                    address: {
                        required: true
                    },
                    city: {
                        required: true
                    },
                    country: {
                        required: true
                    },
                    //payment
                    card_name: {
                        required: true
                    },
                    card_number: {
                        minlength: 16,
                        maxlength: 16,
                        required: true
                    },
                    card_cvc: {
                        digits: true,
                        required: true,
                        minlength: 3,
                        maxlength: 4
                    },
                    card_expiry_date: {
                        required: true
                    },
                    'payment[]': {
                        required: true,
                        minlength: 1
                    }
                },

                messages: { // custom messages for radio buttons and checkboxes
                    'payment[]': {
                        required: "Please select at least one option",
                        minlength: jQuery.validator.format("Please select at least one option")
                    }
                },

                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.attr("name") == "gender") { // for uniform radio buttons, insert the after the given container
                        error.insertAfter("#form_gender_error");
                    } else if (element.attr("name") == "payment[]") { // for uniform radio buttons, insert the after the given container
                        error.insertAfter("#form_payment_error");
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }
                },

                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success.hide();
                    error.show();
                    ASC_ADMIN.scrollTo(error, -200);
                },

                highlight: function (element) { // hightlight error inputs
                    jQuery(element)
                        .closest('.form-group').removeClass('has-success').addClass('has-error'); // set error class to the control group
                },

                unhighlight: function (element) { // revert the change done by hightlight
                    jQuery(element)
                        .closest('.form-group').removeClass('has-error'); // set error class to the control group
                },

                success: function (label) {
                    if (label.attr("for") == "gender" || label.attr("for") == "payment[]") { // for checkboxes and radio buttons, no need to show OK icon
                        label
                            .closest('.form-group').removeClass('has-error').addClass('has-success');
                        label.remove(); // remove error label here
                    } else { // display success icon for other inputs
                        label
                            .addClass('valid') // mark the current input as valid and display OK icon
                        .closest('.form-group').removeClass('has-error').addClass('has-success'); // set success class to the control group
                    }
                },

                submitHandler: function (form) {
                    success.show();
                    error.hide();
                    //add here some ajax code to submit your form or just call form.submit() if you want to submit the form without ajax
                }

            });

            var displayConfirm = function() {
                jQuery('#tab4 .form-control-static', form).each(function(){
                    var input = jQuery('[name="'+jQuery(this).attr("data-display")+'"]', form);
                    if (input.is(":radio")) {
                        input = jQuery('[name="'+jQuery(this).attr("data-display")+'"]:checked', form);
                    }
                    if (input.is(":text") || input.is("textarea")) {
                        jQuery(this).html(input.val());
                    } else if (input.is("select")) {
                        jQuery(this).html(input.find('option:selected').text());
                    } else if (input.is(":radio") && input.is(":checked")) {
                        jQuery(this).html(input.attr("data-title"));
                    } else if (jQuery(this).attr("data-display") == 'payment') {
                        var payment = [];
                        jQuery('[name="payment[]"]:checked').each(function(){
                            payment.push(jQuery(this).attr('data-title'));
                        });
                        jQuery(this).html(payment.join("<br>"));
                    }
                });
            }

            var handleTitle = function(tab, navigation, index) {
                var total = navigation.find('li').length;
                var current = index + 1;
                // set wizard title
                jQuery('.step-title', jQuery('#form_setup_guide_wizard')).text('Step ' + (index + 1) + ' of ' + total);
                // set done steps
                jQuery('li', jQuery('#form_setup_guide_wizard')).removeClass("done");
                var li_list = navigation.find('li');
                for (var i = 0; i < index; i++) {
                    jQuery(li_list[i]).addClass("done");
                }

                if (current == 1) {
                    jQuery('#form_setup_guide_wizard').find('.button-previous').hide();
                } else {
                    jQuery('#form_setup_guide_wizard').find('.button-previous').show();
                }

                if (current >= total) {
                    jQuery('#form_setup_guide_wizard').find('.button-next').hide();
                    jQuery('#form_setup_guide_wizard').find('.button-submit').show();
                    displayConfirm();
                } else {
                    jQuery('#form_setup_guide_wizard').find('.button-next').show();
                    jQuery('#form_setup_guide_wizard').find('.button-submit').hide();
                }
                ASC_ADMIN.scrollTo(jQuery('.page-title'));
            }

            // default form wizard
            jQuery('#form_setup_guide_wizard').bootstrapWizard({
                'nextSelector': '.button-next',
                'previousSelector': '.button-previous',
                onTabClick: function (tab, navigation, index, clickedIndex) {
                    //return false;
                    
                    success.hide();
                    error.hide();
                    if (form.valid() == false) {
                        return false;
                    }
                    handleTitle(tab, navigation, clickedIndex);
                    
                },
                onNext: function (tab, navigation, index) {
                    success.hide();
                    error.hide();

                    if (form.valid() == false) {
                        return false;
                    }

                    handleTitle(tab, navigation, index);
                },
                onPrevious: function (tab, navigation, index) {
                    success.hide();
                    error.hide();

                    handleTitle(tab, navigation, index);
                },
                onTabShow: function (tab, navigation, index) {
                    var total = navigation.find('li').length;
                    var current = index + 1;
                    var jQuerypercent = (current / total) * 100;
                    jQuery('#form_setup_guide_wizard').find('.progress-bar').css({
                        width: jQuerypercent + '%'
                    });
                }
            });

            jQuery('#form_setup_guide_wizard').find('.button-previous').hide();
            jQuery('#form_setup_guide_wizard .button-submit').click(function () {
				jQuery('#form_setup_guide_wizard').hide();
/*				jQuery.post(
					"jquery_ajax_handler.php"
					,{
						 'asc_action':"UpdateApplicationSettings"
						,'group':"WIZARD_SETTINGS"
						,'ApplicationSettingsMap[WIZARD_SETTINGS][STORE_SETUP_GUIDE_HIDE]':"HIDE"

					}
					,function(data,status){
						jQuery("#form_setup_guide_wizard").hide();
					}
				);
*/
            }).hide();
        }

    };

}();
