<?php

namespace JeroenDesloovere\XmpMetadataExtractor;

use PHPUnit\Framework\TestCase;

/**
 * How to execute all tests: `vendor/bin/phpunit`
 */
class XmpMetadataExtractorTest extends TestCase
{
    private $xmpString = '<x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="XMP Core 5.4.0"> <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"> <rdf:Description rdf:about="" xmlns:xmp="http://ns.adobe.com/xap/1.0/" xmlns:aux="http://ns.adobe.com/exif/1.0/aux/" xmlns:photoshop="http://ns.adobe.com/photoshop/1.0/" xmlns:xmpMM="http://ns.adobe.com/xap/1.0/mm/" xmlns:stEvt="http://ns.adobe.com/xap/1.0/sType/ResourceEvent#" xmlns:stRef="http://ns.adobe.com/xap/1.0/sType/ResourceRef#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:crs="http://ns.adobe.com/camera-raw-settings/1.0/" xmlns:xmpRights="http://ns.adobe.com/xap/1.0/rights/" xmlns:pdf="http://ns.adobe.com/pdf/1.3/" xmlns:Xservice="http://ns.Xservice.net/1.0/" xmlns:lr="http://ns.adobe.com/lightroom/1.0/" xmlns:MicrosoftPhoto="http://ns.microsoft.com/photo/1.0" xmp:ModifyDate="2017-06-29T09:10:58+02:00" xmp:CreateDate="2016-08-24T13:33:14" xmp:Label="Second" xmp:MetadataDate="2017-06-29T09:10:58+02:00" xmp:CreatorTool="Adobe Photoshop CS6 (Macintosh)" aux:SerialNumber="033021000966" aux:LensInfo="24/1 24/1 0/0 0/0" aux:Lens="TS-E24mm f/3.5L" aux:LensID="125" aux:LensSerialNumber="0000000000" aux:ImageNumber="0" aux:FlashCompensation="0/1" aux:Firmware="1.0.1" aux:DistortionCorrectionAlreadyApplied="True" aux:VignetteCorrectionAlreadyApplied="True" photoshop:DateCreated="2016-08-24T13:33:14" photoshop:ColorMode="3" photoshop:ICCProfile="Adobe RGB (1998)" photoshop:Country="België" photoshop:State="Hasselt" photoshop:City="Kuringen" xmpMM:DocumentID="xmp.did:2d7d4d64-74e9-42f8-8b36-6440bfe81732" xmpMM:OriginalDocumentID="1B24516D6066CF48B1FB14ECF0A26412" xmpMM:InstanceID="xmp.iid:235A55BC2320681183D1943B54B3F532" dc:format="image/jpeg" crs:RawFileName="20160824_Stadsbader Decathlon Kuringen_0027.CR2" crs:Version="9.6" crs:ProcessVersion="6.7" crs:WhiteBalance="As Shot" crs:AutoWhiteVersion="134348800" crs:Temperature="5350" crs:Tint="+9" crs:Saturation="0" crs:Sharpness="44" crs:LuminanceSmoothing="0" crs:ColorNoiseReduction="25" crs:VignetteAmount="0" crs:ShadowTint="0" crs:RedHue="0" crs:RedSaturation="0" crs:GreenHue="0" crs:GreenSaturation="0" crs:BlueHue="0" crs:BlueSaturation="0" crs:Vibrance="0" crs:HueAdjustmentRed="0" crs:HueAdjustmentOrange="0" crs:HueAdjustmentYellow="0" crs:HueAdjustmentGreen="0" crs:HueAdjustmentAqua="0" crs:HueAdjustmentBlue="0" crs:HueAdjustmentPurple="0" crs:HueAdjustmentMagenta="0" crs:SaturationAdjustmentRed="0" crs:SaturationAdjustmentOrange="0" crs:SaturationAdjustmentYellow="0" crs:SaturationAdjustmentGreen="0" crs:SaturationAdjustmentAqua="0" crs:SaturationAdjustmentBlue="0" crs:SaturationAdjustmentPurple="0" crs:SaturationAdjustmentMagenta="0" crs:LuminanceAdjustmentRed="0" crs:LuminanceAdjustmentOrange="0" crs:LuminanceAdjustmentYellow="0" crs:LuminanceAdjustmentGreen="0" crs:LuminanceAdjustmentAqua="0" crs:LuminanceAdjustmentBlue="0" crs:LuminanceAdjustmentPurple="0" crs:LuminanceAdjustmentMagenta="0" crs:SplitToningShadowHue="0" crs:SplitToningShadowSaturation="0" crs:SplitToningHighlightHue="0" crs:SplitToningHighlightSaturation="0" crs:SplitToningBalance="0" crs:ParametricShadows="0" crs:ParametricDarks="0" crs:ParametricLights="+13" crs:ParametricHighlights="0" crs:ParametricShadowSplit="25" crs:ParametricMidtoneSplit="50" crs:ParametricHighlightSplit="75" crs:SharpenRadius="+1.0" crs:SharpenDetail="25" crs:SharpenEdgeMasking="0" crs:PostCropVignetteAmount="0" crs:GrainAmount="0" crs:ColorNoiseReductionDetail="50" crs:ColorNoiseReductionSmoothness="50" crs:LensProfileEnable="1" crs:LensManualDistortionAmount="0" crs:PerspectiveVertical="0" crs:PerspectiveHorizontal="0" crs:PerspectiveRotate="0.0" crs:PerspectiveScale="100" crs:PerspectiveAspect="0" crs:PerspectiveUpright="1" crs:PerspectiveX="0.00" crs:PerspectiveY="0.00" crs:AutoLateralCA="0" crs:Exposure2012="0.00" crs:Contrast2012="0" crs:Highlights2012="-73" crs:Shadows2012="+76" crs:Whites2012="+8" crs:Blacks2012="0" crs:Clarity2012="+14" crs:DefringePurpleAmount="0" crs:DefringePurpleHueLo="30" crs:DefringePurpleHueHi="70" crs:DefringeGreenAmount="0" crs:DefringeGreenHueLo="40" crs:DefringeGreenHueHi="60" crs:Dehaze="0" crs:ToneMapStrength="0" crs:ConvertToGrayscale="False" crs:ToneCurveName="Medium Contrast" crs:ToneCurveName2012="Linear" crs:CameraProfile="Adobe Standard" crs:CameraProfileDigest="FE9396000CB53BFBEC6C0CAA459E08BB" crs:LensProfileSetup="Custom" crs:LensProfileName="Adobe (Canon EF 24mm f/1.4 L USM)" crs:LensProfileFilename="Canon EOS 5D Mark II (Canon EF 24mm f1.4 L USM) - RAW.lcp" crs:LensProfileDigest="0C5957B94E14AC0D4D515C1ED65AD715" crs:LensProfileDistortionScale="100" crs:LensProfileChromaticAberrationScale="100" crs:LensProfileVignettingScale="100" crs:UprightVersion="151388160" crs:UprightCenterMode="0" crs:UprightCenterNormX="0.507640911" crs:UprightCenterNormY="0.75710438" crs:UprightFocalMode="0" crs:UprightFocalLength35mm="23.964294543" crs:UprightPreview="False" crs:UprightDependentDigest="922815E3FAA3D27B3C0DEEB2EE557130" crs:UprightTransformCount="6" crs:UprightTransform_0="1.000000000,0.000000000,0.000000000,0.000000000,1.000000000,0.000000000,0.000000000,0.000000000,1.000000000" crs:UprightTransform_1="1.020757570,-0.003876258,-0.003946116,0.020116755,1.029734313,-0.019943801,0.000021699,0.009942966,1.000000000" crs:UprightTransform_2="4.944438452,0.010787470,-0.597090085,2.274840372,2.047799193,-0.922201935,3.314035427,0.044100410,1.000000000" crs:UprightTransform_3="1.019492465,-0.008910637,-0.005290914,0.020048934,1.019492465,-0.019770699,0.000000000,0.000000000,1.000000000" crs:UprightTransform_4="1.027215622,0.005335410,-0.006535422,0.018202736,1.047720343,-0.019746712,0.000086222,0.026332402,1.000000000" crs:UprightTransform_5="1.000000000,0.000000000,0.000000000,0.000000000,1.000000000,0.000000000,0.000000000,0.000000000,1.000000000" crs:UprightFourSegmentsCount="0" crs:HasSettings="True" crs:HasCrop="False" crs:AlreadyApplied="True" xmpRights:Marked="True" pdf:Keywords="Werfnummer|SF15-0255-BO Redevco Kuringen" Xservice:realization="Redevco"> <photoshop:SupplementalCategories> <rdf:Bag> <rdf:li>Siergranulaat: Glad wit</rdf:li> </rdf:Bag> </photoshop:SupplementalCategories> <xmpMM:History> <rdf:Seq> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:50989C760C206811822AF7B251F106FE" stEvt:when="2016-09-09T09:35:02+02:00" stEvt:softwareAgent="Adobe Photoshop Camera Raw 9.1" stEvt:changed="/metadata"/> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:73047091-3d13-4613-b93d-0eefcd5a99d1" stEvt:when="2016-09-09T09:43:06+02:00" stEvt:softwareAgent="Adobe Photoshop Camera Raw 9.6 (Macintosh)" stEvt:changed="/metadata"/> <rdf:li stEvt:action="derived" stEvt:parameters="converted from image/x-canon-cr2 to image/tiff, saved to new location"/> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:2d7d4d64-74e9-42f8-8b36-6440bfe81732" stEvt:when="2016-09-09T10:54:58+02:00" stEvt:softwareAgent="Adobe Photoshop Camera Raw 9.6 (Macintosh)" stEvt:changed="/"/> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:bb485215-6dbb-42e2-8fec-4f93016142f0" stEvt:when="2016-09-09T13:21:54+02:00" stEvt:softwareAgent="Adobe Photoshop CC 2014 (Macintosh)" stEvt:changed="/"/> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:974CB79D2C206811822AF7B251F106FE" stEvt:when="2016-09-09T13:25:13+02:00" stEvt:softwareAgent="Adobe Bridge CS6 (Macintosh)" stEvt:changed="/metadata"/> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:225A55BC2320681183D1943B54B3F532" stEvt:when="2016-09-09T13:33:16+02:00" stEvt:softwareAgent="Adobe Photoshop CS6 (Macintosh)" stEvt:changed="/"/> <rdf:li stEvt:action="converted" stEvt:parameters="from image/tiff to image/jpeg"/> <rdf:li stEvt:action="saved" stEvt:instanceID="xmp.iid:235A55BC2320681183D1943B54B3F532" stEvt:when="2016-09-09T13:33:16+02:00" stEvt:softwareAgent="Adobe Photoshop CS6 (Macintosh)" stEvt:changed="/"/> </rdf:Seq> </xmpMM:History> <xmpMM:DerivedFrom stRef:instanceID="xmp.iid:73047091-3d13-4613-b93d-0eefcd5a99d1" stRef:documentID="1B24516D6066CF48B1FB14ECF0A26412" stRef:originalDocumentID="1B24516D6066CF48B1FB14ECF0A26412"/> <dc:rights> <rdf:Alt> <rdf:li xml:lang="x-default">Annick Vernimmen</rdf:li> </rdf:Alt> </dc:rights> <dc:subject> <rdf:Bag> <rdf:li>Werfnummer|SF15-0255-BO Redevco Kuringen</rdf:li> </rdf:Bag> </dc:subject> <crs:ToneCurve> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>32, 22</rdf:li> <rdf:li>64, 56</rdf:li> <rdf:li>128, 128</rdf:li> <rdf:li>192, 196</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurve> <crs:ToneCurveRed> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurveRed> <crs:ToneCurveGreen> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurveGreen> <crs:ToneCurveBlue> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurveBlue> <crs:ToneCurvePV2012> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurvePV2012> <crs:ToneCurvePV2012Red> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurvePV2012Red> <crs:ToneCurvePV2012Green> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurvePV2012Green> <crs:ToneCurvePV2012Blue> <rdf:Seq> <rdf:li>0, 0</rdf:li> <rdf:li>255, 255</rdf:li> </rdf:Seq> </crs:ToneCurvePV2012Blue> <Xservice:sector> <rdf:Bag> <rdf:li>Retail</rdf:li> </rdf:Bag> </Xservice:sector> <Xservice:construction__type> <rdf:Bag> <rdf:li>Winkel</rdf:li> </rdf:Bag> </Xservice:construction__type> <Xservice:materials__used> <rdf:Bag> <rdf:li>Glad wit</rdf:li> </rdf:Bag> </Xservice:materials__used> <lr:hierarchicalSubject> <rdf:Bag> <rdf:li>Werfnummer|SF15-0255-BO Redevco Kuringen</rdf:li> </rdf:Bag> </lr:hierarchicalSubject> <MicrosoftPhoto:LastKeywordIPTC> <rdf:Bag> <rdf:li>Werfnummer|SF15-0255-BO Redevco Kuringen</rdf:li> </rdf:Bag> </MicrosoftPhoto:LastKeywordIPTC> <MicrosoftPhoto:LastKeywordXMP> <rdf:Bag> <rdf:li>Werfnummer|SF15-0255-BO Redevco Kuringen</rdf:li> </rdf:Bag> </MicrosoftPhoto:LastKeywordXMP> </rdf:Description> </rdf:RDF> </x:xmpmeta>';

    private $xmpString2 = '<x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="XMP Core 5.6.0"> <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"> <rdf:Description rdf:about="" xmlns:photoshop="http://ns.adobe.com/photoshop/1.0/" xmlns:Xservice="http://ns.Xservice.net/1.0/" xmlns:xmp="http://ns.adobe.com/xap/1.0/" xmlns:lr="http://ns.adobe.com/lightroom/1.0/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:MicrosoftPhoto="http://ns.microsoft.com/photo/1.0" photoshop:DateCreated="2017-02-10T10:49:14+01:00" photoshop:ICCProfile="sRGB IEC61966-2.1" Xservice:architect="Bureau D\'Hondt bvba" Xservice:surface__area="50000" Xservice:geo__longitude="3.41205930000001" Xservice:geo__latitude="50.8574846" xmp:CreatorTool="Daminion - http://Xservice.net" xmp:MetadataDate="2017-11-22T17:06:24+01:00" xmp:ModifyDate="2017-11-22T17:06:24+01:00"> <Xservice:sector> <rdf:Bag> <rdf:li>Retail</rdf:li> </rdf:Bag> </Xservice:sector> <Xservice:construction__type> <rdf:Bag> <rdf:li>Logistiek</rdf:li> </rdf:Bag> </Xservice:construction__type> <Xservice:materials__used> <rdf:Bag> <rdf:li>Glad Grijs</rdf:li> </rdf:Bag> </Xservice:materials__used> <Xservice:customer> <rdf:Bag> <rdf:li>TVH Rental Equipment Division nv</rdf:li> </rdf:Bag> </Xservice:customer> <Xservice:specials> <rdf:Bag> <rdf:li>Breeam</rdf:li> <rdf:li>Benor</rdf:li> </rdf:Bag> </Xservice:specials> <lr:hierarchicalSubject> <rdf:Bag> <rdf:li>Werfnummer|SF16-0213-PR TVH Waregem</rdf:li> </rdf:Bag> </lr:hierarchicalSubject> <dc:subject> <rdf:Bag> <rdf:li>Werfnummer|SF16-0213-PR TVH Waregem</rdf:li> </rdf:Bag> </dc:subject> <dc:creator> <rdf:Seq/> </dc:creator> <MicrosoftPhoto:LastKeywordIPTC> <rdf:Bag> <rdf:li>Werfnummer|SF16-0213-PR TVH Waregem</rdf:li> </rdf:Bag> </MicrosoftPhoto:LastKeywordIPTC> <MicrosoftPhoto:LastKeywordXMP> <rdf:Bag> <rdf:li>Werfnummer|SF16-0213-PR TVH Waregem</rdf:li> </rdf:Bag> </MicrosoftPhoto:LastKeywordXMP> </rdf:Description> </rdf:RDF> </x:xmpmeta>';

    public function testXmpString(): void
    {
        $extractor = new XmpMetadataExtractor();
        $array = $extractor->extractFromContent($this->xmpString);
        $this->assertEquals(true, array_key_exists('rdf:RDF', $array));
        $this->assertEquals(true, array_key_exists('rdf:Description', $array['rdf:RDF']));
        $this->assertEquals(true, array_key_exists('@attributes', $array));
        $this->assertEquals(true, array_key_exists('@root', $array));
        $this->assertEquals('Glad wit', $array['rdf:RDF']['rdf:Description']['Xservice:materials__used']);
    }

    public function testXmpString2(): void
    {
        $extractor = new XmpMetadataExtractor();
        $array = $extractor->extractFromContent($this->xmpString2);
        $this->assertEquals(true, is_array($array));
    }

    public function testNoXmpData(): void
    {
        $extractor = new XmpMetadataExtractor();

        $this->assertEquals([], $extractor->extractFromContent(''));
    }
}
