
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `fusion91030`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin`
--

CREATE TABLE `[[dbprefix]]admin` (
  `admin_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `admin_rights` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `admin_image` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `admin_title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `admin_link` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'reserved',
  `admin_page` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `admin_language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  PRIMARY KEY (`admin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=36 ;

--
-- Dumping data for table `[[dbprefix]]admin`
--

INSERT INTO `[[dbprefix]]admin` VALUES
(1, 'AD', 'administrator.png', 'Administrators', 'administrators.php', 2, 'English'),
(2, 'APWR', 'adminpass.png', 'Admin Password Reset', 'admin_reset.php', 2, 'English'),
(3, 'SB', 'banner.png', 'Banners', 'banners.php', 3, 'English'),
(4, 'BB', 'bbcodes.png', 'BB Codes', 'bbcodes.php', 3, 'English'),
(5, 'B', 'blacklist.png', 'Blacklist', 'blacklist.php', 2, 'English'),
(6, 'C', 'comments.png', 'Comments', 'comments.php', 1, 'English'),
(7, 'CP', 'c-pages.png', 'Custom Pages', 'custom_pages.php', 1, 'English'),
(8, 'DB', 'db_backup.png', 'Database Backup', 'db_backup.php', 3, 'English'),
(9, 'ERRO', 'errors.png', 'Error Log', 'errors.php', 3, 'English'),
(10, 'IM', 'images.png', 'Images', 'images.php', 1, 'English'),
(11, 'I', 'infusions.png', 'Infusions', 'infusions.php', 3, 'English'),
(12, 'IP', '', 'Infusion Panels', 'reserved', 3, 'English'),
(13, 'M', 'members.png', 'Members', 'members.php', 2, 'English'),
(14, 'MI', 'migration.png', 'Migration Tool', 'migrate.php', 2, 'English'),
(15, 'P', 'panels.png', 'Panels', 'panels.php', 3, 'English'),
(16, 'PL', 'permalink.png', 'Permalinks', 'permalink.php', 3, 'English'),
(17, 'PI', 'serverinfo.png', 'Server Info', 'serverinfo.php', 3, 'English'),
(18, 'SL', 'sitelinks.png', 'Site Links', 'site_links.php', 3, 'English'),
(19, 'SM', 'smileys.png', 'Smileys', 'smileys.php', 3, 'English'),
(20, 'U', 'upgrade.png', 'Upgrade', 'upgrade.php', 3, 'English'),
(21, 'TS', 'theme.png', 'Theme Manager', 'theme.php', 3, 'English'),
(22, 'UG', 'user_groups.png', 'User Groups', 'user_groups.php', 2, 'English'),
(23, 'S1', 'settings.png', 'Main', 'settings_main.php', 4, 'English'),
(24, 'S2', 'time.png', 'Time and Date', 'settings_time.php', 4, 'English'),
(25, 'S4', 'registration.png', 'Registration', 'settings_registration.php', 4, 'English'),
(26, 'S6', 'misc.png', 'Miscellaneous', 'settings_misc.php', 4, 'English'),
(27, 'S7', 'pm.png', 'Private Message', 'settings_messages.php', 4, 'English'),
(28, 'S9', 'user_settings.png', 'User Management', 'settings_users.php', 4, 'English'),
(29, 'S12', 'security.png', 'Security', 'settings_security.php', 4, 'English'),
(30, 'UF', 'user_fields.png', 'User Fields', 'user_fields.php', 2, 'English'),
(31, 'UL', 'user_log.png', 'User Log', 'user_log.php', 2, 'English'),
(32, 'ROB', 'robots.png', 'robots.txt', 'robots.php', 3, 'English'),
(33, 'MAIL', 'email.png', 'Email Templates', 'email.php', 3, 'English'),
(34, 'LANG', 'language.png', 'Language Settings', 'settings_languages.php', 4, 'English'),
(35, 'FM', 'file_manager.png', 'Fusion File Manager', 'file_manager.php', 1, 'English');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admin_resetlog`
--

CREATE TABLE `[[dbprefix]]admin_resetlog` (
  `reset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `reset_admin_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `reset_timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `reset_sucess` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reset_failed` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reset_admins` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `reset_reason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`reset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bbcodes`
--

CREATE TABLE `[[dbprefix]]bbcodes` (
  `bbcode_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `bbcode_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `bbcode_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bbcode_id`),
  KEY `bbcode_order` (`bbcode_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]bbcodes`
--

INSERT INTO `[[dbprefix]]bbcodes` VALUES
(1, 'smiley', 1),
(2, 'b', 2),
(3, 'i', 3),
(4, 'u', 4),
(5, 'url', 5),
(6, 'mail', 6),
(7, 'img', 7),
(8, 'center', 8),
(9, 'small', 9),
(10, 'code', 10),
(11, 'quote', 11);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blacklist`
--

CREATE TABLE `[[dbprefix]]blacklist` (
  `blacklist_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blacklist_user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `blacklist_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `blacklist_ip_type` tinyint(1) NOT NULL DEFAULT '4',
  `blacklist_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `blacklist_reason` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `blacklist_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`blacklist_id`),
  KEY `blacklist_ip_type` (`blacklist_ip_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `comment_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_type` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_cat` bigint(20) NOT NULL DEFAULT '0',
  `comment_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_subject` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `comment_ip_type` tinyint(1) NOT NULL DEFAULT '4',
  `comment_hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `comment_datestamp` (`comment_datestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_pages`
--

CREATE TABLE `[[dbprefix]]custom_pages` (
  `page_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_cat` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_link_cat` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_title` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_access` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `page_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_keywords` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_status` smallint(1) NOT NULL DEFAULT '0',
  `page_breaks` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_user` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `page_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `page_language` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  `page_grid_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_content_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_left_panel` tinyint(1) NOT NULL DEFAULT '0',
  `page_right_panel` tinyint(1) NOT NULL DEFAULT '0',
  `page_header_panel` tinyint(1) NOT NULL DEFAULT '0',
  `page_footer_panel` tinyint(1) NOT NULL DEFAULT '0',
  `page_top_panel` tinyint(1) NOT NULL DEFAULT '0',
  `page_bottom_panel` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`),
  KEY `page_content_id` (`page_content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_pages_content`
--

CREATE TABLE `[[dbprefix]]custom_pages_content` (
  `page_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_grid_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_content_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_content_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_content_order` tinyint(5) unsigned NOT NULL DEFAULT '0',
  `page_widget` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_content_id`),
  KEY `page_grid_id` (`page_grid_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_pages_grid`
--

CREATE TABLE `[[dbprefix]]custom_pages_grid` (
  `page_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `page_grid_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_grid_container` tinyint(1) NOT NULL DEFAULT '0',
  `page_grid_column_count` tinyint(1) NOT NULL DEFAULT '0',
  `page_grid_html_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_grid_class` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_grid_order` tinyint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_grid_id`),
  KEY `page_id` (`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_templates`
--

CREATE TABLE `[[dbprefix]]email_templates` (
  `template_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `template_key` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `template_format` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `template_active` tinyint(1) NOT NULL DEFAULT '0',
  `template_name` varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `template_subject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `template_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `template_sender_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `template_sender_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `template_language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]email_templates`
--

INSERT INTO `[[dbprefix]]email_templates` VALUES
(1, 'PM', 'html', 0, 'Notification on new PM', 'You have a new private message from [USER] waiting at [SITENAME]', 'Hello [RECEIVER],<br/>You have received a new Private Message titled [SUBJECT] from [USER] at [SITENAME]. You can read your private message at <a href=''[SITEURL]messages.php''>[SITEURL]messages.php</a><br/>Message: [MESSAGE]<br/>You can disable email notification through the options panel of the Private Message page if you no longer wish to be notified of new messages.<br/>Regards,<br/>[SENDER].', '', '', 'English'),
(2, 'POST', 'html', 0, 'Notification on new forum posts', 'Thread Reply Notification - [SUBJECT]', 'Hello [RECEIVER],<br/>A reply has been posted in the forum thread ''[SUBJECT]'' which you are tracking at [SITENAME]. You can use the following link to view the reply:<br/>[THREAD_URL]<br/>If you no longer wish to watch this thread you can click the ''Stop tracking this thread'' link located at the top of the thread.<br/>Regards,<br/>[SENDER].', '', '', 'English'),
(3, 'CONTACT', 'html', 0, 'Contact form', '[SUBJECT]', '[MESSAGE]', '', '', 'English');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_verify`
--

CREATE TABLE `[[dbprefix]]email_verify` (
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `user_datestamp` (`user_datestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]errors`
--

CREATE TABLE `[[dbprefix]]errors` (
  `error_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `error_level` smallint(5) unsigned NOT NULL DEFAULT '0',
  `error_message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `error_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `error_line` smallint(5) unsigned NOT NULL DEFAULT '0',
  `error_page` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `error_user_level` tinyint(4) NOT NULL DEFAULT '0',
  `error_user_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `error_user_ip_type` tinyint(1) NOT NULL DEFAULT '4',
  `error_status` tinyint(1) NOT NULL DEFAULT '0',
  `error_timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`error_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]flood_control`
--

CREATE TABLE `[[dbprefix]]flood_control` (
  `flood_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `flood_ip_type` tinyint(1) NOT NULL DEFAULT '4',
  `flood_timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `flood_timestamp` (`flood_timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]infusions`
--

CREATE TABLE `[[dbprefix]]infusions` (
  `inf_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `inf_title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `inf_folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `inf_version` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`inf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language_sessions`
--

CREATE TABLE `[[dbprefix]]language_sessions` (
  `user_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  `user_language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  `user_datestamp` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `message_to` bigint(20) unsigned NOT NULL DEFAULT '0',
  `message_from` bigint(20) unsigned NOT NULL DEFAULT '0',
  `message_user` bigint(20) unsigned NOT NULL DEFAULT '0',
  `message_subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message_message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `message_smileys` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message_read` smallint(1) NOT NULL DEFAULT '0',
  `message_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `message_folder` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`),
  KEY `message_datestamp` (`message_datestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mlt_tables`
--

CREATE TABLE `[[dbprefix]]mlt_tables` (
  `mlt_rights` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mlt_title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mlt_status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`mlt_rights`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]mlt_tables`
--

INSERT INTO `[[dbprefix]]mlt_tables` VALUES
('SL', 'Site Links', '1'),
('CP', 'Custom Pages', '1'),
('ET', 'Email Templates', '1'),
('PN', 'Panels', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]new_users`
--

CREATE TABLE `[[dbprefix]]new_users` (
  `user_code` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `user_info` text COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `user_datestamp` (`user_datestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]online`
--

CREATE TABLE `[[dbprefix]]online` (
  `online_user` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `online_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `online_ip_type` tinyint(1) unsigned NOT NULL DEFAULT '4',
  `online_lastactive` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]online`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]panels`
--

CREATE TABLE `[[dbprefix]]panels` (
  `panel_id` mediumint(11) unsigned NOT NULL AUTO_INCREMENT,
  `panel_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `panel_filename` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `panel_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `panel_side` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `panel_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `panel_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `panel_php_exe` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `panel_access` tinyint(4) NOT NULL DEFAULT '0',
  `panel_display` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `panel_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `panel_url_list` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `panel_restriction` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `panel_languages` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  PRIMARY KEY (`panel_id`),
  KEY `panel_order` (`panel_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]panels`
--

INSERT INTO `[[dbprefix]]panels` VALUES
(1, 'Navigation', 'css_navigation_panel', '', 1, 1, 'file', 0, 0, 1, 1, '', 3, 'English'),
(2, 'RSS', 'rss_feeds_panel', '', 1, 2, 'file', 0, 0, 0, 1, '', 2, 'English'),
(3, 'Online Users', 'online_users_panel', '', 1, 3, 'file', 0, 0, 1, 1, '', 3, 'English'),
(4, 'Welcome Message', 'welcome_message_panel', '', 2, 1, 'file', 0, 0, 0, 1, '', 2, 'English'),
(5, 'User Info', 'user_info_panel', '', 4, 1, 'file', 0, 0, 1, 1, '', 3, 'English');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permalinks_alias`
--

CREATE TABLE `[[dbprefix]]permalinks_alias` (
  `alias_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `alias_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias_php_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias_type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias_item_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`alias_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permalinks_method`
--

CREATE TABLE `[[dbprefix]]permalinks_method` (
  `pattern_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pattern_type` int(5) unsigned NOT NULL DEFAULT '0',
  `pattern_source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pattern_target` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pattern_cat` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`pattern_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permalinks_rewrites`
--

CREATE TABLE `[[dbprefix]]permalinks_rewrites` (
  `rewrite_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `rewrite_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`rewrite_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ratings`
--

CREATE TABLE `[[dbprefix]]ratings` (
  `rating_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rating_item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `rating_type` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rating_user` bigint(20) unsigned NOT NULL DEFAULT '0',
  `rating_vote` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `rating_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rating_ip_type` tinyint(1) unsigned NOT NULL DEFAULT '4',
  PRIMARY KEY (`rating_id`),
  KEY `rating_datestamp` (`rating_datestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `session_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_start` int(10) unsigned NOT NULL DEFAULT '0',
  `session_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `settings_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`settings_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('sitename', '[[site_name]]'),
('siteurl', '[[softurl]]/'),
('site_protocol', 'http'),
('site_host', '[[domhost]]'),
('site_port', ''),
('site_path', '[[relativeurl]]/'),
('site_seo', '0'),
('domain_server', ''),
('sitebanner', 'images/phpfusion-logo-d.svg'),
('sitebanner1', ''),
('sitebanner2', ''),
('siteemail', '[[site_email]]'),
('siteusername', '[[admin_username]]'),
('siteintro', '<div style=''text-align:center''>Welcome to your site</div>'),
('description', 'PHPFusion is a lightweight open source content management system (CMS) written in PHP.'),
('keywords', 'PHPFusion, CMS, Hosting, Domain, Portal, Open Source, AGPL, PHP, MySQL, HTML, CSS, JS'),
('footer', ''),
('opening_page', 'index.php'),
('locale', 'English'),
('enabled_languages', 'English'),
('theme', 'Magazine'),
('admin_theme', 'AdminLTE'),
('default_search', 'all'),
('exclude_left', ''),
('exclude_upper', ''),
('exclude_lower', ''),
('exclude_aupper', ''),
('exclude_blower', ''),
('exclude_right', ''),
('exclude_user1', ''),
('exclude_user2', ''),
('exclude_user3', ''),
('exclude_user4', ''),
('shortdate', '%d.%m.%y'),
('longdate', '%B %d %Y %H:%M:%S'),
('forumdate', '%d-%m-%Y %H:%M'),
('newsdate', '%B %d %Y'),
('timeoffset', 'America/Chicago'),
('week_start', '0'),
('enable_registration', '1'),
('email_verification', '1'),
('admin_activation', '0'),
('display_validation', '0'),
('enable_deactivation', '0'),
('deactivation_period', '365'),
('deactivation_response', '14'),
('enable_terms', '0'),
('license_agreement', ''),
('license_lastupdate', '0'),
('thumb_compression', 'gd2'),
('tinymce_enabled', '0'),
('smtp_host', ''),
('smtp_port', '25'),
('smtp_username', ''),
('smtp_password', ''),
('bad_words_enabled', '1'),
('bad_words', ''),
('bad_word_replace', '****'),
('login_method', '0'),
('guestposts', '0'),
('comments_enabled', '1'),
('ratings_enabled', '1'),
('hide_userprofiles', '0'),
('userthemes', '0'),
('flood_interval', '15'),
('counter', '1'),
('version', '9.10.30'),
('maintenance', '0'),
('maintenance_message', ''),
('links_per_page', '8'),
('links_grouping', '0'),
('link_grouping', '8'),
('link_bbcode', '0'),
('comments_per_page', '10'),
('comments_sorting', 'ASC'),
('comments_avatar', '1'),
('avatar_width', '500'),
('avatar_height', '500'),
('avatar_filesize', '1048576'),
('avatar_ratio', '0'),
('cronjob_day', '[[timestamp]]'),
('cronjob_hour', '[[timestamp]]'),
('flood_autoban', '1'),
('visitorcounter_enabled', '1'),
('rendertime_enabled', '0'),
('maintenance_level', '-102'),
('deactivation_action', '0'),
('captcha', 'securimage3'),
('password_algorithm', 'sha256'),
('username_change', '1'),
('recaptcha_public', ''),
('recaptcha_private', ''),
('recaptcha_theme', 'light'),
('recaptcha_type', 'text'),
('recaptcha_score', '0.5'),
('multiple_logins', '0'),
('smtp_auth', '0'),
('mime_check', '1'),
('normalize_seo', '0'),
('debug_seo', '0'),
('privacy_policy', ''),
('create_og_tags', '1'),
('index_url_bbcode', '1'),
('index_url_userweb', '1'),
('pm_inbox_limit', '20'),
('pm_outbox_limit', '20'),
('pm_archive_limit', '20'),
('pm_email_notify', '2'),
('pm_save_sent', '2'),
('username_ban', ''),
('database_sessions', '0'),
('form_tokens', '5'),
('gateway', '1'),
('gateway_method', '1'),
('devmode', '0'),
('update_checker', '1'),
('update_last_checked', '[[timestamp]]'),
('number_delimiter', '.'),
('thousands_separator', ','),
('error_logging_enabled', '1'),
('error_logging_method', 'database'),
('license', 'agpl');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings_inf`
--

CREATE TABLE `[[dbprefix]]settings_inf` (
  `settings_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings_inf` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`settings_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings_theme`
--

CREATE TABLE `[[dbprefix]]settings_theme` (
  `settings_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings_theme` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`settings_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_links`
--

CREATE TABLE `[[dbprefix]]site_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_cat` bigint(20) unsigned NOT NULL DEFAULT '0',
  `link_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_icon` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visibility` tinyint(4) NOT NULL DEFAULT '0',
  `link_position` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link_window` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link_order` smallint(2) unsigned NOT NULL DEFAULT '0',
  `link_language` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  PRIMARY KEY (`link_id`),
  KEY `link_order` (`link_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]site_links`
--

INSERT INTO `[[dbprefix]]site_links` VALUES
(1, 0, 'Home', 'index.php', '', 0, 2, 1, 0, 1, 'English'),
(2, 0, 'Contact', 'contact.php', '', 0, 3, 1, 0, 8, 'English'),
(3, 0, 'Search', 'search.php', '', 0, 1, 1, 0, 10, 'English');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]smileys`
--

CREATE TABLE `[[dbprefix]]smileys` (
  `smiley_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `smiley_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `smiley_image` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `smiley_text` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`smiley_id`),
  KEY `smiley_image` (`smiley_image`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]smileys`
--

INSERT INTO `[[dbprefix]]smileys` VALUES
(1, ':)', 'smile.svg', 'Smile'),
(2, ';)', 'wink.svg', 'Wink'),
(3, ':(', 'sad.svg', 'Sad'),
(4, ':|', 'frown.svg', 'Frown'),
(5, ':o', 'shock.svg', 'Shock'),
(6, ':P', 'pfft.svg', 'Pfft'),
(7, 'B)', 'cool.svg', 'Cool'),
(8, ':D', 'grin.svg', 'Grin'),
(9, ':@', 'angry.svg', 'Angry'),
(10, '(y)', 'like.svg', 'Like');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]submissions`
--

CREATE TABLE `[[dbprefix]]submissions` (
  `submit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submit_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `submit_user` bigint(20) unsigned NOT NULL DEFAULT '0',
  `submit_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `submit_criteria` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`submit_id`),
  KEY `submit_datestamp` (`submit_datestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]suspends`
--

CREATE TABLE `[[dbprefix]]suspends` (
  `suspend_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `suspended_user` bigint(20) unsigned NOT NULL DEFAULT '0',
  `suspending_admin` bigint(20) unsigned NOT NULL DEFAULT '1',
  `suspend_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `suspend_ip_type` tinyint(1) unsigned NOT NULL DEFAULT '4',
  `suspend_date` int(10) unsigned NOT NULL DEFAULT '0',
  `suspend_reason` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `suspend_type` tinyint(1) NOT NULL DEFAULT '0',
  `reinstating_admin` bigint(20) unsigned NOT NULL DEFAULT '1',
  `reinstate_reason` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reinstate_date` int(10) unsigned NOT NULL DEFAULT '0',
  `reinstate_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reinstate_ip_type` tinyint(1) unsigned NOT NULL DEFAULT '4',
  PRIMARY KEY (`suspend_id`),
  KEY `reinstating_admin` (`reinstating_admin`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]theme`
--

CREATE TABLE `[[dbprefix]]theme` (
  `theme_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `theme_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme_title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme_file` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme_datestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `theme_user` bigint(20) unsigned NOT NULL DEFAULT '0',
  `theme_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `theme_config` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`theme_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_algo` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sha256',
  `user_salt` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_password` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_admin_algo` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sha256',
  `user_admin_salt` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_admin_password` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_hide_email` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `user_timezone` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Europe/London',
  `user_avatar` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_posts` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_threads` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_joined` int(10) unsigned NOT NULL DEFAULT '0',
  `user_lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `user_ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  `user_ip_type` tinyint(1) unsigned NOT NULL DEFAULT '4',
  `user_rights` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_groups` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_level` tinyint(4) NOT NULL DEFAULT '-101',
  `user_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_inbox` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_outbox` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_archive` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_pm_email_notify` tinyint(1) NOT NULL DEFAULT '0',
  `user_pm_save_sent` tinyint(1) NOT NULL DEFAULT '0',
  `user_actiontime` int(10) unsigned NOT NULL DEFAULT '0',
  `user_session` varchar(170) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_theme` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Default',
  `user_location` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_birthdate` date NOT NULL DEFAULT '1900-01-01',
  `user_skype` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_icq` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_web` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_sig` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'English',
  PRIMARY KEY (`user_id`),
  KEY `user_status` (`user_status`),
  FULLTEXT KEY `user_name` (`user_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', 'sha256', '[[salt1]]', '[[login_pass]]', 'sha256', '[[salt]]', '[[admin_pass]]', '[[admin_email]]', 1, 'America/Chicago', '', 0, '', [[timestamp]], [[timestamp]], '[[clientip]]', 4, 'AD.APWR.B.BB.C.CP.DB.ERRO.FM.I.IM.IP.LANG.M.MAIL.MI.P.PI.PL.ROB.S1.S2.S4.S6.S7.S9.S12.SB.SL.SM.TS.U.UF.UG.UL', '', -103, 0, 0, 0, 0, 0, 0, 0, '', 'Default', '', '1900-01-01', '', '', '', '', 'English');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_fields`
--

CREATE TABLE `[[dbprefix]]user_fields` (
  `field_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `field_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `field_cat` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `field_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_default` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_error` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `field_log` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `field_registration` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `field_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `field_config` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`field_id`),
  KEY `field_order` (`field_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]user_fields`
--

INSERT INTO `[[dbprefix]]user_fields` VALUES
(1, 'Birthdate', 'user_birthdate', 3, 'file', '1900-01-01', '', '', 0, 0, 0, 2, ''),
(2, 'Location', 'user_location', 3, 'file', '', '', '', 0, 0, 0, 2, ''),
(3, 'Skype', 'user_skype', 2, 'file', '', '', '', 0, 0, 0, 1, ''),
(4, 'ICQ#', 'user_icq', 2, 'file', '', '', '', 0, 0, 0, 3, ''),
(5, 'Website', 'user_web', 3, 'file', '', '', '', 0, 0, 0, 3, ''),
(6, 'Timezone', 'user_timezone', 4, 'file', '', '', '', 0, 0, 0, 1, ''),
(7, 'Theme', 'user_theme', 4, 'file', '', '', '', 0, 0, 0, 2, ''),
(8, 'Signature', 'user_sig', 4, 'file', '', '', '', 0, 0, 0, 3, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_field_cats`
--

CREATE TABLE `[[dbprefix]]user_field_cats` (
  `field_cat_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `field_cat_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `field_cat_db` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `field_cat_index` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `field_cat_class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `field_cat_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_cat_id`),
  KEY `field_cat_order` (`field_cat_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]user_field_cats`
--

INSERT INTO `[[dbprefix]]user_field_cats` VALUES
(1, 'Profile', 0, 'users', 'user_id', 'fa fa-user', 1),
(2, 'Contact Information', 1, '', '', 'fa fa-user', 1),
(3, 'Miscellaneous Information', 1, '', '', 'fa fa-user', 2),
(4, 'Options', 1, '', '', 'fa fa-user', 3),
(5, 'Statistics', 1, '', '', 'fa fa-user', 4),
(6, 'Privacy', 1, '', '', 'fa fa-user', 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_groups`
--

CREATE TABLE `[[dbprefix]]user_groups` (
  `group_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_description` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_icon` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_log`
--

CREATE TABLE `[[dbprefix]]user_log` (
  `userlog_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `userlog_user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `userlog_field` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userlog_value_new` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `userlog_value_old` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `userlog_timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`userlog_id`),
  KEY `userlog_field` (`userlog_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
