<?php
session_start();
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


    if (isset($_POST['submit'])) {
        $uploadDir = '../../assets/images/';
        if (!empty($_FILES['photo']['tmp_name'])) {
            $originalName = basename($_FILES['photo']['name']);
            $extension = pathinfo($originalName, PATHINFO_EXTENSION);
            $newName = rand(100, 999) . '.' . $extension;
            $newFilePath = $uploadDir . $newName;

            if (move_uploaded_file($_FILES['photo']['tmp_name'], $newFilePath)) {
                $img = $newName;

                // Compression Logic
                // compressImage($newFilePath, $newFilePath, 75); // 75 is the compression quality
            } else {
                echo 'There was an error uploading the file.';
                exit;
            }
        }

        $stmt = $conn->prepare("INSERT INTO `slider`(`photo`,`heading`,`heading1`) VALUES (?,?,?)");

        $stmt->execute([$img, $_POST['heading'], $_POST['heading1']]);

        $_SESSION['success'] = "Slider Added";


        ?>
        <script>
        // Redirect to ../about_seo.php
        window.location.href = "../manage_slider.php";
    </script>
   <?php
    }



   if (isset($_POST['update'])) {
    $uploadDir = "../../assets/images/"; // Set upload directory
    $img = $_POST['old_photo_img']; // Use old photo as default

    // Check if a new image is uploaded
    if (!empty($_FILES['photo']['tmp_name'])) {
        $file_extension = pathinfo(htmlspecialchars($_FILES["photo"]["name"], ENT_QUOTES, 'UTF-8'), PATHINFO_EXTENSION);
        $new_filename = uniqid() . '.' . $file_extension;
        $filepath = $uploadDir . $new_filename;

        // Move the uploaded file to the specified directory
        if (move_uploaded_file($_FILES["photo"]["tmp_name"], $filepath)) {
            $img = $new_filename; // Set new image filename

            // Check if the old photo exists before trying to delete it
            $oldFilePath = $uploadDir . $_POST['old_photo_img'];
            if (file_exists($oldFilePath) && is_file($oldFilePath)) {
                @unlink($oldFilePath); // Delete the old image
            } else {
                echo "Old photo not found. Skipping deletion.";
            }
        } else {
            echo "Error: Failed to upload new photo.";
            exit;
        }
    }

    // Update the database with new data
    $stmt = $conn->prepare("UPDATE `slider` SET `photo`=?, `heading`=?, `heading1`=? WHERE id=?");
    $stmt->execute([$img, $_POST['heading'], $_POST['heading1'], $_POST['id']]);

    $_SESSION['success'] = "Slider Updated";
    ?>

    <script>
        // Redirect to manage_slider.php after update
        window.location.href = "../manage_slider.php";
    </script>

    <?php
}





    if (isset($_POST['del_id'])) {
        $stmt = $conn->prepare("UPDATE `slider` SET delete_status='1' where id='" . $_POST['del_id'] . "' ");

        $stmt->execute();


        $_SESSION['success'] = "Slider Deleted";

        ?>
        <script>
        // Redirect to ../about_seo.php
        window.location.href = "../manage_slider.php";
    </script>
   <?php
    }
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}


function compressImage($source, $destination, $quality)
{
    $info = getimagesize($source);
    if ($info['mime'] == 'image/jpeg') {
        $image = imagecreatefromjpeg($source);
        imagejpeg($image, $destination, $quality);
    } elseif ($info['mime'] == 'image/png') {
        $image = imagecreatefrompng($source);
        imagepng($image, $destination, round(9 - ($quality / 10))); // PNG quality ranges from 0 to 9
    }
}
