<?php
session_start();
error_reporting(0);
include '../../assets/constant/config.php';

try {
	$conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
	$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

	if (isset($_POST['submit'])) {



		$uploadDir = '../../assets/images/';
		if (!empty($_FILES['photo']['tmp_name'])) {
			$originalName = basename($_FILES['photo']['name']);
			$extension = pathinfo($originalName, PATHINFO_EXTENSION);
			$newName = rand(100, 999) . '.' . $extension;
			$newFilePath = $uploadDir . $newName;

			if (move_uploaded_file($_FILES['photo']['tmp_name'], $newFilePath)) {
				$img = $newName;

				// Compression Logic
				// compressImage($newFilePath, $newFilePath, 75); // 75 is the compression quality
			} else {
				echo 'There was an error uploading the file.';
				exit;
			}
		}



		// Using prepared statements to prevent SQL injection and htmlspecialchars for user input
		$stmt = $conn->prepare("INSERT INTO `testimonial`(`name1`,`designation` ,`comment`,`photo`) VALUES (:name1, :designation,  :comment,  :photo)");
		$stmt->bindParam(':name1', htmlspecialchars($_POST['name1'], ENT_QUOTES, 'UTF-8'));
		$stmt->bindParam(':designation', htmlspecialchars($_POST['designation'], ENT_QUOTES, 'UTF-8'));

		$stmt->bindParam(':comment', htmlspecialchars($_POST['comment'], ENT_QUOTES, 'UTF-8'));

		$stmt->bindParam(':photo', $img);
		$stmt->execute();

		$_SESSION['success'] = "Testimonial Added";

		?>
        <script>
        // Redirect to ../about_seo.php
        window.location.href = "../manage_testimonial.php";
    </script>
   <?php
	}

	if (isset($_POST['update'])) {
    $uploadDir = '../../assets/images/';
    $img = null; // Initialize image variable

    // Check if the photo field is not empty
    if (!empty($_FILES['photo']['tmp_name'])) {
        $originalName = basename($_FILES['photo']['name']);
        $extension = pathinfo($originalName, PATHINFO_EXTENSION);
        $newName = rand(100, 999) . '.' . $extension;
        $newFilePath = $uploadDir . $newName;

        // Try to move the uploaded file
        if (move_uploaded_file($_FILES['photo']['tmp_name'], $newFilePath)) {
            $img = $newName; // Set new image name
        } else {
            echo 'There was an error uploading the file.';
            exit;
        }
    } else {
        // If no new image is uploaded, keep the existing one
        $stmt = $conn->prepare("SELECT photo FROM `testimonial` WHERE id=:id");
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $img = $row['photo']; // Keep the current image
    }

    // Use prepared statements for the update query
    $stmt = $conn->prepare("UPDATE `testimonial` SET `name1`=:name1, `designation`=:designation, `comment`=:comment, `photo`=:photo WHERE id=:id");
    $stmt->bindParam(':name1', htmlspecialchars($_POST['name1'], ENT_QUOTES, 'UTF-8'));
    $stmt->bindParam(':designation', htmlspecialchars($_POST['designation'], ENT_QUOTES, 'UTF-8'));
    $stmt->bindParam(':comment', htmlspecialchars($_POST['comment'], ENT_QUOTES, 'UTF-8'));
    $stmt->bindParam(':photo', $img);
    $stmt->bindParam(':id', $_POST['id']);

    $stmt->execute();

    $_SESSION['success'] = "Testimonial Updated";
    ?>

    <script>
        // Redirect to manage_testimonial.php
        window.location.href = "../manage_testimonial.php";
    </script>

    <?php
}

	if (isset($_POST['del_id'])) {
		// Using prepared statements for SQL query and htmlspecialchars for user input
		$stmt = $conn->prepare("UPDATE `testimonial` SET delete_status='1' WHERE id=:id");
		$stmt->bindParam(':id', htmlspecialchars($_POST['del_id'], ENT_QUOTES, 'UTF-8'));

		$stmt->execute();

		$_SESSION['success'] = "Testimonial Deleted";

		?>
        <script>
        // Redirect to ../about_seo.php
        window.location.href = "../manage_testimonial.php";
    </script>
   <?php
	}
} catch (PDOException $e) {
	echo "Connection failed: " . $e->getMessage();
}


?>