<?php
session_start();
include '../../assets/constant/config.php';

try {
	$conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
	$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

	if (isset($_POST['submit'])) {
		// print_r($_POST);exit;
		$uploadDir = '../../assets/images/';
		if (!empty($_FILES['photo']['tmp_name'])) {
			$originalName = basename($_FILES['photo']['name']);
			$extension = pathinfo($originalName, PATHINFO_EXTENSION);
			$newName = rand(100, 999) . '.' . $extension;
			$newFilePath = $uploadDir . $newName;

			if (move_uploaded_file($_FILES['photo']['tmp_name'], $newFilePath)) {
				$img = $newName;

				// Compression Logic
				// compressImage($newFilePath, $newFilePath, 75); // 75 is the compression quality
			} else {
				echo 'There was an error uploading the file.';
				exit;
			}
		}

		$stmt = $conn->prepare("INSERT INTO `team`(`name1`,`designation`,`description`, `photo`) VALUES (?, ?, ?,?)");
	
$stmt->execute([

            htmlspecialchars($_POST['name1'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['designation'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['description'], ENT_QUOTES, 'UTF-8'),
            $img
           
            
        ]);

	//	$stmt->execute([$_POST['name1'],$_POST['designation'],$img, $_POST['description']]);

		$_SESSION['success'] = "Team Added";
		?>
        <script>
        // Redirect to ../about_seo.php
        window.location.href = "../manage_team.php";
    </script>
   <?php
	}

	if (isset($_POST['update'])) {
    $uploadDir = "../../assets/images/"; // Set the upload directory path
    $img = $_POST['old_photo_img']; // Default to old photo if no new file is uploaded

    // Check if a new file is uploaded
    if (!empty($_FILES['photo']['tmp_name'])) {
        $file_extension = pathinfo(htmlspecialchars($_FILES["photo"]["name"], ENT_QUOTES, 'UTF-8'), PATHINFO_EXTENSION);
        $new_filename = uniqid() . '.' . $file_extension;
        $filepath = $uploadDir . $new_filename;

        // Move the uploaded file to the correct directory
        if (move_uploaded_file($_FILES["photo"]["tmp_name"], $filepath)) {
            $img = $new_filename; // Set new file as the image

            // Optional: Compression Logic
            // compressImage($filepath, $filepath, 75); // 75 is the compression quality

            // Delete the old image if it exists
            $oldFilePath = $uploadDir . $_POST['old_photo_img'];
            if (file_exists($oldFilePath)) {
                @unlink($oldFilePath);
            } else {
                echo 'Old photo not found.';
            }
        } else {
            echo 'There was an error uploading the file.';
            exit;
        }
    }

    // Update the database record
    $stmt = $conn->prepare("UPDATE `team` SET `name1`=?, `designation`=?, `description`=?, `photo`=? WHERE id=?");
    $stmt->execute([$_POST['name1'], $_POST['designation'],$_POST['description'], $img, $_POST['id']]);

    $_SESSION['success'] = "Team Updated";
    ?>

    <script>
        // Redirect to manage_team.php after successful update
        window.location.href = "../manage_team.php";
    </script>

    <?php
}


	if (isset($_POST['del_id'])) {
		$stmt = $conn->prepare("UPDATE `team` SET delete_status='1' WHERE id=?");
		$stmt->bindParam(1, htmlspecialchars($_POST['del_id'], ENT_QUOTES, 'UTF-8'));
		$stmt->execute();

		$_SESSION['success'] = "Team Deleted";

		header("location:../manage_team.php");
	}
} catch (PDOException $e) {
	echo "Connection failed: " . $e->getMessage();
}




function compressImage($source, $destination, $quality)
{
	$info = getimagesize($source);
	if ($info['mime'] == 'image/jpeg') {
		$image = imagecreatefromjpeg($source);
		imagejpeg($image, $destination, $quality);
	} elseif ($info['mime'] == 'image/png') {
		$image = imagecreatefrompng($source);
		imagepng($image, $destination, round(9 - ($quality / 10))); // PNG quality ranges from 0 to 9
	}
}
