<?php
/****************************************************************/
/* ATutor														*/
/****************************************************************/
/* Copyright (c) 2002-2008                                      */
/* Written by Greg Gay, Joel Kronenberg & Chris Ridpath         */
/* Inclusive Design Institute                                   */
/* http://atutor.ca												*/
/*                                                              */
/* This program is free software. You can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation.				*/
/****************************************************************/
// $Id$
define('AT_INCLUDE_PATH', '../../../include/');
require (AT_INCLUDE_PATH.'vitals.inc.php');
authenticate(AT_PRIV_READING_LIST);

// initial values for form
$id = intval($_REQUEST['id']);
$title = "";
$author = "";
$comments = "";
$url = "";
$page_return = $_GET['page_return'];

// check if user has submitted form
if (isset($_POST['cancel'])) {
	$msg->addFeedback('CANCELLED');

	header('Location: display_resources.php');
	exit;
} else if (isset($_POST['submit'])) {
	$missing_fields = array();

	if (trim($_POST['title']) == '') {
		$missing_fields[] = _AT('title');
	}
	if (trim($_POST['url']) == '') {
		$missing_fields[] = _AT('url');
	}

	if ($missing_fields) {
		$missing_fields = implode(', ', $missing_fields);
		$msg->addError(array('EMPTY_FIELDS', $missing_fields));
	}

	if (!$msg->containsErrors()) {
		$_POST['title'] = validate_length($_POST['title'], 255);
		$_POST['author'] = validate_length($_POST['author'], 150);
		$_POST['url'] = $_POST['url'];
		$_POST['comments'] = validate_length($_POST['comments'], 255);
		
		if ($id == '0'){ // creating a new URL resource

			$sql = "INSERT INTO %sexternal_resources VALUES (NULL, %d,
				%d, 
				'%s', 
				'%s', 
				'', 
				'', 
				'%s',
				'',
				'%s')";
			$result = queryDB($sql, array(
			    TABLE_PREFIX, 
			    $_SESSION['course_id'], 
			    RL_TYPE_URL,
			    $_POST['title'],
			    $_POST['author'],
			    $_POST['comments'],
			    $_POST['url']));
			
			// index to new URL resource
			$id_new = at_insert_id();
			$msg->addFeedback('ACTION_COMPLETED_SUCCESSFULLY');
		} else { // modifying an existing URL resource

			$sql = "UPDATE %sexternal_resources SET title='%s', author='%s', publisher='%s', date='%s', comments='%s', id='%s' WHERE resource_id=%d AND course_id=%d";
			$result = queryDB($sql, array(TABLE_PREFIX, $_POST['title'], $_POST['author'], $_POST['publisher'], $_POST['date'], $_POST['comments'], $_POST['isbn'], $id, $_SESSION['course_id']));

			// index to URL resource
			$id_new = $id;

			$msg->addFeedback('ACTION_COMPLETED_SUCCESSFULLY');
		}

		if (trim($_POST['page_return']) != ''){
			header('Location: '. $_POST['page_return']. '?existingbook='. $id_new);
		} else {
			header('Location: index_instructor.php');
		}
		exit;
	} else { // submission contained an error, update form values for redisplay
		$title       = $stripslashes($_POST['title']);
		$author      = $stripslashes($_POST['author']);
		$url         = $stripslashes($_POST['url']); 
		$date        = $stripslashes($_POST['date']);
		$comments    = $stripslashes($_POST['comments']);
		$isbn        = $stripslashes($_POST['id']);
		$page_return = $stripslashes($_POST['page_return']);
	}
}

// is user modifying an existing URL resource?
if ($id && !isset($_POST['submit'])){
	// yes, get resource from database
	$id = intval ($_GET['id']);

	$sql = "SELECT * FROM %sexternal_resources WHERE course_id=%d AND resource_id=%d";
	$row = queryDB($sql, array(TABLE_PREFIX, $_SESSION['course_id'], $id), TRUE);
	
	if(count($row) > 0){
		$title    = AT_print($row['title'], 'input.text');
		$author   = AT_print($row['author'], 'input.text');
		$comments = AT_print($row['comments'], 'input.text');
		$url      = AT_print($row['url'], 'input.text');
	}
	// change title of page to 'edit URL resource' (default is 'add URL resource')
	$_pages['mods/_standard/reading_list/add_resource_url.php']['title_var'] = 'rl_edit_resource_url';
} else if ($id) {
	$_pages['mods/_standard/reading_list/add_resource_url.php']['title_var'] = 'rl_edit_resource_url';
}

$onload = 'document.form.name.focus();';

require(AT_INCLUDE_PATH.'header.inc.php');
?>

<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" name="form">
<input type="hidden" name="id" value="<?php echo $id ?>" />
<input type="hidden" name="page_return" value="<?php echo $page_return ?>" />

<div class="input-form">	
	<fieldset class="group_form"><legend class="group_form"><?php echo _AT('rl_add_resource_url'); ?></legend>
	<div class="row">
		<span class="required" title="<?php echo _AT('required_field'); ?>">*</span><label for="title"><?php  echo _AT('title'); ?></label><br />
		<input type="text" name="title" size="35" id="title" value="<?php echo $title; ?>" />
	</div>

	<div class="row">
		<span class="required" title="<?php echo _AT('required_field'); ?>">*</span><label for="url"><?php  echo _AT('url'); ?></label><br />
		<input type="text" name="url" size="50" id="url" value="<?php echo $url; ?>" />
	</div>

	<div class="row">
		<label for="author"><?php  echo _AT('author'); ?></label><br />
		<input type="text" name="author" size="25" id="author" value="<?php echo $author; ?>" />
	</div>

	<div class="row">
		<label for="comments"><?php  echo _AT('comment'); ?></label><br />
		<textarea name="comments" cols="30" rows="2" id="comments"><?php echo $comments; ?></textarea>
	</div>

	<div class="row buttons">
		<input type="submit" name="submit" value="<?php echo _AT('save'); ?>" accesskey="s" />
		<input type="submit" name="cancel" value="<?php echo _AT('cancel'); ?>" />
	</div>
	</fieldset>
</div>
</form>

<?php require(AT_INCLUDE_PATH.'footer.inc.php'); ?>