
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `backdrop1321`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]batch`
--

CREATE TABLE `[[dbprefix]]batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores details about batches (processes that run in…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache`
--

CREATE TABLE `[[dbprefix]]cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Generic cache table for caching things not separated out…';

--
-- Dumping data for table `[[dbprefix]]cache`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_admin_bar`
--

CREATE TABLE `[[dbprefix]]cache_admin_bar` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for Administration bar to store client-side…';

--
-- Dumping data for table `[[dbprefix]]cache_admin_bar`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_bootstrap`
--

CREATE TABLE `[[dbprefix]]cache_bootstrap` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for data required to bootstrap Backdrop, may be…';

--
-- Dumping data for table `[[dbprefix]]cache_bootstrap`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity_comment`
--

CREATE TABLE `[[dbprefix]]cache_entity_comment` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table used to store Comment entity records.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity_file`
--

CREATE TABLE `[[dbprefix]]cache_entity_file` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table used to store File entity records.';

--
-- Dumping data for table `[[dbprefix]]cache_entity_file`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity_node`
--

CREATE TABLE `[[dbprefix]]cache_entity_node` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table used to store Node entity records.';

--
-- Dumping data for table `[[dbprefix]]cache_entity_node`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity_taxonomy_term`
--

CREATE TABLE `[[dbprefix]]cache_entity_taxonomy_term` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table used to store Taxonomy Term entity records.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity_user`
--

CREATE TABLE `[[dbprefix]]cache_entity_user` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table used to store Users entity records.';

--
-- Dumping data for table `[[dbprefix]]cache_entity_user`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_field`
--

CREATE TABLE `[[dbprefix]]cache_field` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for the Field module to store already built…';

--
-- Dumping data for table `[[dbprefix]]cache_field`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_filter`
--

CREATE TABLE `[[dbprefix]]cache_filter` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for the Filter module to store already filtered…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_layout_path`
--

CREATE TABLE `[[dbprefix]]cache_layout_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table to store which layouts are active at a given…';

--
-- Dumping data for table `[[dbprefix]]cache_layout_path`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_menu`
--

CREATE TABLE `[[dbprefix]]cache_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for the menu system to store router information…';

--
-- Dumping data for table `[[dbprefix]]cache_menu`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_page`
--

CREATE TABLE `[[dbprefix]]cache_page` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table used to store compressed pages for anonymous…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_path`
--

CREATE TABLE `[[dbprefix]]cache_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for URL alias lookup.';

--
-- Dumping data for table `[[dbprefix]]cache_path`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_token`
--

CREATE TABLE `[[dbprefix]]cache_token` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for token information.';

--
-- Dumping data for table `[[dbprefix]]cache_token`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_update`
--

CREATE TABLE `[[dbprefix]]cache_update` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for the Update module to store information…';

--
-- Dumping data for table `[[dbprefix]]cache_update`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_views`
--

CREATE TABLE `[[dbprefix]]cache_views` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for Views to store loaded view configurations.';

--
-- Dumping data for table `[[dbprefix]]cache_views`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_views_data`
--

CREATE TABLE `[[dbprefix]]cache_views_data` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache table for views to store pre-rendered queries,…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment`
--

CREATE TABLE `[[dbprefix]]comment` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique comment ID.',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]comment.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node.nid to which this comment is a reply.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid who authored the comment. If set to 0, this comment was created by an anonymous user.',
  `subject` varchar(64) NOT NULL DEFAULT '' COMMENT 'The comment title.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The author’s host name.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was created, as a Unix timestamp.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was last edited, as a Unix timestamp.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The published status of a comment. (0 = Not Published, 1 = Published)',
  `thread` varchar(255) NOT NULL COMMENT 'The alphadecimal representation of the comment’s place in a thread, consisting of a base 36 string prefixed by an integer indicating its length.',
  `name` varchar(60) DEFAULT NULL COMMENT 'The comment author’s name. Uses [[dbprefix]]users.name if the user is logged in, otherwise uses the value typed into the comment form.',
  `mail` varchar(64) DEFAULT NULL COMMENT 'The comment author’s email address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `homepage` varchar(255) DEFAULT NULL COMMENT 'The comment author’s home page address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `langcode` varchar(12) NOT NULL DEFAULT '' COMMENT 'The language code of this comment.',
  PRIMARY KEY (`cid`),
  KEY `comment_status_pid` (`pid`,`status`),
  KEY `comment_num_new` (`nid`,`status`,`created`,`cid`,`thread`),
  KEY `comment_uid` (`uid`),
  KEY `comment_nid_langcode` (`nid`,`langcode`),
  KEY `comment_created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores comments and associated data.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_data_body`
--

CREATE TABLE `[[dbprefix]]field_data_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Data storage for field body';

--
-- Dumping data for table `[[dbprefix]]field_data_body`
--

INSERT INTO `[[dbprefix]]field_data_body` VALUES
('node', 'post', 0, 1, 1, 'und', 0, '<p>This is your first post! You may edit or delete it.</p>', NULL, 'filtered_html'),
('node', 'page', 0, 2, 2, 'und', 0, '<p>This is a page with static content. You may edit or delete it.</p>', NULL, 'filtered_html'),
('node', 'card', 0, 3, 3, 'und', 0, '<p>Use the home page layout to specifically customize this page. These Cards only appear on this layout.</p><p><a href="https://docs.backdropcms.org/documentation/the-home-page">Learn more about the Home page</a></p>', NULL, 'filtered_html'),
('node', 'card', 0, 4, 4, 'und', 0, '<p>A Card can only be seen as part of another page. Place them individually as "Existing content" Blocks, or grouped as in a View.</p><p><a href="https://docs.backdropcms.org/documentation/creating-and-editing-content">Learn more about Cards</a></p>', NULL, 'filtered_html'),
('node', 'card', 0, 5, 5, 'und', 0, '<p>Backdrop CMS includes three pre-defined types of content: Pages, Posts, and Cards. Custom content types can also be added.</p><p><a href="https://docs.backdropcms.org/documentation/content-types">Learn more about content types</a></p>', NULL, 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_data_comment_body`
--

CREATE TABLE `[[dbprefix]]field_data_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Data storage for field comment_body';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_data_field_image`
--

CREATE TABLE `[[dbprefix]]field_data_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The [[dbprefix]]file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Data storage for field field_image';

--
-- Dumping data for table `[[dbprefix]]field_data_field_image`
--

INSERT INTO `[[dbprefix]]field_data_field_image` VALUES
('node', 'card', 0, 3, 3, 'und', 0, 1, NULL, NULL, 800, 533),
('node', 'card', 0, 4, 4, 'und', 0, 2, NULL, NULL, 800, 533),
('node', 'card', 0, 5, 5, 'und', 0, 3, NULL, NULL, 800, 533);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_data_field_tags`
--

CREATE TABLE `[[dbprefix]]field_data_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Data storage for field field_tags';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_revision_body`
--

CREATE TABLE `[[dbprefix]]field_revision_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Revision archive storage for field body';

--
-- Dumping data for table `[[dbprefix]]field_revision_body`
--

INSERT INTO `[[dbprefix]]field_revision_body` VALUES
('node', 'post', 0, 1, 1, 'und', 0, '<p>This is your first post! You may edit or delete it.</p>', NULL, 'filtered_html'),
('node', 'page', 0, 2, 2, 'und', 0, '<p>This is a page with static content. You may edit or delete it.</p>', NULL, 'filtered_html'),
('node', 'card', 0, 3, 3, 'und', 0, '<p>Use the home page layout to specifically customize this page. These Cards only appear on this layout.</p><p><a href="https://docs.backdropcms.org/documentation/the-home-page">Learn more about the Home page</a></p>', NULL, 'filtered_html'),
('node', 'card', 0, 4, 4, 'und', 0, '<p>A Card can only be seen as part of another page. Place them individually as "Existing content" Blocks, or grouped as in a View.</p><p><a href="https://docs.backdropcms.org/documentation/creating-and-editing-content">Learn more about Cards</a></p>', NULL, 'filtered_html'),
('node', 'card', 0, 5, 5, 'und', 0, '<p>Backdrop CMS includes three pre-defined types of content: Pages, Posts, and Cards. Custom content types can also be added.</p><p><a href="https://docs.backdropcms.org/documentation/content-types">Learn more about content types</a></p>', NULL, 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_revision_comment_body`
--

CREATE TABLE `[[dbprefix]]field_revision_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Revision archive storage for field comment_body';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_revision_field_image`
--

CREATE TABLE `[[dbprefix]]field_revision_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The [[dbprefix]]file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Revision archive storage for field field_image';

--
-- Dumping data for table `[[dbprefix]]field_revision_field_image`
--

INSERT INTO `[[dbprefix]]field_revision_field_image` VALUES
('node', 'card', 0, 3, 3, 'und', 0, 1, NULL, NULL, 800, 533),
('node', 'card', 0, 4, 4, 'und', 0, 2, NULL, NULL, 800, 533),
('node', 'card', 0, 5, 5, 'und', 0, 3, NULL, NULL, 800, 533);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]field_revision_field_tags`
--

CREATE TABLE `[[dbprefix]]field_revision_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Revision archive storage for field field_tags';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_managed`
--

CREATE TABLE `[[dbprefix]]file_managed` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid of the user who is associated with the file.',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the file with no path components. This may differ from the basename of the URI if the file is renamed to avoid overwriting an existing file.',
  `uri` varchar(255) NOT NULL DEFAULT '' COMMENT 'The URI to access the file (either local or remote).',
  `filemime` varchar(255) NOT NULL DEFAULT '' COMMENT 'The file’s MIME type.',
  `filesize` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'The size of the file in bytes.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A field indicating the status of the file. Two status are defined in core: temporary (0) and permanent (1). Temporary files older than BACKDROP_MAXIMUM_TEMP_FILE_AGE will be removed during a cron run.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UNIX timestamp for when the file was added.',
  `type` varchar(50) NOT NULL DEFAULT 'undefined' COMMENT 'The type of this file.',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `uri` (`uri`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`),
  KEY `file_type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores information for uploaded files.' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]file_managed`
--

INSERT INTO `[[dbprefix]]file_managed` VALUES
(1, 1, 'card1-layout.png', 'public://field/image/card1-layout.png', 'image/png', 1437, 1, [[timestamp]], 'image'),
(2, 1, 'card2-card.png', 'public://field/image/card2-card.png', 'image/png', 3017, 1, [[timestamp]], 'image'),
(3, 1, 'card3-organize.png', 'public://field/image/card3-organize.png', 'image/png', 1140, 1, [[timestamp]], 'image');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_metadata`
--

CREATE TABLE `[[dbprefix]]file_metadata` (
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]file_managed.fid of the metadata.',
  `name` varchar(255) NOT NULL COMMENT 'The name of the metadata (e.g. ’width’).',
  `value` longblob COMMENT 'The value of the metadata (e.g. ’200’).',
  PRIMARY KEY (`fid`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Cache image metadata.';

--
-- Dumping data for table `[[dbprefix]]file_metadata`
--

INSERT INTO `[[dbprefix]]file_metadata` VALUES
(1, 'height', 'i:533;'),
(1, 'width', 'i:800;'),
(2, 'height', 'i:533;'),
(2, 'width', 'i:800;'),
(3, 'height', 'i:533;'),
(3, 'width', 'i:800;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_usage`
--

CREATE TABLE `[[dbprefix]]file_usage` (
  `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Track where a file is used.';

--
-- Dumping data for table `[[dbprefix]]file_usage`
--

INSERT INTO `[[dbprefix]]file_usage` VALUES
(1, 'file', 'node', 3, 1),
(2, 'file', 'node', 4, 1),
(3, 'file', 'node', 5, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]flood`
--

CREATE TABLE `[[dbprefix]]flood` (
  `fid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unique flood event ID.',
  `event` varchar(64) NOT NULL DEFAULT '' COMMENT 'Name of event (e.g. contact).',
  `identifier` varchar(128) NOT NULL DEFAULT '' COMMENT 'Identifier of the visitor, such as an IP address or hostname.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp of the event.',
  `expiration` int(11) NOT NULL DEFAULT '0' COMMENT 'Expiration timestamp. Expired events are purged on cron run.',
  PRIMARY KEY (`fid`),
  KEY `allow` (`event`,`identifier`,`timestamp`),
  KEY `purge` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Flood controls the threshold of events, such as the number…' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid that read the [[dbprefix]]node nid.',
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node.nid that was read.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='A record of which [[dbprefix]]users have read which [[dbprefix]]nodes.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_links`
--

CREATE TABLE `[[dbprefix]]menu_links` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ’main-menu’) are part of the same menu.',
  `mlid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',
  `plid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The parent link ID (plid) is the mlid of the link above in the hierarchy, or zero if the link is at the top level in its menu.',
  `link_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The Backdrop path or external path this link points to.',
  `router_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'For links corresponding to a Backdrop path (external = 0), this connects the link to a [[dbprefix]]menu_router.path for joins.',
  `link_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The text displayed for the link, which may be modified by a title callback stored in [[dbprefix]]menu_router.',
  `langcode` varchar(12) NOT NULL DEFAULT '' COMMENT 'The language code for this menu link; if ’und’, the link will be shown in all languages.',
  `options` blob COMMENT 'A serialized array of options to be passed to the url() or l() function, such as a query string or HTML attributes.',
  `module` varchar(255) NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',
  `hidden` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link should be rendered in menus. (1 = a disabled menu item that may be shown on admin screens, -1 = a menu callback, 0 = a normal, visible link)',
  `external` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).',
  `has_children` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any links have this link as a parent (1 = children exist, 0 = no children).',
  `expanded` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',
  `depth` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with plid == 0 will have depth == 1.',
  `customized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate that the user has manually created or edited the link (1 = customized, 0 = not customized).',
  `p1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the plid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',
  `p2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',
  `p3` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',
  `p4` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',
  `p5` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',
  `p6` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',
  `p7` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',
  `p8` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',
  `p9` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',
  `updated` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag that indicates that this link was generated during the update from Drupal 5.',
  PRIMARY KEY (`mlid`),
  KEY `path_menu` (`link_path`(128),`menu_name`),
  KEY `menu_plid_expand_child` (`menu_name`,`plid`,`expanded`,`has_children`),
  KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),
  KEY `router_path` (`router_path`(128))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Contains the individual links within a menu.' AUTO_INCREMENT=365 ;

--
-- Dumping data for table `[[dbprefix]]menu_links`
--

INSERT INTO `[[dbprefix]]menu_links` VALUES
('management', 1, 0, 'admin', 'admin', 'Administration', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 9, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 2, 0, 'user', 'user', 'User account', 'und', 'a:1:{s:5:"alter";b:1;}', 'system', 0, 0, 0, 0, -10, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 3, 0, 'file/%', 'file/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 4, 0, 'node/%', 'node/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 5, 0, 'file/add', 'file/add', 'Add a file', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 1, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 6, 0, 'comment/%', 'comment/%', 'Comment permalink', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 1, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 7, 0, 'node/add', 'node/add', 'Add content', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, -20, 1, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 8, 2, 'user/register', 'user/register', 'Create new account', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 2, 8, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 9, 1, 'admin/index', 'admin/index', 'Index', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -18, 2, 0, 1, 9, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 10, 2, 'user/login', 'user/login', 'Log in', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 2, 10, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 11, 0, 'user/logout', 'user/logout', 'Log out', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 10, 1, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 12, 0, 'user/%', 'user/%', 'My account', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 1, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 13, 2, 'user/password', 'user/password', 'Reset password', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 2, 13, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 14, 1, 'admin/tasks', 'admin/tasks', 'Tasks', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -20, 2, 0, 1, 14, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 15, 1, 'admin/appearance', 'admin/appearance', 'Appearance', 'und', 'a:2:{s:4:"icon";s:12:"palette-fill";s:10:"attributes";a:1:{s:5:"title";s:28:"Select and configure themes.";}}', 'system', 0, 0, 1, 0, -4, 2, 0, 1, 15, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 16, 1, 'admin/config', 'admin/config', 'Configuration', 'und', 'a:2:{s:4:"icon";s:9:"gear-fill";s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}', 'system', 0, 0, 1, 0, 0, 2, 0, 1, 16, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 17, 1, 'admin/modules', 'admin/modules', 'Functionality', 'und', 'a:2:{s:4:"icon";s:17:"puzzle-piece-fill";s:10:"attributes";a:1:{s:5:"title";s:29:"Install or uninstall modules.";}}', 'system', 0, 0, 0, 0, -3, 2, 0, 1, 17, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 18, 1, 'admin/reports', 'admin/reports', 'Reports', 'und', 'a:2:{s:4:"icon";s:9:"info-fill";s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}', 'system', 0, 0, 1, 0, 5, 2, 0, 1, 18, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 19, 1, 'admin/structure', 'admin/structure', 'Structure', 'und', 'a:2:{s:4:"icon";s:10:"stack-fill";s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}', 'system', 0, 0, 1, 0, -2, 2, 0, 1, 19, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 20, 1, 'admin/dashboard', 'admin/dashboard', 'Dashboard', 'und', 'a:2:{s:4:"icon";s:16:"speedometer-fill";s:10:"attributes";a:1:{s:5:"title";s:61:"Get an overview of your site and manage administrative tasks.";}}', 'system', 0, 0, 0, 0, -20, 2, 0, 1, 20, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 21, 1, 'admin/content', 'admin/content', 'Content', 'und', 'a:2:{s:4:"icon";s:11:"pencil-fill";s:10:"attributes";a:1:{s:5:"title";s:32:"Administer content and comments.";}}', 'system', 0, 0, 1, 0, -10, 2, 0, 1, 21, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 22, 1, 'admin/people', 'admin/people', 'User accounts', 'und', 'a:2:{s:4:"icon";s:10:"users-fill";s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}', 'system', 0, 0, 0, 0, -6, 2, 0, 1, 22, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 23, 0, 'comment/reply/%', 'comment/reply/%', 'Add comment', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 1, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 24, 6, 'comment/%/approve', 'comment/%/approve', 'Approve', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 1, 2, 0, 6, 24, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 25, 0, 'filter/tips/%', 'filter/tips/%', 'Compose tips', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 1, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 26, 4, 'node/%/delete', 'node/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 2, 0, 4, 26, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 27, 6, 'comment/%/delete', 'comment/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 2, 0, 6, 27, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 28, 6, 'comment/%/edit', 'comment/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 6, 28, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 29, 4, 'node/%/edit', 'node/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 4, 29, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 30, 3, 'file/%/manage', 'file/%/manage', 'Manage', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 3, 30, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 31, 4, 'node/%/revisions', 'node/%/revisions', 'Revisions', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 2, 2, 0, 4, 31, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 32, 3, 'file/%/usage', 'file/%/usage', 'Usage', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 3, 32, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 33, 3, 'file/%/view', 'file/%/view', 'View', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 2, 0, 3, 33, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 34, 4, 'node/%/view', 'node/%/view', 'View', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 2, 0, 4, 34, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 35, 6, 'comment/%/view', 'comment/%/view', 'View comment', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 2, 0, 6, 35, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 36, 22, 'admin/people/create', 'admin/people/create', 'Add user account', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 3, 0, 1, 22, 36, 0, 0, 0, 0, 0, 0, 0),
('management', 37, 18, 'admin/reports/updates', 'admin/reports/updates', 'Available updates', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Get a status report about available updates for your installed modules, themes, and layouts.";}}', 'system', 0, 0, 0, 0, -50, 3, 0, 1, 18, 37, 0, 0, 0, 0, 0, 0, 0),
('management', 38, 18, 'admin/reports/blocks', 'admin/reports/blocks', 'Blocks', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Overview of all blocks and their modules.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 38, 0, 0, 0, 0, 0, 0, 0),
('management', 39, 12, 'user/%/cancel', 'user/%/cancel', 'Cancel account', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 2, 0, 12, 39, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 40, 19, 'admin/structure/types', 'admin/structure/types', 'Content types', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:91:"Manage content types, including default status, home page promotion, comment settings, etc.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 40, 0, 0, 0, 0, 0, 0, 0),
('management', 41, 19, 'admin/structure/block', 'admin/structure/block', 'Custom blocks', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:60:"Create reusable custom blocks that can be placed in layouts.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 41, 0, 0, 0, 0, 0, 0, 0),
('management', 42, 18, 'admin/reports/debug', 'admin/reports/debug', 'Debug information', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:81:"Get information about the site that can help with support requests and debugging.";}}', 'system', 0, 0, 0, 0, -50, 3, 0, 1, 18, 42, 0, 0, 0, 0, 0, 0, 0),
('management', 43, 12, 'user/%/edit', 'user/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 12, 43, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 44, 18, 'admin/reports/fields', 'admin/reports/fields', 'Fields', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 44, 0, 0, 0, 0, 0, 0, 0),
('management', 45, 19, 'admin/structure/file-types', 'admin/structure/file-types', 'File types', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:56:"Manage settings for the type of files used on your site.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 45, 0, 0, 0, 0, 0, 0, 0),
('management', 46, 17, 'admin/modules/list', 'admin/modules/list', 'List modules', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 3, 0, 1, 17, 46, 0, 0, 0, 0, 0, 0, 0),
('management', 47, 15, 'admin/appearance/install', 'admin/appearance/install', 'Install new themes', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 4, 3, 0, 1, 15, 47, 0, 0, 0, 0, 0, 0, 0),
('management', 48, 21, 'admin/content/comment', 'admin/content/comment', 'Manage comments', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"List and edit site comments and the comment approval queue.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 21, 48, 0, 0, 0, 0, 0, 0, 0),
('management', 49, 17, 'admin/modules/install', 'admin/modules/install', 'Install new modules', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 4, 3, 0, 1, 17, 49, 0, 0, 0, 0, 0, 0, 0),
('management', 50, 19, 'admin/structure/layouts', 'admin/structure/layouts', 'Layouts', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:77:"Create new landing pages or modify the layout of existing pages on your site.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 50, 0, 0, 0, 0, 0, 0, 0),
('management', 51, 15, 'admin/appearance/list', 'admin/appearance/list', 'List themes', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Select and configure themes.";}}', 'system', -1, 0, 0, 0, -1, 3, 0, 1, 15, 51, 0, 0, 0, 0, 0, 0, 0),
('management', 52, 19, 'admin/structure/menu', 'admin/structure/menu', 'Menus', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:86:"Add new menus to your site, edit existing menus, and rename and reorganize menu links.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 52, 0, 0, 0, 0, 0, 0, 0),
('management', 53, 20, 'admin/dashboard/overview', 'admin/dashboard/overview', 'Overview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -100, 3, 0, 1, 20, 53, 0, 0, 0, 0, 0, 0, 0),
('management', 54, 18, 'admin/reports/dblog', 'admin/reports/dblog', 'Recent log messages', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View events that have recently been logged.";}}', 'system', 0, 0, 0, 0, -1, 3, 0, 1, 18, 54, 0, 0, 0, 0, 0, 0, 0),
('management', 55, 20, 'admin/dashboard/settings', 'admin/dashboard/settings', 'Settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Admin dashboard settings";}}', 'system', -1, 0, 0, 0, -10, 3, 0, 1, 20, 55, 0, 0, 0, 0, 0, 0, 0),
('management', 56, 18, 'admin/reports/status', 'admin/reports/status', 'Status report', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Get a status report about your site''s operation and any detected problems.";}}', 'system', 0, 0, 0, 0, -60, 3, 0, 1, 18, 56, 0, 0, 0, 0, 0, 0, 0),
('management', 57, 18, 'admin/reports/access-denied', 'admin/reports/access-denied', 'Top ''access denied'' errors', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:35:"View ''access denied'' errors (403s).";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 57, 0, 0, 0, 0, 0, 0, 0),
('management', 58, 18, 'admin/reports/page-not-found', 'admin/reports/page-not-found', 'Top ''page not found'' errors', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"View ''page not found'' errors (404s).";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 58, 0, 0, 0, 0, 0, 0, 0),
('management', 59, 17, 'admin/modules/uninstall', 'admin/modules/uninstall', 'Uninstall modules', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 20, 3, 0, 1, 17, 59, 0, 0, 0, 0, 0, 0, 0),
('management', 60, 12, 'user/%/view', 'user/%/view', 'View', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 2, 0, 12, 60, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 61, 16, 'admin/config/administration', 'admin/config/administration', 'Administration', 'und', 'a:2:{s:4:"icon";s:4:"gear";s:10:"attributes";a:1:{s:5:"title";s:21:"Administration tools.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 16, 61, 0, 0, 0, 0, 0, 0, 0),
('management', 62, 16, 'admin/config/content', 'admin/config/content', 'Content authoring', 'und', 'a:2:{s:4:"icon";s:11:"note-pencil";s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 16, 62, 0, 0, 0, 0, 0, 0, 0),
('management', 63, 16, 'admin/config/development', 'admin/config/development', 'Development', 'und', 'a:2:{s:4:"icon";s:6:"wrench";s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}', 'system', 0, 0, 1, 0, -10, 3, 0, 1, 16, 63, 0, 0, 0, 0, 0, 0, 0),
('management', 64, 16, 'admin/config/media', 'admin/config/media', 'Media', 'und', 'a:2:{s:4:"icon";s:5:"image";s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}', 'system', 0, 0, 1, 0, -10, 3, 0, 1, 16, 64, 0, 0, 0, 0, 0, 0, 0),
('management', 65, 16, 'admin/config/metadata', 'admin/config/metadata', 'Metadata', 'und', 'a:2:{s:4:"icon";s:4:"code";s:10:"attributes";a:1:{s:5:"title";s:78:"Settings related to meta tags, and other data commonly used by search engines.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 16, 65, 0, 0, 0, 0, 0, 0, 0),
('management', 66, 16, 'admin/config/regional', 'admin/config/regional', 'Regional and language', 'und', 'a:2:{s:4:"icon";s:5:"globe";s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}', 'system', 0, 0, 1, 0, -5, 3, 0, 1, 16, 66, 0, 0, 0, 0, 0, 0, 0),
('management', 67, 16, 'admin/config/search', 'admin/config/search', 'Search', 'und', 'a:2:{s:4:"icon";s:16:"magnifying-glass";s:10:"attributes";a:1:{s:5:"title";s:27:"Local site search settings.";}}', 'system', 0, 0, 1, 0, -10, 3, 0, 1, 16, 67, 0, 0, 0, 0, 0, 0, 0),
('management', 68, 16, 'admin/config/system', 'admin/config/system', 'System', 'und', 'a:2:{s:4:"icon";s:11:"hard-drives";s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}', 'system', 0, 0, 1, 0, -20, 3, 0, 1, 16, 68, 0, 0, 0, 0, 0, 0, 0),
('management', 69, 16, 'admin/config/people', 'admin/config/people', 'User accounts', 'und', 'a:2:{s:4:"icon";s:5:"users";s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}', 'system', 0, 0, 1, 0, -20, 3, 0, 1, 16, 69, 0, 0, 0, 0, 0, 0, 0),
('management', 70, 21, 'admin/content/files', 'admin/content/files', 'Manage files', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Find and manage files.";}}', 'system', -1, 0, 0, 0, 0, 3, 0, 1, 21, 70, 0, 0, 0, 0, 0, 0, 0),
('management', 71, 21, 'admin/content/node', 'admin/content/node', 'Manage content', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -1, 3, 0, 1, 21, 71, 0, 0, 0, 0, 0, 0, 0),
('management', 72, 22, 'admin/people/list', 'admin/people/list', 'Manage user accounts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 3, 0, 1, 22, 72, 0, 0, 0, 0, 0, 0, 0),
('management', 73, 16, 'admin/config/urls', 'admin/config/urls', 'URL handling', 'und', 'a:2:{s:4:"icon";s:4:"link";s:10:"attributes";a:1:{s:5:"title";s:65:"Settings related to URLs including URL aliases and URL redirects.";}}', 'system', 0, 0, 1, 0, -20, 3, 0, 1, 16, 73, 0, 0, 0, 0, 0, 0, 0),
('management', 74, 16, 'admin/config/user-interface', 'admin/config/user-interface', 'User interface', 'und', 'a:2:{s:4:"icon";s:10:"app-window";s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 16, 74, 0, 0, 0, 0, 0, 0, 0),
('management', 75, 16, 'admin/config/services', 'admin/config/services', 'Web services', 'und', 'a:2:{s:4:"icon";s:3:"rss";s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 16, 75, 0, 0, 0, 0, 0, 0, 0),
('management', 76, 16, 'admin/config/workflow', 'admin/config/workflow', 'Workflow', 'und', 'a:2:{s:4:"icon";s:4:"path";s:10:"attributes";a:1:{s:5:"title";s:39:"Settings related to editorial workflow.";}}', 'system', 0, 0, 0, 0, 5, 3, 0, 1, 16, 76, 0, 0, 0, 0, 0, 0, 0),
('management', 77, 69, 'admin/config/people/emails', 'admin/config/people/emails', 'Account emails', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Configure email templates used for account registration and management.";}}', 'system', 0, 0, 0, 0, 10, 4, 0, 1, 16, 69, 77, 0, 0, 0, 0, 0, 0),
('management', 78, 69, 'admin/config/people/settings', 'admin/config/people/settings', 'Account settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"Configure settings for user accounts.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 69, 78, 0, 0, 0, 0, 0, 0),
('management', 79, 40, 'admin/structure/types/add', 'admin/structure/types/add', 'Add content type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 40, 79, 0, 0, 0, 0, 0, 0),
('management', 80, 41, 'admin/structure/block/add', 'admin/structure/block/add', 'Add custom block', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 41, 80, 0, 0, 0, 0, 0, 0),
('management', 81, 45, 'admin/structure/file-types/add', 'admin/structure/file-types/add', 'Add file type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 45, 81, 0, 0, 0, 0, 0, 0),
('management', 82, 50, 'admin/structure/layouts/add', 'admin/structure/layouts/add', 'Add layout', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 19, 50, 82, 0, 0, 0, 0, 0, 0),
('management', 83, 52, 'admin/structure/menu/add', 'admin/structure/menu/add', 'Add menu', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 52, 83, 0, 0, 0, 0, 0, 0),
('management', 84, 61, 'admin/config/administration/admin-bar', 'admin/config/administration/admin-bar', 'Administration bar', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:35:"Adjust administration bar settings.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 61, 84, 0, 0, 0, 0, 0, 0),
('management', 85, 15, 'admin/appearance/settings/bartik', 'admin/appearance/settings/bartik', 'Bartik settings', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 20, 3, 0, 1, 15, 85, 0, 0, 0, 0, 0, 0, 0),
('management', 86, 15, 'admin/appearance/settings/basis', 'admin/appearance/settings/basis', 'Basis settings', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 20, 3, 0, 1, 15, 86, 0, 0, 0, 0, 0, 0, 0),
('management', 87, 45, 'admin/structure/file-types/classify', 'admin/structure/file-types/classify', 'Classify file types', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 45, 87, 0, 0, 0, 0, 0, 0),
('management', 88, 63, 'admin/config/development/configuration', 'admin/config/development/configuration', 'Configuration manager', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:166:"Import, export, and synchronize your configuration changes between different installations of your site, such as in development, staging, and production environments.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 63, 88, 0, 0, 0, 0, 0, 0),
('management', 89, 71, 'admin/content/node/delete', 'admin/content/node/delete', 'Confirm content deletion', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 71, 89, 0, 0, 0, 0, 0, 0),
('management', 90, 70, 'admin/content/files/delete', 'admin/content/files/delete', 'Confirm deleting multiple files', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 70, 90, 0, 0, 0, 0, 0, 0),
('management', 91, 68, 'admin/config/system/cron', 'admin/config/system/cron', 'Cron', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}', 'system', 0, 0, 0, 0, 20, 4, 0, 1, 16, 68, 91, 0, 0, 0, 0, 0, 0),
('management', 92, 63, 'admin/config/development/utf8mb4-upgrade', 'admin/config/development/utf8mb4-upgrade', 'Database 4 byte UTF-8 upgrade', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:96:"Upgrades the database to support 4 byte UTF-8 characters such as emoji and mathematical symbols.";}}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 16, 63, 92, 0, 0, 0, 0, 0, 0),
('management', 93, 66, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Date and time formats', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Configure the display of date and time strings.";}}', 'system', 0, 0, 1, 0, -9, 4, 0, 1, 16, 66, 93, 0, 0, 0, 0, 0, 0),
('management', 94, 66, 'admin/config/regional/date-views', 'admin/config/regional/date-views', 'Date views', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"Configure settings for date views.";}}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 16, 66, 94, 0, 0, 0, 0, 0, 0),
('management', 95, 45, 'admin/structure/file-types/settings', 'admin/structure/file-types/settings', 'File settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"Configure allowed file extensions and the file upload wizard.";}}', 'system', -1, 0, 0, 0, 10, 4, 0, 1, 19, 45, 95, 0, 0, 0, 0, 0, 0),
('management', 96, 64, 'admin/config/media/file-system', 'admin/config/media/file-system', 'File system', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:70:"Tell Backdrop where to store uploaded files and how they are accessed.";}}', 'system', 0, 0, 0, 0, -10, 4, 0, 1, 16, 64, 96, 0, 0, 0, 0, 0, 0),
('management', 97, 45, 'admin/structure/file-types/list', 'admin/structure/file-types/list', 'File types', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:56:"Manage settings for the type of files used on your site.";}}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 45, 97, 0, 0, 0, 0, 0, 0),
('management', 98, 64, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Image styles', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 16, 64, 98, 0, 0, 0, 0, 0, 0),
('management', 99, 64, 'admin/config/media/image-toolkit', 'admin/config/media/image-toolkit', 'Image toolkit', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}', 'system', 0, 0, 0, 0, 20, 4, 0, 1, 16, 64, 99, 0, 0, 0, 0, 0, 0),
('management', 100, 1, 'admin/installer/install/%', 'admin/installer/install/%', 'Install', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 2, 0, 1, 100, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 101, 50, 'admin/structure/layouts/settings', 'admin/structure/layouts/settings', 'Layout templates', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Manage layout templates.";}}', 'system', -1, 0, 1, 0, 20, 4, 0, 1, 19, 50, 101, 0, 0, 0, 0, 0, 0),
('management', 102, 50, 'admin/structure/layouts/install', 'admin/structure/layouts/install', 'Install new layout templates', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 4, 4, 0, 1, 19, 50, 102, 0, 0, 0, 0, 0, 0),
('management', 103, 37, 'admin/reports/updates/list', 'admin/reports/updates/list', 'List available updates', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 18, 37, 103, 0, 0, 0, 0, 0, 0),
('management', 104, 40, 'admin/structure/types/list', 'admin/structure/types/list', 'List content types', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 19, 40, 104, 0, 0, 0, 0, 0, 0),
('management', 105, 41, 'admin/structure/block/list', 'admin/structure/block/list', 'List custom blocks', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 41, 105, 0, 0, 0, 0, 0, 0),
('management', 106, 50, 'admin/structure/layouts/list', 'admin/structure/layouts/list', 'List layouts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 19, 50, 106, 0, 0, 0, 0, 0, 0),
('management', 107, 52, 'admin/structure/menu/list', 'admin/structure/menu/list', 'List menus', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 19, 52, 107, 0, 0, 0, 0, 0, 0),
('management', 108, 46, 'admin/modules/list/confirm', 'admin/modules/list/confirm', 'List modules', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 17, 46, 108, 0, 0, 0, 0, 0, 0),
('management', 109, 18, 'admin/reports/event/%', 'admin/reports/event/%', 'Log message #@id', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 109, 0, 0, 0, 0, 0, 0, 0),
('management', 110, 63, 'admin/config/development/logging', 'admin/config/development/logging', 'Logging and errors', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:156:"Settings for logging and alerts modules. Various modules can route Backdrop''s system events to different destinations, such as syslog, database, email, etc.";}}', 'system', 0, 0, 0, 0, -15, 4, 0, 1, 16, 63, 110, 0, 0, 0, 0, 0, 0),
('management', 111, 69, 'admin/config/people/login', 'admin/config/people/login', 'Login settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:63:"Configure the way visitors may log in and limit login attempts.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 69, 111, 0, 0, 0, 0, 0, 0),
('management', 112, 63, 'admin/config/development/maintenance', 'admin/config/development/maintenance', 'Maintenance mode', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}', 'system', 0, 0, 0, 0, -10, 4, 0, 1, 16, 63, 112, 0, 0, 0, 0, 0, 0),
('management', 113, 69, 'admin/config/people/manage', 'admin/config/people/manage', 'Manage fields', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:56:"Configure fields and display of fields on user accounts.";}}', 'system', 0, 0, 0, 0, 1, 4, 0, 1, 16, 69, 113, 0, 0, 0, 0, 0, 0),
('management', 114, 52, 'admin/structure/menu/settings', 'admin/structure/menu/settings', 'Menu settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Configure global settings for menus.";}}', 'system', -1, 0, 0, 0, 99, 4, 0, 1, 19, 52, 114, 0, 0, 0, 0, 0, 0),
('management', 115, 63, 'admin/config/development/performance', 'admin/config/development/performance', 'Performance', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}', 'system', 0, 0, 0, 0, -20, 4, 0, 1, 16, 63, 115, 0, 0, 0, 0, 0, 0),
('management', 116, 69, 'admin/config/people/permissions', 'admin/config/people/permissions', 'Permissions', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 69, 116, 0, 0, 0, 0, 0, 0),
('management', 117, 48, 'admin/content/comment/new', 'admin/content/comment/new', 'Published comments', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 48, 117, 0, 0, 0, 0, 0, 0),
('management', 118, 75, 'admin/config/services/rss-publishing', 'admin/config/services/rss-publishing', 'RSS publishing', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 75, 118, 0, 0, 0, 0, 0, 0),
('management', 119, 66, 'admin/config/regional/settings', 'admin/config/regional/settings', 'Regional settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:54:"Settings for the site''s default time zone and country.";}}', 'system', 0, 0, 0, 0, -20, 4, 0, 1, 16, 66, 119, 0, 0, 0, 0, 0, 0),
('management', 120, 69, 'admin/config/people/roles', 'admin/config/people/roles', 'Roles', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:60:"List, edit, or add levels of access, or <em>user roles</em>.";}}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 16, 69, 120, 0, 0, 0, 0, 0, 0),
('management', 121, 37, 'admin/reports/updates/settings', 'admin/reports/updates/settings', 'Settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 50, 4, 0, 1, 18, 37, 121, 0, 0, 0, 0, 0, 0),
('management', 122, 68, 'admin/config/system/site-information', 'admin/config/system/site-information', 'Site information', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:117:"Change site name, logo, favicon, slogan, email address, default home page, and number of posts per page, error pages.";}}', 'system', 0, 0, 0, 0, -20, 4, 0, 1, 16, 68, 122, 0, 0, 0, 0, 0, 0),
('management', 123, 68, 'admin/config/system/updates', 'admin/config/system/updates', 'System updates', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:76:"Review and install updates for Backdrop core, modules, themes, and layouts..";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 68, 123, 0, 0, 0, 0, 0, 0),
('management', 124, 62, 'admin/config/content/formats', 'admin/config/content/formats', 'Text editors and formats', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:106:"Configure WYSIWYG and text editors on the site. Restrict or allow certain HTML tags to be used in content.";}}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 16, 62, 124, 0, 0, 0, 0, 0, 0),
('management', 125, 73, 'admin/config/urls/settings', 'admin/config/urls/settings', 'URL settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"General URL-related configuration for your site.";}}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 16, 73, 125, 0, 0, 0, 0, 0, 0),
('management', 126, 48, 'admin/content/comment/approval', 'admin/content/comment/approval', 'Unapproved comments', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 48, 126, 0, 0, 0, 0, 0, 0),
('management', 127, 59, 'admin/modules/uninstall/confirm', 'admin/modules/uninstall/confirm', 'Uninstall modules', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 17, 59, 127, 0, 0, 0, 0, 0, 0),
('management', 128, 63, 'admin/config/development/jquery', 'admin/config/development/jquery', 'jQuery', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:49:"Configure settings related to the jQuery version.";}}', 'system', 0, 0, 0, 0, -10, 4, 0, 1, 16, 63, 128, 0, 0, 0, 0, 0, 0),
('management', 129, 98, 'admin/config/media/image-styles/add', 'admin/config/media/image-styles/add', 'Add image style', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}', 'system', -1, 0, 0, 0, 2, 5, 0, 1, 16, 64, 98, 129, 0, 0, 0, 0, 0),
('management', 130, 120, 'admin/config/people/roles/add', 'admin/config/people/roles/add', 'Add role', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Add a new user role.";}}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 69, 120, 130, 0, 0, 0, 0, 0),
('management', 131, 124, 'admin/config/content/formats/add', 'admin/config/content/formats/add', 'Add text format', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 5, 0, 1, 16, 62, 124, 131, 0, 0, 0, 0, 0),
('management', 132, 41, 'admin/structure/block/manage/%', 'admin/structure/block/manage/%', 'Configure block', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 19, 41, 132, 0, 0, 0, 0, 0, 0),
('management', 133, 40, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Configure content type', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 40, 133, 0, 0, 0, 0, 0, 0),
('management', 134, 45, 'admin/structure/file-types/manage/%', 'admin/structure/file-types/manage/%', 'Configure file type', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 45, 134, 0, 0, 0, 0, 0, 0),
('internal', 135, 31, 'node/%/revisions/%/delete', 'node/%/revisions/%/delete', 'Delete earlier revision', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 3, 0, 4, 31, 135, 0, 0, 0, 0, 0, 0, 0),
('management', 136, 52, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Edit links', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 19, 52, 136, 0, 0, 0, 0, 0, 0),
('management', 137, 88, 'admin/config/development/configuration/full', 'admin/config/development/configuration/full', 'Full Import/Export', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 5, 0, 1, 16, 63, 88, 137, 0, 0, 0, 0, 0),
('management', 138, 98, 'admin/config/media/image-styles/list', 'admin/config/media/image-styles/list', 'List image styles', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}', 'system', -1, 0, 0, 0, 1, 5, 0, 1, 16, 64, 98, 138, 0, 0, 0, 0, 0),
('management', 139, 124, 'admin/config/content/formats/list', 'admin/config/content/formats/list', 'List text formats', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 62, 124, 139, 0, 0, 0, 0, 0),
('management', 140, 50, 'admin/structure/layouts/manage/%', 'admin/structure/layouts/manage/%', 'Manage blocks', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 19, 50, 140, 0, 0, 0, 0, 0, 0),
('management', 141, 113, 'admin/config/people/manage/display', 'admin/config/people/manage/display', 'Manage displays', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 2, 5, 0, 1, 16, 69, 113, 141, 0, 0, 0, 0, 0),
('management', 142, 113, 'admin/config/people/manage/fields', 'admin/config/people/manage/fields', 'Manage fields', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 1, 5, 0, 1, 16, 69, 113, 142, 0, 0, 0, 0, 0),
('management', 143, 113, 'admin/config/people/manage/layouts', 'admin/config/people/manage/layouts', 'Manage layouts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 5, 0, 1, 16, 69, 113, 143, 0, 0, 0, 0, 0),
('management', 144, 50, 'admin/structure/layouts/menu/%', 'admin/structure/layouts/menu/%', 'Menu settings', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 50, 144, 0, 0, 0, 0, 0, 0),
('internal', 145, 31, 'node/%/revisions/%/revert', 'node/%/revisions/%/revert', 'Revert to earlier revision', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 3, 0, 4, 31, 145, 0, 0, 0, 0, 0, 0, 0),
('internal', 146, 31, 'node/%/revisions/%/view', 'node/%/revisions/%/view', 'Revisions', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 3, 0, 4, 31, 146, 0, 0, 0, 0, 0, 0, 0),
('management', 147, 88, 'admin/config/development/configuration/single', 'admin/config/development/configuration/single', 'Single Import/Export', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 5, 0, 1, 16, 63, 88, 147, 0, 0, 0, 0, 0),
('management', 148, 88, 'admin/config/development/configuration/sync', 'admin/config/development/configuration/sync', 'Synchronize', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 63, 88, 148, 0, 0, 0, 0, 0),
('management', 149, 96, 'admin/config/media/file-system/transliteration', 'admin/config/media/file-system/transliteration', 'Transliteration', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Convert existing file names to US-ASCII.";}}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 64, 96, 149, 0, 0, 0, 0, 0),
('management', 150, 124, 'admin/config/content/formats/%', 'admin/config/content/formats/%', '', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 5, 0, 1, 16, 62, 124, 150, 0, 0, 0, 0, 0),
('management', 151, 93, 'admin/config/regional/date-time/formats/add', 'admin/config/regional/date-time/formats/add', 'Add date format', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 16, 66, 93, 151, 0, 0, 0, 0, 0),
('management', 152, 141, 'admin/config/people/manage/display/add', 'admin/config/people/manage/display/add', 'Add display mode', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 152, 0, 0, 0, 0),
('management', 153, 101, 'admin/structure/layouts/settings/flexible-template/add', 'admin/structure/layouts/settings/flexible-template/add', 'Add flexible layout template', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 19, 50, 101, 153, 0, 0, 0, 0, 0),
('management', 154, 143, 'admin/config/people/manage/layouts/add', 'admin/config/people/manage/layouts/add', 'Add layout', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 143, 154, 0, 0, 0, 0),
('management', 155, 136, 'admin/structure/menu/manage/%/add', 'admin/structure/menu/manage/%/add', 'Add link', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 52, 136, 155, 0, 0, 0, 0, 0),
('management', 156, 134, 'admin/structure/file-types/manage/%/configure', 'admin/structure/file-types/manage/%/configure', 'Configure', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 45, 134, 156, 0, 0, 0, 0, 0),
('management', 157, 133, 'admin/structure/types/manage/%/configure', 'admin/structure/types/manage/%/configure', 'Configure', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 40, 133, 157, 0, 0, 0, 0, 0),
('management', 158, 132, 'admin/structure/block/manage/%/configure', 'admin/structure/block/manage/%/configure', 'Configure block', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 41, 132, 158, 0, 0, 0, 0, 0),
('management', 159, 98, 'admin/config/media/image-styles/configure/%', 'admin/config/media/image-styles/configure/%', 'Configure image style', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}', 'system', 0, 0, 1, 0, 0, 5, 0, 1, 16, 64, 98, 159, 0, 0, 0, 0, 0),
('management', 160, 140, 'admin/structure/layouts/manage/%/configure', 'admin/structure/layouts/manage/%/configure', 'Configure layout', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 5, 0, 1, 19, 50, 140, 160, 0, 0, 0, 0, 0),
('management', 161, 136, 'admin/structure/menu/manage/%/configure', 'admin/structure/menu/manage/%/configure', 'Configure menu', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 52, 136, 161, 0, 0, 0, 0, 0),
('management', 162, 120, 'admin/config/people/roles/configure/%', 'admin/config/people/roles/configure/%', 'Configure role', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 69, 120, 162, 0, 0, 0, 0, 0),
('management', 163, 39, 'user/%/cancel/confirm/%/%', 'user/%/cancel/confirm/%/%', 'Confirm account cancellation', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 3, 0, 12, 39, 163, 0, 0, 0, 0, 0, 0, 0),
('management', 164, 141, 'admin/config/people/manage/display/default', 'admin/config/people/manage/display/default', 'Default', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 164, 0, 0, 0, 0),
('management', 165, 133, 'admin/structure/types/manage/%/delete', 'admin/structure/types/manage/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 40, 133, 165, 0, 0, 0, 0, 0),
('management', 166, 136, 'admin/structure/menu/manage/%/delete', 'admin/structure/menu/manage/%/delete', 'Delete menu', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 52, 136, 166, 0, 0, 0, 0, 0),
('management', 167, 52, 'admin/structure/menu/item/%/delete', 'admin/structure/menu/item/%/delete', 'Delete menu link', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 52, 167, 0, 0, 0, 0, 0, 0),
('management', 168, 120, 'admin/config/people/roles/delete/%', 'admin/config/people/roles/delete/%', 'Delete role', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 69, 120, 168, 0, 0, 0, 0, 0),
('management', 169, 134, 'admin/structure/file-types/manage/%/disable', 'admin/structure/file-types/manage/%/disable', 'Disable file type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 45, 134, 169, 0, 0, 0, 0, 0),
('management', 170, 150, 'admin/config/content/formats/%/disable', 'admin/config/content/formats/%/disable', 'Disable text format', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 62, 124, 150, 170, 0, 0, 0, 0),
('management', 171, 93, 'admin/config/regional/date-time/formats/%', 'admin/config/regional/date-time/formats/%', 'Edit date format', 'und', 'a:0:{}', 'system', 0, 0, 1, 0, 0, 5, 0, 1, 16, 66, 93, 171, 0, 0, 0, 0, 0),
('management', 172, 52, 'admin/structure/menu/item/%/edit', 'admin/structure/menu/item/%/edit', 'Edit link', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 52, 172, 0, 0, 0, 0, 0, 0),
('management', 173, 136, 'admin/structure/menu/manage/%/list', 'admin/structure/menu/manage/%/list', 'Edit links', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 19, 52, 136, 173, 0, 0, 0, 0, 0),
('management', 174, 134, 'admin/structure/file-types/manage/%/enable', 'admin/structure/file-types/manage/%/enable', 'Enable file type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 45, 134, 174, 0, 0, 0, 0, 0),
('management', 175, 137, 'admin/config/development/configuration/full/export', 'admin/config/development/configuration/full/export', 'Export', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 6, 0, 1, 16, 63, 88, 137, 175, 0, 0, 0, 0),
('management', 176, 147, 'admin/config/development/configuration/single/export', 'admin/config/development/configuration/single/export', 'Export', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 6, 0, 1, 16, 63, 88, 147, 176, 0, 0, 0, 0),
('management', 177, 137, 'admin/config/development/configuration/full/import', 'admin/config/development/configuration/full/import', 'Import', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 63, 88, 137, 177, 0, 0, 0, 0),
('management', 178, 147, 'admin/config/development/configuration/single/import', 'admin/config/development/configuration/single/import', 'Import', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 63, 88, 147, 178, 0, 0, 0, 0),
('management', 179, 140, 'admin/structure/layouts/manage/%/blocks', 'admin/structure/layouts/manage/%/blocks', 'Manage blocks', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 179, 0, 0, 0, 0, 0),
('management', 180, 134, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%/display', 'Manage displays', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 2, 5, 0, 1, 19, 45, 134, 180, 0, 0, 0, 0, 0),
('management', 181, 134, 'admin/structure/file-types/manage/%/fields', 'admin/structure/file-types/manage/%/fields', 'Manage fields', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 1, 5, 0, 1, 19, 45, 134, 181, 0, 0, 0, 0, 0),
('management', 182, 134, 'admin/structure/file-types/manage/%/file-display', 'admin/structure/file-types/manage/%/file-display', 'Manage file display', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 3, 5, 0, 1, 19, 45, 134, 182, 0, 0, 0, 0, 0),
('management', 183, 134, 'admin/structure/file-types/manage/%/layouts', 'admin/structure/file-types/manage/%/layouts', 'Manage layouts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 5, 0, 1, 19, 45, 134, 183, 0, 0, 0, 0, 0),
('management', 184, 144, 'admin/structure/layouts/menu/%/settings', 'admin/structure/layouts/menu/%/settings', 'Menu settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -1, 5, 0, 1, 19, 50, 144, 184, 0, 0, 0, 0, 0),
('management', 185, 141, 'admin/config/people/manage/display/overview', 'admin/config/people/manage/display/overview', 'Overview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -99, 6, 0, 1, 16, 69, 113, 141, 185, 0, 0, 0, 0),
('management', 186, 52, 'admin/structure/menu/item/%/reset', 'admin/structure/menu/item/%/reset', 'Reset menu link', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 52, 186, 0, 0, 0, 0, 0, 0),
('management', 187, 141, 'admin/config/people/manage/display/token', 'admin/config/people/manage/display/token', 'Tokens', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 187, 0, 0, 0, 0),
('management', 188, 132, 'admin/structure/block/manage/%/translation', 'admin/structure/block/manage/%/translation', 'Translate', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 41, 132, 188, 0, 0, 0, 0, 0),
('management', 189, 150, 'admin/config/content/formats/%/ckeditor5-upgrade', 'admin/config/content/formats/%/ckeditor5-upgrade', 'Upgrade CKEditor 4 to CKEditor 5', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 62, 124, 150, 189, 0, 0, 0, 0),
('management', 190, 141, 'admin/config/people/manage/display/full', 'admin/config/people/manage/display/full', 'User account', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 190, 0, 0, 0, 0),
('management', 191, 98, 'admin/config/media/image-styles/delete/%', 'admin/config/media/image-styles/delete/%', 'Delete style', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 64, 98, 191, 0, 0, 0, 0, 0),
('management', 192, 98, 'admin/config/media/image-styles/revert/%', 'admin/config/media/image-styles/revert/%', 'Revert style', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 64, 98, 192, 0, 0, 0, 0, 0),
('management', 193, 142, 'admin/config/people/manage/fields/%', 'admin/config/people/manage/fields/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 142, 193, 0, 0, 0, 0),
('management', 194, 150, 'admin/config/content/formats/%/filter-settings/%', 'admin/config/content/formats/%/filter-settings/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 62, 124, 150, 194, 0, 0, 0, 0),
('management', 195, 180, 'admin/structure/file-types/manage/%/display/add', 'admin/structure/file-types/manage/%/display/add', 'Add display mode', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 195, 0, 0, 0, 0),
('management', 196, 183, 'admin/structure/file-types/manage/%/layouts/add', 'admin/structure/file-types/manage/%/layouts/add', 'Add layout', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 183, 196, 0, 0, 0, 0),
('management', 197, 133, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%/comment/display', 'Comment display', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 4, 5, 0, 1, 19, 40, 133, 197, 0, 0, 0, 0, 0),
('management', 198, 133, 'admin/structure/types/manage/%/comment/fields', 'admin/structure/types/manage/%/comment/fields', 'Comment fields', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 3, 5, 0, 1, 19, 40, 133, 198, 0, 0, 0, 0, 0),
('management', 199, 148, 'admin/config/development/configuration/sync/diff/%', 'admin/config/development/configuration/sync/diff/%', 'Configuration diff', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 63, 88, 148, 199, 0, 0, 0, 0),
('management', 200, 141, 'admin/config/people/manage/display/%/configure', 'admin/config/people/manage/display/%/configure', 'Configure Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 200, 0, 0, 0, 0),
('management', 201, 101, 'admin/structure/layouts/settings/flexible-template/%/configure', 'admin/structure/layouts/settings/flexible-template/%/configure', 'Configure flexible layout template', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, -10, 5, 0, 1, 19, 50, 101, 201, 0, 0, 0, 0, 0),
('management', 202, 101, 'admin/structure/layouts/settings/flexible-template/%/edit', 'admin/structure/layouts/settings/flexible-template/%/edit', 'Configure flexible layout template', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, -10, 5, 0, 1, 19, 50, 101, 202, 0, 0, 0, 0, 0),
('management', 203, 182, 'admin/structure/file-types/manage/%/file-display/default', 'admin/structure/file-types/manage/%/file-display/default', 'Default', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 6, 0, 1, 19, 45, 134, 182, 203, 0, 0, 0, 0),
('management', 204, 180, 'admin/structure/file-types/manage/%/display/default', 'admin/structure/file-types/manage/%/display/default', 'Default', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 204, 0, 0, 0, 0),
('management', 205, 141, 'admin/config/people/manage/display/%/delete', 'admin/config/people/manage/display/%/delete', 'Delete Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 205, 0, 0, 0, 0),
('management', 206, 171, 'admin/config/regional/date-time/formats/%/delete', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 66, 93, 171, 206, 0, 0, 0, 0),
('management', 207, 101, 'admin/structure/layouts/settings/flexible-template/%/delete', 'admin/structure/layouts/settings/flexible-template/%/delete', 'Delete flexible layout template', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, -10, 5, 0, 1, 19, 50, 101, 207, 0, 0, 0, 0, 0),
('management', 208, 171, 'admin/config/regional/date-time/formats/%/edit', 'admin/config/regional/date-time/formats/%/edit', 'Edit', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}', 'system', -1, 0, 0, 0, -10, 6, 0, 1, 16, 66, 93, 171, 208, 0, 0, 0, 0),
('management', 209, 141, 'admin/config/people/manage/display/%/enable', 'admin/config/people/manage/display/%/enable', 'Enable Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 209, 0, 0, 0, 0),
('management', 210, 182, 'admin/structure/file-types/manage/%/file-display/full', 'admin/structure/file-types/manage/%/file-display/full', 'Full content', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 6, 0, 1, 19, 45, 134, 182, 210, 0, 0, 0, 0),
('management', 211, 180, 'admin/structure/file-types/manage/%/display/full', 'admin/structure/file-types/manage/%/display/full', 'Full content', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 211, 0, 0, 0, 0),
('management', 212, 180, 'admin/structure/file-types/manage/%/display/overview', 'admin/structure/file-types/manage/%/display/overview', 'Overview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -99, 6, 0, 1, 19, 45, 134, 180, 212, 0, 0, 0, 0),
('management', 213, 182, 'admin/structure/file-types/manage/%/file-display/preview', 'admin/structure/file-types/manage/%/file-display/preview', 'Preview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 6, 0, 1, 19, 45, 134, 182, 213, 0, 0, 0, 0),
('management', 214, 180, 'admin/structure/file-types/manage/%/display/preview', 'admin/structure/file-types/manage/%/display/preview', 'Preview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 214, 0, 0, 0, 0),
('management', 215, 141, 'admin/config/people/manage/display/%/reset', 'admin/config/people/manage/display/%/reset', 'Reset to default', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 69, 113, 141, 215, 0, 0, 0, 0),
('management', 216, 182, 'admin/structure/file-types/manage/%/file-display/teaser', 'admin/structure/file-types/manage/%/file-display/teaser', 'Teaser', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 182, 216, 0, 0, 0, 0),
('management', 217, 180, 'admin/structure/file-types/manage/%/display/teaser', 'admin/structure/file-types/manage/%/display/teaser', 'Teaser', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 217, 0, 0, 0, 0),
('management', 218, 182, 'admin/structure/file-types/manage/%/file-display/token', 'admin/structure/file-types/manage/%/file-display/token', 'Tokens', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 3, 6, 0, 1, 19, 45, 134, 182, 218, 0, 0, 0, 0),
('management', 219, 180, 'admin/structure/file-types/manage/%/display/token', 'admin/structure/file-types/manage/%/display/token', 'Tokens', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 219, 0, 0, 0, 0);
INSERT INTO `[[dbprefix]]menu_links` VALUES
('management', 220, 132, 'admin/structure/block/manage/%/translate/%', 'admin/structure/block/manage/%/translate/%', 'Translate block', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 41, 132, 220, 0, 0, 0, 0, 0),
('management', 221, 140, 'admin/structure/layouts/manage/%/configure-redirect/%', 'admin/structure/layouts/manage/%/configure-redirect/%', 'Configure block', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 221, 0, 0, 0, 0, 0),
('management', 222, 181, 'admin/structure/file-types/manage/%/fields/%', 'admin/structure/file-types/manage/%/fields/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 181, 222, 0, 0, 0, 0),
('management', 223, 193, 'admin/config/people/manage/fields/%/delete', 'admin/config/people/manage/fields/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 7, 0, 1, 16, 69, 113, 142, 193, 223, 0, 0, 0),
('management', 224, 193, 'admin/config/people/manage/fields/%/edit', 'admin/config/people/manage/fields/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 16, 69, 113, 142, 193, 224, 0, 0, 0),
('management', 225, 193, 'admin/config/people/manage/fields/%/field-settings', 'admin/config/people/manage/fields/%/field-settings', 'Field settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 16, 69, 113, 142, 193, 225, 0, 0, 0),
('management', 226, 193, 'admin/config/people/manage/fields/%/widget-type', 'admin/config/people/manage/fields/%/widget-type', 'Widget type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 16, 69, 113, 142, 193, 226, 0, 0, 0),
('management', 227, 140, 'admin/structure/layouts/manage/%/add-block/%/%', 'admin/structure/layouts/manage/%/add-block/%/%', 'Add block', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 227, 0, 0, 0, 0, 0),
('management', 228, 180, 'admin/structure/file-types/manage/%/display/%/configure', 'admin/structure/file-types/manage/%/display/%/configure', 'Configure Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 228, 0, 0, 0, 0),
('management', 229, 140, 'admin/structure/layouts/manage/%/edit-title/editor/title', 'admin/structure/layouts/manage/%/edit-title/editor/title', 'Configure page title', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 229, 0, 0, 0, 0, 0),
('management', 230, 140, 'admin/structure/layouts/manage/%/configure-region/%/%', 'admin/structure/layouts/manage/%/configure-region/%/%', 'Configure region', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 230, 0, 0, 0, 0, 0),
('management', 231, 180, 'admin/structure/file-types/manage/%/display/%/delete', 'admin/structure/file-types/manage/%/display/%/delete', 'Delete Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 231, 0, 0, 0, 0),
('management', 232, 180, 'admin/structure/file-types/manage/%/display/%/enable', 'admin/structure/file-types/manage/%/display/%/enable', 'Enable Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 232, 0, 0, 0, 0),
('management', 233, 180, 'admin/structure/file-types/manage/%/display/%/reset', 'admin/structure/file-types/manage/%/display/%/reset', 'Reset to default', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 45, 134, 180, 233, 0, 0, 0, 0),
('management', 234, 159, 'admin/config/media/image-styles/configure/%/add/%', 'admin/config/media/image-styles/configure/%/add/%', 'Add image effect', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 16, 64, 98, 159, 234, 0, 0, 0, 0),
('management', 235, 140, 'admin/structure/layouts/manage/%/configure-block/%/%', 'admin/structure/layouts/manage/%/configure-block/%/%', 'Configure block', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 235, 0, 0, 0, 0, 0),
('management', 236, 159, 'admin/config/media/image-styles/configure/%/effects/%', 'admin/config/media/image-styles/configure/%/effects/%', 'Configure image effect', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure an existing effect within a style.";}}', 'system', 0, 0, 1, 0, 0, 6, 0, 1, 16, 64, 98, 159, 236, 0, 0, 0, 0),
('management', 237, 140, 'admin/structure/layouts/manage/%/toggle-block-status/%/%', 'admin/structure/layouts/manage/%/toggle-block-status/%/%', 'Disable block', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 237, 0, 0, 0, 0, 0),
('management', 238, 140, 'admin/structure/layouts/manage/%/remove-block/%/%', 'admin/structure/layouts/manage/%/remove-block/%/%', 'Remove block', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 19, 50, 140, 238, 0, 0, 0, 0, 0),
('management', 239, 222, 'admin/structure/file-types/manage/%/fields/%/delete', 'admin/structure/file-types/manage/%/fields/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 7, 0, 1, 19, 45, 134, 181, 222, 239, 0, 0, 0),
('management', 240, 222, 'admin/structure/file-types/manage/%/fields/%/edit', 'admin/structure/file-types/manage/%/fields/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 45, 134, 181, 222, 240, 0, 0, 0),
('management', 241, 222, 'admin/structure/file-types/manage/%/fields/%/field-settings', 'admin/structure/file-types/manage/%/fields/%/field-settings', 'Field settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 45, 134, 181, 222, 241, 0, 0, 0),
('management', 242, 222, 'admin/structure/file-types/manage/%/fields/%/widget-type', 'admin/structure/file-types/manage/%/fields/%/widget-type', 'Widget type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 45, 134, 181, 222, 242, 0, 0, 0),
('management', 243, 236, 'admin/config/media/image-styles/configure/%/effects/%/delete', 'admin/config/media/image-styles/configure/%/effects/%/delete', 'Delete image effect', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}', 'system', 0, 0, 0, 0, 0, 7, 0, 1, 16, 64, 98, 159, 236, 243, 0, 0, 0),
('management', 244, 52, 'admin/structure/menu/manage/main-menu', 'admin/structure/menu/manage/%', 'Primary navigation', 'und', 'a:0:{}', 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 19, 52, 244, 0, 0, 0, 0, 0, 0),
('management', 245, 52, 'admin/structure/menu/manage/management', 'admin/structure/menu/manage/%', 'Administration menu', 'und', 'a:0:{}', 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 19, 52, 245, 0, 0, 0, 0, 0, 0),
('management', 246, 52, 'admin/structure/menu/manage/user-menu', 'admin/structure/menu/manage/%', 'Account menu', 'und', 'a:0:{}', 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 19, 52, 246, 0, 0, 0, 0, 0, 0),
('internal', 247, 0, 'search', 'search', 'Search', 'und', 'a:0:{}', 'system', 1, 0, 0, 0, 0, 1, 0, 247, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 248, 247, 'search/node', 'search/node', 'Content', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 2, 0, 247, 248, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 249, 247, 'search/user', 'search/user', 'User accounts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 247, 249, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 250, 0, 'system/404/add-redirect', 'system/404/add-redirect', 'Add a URL redirect from this page to another location', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 1, 0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 251, 0, 'taxonomy/term/%', 'taxonomy/term/%', 'Taxonomy term', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 1, 0, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 252, 19, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Taxonomy', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 252, 0, 0, 0, 0, 0, 0, 0),
('management', 253, 18, 'admin/reports/telemetry', 'admin/reports/telemetry', 'Telemetry', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 253, 0, 0, 0, 0, 0, 0, 0),
('management', 254, 18, 'admin/reports/search', 'admin/reports/search', 'Top search phrases', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"View most popular search phrases.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 254, 0, 0, 0, 0, 0, 0, 0),
('management', 255, 19, 'admin/structure/views', 'admin/structure/views', 'Views', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:35:"Manage customized lists of content.";}}', 'system', 0, 0, 1, 0, 0, 3, 0, 1, 19, 255, 0, 0, 0, 0, 0, 0, 0),
('management', 256, 18, 'admin/reports/views-plugins', 'admin/reports/views-plugins', 'Views plugins', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Overview of plugins used in all views.";}}', 'system', 0, 0, 0, 0, 0, 3, 0, 1, 18, 256, 0, 0, 0, 0, 0, 0, 0),
('internal', 257, 248, 'search/node/%', 'search/node/%', 'Content', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 3, 0, 247, 248, 257, 0, 0, 0, 0, 0, 0, 0),
('internal', 258, 249, 'search/user/%', 'search/user/%', 'User accounts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 3, 0, 247, 249, 258, 0, 0, 0, 0, 0, 0, 0),
('internal', 259, 251, 'taxonomy/term/%/delete', 'taxonomy/term/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 11, 2, 0, 251, 259, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 260, 251, 'taxonomy/term/%/edit', 'taxonomy/term/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 2, 0, 251, 260, 0, 0, 0, 0, 0, 0, 0, 0),
('internal', 261, 251, 'taxonomy/term/%/view', 'taxonomy/term/%/view', 'View', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 2, 0, 251, 261, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 262, 255, 'admin/structure/views/add', 'admin/structure/views/add', 'Add view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 255, 262, 0, 0, 0, 0, 0, 0),
('management', 263, 252, 'admin/structure/taxonomy/add', 'admin/structure/taxonomy/add', 'Add vocabulary', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 252, 263, 0, 0, 0, 0, 0, 0),
('management', 264, 58, 'admin/reports/page-not-found/redirect', 'admin/reports/page-not-found/redirect', 'Fix 404 pages with URL redirects', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 18, 58, 264, 0, 0, 0, 0, 0, 0),
('management', 265, 44, 'admin/reports/fields/list', 'admin/reports/fields/list', 'List fields', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 18, 44, 265, 0, 0, 0, 0, 0, 0),
('management', 266, 255, 'admin/structure/views/list', 'admin/structure/views/list', 'List views', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -1, 4, 0, 1, 19, 255, 266, 0, 0, 0, 0, 0, 0),
('management', 267, 252, 'admin/structure/taxonomy/list', 'admin/structure/taxonomy/list', 'List vocabularies', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 4, 0, 1, 19, 252, 267, 0, 0, 0, 0, 0, 0),
('management', 268, 67, 'admin/config/search/settings', 'admin/config/search/settings', 'Search settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Configure relevance settings for search and other indexing options.";}}', 'system', 0, 0, 0, 0, -10, 4, 0, 1, 16, 67, 268, 0, 0, 0, 0, 0, 0),
('management', 269, 255, 'admin/structure/views/settings', 'admin/structure/views/settings', 'Settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 255, 269, 0, 0, 0, 0, 0, 0),
('management', 270, 73, 'admin/config/urls/path', 'admin/config/urls/path', 'URL aliases', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Change your site''s URLs by setting up automatic URL alias patterns.";}}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 16, 73, 270, 0, 0, 0, 0, 0, 0),
('management', 271, 73, 'admin/config/urls/redirect', 'admin/config/urls/redirect', 'URL redirects', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Redirect users from one URL to another.";}}', 'system', 0, 0, 1, 0, 0, 4, 0, 1, 16, 73, 271, 0, 0, 0, 0, 0, 0),
('management', 272, 44, 'admin/reports/fields/views-fields', 'admin/reports/fields/views-fields', 'Used in views', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"Overview of fields used in all views.";}}', 'system', -1, 0, 0, 0, 0, 4, 0, 1, 18, 44, 272, 0, 0, 0, 0, 0, 0),
('management', 273, 252, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 252, 273, 0, 0, 0, 0, 0, 0),
('management', 274, 270, 'admin/config/urls/path/add', 'admin/config/urls/path/add', 'Add URL alias', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 73, 270, 274, 0, 0, 0, 0, 0),
('management', 275, 271, 'admin/config/urls/redirect/add', 'admin/config/urls/redirect/add', 'Add redirect', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 73, 271, 275, 0, 0, 0, 0, 0),
('management', 276, 273, 'admin/structure/taxonomy/%/add', 'admin/structure/taxonomy/%/add', 'Add term', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 252, 273, 276, 0, 0, 0, 0, 0),
('management', 277, 269, 'admin/structure/views/settings/advanced', 'admin/structure/views/settings/advanced', 'Advanced', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 1, 5, 0, 1, 19, 255, 269, 277, 0, 0, 0, 0, 0),
('management', 278, 269, 'admin/structure/views/settings/basic', 'admin/structure/views/settings/basic', 'Basic', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 269, 278, 0, 0, 0, 0, 0),
('management', 279, 273, 'admin/structure/taxonomy/%/configure', 'admin/structure/taxonomy/%/configure', 'Configure', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 19, 252, 273, 279, 0, 0, 0, 0, 0),
('management', 280, 271, 'admin/config/urls/redirect/404', 'admin/config/urls/redirect/404', 'Fix 404 pages', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Add URL redirects for 404 pages.";}}', 'system', -1, 0, 0, 0, 20, 5, 0, 1, 16, 73, 271, 280, 0, 0, 0, 0, 0),
('management', 281, 270, 'admin/config/urls/path/list', 'admin/config/urls/path/list', 'List URL aliases', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 16, 73, 270, 281, 0, 0, 0, 0, 0),
('management', 282, 271, 'admin/config/urls/redirect/list', 'admin/config/urls/redirect/list', 'List URL redirects', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 16, 73, 271, 282, 0, 0, 0, 0, 0),
('management', 283, 273, 'admin/structure/taxonomy/%/list', 'admin/structure/taxonomy/%/list', 'List terms', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -20, 5, 0, 1, 19, 252, 273, 283, 0, 0, 0, 0, 0),
('management', 284, 268, 'admin/config/search/settings/reindex', 'admin/config/search/settings/reindex', 'Rebuild search index', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 16, 67, 268, 284, 0, 0, 0, 0, 0),
('management', 285, 255, 'admin/structure/views/view/%', 'admin/structure/views/view/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 255, 285, 0, 0, 0, 0, 0, 0),
('management', 286, 271, 'admin/config/urls/redirect/settings', 'admin/config/urls/redirect/settings', 'Settings', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"Configure behavior for URL redirects.";}}', 'system', -1, 0, 0, 0, 50, 5, 0, 1, 16, 73, 271, 286, 0, 0, 0, 0, 0),
('management', 287, 270, 'admin/config/urls/path/patterns', 'admin/config/urls/path/patterns', 'URL alias patterns', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 5, 0, 1, 16, 73, 270, 287, 0, 0, 0, 0, 0),
('management', 288, 270, 'admin/config/urls/path/bulk-update', 'admin/config/urls/path/bulk-update', 'URL aliases bulk actions', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 5, 5, 0, 1, 16, 73, 270, 288, 0, 0, 0, 0, 0),
('management', 289, 285, 'admin/structure/views/view/%/break-lock', 'admin/structure/views/view/%/break-lock', 'Break lock', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 289, 0, 0, 0, 0, 0),
('management', 290, 285, 'admin/structure/views/view/%/clone', 'admin/structure/views/view/%/clone', 'Clone view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 290, 0, 0, 0, 0, 0),
('management', 291, 285, 'admin/structure/views/view/%/configure', 'admin/structure/views/view/%/configure', 'Configure view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -10, 5, 0, 1, 19, 255, 285, 291, 0, 0, 0, 0, 0),
('management', 292, 270, 'admin/config/urls/path/delete/%', 'admin/config/urls/path/delete/%', 'Delete alias', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 73, 270, 292, 0, 0, 0, 0, 0),
('management', 293, 271, 'admin/config/urls/redirect/delete/%', 'admin/config/urls/redirect/delete/%', 'Delete redirect', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 73, 271, 293, 0, 0, 0, 0, 0),
('management', 294, 285, 'admin/structure/views/view/%/delete', 'admin/structure/views/view/%/delete', 'Delete view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 294, 0, 0, 0, 0, 0),
('management', 295, 285, 'admin/structure/views/view/%/disable', 'admin/structure/views/view/%/disable', 'Disable view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 295, 0, 0, 0, 0, 0),
('management', 296, 270, 'admin/config/urls/path/edit/%', 'admin/config/urls/path/edit/%', 'Edit alias', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 73, 270, 296, 0, 0, 0, 0, 0),
('management', 297, 271, 'admin/config/urls/redirect/edit/%', 'admin/config/urls/redirect/edit/%', 'Edit redirect', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 5, 0, 1, 16, 73, 271, 297, 0, 0, 0, 0, 0),
('management', 298, 285, 'admin/structure/views/view/%/enable', 'admin/structure/views/view/%/enable', 'Enable view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 298, 0, 0, 0, 0, 0),
('management', 299, 287, 'admin/config/urls/path/patterns/list', 'admin/config/urls/path/patterns/list', 'List URL alias patterns', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 16, 73, 270, 287, 299, 0, 0, 0, 0),
('management', 300, 285, 'admin/structure/views/view/%/revert', 'admin/structure/views/view/%/revert', 'Revert view', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 300, 0, 0, 0, 0, 0),
('management', 301, 287, 'admin/config/urls/path/patterns/settings', 'admin/config/urls/path/patterns/settings', 'URL alias pattern settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 5, 6, 0, 1, 16, 73, 270, 287, 301, 0, 0, 0, 0),
('management', 302, 285, 'admin/structure/views/view/%/preview/%', 'admin/structure/views/view/%/preview/%', '', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 5, 0, 1, 19, 255, 285, 302, 0, 0, 0, 0, 0),
('management', 303, 255, 'admin/structure/views/nojs/preview/%/%', 'admin/structure/views/nojs/preview/%/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 255, 303, 0, 0, 0, 0, 0, 0),
('management', 304, 255, 'admin/structure/views/ajax/preview/%/%', 'admin/structure/views/ajax/preview/%/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 4, 0, 1, 19, 255, 304, 0, 0, 0, 0, 0, 0),
('management', 305, 7, 'node/add/card', 'node/add/card', 'Card', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:72:"Add a card for use on an existing page. Display as a block or in a view.";}}', 'system', 0, 0, 0, 0, 0, 2, 0, 7, 305, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 306, 7, 'node/add/page', 'node/add/page', 'Page', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:54:"Add a page with static content, like the ''About'' page.";}}', 'system', 0, 0, 0, 0, 0, 2, 0, 7, 306, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 307, 7, 'node/add/post', 'node/add/post', 'Post', 'und', 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Add a blog post, news article, or press release.";}}', 'system', 0, 0, 0, 0, 0, 2, 0, 7, 307, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 308, 273, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%/display', 'Manage displays', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 2, 5, 0, 1, 19, 252, 273, 308, 0, 0, 0, 0, 0),
('management', 309, 273, 'admin/structure/taxonomy/%/fields', 'admin/structure/taxonomy/%/fields', 'Manage fields', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 1, 5, 0, 1, 19, 252, 273, 309, 0, 0, 0, 0, 0),
('management', 310, 273, 'admin/structure/taxonomy/%/layouts', 'admin/structure/taxonomy/%/layouts', 'Manage layouts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 5, 0, 1, 19, 252, 273, 310, 0, 0, 0, 0, 0),
('management', 311, 308, 'admin/structure/taxonomy/%/display/add', 'admin/structure/taxonomy/%/display/add', 'Add display mode', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 311, 0, 0, 0, 0),
('management', 312, 310, 'admin/structure/taxonomy/%/layouts/add', 'admin/structure/taxonomy/%/layouts/add', 'Add layout', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 310, 312, 0, 0, 0, 0),
('management', 313, 308, 'admin/structure/taxonomy/%/display/default', 'admin/structure/taxonomy/%/display/default', 'Default', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 313, 0, 0, 0, 0),
('management', 314, 133, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%/display', 'Manage displays', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 2, 5, 0, 1, 19, 40, 133, 314, 0, 0, 0, 0, 0),
('management', 315, 133, 'admin/structure/types/manage/%/fields', 'admin/structure/types/manage/%/fields', 'Manage fields', 'und', 'a:0:{}', 'system', -1, 0, 1, 0, 1, 5, 0, 1, 19, 40, 133, 315, 0, 0, 0, 0, 0),
('management', 316, 133, 'admin/structure/types/manage/%/layouts', 'admin/structure/types/manage/%/layouts', 'Manage layouts', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 2, 5, 0, 1, 19, 40, 133, 316, 0, 0, 0, 0, 0),
('management', 317, 308, 'admin/structure/taxonomy/%/display/overview', 'admin/structure/taxonomy/%/display/overview', 'Overview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -99, 6, 0, 1, 19, 252, 273, 308, 317, 0, 0, 0, 0),
('management', 318, 308, 'admin/structure/taxonomy/%/display/full', 'admin/structure/taxonomy/%/display/full', 'Taxonomy term page', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 318, 0, 0, 0, 0),
('management', 319, 308, 'admin/structure/taxonomy/%/display/token', 'admin/structure/taxonomy/%/display/token', 'Tokens', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 319, 0, 0, 0, 0),
('management', 320, 309, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 309, 320, 0, 0, 0, 0),
('management', 321, 314, 'admin/structure/types/manage/%/display/add', 'admin/structure/types/manage/%/display/add', 'Add display mode', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 321, 0, 0, 0, 0),
('management', 322, 316, 'admin/structure/types/manage/%/layouts/add', 'admin/structure/types/manage/%/layouts/add', 'Add layout', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 316, 322, 0, 0, 0, 0),
('management', 323, 308, 'admin/structure/taxonomy/%/display/%/configure', 'admin/structure/taxonomy/%/display/%/configure', 'Configure Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 323, 0, 0, 0, 0),
('management', 324, 314, 'admin/structure/types/manage/%/display/default', 'admin/structure/types/manage/%/display/default', 'Default', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 324, 0, 0, 0, 0),
('management', 325, 308, 'admin/structure/taxonomy/%/display/%/delete', 'admin/structure/taxonomy/%/display/%/delete', 'Delete Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 325, 0, 0, 0, 0),
('management', 326, 308, 'admin/structure/taxonomy/%/display/%/enable', 'admin/structure/taxonomy/%/display/%/enable', 'Enable Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 326, 0, 0, 0, 0),
('management', 327, 314, 'admin/structure/types/manage/%/display/full', 'admin/structure/types/manage/%/display/full', 'Full content', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 327, 0, 0, 0, 0),
('management', 328, 314, 'admin/structure/types/manage/%/display/overview', 'admin/structure/types/manage/%/display/overview', 'Overview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -99, 6, 0, 1, 19, 40, 133, 314, 328, 0, 0, 0, 0),
('management', 329, 314, 'admin/structure/types/manage/%/display/rss', 'admin/structure/types/manage/%/display/rss', 'RSS', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 329, 0, 0, 0, 0),
('management', 330, 308, 'admin/structure/taxonomy/%/display/%/reset', 'admin/structure/taxonomy/%/display/%/reset', 'Reset to default', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 252, 273, 308, 330, 0, 0, 0, 0),
('management', 331, 314, 'admin/structure/types/manage/%/display/search_index', 'admin/structure/types/manage/%/display/search_index', 'Search index', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 331, 0, 0, 0, 0),
('management', 332, 314, 'admin/structure/types/manage/%/display/search_result', 'admin/structure/types/manage/%/display/search_result', 'Search result highlighting input', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 332, 0, 0, 0, 0),
('management', 333, 314, 'admin/structure/types/manage/%/display/teaser', 'admin/structure/types/manage/%/display/teaser', 'Teaser', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 333, 0, 0, 0, 0),
('management', 334, 314, 'admin/structure/types/manage/%/display/token', 'admin/structure/types/manage/%/display/token', 'Tokens', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 334, 0, 0, 0, 0),
('management', 335, 315, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 315, 335, 0, 0, 0, 0),
('management', 336, 320, 'admin/structure/taxonomy/%/fields/%/delete', 'admin/structure/taxonomy/%/fields/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 7, 0, 1, 19, 252, 273, 309, 320, 336, 0, 0, 0),
('management', 337, 320, 'admin/structure/taxonomy/%/fields/%/edit', 'admin/structure/taxonomy/%/fields/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 252, 273, 309, 320, 337, 0, 0, 0),
('management', 338, 320, 'admin/structure/taxonomy/%/fields/%/field-settings', 'admin/structure/taxonomy/%/fields/%/field-settings', 'Field settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 252, 273, 309, 320, 338, 0, 0, 0),
('management', 339, 320, 'admin/structure/taxonomy/%/fields/%/widget-type', 'admin/structure/taxonomy/%/fields/%/widget-type', 'Widget type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 252, 273, 309, 320, 339, 0, 0, 0),
('management', 340, 197, 'admin/structure/types/manage/%/comment/display/add', 'admin/structure/types/manage/%/comment/display/add', 'Add display mode', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 340, 0, 0, 0, 0),
('management', 341, 314, 'admin/structure/types/manage/%/display/%/configure', 'admin/structure/types/manage/%/display/%/configure', 'Configure Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 341, 0, 0, 0, 0),
('management', 342, 197, 'admin/structure/types/manage/%/comment/display/default', 'admin/structure/types/manage/%/comment/display/default', 'Default', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 342, 0, 0, 0, 0),
('management', 343, 314, 'admin/structure/types/manage/%/display/%/delete', 'admin/structure/types/manage/%/display/%/delete', 'Delete Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 343, 0, 0, 0, 0),
('management', 344, 314, 'admin/structure/types/manage/%/display/%/enable', 'admin/structure/types/manage/%/display/%/enable', 'Enable Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 344, 0, 0, 0, 0),
('management', 345, 197, 'admin/structure/types/manage/%/comment/display/full', 'admin/structure/types/manage/%/comment/display/full', 'Full comment', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 345, 0, 0, 0, 0),
('management', 346, 197, 'admin/structure/types/manage/%/comment/display/overview', 'admin/structure/types/manage/%/comment/display/overview', 'Overview', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, -99, 6, 0, 1, 19, 40, 133, 197, 346, 0, 0, 0, 0),
('management', 347, 314, 'admin/structure/types/manage/%/display/%/reset', 'admin/structure/types/manage/%/display/%/reset', 'Reset to default', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 314, 347, 0, 0, 0, 0),
('management', 348, 197, 'admin/structure/types/manage/%/comment/display/token', 'admin/structure/types/manage/%/comment/display/token', 'Tokens', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 348, 0, 0, 0, 0),
('management', 349, 198, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', '', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 198, 349, 0, 0, 0, 0),
('management', 350, 335, 'admin/structure/types/manage/%/fields/%/delete', 'admin/structure/types/manage/%/fields/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 7, 0, 1, 19, 40, 133, 315, 335, 350, 0, 0, 0),
('management', 351, 335, 'admin/structure/types/manage/%/fields/%/edit', 'admin/structure/types/manage/%/fields/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 40, 133, 315, 335, 351, 0, 0, 0),
('management', 352, 335, 'admin/structure/types/manage/%/fields/%/field-settings', 'admin/structure/types/manage/%/fields/%/field-settings', 'Field settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 40, 133, 315, 335, 352, 0, 0, 0),
('management', 353, 335, 'admin/structure/types/manage/%/fields/%/widget-type', 'admin/structure/types/manage/%/fields/%/widget-type', 'Widget type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 40, 133, 315, 335, 353, 0, 0, 0),
('management', 354, 197, 'admin/structure/types/manage/%/comment/display/%/configure', 'admin/structure/types/manage/%/comment/display/%/configure', 'Configure Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 354, 0, 0, 0, 0),
('management', 355, 197, 'admin/structure/types/manage/%/comment/display/%/delete', 'admin/structure/types/manage/%/comment/display/%/delete', 'Delete Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 355, 0, 0, 0, 0),
('management', 356, 197, 'admin/structure/types/manage/%/comment/display/%/enable', 'admin/structure/types/manage/%/comment/display/%/enable', 'Enable Display mode', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 356, 0, 0, 0, 0),
('management', 357, 197, 'admin/structure/types/manage/%/comment/display/%/reset', 'admin/structure/types/manage/%/comment/display/%/reset', 'Reset to default', 'und', 'a:0:{}', 'system', 0, 0, 0, 0, 0, 6, 0, 1, 19, 40, 133, 197, 357, 0, 0, 0, 0),
('management', 358, 349, 'admin/structure/types/manage/%/comment/fields/%/delete', 'admin/structure/types/manage/%/comment/fields/%/delete', 'Delete', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 10, 7, 0, 1, 19, 40, 133, 198, 349, 358, 0, 0, 0),
('management', 359, 349, 'admin/structure/types/manage/%/comment/fields/%/edit', 'admin/structure/types/manage/%/comment/fields/%/edit', 'Edit', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 40, 133, 198, 349, 359, 0, 0, 0),
('management', 360, 349, 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'Field settings', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 40, 133, 198, 349, 360, 0, 0, 0),
('management', 361, 349, 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'Widget type', 'und', 'a:0:{}', 'system', -1, 0, 0, 0, 0, 7, 0, 1, 19, 40, 133, 198, 349, 361, 0, 0, 0),
('main-menu', 362, 0, 'node/2', 'node/%', 'About', 'und', 'a:0:{}', 'menu', 0, 0, 0, 0, 1, 1, 0, 362, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 363, 0, '<front>', '', 'Home', 'und', 'a:0:{}', 'menu', 0, 1, 0, 0, -1, 1, 0, 363, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 364, 0, 'user/login', 'user/login', 'Login', 'und', 'a:0:{}', 'menu', 0, 0, 0, 0, -1, 1, 0, 364, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_router`
--

CREATE TABLE `[[dbprefix]]menu_router` (
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: the Backdrop path this entry describes',
  `load_functions` blob NOT NULL COMMENT 'A serialized array of function names (like node_load) to be called to load an object corresponding to a part of the current path.',
  `to_arg_functions` blob NOT NULL COMMENT 'A serialized array of function names (like user_uid_optional_to_arg) to be called to replace a part of the router path with another string.',
  `access_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback which determines the access to this router path. Defaults to user_access.',
  `access_arguments` blob COMMENT 'A serialized array of arguments for the access callback.',
  `page_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that renders the page.',
  `page_arguments` blob COMMENT 'A serialized array of arguments for the page callback.',
  `delivery_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that sends the result of the page_callback function to the browser.',
  `fit` int(11) NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',
  `number_parts` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',
  `context` int(11) NOT NULL DEFAULT '0' COMMENT 'Only for local tasks (tabs) - the context of a local task to control its placement.',
  `tab_parent` varchar(255) NOT NULL DEFAULT '' COMMENT 'Only for local tasks (tabs) - the router path of the parent page (which may also be a local task).',
  `tab_root` varchar(255) NOT NULL DEFAULT '' COMMENT 'Router path of the closest non-tab parent page. For pages that are not local tasks, this will be the same as the path.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title for the current page, or the title for the tab if this is a local task.',
  `title_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which will alter the title. Defaults to t()',
  `title_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the title callback. If empty, the title will be used as the sole argument for the title callback.',
  `theme_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which returns the name of the theme that will be used to render this page. If left empty, the default theme will be used.',
  `theme_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the theme callback.',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT 'Numeric representation of the type of the menu item, like MENU_LOCAL_TASK.',
  `description` text NOT NULL COMMENT 'A description of this item.',
  `position` varchar(255) NOT NULL DEFAULT '' COMMENT 'The position of the block (left or right) on the system administration page for this item.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of the element. Lighter weights are higher up, heavier weights go down.',
  `include_file` mediumtext COMMENT 'The file to include for this element, usually the page callback function lives in this file.',
  PRIMARY KEY (`path`),
  KEY `fit` (`fit`),
  KEY `tab_parent` (`tab_parent`(64),`weight`,`title`),
  KEY `tab_root_weight_title` (`tab_root`(64),`weight`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Maps paths to various callbacks (access, page and title)';

--
-- Dumping data for table `[[dbprefix]]menu_router`
--

INSERT INTO `[[dbprefix]]menu_router` VALUES
('admin', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 1, 1, 0, '', 'admin', 'Administration', 't', '', '', 'a:0:{}', 6, '', '', 9, 'core/modules/system/system.admin.inc'),
('admin/appearance', '', '', 'user_access', 'a:1:{i:0;s:17:"administer themes";}', 'system_themes_page', 'a:0:{}', '', 3, 2, 0, '', 'admin/appearance', 'Appearance', 't', '', '', 'a:0:{}', 6, 'Select and configure themes.', '', -4, 'core/modules/system/system.admin.inc'),
('admin/appearance/default', '', '', 'user_access', 'a:1:{i:0;s:17:"administer themes";}', 'system_theme_default', 'a:0:{}', '', 7, 3, 0, '', 'admin/appearance/default', 'Set default theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/appearance/disable', '', '', 'user_access', 'a:1:{i:0;s:17:"administer themes";}', 'backdrop_get_form', 'a:1:{i:0;s:28:"system_theme_disable_confirm";}', '', 7, 3, 0, '', 'admin/appearance/disable', 'Disable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/appearance/enable', '', '', 'user_access', 'a:1:{i:0;s:17:"administer themes";}', 'system_theme_enable', 'a:0:{}', '', 7, 3, 0, '', 'admin/appearance/enable', 'Enable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/appearance/install', '', '', 'installer_install_access', 'a:0:{}', 'installer_browser_page', 'a:1:{i:0;s:5:"theme";}', '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Install new themes', 't', '', '', 'a:0:{}', 132, '', '', 4, 'core/modules/installer/installer.pages.inc'),
('admin/appearance/list', '', '', 'user_access', 'a:1:{i:0;s:17:"administer themes";}', 'system_themes_page', 'a:0:{}', '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'List themes', 't', '', '', 'a:0:{}', 140, 'Select and configure themes.', '', -1, 'core/modules/system/system.admin.inc'),
('admin/appearance/settings/bartik', '', '', '_system_themes_access', 'a:1:{i:0;s:6:"bartik";}', 'backdrop_get_form', 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}', '', 15, 4, 0, '', 'admin/appearance/settings/bartik', 'Bartik settings', 't', '', '', 'a:0:{}', 6, '', '', 20, 'core/modules/system/system.admin.inc'),
('admin/appearance/settings/basis', '', '', '_system_themes_access', 'a:1:{i:0;s:5:"basis";}', 'backdrop_get_form', 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"basis";}', '', 15, 4, 0, '', 'admin/appearance/settings/basis', 'Basis settings', 't', '', '', 'a:0:{}', 6, '', '', 20, 'core/modules/system/system.admin.inc'),
('admin/appearance/update', '', '', 'user_access', 'a:1:{i:0;s:23:"installer_update_access";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:27:"admin/config/system/updates";}', '', 7, 3, 0, '', 'admin/appearance/update', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_config_page', 'a:0:{}', '', 3, 2, 0, '', 'admin/config', 'Configuration', 't', '', '', 'a:0:{}', 6, 'Administer settings.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/administration', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/administration', 'Administration', 't', '', '', 'a:0:{}', 6, 'Administration tools.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/administration/admin-bar', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:24:"admin_bar_theme_settings";}', '', 15, 4, 0, '', 'admin/config/administration/admin-bar', 'Administration bar', 't', '', '', 'a:0:{}', 6, 'Adjust administration bar settings.', '', 0, 'core/modules/admin_bar/admin_bar.inc'),
('admin/config/content', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/content', 'Content authoring', 't', '', '', 'a:0:{}', 6, 'Settings related to formatting and authoring content.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/content/formats', '', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'backdrop_get_form', 'a:1:{i:0;s:21:"filter_admin_overview";}', '', 15, 4, 0, '', 'admin/config/content/formats', 'Text editors and formats', 't', '', '', 'a:0:{}', 6, 'Configure WYSIWYG and text editors on the site. Restrict or allow certain HTML tags to be used in content.', '', 0, 'core/modules/filter/filter.admin.inc'),
('admin/config/content/formats/%', 'a:1:{i:4;a:1:{s:18:"filter_format_load";a:1:{i:0;b:1;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'filter_admin_format_page', 'a:1:{i:0;i:4;}', '', 30, 5, 0, '', 'admin/config/content/formats/%', '', 'filter_admin_format_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/filter/filter.admin.inc'),
('admin/config/content/formats/%/ckeditor5-upgrade', 'a:1:{i:4;a:1:{s:18:"filter_format_load";a:1:{i:0;b:1;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'backdrop_get_form', 'a:2:{i:0;s:22:"ckeditor5_upgrade_form";i:1;i:4;}', '', 61, 6, 1, 'admin/config/content/formats/%', 'admin/config/content/formats/%', 'Upgrade CKEditor 4 to CKEditor 5', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/ckeditor5/ckeditor5.upgrade.inc'),
('admin/config/content/formats/%/disable', 'a:1:{i:4;a:1:{s:18:"filter_format_load";a:1:{i:0;b:1;}}}', '', '_filter_disable_format_access', 'a:1:{i:0;i:4;}', 'backdrop_get_form', 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}', '', 61, 6, 0, '', 'admin/config/content/formats/%/disable', 'Disable text format', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/filter/filter.admin.inc'),
('admin/config/content/formats/%/enable', 'a:1:{i:4;a:1:{s:18:"filter_format_load";a:1:{i:0;b:1;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'filter_admin_enable', 'a:1:{i:0;i:4;}', '', 61, 6, 0, '', 'admin/config/content/formats/%/enable', 'Enable text format', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/filter/filter.admin.inc'),
('admin/config/content/formats/%/filter-settings/%', 'a:2:{i:4;a:1:{s:18:"filter_format_load";a:1:{i:0;b:1;}}i:6;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'backdrop_get_form', 'a:3:{i:0;s:40:"filter_admin_format_filter_settings_form";i:1;i:4;i:2;i:6;}', '', 122, 7, 0, '', 'admin/config/content/formats/%/filter-settings/%', '', 'filter_admin_format_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/filter/filter.admin.inc'),
('admin/config/content/formats/add', '', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'filter_admin_format_page', 'a:0:{}', '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'Add text format', 't', '', '', 'a:0:{}', 388, '', '', 1, 'core/modules/filter/filter.admin.inc'),
('admin/config/content/formats/list', '', '', 'user_access', 'a:1:{i:0;s:18:"administer filters";}', 'backdrop_get_form', 'a:1:{i:0;s:21:"filter_admin_overview";}', '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'List text formats', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/filter/filter.admin.inc'),
('admin/config/development', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/development', 'Development', 't', '', '', 'a:0:{}', 6, 'Development tools.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/development/configuration', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:16:"config_sync_form";}', '', 15, 4, 0, '', 'admin/config/development/configuration', 'Configuration manager', 't', '', '', 'a:0:{}', 6, 'Import, export, and synchronize your configuration changes between different installations of your site, such as in development, staging, and production environments.', '', 0, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/full', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:23:"config_import_full_form";}', '', 31, 5, 1, 'admin/config/development/configuration', 'admin/config/development/configuration', 'Full Import/Export', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/full/export', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:23:"config_export_full_form";}', '', 63, 6, 1, 'admin/config/development/configuration/full', 'admin/config/development/configuration', 'Export', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/full/export-download', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'config_download_full_export', 'a:0:{}', '', 63, 6, 0, '', 'admin/config/development/configuration/full/export-download', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/full/import', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:23:"config_import_full_form";}', '', 63, 6, 1, 'admin/config/development/configuration/full', 'admin/config/development/configuration', 'Import', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/single', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:25:"config_import_single_form";}', '', 31, 5, 1, 'admin/config/development/configuration', 'admin/config/development/configuration', 'Single Import/Export', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/single/export', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:25:"config_export_single_form";}', '', 63, 6, 1, 'admin/config/development/configuration/single', 'admin/config/development/configuration', 'Export', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/single/import', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:25:"config_import_single_form";}', '', 63, 6, 1, 'admin/config/development/configuration/single', 'admin/config/development/configuration', 'Import', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/sync', '', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:16:"config_sync_form";}', '', 31, 5, 1, 'admin/config/development/configuration', 'admin/config/development/configuration', 'Synchronize', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/config/config.admin.inc'),
('admin/config/development/configuration/sync/diff/%', 'a:1:{i:6;N;}', '', 'user_access', 'a:1:{i:0;s:25:"synchronize configuration";}', 'config_diff_page', 'a:1:{i:0;i:6;}', '', 126, 7, 1, 'admin/config/development/configuration/sync', 'admin/config/development/configuration', 'Configuration diff', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/config/config.admin.inc'),
('admin/config/development/jquery', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:22:"system_jquery_settings";}', '', 15, 4, 0, '', 'admin/config/development/jquery', 'jQuery', 't', '', '', 'a:0:{}', 6, 'Configure settings related to the jQuery version.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/development/logging', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:23:"system_logging_settings";}', '', 15, 4, 0, '', 'admin/config/development/logging', 'Logging and errors', 't', '', '', 'a:0:{}', 6, 'Settings for logging and alerts modules. Various modules can route Backdrop''s system events to different destinations, such as syslog, database, email, etc.', '', -15, 'core/modules/system/system.admin.inc'),
('admin/config/development/maintenance', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:28:"system_site_maintenance_mode";}', '', 15, 4, 0, '', 'admin/config/development/maintenance', 'Maintenance mode', 't', '', '', 'a:0:{}', 6, 'Take the site offline for maintenance or bring it back online.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/development/performance', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:27:"system_performance_settings";}', '', 15, 4, 0, '', 'admin/config/development/performance', 'Performance', 't', '', '', 'a:0:{}', 6, 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.', '', -20, 'core/modules/system/system.admin.inc'),
('admin/config/development/utf8mb4-upgrade', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:27:"system_utf8mb4_convert_form";}', '', 15, 4, 0, '', 'admin/config/development/utf8mb4-upgrade', 'Database 4 byte UTF-8 upgrade', 't', '', '', 'a:0:{}', 4, 'Upgrades the database to support 4 byte UTF-8 characters such as emoji and mathematical symbols.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/media', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/media', 'Media', 't', '', '', 'a:0:{}', 6, 'Media tools.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/media/file-system', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:27:"system_file_system_settings";}', '', 15, 4, 0, '', 'admin/config/media/file-system', 'File system', 't', '', '', 'a:0:{}', 6, 'Tell Backdrop where to store uploaded files and how they are accessed.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/media/file-system/transliteration', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:34:"system_transliteration_retroactive";}', '', 31, 5, 0, '', 'admin/config/media/file-system/transliteration', 'Transliteration', 't', '', '', 'a:0:{}', 4, 'Convert existing file names to US-ASCII.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/media/image-styles', '', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'image_style_list', 'a:0:{}', '', 15, 4, 0, '', 'admin/config/media/image-styles', 'Image styles', 't', '', '', 'a:0:{}', 6, 'Configure styles that can be used for resizing or adjusting images on display.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/add', '', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:1:{i:0;s:20:"image_style_add_form";}', '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Add image style', 't', '', '', 'a:0:{}', 388, 'Add a new image style.', '', 2, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/configure/%', 'a:1:{i:5;s:16:"image_style_load";}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/media/image-styles/configure/%', 'Configure image style', 't', '', '', 'a:0:{}', 6, 'Configure an image style.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/configure/%/add/%', 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}', '', 250, 8, 0, '', 'admin/config/media/image-styles/configure/%/add/%', 'Add image effect', 't', '', '', 'a:0:{}', 6, 'Add a new effect to a style.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/configure/%/effects/%', 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:17:"image_effect_load";a:1:{i:0;i:5;}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}', '', 250, 8, 0, '', 'admin/config/media/image-styles/configure/%/effects/%', 'Configure image effect', 't', '', '', 'a:0:{}', 6, 'Configure an existing effect within a style.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/configure/%/effects/%/delete', 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:17:"image_effect_load";a:1:{i:0;i:5;}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}', '', 501, 9, 0, '', 'admin/config/media/image-styles/configure/%/effects/%/delete', 'Delete image effect', 't', '', '', 'a:0:{}', 6, 'Delete an existing effect from a style.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/delete/%', 'a:1:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;s:1:"1";}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/media/image-styles/delete/%', 'Delete style', 't', '', '', 'a:0:{}', 6, 'Delete an image style.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%', 'a:1:{i:5;s:16:"image_style_load";}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:54:"admin/config/media/image-styles/configure/%image_style";}', '', 62, 6, 0, '', 'admin/config/media/image-styles/edit/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/media/image-styles/edit/%/add/%', 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:83:"admin/config/media/image-styles/configure/%image_style/add/%image_effect_definition";}', '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/add/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/media/image-styles/edit/%/effects/%', 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:17:"image_effect_load";a:1:{i:0;i:5;}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:76:"admin/config/media/image-styles/configure/%image_style/effects/%image_effect";}', '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/effects/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/media/image-styles/edit/%/effects/%/delete', 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:17:"image_effect_load";a:1:{i:0;i:5;}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:83:"admin/config/media/image-styles/configure/%image_style/effects/%image_effect/delete";}', '', 501, 9, 0, '', 'admin/config/media/image-styles/edit/%/effects/%/delete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/media/image-styles/list', '', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'image_style_list', 'a:0:{}', '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'List image styles', 't', '', '', 'a:0:{}', 140, 'List the current image styles on the site.', '', 1, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-styles/revert/%', 'a:1:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;s:1:"6";}}}', '', 'user_access', 'a:1:{i:0;s:23:"administer image styles";}', 'backdrop_get_form', 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/media/image-styles/revert/%', 'Revert style', 't', '', '', 'a:0:{}', 6, 'Revert an image style.', '', 0, 'core/modules/image/image.admin.inc'),
('admin/config/media/image-toolkit', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:29:"system_image_toolkit_settings";}', '', 15, 4, 0, '', 'admin/config/media/image-toolkit', 'Image toolkit', 't', '', '', 'a:0:{}', 6, 'Choose which image toolkit to use if you have installed optional toolkits.', '', 20, 'core/modules/system/system.admin.inc'),
('admin/config/metadata', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/metadata', 'Metadata', 't', '', '', 'a:0:{}', 6, 'Settings related to meta tags, and other data commonly used by search engines.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/people', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/people', 'User accounts', 't', '', '', 'a:0:{}', 6, 'Configure user accounts.', '', -20, 'core/modules/system/system.admin.inc'),
('admin/config/people/emails', '', '', 'user_access', 'a:1:{i:0;s:27:"administer account settings";}', 'backdrop_get_form', 'a:1:{i:0;s:19:"user_settings_email";}', '', 15, 4, 0, '', 'admin/config/people/emails', 'Account emails', 't', '', '', 'a:0:{}', 6, 'Configure email templates used for account registration and management.', '', 10, 'core/modules/user/user.admin.inc'),
('admin/config/people/login', '', '', 'user_access', 'a:1:{i:0;s:27:"administer account settings";}', 'backdrop_get_form', 'a:1:{i:0;s:19:"user_login_settings";}', '', 15, 4, 0, '', 'admin/config/people/login', 'Login settings', 't', '', '', 'a:0:{}', 6, 'Configure the way visitors may log in and limit login attempts.', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/people/manage', '', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}', '', 15, 4, 0, '', 'admin/config/people/manage', 'Manage fields', 't', '', '', 'a:0:{}', 6, 'Configure fields and display of fields on user accounts.', '', 1, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display', '', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'field_ui_display_overview', 'a:2:{i:0;s:4:"user";i:1;s:4:"user";}', '', 31, 5, 1, 'admin/config/people/manage', 'admin/config/people/manage', 'Manage displays', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/%/configure', 'a:1:{i:5;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:23:"field_ui_view_mode_form";i:1;s:4:"user";i:2;s:4:"user";i:3;i:5;}', '', 125, 7, 0, '', 'admin/config/people/manage/display/%/configure', 'Configure Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/%/delete', 'a:1:{i:5;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:30:"field_ui_view_mode_delete_form";i:1;s:4:"user";i:2;s:4:"user";i:3;i:5;}', '', 125, 7, 0, '', 'admin/config/people/manage/display/%/delete', 'Delete Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/%/enable', 'a:1:{i:5;N;}', '', 'field_ui_view_mode_enable_access', 'a:0:{}', 'field_ui_view_mode_enable', 'a:3:{i:0;s:4:"user";i:1;s:4:"user";i:2;i:5;}', '', 125, 7, 0, '', 'admin/config/people/manage/display/%/enable', 'Enable Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/%/reset', 'a:1:{i:5;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:29:"field_ui_view_mode_reset_form";i:1;s:4:"user";i:2;s:4:"user";i:3;i:5;}', '', 125, 7, 0, '', 'admin/config/people/manage/display/%/reset', 'Reset to default', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/add', '', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:3:{i:0;s:23:"field_ui_view_mode_form";i:1;s:4:"user";i:2;s:4:"user";}', '', 63, 6, 1, 'admin/config/people/manage/display', 'admin/config/people/manage', 'Add display mode', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/default', '', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}', '', 63, 6, 1, 'admin/config/people/manage/display', 'admin/config/people/manage', 'Default', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/full', '', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}', '', 63, 6, 1, 'admin/config/people/manage/display', 'admin/config/people/manage', 'User account', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/overview', '', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'field_ui_display_overview', 'a:2:{i:0;s:4:"user";i:1;s:4:"user";}', '', 63, 6, 1, 'admin/config/people/manage/display', 'admin/config/people/manage', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', -99, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/display/token', '', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:5:"token";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:5:"token";}', '', 63, 6, 1, 'admin/config/people/manage/display', 'admin/config/people/manage', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/fields', '', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}', '', 31, 5, 1, 'admin/config/people/manage', 'admin/config/people/manage', 'Manage fields', 't', '', '', 'a:0:{}', 140, '', '', 1, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/fields/%', 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/people/manage/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/fields/%/delete', 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}', '', 125, 7, 0, '', 'admin/config/people/manage/fields/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 10, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/fields/%/edit', 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}', '', 125, 7, 1, 'admin/config/people/manage/fields/%', 'admin/config/people/manage/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/fields/%/field-settings', 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}', '', 125, 7, 1, 'admin/config/people/manage/fields/%', 'admin/config/people/manage/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/fields/%/widget-type', 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:27:"administer account settings";}}', 'backdrop_get_form', 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}', '', 125, 7, 1, 'admin/config/people/manage/fields/%', 'admin/config/people/manage/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/config/people/manage/layouts', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:24:"layout_entity_admin_form";i:1;s:4:"user";i:2;s:4:"user";}', '', 31, 5, 1, 'admin/config/people/manage', 'admin/config/people/manage', 'Manage layouts', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/layout/layout.entity.admin.inc'),
('admin/config/people/manage/layouts/add', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:28:"layout_entity_admin_add_form";i:1;s:4:"user";i:2;s:4:"user";}', '', 63, 6, 1, 'admin/config/people/manage/layouts', 'admin/config/people/manage', 'Add layout', 'layout_entity_menu_title', 'a:2:{i:0;s:4:"user";i:1;s:4:"user";}', '', 'a:0:{}', 388, '', '', 0, 'core/modules/layout/layout.entity.admin.inc'),
('admin/config/people/permissions', '', '', 'user_access', 'a:1:{i:0;s:22:"administer permissions";}', 'backdrop_get_form', 'a:1:{i:0;s:22:"user_admin_permissions";}', '', 15, 4, 0, '', 'admin/config/people/permissions', 'Permissions', 't', '', '', 'a:0:{}', 6, 'Determine access to features by selecting permissions for roles.', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/people/roles', '', '', 'user_access', 'a:1:{i:0;s:22:"administer permissions";}', 'backdrop_get_form', 'a:1:{i:0;s:16:"user_admin_roles";}', '', 15, 4, 0, '', 'admin/config/people/roles', 'Roles', 't', '', '', 'a:0:{}', 6, 'List, edit, or add levels of access, or <em>user roles</em>.', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/people/roles/add', '', '', 'user_access', 'a:1:{i:0;s:22:"administer permissions";}', 'backdrop_get_form', 'a:1:{i:0;s:15:"user_admin_role";}', '', 31, 5, 1, 'admin/config/people/roles', 'admin/config/people/roles', 'Add role', 't', '', '', 'a:0:{}', 388, 'Add a new user role.', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/people/roles/configure/%', 'a:1:{i:5;s:14:"user_role_load";}', '', 'user_access', 'a:1:{i:0;s:22:"administer permissions";}', 'backdrop_get_form', 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/people/roles/configure/%', 'Configure role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/people/roles/delete/%', 'a:1:{i:5;s:14:"user_role_load";}', '', 'user_role_delete_access', 'a:1:{i:0;i:5;}', 'backdrop_get_form', 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/people/roles/delete/%', 'Delete role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/people/roles/edit/%', 'a:1:{i:5;s:14:"user_role_load";}', '', 'user_access', 'a:1:{i:0;s:22:"administer permissions";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:46:"admin/config/people/roles/configure/%user_role";}', '', 62, 6, 0, '', 'admin/config/people/roles/edit/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/people/settings', '', '', 'user_access', 'a:1:{i:0;s:27:"administer account settings";}', 'backdrop_get_form', 'a:1:{i:0;s:19:"user_admin_settings";}', '', 15, 4, 0, '', 'admin/config/people/settings', 'Account settings', 't', '', '', 'a:0:{}', 6, 'Configure settings for user accounts.', '', 0, 'core/modules/user/user.admin.inc'),
('admin/config/regional', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/regional', 'Regional and language', 't', '', '', 'a:0:{}', 6, 'Regional settings, localization and translation.', '', -5, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-time', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'system_date_time_formats', 'a:0:{}', '', 15, 4, 0, '', 'admin/config/regional/date-time', 'Date and time formats', 't', '', '', 'a:0:{}', 6, 'Configure the display of date and time strings.', '', -9, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%', 'a:1:{i:5;s:23:"system_date_format_load";}', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/regional/date-time/formats/%', 'Edit date format', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/delete', 'a:1:{i:5;s:23:"system_date_format_load";}', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}', '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date format.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/edit', 'a:1:{i:5;s:23:"system_date_format_load";}', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}', '', 125, 7, 1, 'admin/config/regional/date-time/formats/%', 'admin/config/regional/date-time/formats/%', 'Edit', 't', '', '', 'a:0:{}', 140, 'Allow users to edit a configured date format.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/add', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:34:"system_configure_date_formats_form";}', '', 63, 6, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Add date format', 't', '', '', 'a:0:{}', 388, 'Allow users to add additional date formats.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/lookup', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'system_date_time_lookup', 'a:0:{}', '', 63, 6, 0, '', 'admin/config/regional/date-time/formats/lookup', 'Date and time lookup', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/regional/date-views', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:19:"date_views_settings";}', '', 15, 4, 1, 'admin/config/regional', 'admin/config/regional', 'Date views', 't', '', '', 'a:0:{}', 132, 'Configure settings for date views.', '', 0, ''),
('admin/config/regional/settings', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:24:"system_regional_settings";}', '', 15, 4, 0, '', 'admin/config/regional/settings', 'Regional settings', 't', '', '', 'a:0:{}', 6, 'Settings for the site''s default time zone and country.', '', -20, 'core/modules/system/system.admin.inc'),
('admin/config/search', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/search', 'Search', 't', '', '', 'a:0:{}', 6, 'Local site search settings.', '', -10, 'core/modules/system/system.admin.inc'),
('admin/config/search/clean-urls', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:26:"admin/config/urls/settings";}', '', 15, 4, 0, '', 'admin/config/search/clean-urls', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:22:"admin/config/urls/path";}', '', 15, 4, 0, '', 'admin/config/search/path', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/add', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:26:"admin/config/urls/path/add";}', '', 31, 5, 0, '', 'admin/config/search/path/add', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/bulk-delete', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:34:"admin/config/urls/path/bulk-delete";}', '', 31, 5, 0, '', 'admin/config/search/path/bulk-delete', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/bulk-update', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:34:"admin/config/urls/path/bulk-update";}', '', 31, 5, 0, '', 'admin/config/search/path/bulk-update', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/delete/%', 'a:1:{i:5;s:9:"path_load";}', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:35:"admin/config/urls/path/delete/%path";}', '', 62, 6, 0, '', 'admin/config/search/path/delete/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/edit/%', 'a:1:{i:5;s:9:"path_load";}', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:33:"admin/config/urls/path/edit/%path";}', '', 62, 6, 0, '', 'admin/config/search/path/edit/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/list', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:27:"admin/config/urls/path/list";}', '', 31, 5, 0, '', 'admin/config/search/path/list', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/patterns', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:31:"admin/config/urls/path/patterns";}', '', 31, 5, 0, '', 'admin/config/search/path/patterns', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/patterns/list', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:36:"admin/config/urls/path/patterns/list";}', '', 63, 6, 0, '', 'admin/config/search/path/patterns/list', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/path/patterns/settings', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:40:"admin/config/urls/path/patterns/settings";}', '', 63, 6, 0, '', 'admin/config/search/path/patterns/settings', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:26:"admin/config/urls/redirect";}', '', 15, 4, 0, '', 'admin/config/search/redirect', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect/404', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:30:"admin/config/urls/redirect/404";}', '', 31, 5, 0, '', 'admin/config/search/redirect/404', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect/add', '', '', 'redirect_access', 'a:2:{i:0;s:6:"create";i:1;s:8:"redirect";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:30:"admin/config/urls/redirect/add";}', '', 31, 5, 0, '', 'admin/config/search/redirect/add', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect/delete/%', 'a:1:{i:5;s:13:"redirect_load";}', '', 'redirect_access', 'a:2:{i:0;s:6:"delete";i:1;i:5;}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:43:"admin/config/urls/redirect/delete/%redirect";}', '', 62, 6, 0, '', 'admin/config/search/redirect/delete/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect/edit/%', 'a:1:{i:5;s:13:"redirect_load";}', '', 'redirect_access', 'a:2:{i:0;s:6:"update";i:1;i:5;}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:41:"admin/config/urls/redirect/edit/%redirect";}', '', 62, 6, 0, '', 'admin/config/search/redirect/edit/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect/list', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:31:"admin/config/urls/redirect/list";}', '', 31, 5, 0, '', 'admin/config/search/redirect/list', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/redirect/settings', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:35:"admin/config/urls/redirect/settings";}', '', 31, 5, 0, '', 'admin/config/search/redirect/settings', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/settings', '', '', 'user_access', 'a:1:{i:0;s:17:"administer search";}', 'backdrop_get_form', 'a:1:{i:0;s:21:"search_admin_settings";}', '', 15, 4, 0, '', 'admin/config/search/settings', 'Search settings', 't', '', '', 'a:0:{}', 6, 'Configure relevance settings for search and other indexing options.', '', -10, 'core/modules/search/search.admin.inc'),
('admin/config/search/settings/reindex', '', '', 'user_access', 'a:1:{i:0;s:17:"administer search";}', 'backdrop_get_form', 'a:1:{i:0;s:22:"search_reindex_confirm";}', '', 31, 5, 0, '', 'admin/config/search/settings/reindex', 'Rebuild search index', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/search/search.admin.inc'),
('admin/config/search/urls', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:26:"admin/config/urls/settings";}', '', 15, 4, 0, '', 'admin/config/search/urls', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/search/urls/check', '', '', '1', 'a:0:{}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:32:"admin/config/urls/settings/check";}', '', 31, 5, 0, '', 'admin/config/search/urls/check', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/config/services', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/services', 'Web services', 't', '', '', 'a:0:{}', 6, 'Tools related to web services.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/services/rss-publishing', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:25:"system_rss_feeds_settings";}', '', 15, 4, 0, '', 'admin/config/services/rss-publishing', 'RSS publishing', 't', '', '', 'a:0:{}', 6, 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/system', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/system', 'System', 't', '', '', 'a:0:{}', 6, 'General system related configuration.', '', -20, 'core/modules/system/system.admin.inc'),
('admin/config/system/cron', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:20:"system_cron_settings";}', '', 15, 4, 0, '', 'admin/config/system/cron', 'Cron', 't', '', '', 'a:0:{}', 6, 'Manage automatic site maintenance tasks.', '', 20, 'core/modules/system/system.admin.inc'),
('admin/config/system/site-information', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:32:"system_site_information_settings";}', '', 15, 4, 0, '', 'admin/config/system/site-information', 'Site information', 't', '', '', 'a:0:{}', 6, 'Change site name, logo, favicon, slogan, email address, default home page, and number of posts per page, error pages.', '', -20, 'core/modules/system/system.admin.inc'),
('admin/config/system/updates', '', '', 'installer_update_access', 'a:0:{}', 'backdrop_get_form', 'a:1:{i:0;s:29:"installer_manager_update_form";}', '', 15, 4, 0, '', 'admin/config/system/updates', 'System updates', 't', '', '', 'a:0:{}', 6, 'Review and install updates for Backdrop core, modules, themes, and layouts..', '', 0, 'core/modules/installer/installer.manager.inc'),
('admin/config/urls', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/urls', 'URL handling', 't', '', '', 'a:0:{}', 6, 'Settings related to URLs including URL aliases and URL redirects.', '', -20, 'core/modules/system/system.admin.inc'),
('admin/config/urls/path', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'path_admin_overview', 'a:0:{}', '', 15, 4, 0, '', 'admin/config/urls/path', 'URL aliases', 't', '', '', 'a:0:{}', 6, 'Change your site''s URLs by setting up automatic URL alias patterns.', '', 0, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/add', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'path_admin_edit', 'a:0:{}', '', 31, 5, 1, 'admin/config/urls/path', 'admin/config/urls/path', 'Add URL alias', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/bulk-update', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'backdrop_get_form', 'a:1:{i:0;s:21:"path_bulk_update_form";}', '', 31, 5, 1, 'admin/config/urls/path', 'admin/config/urls/path', 'URL aliases bulk actions', 't', '', '', 'a:0:{}', 132, '', '', 5, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/delete/%', 'a:1:{i:5;s:9:"path_load";}', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'backdrop_get_form', 'a:2:{i:0;s:25:"path_admin_delete_confirm";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/urls/path/delete/%', 'Delete alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/edit/%', 'a:1:{i:5;s:9:"path_load";}', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'path_admin_edit', 'a:1:{i:0;i:5;}', '', 62, 6, 0, '', 'admin/config/urls/path/edit/%', 'Edit alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/list', '', '', 'user_access', 'a:1:{i:0;s:22:"administer url aliases";}', 'path_admin_overview', 'a:0:{}', '', 31, 5, 1, 'admin/config/urls/path', 'admin/config/urls/path', 'List URL aliases', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/patterns', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"path_patterns_form";}', '', 31, 5, 1, 'admin/config/urls/path', 'admin/config/urls/path', 'URL alias patterns', 't', '', '', 'a:0:{}', 132, '', '', 10, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/patterns/list', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"path_patterns_form";}', '', 63, 6, 1, 'admin/config/urls/path/patterns', 'admin/config/urls/path', 'List URL alias patterns', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/path/path.admin.inc'),
('admin/config/urls/path/patterns/settings', '', '', 'user_access', 'a:1:{i:0;s:24:"administer path patterns";}', 'backdrop_get_form', 'a:1:{i:0;s:27:"path_patterns_settings_form";}', '', 63, 6, 1, 'admin/config/urls/path/patterns', 'admin/config/urls/path', 'URL alias pattern settings', 't', '', '', 'a:0:{}', 132, '', '', 5, 'core/modules/path/path.admin.inc'),
('admin/config/urls/redirect', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"redirect_list_form";}', '', 15, 4, 0, '', 'admin/config/urls/redirect', 'URL redirects', 't', '', '', 'a:0:{}', 6, 'Redirect users from one URL to another.', '', 0, 'core/modules/redirect/redirect.admin.inc'),
('admin/config/urls/redirect/404', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'redirect_404_list', 'a:0:{}', '', 31, 5, 1, 'admin/config/urls/redirect', 'admin/config/urls/redirect', 'Fix 404 pages', 't', '', '', 'a:0:{}', 132, 'Add URL redirects for 404 pages.', '', 20, 'core/modules/redirect/redirect.admin.inc');
INSERT INTO `[[dbprefix]]menu_router` VALUES
('admin/config/urls/redirect/add', '', '', 'redirect_access', 'a:2:{i:0;s:6:"create";i:1;s:8:"redirect";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"redirect_edit_form";}', '', 31, 5, 1, 'admin/config/urls/redirect', 'admin/config/urls/redirect', 'Add redirect', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/redirect/redirect.admin.inc'),
('admin/config/urls/redirect/delete/%', 'a:1:{i:5;s:13:"redirect_load";}', '', 'redirect_access', 'a:2:{i:0;s:6:"delete";i:1;i:5;}', 'backdrop_get_form', 'a:2:{i:0;s:20:"redirect_delete_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/urls/redirect/delete/%', 'Delete redirect', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/redirect/redirect.admin.inc'),
('admin/config/urls/redirect/edit/%', 'a:1:{i:5;s:13:"redirect_load";}', '', 'redirect_access', 'a:2:{i:0;s:6:"update";i:1;i:5;}', 'backdrop_get_form', 'a:2:{i:0;s:18:"redirect_edit_form";i:1;i:5;}', '', 62, 6, 0, '', 'admin/config/urls/redirect/edit/%', 'Edit redirect', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/redirect/redirect.admin.inc'),
('admin/config/urls/redirect/list', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"redirect_list_form";}', '', 31, 5, 1, 'admin/config/urls/redirect', 'admin/config/urls/redirect', 'List URL redirects', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/redirect/redirect.admin.inc'),
('admin/config/urls/redirect/settings', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'backdrop_get_form', 'a:1:{i:0;s:22:"redirect_settings_form";}', '', 31, 5, 1, 'admin/config/urls/redirect', 'admin/config/urls/redirect', 'Settings', 't', '', '', 'a:0:{}', 132, 'Configure behavior for URL redirects.', '', 50, 'core/modules/redirect/redirect.admin.inc'),
('admin/config/urls/settings', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:20:"system_urls_settings";}', '', 15, 4, 0, '', 'admin/config/urls/settings', 'URL settings', 't', '', '', 'a:0:{}', 6, 'General URL-related configuration for your site.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/urls/settings/check', '', '', '1', 'a:0:{}', 'backdrop_json_output', 'a:1:{i:0;a:1:{s:6:"status";b:1;}}', '', 31, 5, 0, '', 'admin/config/urls/settings/check', 'Clean URL check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/user-interface', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/user-interface', 'User interface', 't', '', '', 'a:0:{}', 6, 'Tools that enhance the user interface.', '', 0, 'core/modules/system/system.admin.inc'),
('admin/config/workflow', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/config/workflow', 'Workflow', 't', '', '', 'a:0:{}', 6, 'Settings related to editorial workflow.', '', 5, 'core/modules/system/system.admin.inc'),
('admin/content', '', '', 'views_access', 'a:1:{i:0;a:2:{i:0;s:16:"views_check_perm";i:1;a:1:{i:0;s:23:"access content overview";}}}', 'views_page', 'a:2:{i:0;s:18:"node_admin_content";i:1;s:4:"page";}', '', 3, 2, 0, '', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 6, 'Administer content and comments.', '', -10, ''),
('admin/content/comment', '', '', 'user_access', 'a:1:{i:0;s:19:"administer comments";}', 'comment_admin', 'a:0:{}', '', 7, 3, 1, 'admin/content', 'admin/content', 'Manage comments', 't', '', '', 'a:0:{}', 134, 'List and edit site comments and the comment approval queue.', '', 0, 'core/modules/comment/comment.admin.inc'),
('admin/content/comment/approval', '', '', 'user_access', 'a:1:{i:0;s:19:"administer comments";}', 'comment_admin', 'a:1:{i:0;s:8:"approval";}', '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Unapproved comments', 'comment_count_unpublished', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/comment/comment.admin.inc'),
('admin/content/comment/new', '', '', 'user_access', 'a:1:{i:0;s:19:"administer comments";}', 'comment_admin', 'a:0:{}', '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Published comments', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/comment/comment.admin.inc'),
('admin/content/files', '', '', 'views_access', 'a:1:{i:0;a:2:{i:0;s:16:"views_check_perm";i:1;a:1:{i:0;s:20:"access file overview";}}}', 'views_page', 'a:2:{i:0;s:10:"file_admin";i:1;s:4:"page";}', '', 7, 3, 1, 'admin/content', 'admin/content', 'Manage files', 't', '', '', 'a:0:{}', 132, 'Find and manage files.', '', 0, ''),
('admin/content/files/delete', '', '', 'user_access', 'a:1:{i:0;s:12:"delete files";}', 'backdrop_get_form', 'a:1:{i:0;s:28:"file_multiple_delete_confirm";}', '', 15, 4, 0, '', 'admin/content/files/delete', 'Confirm deleting multiple files', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/file/file.pages.inc'),
('admin/content/node', '', '', 'views_access', 'a:1:{i:0;a:2:{i:0;s:16:"views_check_perm";i:1;a:1:{i:0;s:23:"access content overview";}}}', 'views_page', 'a:2:{i:0;s:18:"node_admin_content";i:1;s:4:"page";}', '', 7, 3, 1, 'admin/content', 'admin/content', 'Manage content', 't', '', '', 'a:0:{}', 140, '', '', -1, ''),
('admin/content/node/delete', '', '', 'user_access', 'a:1:{i:0;s:23:"access content overview";}', 'backdrop_get_form', 'a:1:{i:0;s:28:"node_multiple_delete_confirm";}', '', 15, 4, 0, '', 'admin/content/node/delete', 'Confirm content deletion', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/node/node.admin.inc'),
('admin/dashboard', '', '', 'layout_page_access', 'a:3:{i:0;s:9:"dashboard";i:1;i:0;i:2;i:1;}', 'layout_page_callback', 'a:3:{i:0;s:9:"dashboard";i:1;i:0;i:2;i:1;}', '', 3, 2, 0, '', 'admin/dashboard', 'Dashboard', 't', '', '', 'a:0:{}', 6, 'Get an overview of your site and manage administrative tasks.', '', -20, 'core/modules/layout/layout.pages.inc'),
('admin/dashboard/overview', '', '', 'layout_page_access', 'a:3:{i:0;s:9:"dashboard";i:1;i:0;i:2;i:1;}', 'layout_page_callback', 'a:3:{i:0;s:9:"dashboard";i:1;i:0;i:2;i:1;}', '', 7, 3, 1, 'admin/dashboard', 'admin/dashboard', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', -100, 'core/modules/layout/layout.pages.inc'),
('admin/dashboard/settings', '', '', 'user_access', 'a:1:{i:0;s:20:"administer dashboard";}', 'backdrop_get_form', 'a:1:{i:0;s:24:"dashboard_admin_settings";}', '', 7, 3, 1, 'admin/dashboard', 'admin/dashboard', 'Settings', 't', '', '', 'a:0:{}', 132, 'Admin dashboard settings', '', -10, ''),
('admin/index', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_index', 'a:0:{}', '', 3, 2, 1, 'admin', 'admin', 'Index', 't', '', '', 'a:0:{}', 132, '', '', -18, 'core/modules/system/system.admin.inc'),
('admin/installer/bulk/%', 'a:1:{i:3;N;}', '', 'installer_install_access', 'a:0:{}', 'backdrop_get_form', 'a:2:{i:0;s:35:"installer_browser_bulk_install_form";i:1;i:3;}', '', 14, 4, 0, '', 'admin/installer/bulk/%', 'Install by names', 't', '', '', 'a:0:{}', 0, 'Install multiple projects by listing machine names.', '', 0, 'core/modules/installer/installer.pages.inc'),
('admin/installer/install/%', 'a:1:{i:3;N;}', '', 'installer_install_access', 'a:0:{}', 'installer_browser_installation_page', 'a:1:{i:0;i:3;}', '', 14, 4, 0, '', 'admin/installer/install/%', 'Install', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/installer/installer.pages.inc'),
('admin/installer/manual', '', '', 'installer_install_access', 'a:0:{}', 'backdrop_get_form', 'a:1:{i:0;s:30:"installer_manager_install_form";}', '', 7, 3, 0, '', 'admin/installer/manual', '', 't', '', '', 'a:0:{}', 0, '', '', 25, 'core/modules/installer/installer.manager.inc'),
('admin/installer/project/%', 'a:1:{i:3;N;}', '', 'installer_install_access', 'a:0:{}', 'installer_browser_project_display', 'a:1:{i:0;i:3;}', '', 14, 4, 0, '', 'admin/installer/project/%', 'Project details', 't', '', '', 'a:0:{}', 0, 'Project details', '', 0, 'core/modules/installer/installer.pages.inc'),
('admin/installer/queue/%/%/%', 'a:3:{i:3;N;i:4;N;i:5;N;}', '', 'installer_install_access', 'a:0:{}', 'installer_browser_install_queue_callback', 'a:3:{i:0;i:3;i:1;i:4;i:2;i:5;}', '', 56, 6, 0, '', 'admin/installer/queue/%/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/installer/installer.pages.inc'),
('admin/installer/reset/%/%', 'a:2:{i:3;N;i:4;N;}', '', 'installer_install_access', 'a:0:{}', 'installer_browser_installation_reset', 'a:2:{i:0;i:3;i:1;i:4;}', '', 28, 5, 0, '', 'admin/installer/reset/%/%', 'Reset', 't', '', '', 'a:0:{}', 0, 'Reset installer project list.', '', 0, 'core/modules/installer/installer.pages.inc'),
('admin/modules', '', '', 'user_access', 'a:1:{i:0;s:18:"administer modules";}', 'backdrop_get_form', 'a:1:{i:0;s:14:"system_modules";}', '', 3, 2, 0, '', 'admin/modules', 'Functionality', 't', '', '', 'a:0:{}', 6, 'Install or uninstall modules.', '', -3, 'core/modules/system/system.admin.inc'),
('admin/modules/install', '', '', 'installer_install_access', 'a:0:{}', 'installer_browser_page', 'a:1:{i:0;s:6:"module";}', '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Install new modules', 't', '', '', 'a:0:{}', 132, '', '', 4, 'core/modules/installer/installer.pages.inc'),
('admin/modules/list', '', '', 'user_access', 'a:1:{i:0;s:18:"administer modules";}', 'backdrop_get_form', 'a:1:{i:0;s:14:"system_modules";}', '', 7, 3, 1, 'admin/modules', 'admin/modules', 'List modules', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/modules/list/confirm', '', '', 'user_access', 'a:1:{i:0;s:18:"administer modules";}', 'backdrop_get_form', 'a:1:{i:0;s:14:"system_modules";}', '', 15, 4, 0, '', 'admin/modules/list/confirm', 'List modules', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/modules/uninstall', '', '', 'user_access', 'a:1:{i:0;s:18:"administer modules";}', 'backdrop_get_form', 'a:1:{i:0;s:24:"system_modules_uninstall";}', '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Uninstall modules', 't', '', '', 'a:0:{}', 132, '', '', 20, 'core/modules/system/system.admin.inc'),
('admin/modules/uninstall/confirm', '', '', 'user_access', 'a:1:{i:0;s:18:"administer modules";}', 'backdrop_get_form', 'a:1:{i:0;s:24:"system_modules_uninstall";}', '', 15, 4, 0, '', 'admin/modules/uninstall/confirm', 'Uninstall modules', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/modules/update', '', '', 'user_access', 'a:1:{i:0;s:23:"installer_update_access";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:27:"admin/config/system/updates";}', '', 7, 3, 0, '', 'admin/modules/update', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/people', '', '', 'views_access', 'a:1:{i:0;a:2:{i:0;s:16:"views_check_perm";i:1;a:1:{i:0;s:16:"administer users";}}}', 'views_page', 'a:2:{i:0;s:10:"user_admin";i:1;s:4:"page";}', '', 3, 2, 0, '', 'admin/people', 'User accounts', 't', '', '', 'a:0:{}', 6, 'Manage user accounts, roles, and permissions.', '', -6, ''),
('admin/people/cancel', '', '', 'user_access', 'a:1:{i:0;s:16:"administer users";}', 'backdrop_get_form', 'a:1:{i:0;s:28:"user_multiple_cancel_confirm";}', '', 7, 3, 0, '', 'admin/people/cancel', 'Cancel user accounts', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/user/user.admin.inc'),
('admin/people/create', '', '', 'user_access', 'a:1:{i:0;s:16:"administer users";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"user_register_form";}', '', 7, 3, 1, 'admin/people', 'admin/people', 'Add user account', 't', '', '', 'a:0:{}', 388, '', '', 0, ''),
('admin/people/list', '', '', 'views_access', 'a:1:{i:0;a:2:{i:0;s:16:"views_check_perm";i:1;a:1:{i:0;s:16:"administer users";}}}', 'views_page', 'a:2:{i:0;s:10:"user_admin";i:1;s:4:"page";}', '', 7, 3, 1, 'admin/people', 'admin/people', 'Manage user accounts', 't', '', '', 'a:0:{}', 140, '', '', 0, ''),
('admin/reports', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'system_admin_menu_block_page', 'a:0:{}', '', 3, 2, 0, '', 'admin/reports', 'Reports', 't', '', '', 'a:0:{}', 6, 'View reports, updates, and errors.', '', 5, 'core/modules/system/system.admin.inc'),
('admin/reports/access-denied', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'dblog_top', 'a:1:{i:0;s:13:"access denied";}', '', 7, 3, 0, '', 'admin/reports/access-denied', 'Top ''access denied'' errors', 't', '', '', 'a:0:{}', 6, 'View ''access denied'' errors (403s).', '', 0, 'core/modules/dblog/dblog.admin.inc'),
('admin/reports/blocks', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_block_list', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/blocks', 'Blocks', 't', '', '', 'a:0:{}', 6, 'Overview of all blocks and their modules.', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/reports/dblog', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'dblog_overview', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/dblog', 'Recent log messages', 't', '', '', 'a:0:{}', 6, 'View events that have recently been logged.', '', -1, 'core/modules/dblog/dblog.admin.inc'),
('admin/reports/debug', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'system_debug_info', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/debug', 'Debug information', 't', '', '', 'a:0:{}', 6, 'Get information about the site that can help with support requests and debugging.', '', -50, 'core/modules/system/system.admin.inc'),
('admin/reports/event/%', 'a:1:{i:3;N;}', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'dblog_event', 'a:1:{i:0;i:3;}', '', 14, 4, 0, '', 'admin/reports/event/%', 'Log message #@id', 't', 'a:1:{s:3:"@id";i:3;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/dblog/dblog.admin.inc'),
('admin/reports/fields', '', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'field_ui_fields_list', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/fields', 'Fields', 't', '', '', 'a:0:{}', 6, 'Overview of fields on all entity types.', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/list', '', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'field_ui_fields_list', 'a:0:{}', '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'List fields', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/views-fields', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_field_list', 'a:0:{}', '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'Used in views', 't', '', '', 'a:0:{}', 132, 'Overview of fields used in all views.', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/reports/page-not-found', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'dblog_top', 'a:1:{i:0;s:14:"page not found";}', '', 7, 3, 0, '', 'admin/reports/page-not-found', 'Top ''page not found'' errors', 't', '', '', 'a:0:{}', 6, 'View ''page not found'' errors (404s).', '', 0, 'core/modules/dblog/dblog.admin.inc'),
('admin/reports/page-not-found/redirect', '', '', 'user_access', 'a:1:{i:0;s:20:"administer redirects";}', 'backdrop_goto', 'a:1:{i:0;s:30:"admin/config/urls/redirect/404";}', '', 15, 4, 1, 'admin/reports/page-not-found', 'admin/reports/page-not-found', 'Fix 404 pages with URL redirects', 't', '', '', 'a:0:{}', 388, '', '', 0, ''),
('admin/reports/search', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'dblog_top', 'a:1:{i:0;s:6:"search";}', '', 7, 3, 0, '', 'admin/reports/search', 'Top search phrases', 't', '', '', 'a:0:{}', 6, 'View most popular search phrases.', '', 0, 'core/modules/dblog/dblog.admin.inc'),
('admin/reports/status', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'system_status', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/status', 'Status report', 't', '', '', 'a:0:{}', 6, 'Get a status report about your site''s operation and any detected problems.', '', -60, 'core/modules/system/system.admin.inc'),
('admin/reports/status/php', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'system_php', 'a:0:{}', '', 15, 4, 0, '', 'admin/reports/status/php', 'PHP', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/reports/status/rebuild', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'backdrop_get_form', 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}', '', 15, 4, 0, '', 'admin/reports/status/rebuild', 'Rebuild permissions', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/node/node.admin.inc'),
('admin/reports/status/run-cron', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'system_run_cron', 'a:0:{}', '', 15, 4, 0, '', 'admin/reports/status/run-cron', 'Run cron', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('admin/reports/telemetry', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'telemetry_report', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/telemetry', 'Telemetry', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/telemetry/telemetry.admin.inc'),
('admin/reports/updates', '', '', 'user_access', 'a:1:{i:0;s:19:"access site reports";}', 'update_status', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/updates', 'Available updates', 't', '', '', 'a:0:{}', 6, 'Get a status report about available updates for your installed modules, themes, and layouts.', '', -50, 'core/modules/update/update.report.inc'),
('admin/reports/updates/check', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'update_manual_status', 'a:0:{}', '', 15, 4, 0, '', 'admin/reports/updates/check', 'Manual update check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/update/update.fetch.inc'),
('admin/reports/updates/list', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'update_status', 'a:0:{}', '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'List available updates', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/update/update.report.inc'),
('admin/reports/updates/settings', '', '', 'user_access', 'a:1:{i:0;s:29:"administer site configuration";}', 'backdrop_get_form', 'a:1:{i:0;s:15:"update_settings";}', '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 50, 'core/modules/update/update.admin.inc'),
('admin/reports/views-plugins', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_plugin_list', 'a:0:{}', '', 7, 3, 0, '', 'admin/reports/views-plugins', 'Views plugins', 't', '', '', 'a:0:{}', 6, 'Overview of plugins used in all views.', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 3, 2, 0, '', 'admin/structure', 'Structure', 't', '', '', 'a:0:{}', 6, 'Administer blocks, content types, menus, etc.', '', -2, 'core/modules/system/system.admin.inc'),
('admin/structure/block', '', '', 'user_access', 'a:1:{i:0;s:17:"administer blocks";}', 'block_admin_list', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/block', 'Custom blocks', 't', '', '', 'a:0:{}', 6, 'Create reusable custom blocks that can be placed in layouts.', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/add', '', '', 'user_access', 'a:1:{i:0;s:17:"administer blocks";}', 'backdrop_get_form', 'a:1:{i:0;s:20:"block_add_block_form";}', '', 15, 4, 1, 'admin/structure/block', 'admin/structure/block', 'Add custom block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/list', '', '', 'user_access', 'a:1:{i:0;s:17:"administer blocks";}', 'block_admin_list', 'a:0:{}', '', 15, 4, 1, 'admin/structure/block', 'admin/structure/block', 'List custom blocks', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/manage/%', 'a:1:{i:4;N;}', '', 'user_access', 'a:1:{i:0;s:17:"administer blocks";}', 'backdrop_get_form', 'a:2:{i:0;s:21:"block_admin_configure";i:1;i:4;}', '', 30, 5, 0, '', 'admin/structure/block/manage/%', 'Configure block', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/manage/%/configure', 'a:1:{i:4;N;}', '', 'user_access', 'a:1:{i:0;s:17:"administer blocks";}', 'backdrop_get_form', 'a:2:{i:0;s:21:"block_admin_configure";i:1;i:4;}', '', 61, 6, 0, 'admin/structure/block/manage/%', 'admin/structure/block/manage/%', 'Configure block', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/manage/%/delete', 'a:1:{i:4;N;}', '', 'user_access', 'a:1:{i:0;s:17:"administer blocks";}', 'backdrop_get_form', 'a:2:{i:0;s:25:"block_custom_block_delete";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/block/manage/%/delete', 'Delete block', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/manage/%/translate/%', 'a:2:{i:4;N;i:6;N;}', '', 'block_custom_block_translate_access', 'a:2:{i:0;i:4;i:1;i:6;}', 'backdrop_get_form', 'a:3:{i:0;s:28:"block_custom_block_translate";i:1;i:4;i:2;i:6;}', '', 122, 7, 0, '', 'admin/structure/block/manage/%/translate/%', 'Translate block', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/block/manage/%/translation', 'a:1:{i:4;N;}', '', 'block_custom_block_translate_access', 'a:1:{i:0;i:4;}', 'backdrop_get_form', 'a:2:{i:0;s:33:"block_custom_block_translate_list";i:1;i:4;}', '', 61, 6, 0, 'admin/structure/block/manage/%', 'admin/structure/block/manage/%', 'Translate', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/block/block.admin.inc'),
('admin/structure/file-types', '', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'file_list_types_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/file-types', 'File types', 't', '', '', 'a:0:{}', 6, 'Manage settings for the type of files used on your site.', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/add', '', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:1:{i:0;s:14:"file_type_form";}', '', 15, 4, 1, 'admin/structure/file-types', 'admin/structure/file-types', 'Add file type', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/classify', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'backdrop_get_form', 'a:1:{i:0;s:26:"file_type_classify_confirm";}', '', 15, 4, 0, '', 'admin/structure/file-types/classify', 'Classify file types', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/list', '', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'file_list_types_page', 'a:0:{}', '', 15, 4, 1, 'admin/structure/file-types', 'admin/structure/file-types', 'File types', 't', '', '', 'a:0:{}', 140, 'Manage settings for the type of files used on your site.', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:2:{i:0;s:14:"file_type_form";i:1;i:4;}', '', 30, 5, 0, '', 'admin/structure/file-types/manage/%', 'Configure file type', 'file_type_get_name', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/configure', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:2:{i:0;s:14:"file_type_form";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/file-types/manage/%', 'admin/structure/file-types/manage/%', 'Configure', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/delete', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:2:{i:0;s:24:"file_type_delete_confirm";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/file-types/manage/%/delete', 'Delete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/disable', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'file_type_toggle_enable', 'a:2:{i:0;i:4;i:1;s:1:"0";}', '', 61, 6, 0, '', 'admin/structure/file-types/manage/%/disable', 'Disable file type', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/display', 'a:1:{i:4;s:14:"file_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'field_ui_display_overview', 'a:2:{i:0;s:4:"file";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/file-types/manage/%', 'admin/structure/file-types/manage/%', 'Manage displays', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/%/configure', 'a:2:{i:4;s:14:"file_type_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:23:"field_ui_view_mode_form";i:1;s:4:"file";i:2;i:4;i:3;i:6;}', '', 245, 8, 0, '', 'admin/structure/file-types/manage/%/display/%/configure', 'Configure Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/%/delete', 'a:2:{i:4;s:14:"file_type_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:30:"field_ui_view_mode_delete_form";i:1;s:4:"file";i:2;i:4;i:3;i:6;}', '', 245, 8, 0, '', 'admin/structure/file-types/manage/%/display/%/delete', 'Delete Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/%/enable', 'a:2:{i:4;s:14:"file_type_load";i:6;N;}', '', 'field_ui_view_mode_enable_access', 'a:0:{}', 'field_ui_view_mode_enable', 'a:3:{i:0;s:4:"file";i:1;i:4;i:2;i:6;}', '', 245, 8, 0, '', 'admin/structure/file-types/manage/%/display/%/enable', 'Enable Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/%/reset', 'a:2:{i:4;s:14:"file_type_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:29:"field_ui_view_mode_reset_form";i:1;s:4:"file";i:2;i:4;i:3;i:6;}', '', 245, 8, 0, '', 'admin/structure/file-types/manage/%/display/%/reset', 'Reset to default', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/add', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:3:{i:0;s:23:"field_ui_view_mode_form";i:1;s:4:"file";i:2;i:4;}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Add display mode', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/default', 'a:1:{i:4;s:14:"file_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"file";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"file";i:2;i:4;i:3;s:7:"default";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Default', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/full', 'a:1:{i:4;s:14:"file_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"file";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"file";i:2;i:4;i:3;s:4:"full";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Full content', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/overview', 'a:1:{i:4;s:14:"file_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'field_ui_display_overview', 'a:2:{i:0;s:4:"file";i:1;i:4;}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', -99, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/preview', 'a:1:{i:4;s:14:"file_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"file";i:1;i:4;i:2;s:7:"preview";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"file";i:2;i:4;i:3;s:7:"preview";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Preview', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/teaser', 'a:1:{i:4;s:14:"file_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"file";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"file";i:2;i:4;i:3;s:6:"teaser";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Teaser', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/display/token', 'a:1:{i:4;s:14:"file_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"file";i:1;i:4;i:2;s:5:"token";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"file";i:2;i:4;i:3;s:5:"token";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/display', 'admin/structure/file-types/manage/%', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/enable', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'file_type_toggle_enable', 'a:2:{i:0;i:4;i:1;s:1:"1";}', '', 61, 6, 0, '', 'admin/structure/file-types/manage/%/enable', 'Enable file type', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/fields', 'a:1:{i:4;s:14:"file_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"file";i:2;i:4;}', '', 61, 6, 1, 'admin/structure/file-types/manage/%', 'admin/structure/file-types/manage/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/fields/%', 'a:2:{i:4;a:1:{s:14:"file_type_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}', '', 122, 7, 0, '', 'admin/structure/file-types/manage/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/fields/%/delete', 'a:2:{i:4;a:1:{s:14:"file_type_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}', '', 245, 8, 0, '', 'admin/structure/file-types/manage/%/fields/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 10, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/fields/%/edit', 'a:2:{i:4;a:1:{s:14:"file_type_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}', '', 245, 8, 1, 'admin/structure/file-types/manage/%/fields/%', 'admin/structure/file-types/manage/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/fields/%/field-settings', 'a:2:{i:4;a:1:{s:14:"file_type_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}', '', 245, 8, 1, 'admin/structure/file-types/manage/%/fields/%', 'admin/structure/file-types/manage/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/fields/%/widget-type', 'a:2:{i:4;a:1:{s:14:"file_type_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"file";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:21:"administer file types";}}', 'backdrop_get_form', 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}', '', 245, 8, 1, 'admin/structure/file-types/manage/%/fields/%', 'admin/structure/file-types/manage/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/file-types/manage/%/file-display', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"file_display_form";i:1;i:4;i:2;s:7:"default";}', '', 61, 6, 1, 'admin/structure/file-types/manage/%', 'admin/structure/file-types/manage/%', 'Manage file display', 't', '', '', 'a:0:{}', 132, '', '', 3, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/file-display/default', 'a:1:{i:4;s:14:"file_type_load";}', '', '_file_view_mode_menu_access', 'a:4:{i:0;i:4;i:1;s:7:"default";i:2;s:11:"user_access";i:3;s:21:"administer file types";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"file_display_form";i:1;i:4;i:2;s:7:"default";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/file-display', 'admin/structure/file-types/manage/%', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/file-display/full', 'a:1:{i:4;s:14:"file_type_load";}', '', '_file_view_mode_menu_access', 'a:4:{i:0;i:4;i:1;s:4:"full";i:2;s:11:"user_access";i:3;s:21:"administer file types";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"file_display_form";i:1;i:4;i:2;s:4:"full";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/file-display', 'admin/structure/file-types/manage/%', 'Full content', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/file-display/preview', 'a:1:{i:4;s:14:"file_type_load";}', '', '_file_view_mode_menu_access', 'a:4:{i:0;i:4;i:1;s:7:"preview";i:2;s:11:"user_access";i:3;s:21:"administer file types";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"file_display_form";i:1;i:4;i:2;s:7:"preview";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/file-display', 'admin/structure/file-types/manage/%', 'Preview', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/file-display/teaser', 'a:1:{i:4;s:14:"file_type_load";}', '', '_file_view_mode_menu_access', 'a:4:{i:0;i:4;i:1;s:6:"teaser";i:2;s:11:"user_access";i:3;s:21:"administer file types";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"file_display_form";i:1;i:4;i:2;s:6:"teaser";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/file-display', 'admin/structure/file-types/manage/%', 'Teaser', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/file-display/token', 'a:1:{i:4;s:14:"file_type_load";}', '', '_file_view_mode_menu_access', 'a:4:{i:0;i:4;i:1;s:5:"token";i:2;s:11:"user_access";i:3;s:21:"administer file types";}', 'backdrop_get_form', 'a:3:{i:0;s:17:"file_display_form";i:1;i:4;i:2;s:5:"token";}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/file-display', 'admin/structure/file-types/manage/%', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 3, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/manage/%/layouts', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:24:"layout_entity_admin_form";i:1;s:4:"file";i:2;i:4;}', '', 61, 6, 1, 'admin/structure/file-types/manage/%', 'admin/structure/file-types/manage/%', 'Manage layouts', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/layout/layout.entity.admin.inc'),
('admin/structure/file-types/manage/%/layouts/add', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:28:"layout_entity_admin_add_form";i:1;s:4:"file";i:2;i:4;}', '', 123, 7, 1, 'admin/structure/file-types/manage/%/layouts', 'admin/structure/file-types/manage/%', 'Add layout', 'layout_entity_menu_title', 'a:2:{i:0;s:4:"file";i:1;i:4;}', '', 'a:0:{}', 388, '', '', 0, 'core/modules/layout/layout.entity.admin.inc'),
('admin/structure/file-types/manage/%/revert', 'a:1:{i:4;s:14:"file_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:2:{i:0;s:24:"file_type_revert_confirm";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/file-types/manage/%/revert', 'Revert', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/file/file.admin.inc'),
('admin/structure/file-types/settings', '', '', 'user_access', 'a:1:{i:0;s:21:"administer file types";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"file_settings_form";}', '', 15, 4, 1, 'admin/structure/file-types', 'admin/structure/file-types', 'File settings', 't', '', '', 'a:0:{}', 132, 'Configure allowed file extensions and the file upload wizard.', '', 10, 'core/modules/file/file.admin.inc'),
('admin/structure/layouts', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_list_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/layouts', 'Layouts', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, 'Create new landing pages or modify the layout of existing pages on your site.', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/add', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_add_page', 'a:0:{}', '', 15, 4, 1, 'admin/structure/layouts', 'admin/structure/layouts', 'Add layout', 't', '', 'ajax_base_page_theme', 'a:0:{}', 388, '', '', -10, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/install', '', '', 'installer_install_access', 'a:0:{}', 'installer_browser_page', 'a:1:{i:0;s:6:"layout";}', '', 15, 4, 1, 'admin/structure/layouts', 'admin/structure/layouts', 'Install new layout templates', 't', '', 'ajax_base_page_theme', 'a:0:{}', 132, '', '', 4, 'core/modules/installer/installer.pages.inc'),
('admin/structure/layouts/list', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_list_page', 'a:0:{}', '', 15, 4, 1, 'admin/structure/layouts', 'admin/structure/layouts', 'List layouts', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', -10, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:19:"layout_content_form";i:1;i:4;}', '', 30, 5, 0, '', 'admin/structure/layouts/manage/%', 'Manage blocks', 'layout_page_title', 'a:1:{i:0;i:4;}', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/add-block/%/%', 'a:3:{i:4;s:21:"layout_tempstore_load";i:6;N;i:7;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_block_add_page', 'a:3:{i:0;i:4;i:1;i:6;i:2;i:7;}', '', 244, 8, 0, '', 'admin/structure/layouts/manage/%/add-block/%/%', 'Add block', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/blocks', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:19:"layout_content_form";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/layouts/manage/%', 'admin/structure/layouts/manage/%', 'Manage blocks', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/break-lock', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_break_lock_page', 'a:2:{i:0;i:4;i:1;s:6:"layout";}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/break-lock', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/clone', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:17:"layout_clone_form";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/clone', 'Clone layout', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/condition/add', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:25:"layout_condition_add_form";i:1;i:4;}', '', 123, 7, 0, '', 'admin/structure/layouts/manage/%/condition/add', 'Add visibility condition', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/condition/add/%', 'a:2:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:7;a:1:{s:27:"layout_tempstore_block_load";a:1:{i:0;i:4;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:25:"layout_condition_add_form";i:1;i:4;i:2;i:7;}', '', 246, 8, 0, '', 'admin/structure/layouts/manage/%/condition/add/%', 'Add visibility condition', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/condition/edit/%/%', 'a:3:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:7;a:1:{s:27:"layout_tempstore_block_load";a:1:{i:0;i:4;}}i:8;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:5:{i:0;s:25:"layout_condition_add_form";i:1;i:4;i:2;i:7;i:3;N;i:4;i:8;}', '', 492, 9, 0, '', 'admin/structure/layouts/manage/%/condition/edit/%/%', 'Configure condition', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/condition/edit/layout/%', 'a:2:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:8;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:5:{i:0;s:25:"layout_condition_add_form";i:1;i:4;i:2;N;i:3;N;i:4;i:8;}', '', 494, 9, 0, '', 'admin/structure/layouts/manage/%/condition/edit/layout/%', 'Configure condition', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/configure', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:20:"layout_settings_form";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/layouts/manage/%', 'admin/structure/layouts/manage/%', 'Configure layout', 't', '', 'ajax_base_page_theme', 'a:0:{}', 132, '', '', 10, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/configure-block/%/%', 'a:3:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:6;N;i:7;a:1:{s:27:"layout_tempstore_block_load";a:1:{i:0;i:4;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:4:{i:0;s:27:"layout_block_configure_form";i:1;i:4;i:2;i:7;i:3;i:6;}', '', 244, 8, 0, '', 'admin/structure/layouts/manage/%/configure-block/%/%', 'Configure block', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/configure-redirect/%', 'a:2:{i:4;a:1:{s:11:"layout_load";a:1:{i:0;i:4;}}i:6;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_block_configure_redirect', 'a:2:{i:0;i:4;i:1;i:6;}', '', 122, 7, 2, 'admin/structure/layouts/manage/%', 'admin/structure/layouts/manage/%', 'Configure block', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/configure-region/%/%', 'a:3:{i:4;s:21:"layout_tempstore_load";i:6;N;i:7;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:4:{i:0;s:28:"layout_configure_region_page";i:1;i:4;i:2;i:6;i:3;i:7;}', '', 244, 8, 0, '', 'admin/structure/layouts/manage/%/configure-region/%/%', 'Configure region', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/context/add', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:23:"layout_context_add_form";i:1;i:4;}', '', 123, 7, 0, '', 'admin/structure/layouts/manage/%/context/add', 'Add context', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.context.admin.inc'),
('admin/structure/layouts/manage/%/context/edit/layout/%', 'a:2:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:8;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:23:"layout_context_add_form";i:1;i:4;i:2;i:8;}', '', 494, 9, 0, '', 'admin/structure/layouts/manage/%/context/edit/layout/%', 'Configure context', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.context.admin.inc'),
('admin/structure/layouts/manage/%/delete', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:18:"layout_delete_form";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/delete', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/disable', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_toggle_enabled', 'a:2:{i:0;i:4;i:1;b:0;}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/disable', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/edit', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:55:"admin/structure/layouts/manage/%layout_tempstore/blocks";}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/edit', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('admin/structure/layouts/manage/%/edit-title/editor/title', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:26:"layout_title_settings_form";i:1;i:4;}', '', 247, 8, 0, '', 'admin/structure/layouts/manage/%/edit-title/editor/title', 'Configure page title', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/enable', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_toggle_enabled', 'a:2:{i:0;i:4;i:1;b:1;}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/enable', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/relationship/add', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:36:"layout_context_relationship_add_form";i:1;i:4;}', '', 123, 7, 0, '', 'admin/structure/layouts/manage/%/relationship/add', 'Add relationship', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.context.admin.inc'),
('admin/structure/layouts/manage/%/relationship/edit/layout/%', 'a:2:{i:4;s:21:"layout_tempstore_load";i:8;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:36:"layout_context_relationship_add_form";i:1;i:4;i:2;i:8;}', '', 494, 9, 0, '', 'admin/structure/layouts/manage/%/relationship/edit/layout/%', 'Configure relationship', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.context.admin.inc');
INSERT INTO `[[dbprefix]]menu_router` VALUES
('admin/structure/layouts/manage/%/remove-block/%/%', 'a:3:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:6;N;i:7;a:1:{s:27:"layout_tempstore_block_load";a:1:{i:0;i:4;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_block_remove_page', 'a:3:{i:0;i:4;i:1;i:7;i:2;i:6;}', '', 244, 8, 0, '', 'admin/structure/layouts/manage/%/remove-block/%/%', 'Remove block', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/manage/%/settings', 'a:1:{i:4;s:21:"layout_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:58:"admin/structure/layouts/manage/%layout_tempstore/configure";}', '', 61, 6, 0, '', 'admin/structure/layouts/manage/%/settings', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('admin/structure/layouts/manage/%/toggle-block-status/%/%', 'a:3:{i:4;a:1:{s:21:"layout_tempstore_load";a:1:{i:0;i:4;}}i:6;N;i:7;a:1:{s:27:"layout_tempstore_block_load";a:1:{i:0;i:4;}}}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_block_disable_page', 'a:3:{i:0;i:4;i:1;i:7;i:2;i:6;}', '', 244, 8, 0, '', 'admin/structure/layouts/manage/%/toggle-block-status/%/%', 'Disable block', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/menu/%', 'a:1:{i:4;s:31:"layout_tempstore_menu_item_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:21:"layout_menu_item_form";i:1;i:4;}', '', 30, 5, 0, '', 'admin/structure/layouts/menu/%', 'Menu settings', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/menu/%/break-lock', 'a:1:{i:4;s:31:"layout_tempstore_menu_item_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_break_lock_page', 'a:2:{i:0;i:4;i:1;s:9:"menu_item";}', '', 61, 6, 0, '', 'admin/structure/layouts/menu/%/break-lock', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/menu/%/condition/add', 'a:1:{i:4;s:31:"layout_tempstore_menu_item_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:4:{i:0;s:25:"layout_condition_add_form";i:1;N;i:2;N;i:3;i:4;}', '', 123, 7, 0, '', 'admin/structure/layouts/menu/%/condition/add', 'Add visibility condition', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/menu/%/condition/edit/%', 'a:2:{i:4;s:31:"layout_tempstore_menu_item_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:5:{i:0;s:25:"layout_condition_add_form";i:1;N;i:2;N;i:3;i:4;i:4;i:7;}', '', 246, 8, 0, '', 'admin/structure/layouts/menu/%/condition/edit/%', 'Configure condition', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/menu/%/settings', 'a:1:{i:4;s:31:"layout_tempstore_menu_item_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:2:{i:0;s:21:"layout_menu_item_form";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/layouts/menu/%', 'admin/structure/layouts/menu/%', 'Menu settings', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', -1, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/reorder', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:1:{i:0;s:19:"layout_reorder_form";}', '', 15, 4, 0, '', 'admin/structure/layouts/reorder', 'Reorder', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/settings', '', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:1:{i:0;s:20:"layout_settings_page";}', '', 15, 4, 1, 'admin/structure/layouts', 'admin/structure/layouts', 'Layout templates', 't', '', 'ajax_base_page_theme', 'a:0:{}', 132, 'Manage layout templates.', '', 20, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/settings/flexible-template/%/configure', 'a:1:{i:5;s:30:"layout_flexible_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'backdrop_get_form', 'a:2:{i:0;s:39:"layout_flexible_template_configure_form";i:1;i:5;}', '', 125, 7, 0, '', 'admin/structure/layouts/settings/flexible-template/%/configure', 'Configure flexible layout template', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/%/delete', 'a:1:{i:5;s:30:"layout_flexible_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'backdrop_get_form', 'a:2:{i:0;s:36:"layout_flexible_template_delete_form";i:1;i:5;}', '', 125, 7, 0, '', 'admin/structure/layouts/settings/flexible-template/%/delete', 'Delete flexible layout template', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/%/edit', 'a:1:{i:5;s:30:"layout_flexible_tempstore_load";}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'backdrop_get_form', 'a:2:{i:0;s:43:"layout_flexible_template_settings_edit_form";i:1;i:5;}', '', 125, 7, 0, '', 'admin/structure/layouts/settings/flexible-template/%/edit', 'Configure flexible layout template', 't', '', 'ajax_base_page_theme', 'a:0:{}', 6, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/%/row/%/configure', 'a:2:{i:5;s:30:"layout_flexible_tempstore_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'backdrop_get_form', 'a:3:{i:0;s:38:"layout_flexible_template_edit_row_form";i:1;i:5;i:2;i:7;}', '', 501, 9, 0, '', 'admin/structure/layouts/settings/flexible-template/%/row/%/configure', 'Add row', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/%/row/%/configure/%', 'a:2:{i:5;s:30:"layout_flexible_tempstore_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'backdrop_get_form', 'a:4:{i:0;s:38:"layout_flexible_template_edit_row_form";i:1;i:5;i:2;i:7;i:3;i:9;}', '', 501, 9, 0, '', 'admin/structure/layouts/settings/flexible-template/%/row/%/configure/%', 'Add row', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/%/row/%/delete', 'a:2:{i:5;s:30:"layout_flexible_tempstore_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'layout_flexible_template_delete_row', 'a:2:{i:0;i:5;i:1;i:7;}', '', 501, 9, 0, '', 'admin/structure/layouts/settings/flexible-template/%/row/%/delete', 'Delete row', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/%/row/%/select-widths', 'a:2:{i:5;s:30:"layout_flexible_tempstore_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'backdrop_get_form', 'a:3:{i:0;s:44:"layout_flexible_template_region_style_select";i:1;i:5;i:2;i:7;}', '', 501, 9, 0, '', 'admin/structure/layouts/settings/flexible-template/%/row/%/select-widths', 'Choose region widths', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/flexible-template/add', '', '', 'user_access', 'a:1:{i:0;s:29:"administer flexible templates";}', 'layout_flexible_template_settings_add_form', 'a:0:{}', '', 63, 6, 1, 'admin/structure/layouts/settings', 'admin/structure/layouts', 'Add flexible layout template', 't', '', 'ajax_base_page_theme', 'a:0:{}', 388, '', '', -10, 'core/modules/layout/layout.flexible.inc'),
('admin/structure/layouts/settings/toggle/%/disable', 'a:1:{i:5;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_template_toggle_enabled', 'a:2:{i:0;i:5;i:1;b:0;}', '', 125, 7, 0, '', 'admin/structure/layouts/settings/toggle/%/disable', 'Disable layout template', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/settings/toggle/%/enable', 'a:1:{i:5;N;}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'layout_template_toggle_enabled', 'a:2:{i:0;i:5;i:1;b:1;}', '', 125, 7, 0, '', 'admin/structure/layouts/settings/toggle/%/enable', 'Enable layout template', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.admin.inc'),
('admin/structure/layouts/update', '', '', 'user_access', 'a:1:{i:0;s:23:"installer_update_access";}', 'system_redirect_deprecated_page', 'a:1:{i:0;s:27:"admin/config/system/updates";}', '', 15, 4, 0, '', 'admin/structure/layouts/update', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('admin/structure/menu', '', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'menu_overview_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/menu', 'Menus', 't', '', '', 'a:0:{}', 6, 'Add new menus to your site, edit existing menus, and rename and reorganize menu links.', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/add', '', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}', '', 15, 4, 1, 'admin/structure/menu', 'admin/structure/menu', 'Add menu', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/item/%/delete', 'a:1:{i:4;s:14:"menu_link_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'menu_item_delete_page', 'a:1:{i:0;i:4;}', '', 61, 6, 0, '', 'admin/structure/menu/item/%/delete', 'Delete menu link', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/item/%/edit', 'a:1:{i:4;s:14:"menu_link_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}', '', 61, 6, 0, '', 'admin/structure/menu/item/%/edit', 'Edit link', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/item/%/reset', 'a:1:{i:4;s:14:"menu_link_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/menu/item/%/reset', 'Reset menu link', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/list', '', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'menu_overview_page', 'a:0:{}', '', 15, 4, 1, 'admin/structure/menu', 'admin/structure/menu', 'List menus', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%', 'a:1:{i:4;s:9:"menu_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}', '', 30, 5, 0, '', 'admin/structure/menu/manage/%', 'Edit links', 'menu_overview_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/add', 'a:1:{i:4;s:9:"menu_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:4;}', '', 61, 6, 3, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Add link', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/configure', 'a:1:{i:4;s:9:"menu_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:9:"configure";i:2;i:4;}', '', 61, 6, 1, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Configure menu', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/delete', 'a:1:{i:4;s:9:"menu_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'menu_delete_menu_page', 'a:1:{i:0;i:4;}', '', 61, 6, 0, '', 'admin/structure/menu/manage/%/delete', 'Delete menu', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/manage/%/list', 'a:1:{i:4;s:9:"menu_load";}', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}', '', 61, 6, 3, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Edit links', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/menu/menu.admin.inc'),
('admin/structure/menu/parents', '', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'menu_parent_options_js', 'a:0:{}', 'backdrop_json_deliver', 15, 4, 0, '', 'admin/structure/menu/parents', 'Parent menu items', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/structure/menu/settings', '', '', 'user_access', 'a:1:{i:0;s:15:"administer menu";}', 'backdrop_get_form', 'a:1:{i:0;s:18:"menu_settings_form";}', '', 15, 4, 1, 'admin/structure/menu', 'admin/structure/menu', 'Menu settings', 't', '', '', 'a:0:{}', 132, 'Configure global settings for menus.', '', 99, 'core/modules/menu/menu.admin.inc'),
('admin/structure/taxonomy', '', '', 'taxonomy_vocabulary_overview_access', 'a:0:{}', 'taxonomy_overview_vocabularies', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/taxonomy', 'Taxonomy', 't', '', '', 'a:0:{}', 6, 'Manage tagging, categorization, and classification of your content.', '', 0, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'taxonomy_vocabulary_access', 'a:2:{i:0;b:0;i:1;i:3;}', 'backdrop_get_form', 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}', '', 14, 4, 0, '', 'admin/structure/taxonomy/%', '', 'taxonomy_vocabulary_title', 'a:1:{i:0;i:3;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/add', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'taxonomy_vocabulary_access', 'a:2:{i:0;s:6:"create";i:1;i:3;}', 'backdrop_get_form', 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;N;i:2;i:3;}', '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Add term', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/configure', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'user_access', 'a:1:{i:0;s:19:"administer taxonomy";}', 'backdrop_get_form', 'a:2:{i:0;s:24:"taxonomy_form_vocabulary";i:1;i:3;}', '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Configure', 't', '', '', 'a:0:{}', 132, '', '', -10, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/delete', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'taxonomy_vocabulary_access', 'a:2:{i:0;b:0;i:1;i:3;}', 'backdrop_get_form', 'a:2:{i:0;s:34:"taxonomy_vocabulary_confirm_delete";i:1;i:3;}', '', 29, 5, 0, '', 'admin/structure/taxonomy/%/delete', 'Delete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/%/display', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'field_ui_display_overview', 'a:2:{i:0;s:13:"taxonomy_term";i:1;i:3;}', '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Manage displays', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/%/configure', 'a:2:{i:3;s:24:"taxonomy_vocabulary_load";i:5;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:23:"field_ui_view_mode_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;i:5;}', '', 117, 7, 0, '', 'admin/structure/taxonomy/%/display/%/configure', 'Configure Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/%/delete', 'a:2:{i:3;s:24:"taxonomy_vocabulary_load";i:5;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:30:"field_ui_view_mode_delete_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;i:5;}', '', 117, 7, 0, '', 'admin/structure/taxonomy/%/display/%/delete', 'Delete Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/%/enable', 'a:2:{i:3;s:24:"taxonomy_vocabulary_load";i:5;N;}', '', 'field_ui_view_mode_enable_access', 'a:0:{}', 'field_ui_view_mode_enable', 'a:3:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;i:5;}', '', 117, 7, 0, '', 'admin/structure/taxonomy/%/display/%/enable', 'Enable Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/%/reset', 'a:2:{i:3;s:24:"taxonomy_vocabulary_load";i:5;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:29:"field_ui_view_mode_reset_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;i:5;}', '', 117, 7, 0, '', 'admin/structure/taxonomy/%/display/%/reset', 'Reset to default', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/add', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:3:{i:0;s:23:"field_ui_view_mode_form";i:1;s:13:"taxonomy_term";i:2;i:3;}', '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Add display mode', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/default', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}', '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Default', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/full', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:4:"full";}', '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Taxonomy term page', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/overview', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'field_ui_display_overview', 'a:2:{i:0;s:13:"taxonomy_term";i:1;i:3;}', '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', -99, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/display/token', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:5:"token";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:5:"token";}', '', 59, 6, 1, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;}', '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%', 'a:2:{i:3;a:1:{s:24:"taxonomy_vocabulary_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}', '', 58, 6, 0, '', 'admin/structure/taxonomy/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/delete', 'a:2:{i:3;a:1:{s:24:"taxonomy_vocabulary_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}', '', 117, 7, 0, '', 'admin/structure/taxonomy/%/fields/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 10, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/edit', 'a:2:{i:3;a:1:{s:24:"taxonomy_vocabulary_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}', '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/field-settings', 'a:2:{i:3;a:1:{s:24:"taxonomy_vocabulary_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}', '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/fields/%/widget-type', 'a:2:{i:3;a:1:{s:24:"taxonomy_vocabulary_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}', 'backdrop_get_form', 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}', '', 117, 7, 1, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/taxonomy/%/layouts', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:24:"layout_entity_admin_form";i:1;s:13:"taxonomy_term";i:2;i:3;}', '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'Manage layouts', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/layout/layout.entity.admin.inc'),
('admin/structure/taxonomy/%/layouts/add', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:28:"layout_entity_admin_add_form";i:1;s:13:"taxonomy_term";i:2;i:3;}', '', 59, 6, 1, 'admin/structure/taxonomy/%/layouts', 'admin/structure/taxonomy/%', 'Add layout', 'layout_entity_menu_title', 'a:2:{i:0;s:13:"taxonomy_term";i:1;i:3;}', '', 'a:0:{}', 388, '', '', 0, 'core/modules/layout/layout.entity.admin.inc'),
('admin/structure/taxonomy/%/list', 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}', '', 'taxonomy_vocabulary_access', 'a:2:{i:0;b:0;i:1;i:3;}', 'backdrop_get_form', 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}', '', 29, 5, 1, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', 'List terms', 't', '', '', 'a:0:{}', 140, '', '', -20, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/add', '', '', 'user_access', 'a:1:{i:0;s:19:"administer taxonomy";}', 'backdrop_get_form', 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}', '', 15, 4, 1, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Add vocabulary', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/taxonomy/list', '', '', 'taxonomy_vocabulary_overview_access', 'a:0:{}', 'taxonomy_overview_vocabularies', 'a:0:{}', '', 15, 4, 1, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'List vocabularies', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/taxonomy/taxonomy.admin.inc'),
('admin/structure/types', '', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'node_overview_types', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/types', 'Content types', 't', '', '', 'a:0:{}', 6, 'Manage content types, including default status, home page promotion, comment settings, etc.', '', 0, 'core/modules/node/node.types.inc'),
('admin/structure/types/add', '', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'backdrop_get_form', 'a:1:{i:0;s:14:"node_type_form";}', '', 15, 4, 1, 'admin/structure/types', 'admin/structure/types', 'Add content type', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/node/node.types.inc'),
('admin/structure/types/list', '', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'node_overview_types', 'a:0:{}', '', 15, 4, 1, 'admin/structure/types', 'admin/structure/types', 'List content types', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/node/node.types.inc'),
('admin/structure/types/manage/%', 'a:1:{i:4;s:14:"node_type_load";}', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'backdrop_get_form', 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}', '', 30, 5, 0, '', 'admin/structure/types/manage/%', 'Configure content type', 'node_type_page_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/node/node.types.inc'),
('admin/structure/types/manage/%/comment/display', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'field_ui_display_overview', 'a:2:{i:0;s:7:"comment";i:1;i:4;}', '', 123, 7, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Comment display', 't', '', '', 'a:0:{}', 132, '', '', 4, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/%/configure', 'a:2:{i:4;s:27:"comment_menu_node_type_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:23:"field_ui_view_mode_form";i:1;s:7:"comment";i:2;i:4;i:3;i:7;}', '', 493, 9, 0, '', 'admin/structure/types/manage/%/comment/display/%/configure', 'Configure Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/%/delete', 'a:2:{i:4;s:27:"comment_menu_node_type_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:30:"field_ui_view_mode_delete_form";i:1;s:7:"comment";i:2;i:4;i:3;i:7;}', '', 493, 9, 0, '', 'admin/structure/types/manage/%/comment/display/%/delete', 'Delete Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/%/enable', 'a:2:{i:4;s:27:"comment_menu_node_type_load";i:7;N;}', '', 'field_ui_view_mode_enable_access', 'a:0:{}', 'field_ui_view_mode_enable', 'a:3:{i:0;s:7:"comment";i:1;i:4;i:2;i:7;}', '', 493, 9, 0, '', 'admin/structure/types/manage/%/comment/display/%/enable', 'Enable Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/%/reset', 'a:2:{i:4;s:27:"comment_menu_node_type_load";i:7;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:29:"field_ui_view_mode_reset_form";i:1;s:7:"comment";i:2;i:4;i:3;i:7;}', '', 493, 9, 0, '', 'admin/structure/types/manage/%/comment/display/%/reset', 'Reset to default', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/add', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:3:{i:0;s:23:"field_ui_view_mode_form";i:1;s:7:"comment";i:2;i:4;}', '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Add display mode', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/default', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}', '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Default', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/full', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:7:"comment";i:2;i:4;i:3;s:4:"full";}', '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Full comment', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/overview', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'field_ui_display_overview', 'a:2:{i:0;s:7:"comment";i:1;i:4;}', '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', -99, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/display/token', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:5:"token";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:7:"comment";i:2;i:4;i:3;s:5:"token";}', '', 247, 8, 1, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields', 'a:1:{i:4;s:27:"comment_menu_node_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:7:"comment";i:2;i:4;}', '', 123, 7, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Comment fields', 't', '', '', 'a:0:{}', 132, '', '', 3, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%', 'a:2:{i:4;a:1:{s:27:"comment_menu_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}', '', 246, 8, 0, '', 'admin/structure/types/manage/%/comment/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:7;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/delete', 'a:2:{i:4;a:1:{s:27:"comment_menu_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:7;}', '', 493, 9, 0, '', 'admin/structure/types/manage/%/comment/fields/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 10, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/edit', 'a:2:{i:4;a:1:{s:27:"comment_menu_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}', '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/field-settings', 'a:2:{i:4;a:1:{s:27:"comment_menu_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:7;}', '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/comment/fields/%/widget-type', 'a:2:{i:4;a:1:{s:27:"comment_menu_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:7;}', '', 493, 9, 1, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/configure', 'a:1:{i:4;s:14:"node_type_load";}', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'backdrop_get_form', 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Configure', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/node/node.types.inc'),
('admin/structure/types/manage/%/delete', 'a:1:{i:4;s:14:"node_type_load";}', '', 'user_access', 'a:1:{i:0;s:24:"administer content types";}', 'backdrop_get_form', 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/types/manage/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/node/node.types.inc'),
('admin/structure/types/manage/%/display', 'a:1:{i:4;s:14:"node_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'field_ui_display_overview', 'a:2:{i:0;s:4:"node";i:1;i:4;}', '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Manage displays', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/%/configure', 'a:2:{i:4;s:14:"node_type_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:23:"field_ui_view_mode_form";i:1;s:4:"node";i:2;i:4;i:3;i:6;}', '', 245, 8, 0, '', 'admin/structure/types/manage/%/display/%/configure', 'Configure Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/%/delete', 'a:2:{i:4;s:14:"node_type_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:30:"field_ui_view_mode_delete_form";i:1;s:4:"node";i:2;i:4;i:3;i:6;}', '', 245, 8, 0, '', 'admin/structure/types/manage/%/display/%/delete', 'Delete Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/%/enable', 'a:2:{i:4;s:14:"node_type_load";i:6;N;}', '', 'field_ui_view_mode_enable_access', 'a:0:{}', 'field_ui_view_mode_enable', 'a:3:{i:0;s:4:"node";i:1;i:4;i:2;i:6;}', '', 245, 8, 0, '', 'admin/structure/types/manage/%/display/%/enable', 'Enable Display mode', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/%/reset', 'a:2:{i:4;s:14:"node_type_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:4:{i:0;s:29:"field_ui_view_mode_reset_form";i:1;s:4:"node";i:2;i:4;i:3;i:6;}', '', 245, 8, 0, '', 'admin/structure/types/manage/%/display/%/reset', 'Reset to default', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/add', 'a:1:{i:4;s:14:"node_type_load";}', '', 'user_access', 'a:1:{i:0;s:21:"administer view modes";}', 'backdrop_get_form', 'a:3:{i:0;s:23:"field_ui_view_mode_form";i:1;s:4:"node";i:2;i:4;}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Add display mode', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/default', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Default', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/full', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Full content', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/overview', 'a:1:{i:4;s:14:"node_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'field_ui_display_overview', 'a:2:{i:0;s:4:"node";i:1;i:4;}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Overview', 't', '', '', 'a:0:{}', 140, '', '', -99, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/rss', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'RSS', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/search_index', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:12:"search_index";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:12:"search_index";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Search index', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/search_result', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:13:"search_result";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:13:"search_result";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Search result highlighting input', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/teaser', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Teaser', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/display/token', 'a:1:{i:4;s:14:"node_type_load";}', '', '_field_ui_view_mode_menu_access', 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:5:"token";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:4:{i:0;s:21:"field_ui_display_form";i:1;s:4:"node";i:2;i:4;i:3;s:5:"token";}', '', 123, 7, 1, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields', 'a:1:{i:4;s:14:"node_type_load";}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}', '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%', 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}', '', 122, 7, 0, '', 'admin/structure/types/manage/%/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/delete', 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}', '', 245, 8, 0, '', 'admin/structure/types/manage/%/fields/%/delete', 'Delete', 't', '', '', 'a:0:{}', 4, '', '', 10, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/edit', 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}', '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/field-settings', 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}', '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/fields/%/widget-type', 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}', '', 'field_ui_admin_access', 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}', 'backdrop_get_form', 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}', '', 245, 8, 1, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/field_ui/field_ui.admin.inc'),
('admin/structure/types/manage/%/layouts', 'a:1:{i:4;s:14:"node_type_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:24:"layout_entity_admin_form";i:1;s:4:"node";i:2;i:4;}', '', 61, 6, 1, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Manage layouts', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/layout/layout.entity.admin.inc'),
('admin/structure/types/manage/%/layouts/add', 'a:1:{i:4;s:14:"node_type_load";}', '', 'user_access', 'a:1:{i:0;s:18:"administer layouts";}', 'backdrop_get_form', 'a:3:{i:0;s:28:"layout_entity_admin_add_form";i:1;s:4:"node";i:2;i:4;}', '', 123, 7, 1, 'admin/structure/types/manage/%/layouts', 'admin/structure/types/manage/%', 'Add layout', 'layout_entity_menu_title', 'a:2:{i:0;s:4:"node";i:1;i:4;}', '', 'a:0:{}', 388, '', '', 0, 'core/modules/layout/layout.entity.admin.inc'),
('admin/structure/views', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_list_page', 'a:0:{}', '', 7, 3, 0, '', 'admin/structure/views', 'Views', 't', '', '', 'a:0:{}', 6, 'Manage customized lists of content.', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/add', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_add_page', 'a:0:{}', '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'Add view', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/ajax/%/%', 'a:2:{i:4;N;i:5;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_ajax_form', 'a:3:{i:0;b:1;i:1;i:4;i:2;i:5;}', 'ajax_deliver', 60, 6, 0, '', 'admin/structure/views/ajax/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/ajax/preview/%/%', 'a:2:{i:5;s:19:"views_ui_cache_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_preview', 'a:2:{i:0;i:5;i:1;i:6;}', 'ajax_deliver', 124, 7, 0, '', 'admin/structure/views/ajax/preview/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/list', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_list_page', 'a:0:{}', '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'List views', 't', '', '', 'a:0:{}', 140, '', '', -1, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/nojs/%/%', 'a:2:{i:4;N;i:5;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_ajax_form', 'a:3:{i:0;b:0;i:1;i:4;i:2;i:5;}', '', 60, 6, 0, '', 'admin/structure/views/nojs/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc');
INSERT INTO `[[dbprefix]]menu_router` VALUES
('admin/structure/views/nojs/preview/%/%', 'a:2:{i:5;s:19:"views_ui_cache_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_preview', 'a:2:{i:0;i:5;i:1;i:6;}', '', 124, 7, 0, '', 'admin/structure/views/nojs/preview/%/%', '', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/settings', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'backdrop_get_form', 'a:1:{i:0;s:29:"views_ui_admin_settings_basic";}', '', 15, 4, 1, 'admin/structure/views', 'admin/structure/views', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/settings/advanced', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'backdrop_get_form', 'a:1:{i:0;s:32:"views_ui_admin_settings_advanced";}', '', 31, 5, 1, 'admin/structure/views/settings', 'admin/structure/views', 'Advanced', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/settings/basic', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'backdrop_get_form', 'a:1:{i:0;s:29:"views_ui_admin_settings_basic";}', '', 31, 5, 1, 'admin/structure/views/settings', 'admin/structure/views', 'Basic', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_edit_page', 'a:1:{i:0;i:4;}', '', 30, 5, 0, '', 'admin/structure/views/view/%', '', 'views_ui_edit_page_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/break-lock', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'backdrop_get_form', 'a:2:{i:0;s:27:"views_ui_break_lock_confirm";i:1;i:4;}', '', 61, 6, 0, '', 'admin/structure/views/view/%/break-lock', 'Break lock', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/clone', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'backdrop_get_form', 'a:2:{i:0;s:19:"views_ui_clone_form";i:1;i:4;}', '', 61, 6, 3, '', 'admin/structure/views/view/%/clone', 'Clone view', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/configure', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_edit_page', 'a:1:{i:0;i:4;}', '', 61, 6, 3, 'admin/structure/views/view/%', 'admin/structure/views/view/%', 'Configure view', 't', '', 'ajax_base_page_theme', 'a:0:{}', 140, '', '', -10, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/configure/%/ajax', 'a:2:{i:4;s:19:"views_ui_cache_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_ajax_get_form', 'a:3:{i:0;s:18:"views_ui_edit_form";i:1;i:4;i:2;i:6;}', 'ajax_deliver', 245, 8, 0, '', 'admin/structure/views/view/%/configure/%/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/delete', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'views_ui_menu_action_access', 'a:2:{i:0;i:4;i:1;s:6:"delete";}', 'backdrop_get_form', 'a:2:{i:0;s:20:"views_ui_delete_form";i:1;i:4;}', '', 61, 6, 3, '', 'admin/structure/views/view/%/delete', 'Delete view', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/disable', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_toggle_enable_page', 'a:2:{i:0;i:4;i:1;s:1:"0";}', '', 61, 6, 0, '', 'admin/structure/views/view/%/disable', 'Disable view', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/enable', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_toggle_enable_page', 'a:2:{i:0;i:4;i:1;s:1:"1";}', '', 61, 6, 0, '', 'admin/structure/views/view/%/enable', 'Enable view', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/preview/%', 'a:2:{i:4;s:19:"views_ui_cache_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_build_preview', 'a:2:{i:0;i:4;i:1;i:6;}', '', 122, 7, 3, '', 'admin/structure/views/view/%/preview/%', '', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/preview/%/ajax', 'a:2:{i:4;s:19:"views_ui_cache_load";i:6;N;}', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_build_preview', 'a:2:{i:0;i:4;i:1;i:6;}', 'ajax_deliver', 245, 8, 0, '', 'admin/structure/views/view/%/preview/%/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/structure/views/view/%/revert', 'a:1:{i:4;s:19:"views_ui_cache_load";}', '', 'views_ui_menu_action_access', 'a:2:{i:0;i:4;i:1;s:6:"revert";}', 'backdrop_get_form', 'a:2:{i:0;s:20:"views_ui_revert_form";i:1;i:4;}', '', 61, 6, 3, '', 'admin/structure/views/view/%/revert', 'Revert view', 't', '', '', 'a:0:{}', 4, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/tasks', '', '', 'user_access', 'a:1:{i:0;s:27:"access administration pages";}', 'system_admin_menu_block_page', 'a:0:{}', '', 3, 2, 1, 'admin', 'admin', 'Tasks', 't', '', '', 'a:0:{}', 140, '', '', -20, 'core/modules/system/system.admin.inc'),
('admin/update/ready', '', '', 'installer_install_access', 'a:0:{}', 'backdrop_get_form', 'a:1:{i:0;s:35:"installer_manager_update_ready_form";}', '', 7, 3, 0, '', 'admin/update/ready', 'Ready to update', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/installer/installer.manager.inc'),
('admin/views/ajax/autocomplete/tag', '', '', 'user_access', 'a:1:{i:0;s:16:"administer views";}', 'views_ui_autocomplete_tag', 'a:0:{}', 'backdrop_json_deliver', 31, 5, 0, '', 'admin/views/ajax/autocomplete/tag', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/views_ui/views_ui.admin.inc'),
('admin/views/ajax/autocomplete/taxonomy', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'views_ajax_autocomplete_taxonomy', 'a:0:{}', '', 31, 5, 0, '', 'admin/views/ajax/autocomplete/taxonomy', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/views/includes/ajax.inc'),
('admin/views/ajax/autocomplete/user', '', '', 'user_access', 'a:1:{i:0;s:20:"access user profiles";}', 'views_ajax_autocomplete_user', 'a:0:{}', '', 31, 5, 0, '', 'admin/views/ajax/autocomplete/user', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/views/includes/ajax.inc'),
('admin_bar/flush-cache', '', '', 'user_access', 'a:1:{i:0;s:12:"flush caches";}', 'admin_bar_flush_cache', 'a:0:{}', '', 3, 2, 0, '', 'admin_bar/flush-cache', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/admin_bar/admin_bar.inc'),
('batch', '', '', '1', 'a:0:{}', 'system_batch_page', 'a:0:{}', '', 1, 1, 0, '', 'batch', '', 't', '', '_system_batch_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('ckeditor5/upload/image/%', 'a:1:{i:3;s:18:"filter_format_load";}', '', 'filter_dialog_access', 'a:2:{i:0;i:3;i:1;s:5:"image";}', 'ckeditor5_image_upload', 'a:1:{i:0;i:3;}', 'backdrop_json_deliver', 14, 4, 0, '', 'ckeditor5/upload/image/%', 'Upload image', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/ckeditor5/ckeditor5.pages.inc'),
('color/save_preview_settings/%', 'a:1:{i:2;N;}', '', 'user_access', 'a:1:{i:0;s:17:"administer themes";}', 'color_save_preview_settings', 'a:1:{i:0;i:2;}', 'backdrop_json_deliver', 6, 3, 0, '', 'color/save_preview_settings/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('comment/%', 'a:1:{i:1;N;}', '', 'user_access', 'a:1:{i:0;s:15:"access comments";}', 'comment_permalink', 'a:1:{i:0;i:1;}', '', 2, 2, 0, '', 'comment/%', 'Comment permalink', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('comment/%/approve', 'a:1:{i:1;N;}', '', 'user_access', 'a:1:{i:0;s:19:"administer comments";}', 'comment_approve', 'a:1:{i:0;i:1;}', '', 5, 3, 0, '', 'comment/%/approve', 'Approve', 't', '', '', 'a:0:{}', 6, '', '', 1, 'core/modules/comment/comment.pages.inc'),
('comment/%/delete', 'a:1:{i:1;N;}', '', 'user_access', 'a:1:{i:0;s:19:"administer comments";}', 'comment_confirm_delete_page', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'comment/%', 'comment/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/comment/comment.admin.inc'),
('comment/%/edit', 'a:1:{i:1;s:12:"comment_load";}', '', 'comment_access', 'a:2:{i:0;s:6:"update";i:1;i:1;}', 'comment_edit_page', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'comment/%', 'comment/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, ''),
('comment/%/view', 'a:1:{i:1;N;}', '', 'user_access', 'a:1:{i:0;s:15:"access comments";}', 'comment_permalink', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'comment/%', 'comment/%', 'View comment', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('comment/reply/%', 'a:1:{i:2;s:9:"node_load";}', '', 'node_access', 'a:2:{i:0;s:4:"view";i:1;i:2;}', 'comment_reply', 'a:1:{i:0;i:2;}', '', 6, 3, 0, '', 'comment/reply/%', 'Add comment', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/comment/comment.pages.inc'),
('editor/dialog/image/%', 'a:1:{i:3;s:18:"filter_format_load";}', '', 'filter_dialog_access', 'a:2:{i:0;i:3;i:1;s:5:"image";}', 'backdrop_get_form', 'a:2:{i:0;s:31:"filter_format_editor_image_form";i:1;i:3;}', '', 14, 4, 0, '', 'editor/dialog/image/%', 'Edit image', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/filter/filter.pages.inc'),
('editor/dialog/link/%', 'a:1:{i:3;s:18:"filter_format_load";}', '', 'filter_dialog_access', 'a:2:{i:0;i:3;i:1;s:4:"link";}', 'backdrop_get_form', 'a:2:{i:0;s:30:"filter_format_editor_link_form";i:1;i:3;}', '', 14, 4, 0, '', 'editor/dialog/link/%', 'Edit image', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/filter/filter.pages.inc'),
('file/%', 'a:1:{i:1;s:9:"file_load";}', '', 'file_access', 'a:2:{i:0;s:4:"view";i:1;i:1;}', 'file_view_page', 'a:1:{i:0;i:1;}', '', 2, 2, 0, '', 'file/%', '', 'entity_label', 'a:2:{i:0;s:4:"file";i:1;i:1;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/file/file.pages.inc'),
('file/%/delete', 'a:1:{i:1;s:9:"file_load";}', '', 'file_access', 'a:2:{i:0;s:6:"delete";i:1;i:1;}', 'backdrop_get_form', 'a:2:{i:0;s:16:"file_delete_form";i:1;i:1;}', '', 5, 3, 0, '', 'file/%/delete', 'Delete', 't', '', '', 'a:0:{}', 0, '', '', 1, 'core/modules/file/file.pages.inc'),
('file/%/download', 'a:1:{i:1;s:9:"file_load";}', '', 'file_access', 'a:2:{i:0;s:8:"download";i:1;i:1;}', 'file_download_page', 'a:1:{i:0;i:1;}', '', 5, 3, 0, '', 'file/%/download', 'Download', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/file/file.pages.inc'),
('file/%/manage', 'a:1:{i:1;s:9:"file_load";}', '', 'file_access', 'a:2:{i:0;s:6:"update";i:1;i:1;}', 'backdrop_get_form', 'a:2:{i:0;s:16:"file_manage_form";i:1;i:1;}', '', 5, 3, 3, 'file/%', 'file/%', 'Manage', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/file/file.pages.inc'),
('file/%/usage', 'a:1:{i:1;s:9:"file_load";}', '', 'file_access', 'a:2:{i:0;s:6:"update";i:1;i:1;}', 'file_usage_page', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'file/%', 'file/%', 'Usage', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/file/file.pages.inc'),
('file/%/view', 'a:1:{i:1;s:9:"file_load";}', '', 'file_access', 'a:2:{i:0;s:4:"view";i:1;i:1;}', 'file_view_page', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'file/%', 'file/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, 'core/modules/file/file.pages.inc'),
('file/add', '', '', 'user_access', 'a:1:{i:0;s:12:"create files";}', 'backdrop_get_form', 'a:1:{i:0;s:13:"file_add_form";}', '', 3, 2, 1, '', 'file/add', 'Add a file', 't', '', '', 'a:0:{}', 388, '', '', -10, 'core/modules/file/file.pages.inc'),
('file/ajax', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'file_ajax_upload', 'a:0:{}', 'ajax_deliver', 3, 2, 0, '', 'file/ajax', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('file/progress', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'file_ajax_progress', 'a:0:{}', 'backdrop_json_deliver', 3, 2, 0, '', 'file/progress', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, ''),
('files/styles/%', 'a:1:{i:2;s:16:"image_style_load";}', '', '1', 'a:0:{}', 'image_style_deliver', 'a:1:{i:0;i:2;}', '', 6, 3, 0, '', 'files/styles/%', 'Generate image style', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('filter/tips', '', '', '1', 'a:0:{}', 'filter_tips_long', 'a:0:{}', '', 3, 2, 0, '', 'filter/tips', 'Compose tips', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/filter/filter.pages.inc'),
('filter/tips/%', 'a:1:{i:2;s:18:"filter_format_load";}', '', 'filter_access', 'a:1:{i:0;i:2;}', 'filter_tips_long', 'a:1:{i:0;i:2;}', '', 6, 3, 0, '', 'filter/tips/%', 'Compose tips', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/filter/filter.pages.inc'),
('home', '', '', 'layout_page_access', 'a:2:{i:0;s:4:"home";i:1;i:0;}', 'layout_page_callback', 'a:2:{i:0;s:4:"home";i:1;i:0;}', '', 1, 1, 0, '', 'home', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/layout/layout.pages.inc'),
('js/admin_bar/cache', '', '', 'user_access', 'a:1:{i:0;s:25:"access administration bar";}', 'admin_bar_js_cache', 'a:0:{}', 'admin_bar_deliver', 7, 3, 0, '', 'js/admin_bar/cache', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('node', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'node_page_default', 'a:0:{}', '', 1, 1, 0, '', 'node', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('node/%', 'a:1:{i:1;s:9:"node_load";}', '', 'node_access', 'a:2:{i:0;s:4:"view";i:1;i:1;}', 'node_page_view', 'a:1:{i:0;i:1;}', '', 2, 2, 0, '', 'node/%', '', 'node_page_title', 'a:1:{i:0;i:1;}', '', 'a:0:{}', 6, '', '', 0, ''),
('node/%/delete', 'a:1:{i:1;s:9:"node_load";}', '', 'node_access', 'a:2:{i:0;s:6:"delete";i:1;i:1;}', 'backdrop_get_form', 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}', '', 5, 3, 2, 'node/%', 'node/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 1, 'core/modules/node/node.pages.inc'),
('node/%/edit', 'a:1:{i:1;s:9:"node_load";}', '', 'node_access', 'a:2:{i:0;s:6:"update";i:1;i:1;}', 'node_page_edit', 'a:1:{i:0;i:1;}', '', 5, 3, 3, 'node/%', 'node/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/node/node.pages.inc'),
('node/%/revisions', 'a:1:{i:1;s:9:"node_load";}', '', '_node_revision_access', 'a:1:{i:0;i:1;}', 'node_revision_overview', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'node/%', 'node/%', 'Revisions', 't', '', '', 'a:0:{}', 132, '', '', 2, 'core/modules/node/node.pages.inc'),
('node/%/revisions/%/delete', 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}', '', '_node_revision_access', 'a:2:{i:0;i:1;i:1;s:6:"delete";}', 'backdrop_get_form', 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}', '', 21, 5, 0, '', 'node/%/revisions/%/delete', 'Delete earlier revision', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/node/node.pages.inc'),
('node/%/revisions/%/revert', 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}', '', '_node_revision_access', 'a:2:{i:0;i:1;i:1;s:6:"update";}', 'backdrop_get_form', 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}', '', 21, 5, 0, '', 'node/%/revisions/%/revert', 'Revert to earlier revision', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/node/node.pages.inc'),
('node/%/revisions/%/view', 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}', '', '_node_revision_access', 'a:1:{i:0;i:1;}', 'node_show', 'a:2:{i:0;i:1;i:1;b:1;}', '', 21, 5, 0, '', 'node/%/revisions/%/view', 'Revisions', 't', '', '', 'a:0:{}', 6, '', '', 0, ''),
('node/%/view', 'a:1:{i:1;s:9:"node_load";}', '', 'node_access', 'a:2:{i:0;s:4:"view";i:1;i:1;}', 'node_page_view', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'node/%', 'node/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('node/add', '', '', '_node_add_access', 'a:0:{}', 'node_add_page', 'a:0:{}', '', 3, 2, 0, '', 'node/add', 'Add content', 't', '', '', 'a:0:{}', 6, '', '', -20, 'core/modules/node/node.pages.inc'),
('node/add/card', '', '', 'node_access', 'a:2:{i:0;s:6:"create";i:1;s:4:"card";}', 'node_add', 'a:1:{i:0;s:4:"card";}', '', 7, 3, 0, '', 'node/add/card', 'Card', 'check_plain', '', '', 'a:0:{}', 6, 'Add a card for use on an existing page. Display as a block or in a view.', '', 0, 'core/modules/node/node.pages.inc'),
('node/add/page', '', '', 'node_access', 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}', 'node_add', 'a:1:{i:0;s:4:"page";}', '', 7, 3, 0, '', 'node/add/page', 'Page', 'check_plain', '', '', 'a:0:{}', 6, 'Add a page with static content, like the ''About'' page.', '', 0, 'core/modules/node/node.pages.inc'),
('node/add/post', '', '', 'node_access', 'a:2:{i:0;s:6:"create";i:1;s:4:"post";}', 'node_add', 'a:1:{i:0;s:4:"post";}', '', 7, 3, 0, '', 'node/add/post', 'Post', 'check_plain', '', '', 'a:0:{}', 6, 'Add a blog post, news article, or press release.', '', 0, 'core/modules/node/node.pages.inc'),
('node/autocomplete', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'node_autocomplete', 'a:0:{}', '', 3, 2, 0, '', 'node/autocomplete', 'Node autocomplete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/node/node.pages.inc'),
('node/preview/card/%', 'a:1:{i:3;N;}', '', 'node_preview_access', 'a:1:{i:0;i:3;}', 'node_preview', 'a:2:{i:0;i:3;i:1;s:4:"card";}', '', 14, 4, 0, '', 'node/preview/card/%', 'Card', 'check_plain', '', '', 'a:0:{}', 0, 'Add a card for use on an existing page. Display as a block or in a view.', '', 0, 'core/modules/node/node.pages.inc'),
('node/preview/page/%', 'a:1:{i:3;N;}', '', 'node_preview_access', 'a:1:{i:0;i:3;}', 'node_preview', 'a:2:{i:0;i:3;i:1;s:4:"page";}', '', 14, 4, 0, '', 'node/preview/page/%', 'Page', 'check_plain', '', '', 'a:0:{}', 0, 'Add a page with static content, like the ''About'' page.', '', 0, 'core/modules/node/node.pages.inc'),
('node/preview/post/%', 'a:1:{i:3;N;}', '', 'node_preview_access', 'a:1:{i:0;i:3;}', 'node_preview', 'a:2:{i:0;i:3;i:1;s:4:"post";}', '', 14, 4, 0, '', 'node/preview/post/%', 'Post', 'check_plain', '', '', 'a:0:{}', 0, 'Add a blog post, news article, or press release.', '', 0, 'core/modules/node/node.pages.inc'),
('path-autocomplete', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'path_autocomplete', 'a:0:{}', '', 1, 1, 0, '', 'path-autocomplete', 'Path autocomplete', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('rss.xml', '', '', 'views_access', 'a:1:{i:0;a:2:{i:0;s:16:"views_check_perm";i:1;a:1:{i:0;s:14:"access content";}}}', 'views_page', 'a:2:{i:0;s:8:"promoted";i:1;s:4:"feed";}', '', 1, 1, 0, '', 'rss.xml', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('search', '', '', 'search_is_active', 'a:0:{}', 'search_view', 'a:0:{}', '', 1, 1, 0, '', 'search', 'Search', 't', '', '', 'a:0:{}', 20, '', '', 0, 'core/modules/search/search.pages.inc'),
('search/node', '', '', '_search_menu_access', 'a:1:{i:0;s:4:"node";}', 'search_view', 'a:2:{i:0;s:4:"node";i:1;s:0:"";}', '', 3, 2, 1, 'search', 'search', 'Content', 't', '', '', 'a:0:{}', 132, '', '', -10, 'core/modules/search/search.pages.inc'),
('search/node/%', 'a:1:{i:2;a:1:{s:14:"menu_tail_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}', 'a:1:{i:2;s:16:"menu_tail_to_arg";}', '_search_menu_access', 'a:1:{i:0;s:4:"node";}', 'search_view', 'a:2:{i:0;s:4:"node";i:1;i:2;}', '', 6, 3, 1, 'search/node', 'search/node/%', 'Content', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/search/search.pages.inc'),
('search/user', '', '', '_search_menu_access', 'a:1:{i:0;s:4:"user";}', 'search_view', 'a:2:{i:0;s:4:"user";i:1;s:0:"";}', '', 3, 2, 1, 'search', 'search', 'User accounts', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/search/search.pages.inc'),
('search/user/%', 'a:1:{i:2;a:1:{s:14:"menu_tail_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}', 'a:1:{i:2;s:16:"menu_tail_to_arg";}', '_search_menu_access', 'a:1:{i:0;s:4:"user";}', 'search_view', 'a:2:{i:0;s:4:"user";i:1;i:2;}', '', 6, 3, 1, 'search/node', 'search/node/%', 'User accounts', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/search/search.pages.inc'),
('system/403', '', '', '1', 'a:0:{}', 'system_403', 'a:0:{}', '', 3, 2, 0, '', 'system/403', 'Access denied', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/404', '', '', '1', 'a:0:{}', 'system_404', 'a:0:{}', '', 3, 2, 0, '', 'system/404', 'Page not found', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/404/add-redirect', '', '', 'redirect_access', 'a:2:{i:0;s:6:"create";i:1;s:8:"redirect";}', 'redirect_add_redirect_page', 'a:0:{}', '', 7, 3, 1, 'system/404', 'system/404', 'Add a URL redirect from this page to another location', 't', '', '', 'a:0:{}', 388, '', '', 0, 'core/modules/redirect/redirect.admin.inc'),
('system/ajax', '', '', '1', 'a:0:{}', 'ajax_form_callback', 'a:0:{}', 'ajax_deliver', 3, 2, 0, '', 'system/ajax', 'AJAX callback', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/includes/form.inc'),
('system/files', '', '', '1', 'a:0:{}', 'file_download', 'a:1:{i:0;s:7:"private";}', '', 3, 2, 0, '', 'system/files', 'File download', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/files/styles/%', 'a:1:{i:3;s:16:"image_style_load";}', '', '1', 'a:0:{}', 'image_style_deliver', 'a:1:{i:0;i:3;}', '', 14, 4, 0, '', 'system/files/styles/%', 'Generate image style', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/temporary', '', '', '1', 'a:0:{}', 'file_download', 'a:1:{i:0;s:9:"temporary";}', '', 3, 2, 0, '', 'system/temporary', 'Temporary files', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('system/timezone', '', '', '1', 'a:0:{}', 'system_timezone', 'a:0:{}', 'backdrop_json_deliver', 3, 2, 0, '', 'system/timezone', 'Time zone', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('system/transliterate/%', 'a:1:{i:2;N;}', '', 'system_transliterate_ajax_access', 'a:0:{}', 'system_transliterate_ajax', 'a:1:{i:0;i:2;}', '', 6, 3, 0, '', 'system/transliterate/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.admin.inc'),
('taxonomy/autocomplete', '', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'taxonomy_autocomplete', 'a:0:{}', 'backdrop_json_deliver', 3, 2, 0, '', 'taxonomy/autocomplete', 'Autocomplete taxonomy', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/taxonomy/taxonomy.pages.inc'),
('taxonomy/term/%', 'a:1:{i:2;s:18:"taxonomy_term_load";}', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'taxonomy_term_page', 'a:1:{i:0;i:2;}', '', 6, 3, 0, '', 'taxonomy/term/%', 'Taxonomy term', 'taxonomy_term_title', 'a:1:{i:0;i:2;}', '', 'a:0:{}', 6, '', '', 0, 'core/modules/taxonomy/taxonomy.pages.inc'),
('taxonomy/term/%/delete', 'a:1:{i:2;s:18:"taxonomy_term_load";}', '', 'taxonomy_term_access', 'a:2:{i:0;s:6:"delete";i:1;i:2;}', 'backdrop_get_form', 'a:2:{i:0;s:28:"taxonomy_term_confirm_delete";i:1;i:2;}', '', 13, 4, 1, 'taxonomy/term/%', 'taxonomy/term/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 11, 'core/modules/taxonomy/taxonomy.admin.inc'),
('taxonomy/term/%/edit', 'a:1:{i:2;s:18:"taxonomy_term_load";}', '', 'taxonomy_term_access', 'a:2:{i:0;s:6:"update";i:1;i:2;}', 'backdrop_get_form', 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}', '', 13, 4, 1, 'taxonomy/term/%', 'taxonomy/term/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 10, 'core/modules/taxonomy/taxonomy.admin.inc'),
('taxonomy/term/%/feed', 'a:1:{i:2;s:18:"taxonomy_term_load";}', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'taxonomy_term_feed', 'a:1:{i:0;i:2;}', 'backdrop_deliver_html_page', 13, 4, 0, '', 'taxonomy/term/%/feed', 'Taxonomy term', 'taxonomy_term_title', 'a:1:{i:0;i:2;}', '', 'a:0:{}', 0, '', '', 0, 'core/modules/taxonomy/taxonomy.pages.inc'),
('taxonomy/term/%/view', 'a:1:{i:2;s:18:"taxonomy_term_load";}', '', 'user_access', 'a:1:{i:0;s:14:"access content";}', 'taxonomy_term_page', 'a:1:{i:0;i:2;}', '', 13, 4, 1, 'taxonomy/term/%', 'taxonomy/term/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', 0, 'core/modules/taxonomy/taxonomy.pages.inc'),
('token-browser/token/%', 'a:1:{i:2;N;}', '', 'system_token_browser_access', 'a:0:{}', 'system_token_browser', 'a:1:{i:0;i:2;}', 'system_token_browser_output', 6, 3, 0, '', 'token-browser/token/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.pages.inc'),
('token/tree', '', '', '1', 'a:0:{}', 'system_token_output', 'a:0:{}', '', 3, 2, 0, '', 'token/tree', '', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, '', '', 0, 'core/modules/system/system.pages.inc'),
('user', '', '', '1', 'a:0:{}', 'user_page', 'a:0:{}', '', 1, 1, 0, '', 'user', 'User account', 'user_menu_title', '', '', 'a:0:{}', 6, '', '', -10, 'core/modules/user/user.pages.inc'),
('user/%', 'a:1:{i:1;s:9:"user_load";}', '', 'user_view_access', 'a:1:{i:0;i:1;}', 'user_view_page', 'a:1:{i:0;i:1;}', '', 2, 2, 0, '', 'user/%', 'My account', 'user_page_title', 'a:1:{i:0;i:1;}', '', 'a:0:{}', 6, '', '', 0, ''),
('user/%/cancel', 'a:1:{i:1;s:9:"user_load";}', '', 'user_cancel_access', 'a:1:{i:0;i:1;}', 'backdrop_get_form', 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}', '', 5, 3, 0, '', 'user/%/cancel', 'Cancel account', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/user/user.pages.inc'),
('user/%/cancel/confirm/%/%', 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}', '', 'user_cancel_access', 'a:1:{i:0;i:1;}', 'user_cancel_confirm', 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}', '', 44, 6, 0, '', 'user/%/cancel/confirm/%/%', 'Confirm account cancellation', 't', '', '', 'a:0:{}', 6, '', '', 0, 'core/modules/user/user.pages.inc'),
('user/%/edit', 'a:1:{i:1;s:9:"user_load";}', '', 'user_edit_access', 'a:1:{i:0;i:1;}', 'backdrop_get_form', 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}', '', 5, 3, 1, 'user/%', 'user/%', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/user/user.pages.inc'),
('user/%/view', 'a:1:{i:1;s:9:"user_load";}', '', 'user_view_access', 'a:1:{i:0;i:1;}', 'user_view_page', 'a:1:{i:0;i:1;}', '', 5, 3, 1, 'user/%', 'user/%', 'View', 't', '', '', 'a:0:{}', 140, '', '', -10, ''),
('user/autocomplete', '', '', 'user_access', 'a:1:{i:0;s:20:"access user profiles";}', 'user_autocomplete', 'a:0:{}', 'backdrop_json_deliver', 3, 2, 0, '', 'user/autocomplete', 'User autocomplete', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/user/user.pages.inc'),
('user/login', '', '', 'user_is_anonymous', 'a:0:{}', 'user_login_page', 'a:0:{}', 'backdrop_deliver_html_page', 3, 2, 1, 'user', 'user', 'Log in', 't', '', '', 'a:0:{}', 140, '', '', 0, ''),
('user/logout', '', '', 'user_is_logged_in', 'a:0:{}', 'user_logout', 'a:0:{}', '', 3, 2, 0, '', 'user/logout', 'Log out', 't', '', '', 'a:0:{}', 6, '', '', 10, 'core/modules/user/user.pages.inc'),
('user/password', '', '', '1', 'a:0:{}', 'user_pass_page', 'a:0:{}', 'backdrop_deliver_html_page', 3, 2, 1, 'user', 'user', 'Reset password', 't', '', '', 'a:0:{}', 132, '', '', 0, 'core/modules/user/user.pages.inc'),
('user/register', '', '', 'user_register_access', 'a:0:{}', 'user_register_page', 'a:0:{}', '', 3, 2, 1, 'user', 'user', 'Create new account', 't', '', '', 'a:0:{}', 132, '', '', 0, ''),
('user/reset/%/%/%', 'a:3:{i:2;N;i:3;N;i:4;N;}', '', '1', 'a:0:{}', 'user_pass_reset', 'a:3:{i:0;i:2;i:1;i:3;i:2;i:4;}', '', 24, 5, 0, '', 'user/reset/%/%/%', 'Reset password', 't', '', '', 'a:0:{}', 0, '', '', 0, 'core/modules/user/user.pages.inc'),
('views/ajax', '', '', '1', 'a:0:{}', 'views_ajax', 'a:0:{}', 'ajax_deliver', 3, 2, 0, '', 'views/ajax', 'Views', 't', '', 'ajax_base_page_theme', 'a:0:{}', 0, 'Ajax callback for view loading.', '', 0, 'core/modules/views/includes/ajax.inc');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node`
--

CREATE TABLE `[[dbprefix]]node` (
  `nid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a node.',
  `vid` int(10) unsigned DEFAULT NULL COMMENT 'The current [[dbprefix]]node_revision.vid version identifier.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The type of this node.',
  `langcode` varchar(12) NOT NULL DEFAULT '' COMMENT 'The language code of this node.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this node, always treated as non-markup plain text.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid that owns this node; initially, this is the user that created it.',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the node is published (visible to non-administrators).',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was most recently saved.',
  `scheduled` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating content is scheduled to be published in the future.',
  `comment` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this node: 0 = no, 1 = closed (read only), 2 = open (read/write).',
  `promote` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node should be displayed on the home page.',
  `sticky` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node should be displayed at the top of lists in which it appears.',
  `tnid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The translation set id for this node, which equals the node id of the source post in each set.',
  `translate` int(11) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this translation page needs to be updated.',
  `comment_close_override` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Override the automatic comment closer. (0 = Do not override, 1 = Override)',
  PRIMARY KEY (`nid`),
  UNIQUE KEY `vid` (`vid`),
  KEY `node_changed` (`changed`),
  KEY `node_created` (`created`),
  KEY `node_frontpage` (`promote`,`status`,`sticky`,`created`),
  KEY `node_status_type` (`status`,`type`,`nid`),
  KEY `node_title_type` (`title`,`type`(4)),
  KEY `node_type` (`type`(4)),
  KEY `uid` (`uid`),
  KEY `tnid` (`tnid`),
  KEY `translate` (`translate`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='The base table for nodes.' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]node`
--

INSERT INTO `[[dbprefix]]node` VALUES
(1, 1, 'post', 'und', 'Your first post!', 1, 1, [[timestamp]], [[timestamp]], 0, 0, 1, 0, 0, 0, 0),
(2, 2, 'page', 'und', 'About', 1, 1, [[timestamp]], [[timestamp]], 0, 0, 0, 0, 0, 0, 0),
(3, 3, 'card', 'und', 'The Home page layout', 1, 1, [[timestamp]], [[timestamp]], 0, 0, 1, 0, 0, 0, 0),
(4, 4, 'card', 'und', 'What is a Card?', 1, 1, [[timestamp]], [[timestamp]], 0, 0, 1, 0, 0, 0, 0),
(5, 5, 'card', 'und', 'Organize your content', 1, 1, [[timestamp]], [[timestamp]], 0, 0, 1, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_access`
--

CREATE TABLE `[[dbprefix]]node_access` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node.nid this record affects.',
  `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The grant ID a user must possess in the specified realm to gain this row’s privileges on the node.',
  `realm` varchar(255) NOT NULL DEFAULT '' COMMENT 'The realm in which the user must possess the grant ID. Each node access node can define one or more realms.',
  `grant_view` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can view this node.',
  `grant_update` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can edit this node.',
  `grant_delete` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can delete this node.',
  PRIMARY KEY (`nid`,`gid`,`realm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Identifies which realm/grant pairs a user must possess in…';

--
-- Dumping data for table `[[dbprefix]]node_access`
--

INSERT INTO `[[dbprefix]]node_access` VALUES
(0, 0, 'all', 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_comment_statistics`
--

CREATE TABLE `[[dbprefix]]node_comment_statistics` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node.nid for which the statistics are compiled.',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]comment.cid of the last comment.',
  `last_comment_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from [[dbprefix]]comment.changed.',
  `last_comment_name` varchar(60) DEFAULT NULL COMMENT 'The name of the latest author to post a comment on this node, from [[dbprefix]]comment.name.',
  `last_comment_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The user ID of the latest author to post a comment on this node, from [[dbprefix]]comment.uid.',
  `comment_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this node.',
  PRIMARY KEY (`nid`),
  KEY `node_comment_timestamp` (`last_comment_timestamp`),
  KEY `comment_count` (`comment_count`),
  KEY `last_comment_uid` (`last_comment_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Maintains statistics of node and comments posts to show …';

--
-- Dumping data for table `[[dbprefix]]node_comment_statistics`
--

INSERT INTO `[[dbprefix]]node_comment_statistics` VALUES
(1, 0, [[timestamp]], NULL, 1, 0),
(2, 0, [[timestamp]], NULL, 1, 0),
(3, 0, [[timestamp]], NULL, 1, 0),
(4, 0, [[timestamp]], NULL, 1, 0),
(5, 0, [[timestamp]], NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_revision`
--

CREATE TABLE `[[dbprefix]]node_revision` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node this version belongs to.',
  `vid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this version.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid that created this version.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this version.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when this version was created.',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the node (at the time of this revision) is published (visible to non-administrators).',
  `comment` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this node (at the time of this revision): 0 = no, 1 = closed (read only), 2 = open (read/write).',
  `promote` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node (at the time of this revision) should be displayed on the home page.',
  `sticky` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node (at the time of this revision) should be displayed at the top of lists in which it appears.',
  PRIMARY KEY (`vid`),
  KEY `nid` (`nid`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores information about each saved version of a [[dbprefix]]node.' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]node_revision`
--

INSERT INTO `[[dbprefix]]node_revision` VALUES
(1, 1, 0, 'Your first post!', '', 0, 1, 0, 1, 0),
(2, 2, 0, 'About', '', 0, 1, 0, 0, 0),
(3, 3, 0, 'The Home page layout', '', 0, 1, 0, 1, 0),
(4, 4, 0, 'What is a Card?', '', 0, 1, 0, 1, 0),
(5, 5, 0, 'Organize your content', '', 0, 1, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue`
--

CREATE TABLE `[[dbprefix]]queue` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique item ID.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The queue name.',
  `data` longblob COMMENT 'The arbitrary data for the item.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the claim lease expires on the item.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the item was created.',
  PRIMARY KEY (`item_id`),
  KEY `name_created` (`name`,`created`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores items in queues.' AUTO_INCREMENT=39 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]redirect`
--

CREATE TABLE `[[dbprefix]]redirect` (
  `rid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique redirect ID.',
  `hash` varchar(64) NOT NULL COMMENT 'A unique hash based on source, source_options, and language.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'The redirect type; if value is ’redirect’ it is a normal redirect handled by the module.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid of the user who created the redirect.',
  `source` varchar(255) NOT NULL COMMENT 'The source path from which to redirect.',
  `source_options` text NOT NULL COMMENT 'A serialized array of source options.',
  `redirect` varchar(255) NOT NULL COMMENT 'The destination path to which the user will be redirected.',
  `redirect_options` text NOT NULL COMMENT 'A serialized array of redirect options.',
  `langcode` varchar(12) NOT NULL DEFAULT 'und' COMMENT 'The language this redirect is for; if blank, the alias will be used for unknown languages.',
  `status_code` smallint(6) NOT NULL COMMENT 'The HTTP status code to use for the redirect.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times the redirect has been used.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The timestamp of when the redirect was last accessed.',
  PRIMARY KEY (`rid`),
  UNIQUE KEY `hash` (`hash`),
  KEY `expires` (`type`,`access`),
  KEY `source_langcode` (`source`,`langcode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores information on redirects.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]redirect`
--

INSERT INTO `[[dbprefix]]redirect` VALUES
(1, 'GtO11b5NavTifFpLAZ2EXm1OADKyqR-Hmu2OfNqeIeo', 'redirect', 0, 'accounts/placeholder-for-uid-1', 'a:0:{}', 'user/1', 'a:0:{}', 'und', 301, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_dataset`
--

CREATE TABLE `[[dbprefix]]search_dataset` (
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Search item ID, e.g. node ID for nodes.',
  `type` varchar(16) NOT NULL COMMENT 'Type of item, e.g. node.',
  `data` longtext NOT NULL COMMENT 'List of space-separated words from the item.',
  `reindex` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Set to force node reindexing.',
  PRIMARY KEY (`sid`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores items that will be searched.';

--
-- Dumping data for table `[[dbprefix]]search_dataset`
--

INSERT INTO `[[dbprefix]]search_dataset` VALUES
(1, 'node', ' your first post  this is your first post you may edit or delete it  ', 0),
(2, 'node', ' about this is a page with static content you may edit or delete it  ', 0),
(3, 'node', ' the home page layout use the home page layout to specifically customize this page these cards only appear on this layout learn more about the home page ', 0),
(4, 'node', ' what is a card  a card can only be seen as part of another page place them individually as existing content blocks or grouped as in a view learn more about cards ', 0),
(5, 'node', ' organize your content backdrop cms includes three predefined types of content pages posts and cards custom content types can also be added learn more about content types ', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_index`
--

CREATE TABLE `[[dbprefix]]search_index` (
  `word` varchar(50) NOT NULL DEFAULT '' COMMENT 'The [[dbprefix]]search_total.word that is associated with the search item.',
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]search_dataset.sid of the searchable item to which the word belongs.',
  `type` varchar(16) NOT NULL COMMENT 'The [[dbprefix]]search_dataset.type of the searchable item to which the word belongs.',
  `score` float DEFAULT NULL COMMENT 'The numeric score of the word, higher being more important.',
  PRIMARY KEY (`word`,`sid`,`type`),
  KEY `sid_type` (`sid`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores the search index, associating words, items and…';

--
-- Dumping data for table `[[dbprefix]]search_index`
--

INSERT INTO `[[dbprefix]]search_index` VALUES
('about', 2, 'node', 26),
('about', 3, 'node', 11),
('about', 4, 'node', 11),
('about', 5, 'node', 11),
('added', 5, 'node', 1),
('also', 5, 'node', 1),
('and', 5, 'node', 1),
('another', 4, 'node', 1),
('appear', 3, 'node', 1),
('backdrop', 5, 'node', 1),
('blocks', 4, 'node', 1),
('can', 4, 'node', 1),
('can', 5, 'node', 1),
('card', 4, 'node', 27),
('cards', 3, 'node', 1),
('cards', 4, 'node', 11),
('cards', 5, 'node', 1),
('cms', 5, 'node', 1),
('content', 2, 'node', 1),
('content', 4, 'node', 1),
('content', 5, 'node', 39),
('custom', 5, 'node', 1),
('customize', 3, 'node', 1),
('delete', 1, 'node', 1),
('delete', 2, 'node', 1),
('edit', 1, 'node', 1),
('edit', 2, 'node', 1),
('existing', 4, 'node', 1),
('first', 1, 'node', 27),
('grouped', 4, 'node', 1),
('home', 3, 'node', 38),
('includes', 5, 'node', 1),
('individually', 4, 'node', 1),
('layout', 3, 'node', 28),
('learn', 3, 'node', 11),
('learn', 4, 'node', 11),
('learn', 5, 'node', 11),
('may', 1, 'node', 1),
('may', 2, 'node', 1),
('more', 3, 'node', 11),
('more', 4, 'node', 11),
('more', 5, 'node', 11),
('only', 3, 'node', 1),
('only', 4, 'node', 1),
('organize', 5, 'node', 26),
('page', 2, 'node', 1),
('page', 3, 'node', 39),
('page', 4, 'node', 1),
('pages', 5, 'node', 1),
('part', 4, 'node', 1),
('place', 4, 'node', 1),
('post', 1, 'node', 27),
('posts', 5, 'node', 1),
('predefined', 5, 'node', 1),
('seen', 4, 'node', 1),
('specifically', 3, 'node', 1),
('static', 2, 'node', 1),
('the', 3, 'node', 38),
('them', 4, 'node', 1),
('these', 3, 'node', 1),
('this', 1, 'node', 1),
('this', 2, 'node', 1),
('this', 3, 'node', 2),
('three', 5, 'node', 1),
('types', 5, 'node', 13),
('use', 3, 'node', 1),
('view', 4, 'node', 1),
('what', 4, 'node', 26),
('with', 2, 'node', 1),
('you', 1, 'node', 1),
('you', 2, 'node', 1),
('your', 1, 'node', 27),
('your', 5, 'node', 26);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_node_links`
--

CREATE TABLE `[[dbprefix]]search_node_links` (
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]search_dataset.sid of the searchable item containing the link to the node.',
  `type` varchar(16) NOT NULL DEFAULT '' COMMENT 'The [[dbprefix]]search_dataset.type of the searchable item containing the link to the node.',
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node.nid that this item links to.',
  `caption` longtext COMMENT 'The text used to link to the [[dbprefix]]node.nid.',
  PRIMARY KEY (`sid`,`type`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores items (like nodes) that link to other nodes, used to…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_total`
--

CREATE TABLE `[[dbprefix]]search_total` (
  `word` varchar(50) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique word in the search index.',
  `count` float DEFAULT NULL COMMENT 'The count of the word in the index using Zipf’s law to equalize the probability distribution.',
  PRIMARY KEY (`word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores search totals for words.';

--
-- Dumping data for table `[[dbprefix]]search_total`
--

INSERT INTO `[[dbprefix]]search_total` VALUES
('about', 0.00729924),
('added', 0.30103),
('also', 0.30103),
('and', 0.30103),
('another', 0.30103),
('appear', 0.30103),
('backdrop', 0.30103),
('blocks', 0.30103),
('can', 0.176091),
('card', 0.0157943),
('cards', 0.0321847),
('cms', 0.30103),
('content', 0.0104654),
('custom', 0.30103),
('customize', 0.30103),
('delete', 0.176091),
('edit', 0.176091),
('existing', 0.30103),
('first', 0.0157943),
('grouped', 0.30103),
('home', 0.011281),
('includes', 0.30103),
('individually', 0.30103),
('layout', 0.01524),
('learn', 0.012965),
('may', 0.176091),
('more', 0.012965),
('only', 0.176091),
('organize', 0.0163904),
('page', 0.0104654),
('pages', 0.30103),
('part', 0.30103),
('place', 0.30103),
('post', 0.0157943),
('posts', 0.30103),
('predefined', 0.30103),
('seen', 0.30103),
('specifically', 0.30103),
('static', 0.30103),
('the', 0.011281),
('them', 0.30103),
('these', 0.30103),
('this', 0.09691),
('three', 0.30103),
('types', 0.0321847),
('use', 0.30103),
('view', 0.30103),
('what', 0.0163904),
('with', 0.30103),
('you', 0.176091),
('your', 0.00811789);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]semaphore`
--

CREATE TABLE `[[dbprefix]]semaphore` (
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique name.',
  `value` varchar(255) NOT NULL DEFAULT '' COMMENT 'A value for the semaphore.',
  `expire` double NOT NULL COMMENT 'A Unix timestamp with microseconds indicating when the semaphore should expire.',
  PRIMARY KEY (`name`),
  KEY `value` (`value`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Table for holding semaphores, locks, flags, etc. that…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sequences`
--

CREATE TABLE `[[dbprefix]]sequences` (
  `value` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The value of the sequence.',
  PRIMARY KEY (`value`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores IDs.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]sequences`
--

INSERT INTO `[[dbprefix]]sequences` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `uid` int(10) unsigned NOT NULL COMMENT 'The [[dbprefix]]users.uid corresponding to a session, or 0 for anonymous user.',
  `sid` varchar(128) NOT NULL COMMENT 'A session ID. The value is generated by Backdrop’s session handlers.',
  `ssid` varchar(128) NOT NULL DEFAULT '' COMMENT 'Secure session ID. The value is generated by Backdrop’s session handlers.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The IP address that last used this session ID (sid).',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when this session last requested a page. Old records are purged by PHP automatically.',
  `session` longblob COMMENT 'The serialized contents of $_SESSION, an array of name/value pairs that persists across page requests by this session ID. Backdrop loads $_SESSION from here at the start of each request and saves it at the end.',
  PRIMARY KEY (`sid`,`ssid`),
  KEY `timestamp` (`timestamp`),
  KEY `uid` (`uid`),
  KEY `ssid` (`ssid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Backdrop’s session handlers read and write into the…';

--
-- Dumping data for table `[[dbprefix]]sessions`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]state`
--

CREATE TABLE `[[dbprefix]]state` (
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT 'The name of the state.',
  `value` longblob NOT NULL COMMENT 'The value of the state.',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores environment-specific state values.';

--
-- Dumping data for table `[[dbprefix]]state`
--

INSERT INTO `[[dbprefix]]state` VALUES
('cron_key', '[[ser_cron_key]]'),
('cron_last', 'i:[[timestamp]];'),
('css_cache_files', 'a:10:{s:64:"ae2fb0610941edf95235a811385bb187740dbfdd5dbd939dbc904e64db3a5248";s:64:"public://css/css_mXMBoDN6ZcLhX0AmHKMEPdSZXm6MxjvEukCI2EAY24M.css";s:64:"a3a719433f648d9b6e484b229e75870bcce40e0999e42ad58d31735480164d2d";s:64:"public://css/css_IGkxQd7Ehp8U0Mj5VUMK-_Lb6L_phooDdOpYEpDAXGU.css";s:64:"2d44b4adcca6193e27a64fc0ea081b9b3590ad708a1a582160faa4c8b03b354c";s:64:"public://css/css_73Ns0T31oNMASWPIBzPzldUmj1XMIV1EmLh5tkNH4iY.css";s:64:"5a6e39d782f5716ca64076c2237ab754c3d687ff628b8e061cfe9caea74e53d5";s:64:"public://css/css_iEY9roPqswrO1fjxG-72NU5A-jZSpcnvzwXV0DQO3P0.css";s:64:"4b0951a909643597da4818e659e250d577ead54e54f1fef8afa54788f563657b";s:64:"public://css/css_5xRVjAzi9enY9F6I0tdRY2Go4bcvSBAHYEN2MrMmdGo.css";s:64:"541bae1b8827edf280a107dacb42e696335b0efd49dbccee8eb9de1036c6e8bc";s:64:"public://css/css_zqSb9CDhZD129KLKZprUMXWXgRtzeirj-kLRa6cS3Is.css";s:64:"646a3b199a8a118554c3375d73305afa28b542570feef915681c155cca280a90";s:64:"public://css/css_IDIbMqCWflBhfHfgPyDODsF0chpBDOQwXbd3PP7FJ7g.css";s:64:"4200e6710cfb67eafc4c994914345229943c95e865fb7628ecde941f31a894b2";s:64:"public://css/css_KdLncZZ60zVXTRHdVvCpWhNhgnqjPC4f75swkLplttQ.css";s:64:"d8f19a75464b33fbcf4536cdfc9e2287b256a7b4f1b53e38ab1802e8f6aa1d84";s:64:"public://css/css__C0PHkPE-7nuufkguMCdD2IygBQ2xH45sMQTGMrbUnQ.css";s:64:"6d2edfaa6db97a119a57274c50946523feaca7dbf1b9a42bab3d3a69db91c6e3";s:64:"public://css/css_XiR7G_POCsnr8YgLCoNKdrajweR66gXAXBGjZJf035k.css";}'),
('css_js_query_string', '[[css_js_query_string]]'),
('dashboard_news_timestamp', 'i:[[timestamp]];'),
('database_utf8mb4_active', 'b:1;'),
('install_task', 's:4:"done";'),
('install_time', 'i:[[timestamp]];'),
('js_cache_files', 'a:5:{s:64:"2d6f587b2e8eece6d1be7e595cb024b842b531236b9803e1ac1105dc4300e0d3";s:61:"public://js/js_qcuQasNlfIq7236oVf0NRWYeUUrasWXW4qABbJzWJEo.js";s:64:"5de7953e0a3ba1efa49a1c1741f1f3dab08bf85faf09c436206e96cab80d2316";s:61:"public://js/js_M1LHD5eT8ocYiyB0BooQmiqnECMpWy0u-XVOv3X0O20.js";s:64:"ca41f45763b3c93df723b2c55e8c494e542a9f7bdf1c4df39f3e75c6a86caf5b";s:61:"public://js/js__yqb2-FZMVY8OETvRiyxDxXRAD2rzUyJO6mzWZauLl8.js";s:64:"4d22464abdf0aefec3d8fac8ea1419e781aa86554d98ecaef50d878e56c56335";s:61:"public://js/js_vE9VUITM6K0oBAs63BavEJf0pVja61l1tRlrDYz3Du4.js";s:64:"eda515f1f29e4920dd6438b9c532428828339e7a3458547c5ad372336ba6c142";s:61:"public://js/js__m_E87HVAkZX2YE7oOWSgK-QMfK-PtY209iqcX2wsRE.js";}'),
('menus_containing_expanded_items', 'a:0:{}'),
('menu_masks', 'a:38:{i:0;i:501;i:1;i:494;i:2;i:493;i:3;i:492;i:4;i:250;i:5;i:247;i:6;i:246;i:7;i:245;i:8;i:244;i:9;i:126;i:10;i:125;i:11;i:124;i:12;i:123;i:13;i:122;i:14;i:117;i:15;i:63;i:16;i:62;i:17;i:61;i:18;i:60;i:19;i:59;i:20;i:58;i:21;i:56;i:22;i:44;i:23;i:31;i:24;i:30;i:25;i:29;i:26;i:28;i:27;i:24;i:28;i:21;i:29;i:15;i:30;i:14;i:31;i:13;i:32;i:7;i:33;i:6;i:34;i:5;i:35;i:3;i:36;i:2;i:37;i:1;}'),
('node_cron_last', 'i:[[timestamp]];'),
('private_key', 's:43:"[[backdrop_private_key]]";'),
('redirect_cron_last', 'i:[[timestamp]];'),
('telemetry_cron_last', 'i:[[timestamp]];'),
('update_last_check', 'i:[[timestamp]];');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system`
--

CREATE TABLE `[[dbprefix]]system` (
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'The path of the primary file for this item, relative to the Backdrop root; e.g. modules/node/node.module.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the item; e.g. node.',
  `type` varchar(12) NOT NULL DEFAULT '' COMMENT 'The type of the item, either module, theme, or theme_engine.',
  `owner` varchar(255) NOT NULL DEFAULT '' COMMENT 'A theme’s ’parent’ . Can be either a theme or an engine.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether or not this item is enabled.',
  `bootstrap` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether this module is loaded during Backdrop’s early bootstrapping phase (e.g. even before the page cache is consulted).',
  `schema_version` smallint(6) NOT NULL DEFAULT '-1' COMMENT 'The module’s database schema version number. -1 if the module is not installed (its tables do not exist); 0 or the largest N of the module’s hook_update_N() function that has either been run or existed when the module was first installed.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The order in which this module’s hooks should be invoked relative to other modules. Equal-weighted modules are ordered by name.',
  `info` blob COMMENT 'A serialized array containing information from the module’s .info file; keys can include name, description, package, version, core, dependencies, and php.',
  PRIMARY KEY (`filename`),
  KEY `system_list` (`status`,`bootstrap`,`type`,`weight`,`name`),
  KEY `type_name` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='A list of all modules, themes, and theme engines that are…';

--
-- Dumping data for table `[[dbprefix]]system`
--

INSERT INTO `[[dbprefix]]system` VALUES
('core/modules/admin_bar/admin_bar.module', 'admin_bar', 'module', '', 1, 0, 0, 100, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:18:"Administration Bar";s:11:"description";s:84:"Provides a dropdown menu to most administrative tasks and other common destinations.";s:7:"package";s:14:"Administration";s:4:"tags";a:3:{i:0;s:5:"Menus";i:1;s:15:"Site Navigation";i:2;s:14:"User Interface";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:37:"admin/config/administration/admin-bar";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/block/block.module', 'block', 'module', '', 1, 0, 1004, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:22:"Reusable Custom Blocks";s:11:"description";s:59:"Allows custom blocks to be reused across different layouts.";s:7:"package";s:7:"Layouts";s:4:"tags";a:2:{i:0;s:6:"Blocks";i:1;s:17:"Site Architecture";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:21:"admin/structure/block";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/block/tests/block_test/block_test.module', 'block_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Block test";s:11:"description";s:21:"Provides test blocks.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/book/book.module', 'book', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:6:"System";s:4:"tags";a:3:{i:0;s:7:"Content";i:1;s:15:"Site Navigation";i:2;s:9:"Structure";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:4:"node";}s:9:"configure";s:27:"admin/content/book/settings";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/ckeditor/ckeditor.module', 'ckeditor', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:23:"CKEditor 4 (Deprecated)";s:11:"description";s:137:"WYSIWYG editing for rich text fields using CKEditor 4. This module is no longer supported and sites should use CKEditor 5 module instead.";s:7:"package";s:14:"User Interface";s:4:"tags";a:3:{i:0;s:7:"Filters";i:1;s:7:"Formats";i:2;s:12:"Text Editors";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:28:"admin/config/content/formats";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/ckeditor5/ckeditor5.module', 'ckeditor5', 'module', '', 1, 0, 1000, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:10:"CKEditor 5";s:11:"description";s:54:"WYSIWYG editing for rich text fields using CKEditor 5.";s:7:"package";s:14:"User Interface";s:4:"tags";a:3:{i:0;s:7:"Filters";i:1;s:7:"Formats";i:2;s:12:"Text Editors";}s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:12:"dependencies";a:1:{i:0;s:6:"filter";}s:9:"configure";s:28:"admin/config/content/formats";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/ckeditor5/tests/ckeditor5_upgrade_test/ckeditor5_upgrade_test.module', 'ckeditor5_upgrade_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:18:"CKEditor 5 Upgrade";s:11:"description";s:71:"Provides assisting code for testing a CKEditor 4 to CKEditor 5 upgrade.";s:7:"package";s:7:"Testing";s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:12:"dependencies";a:1:{i:0;s:9:"ckeditor5";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/color/color.module', 'color', 'module', '', 1, 0, 1000, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:10:"Appearance";s:4:"tags";a:1:{i:0;s:18:"Theme Enhancements";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/comment/comment.module', 'comment', 'module', '', 1, 0, 1008, 0, 'a:16:{s:4:"type";s:6:"module";s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:8:"Comments";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:3:{i:0;s:4:"node";i:1;s:4:"text";i:2;s:6:"entity";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"css/comment.css";s:36:"core/modules/comment/css/comment.css";}}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/config/config.module', 'config', 'module', '', 1, 0, 0, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:21:"Configuration Manager";s:11:"description";s:166:"Import, export, and synchronize your configuration changes between different installations of your site, such as in development, staging, and production environments.";s:7:"package";s:11:"Development";s:4:"tags";a:2:{i:0;s:17:"Site Architecture";i:1;s:6:"System";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:38:"admin/config/development/configuration";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/config/tests/config_test/config_test.module', 'config_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:18:"Configuration test";s:11:"description";s:48:"Provides sample configuration files for testing.";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/config/tests/config_test_hooks/config_test_hooks.module', 'config_test_hooks', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:24:"Configuration test hooks";s:11:"description";s:60:"Tests the hooks provided by Configuration management module.";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/contact/contact.module', 'contact', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:6:"System";s:4:"tags";a:2:{i:0;s:4:"Mail";i:1;s:7:"Utility";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:23:"admin/structure/contact";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/contextual/contextual.module', 'contextual', 'module', '', 1, 0, 1000, 11, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:16:"Contextual Links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:14:"User Interface";s:4:"tags";a:2:{i:0;s:14:"Administration";i:1;s:15:"Site Navigation";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/dashboard/dashboard.module', 'dashboard', 'module', '', 1, 0, 1000, 0, 'a:14:{s:4:"name";s:9:"Dashboard";s:11:"description";s:37:"Provides an administrative dashboard.";s:7:"package";s:9:"Dashboard";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:24:"admin/dashboard/settings";s:12:"dependencies";a:1:{i:0;s:6:"layout";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/date/date.module', 'date', 'module', '', 1, 0, 1003, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:4:"Date";s:11:"description";s:33:"Makes date/time fields available.";s:7:"package";s:6:"Fields";s:4:"tags";a:2:{i:0;s:5:"Dates";i:1;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"css/date.css";s:30:"core/modules/date/css/date.css";}}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/dblog/dblog.module', 'dblog', 'module', '', 1, 1, 1003, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:16:"Database Logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:11:"Development";s:4:"tags";a:1:{i:0;s:7:"Logging";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/email/email.module', 'email', 'module', '', 1, 0, 1000, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:5:"Email";s:11:"description";s:28:"Defines an email field type.";s:7:"package";s:6:"Fields";s:4:"tags";a:2:{i:0;s:4:"Mail";i:1;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/entity.module', 'entity', 'module', '', 1, 0, 0, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:6:"Entity";s:11:"description";s:47:"API for managing entities like nodes and users.";s:7:"package";s:6:"System";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/tests/entity_cache_test/entity_cache_test.module', 'entity_cache_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Entity cache test";s:11:"description";s:40:"Support module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:28:"entity_cache_test_dependency";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/tests/entity_cache_test_dependency/entity_cache_test_dependency.module', 'entity_cache_test_dependency', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:28:"Entity cache test dependency";s:11:"description";s:51:"Support dependency module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/tests/entity_caching_test/entity_caching_test.module', 'entity_caching_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:26:"Entity Caching test module";s:11:"description";s:51:"Provides entity types using to test entity caching.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/tests/entity_crud_hook_test/entity_crud_hook_test.module', 'entity_crud_hook_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:22:"Entity CRUD Hooks Test";s:11:"description";s:35:"Support module for CRUD hook tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/tests/entity_query_access_test/entity_query_access_test.module', 'entity_query_access_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:24:"Entity query access test";s:11:"description";s:49:"Support module for checking entity query results.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entity/tests/entity_test/entity_test.module', 'entity_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:23:"Entity CRUD test module";s:11:"description";s:46:"Provides entity types based upon the CRUD API.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entityreference/entityreference.module', 'entityreference', 'module', '', 0, 0, -1, 0, 'a:13:{s:4:"name";s:16:"Entity Reference";s:11:"description";s:108:"Defines a field type for referencing from other entities, such as content, users, taxonomy terms, and files.";s:7:"package";s:6:"Fields";s:8:"backdrop";s:3:"1.x";s:4:"type";s:6:"module";s:7:"version";s:6:"1.32.1";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:6:"entity";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/entityreference/tests/entityreference_views_test/entityreference_views_test.module', 'entityreference_views_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:27:"Entity Reference Views Test";s:11:"description";s:39:"Test module for Entity Reference Views.";s:7:"package";s:5:"Views";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:2:{i:0;s:5:"views";i:1;s:15:"entityreference";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/field.module', 'field', 'module', '', 1, 0, 1004, 0, 'a:16:{s:4:"type";s:6:"module";s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:6:"System";s:4:"tags";a:1:{i:0;s:6:"Fields";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:2:{i:0;s:17:"field_sql_storage";i:1;s:6:"entity";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:13:"css/field.css";s:32:"core/modules/field/css/field.css";}}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/modules/field_sql_storage/field_sql_storage.module', 'field_sql_storage', 'module', '', 1, 0, 0, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:17:"Field SQL Storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:6:"Fields";s:4:"tags";a:2:{i:0;s:7:"Content";i:1;s:6:"System";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:8:"required";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/modules/list/list.module', 'list', 'module', '', 1, 0, 0, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:6:"Fields";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/modules/list/tests/list_test.module', 'list_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:9:"List test";s:11:"description";s:41:"Support module for the List module tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/modules/number/number.module', 'number', 'module', '', 1, 0, 0, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:6:"Fields";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/modules/options/options.module', 'options', 'module', '', 1, 0, 0, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:6:"Fields";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/modules/text/text.module', 'text', 'module', '', 1, 0, 1000, 0, 'a:17:{s:4:"type";s:6:"module";s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:6:"Fields";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:8:"required";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:8:"disabled";b:1;s:11:"explanation";s:[[url_strlen]]:"Field type(s) in use - see <a href="[[relativeurl]]/admin/reports/fields">Field list</a>";}'),
('core/modules/field/tests/field_test/field_test.module', 'field_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:14:"Field API Test";s:11:"description";s:39:"Support module for the Field API tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field/tests/field_test_schema_alter/field_test_schema_alter.module', 'field_test_schema_alter', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:27:"Field API Schema Alter Test";s:11:"description";s:52:"Support module for the Field API schema alter tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field_ui/field_ui.module', 'field_ui', 'module', '', 1, 0, 0, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:6:"Fields";s:4:"tags";a:2:{i:0;s:14:"Administration";i:1;s:14:"User Interface";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/field_ui/tests/view_mode_test/view_mode_test.module', 'view_mode_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:17:"Display mode test";s:11:"description";s:15:"Testing module.";s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/file/file.module', 'file', 'module', '', 1, 0, 1011, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:6:"Fields";s:4:"tags";a:3:{i:0;s:7:"Content";i:1;s:15:"File Management";i:2;s:5:"Media";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:12:"dependencies";a:1:{i:0;s:5:"field";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/file/tests/file_module_test/file_module_test.module', 'file_module_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:9:"File test";s:11:"description";s:53:"Provides hooks for testing File module functionality.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/filter/filter.module', 'filter', 'module', '', 1, 0, 1004, 0, 'a:16:{s:4:"type";s:6:"module";s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:6:"System";s:4:"tags";a:3:{i:0;s:7:"Filters";i:1;s:7:"Formats";i:2;s:12:"Text Editors";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/filter/tests/filter_formtest.module', 'filter_formtest', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:16:"Filter form test";s:11:"description";s:44:"Helper module to test filter form validation";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/image/image.module', 'image', 'module', '', 1, 0, 1008, 0, 'a:17:{s:4:"type";s:6:"module";s:4:"name";s:5:"Image";s:11:"description";s:55:"Provides image manipulation tools and image field type.";s:7:"package";s:6:"Fields";s:4:"tags";a:3:{i:0;s:6:"Images";i:1;s:5:"Media";i:2;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:9:"configure";s:31:"admin/config/media/image-styles";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:8:"disabled";b:1;s:11:"explanation";s:[[url_strlen]]:"Field type(s) in use - see <a href="[[relativeurl]]/admin/reports/fields">Field list</a>";}'),
('core/modules/image/tests/image_module_test/image_module_test.module', 'image_module_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Image test";s:11:"description";s:69:"Provides hook implementations for testing Image module functionality.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/installer/installer.module', 'installer', 'module', '', 1, 0, 1000, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:17:"Project Installer";s:11:"description";s:83:"Provides a user interface for installing and updating modules, themes, and layouts.";s:7:"version";s:6:"1.32.1";s:7:"package";s:11:"Development";s:4:"tags";a:2:{i:0;s:14:"User interface";i:1;s:6:"System";}s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:6:"update";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/installer/tests/aaa_installer_test/aaa_installer_test.module', 'aaa_installer_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:18:"AAA Installer test";s:11:"description";s:44:"Support module for installer module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/installer/tests/bbb_installer_test/bbb_installer_test.module', 'bbb_installer_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:18:"BBB Installer test";s:11:"description";s:44:"Support module for installer module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/installer/tests/ccc_installer_test/ccc_installer_test.module', 'ccc_installer_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:18:"CCC Installer test";s:11:"description";s:44:"Support module for installer module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/installer/tests/installer_test/installer_test.module', 'installer_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:30:"Installer Browser module tests";s:11:"description";s:53:"Support module for Installer Browser related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/language/language.module', 'language', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"name";s:8:"Language";s:11:"description";s:68:"Lets you configure a number of languages to be used on your website.";s:7:"package";s:11:"Translation";s:4:"tags";a:1:{i:0;s:8:"Language";}s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:30:"admin/config/regional/language";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/layout/layout.module', 'layout', 'module', '', 1, 0, 0, 60, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:6:"Layout";s:11:"description";s:44:"Provides a drag and drop page building tool.";s:7:"package";s:7:"Layouts";s:4:"tags";a:2:{i:0;s:6:"Blocks";i:1;s:17:"Site Architecture";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/layout/tests/layout_test/layout_test.module', 'layout_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Layout Test";s:11:"description";s:39:"Support module for Layout module tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/link/link.module', 'link', 'module', '', 1, 0, 1001, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:4:"Link";s:11:"description";s:32:"Defines simple link field types.";s:7:"package";s:6:"Fields";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/link/tests/modules/link_field_custom_form_test/link_field_custom_form_test.module', 'link_field_custom_form_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:21:"Link Custom Form Test";s:11:"description";s:51:"Helper module to test custom forms and link fields.";s:7:"package";s:7:"Testing";s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:12:"dependencies";a:1:{i:0;s:4:"link";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/locale/locale.module', 'locale', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:6:"Locale";s:11:"description";s:107:"Provides language negotiation functionality and user interface translation to languages other than English.";s:7:"package";s:11:"Translation";s:4:"tags";a:1:{i:0;s:8:"Language";}s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:8:"language";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/locale/tests/locale_test/locale_test.module', 'locale_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Locale Test";s:11:"description";s:42:"Support module for the locale layer tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/menu/menu.module', 'menu', 'module', '', 1, 0, 1006, 0, 'a:15:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:6:"System";s:4:"tags";a:3:{i:0;s:5:"Menus";i:1;s:15:"Site Navigation";i:2;s:9:"Structure";}s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:20:"admin/structure/menu";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/node/node.module', 'node', 'module', '', 1, 0, 1023, 0, 'a:16:{s:4:"type";s:6:"module";s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:6:"System";s:4:"tags";a:1:{i:0;s:7:"Content";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:9:"configure";s:21:"admin/structure/types";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/node/tests/node_access_test/node_access_test.module', 'node_access_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:24:"Node module access tests";s:11:"description";s:43:"Support module for node permission testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/node/tests/node_layout_preview_revision_test/node_layout_preview_revision_test.module', 'node_layout_preview_revision_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:33:"Node Layout Preview/Revision Test";s:11:"description";s:79:"Support module for node module tests of node preview and revision page layouts.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/node/tests/node_test/node_test.module', 'node_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Node module tests";s:11:"description";s:40:"Support module for node related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/node/tests/node_test_exception/node_test_exception.module', 'node_test_exception', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:27:"Node module exception tests";s:11:"description";s:50:"Support module for node related exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/path/path.module', 'path', 'module', '', 1, 0, 1001, 0, 'a:15:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:6:"System";s:4:"tags";a:1:{i:0;s:12:"URL Handling";}s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:22:"admin/config/urls/path";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/redirect/redirect.module', 'redirect', 'module', '', 1, 1, 1004, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:8:"Redirect";s:11:"description";s:51:"Allows users to redirect from old URLs to new URLs.";s:7:"package";s:6:"System";s:4:"tags";a:1:{i:0;s:12:"URL handling";}s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:9:"configure";s:35:"admin/config/urls/redirect/settings";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/search/search.module', 'search', 'module', '', 1, 0, 1004, 0, 'a:16:{s:4:"type";s:6:"module";s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:6:"Search";s:4:"tags";a:1:{i:0;s:7:"Utility";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:16:"search.theme.css";s:36:"core/modules/search/search.theme.css";}}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/search/tests/search_embedded_form/search_embedded_form.module', 'search_embedded_form', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:20:"Search embedded form";s:11:"description";s:59:"Support module for search module testing of embedded forms.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/search/tests/search_extra_type/search_extra_type.module', 'search_extra_type', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:16:"Test search type";s:11:"description";s:41:"Support module for search module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/simpletest.module', 'simpletest', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:7:"Testing";s:11:"description";s:53:"Provides a framework for unit and functional testing.";s:7:"package";s:11:"Development";s:4:"tags";a:1:{i:0;s:7:"Testing";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:41:"admin/config/development/testing/settings";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/actions_loop_test.module', 'actions_loop_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Actions loop test";s:11:"description";s:39:"Support module for action loop testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/ajax_forms_test.module', 'ajax_forms_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:26:"AJAX form test mock module";s:11:"description";s:25:"Test for AJAX form calls.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/ajax_test.module', 'ajax_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:9:"AJAX Test";s:11:"description";s:40:"Support module for AJAX framework tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/backdrop_system_listing_compatible_test/backdrop_system_listing_compatible_test.module', 'backdrop_system_listing_compatible_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:39:"Backdrop system listing compatible test";s:11:"description";s:64:"Support module for testing the backdrop_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/backdrop_system_listing_incompatible_test/backdrop_system_listing_incompatible_test.module', 'backdrop_system_listing_incompatible_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:41:"Backdrop system listing incompatible test";s:11:"description";s:64:"Support module for testing the backdrop_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/backup_test/backup_test.module', 'backup_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Backup Test";s:11:"description";s:32:"Support module for Backup tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/batch_test.module', 'batch_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:14:"Batch API test";s:11:"description";s:35:"Support module for Batch API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/boot_test_1.module', 'boot_test_1', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:39:"A support module for hook_boot testing.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/boot_test_2.module', 'boot_test_2', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:44:"A support module for hook_boot hook testing.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/common_test.module', 'common_test', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"name";s:11:"Common Test";s:11:"description";s:32:"Support module for Common tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:15:"common_test.css";s:45:"core/modules/simpletest/tests/common_test.css";}s:5:"print";a:1:{s:21:"common_test.print.css";s:51:"core/modules/simpletest/tests/common_test.print.css";}}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/common_test_cron_helper.module', 'common_test_cron_helper', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:23:"Common Test Cron Helper";s:11:"description";s:56:"Helper module for CronRunTestCase::testCronExceptions().";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/config_obj_test/config_obj_test.module', 'config_obj_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Config Test";s:11:"description";s:39:"Support module for Config object tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/database_test.module', 'database_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:13:"Database Test";s:11:"description";s:40:"Support module for Database layer tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/dependency_test1.module', 'dependency_test1', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Dependency test 1";s:11:"description";s:38:"Test module for checking dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/dependency_test2.module', 'dependency_test2', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Dependency test 2";s:11:"description";s:38:"Test module for checking dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/dependency_test3.module', 'dependency_test3', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Dependency test 3";s:11:"description";s:38:"Test module for checking dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/error_test.module', 'error_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Error test";s:11:"description";s:47:"Support module for error and exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/file_test.module', 'file_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:9:"File test";s:11:"description";s:39:"Support module for file handling tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/filter_test.module', 'filter_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:18:"Filter test module";s:11:"description";s:33:"Tests filter hooks and functions.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/form_test.module', 'form_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:12:"FormAPI Test";s:11:"description";s:34:"Support module for Form API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/icon_test/icon_test.module', 'icon_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:13:"Icon API test";s:11:"description";s:36:"Support module for Icon API testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}');
INSERT INTO `[[dbprefix]]system` VALUES
('core/modules/simpletest/tests/image_test.module', 'image_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Image test";s:11:"description";s:39:"Support module for image toolkit tests.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/menu_test.module', 'menu_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"Hook menu tests";s:11:"description";s:37:"Support module for menu hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/module_test.module', 'module_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Module test";s:11:"description";s:41:"Support module for module system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/path_test.module', 'path_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"Hook path tests";s:11:"description";s:37:"Support module for path hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/requirements1_test.module', 'requirements1_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:19:"Requirements 1 Test";s:11:"description";s:80:"Tests that a module is not installed when it fails hook_requirements(''install'').";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/requirements2_test.module', 'requirements2_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:19:"Requirements 2 Test";s:11:"description";s:98:"Tests that a module is not installed when the one it depends on fails hook_requirements(''install).";s:12:"dependencies";a:2:{i:0;s:18:"requirements1_test";i:1;s:7:"comment";}s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/session_test.module', 'session_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:12:"Session test";s:11:"description";s:40:"Support module for session data testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_dependencies_test.module', 'system_dependencies_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:22:"System dependency test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:19:"_missing_dependency";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module', 'system_incompatible_core_version_dependencies_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:50:"System incompatible core version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:37:"system_incompatible_core_version_test";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_incompatible_core_version_test.module', 'system_incompatible_core_version_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:37:"System incompatible core version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"0.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module', 'system_incompatible_module_version_dependencies_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:52:"System incompatible module version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:46:"system_incompatible_module_version_test (>2.0)";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_incompatible_module_version_test.module', 'system_incompatible_module_version_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:39:"System incompatible module version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_project_namespace_test.module', 'system_project_namespace_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:29:"System project namespace test";s:11:"description";s:58:"Support module for testing project namespace dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:15:"backdrop:filter";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/system_test.module', 'system_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"System test";s:11:"description";s:34:"Support module for system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/taxonomy_test.module', 'taxonomy_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:20:"Taxonomy test module";s:11:"description";s:45:""Tests functions and hooks not used in core".";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:8:"taxonomy";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/theme_test.module', 'theme_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Theme test";s:11:"description";s:40:"Support module for theme system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/token_test.module', 'token_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Token Test";s:11:"description";s:39:"Testing module for token functionality.";s:7:"package";s:7:"Testing";s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/update_d7_test_1.module', 'update_d7_test_1', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:14:"Update D7 test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/update_d7_test_2.module', 'update_d7_test_2', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:14:"Update D7 test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/update_script_test.module', 'update_script_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:18:"Update script test";s:11:"description";s:41:"Support module for update script testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/update_test_1.module', 'update_test_1', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/update_test_2.module', 'update_test_2', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/update_test_3.module', 'update_test_3', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/simpletest/tests/url_alter_test.module', 'url_alter_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"Url_alter tests";s:11:"description";s:45:"A support modules for url_alter hook testing.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/syslog/syslog.module', 'syslog', 'module', '', 0, 0, -1, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:14:"System Logging";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:11:"Development";s:4:"tags";a:2:{i:0;s:7:"Logging";i:1;s:6:"System";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:32:"admin/config/development/logging";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/system/system.module', 'system', 'module', '', 1, 0, 1103, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:6:"System";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/system/tests/cron_queue_test/cron_queue_test.module', 'cron_queue_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"Cron Queue test";s:11:"description";s:41:"Support module for the cron queue runner.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/system/tests/deprecated_redirect_test/deprecated_redirect_test.module', 'deprecated_redirect_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:24:"Deprecated Redirect Test";s:11:"description";s:69:"Testing module to confirm deprecated paths can redirect to new paths.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/system/tests/system_cron_test/system_cron_test.module', 'system_cron_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:16:"System Cron Test";s:11:"description";s:45:"Support module for testing the system_cron().";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/taxonomy/taxonomy.module', 'taxonomy', 'module', '', 1, 0, 1010, 0, 'a:17:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:48:"Enables the organization of content by category.";s:7:"package";s:14:"Categorization";s:4:"tags";a:2:{i:0;s:8:"Taxonomy";i:1;s:9:"Structure";}s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:2:{i:0;s:7:"options";i:1;s:6:"entity";}s:9:"configure";s:24:"admin/structure/taxonomy";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:8:"disabled";b:1;s:11:"explanation";s:[[url_strlen]]:"Field type(s) in use - see <a href="[[relativeurl]]/admin/reports/fields">Field list</a>";}'),
('core/modules/taxonomy/tests/taxonomy_nodes_test/taxonomy_nodes_test.module', 'taxonomy_nodes_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:31:"Taxonomy module node list tests";s:4:"type";s:6:"module";s:11:"description";s:54:"Support module for taxonomy node list related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/taxonomy/tests/taxonomy_vocab_load_test/taxonomy_vocab_load_test.module', 'taxonomy_vocab_load_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:29:"Taxonomy vocabulary load test";s:4:"type";s:6:"module";s:11:"description";s:39:"Test for hook_taxonomy_vocabulary_load.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/telemetry/telemetry.module', 'telemetry', 'module', '', 1, 0, 0, 0, 'a:13:{s:4:"name";s:9:"Telemetry";s:11:"description";s:90:"Collects anonymous usage information to help improve Backdrop CMS and contributed modules.";s:7:"package";s:6:"System";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/translation/tests/translation_test/translation_test.module', 'translation_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:24:"Content Translation Test";s:11:"description";s:49:"Support module for the content translation tests.";s:8:"backdrop";s:3:"1.x";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/translation/translation.module', 'translation', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"type";s:6:"module";s:4:"name";s:19:"Content Translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:11:"Translation";s:4:"tags";a:1:{i:0;s:8:"Language";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/update/tests/aaa_update_test/aaa_update_test.module', 'aaa_update_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"AAA Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/update/tests/bbb_update_test/bbb_update_test.module', 'bbb_update_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"BBB Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/update/tests/ccc_update_test/ccc_update_test.module', 'ccc_update_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"CCC Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:4:"type";s:6:"module";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/update/tests/update_test/update_test.module', 'update_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:11:"Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/update/update.module', 'update', 'module', '', 1, 0, 1005, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:14:"Update Manager";s:11:"description";s:29:"Checks for available updates.";s:7:"package";s:11:"Development";s:4:"tags";a:2:{i:0;s:6:"System";i:1;s:7:"Utility";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:9:"configure";s:30:"admin/reports/updates/settings";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/user/tests/user_flood_test/user_flood_test.module', 'user_flood_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:31:"User module flood control tests";s:11:"description";s:46:"Support module for user flood control testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/user/tests/user_form_test/user_form_test.module', 'user_form_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:22:"User module form tests";s:11:"description";s:37:"Support module for user form testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/user/tests/user_session_test/user_session_test.module', 'user_session_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:25:"User module session tests";s:11:"description";s:40:"Support module for user session testing.";s:7:"package";s:7:"Testing";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/user/user.module', 'user', 'module', '', 1, 0, 1026, 0, 'a:17:{s:4:"type";s:6:"module";s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:6:"System";s:4:"tags";a:1:{i:0;s:18:"Account Management";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"css/user.css";s:30:"core/modules/user/css/user.css";}}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/views/tests/views_test/views_test.module', 'views_test', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:10:"Views Test";s:11:"description";s:22:"Test module for Views.";s:7:"package";s:5:"Views";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/views/tests/views_test_entity/views_test_entity.module', 'views_test_entity', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:17:"Views Test Entity";s:11:"description";s:32:"Test module for Views Bulk Form.";s:7:"package";s:5:"Views";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/views/tests/views_test_sort/views_test_sort.module', 'views_test_sort', 'module', '', 0, 0, -1, 0, 'a:14:{s:4:"name";s:15:"Views Test Sort";s:11:"description";s:30:"Test module for Views sorting.";s:7:"package";s:5:"Views";s:7:"version";s:6:"1.32.1";s:4:"type";s:6:"module";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/views/views.module', 'views', 'module', '', 1, 0, 1008, 10, 'a:16:{s:4:"type";s:6:"module";s:4:"name";s:5:"Views";s:11:"description";s:55:"Create customized lists and queries from your database.";s:7:"package";s:5:"Views";s:4:"tags";a:1:{i:0;s:17:"Site Architecture";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:13:"css/views.css";s:32:"core/modules/views/css/views.css";}}s:8:"required";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:12:"dependencies";a:0:{}s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/modules/views_ui/views_ui.module', 'views_ui', 'module', '', 1, 0, 1002, 0, 'a:15:{s:4:"type";s:6:"module";s:4:"name";s:8:"Views UI";s:11:"description";s:93:"Administrative interface to views. Without this module, you cannot create or configure views.";s:7:"package";s:5:"Views";s:4:"tags";a:2:{i:0;s:14:"Administration";i:1;s:14:"User Interface";}s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:9:"configure";s:21:"admin/structure/views";s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}'),
('core/profiles/standard/standard.profile', 'standard', 'module', '', 1, 0, 0, 1000, 'a:16:{s:4:"name";s:8:"Standard";s:11:"description";s:51:"Install with commonly used features pre-configured.";s:7:"version";s:6:"1.32.1";s:8:"backdrop";s:3:"1.x";s:4:"type";s:7:"profile";s:12:"dependencies";a:30:{i:0;s:4:"node";i:1;s:9:"admin_bar";i:2;s:5:"block";i:3;s:9:"ckeditor5";i:4;s:5:"color";i:5;s:7:"comment";i:6;s:6:"config";i:7;s:10:"contextual";i:8;s:4:"date";i:9;s:9:"telemetry";i:10;s:9:"dashboard";i:11;s:5:"email";i:12;s:5:"image";i:13;s:9:"installer";i:14;s:6:"layout";i:15;s:4:"link";i:16;s:4:"list";i:17;s:4:"menu";i:18;s:6:"number";i:19;s:7:"options";i:20;s:4:"path";i:21;s:8:"redirect";i:22;s:8:"taxonomy";i:23;s:5:"dblog";i:24;s:6:"search";i:25;s:8:"field_ui";i:26;s:4:"file";i:27;s:6:"update";i:28;s:5:"views";i:29;s:8:"views_ui";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:5:"mtime";i:1759802558;s:7:"package";s:5:"Other";s:3:"php";s:5:"7.1.0";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:6:"hidden";b:1;s:8:"required";b:1;s:17:"distribution_name";s:12:"Backdrop CMS";}'),
('core/themes/bartik/bartik.info', 'bartik', 'theme', 'core/themes/engines/phptemplate/phptemplate.engine', 0, 0, -1, 0, 'a:15:{s:4:"name";s:6:"Bartik";s:11:"description";s:23:"Legacy front-end theme.";s:7:"version";s:6:"1.32.1";s:4:"type";s:5:"theme";s:8:"backdrop";s:3:"1.x";s:11:"stylesheets";a:2:{s:3:"all";a:2:{s:13:"css/style.css";s:32:"core/themes/bartik/css/style.css";s:14:"css/colors.css";s:33:"core/themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:32:"core/themes/bartik/css/print.css";}}s:20:"ckeditor_stylesheets";a:1:{i:0;s:14:"css/editor.css";}s:8:"settings";a:2:{s:5:"color";b:1;s:14:"main_menu_tabs";s:7:"no-tabs";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:6:"engine";s:11:"phptemplate";s:10:"screenshot";s:33:"core/themes/bartik/screenshot.png";s:3:"php";s:5:"7.1.0";s:7:"scripts";a:0:{}s:5:"mtime";i:1759802558;}'),
('core/themes/basis/basis.info', 'basis', 'theme', 'core/themes/engines/phptemplate/phptemplate.engine', 1, 0, -1, 0, 'a:15:{s:4:"type";s:5:"theme";s:4:"name";s:5:"Basis";s:11:"description";s:80:"The default front-end theme for Backdrop CMS, which can make a great base theme.";s:8:"backdrop";s:3:"1.x";s:7:"version";s:6:"1.32.1";s:11:"stylesheets";a:2:{s:3:"all";a:26:{s:12:"css/base.css";s:30:"core/themes/basis/css/base.css";s:14:"css/layout.css";s:32:"core/themes/basis/css/layout.css";s:39:"css/component/small-text-components.css";s:57:"core/themes/basis/css/component/small-text-components.css";s:24:"css/component/header.css";s:42:"core/themes/basis/css/component/header.css";s:24:"css/component/footer.css";s:42:"core/themes/basis/css/component/footer.css";s:31:"css/component/menu-dropdown.css";s:49:"core/themes/basis/css/component/menu-dropdown.css";s:29:"css/component/menu-toggle.css";s:47:"core/themes/basis/css/component/menu-toggle.css";s:31:"css/component/backdrop-form.css";s:49:"core/themes/basis/css/component/backdrop-form.css";s:27:"css/component/tabledrag.css";s:45:"core/themes/basis/css/component/tabledrag.css";s:31:"css/component/vertical-tabs.css";s:49:"core/themes/basis/css/component/vertical-tabs.css";s:26:"css/component/fieldset.css";s:44:"core/themes/basis/css/component/fieldset.css";s:24:"css/component/dialog.css";s:42:"core/themes/basis/css/component/dialog.css";s:26:"css/component/progress.css";s:44:"core/themes/basis/css/component/progress.css";s:28:"css/component/admin-tabs.css";s:46:"core/themes/basis/css/component/admin-tabs.css";s:28:"css/component/breadcrumb.css";s:46:"core/themes/basis/css/component/breadcrumb.css";s:23:"css/component/pager.css";s:41:"core/themes/basis/css/component/pager.css";s:22:"css/component/hero.css";s:40:"core/themes/basis/css/component/hero.css";s:23:"css/component/cards.css";s:41:"core/themes/basis/css/component/cards.css";s:25:"css/component/teasers.css";s:43:"core/themes/basis/css/component/teasers.css";s:25:"css/component/comment.css";s:43:"core/themes/basis/css/component/comment.css";s:25:"css/component/caption.css";s:43:"core/themes/basis/css/component/caption.css";s:12:"css/skin.css";s:30:"core/themes/basis/css/skin.css";s:16:"system.theme.css";s:34:"core/themes/basis/system.theme.css";s:23:"menu-dropdown.theme.css";s:41:"core/themes/basis/menu-dropdown.theme.css";s:34:"menu-dropdown.theme.breakpoint.css";s:52:"core/themes/basis/menu-dropdown.theme.breakpoint.css";s:42:"menu-dropdown.theme.breakpoint-queries.css";s:60:"core/themes/basis/menu-dropdown.theme.breakpoint-queries.css";}s:5:"print";a:1:{s:13:"css/print.css";s:31:"core/themes/basis/css/print.css";}}s:20:"ckeditor_stylesheets";a:2:{i:0;s:12:"css/base.css";i:1;s:25:"css/component/caption.css";}s:7:"scripts";a:1:{s:12:"js/script.js";s:30:"core/themes/basis/js/script.js";}s:8:"settings";a:3:{s:5:"color";b:1;s:10:"css_update";s:7:"install";s:18:"css_update_version";s:0:"";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:6:"engine";s:11:"phptemplate";s:10:"screenshot";s:32:"core/themes/basis/screenshot.png";s:3:"php";s:5:"7.1.0";s:5:"mtime";i:1759802558;}'),
('core/themes/seven/seven.info', 'seven', 'theme', 'core/themes/engines/phptemplate/phptemplate.engine', 1, 0, -1, 0, 'a:14:{s:4:"name";s:5:"Seven";s:11:"description";s:50:"The default administration theme for Backdrop CMS.";s:7:"version";s:6:"1.32.1";s:4:"type";s:5:"theme";s:8:"backdrop";s:3:"1.x";s:11:"stylesheets";a:1:{s:6:"screen";a:3:{s:18:"css/seven.base.css";s:36:"core/themes/seven/css/seven.base.css";s:13:"css/style.css";s:31:"core/themes/seven/css/style.css";s:23:"css/responsive-tabs.css";s:41:"core/themes/seven/css/responsive-tabs.css";}}s:20:"ckeditor_stylesheets";a:1:{i:0;s:18:"css/seven.base.css";}s:7:"scripts";a:1:{s:12:"js/script.js";s:30:"core/themes/seven/js/script.js";}s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:6:"engine";s:11:"phptemplate";s:10:"screenshot";s:32:"core/themes/seven/screenshot.png";s:3:"php";s:5:"7.1.0";s:5:"mtime";i:1759802558;}'),
('core/themes/stark/stark.info', 'stark', 'theme', 'core/themes/engines/phptemplate/phptemplate.engine', 0, 0, -1, 0, 'a:14:{s:4:"name";s:5:"Stark";s:11:"description";s:216:"This theme demonstrates Backdrop CMS''s default HTML markup and CSS styles. To learn how to build your own theme and override Backdrop''s default code, see the <a href="http://drupal.org/theme-guide">Theming Guide</a>.";s:7:"version";s:6:"1.32.1";s:4:"type";s:5:"theme";s:8:"backdrop";s:3:"1.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"layout.css";s:28:"core/themes/stark/layout.css";}}s:6:"hidden";b:1;s:7:"project";s:8:"backdrop";s:9:"timestamp";s:10:"1759813356";s:6:"engine";s:11:"phptemplate";s:10:"screenshot";s:32:"core/themes/stark/screenshot.png";s:3:"php";s:5:"7.1.0";s:7:"scripts";a:0:{}s:5:"mtime";i:1759802558;}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]taxonomy_index`
--

CREATE TABLE `[[dbprefix]]taxonomy_index` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]node.nid this record tracks.',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The term ID.',
  `sticky` tinyint(4) DEFAULT '0' COMMENT 'Boolean indicating whether the node is sticky.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was created.',
  KEY `term_node` (`tid`,`sticky`,`created`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Maintains denormalized information about node/term…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]taxonomy_term_data`
--

CREATE TABLE `[[dbprefix]]taxonomy_term_data` (
  `tid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique term ID.',
  `vocabulary` varchar(255) NOT NULL DEFAULT '' COMMENT 'The vocabulary machine name to which this term is assigned.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The term name.',
  `description` longtext COMMENT 'A description of the term.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The [[dbprefix]]filter_format.format of the description.',
  `langcode` varchar(12) NOT NULL DEFAULT '' COMMENT 'The language code for this term; if ’und’, the term will be shown in all languages.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of this term in relation to other terms.',
  PRIMARY KEY (`tid`),
  KEY `taxonomy_tree` (`vocabulary`,`weight`,`name`),
  KEY `vocabulary_name` (`vocabulary`,`name`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores term information.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]taxonomy_term_hierarchy`
--

CREATE TABLE `[[dbprefix]]taxonomy_term_hierarchy` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Primary Key: The [[dbprefix]]taxonomy_term_data.tid of the term.',
  `parent` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Primary Key: The [[dbprefix]]taxonomy_term_data.tid of the term’s parent. 0 indicates no parent.',
  PRIMARY KEY (`tid`,`parent`),
  KEY `parent` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores the hierarchical relationship between terms.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tempstore`
--

CREATE TABLE `[[dbprefix]]tempstore` (
  `collection` varchar(128) NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT 'The key of the key/value pair.',
  `value` longblob NOT NULL COMMENT 'The value of the key/value pair.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'The time since Unix epoch in seconds when this item expires.',
  PRIMARY KEY (`collection`,`name`),
  KEY `all` (`name`,`collection`,`expire`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Generic temporary key/value storage table with an…';

--
-- Dumping data for table `[[dbprefix]]tempstore`
--
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]url_alias`
--

CREATE TABLE `[[dbprefix]]url_alias` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'A unique URL alias identifier.',
  `source` varchar(255) NOT NULL DEFAULT '' COMMENT 'The Backdrop path this alias is for; e.g. node/12.',
  `alias` varchar(255) NOT NULL DEFAULT '' COMMENT 'The alias for this path; e.g. title-of-the-story.',
  `langcode` varchar(12) NOT NULL DEFAULT '' COMMENT 'The language code this alias is for; if ’und’, the alias will be used for unknown languages. Each Backdrop path can have an alias for each supported language.',
  `auto` tinyint(4) DEFAULT '0' COMMENT 'Boolean indicator if this path was generated from a pattern or manually.',
  PRIMARY KEY (`pid`),
  KEY `alias_langcode_pid` (`alias`,`langcode`,`pid`),
  KEY `source_langcode_pid` (`source`,`langcode`,`pid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='A list of URL aliases for Backdrop paths; a user may visit…' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]url_alias`
--

INSERT INTO `[[dbprefix]]url_alias` VALUES
(1, 'node/1', 'posts/your-first-post', 'und', 1),
(2, 'node/2', 'about', 'und', 1),
(3, 'user/1', 'accounts/[[admin_username]]', 'und', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique user ID.',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT 'Unique user name.',
  `pass` varchar(128) NOT NULL DEFAULT '' COMMENT 'User’s password (hashed).',
  `mail` varchar(254) DEFAULT '' COMMENT 'User’s email address.',
  `signature` varchar(255) NOT NULL DEFAULT '' COMMENT 'User’s signature.',
  `signature_format` varchar(255) DEFAULT NULL COMMENT 'The [[dbprefix]]filter_format.format of the signature.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp for when user was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp for when user was changed.',
  `access` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp for previous time user accessed the site.',
  `login` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp for user’s last login.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether the user is active(1) or blocked(0).',
  `timezone` varchar(32) DEFAULT NULL COMMENT 'User’s time zone.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'User’s default language.',
  `picture` int(11) NOT NULL DEFAULT '0' COMMENT 'Foreign key: [[dbprefix]]file_managed.fid of user’s picture.',
  `init` varchar(254) DEFAULT '' COMMENT 'Email address used for initial account creation.',
  `data` longblob COMMENT 'A serialized array of name value pairs that are related to the user. Any form values posted during user edit are stored and are loaded into the $user object during user_load(). Use of this field is discouraged and it will likely disappear in a future…',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `name` (`name`),
  KEY `access` (`access`),
  KEY `created` (`created`),
  KEY `changed` (`changed`),
  KEY `mail` (`mail`),
  KEY `picture` (`picture`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Stores user data.';

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(0, '', '', '', '', NULL, 0, 0, 0, 0, 0, NULL, '', 0, '', NULL),
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '', NULL, [[timestamp]], [[timestamp]], [[timestamp]], [[timestamp]], 1, 'America/New_York', '', 0, '[[admin_email]]', 'b:0;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_roles`
--

CREATE TABLE `[[dbprefix]]users_roles` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Primary Key: [[dbprefix]]users.uid for user.',
  `role` varchar(64) NOT NULL DEFAULT '' COMMENT 'Primary Key: The name of the role.',
  PRIMARY KEY (`uid`,`role`),
  KEY `role` (`role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Maps users to roles.';

--
-- Dumping data for table `[[dbprefix]]users_roles`
--

INSERT INTO `[[dbprefix]]users_roles` VALUES
(1, 'administrator');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]variable`
--

CREATE TABLE `[[dbprefix]]variable` (
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT 'The name of the variable.',
  `value` longblob NOT NULL COMMENT 'The value of the variable.',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Named variable/value pairs created by Backdrop core or any…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]watchdog`
--

CREATE TABLE `[[dbprefix]]watchdog` (
  `wid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique watchdog event ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The [[dbprefix]]users.uid of the user who triggered the event.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'Type of log message, for example "user" or "page not found."',
  `message` longtext NOT NULL COMMENT 'Text of log message to be passed into the t() function.',
  `variables` longblob NOT NULL COMMENT 'Serialized array of variables that match the message string and that is passed into the t() function.',
  `severity` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'The severity level of the event; ranges from 0 (Emergency) to 7 (Debug)',
  `link` varchar(255) DEFAULT '' COMMENT 'Link to view the result of the event.',
  `location` text NOT NULL COMMENT 'URL of the origin of the event.',
  `referer` text COMMENT 'URL of referring page.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Hostname of the user who triggered the event.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'Unix timestamp of when event occurred.',
  PRIMARY KEY (`wid`),
  KEY `type` (`type`),
  KEY `uid` (`uid`),
  KEY `severity` (`severity`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='Table that contains logs of all system events.' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]watchdog`
--

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
